<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'da', version '4.2'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Tildel rollen "{$a->role_shortname}" til "{$a->user_username}" på kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['assignrolefailed'] = 'Mislykkedes at tildele rollen "{$a->role_shortname}" til brugeren "{$a->user_username}" på kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['autocreate'] = '<p>Kurser kan oprettes automatisk, hvis der er tilmeldinger til et kursus, der endnu ikke eksisterer i Moodle </p> <p>Hvis du bruger automatisk kursusoprettelse, anbefales det at du fjerner følgende beføjelser: "moodle/course:changeidnumber", "moodle/course:changeshortname", "moodle/course:changefullname" og "moodle/course:changesummary" fra de relevante roller, for at forhindre ændringer af de fire kursusfelter angivet ovenfor (id-nummer, kort navn, fulde navn og beskrivelse).</p>';
$string['autocreate_key'] = 'Autoopret';
$string['autocreation_settings'] = 'Indstillinger for automatisk kursusoprettelse';
$string['autoupdate_settings'] = 'Indstillinger for automatisk kursusopdtering:';
$string['autoupdate_settings_desc'] = '<p>Vælg de felter der skal opdateres når den planlagte opgave "Synkroniser LDAP-tilmeldingsopgaver" kører.</p><p>Opdatering sker når mindst et felt er valgt.</p>';
$string['bind_dn'] = 'Vil du bruge en bind-bruger til søgning efter brugere, kan du angive det her. Noget i retning af \'cn=ldapuser,ou=public,o=org';
$string['bind_dn_key'] = 'Bind-brugernavn';
$string['bind_pw'] = 'Bind-brugeradgangskode';
$string['bind_pw_key'] = 'Adgangskode';
$string['bind_settings'] = 'Bind-indstillinger';
$string['cannotcreatecourse'] = 'Kan ikke oprette kursus: Mangler obligatoriske data fra LDAP-posten!';
$string['cannotupdatecourse'] = 'Kan ikke opdatere kurset: Mangler obligatoriske data fra LDAP-posten! Kursets id-nummer: "{$a->idnumber}"';
$string['cannotupdatecourse_duplicateshortname'] = 'Kan ikke opdatere kurset: Duplikeret kort navn. Springer over kurset med id-nummer: "{$a->idnumber}"...';
$string['category'] = 'Kategori til auto-oprettede kurser';
$string['category_key'] = 'Kategori';
$string['contexts'] = 'LDAP-kontekster';
$string['couldnotfinduser'] = 'Fandt ikke brugeren "{$a}", springer over';
$string['course_fullname'] = 'Valgfrit: LDAP-attribut til det fulde navn';
$string['course_fullname_key'] = 'Fulde navn';
$string['course_fullname_updateonsync'] = 'Opdater fulde navn under script-synkronisering';
$string['course_fullname_updateonsync_key'] = 'Opdater fulde navn';
$string['course_idnumber'] = 'LDAP-attribut til kursus-id. Normalt \'cn\' eller \'uid\'.';
$string['course_idnumber_key'] = 'Id-nummer';
$string['course_search_sub'] = 'Søg gruppemedlemskaber fra underkontekster';
$string['course_search_sub_key'] = 'Søg underkontekster';
$string['course_settings'] = 'Kursets tilmeldingsindstillinger';
$string['course_shortname'] = 'Valgfrit: LDAP-attribut det korte navn skal fås fra';
$string['course_shortname_key'] = 'Kort navn';
$string['course_shortname_updateonsync'] = 'Opdater kort navn under script-synkronisering';
$string['course_shortname_updateonsync_key'] = 'Opdater kort navn';
$string['course_summary'] = 'Valgfrit: LDAP-attribut til beskrivelsen';
$string['course_summary_key'] = 'Beskrivelse';
$string['course_summary_updateonsync'] = 'Opdater kursusbeskrivelse under synkroniseringen';
$string['course_summary_updateonsync_key'] = 'Opdater beskrivelse';
$string['coursenotexistskip'] = 'Kurset "{$a}" eksisterer ikke og auto-oprettelse er deaktiveret, springer over';
$string['courseupdated'] = 'Kurset med id-nummer "{$a->idnumber}" er opdateret';
$string['courseupdateskipped'] = 'Kurset med id-nummer "{$a->idnumber}" behøver ikke at blive opdateret. Springer over...';
$string['createcourseextid'] = 'OPRET Bruger tilmeldt et ikke-eksisterende kursus "{$a->courseextid}"';
$string['createnotcourseextid'] = 'Bruger tilmeldt et ikke-eksisterende kursus "{$a->courseextid}"';
$string['creatingcourse'] = 'Opretter kurset "{$a}"...';
$string['duplicateshortname'] = 'Kursusoprettelse mislykkedes. Duplikeret kort navn. Springer over kurset med id-nummer: "{$a->idnumber}"...';
$string['editlock'] = 'Lås værdi';
$string['emptyenrolment'] = 'Tom tilmelding for rollen "{$a->role_shortname}" på kurset "{$a->course_shortname}"';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Tilmeld brugeren "{$a->user_username}" kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['enroluserenable'] = 'Aktiveret tilmelding for brugeren "{$a->user_username}" på kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() understøtter ikke den valgte type bruger: {$a}';
$string['extcourseidinvalid'] = 'Kursets eksterne id er ugyldig!';
$string['extremovedsuspend'] = 'Deaktiveret tilmelding for brugeren "{$a->user_username}" på kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Deaktiveret tilmelding og slettet roller for brugeren "{$a->user_username}" på kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['extremovedunenrol'] = 'Frameld "{$a->user_username}" kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['failed'] = 'Mislykkedes!';
$string['general_options'] = 'Generelle muligheder';
$string['group_memberofattribute'] = 'Navn på den attribut der specificerer hvilke grupper en given bruger eller gruppe tilhører (f.eks., memberOf, groupMembership, osv.)';
$string['group_memberofattribute_key'] = '"Medlem af"-attribut';
$string['host_url'] = 'Specificer LDAP-vært i URL-form som "ldap://ldap.eksempel.dk/" eller "ldaps://ldap.eksempel.dk/"';
$string['host_url_key'] = 'Værts-URL';
$string['idnumber_attribute'] = 'Såfremt gruppemedlemskabet indeholder unikke navne, angiv da samme attribut som for brugerens "ID Number"-tilknytning i LDAP\'s godkendelsesindstillinger.';
$string['idnumber_attribute_key'] = 'Id-nummer-attribut';
$string['ldap:manage'] = 'Administrer LDAP-tilmeldingsforekomster';
$string['ldap_encoding'] = 'Specificer kodningen brugt af LDAP-serveren. Sandsynligvis utf-8, MS AD v2 bruger standard platformskodning såsom cp1252, cp1250, osv.';
$string['ldap_encoding_key'] = 'LDAP-kodning';
$string['memberattribute'] = 'LDAP-medlemsattribut';
$string['memberattribute_isdn'] = 'Hvis gruppemedlemskabet indeholder unikke navne, skal du angive dem her. I så fald skal du konfigurere de resterende indstillinger i dette afsnit.';
$string['memberattribute_isdn_key'] = 'Medlemsattributten bruger dn';
$string['nested_groups'] = 'Vil du bruge indlejrede grupper (grupper af grupper) til tilmelding?';
$string['nested_groups_key'] = 'Indlejrede grupper';
$string['nested_groups_settings'] = 'Indstillinger for indlejrede grupper';
$string['nosuchrole'] = 'Ingen sådan rolle: "{$a}"';
$string['objectclass'] = 'objectClass brugt til søgning på kurser. Almindeligvis "group" eller "posixGroup"';
$string['objectclass_key'] = 'Objektklasse';
$string['ok'] = 'OK!';
$string['opt_deref'] = 'Indeholder gruppemedlemskabet unikke navne, angiv da hvordan aliasser skal håndteres ved en søgning. Vælg en af de følgende værdier: "Nej" (LDAP_DEREF_NEVER) eller "Ja" (LDAP_DEREF_ALWAYS)';
$string['opt_deref_key'] = 'Aliasser for "dereference"';
$string['phpldap_noextension'] = 'PHP LDAP-modulet lader ikke til at være til stede. Sørg for at det er installeret og aktiveret, hvis du vil bruge dette tilmeldings-plugin.';
$string['pluginname'] = 'LDAP-tilmeldinger';
$string['pluginname_desc'] = '<p>Du kan bruge en LDAP-server til at håndtere dine tilmeldinger. Det forudsættes at dit LDAP-træ indeholder grupper tilknyttet kurser, og at hver af disse grupper/kurser har medlemsindlæg at knytte til studerende.</p><p>Det forudsættes at kurser er defineret som grupper i LDAP, hvor hver gruppe har flere medlemsfelter (<em>member</em> eller <em>memberUid</em>) der indeholder en unik identifikation af brugeren.</p><p>For at bruge LDAP-tilmeldinger <strong>skal</strong> dine brugere have et felt med gyldigt id-nummer. LDAP-grupper skal have dette id-nummer i medlemsfelterne for at brugeren kan blive tilmeldt kurset. Dette vil almindeligvis virke fint hvis du allerede bruger LDAP-godkendelse.</p><p>Tilmeldinger vil blive opdateret når brugeren logger ind. Du kan også køre et script der kan holde tilmeldinger synkroniseret. Se i <em>enrol/ldap/cli/sync.php</em>.</p><p>Dette plugin kan også konfigureres til automatisk at oprette nye kurser når nye grupper oprettes i LDAP.</p>';
$string['pluginnotenabled'] = 'Plugin ikke aktiveret!';
$string['privacy:metadata'] = 'Tilmeldingsplugin\'et LDAP-tilmeldinger gemmer ingen personlige data.';
$string['role_mapping'] = '<p>For hver rolle du vil tilknytte fra LDAP, skal du angive listen med kontekster hvori kursusrollens grupper er placeret. Adskil forskellige kontekster med semikolon (;).</p><p>Du skal også angive den attribut LDAP-serveren anvender til gruppering af brugere - som regel "member" eller "memberUid"</p>';
$string['role_mapping_attribute'] = 'LDAP-medlems-attribut for {$a}';
$string['role_mapping_context'] = 'LDAP-kontekster for {$a}';
$string['role_mapping_key'] = 'Tilknyt roller fra LDAP';
$string['roles'] = 'Rolletilknytning';
$string['server_settings'] = 'LDAP-serverindstillinger';
$string['synccourserole'] = '== Synkroniserer kurset "{$a->idnumber}" for rollen "{$a->role_shortname}"';
$string['syncenrolmentstask'] = 'Synkroniser LDAP-tilmeldingsopgaver';
$string['template'] = 'Valgfrit: Auto-oprettede kurser kan kopiere deres indstillinger fra en kursusskabelon';
$string['template_key'] = 'Skabelon';
$string['unassignrole'] = 'Fjerner rollen "{$a->role_shortname}" fra brugeren "{$a->user_username}" på kurset "{$a->course_shortname}" (id {$a->course_id})';
$string['unassignrolefailed'] = 'Mislykkedes at fjerne rollen "{$a->role_shortname}" fra brugeren "{$a->user_username}" på kurset "{$a->course_shortname}" (id "{$a->course_id})';
$string['unassignroleid'] = 'Fjerner rolle-id "{$a->role_id}" fra bruger-id "{$a->user_id}"';
$string['updatelocal'] = 'Opdater lokale data';
$string['user_attribute'] = 'Såfremt gruppemedlemskabet indeholder unikke navne, angiv da den attribut der bruges til at navngive/søge på brugere. Bruger du LDAP-godkendelse, skal denne værdi matche attributten opført i "ID Number"-tilknytningen i LDAP-godkendelses-plugin\'et';
$string['user_attribute_key'] = 'Id-nummer-attribut';
$string['user_contexts'] = 'Såfremt gruppemedlemskabet indeholder unikke navne, angiv da en liste med kontekster hvori brugere er lokaliseret. Adskil forskellige kontekster med semikolon (;), f.eks.:: "ou=users,o=org; ou=others,o=org"';
$string['user_contexts_key'] = 'Kontekster';
$string['user_search_sub'] = 'Indeholder gruppemedslemskabet unikke navne, angiv da om søgning på brugere også skal søge i underkontekster.';
$string['user_search_sub_key'] = 'Søg underkontekster';
$string['user_settings'] = 'Indstillinger for brugeropslag';
$string['user_type'] = 'Indeholder gruppemedlemskabet unikke navne skal du angive hvordan brugere gemmes i LDAP';
$string['user_type_key'] = 'Brugertype';
$string['version'] = 'Version på den LDAP-protokol din server bruger';
$string['version_key'] = 'Version';
