<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sr_cr', version '4.2'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Приступ је одбијен';
$string['accounts'] = 'Налози';
$string['addcategory'] = 'Додај категорију';
$string['additionalhtml'] = 'Додатни HTML';
$string['additionalhtml_desc'] = 'Ово подешавање вам дозвољава да наведете HTML кôд који желите да буде додат на сваку страницу. Можете поставити HTML кôд који ће бити додат унутар ознаке HEAD за сваку страницу, одмах након отварања или непосредно пре затварања ознаке BODY.<br />На овај начин можете имати прилагођено заглавље или подножје на свакој страници или можете додати подршку за сервисе, попут Google Analytics, на једноставан начин, независно од теме коју сте изабрали.';
$string['additionalhtml_heading'] = 'Додатни HTML који ће бити придружен свакој страници.';
$string['additionalhtmlfooter'] = 'Пре него што се затвори BODY ознака';
$string['additionalhtmlfooter_desc'] = 'Садржај који овде упишете биће додат на сваку страницу непосредно пре него што се затвори body ознака (</body>).';
$string['additionalhtmlhead'] = 'Унутар HEAD ознаке';
$string['additionalhtmlhead_desc'] = 'Садржај који овде упишете биће додат на крају HEAD ознаке на свакој страници.';
$string['additionalhtmltopofbody'] = 'Када се отвори BODY ознака';
$string['additionalhtmltopofbody_desc'] = 'Садржај који овде упишете биће додат на сваку страницу одмах након што се отвори body ознака (<body>).';
$string['admincategory'] = 'Категорија: {$a}';
$string['adminseesall'] = 'Администратори виде све';
$string['adminseesallevents'] = 'Администратори виде све догађаје';
$string['adminseesownevents'] = 'Администратори су као остали корисници';
$string['advancedfeatures'] = 'Напредна својства';
$string['agedigitalconsentverification'] = 'Потврда дигиталног узраста за сагласност';
$string['agedigitalconsentverification_desc'] = 'Омогућава потврду дигиталног узраста за сагласност пре приказивања странице за пријављивање за самостално регистроване кориснике. Ово штити ваш сајт од пријава малолетника без сагласности родитеља/старатеља. <a target="_blank" href="{$a}">Контакт за подршку</a> се приказује малолетницима за даљу помоћ.';
$string['ageofdigitalconsentmap'] = 'Дигитална узраст за сагласност';
$string['ageofdigitalconsentmap_desc'] = 'Подразумевани дигитални узраст за сагласност, као и узраст у било којој земљи који се разликује од подразумеваног, могу се овде навести. Унесите сваки од узраста у нови ред у формату: кôд државе, узраст (раздвојене зарезом). Подразумевани узраст се означава знаком * уместо кôда државе. Кôдови држава су наведене у ISO 3166-2.';
$string['allcountrycodes'] = 'Све ознаке земаља';
$string['allowattachments'] = 'Дозволи прилоге';
$string['allowbeforeblock'] = 'Прво ће бити обрађен списак дозвољених адреса';
$string['allowbeforeblockdesc'] = 'Стандардно, прво се обрађује списак блокираних адреса, али ако је ова опција омогућена списак дозвољених IP адреса биће обрађен пре списка блокираних адреса.';
$string['allowcategorythemes'] = 'Дозволи избор графичке теме на нивоу категорија';
$string['allowcohortthemes'] = 'Дозволи избор графичке теме на нивоу кохорте';
$string['allowcoursethemes'] = 'Дозволи избор графичке теме на нивоу курсева';
$string['allowedemaildomains'] = 'Дозвољени домени е-поште';
$string['allowediplist'] = 'Списак дозвољених IP адреса';
$string['allowemailaddresses'] = 'Дозвољени домени е-поште';
$string['allowemojipicker'] = 'Бирач емоџија';
$string['allowframembedding'] = 'Дозволи уметање у оквир';
$string['allowframembedding_help'] = 'Ако је опција омогућена, овај сајт може бити уметнут у оквир на удаљеном систему, као што се то препоручује када се користи додатак за упис \'Објави као LTI алат\'. У супротном, препоручује се да уграђивање оквира искључите, из безбедносних разлога. Имајте у виду, такође, да се  за мобилну апликацију ово подешавање игнорише и да је уграђивање оквира увек дозвољено.';
$string['allowguestmymoodle'] = 'Дозволите гостима приступ \'Контролном панелу\'';
$string['allowindexing'] = 'Дозволи индексирање од стране веб претраживача';
$string['allowindexing_desc'] = 'Ово одређује да ли ће веб претраживачима бити омогућено индексирање страница вашег сајта. Опција "Свуда" ће омогућити веб претраживачима да претражују свуда, укључујући странице за пријаву на систем, што значи да се индексирају и сајтови код којих је укључена опција "Приморај кориснике да се пријаве на систем". Како бисте избегли ризик од нежељене поште који постоји када може да се претражује страница за пријаву користите опцију "Свуда осим страница за пријаву". Опција "Нигде" ће спречити веб претраживаче да индексирају било коју страницу вашег сајта. Имајте у виду да је ово само ознака у заглављу сајта. Од веб претраживача зависи да ли ће уважити ознаку.';
$string['allowindexingeverywhere'] = 'Свуда';
$string['allowindexingexceptlogin'] = 'Свуда осима на страницама за пријаву на систем';
$string['allowindexingnowhere'] = 'Нигде';
$string['allowobjectembed'] = 'Дозволи EMBED и OBJECT ознаке';
$string['allowthemechangeonurl'] = 'Дозволи промену графичке теме у URL адреси';
$string['allowuserblockhiding'] = 'Дозволи корисницима да сакрију блокове';
$string['allowusermailcharset'] = 'Дозволи корисницима да изаберу скупове знакова';
$string['allowuserswitchrolestheycantassign'] = 'Дозволи корисницима који немају способност додељивања улога да мењају своје улоге';
$string['allowuserthemes'] = 'Дозволи корисницима избор графичке теме';
$string['alternativefullnameformat'] = 'Алтернативни формат пуног имена';
$string['alternativefullnameformat_desc'] = 'Ово дефинише како се имена приказују корисницима који имају способност viewfullnames (стандардно, корисници са улогом менаџера, предавача или предавача без уређивачких права. Резервисана места која могу да се користе су иста као и за подешавање "Формат пуног имена".';
$string['always'] = 'Увек';
$string['appearance'] = 'Изглед';
$string['aspellpath'] = 'Путања до алата aspell';
$string['asyncbackupdisabled'] = 'Ваш сајт је тренутно конфигурисан да користи синхроне резервне копије.
Асинхроне резервне копије пружају боље корисничко искуство.
Асинхроне резервне копије биће омогућене за све сајтове од верзије Moodle LMS 4.5 LTS.
Подршка за синхроне резервне копије биће уклоњена од Moodle LMS верзије 4.5 LTS.';
$string['authentication'] = 'Провера идентитета';
$string['authpreventaccountcreation'] = 'Спречи креирање налога приликом провере идентитета';
$string['authpreventaccountcreation_help'] = 'Приликом провере идентитета корисника, на сајту се аутоматски креира налог, уколико он већ не постоји. Ако се пак, за проверу идентитета, користи нека спољашња база података, попут LDAP-а, а при томе желите да дозволите приступ сајту  само корисницима са постојећим налогом, онда треба укључити ову опцију. У том случају, нови налози се креирају ручно или путем опције за постављање корисника. Имајте у виду да се ово подешавање не примењује на MNet проверу идентитета.';
$string['authsettings'] = 'Управљање провером идентитета';
$string['autolang'] = 'Аутоматско детектовање језика';
$string['autolangusercreation'] = 'Приликом креирања налога, подесите језик корисниковог веб читача као преферирани језик';
$string['autologinguests'] = 'Аутоматско пријављивање гостију';
$string['availableto'] = 'Доступно';
$string['availabletoanyone'] = 'Доступно свима који посете сајт';
$string['availabletoauthenticated'] = 'Доступно само аутентификованим корисницима';
$string['backgroundcolour'] = 'Транспарентна боја';
$string['backup_shortname'] = 'Користи скраћени назив курса у називу датотеке резервне копије';
$string['backup_shortnamehelp'] = 'Користите скраћени назив курса као део назива датотеке резервне копије.';
$string['backups'] = 'Резервне копије';
$string['badwordsconfig'] = 'Унесите своју листу ружних речи одвојених зарезима.';
$string['badwordsdefault'] = 'Уколико је ваш списак непристојних/неприкладних речи празан, биће коришћен подразумевани списак језичког пакета.';
$string['badwordslist'] = 'Листа ружних речи';
$string['blockediplist'] = 'Списак блокираних IP адреса';
$string['blockinstances'] = 'Инстанце';
$string['blockmultiple'] = 'Вишеструки';
$string['blockprotect'] = 'Заштити инстанце';
$string['blockprotect_help'] = 'Ако закључате одређени тип блока, онда нико неће моћи да додаје или брише инстанце тог блокова. (Блок можете, наравно,  поново да откључавате, уколико желите да уредите његове инстанце)

Сврха ове опције је да се заштите блокови као што су \'Навигација\' и \'Подешавања \', које је тешко повратити ако се грешком обришу.';
$string['blockprotectblock'] = 'Заштитите инстанце блока {$a}';
$string['blockprotected'] = 'Инстанце блока {$a} су заштићене.';
$string['blocksettings'] = 'Управљање блоковима';
$string['blockunprotect'] = 'Уклони заштиту';
$string['blockunprotectblock'] = 'Уклоните заштиту са инстанци блока {$a}';
$string['blockunprotected'] = 'Инстанце блока {$a} нису заштићене.';
$string['bloglevel'] = 'Видљивост блога';
$string['bookmarkadded'] = 'Обележивач је додат.';
$string['bookmarkalreadyexists'] = 'Већ сте обележили ову страницу.';
$string['bookmarkdeleted'] = 'Обележивач је обрисан.';
$string['bookmarkthispage'] = 'Обележи ову страницу';
$string['cacheapplication'] = 'Кеш апликације';
$string['cacheapplicationhelp'] = 'Кеширане ставке се деле између свих корисника и истичу након одређеног периода (ttl).';
$string['cachejs'] = 'Кеширај Javascript';
$string['cachejs_help'] = 'Кеширање Javascripta и компресија у великој мери побољшава учитавање странице. Веома се препоручује за продукционе сајтове. Програмери ће вероватно желети да онемогуће ову функцију.';
$string['cacherequest'] = 'Кеш захтева';
$string['cacherequesthelp'] = 'Посебан кориснички кеш који истиче након што је захтев испуњен. Намена му је да замени области где смо користили статичко чување података.';
$string['cachesession'] = 'Кеш сесије';
$string['cachesessionhelp'] = 'Посебан кориснички кеш који истиче након што корисник заврши сесију. Намена му је да смањи увећање/оптерећење сесије.';
$string['cachesettings'] = 'Подешавања кеша';
$string['cachetemplates'] = 'Шаблони кеша';
$string['cachetemplates_help'] = 'Кеширање шаблона ће побољшати перформансе учитавања странице и препоручљиво је за продукционе сајтове. Програмери ће вероватно желети да искључе ову функцију.';
$string['caching'] = 'Кеширање';
$string['calendar_weekend'] = 'Дани викенда';
$string['calendarexportsalt'] = 'Насумични стринг (salt) за извоз календара';
$string['calendarsettings'] = 'Календар';
$string['calendartype'] = 'Тип календара';
$string['calendartype_desc'] = 'Изабарите подразумевани тип календара за читав сајт. Ово подешавање може бити промењено у подешавањима курса или од стране корисника на њиховим страницама профила.';
$string['campaign'] = 'Кампања';
$string['cannotdeletemodfilter'] = 'Не можете да деинсталирате филтер \'{$a->filter}\' зато што је он део модула \'{$a->module}\'';
$string['cannotuninstall'] = '{$a} није могуће деинсталирати';
$string['categoryemail'] = 'Е-пошта';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot је погрешно дефинисан у config.php датотеци. Укључује знак \'/\' на крају који мора бити уклоњен.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot је погрешно дефинисан у config.php датотеци. Требало би да се подудара са URL адресом коју користите за приступ овој страници.';
$string['change'] = 'промени';
$string['checkboxno'] = 'Не';
$string['checkboxyes'] = 'Да';
$string['checkupgradepending'] = 'Надоградња';
$string['choosefiletoedit'] = 'Одабери датотеку за уређивање';
$string['cleanup'] = 'Чишћење';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Грациозни излаз, молим сачекајте...';
$string['cliexitnow'] = 'Излазим ОДМАХ';
$string['cliincorrectvalueerror'] = 'Грешка, неисправна вредност "{$a->value}" за "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Неисправна вреднос, молим покушајте поново';
$string['clistatusdisabled'] = 'Статус онемогућен';
$string['clistatusenabled'] = 'Статус омогућен';
$string['clistatusenabledlater'] = 'статус: CLI режим одржавања биће омогућен {$a}';
$string['clitypevalue'] = 'откуцај вредност';
$string['clitypevaluedefault'] = 'откуцај вредност, притисни Ентер да бисте употребили подразумевану вредност ({$a})';
$string['cliunknowoption'] = 'Непрепознате опције:
{$a}
Молимо искористите опцију за помоћ.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Како бисте очистили преостале кеш меморије након пребацивања корисничког саобраћаја на нови кôд употребите команде:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

Требало би да ова чишћења обављате изоловано, једно по једно, са размаком између команди, како би се смањили скокови оптерећења на веб серверу.';
$string['cliupgradedefault'] = 'Ново подешавање: {$a}';
$string['cliupgradedefaultheading'] = 'Подешавање нових подразумеваних вредности';
$string['cliupgradedefaultverbose'] = 'Ново подешавање: {$a->name}, Подразумевана вредност: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Надоградња путем команде линије са верзије {$a->oldversion} на верзију {$a->newversion} успешно је завршена.';
$string['cliupgrademaintenancenotrequired'] = 'Услед ове надоградња сајт НЕЋЕ  бити пребачен у режим одржавања, па ће корисници моћи да му приступе.';
$string['cliupgrademaintenancerequired'] = 'Услед ове надоградња сајт ЋЕ бити пребачен у режим одржавања, па корисници неће моћи да му приступе.';
$string['cliupgradenoneed'] = 'Није потребна надоградња за инсталирану верзију {$}. У сваком случају хвала што сте дошли !';
$string['cliupgradepending'] = 'Надоградња је на чекању';
$string['cliupgradesetlock'] = 'Надоградња је закључана, тако да је сајт могуће надоградити само путем командне линије (CLI).';
$string['cliupgradeunsetlock'] = 'Постојеће закључавање надоградње путем командне линије (CLI) је уклоњено.';
$string['cliyesnoprompt'] = 'унеси y (значи да) или n (значи не)';
$string['close'] = 'Затвори';
$string['cohort_customfield'] = 'Прилагођена поља кохорте';
$string['commentsperpage'] = 'Број коментара приказаних по страници';
$string['commonactivitysettings'] = 'Општа подешавања';
$string['commonfiltersettings'] = 'Заједничка подешавања филтера';
$string['commonsettings'] = 'Општа подешавања';
$string['componentinstalled'] = 'Компонента је инсталирана';
$string['computedfromlogs'] = 'Израчунато из записа о активностима од {$a}.';
$string['condifmodeditdefaults'] = 'Подразумеване вредности се користе у формама за подешавање приликом креирања нове активности или ресурса.';
$string['confeditorhidebuttons'] = 'Одаберите дугмад која треба да буду скривена у HTML едитору.';
$string['configallcountrycodes'] = 'Ово је списак земаља које могу бити изабране на разним местима, рецимо у корисничком профилу. Ако је списак празан (што је подразумевана вредност), користиће се списак из countries.php који је део стандардног енглеског језичког пакета. Тај списак је преузет из ISO 3166-1. У супротном потребно је да наведете и двословне ознаке земаља одвојене зарезом, нпр. \'RS,GB,ES\'. Ако додате нове, нестандардне ознаке, мораћете да их додате и у countries.php датотеку, како енглеског, тако и вашег језичког пакета.';
$string['configallowassign'] = 'За сваку улогу у левој колони, изаберите улоге које оне могу да доделе другим корисницима.';
$string['configallowattachments'] = 'Ако је ова опција омогућена. е-поруке послате са сајта могу да садрже прилоге, као што су беџеви.';
$string['configallowcategorythemes'] = 'Уколико омогућите ову опцију графичке теме се могу подешевати на нивоу категорија. То ће утицати на све подређене категорије и курсеве које већ немају подешену сопствену графичку тему. УПОЗОРЕЊЕ: Омогућавање избора графичке теме на нивоу категорија може утицати на перформансе система.';
$string['configallowcohortthemes'] = 'Уколико омогућите ову опцију, графичке теме се могу подешавати на нивоу кохорте. Ово ће утицати на све кориснике који су чланови само једне кохорте или више кохорти али са истом графичком темом.';
$string['configallowcoursethemes'] = 'Ако је омогућена ова опција, биће дозвољено да се графичке теме подесе на нивоу курса. Графичка тема подешена на нивоу курса има првенство у односу на сва остале места где се теме могу подесити (нпр, на нивоу сајта, корисника , категорије, кохорте или путем URL адресе).';
$string['configallowedemaildomains'] = 'Списак домена е-адреса којима је допуштено да буду приказане у пољу "Од" одлазне е-поруке. Стандардно подешавања "Празно" ће користити е-адресу "не-одговарај" (noreply@mojsajt.rs) за сву одлазну е-пошту. Дозвољена је употреба џокер ознака, нпр. *.@mojsajt.rs ће дозволити слање е-поште послате са било које адресе поддомена mojsajt.rs, али не и са самог домена mojsajt.rs. Потребно је сам домен унети засебно.';
$string['configallowemailaddresses'] = 'Ако желите да ограничите нове е-адресе на одређене домене, наведите их овде раздвојене размацима. Сви остали домени биће одбијени. Како бисте дозволили коришћење поддомена додајте домен са тачком испред. Како бисте дозволили основни домен заједно са његовим поддоменима, додајте домен два пута - једном са тачком испред и једном без ње. На пример: .mojaskola.edu.rs mojaskola.edu.rs.';
$string['configallowemojipicker'] = 'Бирач емоџија омогућава корисницима да изаберу емоџије, попут смајлија, које могу да додају у поруке и друга текстуална поља путем дугмета за бирање емоџија у Atto траци са алаткама.';
$string['configallowemojipickerincompatible'] = 'Ваша тренутна конфигурација базе података нема одговарајућу подршку за емоџије. Да бисте омогућили бирач емоџија потребно је да <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> надоградите вашу базу за пуну "Unicode" подршку</a>';
$string['configallowguestmymoodle'] = 'Ако је ова опција омогућена гости ће моћи да приступе \'Контролном панелу\', у супротном биће преусмерени на насловну страницу сајта.';
$string['configallowobjectembed'] = 'Као подразумевана безбедносна мера, крајњим корисницима није дозвољено уметање мултимедијалних садржаја (попут Flash анимација) унутар текста експлицитно коришћењем ознака EMBED и OBJECT унутар HTML кода (иако је то и даље могуће извести на сигурнији начин путем mediaplugins филтера). Желите ли ипак дозволити употребу ових ознака, укључите ову опцију.';
$string['configallowoverride'] = 'Можете дозволити људима које имају улоге наведене у првој колони са леве стране да мењају овлашћења улога
наведених у преосталим колонама.';
$string['configallowoverride2'] = 'За сваку улогу у левој колони, изаберите улоге које оне могу да промене.<br />Корисници такође морају да имају способност moodle/role:override или moodle/role:safeoverride.';
$string['configallowswitch'] = 'За сваку улогу у левој колони, изаберите улоге на које оне могу да се пребаце.<br />Корисници такође морају да имају способност moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Ако је овo подешавање омогућено, графичка тема може да се промени додавањем <br />?theme=themename било којој Moodle URL адреси (нпр: mymoodlesite.com/?theme=afterburner ) или <br />&theme=themename било којој интерној Moodle URL адреси (нпр: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Да ли желите да корисницима омогућите да сами  скривају/приказују бочне блокове на овом сајту? Ово својство користи Java скрипт и "колачиће" како би се запамтио тренутни статус блокова, и утиче једино на изглед сајта појединачног корисника.';
$string['configallowusermailcharset'] = 'Ако је ова опција омогућена, корисници ће моћи да изаберу сет карактера за електронску пошту у својим подешавањима за слање порука.';
$string['configallowuserswitchrolestheycantassign'] = 'Као подразумевано подешавање, захтева се да корисник има овлашћење moodle/role:assign да би могао да мења улоге. Омогућавањем овог подешавања овде, уклања се овај захтев и за последицу има да се појављује падајући списак "Промени улогу у", који је одређен само подешавањима у табели "Дозволи додељивање улога".
Препоручује се да подешавања у табели "Дозволи додељивање улога" не дозвољавају корисницима да промене улогу у ону са већим овлашћењима од постојеће.';
$string['configallowuserthemes'] = 'Уколико омогућите ову опцију, корисницима ће бити дозвољено да сами подесе графичку тему по својој жељи. Теме које изаберу корисници имају предност у односу на графичку тему подешену на нивоу сајта (али не и у односу на графичку тему подешену на нивоу курса).';
$string['configallowview'] = 'За сваку улогу у левој колони, изаберите улоге које оне могу да виде, претражују и филтрирају.';
$string['configallusersaresitestudents'] = 'За активности на насловној страници сајта, да ли се СВИ корисници сматрају полазницима? Уколико је одговор "Да", онда ће сваком кориснику са отвореним налогом бити дозвољено да као полазник учествује у тим активностима. Уколико је одговор "Не", онда ће само они корисници који су уписани на најмање један курс моћи да учествују у тим активностима. Само администратори и посебно одређени предавачи могу да буду предавачи за активности  на насловној страници.';
$string['configauthenticationplugins'] = 'Молимо одаберите додатке за проверу идентитета које желите да користите и поређајте их у редоследу смењивања у случају неуспеха. Саморегистрацијом ће управљати додатак одабран у колони \'Регистрација\' (обично \'е-пошта\')';
$string['configautolang'] = 'Уколико подразумевани језик на нивоу сајт није омогућен, детектујте подразумевани језик веб читача.';
$string['configautolangusercreation'] = 'Ако је омогућено, када се кориснички налог креира аутоматски приликом прве пријаве на систем (нпр. коришћењем LDAP или OAuth 2 метода за проверу идентитета), језик корисниковог веб читача биће постављен као преферирани језик.
У супротном, као преферирани језик корисника биће подешен подразумеваник језик на нивоу сајта.';
$string['configautologinguests'] = 'Да ли би посетиоци сајта требало да буду аутоматски пријављени на систем као гости када улазе на неки од курсева који дозвољавају приступ гостима?';
$string['configbloglevel'] = 'Ово подешавање вам дозвољава да ограничите ниво до ког ће бити видљиви блогови корисника на овом сајту. Имајте у виду да ово одређује најшири контекст ЧИТАОЦА, а не аутора или тип блог чланка. Блогови могу бити и потпуно онемогућени ако уопште не желите да их користите.';
$string['configcalendarcustomexport'] = 'Омогући прилагођени временски оквир извоза календара';
$string['configcalendarexportsalt'] = 'Овај насумични текст се користи за унапређење безбедности токена за проверу идентитета који се користе за извоз календара. Имајте у виду  да су сви текући токени поништени уколико промените овај насумични текст ("hash salt")';
$string['configcookiehttponly'] = 'Омогућава нову PHP 5.2.0 функцију - веб читачима се задаје да шаљу колачиће само са правим http захтевима; колачићи не би требало да буду доступни скрипт језицима. Ово не подржавају сви веб читачи и можда неће бити у потпуности компатибилно са тренутним кôдом. Ово, такође, помаже да се спрече неки типови XSS напада.';
$string['configcookiesecure'] = 'Ако сервер прихвата само https конекције, препоручљиво је омогућити слање безбедних колачића. Ако је подешавање омогућено, молимо проверите да веб сервер не прихвата http:// или подесите стално преусмеравање на https:// адресу, а било би идеално да подесите HSTS заглавља. Када <em>wwwroot</em> адреса не почиње са https:// ово подешавање се игнорише.';
$string['configcountry'] = 'Уколико овде подесите име државе, оно ће бити изабрано као подразумевано у новоотвореним корисничким налозима. Оставите ово поље празно како би сте приморали кориснике да сами изаберу државу из које су.';
$string['configcoursegraceperiodafter'] = 'Класификујте прошле курсеве као да су у току још оволико дана након датума њиховог завршетка.';
$string['configcoursegraceperiodbefore'] = 'Класификујте будуће курсеве као да су у току оволико дана пре датума њиховог почетка.';
$string['configcourseoverviewfilesext'] = 'Списак дозвољених, зарезима раздвојених, екстензија датотека слика курса.';
$string['configcourseoverviewfileslimit'] = 'Максималан број датотека који се може приказати поред резимеа курса на страници са списком курсева. Прва додата слика се користи као слика курса у прегледу курсева на корисниковом Контролном панелу; све додатне датотеке се приказују само на страници са списком курсева';
$string['configcourserequestnotify'] = 'Упишите корисничко име корисника који ће бити обавештени када се појави захтев за покретање новог курса.';
$string['configcourserequestnotify2'] = 'Корисници који ће бити обавештени када се појави захтев за покретање новог курса. Овде су наведени само корисници који могу одобрити захтев за покретање курса.';
$string['configcoursesperpage'] = 'Унесите број курсева који ће на списку курсева бити приказан по једној страници.';
$string['configcourseswithsummarieslimit'] = 'Максималан број курсева за приказивање на списку курсева, укључујући њихов резимеа, пре повратка на једноставнији списак курсева (без резимеа).';
$string['configcronclionly'] = 'Покретање крона из веб читача може да открије поверљиве информације анонимним корисницима. Због тога се препоручује да се крон покреће само из командне линије, или, да се за удаљени приступ крону постави лозинка.';
$string['configcronremotepassword'] = 'Ово значи да cron.php скрипта не може да се покрене из веб читача уколико се не обезбеди лозинка, користећи следећи облик URL адресе:<pre>    https://site.example.com/admin/cron.php?password=opensesame
</pre>Уколико се ово остави празно, лозинка није потребна.';
$string['configcurlcache'] = 'Време трајања cURL кеша, у секундама';
$string['configcustommenuitems'] = 'Овде се може подесити прилагођени мени. Унесите сваку ставку менија у нови ред у следећем формату: текст менија, URL адресе линка (опционо, не за ставку која се налази у корену менија и која има подставке), кратак опис ставке (опционо) и ознака језика, односно списак ознака језика, одвојених зарезом, (опционо, за приказ тог реда искључиво корисницима наведеног језика); сви елементи ставке су међусобно одвојени вертикалном цртом |. Редови који почињу цртицом појавиће се као ставке унутар подменија ставке која је вишег нивоа. Ставке у менију могу се раздвојити додавањем реда са једним или више знакова #. На пример:
<pre>
Курсеви
-Сви курсеви|/course/
-Претрага курсева|/course/search.php
-###
-FAQ|https://example.org/faq
-Често постављана питања|https://example.org/pmf||sr_cr
Moodle мобилна апликација|https://example.org/app|Преузмите нашу апликацију
</pre>';
$string['configcustomusermenuitems'] = 'Можете конфигурисати садржај корисничког менија (са изузетком линка за одјаву, који се аутоматски додаје). Сваки ред у менију одвојен је знаком | и састоји се од 1) стринга у формату "langstringname, componentname" или у облику обичног текста, и 2) URL адресе. Тамо где је потребно може се користити разделник додавањем реда са једним или више знакова #.';
$string['configdbsessions'] = 'Ако је омогућено, ово подешавање ће користити базу података за похрањивање информације о текућим сесијама. Имајте у виду да:ће промена овог подешавања прекинути сесије свих тренутно активних корисника (укључујући и вас). Уколико користите MySQL проверите да ли је вредност за \'max_allowed_packet\' у my.cnf (или my.ini) датотеци  барем 4M. Други драјвери сесија могу се директно конфигурисати у config.php датотеци; за више информација погледајте датотеку config-dist.php. Ова опција нестаје ако наведете драјвер сесије у датотеци  config.php.';
$string['configdebug'] = 'Уколико укључите ову опцију онда ће бити повећан број извешатаја о грешкама PHP-a (error_reporting). Ова опција је корисна једино онима који развијају Moodle.';
$string['configdebugdisplay'] = 'Ако је ова опција укључена, обавештавање о грешкама ће бити прослеђенo на HTML страницу. Ово је практично, али генерално није компатибилно са XHTML, JS, колачићима и HTTP заглављем. Ако је искључено, излазне информације биће прослеђене у записе вашег сервера, омогућавајући тако боље уклањање грешака. PHP подешавање error_log контролише у који запис иду ове информације.';
$string['configdebugpageinfo'] = 'Укључите уколико желите да се информације о страници приказују у њеном подножју.';
$string['configdebugvalidators'] = 'Укључите ако у подножју странице желите имати линкове на спољне сервере за проверу исправности. Можда ће бити потребно да креирате новог корисника са корисничким именом <em>w3cvalidator</em>, и омогућити му гостујући приступ. Ове измене могу дозволити неовлашћени приступ серверу, не укључујте на званично активним веб локацијама!';
$string['configdefaulthomepage'] = 'На коју страницу треба да буду преусмерени корисници након што се пријаве на сајт? Подешавање такође одређује одређује први линк у навигацији за кориснике графичких тема базираних на теми Classic.';
$string['configdefaultrequestcategory'] = 'Курсеви чије покретање захтевају корисници, који имају могућност да захтевају нове курсеве у контексту система, биће смештени у ову категорију, осим ако корисници немају могућност да изабере неку другу категроију.';
$string['configdefaultrequestedcategory'] = 'Подразумевана категорија за смештање захтеваних курсева, уколико су исти одобрени.';
$string['configdefaultuserroleid'] = 'Свим корисницима, пријављеним  на систем, биће дате могућности улоге коју овде наведете, на нивоу сајта, као ДОДАТАК на евентуалне друге улоге које можда већ имају. Подразумевана је улога ауторизованог корисника. Имајте у виду да ово неће бити у супротности са другим улогама које корисници имају, осим ако не забраните могућности.
Ово само осигурава да сви корисници имају способности које није могуће доделити на нивоу курса (нпр. писање блог чланака, уређивање сопственог календара итд.)';
$string['configdeleteincompleteusers'] = 'По истеку овог периода, сви налози код којих нису попуњена поља за име, презиме или е-адресу се бришу.';
$string['configdeleteunconfirmed'] = 'За одређене методе провере идентитета, као што је самостална регистрација путем е-поште, корисници морају потврдити свој налог унутар одређеног временско периода. Након овог периода сви стари непотврђени налози биће обрисани.';
$string['configdenyemailaddresses'] = 'Да бисте онемогућили електронске адресе са одређених домена наведите их овде на исти начин. Сви други домени биће прихваћени. На пример <strong>hotmail.com yahoo.co.uk neželjeni.domen.com</strong>';
$string['configdisableuserimages'] = 'Искључите могућност да корисници мењају слике у корисничким профилима';
$string['configdisplayloginfailures'] = 'Ово ће корисницима приказати информације о претходним неуспешним покушајима пријаве на систем.';
$string['configdndallowtextandlinks'] = 'Омогућите или онемогућите постављање текста и линкова, заједно са датотекама, помоћу опције \'превуци и спусти\'. Имајте на уму да је превлачење текста у Firefox или између различитих веб читача непоуздано и да као последицу може имати да подаци или текст не буду постављени.';
$string['configdoclang'] = 'Овај језик ће се користити у линковима за странице документације.';
$string['configdocroot'] = 'Дефинише путању до Moodle документације за пружање контекстуалне подршке путем линкова за \'Документација за ову страницу\' у подножју сваке странице. Ако се ово поље остави празно линкови се неће приказивати.';
$string['configdoctonewwindow'] = 'Ако је ова опација омогућена, онда ће линкови до Moodle документације ће бити приказани у новом прозору.';
$string['configduration_high'] = 'Ова вредност је превисока. Максимална вредност је {$a}.';
$string['configduration_low'] = '{$a}';
$string['configeditordictionary'] = 'Ова вредност се користи ако aspell нема речник за језик корисника.';
$string['configeditorfontlist'] = 'Изаберите фонтове који ће се појавити у листи расположивих фонтова при коришћењу едитора.';
$string['configemailchangeconfirmation'] = 'Захтевај потврду путем е-поште када корисници промене своју електронску адресу у свом профилу.';
$string['configemaildkimselector'] = 'DKIM селектор је произвољан ваш(и) DNS запис(и) мора/ју одговарати овоме.';
$string['configemailfromvia'] = 'Додајте информацију о пошиљаоцу поруке у пољу "Од" одлазне поруке. Ово ће примаоца поруке обавестити о томе ко је поруку послао. Истовремено, ово ће бити од  помоћи у ситуацијама када примаоци порука случајно покушају да свој одговор пошаљу на е-адресу "не-одговарај".';
$string['configemailheaders'] = 'Необрађена заглавља е-поште која се дословно додају у сву одлазну е-пошту.';
$string['configemailsubjectprefix'] = 'Текст који претходи наслову теме свих одлазних порука';
$string['configenableactivitychooser'] = 'Бирач активности је оквир за дијалог са кратким описом сваке активности и ресурса. Ако је онемогућен, биће уместо њега доступни посебни падајући менији за ресурсе и активности.';
$string['configenableanalytics'] = 'Аналитички модели, као што су \'Полазници изложени ризику од напуштања курса\' или \'Активности које се ускоро завршавају\', могу да генеришу предвиђања, шаљу обавештења о увиду и нуде друге акције попут слања порука корисницима.';
$string['configenableblogs'] = 'Овај прекидач омогућава свим корисницима сајта да користе свој блог';
$string['configenablecalendarexport'] = 'Омогући извоз или пријаву на календаре';
$string['configenablecomments'] = 'Омогући коментаре';
$string['configenablecourserequests'] = 'Ако је омогућено, корисници који имају способност да затраже нове курсеве (moodle/course:request) имаће опцију да затраже курс. Ова способност није дозвољена ни за једну од стандардних улога. Може се применити у контексту система или категорије.';
$string['configenabledevicedetection'] = 'Омогућава детекцију мобилних и паметних телефона, таблета или стандардних уређаја (стони или преносиви рачунари, итд.) због примене графичких тема и других функција.';
$string['configenablemobilewebservice'] = 'Омогућите примену мобилних сервиса за званичну Moodle апликацију или друге апликације који то захтевају. За више информација прочитајте {$a}';
$string['configenablerssfeeds'] = 'Ова је опција омогућена, RSS извори ће бити генерисани на читавом сајту од стране различити модула активности као што су блогови, форуми. базе података и речници. Имајте у виду да RSS сервис, такође, треба да буде омогућен на нивоу подешавања појединачног модула активности.';
$string['configenablerssfeedsdisabled'] = 'RSS сервис није доступан, зато што његово коришћење није омогућено на нивоу целог сајта. Да би сте омогућили коришћење RSS-a, идите на страницу за подешавања променљивих у оквиру администраторске конфигурације.';
$string['configenablerssfeedsdisabled2'] = 'RSS извори вести су онемогућени на нивоу сајта. Могу се активирати подешавањем Напредних својстава у Администрацији сајта.';
$string['configenablestats'] = 'Ако овде изаберете опцију "Да", крон процес вашег Moodleа ће обрадити записе и прикупити неке статистичке информације. У зависности од количине саобраћаја на вашем сајту то може потраје неко време. Ако ову опцију омогућите, моћи ћете да видите неке занимљиве графиконе и статистичке извештаје о сваком од ваших курсева, или на нивоу целог сајта.';
$string['configenabletrusttext'] = 'Према подразумеваним подешавањима Moodle ће увек темељно пречистити текст који долази од корисника, како би уклонио евентуалне злонамерне скриптове, мултимедијалне и друге садржаје који би могли представљати безбедносни ризик. Систем Поузданог садржаја (Trusted Content system) представља начин да појединим корисницима, којима верујете, дозволите да додају и такве напредне садржаје без додатне провере. Да бисте омогућили овај систем прво морате да укључите ово подешавање, а потом да одобрите дозволу за Поуздани садржај одговарајућој Moodle улози. Tекстови које креирају или постављају такви корисници биће означени као поуздани и неће бити подвргнути пречишћавању пре приказа.';
$string['configenablewebservices'] = 'Веб сервиси омогућавају другим системима, попут Moodle апликације, да се пријаве на сајт и изведу различите операције. Због додатне безбедности ово подешавање треба да буде искључена, ако не користите Moodle апликацију, или неки екстерни алат/сервис који захтевају интеграцију путем веб сервиса.';
$string['configenablewsdocumentation'] = 'Укључите аутоматско генерисање документације о веб сервисима. Корисник може приступити сопственој документацији на својој страници безбедносних кључева {$a}. Страница приказује документацију само за дозвољене протоколе. ';
$string['configerrorlevel'] = 'Одаберите ниво PHP упозорења која ће Вам се приказивати на екрану. Поставка Нормал је обично најбољи одабир.';
$string['configexportlookahead'] = 'Дана унапред за праћење у току извоза';
$string['configexportlookback'] = 'Дана уназад за праћење током извоза';
$string['configextendedusernamechars'] = 'Ако је омогућено, корисничка имена могу да садрже било које знакове, осим великих слова. У супротном, биће дозвољени само алфанумерички знакови са малим словима, доња црта (_), цртица (-), тачка (.) или симбол "ет" (@).';
$string['configextramemorylimit'] = 'Поједини скриптови као што је претрага, прављење резервних копија или крон захтевају више меморије. За велике сајтове поставите више вредности.';
$string['configfilterall'] = 'Филтрирајте све стрингове, укључујући заглавља, наслове, навигацијску траку Ово је углавном корисно када се користи вишејезички филтер, јер ће у супротном додатно оптеретити сајт уз малу или никакву корист.';
$string['configfiltermatchoneperpage'] = 'Филтери за аутоматско линковање ће генерисати само један линк за прву одговарајућу инстанцу (појављивање) текста која се налази на целој страници. Сва остала појављивања текста се игноришу.';
$string['configfiltermatchonepertext'] = 'Филтери за аутоматско линковање ће генерисати само један линк за прву одговарајућу инстанцу (појављивање) текста која се налази у свакој ставци текста на страници. Сва остала појављивања текста се игноришу. Ово подешавање нема ефекта ако је укључено подешавање \'Филтрирај подударање једном по страници\'.';
$string['configfilternavigationwithsystemcontext'] = 'Нормална употреба филтрирања је везана за контекст у којем се користи (нпр. контекст курса), али за навигацију на сајту, експлицитно филтрирање свега са контекстом сајта може довести до побољшања перформанси када се користи филтрирање "садржаја и наслова".';
$string['configfilteruploadedfiles'] = 'Процесирање свих постављених HTML и текстуалних датотека филтерима пре њиховог приказивања, процесирање само постављених HTML датотека или без процесирања.';
$string['configforcelogin'] = 'Под нормалним околностима, људи ће моћи да виде насловну страницу сајта и списак курсева (али не и саме курсеве) без претходног пријављивања. Уколико желите да приморате људе да се пријаве пре него што виде БИЛО ШТА на сајту, онда би требало да омогућите ово подешавање.';
$string['configforceloginforprofiles'] = 'Ово подешавање приморава људе да се на систем пријаве са правим налозима (не као гости) пре него што буду у прилици да виде странице са корисничким профилима. Ако сте онемогућили ово подешавање може се десити да неки корисници у своје профиле постављају рекламе или други неприкладан садржај, који ће онда бити видљив свима на интернету.';
$string['configfrontpage'] = 'Горе изабране ставке биће приказане на насловној страници сајта.';
$string['configfrontpagecourselimit'] = 'Максималан број курсева';
$string['configfrontpagecourselimithelp'] = 'Максималан број курсева који се приказује на насловној страници сајта у оквиру списка курсева.';
$string['configfrontpageloggedin'] = 'Горе изабране ставке биће приказане на насловној страници сајта када је корисник пријављен на систем.';
$string['configfullnamedisplay'] = 'Ово дефинише начин на који ће бити приказано пуно име и презиме. Подразумевана вредност, "language", оставља да вредност стринга "fullnamedisplay" у текућем језичком пакету одреди начин приказа. Поједини језици имају различите конвенције за приказ имена.

За већину једнојезичких сајтова најефикасније подешавање је "Име Презиме", али можете да изаберете да потпуно сакријете презимена. Ознаке које могу да се користе су: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename и alternatename.';
$string['configgeoipfile'] = 'Локација GeoLite2 City бинарне датотеке. Ова датотека није део Moodle дистрибуције и мора бити засебно преузета са <a href="http://www.maxmind.com/">MaxMind</a>. Можете, или да купите комерцијалну или да користите бесплатну верзију. Морате се регистровати да бисте преузели датотеку City базе, што можете учинити на <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Кад се региструјете и преузмете ту датотеку, распакујте је у директоријум "{$a}" на свом серверу.';
$string['configgetremoteaddrconf'] = 'Ако је Ваш сервер иза повратног (reverse) проксија, можете користити ово подешавање да подесите за која HTTP заглавља се може веровати да садрже удаљену адресу. Заглавља се читају по реду, користи се прво доступно.';
$string['configgradebookroles'] = 'Ова опција вам омогућава да контролишете ко се појављује у књизи оцена. Потребно је да корисници имају барем једну од ових улога на курсу како би били приказани у књизи оцена за тај курс.';
$string['configgradeexport'] = 'Одаберите који формати за извоз књиге оцена су Ваши примарни методи за извоз оцена. Изабрани додаци ће онда поставити и користити поље "last exported" за сваку оцену. На пример, ово може као резултат дати извезене оцене означене као "нове" или "ажуриране". Ако нисте сигурни шта желите да постигнете овим подешавањима, слободно оставите све опције непотврђене.';
$string['confighiddenuserfields'] = 'Изаберите која поља са корисничким информацијама желите да сакријете од других корисника који нису предавачи на курсу или администратори. Ово ће повећати приватност корисника. Држите CTRL тастер да бисте изабрали више поља.';
$string['configidnumber'] = 'Ова поставка одређује (а) хоће ли корисници уопште бити питани за ID број, (б) хоће ли корисници бити питани за ID број, али ће наведено поље моћи оставити празно или (ц) хоће ли корисницима унос у поље ID број бити обавезан. Ако је ID број унет, исти се приказује у њиховом профилу.';
$string['configintro'] = 'На овој страници можете да наведете бројне конфигурационе променљиве које ће помоћи да Moodle правилно функционише на вашем серверу. Не брините превише о томе - подразумеване вредности обично су потпуно адекватне. Касније се можете вратити на ову страницу и променити подешавања према потреби.';
$string['configintroadmin'] = 'Потребно је да на овој страници конфигуришите свој главни администраторски налог који ће имати потпуну контролу над сајтом. Проверите да ли сте налогу доделили безбедно корисничко име и лозинку, као и исправну електронску адресу. Касније можете креирати додатне администраторске налоге.';
$string['configintrosite'] = 'Ова страница вам омогућава да конфигуришете изглед насловне странице и назив сајта. Увек се можете накнадно вратити на ову страницу како бисте променили ова подешавања, користећи мени за администрацију.';
$string['configiplookup'] = 'Када кликнете на IP адресу (попут. 34.12.222.93), на пример у записима о активностима, биће вам приказана мапа са најприближнијом проценом локације те IP адресе. Постоје различити додаци које можете да изаберете за ову функцију, при чему сваки има своје предности и мане.';
$string['configkeeptagnamecase'] = 'Чекирајте ово ако желите да имена ознака (тагова) задрже оригинална велика и мала слова како су их унели креатори';
$string['configlang'] = 'Изаберите подразумевани језик за цео сајт. Корисници могу да промене ово подешавање користећи језички мени или подешавање у оквиру свог личног профила.';
$string['configlanglist'] = 'Ако је остављено празно, сви језици инсталирани на сајту биће приказани у језичком менију. Алтернативно, можете скратити језички мени тако што ћете унети списак жељених језичких кôдова одвојених зарезом. На пример: en,sr,de,fr. Ако желите, другачији назив за језик од назива језичког пакета можете га навести у формату: language code|language name нпр. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Изаберите да ли желите да прикажете jeзички мени на почетној страници, страници за пријављивање на систем, итд. Ово не утиче на могућност корисника да сам подеси преферирани језик у личним подешавањима (ставка \'Параметри\' у корисничком менију).';
$string['configlangstringcache'] = 'Кешира све језичке изразе (стрингове) у компајлиране датотеке, смештене у директоријуму за податке. Ако преводите Moodle или мењате постојеће израза у изворном кôду Moodlea, можда ћете желети ово да искључите. У супротном, оставите укључено како бисте видели користи за перформансе система.';
$string['configlatinexcelexport'] = 'Одаберите кодирање за извоз Excel докумената.';
$string['configlocale'] = 'Одаберите локална подешавања на нивоу целог сајта, што ће утицати на облик приказа и језик на којем се исписују датуми. Неопходно је да у оквиру Вашег оперативног система имате инсталирану подршку за  одговарајући језик (нпр. eng_US или sr). Ако не знате шта бисте одабрали, оставите ово поље празним.';
$string['configlockrequestcategory'] = 'Ако је омогућенo, корисници са овлашћењем за покретање нових курсева у контексту система неће моћи да бирају категорију у форми за захтевање новог курса. Алтернативни начин ограничавања корисника да могу да захтевају нови курс само у оквиру једне категорије је постављањем овлашћења за захтевање нових курсева у контекст категорије.';
$string['configloglifetime'] = 'Ово подешавање одређује колико дуго желите да чувате записе о активностима корисника. Записи који су старији биће аутоматски обрисани. Најбоље је да записе о активностима чувате што је могуће дуже, у случају да вам затребају, али уколико имате јако оптерећен сервер и уколико имате проблеме са његовим перформансама, можда ћете желети да скратити временски период њиховог чувања. Вредности мање од 30 дана се не препоручују зато што статистика можда неће исправно функционисати.';
$string['configlookahead'] = 'Дана за праћење унапред';
$string['configmailnewline'] = 'Ознаке за нови ред који се користе у електронском порукама. Према RFC 822bis захтева се ознака CRLF. Неки сервери за електронску пошту аутоматски конвертују ознаку LF у CRLF, други сервери некоректно конвертују CRLF у CRCRLF, док остали одбијају електронске поруке које користе ознаку LF (qmail на пример). Покушајте да промените ово подешавање уколико имате проблема са неиспорученим електронским порукама и двоструким новим редовима.';
$string['configmaxbytes'] = 'Ово подешавање одређује максималну величину датотека које се могу поставити на сајт. Ово подешавање је ограничено PHP подешавањима post_max_size и upload_max_filesize, као и подешавањем Apache сервера LimitRequestBody. Заузврат, maxbytes ограничава опсег величина које се могу одабрати на нивоу курса или активности. Ако је изабрана опција \'Ограничења сајта  за постављање\' биће коришћена максимaлна величина коју дозвољава сервер. ';
$string['configmaxconsecutiveidentchars'] = 'Лозинке не смеју имати више од овог броја истоветних знакова за редом. Употребите 0 како бисте искључили ову опцију.';
$string['configmaxeditingtime'] = 'Одређује време које корисници имају на располагању за накнадно уређивање порука на форумима, коментара у речницима итд. Обично је 30 минута сасвим довољно.';
$string['configmaxevents'] = 'Број догађаја за праћење унапред';
$string['configmaxusersperpage'] = 'Максималан број корисника који се приказује унутар бирача корисника за курс, групу, кохорту, веб сервис итд.';
$string['configmessaging'] = 'Ако је омогућено, корисници могу да шаљу поруке другим корисницима на сајту.';
$string['configmessagingallowemailoverride'] = 'Дозволи да се корисницима обавештења шаљу на адресу е-поште различиту од оне која је наведена у њиховом профилу';
$string['configmessagingallusers'] = 'Ако је омогућено, корисници могу да виде списак свих корисника на сајту када изаберу некога за слање поруке, а њихови параметри за поруке укључују опцију за прихватање порука од било кога на сајту. Ако је онемогућено, корисници могу само да виде списак корисника на својим курсевима и имају само две опције на располагању у параметрима за поруке - да прихвате поруке само од својих контаката, или од својих контаката и било кога на својим курсевима.';
$string['configmessagingdefaultpressenter'] = 'Да ли је подразумевано активирана опција "Пошаљи притиском на тастер Enter" у корисничким подешавањима везаним за слање порука.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Прочитана и непрочитана обавештења могу да се обришу како би се уштедео простор. Колико дуго након што је креирано обавештења може да се обрише?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Обавештења о прочитаним порукама могу се обрисати како би се сачувао простор. Након колико времена после читања могу бити обрисана?';
$string['configminpassworddigits'] = 'Лозинке морају имати најмање оволико бројева.';
$string['configminpasswordlength'] = 'Лозинке морају да садрже најмање оволико знакова.';
$string['configminpasswordlower'] = 'Лозинке морају да садрже најмање оволико малих слова.';
$string['configminpasswordnonalphanum'] = 'Лозинке морају да садрже најмање оволико не-алфанумеричких знакова.';
$string['configminpasswordupper'] = 'Лозинке морају да садрже најмање оволико великих слова.';
$string['configmodchooserdefault'] = 'Да ли би требало бирач активности, стандардно, приказати корисницима?';
$string['configmycoursesperpage'] = 'Максималан број курсева за приказ на било којој корисниковој листи курсева';
$string['configmymoodleredirect'] = 'Ово подешавање чини обавезним преусмеравање на /my при приступу систему свих корисника осим администратора и мења поставку основног нивоа сајта на /my';
$string['configmypagelocked'] = 'Ово подешавање спречава да корисници који нису администратори уређују подразумеване странице, попут насловне странице сајта.';
$string['confignavcourselimit'] = 'Ограничава број курсева приказаних кориснику у навигацији.';
$string['confignavshowallcourses'] = 'Ово подешавање одређује да ли корисници, уписани на курсеве, могу да поред блока \'Моји курсеви\' (списак курсева на које су уписани). да виде и блок \'Курсеви\' (списак свих курсева).';
$string['confignavshowcategories'] = 'Прикажи категорије курсева у навигационој траци и у блоковима за навигацију Ово се не односи на курсеве у које је корисник тренутно уписан, јер ће курсеви бити приказани у менију под Моји курсеви, без навођења категорија.';
$string['confignoreplyaddress'] = 'Повремено се у име корисника шаље електронска пошта (нпр. копије њихових порука на форумима). Електронска адреса коју овде унесете биће коришћена у заглављу поруке тј. у пољу "Од" у случајевима када они који поруку примају не могу директно одговорити кориснику (тј. када корисник изабере да његова електронска адреса буде недоступна осталим корисницима).';
$string['confignotifyloginfailures'] = 'Пошаљи поруке о неуспешним пријавама на систем изабраним корисницима. Ово захтева да интерно складишта записа (нпр. Стандардно складиште записа - Standard Logstore) буде омогућено.';
$string['confignotifyloginthreshold'] = 'Уколико је опција за регистровање неуспешних приступа активна, колики је минимум погрешних приступа по једном кориснику односно једној IP адреси неопходан да би обавештење о томе било послато?';
$string['confignotloggedinroleid'] = 'Корисници који нису пријављени на систем биће третирани као да им је ова улога додељена у контексту сајта. Скоро увек је улога госта оно што бисте пожелели за такве случајеве, али на овај начин имате могућност да користите улоге креиране као мање или више рестриктивне. Ипак, акције као што је слање порука на форуме и томе слично захтевају да корисник прописно приступи систему.';
$string['configopentowebcrawlers'] = 'Уколико укључите ово подешавање, онда ће Google-у бити омогућено да улази на Ваш сајт као гост. Осим тога људи који на Ваш сајт буду долазили посредством Google претрага аутоматски ће бити пријављени као гости. Напомена: ово омогућава приступ само оним курсевима који и иначе дозвољавају приступ са налогом за госта.';
$string['configoverride'] = 'Дефинисано у config.php датотеци';
$string['configpasswordpolicy'] = 'Ако је ова опција омогућена, корисничке лозинке биће проверена да ли су у складу са важећим правилима за креирање лозинки као што је то назначено у доле наведеним подешавањима. Омогућавање правила за креирање лозинке неће утицати на постојеће кориснике све док они не одлуче да промене своју лозинку или не буду у обавези да је промене, или док није омогућено подешавање \'Провери лозинку приликом пријаве\'.';
$string['configpasswordpolicycheckonlogin'] = 'Ако је омогућено, провераваће се да ли су корисничке лозинке у складу са правилима за креирање лозинки при свакој пријави корисника. Уколико провера не успе, од корисника ће се захтевати да промени лозинку пре него што буде могао да настави.
Корисно је омогућити ово подешавање након измене правила за креирање лозинки.';
$string['configpasswordresettime'] = 'Ово одређује време које корисници имају на располагању како би потврдили захтев за ресетовање лозинке, пре него што оно истекне. Обично је 30 минута сасвим одговарајуће време.';
$string['configpathtodu'] = 'Путања до du. Вероватно нешто попут /usr/bin/du. Aко ово унесете, странице које приказују садржај директоријума ће радити много брже за директоријуме са много датотека.';
$string['configpathtophp'] = 'Путања до PHP CLI. Вероватно нешто попут /usr/bin/php. Ако унесете ово, крон скрипте се могу извршити из администраторског веб интерфејса.';
$string['configperfdebug'] = 'Ако ово укључите, информације о перформансама биће приказане у подножју стандардне графичке теме';
$string['configprofileroles'] = 'Списак улога које су видљиве на корисничким профилима и страници са списком учесника.';
$string['configprofilesforenrolledusersonly'] = 'Да би се спречила злоупотреба од стране спамера, поље за опис на страници са профилом корисника, који се још нису уписали ни на један курс, је сакривено. Нови корисници морају да се упишу барем на један курс како би могли да додају опис.';
$string['configprotectusernames'] = 'Ако је ова опција омогућена, образац за заборављену лозинку неће приказивати никакву помоћ за погађање корисничких имена или адреса електронске поште.';
$string['configproxybypass'] = 'Списак (делимичних) назива рачунара или IP адреса (одвојених зарезом) које би требало да премосте прокси (e.g., 192.168., .mydomain.com)';
$string['configproxyfixunsafe_help'] = 'Ово покушава да поправи интерне позиве који не пролазе кроз прокси сервера додавањем MoodleBot User Agent и коришћењем проксија.';
$string['configproxyhost'] = 'Уколико овај <b>сервер</b> мора да користи прокси рачунар (нпр. "заштитни зид") за приступ интернету, унесите овде адресу проксија. У супротном оставите ово поље празно.';
$string['configproxylogunsafe_help'] = 'Ово покушава да евидентира интерне позиве који не пролазе кроз прокси сервер, а требало би.';
$string['configproxypassword'] = 'Лозинка потребна за приступ интернету путем прокси сервера, уколико је то неопходно. Оставите празно уколико прокси сервер није потребан (неопходна је PHP cURL екстензија)';
$string['configproxyport'] = 'Ако овај сервер мора да користи прокси рачунар, наведите овде порт за прокси.';
$string['configproxytype'] = 'Тип веб прокси сервера (PHP5 и cURL екстензија су неопходни за подршку за SOCKS5)';
$string['configproxyuser'] = 'Корисничко име потребно за приступ интернету путем прокси сервера уколико је то неопоходно. Оставити празно уколико прокси није потребан (неопходна је PHP cURL екстензија)';
$string['configrecaptchaprivatekey'] = 'Низ знакова (тајни кључ) који се користи за комуникацију између вашег Moodle сервера и recaptcha сервера. ReCAPTCHA кључеви се могу набавити на сајту <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Низ знакова (кључ сајта) који се користи за приказ reCAPTCHA елемента на обрасцу за пријаву као и на обрасцу за подршку. ReCAPTCHA кључеви се могу набавити на сајту <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Реч за полазника која се користи у захтеваним курсевима';
$string['configrequestedstudentsname'] = 'Реч за полазнике која се користи у захтеваним курсевима';
$string['configrequestedteachername'] = 'Реч за предавача која се користи у захтеваним курсевима';
$string['configrequestedteachersname'] = 'Реч за предаваче која се користи у захтеваним курсевима';
$string['configreverseproxyignore'] = 'Ако је ваш сервер иза вишеструких реверзних проксија који додају  X-Forwarded-For заглавље, у том случају наведите листу вредности одвојених запетама која садржи ИП адресе или подмреже реверзних проксија које треба игнорисати како би нашли исправну ИП адресу корисника.';
$string['configsectioninterface'] = 'Интерфејс';
$string['configsectionmail'] = 'Пошта';
$string['configsectionmaintenance'] = 'Одржавање';
$string['configsectionmisc'] = 'Разно';
$string['configsectionoperatingsystem'] = 'Оперативни систем';
$string['configsectionpermissions'] = 'Овлашћења';
$string['configsectionrequestedcourse'] = 'Захтеви за покретање новог курса';
$string['configsectionsecurity'] = 'Безбедност';
$string['configsectionstats'] = 'Статистика';
$string['configsectionuser'] = 'Корисник';
$string['configsecureforms'] = 'Moodle може да користи додатни ниво безбедности када прима податке из веб образаца. Уколико је то омогућено, онда се HTTP_REFERER променљива веб читача упоређује са текућом адресом обрасца. У веома малом броју случајева то може проузроковати проблеме ако корисник употребљава "заштитни зид" (нпр. Zonealarm) конфигурисан тако да уклања HTTP_REFERER променљиву из веб саобраћаја. Последица тога је тзв. "заглављивање у обрасцу". Уколико ваши корисници имају проблема, на пример, са страницом за пријављивање, можда ћете желети да онемогућите ово подешавање, иако ће то ваш сајт учинити далеко осетљивијим на хакерске нападе разбијања лозинки грубом силом. Уколико сте у дилеми, омогућите ову опцију.';
$string['configservicespage'] = 'Унесите URL адресу странице за услуге и подршку или оставите празно за линк ка Moodle сервисима на moodle.com. Линк се приказује само администраторима сајта.';
$string['configsessioncookie'] = 'Ово подешавање прилагођава име "колачића" за Moodle сесије. Подешавање је опционо и корисно је само да би се избегла мешање "колачића", у ситуацији када је у оквиру истог веб сајта покренуто више од једне копије Moodlea.';
$string['configsessioncookiedomain'] = 'Ово Вам дозвољава да мењате домен са ког су Moodle колачићи доступни. То је корисно за разна прилагођавања Moodlea (нпр. додаци за проверу идентитета или упис) који морају да деле информације о Moodle сесији са веб апликацијом на другом поддомену. <strong>УПОЗОРЕЊЕ: топло препоручујемо да ово подешавање оставите празно (подразумевана вредност) - неисправна вредност ће спречити било какву пријаву на сајт.</strong>';
$string['configsessioncookiepath'] = 'Ако је потребно да промените где веб читачи шаљу Moodle колачиће, можете променити ово подешавање тако што ћете одредите поддиректоријум свог веб сајта. Иначе, стандардна вредност \'/\' требало би да је сасвим прихватљива.';
$string['configsessiontimeout'] = 'Уколико су корисници који су пријављени на сајт, неактивни дужи временски период (не учитавају странице), биће аутоматски одјављени (њихове сесије биће завршене). Ова променљива одређује колико треба да буде ово време.';
$string['configsessiontimeoutwarning'] = 'Уколико су корисници који су пријављени на сајт, неактивни дужи временски период (не учитавају странице), онда ће бити упозорени да ће се њихова сесија ускоро завршити. Ова променљива одређује колико треба да буде ово време.';
$string['configsessiontimeoutwarningcheck'] = 'Упозорење о истеку сесије мора бити мање од истека сесије';
$string['configshowcommentscount'] = 'Прикажи број коментара. Биће потребно извршити само један упит више приликом приказа линка коментара.';
$string['configshowicalsource'] = 'Прикажи изворне информације за ical догађаје';
$string['configshowsiteparticipantslist'] = 'Сви ови полазници и предавачи на нивоу сајта биће приказани на списку учесника. Коме ће бити дозвољено да види овај списак учесника?';
$string['configsitedefaultlicense'] = 'Подразумевана лиценца на нивоу сајта';
$string['configsitedefaultlicensehelp'] = 'Подразумевана лиценца за објављивање садржаја на овом сајту';
$string['configsitemailcharset'] = 'Ово подешавање одређује подразумевани кодни распоред за све поруке е-поште послате са сајта.';
$string['configsitemaxcategorydepth'] = 'Максималан број поткатегорија';
$string['configsitemaxcategorydepthhelp'] = 'Ово одређује максималан број поткатегорија који ће се појавити када се приказују категорије или комбинована листа. Нижи ниво категорија ће појавити као линкови које ће корисник моћи да прошири помоћу AJAX захтева.';
$string['configslasharguments'] = 'Аргументи са обрнутом косом цртом (slash arguments) (коришћењем <em>PATH_INFO</em>) су неопходни да би се SCORM пакети и ресурси који садрже више датотека правилно приказивали. Ако ваш веб сервер не подржава такве аргументе и нисте у могућности да ту подршку обезбедите, ово подешавање може бити онемогућено, с тим да треба имати на уму да поменути типови ресурса неће бити правилно приказивани.<br />Напомена: У наредним верзијама система ће активација коришћења тих аргумената бити обавезна.';
$string['configsmartpix'] = 'Ако се ова опција укључи иконице ће учитавати PHP скрипт који претражује текућу графичку тему сајта, потом све надређене теме, и коначно Moodle /pix директоријум. Ово смањује потребу за чувањем дупликата слика унутар тема, али помало утиче на перформансе система.';
$string['configsmtpauthtype'] = 'Ово поставља тип провере идентитета који ће се користити на smtp серверу.';
$string['configsmtphosts'] = 'Наведите пуну адресу једног или више локалних SMTP сервера које Moodle треба да користи за слање е-поште (нпр. mail.a.com или mail.a.com;mail.b.com). Да бисте одредили нестандардни порт (тј. различит од порта 25), можете да користите синтаксу [sever]:[port] (нпр. \'mail.a.com:587\'). Уколико поље оставите празно Moodle ће за слање е-поште користити подразумевани PHP метод.';
$string['configsmtpmaxbulk'] = 'Максималан број порука послатих по једној SMTP сесији. Груписање порука може да убрза слање електронске поште.  Вредности мање од 2 доводе до креирања нове SMTP сесије за сваку електронску поруку.';
$string['configsmtpoauthservice'] = 'Одаберите OAuth 2 сервис који је подешен за комуникацију са smtp сервером. Ако такав сервис још не постоји, мораћете да га креирате. Напомена: ово подешавање важи искључиво уколико је SMTP тип ауторизације постављен на XOAUTH2.';
$string['configsmtpsecure'] = 'Ако SMTP сервер захтева безбедну везу, наведите тачан тип протокола.';
$string['configsmtpuser'] = 'Ако сте претходно навели SMTP сервер и ако он тражи проверу идентитета унесите корисничко име и лозинку';
$string['configstartwday'] = 'Почетак недеље';
$string['configstatsfirstrun'] = 'Ово одређује колики ће се временски ићи уназад приликом обраде записа о активностима, <b>први пут</b> када крон процес жели да обради статистичке податке. Ако имате доста саобраћаја и на дељеном сте серверу, вероватно није добра идеја да идете превише уназад, јер би могло бити потребно превише времена за извршавање процеса и та активност би била прилично захтевна за сервер. (Имајте на уму да је за ово подешавање 1 месец = 28 дана. На графиконима и у извештајима који се генеришу 1 месец одговара једном календарском месецу).';
$string['configstatsmaxruntime'] = 'Обрада статистичких података може бити прилично интензивнa, па је најбоље да користите комбинацију овог и следећег поља како бисте одредили када ће се обрада покренути и колико дуго ће трајати.';
$string['configstatsmaxruntime2'] = 'Статистичка обрада може бити прилично интезивна. Одредите максимално време које се допушта за прикупљање статистичких података за један дан. Максимални број дана који се обрађује у једном извршењу крона је 31.';
$string['configstatsmaxruntime3'] = 'Ово одређује максимално дозвољено време за израчунавање статистике за један дан. Имајте у виду да обрада статистичких података може у великој мери оптеретити сервер. Максимална број дана обрађених у једном крону може бити доле одређен.';
$string['configstatsruntimedays'] = 'Ово одређује максималан број дана који се обрађује приликом сваког процесуирања статистике. Када је статистика ажурна, само ће се један дан обрађивати - зато подесите ову вредност зависно од оптерећења вашег сервера, смањујући је ако су потребна краћа покретања крона.';
$string['configstatsruntimestart'] = 'У које време треба да започне са извршавањем крон обрада статистичких података? Уколико на серверу има више Moodle сајтова, препоручљиво је навести различита времена.';
$string['configstatsuserthreshold'] = 'Ово подешавање одређује минималан број уписаних корисника, потребан да би курс био укључен у статистичко израчунавање.';
$string['configstrictformsrequired'] = 'Ако је ово подешавање омогућено, корисницима неће бити дозвољено да уносе размак или прелаз у нови ред, али само унутар обавезних поља у обрасцима.';
$string['configstripalltitletags'] = 'Искључите ово подешавање како бисте омогућили HTML ознаке у називима активности и ресурса.';
$string['configsupportavailability'] = 'Одређује ко има приступ контакт подацима подршке за сајт из подножја.';
$string['configsupportemail'] = 'Ако је SMTP конфигурисан на овом сајту, а страница за подршку није подешена, ова адреса е-поште ће примати поруке послате путем обрасца за подршку. Ако слање поруке не успе, адреса е-поште биће приказана пријављеним корисницима.';
$string['configsupportname'] = 'Име особе/организације задужене за пружање подршке путем обрасца за подршку или странице за подршку.';
$string['configsupportpage'] = 'Унесите URL адресу странице за подршку или оставите празно за линк ка обрасцу за подршку. Линк се приказује у подножју сајта.';
$string['configtempdatafoldercleanup'] = 'Уклони из директоријума са подацима привремене датотеке, које су старије од изабраног временског периода.';
$string['configthemedesignermode'] = 'Уобичајено је да се све слике графичке теме као и CSS датотеке на дужи временски период кеширају у веб читачу и на серверу, због брзине извршавања. Ако дизајнирате теме или развијате изворни кôд, вероватно ћете желите да укључити овај режим рада како би сте избегли да добијате верзије из кеша. Упозорење: ово ће успорити ваш сајт за све кориснике! Алтернативно, можете да ресетујете кеш ручно на страници за избор теме.';
$string['configthemelist'] = 'Оставите ово поље празно да бисте дозволили употребу било које графичке теме. Уколико желите да скратите листу тема, овде можете да наведите списак њихових назива, раздвојених зарезима (немојте користити размаке!).
На пример: standard,orangewhite.';
$string['configtimezone'] = 'Ово је подразумевана временска зона за приказивање датума - сваки корисник може да промени ово подешавање у свом профилу. Задаци крона и остала подешавања сервера наведени су у овој временској зони. Ако је приказано "Неисправна временска зона" потребно је да промените подешавање.';
$string['configuseblogassociations'] = 'Да ли је потребно да корисници могу да организују своје блогове повезивањем чланака са курсевима и модулима курса?';
$string['configusesitenameforsitepages'] = 'Ако је ово подешавање омогућено, онда ће се у навигацији за странице сајта, уместо фразе \'Странице сајта\', користити скраћени назив сајта.';
$string['configusetags'] = 'Да ли треба омогућити ознаке (тагове) на читавом сајту?';
$string['configvariables'] = 'Променљиве';
$string['configverifychangedemail'] = 'Омогућава потврду промењених е-адреса користећи подешавање за дозвољене и забрањене домене е-адреса. Уколико је ово подешавање искључено ограничење домена ће бити коришћено само приликом креирања нових корисничких налога.';
$string['configvisiblecourses'] = 'Прикажи нормално курсеве који су у скривеним категоријама.';
$string['configwarning'] = 'Будите опрезни при мењању ових подешавања - необичне вредности могу изазвати проблеме у раду.';
$string['configyuicomboloading'] = 'Ова опција омогућава оптимизацију учитавања комбинованих датотека YUI библиотека. Ово подешавање треба да буде укључено на продукционим сајтовима због бољих перформанси.';
$string['confirmation'] = 'Потврда';
$string['confirmcontextlock'] = '{$a->contextname} је тренутно одмрзнут. Замрзавање ће га учинити доступним само за читање и спречиће кориснике да праве измене. Јесте ли сигурни да желите да наставите?';
$string['confirmcontextunlock'] = '{$a->contextname} је тренутно замрзнут. Одмрзавање ће омогућити корисницима да праве измене. Јесте ли сигурни да желите да наставите?';
$string['confirmdeletecomments'] = 'Да ли сте сигурни да желите да обришете одабран(е) коментар(е)?';
$string['confirmed'] = 'Потврђени налог';
$string['contactsitesupport'] = 'Контактирајте подршку сајта';
$string['contenttypeuninstalling'] = 'Постоји {$a->count} садржај(а) подржаних од {$a->type}. Садржаји ће бити избрисани. Да ли сте сигурни да желите да наставите?';
$string['contextlockappliestoadmin'] = 'Замрзавање контекста односи се на администраторе';
$string['contextlockappliestoadmin_desc'] = 'Ако је онемогућено, администратори остају са правом уписивања у било ком замрзнутом контексту.';
$string['contextlocking'] = 'Замрзавање контекста';
$string['contextlocking_desc'] = 'Ово подешавање омогућава да приступ само за читање буде постављено за изабране категорије, курсеве, активности односно блокове.';
$string['cookiehttponly'] = 'Само http колачићи';
$string['cookiesecure'] = 'Само безбедни колачићи';
$string['country'] = 'Подразумевана држава';
$string['course_customfield'] = 'Прилагођена поља курса';
$string['coursecolor'] = 'Боја {$a}';
$string['coursecolorheading_desc'] = 'Сви курсеви за које није постављена слика у основним подешавањима курса се на контролном панелу приказују у виду шрафиране картице курса. Боје које се користе у шаблону могу бити наведене у наставку.';
$string['coursecolorsettings'] = 'Боје картице курса';
$string['coursecontact'] = 'Курс - контакт особе';
$string['coursecontact_desc'] = 'Ово подешавање вам омогућава да одредите ко се појављује на страници са описом курса. Корисници морају да имају барем једну од ових улога на курсу како би њихова имена била приказани поред описа тог курса.';
$string['coursecontactduplicates'] = 'Прикажите све улоге контакт особе за курс';
$string['coursecontactduplicates_desc'] = 'Ако је омогућено, корисници који имају више од једне улоге изабране да буду контакт особе за курс, биће приказани у опису курса са свим својим улогама. У супротном, биће приказани само са једном улогом (која ја наведена као највиши на страници \'Дефиниши улоге\' у оквиру Администрације сајта).';
$string['coursecreationguide'] = 'Линк ка водичу за креирање Мудл курсева';
$string['coursecreationguide_help'] = 'Дефинише путању до водича за брзи почетак са кратким видео записима и општим саветима везаним за креирање курсева. Линк ка водичу се приказује на страници Моји курсеви када нема курсева за приказ. Само корисници који имају овлашћења за креирање курсева ће видети тај линк.';
$string['coursegraceperiodafter'] = 'Додатно време за прошле курсеве';
$string['coursegraceperiodbefore'] = 'Додатно време за будуће курсеве';
$string['courselistshortnames'] = 'Прикажи пуне називе курсева';
$string['courselistshortnames_desc'] = 'Ако је ова опција омогућена, на списку курсева, поред пуних назива, биће приказани и скраћени називи курсева. Ако је неопходно, пуни називи курсева се могу прилагодити уређивањем језичког стринга \'courseextendednamedisplay\', користећи могућност за прилагођавање језика.';
$string['coursemgmt'] = 'Управљање курсевима и категоријама';
$string['courseoverview'] = 'Преглед курсева';
$string['coursepage'] = 'Страница курса';
$string['courserequestnotify'] = 'Обавештење о захтеву за покретање новог курса';
$string['courserequestnotifyemail'] = 'Корисник {$a->user}  је затражио/ла нови курс <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Захтеви за покретање новог курса';
$string['courserequestspending'] = 'Захтеви за покретање курс на чекању';
$string['courses'] = 'Курсеви';
$string['coursesperpage'] = 'Број курсева по страници';
$string['courseswithsummarieslimit'] = 'Број курсева са резимеом';
$string['creatornewroleid'] = 'Улога креатора у новим курсевима';
$string['creatornewroleid_help'] = 'Уколико корисник већ нема овлашћења да управља новим курсом, онда је аутоматски уписан користећи ову улогу';
$string['cron'] = 'Крон';
$string['cron_enabled'] = 'Омогући крон';
$string['cron_enabled_desc'] = 'Нормално, крон би требало да буде укључен, међутим ово подешавање омогућава његово привремено искључивање, на пример пре поновног покретања сервера. Ако је крон искључен, систем спречава покретање нових позадинских задатака. Имајте на уму да крон не би требало дуго да буде искључен, јер ће то спречити рад важних функција.';
$string['cron_help'] = 'Cron.php покреће бројне задатака у различитим временским интервалима, као што је слање копија нових порука са форума путем е-поште. Потребно је редовно покретање крон скрипте - идеално сваког минута.';
$string['cron_keepalive'] = 'Одржи крон у функцији';
$string['cron_keepalive_desc'] = 'Време за наставак извршавања додатних задатака. Ово подешавање служи како би се осигурало да крон увек буде активан.<br><br>Ако користите наменске покретаче задатака, подесите ову вредност на 0. У супротном, подесите на вредност сличну вашем ограничењу броја паралелних адхок задатака. Избегавајте дуже временске периоде. Максимално време износи 15 минута.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Покретање крона искључиво преко командне линије';
$string['cronerrorclionly'] = 'Нажалост, приступ овој страници је онемогућен од стране администратора.';
$string['cronerrorpassword'] = 'Жао нам је, нисте унели исправну лозинку да бисте приступили овој страници';
$string['croninfrequent'] = 'Време између последња два покретања крон скрипте за одржавање било је {$a->actual}, а требало би да се скрипта покреће сваке {$a->expected}. Препоручујемо да крон конфигуришете тако да се чешће покреће.';
$string['cronremotepassword'] = 'Крон лозинка за удаљени приступ';
$string['cronwarning'] = '<a href="{$a->url}">Скрипт admin/cron.php</a> није покретан последњих {$a->actual}, а требало би на сваких  {$a->expected}.';
$string['cronwarningcli'] = '<code>admin/cli/cron.php</code> скрипт није покретан {$a->actual} а требало би да се извршава на сваких {$a->expected}.';
$string['cronwarningnever'] = 'Скрипт <code>admin/cli/cron.php</code> никада није покренут, а требало би на сваких  {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">Скрипт admin/cron.php</a> никада није покренут, а требало би на сваких  {$a->expected}.';
$string['ctyperequired'] = 'PHP екстензије ctype је сада обавезна за Moodle, како би се унапредиле перформансе сајта и обезбедила вишејезична компатибилност.';
$string['curlcache'] = 'cURL кеш TTL';
$string['curlrequired'] = 'PHP екстензија cURL сада је обавезна за Moodle због комуникације са Moodle репозиторијумима.';
$string['curlsecurityallowedport'] = 'Списак дозвољених портова за cURL';
$string['curlsecurityallowedportsyntax'] = 'Списак бројева портова са којима cURL може да се повеже. Исправни уноси су само целобројне вредности. Унесите сваки број порта у засебан ред. Ако се остави празно онда су дозвољени сви портови. Ако је подешено, у скоро свим случајевима, и порт 443 и порт 80 треба навести за повезивање са стандардним HTTP и HTTPS портовима.';
$string['curlsecurityblockedhosts'] = 'Списак блокираних рачунара за cURL';
$string['curlsecurityblockedhostssyntax'] = 'Унесите сваки рачунар у нови ред. Исправни уноси су или IPv4 или IPv6 адресе (као на пример 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) које одговарају једном рачунару; или CIDR нотација (као на пример 231.54.211.0/20 или fe80::/64); или опсег IP адреса (као на пример 231.3.56.10-20 или fe80::1111-bbbb) где се опсег односи на последњу групу адресе; или називи домена (као на пример localhost или example.com); или називи домена са џокер знацима (као на пример *.example.com или *.sub.example.com). Празни редови нису дозвољени.';
$string['curlsecurityurlblocked'] = 'URL адреса је блокирана.';
$string['curltimeoutkbitrate'] = 'Брзина протока у битовима која се користи приликом израчунавања времена чекања за cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ово подешавање се користи за израчунавање одговарајућег тајм-аута код великих cURL захтева. Као део овог прорачуна креира се HTTP HEAD захтев како би се одредила величина садржаја. Постављањем овог параметра на 0 онемогућава се креирање овог захтева.';
$string['currenttheme'] = 'Тренутна графичка тема';
$string['customcheck'] = 'Друге провере';
$string['custommenu'] = 'Прилагођени мени';
$string['custommenuitems'] = 'Ставке прилагођеног менија';
$string['customusermenuitems'] = 'Ставке корисничког менија';
$string['datarootsecurityerror'] = '<p><strong>БЕЗБЕДНОСНО УПОЗОРЕЊЕ!</strong></p><p>Ваш директоријум са подацима је на погрешном месту и могуће му је приступити са веба. То значи да су све ваше приватне датотеке доступне свакоме ко има приступ интернету, па неке од њих могу искористити злонамерни корисници како би добили неауторизован администраторски приступ вашем сајту!</p>
<p><em>Морате</em> да преместите директоријум са подацима ({$a}) на нову локацију која није у оквиру вашег јавног веб директоријума, а потом да ажурирате <code>$CFG->dataroot</code> подешавање у датотеци config.php у складу са начињеним променама.</p>';
$string['datarootsecuritywarning'] = 'Конфигурација вашег сајта можда није безбедна. Молимо проверите да ли ваш директоријум података ({$a}) није директно доступан преко веба.';
$string['dbprefixtoolong'] = 'Префикс ваше базе података ($CFG->prefix) је предугачак (тренутно, број знакова износи: {$a->current}). Максимални дозвољени број знакова је {$a->maximum}.';
$string['dbsessions'] = 'Користите базу података за информације о сесијама';
$string['debug'] = 'Поруке за отклањање грешака';
$string['debugall'] = 'СВЕ: Прикажи све разумљиве PHP поруке о грешкама';
$string['debugdeveloper'] = 'РАЗВОЈНЕ: Прикажи додатне Moodle поруке о грешкама, намењене само програмери';
$string['debugdisplay'] = 'Прикажи поруке за отклањање грешака';
$string['debugging'] = 'Отклањање грешака';
$string['debugminimal'] = 'МИНИМАЛНО: Прикажи само фаталне грешке';
$string['debugnone'] = 'БЕЗ ПОРУКЕ: Не приказуј грешке или упозорења';
$string['debugnormal'] = 'НОРМАЛНО: Прикажи грешке, упозорења и обавештења';
$string['debugpageinfo'] = 'Прикажи информације о страници';
$string['debugsqltrace'] = 'Прикажи извор SQL позива';
$string['debugsqltrace1'] = 'Прикажи само појединачну линију позива';
$string['debugsqltrace100'] = 'Прикажи комплетан испис стека';
$string['debugsqltrace2'] = 'Прикажи 2 линије исписа стека';
$string['debugsqltrace_desc'] = 'Ако је омогућено, додаје делимични или комплетни PHP испис стека у SQL као коментар';
$string['debugstringids'] = 'Прикажи порекло језичких израза';
$string['debugstringids_desc'] = 'Када је ова опција омогућена, ако URL адреси додате параметар ?strings=1 или &strings=1, то ће приказати језичку датотеку и идентификатор стрингa поред сваког израза.';
$string['debugtemplateinfo'] = 'Прикажи информације о шаблону';
$string['debugtemplateinfo_desc'] = 'Уколико је омогућено, шаблони који се користе за приказивање се приказују као коментари у HTML кôду странице. Након промене подешавања потребно је да очистите кеш меморије. Користите ову опцију само за привремено отклањање грешака, јер проузрокује грешке приликом провере HTML кôда, а може да прекине и извршавање скрипти. Такође, може да оштети основне функционалности.';
$string['debugvalidators'] = 'Прикажи линк ка сервисима за проверу валидности';
$string['defaultcity'] = 'Подразумевани град';
$string['defaultcity_help'] = 'Град који овде унесете биће подразумевани град за све новоотворене корисничке налоге.';
$string['defaultformatnotset'] = 'Грешка приликом одређивања подразумеваног формата курса. Проверите подешавања сајта.';
$string['defaulthomepage'] = 'Почетна страница за кориснике';
$string['defaultrequestcategory'] = 'Подразумевана категорија за захтеване курсеве';
$string['defaultsettinginfo'] = 'Подразумевана вредност: {$a}';
$string['defaultuserroleid'] = 'Подразумевана улога за све кориснике';
$string['deleteincompleteusers'] = 'Oбриши непотпуне корисничке налоге након';
$string['deleteunconfirmed'] = 'Обриши непотврђене кориснике након';
$string['deleteuser'] = 'Обриши корисника';
$string['density'] = 'Густина';
$string['denyemailaddresses'] = 'Недозвољени домени е-поште';
$string['development'] = 'Развој';
$string['devicedetectregex'] = 'Регуларни изрази за детекцију уређаја';
$string['devicedetectregex_desc'] = '<p>Стандардно, Moodle може да детектује подразумевани тип уређаја (стони и преносиви рачунари итд.), мобилни уређај (паметни телефони, ручни рачунари) таблет (iPad, Android таблети) као и старије типове веб читача (Internet Explorer 6 корисници). Помоћу селектора графичке теме могуће је за сваки од ових типова уређаја подесити засебну тема. Ово подешавање дозвољава коришћење регуларних израза који омогућавају детекцију додатних типова уређаја (ови имају предност у односу на подразумеване типове).</p>
<p>На пример, можете да унесете регуларни израз \'/(MIDP-1.0|Maemo|Windows CE)/\'  за детекцију неких најчешће коришћених телефона додајте повратну вредност \'featurephone\'. Ово додаје \'featurephone\' у селектор графичке темe што ће вам омогућити да додате тему која ће се користити на овим уређајима. Остали телефони ће и даље користити тему која је изабрана за мобилне уређаје.</p>';
$string['devicedetectregexexpression'] = 'Регуларни изрази';
$string['devicedetectregexvalue'] = 'Повратна вредност';
$string['devicetype'] = 'Тип уређаја';
$string['devlibdirpresent'] = 'Директоријуми са развојним библиотекама, посебно <em>vendor</em> и <em>node_modules</em> не би требало да буду присутни на јавним сајтовима. За више информација погледајте <a href="{$a->moreinfourl}">извештај о безбедности</a>.';
$string['disabled'] = 'Онемогућено';
$string['disableplugin'] = 'Онемогућите додатак {$a}';
$string['disableuserimages'] = 'Искључи слике у корисничком профилу';
$string['displayerrorswarning'] = 'Омогућавање подешавања у PHP-у <em>display_errors</em> није препоручљиво на продукционим сајтовима, јер неке поруке о грешкама могу открити осетљиве информације о вашем серверу.';
$string['displayloginfailures'] = 'Прикажи неуспешне пријаве';
$string['divertallemails'] = 'Преусмеравање е-поште';
$string['divertallemailsdetail'] = 'Користи се као заштита у развојним окружењима приликом тестирања е-поште и не сме се користити на продукционом серверу.';
$string['divertallemailsexcept'] = 'Изузеци за преусмеравање е-поште';
$string['divertallemailsexcept_desc'] = 'Списак правила за изузеће е-поште, раздвојених зарезима или новим редовима. Свако правило се тумачи као регуларни израз нпр. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Преусмери сву е-пошту';
$string['divertallemailsto_desc'] = 'Ако је подешено, онда ће све поруке е-поште бити преусмерени на ову једину адресу е-поште.';
$string['dndallowtextandlinks'] = 'Постављање текста/линкова помоћу опције \'превуци и спусти\'';
$string['doclang'] = 'Језик за документацију';
$string['docroot'] = 'Коренски директоријум Moodle документације';
$string['doctonewwindow'] = 'Отворити у новом прозору';
$string['doesnotfit'] = 'Подешавања приказа е-поште';
$string['doesnotfitdetail'] = 'Подешавања приказа за е-пошту која се шаље са Moodlea.';
$string['download'] = 'Преузми';
$string['downloadcoursecontentallowed'] = 'Функција за преузимање садржаја курса доступна';
$string['downloadcoursecontentallowed_desc'] = 'Да ли је функција преузимање садржаја курса доступна курсевима. Када је доступна, преузимање садржаја курса може се омогућити/онемогућити помоћу подешавања „Омогући преузимање садржаја курса“ у менију за уређивање курса (стандарно ово се може подесити <a href={$a} target="_blank">Подразумевана подешавања курса</a>).';
$string['durationunits'] = 'јединице трајања:';
$string['edithelpdocs'] = 'Уређивање докумената помоћи';
$string['editlang'] = '<b>Уреди</b>';
$string['editorbackgroundcolor'] = 'Боја позадине';
$string['editordictionary'] = 'Едитор речника';
$string['editorfontfamily'] = 'Фамилија фонтова';
$string['editorfontlist'] = 'Списак фонтова';
$string['editorfontsize'] = 'Величина фонта';
$string['editorhidebuttons'] = 'Сакривена дугмад';
$string['editorkillword'] = 'Филтер Word формата';
$string['editorspelling'] = 'Едитор правописа';
$string['editorspellinghelp'] = 'Укључи/искључи проверу правописа. Када је укључено, <strong>aspell</strong> мора бити инсталиран на серверу.';
$string['editstrings'] = 'Уређивање речи или израза';
$string['emailchangeconfirmation'] = 'Потврда измене адресе е-поште';
$string['emaildkim'] = 'DomainKeys Identified Mail (DKIM) потписивање е-поште';
$string['emaildkiminfo'] = 'Е-пошта ће бити потписана ако је подешен DKIM селектор и уколико је, истовремено, пронађена датотека приватног сертификата, која се подудара са доменом адресе "Од" ("From") у $CFG->dataroot/dkim/[domain]/[selector].private. У већини случајева (на пример, ако је allowedemaildomains празан) потребан је само један сертификат у <pre>{$a->path}</pre>. За више детаља о подешавању погледајте документацију <a href="{$a->docs}">Конфигурација поште</a>.';
$string['emaildkimselector'] = 'DKIM селектор';
$string['emailfromvia'] = 'Информација о пошиљаоцу поруке';
$string['emailheaders'] = 'Заглавља е-поште';
$string['emailsubjectprefix'] = 'Текст који претходи теми е-поруке';
$string['emoticonalt'] = 'Алтернативни текст';
$string['emoticoncomponent'] = 'Графичка компонента емотикона';
$string['emoticonimagename'] = 'Назив слике';
$string['emoticons'] = 'Емотикони';
$string['emoticons_desc'] = 'На овој страници можете подесити емотиконе који се користе на вашем сајту. Како бисте уклонили ред из табеле (односно неки емотикон) обришите садржај било ког од захтеваних поља и сачувајте образац. За додавање новог емотикона, попуните поља у последњем празном реду. За ресетовање свих поља на подразумеване, почетне вредности кликните на горњи линк.

* Текст (обавезно) - овај текст ће бити замењен са сликом емотикона. Мора садржати бар 2 знака.
* Назив слике (обавезно) - назив датотека са сликом емотикона (без екстензије), релативно у односу на pix директоријум компоненте.
* Графичка компонента (обавезно) - компонента која обезбеђује иконицу.
* Алтернативни текст (опционо) - идентификатор стринга и компонента алтернативног текста емотикона.';
$string['emoticonsreset'] = 'Ресетуј подешавања емотикона на подразумеване вредности';
$string['emoticontext'] = 'Текст';
$string['emptysettingvalue'] = 'Празно';
$string['enableactivitychooser'] = 'Омогући бирач активности';
$string['enableanalytics'] = 'Аналитика';
$string['enableblogs'] = 'Омогући блог';
$string['enablecalendarexport'] = 'Омогући извоз календара';
$string['enablecomments'] = 'Омогући коментаре';
$string['enablecourserelativedates'] = 'Омогући релативне датуме курса';
$string['enablecourserelativedates_desc'] = 'Дозволи да се курсеви подесе тако да приказују датуме релативно у односу на датум првог приступа курсу од стране сваког корисника.';
$string['enablecourserequests'] = 'Омогући слање захтева за покретање нових курсева';
$string['enabled'] = 'Омогућено';
$string['enabledashboard'] = 'Омогући Контролни панел';
$string['enabledashboard_help'] = 'Контролни панел стандардно приказује блокове \'Хронологија\', \'Календар\' и \'Скорашње активности/ресурси\'. Можете подесити другачији стандардни Контролни панел за све и омогућити корисницима да сами прилагоде сопствени Контролни панел. Ако је опција онемогућена, потребно је да у менију \'Почетна страница за кориснике\' уместо Контролни панел изаберте неку другу опцију.';
$string['enabledevicedetection'] = 'Омогућите детекцију уређаја';
$string['enableglobalsearch'] = 'Омогући глобалну претрагу';
$string['enableglobalsearch_desc'] = 'Ако је ова опција укључена подаци ће бити индексирани и синхронизовани помоћу планираног задатка.';
$string['enablegravatar'] = 'Омогући Граватар';
$string['enablegravatar_help'] = 'Када је ова опција омогућена Moodle ће покушати да преузме слику за профил са Граватара, ако корисник није поставио своју слику.';
$string['enablemobilewebservice'] = 'Омогућите веб сервисе за мобилне уређаје';
$string['enablepdfexportfont'] = 'Омогући PDF фонтове';
$string['enablepdfexportfont_desc'] = 'Уколико ваш сајт има курсеве на различитим језицима којима су потребни други фонтови у генерисаним PDF датотекама, можете омогућити опцију подешавања фонта у оквиру општих поставки курса. Морате прво специфицирати који су фонтови расположиви под $CFG->pdfexportfont у датотеци config.php.';
$string['enableplugin'] = 'Омогућите додатак {$a}';
$string['enablerecordcache'] = 'Укључи кеш за запис података';
$string['enablerssfeeds'] = 'Омогући RSS изворе вести';
$string['enablesearchareas'] = 'Омогући области за претрагу';
$string['enablesharingtomoodlenet'] = 'Омогућите дељење на MoodleNet платформи (одлазно)';
$string['enablesharingtomoodlenet_desc'] = 'Омогућите корисницима да деле садржај курса на конфигурисаној MoodleNet инстанци, уколико имају одговарајућу могућност.';
$string['enablestats'] = 'Омогући статистику';
$string['enabletrusttext'] = 'Омогући поуздани садржај';
$string['enableuserfeedback'] = 'Омогући повратне информације о овом софтверу';
$string['enableuserfeedback_desc'] = 'Ако је ова опција омогућена, у подножју се приказује линк \'Пошаљите повратне информације о овом софтверу\' како би корисници могли да дају повратне информације о Moodle софтверу Moodle HQ-у. Ако је подешена опција \'Следећи подсетник за повратне информације\', кориснику се такође приказује подсетник на Контролном панелу у одређеном интервалу. Ако се \'Следећи подсетник за повратне информације\' подеси на \'Никад\', подсетник ће бити онемогућен на Контролном панелу, док ће линк \'Пошаљите повратне информације о овом софтверу\' бити приказан у подножју странице.';
$string['enablewebservices'] = 'Омогући веб сервисе';
$string['enablewsdocumentation'] = 'Документација веб сервиса';
$string['encryptedpassword_edit'] = 'Унеси нову вредност';
$string['encryptedpassword_set'] = '(Подешено и шифровано)';
$string['enroladminnewcourse'] = 'Аутоматски упиши администратора на нове курсеве';
$string['enroladminnewcourse_help'] = 'Када администратор додаје нови курс, да ли га треба аутоматски уписати и доделити му улогу креатора на новим курсевима?';
$string['enrolinstancedefaults'] = 'Подразумеване вредности инстанце уписа';
$string['enrolinstancedefaults_desc'] = 'Подразумевана подешавања уписа у новим курсевима';
$string['enrolmultipleusers'] = 'Уписати кориснике';
$string['entitytasklog'] = 'Евиденција задатака';
$string['environment'] = 'Окружење';
$string['environmenterrortodo'] = 'Морате решити све проблеме окружења (грешке) наведене изнад пре наставка инсталације ове Moodle верзије!';
$string['environmenterrorupgrade'] = 'УПОЗОРЕЊЕ: Потребно је да решити све пронађене проблеме окружења (грешке) пре него што наставите са надоградњом ове верзије Moodlea. Прелазак на нову верзију без исправљања пронађених грешака може довести до проблеме као што је губитак података. Да ли сте сигурни да желите да наставите надоградњу?';
$string['environmentmariadbwrongdbtype'] = 'Погрешан тип базе података  - $CFG->dbtype. Морате променити тип базе у својој config.php датотеци, из \'mysqli\' у \'mariadb\'.';
$string['environmentmustfixsetting'] = 'PHP подешавање мора бити промењено.';
$string['environmentok'] = 'Ваше серверско окружење задовољава све минималне захтеве.';
$string['environmentrecommendcustomcheck'] = 'уколико овај тест не прође, постоји могућност појављивања потенцијалног проблема.';
$string['environmentrecommendinstall'] = 'је препоручљиво инсталирати/омогућити да би се добили најбољи резултати';
$string['environmentrecommendversion'] = 'препоручена верзија је {$a->needed} а ви тренутно користите верзију {$a->current}';
$string['environmentrequirecustomcheck'] = 'Овај тест мора проћи';
$string['environmentrequireinstall'] = 'мора бити инсталиран и омогућен';
$string['environmentrequireversion'] = 'неопходна верзија је {$a->needed} а ви тренутно користите верзију {$a->current}';
$string['environmentsettingok'] = 'детектовано је препоручено подешавање';
$string['environmentshouldfixcustomcheck'] = 'треба омогућити за најбоље резултате';
$string['environmentshouldfixsetting'] = 'PHP подешавање би требало бити промењено.';
$string['environmentxmlerror'] = 'Грешка у читању података окружења ({$a->error_code})';
$string['errordeletingconfig'] = 'Дошло је до грешке приликом брисања конфигурационих записа за додатак \'{$a}\'.';
$string['errorsetting'] = 'Није могуће сачувати подешавање';
$string['errorwithsettings'] = 'Нека подешавања нису промењена због грешке.';
$string['eventshandlersinuse'] = 'Следећи додаци у вашем систему користе Events 1 API, односно застареле процедуре за обраду догађаја: \'{$a}\'. Молимо ажурирајте их да би користили Events 2 API. Погледајте https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Свако ко може \'{$a}\'';
$string['exceptions'] = 'изузеци';
$string['execpathnotallowed'] = 'Подешавање извршних и локалних путања у датотеци config.php је онемогућено';
$string['experimental'] = 'Експериментално';
$string['experimentalsettings'] = 'Експериментална подешавања';
$string['extendedusernamechars'] = 'Дозволити проширени избор знакова у корисничким именима';
$string['extramemorylimit'] = 'Додатно PHP меморијско ограничење.';
$string['fatalsessionautostart'] = '<p>Откривена је озбиљна конфигурациона грешка. Молимо Вас да обавестите администратора.</p><p> Како би функционисао правилно Moodle захтева да администратор промени PHP подешавања.</p>
<p><code>session.auto_start</code> мора бити подешен на <code>off</code>.</p>
<p>Ово подешавање се може променти едитовањем <code>php.ini</code>датотеке, конфигурацијом Apache/IIS севера<br />или <code>.htaccess</code> датотеке на серверу.</p>';
$string['favicon'] = 'Фавиконица';
$string['favicon_desc'] = 'Иконица обележивача се приказује поред нослова странице у картици веб читача. Уколико није дата прилагођена иконица користиће се подразумевана за ову платформу.';
$string['feedbacksettings'] = 'Подешавања повратних информација';
$string['fileconversioncleanuptask'] = 'Чишћење привремених записа за конверзију датотека';
$string['filecreated'] = 'Креирана је нова датотека';
$string['filescleanupperiod'] = 'Очисти датотеке означене као смеће';
$string['filescleanupperiod_help'] = 'Колико често се уклањају датотеке које су означене као смеће. У питању су датотеке везане за контекст који више не постоји, на пример када је курс обрисан. Имајте у виду: ово подешавање може за последицу имати да неке датотеке недостају на курсу који се бекапује, брише а затим рестаурира, ако је подешавање \'Укључи датотеке\' (backup_auto_files) у \'Подешавања за аутоматског креирања резервних копија\' искључено.';
$string['filesizeunits'] = 'јединице мере величине датотека';
$string['filestoredin'] = 'Сними датотеку у директоријум:';
$string['filestoredinhelp'] = 'Где ће датотека бити смештена';
$string['filterall'] = 'Филтрирај све стрингове';
$string['filtermatchoneperpage'] = 'Филтрирај подударање једном по страници';
$string['filtermatchonepertext'] = 'Филтрирај подударање једном по тексту';
$string['filternavigationwithsystemcontext'] = 'Филтрирај навигацију са контекстом система';
$string['filters'] = 'Филтери';
$string['filtersettings'] = 'Управљање филтерима';
$string['filtersettingsgeneral'] = 'Општа подешавања филтера';
$string['filteruploadedfiles'] = 'Филтрирај постављене датотеке';
$string['forceclean'] = 'Чишћење садржаја свуда';
$string['forceclean_desc'] = 'Садржај додат сајту обично се брише пре приказивања, како би се уклониле безбедносне претње. Међутим, садржај се не брише на појединим местима као што су описи активности, ресурс страница или HTML блокови, како би било могуће да на тим местима буду додати скриптови, оквири, мултимедијални садржаји итд. Ако је ова опција омогућена, САВ садржај биће очишћен. Ово може довести до тога да се постојећи садржај више не приказује правилно.';
$string['forcelogin'] = 'Приморај кориснике да се пријаве на систем';
$string['forceloginforprofileimage'] = 'Приморај кориснике да се пријаве на систем да би видели корисничке слике';
$string['forceloginforprofileimage_help'] = 'Ако је ово подешавање омогућено, корисници морају да се пријаве на систем како би могли да виде слике других корисника, а у свим е-порукама ће се користити подразумевана слика кориснка.';
$string['forceloginforprofiles'] = 'Приморај кориснике да се пријаве на систем за да би видели корисничке профиле';
$string['forcetimezone'] = 'Обавезна временска зона';
$string['formatuninstallwithcourses'] = 'Постоји/е {$a->count} курс/а/ева који користе  {$a->format}. Формат ових курсева биће промењен у  {$a->defaultformat} (подразумевани формат за овај сајт). Неки подаци који су специфични за поједине формате могу се изгубити. Да ли сте сигурни да желите да наставите?';
$string['frontpage'] = 'Насловна страница';
$string['frontpagebackup'] = 'Резервна копија насловне странице';
$string['frontpagedefaultrole'] = 'Подразумевана улога за насловну страницу';
$string['frontpagefilters'] = 'Филтери насловне странице';
$string['frontpageloggedin'] = 'Ставке на насловној страници када је корисник пријављен на систем';
$string['frontpageoverrides'] = 'Промене овлашћења на насловној страници';
$string['frontpagequestions'] = 'Питања насловне странице';
$string['frontpagerestore'] = 'Рестаурација насловне странице';
$string['frontpageroles'] = 'Улоге на насловној страници';
$string['frontpagesettings'] = 'Подешавања насловне странице';
$string['fullnamedisplay'] = 'Формат пуног имена';
$string['fullnamedisplayprivate'] = 'Формат пуног имена - приватно';
$string['gdrequired'] = 'Moodle сада захтева GD екстензију за конверзију слика';
$string['generalsettings'] = 'Општа подешавања';
$string['geoipfile'] = 'GeoLite2 City MaxMind база података';
$string['getremoteaddrconf'] = 'Извор забележене IP адресе';
$string['globalsearch'] = 'Глобална претрага';
$string['globalsearchmanage'] = 'Управљање глобалном претрагом';
$string['googlemapkey3'] = 'Google Maps API V3 кључ';
$string['googlemapkey3_help'] = 'Да бисте користили Google Maps за лоцирање IP адресе потребно је да унесете специјални кључ. Кључ можете добити бесплатно на <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Иди на први израз који недостаје';
$string['gradebook'] = 'Евиденција оцена';
$string['gradebookroles'] = 'Улоге које могу да се оцењују';
$string['gradeexport'] = 'Примарни методи за извоз оцена';
$string['gravatardefaulturl'] = 'URL адреса подразумеване Gravatar слике';
$string['gravatardefaulturl_help'] = 'Gravatar тражи подразумевану слику за приказивање, уколико није у могућности да пронађе слику датог корисника. Унесите пуну URL адресу слике. Ако подешавање оставите празно, Moodle ће покушати да употреби подразумевану слику која је најприкладнија за страницу коју посматрате. Имајте на уму да Граватар има низ кôдова који могу да се користе за <a href="https://en.gravatar.com/site/implement/images/#default-image"> генерисање подразумеваних слика </a>.';
$string['groupenrolmentkeypolicy'] = 'Правила за лозинку за упис у групу';
$string['groupenrolmentkeypolicy_desc'] = 'Ако је ова опција омогућена, лозинке за упис у групу биће проверена да ли су у складу са важећим правилима за креирање лозинки као што је то назначено у горе наведеним подешавањима.';
$string['guestroleid'] = 'Улога за госта';
$string['guestroleid_help'] = 'Ова улога се аутоматски додељује госту. Она се додељује привремено и неуписаним корисницима који приступају курсу преко додатка за упис гостију.';
$string['h5pgetcontenttypestask'] = 'Преузимање доступних H5P типова садржаја са h5p.org';
$string['helpadminseesall'] = 'Да ли у календару сајта администратори виде и филтрирају догађаје из календара свих курсева или само оних на које се уписани? Без обзира на изабрану опцију администратори ће увек моћи да управаљају догађајима за сваки календар курса, тако што ће прво отићи на сам курс, а онда директно приступити његовом календару.';
$string['helpcalendarcustomexport'] = 'Омогући опцију за прилагођени временски оквир у извозима календара. Претходно морају бити омогућени извози календара, како би ова опција била могућа.';
$string['helpexportlookahead'] = 'Колико дана унапред ће календар тражити дешавања приликом извоза, за опцију прилагођеног извоза?';
$string['helpexportlookback'] = 'Колико дана уназад ће календар тражити дешавања приликом извоза, за опцију прилагођеног извоза?';
$string['helpforcetimezone'] = 'Можете дозволити корисницима да сами изаберу временску зону, или их приморати да користе ону коју сте Ви изабрали.';
$string['helpshowicalsource'] = 'Ако је ова опција омогућена, назив претплате и линк биће приказани за iCal-увезене догађаје.';
$string['helpsitemaintenance'] = 'За надоградње и остале послове одржавања система';
$string['helpstartofweek'] = 'Којим даном започиње седмица у календару?';
$string['helpupcominglookahead'] = 'Колико дана унапред ће календар тражити предстојећа дешавања?';
$string['helpupcomingmaxevents'] = 'Колико се (максимално) наредних догађаја приказује корисницима?';
$string['helpweekenddays'] = 'Који дани у седмици се сматрају викендом и приказују у другој боји?';
$string['hiddenuserfields'] = 'Сакривање корисничких поља';
$string['hidefromall'] = 'Сакриј од свих корисника';
$string['hidefromnone'] = 'Не сакривати';
$string['hidefromstudents'] = 'Сакриј од полазника';
$string['hostname'] = 'Назив рачунара домаћина';
$string['htmleditor'] = 'HTML едитор';
$string['htmleditorsettings'] = 'Подешавања HTML едитора';
$string['htmlsettings'] = 'HTML подешавања';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP безбедност';
$string['iconvrequired'] = 'Потребно је инсталирати ICONV екстензију.';
$string['igbinary322buggyversion'] = 'Екстензија php-igbinary инсталиран на сајту може довести до проблема када се покреће са PHP 7.2 верзијом. Препоручује се, или да надоградите екстензију на php-igbinary 3.2.5 или новију верзију, или, алтернативно, да инсталирате  PHP 7.3 или новију верзију.';
$string['ignore'] = 'Игнориши';
$string['includemoduleuserdata'] = 'Укључи податке корисника модула';
$string['incompatibleblocks'] = 'Некомпатибилни блокови';
$string['incompleteunicodesupport'] = 'Тренутно подешавање MySQL или MariaDB базе података користи \'utf8\' кодни распоред. Овај скуп знакова не подржава четворобајтне знакове, који укључују неке емотиконе. Покушај коришћења ових знакова довешће до грешке приликом ажурирања записа, и све информације које се шаљу у базу података биће изгубљене. Размотрите могућност промене подешавања кодног распореда у \'utf8mb4\'. Погледајте документацију за више информација.';
$string['indexdata'] = 'Индексирај податке';
$string['indexinginfo'] = 'Препоручени начин индексирања садржаја вашег сајта је коришћењем планираног задатка "Индексирање за глобалну претрагу".';
$string['installhijacked'] = 'Инсталација мора бити завршена са оригиналне IP адресе.';
$string['installsessionerror'] = 'Није могуће започети PHP сесију. Проверите да ли ваш веб читач прихвата колачиће.';
$string['intlrecommended'] = 'Intl екстензија се користи за унапређење интернационалне подршке, као што је сортирање према правилима локалног језика.';
$string['intlrequired'] = 'Intl екстензија је неопходна за побољшање подршке интернационализацији, као што су називи међународних домена и сортирање у складу са правописом локалног језика.';
$string['invalidagedigitalconsent'] = 'Дигитални узраст за сагласност није валидан: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL адреса за заборављену лозинку није исправна.';
$string['invalidsection'] = 'Неисправна секција';
$string['invalidthemepreset'] = 'Изабрана унапред постављена датотека није компатибилна са овом темом. SCSS грешка компајлирања: "{$a}"';
$string['invaliduserchangeme'] = 'Корисничко име "changeme" је резервисано -- не можете креирати налог са тим именом.';
$string['ipblocked'] = 'Овај сајт тренутно није доступан.';
$string['ipblocker'] = 'Блокер IP адреса';
$string['ipblockersyntax'] = 'Један запис по једном реду. Исправни записи су или пуне IP адресе (нпр. <b>192.168.10.1<b>), које које одговарају једном серверу; или делимичне адресе (нпр. <b>192.168.</b>), које одговарају сви рачунарима чија IP адреса почиње тим бројевима; или CIDR нотације (нпр. <b>231.54.211.0/20</b>); или опсег IP адреса (нпр. <b>231.3.56.10-20</b>) где опсег одговара последњем делу адресе. Словима написани домени (нпр. \'example.com\') нису подржани. Празни редови и текст који следи знака"#" биће занемарени.';
$string['iplookup'] = 'Тражење IP адресе';
$string['iplookupgeoplugin'] = '<a href="https://www.geoplugin.com">geoPlugin</a> сервис се тренутно користи за проналажење географских информација. За прецизније резултата предлажемо вам да инсталирате локалну копију MaxMind GeoLite базе података.';
$string['iplookupinfo'] = 'Како би се лоцирала IP адреса стандардно се користи бесплатан онлајн NetGeo сервер. Нажалост, ова база података се више не одржава па се може десити да добијете погрешне податке. Препоручује се да инсталирате локалну копију бесплатне GeoLite2 City базе података компаније MaxMind.<br />
Ако је обезбеђен Google Maps API V3 кључ, локација IP адресе се приказује коришћењем апликације Google Maps. Да бисте добили Google Maps API кључ морате имати Google налог Ако није наведен Google Maps API V3 кључ, локација IP адресе се приказује помоћу географске базе података OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Овај производ укључује GeoLite2 податке креиране од стране MaxMind компаније, који је доступан на <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Откривено је да ваш сајт користи прилагођени администраторски директоријум. Ова функција више није подржана и биће уклоњена након верзије Моодлеа 4.2.';
$string['ishttpswarning'] = 'Откривено је да ваш сајт није безбедан јер не користи HTTPS протокол. Топло се препоручује да мигрирате свој сајт на HTTPS како бисте повећали безбедност и унапредили интеграцију са другим системима.';
$string['keeptagnamecase'] = 'Задржати велика и мала слова ознака (тагова)';
$string['lang'] = 'Подразумевани језик';
$string['langcache'] = 'Кеширај језички мени';
$string['langcache_desc'] = 'Кеширај језички мени. Ако је ово подешавање омогућено, списак доступних превода се кешира. Кеш меморија се аутоматски освежава када инсталирате или обришете језички пакете помоћу уграђеног алата за управљање језичким пакетима. Ако ручно инсталирате нови пакет, морате да употребите наредбу "Очистите све кеш меморије" како бисте освежили кеширану листу језичких пакета.';
$string['langlist'] = 'Језици на језичком менију';
$string['langmenu'] = 'Прикажи језички мени';
$string['langmenuinsecurelayout'] = 'Прикажи језички мени у безбедном приказу странице';
$string['langmenuinsecurelayout_desc'] = 'Ако је ова опција омогућена, корисник ће моћи да промени језик када покушава да решава тест или неку другу активност користећи безбедни приказ странице.';
$string['langpackwillbeupdated'] = 'Напомена: У току надоградње Moodle ће покушати да ажурира ваше језичке пакете.';
$string['langstringcache'] = 'Кеширај све језичке стрингове';
$string['languagesettings'] = 'Језичка подешавања';
$string['latinexcelexport'] = 'Excel кодирање';
$string['legacyfilesaddallowed'] = 'Дозволи додавање наслеђеним датотекама';
$string['legacyfilesaddallowed_help'] = 'Ако курс има старе наслеђене датотеке, дозволите да им буду додате нове датотеке и директоријуми.';
$string['legacyfilesinnewcourses'] = 'Наслеђене датотеке курса у новом курсу';
$string['legacyfilesinnewcourses_help'] = 'Стандардно, простори за наслеђене датотеке курсева су доступни само у надограђеним курсевима. Имајте у виду да поједина својства, попут креирања и рестаурирања резервне копије нису компатибилне са овим подешавањем.';
$string['libcurlwarning'] = 'Откривено је да Libcurl нема подршку за CURLOPT_PROTOCOL. Препоручује се да инсталирате најновију libcurl верзију из безбедносних разлога.';
$string['licensesettings'] = 'Подешавања лиценце';
$string['linkadmincategories'] = 'Прикажи администраторске категорије као линкове';
$string['linkadmincategories_help'] = 'Ако је ово подешавање омогућено, категорије, унутар администраторског блока за подешавања, бићe приказане као линкови и повезане са страницама  одговарајућих администраторских категорија.';
$string['linkcoursesections'] = 'Увек линкуј секције курса';
$string['linkcoursesections_help'] = 'Увек се потрудите да дате линк за секције курса. Секције курса се обично приказују као линкови само ако формат курса приказује једну секцију по страници. Ако је ово подешавање омогућено линк ће увек бити приказан.';
$string['loading'] = 'Учитавање';
$string['localetext'] = 'Локални текст на нивоу сајта';
$string['localstringcustomization'] = 'Прилагођавање локалних стрингова';
$string['location'] = 'Локација';
$string['locationsettings'] = 'Подешавања локације';
$string['locked'] = 'Закључано';
$string['lockoutduration'] = 'Период у ком је налог закључан';
$string['lockoutduration_desc'] = 'Закључани налог се аутоматски откључава.након што истекне овај временски период';
$string['lockoutemailbody'] = 'Ваш налог са корисничким именом {$a->username} на сајту \'{$a->sitename}\' је закључан након вишеструких неисправних покушаја пријаве на систем.

Да бисте откључали налог одмах идите на следећу адресу

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['lockoutemailsubject'] = 'Ваш налог на сајту {$a} је закључан';
$string['lockouterrorunlock'] = 'Добављена је неисправна информација за откључавање налога.';
$string['lockoutthreshold'] = 'Праг закључавања налога';
$string['lockoutthreshold_desc'] = 'Изаберите број неуспешних покушаја пријаве на систем који ће довести до закључавања налога. Ова функција може бити злоупотребљена у нападима ускраћивањем услуга (DoS - denial of service).';
$string['lockoutwindow'] = 'Време праћења за закључавање налога';
$string['lockoutwindow_desc'] = 'Време праћења за праг закључавања – уколико нема неуспешних покушаја пријаве на систем бројач прага закључавања се ресетује након овог временског периода.';
$string['lockrequestcategory'] = 'Спречи избор категорије';
$string['log'] = 'Записи о активностима';
$string['logguests'] = 'Бележи приступе гостију';
$string['logguests_help'] = 'Ово подешавање омогућава бележење активности од стране гостију, као и корисника који нису пријављени на систем. Ако ваш сајт има велики број корисника можда ћете желети да искључите ово подешавање због бољих перформанси. Препоручљиво је да ово подешавање држите укључено на продукционим сајтовима.';
$string['logininfoinsecurelayout'] = 'Прикажи пријављеног корисника у безбедном приказу странице';
$string['logininfoinsecurelayout_desc'] = 'Ако је ова опција омогућена, пуно име пријављеног корисника биће приказано у навигационој траци приликом отварања теста или неке друге активности коришћењем безбедног приказа странице.';
$string['loginpageautofocus'] = 'Образац са аутофокусирајућим пољима на страници за пријављивање';
$string['loginpageautofocus_help'] = 'Укључивањем ове опције повећава се употребљивост странице за пријављивање, али аутоматски фокусирајућа поља могу представљати проблем приступачности свим корисницима, нарочито онима са посебним потребама.';
$string['loglifetime'] = 'Чувај записе';
$string['logo'] = 'Лого';
$string['logo_desc'] = 'Пун логотип који ће као украс користити неке графичке тема (као што су главне теме). Ова слика може бити прилично високе резолуције, пошто ће бити умањена за коришћење (и кеширана због бољих перформанси система). Логотипови чија је ширина већа од њихове висине обично дају боље резултате.';
$string['logocompact'] = 'Компактан лого';
$string['logocompact_desc'] = 'Компактна верзија истог, претходно подешеног логотипа, као што је грб, штит или иконица. Слика треба да буде јасна чак и на малим величинама.';
$string['logossettings'] = 'Логотипи';
$string['logstorenotrequired'] = 'Складиште записа није потребно';
$string['logstoressupported'] = 'Складиште записа које подржава овај извештај';
$string['longtimewarning'] = '<b>Молимо вас да узмете у обзир да овај процес може потрајати</b>';
$string['mailnewline'] = 'Ознаке за нови ред у електронским порукама';
$string['maintenancemode'] = 'У режиму одржавања';
$string['maintenancemodeisscheduled'] = 'Сајт се пребацује у режиму одржавања за {$a->min} мин. {$a->sec} сек.';
$string['maintenancemodeisscheduledlong'] = 'Овај сајт ће бити пребачен у режим одржавања за {$a->hour} сат/а/и {$a->min} мин. {$a->sec} сек.';
$string['maintfileopenerror'] = 'Грешка при отварању датотека за одржавање!';
$string['maintinprogress'] = 'Одржавање је у току...';
$string['managecontextlock'] = 'Замрзни овај контекст';
$string['managecontextlocklocked'] = '{$a->contextname} и сви нижи контекст сада су замрзнути.';
$string['managecontextlockunlocked'] = '{$a->contextname} и сви нижи контекст сада су одмрзнути.';
$string['managecontextunlock'] = 'Одмрзни овај контекст';
$string['managecustomfields'] = 'Управљање прилагођеним пољима курса';
$string['manageformats'] = 'Управљање форматима курса';
$string['manageformatsgotosettings'] = 'Подразумевани формат може бити промењен у {$a}';
$string['managelang'] = 'Управљање';
$string['manageqbanks'] = 'Управљање додацима за банку питања';
$string['manageqbehaviours'] = 'Управљање понашањима питања';
$string['manageqtypes'] = 'Управљање типовима питања';
$string['maturity100'] = 'Бета верзија';
$string['maturity150'] = 'RC (Release candidate) верзија';
$string['maturity200'] = 'Стабилна верзија';
$string['maturity50'] = 'Алфа верзија';
$string['maturityallowunstable'] = 'Савет: Можда ћете желети да покренете ову скрипту са опцијом --allow-unstable option';
$string['maturitycoreinfo'] = 'Ваш сајт тренутно покреће нестабилни "{$a}" развојни кôд.';
$string['maturitycorewarning'] = 'Верзија Moodlea коју намеравате да инсталирате или надоградите садржи нестабилан "{$a}" развојни кôд који није погодан за коришћење на већини продукционих сајтова.  Ако то није оно што сте желели  онда би требало да проверите  да ли за ажурирање користите СТАБИЛНУ верзију кôда. Погледајте Moodle документацију за више информација.';
$string['maxbytes'] = 'Максимална величина постављене датотеке';
$string['maxconsecutiveidentchars'] = 'Узастопни идентични знакови';
$string['maxeditingtime'] = 'Максимално време за уређивање порука';
$string['maxsizeperdownloadcoursefile'] = 'Максимална величина по датотеци';
$string['maxsizeperdownloadcoursefile_desc'] = 'Максимална величина сваке датотеке приликом преузимања садржаја курса. Датотеке које су веће од ове величине биће изостављене из преузимања.';
$string['maxtimelimit'] = 'Максимално временско ограничење';
$string['maxtimelimit_desc'] = 'Да бисте ограничили максимално време извршавања PHP-a које ће Moodle дозволити пре него што било шта буде приказано, унесите овде вредност у секундама . Вредност 0 значи да се користе стандардна Moodle ограничења. Ако имате сервер са сопственим временским ограничењем, смањите ову вредност како би PHP грешке биле евидентиране. Ово се не односи на CLI скрипте.';
$string['maxusersperpage'] = 'Максималан број корисника по страници';
$string['mbstringrecommended'] = 'Инсталирање опционе MBSTRING библиотеке је врло препоручљиво због унапређивања перформанси сајта, поготово ако ваш сајт подржава језике који не користе латинично писмо.';
$string['mbstringrequired'] = 'Инсталација библиотеке MBSTRING је неопходна ради унапређивања перформанси сајта, посебно ако ваш сајт подржава нелатиничне језике.';
$string['mediapluginavi'] = 'Омогући .avi филтер';
$string['mediapluginflv'] = 'Омогући .flv филтер';
$string['mediapluginimg'] = 'Омогући аутоматско уметање линкованих слика';
$string['mediapluginmov'] = 'Омогући .mov филтер';
$string['mediapluginmp3'] = 'Омогући .mp3 филтер';
$string['mediapluginmpg'] = 'Омогући .mpg филтер';
$string['mediapluginogg'] = 'Омогући .ogg филтер';
$string['mediapluginogv'] = 'Омогући .ogv филтер';
$string['mediapluginram'] = 'Омогући .ram филтер';
$string['mediapluginrm'] = 'Омогући .rm филтер';
$string['mediapluginrpm'] = 'Омогући .rpm филтер';
$string['mediapluginswf'] = 'Омогући .swf филтер';
$string['mediapluginswfnote'] = 'Као подразумевану меру безбедности, обичним корисницима не треба дозволити да умећу swf flash датотеке.';
$string['mediapluginwmv'] = 'Омогућити .wmv филтер';
$string['mediapluginyoutube'] = 'Омогући филте за YouTube линкове';
$string['messaging'] = 'Омогући систем за слање порука';
$string['messagingallowemailoverride'] = 'Измена е-адресе за слање обавештења';
$string['messagingallusers'] = 'Омогућите слање порука на нивоу сајта';
$string['messagingcategory'] = 'Слање порука';
$string['messagingdefaultpressenter'] = 'Подразумевано пошаљи притиском на тастер Enter';
$string['messagingdeleteallnotificationsdelay'] = 'Обришите све обавештења';
$string['messagingdeletereadnotificationsdelay'] = 'Обриши обавештење о прочитаним порукама';
$string['messagingssettings'] = 'Подешавања за слање порука';
$string['minpassworddigits'] = 'Бројеви';
$string['minpasswordlength'] = 'Дужина лозинке';
$string['minpasswordlower'] = 'Мала слова';
$string['minpasswordnonalphanum'] = 'Не-алфанумерички знакови';
$string['minpasswordupper'] = 'Велика слова';
$string['misc'] = 'Разно';
$string['mlbackendsettings'] = 'Позадинска подешавања машинског учења';
$string['mnetrestore_extusers'] = '<strong>Напомена:</strong> Ова резервна копија садржи удаљене корисничке налоге из одговарајуће Moodle мреже. Ти налози ће током овог процеса такође бити рестаурирани.';
$string['mnetrestore_extusers_admin'] = '<strong>Напомена:</strong> Изгледа да је ова датотека резервне копије креирана на некој другој Moodle инсталацији и да садржи корисничке налоге удаљене Moodle Мреже. Процес рестаурације ће покушати да усклади хостове Moodle Мреже за све кориснике. Оне корисници, за које то не успе, аутоматски ће бити пребачени на интерну проверу идентитета (уместо mnet). Запис о рестаурацији ће Вас информисати о томе.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Напомена!</strong> Ова резервна копија очигледно потиче са неке друге Moodle инсталације и садржи корисничке налоге удаљене Moodle Мреже који се можда неће успешно рестаурирати. Ова операција није подржана. Ако сте сигурни да је архива креирана на овој Moodle инсталацији, или можете да потврдите да су сви потребни хостови у вашој Moodle мрежи  конфигурисани, можда ћете ипак желети да покушате рестаурацију.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Напомена:</strong> Изгледа да је ова дадотека резервне копије креирана на некој другој Moodle инсталацији и да садржи корисничке налоге удаљене Moodle Мреже. Није Вам дозвољено да извршавате овај тип рестаурирања. Контактирајте администратора овог сајта или, алтернативно, рестаурирајте овај курс без било какве информације о кориснивима (модули, датотеке...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Удаљени корисник Moodle Мреже {$a->username} (који долази са {$a->mnethosturl}) пребачен је на локалног {$a->auth} ауторизованог корисника.';
$string['mobilenotconfiguredwarning'] = 'Moodle апликација није омогућена';
$string['modassignmentinuse'] = 'Ваш сајт још увек користи додатак Задатак 2.2. Пре надоградње морате да 1) направити резервну копију свих активности Задатка 2.2 које желите да задржите и рестаурирати их као активности новог модула Задатак, и 2) обришете све податке везане за модул Задатак 2.2 у бази података.';
$string['modassignmentsubpluginsexist'] = 'Могуће да је присутан стари модул Задатак 2.2 (Assignment 2.2). Потребно је, пре надоградње, уклонити директоријум mod/assignment и све његове (под)додатке';
$string['modchooserdefault'] = 'Подразумевани статус бирача активности';
$string['modeditdefaults'] = 'Подразумеване вредности за подешавања активности';
$string['modsettings'] = 'Управљање активностима';
$string['modulesecurity'] = 'Безбедност модула';
$string['moodleapp'] = 'Moodle апликација';
$string['moodleapp_help'] = '<p>Бесплатна Moodle апликација омогућава корисницима да приступе својим курсевима путем мобилних уређаја. Додатне функције апликације су доступне са Pro или Premium пакетом за коришћење апликације.</p>
<a href="https://moodle.com/mobile-app">Преузмите Moodle апликацију</a><br />
<a href="https://apps.moodle.com">Портал Moodle апликације</a>';
$string['moodlebrandedapp'] = 'Брендирана Moodle апликација';
$string['moodlebrandedapp_help'] = '<p>Брендирана Moodle апликација има све функционалности наше бесплатне мобилне апликације за Moodle у комбинацији са вашим властитим прилагођеним брендом.</p>
<a href="https://moodle.com/branded-app">О брендираној Moodle апликацији</a>';
$string['moodlebrandedappreference'] = 'Алтернативно, можете да добијете<a href="https://moodle.com/branded-app/">Брендирану Moodle апликацију</a> са сопственим прилагођеним брендом.';
$string['moodlepartners'] = 'Moodle партнери';
$string['moodlepartners_help'] = 'Moodle партнери су пружаоци услуга овлашћени од стране Moodle HQ-а за пружање високо квалитетних Moodle сервиса за учење у онлајн окружење у вашој организацији/институцији. </p>
<a href="https://moodle.com/about-partners/">О нашим партнерима</a><br />
<a href="https://moodle.com/partners">Пронађите партнера</a>';
$string['moodleservices'] = 'Moodle сервиси';
$string['moodleservices_help'] = 'Побрините се да добијете најбоље од свог Moodle окружења за учење помоћу ових Moodle сервиса:';
$string['multilangforceold'] = 'Инсистирати на старој вишејезичкој синтакси: &lt;span&gt; без class="multilang" и &lt;lang&gt;';
$string['mustenablestats'] = 'Статистика још није омогућена на овом сајту.';
$string['mycourses'] = 'Моји курсеви';
$string['mycoursesperpage'] = 'Број курсева';
$string['mydashboard'] = 'Подразумевани контролни панел система';
$string['mymoodle'] = 'Контролни панел';
$string['mymoodleredirect'] = 'Приморај кориснике да користе Мој Moodle';
$string['mypage'] = 'Подразумевана страница \'Контролни панел\'';
$string['mypagelocked'] = 'Закључај подразумевану страницу';
$string['myprofile'] = 'Подразумевана страница профила';
$string['navadduserpostslinks'] = 'Додај линкове за приказ корисничких порука';
$string['navadduserpostslinks_help'] = 'Ако је ово подешавање омогућено, сваком кориснику ће у блоку за навигацију бити додата два линка, један за приказ дискусија које је корисник започео и други за приказ порука које је поставио на форумима широм сајта или на одређеним курсевима.';
$string['navcourselimit'] = 'Број курсева';
$string['navigationupgrade'] = 'Ова надоградња уводи два нова блока за навигацију који ће заменити следеће блокове: Администрација, Курсеви, Активности и Учесници. Ако сте претходно доделили нека посебна овлашћења у овим блоковима, требало би да проверите да ли се све догађа онако како желите.';
$string['navshowallcourses'] = 'Прикажи све курсеве';
$string['navshowcategories'] = 'Прикажи категорије курсева';
$string['navshowfrontpagemods'] = 'Прикажи активности на насловној страници сајта у навигацији';
$string['navshowfrontpagemods_help'] = 'Ако је ово подешавање омогућено, активности на насловној страници сајта биће приказане у навигације под ставком \'Странице сајта\'. Ово подешавање се односи само на теме засноване на теми Classic.';
$string['navshowfullcoursenames'] = 'Прикажи пуне називе курсева';
$string['navshowfullcoursenames_help'] = 'Ако је ова опција омогућена, у навигацији ће уместо скраћених бити приказани пуни називи курсева';
$string['navshowmycoursecategories'] = 'Прикажи категорије мојих курсева';
$string['navshowmycoursecategories_help'] = 'Ако је ово подешавање омогућено, курсеви ће бити приказани корисницима у блоку за навигацију под ставком \'Моји курсеви\', као гране одговарајућих категорија (само код графичких тема које се базирају на теми Classic).';
$string['navsortmycourseshiddenlast'] = 'Сортирај моје скривене курсеве као последње';
$string['navsortmycourseshiddenlast_help'] = 'Ако је омогућено, сви скривени курсеви биће увршћени после видљивих курсева (за кориснике које могу да виде скривене курсеве). Иначе, сви курсеви, без обзира на видљивост, биће увршћени у складу са подешавањем \'Сортирај моје курсеве\'.';
$string['navsortmycoursessort'] = 'Редослед курсева у блоку за навигацију';
$string['navsortmycoursessort_help'] = 'Да ли курсеви унутар ставке \'Моји курсеви\', у блоку за навигацију, треба да буду поређани према редоследу сортирања (тј. редоследу који је подешен у Администрација сајта > Курсеви > Управљање курсевима и категоријама) или алфабетски према подешавању курса. Ово подешавање се односи само на теме које су базирају на теми Classic.';
$string['never'] = 'Никада';
$string['neverdeleteruns'] = 'Никада не бриши покретања';
$string['newestdocindexed'] = 'Најновији индексирани документ';
$string['nobookmarksforuser'] = 'Немате постављених обележивача.';
$string['nodatabase'] = 'Нема базе података';
$string['nohttpsformobilewarning'] = 'Препоручује се да омогућите HTTPS протокол са важећим сертификатом. Moodle апликација ће увек прво покушати да користи безбедну конекцију.';
$string['nomissingstrings'] = 'Нема недостајућих израза';
$string['none'] = 'Нико';
$string['nonewsettings'] = 'Није додато ниједно ново подешавање током овог ажурирања.';
$string['nonexistentbookmark'] = 'Тражени обележивач не постоји.';
$string['noreplyaddress'] = 'Е-адреса "не-одговарај"';
$string['noreplydomain'] = 'Е-адреса "не-одговарај" и домен';
$string['noreplydomaindetail'] = 'Подешавања за е-адресу "не-одговарај" и конфигурисане домене';
$string['noresults'] = 'Нема резултата';
$string['noroles'] = 'Нема улога';
$string['nosupportedlogstore'] = 'Није пронађено подржано складиште записа';
$string['noteunneededblocks'] = 'Напомена! Блокови који су подешени да се приказују неће бити наведени у менију \'Додај блок\' на курсу ако су наведени у подешавању теме \'Непотребни блокови\'.';
$string['notifications'] = 'Обавештења';
$string['notifyloginfailures'] = 'Послати извештај о неуспешним приступима систему кориснику';
$string['notifyloginthreshold'] = 'Гранична вредност за обавештења е-поштом';
$string['notloggedinroleid'] = 'Улога за посетиоце';
$string['numberofmissingstrings'] = 'Број недостајућих стрингова: {$a}';
$string['numberofstrings'] = 'Укупан број стрингова: {$a->strings}<br />Недостаје: {$a->missing} ({$a->missingpercent} %)';
$string['oauthrefreshtokenexpired'] = 'Токен освежавања за један од OAuth сервиса {$a->issuer} на вашем сајту {$a->siteurl} је истекао. Ово ће ограничити функционалност додатака који користе овај сервис. Како бисте решили овај проблем посетите страницу за конфигурисање OAuth 2 сервиса и кликните на иконицу "Connect system account" у реду табеле у ком се налази овај сервис. Проверите да ли приликом пријаве, сваки пут, користите исти налог за OAuth систем.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth токен освежавања је истекао за {$a->issuer} на вашем сајту {$a->siteurl}.';
$string['onlynoreply'] = 'Само када се шаље са е-адресе "не-одговарај"';
$string['opcacherecommended'] = 'Кеширање PHP оперативног кôда побољшава перформансе и смањује меморијске захтеве. OPcache екстензија се препоручује и у потпуности је подржана.';
$string['opensslrecommended'] = 'Инсталирање опционе OpenSSL библиотеке је врло препоручљиво -- она омогућава коришћење функција за умрежавање.';
$string['opensslrequired'] = 'OpenSSL PHP екстензија је сада обавезна да би Moodle могао да обезбеди јаче криптографске услуге.';
$string['opentowebcrawlers'] = 'Отворено за претраживаче';
$string['optionalmaintenancemessage'] = 'Опциона порука у току одржавања система';
$string['oracledatabaseinuse'] = 'Подршка за базу података Oracle DB ће бити уклоњена. Moodle верзија 4.5 ће бити последња која подржава ову базу података. Додатне информације се могу наћи <a href="https://moodle.org/mod/forum/discuss.php?d=456122">овде</a>';
$string['order1'] = 'Први';
$string['order2'] = 'Други';
$string['order3'] = 'Трећи';
$string['order4'] = 'Четврти';
$string['outgoingmailconfig'] = 'Конфигурација одлазне поште';
$string['overridetossl'] = 'HTTP протокол се више не може користити за пријаву на систем. Ова инстанца мора да користи SSL. Да бисте уклонили упозорење, подесите ставку wwwroot у config.php датотеци  на https: //.';
$string['pageinfodebugsummary'] = 'Ова страница је: {$a}';
$string['passwordchangelogout'] = 'Одјава након промене лозинке';
$string['passwordchangelogout_desc'] = 'Ако је ова опција омогућена, када се промени лозинка све сесије веб читача се прекидају, изузев оне у којој је сачувана нова лозинка. (Ово подешавање не утиче на промене лозинки путем масовног постављања корисника.)';
$string['passwordchangetokendeletion'] = 'Уклони токене за приступ веб сервисима након промене лозинке';
$string['passwordchangetokendeletion_desc'] = 'Ако је ова опција омогућена, сви токени за приступ веб сервисима се бришу када се промени лозинка.';
$string['passwordpolicy'] = 'Правила за креирање лозинке';
$string['passwordpolicycheckonlogin'] = 'Провери лозинку приликом пријаве';
$string['passwordresettime'] = 'Максимално време за потврду захтева за ресетовање лозинке.';
$string['passwordreuselimit'] = 'Ограничење ротације лозинке';
$string['passwordreuselimit_desc'] = 'Број пута колико корисници морају да промени своју лозинку пре него што им буде дозвољено да поново употребе стару лозинку. Хеш вредности претходних лозинки се чувају у локалној табели базе података. Ово својство можда неће бити компатибилна са неким екстерним додацима за проверу идентитета.';
$string['pathtodot'] = 'Путања до dot';
$string['pathtodot_help'] = 'Путања до dot. На Linux платформама нешто попут /usr/bin/dot. На Windows системима нешто попут C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. На Mac системима нешто као /opt/local/bin/dot. Да бисте могли да генеришете слике из DOT датотека морате имати инсталиран извршни dot и овде задати путању до њега.';
$string['pathtodu'] = 'Путања до du алата';
$string['pathtogs'] = 'Путања до ghostscriptа';
$string['pathtogs_help'] = 'На већини Linux инсталација, ово се може оставити као \'/usr/bin/gs\'. На Windows инсталацији ове ће бити нешто попут \'c:\\gs\\bin\\gswin32c.exe\' (проверите да нема размака у путањи - ако је потребно копирајте датотеке \'gswin32c.exe\' и \'gsdll32.dll\' у нови директоријум без размака у путањи)';
$string['pathtopdftoppm'] = 'Путања до pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> је библиотека за растеризацију PDF докумената, која укључује алат \'pdftoppm\' за конверзију PDF датотека у PNG слике. Перформансе су генерално боље него када користите Ghostscript, посебно када се конвертују велике датотеке. Ако је алат присутан, за овај задатак ће се уместо \'Ghostscripta\' користити \'pdftoppm\'. На већини Linux инсталација ова се путања може оставити да буде нешто попут \'/usr/bin/pdftoppm\'. У супротном, морате инсталирати poppler-utils или poppler package, у зависности од Linux дистрибуције. На Windows оперативном систему алат \'pdftoppm\' ће учинити доступним Cygwin инсталације.

За више информација погледајте <a href="https://poppler.freedesktop.org/" target="_blank">Poppler пројекат</a>';
$string['pathtopgdump'] = 'Путања до pg_dump';
$string['pathtopgdumpdesc'] = 'Ово је неопходно унети само ако имате више од једног pg_dumpa на свом систему (на пример ако сте инсталирали више од једне верзије postgresqla)';
$string['pathtopgdumpinvalid'] = 'Путања до pg_dump-a није валидна - или је путања погрешна или није извршива';
$string['pathtophp'] = 'Путања до PHP CLI';
$string['pathtopsql'] = 'Путања до psql';
$string['pathtopsqldesc'] = 'Ово је неопходно унети само ако имате више од једног psqla на свом систему (на пример ако сте инсталирали више од једне верзије postgresqla)';
$string['pathtopsqlinvalid'] = 'Путања до psql-a није валидна - или је путања погрешна или није извршива';
$string['pathtopython'] = 'Путања за Python';
$string['pathtopythondesc'] = 'Путања до ваше извршне Python бинарне датотеке (прихватају се и Python 2 и Python 3 датотеке).';
$string['pathtosassc'] = 'Путања до SassC';
$string['pathtosassc_help'] = 'Специфицирање локације SassC бинарне датотеке ће пребацити SASS компајлер из Moodle-ове PHP имплементације на SassC. Погледајте https://github.com/sass/sassc за више информација.';
$string['pcreunicodewarning'] = 'Строго се препоручује да користите PCRE PHP екстензију који је компатибилна са Unicode сетом знакова.';
$string['perfdebug'] = 'Информације о извршавању';
$string['performance'] = 'Перформансе';
$string['pgcluster'] = 'PostgreSQL кластер';
$string['pgclusterdescription'] = 'Параметар PostgreSQL верзије/кластера за операције командне линије. Ако имате само један postgresql на свом систему или нисте сигурни шта ово подешавање представља, оставите поље празно.';
$string['phpfloatproblem'] = 'Отркривен је неочекивани проблем у обради PHP бројева са покретним зарезом - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Ваш сајт је регистрован. Регистрација је последњи пут ажурирана  {$a}.<br /> Планирани задатак \'Регистрација сајта\' омогућава да ваша регистрација буде ажурна. Такође, можете сами ручно да ажурирате своју регистрацију у било ком тренутку.';
$string['pleaserefreshregistrationnewdata'] = 'Подаци о регистрацији су промењени. Потврдите промене помоћу дугмета \'Ажурирај регистрацију\'.';
$string['pleaserefreshregistrationunknown'] = 'Ваш сајт је регистрован али je датум регистрације непознат. Молимо вас да ажурирате своју регистрацију помоћу дугмета \'Ажурирај регистрацију\' или тако што ћете проверити да ли је планирани задатак \'Регистрација сајта\' омогућен тако да се ваша регистрација аутоматски ажурира.';
$string['plugin'] = 'Додатак';
$string['plugin_disabled'] = 'Додатак {$a} је онемогућен.';
$string['plugin_enabled'] = 'Додатак {$a} је омогућен.';
$string['plugins'] = 'Додаци';
$string['pluginscheck'] = 'Провера зависности додатака';
$string['pluginscheckfailed'] = 'Провера зависности није успела за {$a->pluginslist}';
$string['pluginschecktodo'] = 'Морате решити све захтеве додатака пре него што наставите са инсталацијом ове верзије Мoodlea!';
$string['pluginsoverview'] = 'Преглед додатака';
$string['pluginsoverviewsee'] = 'За више информација погледајте страницу <a href="{$a->url}">Преглед додатака</a>.';
$string['policysettings'] = 'Подешавање правила';
$string['privacy:metadata'] = 'Додатак Администрација не чува никакве личне податке.';
$string['privacyandpolicies'] = 'Приватност и правила';
$string['privacysettings'] = 'Подешавања приватности';
$string['profilecategory'] = 'Категорија';
$string['profilecategoryname'] = 'Назив категорије (мора бити јединствен)';
$string['profilecategorynamenotunique'] = 'Овај назив категорије се већ користи';
$string['profilecommonsettings'] = 'Заједничка подешавања';
$string['profileconfirmcategorydeletion'] = 'Постоје {$a}. поља у овој категорији која могу бити померена у категорију изнад (или испод).<br />Да ли желите да обришете ову категорију?';
$string['profileconfirmfielddeletion'] = 'Постоји {$a} корисничких уноса за ово поље који требају бити обрисани.<br />Да ли и даље желите обрисати ово поље?';
$string['profilecreatecategory'] = 'Креирај нову категорију профила';
$string['profilecreatefield'] = 'Креирај ново поље профила';
$string['profilecreatenewcategory'] = 'Креирај нову категорију';
$string['profilecreatenewfield'] = 'Креирање новог поља профила: &quot;{$a}&quot;';
$string['profiledefaultcategory'] = 'Остала поља';
$string['profiledefaultchecked'] = 'Укључено подразумевано';
$string['profiledefaultdata'] = 'Подразумевана вредност';
$string['profiledeletecategory'] = 'Брисање категорије';
$string['profiledeletefield'] = 'Брисање поља \'{$a}\'';
$string['profiledescription'] = 'Опис поља';
$string['profiledscript'] = 'Оваj скрипт је профилисан';
$string['profiledscriptview'] = 'Види информације о профилисању за овaj скрипт';
$string['profileeditcategory'] = 'Уређивање категорије: {$a}';
$string['profileeditfield'] = 'Уређивање поља  профила: {$a}';
$string['profilefield'] = 'Поље профила';
$string['profilefieldcolumns'] = 'Колоне';
$string['profilefieldispassword'] = 'Да ли је ово поље за лозинку?';
$string['profilefieldlink'] = 'Линк';
$string['profilefieldlink_help'] = 'За претварање текста у линк, унесите URL који садржи $$, где ће $$ бити замењен текстом. На пример, да бисте Twitter ID ознаку претворили у линк, упишите https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Одредиште линка';
$string['profilefieldmaxlength'] = 'Ограничење броја знакова';
$string['profilefieldmaxlength_help'] = 'Како бисте користили ово поље у подешавању \'Прикажи идентитет корисника\', ограничење мора бити 255 знакова или мање.';
$string['profilefieldrows'] = 'Редова';
$string['profilefields'] = 'Поља корисничког профила';
$string['profilefieldsize'] = 'Величина поља';
$string['profileforceunique'] = 'Да ли подаци треба да буду јединствени?';
$string['profileinvaliddata'] = 'Неодговарајућа вредност';
$string['profilelocked'] = 'Да ли је ово поље закључано?';
$string['profilemenudefaultnotinoptions'] = 'Подразумевана вредност није у листи опција.';
$string['profilemenunooptions'] = 'Без опција са менијима';
$string['profilemenuoptions'] = 'Мени опције (по једна у линији)';
$string['profilemenutoofewoptions'] = 'Морате понудити бар 2 могућности';
$string['profilename'] = 'Назив';
$string['profilenofieldsdefined'] = 'Није дефинисано ниједно поље';
$string['profilerequired'] = 'Да ли је ово поље обавезно?';
$string['profileroles'] = 'Улоге видљиве у профилу';
$string['profilesforenrolledusersonly'] = 'Профили само за кориснике уписане на курс.';
$string['profileshortname'] = 'Скраћен назив (мора бити јединствен)';
$string['profileshortnameinvalid'] = 'Овај скраћени назив може да садржи само алфанумеричкe знаке (слова и бројеве) или доњу црту (_).';
$string['profileshortnamenotunique'] = 'Овај скраћен назив се већ користи';
$string['profilesignup'] = 'Приказати на страници за пријаву?';
$string['profilespecificsettings'] = 'Специфична подешавања';
$string['profilevisible'] = 'Коме је ово поље видљиво?';
$string['profilevisible_help'] = '* Није видљиво - за личне податке видљиве само администраторима и менаџерима
* Видљиво кориснику - за личне податке видљиве само администраторима и кориснику чију су подаци
* Видљиво кориснику, предавачима и администраторима - за личне податке видљиве само кориснику, администраторима и предавачима (у профилу курсева)
* Видљиво свима';
$string['profilevisibleall'] = 'Видљиво свима';
$string['profilevisiblenone'] = 'Није видљиво';
$string['profilevisibleprivate'] = 'Видљиво кориснику';
$string['profilevisibleteachers'] = 'Видљиво кориснику, предавачима и администраторима';
$string['profiling'] = 'Профилисање';
$string['profilingallowall'] = 'Континуирано профилисање';
$string['profilingallowall_help'] = 'Ако омогућите ово подешавање, онда, у било ком тренутку можете да користите параметар PROFILEALL било где (PGC) како бисте омогућили профилисање за све извршене скрипте током трајања Moodle сесије. Аналогно томе, можете да користите параметар PROFILEALLSTOP како бисте то зауставили.';
$string['profilingallowme'] = 'Селективно профилисање';
$string['profilingallowme_help'] = 'Ако омогућите ово подешавање, онда, селективно, можете да користите параметар PROFILEME било где (PGC) и тај скрипт ће бити профилисан. Аналогно томе, можете да користите параметар DONTPROFILEME како би спречили профилисање.';
$string['profilingautofrec'] = 'Аутоматско профилисање';
$string['profilingautofrec_help'] = 'Конфигурисањем овог подешавања, неки захтеви (насумично одабрани, засновано на учесталости одређеној као 1 од N) биће одабрани и аутоматски профилисани, смештајући резултате за даљу анализу. Имајте на уму да се овај начин профилисања придржава подешавања "искључи/укључи" (include/exclude). Поставите вредност на 0 како бисте онемогућили аутоматско профилисање.';
$string['profilingenabled'] = 'Омогући профилисање';
$string['profilingenabled_help'] = 'Ако омогућите ову подешавање, онда ће профилисање бити доступно на овом сајту и моћи ћете да одредити његово понашање тако што ћете подесити следеће опције.';
$string['profilingexcluded'] = 'Искључи профилисање';
$string['profilingexcluded_help'] = 'Списак URL адреса (одвојених зарезом или новим редом, апсолутних, прескачући wwwroot, које могу бити позване) које ће бити изузетe од профилисања дефинисаног у подешавању \'Профилиши ове\'.';
$string['profilingimportprefix'] = 'Префикс увезених профилисања';
$string['profilingimportprefix_desc'] = 'Ради лакшег откривања, сва увезена покретања профилисања ће добити префиксе са вредношћу која је овде наведена.';
$string['profilingincluded'] = 'Профилиши ове';
$string['profilingincluded_help'] = 'Списак URL адреса (одвојених зарезом или новим редом, апсолутних, прескачући wwwroot, које могу бити позване) које ће бити аутоматски профилисанe. Пример: /index.php, /course/view.php. Такође је прихватљива употреба * џокер ознака на било којој позицији. Пример: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Настави са профилисањем';
$string['profilinglifetime_help'] = 'Одредите колико дуго желите да чувате информације о претходним покретањима профилисања. Старија ће периодично бити одстрањивана. Имајте у виду да ово искључује било које покретање профилисања означенo као "референтно покретање".';
$string['profilingslow'] = 'Профилиши споре странице';
$string['profilingslow_help'] = 'Подешавањем минималног времена, у секундама, биће профилисане све странице које су спорије. Биће задржани само профили који су спорији од постојећег профила за исти скрипт. Подесите на 0 да бисте онемогућили ову опцију. Имајте на уму да се овај начин профилисања придржава подешавања "искључи" (exclude).';
$string['protectusernames'] = 'Заштитити корисничка имена';
$string['proxybypass'] = 'Хостови за премошћење Proxy сервера';
$string['proxyfixunsafe'] = 'Поправите позиве без проксија';
$string['proxyhost'] = 'Proxy домаћин';
$string['proxylogunsafe'] = 'Евидентирајте позиве без проксија';
$string['proxypassword'] = 'Лозинка за прокси сервер';
$string['proxyport'] = 'Proxy порт';
$string['proxytype'] = 'Тип Proxy сервера';
$string['proxyuser'] = 'Корисничко име за Proxy';
$string['purgecaches'] = 'Очистите све кеш меморије';
$string['purgecachesconfirm'] = 'Moodle може да чува у кеш меморији графичке теме, Javascript, језичке стрингове, филтрирани текст, RSS изворе вести и многе друге обрађене података. Брисање кеш меморије ће обрисати те привремено сачуване податке са сервера и тиме приморати веб читач да поново преузмe податке, тако да можете бити сигурни да гледате најновије вредности које је произвео тренутни кôд. Нема никакве опасности у брисању кеш меморије, али ваш сајт може, на тренутак, бити спорији, све док сервер и клијентски програм не генеришу нове информације и поново их сместе у кеш.';
$string['purgecachesfinished'] = 'Све кеш меморије су очишћене.';
$string['purgecachesnoneselected'] = 'Изаберите једну или више кеш меморија да бисте их очистили';
$string['purgecachespage'] = 'Очистите кеш меморије';
$string['purgefiltercache'] = 'Текстуални филтери';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Језички стринг';
$string['purgemuc'] = 'Све MUC кеш меморије';
$string['purgeothercaches'] = 'Све датотеке и различите кеш меморије';
$string['purgeselectedcaches'] = 'Очистите изабране кеш меморије';
$string['purgeselectedcachesfinished'] = 'Изабране кеш меморије су очишћене.';
$string['purgetemplates'] = 'Шаблони';
$string['purgethemecache'] = 'Графичке теме';
$string['query'] = 'Упит';
$string['question'] = 'Питање';
$string['questionbehaviours'] = 'Понашања питања';
$string['questioncwqpfscheck'] = 'Једно или више насумично изабраних питања у тесту подешени су да бирају питања из категорија дељених али и из категорија недељених питања. Погледајте <a href="{$a->reporturl}">извештај о насумичним питањима</a> и <a href="{$a->docsurl}">документацију</a>.';
$string['questioncwqpfsok'] = 'У реду. Нема \'насумично изабраних\' питања у Вашим тестовима која су подешена тако да врше одабир питања и из категорија дељених и из категорија недељених питања.';
$string['questiontype'] = 'Тип питања';
$string['questiontypes'] = 'Типови питања';
$string['quizattemptsupgradedmessage'] = 'У верзији Moodle 2.1 извршен је велика надоградња оног  дела који се односи на питања. Било је могуће да се део надоградње базе података одложи и покрене касније. Пре преласка на верзију Moodle 2.7 ова надоградња мора да буде завршена.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA тајни кључ';
$string['recaptchapublickey'] = 'ReCAPTCHA кључ сајта';
$string['referrernone'] = 'Подразумевано за веб читач';
$string['referrerpolicy'] = 'Правилник о реферирању';
$string['referrerpolicydesc'] = 'Подесите заглавље правилника о реферирању који ће бити укључен у одговоре са вашег сајта.';
$string['register'] = 'Региструјте свој сајт';
$string['registration'] = 'Регистрација';
$string['registration_help'] = 'Регистрацијом свог сајта:

* добијаћете безбедносна упозорења
* моћи ћете да активирате слање обавештења са свог сајт на мобилну апликацију
* даћете свој допринос статистици Moodle светске заједнице';
$string['registrationwarning'] = 'Ваш сајт још није регистрован';
$string['registrationwarningcontactadmin'] = 'Ваш сајт још није регистрован. Молимо. обавестите свог администратора.';
$string['releasenoteslink'] = 'За информације о овој верзији Moodlea, молимо погледајте онлајн <a target="_new" href="{$a}">Белешке о издању</a>';
$string['rememberuserlicensepref'] = 'Упамти преферирану лиценцу корисника';
$string['rememberuserlicensepref_help'] = 'Ако је омогућено ова опција, последња лиценца коју је корисник изабрао биће унапред изабрана, приликом постављања датотеке у бирач датотека. У супротном, као унапред изабрана користиће се подразумевана лиценца на нивоу сајта.';
$string['rememberusername'] = 'Запамти корисничко име';
$string['rememberusername_desc'] = 'Омогућите ову опцију ако желите да сачувате перманентне колачиће са корисничким именима приликом пријављивања корисника на систем. Перманентни колачићи могу да представљају проблем приватности ако се користе без сагласности.';
$string['replacefrontsearch'] = 'Користи се за претрагу курсева на насловној страници сајта';
$string['reportsmanage'] = 'Управљање извештајима';
$string['required'] = 'Обавезно';
$string['requiredentrieschanged'] = 'Напомена: Након надоградње система подешавање \'Обавезни уноси пре прегледања\' је сада обавезно за следеће активности базе података:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Захтевај опис активности';
$string['requiremodintro_desc'] = 'Ако је опција омогућена корисници ће бити приморани да унесу опис за сваку активности';
$string['requires'] = 'Неопходно';
$string['resetindentation'] = 'Ресетујте увлачење на целом сајту';
$string['resetindentation_help'] = 'Ово ће уклонити сва увлачења која су претходно подешена за све курсеве у формату: {$a->format}.';
$string['resetindentation_title'] = 'Ресетовати увлачење на целом сајту?';
$string['resetindentationsuccess'] = 'Увлачење ресетовано.';
$string['restorecourse'] = 'Рестаурирај курс';
$string['restorernewroleid'] = 'Улога рестауратора на курсевима';
$string['restorernewroleid_help'] = 'Ако корисник већ нема дозволу да управља недавно рестаурисаним курсом, аутоматски ће му бити додељена ова улога и биће уписан на курс ако је то потребно. Изаберите "Ништа", ако не желите да они који рестаурирају курсеве буду  у могућности да управљају сваким рестаурисаним курсом.';
$string['resultfilter'] = 'Филтрирај по резултату';
$string['reverseproxy'] = 'Реверзни прокси';
$string['reverseproxyignore'] = 'Игнориши узвратне посреднике';
$string['riskconfig'] = 'Корисници би могли променити конфигурацију и понашање сајта';
$string['riskconfigshort'] = 'Конфигурациони ризик';
$string['riskdataloss'] = 'Корисници могу да униште велику количину садржаја или информација';
$string['riskdatalossshort'] = 'Ризик од губиткка података';
$string['riskmanagetrust'] = 'Корисници би могли променити сигурносна подашавања других корисника';
$string['riskmanagetrustshort'] = 'Управљање дозволама за приступ';
$string['riskpersonal'] = 'Корисници би могли стећи приступ приватним информацијама других корисника';
$string['riskpersonalshort'] = 'Ризик по приватност';
$string['riskspam'] = 'Корисници би могли слати нежељену пошту корисницима сајта или другим лицима';
$string['riskspamshort'] = 'Ризик од нежељене е-поште';
$string['riskxss'] = 'Корисници би могли додати датотеке и текстове који дозвољавају скриптовање у оквиру читавог сајта (XSS)';
$string['riskxssshort'] = 'XSS ризик';
$string['roleswithexceptions'] = '{$a->roles}, са {$a->exceptions}';
$string['rssglobaldisabled'] = 'Онемогућено на нивоу сајта';
$string['save'] = 'Сачувај';
$string['savechanges'] = 'Сачувај промене';
$string['scssinvalid'] = 'SCSS кôд није исправан. Извршавање кôда није успело са поруком: {$a}';
$string['search'] = 'Претрага';
$string['searchablecourses'] = 'Претраживи курсеви';
$string['searchallavailablecourses'] = 'Курсеви који се могу претраживати';
$string['searchallavailablecourses_desc'] = 'У неким ситуацијама претраживач можда неће функционисати приликом претраживања великог броја курсева. Ако морате да ограничите број курсева који се претражују, подесите претрагу само на уписане курсеве.';
$string['searchallavailablecourses_off'] = 'Претрага само унутар уписаних курсева';
$string['searchallavailablecourses_on'] = 'Претрага унутар свих курсева којима корисник може да приступи';
$string['searchallavailablecoursesdesc'] = 'Ако је подешено да се претрага врши само унутар уписаних курсева, информације о курсу (назив и резиме) као и његов садржај биће претраживани само унутар оних курсева које је корисник уписао. У супротном, информације о курсу и садржај курса биће претраживани унутар свих курсева којима корисник може да приступи, као што су то курсеви који имају омогућен приступ гостима.';
$string['searchalldeleted'] = 'Сав индексирани садржај је обрисан';
$string['searchalternatesettings'] = 'Алтернативна подешавања само за упите';
$string['searchalternatesettings_desc'] = 'Ако довршите ова подешавања, можете да изаберете \'алтернативна подешавања\' за овај претраживач у опцији \'Претраживач само за упите\' на страници \'Управљање глобалном претрагом\'. Ово је корисно само када се крећете између два претраживача истог типа.';
$string['searchareadisabled'] = 'Област претраге је онемогућена';
$string['searchareaenabled'] = 'Област претраге је омогућена';
$string['searchareas'] = 'Области претраге';
$string['searchbanner'] = 'Информације претраге';
$string['searchbannerenable'] = 'Приказ информација претраге';
$string['searchbannerenable_desc'] = 'Ако је омогућено, доњи текст биће приказан при врху екрана за претрагу за све кориснике. Ово се може употребити за информисање корисника док се обавља  одржавање система претраге.';
$string['searchdefaultcategory'] = 'Подразумевана категорија за претрагу';
$string['searchdefaultcategory_desc'] = 'Подразумевано ће бити приказани резултати из изабране категорије као области за претрагу.';
$string['searchdeleteindex'] = 'Обриши сав индексирани садржај';
$string['searchdisplay'] = 'Опције приказа резултата претраге';
$string['searchenablecategories'] = 'Прикажи резултате у одвојеним категоријама';
$string['searchenablecategories_desc'] = 'Ако је ова опција омогућена, резултати претраге биће приказани у различитим категоријама.';
$string['searchengine'] = 'Претраживач';
$string['searchenginealternatesettings'] = '{$a} (алтернативна подешавања)';
$string['searchenginequeryonly'] = 'Претраживач само за упите';
$string['searchenginequeryonly_desc'] = 'Овај претраживач ће се користити само за постављање упита, а не за индексирање. Коришћењем ове функције можете поново индексирати у другом претраживачу, док упити корисника настављају да раде у овом.';
$string['searchenginequeryonly_none'] = 'Ниједан (користите главни претраживач за упите)';
$string['searchenginequeryonlysame'] = 'Претраживач само за упите и главни претраживач не могу се подесити на исту вредност.';
$string['searchhideallcategory'] = 'Сакриј категорију \'Сви резултати\'';
$string['searchhideallcategory_desc'] = 'Ако је означено, категорија са свим резултатима биће сакривена на екрану са резултатима претраге.';
$string['searchincludeallcourses'] = 'Укључи све видљиве курсеве';
$string['searchincludeallcourses_desc'] = 'Ако је ова опција омогућена, резултати претраге ће укључивати информације (назив и резиме) о курсевима који су видљиви корисницима, чак и ако они немају приступ садржају курсева.';
$string['searchindexactions'] = 'Акције индексирања';
$string['searchindexdeleted'] = 'Индекс је обрисан';
$string['searchindextime'] = 'Временско ограничење индексирања';
$string['searchindextime_desc'] = 'Приликом индексирања великих количина новог садржаја, планирани задатак ће се зауставити након што се достигне ово временско ограничење. Индексирање ће се наставити следећи пут када се задатак покрене.';
$string['searchindexupdated'] = 'Садржај претраживача је ажуриран';
$string['searchindexwhendisabled'] = 'Индексирај када је претрага онемогућена';
$string['searchindexwhendisabled_desc'] = 'Дозвољава планираном задатку да креира индекс претраживања чак и када је претрага онемогућена. Ово је корисно ако желите да креирате индекс пре него што се полазницима појави могућност за претраживање.';
$string['searchinsettings'] = 'Тражи у подешавањима';
$string['searchlastrun'] = 'Последње извршавање (време, # докумената, # записа, # игнорисања)';
$string['searchmanagement'] = 'Управљање претрагом';
$string['searchmanagement_desc'] = 'Ове опције су корисне приликом уношења промена на сајтовима са врло великим индексима за претраживање којима је потребно много времена за поновно формирање.';
$string['searchmaxtopresults'] = 'Максималан број најбољих резултата';
$string['searchmaxtopresults_desc'] = 'Максималан број најбоље рангираних резултата који ће бити приказани изнад резултата претраге за садржај курса, курсеве и кориснике.';
$string['searchnotavailable'] = 'Претрага није на располагању';
$string['searchoptions'] = 'Опције за претрагу';
$string['searchpartial'] = '(Још није у потпуности индексирано)';
$string['searchreindexed'] = 'Сав садржај сајта је поново индексиран.';
$string['searchreindexindex'] = 'Поново индексирај сав садржај сајта';
$string['searchresults'] = 'Резултати претраге';
$string['searchsetupinfo'] = 'Подешавање претраживача';
$string['searchteacherroles'] = 'Улоге предавача';
$string['searchteacherroles_desc'] = 'Изаберите све улоге због којих ће корисници са улогом у резултатима претраге бити боље рангирани.';
$string['searchtopresults'] = 'Најбољи резултати';
$string['searchupdateindex'] = 'Ажурирај садржај индекса';
$string['sectionerror'] = 'Грешка секције!';
$string['secureforms'] = 'Користити додатне мере безбедности формулара';
$string['security'] = 'Безбедност';
$string['selectdevice'] = 'Изабери уређај';
$string['selectsearchengine'] = 'Изабери претраживач';
$string['selecttheme'] = 'Изабери графичку тему за уређај {$a}';
$string['server'] = 'Сервер';
$string['serverchecks'] = 'Провере сервера';
$string['serverlimit'] = 'Ограничење сервера';
$string['servicespage'] = 'Линк ка страници за услуге и подршку';
$string['sessionautostartwarning'] = '<p>Откривена је озбиљна грешка при конфигурацији, молимо обавестите администратора сервера</p><p> За исправан рад, администратор треба да променит PHP подешавања.</p> <p><code>session.auto_start</code> мора бити подешено на <code>off</code>.</p><p> Ово подешавање може се променити уређивањем <code>php.ini</code> датотеке, конфигурације Apache/IIS веб сервера<br />или <code>.htaccess</code> датотеке на серверу.</p>';
$string['sessioncookie'] = 'Префикс колачића';
$string['sessioncookiedomain'] = 'Домен колачића';
$string['sessioncookiepath'] = 'Путања колачића';
$string['sessionhandling'] = 'Управљање сесијама';
$string['sessiontimeout'] = 'Време истека сесије';
$string['sessiontimeoutwarning'] = 'Упозорење о истеку сесије';
$string['settingdependenton'] = 'Овo подешавање може бити скривено, на основу вредности <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Постављање датотека је неопходно за нормалан рад система. Молимо вас да омогућите ово у PHP конфигурационој датотеци.';
$string['settingmaxinputvars'] = 'Препоручује се да PHP подешавање max_input_vars буде најмање 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP подешавање max_input_vars мора да буде најмање 5000.';
$string['settingmemorylimit'] = 'Уочена је недостатак меморије. Молимо Вас да поставите већи лимит за меморију у PHP подешаваљима.';
$string['settingsafemode'] = 'Moodle није у потпуности компатибилан са безбедним режимом. Замолите администратора сервер да га искључи. Покретање Moodlea у безбедном режиму није подржано, тако да ако то урадите можете очекивати различите проблеме.';
$string['setupsearchengine'] = 'Подеси претраживач';
$string['showcommentscount'] = 'Прикажи број коментара';
$string['showdetails'] = 'Прикажи детаље';
$string['showuseridentity'] = 'Прикажи идентитет корисника';
$string['showuseridentity_desc'] = 'Приликом избора или претраге корисника, када се приказује списак корисника, ова поља се могу приказати поред њихових имена и презимена. Поља ће бити приказано само оним корисницима који имају способност moodle/site:viewuseridentity;  стандардно, предавачима и менаџерима (ова опција највише има смисла ако изаберете једно или два поља која су у вашој институцији обавезна).

Поља означена са * су прилагођена поља корисничког профила. Можете да изаберете ова поља, али тренутно постоје неки екрани на којима се они неће појавити.';
$string['simplexmlrequired'] = 'Moodle сада захтева SimpleXML PHP екстензију.';
$string['sitemailcharset'] = 'Скуп знакова';
$string['sitemaintenance'] = 'Сајт је у фази одржавања и тренутно није доступан';
$string['sitemaintenancemode'] = 'Режим одржавања система';
$string['sitemaintenanceoff'] = 'Одржавање система је завршено и сајт је поново у нормалном режиму рада';
$string['sitemaintenanceon'] = 'Ваш сајт је тренутно у режиму одржавања (само администратори могу да приступе сајту)';
$string['sitemaintenanceoncli'] = 'Ваш сајт је тренутно у CLI режиму одржавања. Интернет приступ није дозвољен.';
$string['sitemaintenancetitle'] = '{$a} је у режиму одржавања';
$string['sitemaintenancewarning'] = 'Ваш сајт је тренутно у режиму одржавања (само администратори могу да приступе сајту). Да би сте вратили сајт у нормалан режим рада, <a href="maintenance.php"> искључите режим одржавања</a>.';
$string['sitemaintenancewarning2'] = 'Ваш сајт је тренутно у режиму одржавања (само администратори могу да се пријаве на систем). Да бисте вратили овај сајт у нормалан режим рада, <a href="{$a}">искључите режим одржавања</a>.';
$string['sitemenubar'] = 'Навигација на сајту';
$string['sitenameintitle'] = 'Укључите назив сајта у наслов странице';
$string['sitenameintitle_help'] = 'Ово подешавање ће додати назив сајта на крај наслова странице. Укључивање назива сајта у наслов странице се препоручује јер ће то побољшати приступачност сајту омогућавајући корисницима да брзо идентификују страницу на којој се тренутно налазе.';
$string['sitepolicies'] = 'Безбедносна подешавања сајта';
$string['sitepolicy'] = 'URL адреса правилника о коришћењу сајта';
$string['sitepolicy_help'] = 'URL правилника о коришћењу сајта који сви регистровани корисници морају да прочитају и прихвате пре приступа сајту. Имајте у виду да ће ово подешавање имати ефекта само уколико је управљач правилником о коришћењу сајта постављен на Подразумевано (core).';
$string['sitepolicyguest'] = 'URL адреса правилника о коришћењу сајта за госте';
$string['sitepolicyguest_help'] = 'URL адреса правилника о коришћењу сајта који сви гости морају да прочитају и прихвате пре него што приступе сајту. Имајте у виду да ће ово подешавање имати ефекта само уколико је управљач правилником о коришћењу сајта постављен на Подразумевано (core).';
$string['sitepolicyhandler'] = 'Управљач правилником о коришћењу сајта';
$string['sitepolicyhandler_desc'] = 'Ово одређује како се управља правилима сајта и сагласностима корисника са тим правилима. Подразумевани (основни) управљач омогућава да буду наведена како URL адреса правилника о коришћењу сајту, тако и URL адреса правилника о коришћењу сајту за госте. Управљач правилима омогућава да буду подешена правила коришћења сајта, правила приватности као и друга правила. Он, такође, омогућава да буду приказане сагласност корисника  као и да се, ако је то потребно, дâ сагласност у име малолетног лица.';
$string['sitepolicyhandlercore'] = 'Подразумевано  (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Уколико је ова опција изабрана, тематска секција ће бити приказана на насловној страници сајта.';
$string['sixtyfourbitsrequired'] = 'Откривено је да ваш сајт не користи 64-битну PHP верзију. Од вас се захтева да надоградите свој систем (оперативни систем, PHP...) пре инсталирања ове верзије Moodlea.';
$string['sixtyfourbitswarning'] = 'Откривено је да ваш сајт не користи 64-битну верзију PHP-а. Препоручује се да надоградите ваш сајт да бисте обезбедили компатибилност са будућим верзијама система.';
$string['slasharguments'] = 'Користити slash аргументе';
$string['slashargumentswarning'] = 'Препоручује се омогућавање употребе аргумената са косом цртом. У будућности ће то бити обавезно. За више информација погледајте документацију <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Коришћење аргумената са косом цртом</a>.';
$string['smartpix'] = '"Паметна" претрага слика';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP тип провере идентитета';
$string['smtpdetail'] = 'Подешавања SMTP (Simple Mail Transfer Protocol) сервера за слање е-поште.';
$string['smtphosts'] = 'SMTP сервери';
$string['smtpmaxbulk'] = 'Ограничење SMTP сесије';
$string['smtppass'] = 'SMTP лозинка';
$string['smtpsecure'] = 'SMTP безбедност';
$string['smtpuser'] = 'SMTP корисничко име';
$string['soaprecommended'] = 'Инсталирање опционе soap екстензије је корисно за веб сервисе и неке додатке за Moodle.';
$string['sort_fullname'] = 'Пун назив курса';
$string['sort_idnumber'] = 'ID број курса';
$string['sort_shortname'] = 'Скраћени назив курса';
$string['sort_sortorder'] = 'Редослед сортирања';
$string['spellengine'] = 'Систем за проверу правописа';
$string['spelllanguagelist'] = 'Списак језика за проверу правописа';
$string['splrequired'] = 'Moodle захтева SPL PHP екстензију';
$string['stats'] = 'Статистика';
$string['statsfirstrun'] = 'Максимални интервал обраде';
$string['statsmaxruntime'] = 'Максимално време извршавања';
$string['statsmoodleorg'] = 'статистика';
$string['statsruntimedays'] = 'Дана за обраду';
$string['statsruntimestart'] = 'Извршавање у';
$string['statsuserthreshold'] = 'Гранична вредност корисника';
$string['stickyblocks'] = 'Фиксирани блокови';
$string['stickyblockscourseview'] = 'Страница курса';
$string['stickyblocksduplicatenotice'] = 'Ако је било који блок који овде додате већ присутан на некој конкретној страници, биће приказан и његов дупликат.<br />Једино што се фиксирани блок неће моћи мењати, а дупликат још увек хоће.';
$string['stickyblocksmymoodle'] = 'Мој Moodle';
$string['stickyblockspagetype'] = 'Врста странице за конфигурисање';
$string['strictformsrequired'] = 'Стриктна провера обавезних поља';
$string['stripalltitletags'] = 'Уклони HTML ознаке из свих назива активности';
$string['supportandservices'] = 'Подршка и услуге';
$string['supportavailability'] = 'Подржи доступност';
$string['supportcontact'] = 'Контакт за подршку';
$string['supportemail'] = 'Адреса е-поште за подршку';
$string['supportemailsubject'] = 'Захтев за подршку сајта - {$a}';
$string['supportname'] = 'Име за подршку';
$string['supportpage'] = 'Линк ка страници за подршку';
$string['suspenduser'] = 'Суспендуј кориснички налог';
$string['switchlang'] = 'Промени lang директоријум';
$string['systempaths'] = 'Системске путање';
$string['tablenosave'] = 'Промене у горњој табели се аутоматски чувају.';
$string['tablesnosave'] = 'Промене у горњим табелама се аутоматски чувају.';
$string['tabselectedtofront'] = 'У табелама са табовима, да ли би ред са тренутно изабраним табом требало да буде стављен у први план';
$string['tabselectedtofronttext'] = 'Поставите изабрани ред картице напред';
$string['task_adhoc_concurrency_limit'] = 'Ограничења броја паралелних ад хок задатака';
$string['task_adhoc_concurrency_limit_desc'] = 'Број покретача ад хок задатака којима је дозвољено да раде истовремено. Ако је лимит висок, планирани задаци се не могу извршавати редовно када постоји пуно ад хок задатака. Подешавање 0 ће у потпуности онемогућити обраду ад хок задатака.';
$string['task_adhoc_max_runtime'] = 'Животни век покретача ад хок задатка';
$string['task_adhoc_max_runtime_desc'] = 'Старост покретача ад хок задатка пре него што се ослободи. Препоручује се краћи временски период јер не постоји ограничење броја ад хок задатака који могу да буду на чекању. Ако је овај број превисок и ако имате велики број ад хок задатака на чекању, онда се планирани задаци можда неће редовно покретати.';
$string['task_dbreads'] = 'Учитавања из базе података';
$string['task_dbstats'] = 'База података';
$string['task_dbwrites'] = 'Уписивања у базу података';
$string['task_duration'] = 'Време трајања';
$string['task_endtime'] = 'Време завршетка';
$string['task_logmode'] = 'Када записивати';
$string['task_logmode_all'] = 'Чувајте евиденцију свих задатака';
$string['task_logmode_desc'] = 'Можете изабрати када желите да се води евиденција о задацима. Стандардно, евиденције се увек снимају. Можете да онемогућите записивање у потпуности, или да промените па да се евидентирају само задаци који нису успешно извршени.';
$string['task_logmode_failonly'] = 'Чувајте само евиденције за задатке који нису успешно извршени';
$string['task_logmode_none'] = 'Не записуј ништа';
$string['task_logoutput'] = 'Излазни подаци задатка';
$string['task_logretainruns'] = 'Упамћена покретања';
$string['task_logretainruns_desc'] = 'Број покретања сваког задатка које треба упамтити. Ово подешавање је у интеракцији са подешавањем \'Период задржавања\': примењује се прво од ова два ограничење које се достигне';
$string['task_logretention'] = 'Период задржавања';
$string['task_logretention_desc'] = 'Максимални временски период током ког се евиденције чувају. Ово подешавање је у интеракцији са подешавањем \'Упамћена покретања\': примењује се прво од ова два ограничење које се достигне';
$string['task_logtostdout'] = 'Прикажи записе излазних информација';
$string['task_logtostdout_desc'] = 'Када се задаци извршавају, а излазне информације снимају, да ли би, такође, требало приказати снимљене излазне информације док се задатак изводи.';
$string['task_result'] = 'Резултат';
$string['task_result:failed'] = 'Неуспешно';
$string['task_scheduled_concurrency_limit'] = 'Ограничења броја паралелних планираних задатака';
$string['task_scheduled_concurrency_limit_desc'] = 'Број извршилаца планираних задатака којима је дозвољено да раде истовремено.
Ако је лимит висок, може доћо до великог оптерећења сервер што ће утицати на његове перформансе. Подешавање 0 ће у потпуности онемогућити обраду планираних задатака.';
$string['task_scheduled_max_runtime'] = 'Животни век покретача планираног задатка';
$string['task_scheduled_max_runtime_desc'] = 'Старост покретача планираног задатка пре него што се ослободи.';
$string['task_starttime'] = 'Почетно време';
$string['task_stats:dbreads'] = 'очитавања: {$a}';
$string['task_stats:dbwrites'] = 'уписивања: {$a}';
$string['task_status'] = 'Статус задатка';
$string['task_status_desc'] = 'Задатак \'{$a->name}\' је {$a->status}. За више информација, погледајте {$a->class}{$a->extradescription} на страници <a href="{$a->gotourl}">Планирани задаци</a>.';
$string['task_type:adhoc'] = 'Ад хок';
$string['task_type:scheduled'] = 'Планиран';
$string['taskadmintitle'] = 'Задаци';
$string['taskanalyticscleanup'] = 'Чишћење аналитике';
$string['taskautomatedbackup'] = 'Аутоматско креирање резервних копија';
$string['taskautomatedbackup_report'] = 'Извештај о аутоматизованим резервним копијама';
$string['taskbackupcleanup'] = 'Чишћење табела резервних копија, записа и датотека';
$string['taskbadgesadhoc'] = 'Додела беџа';
$string['taskbadgescron'] = 'Додајте адхок задатке доделе беџева';
$string['taskbadgesmessagecron'] = 'Позадинска обрада за слање обавештења о беџевима';
$string['taskblogcron'] = 'Синхронизација екстерних блогова';
$string['taskcachecleanup'] = 'Уклањање застарелих ставки кеша';
$string['taskcachecron'] = 'Позадинска обрада кеша';
$string['taskcalendarcron'] = 'Слање обавештења календара';
$string['taskcheckforupdates'] = 'Провера најновијих верзија';
$string['taskcompletiondaily'] = 'Ознака завршености: започето';
$string['taskcompletionregular'] = 'Израчунавaње редовних података о завршетку';
$string['taskcontextcleanup'] = 'Чишћење контекста';
$string['taskcreatecontexts'] = 'Креирање недостајућих контекста';
$string['taskdeletecachetext'] = 'Брисање старих текстуалних записа кеша';
$string['taskdeleteincompleteusers'] = 'Брисање непотпуних корисничких налога';
$string['taskdeleteunconfirmedusers'] = 'Брисање непотврђених корисничких налога';
$string['taskeventscron'] = 'Позадинска обрада догађаја';
$string['taskfiletrashcleanup'] = 'Чишћење датотека из корпе за отпатке';
$string['taskglobalsearchindex'] = 'Индексирање за глобалну претрагу';
$string['taskglobalsearchoptimize'] = 'Оптимизација индексирања глобалне претраге';
$string['taskgradecron'] = 'Позадинска обрада књиге оцена';
$string['taskgradehistorycleanup'] = 'Позадинска обрада за чишћење табела са историјом оцена';
$string['taskh5pcleanup'] = 'Чишћење неискоришћених H5P датотека';
$string['tasklegacycron'] = 'Наслеђена крон обрада додатака';
$string['tasklockcleanuptask'] = 'Чишћење метаподатке ад хок задатака';
$string['tasklogcleanup'] = 'Чишћење евиденције задатака';
$string['tasklogging'] = 'Конфигурација евиденције задатака';
$string['tasklogs'] = 'Евиденција задатака';
$string['taskmessagingcleanup'] = 'Позадинска обрада слања порука';
$string['taskpasswordresetcleanup'] = 'Чишћење покушаја ресетовања лозинке';
$string['taskplagiarismcron'] = 'Позадинска обрада за наслеђени крон у додацима за проверу плагијата';
$string['taskportfoliocron'] = 'Позадинска обрада додатака за портфолио';
$string['taskprocessing'] = 'Обрада задатака';
$string['taskquestioncron'] = 'Позадинска обрада за чишћење прегледа питања';
$string['taskquestionstatscleanupcron'] = 'Некадашње позадинско чишћење статистике питања (више није потребно)';
$string['taskrefreshsystemtokens'] = 'Освежавање OAuth токена за налоге сервиса';
$string['taskregistrationcron'] = 'Регистрација сајта';
$string['tasksendfailedloginnotifications'] = 'Слање обавештења о неуспешним пријавама на систем';
$string['tasksendnewuserpasswords'] = 'Слање нових корисничких лозинки';
$string['tasksessioncleanup'] = 'Чишћење старих сесија';
$string['taskstatscron'] = 'Позадинска обрада статистике';
$string['tasktagcron'] = 'Позадинска обрада ознака';
$string['tasktempfilecleanup'] = 'Брисање застарелих привремених датотека';
$string['tasktype'] = 'Тип';
$string['tempdatafoldercleanup'] = 'Обриши привремене датотеке старије од';
$string['templates'] = 'Шаблони';
$string['testoutgoingmailconf'] = 'Тестирајте конфигурацију одлазне поште';
$string['testoutgoingmailconf_errorcommunications'] = 'Ваш сајт не може да комуницира са вашим сервером за е-пошту. Проверите конфигурацију  одлазне поште.';
$string['testoutgoingmailconf_fromemail'] = 'Корисничко име или адреса е-поште у пољу "Од"';
$string['testoutgoingmailconf_fromemail_help'] = 'Ово поље опонаша слање поруке од овог корисника, али садржај поља \'Од\' (From)  у заглављу, које се користи у стварној е-поруци, зависиће од других подешавања као што је нпр. подешавање allowedemaildomains (дозвољени домени е-поште)';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Неисправно корисничко име или адреса е-поште у пољу \'Од\' (From). Мора бити исправан формат е-поште или постојеће корисничко име у Moodleu.';
$string['testoutgoingmailconf_message'] = 'Ово је тест порука која потврђује да сте успешно конфигурирали одлазну пошту на свом сајту. Послато: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Пошаљи тест поруку';
$string['testoutgoingmailconf_sentmail'] = 'Овај сајт је успешно испоручио тест поруку серверу за е-пошту. <br />Од: {$a->fromemail}<br />За: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: тест порука. {$a->additional} Послато: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Додатна тема поруке';
$string['testoutgoingmailconf_toemail'] = 'На адресу е-поште';
$string['testoutgoingmaildetail'] = 'Напомена: пре тестирања сачувајте конфигурацију.<br />{$a}';
$string['testsiteupgradewarning'] = 'Тренутно користите тест сајт {$a}; да бисте га исправно надоградили , употребите интерфејс са командом линијом';
$string['themedesignermode'] = 'Режим за дизајнирање теме';
$string['themedesignermodewarning'] = 'Режим за дизајнирање теме је укључен. Овај режим не би требало да буде укључен на продукционим сајтовима. пошто значајно може да умањи перформансе система.';
$string['themelist'] = 'Списак графичких тема';
$string['themenoselected'] = 'Ниједна графичка тема није изабрана';
$string['themeresetcaches'] = 'Обриши теме из кеш меморије';
$string['themeselect'] = 'Промени графичку тему';
$string['themeselector'] = 'Селектор графичке теме';
$string['themesettings'] = 'Подешавања графичких тема';
$string['therewereerrors'] = 'Било је грешака у вашим подацима';
$string['thirdpartylibrary'] = 'Библиотека';
$string['thirdpartylibrarylocation'] = 'Локација';
$string['thirdpartylibs'] = 'Независне библиотеке';
$string['timezone'] = 'Подразумевана временска зона';
$string['timezoneforced'] = 'Ово је администратор сајта прогласио обавезним';
$string['timezoneinvalid'] = 'Неисправна временска зона "{$a}"';
$string['timezoneisforcedto'] = 'Обавезна употреба за све кориснике';
$string['timezonenotforced'] = 'Корисници могу одабрати сопствену временску зону';
$string['timezonephpdefault'] = 'Подразумевана PHP временска зона ({$a})';
$string['timezoneserver'] = 'Временска зона сервера  ({$a})';
$string['tlswarning'] = 'Није детектован PHP/cURL додатак са TLSv1.2 подршком. Неки сервиси можда неће радити. Врло је препоручљиво да ажурирате своје TLS библиотеке.';
$string['tokenduration'] = 'Трајање токена који је креирао корисник';
$string['tokenduration_desc'] = 'Временски период за који је корисник креирао токен веб сервиса (на пример путем мобилне апликације) је исправан.';
$string['tokenizerrecommended'] = 'Препоручује се инсталација опционог PHP Tokenizer додатка ради побољшавања функционалности за умрежавање.';
$string['tools'] = 'Администраторски алати';
$string['toolsmanage'] = 'Управљање администраторским алатима';
$string['unattendedoperation'] = 'Аутоматска инсталација';
$string['unbookmarkthispage'] = 'Уклони обележивач са ове странице';
$string['unicoderequired'] = 'Потребно је да све ваше податке чувате у Unicode формату (UTF-8). Нове инсталације морају бити примењене у базама података које имају основни скуп знакова подешен на Unicode. Уколико вршите надоградњу, потребно је покренути UTF-8 процес миграције (погледајте страницу за администрацију).';
$string['uninstallplugin'] = 'Деинсталирај';
$string['unlockaccount'] = 'Откључај налог';
$string['unoconvwarning'] = 'Верзија unoconv конвертора коју сте инсталирали није подржана. Функционалност која омогућава оцењивања задатака у Moodleu захтева верзију 0.7 или новију.';
$string['unsettheme'] = 'Уклони графичку тему';
$string['unsupported'] = 'Неподржано';
$string['unsupporteddbfileformat'] = 'Ваша база података користе Antelope као формат датотеке. Пуна UTF-8 подршка у MySQL и MariaDB бази података захтева Barracuda формат датотеке. Пребаците формат датотеке на Barracuda формат. За више информација погледајте <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">Пуна UTF-8 подршка у MySQL</a>';
$string['unsupporteddbfilepertable'] = 'За пуну подршку UTF-8 кодног распореда и MySQL и MariaDB база података захтева да промените MySQL подешавање \'innodb_file_per_table\' на \'ON\'. Погледајте документацију за више информација.';
$string['unsupporteddblargeprefix'] = 'За пуну подршку UTF-8 кодног распореда и MySQL и MariaDB база података захтева да промените MySQL подешавање \'innodb_file_per_table\' на \'ON\'. Погледајте документацију за више информација.';
$string['unsupporteddbstorageengine'] = 'Машина базе података која се користи није више подржана.';
$string['unsupporteddbtablerowformat'] = 'Ваша база садржи табеле које користе Antelope као формат датотеке. Препоручује се да конвертујете те табеле у Barracuda формат датотеке. Погледајте документацију <a href="https://docs.moodle.org/en/cli">Администрација путем командне линије</a> за детаље везане за алат за конверзију InnoDB табела у формат Barracuda.';
$string['unsupportedphpversion7'] = 'PHP верзија 7 и новије нису подржане.';
$string['unsupportedphpversion71'] = 'PHP верзија 7.1 и новије нису подржане.';
$string['unsupportedphpversion72'] = 'PHP верзија 7.2 и новије нису подржане.';
$string['unsupportedphpversion73'] = 'PHP верзија 7.3 и новије нису подржане.';
$string['unsupportedphpversion74'] = 'PHP верзија 7.4 и новије нису подржане.';
$string['unsupportedphpversion80'] = 'PHP верзија 8.0 и новије нису подржане.';
$string['unsupportedphpversion81'] = 'PHP верзија 8.1 и новије нису подржане.';
$string['unsupportedphpversion82'] = 'PHP верзија 8.2 и новије нису подржане.';
$string['unsupportedphpversion83'] = 'PHP верзија 8.3 и новије нису подржане.';
$string['unsuspenduser'] = 'Активирајте кориснички налог';
$string['updateaccounts'] = 'Ажурирање постојећих налога';
$string['updateautocheck'] = 'Аутоматски провери доступност нових верзија';
$string['updateautocheck_desc'] = 'Ако је ово подешавање омогућено,  ваш сајт ће аутоматски проверавати да ли су доступне нове верзије како основног Moodle пакета, тако и свих додатака. Ако постоје доступне нове верзије, биће послато обавештење е-поштом администраторима сајта.';
$string['updateavailable'] = 'Доступна је новија верзија Moodlea!';
$string['updateavailable_moreinfo'] = 'Више информација...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Верзија{$a}';
$string['updateavailabledetailslink'] = 'За више информација погледајте {$a->url}';
$string['updateavailableforplugin'] = 'Доступне су новије верзије за неке од ваших додатака!';
$string['updateavailableinstall'] = 'Инсталирај нову верзију';
$string['updateavailableinstallall'] = 'Инсталирај доступне нове верзије ({$a})';
$string['updateavailableinstallallhead'] = 'Инсталирање доступних нових верзија';
$string['updateavailablenot'] = 'Користите последњу верзију Moodlea!';
$string['updateavailablerecommendation'] = 'Веома је препоручљиво да ажурирате свој сајт на најновију верзију како бисте добили све скорашње безбедносне исправке, као и исправке грешака.';
$string['updatecomponent'] = 'Ажурирај компоненту';
$string['updateminmaturity'] = 'Потребна зрелост кôдa';
$string['updateminmaturity_desc'] = 'Пошаљи обавештење о новим верзијама само ако доступни кôд има, најмање, изабрани ниво зрелости. Нове верзије додатака које не објављују зрелост свог кôда увек се пријављују, без обзира на ово подешавање.';
$string['updatenotificationfooter'] = 'Ваш Moodle сајт {$a->siteurl} је конфигурисан да аутоматски проверава да ли су доступне нове верзије програма. Ову поруку сте добили као администратор сајта. Аутоматску проверу нових верзија можете да онемогућите на Администрација сајта/Сервер/Обавештења о новим верзијама или да прилагодите начин слања ове поруке на својој страници са параметрима.';
$string['updatenotifications'] = 'Обавештења о новим верзијама';
$string['updatenotificationsubject'] = 'Доступне су нове верзије Moodlea ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Обавести о новим подверзијама';
$string['updatenotifybuilds_desc'] = 'Ако је ово подешавање омогућено,  онда ће обавештење о новoj верзији Moodle пакета бити послато и у ситуацијама када је доступна нова подверзија за текућу верзију програма. Подверзије (builds) представљају континуирана побољшања дате верзије Moodlea. Генерално, ова обавештења се објављују сваке недеље. Ако је овo подешавање онемогућено, обавештење о новој верзији ће бити послато само када се појави нова, унапређена верзија. Ово подешавање не утиче на проверу нових верзија додатака.';
$string['upgradeerror'] = 'Непозната грешка у току надоградње {$a->plugin} на верзију {$a->version}. Није могуће наставити.';
$string['upgradeforumread'] = 'Moodle верзији 1.5 је додата нова опција за праћење прочитаних/непрочитаних порука у форумима. <br />Да бисте могли да користите ову опцију морате да <a href={$a}>ажурирате своје табеле</a>.';
$string['upgradeforumreadinfo'] = 'Moodle верзији 1.5 је додата нова опција за праћење прочитаних/непрочитаних порука у форумима. Да бисте могли да користите ову опцију морате да ажурирате своје табеле заједно са свим информацијама за постојеће поруке на форумима. У зависности од величине вашег сајта таква акција може потрајати (и до неколико сати) и може оптеретити базу података, тако да је најбоље да то обавите када је сервер мање оптерећен. Ипак, ваш сајт ће у току освежавања бити у функцији и корисници неће бити тиме погођени. Када једном започнете овај процес пустите да се заврши (оставите отворен прозор свог веб читача). Уколико, ипак, затворите прозор: не брините, моћи ћете поново да стартујте процес.<br /><br />Да ли желите да започнете процес ажурирања?';
$string['upgradekeyreq'] = 'Потребан је кључ за надоградњу';
$string['upgradekeyset'] = 'Кључ за надоградњу (оставите празно ако не желите да поставите кључ)';
$string['upgradelogs'] = 'Због потпуне фукционалности, ваши стари записи о активностима треба да буду надограђени. <a href="{$a}">Више информацијa</a>';
$string['upgradelogsinfo'] = 'Недавно су направљене одређене промене у начину чувања записа о активностима. Да бисте могли да видите све своје старе записе, редом по активностима, потребно је да их надоградите. У зависности од вашег сајта, то може да потраје (и до неколико сати) и да оптерети базу података за велике сајтове. Једном када започнете овај процес, потребно је да га пустите да се заврши (тако што ћете прозор веб читача оставити отворен). Не брините - док се записи о активностима надограђују. ваш сајт ће и даље радити без проблема за остале кориснике,.<br /><br />Да ли желите сада да надоградите записе о активностима?';
$string['upgradepluginsfirst'] = 'Препоручује се да прво инсталирате све доступне нове верзије';
$string['upgradepluginsinfo'] = 'Надоградња додатака';
$string['upgradepluginsinfo_help'] = 'Постоје доступне нове верзије за неке од ваших додатака. Требало би да их све инсталирате пре надоградње Moodle базе података. Ако ваш сајт не подржава аутоматско ажурирање, морате да преузмете и ручно, на серверу, инсталирате нове верзије додатака.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Нова подешавања';
$string['upgradesettingsintro'] = 'Доле наведена подешавања су додата током последње надоградње Moodlea. Направите све потребне промене подразумеваних вредности и кликните на дугме \'Сачувај промене\' на дну ове странице.';
$string['upgradestalefiles'] = 'Откривене су измешане верзије Moodle па надоградња не може да се настави';
$string['upgradestalefilesinfo'] = 'Процес надоградње Moodlea је заустављен зато што су у Moodle директоријуму откривене PHP скрипте из најмање две различите верзије Moodlea

Ово касније може да направи велике проблеме. Како бисте наставили процес надоградње, морате прво да обезбедите да у Moodle директоријуму буду датотеке само једне верзије Moodlea

Да бисте очистили Moodle директоријум и решили овај проблем урадите следеће:

* промените назив текућег Moodle директоријума у "moodle_old"
* креирајте нови Moodle директоријум који садржи само датотеке из стандардног Moodle пакета, или из GIT репозиторијума.
* пребаците оригиналну config.php датотеку и све нестандардне додатке из старог, ”moodle_old”, у нови Moodle директоријум.

Када завршите описану процедуру, освежите ову страницу како бисте наставили процес надоградњу Moodlea.

Ово упозорење је често последица распакивања стандардног Moodle пакета у постојећи директоријум, у којем се налази претходна верзија Moodlea. Иако овај поступак не ствара проблеме приликом мањих надоградњи, никако се не саветује када се раде велике надоградње Moodlea.

Упозорење, такође, може да буде последица непотпуне провере или надоградње из GIT репозиторијума, у ком случају ћете морати само да сачекате да се операција заврши, евентуално покренете одговарајућу команду за чишћење и поново покушате операцију.

Више информација можете наћи у документацији о надоградњи на <a href=”{$a}">{$a}</a>';
$string['upgradestart'] = 'Надогради Moodle базу података сада';
$string['upgradesure'] = '<p>Ваше Moodle датотеке су измењене, и намеравате да аутоматски надоградите свој сервер на ову верзију:</p>
<p><strong>{$a}</strong></p>
<p>Једном када ово урадите не можете се вратити назад. Молимо узмите у обзир и то да овај процес може да потраје.</p>
<p>Да ли сте сигурни да желите да надоградите сервер на ову верзију?</p>';
$string['upgradetimedout'] = 'Истекло је време за ажурирање, молимо започните процес ажурирања изнова.';
$string['upgradingdata'] = 'Ажурирање података је у току';
$string['upgradinglogs'] = 'Надоградња записа о активностима је у току';
$string['upgradingversion'] = 'Надоградња на нову верзију';
$string['upwards'] = 'нагоре';
$string['useblogassociations'] = 'Омогући повезивање';
$string['user'] = 'Корисник';
$string['userbulk'] = 'Масовне акције над корисницима';
$string['userbulkdownload'] = 'Извези кориснике као';
$string['userdefaultpreferences'] = 'Подразумевана подешавања профила корисника';
$string['userfeedbackafterupgrade'] = 'После сваке веће надоградње';
$string['userfeedbackencouragement'] = '<p>Од верзији 3.9 у Moodle је укључена нова функција која корисницима даје могућност да Moodle HQ-у дају повратне информације о Moodle софтверу путем екстерног сајта за анкетирање који хостује Moodle HQ. Ниједна информација која  би могла да идентификује корисника не прослеђује се сајту на којем се анкета налази.</p>
<p>Moodle HQ настоји да буде отворен и транспарентан у погледу својих правила о прикупљању података. Стога желимо да будемо сигурни да сте свесни ове функције и да имате пуну контролу над њом.</p>
<p>Повратне информације корисника ће у великој мери помоћи да Moodle HQ унапреди Moodle софтвер. Да бисте омогућили ову функцију, идите на <a href="{$a}">Подешавања повратних информација</a>.</p>';
$string['userfeedbacknextreminder'] = 'Следећи подсетник за повратне информације';
$string['userfeedbacknextreminder_desc'] = 'Када треба поново тражити од корисника да дâ повратне информације?';
$string['userfeedbackperiodically'] = 'Периодично';
$string['userfeedbackremindafter'] = 'Прикажи подсетник након';
$string['userfeedbackremindafter_desc'] = 'Подсетите кориснике поново да пошљу повратне информације након одређеног броја дана.';
$string['userfiltersdefault'] = 'Подразумевани кориснички филтери';
$string['userfiltersdefault_desc'] = 'Изаберите филтере који ће се приказивати на страници "Претрага списка учесника", као и  на страници "Акције над више корисника". Држите притиснут тастер Ctrl да бисте изабрали више ставки. Сви филтери које не изаберете биће расположиви кликом на линк "Прикажи више".';
$string['userimagesdisabled'] = 'Слике корисничких профила су онемогућене';
$string['userlist'] = 'Преглед списка корисника';
$string['usermanagement'] = 'Управљање корисницима';
$string['userpolicies'] = 'Правила за кориснике';
$string['userpreference'] = 'Корисничка подешавања';
$string['userquota'] = 'Одељак за приватне датотеке';
$string['userquota_desc'] = 'Максимална величина података које корисник може да чува у свом приватном одељку за датотеке.';
$string['users'] = 'Корисници';
$string['usesitenameforsitepages'] = 'Користи назив сајта за странице сајта';
$string['usetags'] = 'Омогући ознаке (тагове)';
$string['validateemptylineerror'] = 'Празни редови нису исправни';
$string['validateerror'] = 'Ова вредност није исправна';
$string['validateerrorlist'] = 'Ови уноси су неисправни: {$a}';
$string['validateiperror'] = 'Следеће IP адресе нису валидне: {$a}';
$string['verifychangedemail'] = 'Ограничи домене приликом промене е-адресе';
$string['warningcurrentsetting'] = 'Неисправна тренутна вредност: {$a}';
$string['warningiconvbuggy'] = 'Ваша верзија iconv библиотеке не подржава //IGNORE модификатор. Требало би да инсталирате екстензију mbstring која може, уместо iconv библиотеке, да се користи за чишћење стрингова који садрже неисправне UTF-8 знакове.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Попуни следеће опције уколико Moodle сервер не може да приступи Интернету директно. Приступ Интернету је неопходан за преузимање података о окружењу, језичких пакета, RSS извора вести, временских зона итд.<br /><em>PHP cURL екстензија се препоручује!!!.</em>';
$string['xmlrpcwebserviceenabled'] = 'Откривено је да је на вашем сајту омогућен протокол XML-RPC Web Service. Ова функција се ослања на PHP XML-RPC екстензију коју PHP више не одржава.';
$string['yuicomboloading'] = 'YUI combo се учитава';
$string['ziprequired'] = 'PHP екстензија Zip сада је обавезна за Moodle, бинарне info-ZIP датотеке и библиотека PclZip више се не користе.';
