<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'sr_cr', version '4.2'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (self-signed)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (signed)';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP unencrypted';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (self-signed)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (signed)';
$string['aboutyourhost'] = 'О Вашем серверу';
$string['accesslevel'] = 'Ниво приступа';
$string['addhost'] = 'Додај рачунар';
$string['addnewhost'] = 'Додај нови рачунар';
$string['addtoacl'] = 'Додај у контролу приступа';
$string['allhosts'] = 'Сви домаћини';
$string['allhosts_no_options'] = 'Нема доступних опција приликом прегледавање више хост рачунара';
$string['allow'] = 'Дозволи';
$string['applicationtype'] = 'Тип апликације';
$string['authfail_nosessionexists'] = 'Неуспешна ауторизација: mnet сесија не постоји.';
$string['authfail_sessiontimedout'] = 'Неуспешна ауторизација: mnet сесија је истекла.';
$string['authfail_usermismatch'] = 'Неуспешна ауторизација: корисник се не подудара.';
$string['authmnetdisabled'] = 'MNet додатак за проверу идентитета је <strong>онемогућен</strong>.';
$string['badcert'] = 'Сертификат није исправан.';
$string['certdetails'] = 'Детаљи сертификата';
$string['configmnet'] = 'MNet  (Moodle умрежавање) дозвољава комуникацију овог сервера са другим серверима или сервисима.';
$string['couldnotgetcert'] = 'Није нађен сертификат на <br />{$a}. <br />Рачунар је можда искључен или неисправно подешен.';
$string['couldnotmatchcert'] = 'Ово се не подудара са сертификатом који тренутно издаје web сервер.';
$string['courses'] = 'курсеви';
$string['courseson'] = 'курсеви на';
$string['current_transport'] = 'Тренутни транспорт';
$string['currentkey'] = 'Тренутни јавни кључ';
$string['databaseerror'] = 'Уписивање детаља у базу података није било могуће.';
$string['deleteaserver'] = 'Брисање сервера';
$string['deletedhostinfo'] = 'Овај хост рачунар је обрисан. Ако желите да поништите брисање, пребаците статус брисања на \'Не\'';
$string['deletedhosts'] = 'Обрисани хост рачунари: {$a}';
$string['deletehost'] = 'Обриши рачунар';
$string['deletekeycheck'] = 'Да ли сте потпуно сигурни да желите да обришете овај кључ?';
$string['deleteoutoftime'] = 'Истекао је период од 60 секунди који сте имали да обришете овај кључ. Почните поново.';
$string['deleteuserrecord'] = 'SSO ACL: обриши запис за корисника \'{$a->user}\' са {$a->host}.';
$string['deletewrongkeyvalue'] = 'Дошло је до грешке. Ако нисте покушали да обришете SSL кључ свог сервера, могуће је да сте били жртва напада. Ниједна акција није била извршена.';
$string['deny'] = 'Одбиј';
$string['description'] = 'Опис';
$string['duplicate_usernames'] = 'Креирање колона "mnethostid" и "username" у Вашој табели корисника није било могуће.<br />Ово се може десити када имате  <a href="{$a}" target="_blank">дупликате корисничких имена у Вашој табели корисника</a>.<br /> Ваша надоградња би, ипак, требало да буде успешно завршена. Кликните на горњи линк и упуства за решење проблема ће се појавити у новом прозору. То можете обавити на крају процеса надоградње.<br />';
$string['enabled_for_all'] = '(Ова услуга је омогућена за све рачунаре).';
$string['enterausername'] = 'Молимо Вас да унесете корисничко име, или списак корисничких имена одвојених зарезима.';
$string['error7020'] = 'Ова грешка се обично јавља када је удаљени сајт креирао запис за вас са погрешном адресом тј. wwwroot (на пример, https://vassajt.com уместо https://www.vassajt.com). Обратите се админстратору удаљеног сајта и замолите га да ажурира запис за ваш сајт и унесе исправну адресу тј. wwwroot (онако како је то наведено у вашој config.php датотеци)';
$string['error7022'] = 'Порука коју сте послали удаљеном сајту је исправно шифрована али није потписана. Ово је неочекивана грешка - уколико се појави потребно је да је пријавите, са што је могуће више информација о верзији Moodlea о којој је реч итд.';
$string['error7023'] = 'Удаљени сајт је покушао да дешифрује вашу поруку, са свим кључевима које има у запису за ваш сајт, али без успеха. Можда бисте могли да решите овај проблем тако што ћете ручно унети нови кључ на удаљеном сајту. Мало је вероватно да се ово догоди, осим ако са удаљеним сајтом нисте комуницирали више месеци.';
$string['error7024'] = 'Послали сте нешифровану поруку удаљеном сајту, али он не прихвата нешифровану комуникацију са вашим сајтом. Ово је неочекивана грешка; ако се то догоди вероватно би требало да пријавите грешку  (са што је могуће више информација о верзијама апликација о којима је реч, итд.).';
$string['error7026'] = 'Кључ којим је ваша порука била потписана је различит од кључа који удаљени рачунар у датотеци за ваш сервер. Осим тога, удаљени рачунар је покушао да добави ваш тренутни клуч али није успео. Молимо вас да ручно подесите кључ са удаљеним рачунаром и покушате поново.';
$string['error709'] = 'Удаљени сајт није успео да добије SSL кључ од вас.';
$string['eventaccesscontrolcreated'] = 'Контрола приступа креирана';
$string['eventaccesscontrolupdated'] = 'Контрола приступа ажурирана';
$string['expired'] = 'Овај кључ је истекао';
$string['expires'] = 'Важи до';
$string['expireyourkey'] = 'Обриши овај кључ';
$string['expireyourkeyexplain'] = 'Moodle аутоматски ротира ваше кључеве сваких 28 дана (стандардно), али имате опцију да било када <em>ручно</em> поништите овај кључ. Ово ће бити корисно једино ако верујете да је овај кључ компромитован. Нови кључ ће одмах бити аутоматски генерисан.<br /> Брисање овог кључа ће онемогућити остале апликације да комуницирају са вама, док сами не контактирате сваког администратора и дате му свој нови кључ.';
$string['exportfields'] = 'Поља за извоз';
$string['failedaclwrite'] = 'Уписивање у MNet листу контроле приступа за корисника \'{$a}\' није било могуће.';
$string['findlogin'] = 'Пронађи приступ';
$string['forbidden-function'] = 'Та фукција није омогућена за RPC.';
$string['forbidden-transport'] = 'Метода транспорта коју покушавате да користите није дозвољена.';
$string['forcesavechanges'] = 'Принудно снимање промена';
$string['helpnetworksettings'] = 'Подеси MNet комуникацију';
$string['hidelocal'] = 'Сакриј локалне кориснике';
$string['hideremote'] = 'Сакриј удаљене кориснике';
$string['host'] = 'рачунар';
$string['hostcoursenotfound'] = 'Рачунар или курс није нађен';
$string['hostdeleted'] = 'Рачунар је обрисан';
$string['hostexists'] = 'Већ постоји запис за рачунар са идентичним називом (могуће је да је обрисан). <a href="{$a}">Уредите запис</a>.';
$string['hostlist'] = 'Списак умрежених рачунара';
$string['hostname'] = 'Назив рачунара';
$string['hostnamehelp'] = 'Пуно име домена за удаљени рачунар, нпр. www.primer.com';
$string['hostnotconfiguredforsso'] = 'Овај сервер није подешен за удаљено пријављивање.';
$string['hostsettings'] = 'Подешавања рачунара домаћина';
$string['http_self_signed_help'] = 'Дозволи конекције које користе само-потписани DIY SSL сертификат на удаљеном рачунару.';
$string['http_verified_help'] = 'Дозволи конекције које користе верификовани SSL сертификат у PHP-у на удаљеном рачунару, али преко http, а не https протокола.';
$string['https_self_signed_help'] = 'Дозволи конекције коре користе само-потписани DIY SSL сертификат у PHP-у на удаљеном рачунару преко http-а.';
$string['https_verified_help'] = 'Дозволи конекције које користе верификовани SSL сертификат на удаљеном рачунару.';
$string['id'] = 'ID';
$string['idhelp'] = 'Ова вредност се аутоматски додељује и не може се изменити.';
$string['importfields'] = 'Поља за увоз';
$string['inspect'] = 'Прегледај';
$string['installnosuchfunction'] = 'Програмска грешка! Нешто покушава да инсталира mnet xmlrpc функцију ({$a->method}) из датотеке ({$a->file}), али функцију није могуће пронаћи!';
$string['installnosuchmethod'] = 'Програмска грешка! Нешто покушава да инсталира mnet xmlrpc методу ({$a->method}) у класи ({$a->class}), али метод није могуће пронаћи!';
$string['installreflectionclasserror'] = 'Програмска грешка! MNet интроспекција није успела за метод ({$a->method}) у класи \'{$a->class}\'. Текст поруке о изворној грешци гласи: \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'Програмска грешка! MNet интроспекција није успела за функцију ({$a->method}) у датотеци \'{$a->file}\'. Текст поруке о изворној грешци гласи: \'{$a->error}\'';
$string['invalidaccessparam'] = 'Неисправан параметар приступа.';
$string['invalidactionparam'] = 'Неисправан параметар акције.';
$string['invalidhost'] = 'Морате дати исправан идентификатор рачунара';
$string['invalidpubkey'] = 'Овај кључ није исправан SSL кључ. ({$a})';
$string['invalidurl'] = 'Неисправан URL параметар.';
$string['ipaddress'] = 'IP адреса';
$string['is_in_range'] = 'IP адреса  <code>{$a}</code> представља исправан поуздан рачунар.';
$string['ispublished'] = '{$a} је омогућио ову услугу за вас.';
$string['issubscribed'] = '{$a} се претплаћује се на ову услугу на вашем рачунару.';
$string['keydeleted'] = 'Ваш кључ је успешно обрисан и замењен.';
$string['keydeletedcancelled'] = 'Нема промена на кључу.';
$string['keymismatch'] = 'Јавни кључ који имате за свој рачунар се разликује од јавног кључа који он тренутно објављује. Тренутно објављен кључ је:';
$string['last_connect_time'] = 'Време последње конекције';
$string['last_connect_time_help'] = 'Време када сте се поседњи пут повезали на овај рачунар.';
$string['last_transport_help'] = 'Транспорт који сте користили за последњу конекцију са овим рачунаром.';
$string['leavedefault'] = 'Користи подразумевана подешавања, уместо тога';
$string['listservices'] = 'Списак сервис';
$string['loginlinkmnetuser'] = '<br />Ако сте удаљени корисник Moodle мреже (MNet) и ако имате могућност да <a href="{$a}">потврдите своју адресу овде</a>, можете бити преусмерени на своју страницу за пријављивање.';
$string['logs'] = 'записи';
$string['managemnetpeers'] = 'Управљање равноправним серверима';
$string['method'] = 'Метод';
$string['methodhelp'] = 'Помоћ за метод {$a}';
$string['methodsavailableonhost'] = 'Методе доступне на {$a}';
$string['methodsavailableonhostinservice'] = 'Методе доступне за {$a->service} на {$a->host}';
$string['methodsignature'] = 'Метод потписа за {$}';
$string['mnet'] = 'MNet (Moodle умрежавање)';
$string['mnet_concatenate_strings'] = 'Споји (до) 3 знаковна низа и врати резултате';
$string['mnet_session_prohibited'] = 'Корисницима на Вашем серверу тренутно није дозвољено да лутају до {$a}.';
$string['mnetdisabled'] = 'MNet  је <strong>онемогућен</strong>.';
$string['mnetidprovider'] = 'ID ознака MNet провајдера';
$string['mnetidproviderdesc'] = 'Можете да употребите ову процедуру како бисте поново преузели линк за пријаву, под условом да можете да обезбедите исправну адресу е-поште која одговара корисничком имену са којим сте претходно покушали да се пријавите.';
$string['mnetidprovidermsg'] = 'Требало би да имате могућност да се пријавите код свог провајдера  {$a}';
$string['mnetidprovidernotfound'] = 'Нажалост, није могуће пронаћи више информација.';
$string['mnetpeers'] = 'Равноправни уређаји';
$string['mnetservices'] = 'Услуге';
$string['mnetsettings'] = 'MNet подешавања';
$string['moodle_home_help'] = 'Путања до почетне странице MNet апликације тј. Moodlea на удаљеном рачунару, нпр. /moodle/.';
$string['name'] = 'Назив';
$string['net'] = 'Умрежавање';
$string['networksettings'] = 'Мрежна подешавања';
$string['never'] = 'Никад';
$string['noaclentries'] = 'Нема уноса у листи контроле приступа SSO.';
$string['noaddressforhost'] = 'Опростите, али назив сервера ({$a}) није било могуће разрешити.';
$string['nocurl'] = 'PHP cURL библиотека није инсталирана';
$string['nolocaluser'] = 'За удаљеног корисника не постоји локални запис, нити он може бити креиран будући да овај сервер не креира нове кориснике аутоматски. Контактирајте свог адмимнистратора!';
$string['nomodifyacl'] = 'Није вам дозвољено да мењате MNet листу за контролу приступа.';
$string['nonmatchingcert'] = 'Предмет сертификата: <br /><em>{$a->subject}</em><br />се не подудара са рачунаром са којег је долази: <br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'Било је проблема са преузимањем јавног кључа.<br />Можда рачунар не дозвољава Moodle умрежавање (MNet), или је кључ неисправан.';
$string['nosite'] = 'Није пронађен курс на нивоу сајта';
$string['nosuchfile'] = 'Датотека/фукција {$a} не постоји.';
$string['nosuchfunction'] = 'Фукција није пронађена, или је забрањена за RPC.';
$string['nosuchmodule'] = 'Функција је неисправно адресирана и не може бити лоцирана. Молимо вас да користите формат mod/modulename/lib/functionname.';
$string['nosuchpublickey'] = 'Није пронађен јавни кључ за верификацију потписа.';
$string['nosuchservice'] = 'RPC услуга није укључена на овом рачунару.';
$string['nosuchtransport'] = 'Не постоји транспорт који има тај ID';
$string['notBASE64'] = 'Овај знаковни низ није у base64 кодираном формату. Не може бити исправан кључ.';
$string['notPEM'] = 'Овај кључ није у PEM формату. Неће радити.';
$string['not_in_range'] = 'IP адреса  <code>{$a}</code>  не представља исправан поуздан рачунар.';
$string['notenoughidpinfo'] = 'Провајдер вашег идентитета нам не даје довољно информација за креирање или ажурирање Вашег локалног налога.';
$string['notinxmlrpcserver'] = 'Покушај приступа MNet удаљеном клијенту, изван прериода када сервер извршава XMLRPC';
$string['notmoodleapplication'] = 'УПОЗОРЕЊЕ: Ово није Моодле апликација, тако да неке од метода инспекције можда неће исправно радити.';
$string['notpermittedtojump'] = 'Немате овлашћење да почнете удаљену сесију са овог Moodle сервера.';
$string['notpermittedtojumpas'] = 'Не можете да започнете удаљену сесију док сте пријављени под другим корисничким именом.';
$string['notpermittedtoland'] = 'Немате дозволу да почнете удаљену сесију.';
$string['off'] = 'Искључено';
$string['on'] = 'Укључено';
$string['options'] = 'Опције';
$string['peerprofilefielddesc'] = 'Овде можете променити глобална подешавања о томе која поља корисничког профила се шаљу или увозе при креирању нових корисничких налога';
$string['permittedtransports'] = 'Дозвољени транспорти';
$string['phperror'] = 'Унутрашња PHP грешка је спречила испуњење вашег захтева.';
$string['position'] = 'Позиција';
$string['postrequired'] = 'Функција брисања захтева POST захтев.';
$string['privacy:metadata'] = 'MNet додатак не чува никакве личне податке.';
$string['profileexportfields'] = 'Поља за слање';
$string['profilefielddesc'] = 'Овде можете подесити списак поља корисничког профила која се шаљу и примају преко MNet мреже када се креирају нови или ажурирају постојећи кориснички налози. Можете, такође, да променити овај списак поља за сваки MNet сервер појединачно. Узмите у обзир да се следећа поља УВЕК шаљу и да нису опциона: {$a}';
$string['profilefields'] = 'Поља профила';
$string['profileimportfields'] = 'Поља за увоз';
$string['promiscuous'] = 'Промискуитетни';
$string['publickey'] = 'Јавни кључ';
$string['publickey_help'] = 'Јавни кључ се аутоматски преузима са удаљеног сервера.';
$string['publickeyrequired'] = 'Морате да обезбедите јавни кључ';
$string['publish'] = 'Објави';
$string['reallydeleteserver'] = 'Да ли сте сигурни да желите да обришете сервер?';
$string['receivedwarnings'] = 'Примљена су следећа упозорења';
$string['recordnoexists'] = 'Запис не постоји.';
$string['reenableserver'] = 'Не - изаберите ову опцију да поново активирате овај сервер.';
$string['registerallhosts'] = 'Региструј све хост рачунаре (неселективни режим рада)';
$string['registerallhostsexplain'] = 'Можете изабрати да аутоматски региструјете све рачунаре који покушавају аутоматски да се повежу са вама.
Ово значи да ће се појавити запис у вашој листи хост рачунара за било који MNet сајт који се са вама повезује и тражи ваш јавни кључ.<br />У наставку имате опцију да подесите сервисе за \'Све рачунаре\'. Активирањем неких од сервиса  бићете у могућности да их обезбедите било ком удаљеном серверу, без изузетка.';
$string['registerhostsoff'] = 'Региструј све хост рачунаре који су тренутно <b>искључени</b>';
$string['registerhostson'] = 'Региструј све хост рачунаре који су  тренутно <b>укључени</b>';
$string['remotecourses'] = 'Удаљени курсеви';
$string['remotehost'] = 'Удаљени сервер';
$string['remotehosts'] = 'Удаљени рачунари';
$string['remoteuser'] = 'Удаљени {$a->remotetype} корисник';
$string['remoteuserinfo'] = 'Профил је преузет са <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Умрежавање захтева OpenSSL екстензију';
$string['restore'] = 'Рестаурирај';
$string['returnvalue'] = 'Повратна вредност';
$string['reviewhostdetails'] = 'Прегледај детаље сервера';
$string['reviewhostservices'] = 'Прегледај услуге сервера';
$string['selectaccesslevel'] = 'Молимо Вас да изаберете ниво приступа са листе';
$string['selectahost'] = 'Молимо изаберите удаљени Moodle рачунар.';
$string['service'] = 'Назив сервиса';
$string['serviceid'] = 'ID сервиса';
$string['servicesavailableonhost'] = 'Сервиси доступни на {$a}';
$string['serviceswepublish'] = 'Услуге које објављујемо за {$a}.';
$string['serviceswesubscribeto'] = 'Услуге на {$a} које пратимо.';
$string['settings'] = 'Подешавања';
$string['showlocal'] = 'Покажи локалне кориснике';
$string['showremote'] = 'Покажи удаљене кориснике';
$string['ssl_acl_allow'] = 'SSO ACL: Дозволи приступ кориснику \'{$a->user}\' са рачунара \'{$a->host}\'';
$string['ssl_acl_deny'] = 'SSO ACL: Забрани приступ кориснику \'{$a->user}\' са рачунара \'{$a->host}\'';
$string['sslverification'] = 'SSL верификација';
$string['sslverification_help'] = 'Ова опција вам дозвољава да подесите ниво безбедности када се повезујете на други равноправан уређај коришћењем HTTPS-а.

* Без: нема нивоа безбедности
* Потврди само домаћина: потврђује домен SSL сертификата
* Потврди домаћина и равноправан уређај (препоручено): потврђује домен и издавача SSL сертификата';
$string['ssoaccesscontrol'] = 'SSO контрола приступа';
$string['ssoacldescr'] = 'Користите ову страну да дозволите/одбијете приступ одређеном кориснику са удаљеног MNet рачунара. Ово је корисно ако удаљеним корисницима пружате SSO сервис. Како бисте контролисали могућност ваших <em>локалних</em> корисника да се пријављују на друге MNet хост рачунаре, употребите систем улога да бисте им одобрили <em>mnetlogintoremote</em> способност.';
$string['ssoaclneeds'] = 'Да би ова опција могла да ради, морате да укључите Moodle умрежавање, као и MNet додатак за проверу идентитета.';
$string['strict'] = 'Строго';
$string['subscribe'] = 'Прати';
$string['system'] = 'Систем';
$string['testclient'] = 'MNet тест клијент';
$string['testtrustedhosts'] = 'Тестирај адресу';
$string['testtrustedhostsexplain'] = 'Унесите IP адресу да видите да ли је то сигуран рачунар.';
$string['theypublish'] = 'Они објављују';
$string['theysubscribe'] = 'Они су претплаћени';
$string['transport_help'] = 'Ове опције су реципрочне, тако да можете натерати удаљени рачунар да користи потписани SSL сертификат ако Ваш сервер такође поседује потписан SSL сертификат.';
$string['trustedhosts'] = 'XML-RPC рачунари';
$string['trustedhostsexplain'] = '<p>Механизам поузданих рачунара дозвољава одређеним машинама да извршавају позиве преко XML-RPC било ком делу Moodle API-а. Ова опција је доступнa како би скрипте контролисале понашање Moodleа, и може бити веома опасна. Ако нисте сигурни, оставите је искључену.</p>
<p><strong>Опција није неопходнa за било коју стандардну MNet функцију!</strong>. Укључите је само уколико тачно знате шта радите.</p>
<p>Да бисте је омогућили, унесите списак IP адреса или мрежа, по једну у сваки ред.
Неки примери:</p>Ваш локални рачунар:<br />127.0.0.1<br />Ваш локални рачунар (са мрежним блоком):<br />127.0.0.1/32<br />Само рачунар са IP адресом 192.168.0.7:<br />192.168.0.7/32<br />Било који хост рачунар са IP адресом између 192.168.0.1 и 192.168.0.255:<br />192.168.0.0/24<br />Било који хост рачунар:<br />192.168.0.0/0<br />Наравно, последњи пример се <strong>не препоручује</strong>.';
$string['turnitoff'] = 'Искључи';
$string['turniton'] = 'Укључи';
$string['type'] = 'Тип';
$string['unknown'] = 'Непознато';
$string['unknownerror'] = 'Непозната грешка се догодила током преговарања.';
$string['usercannotchangepassword'] = 'Овде не можете променити лозинку пошто сте удаљени корисник.';
$string['userchangepasswordlink'] = '<br />Можда ћете моћи да промените своју лозинку код свог <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> добављача.';
$string['usernotfullysetup'] = 'Ваш кориснички налог није потпун. Морате да да се вратите на <a href="{$a}">свој изворни Moodle сајт</a> и проверите да ли су унети сви подаци у Ваш профил. Можда ћете морати да се одјавити и поново пријавити како би те измене могле да се ажурирају и на овом сајту.';
$string['usersareonline'] = 'Упозорење: број корисника са тог сервера који су тренутно пријављени на Ваш сајт је {$a}.';
$string['validated_by'] = 'Исправност проверава мрежа: <code>{$a}</code>';
$string['verifyhostandpeer'] = 'Потврди домаћина и равноправан уређај';
$string['verifyhostonly'] = 'Потврди само домаћина';
$string['verifysignature-error'] = 'Неуспешна провера исправности потписа: јавила се грешка.';
$string['verifysignature-invalid'] = 'Неуспешна провера исправности потписа. Изгеда да ове корисничке податке нисте потписали Ви.';
$string['version'] = 'Верзија';
$string['warning'] = 'Упозорење';
$string['wrong-ip'] = 'Ваша IP адреса се не подудара са адресом коју имамо у запису.';
$string['xmlrpc-missing'] = 'XML-RPC мора бити инсталиран на Вашој верзији PHP-а како бисте могли да користите ову функцију.';
$string['yourhost'] = 'Ваш рачунар';
$string['yourpeers'] = 'Ваши равноправни уређаји';
