<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'nl', version '4.2'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Toegangscontrole';
$string['actionaftercorrectanswer'] = 'Actie na juist antwoord';
$string['actionaftercorrectanswer_help'] = 'Na een juist antwoord op een vraag zijn er 3 opties voor de volgende pagina:

* Normaal - Volgt het lesverloop
* Toon een ongeziene pagina - Toont een willekeurige pagina die nog niet eerder werd getoond, één enkele keer
* Toon een onbeantwoorde pagina - Toont een willekeurige pagina die nog niet eerder werd beantwoord, hoewel misschien eerder getoond';
$string['actions'] = 'Acties';
$string['activitylink'] = 'Link naar volgende activiteit';
$string['activitylink_help'] = 'Om een link te plaatsen op het einde van de les naar een andere activiteit in de cursus kun je de activiteit selecteren uit het rolmenu.';
$string['activitylinkname'] = 'Ga naar {$a}';
$string['activityoverview'] = 'Je hebt lessen te voltooien';
$string['addabranchtable'] = 'Voeg een pagina toe';
$string['addanendofbranch'] = 'Voeg het einde van een tak toe';
$string['addanewpage'] = 'Voeg een nieuwe pagina toe';
$string['addaquestionpage'] = 'Voeg een vragenpagina toe';
$string['addaquestionpagehere'] = 'Voeg hier een vragenpagina toe';
$string['addbranchtable'] = 'Voeg een inhoudspagina toe';
$string['addcluster'] = 'Voeg een cluster toe';
$string['addedabranchtable'] = 'Inhoudspagina toegevoegd';
$string['addedanendofbranch'] = 'Einde van een tak toegevoegd';
$string['addedaquestionpage'] = 'Vragenpagina toegevoegd';
$string['addedcluster'] = 'Cluster toegevoegd';
$string['addedendofcluster'] = 'Einde van een cluster toegevoegd';
$string['addendofbranch'] = 'Voeg einde van vertakking toe';
$string['addendofcluster'] = 'Voeg het einde van een cluster toe';
$string['addessay'] = 'Maak een open vraagpagina';
$string['addmatching'] = 'Maak een koppelvraagpagina';
$string['addmultichoice'] = 'Maak een meerkeuzevraagpagina';
$string['addnewgroupoverride'] = 'Voeg groep verschrijving toe';
$string['addnewuseroverride'] = 'Voeg gebruiker overschrijven toe';
$string['addnumerical'] = 'Maak een numerieke vraagpagina';
$string['addpage'] = 'Pagina toevoegen';
$string['addshortanswer'] = 'Maak een kort antwoordpagina';
$string['addtruefalse'] = 'Maak een waar-/niet waarpagina';
$string['allotheranswers'] = 'Alle andere antwoorden';
$string['allotheranswersjump'] = 'Alle andere antwoorden springen';
$string['allotheranswersscore'] = 'Alle andere antwoorden scoren';
$string['allowofflineattempts'] = 'Sta toe lessen offline te proberen met de mobiele app';
$string['allowofflineattempts_help'] = 'Indien ingeschakeld zal een mobiele app-gebruiker de les kunnen downloaden en offline een poging maken.
Alle mogelijke antwoorden en juiste antwoorden zullen ook gedownload worden.
Opmerking: een les kan niet offline geprobeerd worden als er een tijdslimiet op zit.';
$string['anchortitle'] = 'Begin van de hoofdinhoud';
$string['and'] = 'EN';
$string['answer'] = 'Antwoord';
$string['answeredcorrectly'] = 'juist geantwoord.';
$string['answersfornumerical'] = 'Antwoorden voor numerieke vragen moeten koppels zijn van de minimum- en de maximumwaarde';
$string['arrangebuttonshorizontally'] = 'Inhoudsknoppen horizontaal schikken?';
$string['attempt'] = 'Poging: {$a}';
$string['attemptheader'] = 'Poging';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Pogingen';
$string['attemptsdeleted'] = 'Verwijderde pogingen';
$string['attemptsremaining'] = 'Je kan nog {$a} poging(en) doen';
$string['available'] = 'Beschikbaar vanaf';
$string['averagescore'] = 'Gemiddelde score';
$string['averagetime'] = 'Gemiddelde tijd';
$string['branch'] = 'Inhoud';
$string['branchtable'] = 'Inhoud';
$string['cachedef_overrides'] = 'Informatie gebruiker- en groepsoverschrijving';
$string['cancel'] = 'Annuleer';
$string['cannotfindanswer'] = 'Fout: kon antwoord niet vinden';
$string['cannotfindattempt'] = 'Fout: kon poging niet vinden';
$string['cannotfindessay'] = 'Fout: kon open vraag niet vinden';
$string['cannotfindfirstgrade'] = 'Fout: kon cijfers niet vinden';
$string['cannotfindfirstpage'] = 'Kon eerste pagina niet vinden';
$string['cannotfindgrade'] = 'Fout: kon cijfers niet vinden';
$string['cannotfindnewestgrade'] = 'Fout: kon nieuwste cijfer niet vinden';
$string['cannotfindnextpage'] = 'Lesback-up: volgende pagina niet gevonden';
$string['cannotfindpagerecord'] = 'Voeg het einde van een tak toe: pagina-record niet gevonden';
$string['cannotfindpages'] = 'Kon lespagina\'s niet vinden';
$string['cannotfindpagetitle'] = 'Bevesting verwijderen: paginatitel niet gevonden';
$string['cannotfindpreattempt'] = 'Record van vorige poging niet gevondden!';
$string['cannotfindrecords'] = 'Fout: kon records van les niet vinden';
$string['cannotfindtimer'] = 'Fout: kon records van lestimer niet vinden';
$string['cannotfinduser'] = 'Fout: kon geen gebruikers vinden';
$string['canretake'] = '{$a} mag de les opnieuw doen';
$string['casesensitive'] = 'Regular expressions gebruiken';
$string['casesensitive_help'] = 'Zet een vinkje om regular expressions te gebruiken voor de analyse van de antwoorden.';
$string['checkbranchtable'] = 'Controleer inhoudspagina';
$string['checkedthisone'] = 'hebben dit geantwoord.';
$string['checknavigation'] = 'Controleer de navigatie';
$string['checkquestion'] = 'Controleer de vraag';
$string['classstats'] = 'Statistieken van de klas';
$string['clicktodownload'] = 'Klik op de link om het bestand te downloaden';
$string['closebeforeopen'] = 'Kon deze les niet aanpassen. Je hebt een afsluitdatum opgegeven die vroeger valt dan de startdatum.';
$string['cluster'] = 'Cluster';
$string['clusterjump'] = 'Ongeziene vraag binnen een cluster';
$string['clustertitle'] = 'Cluster';
$string['collapsed'] = 'Samengeplooid';
$string['comments'] = 'Jouw commentaar';
$string['completed'] = 'Voltooid';
$string['completederror'] = 'Voltooi de les';
$string['completethefollowingconditions'] = 'Je moet volgende voorwaarde(n) voltooien in les <b>{$a}</b> voor je verder kan gaan.';
$string['completiondetail:reachend'] = 'Ga door de activiteit tot het einde';
$string['completiondetail:timespent'] = 'Spendeer minstens {$a} aan deze activiteit';
$string['completionendreached'] = 'Vereis lezen tot het einde';
$string['completionendreached_desc'] = 'De leerling moet het einde van de lespagina bereiken voor deze activiteit voltooid is';
$string['completiontimespent'] = 'Leerling moet deze activiteit doen gedurende minstens';
$string['completiontimespentdesc'] = 'Leerling moet deze activiteit minstens {$a} doen';
$string['completiontimespentgroup'] = 'Vereiste gespendeerde tijd';
$string['conditionsfordependency'] = 'Voorwaarde(n) voor deeltaak';
$string['configintro'] = 'De waardes die hier geplaatst worden bepalen de standaard waardes die gebruikt worden in het instellingsformulier voor een nieuwe les activiteit. De instellingen die bij \'Geavanceerd\' staan worden enkel getoond wanneer op de \'Toon meer...\'-link geklikt wordt.';
$string['configmaxanswers'] = 'Standaard maximaal aantal antwoorden per pagina';
$string['configmediaclose'] = 'Toont een sluit-knop als deel van de pop-up waarin het gelinkte mediabestand getoond wordt';
$string['configmediaheight'] = 'Instelling voor de hoogte van de pop-up voor het gelinkte mediabestand';
$string['configmediawidth'] = 'Instelling voor de breedte van de pop-up voor het gelinkte mediabestand';
$string['configpassword_desc'] = 'Of er een wachtwoord vereist is om toegang te krijgen tot de les.';
$string['configslideshowbgcolor'] = 'Achtergrondkleur voor de diashow als die is ingeschakeld';
$string['configslideshowheight'] = 'Instelling voor de hoogte van de diashow als die is ingeschakeld';
$string['configslideshowwidth'] = 'Instelling voor de breedte van de diashow als die is ingeschakeld';
$string['configtimelimit_desc'] = 'Als er een tijdslimiet is ingesteld, dan wordt er een waarschuwing getoond aan het begin van de les en is er een aftelklokje. Indien ingesteld op nul zal er geen tijdslimiet zijn.';
$string['confirmdelete'] = 'Verwijder pagina';
$string['confirmdeletionofthispage'] = 'Bevestig het verwijderen van deze pagina';
$string['congratulations'] = 'Proficiat - je hebt het einde van de les bereikt';
$string['continue'] = 'Ga verder';
$string['continuetoanswer'] = 'Ga verder met het wijzigen van de antwoorden';
$string['continuetonextpage'] = 'Ga naar volgende pagina';
$string['correctanswerjump'] = 'Sprong bij juist antwoord';
$string['correctanswerscore'] = 'Cijfer bij juist antwoord';
$string['correctresponse'] = 'Juist antwoord';
$string['createaquestionpage'] = 'Maak een vragenpagina';
$string['credit'] = 'Krediet';
$string['customscoring'] = 'Aangepaste cijfers';
$string['customscoring_help'] = 'Indien ingeschakeld kan een geheel getal (positief of negatief) ingegeven worden voor elk antwoord.';
$string['deadline'] = 'Deadline';
$string['defaultessayresponse'] = 'Je antwoord op deze open vraag zal door de leraar beoordeeld worden.';
$string['deleteallattempts'] = 'Verwijder alle pogingen';
$string['deletedefaults'] = 'Standaard les {$a} verwijderd';
$string['deletedpage'] = 'Pagina verwijderd';
$string['deletepagenamed'] = 'Verwijder pagina: {$a}';
$string['deleting'] = 'Verwijderen';
$string['deletingpage'] = 'Bezig met pagina {$a} verwijderen';
$string['dependencyon'] = 'Deeltaak van';
$string['dependencyon_help'] = 'Met deze instelling kun je de toegang tot deze les afhankelijk maken van de score van een student voor een andere les in dezelfde cursus. Elke combinatie van gespendeerde tijd, voltooid, of "cijfer hoger dan" kunnen worden gebruikt.';
$string['description'] = 'Beschrijving';
$string['deselectallattempts'] = 'Deselecteer alle pogingen';
$string['detailedstats'] = 'Gedetailleerde statistieken';
$string['didnotanswerquestion'] = 'Deze vraag niet beantwoord';
$string['didnotreceivecredit'] = 'Geen cijfers gekregen';
$string['disabled'] = 'Uitgeschakeld';
$string['displaydefaultfeedback'] = 'Gebruik standaard feedback';
$string['displaydefaultfeedback_help'] = '<p align="center"><strong>Toon standaardfeedback</strong></p>

<p>Als deze instelling op <strong>ja</strong> gezet wordt, dan zal bij het ontbreken van feedback, de standaardfeedback "Juist antwoord" en "Fout antwoord" gebruikt worden.</p>
<p>Als deze instelling op <strong>Nee</strong> gezet wordt, dan zal er bij het ontbreken van feedback niets getoond worden. De gebruiker wordt dan automatisch naar de volgende pagina van de les gebracht worden.</p>';
$string['displayinleftmenu'] = 'Toon in menu?';
$string['displayleftif'] = 'Minimum cijfer om het linkermenu te tonen';
$string['displayleftif_help'] = 'Deze instelling bepaalt of een leerling een bepaald cijfer moet halen voor die het linker menu kan zien. Dit verplicht een leerling om door de hele les te gaan tijdens de eerste poging, dan kan die na het behalen van het vereiste cijfer, het menu gebruiken om na te kijken.';
$string['displayleftmenu'] = 'Toon menu';
$string['displayleftmenu_help'] = 'Indien ingeschakeld, wordt een menu getoond waarmee de gebruiker door een lijst van pagina\'s kan navigeren.';
$string['displaymode'] = 'Weergavemodus';
$string['displayofgrade'] = 'Tonen van het cijfer (voor de leerling)';
$string['displayreview'] = 'Geef de optie om een vraag opnieuw te proberen';
$string['displayreview_help'] = 'Indien ingeschakeld, zal bij een fout antwoord de leerling de optie krijgen om ofwel de vraag vrijblijvend opnieuw te proberen (zonder cijfer), ofwel verder te gaan met de les. Als de leerling klikt om verder te gaan naar een volgende vraag, dan zal het geselecteerde (foute) antwoord gevolgd worden. Standaard wordt de sprong bij een fout antwoord ingesteld op naar "huidige pagina" met een score van 0. Het is daarom aangeraden om de sprong bij fout antwoord in te stellen op een andere pagina om verwarring bij je leerlingen te vermijden.';
$string['displayscorewithessays'] = '<p>Je hebt {$a->score} punten op {$a->tempmaxgrade} behaald voor de automatisch beoordeelde vragen.</p><p>Je {$a->essayquestions} open vragen zullen beoordeeld worden op een later moment  toegevoegd worden bij je totaalcijfer.</p><p>Je resultaat op dit ogenblik, zonder de open vragen is {$a->score} op {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Je cijfer is {$a->score} (op {$a->grade}).';
$string['duplicatepagenamed'] = 'Kopiëer pagina: {$a}';
$string['edit'] = 'Bewerk';
$string['editbranchtable'] = 'Bewerk een inhoudspagina';
$string['editcluster'] = 'Bewerk een cluster';
$string['editendofbranch'] = 'Bewerk het einde van een vertakkingspagina';
$string['editendofcluster'] = 'Bewerk een einde van een clusterpagina';
$string['editessay'] = 'Bewerk een open vraagpagina';
$string['editinglesson'] = 'Les bewerken';
$string['editingquestionpage'] = 'Bewerken {$a} vragenpagina';
$string['editlesson'] = 'Bewerk les';
$string['editlessonsettings'] = 'Bewerk de instellingen van deze les';
$string['editmatching'] = 'Bewerk een koppelvraagpagina';
$string['editmultichoice'] = 'Bewerk een meerkeuzevraagpagina';
$string['editnumerical'] = 'Bewerk een numerieke vraagpagina';
$string['editoverride'] = 'Bewerk overschrijven';
$string['editpage'] = 'Bewerk pagina inhoud';
$string['editpagecontent'] = 'Bewerk de inhoud van deze pagina';
$string['editquestion'] = 'Bewerk een vraagpagina';
$string['editshortanswer'] = 'Bewerk een kort antwoordpagina';
$string['edittruefalse'] = 'Bewerk een waar/niet waar vraagpagina';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Verstuur melding voor de  beoordeelde taken';
$string['emailgradedessays'] = 'Verstuur melding voor de beoordeelde taken';
$string['emailsuccess'] = 'Meldingen verstuurd';
$string['emptypassword'] = 'Wachtwoord kan niet leeg zijn';
$string['enabled'] = 'Ingeschakeld';
$string['endofbranch'] = 'Einde vertakking';
$string['endofcluster'] = 'Einde cluster';
$string['endofclustertitle'] = 'Einde van de cluster';
$string['endoflesson'] = 'Einde van de les';
$string['enteredthis'] = 'hebben dit geantwoord.';
$string['enterpassword'] = 'Geef het wachtwoord:';
$string['eolstudentoutoftime'] = 'Opgelet: je tijd voor deze les is helemaal op. Wanneer je laatste antwoord verstuurd is nadat de tijd op was, dan telt dat niet meer mee.';
$string['eolstudentoutoftimenoanswers'] = 'Je hebt geen enkele vraag beantwoord. Je hebt een 0 voor deze les';
$string['essay'] = 'Open vraag';
$string['essayemailmessage2'] = '<p>Open vraag prompt: {$a->question}</p><p>Jouw antwoord:<em>{$a->response}</em></p><p>Commentaar van de beoordeler:<em>{$a->comment}</em></p><p>Je hebt {$a->earned} op {$a->outof} gekregen voor deze open vraag.</p><p>Je cijfer voor deze les is gewijzigd naar {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Je hebt {$a->earned} ontvangen van {$a->outof} voor deze open vraag. </p><p> Jouw cijfer voor de les {$a->lesson} is gewijzigd in {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Cijfer beschikbaar voor vraag uit les';
$string['essaynotgradedyet'] = 'Deze open vraag is nog niet beoordeeld';
$string['essayresponses'] = 'Antwoord op open vraag';
$string['essays'] = 'Open vragen';
$string['essayscore'] = 'Cijfer voor de open vragen';
$string['eventcontentpageviewed'] = 'Inhoudspagina bekeken';
$string['eventessayassessed'] = 'Open vraag beoordeeld';
$string['eventessayattemptviewed'] = 'Open vraag bekeken';
$string['eventhighscoreadded'] = 'Hoogste cijfer van de les toegevoegd';
$string['eventhighscoresviewed'] = 'Hoogste cijfer van de les bekeken';
$string['eventlessonended'] = 'Les beëindigd';
$string['eventlessonrestarted'] = 'Les gestart';
$string['eventlessonresumed'] = 'Les verder gezet';
$string['eventlessonstarted'] = 'Les begonnen';
$string['eventoverridecreated'] = 'Les overschrijving gemaakt';
$string['eventoverridedeleted'] = 'Les overschrijving verwijderd';
$string['eventoverrideupdated'] = 'Les overschrijving aangepast';
$string['eventpagecreated'] = 'Pagina gemaakt';
$string['eventpagedeleted'] = 'Pagina verwijderd';
$string['eventpagemoved'] = 'Pagina verplaatst';
$string['eventpageupdated'] = 'Pagina aangepast';
$string['eventquestionanswered'] = 'Vraag beantwoord';
$string['eventquestionviewed'] = 'Vraag bekeken';
$string['false'] = 'Onwaar';
$string['fileformat'] = 'Bestandsformaat';
$string['finalwrong'] = 'Niet echt.';
$string['finish'] = 'Einde';
$string['firstanswershould'] = 'Het eerste antwoord moet naar de "juist"-pagina verwijzen';
$string['firstwrong'] = 'Je antwoord is fout.  Wil je de vraag opnieuw proberen te beantwoorden? Als je het antwoord weet, zul je er geen punten meer mee verdienen.';
$string['flowcontrol'] = 'Controle van het verloop';
$string['fractionsaddwrong'] = 'De positieve cijfers die je hebt gekozen tellen niet op tot 100%
<br />In plaats daarvan tellen ze op tot {$a}%
<br />Wil je terug gaan en deze vraag verbeteren?';
$string['fractionsnomax'] = 'Eén van de antwoorden moet 100% zijn, zodat het mogelijk is
<br />om een vol punt voor deze vraag te krijgen.
<br />Wil je terug gaan en deze vraag verbeteren?';
$string['full'] = 'Volledig';
$string['general'] = 'Algemeen';
$string['gotoendoflesson'] = 'Ga naar het einde van de les';
$string['grade'] = 'Cijfer';
$string['gradebetterthan'] = 'Cijfer beter dan (%)';
$string['gradebetterthanerror'] = 'Verdien een cijfer beter dan {$a} procent';
$string['graded'] = 'Beoordeeld';
$string['gradeessay'] = 'Beoordeel open vragen';
$string['gradeis'] = 'Cijfer is {$a}';
$string['gradeoptions'] = 'Beoordelingsopties';
$string['groupoverrides'] = 'Groepsoverschrijvingen';
$string['groupoverridesdeleted'] = 'Groepsoverschrijvingen verwijderd';
$string['groupsnone'] = 'Geen groepen waartoe je toegang hebt.';
$string['handlingofretakes'] = 'Behandeling van nieuwe pogingen';
$string['handlingofretakes_help'] = 'Als opnieuw mag geprobeerd worden, dan bepaalt deze instellingen of het eindcijfer voor de les het gemiddelde of het maximum van alle pogingen wordt.';
$string['havenotgradedyet'] = 'Nog geen cijfer gegeven';
$string['here'] = 'hier';
$string['highscore'] = 'Hoogste score';
$string['hightime'] = 'Langste duur';
$string['importcount'] = '{$a} vragen importeren';
$string['importquestions'] = 'Importeer vragen';
$string['importquestions_help'] = 'Met deze functie kun je vragen importeren uit tekstbestanden.';
$string['inactiveoverridehelp'] = '* Deze overschrijving is niet actief omdat de toegang tot de activiteit beperkt is voor deze gebruiker. Dit kan te wijten zijn aan roltoewijzingen, andere toegangsbeperkingen of de activiteit die verborgen is.';
$string['indicator:cognitivedepth'] = 'Les cognitief';
$string['indicator:cognitivedepth_help'] = 'Deze indicator is gebaseerd op de door de leerling bereikte cognitieve diepte in een Les activiteit.';
$string['indicator:cognitivedepthdef'] = 'Les cognitief';
$string['indicator:cognitivedepthdef_help'] = 'De deelnemer heeft dit percentage van de cognitieve betrokkenheid van de lesactiviteiten tijdens dit analyse-interval bereikt (Niveaus = Geen weergave, Bekijken, Verzenden, Feedback bekijken, Reageren op feedback, Opnieuw verzenden na het bekijken van feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Les sociaal';
$string['indicator:socialbreadth_help'] = 'Deze indicator is gebaseerd op de door de leerling behaalde sociale breedte in een Les activiteit.';
$string['indicator:socialbreadthdef'] = 'Les sociaal';
$string['indicator:socialbreadthdef_help'] = 'De deelnemer heeft dit percentage van de sociale betrokkenheid van de lesactiviteiten tijdens dit analyse-interval bereikt (niveaus = geen deelname, alleen deelnemer, deelnemer met anderen)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Pagina ingevoegd';
$string['invalidfile'] = 'Ingeldig bestand';
$string['invalidid'] = 'Geen cursusmodule ID of le ID is doorgegeven';
$string['invalidlessonid'] = 'Foute les ID';
$string['invalidoverrideid'] = 'Ongeldig overschrijvings-ID';
$string['invalidpageid'] = 'Ongeldige pagina ID';
$string['jump'] = 'Spring';
$string['jumps'] = 'Verspringen';
$string['jumps_help'] = 'Elk antwoord (voor vragen) of beschrijving (voor inhoudelijke pagina\'s) heeft een bijhorende "ga naar"-link. De link kan relatief zijn, zoals \'deze pagina\', \'volgende pagina\' of absoluut, waarbij wordt verwezen naar een bepaalde, specifieke pagina in de les.';
$string['jumpsto'] = 'Verspringen naar  <em>{$a}</em>';
$string['leftduringtimed'] = 'Je bent weggegaan tijdens een getimede les. <br />Klik op ga verder om de les te hervatten.';
$string['leftduringtimednoretake'] = 'Je bent weggegaan tijdens een getimede les.  <br />Je mag niet verder werken.';
$string['leftduringtimedsession'] = 'Je bent weggegaan tijdens een getimede les';
$string['lesson:addinstance'] = 'Voeg een nieuwe les toe';
$string['lesson:edit'] = 'Bewerk een les';
$string['lesson:grade'] = 'Cijfer van de open vragen van de les';
$string['lesson:manage'] = 'Beheer een les';
$string['lesson:manageoverrides'] = 'Beheer lesoverschrijvingen';
$string['lesson:view'] = 'Bekijk lesactiviteit';
$string['lesson:viewreports'] = 'Toon lesrapporten';
$string['lessonbeingpreviewed'] = 'De les wordt momenteel bekeken.';
$string['lessonclosed'] = 'Deze les sluit op {$a}.';
$string['lessoncloses'] = 'Les sluit';
$string['lessoneventcloses'] = '{$a} sluit';
$string['lessoneventopens'] = '{$a} opent';
$string['lessonformating'] = 'Opmaken van de les';
$string['lessonmenu'] = 'Lesmenu';
$string['lessonnotready'] = 'Deze les is nog niet klaar. Contacteer aub je {$a}';
$string['lessonnotready2'] = 'Deze les is niet klaar om te starten';
$string['lessonopen'] = 'Deze les zal openen op {$a}.';
$string['lessonopens'] = 'Les opent';
$string['lessonpagelinkingbroken'] = 'Eerste pagina niet gevonden. Waarschijnlijk is de link naar de lespagina gebroken. Contacteer een beheerder';
$string['lessonstats'] = 'Statistieken van de les';
$string['linkedmedia'] = 'Gelinkte media';
$string['loginfail'] = 'Login mislukt. Probeer nog eens...';
$string['lowscore'] = 'Laagste score';
$string['lowtime'] = 'kortste duur';
$string['manageoverrides'] = 'Overschrijvingen beheren';
$string['manualgrading'] = 'Beoordeel open vragen';
$string['matchesanswer'] = 'Komt overeen met antwoord';
$string['matching'] = 'Koppelen';
$string['matchingpair'] = 'Gekoppeld paar {$a}';
$string['maxgrade'] = 'Maximumcijfer';
$string['maxgrade_help'] = 'Deze waarde bepaalt het maximumcijfer dat gegeven kan worden voor deze les. Als dit op 0 gezet wordt, dan verschijnt het cijfer niet op de cijferlijsten.';
$string['maximumnumberofanswersbranches'] = 'Maximale aantal antwoorden';
$string['maximumnumberofanswersbranches_help'] = 'Deze waarde bepaalt het maximale aantal antwoorden dat kan worden gebruikt in de les. Als de les enkel waar/onwaar-vragen gebruikt, dan kun je deze optie beter op 2 zetten.
De waarde kan op ieder moment worden gewijzigd; een nieuwe instelling heeft immers enkel effect op wat de leraar ziet, en niet op de data.';
$string['maximumnumberofattempts'] = 'Maximale aantal pogingen per vraag';
$string['maximumnumberofattempts_help'] = 'Deze waarde bepaalt het maximale aantal pogingen die een leerling krijgt om een vraag te beantwoorden. Indien het maximum wordt bereikt na telkens opnieuw een foutief antwoord, dan wordt de volgende pagina van de les getoond.';
$string['maximumnumberofattemptsreached'] = 'Maximum aantal pogingen bereikt - we gaan verder naar de volgende pagina.';
$string['mediaclose'] = 'Toon sluit-knop';
$string['mediafile'] = 'Gelinkte media';
$string['mediafile_help'] = 'Er kan een media-bestand geüpload worden om te gebruiken in de les. Er verschijnt een "Klik hier om te bekijken"-link in het blok \'Gelinkte media\' op elke lespagina.';
$string['mediafilepopup'] = 'Klik hier om te bekijken';
$string['mediaheight'] = 'Hoogte pop-upvenster';
$string['mediawidth'] = 'Breedte pop-upvenster';
$string['messageprovider:graded_essay'] = 'Melding beoordeling open vraag van les';
$string['minimumnumberofquestions'] = 'Minimaal aantal vragen';
$string['minimumnumberofquestions_help'] = 'Deze instelling specifieert het minimaal aantal vragen dat het mogelijk maakt om het cijfer voor de activiteit te berekenen.';
$string['missingname'] = 'Geef een schuilnaam';
$string['modattempts'] = 'Laat leerling nalezen';
$string['modattempts_help'] = '<p>Deze instelling zal leerlingen toelaten opnieuw door de les te navigeren en antwoorden te wijzigen.</p>';
$string['modattemptsnoteacher'] = 'Nalezen werkt alleen voor leerlingen';
$string['modulename'] = 'Les';
$string['modulename_help'] = 'Een lesactiviteit geeft de leraar de mogelijkheid om inhoud of oefeningen op een interessante en flexibele manier aan te bieden. Een leraar kan de les gebruiken om een lineaire set van inhoudspagina\'s of instructie-activiteiten te maken. In elk geval kunnen leraren kiezen om he engagement van de leerling te verhogen en om het begrijpen van de inhoud te verzekeren door een variatie aan vragen toe te voegen, zoals meerkeuzevragen, koppelvragen en korte antwoorden. Afhankelijk van het antwoord van de leerling en van hoe de leraar de les opbouwt, kunnen leerlingen dan naar de volgende pagina verder gaan of terug genomen worden naar een eerdere pagina of op een compleet ander pad gezet worden.

Een les kan beoordeeld worden met een cijfer in de cijferlijst.

Les kan gebruikt worden

* voor zelfgestuurd leren van een nieuw onderwerp
* voor scenario\'s of simulaties van oefeningen rond beslissingen nemen
* voor gedifferentieerde herhaling met verschillende herhalingsvragen, afhankelijk van gegeven antwoorden op initiële vragen.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lessen';
$string['move'] = 'Verplaats pagina';
$string['movedpage'] = 'Pagina verplaatst';
$string['movepagehere'] = 'Verplaats de pagina naar hier';
$string['movepagenamed'] = 'Verplaats pagina: {$a}';
$string['moving'] = 'Bezig met pagina {$a} verplaatsen';
$string['multianswer'] = 'Meervoudig antwoord';
$string['multianswer_help'] = 'Vink het selectievakje aan als er meer dan één juist antwoord is.';
$string['multichoice'] = 'Meerkeuze';
$string['multipleanswer'] = 'Meer antwoorden';
$string['nameapproved'] = 'Naam goedgekeurd';
$string['namereject'] = 'Je naam werd geweigerd. Probeer een andere naam.';
$string['new'] = 'nieuw';
$string['nextpage'] = 'Volgende pagina';
$string['noanswer'] = 'Eén of meerdere vragen zijn niet beantwoord. Ga terug en geef een antwoord.';
$string['noattemptrecordsfound'] = 'Geen pogingen gevonden: geen cijfer gegeven.';
$string['nobranchtablefound'] = 'Geen inhoudspagina gevonden';
$string['noclose'] = 'Geen sluitdatum';
$string['nocommentyet'] = 'Nog geen commentaar';
$string['nocoursemods'] = 'Geen activiteiten gevonden';
$string['nocredit'] = 'Geen krediet';
$string['nodeadline'] = 'Geen deadline';
$string['noessayquestionsfound'] = 'Er zijn geen open vragen gevonden in deze les';
$string['nohighscores'] = 'Geen hoogste cijfer';
$string['nolessonattempts'] = 'Niemand heeft deze les gemaakt.';
$string['nolessonattemptsgroup'] = 'Er zijn geen pogingen gedaan door {$a} groepsleden voor deze les.';
$string['none'] = 'Geen';
$string['nooneansweredcorrectly'] = 'Niemand heeft juist geantwoord';
$string['nooneansweredthisquestion'] = 'Niemand heeft deze vraag beantwoord';
$string['noonecheckedthis'] = 'Niemand heeft dit geantwoord.';
$string['nooneenteredthis'] = 'Niemand heeft dit ingegeven';
$string['noonehasanswered'] = 'Niemand heeft een open vraag beantwoord';
$string['noonehasansweredgroup'] = 'Niemand in {$a} heeft deze vraag al beantwoord.';
$string['noopen'] = 'Geen opendatum';
$string['nooverridecreated'] = 'Geen overschrijvingen gemaakt.';
$string['nooverridedata'] = 'Je moet minstens één lesinstelling overschrijven.';
$string['noretake'] = 'Je mag deze les niet opnieuw maken';
$string['normal'] = 'Normaal - volg het lespad';
$string['notcompleted'] = 'Nog niet voltooid';
$string['notcompletedwithdate'] = 'Niet voltooid ({$a})';
$string['notdefined'] = 'Niet gedefinieerd';
$string['notenoughsubquestions'] = 'Er zijn onvoldoende deelvragen gedefinieerd!<br />Wil je teruggaan en deze vraag herstellen?';
$string['notenoughtimespent'] = 'Je hebt deze les voltooid in {$a->timespent}, wat minder is dan de vereiste tijd van {$a->timerequired}. Misschien wil je deze les nog eens overdoen.';
$string['notgraded'] = 'Niet beoordeeld';
$string['notitle'] = 'Geen titel';
$string['notyetcompleted'] = 'Les is gestart maar nog niet voltooid.';
$string['numberofcorrectanswers'] = 'Aantal juiste antwoorden: {$a}';
$string['numberofcorrectanswersheader'] = 'Aantal juiste antwoorden';
$string['numberofcorrectmatches'] = 'Aantal juiste koppelingen: {$a}';
$string['numberofpagestoshow'] = 'Aantal te tonen pagina\'s';
$string['numberofpagestoshow_help'] = '<p>Deze pagina wordt alleen maar gebruikt in lessen met Flash Cards. De standaardwaarde is nul, wat betekent dat alle pagina\'s/Flash Cards in de les getoond worden. Door deze parameter op een andere waarde dan nul te zetten, worden slechts dat aantal pagina\'s getoond. Als dat aantal pagina\'s/Flash Cards getoond is, krijgt de leerling te zien dat het einde van de les bereikt is en wordt zijn cijfer getoond.</p>

<p>Als deze parameter op een getal groter dan het aantal pagina\'s in de les is ingesteld, dan wordt het einde van de les bereikt als alle pagina\'s getoond zijn.</p>';
$string['numberofpagesviewed'] = 'Aantal beantwoorde vragen: {$a}';
$string['numberofpagesviewedheader'] = 'Aantal beantwoorde vragen';
$string['numberofpagesviewednotice'] = 'Aantal beantwoorde vragen: {$a->nquestions} (je moet minstens {$a->minquestions} vragen beantwoorden)';
$string['numerical'] = 'Numeriek';
$string['numericanswer'] = 'Numeriek antwoord';
$string['numericanswer_help'] = 'Je kunt een nummer of een reeks nummers specificeren door een dubbele punt te gebruiken. Bijvoorbeeld 2: 5 betekent dat elk antwoord tussen 2 en 5 inclusief het juiste is.';
$string['offlinedatamessage'] = 'Je hebt aan deze poging gewerkt met een mobiel toestel. De laatste gegevens hierover zijn op deze site {$a} geleden bewaard. Controleer of je geen onbewaard werk hebt.';
$string['ongoing'] = 'Toon het huidige cijfer';
$string['ongoing_help'] = 'Indien ingeschakeld, zal elke pagina het huidig aantal verdiende punten uit het mogelijk totaal tonen.';
$string['ongoingcustom'] = 'Dit is een les op {$a->score} punten. Je hebt nu al {$a->score} punten verdiend van de {$a->currenthigh} punten die er tot nu toe te verdienen waren.';
$string['ongoingnormal'] = 'Je hebt {$a->correct} vragen van de {$a->viewed} juist beantwoord.';
$string['onpostperpage'] = 'Slechts één bericht per cijfer';
$string['openafterclose'] = 'Je hebt een startdatum opgegeven na de einddatum';
$string['options'] = 'Opties';
$string['or'] = 'OF';
$string['ordered'] = 'Gesorteerd';
$string['other'] = 'Andere';
$string['outof'] = 'Van {$a}';
$string['override'] = 'Overschrijven';
$string['overridedeletegroupsure'] = 'Weet je zeker dat je de overschrijving voor groep {$a} wil verwijderen?';
$string['overridedeleteusersure'] = 'Weet je zeker dat je de overschrijving voor gebruiker {$a} wil verwijderen?';
$string['overridegroup'] = 'Overschrijf groep';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Overschrijvingen';
$string['overrideuser'] = 'Overschrijf gebruiker';
$string['overrideusereventname'] = '{$a->lesson} - Overschrijf';
$string['overview'] = 'Overzicht';
$string['overview_help'] = 'Een les is opgebouwd uit een aantal pagina\'s en optioneel een aantal inhoudspagina\'s. Een pagina bevat een zekere inhoud en eindigt gewoonlijk met een vraag.
Aan elk antwoord op de vraag is een sprong verbonden. De sprong kan relatief zijn, zoals deze pagina of volgende pagina, of absoluut verwijzen naar om het even welke pagina in de les. Een inhoudspagina is een pagina die een reeks links naar andere pagina\'s in de les bevat, zoals bijvoorbeeld een inhoudsopgave.';
$string['page'] = 'Pagina: {$a}';
$string['page-mod-lesson-edit'] = 'Bewerk lespagina';
$string['page-mod-lesson-view'] = 'Bekijk of bekijk voorbeeld van lespagina';
$string['page-mod-lesson-x'] = 'Elke lespagina';
$string['pageanswers'] = 'Pagineer antwoorden';
$string['pagecontents'] = 'Inhoud van de pagina';
$string['pageresponses'] = 'Pagineer reacties';
$string['pages'] = 'Pagina\'s';
$string['pagetitle'] = 'Titel van de pagina';
$string['password'] = 'Wachtwoord';
$string['passwordprotectedlesson'] = '{$a} is met een wachtwoord beveiligd.';
$string['pleasecheckoneanswer'] = 'Kies één antwoord';
$string['pleasecheckoneormoreanswers'] = 'Duid één of meer antwoorden aan';
$string['pleaseenteryouranswerinthebox'] = 'Geef je antwoord in het vakje';
$string['pleasematchtheabovepairs'] = 'Koppel bovenstaande paren';
$string['pluginadministration'] = 'Beheer les';
$string['pluginname'] = 'Les';
$string['pointsearned'] = 'Verdiende punten';
$string['postprocesserror'] = 'Fout opgetreden tijdens de verwerking!';
$string['postsuccess'] = 'Posten gelukt';
$string['practice'] = 'Oefenles';
$string['practice_help'] = 'Een oefenles zal niet in de cijferlijst verschijnen.';
$string['preprocesserror'] = 'Fout opgetreden tijdens de voorbereiding!';
$string['prerequisiteisobsolete'] = 'De optie voor voorwaarden bij lessen zal worden verwijderd. Gebruik vanaf nu toegangsbeperkingen.';
$string['prerequisitelesson'] = 'Voorwaarde les';
$string['preview'] = 'Voorbeeld';
$string['previewlesson'] = 'Voorbeeld van {$a}';
$string['previewpagenamed'] = 'Voorbeeld van pagina: {$a}';
$string['previouspage'] = 'Vorige pagina';
$string['privacy:metadata:attempts'] = 'Gegevens over pagina-pogingen';
$string['privacy:metadata:attempts:answerid'] = 'Het antwoord-ID';
$string['privacy:metadata:attempts:correct'] = 'Of de poging correct was';
$string['privacy:metadata:attempts:pageid'] = 'De paginaID';
$string['privacy:metadata:attempts:retry'] = 'Het pogingnummer';
$string['privacy:metadata:attempts:timeseen'] = 'Tijdstip waarop de poging gedaan werd';
$string['privacy:metadata:attempts:useranswer'] = 'Details over het antwoord van de gebruiker';
$string['privacy:metadata:attempts:userid'] = 'GebruikersID';
$string['privacy:metadata:branch'] = 'Gegevens over de bekeken pagina\'s';
$string['privacy:metadata:branch:flag'] = 'Of de pagina willekeurig berekend was';
$string['privacy:metadata:branch:nextpageid'] = 'De volgende paginaID';
$string['privacy:metadata:branch:pageid'] = 'De paginaID';
$string['privacy:metadata:branch:retry'] = 'Het pogingnummer';
$string['privacy:metadata:branch:timeseen'] = 'Tijdstip waarop de pagina bekeken werd';
$string['privacy:metadata:branch:userid'] = 'GebruikersID';
$string['privacy:metadata:grades'] = 'Gegevens over de cijfers voor elke les';
$string['privacy:metadata:grades:completed'] = 'De datum waarop het cijfer gegeven is';
$string['privacy:metadata:grades:grade'] = 'Het gegeven cijfer';
$string['privacy:metadata:grades:userid'] = 'De gebruikersID';
$string['privacy:metadata:overrides'] = 'Gegevens over overschrijvingen per les';
$string['privacy:metadata:overrides:available'] = 'Tijdstip waarop een leerlingen een poging voor een les kan beginnen';
$string['privacy:metadata:overrides:deadline'] = 'Tijdstip waarop leerlingen hun poging voor de les voltooid moeten hebben.';
$string['privacy:metadata:overrides:maxattempts'] = 'Het maximaal aantal pogingen';
$string['privacy:metadata:overrides:password'] = 'Het wachtwoord om toegang tot de les te krijgen';
$string['privacy:metadata:overrides:retake'] = 'Of er meerdere pogingen toegestaan zijn';
$string['privacy:metadata:overrides:review'] = 'Of het opnieuw proberen van een vraag is toegestaan';
$string['privacy:metadata:overrides:timelimit'] = 'Tijd om de les te voltooien in seconden.';
$string['privacy:metadata:overrides:userid'] = 'De gebruikersID';
$string['privacy:metadata:timer'] = 'Gegevens over de poging van een les';
$string['privacy:metadata:timer:completed'] = 'Of de poging volledig is';
$string['privacy:metadata:timer:lessontime'] = 'Het laatste moment waarop we activiteit gezien hebben';
$string['privacy:metadata:timer:starttime'] = 'De datum waarop de poging startte';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Het laatste moment waarop we activiteit gezien hebben van de mobiele app';
$string['privacy:metadata:timer:userid'] = 'De gebruikersID';
$string['privacy:metadata:userpref:lessonview'] = 'De gekozen displaymodus wanneer lessen bewerkt worden';
$string['privacy:path:essayanswers'] = 'Open vraag-antwoorden';
$string['privacy:path:essayresponses'] = 'Antwoorden op open vragen';
$string['privacy:path:pages'] = 'Pagina\'s';
$string['processerror'] = 'Fout opgetreden tijdens de verwerking!';
$string['progressbar'] = 'Vorderingsbalk';
$string['progressbar_help'] = 'Indien ingeschakeld, krijg je een vorderingsbalk te zien onderaan de les pagina\'s. Deze vorderingsbalk toont bij nadering het percentage dat is voltooid.';
$string['progressbarteacherwarning'] = 'Vorderingsbalk niet tonen voor {$a}';
$string['progressbarteacherwarning2'] = 'Je zult de vorderingsbalk niet zien omdat je deze les kunt bewerken';
$string['progresscompleted'] = 'Je hebt {$a}% van de les beëindigd';
$string['qtype'] = 'Paginatype';
$string['question'] = 'Vraag';
$string['questionoption'] = 'Vraagoptie';
$string['questiontype'] = 'Vraagtype';
$string['randombranch'] = 'Willekeurige inhoudspagina';
$string['randompageinbranch'] = 'Willekeurige vraag binnen een inhoudspagina';
$string['rank'] = 'Rangschikking';
$string['rawgrade'] = 'Ruwe score';
$string['receivedcredit'] = 'Behaalde score';
$string['redisplaypage'] = 'Toon pagina opnieuw';
$string['removeallgroupoverrides'] = 'Verwijder alle groepsoverschrijvingen';
$string['removealluseroverrides'] = 'Verwijder alle gebruikersoverschrijvingen';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporten';
$string['response'] = 'Feedback';
$string['retakesallowed'] = 'Opnieuw doen toegelaten';
$string['retakesallowed_help'] = '<p>Deze instelling bepaalt of de leerlingen de les meer dan eens kunnen doormaken of slechts één keer. De leraar kan beslissen of deze les materiaal bevat dat de leerlingen erg grondig moeten kennen. In dat geval moet het herhaald bekijken van de les toegelaten worden. Als het materaal eerder gebruikt wordt om te testen, dan kun je er beter voor kiezen de les maar één keer te laten doornemen.</p>

<p>Als de leerlingen de les mogen overdoen, dan wordt voor de <b>cijfers</b> in de cijfertabel hun <b>beste</b> poging gekozen. Nochtans worden voor de <b>vragen analyse</b> altijd de antwoorden van de eerste pogingen genomen. De volgende antwoorden worden genegeerd.</p>

<p>Merk op: de <b>Vraaganalyse</b> gebruikt altijd de antwoorden van de eerste poging van de les. De volgende pogingen worden genegeerd.</p>

<p>De standaardinstelling van deze optie is <b>Ja</b>, wat wil zeggen dat leerlingen de les opnieuw mogen doornemen. Waarschijnlijk moet deze optie slechts in uitzonderlijke gevallen op <b>Nee</b> gezet worden.</p>';
$string['returnto'] = 'Keer terug naar {$a}';
$string['returntocourse'] = 'Keer terug naar de cursuspagina';
$string['reverttodefaults'] = 'Zet les terug op standaardinstellingen';
$string['review'] = 'Nalezen';
$string['reviewlesson'] = 'Les nalezen';
$string['reviewquestionback'] = 'Ja, ik wil nog eens proberen';
$string['reviewquestioncontinue'] = 'Nee, ik wil naar de volgende vraag gaan';
$string['sanitycheckfailed'] = 'Fouten gevonden: deze poging wordt verwijderd';
$string['save'] = 'Bewaar';
$string['savechanges'] = 'Bewaar wijzigingen';
$string['savechangesandeol'] = 'Bewaar alle wijzigingen en ga naar het einde van de les';
$string['saveoverrideandstay'] = 'Bewaar en geef nog een overschrijving';
$string['savepage'] = 'Bewaar pagina';
$string['score'] = 'Cijfer';
$string['score_help'] = 'Als aangepaste score is ingeschakeld in de les, dan kun je een geheel getal (positief of negatief) als waarde ingeven voor elk antwoord.';
$string['scores'] = 'Cijfers';
$string['search:activity'] = 'Les - activiteitsinformatie';
$string['secondpluswrong'] = 'Niet echt. Wil je nog eens proberen?';
$string['selectallattempts'] = 'Selecteer alle pogingen';
$string['selectaqtype'] = 'Kies een vraagtype';
$string['selectreport'] = 'Selecteer rapport';
$string['sent'] = 'Verstuurd';
$string['shortanswer'] = 'Kort antwoord';
$string['showanunansweredpage'] = 'Toon een onbeantwoorde pagina';
$string['showanunseenpage'] = 'Toon een ongeziene pagina';
$string['singleanswer'] = 'Eén enkel antwoord';
$string['skip'] = 'Sla navigatie over';
$string['slideshow'] = 'Diavoorstelling';
$string['slideshow_help'] = '<p>Hiermee kun je de les als een diavoorstelling tonen, met een vaste breedte, hoogte en een aangepaste achtergrondkleur. Een op CSS gebaseerde rolbalk wordt getoond als de breedte of hoogte van de dia overschreden wordt door de inhoud van de pagina.
Standaard worden vragen niet getoond in een diavoorstelling, alleen vertakkingstabellen verschijnen. Knoppen met labels voor "Terug" en "Verder" worden links en rechts van de dia getoond als die optie gekozen is. Andere knoppen worden in het midden van de dia geplaatst.</p>';
$string['slideshowbgcolor'] = 'Achtergrondkleur van de diavoorstelling';
$string['slideshowheight'] = 'Hoogte van de diavoorstelling';
$string['slideshowwidth'] = 'Breedte van de diavoorstelling';
$string['startlesson'] = 'Start de les';
$string['studentattemptlesson'] = 'Pogingnummer {$a->attempt} van {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} naam';
$string['studentoneminwarning'] = 'Waarschuwing: je hebt nog één minuut of minder om deze les te voltooien.';
$string['studentoutoftimeforreview'] = 'Opgelet: je hebt geen tijd meer om deze les te herbekijken';
$string['studentresponse'] = 'Het antwoord van {$a}';
$string['submit'] = 'Insturen';
$string['submitname'] = 'Geef een naam';
$string['teacherjumpwarning'] = 'Er wordt een {$a->cluster} sprong of een {$a->unseen} sprong gebruikt in deze les. De sprong naar de volgende pagina zal in de plaats gebruikt worden. Meld je aan als leerling om deze sprongen te testen.';
$string['teacherongoingwarning'] = 'De score tijdens de les wordt alleen aan leerlingen getoond. Meld je aan als leerling om deze optie te testen';
$string['teachertimerwarning'] = 'De timer werkt enkel voor leerlingen. Test de timer door je als leerling aan te melden.';
$string['thatsthecorrectanswer'] = 'Dat is het juiste antwoord';
$string['thatsthewronganswer'] = 'Dat is het verkeerde antwoord';
$string['thefollowingpagesjumptothispage'] = 'Volgende pagina verwijst naar deze pagina';
$string['thispage'] = 'Deze pagina';
$string['timeisup'] = 'Tijd is verstreken';
$string['timelimit'] = 'Tijdslimiet';
$string['timelimit_help'] = 'Indien ingeschakeld zal een tijdswaarschuwing getoond worden aan het begin van de les en wordt een aftel-timer getoond. Antwoorden die gegeven worden na het verlopen van de tijd worden niet beoordeeld.';
$string['timelimitwarning'] = 'Je hebt nog {$a} om de les te voltooien';
$string['timeremaining'] = 'Resterende tijd';
$string['timespenterror'] = 'Neem minstens {$a} minuten de tijd om de les te maken';
$string['timespentminutes'] = 'Gebruikte tijd (minuten)';
$string['timetaken'] = 'Gebruikte tijd';
$string['totalpagesviewedheader'] = 'Aantal bekeken pagina\'s';
$string['true'] = 'Waar';
$string['truefalse'] = 'Waar/niet waar';
$string['unabledtosavefile'] = 'Het bestand dat je uploadde kon niet bewaard worden';
$string['unknownqtypesnotimported'] = '{$a} vragen met niet ondersteunde vraagtypes werden niet geïmporteerd';
$string['unseenpageinbranch'] = 'Ongeziene vraag binnen een inhoudspagina';
$string['unsupportedqtype'] = 'Vraagtype ({$a}) niet ondersteund';
$string['updatedpage'] = 'Pagina geüpdatet';
$string['updatefailed'] = 'Update mislukt';
$string['updatepagenamed'] = 'Pagina updaten: {$a}';
$string['usemaximum'] = 'Gebruik maximum';
$string['usemean'] = 'Gemiddelde';
$string['usepassword'] = 'Les beschermd met wachtwoord';
$string['usepassword_help'] = '<p>Hiermee zullen leerlingen die het wachtwoord niet kunnen intypen de les niet kunnen beginnen.</p>';
$string['useroverrides'] = 'Gebruikersoverschrijvingen';
$string['useroverridesdeleted'] = 'Gebruikersoverschrijvingen verwijderd';
$string['usersnone'] = 'Geen enkele leerling heeft toegang tot deze les';
$string['viewessayanswers'] = 'Bekijk antwoorden op open vragen';
$string['viewgrades'] = 'Bekijk de cijfers';
$string['viewreports'] = 'Bekijk {$a->attempts} voltooide pogingen van {$a->student}';
$string['viewreports2'] = 'Bekijk {$a} volledige pogingen';
$string['warning'] = 'Waarschuwing';
$string['welldone'] = 'Goed gedaan!';
$string['whatdofirst'] = 'Wat wil je eerst doen?';
$string['withselectedattempts'] = 'Met geselecteerde pogingen';
$string['wronganswerjump'] = 'Verkeerde antwoordsprong';
$string['wronganswerscore'] = 'Verkeerd antwoordcijfer';
$string['wrongresponse'] = 'Verkeerd antwoord';
$string['youhaveseen'] = 'Je hebt al meer dan één pagina van deze les bekeken.<br />Wil je beginnen bij de laatste pagina die je vorige keer bekeken hebt?';
$string['youranswer'] = 'Jouw antwoord';
$string['yourcurrentgradeis'] = 'Je cijfer is nu {$a}';
$string['yourcurrentgradeisoutof'] = 'Je huidige cijfer is {$a->grade} op {$a->total}';
$string['youshouldview'] = 'Je moet een antwoord geven op minstens: {$a}';
