<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'ro', version '4.3'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Despre mine';
$string['actingasrole'] = 'În prezent aveți un rol diferit';
$string['activatetemplateoverride'] = 'Activarea suprascrierii șablonului lui \'{$a}\'';
$string['activitiesheading'] = 'Activități';
$string['alertaccess'] = 'Vizibilitate alertă';
$string['alertaccessadmins'] = 'Vizibil pentru administratori';
$string['alertaccessglobal'] = 'Vizibilitate generală';
$string['alertaccessprofile'] = 'Adaugă restricție personalizată pentru câmpul de profil';
$string['alertaccessusers'] = 'Vizibil utilizatorilor autentificați';
$string['alertannounce'] = 'Anunț';
$string['alertannouncedesc'] = 'Afișează un anunț în alertă.';
$string['alertbackgroundcolorinfo'] = 'Culoare de fundal informații';
$string['alertbackgroundcolorinfodesc'] = 'Culoarea de fundal a alertelor tip informații.';
$string['alertbackgroundcolorsuccess'] = 'Culoarea de fundal a anunțului';
$string['alertbackgroundcolorsuccessdesc'] = 'culoarea de fundal a alertelor de tip anunț.';
$string['alertbackgroundcolorwarning'] = 'Culoarea de fundal a avertizarării';
$string['alertbackgroundcolorwarningdesc'] = 'Culoarea de fundal a alertelor tip Avertizare.';
$string['alertbordercolorinfo'] = 'Culoarea chenarului Informații';
$string['alertbordercolorinfodesc'] = 'Culoarea chenarului alertelor de tip Informații.';
$string['alertbordercolorsuccess'] = 'Culoarea chenarului Anunțuri';
$string['alertbordercolorsuccessdesc'] = 'Culoarea chenarului alertelor de tip Anunț.';
$string['alertbordercolorwarning'] = 'Culoarea chenarului Avertizare';
$string['alertbordercolorwarningdesc'] = 'Culoarea chenarului alertelor de tip Avertisment.';
$string['alertcolorinfo'] = 'Culoare informații';
$string['alertcolorinfodesc'] = 'Culoarea pictogramei alertelor de tip Informații.';
$string['alertcolorsheading'] = 'Culorile alertelor și pictogramelor';
$string['alertcolorsuccess'] = 'Culoarea anunțului';
$string['alertcolorsuccessdesc'] = 'Culoarea pictogramei alertelor de tip anunț.';
$string['alertcolorwarning'] = 'Culoarea avertizării';
$string['alertcolorwarningdesc'] = 'Culoarea pictogramei alertelor tip avertisment.';
$string['alertcount'] = 'Număr de alerte';
$string['alertcountdesc'] = 'Numărul de alerte de afișat în zona de editare de mai jos.';
$string['alertdesc'] = 'Scrieți și personalizați un text pentru a fi afișat în partea de sus a site-ului ca alertă. Este posibil să setați mai mult de o alertă pentru diferite tipuri de utilizatori.';
$string['alertdisabled'] = 'Dezactivat';
$string['alertdisabledesc'] = 'Dezactivați această alertă.';
$string['alerthiddencourse'] = 'Alertă pentru cursul ascuns';
$string['alerthiddencoursedesc'] = 'Avertizați profesorii despre cursurile ascunse.';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = 'click aici pentru actualizare setări';
$string['alerthiddencoursetext-start'] = 'Acest curs este ascuns și nu poate fi accesat de cursanți,';
$string['alerticoninfo'] = 'Pictograma Info';
$string['alerticonsuccess'] = 'Pictogramă anunț';
$string['alerticonwarning'] = 'Pictogramă avertizare';
$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Afișează informație în alertă.';
$string['alertkeyvalue'] = 'Alert key';
$string['alertprofilefield'] = 'Denumire câmp de profil personalizat=Valoare (opțional)';
$string['alertprofilefielddesc'] = 'Adaugă regulă de acces pentru câmpul de profil personalizat, de ex. usertype=cursant.';
$string['alertsettings'] = 'Alertă {$a}';
$string['alertsettingscourse'] = 'Setare alertă curs';
$string['alertsettingsgeneral'] = 'Setările generale ale alertei';
$string['alertsettingsheading'] = 'Alerte';
$string['alerttext'] = 'Text alertă';
$string['alerttextdesc'] = 'Inserați textul de afișat în alertă.';
$string['alerttype'] = 'Tip alertă';
$string['alerttypedesc'] = 'Selectați tipul alertei: info (albastru), avertizare (galben) sau anunț (verde).';
$string['alertwarning'] = 'Avertizare';
$string['alertwarningdesc'] = 'Afișează o avertizare în alertă.';
$string['analyticscount'] = 'Număr de analizări';
$string['analyticsprofilefield'] = 'Denumire Câmp de Profil Personalizat=Valoare (opțional)';
$string['analyticsprofilefielddesc'] = 'Adăugați regulă de acces pentru câmpul de profil particularizat, ex: tipdeutilizator=student';
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsheading'] = 'Setați Google Analytics și/sau Matomo';
$string['analyticstext'] = 'ID Analytics';
$string['analyticstextdesc'] = 'Inserați ID Google Analytics.';
$string['anonymizega'] = 'Anonimizare IP utilizator';
$string['anonymizegadesc'] = 'Anonimizare IP al utilizatorului trimis la Google Analytics.';
$string['backcolor'] = 'Culoare background';
$string['backcolordesc'] = 'Setați culoarea de fundal';
$string['bcustyle'] = 'Stil BCU';
$string['blockbackgroundcolor'] = 'Block Culoare de fundal';
$string['blockbackgroundcolordesc'] = 'Setați culoarea de fundal pentru toate block-urile';
$string['blockbordercolor'] = 'Culoarea chenarului blocului.';
$string['blockbordercolordesc'] = 'Setați culoarea chenarului blocului.';
$string['blockheaderbackgroundcolor'] = 'Culoare de fundal a antetului blocului';
$string['blockheaderbackgroundcolordesc'] = 'Setați culoarea de fundal a antetului tuturor blocurilor.';
$string['blockheadercolor'] = 'Culoare fundal antete blocuri';
$string['blockheadercolordesc'] = 'Setați culoarea fontului pentru antetul blocului.';
$string['blockicons'] = 'Pictograme blocuri';
$string['blockiconsheadersize'] = 'Dimensiune pictogramă antetelor blocurilor';
$string['blockiconsheadersizedesc'] = 'Setați dimensiunea fontului pictogramei utilizat în antetul blocurilor moodle. Selectați o valoare din listă.';
$string['blocklayoutbuilder'] = 'Regiunile de blocuri de pe prima pagină';
$string['blocklayoutlayoutcheck'] = 'Verificați-vă layout-ul';
$string['blocklayoutlayoutcheckdesc'] = 'Utilizați instrumentul de mai jos pentru a verifica numărul de blocuri pe care le-ați folosit și pentru a vedea cum arată noul layout.';
$string['blocklayoutlayoutcount1'] = 'Puteți seta un maximum de';
$string['blocklayoutlayoutcount2'] = 'Regiunile de block. Acum folosiți:';
$string['blocklayoutlayoutrow'] = 'Regiunea cu rânduri de blocuri';
$string['blockregionbackground'] = 'Culoarea de fundal a regiunii de blocuri';
$string['blockshowhide'] = 'Afișare / Ascundere bloc';
$string['blockside'] = 'Localizarea block-urilor';
$string['blocksidedesc'] = 'Setează dacă block-urile apar în stânga sau în dreapta paginii.';
$string['breadcrumb'] = 'Breadcrumb';
$string['breadcrumbbackgroundcolor'] = 'Culoare de fundal Breadcrumb';
$string['breadcrumbbackgroundcolordesc'] = 'Setați culoarea de fundal a breadcrumb.';
$string['breadcrumbdisplay'] = 'Afișare Breadcrumb';
$string['breadcrumbhome'] = 'Pagina principală Breadcrumb';
$string['breadcrumbhomeicon'] = 'Pictogramă';
$string['breadcrumbhometext'] = 'Text';
$string['breadcrumbseparator'] = 'Separator Breadcrumb';
$string['breadcrumbtextcolor'] = 'Culoarea textului Breadcrumb';
$string['breadcrumbtextcolordesc'] = 'Setați culoarea textului pentru breadcrumb.';
$string['breadcrumbtitle'] = 'Numele cursului Breadcrumb';
$string['bs4all'] = 'Extra small - Extra large';
$string['bs4extralarge'] = 'Doar extra large';
$string['bs4large'] = 'Large - Extra large';
$string['bs4medium'] = 'Medium - Extra large';
$string['bs4none'] = 'Niciuna';
$string['bs4small'] = 'Small - Extra large';
$string['buttoncolor'] = 'Culoarea butonului';
$string['buttoncolorcancel'] = 'Culoarea butonului Anulare';
$string['buttoncolordesc'] = 'Culoarea butoanelor principale folosite pe site.';
$string['buttoncolordescscnd'] = 'Culoarea butoanelor secundare utilizate în site';
$string['buttoncolorscnd'] = 'Culoare buton secundar';
$string['buttondesc'] = 'Modificați aspectul butoanelor utilizate în această temă.';
$string['buttonlogincolor'] = 'Culoarea butonului de logare';
$string['buttonlogincolordesc'] = 'Culoarea butonului de logare';
$string['buttonloginheight'] = 'Setați înălțimea butonului de logare';
$string['buttonloginpaddingdesc'] = 'Număr mai mare = buton mai mare.';
$string['buttonlogintextcolor'] = 'Culoarea textului butonului de autentificare';
$string['buttonlogintextcolordesc'] = 'Culoarea textului folosit la butonul de login';
$string['buttonradius'] = 'Setați butonul radius';
$string['buttonsettings'] = 'Butoane';
$string['buttonsettingsheading'] = 'Particularizați butoanele acestei teme';
$string['buttontextcolor'] = 'Culoarea textului butonului';
$string['buttontextcolorcancel'] = 'Culoarea textului butonului Anulare';
$string['buttontextcolordesc'] = 'Culoarea textului folosit pentru butoane.';
$string['buttontextcolordesccancel'] = 'Culoarea textului folosit pentru butoanele Anulare.';
$string['buttontextcolordescscnd'] = 'Culoarea textului folosit pentru butoane secundare.';
$string['buttontextcolorscnd'] = 'Culoarea textului butonului secundar';
$string['buttontexthovercolordesc'] = 'Culoarea în care se schimbă textul butonului când treceți cu mouse-ul peste el.';
$string['categoryhavecustomheaderdesc'] = 'Selectați categoriile de nivel superior care vor avea un antet personalizat. Pentru a selecta mai multe sau a deselecta o categorie, utilizați tasta „Ctrl”. Salvați și actualizați pagina. Notă: Subcategoriile selectate vor avea valorile setărilor.';
$string['categoryheaderbgimage'] = 'Imaginea de fundal a categoriei  \'{$a->name}\' cu id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Setați o imagine de fundal a categoriei de nivel înalt \'{$a->name}\' cu id \'{$a->id}\' în antet. Dimensiunea minimă este 1600x180px (1900x180px recomandată). Imaginea va acoperi întregul  antet.';
$string['categoryheaderbgimagedescchildren'] = 'Setați o imagine de fundal a categoriei de nivel înalt {$a->name}\' cu id \'{$a->id}\' și subcategoriile ei\' {$a->children}\' în antet. Dimensiunea minimă este de 1600x180px (1900x180px recomandată). Imaginea va acoperi întregul antet.';
$string['categoryheaderbgimagetextcolour'] = 'Culoarea textului imaginii de fundal a categoriei \'{$a->name}\' cu id \'{$a->id}\'';
$string['categoryheaderbgimagetextcolourdesc'] = 'Setați culoarea textului din imaginea de fundal a categoriei de nivel înalt \'{$a->name}\' cu id \'{$a->id}\' în antet.';
$string['categoryheaderbgimagetextcolourdescchildren'] = 'Setați culoarea textului din imaginea de fundal pentru categoria de nivel înalt \'{$a->name}\' cu id \'{$a->id}\' și subcategoriile ei \'{$a->children}\' în antet.';
$string['categoryheadercustomcss'] = 'SCSS personalizat al categoriei \'{$a->name}\' cu id \'{$a->id}\'';
$string['categoryheadercustomtitle'] = 'Denumire particularizată a categoriei cu id \'{$a->id}\'';
$string['categoryheaderheader'] = 'Setările categoriei de nivel înalt \'{$a->name}\' cu id \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Configurați setările categoriei de nivel înalt \'{$a->name}\' cu id \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Configurați setările categoriei de nivel înalt \'{$a->name}\' cu id \'{$a->id}\' și suabcategoriile sale \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Categoria \'{$a->name}\' cu logo id \'{$a->id}\' logo';
$string['categoryheaderlogodesc'] = 'Setați un logo al categoriei de nivel înalt {$a->name}\' cu id \'{$a->id}\' în antet. Dimensiunea recomandată este 200px by 80px.';
$string['categoryheaderlogodescchildren'] = 'Setați un logo al categoriei de nivel înalt \'{$a->name}\' cu id \'{$a->id}\' și subcategoriile ei \'{$a->children}\' în antet.  Dimensiunea recomandată este 200px pe 80px.';
$string['categoryheaderssettings'] = 'Antetele categoriei';
$string['categoryheaderssettingsdesc'] = 'Configurare setări ale antetelor din cadrul unei categorii.';
$string['categoryheaderssettingsheading'] = 'Modificați antetul uneia sau a mai multor categorii de nivel înalt sau inferioare.';
$string['cdefaulticon'] = 'Pictograma implicită pentru Cursurile mele';
$string['chiddenicon'] = 'Pictograma pentru Cursurile mele ascunse';
$string['cneveraccessedicon'] = 'Pictograma pentru Cursurile mele niciodată accesate';
$string['colorsettings'] = 'Culori';
$string['colorsettingsheading'] = 'Modificați principalele culori utilizate pe tot parcursul temei.';
$string['configtabtitle'] = 'Setări';
$string['configtitle'] = 'Adaptabil';
$string['course'] = 'Curs';
$string['courseactivitynavigationenabled'] = 'Navigare în activitate';
$string['courseactivitynavigationenableddesc'] = 'Navigarea în activitate activată.';
$string['courseindexenabled'] = 'Activat';
$string['courseindexenableddesc'] = 'Activați sau dezactivați \'Index curs\'.';
$string['courseindexitemcolor'] = 'Culoare element';
$string['courseindexitemcolordesc'] = 'Culoarea elementului din „Index curs” dintr-un curs.';
$string['courseindexpageitembgcolor'] = 'Culoare de fundal a elementului din pagină';
$string['courseindexpageitemcolor'] = 'Culoare a elementului din pagină';
$string['courseindexsettings'] = 'Index curs';
$string['courseindexsettingsdesc'] = 'Particularizare index curs.';
$string['courseindexsettingsheading'] = 'Setări index curs';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'O regiune de blocuri personalizată care apare la încheierea activităților.';
$string['coursepageblockactivitybottomenableddesc'] = 'Activați această regiune pe toate paginile cursului.';
$string['coursepageblocklayoutbuilder'] = 'Regiuni de blocuri pe pagina de curs';
$string['coursepageblocksliderenableddesc'] = 'Activează această regiune pe toate paginile cursului.';
$string['coursepageheaderhidesitetitle'] = 'Ascunde denumirea site-ului pe paginile cursului';
$string['coursepageheaderhidesitetitledesc'] = 'DEPRECIAT, utilizați  \'coursepageheaderhidetitle\' în schimb.';
$string['coursepageheaderhidetitle'] = 'Ascundeți titlul antetului pe paginile cursului';
$string['coursepagesidebarinfooterenabledsection'] = 'Setări obișnuite';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Setări standard pentru majoritatea formatelor de curs.';
$string['courses'] = 'Cursuri';
$string['coursesearch'] = 'Căutare curs';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Setați culoarea marginii stângi.';
$string['coursesectionactivitycolors'] = 'Opțiuni de activități ale secțiunii de curs';
$string['coursesectionactivityforumbgcolor'] = 'Culoarea de fundal a activității de tip forum';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Setați culoarea chenarului din stânga.';
$string['coursesectionactivityheadingcolourdesc'] = 'Culoare activităților pe care se poate da click afișate pe pagina de start a cursului.';
$string['coursesectionactivityiconsize'] = 'Dimensiunea pictogramei Activitate din secțiunea de curs';
$string['coursesectionactivityiconsizedesc'] = 'Setați dimensiunea pictogramei activități/resurse (de exemplu, o valoare de 16 px se va seta la 16 px pe 16 px).';
$string['coursesectionactivityquizbgcolor'] = 'Culoare de fundal a activității de tip test';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Setați culoarea marginii stângi.';
$string['coursesectionbgcolor'] = 'Fundalul secțiunii de curs';
$string['coursesectionbgcolordesc'] = 'Setați culoarea de fundal a secțiunii de curs.';
$string['coursesectionbordercolor'] = 'Culoarea chenarului secțiunii de curs';
$string['coursesectionborderwidth'] = 'Lățimea chenarului secțiunii cursului';
$string['coursesectionborderwidthdesc'] = 'Setați lățimea chenarelor secțiunii cursului.';
$string['coursesectionheaderbg'] = 'Fundalul antetului secțiunii de curs';
$string['coursesectionheaderbgdesc'] = 'Setați culoarea de fundal a antetelor secțiunii de curs.';
$string['coursesections'] = 'Secțiuni de curs';
$string['coursesettings'] = 'Cursuri';
$string['coursesettingsdesc'] = 'Particularizează cursurile.';
$string['coursesettingsheading'] = 'Setări curs';
$string['coursetitlefullname'] = 'Denumire completă a cursului';
$string['coursetitlemaxwidth'] = 'Lungime maximă a titlului cursului';
$string['coursetitlemaxwidthdesc'] = 'Setați numărul maxim de caractere din zona denumire curs.';
$string['coursetitleshortname'] = 'Denumire prescurtată / cod curs';
$string['coventrystyle'] = 'Stil Coventry';
$string['currentcolordesc'] = 'Setați culoarea pentru evidențierea secțiunii curente din curs.';
$string['customcoursesubtitle'] = 'Subtitlu particularizat al cursului';
$string['customcoursetitle'] = 'Denumire particularizată a cursului';
$string['customcss'] = 'Particularizare CSS';
$string['customcssdesc'] = 'Indiferent ce reguli CSS adăugați în această zonă de text, ele se vor reflecta în fiecare pagină, făcând mai ușoară personalizarea acestei teme.';
$string['customcssjssettingsheading'] = 'Aplică modificările tale';
$string['customcsssettings'] = 'CSS particularizat';
$string['customcsssettingsdescription'] = 'Aici puteți găsi diferite setări pentru a le adăuga temei din CSS-ul propriu.';
$string['customjs'] = 'JavaScript particularizat';
$string['customjsdesc'] = 'Adaugă JavaScript la site.';
$string['customjsfiles'] = 'Fișiere JavaScript personalizate';
$string['customjsfilesdesc'] = 'Adaugă fișiere';
$string['customjsrestricted'] = 'JavaScript condițional JavaScript la site.';
$string['customjssettings'] = 'JS particularizat';
$string['custommenu'] = 'Particularizare';
$string['custommenutitle'] = 'Denumire particularizată a meniului';
$string['dangericoncolor'] = 'Culoarea pictogramei Avertizare';
$string['dashblocklayoutbuilder'] = 'Regiunile cu blocuri în tabloul de bord';
$string['dashblocksabovecontent'] = 'Afișare sub conținutul principal';
$string['dashblocksbelowcontent'] = 'Afișare sub conținutul principal';
$string['dashblocksposition'] = 'Poziție personalizată a regiunii de blocuri';
$string['dashblockspositiondesc'] = 'Când regiunile personalizate cu blocuri sunt activate pentru pagina Tablou de bord, alegeți poziția acestora.';
$string['dashed'] = 'Întreruptă';
$string['defaultzoom'] = 'Zoom implicit';
$string['dimmedtextcolor'] = 'Culoarea textului estompată';
$string['disablecustommenu'] = 'Dezactivați Meniu particularizat Moodle';
$string['disablecustommenudesc'] = 'Dezactivează meniurile personalizate Moodle din bara de navigare (se vor randa în continuare în alte teme instalate).';
$string['disabled'] = 'Dezactivat';
$string['disablemenuscoursepages'] = 'Dezactivați meniurile pe paginile cursului';
$string['discardbuttontext'] = 'Anulare';
$string['displayeditingbuttontext'] = 'Editare buton text';
$string['displayeditingbuttontextdesc'] = 'Afișați sau ascundeți textul la butonul de editare. Notă: Se aplică doar butonului de editare curs.';
$string['displaygrades'] = 'Afișare note';
$string['displaylogin'] = 'Afișare autentificare';
$string['displayloginbox'] = 'Căsuță de autentificare';
$string['displayloginbutton'] = 'Buton';
$string['displaylogindesc'] = 'Selectați modul de afișare a căsuței de autentificare în antet.';
$string['displayloginno'] = 'Fără căsuță pentru logare';
$string['displayparticipants'] = 'Afișare participanți';
$string['dividingline'] = 'Linie despărțitoare în antet';
$string['dividingline2'] = 'Linie despărțitoare în npta de subsol';
$string['dotted'] = 'Dotted';
$string['double'] = 'Dublu';
$string['editfont'] = 'Editați și personalizați butonul culorii de fundal a acestei pagini';
$string['editfontdesc'] = 'Configurați editarea și particularizare culorii de fond a butonului de pe această pagină';
$string['editoffbk'] = 'Editare și particularizare a fundalului butonului \'Off\' de pe această pagină.';
$string['editonbk'] = 'Editați și personalizați butonul de fundal al acestei pagini';
$string['editonbkdesc'] = 'Setați culoarea de fundal a butonului de editare și personalizare a acestei pagini.';
$string['editsettingsbutton'] = 'Editare setări și mod de afișare al butonului';
$string['editsettingsbuttonshowbutton'] = 'Afișați doar butonul de editare. Ex. butonul "Activare Editare" pe pagina de curs.';
$string['emoticonsize'] = 'Dimensiunea emoticoanelor';
$string['emoticonsizedesc'] = 'Setați înălțimea și lățimea emoticoanelor moodle.';
$string['enableaccesstool'] = 'Instrument accesibilitate';
$string['enablealert'] = 'Activați alerta {$a}';
$string['enablealertdesc'] = 'Activați alerta {$a}';
$string['enablealerts'] = 'Activați / Dezactivați alertele';
$string['enablealertsdesc'] = 'Activați / dezactivați alertele pe site-ul dumneavoastră, nu în curs, verificați setările \'alerthiddencourse\'';
$string['enableanalytics'] = 'Activați Google Analytics';
$string['enableanalyticsdesc'] = 'Activați setările Google Analytics în site-ul dumneavoastră Moodle';
$string['enableavailablecourses'] = 'Afisați "Cursuri disponibile"';
$string['enableavailablecoursesdesc'] = 'Afișați textul "Cursuri Disponibile" pe pagina principală.';
$string['enablebadges'] = 'Ecusoane';
$string['enablebadgesdesc'] = 'Afișați un link către ecusoanele utilizatorilor.';
$string['enableblog'] = 'Activare blogurile mele';
$string['enableblogdesc'] = 'Afișați un link către paginile cu blogurile utilizatorilor.';
$string['enablecalendar'] = 'Calendarul utilizatorului';
$string['enablecalendardesc'] = 'Afișați un link către calendarul utilizatorilor.';
$string['enablecompetencieslink'] = 'Link Competențe';
$string['enablecoursetitle'] = 'Titlu curs';
$string['enablecoursetitledesc'] = 'Setați modul de afișare a denumirii cursului.';
$string['enabledtabbedprofileeditprofilelink'] = 'Activați link-ul de editare profil';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Activare link Preferințe';
$string['enableeditprofile'] = 'Editați profilul';
$string['enableeditprofiledesc'] = 'Afișați un link pentru a edita profilul utilizatorilor.';
$string['enableeventsdesc'] = 'Afișați un link către calendar.';
$string['enablefeed'] = 'Feedback-ul meu';
$string['enablegrades'] = 'Note';
$string['enablegradesdesc'] = 'Afișați un link către notele utilizatorilor.';
$string['enableheading'] = 'Denumire antet curs';
$string['enableheadingdesc'] = 'DEPRECIAT, utilizați \'enablecoursetitle\' în schimb.';
$string['enablehelp'] = 'Link de suport \'{$a->number}\'';
$string['enablehelpdesc'] = 'Adăugați un link de suport \'{$a->number}\' în navbar.';
$string['enablehomedesc'] = 'Afișați un link către pagina principală.';
$string['enablehomeredirect'] = 'Activați home redirect=0';
$string['enablemenus'] = 'Activare meniuri';
$string['enablemy'] = 'Dashboard';
$string['enablemydesc'] = 'Afișați un link către pagina Tablou de bord';
$string['enablenavbarwhenloggedout'] = 'Activați navbar la delogare';
$string['enablenote'] = 'Notificările mele';
$string['enablenotedesc'] = 'Afișați un link către pagina de notificări a utilizatorului';
$string['enableposts'] = 'Postările mele';
$string['enablepref'] = 'Preferințele mele';
$string['enableprefdesc'] = 'Afișează un link către pagina Preferințele utilizatorului.';
$string['enableprivatefiles'] = 'Fișiere confidențiale';
$string['enableprivatefilesdesc'] = 'Afișează un link către';
$string['enableprofile'] = 'Profil utilizator';
$string['enableprofiledesc'] = 'Afișați un link către profilul utilizatorilor';
$string['enableshowhideblocks'] = 'Activați block-urile Afișați/Ascundeți';
$string['enableshowhideblocksdesc'] = 'Permiteți utilizatorilor să afișeze/ascundă toate block-urile.';
$string['enableshowhideblockstextdesc'] = 'Afișează textul de lângă buton.';
$string['enableticker'] = 'Activați știrile derulante pe pagina principală?';
$string['enabletickerc'] = 'Activați știrile derulante pe paginile interne?';
$string['enabletickermy'] = 'Activați știrile derulante?';
$string['enabletoolsmenus'] = 'Activați Meniu instrumente';
$string['enablezoom'] = 'Activați Zoom';
$string['enablezoomdesc'] = 'Permite utilizatorilor să comute între ecranul complet și lățimea fixă.';
$string['enablezoomshowtextdesc'] = 'Se afișează text lângă buton.';
$string['events'] = 'Evenimente';
$string['expandable'] = 'Expandabil';
$string['fa6name'] = 'Versiunea temei FontAwesome 6 Free';
$string['faiv'] = 'FontAwesome Free v4 shims';
$string['fav'] = 'FontAwesome 6 Free';
$string['favicon'] = 'Favicon';
$string['favoff'] = 'Core FontAwesome 6 Free version';
$string['flexibleblocksoverflow'] = 'Suprapunere';
$string['fontblockheadersizedesc'] = 'Setați dimensiunea fontului folosit în antetul blocurilor Moodle. Selectați o valoare din listă.';
$string['fontcolordesc'] = 'Setați culoarea fontului în cadrul temei utilizând codul html hex';
$string['fontdefault'] = 'Implicit';
$string['fontdesc'] = 'Puteți selecta fonturile pe care doriți să le utilizați în temă.';
$string['fontheadercolor'] = 'Culoare font antete';
$string['fontheadercolordesc'] = 'Setați culoarea fonturilor antetelor în temă utilizând codul html hex.';
$string['fontheadername'] = 'Font antete';
$string['fontheadernamedesc'] = 'Selectați fontul folosit în text și blocurile antetelor.';
$string['fontheaderweightdesc'] = 'Ponderea fontului antetelor folosite în site. Selectați o valoare de la 100 la 900 în funcție de fontul selectat.';
$string['fontname'] = 'Fontul principal';
$string['fontnamedesc'] = 'Selectați fontul principal al site-ului.';
$string['fontsettings'] = 'Fonturi';
$string['fontsettingsheading'] = 'Modificați fonturile utilizate pe parcursul temei.';
$string['fontsize'] = 'Dimensiunea fontului principal';
$string['fontsizedesc'] = 'Selectați valoarea implicită a dimensiunii fontului (în procente) utilizată pe tot site-ul.';
$string['fonttitlecolor'] = 'Culorea fontului denumirii site-ului/ cursului';
$string['fonttitlecolorcourse'] = 'Culoarea de fundal a denumirii cursului.';
$string['fonttitlecolorcoursedesc'] = 'Setați culoarea fontului denumirii cursului în temă utilizând codul html hex.';
$string['fonttitlecolordesc'] = 'Setați culoarea denumirii cursului și fontul denumirii cursului în temă utilizând codul html hex.';
$string['fonttitlename'] = 'Fontul denumirii site-ului/ cursului';
$string['fonttitlenamedesc'] = 'Selectați fontul folosit în site-ul și titlurile cursurilor.';
$string['fonttitlesize'] = 'Dimensiune font denumire site / curs';
$string['fonttitlesizedesc'] = 'Denumirea cursului si dimensiunea fontului denumirii cursului folosite în site. Selectați o valoare din listă.';
$string['fonttitleweightdesc'] = 'Setați ponderea fontului utilizat pentru denumirea site-ului și denumirea cursurilor. Selectați o valoare de la 100 la 900 în funcție de fontul selectat.';
$string['fontweight'] = 'Ponderare font principal';
$string['fontweightdesc'] = 'Ponderea fontului utilizat în site. Selectați o valoare de la 100 la 900 în funcție de fontul selectat.';
$string['footerbkcolor'] = 'Culoarea de fundal a subsolului paginii';
$string['footerbkcolordesc'] = 'Setați culoarea de fundal a notei de subsol.';
$string['footerblocksplacement'] = 'Plasare blocuri de subsol';
$string['footerblocksplacement1'] = 'Sitewide';
$string['footerblocksplacement2'] = 'Doar homepage';
$string['footerblocksplacement3'] = 'Niciodată';
$string['footercontent'] = 'Secțiunea conținut notă de subsol';
$string['footercontentdesc'] = 'Adăugați conținut în secțiunea notă de subsol.';
$string['footerdesc'] = 'Adăugați titlu pentru secțiunea notă de subsol.';
$string['footersettings'] = 'Subsol pagină';
$string['footersettingsheading'] = 'Configurați conținutul care ar trebui să apară în nota de subsol.';
$string['footertextcolor'] = 'Culoarea textului din subsolul paginii';
$string['footertextcolordesc'] = 'Culoarea textului în nota de subsol, utilizați codul html hex.';
$string['footnote'] = 'Notă de subsol';
$string['footnotedesc'] = 'Adăugați text în note de subsol';
$string['forumbodybackgroundcolordesc'] = 'Culoarea de fundal a unei postări de pe forum.';
$string['forumheaderbackgroundcolordesc'] = 'Culoarea de fundal a unei postări de pe forum.';
$string['frnt-footer'] = 'Block-urile din această zonă vor fi vizibile doar pentru utilizatorii admin';
$string['frontpageblocksettings'] = 'Blocuri marketing';
$string['frontpagecoursesettings'] = 'Lista de cursuri de pe pagina principală';
$string['frontpagemarketenabled'] = 'Activare blocuri marketing';
$string['frontpagerendererdefaultimage'] = 'Imaginea implicită pentru curs';
$string['frontpagerendereroption1'] = 'Carduri';
$string['frontpagerendereroption3'] = 'Moodle implicit';
$string['frontpageslidersettings'] = 'Slider pe pagina principală';
$string['frontpagetiles1'] = 'Un card';
$string['frontpagetiles2'] = 'Două carduri';
$string['frontpagetiles3'] = 'Trei carduri';
$string['frontpagetiles4'] = 'Patru carduri';
$string['frontpagetiles6'] = 'Șase carduri';
$string['fullscreen'] = 'Întregul ecran';
$string['fullscreenwidth'] = 'Lățime ecran complet.';
$string['future'] = 'Viitor';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsheading'] = 'Setați Google Analytics pentru site-ul dumneaoastră';
$string['googlefonts'] = 'Fonturi Google';
$string['headerbgimage'] = 'Imagine de fundal';
$string['headerbgimagetextcolour'] = 'Culoarea textului imaginii de fundal';
$string['headernavbarcustommenucoreheading'] = 'Setări esențiale';
$string['headernavbarcustommenucoreheadingdesc'] = 'Duplicat pentru a fi mai facil.';
$string['headernavbarcustommenuheading'] = 'Meniu personalizat';
$string['headernavbarhelpheading'] = 'Opțiuni și link-uri pentru suport';
$string['headernavbarmycoursesheading'] = 'Meniu Cursurile mele';
$string['headernavbarthiscourseheading'] = 'Meniu curs';
$string['headersearchandsocialnone'] = 'Nici una';
$string['headersearchandsocialsearchheader'] = 'Căutare în antet';
$string['headersearchandsocialsearchnavbar'] = 'Căutare în navbar';
$string['headersettings'] = 'Antet';
$string['headersettingsheading'] = 'Particularizați antetul acestei teme.';
$string['headerstyle'] = 'Stil antet';
$string['headerstyleheading'] = 'Setări stil antet';
$string['headertextcolordesc'] = 'Setați culoarea link-ului și textului din antet.';
$string['help'] = 'Ajutor';
$string['helplinkscount'] = 'Număr link-uri de suport';
$string['helplinktitle'] = 'Denumire link de suport \'{$a->number}\'';
$string['helptargetdesc'] = 'Doriți ca link-ul de ajutor să se deschidă într-o fereastră nouă?';
$string['helptitle'] = 'Ajutor {$a->number}';
$string['hiddencourses'] = 'Cursuri ascunse';
$string['hiddenfromview'] = 'Ascuns pentru utilizatori';
$string['hide'] = 'aScunde';
$string['hidefootersocial'] = 'Afișare pictograme sociale';
$string['hidefootersocialdesc'] = 'Afișare pictograme sociale în subsolul paginii sub blocuri.';
$string['hideinforum'] = 'Ascunde suportul și instrumentele în forumuri';
$string['home'] = 'Acasă';
$string['homebk'] = 'Imagine de fundal a paginii principale';
$string['homebkdesc'] = 'Încărcați o imagine care va fi imaginea de fundal pe pagina principală.';
$string['infoiconcolor'] = 'Culoare pictogramă Suport';
$string['informationblocksenabled'] = 'Activare blocuri Informații';
$string['informationblocksenableddesc'] = 'Afișare bloc Informații pe pagina principală.';
$string['informationblocksettings'] = 'Blocuri Informații';
$string['informationblocksvisible'] = 'Afișare blocuri Informații când';
$string['informationblocksvisibledesc'] = 'Afișează blocurile informații cînd apare \'Dezautentificat\', \'Autentificat\' sau \'Autentificat sau dezautentificat\'.';
$string['informationblocksvisibleloggedin'] = 'Logat';
$string['informationblocksvisibleloggedinout'] = 'Logat sau delogat';
$string['informationblocksvisibleloggedout'] = 'Delogat';
$string['informationsettingsheading'] = 'Particularizați regiunea cu blocuri Informații care apare pe pagina principală.';
$string['inprogress'] = 'În desfășurare';
$string['jssection'] = 'Secțiune Javascript';
$string['jssectiondesc'] = 'DEPRECIAT, utilizați în schimb \'customjs\'';
$string['jssectionrestricted'] = 'Secțiune Conditional javascript';
$string['jssectionrestricteddashboardonly'] = 'Include javascript doar pe pagina Tablou de bord';
$string['jssectionrestricteddesc'] = 'DEPRECIAT, utilizați în schimb \'customjsrestricted\'';
$string['jumpto'] = 'Mergi la...';
$string['landscape'] = 'Landscape';
$string['layoutaddcontent'] = 'Sunteți mulțumit(ă) de aspect? Adăugați acum conținut blocurilor:';
$string['layoutaddcontentdesc1'] = 'Ați configurat';
$string['layoutcheck'] = 'Verificați-vă layout-ul';
$string['layoutcount1'] = 'Puteți seta un maximum de';
$string['layoutcount2'] = 'regiuni cu blocuri. Acum folosești:';
$string['layoutdesc'] = 'Setați layout-ul implicit pe care îl vor vedea utilizatorii.';
$string['layoutsettings'] = 'Layout';
$string['layoutsettingsheading'] = 'Setează layout-ul site-ului';
$string['leftblocks'] = 'Partea stângă';
$string['linkcolor'] = 'Culoare link';
$string['linkcolordesc'] = 'Setați culoarea link-urilor în temă utilizând codul html hex.';
$string['linksmenu'] = 'Meniu link-uri';
$string['loadingcolor'] = 'Se încarcă culoarea';
$string['loginbgimage'] = 'Imagine de fundal';
$string['loginbgimagedesc'] = 'Adăugare imagine de fundal pe toată dimensiunea paginii.';
$string['loginbgstyledesc'] = 'Selectați stilul imaginii încărcate.';
$string['logindesc'] = 'Particularizați pagina de autentificare adăugând o imagine de fundal și text deasupra și sub căsuța de autentificare.';
$string['loginfooter'] = 'Subsol al paginii de logare';
$string['loginfooterdesc'] = 'Afișare notă de subsol a paginii de autentificare.';
$string['loginheader'] = 'Antet al paginii de logare';
$string['loginheaderdesc'] = 'Afișează antet al paginii de logare';
$string['loginplaceholder'] = 'Nume utilizator';
$string['loginsettings'] = 'Pagina de autentificare';
$string['loginsettingsheading'] = 'Particularizare pagină de logare.';
$string['logintextboxbottomdesc'] = 'Adăugați un text particularizat sub căsuța de autentificare.';
$string['logintextboxtopdesc'] = 'Adăugați un text paticularizat deasupra căsuței de autentificare.';
$string['logintextbutton'] = 'Autentificare';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Încărcați un logo pe site-ul dumneavoastră. Dimensiunea recomandată este 200px pe 80px';
$string['maincolor'] = 'Culoare principală';
$string['maincolordesc'] = 'Culoarea principală a block-urilor și a notelor de subsol';
$string['market'] = 'Block Marketing';
$string['marketingsettings'] = 'Blocuri Marketing';
$string['marketingsettingsheading'] = 'Particularizare blocuri marketing de pe prima pagină.';
$string['marketingvisible'] = 'Afișează blocurile marketing când';
$string['marketingvisibledesc'] = 'Afișare blocuri marketing când se afișează \'Dezautentificat\', \'Autentificat\' sau \'Autentificat sau dezautentificat\'.';
$string['marketingvisibleloggedin'] = 'Autentificat';
$string['marketingvisibleloggedinout'] = 'Autentificat sau dezautentificat';
$string['marketingvisibleloggedout'] = 'Dezautentificat';
$string['menuoverrideprofilefield'] = 'Denumire câmp de profil personalizat';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menusettings'] = 'Meniuri antet';
$string['menusheadingvisibility'] = 'Setări generale ale top menu visibility';
$string['menuuseroverride'] = 'Permiteți utilizatorilor să poată suprascrie';
$string['messagepopupbackground'] = 'Imagine de fundal a mesajelor pop-up';
$string['messagepopupcolor'] = 'Culoarea textului mesajelor pop-up';
$string['mobileprimarynavdesc'] = 'Activare sau deactivare. Notă: Acesta este meniul controlat de pictograma hamburger';
$string['moodledocs'] = 'Link Moodle docs';
$string['moodledocsdesc'] = 'Afișați link-ul Moodle docs în subsolul paginii.';
$string['more'] = 'Mai mult';
$string['myblogs'] = 'Blogurile mele';
$string['mysites'] = 'Cursurile mele';
$string['mysitesdisabled'] = 'Dezactivează';
$string['mysitesexclude'] = 'Activați excluderea cursurilor ascunse';
$string['mysitesinclude'] = 'Activați includerea cursurilor ascunse';
$string['navbardesc'] = 'Vă permite să controlați toate elementele care apar în bara de navigare.';
$string['navbardisplayicons'] = 'Afișare pictograme';
$string['navbarlinksettingsheading'] = 'Particularizare link-uri în bara de navigare';
$string['navbarlinkssettings'] = 'Link-uri Navbar';
$string['navbarmycourses'] = 'Bară de navigare cursurile mele';
$string['navbarsettings'] = 'Navbar';
$string['navbarsettingsheading'] = 'Personalizați bara de navigare';
$string['navbarstyles'] = 'Stiluri bară de navigare';
$string['newmenufield'] = 'Denumire câmp de profil personalizat=Valoare (opțional)';
$string['newmenuheading'] = 'Top menu';
$string['newmenurequirelogin'] = 'Necesită autentificarea';
$string['newmenurequirelogindesc'] = 'Dacă este activat, acest meniu va fi vizibil doar pentru utilizatorii logați.';
$string['newmenutitledefault'] = 'Meniu';
$string['newstickercount'] = 'Număr de secțiuni știri derulante';
$string['newstickersettings'] = 'Știri derulante';
$string['nextactivity'] = 'Următoarea activitate';
$string['nextsection'] = 'Următoarea secțiune';
$string['noenrolments'] = 'Nu s-au găsit înscrieri';
$string['none'] = 'Niciuna';
$string['normal'] = 'Lățime fixă';
$string['nostyle'] = 'Nu este precizat stilul';
$string['onetopicheading'] = 'Un Topic';
$string['overriddentemplate'] = 'Șablon suprascris: {$a}';
$string['overridetemplate'] = 'Se suprascrie șablon: {$a}';
$string['pageheaderalternative'] = 'Alternativ';
$string['pageheaderheight'] = 'Înălțime antet paginii';
$string['pageheadernosearch'] = 'Fără căutare';
$string['pageheaderoriginal'] = 'Original';
$string['passwordplaceholder'] = 'Parolă';
$string['past'] = 'Trecut';
$string['pastcourses'] = 'Cursuri anterioare';
$string['people'] = 'Participanți';
$string['piwikenabled'] = 'Activat';
$string['piwikenableddesc'] = 'Activați tracking-ul Matomo pentru Moodle.';
$string['piwikimagetrack'] = 'Tracking imagine';
$string['piwiksettings'] = 'Analytics Matomo (anterior Piwik)';
$string['piwiksettingsheading'] = 'Configurare Matomo';
$string['piwiksiteid'] = 'ID al site-ului';
$string['piwiksiteiddesc'] = 'Inserați ID-ul site-ului dumneavoastră.';
$string['piwiksiteurl'] = 'URL Matomo';
$string['piwiktrackadmindesc'] = 'Activați tracking pentru utilizatorii admin (nerecomandat)';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Portrait';
$string['previousactivity'] = 'Activitate anterioară';
$string['previoussection'] = 'Secțiune precedentă';
$string['primarycolour'] = 'Culoare primară';
$string['printlineheight'] = 'Înălțime linie';
$string['printlineheightdesc'] = 'Configurați înălțimea liniei';
$string['printmargin'] = 'Margine';
$string['printmargindesc'] = 'Configurare margine.';
$string['printpageorientation'] = 'Orientare pagină';
$string['printsettings'] = 'Printare';
$string['printsettingsdesc'] = 'Configurați setările pentru printare:';
$string['printsettingsheading'] = 'Setări printare';
$string['privacy:closed'] = 'Închis';
$string['privacy:nofull'] = 'Incomplet';
$string['privacy:open'] = 'Deschis';
$string['properties'] = 'Setări import / export';
$string['propertiesexport'] = 'Export proprietăți sub formă de șir JSON';
$string['propertiesproperty'] = 'Proprietate';
$string['propertiesreturn'] = 'Mergi înapoi';
$string['propertiessub'] = 'Setări tema curentă';
$string['propertiesvalue'] = 'Valoare';
$string['putpropertiesadded'] = 'Adăugat:';
$string['putpropertieschanged'] = 'Modificat:';
$string['putpropertiesfrom'] = 'de la';
$string['putpropertiesheading'] = 'Import setări temă';
$string['putpropertiesignored'] = 'Ignorat:';
$string['putpropertiesname'] = 'Import proprietăți';
$string['putpropertiesreportfiles'] = 'Nu uitați să încărcați următoarele fișiere conform setărilor lor:';
$string['putpropertiessettingsreport'] = 'Raport setări:';
$string['putpropertiesunchanged'] = 'Neschimbat:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nostru';
$string['putpropertyproperties'] = 'Proprietăți';
$string['putpropertyreport'] = 'Raport:';
$string['putpropertyversion'] = 'versiune:';
$string['region-content'] = 'Conținut';
$string['region-frnt-footer'] = 'Subsolul paginii';
$string['region-frnt-market-a'] = 'Regiunea paginii unu';
$string['region-frnt-market-b'] = 'Regiune paginii doi';
$string['region-frnt-market-c'] = 'Regiunea paginii trei';
$string['region-frnt-market-d'] = 'Regiunea paginii patru';
$string['region-frnt-market-e'] = 'Regiunea paginii cinci';
$string['region-frnt-market-f'] = 'Regiunea paginii șase';
$string['region-frnt-market-g'] = 'Regiunea paginii șapte';
$string['region-frnt-market-h'] = 'Regiunea paginii opt';
$string['region-frnt-market-i'] = 'Regiunea paginii nouă';
$string['region-frnt-market-j'] = 'Regiunea paginii zece';
$string['region-frnt-market-k'] = 'Regiunea paginii unsprezece';
$string['region-frnt-market-l'] = 'Regiunea paginii doisprezece';
$string['region-frnt-market-m'] = 'Regiunea paginii treisprezece';
$string['region-frnt-market-n'] = 'Regiunea paginii paisprezece';
$string['region-frnt-market-o'] = 'Regiunea paginii cincisprezece';
$string['region-frnt-market-p'] = 'Regiunea paginii șaisprezece';
$string['region-frnt-market-q'] = 'Regiunea paginii șaptesprezece';
$string['region-frnt-market-r'] = 'Regiunea paginii optsprezece';
$string['region-frnt-market-s'] = 'Regiunea paginii nouăsprezece';
$string['region-frnt-market-t'] = 'Regiunea paginii douăzeci';
$string['region-information'] = 'Informații';
$string['region-side-post'] = 'Dreapta';
$string['region-side-pre'] = 'Stânga';
$string['responsivebreadcrumb'] = 'Navigare Beadcrumb';
$string['responsivecoursetitle'] = 'Denumire curs / site';
$string['responsivecoursetitledesc'] = 'DEPRECIAT, utilizați în schimb \'responsivesitetitle\'';
$string['responsiveheader'] = 'Antet principal';
$string['responsiveheadertitle'] = 'Titlu antet';
$string['responsivelogo'] = 'Logo';
$string['responsivepagefooter'] = 'Notă de subsol';
$string['responsivesectionnav'] = 'Navigare activitate / secțiune';
$string['responsivesettingsheading'] = 'Controlează cum apare site-ul pe dimensiuni diferite de ecran';
$string['responsivesitetitle'] = 'Denumire site';
$string['responsivesitetitledesc'] = 'DEPRECIAT, utilizați \'responsiveheadertitle\' în schimb.';
$string['responsivesocial'] = 'Pictograme sociale';
$string['responsiveticker'] = 'Știri derulante';
$string['rightblocks'] = 'Partea dreaptă';
$string['savebuttontext'] = 'Salvare modificări';
$string['sections'] = 'Secțiuni';
$string['selectionbackground'] = 'Culoare de fundal a selecției';
$string['settingsalertbox'] = 'Alert box';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblockicons'] = 'Pictograme';
$string['settingsborders'] = 'Margini';
$string['settingsbreadcrumbcolors'] = 'Culori Breadcrumb';
$string['settingscolors'] = 'Culori';
$string['settingscourses'] = 'Cursuri';
$string['settingsfonts'] = 'Fonturi';
$string['settingsfootercolors'] = 'Culori notă de subsol';
$string['settingsforumheading'] = 'Forum';
$string['settingsheadercolors'] = 'Culori antet';
$string['settingsinformation'] = 'Informații';
$string['settingsmaincolors'] = 'Culori principale';
$string['settingsmarketingcolors'] = 'Culoarea blocurilor Marketing';
$string['settingsmessagescolors'] = 'Culoare mesaje pop-up';
$string['settingsmobilecolors'] = 'Culori pentru versiunea mobilă';
$string['settingspagealertsettings'] = 'Alerte';
$string['settingspageblocksettings'] = 'Bloc';
$string['settingstopicsweeks'] = 'Topicuri / Săptămâni';
$string['show'] = 'Afișare';
$string['showfooterblocks'] = 'Afișați block-urile din subsol';
$string['shownavigationblockoncoursepage'] = 'Afișează blocul navigare pe pagina cursului';
$string['showusername'] = 'Afișează numele de utilizator.';
$string['side-post1'] = 'Bară laterală în nota de subsol';
$string['sidebaricon'] = 'Afișare / ascundere bară laterală';
$string['sitelinkslabel'] = 'Link-uri site';
$string['sitetitle'] = 'Afișați titlul site-ului';
$string['sitetitlecoursesdisabled'] = 'Dezactivat - afișare doar a denumirii cursului în paginile cursului';
$string['sitetitlecoursesenabled'] = 'Activat - afișare denumire site și denumire curs în paginile cursului';
$string['sitetitledefault'] = 'Utilizați denumirea site-ului Moodle (denumire site)';
$string['sitetitleoff'] = 'Dezactivați titlul site-ului';
$string['sitetitletext'] = 'Titlu site';
$string['skipblock'] = 'Omitere bloc {$a}';
$string['slidercaptiondesc'] = 'Adăugați text în slide';
$string['slidercount'] = 'Număr de slidere';
$string['sliderenabled'] = 'Activați slider';
$string['sliderh3color'] = 'Culoare slider one H3';
$string['sliderh4color'] = 'Culoare slider one H4';
$string['sliderimage'] = 'Imagine slider';
$string['sliderimagedesc'] = 'Adăugați o imagine la slide-ul dumneavoastră. Dimensiunea recomandată este 1600px x 400px sau mai mare.';
$string['slideroption2'] = 'Alege tipul de slider';
$string['sliderstyle1'] = 'Slider stil unu';
$string['sliderstyle2'] = 'Slider stil doi';
$string['sliderurldesc'] = 'Adăugați URL-ul către care vă va direcționa slide-ul când dați click';
$string['slidervisible'] = 'Afișare slider când';
$string['slidervisibleloggedin'] = 'Autentificat';
$string['slidervisibleloggedinout'] = 'Autentificat sau dezautentificat';
$string['slidervisibleloggedout'] = 'Dezautentificat';
$string['slideshowsettings'] = 'Slideshow';
$string['slight'] = 'Slight';
$string['socialheading'] = 'Setări pictogramă social';
$string['socialiconlist'] = 'Lista de pictograme sociale';
$string['socialsearchicon'] = 'Căutare Moodle';
$string['socialsettings'] = 'Antet social';
$string['socialsize'] = 'Setați dimensiunea fonturilor pictogramelor sociale';
$string['socialtargetdesc'] = 'Cum vreți să se deschidă link-urile sociale (aici sau în fereastră nouă)';
$string['solid'] = 'Solid';
$string['standard'] = 'Standard';
$string['standardscreenwidth'] = 'Lățime standard ecran.';
$string['standardview'] = 'Vizualizare standard';
$string['static'] = 'Static';
$string['stickynavbar'] = 'Sticky navbar în partea de sus';
$string['stylecover'] = 'Cover';
$string['stylestretch'] = 'Stretch';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Culori selectate ale tab-urilor pentru pagina de curs';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Alegeți culoarea tab-ului selectat acum.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Culoarea neselectată  a tab-ului pagina de curs';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Alegeți culoarea pentru orice alt tab.';
$string['tabbedlayoutdashboardtab1condition'] = 'Restricție Câmp de Profil Personalizat Tab unu (opțional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Adaugă regulă de acces pentru afișarea Tab-ului 1 utilizând câmpul de profil personalizat, de ex. showtab1=adevărat.';
$string['tabbedlayoutdashboardtab2condition'] = 'Restricție pentru Câmpul de Profil Personalizat Tab doi (opțional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Adaugă regulă de acces pentru afișarea Tab-ului 2 utilizând câmpul de profil personalizat, de ex: showtab2=adevărat.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Culoare selectată pentru tab-ul Tablou de bord';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Alegeți culoarea tab-ului selectat acum.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Culoare neselectată pentru tab-ul Tablou de bord';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Alegeți culoarea pentru oricare alt tab.';
$string['tabbedlayouttablabelcourse'] = 'Conținut curs';
$string['tabbedlayouttablabelcourse1'] = 'Tab doi';
$string['tabbedlayouttablabelcourse2'] = 'Tab doi';
$string['tabbedlayouttablabeldashboard'] = 'Conținut Tablou de bord';
$string['tabbedlayouttablabeldashboard1'] = 'Tab unu';
$string['tabbedlayouttablabeldashboard2'] = 'Tab doi';
$string['targetnewwindow'] = 'Fereastră nouă';
$string['targetsamewindow'] = 'Acceași fereastră';
$string['templatesheading'] = 'Setări șabloane';
$string['templatesheadingdesc'] = 'Suprascrie șabloane.';
$string['templatessel'] = 'Șabloane de susprascris';
$string['templatessettings'] = 'Șabloane';
$string['themechanges'] = 'Modificări';
$string['themereadme'] = 'Readme';
$string['themesupportsponsorship'] = 'Suport și sponsorizare';
$string['thiscourse'] = 'Acest curs';
$string['ticker'] = 'Anunțuri';
$string['tickerdefault'] = 'Nu există noutăți de afișat';
$string['tickerfullscreen'] = 'Lățime ecran complet';
$string['tickersettings'] = 'Știri derulante';
$string['tickersettingsheading'] = 'Configurare știri derulante';
$string['tickertext'] = 'Text știri derulante';
$string['tickertextprofilefield'] = 'Denumire Câmp de Profil Personalizat=Valoare (opțional)';
$string['tickertextprofilefielddesc'] = 'Adaugă regulă de acces pentru câmpul de profil personalizat, de ex: usertype=cursant';
$string['tickerwidth'] = 'Lățime fixă';
$string['tickerwidthdesc'] = 'Puteți utiliza acestă setare pentru a stabili lățimea fixă a știrilor derulante la 100%.';
$string['tilesshowallcontacts'] = 'Afișează toate contactele de la curs';
$string['tilesshowallcontactsdesc'] = 'Afișează toate contactele de la curs sau doar unul.';
$string['tilesshowcontacts'] = 'Afișează contactele din curs';
$string['tilesshowcontactsdesc'] = 'Afișează / ascunde contactele din curs';
$string['toolsmenu'] = 'Meniu instrumente';
$string['toolsmenudesc'] = 'Adaugă link-urile aici.';
$string['toolsmenufielddesc'] = 'Adaugă regulă de acces pentru câmpul de profil personalizat, de ex. usertype=cursant.';
$string['toolsmenuheading'] = 'Meniu instrumente';
$string['toolsmenuheadingindex'] = 'Meniu instrumente {$a}';
$string['toolsmenuscount'] = 'Număr de meniuri instrumente';
$string['toolsmenutitledefault'] = 'Instrumente';
$string['toolsmenutitledesc'] = 'Adaugă denumirea meniului pe care vrei să îl afișezi în bara de navigare principală.';
$string['usermenu'] = 'Meniu utilizator';
$string['usernameposition'] = 'Poziția numelui de utilizator';
$string['usernamepositiondesc'] = 'Setare poziție nume de de utilizator, \'Stânga\' sau \'Dreapta\'.';
$string['usernav'] = 'Antet utilizator';
$string['usernodescription'] = 'Utilizatorul nu și-a actualizat încă descrierea.';
$string['usernointerests'] = 'Utilizatorul nu și-a actualizat încă interesele.';
$string['usersettings'] = 'Profilul utilizatorului';
$string['usersettingsdesc'] = 'Setează configurarea profilului utilizatorului.';
$string['usersettingsheading'] = 'Controlează aspectul profilului utilizatorului';
$string['versionalpha'] = 'Versiune alpha - Aproape sigur conține bug-uri. Este o versiune în dezvoltare \'doar\' pentru dezvoltatori! A nu se instala pe un server de producție!';
$string['versionbeta'] = 'Versiune beta - Foarte probabil conține bug-uri. Gata pentru testare de către administratori doar pe un server test.';
$string['versioninfo'] = 'Lansare {$a->release}, versiune {$a->version} în Moodle {$a->moodle}';
$string['wide'] = 'Ecran complet';
