<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'da', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['activate'] = 'Aktiver adgang';
$string['activatesuccess'] = 'Adgang til badges er aktiveret';
$string['addalignment'] = 'En ekstern kvalifikation eller standard';
$string['addbadge'] = 'Tilføj badges';
$string['addbadge_help'] = 'Vælg de badges der skal føjes til disse badge-krav. Hold CTRL nede for at vælge flere.';
$string['addbadgecriteria'] = 'Tilføj badgekriterium';
$string['addcohort'] = 'Tilføj brugergruppe';
$string['addcohort_help'] = 'Vælg de brugergrupper der skal føjes til disse badge-krav. Hold CTRL nede for at vælge flere.';
$string['addcompetency'] = 'Tilføj kompetence';
$string['addcompetency_help'] = 'Vælg de kompetencer der skal føjes til disse badge-krav. Hold CTRL nede for at vælge flere.';
$string['addcourse'] = 'Tilføj kurser';
$string['addcourse_help'] = 'Udvælg alle kurser der skal føjes til dette badgekrav. Hold CTRL-tasten nede for at udvælge flere.';
$string['addcriteria'] = 'Tilføj kriterier';
$string['addcriteriatext'] = 'Vælg en af mulighederne fra rullemenuen for at tilføje kriterier.';
$string['addedtobackpack'] = 'Badge føjet til rygsæk';
$string['addrelated'] = 'Tilføj relateret badge';
$string['addtobackpack'] = 'Føj til rygsæk';
$string['adminonly'] = 'Denne side kan kun tilgås af til site-administratorer.';
$string['after'] = 'efter udstedelsesdato';
$string['aggregationmethod'] = 'Sammenlægningsmetode';
$string['alignment'] = 'Justering';
$string['all'] = 'Alle';
$string['allmethod'] = 'Alle valgte betingelser er opfyldt';
$string['allmethodactivity'] = 'Alle valgte aktiviteter er udførte';
$string['allmethodbadges'] = 'Alle valgte badges er optjent';
$string['allmethodcohort'] = 'Medlemskab i alle valgte brugergrupper';
$string['allmethodcompetencies'] = 'Alle valgte kompetencer er opnået';
$string['allmethodcourseset'] = 'Alle valgte kurser er gennemførte';
$string['allmethodmanual'] = 'Alle de valgter roller kan tildele denne badge';
$string['allmethodprofile'] = 'Alle de udvalgte profilfelter er færdiggjort';
$string['allowcoursebadges'] = 'Aktiver kursusbadges';
$string['allowcoursebadges_desc'] = 'Tillad badges at blive oprettet og tildelt på kursusniveau.';
$string['allowexternalbackpack'] = 'Forbindelse til ekstern rygsæk';
$string['allowexternalbackpack_desc'] = 'Er indstillingen aktiveret, kan brugere forbinde til en ekstern rygsæk og dele deres badges der fra dette site. De kan også vælge at vise eksterne badges på deres profil i Moodle. Det anbefales at lade indstillingen være deaktiveret hvis siden ikke er tilgængelig fra internettet.';
$string['any'] = 'Enhver';
$string['anymethod'] = 'Alle de valgte betingelser er opfyldt';
$string['anymethodactivity'] = 'Alle valgte aktiviteter er gennemførte';
$string['anymethodbadges'] = 'Alle de valgte badges er opnået';
$string['anymethodcohort'] = 'Medlemskab i alle de valgte brugergrupper';
$string['anymethodcompetencies'] = 'Alle de valgte kompetencer er opnået';
$string['anymethodcourseset'] = 'Alle de valgte kurser er gennemførte';
$string['anymethodmanual'] = 'Alle de valgte roller kan udstede badgen';
$string['anymethodprofile'] = 'Alle de valgte profilfelter er fuldførte';
$string['apiversion'] = 'API-version understøttes';
$string['archivebadge'] = 'Vil du slette badgen "{$a}", men beholde alle allerede tildelte badges?';
$string['archiveconfirm'] = 'Slet og behold allerede tildelte badges';
$string['archivehelp'] = '<p>Denne mulighed betyder, at badgen vil blive markeret som "pensioneret" og vil ikke længere fremgå af badge-listen. Brugere vil ikke længere kunne optjene retten til badgen, dog vil brugere der allerede har fået den tildelt, fortsat kunne få vist den på deres profilside og eksportere den til deres eksterne rygsække.</p> <p> Hvis du ønsker at dine brugere bibeholder adgangen til de optjente badges er det vigtigt at denne mulighed vælges i stedet for at badges slettes fuldstændigt. </p>';
$string['attachment'] = 'Tilføj badge til besked';
$string['attachment_help'] = 'Er indstillingen aktiveret, vil en tildelt badge tilføjes modtagerens e-mail til download. (Vedhæftning af filer skal være aktiveret i  Siteadministration / Server / E-mail / Konfiguration af udgående mail.)';
$string['award'] = 'Tildel badge';
$string['awardedto'] = 'Tildelt {$a}';
$string['awardedtoyou'] = 'Udstedt til mig';
$string['awardoncron'] = 'Adgang til badges blev aktiveret. For mange brugere kan straks optjene ret til denne badge. For at sikre en god ydeevne, vil behandlingen tage lidt tid.';
$string['awards'] = 'Modtagere';
$string['backpackapiurl'] = 'Rygsæk-API URL';
$string['backpackavailability'] = 'Ekstern badgeverifikation';
$string['backpackavailability_help'] = 'For at badgemodtagere kan bevise at de har optjent deres badge fra dig, bør en ekstern rygsækservice kunne få adgang til dit site og verificere badges tildelt fra det. Dit site ser p.t. ikke ud til at være tilgængeligt, hvilket betyder, at badges der allerede er tildelt eller vil blive tildelt, fremadrettet ikke kan verificeres.

**Hvorfor ser jeg denne besked?**

Det kan være at jeres firewall ikke tillader adgang for brugere udenfor jeres netværk, at jeres site er adgangskodebeskyttet, eller at du kører sitet fra en computer der ikke kan tilgås fra internettet (såsom en lokal udviklingsmaskine).

**Er dette et problem?**

Du bør fikse dette problem på en installation i drift hvorfra du planlægger at kunne tildele badges, ellers vil modtagerne ikke kunne bevise at de har optjent deres badges fra jer. Hvis jeres site endnu ikke er gået live, kan du danne og tildele testbadges blot sitet er tilgængeligt når I går live.

**Hvad hvis jeg ikke kan gøre mit fulde site tilgængeligt?**

Den eneste URL der er påkrævet for verifikation, er [ditdomæne.dk]/badges/assertion.php, så hvis I kan konfigurere jeres firewall til at tillade ekstern adgang til denne fil, vil verifikation af badges fortsat virke.';
$string['backpackbadgessettings'] = 'Rediger rygsækindstillinger';
$string['backpackbadgessummary'] = 'Du har {$a->totalbadges} badge(s) vist fra {$a->totalcollections} samling(er).';
$string['backpackcannotsendverification'] = 'Kan ikke sende verifikationsmail';
$string['backpackconnected'] = 'Rygsækken er forbundet';
$string['backpackconnection'] = 'Forbind til en rygsæk';
$string['backpackconnection_connected'] = 'Din rygsæk';
$string['backpackconnection_help'] = 'Gem og del dine badges fra denne hjemmeside, og vis offentlige badges fra andre hjemmesider på din brugerprofil.';
$string['backpackconnectioncancelattempt'] = 'Forbind med en anden mailadresse';
$string['backpackconnectionconnect'] = 'Forbind til rygsæk';
$string['backpackconnectionnottested'] = 'Forbindelsen kan ikke testes for denne rygsæk da kun Open Badges v2.0 understøtter den.';
$string['backpackconnectionok'] = 'Forbindelse til rygsæk etableret';
$string['backpackconnectionresendemail'] = 'Gensend verifikationsmail';
$string['backpackconnectionunexpectedmessage'] = 'Rygsækken returnerede en fejl: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Der opstod et problem med at oprette forbindelse til din rygsæk. Din rygsækudbyder sender denne besked: \'{$a}\'.';
$string['backpackdetails'] = 'Rygsækindstillinger';
$string['backpackdisconnected'] = 'Forbindelse til rygsækken er afbrudt';
$string['backpackemail'] = 'E-mailadresse';
$string['backpackemail_help'] = 'E-mailadresse som er tilknyttet din rygsæk. Mens du er forbundet vil enhver badge du optjener via dette site, blive tilknyttet denne e-mailadresse.';
$string['backpackemail_required'] = 'E-mailadressen må ikke være tom';
$string['backpackemailverificationpending'] = 'Afventer verificering';
$string['backpackemailverifyemailbody'] = 'Hej {$a->userfirstname},

Du er næsten færdig med at oprette forbindelse til din badges-rygsæk på \'{$a->sitename}\'.

For at afslutte forbindelsen til din rygsæk skal du bekræfte din e-mailadresse via følgende knap:

{$a->buttonlink}

Virker knappen ikke, kan du kopiere og indsætte følgende URL i din browser:
{$a->link}

Hvis du ikke har forsøgt at oprette forbindelse til din badges-rygsæk, kan du roligt ignorere denne e-mail.

Har du brug for yderligere hjælp, bedes du kontakte dit websteds support

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Badge-rygsæk mail-verifikation';
$string['backpackemailverifypending'] = 'Vi har sendt en mail til <strong>{$a}</strong>. Klik på bekræftelseslinket i mailen for at aktivere din rygsækforbindelse.';
$string['backpackemailverifysuccess'] = 'Du har nu forbindelse til din rygsæk.';
$string['backpackemailverifytokenmismatch'] = 'Linkets token matcher ikke det gemte token. Du bør sikre dig at du har klikket på linket i den sidste mail du har modtaget.';
$string['backpackexporterror'] = 'Kan ikke eksportere badgen til rygsækken';
$string['backpackexporterrorwithinfo'] = 'Kan ikke eksportere mærket "{$a->badgename}" til rygsækken. Fejl: {$a->error}';
$string['backpackimport'] = 'Badge-importindstillinger';
$string['backpackimport_help'] = 'Når forbindelsen til rygsækken er korrekt etableret, kan badges fra din rygsæk blive vist på din badge- og din profilside.

I dette område kan du udvælge samlinger af badges fra din rygsæk som du gerne vil vise på din profil.';
$string['backpackprovider'] = 'Rygsækudbyder';
$string['backpacksettings'] = 'Rygsækindstillinger';
$string['backpackweburl'] = 'Rygsækhjemmesides URL';
$string['badgedetails'] = 'Badgeoplysninger';
$string['badgeimage'] = 'Billede';
$string['badgeimage_help'] = 'Billedet skal være mindst 300 x 300 pixel stort. Det vil blive vist som 300 x 300 pixels på badgesiden og 100 x 100 pixels på brugerens profilside.';
$string['badgeissued'] = 'Badge udstedt';
$string['badgeprivacysetting'] = 'Badges\' privatlivsindstillinger';
$string['badgeprivacysetting_help'] = 'De badges du har optjent kan vises på din profilside. Denne indstilling tillader at du automatisk kan indstille synligheden af nyligt optjente badges.

Du kan stadig kontrollere individuelle badge\'s privatlivsindstillinger fra din badgeside.';
$string['badgeprivacysetting_str'] = 'Vis automatisk badges jeg optjener på min profilside';
$string['badges'] = 'Badges';
$string['badgesalt'] = '"Salt" til "hashing" af modtagerens mailadresse';
$string['badgesalt_desc'] = 'Anvendelse af hash muliggør rygsækservicer at bekræfte badgeejere uden at afsløre deres e-mailadresser. Denne indstilling bør kun bruge tal og bogstaver. Bemærk: Af hensyn til verifikation af modtagere skal det undgås at ændre denne indstilling efter start på udstedelse af badges.';
$string['badgesdisabled'] = 'Badges er ikke aktiveret på dette site.';
$string['badgesearned'] = 'Antal badges optjent: {$a}';
$string['badgesettings'] = 'Badgeindstillinger';
$string['badgestatus_0'] = 'Ikke tilgængelig';
$string['badgestatus_1'] = 'Tilgængelig';
$string['badgestatus_2'] = 'Ikke tilgængelig (kriterierne er låst)';
$string['badgestatus_3'] = 'Tilgængelig (kriterierne er låst)';
$string['badgestatus_4'] = 'Arkiveret';
$string['badgestoearn'] = 'Antal tilgængelige badges: {$a}';
$string['badgesview'] = 'Kursusbadges';
$string['badgetags'] = 'Emneknapper';
$string['badgeurl'] = 'Link til tildelt badge';
$string['balignment'] = 'Justeringer  ({$a})';
$string['bawards'] = 'Modtagere ({$a})';
$string['bcriteria'] = 'Kriterier';
$string['bdetails'] = 'Rediger oplysninger';
$string['bendorsement'] = 'Godkendelse';
$string['bmessage'] = 'Besked';
$string['boverview'] = 'Oversigt';
$string['brelated'] = 'Relaterede badges ({$a})';
$string['bydate'] = 'færdiggør inden';
$string['claim'] = 'Krav';
$string['claimcomment'] = 'Kommentar ved godkendelse';
$string['claimid'] = 'Gør krav på (Claim) URL';
$string['clearsettings'] = 'Nulstil indstillinger';
$string['completioninfo'] = 'Denne badge blev tildelt for færdiggørelse af:';
$string['completionnotenabled'] = 'Kursusgennemførelse er ikke aktiveret på dette kursus, og kan derfor ikke bruges i badgekriterier. Kursusgennemførelse kan aktiveres i kursusindstillingerne.';
$string['configenablebadges'] = 'Er indstillingen aktiveret, kan du oprette badges og uddele dem til brugerne.';
$string['configuremessage'] = 'Badge-besked';
$string['connect'] = 'Forbind';
$string['connected'] = 'Forbundet';
$string['connecting'] = 'Forbinder...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'En e-mailadresse tilknyttet til badge-tildeleren.';
$string['copy'] = 'Kopi';
$string['copyof'] = 'Kopi af {$a}';
$string['course'] = 'Kursus: {$a}';
$string['coursebadges'] = 'Badges';
$string['coursebadgesdisabled'] = 'Kursusbadges er ikke aktiveret på sitet.';
$string['coursebadgetitle'] = '{$a} krususbadge';
$string['coursecompletion'] = 'Brugere skal gennemføre dette kursus.';
$string['create'] = 'Ny badge';
$string['createbutton'] = 'Opret badge';
$string['creatorbody'] = '<p>{$a->user} har færdiggjort alle badgekrav og fået tildelt denne badge. Se tildelt badge på {$a->link} </p>';
$string['creatorsubject'] = '"{$a}" er blevet tildelt!';
$string['criteria_0'] = 'Denne badge tildeles når...';
$string['criteria_1'] = 'Aktivitetsgennemførelse';
$string['criteria_1_help'] = 'Muliggør at en badge kan blive tildelt brugere baseret på gennemførelse af et sæt aktiviteter på et kursus.';
$string['criteria_2'] = 'Manuel udstedelse via rolle';
$string['criteria_2_help'] = 'Muliggør en badge at blive manuelt tildelt af brugere med en bestemt rolle på sitet eller kurset.';
$string['criteria_3'] = 'Social deltagelse';
$string['criteria_3_help'] = 'Sociale';
$string['criteria_4'] = 'Kursusgennemførelse';
$string['criteria_4_help'] = 'Muliggør at en badge kan blive tildelt brugere som har gennemført kurset. Kriteriet kan have flere parametre såsom en minimumskarakter og dato for gennemførelse.';
$string['criteria_5'] = 'Fuldfør et sæt kurser';
$string['criteria_5_help'] = 'Muliggør at en badge kan blive tildelt brugere som har gennemført et sæt kurser. Hvert kursus kan have flere parametre såsom en minimumskarakter og dato for gennemførelse.';
$string['criteria_6'] = 'Profilfuldførelse';
$string['criteria_6_help'] = 'Tillader en badge at blive tildelt brugere for at færdiggøre visse felter i deres profil. Du kan vælge fra standard og brugerdefinerede profilfelter der er tilgængelige for brugere';
$string['criteria_7'] = 'Tildelte badges';
$string['criteria_7_help'] = 'Muliggør at en badge kan tildeles en bruger på baggrund af brugerens andre badges.';
$string['criteria_8'] = 'Medlemskab af brugergruppe';
$string['criteria_8_help'] = 'Muliggør at en badge kan tildeles brugere på baggrund af medlemskab af brugergruppe.';
$string['criteria_9'] = 'Kompetencer';
$string['criteria_9_help'] = 'Muliggør at en badge kan tildeles brugere på baggrund af de kompetencer de har opnået.';
$string['criteria_descr'] = 'Brugere tildeles denne badge når de opfylder følgende krav:';
$string['criteria_descr_0'] = 'Opfyld <strong>{$a}</strong> af de stillede krav.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> af følgende aktiviteter er gennemførte:';
$string['criteria_descr_2'] = 'Denne badge skal tildeles af brugere med <strong>{$a}</strong> af de følgende roller:';
$string['criteria_descr_4'] = 'Brugere skal færdiggøre kurset';
$string['criteria_descr_5'] = '<strong>{$a}</strong> af de følgende kurser skal færdiggøres:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> af de følgende brugerprofilfelter skal færdiggøres:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> af følgende badges skal optjenes:';
$string['criteria_descr_8'] = 'Der kræves medlemskab af <strong>{$a}</strong> af følgende brugergrupper:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> af følgende kompetencer skal opnås:';
$string['criteria_descr_bydate'] = 'før <em>{$a}</em>';
$string['criteria_descr_grade'] = 'med minimumskarakter på <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Færdiggør <strong>{$a}</strong> af:';
$string['criteria_descr_short1'] = 'Færdiggør <strong>{$a}</strong> af:';
$string['criteria_descr_short2'] = 'Tildelt af <strong>{$a}</strong> af:';
$string['criteria_descr_short4'] = 'Færdiggør kurset';
$string['criteria_descr_short5'] = 'Færdiggør <strong>{$a}</strong> af:';
$string['criteria_descr_short6'] = 'Færdiggør <strong>{$a}</strong> af:';
$string['criteria_descr_short7'] = 'Færdiggør <strong>{$a}</strong> af:';
$string['criteria_descr_short8'] = 'Brugergruppemedlemskab i <strong>{$a}</strong> af:';
$string['criteria_descr_short9'] = 'Færdiggør <strong>{$a}</strong> af:';
$string['criteria_descr_single_1'] = 'Følgende aktivitet skal færdiggøres:';
$string['criteria_descr_single_2'] = 'Badgen kan tildeles af en bruger med følgende rolle:';
$string['criteria_descr_single_4'] = 'Brugere skal færdiggøre kurset';
$string['criteria_descr_single_5'] = 'Dette kursus skal færdiggøres:';
$string['criteria_descr_single_6'] = 'Følgende brugerprofilfelt skal færdiggøres:';
$string['criteria_descr_single_7'] = 'Følgende badge skal optjenes:';
$string['criteria_descr_single_8'] = 'Der kræves medlemskab af følgende brugergruppe:';
$string['criteria_descr_single_9'] = 'Følgende kompetencer skal opnås:';
$string['criteria_descr_single_short1'] = 'Færdiggør:';
$string['criteria_descr_single_short2'] = 'Tildelt af:';
$string['criteria_descr_single_short4'] = 'Færdiggør kurset';
$string['criteria_descr_single_short5'] = 'Færdiggør:';
$string['criteria_descr_single_short6'] = 'Færdiggør:';
$string['criteria_descr_single_short7'] = 'Færdiggjort:';
$string['criteria_descr_single_short8'] = 'Medlemskab af:';
$string['criteria_descr_single_short9'] = 'Færdig:';
$string['criteriacreated'] = 'Badgekriterier oprettet';
$string['criteriadeleted'] = 'Badgekriterier slettet';
$string['criteriasummary'] = 'Resumé af kriterie';
$string['criteriaupdated'] = 'Badgekriterier opdateret';
$string['criterror'] = 'Fejl i nuværende parametre';
$string['criterror_help'] = 'Disse felter viser alle parametre der oprindelig blev tilføjet denne badges krav, men er ikke længere tilgængelige. Det anbefales at deaktivere dem for at sikre at man fremover kan gøre sig fortjent til den.';
$string['currentimage'] = 'Nuværende billede';
$string['currentstatus'] = 'Nuværende status:';
$string['dateawarded'] = 'Udstedelsesdato';
$string['dateearned'] = 'Dato: {$a}';
$string['day'] = 'Dag(e)';
$string['deactivate'] = 'Deaktiver adgang';
$string['deactivatesuccess'] = 'Adgang til badges blev deaktiveret.';
$string['defaultissuercontact'] = 'Badge-udbyders mailadresse';
$string['defaultissuercontact_desc'] = 'Badge-udbyders mailadresse. Til en Open Badges v2.0-rygsæk bruges den i forbindelse med godkendelse når badges publiceres i en rygsæk.';
$string['defaultissuername'] = 'Badge-udbyders navn';
$string['defaultissuername_desc'] = 'Badge-udbyders navn.';
$string['defaultissuerpassword'] = 'Badge-udbyders adgangskode';
$string['defaultissuerpassword_help'] = 'Det er nødvendigt med en konto på rygsæksiden med mailadresse som specificeret i badgeudbyders indstilling for mailadresse i Siteadministration / Badges / Badgeindstillinger';
$string['delbadge'] = 'Vil du slette badgen "{$a}" og fjerne alle eksisterende udstedte badges?';
$string['delconfirm'] = 'Slet og fjern eksisterende udstedte badges';
$string['delcritconfirm'] = 'Er du sikker på at du vil slette dette kriterium?';
$string['deletehelp'] = '<p>At slette en badge helt betyder, at al dens information og kriterieposter vil blive fjernet permanent. Brugere der har optjent badgen, vil ikke længere kunne tilgå og vise den på deres profilside.</p> <p>Bemærk: Brugere der har optjent badgen og allerede har lagt den i deres eksterne rygsæk, vil stadig have den i deres eksterne rygsæk. Imidlertid vil de ikke kunne tilgå kriterier og vidnesbyrdsider der linker tilbage til dette websted.</p>';
$string['delexternalbackpack'] = 'Slet webstedsrygsæk';
$string['delexternalbackpackconfirm'] = 'Slet site-rygsæk "{$a}"?';
$string['delparamconfirm'] = 'Er du sikker på at du vil slette dette parameter?';
$string['description'] = 'Beskrivelse';
$string['disconnect'] = 'Afbryd';
$string['donotaward'] = 'Denne badge er pt. ikke aktiv, så den kan ikke tildeles brugere. Vil du gerne tildele den, skal dens status ændres til aktiv.';
$string['enablebadges'] = 'Aktiver badges';
$string['endorsement'] = '';
$string['error:backpackdatainvalid'] = 'Data returneret fra rygsækken var ikke gyldige.';
$string['error:backpackemailnotfound'] = 'E-mailadressen "{$a}" er ikke knyttet til en rygsæk. Du må <a href="https://backpack.openbadges.org">oprette en rygsæk</a> til kontoen eller logge ind med en anden e-mailadresse.';
$string['error:badgeawardnotfound'] = 'Kan ikke verificere denne tildelte badge. Den kan være tilbagekaldt.';
$string['error:badgenotfound'] = 'Badge ikke fundet';
$string['error:cannotact'] = 'Kan ikke aktivere badgen.';
$string['error:cannotawardbadge'] = 'Kan ikke tildele badgen til brugeren.';
$string['error:cannotdeletecriterion'] = 'Dette kriterie kan ikke slettes.';
$string['error:cannotrevokebadge'] = 'Kan ikke tilbagekalde badgen fra en bruger.';
$string['error:clone'] = 'Kan ikke klone badgen.';
$string['error:connectionunknownreason'] = 'Forbindelsen var ikke succesfuld men der blev ikke angivet en årsag';
$string['error:duplicatename'] = 'Der eksisterer allerede en badge i systemet med dette navn.';
$string['error:externalbadgedoesntexist'] = 'Badge ikke fundet';
$string['error:guestuseraccess'] = 'Du bruger gæsteadgang. Du skal logge ind med din brugerkonto hvis du vil se badges.';
$string['error:invalidcriteriatype'] = 'Ugyldig kriterietype';
$string['error:invalidexpiredate'] = 'Udløbsdato skal ligge i fremtiden';
$string['error:invalidexpireperiod'] = 'Udløbsdato kan ikke være negativ eller lig 0.';
$string['error:invalidparambadge'] = 'Badgen eksisterer ikke.';
$string['error:invalidparamcohort'] = 'Brugergruppen eksisterer ikke.';
$string['error:noactivities'] = 'Der er ikke aktiveret nogen aktiviteter med gennemførelseskriterier på dette kursus.';
$string['error:nobadges'] = 'Der er ingen kurser eller site-badges med adgang aktiveret der skal tilføjes som kriterium. Et site-badge kan kun have andre badges som kriterium. Et kursus-badge kan have andre kursers badges eller site-badges som kriterium.';
$string['error:nocohorts'] = 'Ingen brugergrupper';
$string['error:nocourses'] = 'Kursusgennemførelse er ikke aktiveret for nogen kurser på dette site, så intet kan vises. Kursusgennemførelse kan aktiveres i kursusindstillingerne.';
$string['error:nogroupslink'] = '<p>Kun offentlige samlinger vises. <a href="{$a}" target="_blank" rel="nofollow">Besøg din rygsæt</a> for at oprette offentlige samlinger.</p>';
$string['error:nogroupssummary'] = '<p>Der er ingen offentligt tilgængelige badgesamlinger i din rygsæk. </p>';
$string['error:nopermissiontoview'] = 'Du har ikke tilladelse til at se badgemodtagere.';
$string['error:nosuchbadge'] = 'Badge med id\'en {$a} findes ikke.';
$string['error:nosuchcohort'] = 'Advarsel: Brugergruppen er ikke længere tilgængelig.';
$string['error:nosuchcourse'] = 'Advarsel: Dette kursus er ikke længere tilgængeligt.';
$string['error:nosuchfield'] = 'Advarsel: Dette brugerprofilfelt er ikke længere tilgængeligt.';
$string['error:nosuchmod'] = 'Advarsel: Denne aktivitet er ikke længere tilgængelig.';
$string['error:nosuchrole'] = 'Advarsel: Denne rolle er ikke længere tilgængelig.';
$string['error:nosuchuser'] = 'Bruger med denne e-mailadresse har ikke en konto hos den aktuelle rygsækudbyder.';
$string['error:notifycoursedate'] = 'Advarsel: Badges knyttet til kursus- og aktivitetsgennemførelse vil først blive udstedt på kursets startdato.';
$string['error:parameter'] = 'Advarsel: Mindst en parameter skal vælges for at sikre korrekt badgeudstedelsesprocedure';
$string['error:relatedbadgedoesntexist'] = 'Der er ingen offentlig badge med denne identifikator';
$string['error:requesterror'] = 'Forbindelsesforsøget mislykkedes (fejlkode {$a}).';
$string['error:requesttimeout'] = 'Forbindelsesforsøget timede ud før det kunne gøres færdigt.';
$string['error:save'] = 'Kan ikke gemme badgen';
$string['error:userdeleted'] = '{$a->user} (Denne bruger findes ikke længere på {$a->site})';
$string['eventbadgearchived'] = 'Badge arkiveret';
$string['eventbadgeawarded'] = 'Badge tildelt';
$string['eventbadgecreated'] = 'Badge oprettet';
$string['eventbadgecriteriacreated'] = 'Badgekriterier oprettet';
$string['eventbadgecriteriadeleted'] = 'Badgekriterier slettet';
$string['eventbadgecriteriaupdated'] = 'Badgekriterier opdateret';
$string['eventbadgedeleted'] = 'Badge slettet';
$string['eventbadgedisabled'] = 'Badge deaktiveret';
$string['eventbadgeduplicated'] = 'Badge kopieret';
$string['eventbadgeenabled'] = 'Badge aktiveret';
$string['eventbadgelistingviewed'] = 'Badgeliste vist';
$string['eventbadgerevoked'] = 'Badge tilbagekaldt';
$string['eventbadgeupdated'] = 'Badge opdateret';
$string['eventbadgeviewed'] = 'Badge set';
$string['evidence'] = 'Vidnesbyrd';
$string['existingrecipients'] = 'Eksisterende badgemodtagere';
$string['existsinbackpack'] = 'Badgen findes allerede i rygsækken';
$string['expired'] = 'Udløbet';
$string['expiredate'] = 'Badgen udløber {$a}.';
$string['expireddate'] = 'Badgen udløb {$a}.';
$string['expiredin'] = 'Udløbet {$a}';
$string['expireperiod'] = 'Badgen udløber {$a} dag(e) efter udstedelsen.';
$string['expireperiodh'] = 'Badgen udløber {$a} time(r) efter udstedelsen.';
$string['expireperiodm'] = 'Badgen udløber {$a} minut(ter) efter udstedelsen.';
$string['expireperiods'] = 'Badgen udløber {$a} sekund(er) efter udstedelsen.';
$string['expiresin'] = 'Udløber {$a}';
$string['expirydate'] = 'Udløbsdato';
$string['expirydate_help'] = 'Badges kan eventuelt have en udløbstid, som kan være en fast dato eller en beregnet ud fra udstedelsesdatoen.';
$string['externalbackpack_required'] = 'Rygsækudbyder kan ikke være tom';
$string['externalbadges'] = 'Mine badges fra ældre websteder';
$string['externalbadges_help'] = 'Her vises badges fra din eksterne rygsæk.';
$string['externalbadgesp'] = 'Badges fra andre websteder:';
$string['externalconnectto'] = 'Du skal <a href="{$a}">forbinde til en rygsæk</a> for at vise eksterne badges.';
$string['fixed'] = 'Fast dato';
$string['hidden'] = 'Skjult';
$string['hiddenbadge'] = 'Desværre, badgeindehaveren har ikke gjort denne information tilgængelig.';
$string['hostedurl'] = 'Ekstern URL';
$string['hostedurldescription'] = 'Ekstern URL hvor badget er hostet';
$string['imageauthoremail'] = 'Billedforfatterens e-mail';
$string['imageauthoremail_help'] = 'Hvis det er angivet, vises e-mail-adressen til badge-billedforfatteren på badgesiden.';
$string['imageauthorname'] = 'Billedforfatterens navn';
$string['imageauthorname_help'] = 'Hvis angivet, vises navnet på forfatteren af badge-billedet på badgesiden.';
$string['imageauthorurl'] = 'Billedforfatterens URL';
$string['imageauthorurl_help'] = 'Hvis angivet, vises et link til badge-billedforfatterens websted på badgesiden. URL\'en skal have et præfiks http:// or https://.';
$string['imagecaption'] = 'Billedtekst';
$string['imagecaption_help'] = 'Hvis specificeret, vises billedteksten på badge-siden.';
$string['includeauthdetails'] = 'Inkluder godkendelsesoplysninger med rygsækken';
$string['invalidurl'] = 'Ugyldig URL';
$string['issuancedetails'] = 'Badge-udløb';
$string['issuedbadge'] = 'Information om udstedt badge';
$string['issuedby'] = 'Udstedt af {$a}';
$string['issuedon'] = 'Udstedt {$a}';
$string['issuerdetails'] = 'Udstederdata';
$string['issueremail'] = 'Mailadresse';
$string['issueremail_help'] = 'En e-mailadresse til den organisation, der udsteder godkendelsen.';
$string['issuername'] = 'Udsteders navn';
$string['issuername_endorsement'] = 'Navn på godkender';
$string['issuername_endorsement_help'] = 'Navnet på garanten.';
$string['issuername_help'] = 'Navn på den udstedende agent eller autoritet.';
$string['issuerurl'] = 'Udsteders URL';
$string['issuerurl_help'] = 'Organisationens websted, der udsteder godkendelsen. URL\'en bør have et præfiks http:// eller https://.';
$string['language'] = 'Sprog';
$string['language_help'] = 'Sprog brugt på badge-siden';
$string['listbackpacks'] = 'Rygsækliste';
$string['localbadges'] = 'Mine badges fra webstedet {$a}';
$string['localbadgesh'] = 'Mine badges fra dette websted';
$string['localbadgesh_help'] = 'Alle badges opnået på dette websted ved gennemførelse af kurser, kursusaktiviteter mv.

Du kan håndtere dine badges her og gøre dem offentlige eller private på din profilside.

Du kan downloade alle på en gang eller hver badge for sig og gemme dem på din computer. Downloadede badges kan føjes til din eksterne rygsækservice.';
$string['localbadgesp'] = 'Badges fra {$a}:';
$string['localconnectto'] = 'Du skal <a href="{$a}">forbinde til en rygsæk</a> for at dele disse badges udenfor dette websted..';
$string['loginbackpacktitle'] = '<strong>Log ind på din rygsæk</strong>';
$string['makeprivate'] = 'Gør privat';
$string['makepublic'] = 'Gør offentlig';
$string['managebackpacks'] = 'Håndter rygsække';
$string['managebadges'] = 'Administrer badges';
$string['message'] = 'Besked tekst';
$string['messagebody'] = '<p>Du er blevet tildelt badgen "%badgename%"!</p> <p>Der er mere information om den på siden med %badgelink% badgeinformation.</p> <p>Du kan administrere og downloade badgen fra din {$a}-side.</p>';
$string['messagesubject'] = 'Tillykke! Du har lige optjent en badge!';
$string['method'] = 'Dette kriterie er færdiggjort når...';
$string['mingrade'] = 'Min. karakter påkrævet';
$string['month'] = 'Måned(er)';
$string['moredetails'] = 'Flere oplysninger';
$string['mybackpack'] = 'Mine rygsækindstillinger';
$string['mybadges'] = 'Mine badges';
$string['namewithlink'] = 'Navn med link';
$string['never'] = 'Aldrig';
$string['newbackpack'] = 'Tilføj en ny rygsæk';
$string['newbadge'] = 'Tilføj en ny badge';
$string['newimage'] = 'Nyt billede';
$string['noalignment'] = 'Denne badge har ingen eksterne færdigheder eller standarder specificeret.';
$string['noawards'] = 'Denne badge er endnu ikke optjent';
$string['nobackpack'] = 'Der er ingen rygsækservice forbundet med denne konto.<br />';
$string['nobackpackbadgessummary'] = 'Der er ingen badges i de samlinger du har valgt';
$string['nobackpackcollectionssummary'] = 'Ingen badge-samlinger er valgt.';
$string['nobackpacks'] = 'Der er ingen tilgængelig rygsæk';
$string['nobadges'] = 'Der er pt. ingen tilgængelige badges.';
$string['nocompetencies'] = 'Ingen kompetencer er valgt.';
$string['nocriteria'] = 'Der er endnu ikke opsat kriterier for denne badge.';
$string['noendorsement'] = 'Dette badge har ikke en godkendelse.';
$string['noexpiry'] = 'Denne badge har ingen udløbsdato.';
$string['nomatchingbadges'] = 'Der er ingen tilgængelige matchende badges, som brugere kan opnå.';
$string['noparamstoadd'] = 'Der er ingen ekstra parametre tilgængelige at føje til dette badgekrav.';
$string['norelated'] = 'Denne badge har ingen relaterede badges.';
$string['notacceptedrole'] = 'Din nuværende rolletildeling er ikke mellem de roller, der manuelt kan udstede denne badge.<br/>Vil du se hvilke brugere der har opnået denne badge, kan du besøge siden {$a}.';
$string['notconnected'] = 'Ikke forbundet';
$string['notealignment'] = 'Eksterne færdigheder eller standarder, som badgen er tilpasset, kan specificeres. Eventuelle eksterne færdigheder eller standarder vises på badgesiden.';
$string['noteendorsement'] = 'En godkendelse fra en tredjepart kan anvendes til at tilføje værdi til mærket. For eksempel kan et mærke udstedt af en lærer blive godkendt af skolen, eller et mærke udstedt af en lokal uddelende instans kan blive godkendt af den nationale uddelende instans.';
$string['noterelated'] = 'Badges med en forbindelse kan markeres som relateret. For eksempel kan badges med samme kriterier som er vist i forskellige sprog markeres som relateret. Alle relaterede badges vises på badge-siden.';
$string['nothingtoadd'] = 'Der er ingen tilgængelige kriterier at tilføje.';
$string['notification'] = 'Underret den der har oprettet badgen';
$string['notification_help'] = 'Denne indstilling styrer underretninger sendt til opretteren af en badge med oplysning om at badgen er blevet tildelt. Følgende valgmuligheder er tilgængelige:

* **ALDRIG** – Send ikke underretninger.
* **HVER GANG** – Send besked hver gang en badge er tildelt.
* **DAGLIGT** – Send besked en gang dagligt.
* **UGENTLIGT** – Send besked en gang om ugen.
* **MÅNEDLIG** – Send besked en gang om måneden.';
$string['notifydaily'] = 'Dagligt';
$string['notifyevery'] = 'Hver time';
$string['notifymonthly'] = 'Månedligt';
$string['notifyweekly'] = 'Ugentligt';
$string['numawards'] = 'Denne badge er tildelt a href="{$a->link}">{$a->count}</a> bruger(e).';
$string['numawardstat'] = 'Denne badge er tildelt {$a} bruger(e).';
$string['oauth2issuer'] = 'OAuth 2-servicer';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Anden navigation ...';
$string['overallcrit'] = 'af de valgte kriterier er fuldførte.';
$string['password_required'] = 'Adgangskoden må ikke være tom';
$string['potentialrecipients'] = 'Potentielle badgemodtagere';
$string['preferences'] = 'Badgeindstillinger';
$string['privacy:metadata:backpack'] = 'En registrering af brugerens rygsække';
$string['privacy:metadata:backpack:backpackuid'] = 'Den unikke identifikator for rygsækken';
$string['privacy:metadata:backpack:email'] = 'E-mail associeret med rygsækken';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Rygsækkens id';
$string['privacy:metadata:backpack:userid'] = 'Id på rygsækkens bruger';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2-oplysninger, når brugeren forbinder til en ekstern rygsæk';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2-tjeneste-ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Oplist omfanget af backpack connect';
$string['privacy:metadata:backpackoauth2:token'] = 'Backpack-forbindelsestoken';
$string['privacy:metadata:backpackoauth2:userid'] = 'Brugerens ID tilknyttet til rygsækken';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Brugerens ID blev ændret i forbindelse';
$string['privacy:metadata:badge'] = 'En samling badges';
$string['privacy:metadata:badge:timecreated'] = 'Hvornår badgen blev lavet';
$string['privacy:metadata:badge:timemodified'] = 'Hvornår badgen blev ændret';
$string['privacy:metadata:badge:usercreated'] = 'Id på badgens ophavsmand';
$string['privacy:metadata:badge:usermodified'] = 'Id på personen der ændrede badgen';
$string['privacy:metadata:criteriamet'] = 'En samling af kriterier, som er blevet opfyldt';
$string['privacy:metadata:criteriamet:datemet'] = 'Datoen hvor kriterierne blev opfyldt';
$string['privacy:metadata:criteriamet:userid'] = 'ID\'et for brugeren, der har opfyldt kriterierne';
$string['privacy:metadata:external:backpacks'] = 'Information delt, når brugere indsender deres badges til en ekstern rygsæk';
$string['privacy:metadata:external:backpacks:badge'] = 'Navnet på mærket';
$string['privacy:metadata:external:backpacks:description'] = 'Beskrivelsen af mærket';
$string['privacy:metadata:external:backpacks:image'] = 'Billedet af mærket';
$string['privacy:metadata:external:backpacks:issuer'] = 'Nogle oplysninger om udstederen';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle-URL\'en, hvor oplysningerne om det udstedte badge kan ses';
$string['privacy:metadata:issued'] = 'En registrering af tildelte badges';
$string['privacy:metadata:issued:dateexpire'] = 'Datoen for hvornår mærket udløber';
$string['privacy:metadata:issued:dateissued'] = 'Datoen for tildelingen';
$string['privacy:metadata:issued:userid'] = 'ID for brugeren der har fået tildelt en badge';
$string['privacy:metadata:manualaward'] = 'En fortegnelse over manuelle tildelinger';
$string['privacy:metadata:manualaward:datemet'] = 'Dato for tildeling af badgen';
$string['privacy:metadata:manualaward:issuerid'] = 'ID\'et for brugeren, der tildeler mærket';
$string['privacy:metadata:manualaward:issuerrole'] = 'Brugerens rolle i tildelingen af mærket';
$string['privacy:metadata:manualaward:recipientid'] = 'ID for den bruger, der manuelt har fået tildelt et badge';
$string['recipient'] = 'Modtager af badge';
$string['recipientdetails'] = 'Modtagerdata';
$string['recipientidentificationproblem'] = 'Kan ikke finde en modtager af denne badge mellem de nuværende brugere.';
$string['recipients'] = 'Badgemodtagere.';
$string['recipientvalidationproblem'] = 'Den aktuelle bruger kan ikke verificeres som modtager af denne badge.';
$string['relatedbages'] = 'Relaterede badges';
$string['relative'] = 'Relativ dato';
$string['requiredbadge'] = 'Mindst en badge skal tilføjes badgekriteriet.';
$string['requiredcohort'] = 'Mindst en brugergruppe skal tilføjes brugergruppekriteriet.';
$string['requiredcompetency'] = 'Mindst en kompetence skal tilføjes kompetencekriteriet.';
$string['requiredcourse'] = 'Mindst et kursus skal tilføjes kriterier for kursussæt.';
$string['reviewbadge'] = 'Ændringer i badgeadgang';
$string['reviewconfirm'] = '<p>Dette vil gøre din badge synlig for brugere og gøre det muligt for dem at gøre sig fortjent til den.</p> <p>Det er muligt at nogle brugere allerede opfylder kravene i badgens kriterier og vil få den tildelt umiddelbart efter du aktiverer den.</p> <p>Når en badge er tildelt <strong>låses</strong> den - bestemte indstillinger inklusiv kriterier og udløbsindstilling kan ikke længere ændres.</p> <p>Er du sikker på at du vil aktivere adgang til badgen "{$a}"?</p>';
$string['revoke'] = 'Tilbagekald badge';
$string['save'] = 'Gem';
$string['searchname'] = 'Søg efter navn';
$string['selectaward'] = 'Vælg den rolle du vil bruge til tildeling af denne badge:';
$string['selectgroup_end'] = 'Kun offentlige samlinger vises.  <a href="{$a}">Besøg din rygsæk</a> for at oprette flere offentlige samlinger.';
$string['selectgroup_start'] = 'Vælg samlinger fra din rygsæk til visning på dette site:';
$string['selecting'] = 'Med valgte badges...';
$string['setup'] = 'Opsæt forbindelse';
$string['sitebackpackdeleted'] = 'Webstedsrygsæk er slettet.';
$string['sitebackpacknotdeleted'] = 'Denne rygsæk kunne ikke slettes da den er webstedets standardrygsæk';
$string['sitebackpackwarning'] = 'Kunne ikke forbinde til rygsækken. <br/><br/>Tjek at indstillingen "Badge-udbyders mailadresse" er den rigtige mail til en konto på rygsækkens webside. <br/><br/>Tjek at "Badge-udbyders adgangskode" på siden <a href="{$a->url}">Rygsækindstillinger</a>, er den rigtige adgangskode til kontoen på rygsækkens webside.<br/><br/>Rygsækken returnerede: "{$a->warning}"';
$string['sitebadges'] = 'Site-badges';
$string['sitebadges_help'] = 'Sitebadges kan kun tildeles brugere for siterelaterede aktiviteter. Disse omfatter færdiggørelse af kurser eller dele af brugerprofiler. Sitebadges kan også tildeles manuelt af en bruger til en anden.

Badges for kursusrelaterede aktiviteter kan oprettes på kursusniveau. Kursusbadges kan findes under Kursusadministration > Badges.';
$string['sitebadgetitle'] = '{$a} webstedsbadge';
$string['status'] = 'Badgestatus';
$string['status_help'] = 'Status på en badge styrer dens \'opførsel\' i systemet:

* **TILGÆNGELIG** – Den kan optjenes af brugere. Så længe den er tilgængelig for brugerne, kan dens kriterier ikke ændres.

* ** IKKE TILGÆNGELIG** – Betyder at badgen ikke er tilgængelig for brugere og ikke kan blive optjent eller udstedt manuelt. Hvis ikke en sådan badge tidligere er tildelt, kan dens kriterier ændres.

Så snart en badge er udstedt til en bruger, bliver den **LÅST**. En låst badge kan stadig optjenes, men kriterierne kan ikke ændres. Hvis du skal modificere oplysninger eller kriterier på en låst badge, kan du tage en kopi og ændre den.

*Hvorfor låser vi badges?*

Vi vil sikre at brugerne opfylder ens kriterier for at optjene en badge. Det er pt. ikke muligt at tilbagekalde badges. Hvis vi altid tillod ændringer i badgekriterier, ville vi få brugere med samme badge men optjent på helt forskellige forudsætninger.';
$string['statusmessage_0'] = 'Denne badge er pt. ikke tilgængelig for brugere. Aktiver adgang til den hvis du ønsker at give brugere mulighed for at optjene den.';
$string['statusmessage_1'] = 'Denne badge er pt. tilgængelig for brugere. Deaktiver adgang til den hvis du lave ændringer.';
$string['statusmessage_2'] = 'Denne badge er pt. ikke tilgængelig for brugere og dens kriterier er låste. Aktiver adgang hvis du ønsker at give brugere mulighed for at optjene den.';
$string['statusmessage_3'] = 'Denne badge er pt. tilgængelig for brugere og dens kriterier er låste.';
$string['statusmessage_4'] = 'Denne badge er pt. arkiveret.';
$string['subject'] = 'Beskedemne';
$string['tagarea_badge'] = 'Mærker';
$string['tags'] = 'Tags';
$string['targetcode'] = 'Kode';
$string['targetcode_help'] = 'En unik strengidentifikator til henvisning til den eksterne færdighed eller standard inden for dens rammer.';
$string['targetdescription'] = 'Beskrivelse';
$string['targetdescription_help'] = 'Kort beskrivelse af den eksterne færdighed eller standard.';
$string['targetframework'] = 'Ramme';
$string['targetframework_help'] = 'Navn på den eksterne færdighed eller standard.';
$string['targetname'] = 'Navn';
$string['targetname_help'] = 'Den eksterne færdighed eller standard, som badgen er tilpasset.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Link til en side med beskrivelse af den eksterne færdighed eller standard. URL\'en skal starte med http:// eller https://.';
$string['testbackpack'] = 'Test rygsækken "{$a}"';
$string['testsettings'] = 'Testindstillingere';
$string['type'] = 'Type';
$string['userbadges'] = 'Brugerbadges';
$string['variablesubstitution'] = 'Variable erstatninger i beskeder.';
$string['variablesubstitution_help'] = 'I en badge-besked kan bestemte variable indsættes som emne og/eller i selve teksten sådan at de bliver erstattet af rigtige værdier når beskeden sendes. Variablene skal indsættes nøjagtig som vist herunder. Følgende variable kan bruges:
%badgename%: Vil blive erstattet med badgens fulde navn.
%username%: Vil blive erstattet med modtagerens fulde navn.
%badgelink%: Vil blive erstattet med den offentlige URL med information om den tildelte badge.';
$string['verifyemail'] = 'Bekræft e-mail';
$string['version'] = 'Version';
$string['version_help'] = 'Versionsfeltet kan bruges til at holde øje med badgens udvikling. Er det angivet, vises versionen på badgens side.';
$string['viewbadge'] = 'Vis udstedt badge';
$string['visible'] = 'Synlig';
$string['warnexpired'] = '(Badgen er udgået!)';
$string['year'] = 'År';
