<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'da', version '4.3'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'HUSKAT';
$string['activityisscheduledfordeletion'] = 'Sletter aktivitet...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" er ikke en gyldig værdi for alder.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" har flere eller færre end en kommaseparator.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" er ikke en gyldig værdi for land.';
$string['agedigitalconsentmapinvaliddefault'] = 'Standard (*) værdi mangler.';
$string['agelocationverificationdisabled'] = 'Verifikation af alder og placering deaktiveret';
$string['alreadyloggedin'] = 'Du er allerede logget ind som {$a}. Du er nødt til at logge ud før du kan logge ind som anden bruger.';
$string['authnotexisting'] = 'Godkendelses-plugin\'et eksisterer ikke';
$string['backupcontainexternal'] = 'Denne backupfil indeholder eksterne Moodle Network Hosts der ikke er konfigureret lokalt';
$string['backuptablefail'] = 'Backuptabeller kunne IKKE opsættes!';
$string['blockcannotconfig'] = 'Denne blok understøtter ikke global konfiguration';
$string['blockcannotinistantiate'] = 'Problem med instantiering af blokobjekt';
$string['blockcannotread'] = 'Kan ikke læse data for blockid = {$a}';
$string['blockdoesnotexist'] = 'Denne blok eksisterer ikke';
$string['blockdoesnotexistonpage'] = 'Denne blok (id= $a->instanceid}) findes ikke på denne side ({$a->url}).';
$string['blocknameconflict'] = 'Navne konflikt: block {$a->name} har samme titel som en eksisterende block:{$a->conflict}!';
$string['callbackrejectcomment'] = 'Tilbagekaldelse af kommentar afvist.';
$string['cannotaddcoursemodule'] = 'Kunne ikke tilføje et nyt kursusmodul';
$string['cannotaddcoursemoduletosection'] = 'Kunne ikke tilføje det nye kursusmodul til den sektion';
$string['cannotaddmodule'] = 'Modulet {$a} kunne ikke tilføjes modullisten!';
$string['cannotaddnewmodule'] = 'Kunne ikke tilføje et nyt modul af {$a}.';
$string['cannotaddrss'] = 'Du har ikke tilladelse til at tilføje rss-feeds';
$string['cannotaddthisblocktype'] = 'Du kan ikke tilføje en {$a} blok på denne side.';
$string['cannotassignrole'] = 'Kan ikke tilføje rolle på kurset';
$string['cannotassignrolehere'] = 'Du har ikke tilladelse til at tildele denne rolle (id = {$a->roleid}) i denne kontekst ({$a->context})';
$string['cannotassignselfasparent'] = 'Kan ikke tildele sig selv som overordnet';
$string['cannotcallscript'] = 'Du kan ikke kalde et script via denne metode';
$string['cannotcallusgetselecteduser'] = 'Du kan ikke kalde user_selector::get_selected_user hvis multi-valg er sand.';
$string['cannotcreatebackupdir'] = 'Kunne ikke oprette en backupmappe. Administrator er nødt til at ændre filrettighederne.';
$string['cannotcreatecategory'] = 'Kategorien blev ikke tilføjet';
$string['cannotcreatedboninstall'] = '<p>Kan ikke oprette databasen.</p> <p>Den specificerede database eksisterer ikke og brugeren har ikke tilladelse til at oprette den.</p> <p>Administrator bør verificere databasekonfigurationen.</p>';
$string['cannotcreategroup'] = 'Fejl ved oprettelse af gruppe';
$string['cannotcreatelangbase'] = 'Fejl: Kunne ikke oprette mappe til basissprog';
$string['cannotcreatelangdir'] = 'Kan ikke oprette sprogmappe';
$string['cannotcreateorfindstructs'] = 'Fejl ved at finde eller danne sektionsstrukturer for dette kursus';
$string['cannotcreatepopupwin'] = 'Udefineret element - kan ikke oprette et pop op-vindue.';
$string['cannotcreatesitedir'] = 'Kan ikke oprette en site-mappe. Administratoren må ændre filrettighederne.';
$string['cannotcreatetempdir'] = 'Kan ikke oprette temp-mappe';
$string['cannotcreateuploaddir'] = 'Kan ikke oprette en upload-mappe. Administratoren må ændre filrettighederne.';
$string['cannotcustomisefiltersblockuser'] = 'Du kan ikke tilpasse filterindstillinger i bruger- eller bloksammenhænge.';
$string['cannotdeletebackupids'] = 'Kunne ikke slette tidligere backup-id\'er.';
$string['cannotdeletecategorycourse'] = 'Kurset "{$a}" kunne ikke slettes.';
$string['cannotdeletecategoryquestions'] = 'Kunne ikke slette spørgsmål fra kategorien "{$a}"';
$string['cannotdeletecourse'] = 'Du har ikke tilladelse til at slette dette kursus';
$string['cannotdeletecustomfield'] = 'Fejl opstået ved sletning af skræddersyet felt-data';
$string['cannotdeletedir'] = 'Kan ikke slette ({$a})';
$string['cannotdeletefile'] = 'Kan ikke slette denne fil';
$string['cannotdeleterole'] = 'Kan ikke slettes fordi {$a}';
$string['cannotdeleterolewithid'] = 'Kan ikke slette rollen med ID {$a}';
$string['cannotdeletethisrole'] = 'Du kan ikke slette denne rolle da den bruges af systemet eller fordi det er den eneste rolle med administratorbeføjelser.';
$string['cannotdisableformat'] = 'Standard-formatet kan ikke deaktiveres.';
$string['cannotdownloadcomponents'] = 'Kan ikke downloade komponenter';
$string['cannotdownloadlanguageupdatelist'] = 'Kan ikke downloade listen med sprogpakker fra download.moodle.org';
$string['cannotdownloadzipfile'] = 'Kan ikke downloade zip-fil';
$string['cannoteditcomment'] = 'Denne kommentar er ikke din, du kan ikke redigere den!';
$string['cannoteditcommentexpired'] = 'Du kan ikke redigere her længere, tiden er udløbet!';
$string['cannoteditpostorblog'] = 'Du kan ikke oprette eller redigere blogs.';
$string['cannoteditsiteform'] = 'Du kan ikke redigere site-kurset ved brug af denne formular';
$string['cannotedituserpreferences'] = 'Kan ikke redigere brugerens indstillinger';
$string['cannotedityourprofile'] = 'Beklager, du kan ikke ændre din egen profil';
$string['cannotexecduringupgrade'] = 'Kan ikke udføres under opgradering';
$string['cannotfindcategory'] = 'Kan ikke finde kategoriposten i databasen efter id - {$a}';
$string['cannotfindcomponent'] = 'Kan ikke finde komponent';
$string['cannotfindcontext'] = 'Kunne ikke finde konteksten';
$string['cannotfindcourse'] = 'Kan ikke finde kursus';
$string['cannotfinddocs'] = 'Kan ikke finde "{$a}" dokumentationsfiler';
$string['cannotfindgradeitem'] = 'Kan ikke finde grade_item';
$string['cannotfindgroup'] = 'Kan ikke finde gruppe';
$string['cannotfindhelp'] = 'Kan ikke finde "{$a}" sproghjælpefiler';
$string['cannotfindinfo'] = 'Kan ikke finde information for: "{$a}"';
$string['cannotfindlang'] = 'Kan ikke finde sprogpakken "{$a}"!';
$string['cannotfindteacher'] = 'Kan ikke finde læreren';
$string['cannotfinduser'] = 'Kan ikke finde brugeren ved navn {$a}';
$string['cannotgeoplugin'] = 'Kan ikke forbinde til geoPlugin-serveren på https://www.geoplugin.com, tjek proxyindstillingerne eller  installer MaxMind GeoLite City-datafilen.';
$string['cannotgetblock'] = 'Kunne ikke hente blokke fra databasen';
$string['cannotgetcats'] = 'Kan ikke hente kategoripost';
$string['cannotgetdata'] = 'Kan ikke hente data';
$string['cannotgradeuser'] = 'Kan ikke bedømme denne bruger';
$string['cannothaveparentcate'] = 'Kursuskategorien kan ikke have en overliggende kategori!';
$string['cannotimport'] = 'Importfejl';
$string['cannotimportformat'] = 'Beklager, import af dette format er endnu ikke implementeret!';
$string['cannotimportgrade'] = 'Fejl ved karakterimport';
$string['cannotinsertgrade'] = 'Kan ikke indsætte karakteren uden kursus-id!';
$string['cannotinsertrate'] = 'Kunne ikke indsætte en ny vurdering ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Kunne ikke indsætte en ny post-id {$a}';
$string['cannotmailconfirm'] = 'Fejl ved fremsendelse af bekræftelsesmail til ændring af adgangskode';
$string['cannotmanualctrack'] = 'Aktiviteten understøtter ikke manuel registrering af gennemførelse';
$string['cannotmapfield'] = 'Tilknytningskollision - to felter knytter sig til samme karakterelement {$a}';
$string['cannotmarktopic'] = 'Kunne ikke bedømme det emne på dette kursus';
$string['cannotmigratedatacomments'] = 'Kan ikke flytte kommentarer i datamodulet';
$string['cannotmodulename'] = 'Kan ikke hente modulnavnet i opbyg navigation';
$string['cannotmoduletype'] = 'Kan ikke hente modultypen i opbyg navigation';
$string['cannotmovecategory'] = 'Kan ikke flytte kategori';
$string['cannotmovecourses'] = 'Kan ikke flytte kurserne fra den kategori de er i og ind i en anden.';
$string['cannotmoverolewithid'] = 'Kan ikke flytte rollen med id\'et {$a}';
$string['cannotopencsv'] = 'Kan ikke åbne CSV-fil';
$string['cannotopenfile'] = 'Kan ikke åbne filen ({$a})';
$string['cannotopenforwrit'] = 'Kan ikke åbne til skrivning: {$a}';
$string['cannotopentemplate'] = 'Kan ikke åbne skabelonfilen ({$a})';
$string['cannotopenzip'] = 'Kan ikke åbne zip-filen, formentlig grundet en zipudvidelsesfejl på 64bit OS';
$string['cannotoverridebaserole'] = 'Kan ikke ændre grundlæggende rolles beføjelser';
$string['cannotoverriderolehere'] = 'Du har ikke tilladelse til at oprette undtagelser til denne rolle (id = {$a->roleid}) i denne kontekst ({$a->context})';
$string['cannotreadfile'] = 'Kan ikke læse filen ({$a})';
$string['cannotreadtmpfile'] = 'Fejl ved læsning af midlertidig fil';
$string['cannotreaduploadfile'] = 'Kan ikke læse den uploadede fil';
$string['cannotremovefrommeta'] = 'Kunne ikke fjerne det valgte kursus fra dette metakursus!';
$string['cannotreprocessgrades'] = 'Kunne ikke genbehandle karakterer for denne aktivitet {$a}';
$string['cannotresetguestpwd'] = 'Du kan ikke ændre gæstekoden';
$string['cannotresetmail'] = 'Fejl ved nulstillling af adgangskode og fremsendelse af besked';
$string['cannotresetthisrole'] = 'Kan ikke nulstille denne rolle';
$string['cannotrestore'] = 'Der opstod en fejl og gendannelsen kan ikke færdiggøres!';
$string['cannotrestoreadminorcreator'] = 'Du skal være kursus- eller site-administrator for at kunne gendanne til et nyt kursus!';
$string['cannotrestoreadminoredit'] = 'Du skal være lærer eller administrator for at kunne gendanne til det valgte kursus!';
$string['cannotsaveagreement'] = 'Kunne ikke gemme dit samtykke';
$string['cannotsaveblock'] = 'Fejl ved lagring af blokkonfiguration';
$string['cannotsavecomment'] = 'Kan ikke gemme kommentaren';
$string['cannotsavedata'] = 'Kan ikke gemme data';
$string['cannotsavefile'] = 'Kan ikke gemme filen "{$a}"!';
$string['cannotsavemd5file'] = 'Kan ikke gemme md5-fil';
$string['cannotsavezipfile'] = 'Kan ikke gemme zip-fil';
$string['cannotservefile'] = 'Kan ikke ekspedere filen grundet et serverkonfigationsproblem.';
$string['cannotsetparentforcatoritem'] = 'Kan ikke sætte overliggende kategori eller kursuselement!';
$string['cannotsetpassword'] = 'Kunne ikke danne brugeradgangskode!';
$string['cannotsetprefgrade'] = 'Kunne ikke indstille præferenceaggregationsvisning til {$a} for denne karakterkategori';
$string['cannotsettheme'] = 'Kan ikke indstille tema!';
$string['cannotsetupblock'] = 'Blokke tabeller blev ikke ikke dannet korrekt!';
$string['cannotsetupcapformod'] = 'Kunne ikke opsætte beføjelser for {$a}';
$string['cannotsetupcapforplugin'] = 'Kunne ikke opsætte beføjelser for {$a}';
$string['cannotshowhidecoursesincategory'] = 'Kunne ikke vise/skjule kurserne i kategorien {$a}.';
$string['cannotsignup'] = 'Du kan ikke oprette en ny konto da du allerede er logget ind som {$a}.';
$string['cannotunassigncap'] = 'Kunne ikke annullere den forældede beføjelse {$a->cap} fra rollen {$a->role}';
$string['cannotunassignrolefrom'] = 'Kan ikke fratage brugeren rollen med id: {$a}';
$string['cannotunzipfile'] = 'Kan ikke pakke filen ud';
$string['cannotupdatemod'] = 'Kan ikke opdatere {$a}';
$string['cannotupdatepasswordonextauth'] = 'Fejl ved opdatering af adgangskode ved ekstern auth: {$a}. Se yderligere information i serverloggen.';
$string['cannotupdateprofile'] = 'Fejl ved opdatering af brugerpost';
$string['cannotupdaterecord'] = 'Kan ikke opdatere post-id {$a}';
$string['cannotupdaterss'] = 'Kan ikke opdatere RSS';
$string['cannotupdatesubcourse'] = 'Kunne ikke opdatere et underliggende kursus!';
$string['cannotupdateusermsgpref'] = 'Kan ikke opdatere indstillinger for brugerbeskeder';
$string['cannotupdateuseronexauth'] = 'Kan ikke opdatere brugerdata ved ekstern auth: ($a). Se serverlogs for yderligere oplysninger.';
$string['cannotuploadfile'] = 'Fejl under behandling af den uploadede fil';
$string['cannotuseadmin'] = 'Du skal være en admin bruger for at kunne tilgå denne side.';
$string['cannotuseadminadminorteacher'] = 'Du skal være en lærer eller admin bruger for at kunne bruge denne side.';
$string['cannotusepage'] = 'Kun lærere eller administratorer kan  bruge denne side.';
$string['cannotusepage2'] = 'Beklager, du må ikke bruge denne side';
$string['cannotviewcategory'] = 'Du har ikke tilladelse til at se denne kursusliste.';
$string['cannotviewprofile'] = 'Du kan ikke se denne brugers profil';
$string['cannotviewreport'] = 'Du må ikke se denne rapport';
$string['cannotwritefile'] = 'Kan ikke skrive til filen ({$a})';
$string['categoryerror'] = 'Kategori fejl';
$string['categoryidnumbertaken'] = 'ID-nummeret er allerede brugt til en anden kategori';
$string['categorynamerequired'] = 'Kategorinavn er obligatorisk';
$string['categorytoolong'] = 'Kategorinavnet er for langt';
$string['commentmisconf'] = 'Kommentar ID er fejlkonfigureret';
$string['componentisuptodate'] = 'Komponenten er opdateret';
$string['confirmationnotenabled'] = 'Brugerbekræftelse er ikke aktiveret på dette websted';
$string['confirmsesskeybad'] = 'Desværre, men din sessionsnøgle kunne ikke godkendes til denne handling. Denne sikkerhedskontrol forhindrer utilsigtet eller uautoriseret tilgang til vigtige funktioner for din profil. Er du sikker på at du virkelig vil udføre denne funktion?';
$string['contenttypenotfound'] = 'Indholdsbanktypen "{$a}" findes ikke eller kan ikke genkendes.';
$string['contentvisibilitynotfound'] = 'Indholdets synlighed med værdien "{$a}", eksisterer eller genkendes ikke.';
$string['couldnotassignrole'] = 'Der opstod en alvorlig ukendt fejl under forsøg på at tildele dig denne rolle';
$string['couldnotupdatenoexistinguser'] = 'Kan ikke opdatere brugeren - bruger eksisterer ikke';
$string['couldnotverifyagedigitalconsent'] = 'Der opstod en fejl under forsøg på at verificere den digitale lavalder.<br />Kontakt administrator';
$string['countriesphpempty'] = 'Fejl: Filen countries.php i sprogpakken {$a} er tom eller mangler.';
$string['coursedoesnotbelongtocategory'] = 'Dette kursus hører ikke til i denne kategori';
$string['courseformatnotfound'] = 'Kursusformatet "{$a}" eksisterer ikke eller genkendes ikke';
$string['coursegroupunknown'] = 'Kurset der hører sammen med gruppen {$a}, er ikke specificeret';
$string['courseidnotfound'] = 'Kursus-id\'et eksisterer ikke';
$string['courseidnumbertaken'] = 'Id-nummer bruges allerede til andet kursus ({$a})';
$string['coursemisconf'] = 'Kurset er ikke konfigureret korrekt';
$string['courserequestdisabled'] = 'Beklager, men kursusanmodninger er deaktiveret af administrator.';
$string['csvcolumnduplicates'] = 'Dublerede kolonner er slettet';
$string['csvemptyfile'] = 'CVS-filen er tom';
$string['csvfewcolumns'] = 'Der er ikke kolonner nok, kontroller separatorindstilling.';
$string['csvfileerror'] = 'Der er noget galt med formatet på denne CSV-fil. Tjek at antallet af feltnavne og kolonner matcher, og at separator og filkodning er korrekt. {$a}';
$string['csvinvalidcols'] = '<b>Ugyldig CSV-fil:</b> Første linje skal indeholde "Header Fields" og filen skal være at typen <br />"Expanded Fields/Kommasepareret"<br />eller<br /> "Expanded Fields with CAVV Result Code/Kommasepareret"';
$string['csvinvalidcolsnum'] = 'Ugyldig csv-fil - hver linje skal indeholde 49 eller 70 felter';
$string['csvloaderror'] = 'En fejl er opstået ved indlæsning af csv-filen: {$a}';
$string['csvnodata'] = 'Ugyldig CSV-fil - CSV-filen har feltnavne men ingen data.';
$string['csvweirdcolumns'] = 'Ugyldig format i CVS-filen - antallet af kolonner er ikke konstant!';
$string['dbconnectionfailed'] = '<p>Fejl: Forbindelse til databasen mislykkedes</p> <p>Det er muligt at databasen er overbelastet eller på anden vis ikke fungerer tilfredsstillende.</p> <p>Siteadministrator bør også tjekke at databaseoplysningerne er korrekt angivet i config.php </p>';
$string['dbdriverproblem'] = '<p>Fejl: database driver problem fundet</p>
<p>Site administrator bør verifificere server konfiguration </p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Alvorligt problem i databasesession fundet. <br /><br />Underret serveradministrator.';
$string['dbsessionhandlerproblem'] = 'Etablering af database session fejlede. Venligst underret server administrator.';
$string['dbsessionmysqlpacketsize'] = 'Alvorlig sessionsfejl fundet. Underret siteadministrator. Problemet skyldes formentlig en lav værdi i MySQL-indstillingen max_allowed_packet .';
$string['dbupdatefailed'] = 'Opdatering af databasen mislykkedes';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kan ikke ændres. Afhængighed fundet med {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql-udførelsesfejl';
$string['ddlfieldalreadyexists'] = 'Feltet "{$a}" eksisterer allerede';
$string['ddlfieldnotexist'] = 'Felt "{$a->fieldname}" eksisterer ikke i tabellen {$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabellen "{$a}" eksisterer allerede';
$string['ddltablenotexist'] = 'Tabellen "{$a}" eksisterer ikke';
$string['ddlunknownerror'] = 'Ukendt DDL-biblioteksfejl';
$string['ddlxmlfileerror'] = 'Fejl fundet i XML-databasefil';
$string['ddsequenceerror'] = 'Forkert defintion i tabellen "{$a}", der kan kun være en auto-kolonne og den skal være defineret som nøgle.';
$string['destinationcmnotexit'] = 'Destinationsmodulet på kurset eksisterer ikke';
$string['detectedbrokenplugin'] = 'Plugin\'et "{$a}" er defekt eller forældet. Kan ikke fortsætte, desværre.';
$string['dmlexceptiononinstall'] = '<p>En database fejl er opstået [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Fejl ved parsning af SQL-forespørgsel';
$string['dmlreadexception'] = 'Fejl ved læsning fra database.';
$string['dmltransactionexception'] = 'Database transaktionsfejl';
$string['dmlwriteexception'] = 'Fejl ved skrivning til database';
$string['dndmaxbytes'] = 'Filen er for stor. Den maksimalt tilladte størrelse er {$a->size}.';
$string['dndread'] = 'Fejl ved læsning af filen';
$string['dndunkownfile'] = 'Denne filtype understøttes ikke';
$string['dndupload'] = 'En ukendt fejl opstod under upload af filen';
$string['downgradedcore'] = 'FEJL: Koden du bruger er ÆLDRE end den version der har dannet disse databaser!';
$string['downloadedfilecheckfailed'] = 'Downloadet fil-tjek mislykkedes';
$string['duplicatefieldname'] = 'Duplikeret feltnavn "{$a}" fundet';
$string['duplicatenosupport'] = 'Aktiviteten "{$a->modname}" kunne ikke duplikeres da modulet {$a->modtype} ikke understøtter backup og gendannelse.';
$string['duplicateparaminsql'] = 'FEJL: forespørsglen indeholder dobbelt parameter navn';
$string['duplicaterolename'] = 'Der findes allerede en rolle med dette navn!';
$string['duplicateroleshortname'] = 'Der findes allerede en rolle med dette korte navn!!';
$string['duplicateusername'] = 'To ens brugernavne - posten skippes';
$string['editedpagenotfound'] = 'Systemet kunne ikke bestemme, hvilken side du er på. Opdater venligst siden og prøv igen.';
$string['emailfail'] = 'E-mailen kunne ikke sendes';
$string['encryption_decryptfailed'] = 'Dekryptering fejlede';
$string['encryption_encryptfailed'] = 'Kryptering fejlede';
$string['encryption_invalidkey'] = 'Ugyldig nøgle';
$string['encryption_keyalreadyexists'] = 'Nøglen eksisterer allerede';
$string['encryption_nokey'] = 'Nøglen blev ikke fundet';
$string['encryption_wrongmethod'] = 'Data matcher ikke en understøttet krypteringsmetode';
$string['enddatebeforestartdate'] = 'Kursets slutdato skal ligge senere end startdatoen!';
$string['error'] = 'Fejl opstået';
$string['error_question_answers_missing_in_db'] = 'Kunne ikke finde et svar der matcher "{$a->answer}" i question_answers databasetabellen. Denne fejl opstod under gendannelse af spørgsmålet med id {$a->filequestionid} i backup-filen, som er matchet til det eksisterende spørgsmål med id {$a->dbquestionid} i databasen.';
$string['errorcleaningdirectory'] = 'Fejl under oprettelse af mappen "{$a}"';
$string['errorcopyingfiles'] = 'Fejl under kopiering af filer';
$string['errorcreatingdirectory'] = 'Fejl ved oprettelse af mappen "{$a}"';
$string['errorcreatingfile'] = 'Fejl under oprettelse af filen "{$a}"';
$string['errorcreatingrole'] = 'Rollen kunne ikke oprettes';
$string['errorfetchingrssfeed'] = 'Fejl ved hentning af RSS-feed.';
$string['erroronline'] = 'Fejl på linjen {$a}';
$string['erroroutput'] = 'Fejloutput, deaktiverer derfor automatisk omdirigering.';
$string['errorparsingxml'] = 'Fejl ved parsing af XML: {$a->errorstring} på linje {$a->errorline}, tegn {$a->errorchar}';
$string['errorprocessingarchive'] = 'Fejl under behandling af arkivfil';
$string['errorreadingfile'] = 'Fejl under læsning af filen "{$a}"';
$string['errorsavingrequest'] = 'Der er opstået en fejl ved forsøg på at gemme din forespørgsel.';
$string['errorsettinguserpref'] = 'Fejl ved oprettelse af brugerindstilling.';
$string['errorunzippingfiles'] = 'Fejl under udpakning af filer';
$string['expiredkey'] = 'Udløbet nøgle';
$string['externalauthpassworderror'] = 'Ikke-tom adgangskode til ekstern godkendelse';
$string['externalfilenolocation'] = 'Ekstern fil mangler lokaliserings sti';
$string['failtoloadblocks'] = 'En eller flere blokke er registreret i databasen men de fejlede alle ved load!';
$string['fieldrequired'] = '"{$a}" er et påkrævet felt';
$string['fileexists'] = 'Filen eksisterer';
$string['filemismatch'] = 'Rod i filnavn. Filen "{$a->current}" skulle være {$a->file}';
$string['filenotfound'] = 'Desværre, den efterspurgte fil blev ikke fundet.';
$string['filenotreadable'] = 'Filen kan ikke læses';
$string['filterdoesnothavelocalconfig'] = 'Filteret {$a} tillader ikke lokal konfiguration.';
$string['filternotactive'] = 'Filter {$a} er ikke aktivt p.t.';
$string['filternotenabled'] = 'Filter ikke aktiveret!';
$string['filternotinstalled'] = 'Filteret {$a} er ikke installeret p.t.';
$string['forumblockingtoomanyposts'] = 'Du har overskredet grænsen for antal indlæg i forummet.';
$string['functionalityremoved'] = 'Du forsøger at få adgang til en funktion der er fjernet.';
$string['generalexceptionmessage'] = 'Undtagelse - {$a}';
$string['gradecantregrade'] = 'En fejl er opstået ved beregning af karakter: {$a}';
$string['gradepubdisable'] = 'Karakter publisering ikke aktiv';
$string['gradesneedregrading'] = 'Kursuskaraktererne skal genberegnes';
$string['groupalready'] = 'Bruger er allerede tilknyttet gruppe {$a}';
$string['groupexistforcourse'] = 'Gruppen "{$a}" eksisterer allerede på dette kursus';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Gruppen "{$a->name}" med id-nummeret "{$a->idnumber}" eksisterer allerede på dette kursus';
$string['grouphasidnumber'] = 'Gruppen "{$a}" har et id-nummer og kan være blevet dannet automatisk af et eksternt system. Du har ikke tilladelse til at fjerne denne gruppe.';
$string['groupinghasidnumber'] = 'Grupperingen "{$a}" har et id-nummer og kan være blevet dannet automatisk af et eksternt system. Du har ikke tilladelse til at fjerne denne gruppering';
$string['groupingnotaddederror'] = 'Grupperingen "{$a}" blev ikke tilføjet';
$string['groupnotaddederror'] = 'Gruppen "{$a}" blev ikke tilføjet';
$string['groupnotaddedtogroupingerror'] = 'Gruppe "{$a->groupname}" blev ikke tilføjet til grouping "{$a->groupingname}"';
$string['groupunknown'] = 'Gruppen {$a} er ikke tilknyttet det valgte kursus';
$string['groupusernotmember'] = 'Brugeren er ikke medlem af denne gruppe';
$string['guestcantaccessprofiles'] = 'Gæster kan ikke få adgang til brugerprofiler. Log ind med en brugerkonto for at fortsætte.';
$string['guestnocomment'] = 'Gæster har ikke tilladelse til at poste kommentarer!';
$string['guestnoeditprofile'] = 'Gæster kan ikke ændre deres profil';
$string['guestnoeditprofileother'] = 'Gæsteprofilen kan ikke ændres';
$string['guestnorate'] = 'Gæster har ikke tilladelse til at bedømme indlæg';
$string['guestsarenotallowed'] = 'Gæstebrugere har ikke tilladelse til dette';
$string['hackdetected'] = 'Hacker angreb opdaget';
$string['hashpoolproblem'] = 'Forkert filpoolindhold {$a}.';
$string['headersent'] = 'Headers er allerede sendt';
$string['idnumbertaken'] = 'ID-nummeret bruges allerede';
$string['idnumbertoolong'] = 'ID-nummeret er for langt';
$string['importformatnotimplement'] = 'Desværre er import af dette format endnu ikke implementeret!';
$string['incorrectext'] = 'Filen har en ugyldig filendelse';
$string['inplaceeditableerror'] = 'Fejl under kald af opdateringsprocessor';
$string['installproblem'] = 'Det er sædvanligvis ikke muligt at rette op på fejl som opstår under installation, det kan være nødvendigt at danne en ny database eller bruge en anden databasepræfiks hvis du vil prøve at installere igen';
$string['internalauthpassworderror'] = 'Password mangler eller ugyldigt password politik for intern godkendelse';
$string['invalidaccess'] = 'Denne side blev ikke indlæst korrekt';
$string['invalidaccessparameter'] = 'Ugyldigt adgangsparameter';
$string['invalidaction'] = 'Ugyldigt handlingsparameter';
$string['invalidactivityid'] = 'Ugyldigt aktivitets ID';
$string['invalidadminsettingname'] = 'Ugyldig admin indstilling ({$a})';
$string['invalidargorconf'] = 'Ingen gyldige argumenter angivet eller forkert server konfiguration';
$string['invalidarguments'] = 'Ingen gyldige argumenter angivet';
$string['invalidblockinstance'] = 'Ugyldig blokforekomst for: {$a}';
$string['invalidbulkenrolop'] = 'Ugyldig masse tilmeldings operation forespurgt';
$string['invalidcategory'] = 'Forkert kategori!';
$string['invalidcategoryid'] = 'Forkert kategori-id!';
$string['invalidcomment'] = 'Kommentar er forkert';
$string['invalidcommentarea'] = 'Forkert kommentarområde';
$string['invalidcommentid'] = 'Forkert kommentar-id';
$string['invalidcommentitemid'] = 'Ugyldig id på kommentarelement';
$string['invalidcommentparam'] = 'Ugyldige kommentar parametre';
$string['invalidcomponent'] = 'Ugyldig komponent navn';
$string['invalidconfirmdata'] = 'Ugyldig bekræftelses data';
$string['invalidcontentid'] = 'Ugyldig indholds-id';
$string['invalidcontext'] = 'Ugyldig kontekst';
$string['invalidcountrycode'] = 'Ugyldig landekode: {$a}';
$string['invalidcourse'] = 'Ugyldigt kursus';
$string['invalidcourseformat'] = 'Ugyldigt kursusformat';
$string['invalidcourseid'] = 'Du prøver at benytte et ugyldigt id for kurset ({$a})';
$string['invalidcourselevel'] = 'Ugyldig kontekst niveau';
$string['invalidcoursemodule'] = 'Ugyldigt kursusmodul-id';
$string['invalidcoursemoduleid'] = 'Ugyldigt kursusmodul-ID: {$a}';
$string['invalidcoursenameshort'] = 'Kursets korte navn er ugyldigt';
$string['invaliddata'] = 'De afleverede data er ugyldige';
$string['invaliddatarootpermissions'] = 'Der er fundet ugyldige tilladelser under forsøg på at oprette en mappe. Aktiver fejlfinding for at få flere informationer.';
$string['invaliddevicetype'] = 'Ugyldig enhedstype';
$string['invalidelementid'] = 'Forkert element-id!';
$string['invalidentry'] = 'Dette er ikke en gyldig indtastninig!';
$string['invalidevent'] = 'Ugyldig begivenhed';
$string['invalidfieldname'] = '"{$a}" er ikke et godkendt feltnavn';
$string['invalidfiletype'] = '"{$a}" er ikke en gyldig filtype';
$string['invalidformatpara'] = 'Forkert format til valg-parameter';
$string['invalidformdata'] = 'Forkert formulardata';
$string['invalidfunction'] = 'Forkert funktion';
$string['invalidgradeitemid'] = 'Forkert karakterelement-id';
$string['invalidgroupid'] = 'Forkert gruppe-id angivet';
$string['invalidipformat'] = 'Ugyldigt format på IP-adresse';
$string['invaliditemid'] = 'Forkert item-id';
$string['invalidkey'] = 'Forkert nøgle';
$string['invalidlanguagecode'] = 'Ugyldig sprogkode: {$a}';
$string['invalidlegacy'] = 'Fejlagtig legacy rolledefinition til typen: {$a}';
$string['invalidmd5'] = 'Tjekvariablen var forkert - prøv igen';
$string['invalidmode'] = 'Ugyldig tilstand ({$a})';
$string['invalidmodule'] = 'Ugyldigt modul';
$string['invalidmoduleid'] = 'Ugyldigt modul ID: {$a}';
$string['invalidmodulename'] = 'Ugyldigt modul navn: {$a}';
$string['invalidnum'] = 'Ugyldig numerisk værdi';
$string['invalidnumkey'] = 'Arrayet $conditions må ikke indeholde numeriske nøgler. Venligst ret koden!';
$string['invalidoutcome'] = 'Forkert id på slutresultat';
$string['invalidpagesize'] = 'Ugyldig sidestørrelse';
$string['invalidpasswordpolicy'] = 'Ugyldig kodepolitik';
$string['invalidpaymentmethod'] = 'Forkert betalingsmetode {$a}';
$string['invalidpersistenterror'] = 'Fejl: {$a}';
$string['invalidqueryparam'] = 'FEJL: Forkert antal forespørgselsparametre. Forventet  {$a->expected}, fik {$a->actual}.';
$string['invalidratingarea'] = 'Ugyldigt valideringsområde';
$string['invalidrecord'] = 'Kan ikke finde dataposten i databasetabellen {$a}.';
$string['invalidrecordunknown'] = 'Kan ikke finde dataposten i databasen.';
$string['invalidrequest'] = 'Ugyldig forespørgsel';
$string['invalidrole'] = 'Ugyldig rolle';
$string['invalidroleid'] = 'Ugyldig rolle-ID';
$string['invalidscaleid'] = 'Forkert skala-id';
$string['invalidsection'] = 'Posten med kursusmodul indeholder en ugyldig sektion';
$string['invalidsesskey'] = 'Din session ser ud til at være udløbet. Log ind igen.';
$string['invalidshortname'] = 'Kursets korte navn er ugyldigt';
$string['invalidsourcefield'] = 'Kladdens kildefelt er ugyldigt';
$string['invalidstatedetected'] = 'Noget er gået galt: {$a}. Dette bør normalt ikke ske.';
$string['invalidurl'] = 'Ugyldig URL';
$string['invaliduser'] = 'Ugyldig bruger';
$string['invaliduserdata'] = 'Ugyldig brugerdata: {$a}';
$string['invaliduserfield'] = 'Ugyldigt brugerfelt: {$a}';
$string['invaliduserid'] = 'Ugyldigt bruger-id.';
$string['invalidusername'] = 'Det angivne brugernavn indeholder ugyldige tegn';
$string['invalidusernameblank'] = 'Brugernavnet kan ikke være tomt';
$string['invalidxmlfile'] = '"{$a}" er ikke en gyldig xml-fil';
$string['iplookupfailed'] = 'Kan ikke finde geo-information om denne IP {$a}';
$string['iplookupprivate'] = 'Kan ikke vise opslag på private IP-adresser';
$string['ipmismatch'] = 'Rod i klient-IP-adresser';
$string['listcantmovedown'] = 'Kunne ikke flytte emnet ned, da det er det sidste af dens slags';
$string['listcantmoveleft'] = 'Kunne ikke flytte emnet til venstre da det ikke tilhører et overordnet emne';
$string['listcantmoveright'] = 'Kunne ikke flytte emnet til højre da det ikke kan underordnes et overliggende emne. Flyt det til et andet overliggende emne og herefter flyt det til højre.';
$string['listcantmoveup'] = 'Kunne ikke flytte emnet op, da det er det første af dens slags';
$string['listnochildren'] = 'Ingen underliggende emner fundet';
$string['listnoitem'] = 'Ingen emner fundet';
$string['listnopeers'] = 'Ingen overliggende emner fundet';
$string['listupdatefail'] = 'DB-operation mislykkedes ved redigering af listehierakiet';
$string['logfilenotavailable'] = 'Logs er ikke tilgængelige';
$string['loginasnoenrol'] = 'Du kan ikke bruge tilmeld eller frameld i en "log ind som"-session';
$string['loginasonecourse'] = 'Du kan ikke komme ind på dette kursus.<br />Du skal afslutte din "Log ind som"-session inden du kan komme ind på et andet kursus.';
$string['maxareabytes'] = 'Filen er større end den plads der er tilgængelig i dette område';
$string['maxbytesfile'] = 'Filen {$a->file} er for stor. Maksimal upload-størrelse er {$a->size}.';
$string['maxdraftitemids'] = 'Dine filuploads er midlertidigt begrænset, efter du har uploadet et stort antal filer. Vent venligst og prøv igen.';
$string['messageundeliveredbynotificationsettings'] = 'Beskeden kunne ikke sendes, fordi personlige beskeder mellem brugere (i Indstillinger for notifikationer) er deaktiveret af en administrator.';
$string['messagingdisable'] = 'Notifikationer er deaktiveret';
$string['mimetexisnotexist'] = 'Dit system er ikke konfigureret til at kunne køre mimeTeX. Du skal anskaffe C-kilden fra <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, kompilere den og gemme exe-filen i din mappe moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Brugerdefineret mimetex er ikke eksekverbar!';
$string['missing_moodle_backup_xml_file'] = 'Backup\'en mangler XML-fil: {$a}';
$string['missingcategoryrole'] = 'Kunne ikke tildele rolle til bruger: mangler rolle for kategori.';
$string['missingfield'] = 'Feltet "{$a}" mangler';
$string['missingkeyinsql'] = 'FEJL: Mangler parameteret "{$a}" i forespørgslen';
$string['missingparam'] = 'Det obligatoriske parameter ({$a}) manglede';
$string['missingparameter'] = 'Parameter mangler';
$string['missingrequiredfield'] = 'Der mangler nogle obligatoriske felter';
$string['missinguseranditemid'] = 'Manglende brugerid og itemid';
$string['missingvarname'] = 'Påkrævet variabel navn mangler!';
$string['mixedtypesqlparam'] = 'FEJL: Blandede type parametre på SQL-query!!';
$string['mnetdisable'] = 'MNET er deaktiveret';
$string['mnetlocal'] = 'Eksterne MNet-brugere kan ikke logge ind lokalt';
$string['moduledisable'] = 'Dette modul ({$a}) er blevet deaktiveret på dette kursus';
$string['moduledoesnotexist'] = 'Dette modul eksisterer ikke';
$string['moduleinstancedoesnotexist'] = 'Forekomsten af dette modul findes ikke.';
$string['modulemissingcode'] = 'Modulet {$a} mangler den kode, der skal udføre denne funktion';
$string['moodlenet:invalidshareformat'] = 'Forkert MoodleNet-delingsformat';
$string['moodlenet:invalidsharestatus'] = 'Forkert MoodleNet-delingsstatus';
$string['moodlenet:invalidsharetype'] = 'Ugyldig MoodleNet-delingskategori';
$string['moodlenet:usernotconfigured'] = 'Du har ikke tilladelse til at dele indhold på MoodleNet, eller din konto er forkert konfigureret.';
$string['movecatcontentstoroot'] = 'Det er ikke tilladt at flytte kategoriindhold til root. Du skal flytte indholdet til en eksisterende kategori!';
$string['movecatcontentstoselected'] = 'Noget af kategoriindholdet kan ikke flyttes til den valgte kategori.';
$string['movecategorynotpossible'] = 'Du kan ikke flytte kategorien "{$a}" til den valgte kategori.';
$string['movecategoryownparent'] = 'Du kan ikke gøre kategorien "{$a}" til sin egen overordnede kategori.';
$string['movecategoryparentconflict'] = 'Du kan ikke gøre kategorien "{$a}" til en underkategori til en af sine egne underkategorier.';
$string['mssqlrcsmodemissing'] = 'Databasen bruger ikke den forventede READ_COMMITTED_SNAPSHOT-tilstand, hvilket kan føre til forkerte resultater, især under scenarier med høj samtidighed. Aktiver den venligst for korrekt funktion. For yderligere information, se dokumentationen <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Der er fundet flere poster, kun en post var forventet.';
$string['multiplerestorenotallow'] = 'Flere samtidige gendannelses er ikke tilladt!';
$string['mustbeloggedin'] = 'Du skal være logget ind for at kunne udføre dette';
$string['mustbeteacher'] = 'Du skal være lærer for at se denne side';
$string['myisamproblem'] = 'Databasetabellerne bruger databasemaskinen MyISAM, det anbefales at bruge en ACID-kompatibel maskine med understøttelse af fuld transaktion såsom InnoDB.';
$string['needcopy'] = 'Du skal kopiere noget først!';
$string['needcoursecategroyid'] = 'Du skal angive enten kursus-id eller kategori';
$string['needphpext'] = 'Du skal tilføje {$a} understøttelse til din PHP installation';
$string['noadmins'] = 'Ingen administratorer!';
$string['noblocks'] = 'Ingen blokke blev fundet!';
$string['nocapabilitytousethisservice'] = 'Brugeren har ikke den beføjelse der kræves, for at kunne bruge denne service';
$string['nocategorydelete'] = 'Kategorien "{$a}" kan ikke slettes!';
$string['nocontext'] = 'Desværre, det kursus er ikke en gyldig kontekst';
$string['nodata'] = 'Ingen data';
$string['noexistingcategory'] = 'Ingen eksisterende kategori';
$string['nofile'] = 'Fil ikke angivet';
$string['nofiltersenabled'] = 'Ingen filtre er aktiveret.';
$string['nofolder'] = 'Den efterspurgte mappe eksisterer ikke';
$string['noformdesc'] = 'Ingen formslib-beskrivelsesfil fundet for denne aktivitet.';
$string['noguest'] = 'Ingen gæster her!';
$string['noinstances'] = 'Der er ingen {$a} på dette kursus!';
$string['nologinas'] = 'Du må ikke logge ind som den bruger';
$string['nonmeaningfulcontent'] = 'Intet meningsfuldt indhold';
$string['noparticipants'] = 'Ingen deltagere fundet på dette kursus';
$string['noparticipatorycms'] = 'Desværre, men du deltager ikke i nogen kursusmoduler du kan rapportere til.';
$string['nopermissions'] = 'Beklager, men dette ({$a}) har du aktuelt ikke tilladelse til.';
$string['nopermissiontoaccesspage'] = 'Du har ikke rettigheder til at tilgå denne side';
$string['nopermissiontocomment'] = 'Du kan ikke tilføje kommentarer';
$string['nopermissiontodelentry'] = 'Du kan ikke slette denne kommentar!';
$string['nopermissiontoeditcomment'] = 'Du kan ikke redigere andres kommentarer!';
$string['nopermissiontohide'] = 'Ingen tilladelser at skjule!';
$string['nopermissiontoimportact'] = 'Du har ikke de påkrævede tilladelser til at kunne importere aktiviteter på dette kursus';
$string['nopermissiontolock'] = 'Mangler tilladelse til at kunne låse!';
$string['nopermissiontomanagegroup'] = 'Du har ikke de påkrævede tilladelser til at administrere grupper';
$string['nopermissiontorate'] = 'Vurdering af elementer er ikke tilladt!';
$string['nopermissiontoshow'] = 'Mangler tilladelse til at kunne se dette!';
$string['nopermissiontounlock'] = 'Mangler tilladelse til at kunne låse op';
$string['nopermissiontoupdatecalendar'] = 'Beklager, men du har ikke tilladelse til opdatere en begivenhed i kalenderen.';
$string['nopermissiontoviewcalendar'] = 'Beklager, men du har ikke tilladelse til at se kalenderbegivenheden.';
$string['nopermissiontoviewgrades'] = 'Kan ikke se karakterer.';
$string['nopermissiontoviewletergrade'] = 'Mangler tilladelse til at kunne se karakterer af typen bogstav';
$string['nopermissiontoviewpage'] = 'Du har ikke ret til at se denne side';
$string['nosite'] = 'Kan ikke finde et øverstliggende kursus!';
$string['nositeid'] = 'Ingen site-id';
$string['nostartdatenoenddate'] = 'En slutdato for et kursus kræver at der også er angivet en startdato.';
$string['nostatstodisplay'] = 'Beklager, der er ingen tilgængelige data der kan vises.';
$string['notallowedtoupdateprefremotely'] = 'Du har ikke tilladelse til at fjernopdatere denne brugerindstilling';
$string['notavailable'] = 'Dette er p.t. ikke tilgængeligt';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Du er ikke medlem af denne kursusgruppe';
$string['notownerofkey'] = 'Du er ikke ejer af denne nøgle';
$string['nousers'] = 'Ingen sådan bruger fundet!';
$string['oauth1accesstoken'] = 'OAuth 1.0-fejl: Vi modtog ikke adgangstokenet.';
$string['oauth1requesttoken'] = 'OAuth 1.0-fejl: Vi modtog ikke anmodningstokenet - tjenesteudbyderen kan midlertidigt være nede.';
$string['oauth2refreshtokenerror'] = 'Kunne ikke opdatere OAuth 2-token. HTTP-status for fjernendepunkt: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Kunne ikke opdatere OAuth 2-token for en eller flere udstedere. Se opgaveoutput for detaljer.';
$string['oauth2upgradetokenerror'] = 'Kunne ikke opgradere OAuth 2-token. HTTP-status for fjernendpoint: {$a}';
$string['onlyadmins'] = 'Dette kan kun administratorer gøre.';
$string['onlyeditingteachers'] = 'Kun lærere med tilladelse til at redigere kurser, kan gøre det';
$string['onlyeditown'] = 'Du kan kun ændre din egen information';
$string['opensslsealerror'] = 'OpenSSL kunne ikke forsegle data';
$string['opensslsignerror'] = 'OpenSSL kunne ikke signere data';
$string['orderidnotfound'] = 'Ordre ID {$a} ikke fundet';
$string['pagenotexist'] = '<p>Der opstod en uventet fejl under forsøg på at vise en side der ikke eksisterer:</p>{$a}';
$string['pagenotexisttitle'] = '404 Fejl: Filen blev ikke fundet';
$string['passwordexceeded'] = 'Adgangskoden kan ikke være længere end {$a} tegn.';
$string['pathdoesnotstartslash'] = 'Ingen gyldige argumenter angive, sti starter ikke med en slash!';
$string['pleasereport'] = 'Hvis du har tid, må du meget gerne lade os vide hvad du forsøgte at gøre da fejlen opstod:';
$string['pluginnotexist'] = '{$a}-plugin eksisterer ikke.';
$string['pluginrequirementsnotmet'] = 'Plugin\'et "{$a->pluginname}" ({$a->pluginversion}) kunne ikke installeres. Det kræver en nyere version af Moodle (den nuværende version er {$a->currentmoodle}, og det kræver {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Pluginet "{$a->pluginname}" {$a->pluginversion} understøtter ikke denne version af Moodle {$a->moodleversion}. Søg efter plugininfo for at finde understøttede versioner.';
$string['prefixcannotbeempty'] = '<p>Fejl: database tabel prefix må ikke være blank ({$a})</p>
<p>Site administratoren skal løse dette problem.</p>';
$string['prefixtoolong'] = '<p>Fejl: database tabel prefix er for lang ({$a->dbfamily})</p>
<p>Site administratoren skal løse dette problem. Maks. længde for tabel prefixerne i {$a->dbfamily} er {$a->maxlength}karakterer. </p>';
$string['privatefilesupload'] = 'Det understøttes ikke længere at uploade direkte til brugernes private fil-område. Upload til et kladde-område og flyt herefter filerne med core_user::add_user_private_files';
$string['processingstops'] = 'Behandlingen stopper her. Efterfølgende poster ignoreres.';
$string['protected_cc_not_supported'] = 'Beskyttede Commen Cartridges understøttes ikke.';
$string['querystringcannotbeempty'] = 'Forespørgsels-strengen må ikke være tom';
$string['redirecterrordetected'] = 'Ikke understøttet omdirigering opdaget, kørsel af script afsluttet';
$string['refoundto'] = 'Kan refunderes til {$a}';
$string['refoundtoorigi'] = 'Refunderet til oprindeligt beløb: {$a}';
$string['registrationdisabled'] = 'Registrering er deaktiveret på dette websted';
$string['remotedownloaderror'] = '<p>Download af komponent til din server fejlede. Verificer venligst proxy-indstillilngerne; udvidelsen PHP cURL  anbefales kraftigt. </p> <p>Du må downloade filen <a href="{$a->url}">{$a->url}</a> manuelt, kopier den til "{$a->dest}" på din server og udpak den der.</p>';
$string['remotedownloadnotallowed'] = 'Download af komponenter til din server er ikke tilladt ("allow_url_fopen" er deaktiveret).<br /><br />Du må downloade filen <a href="{$a->url}">{$a->url}</a> manuelt, kopiere den til "{$a->dest}" til din server og pakke den ud der.';
$string['reportnotavailable'] = 'Denne type rapport er kun tilgængelig for site-kurset';
$string['requirecorrectaccess'] = 'Ugyldig URL eller port';
$string['requireloginerror'] = 'Kursus eller aktivitet ikke tilgængelig.';
$string['restore_path_element_missingmethod'] = 'Gendannelsesmetoden {$a} mangler. Den skal defineres af en udvikler.';
$string['restore_path_element_noobject'] = 'Gendan objekt {$a} er ikke et object.';
$string['restorechecksumfailed'] = 'Et problem er opstået med gendannelsesinformationen gemt i din session. Tjek din PHP-hukommelse/DB-pakkestørrelses grænse. Gendannelsen er afbrudt.';
$string['restrictedcontextexception'] = 'Beklager, kørsel af den eksterne funktion overtræder kontekstens begrænsning.';
$string['restricteduser'] = 'Desværre, men det er din nuværende profil "{$a}"  forhindret i at gøre';
$string['reverseproxyabused'] = 'Reverse proxy aktiveret, så serveren kan ikke tilgås direkte, beklager.<br />Kontakt serverens administrator.';
$string['rpcerror'] = 'Hovsa! Kommunikationen med MNET er fejlet. Her er fejbeskeden som du kan videregive til administrator: {$a}';
$string['scheduledbackupsdisabled'] = 'Planlagte backups er deaktiveret af server-administrator';
$string['secretalreadyused'] = 'Linket til skift af adgangskode er allerede brugt, koden blev ikke ændret.';
$string['sectionnotexist'] = 'Denne sektion eksisterer ikke';
$string['sendmessage'] = 'Send besked';
$string['sendmessagesent'] = 'Tak for din feedback om:<br>{$a}';
$string['serverconnection'] = 'Fejl ved forbindelse til server';
$string['servicedonotexist'] = 'Servicen findes ikke';
$string['sessioncannotobtainlock'] = '<p>Kan ikke opnå lås for sessions-id {$a->id} inden for {$a->acquiretimeout}.</p>
<p>Det er sandsynligt, at en anden side ({$a->whohaslock}) stadig kører i en anden browserfane, eller at den ikke frigav låsen på grund af en fejl.</p>
<p>Du kan vente til sessionens låsetidsfrist ({$a->lockexpire}) eller genstarte din browsersession. Hvis fejlen fortsætter, bedes du underrette serveradministratoren.</p>';
$string['sessioncookiesdisable'] = 'Forkert brug af require_key_login() - session-cookies skal være deaktiveret!';
$string['sessiondiskfull'] = 'Sessionspartitionen er fuld. Det er ikke muligt at logge ind på nuværende tidspunkt. Underret serveradministrator.';
$string['sessionerroruser'] = 'Din session er udløbet. Log ind igen.';
$string['sessionerroruser2'] = 'Der er opstået en serverfejl der påvirker dit login. Log ind igen eller genstart din browser.';
$string['sessionexpired'] = 'Sessionen er udløbet';
$string['sessionhandlerproblem'] = 'Sessionshåndteringen er ikke konfigureret korrekt';
$string['sessionipnomatch'] = 'Desværre, dit IP-nummer ser ud til at være ændret siden du loggede ind. Denne sikkerhedsfunktion bør beskytte mod at andre overtager din identitet på sitet mens du er logget på. Brugere bør normalt ikke få denne fejl. Hvis du ikke er klar over hvad det skyldes så prøv at kontakte sitets administrator.';
$string['sessionipnomatch2'] = '<p>Din IP-adresse synes at have ændret sig siden du loggede ind. Denne sikkerhedsfunktion skal forhindre hackere i at stjæle din identitet mens du er logget ind på dette site. Du kan få denne fejl hvis du bruger et trådløst netværk eller hvis du roamer mellem forskellige netværk. Spørg siteadministrator om hjælp. </p> <p>Hvis du vil fortsætte så tryk på F5 for at genindlæse siden.</p>';
$string['sessionwaiterr'] = 'Timed out under afventning af sessionslås.<br />Vent til din nuværende forespørgsel er færdig og prøv igen senere.';
$string['shortnametaken'] = 'Det korte kursusnavn er allerede brugt til et andet kursus ({$a})';
$string['sitepolicynotagreed'] = 'Webstedets politik er ikke accepteret: <a href="{$a}">Klik her for at se vores politik.</a>';
$string['socksnotsupported'] = 'SOCKS5 proxy supporteres ikke i PHP4';
$string['spellcheckernotconf'] = 'Stavekontrol ikke konfigureret';
$string['sslonlyaccess'] = 'Af sikkerhedsmæssige årsager er kun krypterede forbindelser tilladt, beklager.';
$string['statscatchupmode'] = 'Statistikken er pt. i "catchup mode". Indtil nu er {$a->daysdone} dag(e) behandlet og {$a->dayspending} venter på at blive det. Tjek snart igen!';
$string['statsdisable'] = 'Statistik er ikke aktiveret';
$string['statsnodata'] = 'Der er ikke data tilgængelige for den kombination af kursus og tidsperiode';
$string['storedfilecannotcreatefile'] = 'Kan ikke oprette lokal "pool-fil", tjek rettigheder i dataroot og tilgængelig diskplads.';
$string['storedfilecannotcreatefiledirs'] = 'Kan ikke oprette lokale fil-pool-mapper, tjek rettigheder i dataroot.';
$string['storedfilecannotread'] = 'Kan ikke læse filen. Enten findes filen ikke eller også er der et rettighedsproblem';
$string['storedfilecannotreadfile'] = 'Kan ikke læse filen "{$a}". Enten eksisterer den ikke eller der er ikke adgangstilladelse til den.';
$string['storedfilenotcreated'] = 'Kan ikke oprette filen "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Ukendt undtagelse realteret til lokale filer ({$a})';
$string['tagdisabled'] = 'Tags er deaktiveret!';
$string['tagnotfound'] = 'Tags blev ikke fundet i databasen';
$string['targetdatabasenotempty'] = 'Destinationsdatabasen er ikke tom. Overførsel afbrudt af sikkerhedsmæssige årsager.';
$string['textconditionsnotallowed'] = 'Sammenligninger af betingelser for tekstkolonner er ikke tilladt. Brug venligst sql_compare_text() i din forespørgsel.';
$string['themenotinstall'] = 'Dette tema er ikke installeret!';
$string['tokengenerationfailed'] = 'Kan ikke generere en ny token.';
$string['transactionvoid'] = 'Transaktionen kan ikke annulleres da den allerede er annulleret.';
$string['unenrolerror'] = 'En fejl er opstået ved af-tilmelding af denne person';
$string['unicodeupgradeerror'] = 'Beklager, men din database er ikke i Unicode allerede, og denne version af Moodle kan ikke migrere din database til Unicode. Opgrader til Moodle 1.7.x først og udfør migrationen til Unicode fra Adminsiden. Derefter skulle du kunne migrere til Moodle {$a}';
$string['unknowaction'] = 'Ukendt handling!';
$string['unknowcategory'] = 'Ukendt kategori!';
$string['unknowcontext'] = 'Dette er en ukendt kontekst ({$a}) i get_child_contexts!';
$string['unknowformat'] = 'Ukendt format ({$a})';
$string['unknownbackupexporterror'] = 'Ukendt fejl er opstået under forberedelse til import';
$string['unknownblockregion'] = 'Blokområdet "{$a}" genkendes ikke på denne side.';
$string['unknowncategory'] = 'Ukendt kategori med kategori-ID-nummer "{$a}"';
$string['unknowncontext'] = 'Dette er en ukendt kontekst.';
$string['unknowncourse'] = 'Ukendt kursus med navnet "{$a}"';
$string['unknowncourseidnumber'] = 'Ukendt kursus-id "{$a}"';
$string['unknowncourserequest'] = 'Ukendt kursusanmodning';
$string['unknowncoursesection'] = 'Ukendt kursussektion på kurset "{$a}"';
$string['unknownevent'] = 'Ukendt hændelse';
$string['unknownfiletype'] = 'Fejl, ukendt filtertype';
$string['unknowngroup'] = 'Ukendt gruppe "{$a}"';
$string['unknownhelp'] = 'Ukendt hjælpe emne {$a}';
$string['unknownjsinrequirejs'] = 'Kan ikke finde JavaScript-biblioteket "{$a}"';
$string['unknownmodulename'] = '';
$string['unknownrole'] = 'Ukendt rolle "{$a}"';
$string['unknownsortcolumn'] = 'Ukendt sorteringskolonne {$a}';
$string['unknownuseraction'] = 'Beklager, jeg forstår ikke denne brugerhandling';
$string['unknownuserselector'] = 'Ukendt brugervælger';
$string['unknoworder'] = 'Ukendt sorteringsrækkefølge';
$string['unknowparamtype'] = 'Ukendt type parameter: {$a}';
$string['unknowquestiontype'] = 'Ikke understøttet type spørgsmål {$a}';
$string['unknowuploadaction'] = 'Fejl: Ukendt uploadhandling ({$a})';
$string['unspecifycourseid'] = 'Du skal angive kursus-id, kort navn eller id-nummer';
$string['unsupportedevent'] = 'Ikke understøttet type begivenhed';
$string['unsupportedstate'] = 'Ikke understøttet gennemførelsesstatus';
$string['unsupportedwebserver'] = 'Web server software {{$a}} understøttes desværre ikke.';
$string['upgraderequires19'] = 'Fejl: En ny Moodleversion blev installeret på serveren, desværre er opgradering fra den tidligere version ikke understøttet. <br />Opgrader først til seneste 1.9.x-version. Du kan også returnere til den tidligere version ved at geninstallere de originale filer.';
$string['upgraderunning'] = 'Sitet er under opgradering. Prøv igen senere.';
$string['urlnotdefinerss'] = 'Der er ikke opgivet en URL til RSS-feed';
$string['useradmineditadmin'] = 'Kun administratorer har tilladelse til at ændre andre administratorkonti';
$string['useradminodelete'] = 'Administratorkonti kan ikke slettes';
$string['userautherror'] = 'Ukendt godkendelses-plugin';
$string['userauthunsupported'] = 'Auth plugin understøttes ikke her';
$string['useremailduplicate'] = 'Duplikeret adresse';
$string['userisfilteredout'] = 'Denne bruger matcher ikke filtrene og tabelpræferencerne!';
$string['usermustbemnet'] = 'Brugere i MNET\'s adgangskontrolliste skal være eksterne MNET-brugere';
$string['usernamelowercase'] = 'Brugernavnet skal være med små bogstaver';
$string['usernotaddederror'] = 'Brugeren blev ikke tilføjet - fejl';
$string['usernotaddedregistered'] = 'Brugeren blev ikke tilføjet - er registreret i forvejen.';
$string['usernotaddedusernameexists'] = 'Bruger ikke tilføjet - brugernavn findes allerede med en anden e-mailadresse';
$string['usernotavailable'] = 'Denne brugers oplysninger er ikke tilgængelige for dig';
$string['usernotdeletedadmin'] = 'Brugeren blev ikke slettet da administratorkonti ikke kan slettes';
$string['usernotdeleteddeleted'] = 'Denne bruger er allerede slettet';
$string['usernotdeletederror'] = 'Brugeren er ikke slettet - fejl.';
$string['usernotdeletedmissing'] = 'Brugeren er ikke slettet - brugernavnet blev ikke fundet';
$string['usernotdeletedoff'] = 'Brugeren er ikke slettet - sletning er ikke tilladt';
$string['usernotfullysetup'] = 'Brugeren er ikke fuldt sat op';
$string['usernotincourse'] = 'Denne bruger findes ikke på kurset!';
$string['usernotrenamedadmin'] = 'Kan ikke omdøbe admin-konti';
$string['usernotrenamedexists'] = 'Brugernavnet blev ikke ændret - det er allerede i brug';
$string['usernotrenamedmissing'] = 'Brugernavnet blev ikke ændret - kunne ikke finde det gamle brugernavn';
$string['usernotrenamedoff'] = 'Brugeren blev ikke omdøbt - det er ikke tilladt at omdøbe';
$string['usernotupdatedadmin'] = 'Kan ikke opdatere admin-konti';
$string['usernotupdatederror'] = 'Brugeren er ikke opdateret - fejl';
$string['usernotupdatednotexists'] = 'Brugeren er ikke opdateret - eksisterer ikke';
$string['userquotalimit'] = 'Du har nået din kvotegrænse for filer';
$string['userselectortoomany'] = 'user_selector har mere en en valgt bruger trods multivalg er falsk.';
$string['verifyagedigitalconsentnotpossible'] = 'Beklager, digital alderssamtykkebekræftelse er ikke mulig på nuværende tidspunkt.';
$string['wrongcall'] = 'Scriptet blev kaldt forkert';
$string['wrongcontextid'] = 'Kontekst ID var ikke korrekt (det findes ikke)';
$string['wrongdestpath'] = 'Forkert destinationssti';
$string['wrongroleid'] = 'Forkert rolle-id!';
$string['wrongsourcebase'] = 'Forkert kilde-URL';
$string['wrongusernamepassword'] = 'Forkert bruger/adgangskode';
$string['wrongzipfilename'] = 'Forkert zip-filnavn';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Kunne ikke oprette kursus - Ingen tilladelse';
$string['wwwrootmismatch'] = 'Forkert adgang opdaget, denne server kan desværre kun tilgås via adressen "{$a}", <br />Underret serveradministrator.';
$string['wwwrootslash'] = 'Forkert $CFG->wwwroot i config.php, den må ikke ende på en skråstreg.<br />Underret serverens administrator.';
$string['xmldberror'] = 'XMLDB-fejl!';
$string['youcannotdeletecategory'] = 'Du kan ikke slette kategorien "{$a}" fordi du hverken kan slette indholdet eller flytte det til anden placering.';
