<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'da', version '4.3'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_antivirus_details'] = 'Denne status kontrollerer, om der er blevet registreret en nylig fejl baseret på den grænseværdi, der er indstillet i de primære antivirusindstillinger.';
$string['check_antivirus_error'] = 'Der er blevet registreret {$a->errors} fejl inden for de sidste {$a->lookback}';
$string['check_antivirus_info'] = 'Ingen antivirus-scannere er i øjeblikket aktiveret';
$string['check_antivirus_logstore_not_supported'] = 'Det er ikke muligt at verificere tilstanden af antivirus-scannere på grund af den valgte type logopbevaring';
$string['check_antivirus_name'] = 'Antivirus';
$string['check_antivirus_ok'] = '{$a->scanners} antivirus scanner(e) aktiveret, der er ikke blevet registreret nogen problemer i de sidste {$a->lookback}';
$string['check_configrw_details'] = '<p>Det anbefales at filrettighederne på<code>config.php</code> ændres efter installationen så filen ikke kan modificeres af webserveren. Bemærk at dette tiltag ikke forbedrer sikkerheden på serveren ret meget, selv om det besværliggør eller begrænser generelle angreb.</p>';
$string['check_configrw_name'] = 'Skriveadgang til config.php';
$string['check_configrw_ok'] = 'config.php kan ikke ændres af PHP-scripts.';
$string['check_configrw_warning'] = 'PHP-scripts kan ændre i config.php.';
$string['check_cookiesecure_details'] = '<p>Hvis https-kommunikation er aktiveret, anbefales det at du også aktiverer sikre cookies. Du bør også tilføje en permanent viderestilling fra http til https, samt ideelt set tilbyde HSTS-headers.</p>';
$string['check_cookiesecure_error'] = 'Aktiver sikre cookies';
$string['check_cookiesecure_http'] = 'Du skal slå https til for at kunne bruge sikre cookies';
$string['check_cookiesecure_name'] = 'Sikre cookies';
$string['check_cookiesecure_ok'] = 'Sikre cookies er aktiveret';
$string['check_crawlers_details'] = '<p>Indstillingen "Åben for Google" giver søgemaskiner adgang til kurser som gæster. Der er ingen grund til at aktivere denne indstilling hvis gæstelogin ikke er tilladt.</p>';
$string['check_crawlers_error'] = 'Søgemaskineadgang er tilladt, men det er gæsteadgang ikke.';
$string['check_crawlers_info'] = 'Søgemaskiner kan få adgang som gæster.';
$string['check_crawlers_name'] = 'Åben for Google';
$string['check_crawlers_ok'] = 'Søgemaskineadgang er ikke aktiveret.';
$string['check_defaultuserrole_details'] = '<p>Alle brugere, der er logget ind, får tildelt funktioner i standardbrugerrollen. Sørg for, at ingen risikable funktioner er tilladt i denne rolle.</p>
<p>Den eneste understøttede legacy-type for standardbrugerrollen er <em>Godkendt bruger</em>. Beføjelsen vis kursus må ikke være aktiveret.</p>
<p>Tjek, om indstillingen til automatisk godkendelse af anmodninger om datasletning (tool_dataprivacy | automaticdatadeletionapproval) er aktiveret. Brugere kan anmode om sletninger, der kan slette store mængder data..</p>';
$string['check_defaultuserrole_error'] = 'Standardrollen "{$a}" for brugere er ikke defineret korrekt!';
$string['check_defaultuserrole_name'] = 'Standardrolle til alle brugere';
$string['check_defaultuserrole_notset'] = 'Standardrollen er ikke specificeret.';
$string['check_defaultuserrole_ok'] = 'Definitionen af standardrollen for alle brugere er OK.';
$string['check_dirindex_info'] = 'Mappeindeks bør ikke være aktiveret';
$string['check_displayerrors_details'] = '<p>Aktivering af PHP-indstillingen <code>display_errors</code> anbefales ikke på en installation i drift da fejlbeskeder kan afsløre følsomme oplysninger om din server.</p>';
$string['check_displayerrors_error'] = 'PHP-indstillingen til at vise fejl er aktiveret. Den anbefales deaktiveret.';
$string['check_displayerrors_name'] = 'Visning af PHP-fejl';
$string['check_displayerrors_ok'] = 'Visning af PHP-fejl er deaktiveret.';
$string['check_dotfiles_info'] = 'Alle dotfiler undtagen /.well-known/* bør ikke være offentligt tilgængelige';
$string['check_emailchangeconfirmation_details'] = '<p>Det anbefales at kræve en mailbekræftelse når brugere ændrer deres e-mail i deres profil. Ellers kan spammere prøve at udnytte serveren til udsending af spam.</p> <p>E-mailfelter kan også låses for godkendelses-plugins, det er måske ikke taget med i betragtning her.</p>';
$string['check_emailchangeconfirmation_error'] = 'Brugere kan skrive deres e-mailadresse.';
$string['check_emailchangeconfirmation_info'] = 'Brugere kan kun skrive deres e-mailadresse fra tilladte domæner.';
$string['check_emailchangeconfirmation_name'] = 'Bekræftelse af ny e-mailadresse';
$string['check_emailchangeconfirmation_ok'] = 'Bekræftelse af ændring af e-mailadresse i brugerprofilen.';
$string['check_embed_details'] = '<p>Ubegrænset indlejring af objekter er meget risikabelt - enhver registreret bruger kan starte et XXS-angreb mod andre serverbrugere. Indstillingen bør være deaktiveret på produktionsservere.</p>';
$string['check_embed_error'] = 'Ubegrænset indlejring af objekter er aktiveret - dette er forbundet med stor usikkerhed for de fleste servere.';
$string['check_embed_name'] = 'Tillad EMBED og OBJECT';
$string['check_embed_ok'] = 'Ubegrænset indlejring af objekter er ikke tilladt.';
$string['check_frontpagerole_details'] = '<p>Standardrollen på forsiden gives til alle registrerede brugere for aktiviteter på forsiden. Du bør forsikre dig om at ingen risikable beføjelser er tilladt for denne rolle.</p> <p>Det anbefales at oprette en speciel rolle til dette formål og ikke bruge en arvet type rolle.</p>';
$string['check_frontpagerole_error'] = 'Ikke korrekt defineret forsiderolle "{$a}" opdaget!';
$string['check_frontpagerole_name'] = 'Forsiderolle';
$string['check_frontpagerole_notset'] = 'Der er ikke valgt forsiderolle.';
$string['check_frontpagerole_ok'] = 'Definition af forsiderolle er OK.';
$string['check_guestrole_details'] = '<p>Gæsterollen er til gæster, til brugere der ikke er logget ind og til midlertidig adgang for gæster på et kursus. Sørg for at denne rolle ikke har nogen risikofyldte beføjelser.</p> <p>Den eneste understøttede legacy-type for gæsterollen er <em>gæst</em>.</p>';
$string['check_guestrole_error'] = 'Gæsterollen "{$a}" er ikke defineret korrekt!';
$string['check_guestrole_name'] = 'Gæsterolle';
$string['check_guestrole_notset'] = 'Gæsterollen er ikke defineret.';
$string['check_guestrole_ok'] = 'Definitionen af gæsterollen er OK.';
$string['check_mediafilterswf_details'] = '<p>Automatisk indlejring af swf-filer er meget risikabelt - enhver registreret bruger kan starte et XXS-angreb mod andre serverbrugere. Deaktiver denne mulighed på installationer i drift.</p>';
$string['check_mediafilterswf_error'] = 'Flash-mediefilteret er aktiveret - dette er meget risikabelt for de fleste servere.';
$string['check_mediafilterswf_name'] = '.swf-mediefilteret er aktiveret';
$string['check_mediafilterswf_ok'] = 'Flash-mediefilteret er ikke aktiveret';
$string['check_nodemodules_details'] = '<p>Mappen <code>{$a->path}</code> indeholder Node.js-moduler og deres afhængigheder, typisk installeret af NPM. Disse moduler kan være nødvendige når Moodle udvikles lokalt, såsom med grunt framework. De kræves ikke til kørsel af Moodle i drift og kan indeholde potentielt farlig kode der kan eksponere dit site for eksterne angreb.</p><p>Det anbefales kraftigt at fjerne mappen hvis sitet er tilgængeligt via en offentlig URL, eller i det mindste lukke for webadgang til det i webserverens konfiguration.</p>';
$string['check_nodemodules_info'] = 'Mappen node_modules skal ikke eksistere på offentlige websteder.';
$string['check_nodemodules_name'] = 'Mappe med Node.js-moduler';
$string['check_openprofiles_details'] = 'Åbne brugerprofiler kan misbruges af spammere. <code>Tving brugere til at logge ind for at se profiler</code> eller <code>Tving brugere til at logge ind</code> anbefales aktiveret.';
$string['check_openprofiles_error'] = 'Alle kan se brugerprofiler uden at logge ind.';
$string['check_openprofiles_name'] = 'Åbne brugerprofiler';
$string['check_openprofiles_ok'] = 'Kun brugere, der er logget ind, kan se brugerprofiler.';
$string['check_passwordpolicy_details'] = '<p>Det anbefales at have en adgangskodepolitik da gæt af koder meget ofte er den nemmeste vej til opnåelse af uautoriseret adgang. Lad dog ikke kravene være for strikse, det kan resultere i at brugerne ikke vil kunne huske deres koder og enten glemmer dem eller skriver dem ned.</p>';
$string['check_passwordpolicy_error'] = 'Der er ikke defineret en adgangskodepolitik.';
$string['check_passwordpolicy_name'] = 'Adgangskodepolitik';
$string['check_passwordpolicy_ok'] = 'Adgangskodepolitik aktiveret';
$string['check_preventexecpath_details'] = '<p>Tillader eksekverbare stier at blive sat via Admin-GUI som en vektor for øgede brugerrettigheder. Dette kan gennemtvinges i config.php:</p><p><code>$CFG->preventexecpath = true;</code></p>';
$string['check_preventexecpath_name'] = 'Exekverbare stier';
$string['check_preventexecpath_ok'] = 'Eksekverbare stier kan kun opsættes i config.php.';
$string['check_preventexecpath_warning'] = 'Exekverbare stier kan opsættes i Admin-indstillingerne';
$string['check_publicpaths_403'] = '(Returnerede en 403, ideelt set skulle være 404)';
$string['check_publicpaths_generic'] = '{$a} filer bør ikke være offentligt tilgængelige';
$string['check_publicpaths_name'] = 'Kontroller alle offentlige/private stier';
$string['check_publicpaths_ok'] = 'Alle interne stier er ikke offentligt tilgængelige';
$string['check_publicpaths_warning'] = 'Nogle interne stier er offentligt tilgængelige';
$string['check_riskadmin_detailsok'] = '<p>Verificer denne liste med systemadministratorer:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Verificer den følgende liste med systemadministratorer:</p>{$a->admins} <p>Det anbefales kun at tildele administratorrollen i systemkontekst. De følgende brugere har (usupporterede) tildelinger af admin-rollen i andre kontekster:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Administratorer';
$string['check_riskadmin_ok'] = '{$a} server administrator(er) fundet';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) gennemse rolletildelinger</a>';
$string['check_riskadmin_warning'] = 'Fandt {$a->admincount} serveradministratorer og {$a->unsupcount} usupporterede admin-rolletildelinger.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Disse aktive undtagelser giver brugere mulighed for at inkludere brugerdata i backups. Forsikr dig om at disse tilladelser er nødvendige.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>De følgende systemroller tillader pt. brugere at inkludere brugerdata i backups. Du bør forsikre dig om at denne tilladelse er nødvendig.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Som følge af de ovenstående roller eller lokale overskrivninger, har de følgende konti tilladelse til at tage backups med private data om deltagere på deres kursus. Du bør forsikre dig om at de er (a) troværdige/betroede og (b) beskyttet af stærke adgangskoder:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Ingen roller tillader eksplicit backup af brugerdata. Bemærk imidlertid at admins med beføjelsen "doanything" sandsynligvis stadig er i stand til dette.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} i {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Backup af brugerdata';
$string['check_riskbackup_ok'] = 'Ingen roller har eksplicit tilladelse til at tage backup af brugerdata';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) i {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Fandt {$a->rolecount} roller, {$a->overridecount} tilsidesættelser og {$a->usercount} brugere med tilladelse til at tage backup af brugerdata.';
$string['check_riskxss_details'] = '<p>RISK_XSS angiver risikofyldte beføjelser som kun betroede brugere bør have.</p> <p>Verificer den følgende brugerliste og sikr dig at du fuldt ud stoler på dem på denne server:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS-betroede brugere';
$string['check_riskxss_warning'] = 'RISK_XSS - fandt {$a} brugere der skal være betroede.';
$string['check_unsecuredataroot_details'] = '<p>Mappen med Moodledata må ikke være tilgængelig fra Internettet. Den bedste måde at sikre det på, er at placere mappen udenfor den offentlige webmappe.</p> <p>Hvis du flytter mappen skal du opdatere indstillingen for <code>$CFG->dataroot</code> i <code>config.php</code> tilsvarende.</p>';
$string['check_unsecuredataroot_error'] = 'Din datamappe <code>{$a}</code> er placeret forkert og er synlig på Internettet!';
$string['check_unsecuredataroot_name'] = 'Usikker datamappe';
$string['check_unsecuredataroot_ok'] = 'Datamappen må ikke være tilgængelig fra Internettet.';
$string['check_unsecuredataroot_warning'] = 'Din datamappe <code>{$a}</code> er placeret forkert og kan være synlig på Internettet.';
$string['check_vendordir_details'] = '<p>Mappen <code>{$a->path}</code> indeholder forskellige 3.-partsbiblioteker og deres afhængigheder, typisk installeret af PHP Composer. Disse moduler kan være nødvendige når Moodle udvikles lokalt, såsom til installation af PHPUnit framework. De kræves ikke til kørsel af Moodle i drift og kan indeholde potentielt farlig kode der kan eksponere dit site for eksterne angreb.</p>
<p>Det anbefales kraftigt at fjerne mappen hvis sitet er tilgængeligt via en offentlig URL, eller i det mindste lukke for webadgang til det i webserverens konfiguration.</p>';
$string['check_vendordir_info'] = 'Leverandørmappen bør ikke findes på sites i drift.';
$string['check_vendordir_name'] = 'Leverandørmappe';
$string['check_webcron_details'] = '<p>Kørsel af cron fra en webbrowser kan afsløre fortrolig information til anonyme brugere. Det anbefales kun at køre cron fra en kommandolinje eller sætte en kode på cron til ekstern adgang.';
$string['check_webcron_name'] = 'Web-cron';
$string['check_webcron_ok'] = 'Anonyme brugere kan ikke tilgå cron.';
$string['check_webcron_warning'] = 'Anonyme brugere kan tilgå cron.';
$string['configuration'] = 'Konfiguration';
$string['description'] = 'Beskrivelse';
$string['details'] = 'Detaljer';
$string['eventreportviewed'] = 'Sikkerhedskontrolrapport set';
$string['issue'] = 'Udbyder';
$string['pluginname'] = 'Sikkerhedstjek';
$string['privacy:metadata'] = 'Plugin\'et Sikkerhedsoversigt gemmer ingen personlige data.';
$string['security:view'] = 'Vis sikkerhedsrapport';
$string['timewarning'] = 'Det kan tage nogen tid at behandle dataene, vær tålmodig...';
