<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'da', version '4.3'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Tilføjer en ny rolle';
$string['addrole'] = 'Tilføj en ny rolle';
$string['advancedoverride'] = 'Avanceret rolletilsidesættelse';
$string['allow'] = 'Tillad';
$string['allowassign'] = 'Tillad rolletildeling';
$string['allowed'] = 'Tilladt';
$string['allowoverride'] = 'Tillad tilsidesættelse af roller';
$string['allowroletoassign'] = 'Tillad brugere med rollen {$a->fromrole} at tildele rollen {$a->targetrole}';
$string['allowroletooverride'] = 'Tillad brugere med rollen {$a->fromrole} at overskrive rollen {$a->targetrole}';
$string['allowroletoswitch'] = 'Tillad brugere med rollen {$a->fromrole} at skifte rolle til {$a->targetrole}';
$string['allowroletoview'] = 'Tillad brugere med rollen {$a->fromrole} at se rollen {$a->targetrole}';
$string['allowswitch'] = 'Tillad skift af rolle';
$string['allowview'] = 'Tillad rolle at se';
$string['allsiteusers'] = 'Alle brugere på webstedet';
$string['analytics:listinsights'] = 'Vis indsigter.';
$string['analytics:listowninsights'] = 'Vis egne indsigter.';
$string['analytics:managemodels'] = 'Håndter modeller';
$string['archetype'] = 'Rollearketype';
$string['archetype_help'] = 'Rollens arketype bestemmer tilladelserne når en rolle nulstilles til standard. Den bestemmer også nye tilladelser for rollen når sitet er opgraderet.';
$string['archetypecoursecreator'] = 'ARKETYPE: Kursusadministrator';
$string['archetypeeditingteacher'] = 'ARKETYPE: Lærer (kan redigere)';
$string['archetypefrontpage'] = 'ARKETYPE: Godkendt bruger på forsiden';
$string['archetypeguest'] = 'ARKETYPE: Gæst';
$string['archetypemanager'] = 'ARKETYPE: Administrator';
$string['archetypestudent'] = 'ARKETYPE: Studerende';
$string['archetypeteacher'] = 'ARKETYPE: Medunderviser  (kan ikke redigere)';
$string['archetypeuser'] = 'ARKETYPE: Godkendt bruger';
$string['assignanotherrole'] = 'Tildel en anden rolle';
$string['assignedroles'] = 'Tildelte roller';
$string['assignerror'] = 'Fejl under tildeling af rollen{$a->role} til {$a->user}';
$string['assignglobalroles'] = 'Tildel generelle roller';
$string['assignmentcontext'] = 'Opgavekontekst';
$string['assignmentoptions'] = 'Opgaveindstillinger';
$string['assignrole'] = 'Tildel rolle';
$string['assignrolenameincontext'] = 'Tildel rollen "{$a->role}" i konteksten "{$a->context}"';
$string['assignroles'] = 'Tildel roller';
$string['assignroles_help'] = 'Ved at tildele en rolle til brugere i en kontekst, giver du dem de tilladelser der er indeholdt i rollen for den aktuelle kontekst og alle kontekster under den. Hvis du f.eks. bevilger rollen studerende til en bruger på et kursus, vil vedkommende også have den rolle i alle blokke og aktiviteter på kurset.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = '{$a} - tildeling af roller';
$string['assignrolesrelativetothisuser'] = 'Tildel roller relateret til denne bruger';
$string['backtoallroles'] = 'Tilbage til listen over roller';
$string['backup:anonymise'] = 'Anonymiser brugerdata på backup';
$string['backup:backupactivity'] = 'Tag backup af aktiviteter';
$string['backup:backupcourse'] = 'Tag backup af kurser';
$string['backup:backupsection'] = 'Tag backup af sektioner';
$string['backup:backuptargetimport'] = 'Backup til import';
$string['backup:configure'] = 'Konfigurer backup-indstillinger';
$string['backup:downloadfile'] = 'Download filer fra backup-mapper';
$string['backup:userinfo'] = 'Tag backup af brugerdata';
$string['badges:awardbadge'] = 'Tildel badge til en bruger';
$string['badges:configurecriteria'] = 'Opstil/rediger kriterier for at få en badge';
$string['badges:configuredetails'] = 'Opstil/rediger badge-oplysninger';
$string['badges:configuremessages'] = 'Konfigurer badge-beskeder';
$string['badges:createbadge'] = 'Opret/dupliker badges';
$string['badges:deletebadge'] = 'Slet badges';
$string['badges:earnbadge'] = 'Optjen badge';
$string['badges:manageglobalsettings'] = 'Administrer generelle badge-indstillinger';
$string['badges:manageownbadges'] = 'Se og håndter egne optjente badges';
$string['badges:revokebadge'] = 'Tilbagekald badge fra en bruger';
$string['badges:viewawarded'] = 'Se brugere der har optjent en specifik badge uden at kunne tildele en badge';
$string['badges:viewbadges'] = 'Se tilgængelige badges uden at optjene dem';
$string['badges:viewotherbadges'] = 'Se offentlige badges i brugeres profiler';
$string['block:edit'] = 'Rediger en bloks indstillinger';
$string['block:view'] = 'Se blok';
$string['blog:create'] = 'Opret nye blogindlæg';
$string['blog:manageentries'] = 'Rediger og administrer indlæg';
$string['blog:manageexternal'] = 'Rediger og administrer eksterne blogs';
$string['blog:search'] = 'Søg blogindlæg';
$string['blog:view'] = 'Vis blogindlæg';
$string['blog:viewdrafts'] = 'Se udkast til blogindlæg';
$string['calendar:manageentries'] = 'Administrer alle kalendere';
$string['calendar:managegroupentries'] = 'Administrer kalender for gruppe';
$string['calendar:manageownentries'] = 'Administrer egen kalender';
$string['capabilities'] = 'Beføjelser';
$string['capability'] = 'Beføjelse';
$string['category:create'] = 'Opret kategorier';
$string['category:delete'] = 'Slet kategorier';
$string['category:manage'] = 'Administrer kategorier';
$string['category:update'] = 'Opdatere kategorier';
$string['category:viewcourselist'] = 'Vis kursuskategori og kurser i den';
$string['category:viewhiddencategories'] = 'Se skjulte kategorier';
$string['category:visibility'] = 'Se skjulte kategorier';
$string['checkglobalpermissions'] = 'Tjek systemtilladelser';
$string['checkpermissions'] = 'Tjek tilladelser';
$string['checkpermissionsin'] = 'Tjek tilladelser i {$a}';
$string['checksystempermissionsfor'] = 'Tjek systemtilladelser for {$a->fullname}';
$string['checkuserspermissionshere'] = 'Tjek hvilke tilladelser {$a->fullname} har i {$a->contextlevel}';
$string['chooseroletoassign'] = 'Vælg en rolle at tildele';
$string['cohort:assign'] = 'Tilføj og fjern medlemmer af brugergruppe';
$string['cohort:configurecustomfields'] = 'Konfigurer kohorte brugerdefinerede felter.';
$string['cohort:manage'] = 'Opret, slet og flyt brugergrupper';
$string['cohort:view'] = 'Se webstedets brugergrupper';
$string['comment:delete'] = 'Slet kommentarer';
$string['comment:post'] = 'Skriv kommentarer';
$string['comment:view'] = 'Se kommentarer';
$string['competency:competencygrade'] = 'Sæt kompetencevurdering';
$string['competency:competencymanage'] = 'Administrer kompetencerammer';
$string['competency:competencyview'] = 'Se kompetencerammer';
$string['competency:coursecompetencyconfigure'] = 'Konfigurer indstillinger for kursuskompetence';
$string['competency:coursecompetencygradable'] = 'Modtag kompetencemærker.';
$string['competency:coursecompetencymanage'] = 'Administrer kursuskompetencer';
$string['competency:coursecompetencyview'] = 'Se kursuskompetencer';
$string['competency:evidencedelete'] = 'Slet vidnesbyrd';
$string['competency:plancomment'] = 'Kommentar på en læringsplan';
$string['competency:plancommentown'] = 'Kommentar på egen læringsplan';
$string['competency:planmanage'] = 'Administrer læringsplaner';
$string['competency:planmanagedraft'] = 'Administrer læringsplankladder';
$string['competency:planmanageown'] = 'Administrer egne læringsplaner';
$string['competency:planmanageowndraft'] = 'Administrer egne læringsplankladder';
$string['competency:planrequestreview'] = 'Anmod om gennemsyn af en læringsplan';
$string['competency:planrequestreviewown'] = 'Anmod om gennemsyn af egen læringsplan';
$string['competency:planreview'] = 'Gennemse en læringsplan';
$string['competency:planview'] = 'Se alle læringsplaner';
$string['competency:planviewdraft'] = 'Se læringsplankladder';
$string['competency:planviewown'] = 'Se egne læringsplaner';
$string['competency:planviewowndraft'] = 'Se egne læringsplankladder';
$string['competency:templatemanage'] = 'Administrer læringsplanskabeloner';
$string['competency:templateview'] = 'Se læringsplanskabeloner';
$string['competency:usercompetencycomment'] = 'Kommenter en brugerkompetence';
$string['competency:usercompetencycommentown'] = 'Kommenter egen brugerkompetence';
$string['competency:usercompetencyrequestreview'] = 'Anmod om gennemsyn af brugerkompetence';
$string['competency:usercompetencyrequestreviewown'] = 'Anmod om gennemsyn af egen brugerkompetence';
$string['competency:usercompetencyreview'] = 'Gennemse brugerkompetence';
$string['competency:usercompetencyview'] = 'Se en brugerkompetence';
$string['competency:userevidencemanage'] = 'Administrer dokumentation af tidligere læring';
$string['competency:userevidencemanageown'] = 'Administrer dokumentation af egen tidligere læring';
$string['competency:userevidenceview'] = 'Administrer dokumentation af en brugers tidligere læring';
$string['confirmaddadmin'] = 'Vil du virkelig tilføje brugeren <strong>{$a}</ strong> som ny administrator?';
$string['confirmaddadmins'] = 'Er du sikker på, at du vil tilføje følgende brugere til listen over sideadministratoren?';
$string['confirmdeladmin'] = 'Vil du virkelig fjerne brugeren <strong>{$a}</ strong> fra listen over webstedsadministratorer?';
$string['confirmremoveadmins'] = 'Er du sikker på, at du vil fjerne følgende brugere fra listen over sideadministratorer?';
$string['confirmroleprevent'] = 'Vil du virkelig fjerne <strong>{$a->role}</strong> fra listen over roller med beføjelsen "{$a->cap}" i konteksten {$a->context}?';
$string['confirmroleunprohibit'] = 'Vil du virkelig fjerne <strong>{$a->role}</strong> fra listen over forbudte roller for beføjelsen {$a->cap} i konteksten {$a->context}?';
$string['confirmunassign'] = 'Er du sikker på du ønsker at fjerne denne rolle fra denne bruger?';
$string['confirmunassignno'] = 'Annuller';
$string['confirmunassigntitle'] = 'Bekræft skift af rolle';
$string['confirmunassignyes'] = 'Fjern';
$string['contentbank:access'] = 'Tilgå indholdsbanken';
$string['contentbank:copyanycontent'] = 'Kopier ethvert indhold i indholdsbanken.';
$string['contentbank:copycontent'] = 'Kopier indholdet i indholdsbanken.';
$string['contentbank:deleteanycontent'] = 'Slet alt indhold i indholdsbanken';
$string['contentbank:deleteowncontent'] = 'Slet indhold i egen indholdsbank';
$string['contentbank:downloadcontent'] = 'Download indhold fra indholdsbanken';
$string['contentbank:manageanycontent'] = 'Håndter alt indhold i indholdsbanken';
$string['contentbank:manageowncontent'] = 'Håndter indhold i egen indholdsbank';
$string['contentbank:upload'] = 'Upload nyt indhold til indholdsbanken';
$string['contentbank:useeditor'] = 'Opret eller rediger indhold ved hjælp af en indholdstypeeditor';
$string['contentbank:viewunlistedcontent'] = 'Vis indhold fra indholdsbanken, der ikke er på listen';
$string['context'] = 'Kontekst';
$string['contextrolenotallowed'] = 'Rolle {$a} ikke tilladt i denne kontekst.';
$string['course:activityvisibility'] = 'Skjul/vis aktiviteter';
$string['course:bulkmessaging'] = 'Send en besked til mange personer';
$string['course:changecategory'] = 'Skift kursuskategori';
$string['course:changefullname'] = 'Rediger kursets fulde navn';
$string['course:changeidnumber'] = 'Rediger kursets id-nummer';
$string['course:changelockedcustomfields'] = 'Redigere skræddersyede felter der er låste';
$string['course:changeshortname'] = 'Rediger kursets korte navn';
$string['course:changesummary'] = 'Rediger kursusbeskrivelse';
$string['course:configurecoursecommunication'] = 'Konfigurer kursuskommunikationsindstillinger.';
$string['course:configurecustomfields'] = 'Konfigurer skræddersyede felter';
$string['course:configuredownloadcontent'] = 'Konfigurer download af kursusindhold';
$string['course:create'] = 'Opret kurser';
$string['course:creategroupconversations'] = 'Opret gruppesamtaler';
$string['course:delete'] = 'Slet kurser';
$string['course:downloadcoursecontent'] = 'Download kursusindhold';
$string['course:enrolconfig'] = 'Konfigurer tilmeldingsforekomster på kurser';
$string['course:enrolreview'] = 'Gennemgå kursustilmeldinger';
$string['course:ignoreavailabilityrestrictions'] = 'Ignorer adgangsbetingelser';
$string['course:ignorefilesizelimits'] = 'Brug filer der fylder mere end de angivne begrænsninger for fil-størrelse';
$string['course:isincompletionreports'] = 'Bliv vist i gennemførelsesrapporter';
$string['course:manageactivities'] = 'Administrer aktiviteter';
$string['course:managefiles'] = 'Administrer filer';
$string['course:managegrades'] = 'Administrer karakterer';
$string['course:managegroups'] = 'Administrer grupper';
$string['course:managescales'] = 'Administrer skalaer';
$string['course:markcomplete'] = 'Marker brugere som færdige i kursusgennemførelse';
$string['course:movesections'] = 'Flyt sektioner';
$string['course:overridecompletion'] = 'Overskriv status på aktivitetsfuldførelse';
$string['course:recommendactivity'] = 'Anbefalede aktiviteter i indholdsvælgeren';
$string['course:renameroles'] = 'Omdøb roller';
$string['course:request'] = 'Anmod om nye kurser';
$string['course:reset'] = 'Nulstil kursus';
$string['course:reviewotherusers'] = 'Gennemse øvrige brugere';
$string['course:sectionvisibility'] = 'Kontroller synligheden af sektioner';
$string['course:setcurrentsection'] = 'Se aktuelle sektion';
$string['course:setforcedlanguage'] = 'Gennemtving kursus- eller aktivitetssprog';
$string['course:tag'] = 'Ændre kursus-tags';
$string['course:togglecompletion'] = 'Marker automatisk aktiviteter som gennemførte';
$string['course:update'] = 'Opdater kursusindstillinger';
$string['course:useremail'] = 'Aktivere/deaktivere e-mailadresser';
$string['course:view'] = 'Se kurser uden tilmelding';
$string['course:viewcoursegrades'] = 'Se kursuskarakterer';
$string['course:viewhiddenactivities'] = 'Se skjulte aktiviteter';
$string['course:viewhiddencourses'] = 'Se skjulte kurser';
$string['course:viewhiddengroups'] = 'Vis skjulte gruppe';
$string['course:viewhiddensections'] = 'Se skjulte sektioner';
$string['course:viewhiddenuserfields'] = 'Se skjulte brugeroplysninger';
$string['course:viewparticipants'] = 'Se deltagerlisten';
$string['course:viewscales'] = 'Se skalaer';
$string['course:viewsuspendedusers'] = 'Se suspenderede brugere';
$string['course:visibility'] = 'Vise/skjule kurser';
$string['createrolebycopying'] = 'Opret en ny rolle ved at kopiere {$a}';
$string['createthisrole'] = 'Opret denne rolle';
$string['currentcontext'] = 'Nuværende indhold';
$string['currentrole'] = 'Nuværende rolle';
$string['customroledescription'] = 'Brugerdefineret beskrivelse';
$string['customroledescription_help'] = 'Beskrivelse af standardroller sker automatisk hvis den brugerdefinerede beskrivelse er tom.';
$string['customrolename'] = 'Brugerdefineret fulde navn';
$string['customrolename_help'] = 'Navne på standardroller angives automatisk hvis det brugerdefinerede navn er tomt. Du skal angive et fuldt navn på alle brugerdefinerede roller.';
$string['defaultrole'] = 'Standardrolle';
$string['defaultx'] = 'Standard: {$a}';
$string['defineroles'] = 'Definer roller';
$string['definitionofrolex'] = 'Definition af rolle \'{$a}\'';
$string['deletecourseoverrides'] = 'Slet alle tilsidesættelser af roller på kurset';
$string['deletelocalroles'] = 'Slet alle rolletildelinger';
$string['deleterolesure'] = 'Er du sikker på at du vil slette rollen "{$a->name} ({$a->shortname})"?</p><p>Denne rolle er på nuværende tidspunkt tildelt {$a->count} brugere.';
$string['deletexrole'] = 'Slet rollen {$a}';
$string['duplicaterole'] = 'Kopier rolle';
$string['duplicaterolesure'] = '<p>Bekræft at du vil dublere rollen "{$a->name} ({$a->shortname})".</p>';
$string['editingrolex'] = 'Rediger rollen "{$a}"';
$string['editrole'] = 'Rediger rolle';
$string['editxrole'] = 'Rediger rollen {$a}';
$string['errorbadrolename'] = 'Ugyldigt rollenavn';
$string['errorbadroleshortname'] = 'Ugyldigt kort rollenavn';
$string['errorexistsrolename'] = 'Rollen eksisterer allerede';
$string['errorexistsroleshortname'] = 'Rollen eksisterer allerede';
$string['errorroleshortnametoolong'] = 'Det korte navn må ikke have mere end 100 tegn';
$string['eventcapabilityassigned'] = 'Beføjelse tildelt';
$string['eventcapabilityunassigned'] = 'Beføjelse frataget';
$string['eventroleallowassignupdated'] = 'Tillad rolletildeling';
$string['eventroleallowoverrideupdated'] = 'Tillad tilsidesættelse af rolle';
$string['eventroleallowswitchupdated'] = 'Tillad skift af rolle';
$string['eventroleallowviewupdated'] = 'Tillad rollevisning';
$string['eventroleassigned'] = 'Rolle tildelt';
$string['eventrolecapabilitiesupdated'] = 'Rollebeføjelser opdateret';
$string['eventroledeleted'] = 'Rolle blev slettet';
$string['eventroleunassigned'] = 'Rolle ikke tildelt';
$string['eventroleupdated'] = 'Rolle opdateret';
$string['existingadmins'] = 'Aktuelle webstedsadministratorer';
$string['existingusers'] = '{$a} eksisterende brugere';
$string['explanation'] = 'Forklaring';
$string['export'] = 'Eksport';
$string['extusers'] = 'Eksisterende brugere';
$string['extusersmatching'] = 'Eksisterende brugere der matcher "{$a}"';
$string['filter:manage'] = 'Administrer lokale filterindstillinger';
$string['frontpageuser'] = 'Godkendte brugere på forsiden';
$string['frontpageuserdescription'] = 'Alle brugere der er logget på forsidekurset.';
$string['globalrole'] = 'Systemrolle';
$string['globalroleswarning'] = 'ADVARSEL! De roller du tildeler her vil gælde på hele webstedet, inklusiv forsiden og samtlige kurser.';
$string['gotoassignroles'] = 'Gå til Tildel roller til {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Gå til tildeling af systemroller';
$string['grade:edit'] = 'Rediger karakterer';
$string['grade:export'] = 'Eksporter karakterer';
$string['grade:hide'] = 'Vis/skjul karakterer eller elementer';
$string['grade:import'] = 'Importer karakterer';
$string['grade:lock'] = 'Lås karakterer eller elementer';
$string['grade:manage'] = 'Administrer karakterelementer';
$string['grade:managegradingforms'] = 'Administrer avancerede karaktergivningsmetoder';
$string['grade:manageletters'] = 'Administrer bogstav-karakterer';
$string['grade:manageoutcomes'] = 'Administrer karakterresultater';
$string['grade:managesharedforms'] = 'Administrer avanceret skabelon til karaktergivningsformular';
$string['grade:override'] = 'Overskriv karakterer';
$string['grade:sharegradingforms'] = 'Del avanceret karaktergivningsformular som skabelon';
$string['grade:unlock'] = 'Lås karakterelementer op';
$string['grade:view'] = 'Vis egne karakterer';
$string['grade:viewall'] = 'Vis andre brugeres karakterer';
$string['grade:viewhidden'] = 'Vis karakterer der er skjult for ejer';
$string['h5p:deploy'] = 'Udrul H5P-indhold';
$string['h5p:setdisplayoptions'] = 'Visningsindstillinger for H5P';
$string['h5p:updatelibraries'] = 'Administrer H5P-indholdstyper';
$string['highlightedcellsshowdefault'] = 'De fremhævede felter i tabellen herunder viser de tilladelser, der vil blive nedarvet. Bortset fra de beføjelser du vil ændre på, skal du lade alt blive nedarvet.';
$string['highlightedcellsshowinherit'] = 'De fremhævede celler i tabellen herunder viser de (eventuelle) tilladelser der vil blive nedarvede. Bortset fra de beføjelser hvis tilladelser du faktisk vil ændre, skal du lade resten blive nedarvet.';
$string['inactiveformorethan'] = 'inaktiv i mere end {$a->timeperiod}';
$string['ingroup'] = 'i gruppen "{$a->group}"';
$string['inherit'] = 'Nedarver';
$string['invalidpresetfile'] = 'Ugyldig definitionsfil til rolle';
$string['legacy:admin'] = 'STANDARDROLLE: Administrator';
$string['legacy:coursecreator'] = 'STANDARDROLLE: Kursusadministrator';
$string['legacy:editingteacher'] = 'STANDARDROLLE: Lærer';
$string['legacy:guest'] = 'STANDARDROLLE: Gæst';
$string['legacy:student'] = 'STANDARDROLLE: Studerende';
$string['legacy:teacher'] = 'STANDARDROLLE: Medunderviser';
$string['legacy:user'] = 'STANDARDROLLE: Oprettet bruger';
$string['legacytype'] = 'Nedarvet rolletype';
$string['listallroles'] = 'Vis alle roller';
$string['localroles'] = 'Lokal tildeling af roller';
$string['mainadmin'] = 'Hovedadministrator';
$string['mainadminset'] = 'Vælg som hovedadministrator';
$string['manageadmins'] = 'Administrer webstedsadministratorer';
$string['manager'] = 'Administrator';
$string['managerdescription'] = 'Administratorer kan komme ind på kurser og ændre i dem, de deltager normalt ikke på kurser.';
$string['manageroles'] = 'Administrer roller';
$string['maybeassignedin'] = 'Konteksttyper hvori denne rolle kan tildeles ';
$string['morethan'] = 'Mere end {$a}';
$string['multipleroles'] = 'Flere roller';
$string['my:configsyspages'] = 'Konfigurer systemskabeloner til betjeningspanelsider';
$string['my:manageblocks'] = 'Administrer betjeningspanelsblokke';
$string['neededroles'] = 'Roller med tilladelse';
$string['nocapabilitiesincontext'] = 'Ingen beføjelser tilgængelige i denne kontekst';
$string['noneinthisx'] = 'Ingen i {$a}';
$string['noneinthisxmatching'] = 'Ingen brugere matcher "{$a->search}" i denne {$a->contexttype}';
$string['norole'] = 'Ingen rolle';
$string['noroleassignments'] = 'Denne bruger har ikke nogen rolle tildelt på dette websted.';
$string['noroles'] = 'Ingen roller';
$string['notabletoassignroleshere'] = 'Rolletildeling her er ikke aktiveret af en administrator.';
$string['notabletooverrideroleshere'] = 'Du kan ikke overskrive tilladelserne for roller her';
$string['notes:manage'] = 'Administrer noter';
$string['notes:view'] = 'Vis noter';
$string['notset'] = 'Ikke angivet';
$string['novisibleroles'] = 'Ingen roller';
$string['overrideanotherrole'] = 'Overskriv en anden rolle';
$string['overridecontext'] = 'Overskriv kontekst';
$string['overridepermissions'] = 'Tilsidesæt tilladelser';
$string['overridepermissions_help'] = 'Tilsidesættelse af tilladelser gør det muligt at tillade eller forbyde udvalgte beføjelser i en specifik kontekst.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Overskriv tilladelser for rollen "{$a->role}" i {$a->context}';
$string['overridepermissionsin'] = '{$a} - tilsidesæt beføjelser';
$string['overrideroles'] = 'Tilsidesæt roller';
$string['overriderolesin'] = 'Tilsidesæt roller i {$a}';
$string['overrides'] = 'Tilsidesættelser';
$string['overridesbycontext'] = 'Tilsidesættelser (pr. kontekst)';
$string['payment:manageaccounts'] = 'Administrer konti';
$string['permission'] = 'Tilladelse';
$string['permission_help'] = 'Tilladelser er de indstillinger du tildeler de specifikke beføjelser. Der er 4 muligheder:

* Ikke specificeret
* Tillad - Bevilger tilladelse til beføjelsen
* Tillad ikke - Tilladelsen er ophævet, også hvis den er nedarvet fra et højere niveau
* Forbyd - Tilladelsen er totalt forbudt og kan ikke overskrives på et lavere (mere specifikt) niveau.';
$string['permissions'] = 'Tilladelser';
$string['permissionsforuser'] = 'Tilladelser for brugeren {$a}';
$string['permissionsincontext'] = 'Tilladelser i {$a}';
$string['portfolio:export'] = 'Eksporter til porteføljer';
$string['potentialusers'] = '{$a} potentielle brugere';
$string['potusers'] = 'Potentielle brugere';
$string['potusersmatching'] = 'Potentielle brugere der matcher "{$a}"';
$string['prevent'] = 'Tillad ikke';
$string['prohibit'] = 'Forbyd';
$string['prohibitedroles'] = 'Forbudt';
$string['question:add'] = 'Tilføj nye spørgsmål';
$string['question:commentall'] = 'Kommenter alle spørgsmål';
$string['question:commentmine'] = 'Kommenter dine egne spørgsmål';
$string['question:config'] = 'Konfigurer typer af spørgsmål';
$string['question:editall'] = 'Rediger alle spørgsmål';
$string['question:editmine'] = 'Rediger dine egne spørgsmål';
$string['question:flag'] = 'Marker (flag) spørgsmål mens de forsøges besvaret';
$string['question:managecategory'] = 'Administrer spørgsmålskategorier';
$string['question:moveall'] = 'Flyt alle spørgsmål';
$string['question:movemine'] = 'Flyt dine egne spørgsmål';
$string['question:tagall'] = 'Tag alle spørgsmål';
$string['question:tagmine'] = 'Tag alle spørgsmål';
$string['question:useall'] = 'Benyt alle spørgsmål';
$string['question:usemine'] = 'Benyt dine egne spørgsmål';
$string['question:viewall'] = 'Vis alle spørgsmål';
$string['question:viewmine'] = 'Vis dine egne spørgsmål';
$string['rating:rate'] = 'Føj vurderinger til elementer';
$string['rating:view'] = 'Vis alle de vurderinger du har modtaget';
$string['rating:viewall'] = 'Vis alle vurderinger givet af brugere';
$string['rating:viewany'] = 'Vis totale vurderinger alle har modtaget';
$string['reportbuilder:edit'] = 'Rediger dine egne brugerdefinerede rapporter';
$string['reportbuilder:editall'] = 'Rediger alle brugerdefinerede rapporter';
$string['reportbuilder:view'] = 'Vis brugerdefinerede rapporter';
$string['resetrole'] = 'Nulstil';
$string['resettingrole'] = 'Nulstiller rollen "{$a}"';
$string['restore:configure'] = 'Konfigurer indstillinger for gendannelse';
$string['restore:createuser'] = 'Opret brugere under gendannelse';
$string['restore:restoreactivity'] = 'Gendan aktiviteter';
$string['restore:restorecourse'] = 'Gendan kurser';
$string['restore:restoresection'] = 'Gendan sektioner';
$string['restore:restoretargetimport'] = 'Gendan fra filer markeret som import';
$string['restore:rolldates'] = 'Tilladelse til at rulle aktivitetsdatoer for konfiguration ved gendannelse';
$string['restore:uploadfile'] = 'Upload filer til backup-mapper';
$string['restore:userinfo'] = 'Gendan brugerdata';
$string['restore:viewautomatedfilearea'] = 'Se området til automatiske backups';
$string['risks'] = 'Risici';
$string['role:assign'] = 'Tildel roller til brugere';
$string['role:manage'] = 'Opret og administrer roller';
$string['role:override'] = 'Tilsidesæt tilladelser for andre';
$string['role:review'] = 'Gennemgå tilladelser for andre';
$string['role:safeoverride'] = 'Tilsidesæt andres tilladelser';
$string['role:switchroles'] = 'Skift til andre roller';
$string['roleallowheader'] = 'Tillad rollen:';
$string['roleallowinfo'] = 'Vælg en rolle der skal tilføjes listen med tilladte roller i konteksten {$a->context}, beføjelse {$a->cap}:';
$string['roleassignments'] = 'Rolletildeling';
$string['roledefinitions'] = 'Rolledefinitioner';
$string['rolefullname'] = 'Rollenavn';
$string['roleincontext'] = '{$a->role} i {$a->context}';
$string['roleprohibitheader'] = 'Forbyd rollen';
$string['roleprohibitinfo'] = 'Vælg en rolle der skal tilføjes listen med forbudte roller i konteksten {$a->context}, beføjelse {$a->cap}:';
$string['rolerepreset'] = 'Brug rolleskabelon';
$string['roleresetdefaults'] = 'Standarder';
$string['roleresetrole'] = 'Brug rolle eller arketype';
$string['rolerisks'] = 'Rolle-risici';
$string['roles'] = 'Roller';
$string['roles_help'] = 'En rolle er en samling tilladelser defineret for hele systemet, som du kan tildele specifikke brugere i bestemte sammenhænge.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Vælg rolle';
$string['rolesforuser'] = 'Brugeren {$a}s roller';
$string['roleshortname'] = 'Kort navn';
$string['roleshortname_help'] = 'Kort navn for roller er et lavniveau identifikationsnavn hvortil kun alfanumeriske ASCII-tegn må bruges.';
$string['roletoassign'] = 'Roller der kan tildeles';
$string['roletooverride'] = 'Roller der kan tilsidesættes';
$string['safeoverridenotice'] = 'Bemærk: Beføjelser med højere risici er låst fordi du kun har tilladelse til at overskrive sikre beføjelser.';
$string['search:query'] = 'Udfør generelle søgninger på sitet';
$string['selectanotheruser'] = 'Vælg en anden bruger';
$string['selectauser'] = 'Vælg en bruger';
$string['selectrole'] = 'Vælg en rolle';
$string['showallroles'] = 'Vis alle roller';
$string['showthisuserspermissions'] = 'Vis denne brugers tilladelser';
$string['site:accessallgroups'] = 'Tilgå alle grupper';
$string['site:approvecourse'] = 'Godkend kursusoprettelse';
$string['site:backup'] = 'Tag backup af kurser';
$string['site:config'] = 'Rediger webstedets konfiguration';
$string['site:configview'] = 'Se siteadministrationstræet (men ikke alle siderne i det)';
$string['site:deleteanymessage'] = 'Slet alle beskeder på sitet';
$string['site:deleteownmessage'] = 'Slet beskeder sendt af og til brugeren';
$string['site:doanything'] = 'Må gøre alt';
$string['site:doclinks'] = 'Vis links til eksterne dokumenter';
$string['site:forcelanguage'] = 'Underkend kursussprog';
$string['site:import'] = 'Importer andre kurser til et kursus';
$string['site:maintenanceaccess'] = 'Tilgå sitet i vedligeholdelsestilstand';
$string['site:manageallmessaging'] = 'Tilføj, fjern, bloker og fjern blokering af kontakter for enhver bruger';
$string['site:manageblocks'] = 'Administrer sideblokke';
$string['site:managecontextlocks'] = 'Håndter nedfrysning af indhold';
$string['site:messageanyuser'] = 'Omgå brugerindstillinger vedrørende privatliv for at sende besked til brugere';
$string['site:mnetloginfromremote'] = 'Login fra en ekstern applikation via MNet';
$string['site:mnetlogintoremote'] = 'Roam til en anden installation via MNet';
$string['site:readallmessages'] = 'Læs alle beskeder på webstedet';
$string['site:restore'] = 'Genopret kurser fra backup';
$string['site:senderrormessage'] = 'Send en besked til supporteren fra fejlsiden';
$string['site:sendmessage'] = 'Send en besked til en vilkårlig bruger';
$string['site:trustcontent'] = 'Stol på afleveret indhold';
$string['site:uploadusers'] = 'Upload nye brugere fra en fil';
$string['site:viewanonymousevents'] = 'Få vist anonyme begivenheder i rapporter';
$string['site:viewfullnames'] = 'Se altid brugeres fulde navne';
$string['site:viewparticipants'] = 'Se deltagere';
$string['site:viewreports'] = 'Vis rapporter';
$string['site:viewuseridentity'] = 'Se hele brugeridentiteten på lister';
$string['siteadministrators'] = 'Webstedsadministratorer';
$string['tag:edit'] = 'Rediger eksisterende tag';
$string['tag:editblocks'] = 'Rediger blokke på tags-sider';
$string['tag:flag'] = 'Marker tags som upassende';
$string['tag:manage'] = 'Administrer alle tags';
$string['thisnewrole'] = 'Denne nye rolle';
$string['thisusersroles'] = 'Rolletildelinger';
$string['unassignarole'] = 'Fratag rollen {$a}';
$string['unassignconfirm'] = 'Bekræft at du vil fratage "{$a->user}" rollen "{$a->role}" ';
$string['unassignerror'] = 'Der opstod en fejl under fratagelse af rollen {$a->role} fra {$a->user}.';
$string['user:changeownpassword'] = 'Skift egen adgangskode';
$string['user:create'] = 'Opret brugere';
$string['user:delete'] = 'Slet brugere';
$string['user:editmessageprofile'] = 'Rediger brugers beskedprofil';
$string['user:editownmessageprofile'] = 'Rediger egen beskedprofil';
$string['user:editownprofile'] = 'Rediger egen brugerprofil';
$string['user:editprofile'] = 'Rediger brugerprofiler';
$string['user:ignoreuserquota'] = 'Ignorer kvotagrænse for bruger';
$string['user:loginas'] = 'Login som andre brugere';
$string['user:manageblocks'] = 'Administrer blokke på andre brugeres brugerprofil';
$string['user:manageownblocks'] = 'Administrer blokke på egen offentlig brugerprofil';
$string['user:manageownfiles'] = 'Håndter filer i eget filområde';
$string['user:managesyspages'] = 'Konfigurer standard sidelayout til offentlige brugerprofiler';
$string['user:readuserblogs'] = 'Se alle brugerblogge';
$string['user:readuserposts'] = 'Se alle brugerindlæg i fora';
$string['user:update'] = 'Opdater brugerprofiler';
$string['user:viewalldetails'] = 'Se komplet brugerinformation';
$string['user:viewdetails'] = 'Se brugerprofiler';
$string['user:viewhiddendetails'] = 'Se skjulte brugeroplysninger';
$string['user:viewlastip'] = 'Se brugerens seneste ip-adresse';
$string['user:viewuseractivitiesreport'] = 'Se brugeraktivitetsrapport';
$string['user:viewusergrades'] = 'Se karakterer';
$string['usersfrom'] = 'Brugere fra {$a}';
$string['usersfrommatching'] = 'Brugere fra {$a->contextname} der matcher "{$a->search}"';
$string['usersinthisx'] = 'Brugere i denne {$a}';
$string['usersinthisxmatching'] = 'Brugere i denne {$a->contexttype} der matcher "{$a->search}"';
$string['userswithrole'] = 'Alle brugere med en rolle';
$string['userswiththisrole'] = 'Brugere med rollen';
$string['useshowadvancedtochange'] = 'Brug "Vis avanceret" for at ændre';
$string['viewingdefinitionofrolex'] = 'Viser definitionen af rollen "{$a}"';
$string['viewrole'] = 'Se rolledetaljer';
$string['webservice:createmobiletoken'] = 'Opret en webservice-token til mobil adgang';
$string['webservice:createtoken'] = 'Opret en webservice-token';
$string['webservice:managealltokens'] = 'Håndter alle brugeres webservice-tokens';
$string['whydoesuserhavecap'] = 'Hvorfor har {$a->fullname} beføjelsen {$a->capability} i konteksten {$a->context}?';
$string['whydoesusernothavecap'] = 'Hvorfor har {$a->fullname} ikke beføjelsen {$a->capability} i konteksten {$a->context}?';
$string['xroleassignments'] = '{$a}\'s rolletildelinger';
$string['xuserswiththerole'] = 'Brugere med rollen "{$a->role}"';
