<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_formulas', language 'af', version '4.3'.
 *
 * @package     qtype_formulas
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abserror'] = 'Absolute fout';
$string['addmorepartsblanks'] = 'Blanko\'s vir {no} meer dele';
$string['algebraic_formula'] = 'Algebraïese formule';
$string['answer'] = 'Antwoord*';
$string['answer_help'] = '**Vereis**.
moet \'n lys nommers of \'n lys stringe wees, afhangende watter vraagtipe gekies is. Waar daar slegs een antwoord is, kan \'n getal of string direk ingevoer word. Let asseblief daarop dat die aantal elemente in die lys die aantal antwoordvelde vir hierdie gedeelte definieer.

<pre class="prettyprint">123<br>[1, 0, 0, 1]<br>a<br>[1, a, b]<br>"exp(-a t)"<br>["vx t","vy t - 0.5 a t^2"]</pre>';
$string['answercombinedunitmulti'] = 'Antwoord en eenheid vir deel {$a->part}';
$string['answercombinedunitsingle'] = 'Antwoord en eenheid';
$string['answercoordinatemulti'] = 'Antwoord vir deel {$a->part} en koördinaat {$a->numanswer}';
$string['answercoordinatesingle'] = 'Antwoord vir koördinaat {$a->numanswer}';
$string['answermark'] = 'Gedeelte se punt*';
$string['answermark_help'] = '**Vereis**.
Die punt vir die antwoord van hierdie deel, wat \'n getal groter as 0 behoort te wees. Die verstek punt van die hele vraag is die som van al die deelpunte.

Let wel: As hierdie deel se puntveld leeg gelaat word, sal die deel uitgewis word wanneer die vraag geberg word.';
$string['answermulti'] = 'Antwoord vir deel {$a->part}';
$string['answerno'] = 'Deel {$a}';
$string['answersingle'] = 'Antwoord';
$string['answertype'] = 'Antwoordtipe';
$string['answertype_help'] = 'Daar is vier antwoordtipes.

Getal, numeries en numeriese formule vereis \'n getal of \'n lys van getalle as antwoord.

Algebraïese formule-antwoorde vereis \'n string of lys stringe as antwoord.

Verskillende antwoordtipes sal verskillende beperkings op die invoer van antwoorde plaas, dus sal studente moet weet hoe om dit in te voer. Die formaatkontrole in die vraagkode sal hulle ook wanneer hulle tik inlig dat iets fout is. Lees asseblief die dokumentasie vir besonderhede.';
$string['answertype_link'] = 'https://moodleformulas.org/';
$string['answerunitmulti'] = 'Eenheid vir deel {$a->part}';
$string['answerunitsingle'] = 'Eenheid';
$string['checkvarshdr'] = 'Kontroleer instelling van veranderlikes';
$string['choiceno'] = 'Nee';
$string['choiceyes'] = 'Ja';
$string['commonsiunit'] = 'Algemene SI-eenheid';
$string['correctansweris'] = 'Een moontlike korrekte antwoord is: {$a}';
$string['correctfeedback'] = 'Vir enige korrekte antwoord';
$string['correctfeedback_help'] = 'Hierdie terugvoer sal vertoon word aan studente wat die maksimum punt teen hierdie gedeelte verkry het. Dit kan globale en plaaslike veranderlikes insluit wat deur hul waardes vervang sal word.';
$string['correctness'] = 'Merkkriterium*';
$string['correctness_help'] = '**Vereis**. Jy kan óf relatiewe fout óf absolute fout met die foutvestek kies. Relatiewe fout kan nie vir algebraïese antwoordtipe gebruik word nie.

Vir die presiese definisie van die relatiewe en absolute fout wanneer daar meer as een antwoordveld is, sien dokumentasie.';
$string['correctness_link'] = 'https://moodleformulas.org/';
$string['correctnessexpert'] = 'Kenner';
$string['correctnesssimple'] = 'Eenvoudig';
$string['defaultanswermark'] = 'Verstek deel se punt';
$string['defaultanswermark_desc'] = 'Verstek deel se punt vir nuwe vraag se dele';
$string['defaultanswertype'] = 'Verstek antwoordtipe';
$string['defaultanswertype_desc'] = 'Verstek antwoordtipe vir nuwe vraag se dele';
$string['defaultcorrectness'] = 'Verstek merkkriteria';
$string['defaultcorrectness_desc'] = 'Verstek merkkriteria vir nuwe vraag se dele';
$string['defaultunitpenalty'] = 'Verstek eenheidstraftoekenning';
$string['defaultunitpenalty_desc'] = 'Verstek straftoekenning vir verkeerde eenheid (0-1)';
$string['error_algebraic_var'] = 'Sintaksisfout by die definiëring van algebraïese veranderlike.';
$string['error_answer_missing'] = 'Geen antwoord is gedefinieer nie.';
$string['error_answerbox_duplicate'] = 'Elke antwoordveld-plekhouer kan slegs een maal in \'n deel gebruik word.';
$string['error_answertype_mistmatch'] = 'Antwoordtipe pas nie: Numeriese antwoordtipe vereis getal en algebraïese antwoordtipe vereis string.';
$string['error_criterion'] = 'Die merkkriterium moet tot \'n enkele getal geëvalueer word.';
$string['error_eval_numerical'] = 'Sommige uitdrukkings kan nie numeries geëvalueer word nie.';
$string['error_fixed_range'] = 'Sintaksisfout van \'n vaste reeks.';
$string['error_forbid_char'] = 'Formule of uitdrukking bevat verbode karakters of operateurs.';
$string['error_forloop'] = 'Sintaksisfout van die for-lus.';
$string['error_forloop_expression'] = 'Uitdrukking van die for-lus moet \'n lys wees.';
$string['error_forloop_var'] = 'Veranderlike van die for-lus bevat \'n aantal foute.';
$string['error_func_param'] = 'Verkeerde getal of verkeerde tipe parameters vir die funksie {$a}()';
$string['error_mark'] = 'Die antwoordpunt moet \'n waarde groter as 0 neem.';
$string['error_no_answer'] = 'Minstens een antwoord word vereis.';
$string['error_placeholder_format'] = 'Verkeerde plekhouer se formaat of verbode karakters.';
$string['error_placeholder_main_duplicate'] = 'Gedupliseerde plekhouer in die hoofvraagteks.';
$string['error_placeholder_missing'] = 'Hierdie plekhouer ontbreek uit die hoofvraagteks.';
$string['error_placeholder_sub_duplicate'] = 'Hierdie plekhouer is reeds in \'n ander deel gedefinieer.';
$string['error_placeholder_too_long'] = 'Die plekhouer se lengte word beperk tot 40 karakters.';
$string['error_randvars_set_size'] = 'Die aantal genereerbare elemente in die versameling moet groter as 1 wees.';
$string['error_randvars_type'] = 'Alle elemente in die stel moet presies dieselfde tipe en grootte hê.';
$string['error_rule'] = 'Reëlontledingsfout!';
$string['error_ruleid'] = 'Geen so \'n reël bestaan in die dokument met die id/naam nie.';
$string['error_subexpression_empty'] = '\'n Subuitdrukking is leeg.';
$string['error_syntax'] = 'Sintaksisfout.';
$string['error_unit'] = 'Eenheidontledingsfout!';
$string['error_unitpenalty'] = 'Die straftoekenning moet \'n getal tussen 0 en 1 wees.';
$string['error_validation_eval'] = 'Pogingevaluasiefout!';
$string['error_vars_array_index_nonnumeric'] = 'Nienumeriese waarde kan nie as lysindeks gebruik word nie.';
$string['error_vars_array_index_out_of_range'] = 'Lysindeks is buite bestek!';
$string['error_vars_array_size'] = 'Grootte van lys moet binne 1 tot 1000 wees.';
$string['error_vars_array_type'] = 'Element in dieselfde lys moet dieselfde tipe wees, hetsy \'n getal of \'n string.';
$string['error_vars_array_unsubscriptable'] = 'Veranderlike is onskryfbaar.';
$string['error_vars_bracket_mismatch'] = 'Hakies pas nie by mekaar nie.';
$string['error_vars_end_separator'] = '\'n Opdragskeier aan die einde ontbreek.';
$string['error_vars_name'] = 'Die sintaksis met die veranderlikenaam is verkeerd.';
$string['error_vars_reserved'] = 'Funksie {$a}() is gereserveer en kan nie as veranderlike gebruik word nie.';
$string['error_vars_string'] = 'Fout! Hetsy \'n string sonder om dubbele aanhaling te sluit, of die gebruik van nieaanvaarde karakter soos \'.';
$string['error_vars_undefined'] = 'Veranderlike \'{$a}\' is nie gedefinieer nie.';
$string['feedback'] = 'Deel algemene terugvoer';
$string['feedback_help'] = 'Hierdie deelterugvoer sal aan alle studente vertoon word. Dit kan globale en plaaslike veranderlikes insluit wat deur hul waardes vervang sal word.';
$string['functiontakesatleasttwo'] = 'Die funksie {$a} moet minstens twee argumente hê';
$string['functiontakesnoargs'] = 'Die funksie {$a} neem geen argumente nie';
$string['functiontakesonearg'] = 'Die funksie {$a} moet presies een argument hê';
$string['functiontakesoneortwoargs'] = 'Die funksie {$a} moet een of twee argumente hê';
$string['functiontakestwoargs'] = 'Die funksie {$a} moet presies twee argumente hê';
$string['globalvarshdr'] = 'Veranderlikes';
$string['illegalformulasyntax'] = 'Onwettige formulesintaksis beginnende met \'{$a}\'';
$string['incorrectfeedback'] = 'Vir enige verkeerde antwoord';
$string['incorrectfeedback_help'] = 'Hierde terugvoer sal aan studente vertoon word wat geen punt op hierdie gedeelte verkry nie. Dit kan globale en plaaslike veranderlikes insluit wat deur hul waardes vervang sal word.';
$string['instantiate'] = 'Instansieer';
$string['mainq'] = 'Hoofvraag';
$string['modelanswer'] = 'Modelvraag';
$string['none'] = 'Geen';
$string['number'] = 'Getal';
$string['number_unit'] = 'Getal en eenheid';
$string['numdataset'] = 'Getal van datastel';
$string['numeric'] = 'Numeries';
$string['numeric_unit'] = 'Numeries en eenheid';
$string['numerical_formula'] = 'Numeriese formule';
$string['numerical_formula_unit'] = 'Numeriese formule en eenheid';
$string['otherrule'] = 'Ander reëls';
$string['otherrule_help'] = 'Hier kan die vraagouteur addisionele omskakelingsreëls vir ander aanvaarde basiseenhede definieer. Sien dokumentasie vir die gevorderde gebruike.';
$string['partiallycorrectfeedback'] = 'Vir enige gedeeltelik korrekte antwoord';
$string['partiallycorrectfeedback_help'] = 'Hierdie terugvoer sal aan studente vertoon word wat nie die maksimum punt op hierdie deel verkry nie. Dit kan globale en plaaslike veranderlikes insluit wat deur hul waardes vervang sal word.';
$string['placeholder'] = 'Plekhouernaam';
$string['placeholder_help'] = '\'n Plekhouer word gebruik om die posisie in die hoofvraagteks te identifiseer wat deur die inhoud van die deel vervang sal word. Dit is \'n string alafanumeriese karakters, voorafgegaan deur \'**#**\', soos #1, #2a, #2b and #A.

As hierdie veld leeg gelaat word, sal die deel aan die einde van die hoofvraagteks bygevoeg word.';
$string['pleaseputananswer'] = 'Plaas asseblief \'n antwoord in elke veld.';
$string['pluginname'] = 'Formules';
$string['pluginname_help'] = 'Om hierdie vraag te begin gebruik, gaan asseblief na <a href="https://moodleformulas.org/">moodleformulas.org</a>

Vir moontlike vrae, gaan asseblief na <a href="https://moodleformulas.org/">moodleformulas.org</a>.

Vir die opsies in die wysigingsvorm hieronder, gaan asseblief na <a href="https://moodleformulas.org/">moodleformulas.org</a>.

Vir die volledige dokumentasie, gaan asseblief na <a href="https://moodleformulas.org/">moodleformulas.org</a>.';
$string['pluginname_link'] = 'question/type/formulas';
$string['pluginnameadding'] = '\'n Formulevraag word bygevoeg';
$string['pluginnameediting'] = '\'n Formulevraag word gewysig';
$string['pluginnamesummary'] = 'Vraagtipe met lukrake waardes en veelvoudige antwoorde
Die antwoordvelde kan op enige plek vervang word, sodat ons vrae kan skep wat verskeie strukture behels, soos vektors, polinomiale en matriks.
Ander funksies soos eenheidkontrole en veelvoudige deelvrae word ook nou geïntegreer en is maklik om te gebruik.';
$string['postunit'] = 'Eenheid';
$string['postunit_help'] = 'Jy kan die eenheid hier spesifiseer. Die vraagtipe is spesifieke ontwerp vir SI-eenheid, dus sal \'n oop spasie die \'produk\' van \'n ander \'basiseenheid\' voorstel en <tt> ^ </tt> word vir eksponente gebruik.
Ook kan <tt> / </tt> vir omgekeerde eksponent gebruik word. Enige permutasie van die basiseenheid word dieselfde hanteer.

Daar word van studente vereis om dieselfde invoerformaat te gebruik, byvoorbeeld:

<pre class="prettyprint">1 m<br>0.1 m^2<br>20 m s^(-1)<br>400 kg m/s<br>100 kW</pre>';
$string['privacy:metadata'] = 'Die invoegtoepassing van Formules vraagtipe berg geen persoonlike data nie.';
$string['qtextpreview'] = 'Vooruitskou deur datastel te gebruik';
$string['questiontext'] = 'Vraagteks';
$string['questiontext_help'] = 'Bykomend tot die normale vraagteks, kan jy ook globale veranderlikes en plekhouers hier gebruik.

Globale veranderlikes sal deur hul waardes vervang word en plekhouers sal deur dele vervang word.
\'n Eenvoudige voorbeeld met veranderlikes <tt> A, B, C </tt> en plekhouers <tt> #1, #2, #3 </tt> is:

<pre class="prettyprint">Wat is die resultaat van {A} + {B}?<br>{#1}<br>Wat is die resultaat van {A} - {B}?<br>{#2}<br>Wat is die resultaat van {C} / {B}?<br>{#3}</pre>';
$string['relerror'] = 'Relatiewe fout';
$string['renew'] = 'Bywerking';
$string['ruleid'] = 'Basiese omskakelingsreëls';
$string['ruleid_help'] = 'Hierdie vraagtipe het \'n ingeboude omskakelingstelsel en beskik oor basiese omskakelingsreëls.

Die basiese een is die "Algemene SI-eenheid" reëls wat standaard eenhede sal omskakel, soos die eenheid vir lengte, bv. km, m, cm en mm. Hierdie opsie het geen effek as geen eenheid gebruik is nie.';
$string['settingusepopup'] = 'Gebruik nutswenke';
$string['settingusepopup_desc'] = 'Vertoon korrekte antwoord en terugvoer in \'n nutswenk';
$string['subqoptions'] = 'Ekstra opsies';
$string['subqtext'] = 'Deel se teks';
$string['subqtext_help'] = 'Deelteks en antwoordveldplekke kan hier gespesifiseer word. Die plekhouers wat gebruik kan word om antwoordveldplekke te spesifiseer, is:

<pre class="prettyprint">{_0}<br>{_1}<br>{_2}<br>...<br>{_u}</pre>

Die <tt> {_0}, {_1}, {_2} </tt> is die invoervelde vir koördinate en <tt> {_u} </tt> is die invoerveld vir eenheid.

Alle ontbrekende velde word outomaties aan die einde van die deel se teks gevoeg. \'n Spesiale geval is dat as <tt> {_0}, {_u} </tt> opeenvolgend gespesifiseer word, en daar slegs een koördinaat en eenheid is, d.w.s <tt> {_0}{_u} </tt>, dit in \'n enkele, lang invoerantwoordveld vir beide antwoord en eenheid gekombineer sal word.';
$string['unit'] = 'Eenheid';
$string['unitpenalty'] = 'Aftrekking vir verkeerde eenheid (0-1)*';
$string['unitpenalty_help'] = 'Hierdie opsie spesifiseer die punt waarmee jy die student vir \'n verkeerde eenheid wil penaliseer.

Dit neem waarde tussen 0 en 1. As dit waarde 1 neem, moet die eenheid en antwoord tegelykertyd korrek wees om \'n punt te kan kry. D.w.s. die eenheid en antwoord word as een entiteit behandel. Aan die ander kant, as dit waarde 0 neem, kan studente vir slegs korrekte antwoord volpunt kry, alle lukrake string sal geen effek aan die einde van die antwoord hê nie.

Derhalwe word dit aanbeveel om waarde 1 te gebruik wanneer die antwoord geen geassosieerde eenheid het nie.';
$string['unsupportedformulafunction'] = 'Die funksie {$a} word nie ondersteun nie';
$string['vars1'] = 'Plaaslike veranderlikes';
$string['vars1_help'] = 'Jy kan veranderlikes hier definieer op dieselfde manier wat globale veranderlikes op die vraagvlak gedefinieer word. Veranderlikes wat hier gedefinieer word, kan in die deel se antwoord of terugvoer gebruik word en hul bestek van sigbaarheid is beperk tot die deel.';
$string['vars2'] = 'Graderingsveranderlikes';
$string['vars2_help'] = 'Alle plaaslike veranderlikes en die student se antwoorde kan hier gebruik word. Sien dokumentasie vir gevorderde gebruike.';
$string['vars2_link'] = 'https://moodleformulas.org/';
$string['varsdata'] = 'Geïnstansieerde datastel';
$string['varsglobal'] = 'Globale veranderlikes';
$string['varsglobal_help'] = 'Formules kan hier gespesifiseer word om die geïnstansieerde lukrake veranderlikes te manipuleer (alle lukrake veranderlikes is hier beskikbaar). Die volledige lys wiskundige funksies en operateurs word in die dokumentasie verskaf.

<pre class="prettyprint">a = 1.11111;<br>b = exp(3);<br>c = A + a + b;<br>d = sin(1.5*pi()) + c;<br>e = round(a, 0);<br>f = [0,1,2,3][A];<br>g = ["zero","one","two","three"][A];<br>distance = sqrt(a*a + b*b);</pre>';
$string['varsglobal_link'] = 'https://moodleformulas.org/';
$string['varsrandom'] = 'Lukrake veranderlikes';
$string['varsrandom_help'] = 'Nuwe lukrake waardes word vir hierdie veranderlikes aan die begin van elke poging gegenereer. Dit kan gedoen word deur \'n stel elemente om uit te kies, te definieer:

<pre class="prettyprint">A = {1,2,3};<br>C = {[1,-1], [2,-2], [3,-3]};<br>E = {10:100:10, 100, 1000};</pre>

Die elemente kan getalle, stringe, of lyste daarvan wees. Aan die begin van \'n nuwe poging sal een element uit die stel getrek word en aan die veranderlike op linkerhand toegeken word. Ook: vir \'n stel nommer, kan jy die reeksnotasie gebruik, soos 10:100:10 (sien voorbeeld E hierbo).</p>';
$string['varsrandom_link'] = 'https://moodleformulas.org/';
$string['varsstatistics'] = 'Statistieke';
$string['yougotnright'] = 'Jy het {$a->num} deel/dele van hierdie vraag korrek beantwoord.';
