<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'af', version '4.3'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Agtergrondkleur';
$string['background_color_black'] = 'Swart Tema {$a}';
$string['background_color_blue'] = 'Blou Tema {$a}';
$string['background_color_default'] = 'Standaard Tema {$a}';
$string['background_color_desc'] = 'Kleur van sprite!';
$string['background_color_green'] = 'Groen Tema {$a}';
$string['background_color_random'] = 'Lukrake Tema {$a}';
$string['background_color_red'] = 'Rooi Tema {$a}';
$string['background_text_color'] = 'Teks kleur';
$string['background_text_color_desc'] = 'Bokant en Voetnoot Teks kleur!';
$string['choosereadme'] = 'Degrade is \'n tema wat met sorg ontwerp is om vrolike kleure na Moodle te bring.';
$string['contact_address'] = 'Adres';
$string['contact_email'] = 'E-pos';
$string['contact_phone'] = 'Telefoonnommer';
$string['content_pagefonts'] = 'Ekstra Google Fonts';
$string['content_pagefonts_desc'] = 'Voeg hierdie @import skakel van Google by vir ekstra fonts.<br>Jy kan veelvuldige invoer plaas.<br><a href="https://fonts.google.com/selection/embed" target="google">Insluit-kode</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle se Standaard';
$string['content_type_empty'] = '(Geen inhoud)';
$string['content_type_footer'] = 'Inhoudstipe vir die voetnoot';
$string['content_type_footer_desc'] = 'Kies die tipe inhoud wat jy in die voetnoot wil vertoon.';
$string['content_type_home'] = 'Inhoudstipe vir die tuisblad';
$string['content_type_home_desc'] = 'Kies die tipe inhoud wat jy op die tuisblad wil vertoon.';
$string['content_type_html'] = 'Bladsy om te skep met redigeerder';
$string['continuar'] = 'Voortgaan met studeer';
$string['countlesson'] = '{$a} les';
$string['countlessons'] = '{$a} lesse';
$string['course_access'] = 'Toegang tot die kursus';
$string['course_moore'] = 'Meer besonderhede';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcss_desc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['custommenuitems'] = 'Aangepaste Bo-menumekanismes';
$string['custommenuitems_desc'] = 'Jy kan \'n aangepaste menu saam met die boonste menumekanismes skep. Die hoofmenu moet begin met die kant, en submenu\'s moet deur \'n koppelteken (-) voorafgegaan word. Die aantal koppeltekens bepaal die itemdiepte. Dus verskyn items met \'n enkele koppelteken in \'n submenu onder die vorige boonste-vlak-item, en items met twee koppeltekens verskyn in \'n submenu onder die voorafgaande submenu.
Die inhoud van elke menupunt moet bestaan uit tot drie elemente (<strong>etiket</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>taal</strong>), elk geskei deur die "|" karakter.
<ul>
<li><strong>etiket</strong>: Dit is die teks wat binne die menupunt vertoon sal word. Jy moet \'n etiket spesifiseer vir elke menupunt.</li>
<li><strong>url</strong>: Dit is die URL waarna die gebruiker geneem sal word as hy die menupunt kliek. Dit is opsioneel; as dit nie verskaf word nie, sal die item nie na enige plek gekoppel word nie.<br>
Ander eienskappe soos "teiken" kan aan die einde van die URL gevoeg word.</li>
<li><strong>tooltip</strong>: As jy \'n URL voorsien, kan jy ook kies om \'n tooltip vir die skakel wat met die URL geskep is, te voorsien. Dit is opsioneel, en as dit nie gedefinieer word nie, word die etiket as die tooltip vir die menupunt gebruik.</li>
<li><strong>taal</strong>: Jy kan \'n taalkode (of \'n komma-geskeide lys van kodes) as die vierde element van die lyn byvoeg. Die lyn sal slegs vertoon word as die gebruiker die gelysde taal (s) gekies het.</li>
</ul>
Hieronder is \'n voorbeeld van hoe jy \'n aangepaste menu sou skep:
<blockquote><pre>
Kursusse
-Alle kursusse | /kursus/
-My kursusse
--Voorbeeldkursus
---Voorbeeldkursus 7 | /kursus/view.php?id=7
---Voorbeeldkursus 9 | /kursus/view.php?id=9
--Toetskursus
---Toetskursus 2 | /kursus/view.php?id=2
---Toetskursus 5 | /kursus/view.php?id=5
Google
-Google in enige taal | https://google.com/" target="_blank
-Google in Meksiko | https://www.google.com.mx/" target="_blank|Google-etiket|en
-Google in Portugees | https://google.com.br/" target="_blank|Google-etiket|pt,pt_br,pt_br_kids
Ondersteuningsbladsy | https://ondersteuning.com/" target="_blank
</pre></blockquote>
Vir Moodle met ondersteuning vir veelvuldige tale, moet die <strong>etiket</strong> waarde geformateer word as <strong>"taalstringnaam,komponentnaam"</strong>.
<blockquote><pre>
profiel,moodle | /gebruiker/profiel.php
boodskappe,boodskap | /boodskap/indeks.php
</pre></blockquote>
<a href="https://dokumentasie.moodle.org/404/af/Gevorderde_tema-instellings" target="_blank">Meer inligting oor die menu</a>';
$string['editor_link_footer'] = 'Redigeer die voetnootblok vir die taal {$a}';
$string['editor_link_footer_all'] = 'Redigeer die voetnootblok vir alle tale';
$string['editor_link_home'] = 'Redigeer die tuisblad vir die taal {$a}';
$string['editor_link_home_all'] = 'Redigeer die tuisblad vir alle tale';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Verander die Favicon van die tema. \'n .png-prent met deursigtige agtergrond en hoogte van 32 px sal die beste werk.';
$string['fontfamily'] = 'Webwerflettertipe';
$string['fontfamily_desc'] = 'Kies watter lettertipe jy wil gebruik in jou Moodle';
$string['fontfamily_menus'] = 'Kies watter lettertipe jy wil gebruik vir kieslys op jou Moodle-webwerf.';
$string['fontfamily_menus_desc'] = 'Kies watter lettertipe jy wil gebruik vir kieslys op jou Moodle-webwerf.';
$string['fontfamily_sitename'] = 'Lettertipe vir die webwerfnaam';
$string['fontfamily_sitename_desc'] = 'Die lettertipe wat toegepas sal word op die webwerfnaam as \'n logo nie verskaf word nie.';
$string['fontfamily_title'] = 'Titel Teks Fonts';
$string['fontfamily_title_desc'] = 'Kies watter lettertipe jy wil gebruik vir titels op jou Moodle-webwerf.';
$string['fontpreview'] = 'Lettertipe Lys Voorbeeld';
$string['footer_contact_title'] = 'Titel van die Kontakblok';
$string['footer_contact_title_default'] = 'Kontak Ons';
$string['footer_contact_title_desc'] = 'Voer die titel van die blok in wat in die voet met jou kontakinligting vertoon sal word.';
$string['footer_description'] = 'Beskrywing';
$string['footer_description_desc'] = 'Beskryf jou Moodle, wat jy doen, en hierdie inligting sal onder die logo in die voet van Moodle vertoon word';
$string['footer_frontpage_blockcourses_instructor'] = 'Wys die naam van die Onderwyser';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'As gemerk, toon dit die name van die onderwysers in die lys van kursusse!';
$string['footer_frontpage_blockcourses_text'] = 'Kort teks wat die blok "{$a}" verduidelik';
$string['footer_frontpage_blockcourses_text_desc'] = 'Voeg \'n teks by wat van "{$a}" handel!';
$string['footer_links_title'] = 'Titel van die Skakelblok';
$string['footer_links_title_default'] = 'Belangrike skakels';
$string['footer_show_copywriter'] = 'Wys die Gemaak met ❤️';
$string['footer_show_copywriter_desc'] = 'Deselecteer as jy die "Gemaak met ❤️" wil wegsteek';
$string['footer_social_title'] = 'Titel van die Sosiale Blok';
$string['footer_social_title_default'] = 'Volg ons op sosiale media';
$string['footer_social_title_desc'] = 'Voer die titel van die blok in wat in die voet met jou sosiale mediainligting vertoon sal word.';
$string['footerblink'] = 'Skakels van die Voetblok';
$string['footerblink_desc'] = 'Jy kan \'n Voetblok Skakels hier instel om deur temas vertoon te word. <br>Elke lyn bestaan uit \'n bietjie menu- of taalsleutelteks, \'n skakel-URL (opsioneel), geskei deur vertikale strepies. Byvoorbeeld:<br><pre>Moodle-ondersteuning|https://moodle.org/ondersteuning</pre>';
$string['footerblock_contact'] = 'Kontakblok';
$string['footerblock_copywriter'] = 'Gemaak met ❤️';
$string['footerblock_description'] = 'Beskrywingsblok';
$string['footerblock_links'] = 'Skakelblok';
$string['footerblock_social'] = 'Sosiale Blok';
$string['free_name'] = 'Gratis';
$string['frontpage_about_description'] = 'Beskryf wat julle doen';
$string['frontpage_about_description_desc'] = 'Beskryf in hoogstens 5 lyne wat die doel van jou Moodle is';
$string['frontpage_about_enable'] = 'Skakel About blok in';
$string['frontpage_about_enable_desc'] = 'Indien gemerk, sal die About blok onder die Bander verskyn!';
$string['frontpage_about_info'] = 'Data blok {$a}';
$string['frontpage_about_logo'] = 'Verskeie logo om hier te vertoon';
$string['frontpage_about_logo_desc'] = 'Indien gedefinieer, sal hierdie logo hier gebruik word, in plaas van die Bander se logo.<br>
Leeg gebruik die Bander se logo!';
$string['frontpage_about_number'] = 'Hoeveelheid data';
$string['frontpage_about_number_desc'] = 'Plaas hier die hoeveelheid inligting hierbo genoem';
$string['frontpage_about_text'] = 'Naam van die data';
$string['frontpage_about_text_1_defalt'] = 'Kursusse';
$string['frontpage_about_text_2_defalt'] = 'Onderwysers';
$string['frontpage_about_text_3_defalt'] = 'Studente';
$string['frontpage_about_text_4_defalt'] = 'Lesse';
$string['frontpage_about_text_desc'] = 'Plaas hier die naam van die data wat op die Tuisblad vertoon sal word';
$string['frontpage_about_title'] = 'Titel van About blok';
$string['frontpage_about_title_default'] = 'Ons Wêreldwye Gemeenskap';
$string['heart'] = 'As jy van hierdie tema hou, moenie vergeet om op ❤️ te klik op die thema-bladsy <a href="{$a}" target="_blank">deur hier te klik</a>';
$string['instructor'] = 'Onderwyser';
$string['login_backgroundcolor'] = 'Agtergrondkleur';
$string['login_backgroundcolor_desc'] = 'Kies die agtergrondkleur van die wagwoordherstelbladsy';
$string['login_backgroundfoto'] = 'Agtergrondbeeld';
$string['login_backgroundfoto_desc'] = 'Kies die agtergrondbeeld vir die Aanmeld/Herstel wagwoord/Skep rekening. Standaard beeld is: {$a}';
$string['login_forgot_description'] = 'Teks aan die kant van die Wagwoord Herstel-skerm';
$string['login_forgot_description_desc'] = 'Teks wat net op die Wagwoord Herstel-skerm verskyn';
$string['login_login_description'] = 'Teks aan die kant van die Aanmeldskerm';
$string['login_login_description_desc'] = 'Teks wat net op die Aanmeldskerm verskyn';
$string['login_signup_description'] = 'Teks aan die kant van die Skep Rekening-skerm';
$string['login_signup_description_desc'] = 'Teks wat net op die Skep Rekening-skerm verskyn';
$string['login_theme'] = 'Aanmeldskermtema';
$string['login_theme_block'] = 'Wit blok in die middel met opsionele agtergrond';
$string['login_theme_desc'] = 'Kies watter tema jy wil hê in die aanmeldskerm';
$string['login_theme_image_login'] = 'Agtergrondbeeld en aanmelding aan die kant';
$string['login_theme_imagetext_login'] = 'Agtergrondbeeld, teks bo-op die beeld en aanmelding aan die kant';
$string['login_theme_login'] = 'Net aanmeldingskerm, sonder beeld aan die kant';
$string['logo_color'] = 'Gekleurde Logo';
$string['logo_color_desc'] = 'Laai asseblief jou GEKLEURDE LOGO op as jy dit in die Bander wil insluit. Hierdie logo sal vertoon word as die bladsy afrol, en die kieslys sal op \'n wit agtergrond vertoon word.';
$string['logo_write'] = 'Wit Logo';
$string['logo_write_desc'] = 'Laai asseblief jou WIT LOGO op as jy dit in die Bander wil insluit. Hierdie logo sal vertoon word as die bladsy bo-aan bly, en die kieslys sal op \'n gekleurde agtergrond vertoon word.';
$string['matricular'] = 'Registreer';
$string['mycourses_color'] = 'Blok Agtergrondkleur';
$string['mycourses_color_desc'] = 'Die agtergrondkleur vir die blok.';
$string['mycourses_icon'] = 'Ikon';
$string['mycourses_icon_desc'] = '\'n Verteenwoordigende ikon vir die blok. Ikon grootte moet 48x48 piksels wees.';
$string['mycourses_info'] = 'Blok {$a}';
$string['mycourses_numblocos'] = 'Geen blokke';
$string['mycourses_numblocos_desc'] = 'Hoeveel beelde wil jy in die SlideShow hê?';
$string['mycourses_numblocos_nenhum'] = 'Geen skyfies op die tuisblad nie';
$string['mycourses_title'] = 'Kort Blok Titel';
$string['mycourses_title_desc'] = '\'n Kort en beskrywende titel vir die blok.';
$string['mycourses_url'] = 'Blok Skakel';
$string['mycourses_url_desc'] = 'Die URL na waar jy sal navigeer wanneer jy op die blok klik. Dit kan \'n eksterne skakel wees of \'n interne skakel binne die platform.';
$string['pluginname'] = 'Afgradeer';
$string['privacy:metadata'] = 'Die Degrade tema stoor geen persoonlike data oor enige gebruiker nie.';
$string['settings_about_heading'] = 'Oor jou Moodle';
$string['settings_css_heading'] = 'Fonts en CSS';
$string['settings_footer_heading'] = 'Voetblok';
$string['settings_icons_change_icons'] = 'Verander die verstek-ikoon in die lys van kursusse';
$string['settings_login_heading'] = 'Aanmeldskerm';
$string['settings_mycourses_heading'] = 'My Kursusse Blokke';
$string['settings_slideshow_heading'] = 'SlideShow';
$string['settings_theme_heading'] = 'Tema en CSS';
$string['settings_top_heading'] = 'Bander';
$string['sitefonts'] = 'Bykomende Google Fonts';
$string['sitefonts_desc'] = 'Voeg die @import kode van Google Fonts in soos aangedui in die beeld hieronder. Na die stoor sal die "Site Font" veld opgedateer word, wat hierdie fonts sal vertoon. Jy kan veelvuldige @import voeg soos nodig.';
$string['slidecaption_desc'] = 'Voer die teks van die onderskrif in wat op die skyf gebruik moet word';
$string['slideshow_image'] = 'Slide Beeld';
$string['slideshow_image_desc'] = 'Die beeld moet 1250px X 400px wees.';
$string['slideshow_info'] = 'Slide {$a}';
$string['slideshow_numslides'] = 'Hoeveel beelde in SlideShow';
$string['slideshow_numslides_desc'] = 'Hoeveel beelde wil jy in die SlideShow hê?';
$string['slideshow_numslides_nenhum'] = 'Geen skyf op die Tuisblad';
$string['slideshow_text'] = 'Kort beskrywende teks van Slide';
$string['slideshow_text_desc'] = 'Voer \'n kort teks in oor die slide.';
$string['slideshow_url'] = 'Skakel van skyfknoppies';
$string['slideshow_url_desc'] = 'Voer die doel van die skakel van die beeld skyf in';
$string['social_facebook'] = 'Jou Facebook';
$string['social_facebook_desc'] = 'Die URL van jou organisasie se Facebook-bladsy.';
$string['social_instagram'] = 'Jou Instagram';
$string['social_instagram_desc'] = 'Die URL van jou organisasie se Instagram-rekening.';
$string['social_linkedin'] = 'Jou Linkedin';
$string['social_linkedin_desc'] = 'Die URL van jou organisasie se Linkedin-profiel.';
$string['social_twitter'] = 'Jou Twitter';
$string['social_twitter_desc'] = 'Die URL van jou organisasie se Twitter-rekening.';
$string['social_youtube'] = 'Jou Youtube';
$string['social_youtube_desc'] = 'Die URL van jou organisasie se Youtube-kanaal.';
$string['theme_color-color_buttons'] = 'Knoppiekleur';
$string['theme_color-color_buttons_desc'] = 'Die kleur wat vir die knoppies gebruik word, wat visuele samehang gee en interaktiewe aksies beklemtoon.';
$string['theme_color-color_names'] = 'Naamkleur';
$string['theme_color-color_names_desc'] = 'Die kleur wat gebruik word om name of identifiseerders te beklemtoon, wat duidelikheid en klem gee aan spesifieke teksinligting.';
$string['theme_color-color_primary'] = 'Primêre Kleur';
$string['theme_color-color_primary_desc'] = 'Die primêre hoofkleur van die tema, gewoonlik gebruik vir beklemtoonde elemente en klem.';
$string['theme_color-color_secondary'] = 'Sekondêre Kleur';
$string['theme_color-color_secondary_desc'] = '‘n Sekondêre kleur wat die primêre kleur aanvul, gebruik vir beklemtoning van sekondêre elemente of vir kontras met die primêre kleur.';
$string['theme_color_desc'] = 'Kies die kleure van die teks en knoppies van Moodle of klik op die lyn hieronder:';
$string['theme_color_heading'] = 'Kleurseleksie van die omgewing';
$string['theme_color_sugestion'] = 'Kleur voorstel';
$string['theme_color_sugestion_text'] = 'Klik op die lyn om die kleur toe te pas op die velde hieronder:';
$string['theme_degrade_about_editbooton'] = 'Redigeer About blok';
$string['theme_degrade_frontpage_bloco'] = 'Blok "{$a}"';
$string['theme_degrade_frontpage_home'] = 'Blokke van die Tuisblad';
$string['theme_degrade_mycourses_editbooton'] = 'Bewerk Blokke';
$string['theme_degrade_slideshow_editbooton'] = 'Wysig SlideShow';
$string['theme_login_branco'] = 'Net aanmeldingskerm, sonder beeld aan die kant, met die vorm op \'n wit agtergrond';
$string['top_color_heading'] = 'Bokant van rolkleur';
$string['top_scroll'] = 'Pen die keuselys vas wanneer jy die bladsy afrol';
$string['top_scroll_background_color'] = 'Agtergrondkleur van topmenu wanneer gescrol word';
$string['top_scroll_background_color_desc'] = 'Stel die agtergrondkleur in wanneer deur die bladsy gescrol word.';
$string['top_scroll_desc'] = 'Wanneer geaktiveer, sal die keuselys aan die bokant van die skerm vasgepen wees terwyl jy die bladsy afrol, wat maklike toegang tot kleuselys opsies verseker.';
$string['top_scroll_text_color'] = 'Teks kleur van topmenu tydens scroll';
$string['top_scroll_text_color_desc'] = 'Stel die tekskleur van die topmenu in wanneer deur die bladsy gescrol word.';
$string['vvveb_footer_contact_title_default'] = 'Kontak ons';
$string['vvveb_home_access'] = 'Toegang tot kursus';
$string['vvveb_home_automatically_catalogo'] = 'Moet nie wysig nie. Hierdie blok sal outomaties vervang word met die kursus katalogus.';
$string['vvveb_home_automatically_category'] = 'Moet nie wysig nie. Hierdie blok sal outomaties vervang word met kursus kategorieë.';
$string['vvveb_home_automatically_my_course'] = 'Moenie wysig nie. Hierdie blok sal outomaties vervang word met die kursusse waarin die student ingeskryf is.';
$string['vvveb_home_automatically_popular'] = 'Moet nie wysig nie. Hierdie blok sal outomaties vervang word met die gewildste kursusse.';
$string['vvveb_home_catalogo_heading'] = 'Kursus katalogus';
$string['vvveb_home_category_heading'] = 'Kursus kategorieë';
$string['vvveb_home_mycourses_heading'] = 'My Kursusse';
$string['vvveb_home_popular_course'] = 'Gewilde Kursusse';
$string['vvveb_home_team_subtitle'] = 'Ons is \'n groep professionele persone wat toegewyd is aan hul werk';
$string['vvveb_home_team_title'] = 'Ontmoet Ons Span';
