<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'id', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aksi';
$string['activate'] = 'Aktifkan akses';
$string['activatesuccess'] = 'Akses ke Lencana berhasil diaktifkan.';
$string['addalignment'] = 'Tambahkan keterampilan eksternal atau standar';
$string['addbadge'] = 'Tambahkan lencana';
$string['addbadge_help'] = 'Pilih semua lencana yang harus ditambahkan ke persyaratan lencana ini. Tahan tombol CTRL untuk memilih beberapa item.';
$string['addbadgecriteria'] = 'Tambahkan kriteria lencana';
$string['addcohort'] = 'Tambahkan kohor';
$string['addcohort_help'] = 'Pilih semua kohor yang harus ditambahkan ke persyaratan lencana ini. Tahan tombol CTRL untuk memilih beberapa item.';
$string['addcompetency'] = 'Tambahkan kompetensi';
$string['addcompetency_help'] = 'Pilih semua kompetensi yang harus ditambahkan ke persyaratan lencana ini. Tahan tombol CTRL untuk memilih beberapa item.';
$string['addcourse'] = 'Tambahkan kursus';
$string['addcourse_help'] = 'Pilih semua kursus yang harus ditambahkan ke persyaratan lencana ini. Tahan tombol CTRL untuk memilih beberapa item.';
$string['addcriteria'] = 'Tambahkan kriteria';
$string['addcriteriatext'] = 'Untuk menambahkan kriteria, pilih salah satu pilihan dari menu tarik-turun.';
$string['addedtobackpack'] = 'Menambahkan lencana ke ransel';
$string['addrelated'] = 'Tambahkan lencana terkait';
$string['addtobackpack'] = 'Tambahkan ke ransel';
$string['adminonly'] = 'Halaman ini terbatas hanya untuk administrator situs.';
$string['after'] = 'setelah tanggal terbit.';
$string['aggregationmethod'] = 'Metode agregasi';
$string['alignment'] = 'Perataan';
$string['all'] = 'Semua';
$string['allmethod'] = 'Semua kondisi terpilih terpenuhi';
$string['allmethodactivity'] = 'Semua aktivitas terpilih telah lengkap';
$string['allmethodbadges'] = 'Semua lencana terpilih sudah didapatkan';
$string['allmethodcohort'] = 'Keanggotaan di semua kohor terpilih';
$string['allmethodcompetencies'] = 'Semua kompetensi terpilih telah diselesaikan';
$string['allmethodcourseset'] = 'Semua kursus terpilih telah lengkap';
$string['allmethodmanual'] = 'Semua peran yang dipilih memberikan lencana';
$string['allmethodprofile'] = 'Semua bidang pada profil telah lengkap';
$string['allowcoursebadges'] = 'Aktifkan lencana kursus';
$string['allowcoursebadges_desc'] = 'Izinkan lencana dibuat dan diberikan dalam konteks kursus.';
$string['allowexternalbackpack'] = 'Aktifkan koneksi pada ransel eksternal';
$string['allowexternalbackpack_desc'] = 'Jika diaktifkan, pengguna dapat terhubung ke ransel eksternal dan membagikan lencana mereka dari situs ini. Pengguna juga dapat memilih untuk menampilkan koleksi lencana publik dari ransel eksternal mereka di halaman profil mereka di situs ini. Pengguna juga dapat memilih untuk menampilkan koleksi lencana publik dari ransel eksternal mereka di halaman profil mereka di situs ini. Dianjurkan untuk membiarkan opsi ini dinonaktifkan jika situs Anda tidak dapat diakses dari Internet.';
$string['any'] = 'Apa pun';
$string['anymethod'] = 'Salah satu kondisi terpilih terpenuhi';
$string['anymethodactivity'] = 'Salah satu aktivitas terpilih selesai';
$string['anymethodbadges'] = 'Salah satu lencana terpilih telah didapatkan';
$string['anymethodcohort'] = 'Keanggotaan dalam kohor terpilih';
$string['anymethodcompetencies'] = 'Salah satu kompetensi yang dipilih telah diselesaikan';
$string['anymethodcourseset'] = 'Salah satu kursus terpilih telah selesai';
$string['anymethodmanual'] = 'Salah satu peran terpilih akan memberikan lencana';
$string['anymethodprofile'] = 'Salah satu ruas profil terpilih telah diisi';
$string['apiversion'] = 'Versi API didukung';
$string['archivebadge'] = 'Apakah anda akan menghapus lencana \'{$a}\', tetapi tetap menyimpan lencana yang telah diterbitkan?';
$string['archiveconfirm'] = 'Hapus dan tetap simpan lencana yang telah terbitkan';
$string['archivehelp'] = '<p> Opsi ini berarti bahwa lencana akan ditandai sebagai "tidak berlaku" dan tidak akan lagi muncul dalam daftar lencana. Pengguna tidak lagi dapat memperoleh lencana ini, namun penerima lencana yang ada masih dapat menampilkan lencana ini di halaman profil mereka dan mendorongnya ke ransel eksternal mereka. </p> <p> Jika Anda ingin pengguna mempertahankan akses ke lencana yang diperoleh, penting untuk memilih opsi ini alih-alih menghapus lencana sepenuhnya. </p>';
$string['attachment'] = 'Lampirkan lencana pada pesan';
$string['attachment_help'] = 'Jika diaktifkan, lencana yang diterbitkan akan dilampirkan ke surel penerima untuk diunduh. (Lampiran harus diaktifkan di "Administrasi Situs/Server/Surel /Konfigurasi Surel Keluar" untuk menggunakan opsi ini.)';
$string['award'] = 'Lencana penghargaan';
$string['awardedto'] = 'Diberikan kepada {$a}';
$string['awardedtoyou'] = 'Terbitkan untuk saya';
$string['awardoncron'] = 'Akses ke lencana berhasil diaktifkan. Terlalu banyak pengguna yang bisa langsung mendapatkan lencana ini. Untuk memastikan kinerja situs, tindakan ini membutuhkan waktu untuk diproses.';
$string['awards'] = 'Penerima';
$string['backpackapiurl'] = 'URL API Ransel';
$string['backpackavailability'] = 'Verifikasi lencana eksternal';
$string['backpackavailability_help'] = 'Agar penerima lencana dapat membuktikan bahwa mereka mendapatkan lencana mereka dari Anda, layanan ransel eksternal harus dapat mengakses situs Anda dan memverifikasi lencana yang dikeluarkan darinya. Situs Anda saat ini tampaknya tidak dapat diakses, yang berarti bahwa lencana yang sudah Anda terbitkan atau akan terbitkan di masa depan tidak dapat diverifikasi. ** Mengapa saya melihat pesan ini? ** Mungkin firewall Anda mencegah akses dari pengguna di luar jaringan Anda, situs Anda dilindungi kata sandi, atau Anda menjalankan situs di komputer yang tidak tersedia dari Internet (seperti mesin pengembangan lokal). ** Apakah ini masalah? ** Anda harus memperbaiki masalah ini di setiap lokasi produksi di mana Anda berencana untuk mengeluarkan lencana, jika tidak, penerima tidak akan dapat membuktikan bahwa mereka mendapatkan lencana mereka dari Anda. Jika situs Anda belum tayang, Anda dapat membuat dan mengeluarkan lencana uji, selama situs tersebut dapat diakses sebelum Anda tayang. ** Bagaimana jika saya tidak dapat membuat seluruh situs saya dapat diakses publik? ** Satu-satunya URL yang diperlukan untuk verifikasi adalah [situs-Anda-url]/badges/assertion.php jadi jika Anda dapat memodifikasi firewall Anda untuk memungkinkan akses eksternal ke berkas itu, verifikasi lencana masih akan berfungsi.';
$string['backpackbadgessettings'] = 'Ubah setelan ransel';
$string['backpackbadgessummary'] = 'Anda memiliki lencana {$a->totalbadges} yang ditampilkan dari koleksi {$a->totalcollections}.';
$string['backpackcannotsendverification'] = 'Tidak dapat mengirim surel verifikasi';
$string['backpackconnected'] = 'Ransel terhubung';
$string['backpackconnection'] = 'Terhubung ke ransel';
$string['backpackconnection_connected'] = 'Ransel Anda';
$string['backpackconnection_help'] = 'Simpan dan bagikan lencana Anda dari situs ini dan tampilkan lencana publik dari situs web lain di profil pengguna Anda.';
$string['backpackconnectioncancelattempt'] = 'Tersambung menggunakan alamat surel yang lain';
$string['backpackconnectionconnect'] = 'Tersambung ke ransel';
$string['backpackconnectionnottested'] = 'Koneksi tidak dapat diuji untuk ransel ini karena hanya ransel Open Badges v2.0 yang mendukungnya.';
$string['backpackconnectionok'] = 'Koneksi ransel berhasil dibuat';
$string['backpackconnectionresendemail'] = 'Kirim ulang surel verifikasi';
$string['backpackconnectionunexpectedmessage'] = 'Ransel itu mengembalikan kesalahan: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Galat ketika menghubungkan ke ransel Anda. Penyedia ransel Anda mengirimkan pesan ini: \'{$a}\'.';
$string['backpackdetails'] = 'Setelan ransel';
$string['backpackdisconnected'] = 'Ransel terputus';
$string['backpackemail'] = 'Alamat surel';
$string['backpackemail_help'] = 'Alamat surel yang terkait dengan ransel Anda. Saat Anda terhubung, setiap lencana yang diperoleh di situs ini akan dikaitkan dengan alamat surel ini.';
$string['backpackemail_required'] = 'Alamat surel tidak boleh kosong';
$string['backpackemailverificationpending'] = 'Verifikasi tertunda';
$string['backpackemailverifyemailbody'] = 'Halo {$a->userfirstname},

Anda hampir selesai terhubung ke ransel lencana Anda di \'{$a->sitename}\'.

Untuk menyelesaikan menghubungkan ke ransel Anda, verifikasi alamat surel Anda melalui tombol berikut:

{$a->buttonlink}

Jika tombol tidak berfungsi, Anda dapat menyalin dan menempelkan URL berikut ke peramban Anda:
{$a->link}

Jika Anda tidak mencoba terhubung ke ransel lencana Anda, Anda dapat mengabaikan surel ini dengan aman.

Untuk bantuan tambahan, silakan hubungi dukungan situs Anda,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Verifikasi surel ransel lencana';
$string['backpackemailverifypending'] = 'Surel verifikasi telah dikirim ke <strong> {$a} </strong>. Klik tautan verifikasi di surel untuk mengaktifkan koneksi ransel Anda.';
$string['backpackemailverifysuccess'] = 'Anda sekarang terhubung ke ransel Anda.';
$string['backpackemailverifytokenmismatch'] = 'Token di tautan yang Anda klik tidak cocok dengan token yang disimpan. Pastikan Anda mengklik tautan di surel terbaru yang Anda terima.';
$string['backpackexporterror'] = 'Tidak dapat mengekspor lencana ke ransel';
$string['backpackexporterrorwithinfo'] = 'Tidak dapat mengekspor lencana "{$a->badgename}" ke ransel. Kesalahan: {$a->error}';
$string['backpackimport'] = 'Setelan impor lencana';
$string['backpackimport_help'] = 'Setelah koneksi ransel berhasil dibuat, lencana dari ransel Anda dapat ditampilkan di halaman lencana dan halaman profil Anda. Di area ini, Anda dapat memilih koleksi lencana dari ransel Anda yang ingin Anda tampilkan di profil Anda.';
$string['backpackprovider'] = 'Penyedia ransel';
$string['backpacksettings'] = 'Setelan ransel';
$string['backpackweburl'] = 'URL ransel';
$string['badgedetails'] = 'Detail lencana';
$string['badgeimage'] = 'Gambar';
$string['badgeimage_help'] = 'Ini adalah gambar yang akan digunakan saat lencana ini dikeluarkan. Untuk menambahkan gambar baru, telusuri dan pilih gambar (dalam format JPG atau PNG) lalu klik "Simpan perubahan". Gambar akan dipotong menjadi persegi dan diubah ukurannya agar sesuai dengan persyaratan gambar lencana.';
$string['badgeissued'] = 'Lencana yang diterbitkan';
$string['badgeprivacysetting'] = 'Setelan privasi lencana';
$string['badgeprivacysetting_help'] = 'Lencana yang Anda peroleh dapat ditampilkan di halaman profil akun Anda. Setelan ini memungkinkan Anda untuk secara otomatis mengatur visibilitas lencana yang baru diperoleh. Anda masih dapat mengontrol setelan privasi lencana individu di halaman lencana Anda.';
$string['badgeprivacysetting_str'] = 'Secara otomatis menampilkan lencana yang saya peroleh di halaman profil saya';
$string['badges'] = 'Lencana';
$string['badgesalt'] = 'Salt untuk mencirikan alamat surel penerima';
$string['badgesalt_desc'] = 'Menggunakan hash memungkinkan layanan ransel untuk mengonfirmasi penerima lencana tanpa harus mengungkap alamat email mereka. Setelan ini sebaiknya hanya menggunakan angka dan huruf. Catatan: Untuk tujuan verifikasi penerima, harap hindari mengubah setelan ini setelah Anda mulai mengeluarkan lencana.';
$string['badgesdisabled'] = 'Lencana tidak aktif di situs ini.';
$string['badgesearned'] = 'Jumlah lencana yang diperoleh: {$a}';
$string['badgesettings'] = 'Setelan lencana';
$string['badgestatus_0'] = 'Tidak tersedia';
$string['badgestatus_1'] = 'Tersedia untuk pengguna';
$string['badgestatus_2'] = 'Tidak tersedia untuk pengguna';
$string['badgestatus_3'] = 'Tersedia untuk pengguna';
$string['badgestatus_4'] = 'Diarsipkan';
$string['badgestoearn'] = 'Lencana yang tersedia: {$a}';
$string['badgesview'] = 'Lencana kursus';
$string['badgetags'] = 'Tag lencana';
$string['badgeurl'] = 'Tautan lencana yang diterbitkan';
$string['balignment'] = 'Perataan ({$a})';
$string['bawards'] = 'Penerima ({$a})';
$string['bcriteria'] = 'Kriteria';
$string['bdetails'] = 'Edit detail';
$string['bendorsement'] = 'Pengesahanh';
$string['bmessage'] = 'Pesan';
$string['boverview'] = 'Ikhtisar';
$string['brelated'] = 'Lencana terkait ({$a})';
$string['bydate'] = 'selesai pada';
$string['claim'] = 'Klaim';
$string['claimcomment'] = 'Komentar pengesahan';
$string['claimid'] = 'URL Klaim';
$string['clearsettings'] = 'Bersihkan setelan';
$string['completioninfo'] = 'Lencana ini diterbitkan setelah menyelesaikan:';
$string['completionnotenabled'] = 'Penyelesaian kursus tidak diaktifkan untuk kursus ini, sehingga tidak dapat dimasukkan dalam kriteria lencana. Penyelesaian kursus dapat diaktifkan di setelan kursus.';
$string['configenablebadges'] = 'Jika diaktifkan, fitur ini memungkinkan Anda membuat lencana dan memberikannya kepada pengguna situs.';
$string['configuremessage'] = 'Pesan lencana';
$string['connect'] = 'Hubung';
$string['connected'] = 'Terhubung';
$string['connecting'] = 'Menghubungkan...';
$string['contact'] = 'Kontak';
$string['contact_help'] = 'Alamat surel yang terkait dengan penerbit lencana.';
$string['copy'] = 'Salin';
$string['copyof'] = 'Salinan dari {$a}';
$string['course'] = 'Kursus: {$a}';
$string['coursebadges'] = 'Lencana';
$string['coursebadgesdisabled'] = 'Lencana kursus tidak diaktifkan di situs ini.';
$string['coursebadgetitle'] = 'lencana kursus {$a}';
$string['coursecompletion'] = 'Pengguna harus menyelesaikan kursus ini.';
$string['create'] = 'Lencana baru';
$string['createbutton'] = 'Buat lencana';
$string['creatorbody'] = '<p> {$a->user} telah menyelesaikan semua persyaratan lencana dan mendapatkan lencana. Lihat lencana yang diterbitkan di {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' telah diberikan!';
$string['criteria_0'] = 'Lencana ini diberikan ketika...';
$string['criteria_1'] = 'Penyelesaian aktivitas';
$string['criteria_1_help'] = 'Mengizinkan lencana diberikan kepada pengguna berdasarkan penyelesaian serangkaian aktivitas dalam suatu kursus.';
$string['criteria_2'] = 'Terbitkan manual berdasarkan peran';
$string['criteria_2_help'] = 'Mengizinkan lencana diberikan secara manual oleh pengguna yang memiliki peran tertentu dalam situs atau kursus.';
$string['criteria_3'] = 'Partisipasi sosial';
$string['criteria_3_help'] = 'Sosial';
$string['criteria_4'] = 'Penyelesaian kursus';
$string['criteria_4_help'] = 'Mengizinkan lencana diberikan kepada pengguna yang telah menyelesaikan kursus. Kriteria ini dapat memiliki parameter tambahan seperti nilai minimum dan tanggal penyelesaian kursus.';
$string['criteria_5'] = 'Menyelesaikan sekumpulan kursus';
$string['criteria_5_help'] = 'Mengizinkan lencana diberikan kepada pengguna yang telah menyelesaikan serangkaian kursus. Setiap kursus dapat memiliki parameter tambahan seperti nilai minimum dan tanggal penyelesaian kursus.';
$string['criteria_6'] = 'Penyelesaian profil';
$string['criteria_6_help'] = 'Mengizinkan lencana diberikan kepada pengguna karena menyelesaikan bidang tertentu di profil mereka. Anda dapat memilih dari bidang profil bawaan dan kursus yang tersedia untuk pengguna.';
$string['criteria_7'] = 'Lencana yang diberikan';
$string['criteria_7_help'] = 'Mengizinkan lencana diberikan kepada pengguna berdasarkan lencana lain yang telah mereka peroleh.';
$string['criteria_8'] = 'Keanggotaan kohor';
$string['criteria_8_help'] = 'Memungkinkan lencana diberikan kepada pengguna berdasarkan keanggotaan kohor.';
$string['criteria_9'] = 'Kompetensi';
$string['criteria_9_help'] = 'Memungkinkan lencana diberikan kepada pengguna berdasarkan kompetensi yang telah mereka selesaikan.';
$string['criteria_descr'] = 'Pengguna diberikan lencana ini ketika mereka menyelesaikan persyaratan berikut:';
$string['criteria_descr_0'] = 'Lengkapi <strong>{$a}</strong> pada persyaratan yang tercantum.';
$string['criteria_descr_1'] = '<strong> {$a} </strong> dari aktivitas berikut telah diselesaikan:';
$string['criteria_descr_2'] = 'Lencana ini telah diberikan oleh pengguna dengan  <strong>{$a}</strong> dari peran berikut:';
$string['criteria_descr_4'] = 'Pengguna harus menyelesaikan kursus';
$string['criteria_descr_5'] = '<strong> {$a} </strong> dari kursus berikut harus diselesaikan:';
$string['criteria_descr_6'] = '<strong> {$a} </strong> dari ruas profil pengguna berikut harus dilengkapi:';
$string['criteria_descr_7'] = '<strong> {$a} </strong> dari lencana berikut harus diperoleh:';
$string['criteria_descr_8'] = 'Keanggotaan dalam <strong> {$a} </strong> dari kohor berikut diperlukan:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> kompetensi berikut harus diselesaikan:';
$string['criteria_descr_bydate'] = 'oleh <em>{$a}</em>';
$string['criteria_descr_grade'] = 'dengan nilai minimal <em> {$a} </em>';
$string['criteria_descr_short0'] = 'Selesaikan <strong> {$a} </strong> dari:';
$string['criteria_descr_short1'] = 'Selesaikan <strong> {$a} </strong> dari:';
$string['criteria_descr_short2'] = 'Diberikan oleh <strong>{$a}</strong> dari:';
$string['criteria_descr_short4'] = 'Selesaikan kursus';
$string['criteria_descr_short5'] = 'Selesaikan <strong> {$a} </strong> dari:';
$string['criteria_descr_short6'] = 'Selesaikan <strong> {$a} </strong> dari:';
$string['criteria_descr_short7'] = 'Selesaikan <strong> {$a} </strong> dari:';
$string['criteria_descr_short8'] = 'Keanggotaan kohor di <strong> {$a} </strong> dari:';
$string['criteria_descr_short9'] = 'Selesaikan <strong> {$a} </strong> dari:';
$string['criteria_descr_single_1'] = 'Aktivitas berikut harus diselesaikan:';
$string['criteria_descr_single_2'] = 'Lencana ini telah diberikan oleh pengguna dengan peran berikut:';
$string['criteria_descr_single_4'] = 'Pengguna harus menyelesaikan kursus';
$string['criteria_descr_single_5'] = 'Kursus berikut harus diselesaikan:';
$string['criteria_descr_single_6'] = 'Bidang profil pengguna berikut harus dilengkapi:';
$string['criteria_descr_single_7'] = 'Lencana berikut harus diperoleh:';
$string['criteria_descr_single_8'] = 'Keanggotaan dalam kohor berikut diperlukan:';
$string['criteria_descr_single_9'] = 'Kompetensi berikut harus diselesaikan:';
$string['criteria_descr_single_short1'] = 'Selesaikan:';
$string['criteria_descr_single_short2'] = 'Diberikan oleh:';
$string['criteria_descr_single_short4'] = 'Selesaikan kursus';
$string['criteria_descr_single_short5'] = 'Selesaikan:';
$string['criteria_descr_single_short6'] = 'Selesaikan:';
$string['criteria_descr_single_short7'] = 'Selesaikan:';
$string['criteria_descr_single_short8'] = 'Anggota dalam:';
$string['criteria_descr_single_short9'] = 'Selesaikan:';
$string['criteriacreated'] = 'Kriteria lencana berhasil dibuat';
$string['criteriadeleted'] = 'Kriteria lencana berhasil dihapus';
$string['criteriasummary'] = 'Ringkasan kriteria';
$string['criteriaupdated'] = 'Kriteria lencana berhasil diperbarui';
$string['criterror'] = 'Masalah parameter saat ini';
$string['criterror_help'] = 'Kumpulan ruas ini menunjukkan semua parameter yang awalnya ditambahkan ke persyaratan lencana ini tetapi tidak lagi tersedia. Sebaiknya hapus centang pada parameter tersebut untuk memastikan bahwa pengguna dapat memperoleh lencana ini di masa mendatang.';
$string['currentimage'] = 'Gambar sekarang';
$string['currentstatus'] = 'Status terkini:';
$string['dateawarded'] = 'Tanggal terbit';
$string['dateearned'] = 'Tanggal: {$a}';
$string['day'] = 'Hari';
$string['deactivate'] = 'Nonaktifkan akses';
$string['deactivatesuccess'] = 'Akses ke lencana berhasil dinonaktifkan.';
$string['defaultissuercontact'] = 'Alamat surel penerbit lencana';
$string['defaultissuercontact_desc'] = 'Alamat surel yang terkait dengan penerbit lencana. Untuk ransel Open Badges v2.0, ini digunakan untuk otentikasi saat menerbitkan lencana ke ransel.';
$string['defaultissuername'] = 'Nama penerbit lencana';
$string['defaultissuername_desc'] = 'Nama agen atau otoritas penerbit.';
$string['defaultissuerpassword'] = 'Kata sandi penerbit lencana';
$string['defaultissuerpassword_help'] = 'Akun diperlukan di situs ransel dengan alamat surel seperti yang ditentukan dalam setelan alamat surel penerbit lencana di administrasi Situs/Lencana/Setelan Lencana. Kata sandi untuk akun tersebut harus dimasukkan di sini.';
$string['delbadge'] = 'Apakah Anda ingin menghapus lencana \'{$a}\' dan menghapus semua lencana yang diterbitkan?';
$string['delconfirm'] = 'Hapus dan hapus lencana yang sudah ada';
$string['delcritconfirm'] = 'Apakah Anda yakin ingin menghapus kriteria ini?';
$string['deletehelp'] = '<p> Menghapus lencana sepenuhnya berarti semua informasi dan catatan kriterianya akan dihapus secara permanen. Pengguna yang mendapatkan lencana ini tidak dapat lagi mengaksesnya dan menampilkannya di halaman profil mereka. </p> <p> Catatan: Pengguna yang telah mendapatkan lencana ini dan telah memasukkannya ke ransel eksternal mereka, masih akan memiliki lencana ini di ransel luar mereka. Namun, mereka tidak akan dapat mengakses kriteria dan halaman bukti yang menautkan kembali ke situs web ini. </p>';
$string['delexternalbackpack'] = 'Hapus situs ransel';
$string['delexternalbackpackconfirm'] = 'Hapus situs ransel \'{$a}\'?';
$string['delparamconfirm'] = 'Anda yakin ingin menghapus parameter ini?';
$string['description'] = 'Deskripsi';
$string['disconnect'] = 'Putuskan';
$string['donotaward'] = 'Saat ini, lencana ini tidak aktif, sehingga tidak dapat diberikan kepada pengguna. Jika Anda ingin memberikan lencana ini, atur statusnya menjadi aktif.';
$string['enablebadges'] = 'Aktifkan lencana';
$string['endorsement'] = 'Pengesahan';
$string['error:backpackdatainvalid'] = 'Data yang dikembalikan dari ransel tidak valid.';
$string['error:backpackemailnotfound'] = 'Surel \'{$a}\' tidak terkait dengan ransel. Anda perlu <a href="http://backpack.openbadges.org">membuat ransel</a> untuk akun tersebut atau masuk dengan alamat surel lain.';
$string['error:badgeawardnotfound'] = 'Tidak dapat memverifikasi lencana yang diberikan ini. Lencana ini mungkin telah dicabut.';
$string['error:badgenotfound'] = 'Lencana tidak ditemukan';
$string['error:cannotact'] = 'Tidak dapat mengaktifkan lencana.';
$string['error:cannotawardbadge'] = 'Tidak dapat memberikan lencana kepada pengguna.';
$string['error:cannotdeletecriterion'] = 'Kriteria ini tidak dapat dihapus.';
$string['error:cannotrevokebadge'] = 'Tidak dapat mencabut lencana dari pengguna.';
$string['error:clone'] = 'Tidak dapat mengkloning lencana.';
$string['error:connectionunknownreason'] = 'Koneksi tidak berhasil tetapi tidak ada alasan yang diberikan.';
$string['error:duplicatename'] = 'Lencana dengan nama seperti itu sudah ada di sistem.';
$string['error:externalbadgedoesntexist'] = 'Lencana tidak ditemukan';
$string['error:guestuseraccess'] = 'Anda sedang menggunakan akses tamu. Untuk melihat lencana, Anda harus masuk dengan akun pengguna Anda.';
$string['error:invalidcriteriatype'] = 'Jenis kriteria tidak valid.';
$string['error:invalidexpiredate'] = 'Tanggal kedaluwarsa harus di waktu di akan datang.';
$string['error:invalidexpireperiod'] = 'Periode kedaluwarsa tidak boleh negatif atau sama dengan 0.';
$string['error:invalidparambadge'] = 'Lencana tidak ada.';
$string['error:invalidparamcohort'] = 'Kohor tidak ada.';
$string['error:noactivities'] = 'Tidak ada aktivitas dengan kriteria penyelesaian yang diaktifkan dalam kursus ini.';
$string['error:nobadges'] = 'Tidak ada lencana kursus atau situs dengan akses yang diaktifkan untuk ditambahkan sebagai kriteria.';
$string['error:nocohorts'] = 'Tak ada kohor';
$string['error:nocourses'] = 'Penyelesaian kursus tidak diaktifkan untuk kursus mana pun di situs ini, jadi tidak ada yang dapat ditampilkan. Penyelesaian kursus dapat diaktifkan di setelan kursus.';
$string['error:nogroupslink'] = '<p> Hanya koleksi publik yang ditampilkan. <a href="{$a}" target="_blank" rel="nofollow"> Kunjungi ransel Anda </a> untuk membuat beberapa koleksi publik. </p>';
$string['error:nogroupssummary'] = '<p>Tidak ada koleksi lencana publik yang tersedia di ransel Anda. </p>';
$string['error:nopermissiontoview'] = 'Anda tidak diizinkan melihat penerima lencana';
$string['error:nosuchbadge'] = 'Lencana dengan id {$a} tidak ada.';
$string['error:nosuchcohort'] = 'Peringatan: Kohor ini tidak lagi tersedia.';
$string['error:nosuchcourse'] = 'Peringatan: kursus ini tidak lagi tersedia.';
$string['error:nosuchfield'] = 'Peringatan: Ruas profil pengguna ini tidak lagi tersedia.';
$string['error:nosuchmod'] = 'Peringatan: Aktivitas ini tidak lagi tersedia.';
$string['error:nosuchrole'] = 'Peringatan: Peran ini tidak lagi tersedia.';
$string['error:nosuchuser'] = 'Pengguna dengan alamat surel ini tidak memiliki akun di penyedia ransel saat ini.';
$string['error:notifycoursedate'] = 'Peringatan: Lencana yang terkait dengan kursus dan penyelesaian aktivitas tidak akan dikeluarkan hingga tanggal mulai kursus.';
$string['error:parameter'] = 'Peringatan: Setidaknya satu parameter harus dipilih untuk memastikan alur kerja penerbitan lencana yang benar.';
$string['error:relatedbadgedoesntexist'] = 'Tidak ada lencana publik dengan pengenal ini';
$string['error:requesterror'] = 'Permintaan koneksi gagal (kode kesalahan {$a}).';
$string['error:requesttimeout'] = 'Permintaan koneksi habis waktu sebelum bisa diselesaikan.';
$string['error:save'] = 'Tidak dapat menyimpan lencana.';
$string['error:userdeleted'] = '{$a->user} (Pengguna ini tidak ada lagi di {$a->site})';
$string['eventbadgearchived'] = 'Mengarsipkan lencana';
$string['eventbadgeawarded'] = 'Menyerahkan lencana';
$string['eventbadgecreated'] = 'Membuat lencana';
$string['eventbadgecriteriacreated'] = 'Membuat kriteria lencana';
$string['eventbadgecriteriadeleted'] = 'Menghapus kriteria lencana';
$string['eventbadgecriteriaupdated'] = 'Memperbarui kriteria lencana';
$string['eventbadgedeleted'] = 'Menghapus lencana';
$string['eventbadgedisabled'] = 'Menonaktifkan lencana';
$string['eventbadgeduplicated'] = 'Menduplikasi lencana';
$string['eventbadgeenabled'] = 'Mengaktifkan lencana';
$string['eventbadgelistingviewed'] = 'Melihat daftar lencana';
$string['eventbadgerevoked'] = 'Mencabut lencana';
$string['eventbadgeupdated'] = 'Memperbarui lencana';
$string['eventbadgeviewed'] = 'Melihat lencana';
$string['evidence'] = 'Bukti';
$string['existingrecipients'] = 'Penerima lencana';
$string['existsinbackpack'] = 'Lencana sudah ada di ransel';
$string['expired'] = 'Kedaluwarsa';
$string['expiredate'] = 'Lencana ini kedaluwarsa pada {$a}.';
$string['expireddate'] = 'Lencana ini kedaluwarsa pada {$a}.';
$string['expiredin'] = 'Kedaluwarsa {$a}';
$string['expireperiod'] = 'Lencana ini kedaluwarsa dalam {$a} hari setelah diterbitkan.';
$string['expireperiodh'] = 'Lencana ini kedaluwarsa dalam {$a} jam setelah diterbitkan.';
$string['expireperiodm'] = 'Lencana ini kedaluwarsa dalam {$a} menit setelah diterbitkan.';
$string['expireperiods'] = 'Lencana ini kedaluwarsa dalam {$a} detik setelah diterbitkan.';
$string['expiresin'] = 'Kedaluwarsa {$a}';
$string['expirydate'] = 'Tanggal kedaluwarsa';
$string['expirydate_help'] = 'Secara opsional, lencana dapat kedaluwarsa pada tanggal tertentu, atau tanggal tersebut dapat dihitung berdasarkan tanggal ketika lencana dikeluarkan kepada pengguna.';
$string['externalbackpack_required'] = 'Penyedia ransel wajib diisi';
$string['externalbadges'] = 'Lencana saya dari situs web lain';
$string['externalbadges_help'] = 'Area ini menampilkan lencana dari ransel eksternal Anda.';
$string['externalbadgesp'] = 'Lencana dari situs web lain:';
$string['externalconnectto'] = 'Untuk menampilkan lencana eksternal Anda perlu <a href="{$a}"> menghubungkan ke ransel </a>.';
$string['fixed'] = 'Tanggal tetap';
$string['hidden'] = 'Tersembunyi';
$string['hiddenbadge'] = 'Sayangnya, pemilik lencana belum menyediakan informasi ini.';
$string['hostedurl'] = 'URL eksternal';
$string['hostedurldescription'] = 'URL eksternal tempat lencana dihosting';
$string['imageauthoremail'] = 'Surel pembuat gambar';
$string['imageauthoremail_help'] = 'Jika ditentukan, alamat surel dari pembuat gambar lencana ditampilkan di halaman lencana.';
$string['imageauthorname'] = 'Nama pembuat gambar';
$string['imageauthorname_help'] = 'Jika ditentukan, nama pembuat gambar lencana ditampilkan di halaman lencana.';
$string['imageauthorurl'] = 'URL pembuat gambar';
$string['imageauthorurl_help'] = 'Jika ditentukan, tautan ke situs web pembuat gambar lencana ditampilkan di halaman lencana. URL harus memiliki awalan http:// atau https://.';
$string['imagecaption'] = 'Takarir gambar';
$string['imagecaption_help'] = 'Jika ditentukan, Takarir gambar ditampilkan di halaman lencana.';
$string['includeauthdetails'] = 'Sertakan detail autentikasi dengan ransel';
$string['invalidurl'] = 'URL tidak valid';
$string['issuancedetails'] = 'Kedaluwarsa lencana';
$string['issuedbadge'] = 'Informasi lencana yang diterbitkan';
$string['issuedby'] = 'Diterbitkan oleh {$a}';
$string['issuedon'] = 'Diterbitkan {$a}';
$string['issuerdetails'] = 'Detail penerbit';
$string['issueremail'] = 'Surel';
$string['issueremail_help'] = 'Alamat surel kontak organisasi yang mengeluarkan pengesahan.';
$string['issuername'] = 'Nama penerbit';
$string['issuername_endorsement'] = 'Nama pemberi pengesahan';
$string['issuername_endorsement_help'] = 'Nama pemberi pengesahan.';
$string['issuername_help'] = 'Nama agen atau otoritas penerbit.';
$string['issuerurl'] = 'URL penerbit';
$string['issuerurl_help'] = 'Situs web organisasi yang mengeluarkan pengesahan. URL harus memiliki awalan http:// atau https://.';
$string['language'] = 'Bahasa';
$string['language_help'] = 'Bahasa yang digunakan di halaman lencana.';
$string['listbackpacks'] = 'Daftar ransel';
$string['localbadges'] = 'Lencana saya dari situs web {$a}';
$string['localbadgesh'] = 'Lencana saya dari situs web ini';
$string['localbadgesh_help'] = 'Semua lencana diperoleh dalam situs web ini dengan menyelesaikan kursus, aktivitas kursus, dan persyaratan lainnya. Anda dapat mengelola lencana Anda di sini dengan menjadikannya publik atau pribadi untuk halaman profil Anda. Anda dapat mengunduh semua lencana atau setiap lencana secara terpisah dan menyimpannya di komputer Anda. Lencana yang diunduh dapat ditambahkan ke layanan ransel eksternal Anda.';
$string['localbadgesp'] = 'Lencana dari {$a}:';
$string['localconnectto'] = 'Untuk membagikan lencana ini di luar situs web ini, Anda harus <a href="{$a}"> menghubungkan ke ransel </a>.';
$string['loginbackpacktitle'] = '<strong>Masuk ke ransel Anda</strong>';
$string['makeprivate'] = 'Jadikan pribadi';
$string['makepublic'] = 'Jadikan publik';
$string['managebackpacks'] = 'Kelola ransel';
$string['managebadges'] = 'Kelola lencana';
$string['message'] = 'Tubuh pesan';
$string['messagebody'] = '<p> Anda telah diberikan lencana "%badgename%"! </p> <p> Informasi lebih lanjut tentang lencana ini dapat ditemukan di halaman%badgelink% informasi lencana. </p> <p> Anda dapat mengelola dan unduh lencananya dari laman {$a} Anda. </p>';
$string['messagesubject'] = 'Selamat! Anda baru saja mendapatkan lencana!';
$string['method'] = 'Kriteria lengkap jika ...';
$string['mingrade'] = 'Nilai minimum dibutuhkan';
$string['month'] = 'Bulan';
$string['moredetails'] = 'Detail lebih lanjut';
$string['mybackpack'] = 'Setelan ransel';
$string['mybadges'] = 'Lencanaku';
$string['namewithlink'] = 'Nama dengan tautan';
$string['never'] = 'Tidak pernah';
$string['newbackpack'] = 'Tambahkan ransel baru';
$string['newbadge'] = 'Tambahkan lencana baru';
$string['newimage'] = 'Gambar baru';
$string['noalignment'] = 'Lencana ini tidak memiliki kompetensi yang ditentukan.';
$string['noawards'] = 'Lencana ini belum didapatkan.';
$string['nobackpack'] = 'Tidak ada layanan backpack tersambung pada akun ini. <br />';
$string['nobackpackbadgessummary'] = 'Tidak ada lencana dalam koleksi yang Anda pilih.';
$string['nobackpackcollectionssummary'] = 'Tidak ada koleksi lencana yang dipilih.';
$string['nobackpacks'] = 'Tidak ada ransel yang tersedia';
$string['nobadges'] = 'Lencana belum tersedia';
$string['nocompetencies'] = 'Tidak ada kompetensi yang dipilih.';
$string['nocriteria'] = 'Kriteria untuk lencana ini belum disiapkan.';
$string['noendorsement'] = 'Lencana ini tidak memiliki pengesahan.';
$string['noexpiry'] = 'Lencana ini tidak memiliki kedaluwarsa';
$string['nomatchingbadges'] = 'Tidak ada lencana yang cocok yang tersedia untuk diperoleh pengguna.';
$string['noparamstoadd'] = 'Tidak ada parameter tambahan yang tersedia untuk ditambahkan ke persyaratan lencana ini.';
$string['norelated'] = 'Lencana ini tidak memiliki lencana terkait.';
$string['notacceptedrole'] = 'Penetapan peran Anda saat ini tidak termasuk di antara peran yang dapat menerbitkan lencana ini secara manual. <br/> Jika Anda ingin melihat pengguna yang telah mendapatkan lencana ini, Anda dapat mengunjungi halaman {$a}.';
$string['notconnected'] = 'Tidak terhubung';
$string['notealignment'] = 'Keterampilan atau standar eksternal, yang selaras dengan lencana, dapat ditentukan. Keterampilan atau standar eksternal apa pun ditampilkan di halaman lencana.';
$string['noteendorsement'] = 'Pengesahan dari pihak ketiga dapat digunakan untuk menambah nilai pada lencana. Misalnya, lencana yang dikeluarkan oleh pengajar dapat disahkan oleh sekolah, atau lencana yang dikeluarkan oleh badan pemberi penghargaan lokal dapat disahkan oleh badan pemberi penghargaan nasional.';
$string['noterelated'] = 'Lencana dengan koneksi dapat ditandai sebagai terkait. Misalnya, lencana dengan kriteria yang sama yang ditampilkan dalam bahasa yang berbeda dapat ditandai sebagai terkait. Setiap lencana terkait ditampilkan pada halaman lencana.';
$string['nothingtoadd'] = 'Tidak ada kriteria yang tersedia untuk ditambahkan.';
$string['notification'] = 'Beri tahu pembuat lencana';
$string['notification_help'] = 'Setelan ini mengelola pemberitahuan yang dikirim ke pembuat lencana untuk memberi tahu mereka bahwa lencana telah diterbitkan.

Opsi berikut tersedia:

* **TIDAK PERNAH** - Jangan kirim notifikasi.

* **SETIAP WAKTU** – Kirim pemberitahuan setiap kali lencana ini diberikan.

* **SETIAP HARI** - Kirim pemberitahuan sekali sehari.

* **MINGGUAN** - Kirim notifikasi seminggu sekali.

* **BULANAN** - Kirim notifikasi sebulan sekali.';
$string['notifydaily'] = 'Harian';
$string['notifyevery'] = 'Setiap saat';
$string['notifymonthly'] = 'Bulanan';
$string['notifyweekly'] = 'Mingguan';
$string['numawards'] = 'Lencana ini telah diberikan kepada <a href="{$a->link} "> {$a->count} </a> pengguna.';
$string['numawardstat'] = 'Lencana ini telah diberikan kepada {$a} pengguna.';
$string['oauth2issuer'] = 'Layanan OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Navigasi lainnya...';
$string['overallcrit'] = 'dari kriteria yang dipilih sudah lengkap.';
$string['password_required'] = 'Kata sandi tidak boleh kosong';
$string['potentialrecipients'] = 'Penerima lencana potensial';
$string['preferences'] = 'Preferensi lencana';
$string['privacy:metadata:backpack'] = 'Catatan backpack pengguna';
$string['privacy:metadata:backpack:backpackuid'] = 'Pengidentifikasi unik backpack';
$string['privacy:metadata:backpack:email'] = 'Surel yang terkait dengan ransel';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID ranranselsel';
$string['privacy:metadata:backpack:userid'] = 'ID pengguna yang memiliki ransel';
$string['privacy:metadata:backpackoauth2'] = 'Informasi OAuth 2 saat pengguna terhubung ke ransel eksternal';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID layanan OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Daftar ruang lingkup ransel terhubung';
$string['privacy:metadata:backpackoauth2:token'] = 'Token koneksi ransel';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID pengguna yang terhubung ke ransel';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID dari koneksi yang dimodifikasi pengguna';
$string['privacy:metadata:badge'] = 'Koleksi lencana';
$string['privacy:metadata:badge:timecreated'] = 'Waktu saat lencana dibuat';
$string['privacy:metadata:badge:timemodified'] = 'Waktu ketika lencana terakhir diubah';
$string['privacy:metadata:badge:usercreated'] = 'ID pengguna yang membuat lencana';
$string['privacy:metadata:badge:usermodified'] = 'ID pengguna yang mengubah lencana';
$string['privacy:metadata:criteriamet'] = 'Kumpulan kriteria yang telah terpenuhi';
$string['privacy:metadata:criteriamet:datemet'] = 'Tanggal saat kriteria dipenuhi';
$string['privacy:metadata:criteriamet:userid'] = 'ID pengguna yang telah memenuhi kriteria';
$string['privacy:metadata:external:backpacks'] = 'Informasi dibagikan saat pengguna mengirimkan lencana mereka ke ransel eksternal';
$string['privacy:metadata:external:backpacks:badge'] = 'Nama lencana';
$string['privacy:metadata:external:backpacks:description'] = 'Deskripsi lencana';
$string['privacy:metadata:external:backpacks:image'] = 'Gambar lencana';
$string['privacy:metadata:external:backpacks:issuer'] = 'Beberapa informasi tentang penerbit';
$string['privacy:metadata:external:backpacks:url'] = 'URL Moodle tempat informasi lencana yang dikeluarkan dapat dilihat';
$string['privacy:metadata:issued'] = 'Rekaman penghargaan lencana';
$string['privacy:metadata:issued:dateexpire'] = 'Tanggal kedaluwarsa lencana';
$string['privacy:metadata:issued:dateissued'] = 'Tanggal penghargaan';
$string['privacy:metadata:issued:userid'] = 'ID pengguna yang mendapatkan lencana';
$string['privacy:metadata:manualaward'] = 'Rekaman penghargaan manual';
$string['privacy:metadata:manualaward:datemet'] = 'Tanggal ketika pengguna mendapatkan lencana';
$string['privacy:metadata:manualaward:issuerid'] = 'ID pengguna yang memberikan lencana';
$string['privacy:metadata:manualaward:issuerrole'] = 'Peran pengguna yang memberikan lencana';
$string['privacy:metadata:manualaward:recipientid'] = 'ID pengguna yang secara manual diberikan lencana';
$string['recipient'] = 'Penerima lencana';
$string['recipientdetails'] = 'Detail penerima';
$string['recipientidentificationproblem'] = 'Tidak dapat menemukan penerima lencana ini di antara pengguna yang ada.';
$string['recipients'] = 'Penerima lencana';
$string['recipientvalidationproblem'] = 'Pengguna saat ini tidak dapat diverifikasi sebagai penerima lencana ini.';
$string['relatedbages'] = 'Lencana terkait';
$string['relative'] = 'Tanggal relatif';
$string['requiredbadge'] = 'Setidaknya satu lencana harus ditambahkan ke kriteria lencana.';
$string['requiredcohort'] = 'Setidaknya satu kohor harus ditambahkan ke kriteria kohor.';
$string['requiredcompetency'] = 'Setidaknya satu kompetensi harus ditambahkan ke kriteria kompetensi.';
$string['requiredcourse'] = 'Setidaknya satu kursus harus ditambahkan ke kriteria kumpulan kursus.';
$string['reviewbadge'] = 'Perubahan dalam akses lencana';
$string['reviewconfirm'] = '<p> Ini akan membuat lencana Anda terlihat oleh pengguna dan memungkinkan mereka untuk mulai menghasilkannya. </p> <p> Ada kemungkinan bahwa beberapa pengguna sudah memenuhi kriteria lencana ini dan akan mengeluarkan lencana ini segera setelah Anda mengaktifkannya. < / p> <p> Setelah lencana dikeluarkan, itu akan menjadi <strong> terkunci </strong> - setelan tertentu termasuk kriteria dan setelan kedaluwarsa tidak dapat lagi diubah. </p> <p> Anda yakin ingin untuk mengaktifkan akses ke lencana \'{$a}\'? </p>';
$string['revoke'] = 'Cabut lencana';
$string['save'] = 'Simpan';
$string['searchname'] = 'Pencarian berdasarkan nama';
$string['selectaward'] = 'Pilih peran yang ingin Anda gunakan untuk memberikan lencana ini:';
$string['selectgroup_end'] = 'Hanya koleksi publik yang ditampilkan. <a href="{$a}"> Kunjungi ransel Anda </a> untuk membuat lebih banyak koleksi publik.';
$string['selectgroup_start'] = 'Pilih koleksi dari ransel Anda untuk ditampilkan di situs ini:';
$string['selecting'] = 'Dengan lencana terpilih ...';
$string['setup'] = 'Siapkan koneksi';
$string['sitebackpackdeleted'] = 'Ransel situs telah dihapus.';
$string['sitebackpacknotdeleted'] = 'Ransel ini tidak dapat dihapus karena saat ini merupakan bawaan situs.';
$string['sitebackpackwarning'] = 'Tidak dapat terhubung ke ransel. <br/><br/>Periksa bahwa setelan admin "Alamat surel penerbit lencana" adalah surel yang valid untuk akun di situs web ransel. <br/> <br/> Periksa apakah "Sandi penerbit lencana" di <a href="{$a-> url} "> laman setelan ransel situs </a>, adalah sandi yang benar untuk akun di situs ransel. <br/> <br/>
Ransel itu mengembalikan: "{$a->warning}"';
$string['sitebadges'] = 'Lencana situs';
$string['sitebadges_help'] = 'Lencana situs hanya dapat diberikan kepada pengguna untuk aktivitas terkait situs. Ini termasuk menyelesaikan sekumpulan kursus atau bagian dari profil pengguna. Lencana situs juga dapat dikeluarkan secara manual oleh satu pengguna ke pengguna lainnya. Lencana untuk aktivitas yang berhubungan dengan kursus harus dibuat di tingkat kursus. Lencana kursus dapat ditemukan di Administrasi kursus > Lencana.';
$string['sitebadgetitle'] = 'lencana situs {$a}';
$string['status'] = 'Status lencana';
$string['status_help'] = 'Status lencana menentukan perilakunya dalam sistem: * ** TERSEDIA ** - Berarti lencana ini dapat diperoleh oleh pengguna. Sementara lencana tersedia untuk pengguna, kriterianya tidak dapat dimodifikasi. * ** TIDAK TERSEDIA ** - Berarti lencana ini tidak tersedia untuk pengguna dan tidak dapat diperoleh atau dikeluarkan secara manual. Jika lencana tersebut belum pernah dikeluarkan sebelumnya, kriterianya dapat diubah. Setelah lencana dikeluarkan untuk setidaknya satu pengguna, secara otomatis menjadi ** TERKUNCI **. Lencana yang dikunci masih dapat diperoleh oleh pengguna, tetapi kriteria mereka tidak dapat lagi diubah. Jika Anda perlu mengubah detail atau kriteria lencana yang dikunci, Anda dapat menduplikasi lencana ini dan membuat semua perubahan yang diperlukan. * Mengapa kami mengunci lencana? * Kami ingin memastikan bahwa semua pengguna melengkapi persyaratan yang sama untuk mendapatkan lencana. Saat ini, pencabutan lencana tidak memungkinkan. Jika kami mengizinkan persyaratan lencana diubah sepanjang waktu, kemungkinan besar kami akan berakhir dengan pengguna yang memiliki lencana yang sama untuk memenuhi persyaratan yang sama sekali berbeda.';
$string['statusmessage_0'] = 'Lencana ini sekarang tidak tersedia. Aktifkan akses jika Anda menginginkan mendapatkan lencana ini.';
$string['statusmessage_1'] = 'Lencana ini saat ini tersedia untuk pengguna. Nonaktifkan akses untuk membuat perubahan.';
$string['statusmessage_2'] = 'Lencana ini saat ini tidak tersedia, dan kriterianya dikunci. Aktifkan akses jika Anda ingin pengguna mendapatkan lencana ini.';
$string['statusmessage_3'] = 'Lencana ini saat ini tersedia, dan kriterianya dikunci.';
$string['statusmessage_4'] = 'Lencana ini sekarang diarsipkan';
$string['subject'] = 'Subjek';
$string['tagarea_badge'] = 'Lencana';
$string['tags'] = 'Tagar';
$string['targetcode'] = 'Kode';
$string['targetcode_help'] = 'Pengidentifikasi string unik untuk referensi kompetensi dalam kerangkanya.';
$string['targetdescription'] = 'Deskripsi';
$string['targetdescription_help'] = 'Deskripsi singkat tentang keterampilan atau standar eksternal.';
$string['targetframework'] = 'Kerangka kerja';
$string['targetframework_help'] = 'Nama keterampilan eksternal atau kerangka standar.';
$string['targetname'] = 'Nama';
$string['targetname_help'] = 'Keterampilan atau standar eksternal yang selaras dengan lencana.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Tautan ke halaman yang menjelaskan kompetensi, keterampilan, atau standar. URL harus memiliki awalan http:// atau https://.';
$string['testbackpack'] = 'Uji ransel \'{$a}\'';
$string['testsettings'] = 'Setelan pengujian';
$string['type'] = 'Tipe';
$string['userbadges'] = 'Lencana pengguna';
$string['variablesubstitution'] = 'Substitusi variabel dalam pesan.';
$string['variablesubstitution_help'] = 'Dalam pesan lencana, variabel-variabel tertentu dapat dimasukkan ke dalam subjek dan / atau badan pesan sehingga mereka akan diganti dengan nilai-nilai nyata ketika pesan dikirim. Variabel harus dimasukkan ke dalam teks persis seperti yang ditunjukkan di bawah ini. Variabel berikut dapat digunakan:

%badgename%
: Ini akan diganti dengan nama lengkap badge.

%username%
: Ini akan diganti dengan nama lengkap penerima.

%badgelink%
: Ini akan diganti oleh URL publik dengan informasi tentang lencana yang dikeluarkan.';
$string['verifyemail'] = 'Verifikasi surel';
$string['version'] = 'Versi';
$string['version_help'] = 'Bidang versi dapat digunakan untuk melacak perkembangan lencana. Jika ditentukan, versi ditampilkan di halaman lencana.';
$string['viewbadge'] = 'Lihat lencana yang dikeluarkan';
$string['visible'] = 'Terlihat';
$string['warnexpired'] = '(Lencana ini telah kedaluwarsa)';
$string['year'] = 'Tahun';
