<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'fr', version '4.3'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Contenu de la page « À propos de nous »';
$string['aboutuscontentsetting_desc'] = 'Ce paramètre permet de rédiger le contenu pour la page « À propos de nous ».';
$string['aboutusdisabled'] = 'La page « À propos de nous » est désactivée pour ce site. Aucune information n‘est donc disponible sur cette page.';
$string['aboutusheading'] = 'À propos de nous';
$string['aboutuslinkpositionboth'] = 'Ajouter un lien vers la page « À propos de nous » dans la note de bas de page et dans le pied de page (icône « ? »)';
$string['aboutuslinkpositionfooter'] = 'Ajouter un lien vers la page « À propos de nous » dans le pied de page (icône « ? »)';
$string['aboutuslinkpositionfootnote'] = 'Ajouter un lien vers la page « À propos de nous » dans la note de bas de page';
$string['aboutuslinkpositionnone'] = 'Ne pas ajouter de lien automatiquement vers la page « À propos de nous »';
$string['aboutuslinkpositionsetting'] = 'Position du lien « À propos de nous »';
$string['aboutuslinkpositionsetting_desc'] = 'Ce paramètre vous permet d’ajouter automatiquement un lien vers la page « À propos de nous » dans le pied de page et/ou la note de bas de page. Si vous ne souhaitez pas que ce lien soit ajouté d’office, vous pouvez insérer le lien {$a->url} manuellement où cela vous convient.';
$string['aboutuspagetitledefault'] = 'À propos de nous';
$string['aboutuspagetitlesetting'] = 'Titre de la page « À propos de nous »';
$string['aboutuspagetitlesetting_desc'] = 'Ce paramètre vous permet de définir le titre de la page « À propos de nous ». Ce texte sera également le texte du lien automatique si vous l’avez configuré dans le paramètre « Position du lien À propos de nous ».';
$string['activitybrandingtab'] = 'Marquage d’activité';
$string['activityiconcoloradministrationsetting'] = 'Couleur de l’icône d’activité pour « Administration »';
$string['activityiconcoloradministrationsetting_desc'] = 'La couleur de l’icône d’activité pour « Administration »';
$string['activityiconcolorassessmentsetting'] = 'Couleur de l’icône d’activité pour « Évaluation »';
$string['activityiconcolorassessmentsetting_desc'] = 'La couleur de l’icône d’activité pour « Évaluation »';
$string['activityiconcolorcollaborationsetting'] = 'Couleur de l’icône d’activité pour « Collaboration »';
$string['activityiconcolorcollaborationsetting_desc'] = 'La couleur de l’icône d’activité pour « Collaboration »';
$string['activityiconcolorcommunicationsetting'] = 'Couleur de l’icône d’activité pour « Communication »';
$string['activityiconcolorcommunicationsetting_desc'] = 'La couleur de l’icône d’activité pour « Communication »';
$string['activityiconcolorcontentsetting'] = 'Couleur de l’icône d’activité pour « Contenu »';
$string['activityiconcolorcontentsetting_desc'] = 'La couleur de l’icône d’activité pour «  Contenu »';
$string['activityiconcolorinterfacesetting'] = 'Couleur de l’icône d’activité pour « Interface »';
$string['activityiconcolorinterfacesetting_desc'] = 'La couleur de l’icône d’activité pour « Interface »';
$string['activityiconcolorsheading'] = 'Couleurs de l’icône d’activité';
$string['activitynavigationsetting'] = 'Éléments de navigation d’activité et de section';
$string['activitynavigationsetting_desc'] = 'Avec ce paramètre, les éléments permettant de passer à l’activité / ressource précédente et suivante ainsi que le menu déroulant permettant de passer à une activité / ressource distincte s’affichent. En outre, dans les cours utilisant le mode « une section par page », des éléments similaires pour la section précédente et la section suivante sont également affichés. Des éléments d’interface utilisateur comme celui-ci existaient déjà sur Boost dans le noyau de Moodle jusqu’à Moodle 3.11, mais ont été supprimés dans 4.0. Avec Boost Union, vous pouvez les faire revenir.';
$string['activitypurposeadministration'] = 'Administration';
$string['activitypurposeassessment'] = 'Évaluation';
$string['activitypurposecollaboration'] = 'Collaboration';
$string['activitypurposecommunication'] = 'Communication';
$string['activitypurposecontent'] = 'Contenu';
$string['activitypurposeheading'] = 'Objectifs de l’icône d’activité';
$string['activitypurposeheading_desc'] = 'Ces paramètres permettent de remplacer la couleur d’arrière-plan de l’icône d’activité qui est définie par l’objectif de l’activité (et qui est une fonctionnalité de plugin codée en dur dans chaque activité).';
$string['activitypurposeheadingtechnote'] = 'Note technique : étant donné la manière dont Moodle gère les types d’activités et leurs couleurs,  Boost Union utilise exclusivement des règles CSS pour modifier les couleurs par défaut. Tous les endroits dans Moodle qui affichent des icônes d’activité colorées devraient être prises en compte. Si vous repérez un endroit dans Moodle ou dans un plugin tiers où les couleurs par défaut sont maintenues, merci de le signaler à l’adresse {$a}.';
$string['activitypurposeinterface'] = 'Interface';
$string['activitypurposeother'] = 'Autre';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistante)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (révisée)';
$string['additionalresourcesheading'] = 'Ressources additionnelles';
$string['additionalresourceslistsetting'] = 'Liste de ressources additionnelles';
$string['additionalresourceslistsetting_desc'] = 'Il s’agit de la liste des fichiers que vous avez téléchargés dans la zone de ressources supplémentaires. Les URL indiquées peuvent être utilisées pour créer un lien vers ces fichiers à partir de votre CSS personnalisé, de la note de bas de page ou de tout autre endroit dans lesquels vous avez besoin de les utiliser sans pouvoir les télécharger.';
$string['additionalresourcessetting'] = 'Ressources additionnelles';
$string['additionalresourcessetting_desc'] = 'Avec ce paramètre, vous pouvez déposer des ressources supplémentaires sur le thème. L’avantage de déposer des fichiers dans cette zone de fichiers est que ces fichiers peuvent être livrés sans vérification si l’utilisateur est connecté. C’est aussi pourquoi vous ne devez ajouter que des fichiers non critiques, accessibles par tout le monde sans être protégés par un identifiant valide. Dès que vous avez déposé au moins un fichier dans cette zone de fichiers et que vous avez enregistré les paramètres, une liste qui vous donnera l’URL que vous pouvez utiliser pour référencer un fichier particulier apparaîtra en dessous.';
$string['addpreferredlangsetting'] = 'Ajouter un lien « Langue préférée » au menu des langues';
$string['addpreferredlangsetting_desc'] = 'Ce paramètre permet d’ajouter un lien « Langue préférée » dans le menu des langues du menu utilisateur. Évidemment, ce paramètre ne sera pris en compte que si le paramètre <a href="{$a->url1}">Afficher le menu des langues</a> est activé et si au moins <a href="{$a->url2}">une deuxième langue est installée</a> et <a href="{$a->url3}">sélectionnable</a>.';
$string['administrationtab'] = 'Administration';
$string['alternativelogolinkurlsetting'] = 'URL alternative pour le lien du logo';
$string['alternativelogolinkurlsetting_desc'] = 'Ce paramètre permet de définir une URL alternative pour le lien du logo dans la barre de navigation. Vous pouvez utiliser ce paramètre pour pour renvoyer, par exemple, vers le site principal de votre institution plutôt que vers la page d’accueil de Moodle afin de proposer une navigation homogène pour toutes les applications de votre institution.';
$string['backgroundimagepositionsetting'] = 'Position de l‘image de fond';
$string['backgroundimagepositionsetting_desc'] = 'Ce paramètre permet de contrôler le positionnement de l‘image de fond dans la fenêtre du navigateur. La première valeur fixe le positionnement horizontal, la seconde le positionnement horizontal.';
$string['backgroundimagesetting'] = 'Image d’arrière-plan';
$string['backgroundimagesetting_desc'] = 'On peut télécharger ici une image personnalisée à afficher en arrière-plan du site. L’image d’arrière-plan téléchargée remplacera l’image d’arrière-plan des fichiers de préréglage de thème.';
$string['backgroundimagesheading'] = 'Image d’arrière plan générale';
$string['backtotop'] = 'Retour au début';
$string['backtotopbuttonsetting'] = 'Bouton de retour au début';
$string['backtotopbuttonsetting_desc'] = 'Avec ce paramètre, un bouton de retour en haut apparaîtra dans le coin inférieur droit de la page dès que l’utilisateur fait défiler la page. Un bouton comme celui-ci existait déjà sur Boost dans Moodle Core jusqu’à Moodle 3.11, mais a été supprimé dans 4.0. Avec Boost Union, vous pouvez le ramener.';
$string['blockdrawerwidthsetting'] = 'Largeur du tiroir des blocs';
$string['blockdrawerwidthsetting_desc'] = 'Ce paramètre permet de modifier la largeur du tiroir des blocs sans devoir faire des modifications SCSS manuelles. Par défaut, Moodle fixe une largeur maximale de 315px. Vous pouvez définir une autre valeur en pixels, mais des valeurs en pourcentage ou relatives à la largeur de la fenêtre d’affichage (vw) ne fonctionneront pas.';
$string['blockregionfooterwidth'] = 'Bloquer la largeur de la région pour la région « Pied de page »';
$string['blockregionfooterwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Pied de page ». On peut choisir entre la pleine largeur, la largeur du contenu du cours et la largeur de l’image de bandeau.';
$string['blockregionoutsidebottomwidth'] = 'Largeur de la zone du bloc « Extérieur (en bas) »';
$string['blockregionoutsidebottomwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (en bas) » qui s’affiche sous le contenu principal. On peut choisir entre la pleine largeur, la largeur du contenu du cours et la largeur du modèle.';
$string['blockregionoutsideleftwidth'] = 'Largeur de la zone du bloc « Extérieur (à gauche) »';
$string['blockregionoutsideleftwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (à gauche) » qui s’affiche sur le côté gauche de la zone de contenu principale. Par défaut, Boost Union utilise une largeur de 300px. On peut saisir d’autres valeurs basées sur les pixels comme 200px, mais également une valeur basée sur un pourcentage comme 10% ou une valeur de largeur de fenêtre comme 10vw.';
$string['blockregionoutsiderightwidth'] = 'Largeur de la zone du bloc « Extérieur (à droite) »';
$string['blockregionoutsiderightwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (à droite) » qui s’affiche sur le côté droit de la zone de contenu principale. Par défaut, Boost Union utilise une largeur de 300px. On peut saisir d’autres valeurs basées sur les pixels comme 200px, mais également saisir une valeur basée sur un pourcentage comme 10% ou une valeur de largeur de fenêtre comme 10vw.';
$string['blockregionoutsidetopwidth'] = 'Largeur de la zone du bloc « Extérieur (en haut) »';
$string['blockregionoutsidetopwidth_desc'] = 'Ce paramètre permet de définir la largeur de la zone de bloc « Extérieur (en haut) » qui s’affiche au-dessus du contenu principal. On peut choisir entre la pleine largeur, la largeur du contenu du cours et la largeur du modèle.';
$string['blockregionsforlayout'] = 'Régions de bloc supplémentaires pour la mise en page « {$a} »';
$string['blockregionsforlayout_desc'] = 'Ce paramètre permet d’activer des régions de bloc supplémentaires pour la mise en page « {$a} ».';
$string['blockregionsheading'] = 'Régions de blocs supplémentaires';
$string['blockregionsheading_desc'] = '<p>Boost Union fournit un grand nombre de régions de blocs supplémentaires qui peuvent être utilisées pour ajouter et afficher des blocs sur toute la page Moodle :</p>
<ul><li>Les <em>régions du bloc extérieur</em> sont placées sur les quatre côtés de la page Moodle. Ils peuvent être utilisés pour afficher des blocs qui accompagnent la page Moodle affichée mais n’appartiennent pas directement au contenu principal.</li>
<li>La <em>région du bloc d’en-tête</em> est placée entre la zone Extérieure (en haut) et la zone de contenu principale. Elle peut être utilisée pour afficher un bloc en tant qu’informations d’en-tête de cours.</li>
<li>Les <em>régions du bloc de contenu</em> sont placées directement au-dessus et en dessous du contenu principal dans la zone de contenu principale. Elles peuvent être utilisées pour ajouter des blocs au flux de contenu du cours.</li>
<li>Les <em>régions du bloc de pied de page</em> sont placées en bas de la page entre la zone Extérieure (en bas) et la note de bas de page. Trois zones de pied de page sont disponibles pour créer des colonnes si nécessaire.</li>
<li>La <em>région de bloc hors canevas</em> est en quelque sorte spéciale car elle survole toute la page Moodle en tant que tiroir. Le tiroir est ouvert par l’icône à 9 points tout à droite de la barre de navigation. Trois régions hors canevas sont disponibles pour créer des colonnes si nécessaire.</li></ul>
<p>À noter :</p>
<ul><li>Par défaut, toutes les régions de bloc supplémentaires sont désactivées. Les régions de bloc particulières sur les mises en page particulières peuvent être activées en fonction des besoins. Mieux vaut condenser autant que possible : un trop grand nombre de régions de blocs pourrait submerger les utilisateurs finaux.</li>
<li>Dès qu’une région de bloc supplémentaire est activée, elle est visible pour tous les utilisateurs authentifiés et modifiable par les enseignants et les gestionnaires (selon le fait que l’utilisateur particulier est autorisé à modifier la page Moodle particulière, bien sûr). Mais il existe également des fonctionnalités theme/boost_union:viewregion* et theme/boost_union:editregion* qui permettent d’affiner l’utilisation de chaque région de bloc en fonction de vos besoins.</li>
<li>Les régions des blocs Extérieure (gauche), Extérieure (droite), Contenu (supérieur), Contenu (inférieur) et En-tête ne sont pas disponibles pour toutes les mises en page.</li></ul>';
$string['blockregionsheading_experimental'] = 'Remarque : les régions de bloc <em>Extérieur (gauche) et Extérieur (droit)</em> fonctionnent pleinement dans l’état actuel de la mise en œuvre, mais doivent être <em>considérées comme expérimentales</em> car elles ne vont pas encore couvrir correctement les écrans de largeur moyenne. Dans ce contexte, elles sont à utiliser avec précaution. Ce problème sera résolu dans une prochaine version.';
$string['blocksgeneralheading'] = 'Blocs généraux';
$string['blockstab'] = 'Blocs';
$string['boost_union:configure'] = 'Pour pouvoir configurer le thème en tant que non-administrateur';
$string['boost_union:editregioncontentlower'] = 'Pour pouvoir modifier la région du bloc Contenu (inférieur)';
$string['boost_union:editregioncontentupper'] = 'Pour pouvoir modifier la région du bloc Contenu (supérieur)';
$string['boost_union:editregionfootercenter'] = 'Pour pouvoir modifier la région du bloc Pied de page (centre)';
$string['boost_union:editregionfooterleft'] = 'Pour pouvoir modifier la région du bloc Pied de page (gauche)';
$string['boost_union:editregionfooterright'] = 'Pour pouvoir modifier la région du bloc Pied de page (droite)';
$string['boost_union:editregionheader'] = 'Pour pouvoir modifier la région du bloc d’en-tête';
$string['boost_union:editregionoffcanvascenter'] = 'Pour pouvoir modifier la région de bloc hors canevas (centre)';
$string['boost_union:editregionoffcanvasleft'] = 'Pour pouvoir modifier la région de bloc hors canevas (gauche)';
$string['boost_union:editregionoffcanvasright'] = 'Pour pouvoir modifier la région de bloc hors canevas (droite)';
$string['boost_union:editregionoutsidebottom'] = 'Pour pouvoir modifier la région de bloc extérieur (en bas)';
$string['boost_union:editregionoutsideleft'] = 'Pour pouvoir modifier la région de bloc extérieur (à gauche)';
$string['boost_union:editregionoutsideright'] = 'Pour pouvoir modifier la région de bloc extérieur (à droite)';
$string['boost_union:editregionoutsidetop'] = 'Pour pouvoir modifier la région de bloc extérieur (en haut)';
$string['boost_union:viewhintcourseselfenrol'] = 'Pour pouvoir obtenir un indice d’auto-inscription libre à un cours visible.';
$string['boost_union:viewhintinhiddencourse'] = 'Pour pouvoir obtenir un indice pour un cours caché.';
$string['boost_union:viewregioncontentlower'] = 'Pour pouvoir voir la région du bloc Contenu (inférieur)';
$string['boost_union:viewregioncontentupper'] = 'Pour pouvoir voir la région du bloc Contenu (supérieur)';
$string['boost_union:viewregionfootercenter'] = 'Pour pouvoir voir la région du bloc Pied de page (centre)';
$string['boost_union:viewregionfooterleft'] = 'Pour pouvoir voir la région du bloc Pied de page (gauche)';
$string['boost_union:viewregionfooterright'] = 'Pour pouvoir voir la région du bloc Pied de page (droite)';
$string['boost_union:viewregionheader'] = 'Pour pouvoir voir la région du bloc d’en-tête';
$string['boost_union:viewregionoffcanvascenter'] = 'Pour pouvoir voir la région de bloc hors canevas (centre)';
$string['boost_union:viewregionoffcanvasleft'] = 'Pour pouvoir voir la région de bloc hors canevas (gauche)';
$string['boost_union:viewregionoffcanvasright'] = 'Pour pouvoir voir la région de bloc hors canevas (droite)';
$string['boost_union:viewregionoutsidebottom'] = 'Pour pouvoir voir la région du bloc extérieur (en bas)';
$string['boost_union:viewregionoutsideleft'] = 'Pour pouvoir voir la région du bloc extérieur (à gauche)';
$string['boost_union:viewregionoutsideright'] = 'Pour pouvoir voir la région du bloc extérieur (à droite)';
$string['boost_union:viewregionoutsidetop'] = 'Pour pouvoir voir la région du bloc extérieur (au-dessus)';
$string['bootstrapcolordangersetting'] = 'Couleur Bootstrap pour « Danger »';
$string['bootstrapcolordangersetting_desc'] = 'La couleur Bootstrap pour « Danger »';
$string['bootstrapcolorinfosetting'] = 'Couleur Bootstrap pour « Info »';
$string['bootstrapcolorinfosetting_desc'] = 'La couleur Bootstrap pour « Info »';
$string['bootstrapcolorsheading'] = 'Couleurs Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Couleur Bootstrap pour « Succès »';
$string['bootstrapcolorsuccesssetting_desc'] = 'La couleur Bootstrap pour « Succès »';
$string['bootstrapcolorwarningsetting'] = 'Couleur Bootstrap pour « Attention »';
$string['bootstrapcolorwarningsetting_desc'] = 'Couleur Bootstrap pour « Attention »';
$string['bootstrapdangercolor'] = 'Couleur de danger';
$string['bootstrapdarkcolor'] = 'Couleur sombre';
$string['bootstrapinfocolor'] = 'Couleur d’info';
$string['bootstraplightcolor'] = 'Couleur claire';
$string['bootstrapnone'] = 'Pas de couleur Bootstrap';
$string['bootstrapprimarycolor'] = 'Couleur primaire';
$string['bootstrapsecondarycolor'] = 'Couleur secondaire';
$string['bootstrapsuccesscolor'] = 'Couleur de succès';
$string['bootstrapwarningcolor'] = 'Couleur d’attention';
$string['brandcolorsheading'] = 'Couleurs de la marque';
$string['breadcrumbsheading'] = 'Fil d’Ariane';
$string['cachedef_flavours'] = 'Variantes qui s’appliquent à un numéro d’identifiant de catégorie de page donné pour l’utilisateur actuel';
$string['cachedef_smartmenu_items'] = 'Éléments du menu intelligent';
$string['cachedef_smartmenus'] = 'Menus intelligents';
$string['cachedef_touchiconsios'] = 'Icônes pour écran d‘accueil iOS';
$string['categorybreadcrumbs'] = 'Afficher le fil d’Ariane de la catégorie dans l’en-tête du cours';
$string['categorybreadcrumbs_desc'] = 'Par défaut, les fils d’Ariane de la catégorie de cours ne sont pas affichés sur les pages de cours dans l’en-tête du cours. Ce paramètre permet d’afficher le fil d’Ariane de la catégorie de cours dans l’en-tête du cours au-dessus du nom du cours.<br/><br/>
Remarque : l’option « Ne rien changer » ne change rien au fil d’Ariane de la catégorie de cours tel qu’il est présenté par le noyau Moodle. Alors que l’option « Non » veille à ce que les fils d’Ariane des catégories de cours ne soient jamais affichés du tout. Cela pourrait être une différence car Boost dans le noyau de Moodle pourrait en effet montrer des fils d’Ariane de catégorie de cours commençant sur des niveaux de catégorie de cours imbriqués plus profonds (ce que les développeurs de Boost Union considèrent comme un problème).';
$string['choosereadme'] = '<p>Theme Boost Union est un thème enfant amélioré de Boost qui vise, d’une part, à rendre Boost simplement plus configurable et, d’autre part, à fournir des fonctionnalités supplémentaires utiles pour le fonctionnement quotidien de Moodle par les administrateurs, les enseignants et étudiants.</p><p>Boost Union est géré par<br />Moodle an Hochschulen e.V.,</p><p>en coopération avec<br />lern.link GmbH</p><p>ainsi que<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Fermer le tiroir hors canevas';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Contenu';
$string['configtitlefeel'] = 'Sensation';
$string['configtitleflavours'] = 'Variantes';
$string['configtitlefunctionality'] = 'Fonctionnalité';
$string['configtitlelook'] = 'Apparence';
$string['contactcontentsetting'] = 'Contenu de la page Contact';
$string['contactcontentsetting_desc'] = 'Ce réglage permet d’ajouter du contenu en texte enrichi qui sera affiché sur une page de contact (qui n’est pas la même que la page intégrée Moodle « Contacter l’assistance du site »).';
$string['contactdisabled'] = 'La page de contact est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['contactheading'] = 'Contact';
$string['contactlinkpositionboth'] = 'Ajouter à la note de bas de page et à l’icône de pied de page (point d’interrogation) un lien vers la page de contact';
$string['contactlinkpositionfooter'] = 'Ajouter à l’icône du pied de page (point d’interrogation) un lien vers la page de contact';
$string['contactlinkpositionfootnote'] = 'Ajouter à la note de bas de page un lien vers la page de contact';
$string['contactlinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page de contact';
$string['contactlinkpositionsetting'] = 'Position du lien de la page de contact';
$string['contactlinkpositionsetting_desc'] = 'Ce réglage permet de configurer si un lien vers la page de contact doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, vous pouvez en ajouter manuellement vers {$a->url} depuis n’importe où dans Moodle.';
$string['contactpagetitledefault'] = 'Contact';
$string['contactpagetitlesetting'] = 'Titre de la page Contact';
$string['contactpagetitlesetting_desc'] = 'Ce réglage permet de définir le titre de la page de contact. Ce texte sera également utilisé comme texte de lien vers la page de contact si vous configurez la « Position du lien de la page de contact » en conséquence.';
$string['contentwidthheading'] = 'Largeur du contenu';
$string['coursecontentmaxwidthsetting'] = 'Largeur maximale du contenu du cours';
$string['coursecontentmaxwidthsetting_desc'] = 'Ce paramètre permet de remplacer la largeur du contenu par défaut de Moodle sans modifications SCSS manuelles. Cette largeur est utilisée comme largeur de page des pages de cours et dans plusieurs activités. Par défaut, Moodle utilise une largeur maximale du contenu de cours de 830px. Il est possible de saisir d’autres valeurs basées sur les pixels comme 1200px, mais également de saisir une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['courseheaderheading'] = 'En-tête du cours';
$string['courseheaderimageenabled'] = 'Afficher l’image du cours dans l’en-tête du cours';
$string['courseheaderimageenabled_desc'] = 'Lorsqu’elle est activée, l’image du cours (qui peut être déposée dans les paramètres de cours d’un cours) s’affiche dans l’en-tête d’un cours. Les images des cours y sont affichées en plus de la page « Mes cours » où elles sont toujours affichées.';
$string['courseheaderimagefallback'] = 'Image de remplacement de l’en-tête du cours';
$string['courseheaderimagefallback_desc'] = 'Une image déposée dans ce réglage sera utilisée comme image de remplacement et s’affiche dans l’en-tête du cours si aucune image de cours n’est déposée dans les paramètres de cours d’un cours particulier. Si vous ne déposez pas d’image ici, une image d’en-tête de cours n’est affichée dans un cours particulier que si une image de cours est déposée dans les paramètres de cours de ce cours particulier.';
$string['courseheaderimageheight'] = 'Hauteur de l’image d’en-tête du cours';
$string['courseheaderimageheight_desc'] = 'Ce réglage permet de contrôler la hauteur de l’image d’en-tête du cours présentée.';
$string['courseheaderimagelayout'] = 'Mise en page de l’image d’en-tête du cours';
$string['courseheaderimagelayout_desc'] = 'Ce paramètre permet de contrôler la mise en page de l’image d’en-tête du cours et du titre du cours.';
$string['courseheaderimagelayoutheadingabove'] = 'Titre du cours au-dessus de l’image du cours';
$string['courseheaderimagelayoutstackeddark'] = 'Titre du cours superposé sur l’image du cours (couleur de police blanche pour les images d’arrière-plan sombre)';
$string['courseheaderimagelayoutstackedlight'] = 'Titre du cours superposé sur l’image du cours (couleur de police noire pour les images d’arrière-plan clair)';
$string['courseheaderimageposition'] = 'Position de l’image d’en-tête du cours';
$string['courseheaderimageposition_desc'] = 'Ce paramètre permet de contrôler le positionnement de l’image d’en-tête de cours dans le conteneur d’images d’en-tête de cours. La première valeur est la position horizontale, la deuxième valeur est la position verticale.';
$string['courseindexcompletioninfoposition'] = 'Position de l‘indicateur d‘achèvement d‘activité';
$string['courseindexcompletioninfoposition_desc'] = 'Choisissez la position de l‘indicateur d‘achèvement d‘activité dans l‘index de cours. <em>Fin de ligne</em> dispose l‘indicateur d‘achèvement standard à droite du titre de l‘activité. <em>Début de ligne</em> le positionne à gauche du titre de l‘activité. <em>Couleur d‘icône</em> remplace l‘indicateur d‘achèvement standard par une couleur d’arrière plan au niveau de l‘icône d‘activité.';
$string['courseindexcompletioninfopositionendofline'] = 'Fin de ligne';
$string['courseindexcompletioninfopositioniconcolor'] = 'Couleur d‘icône';
$string['courseindexcompletioninfopositionstartofline'] = 'Début de ligne';
$string['courseindexdrawerwidthsetting'] = 'Largeur de l‘index de cours';
$string['courseindexdrawerwidthsetting_desc'] = 'Ce paramètre permet de modifier la largeur par défaut de l‘index de cours devoir effectuer des modifications SCSS manuelles. Par défaut, Moodle fixe cette largeur à 285px. Vous pouvez définir une autre valeur en pixels, mais des valeurs en pourcentage ou basées sur la largeur de la fenêtre d‘affichage ne fonctionneront pas.';
$string['courseindexheading'] = 'Index de cours';
$string['courseindexmodiconenabled'] = 'Afficher les icônes d‘activités dans l‘index de cours';
$string['courseindexmodiconenabled_desc'] = 'Si activé, l‘icône représentant le type d‘activité sera affiché à gauche du titre de l‘activité. Ce faisant, soit l‘icône déplace l‘indicateur d‘achèvement d‘activité à droite du titre de l‘activité, soit il remplace cet indicateur en revêtant la couleur d‘état d‘achèvement en arrière-plan.';
$string['coursemanagementheading'] = 'Gestion des cours';
$string['courseoverviewheading'] = 'Bloc « Vue d‘ensemble des cours »';
$string['courseoverviewshowcourseimagessetting'] = 'Afficher les images de cours';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Ce paramètre permet d‘afficher ou non les images de cours dans le bloc « Vue d‘ensemble des cours ». Ce paramètre est réglable individuellement pour les différentes vues (Cartes, Liste et Résumé).';
$string['courseoverviewshowprogresssetting'] = 'Afficher la progression dans le cours';
$string['courseoverviewshowprogresssetting_desc'] = 'Ce paramètre permet d‘afficher ou non la progression dans le cours dans le bloc « Vue d‘ensemble des cours ».';
$string['courserelatedhintsheading'] = 'Conseils liés au cours';
$string['coursestab'] = 'Cours';
$string['coursetab'] = 'Cours';
$string['cssh5pheading'] = 'CSS brut pour H5P';
$string['cssh5psetting'] = 'CSS brut pour H5P';
$string['cssh5psetting_desc'] = 'Utiliser ce champ pour fournir le code CSS qui sera appliqué à la présentation du contenu H5P par mod_h5p et mod_hvp. Inspecter les types de contenu H5P pour trouver les sélecteurs CSS nécessaires.';
$string['customfontsfileurlpersistent'] = 'URL (persistante)';
$string['customfontsfileurlrevisioned'] = 'URL (révisée)';
$string['customfontsheading'] = 'Polices personnalisées';
$string['customfontslistsetting'] = 'Liste des polices personnalisées';
$string['customfontslistsetting_desc'] = 'Il s’agit de la liste des polices que vous avez téléchargées dans la zone de fichiers des polices personnalisées. Les extraits CSS donnés peuvent être utilisés pour ajouter ces polices à votre SCSS personnalisé. Veuillez noter que vous devrez vous occuper vous-même de la valeur du format de police ainsi que des propriétés CSS font-family, font-style et font-weight pour le moment, car Boost Union n’est pas encore en mesure d’analyser les fichiers de police.';
$string['customfontssetting'] = 'Polices personnalisées';
$string['customfontssetting_desc'] = 'Avec ce paramètre, vous pouvez télécharger des polices personnalisées sur le thème. L’avantage de télécharger des polices dans cette zone de fichiers est que ces polices peuvent être livrées sans vérification si l’utilisateur est connecté et peuvent être utilisées comme polices installées localement partout sur le site. Dès que vous avez déposé au moins une police dans cette zone de fichiers et que vous avez enregistré les paramètres, une liste qui vous donnera des extraits de code CSS que vous pouvez utiliser comme passe-partout pour référencer des polices particulières dans votre SCSS personnalisé, apparaîtra en dessous.';
$string['dashboardtab'] = 'Tableau de bord / Mes cours';
$string['dontchange'] = 'Ne rien changer';
$string['drawerwidthheading'] = 'Largeur du tiroir';
$string['emailbrandinghtmldemobody'] = '<p>Le corps du courriel commence ici.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Le corps du courriel se termine ici.</p>';
$string['emailbrandinghtmlheading'] = 'Aperçu du courriel HTML';
$string['emailbrandinghtmlintro'] = 'Il s’agit de l’aperçu d’un courriel HTML basé sur les préfixes et suffixes de marque actuellement définis dans le paquetage de langue.';
$string['emailbrandinghtmlnopreview'] = 'Jusqu’à présent, les courriels HTML n’ont pas été personnalisés dans cette fonctionnalité. Ils seront composés et envoyés normalement.';
$string['emailbrandinginstruction'] = 'Comment';
$string['emailbrandinginstruction0'] = 'Avec cette fonctionnalité Boost Union, vous pouvez appliquer une image de marque à tous les courriels envoyés par Moodle.';
$string['emailbrandinginstructionli1'] = 'Aller à la <a href="{$a->url}" target="_blank">page des paramètres de personnalisation de la langue</a> pour ouvrir le paquetage de langue <em>{$a->lang}</em> en mode édition.';
$string['emailbrandinginstructionli2'] = 'Rechercher et modifier ces chaînes dans le paquetage de langue <code>theme_boost_union</code> :';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code> : cet extrait sera ajouté <em>au début / avant le corps</em> de tous les <em>courriels HTML</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code> : cet extrait sera ajouté <em>à la fin / après le corps</em> de tous les <em>courriels HTML</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailhtmlprefix</code> : cet extrait sera ajouté <em>au début / avant le corps</em> de tous les <em>courriels texte</em> que Moodle envoie.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code> : cet extrait sera ajouté <em>à la fin / après le corps</em> de tous les <em>courriels texte</em> que Moodle envoie.';
$string['emailbrandinginstructionli3'] = 'Enregistrer les modifications apportées au paquetage de langue.';
$string['emailbrandinginstructionli4'] = 'Revenir sur cette page et visualiser les aperçus des courriels ci-dessous.';
$string['emailbrandingintroheading'] = 'Introduction';
$string['emailbrandingintronote'] = 'Remarque : il s’agit d’une fonctionnalité avancée qui utilise des solutions de contournement pour fournir des options de personnalisation des courriels. Veuillez suivre attentivement les instructions.';
$string['emailbrandingpitfalls'] = 'Pièges';
$string['emailbrandingpitfalls0'] = 'En utilisant cette fonctionnalité, vous devez être conscient de certains pièges :';
$string['emailbrandingpitfallsli1'] = 'Il est obligatoire de modifiier les chaînes du pack de langue de la <em>langue par défaut actuelle</em> de ce site. Même si plusieurs modules linguistiques sont installés, seules les modifications apportées à la langue par défaut seront impactées.';
$string['emailbrandingpitfallsli2'] = 'Le respect de la langue du destinataire n’est pas possible. Ainsi, il faut utiliser des termes indépendants de la langue dans vos extraits de marque de messagerie électronique.';
$string['emailbrandingpitfallsli3'] = 'Si la langue par défaut du site est modifier, il faudra migrer les chaînes du paquetage de langue modifié vers le nouveau paquetage de langue par défaut.';
$string['emailbrandingpitfallsli4'] = 'Dans les courriels en texte brut, il y a un saut de ligne et une ligne vide ajoutés automatiquement après le préfixe et une ligne vide ajoutée automatiquement avant l’extrait de suffixe. Cela permet de s’assurer que le suffixe et le préfixe ne collent pas directement au corps du courriel.';
$string['emailbrandingpitfallsli5'] = 'Dans les courriels en HTML, le préfixe et le suffixe sont directement ajoutés avant et au-dessus du corps du courriel. Cela permet de s’assurer de pouvoir travailler facilement avec les balises HTML, mais tout l’espace autour du corps devra être géré manuellement.';
$string['emailbrandingpitfallsli6'] = 'Dans les courriels en HTML, on peut ouvrir une balise HTML dans l’extrait de préfixe et fermer la balise dans l’extrait de suffixe sans problème. Ne pas oublier de créer un code HTML valide dans le courriel résultant.';
$string['emailbrandingtab'] = 'Étiquette de messagerie électronique';
$string['emailbrandingtextdemobody'] = 'Le corps de l’e-mail commence ici.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Le corps de l’e-mail se termine ici.';
$string['emailbrandingtextheading'] = 'Aperçu des courriels en texte brut';
$string['emailbrandingtextintro'] = 'Il s’agit d’un aperçu d’un courriel en clair basé sur les préfixes et suffixes de marque actuellement définis dans le paquetage de langue.';
$string['emailbrandingtextnopreview'] = 'Jusqu’à présent, les courriels texte n’ont pas été personnalisés dans cette fonctionnalité. Ils seront composés et envoyés normalement.';
$string['enableaboutussetting'] = 'Activer la page « À propos de nous »';
$string['enablecontactsetting'] = 'Activer la page de contact';
$string['enablefooterbutton'] = 'Afficher le pied de page';
$string['enablefooterbutton_desc'] = 'Par « pied de page » on entend le point d‘interrogation dans un cercle en bas à droite de la page.<br/>Une fenêtre surgissante apparaît au clic. En fonction du paramétrage de Moodle, un ensemble de liens est proposé dans cette fenêtre (par exemple « Documentation pour cette page » ou « Résumé de conservation des données ».<br/>Ce paramètre permet d‘afficher ou non ce bouton en bas de la page.';
$string['enablefooterbuttonboth'] = 'Afficher sur ordinateur de bureau, tablette et smartphone';
$string['enablefooterbuttondesktop'] = 'Afficher uniquement sur ordinateur de bureau et tablette, masquer sur smartphone (comportement par défaut de Moodle)';
$string['enablefooterbuttonhidden'] = 'Masquer sur tous les dispositifs';
$string['enablefooterbuttonmobile'] = 'Afficher uniquement sur smartphone, masquer sur ordinateur de bureau et tablette';
$string['enablehelpsetting'] = 'Activer la page d’aide';
$string['enableimprintsetting'] = 'Activer l’impression';
$string['enablemaintenancesetting'] = 'Activer la page d’informations sur la maintenance';
$string['enableofferssetting'] = 'Activer la page des offres';
$string['enablepage1setting'] = 'Activer la page personnalisée 1';
$string['enablepage2setting'] = 'Activer la page personnalisée 2';
$string['enablepage3setting'] = 'Activer la page personnalisée 3';
$string['error:infobannerdismissnonotdismissible'] = 'La bannière d’information donnée n’est pas dissimulable';
$string['error:infobannerdismissnonotvalid'] = 'Le numéro de bannière d’information donné n’est pas valide';
$string['error:smartmenusmenuitemnotfound'] = 'Élément de menu intelligent introuvable';
$string['error:smartmenusmenunotfound'] = 'Menu intelligent introuvable';
$string['extscssgithubpostfilepath'] = 'Chemin du fichier Post SCSS Github externe';
$string['extscssgithubpostfilepath_desc'] = 'Le chemin dans le référentiel Github privé où se trouve le fichier Post SCSS.';
$string['extscssgithubprefilepath'] = 'Chemin externe du fichier Github pré-SCSS';
$string['extscssgithubprefilepath_desc'] = 'Le chemin dans le référentiel Github privé où se trouve le fichier Pré-SCSS.';
$string['extscssgithubrepo'] = 'Dépôt externe d’API SCSS Github';
$string['extscssgithubrepo_desc'] = 'Le référentiel Github privé où se trouvent les fichiers SCSS.';
$string['extscssgithubtoken'] = 'Jeton d’API SCSS Github externe';
$string['extscssgithubtoken_desc'] = 'Le jeton API Github qui sera utilisé pour récupérer le code SCSS du référentiel Github privé donné.';
$string['extscssgithubtoken_docs'] = 'Accéder aux paramètres <a href="https://github.com/settings/tokens"> de votre jeton Github</a> pour générer un jeton API et consulter la documentation officielle.';
$string['extscssgithubuser'] = 'Utilisateur externe de l’API SCSS Github';
$string['extscssgithubuser_desc'] = 'L’utilisateur ou l’organisation de l’API Github qui possède le référentiel Github privé.';
$string['extscssheading'] = 'SCSS Externes';
$string['extscssheading_desc'] = 'En plus des paramètres SCSS bruts ci-dessus, Boost Union peut charger des SCSS à partir d’une source externe. Il est inclus avant le code SCSS défini ci-dessus, ce qui signifie que vous pouvez gérer une base de code SCSS externe centralisée et que vous pouvez toujours la modifier avec des ajouts SCSS locaux.';
$string['extscssheading_drop'] = 'Si Boost Union ne peut pas récupérer le fichier SCSS externe pour une raison quelconque, il ignorera simplement le fichier SCSS externe pour éviter les problèmes de compilation SCSS et les interfaces inaccessibles.';
$string['extscssheading_instr'] = 'Instructions';
$string['extscssheading_prepost'] = 'Tout comme les paramètres SCSS bruts ci-dessus, le SCSS externe est divisé en deux parties : Pré et Post SCSS. Pré SCSS peut être utilisé pour initialiser les variables SCSS, Post SCSS est utilisé pour votre code SCSS réel.';
$string['extscssheading_sources'] = 'Vous pouvez configurer Boost Union pour récupérer le fichier SCSS externe soit à partir d’une URL de téléchargement publique (qui sera consultée et récupérée avec une requête cURL non authentifiée) soit à partir d’un référentiel Github privé (qui sera consulté et récupéré avec un jeton API Github).';
$string['extscssheading_structure'] = 'Le SCSS externe doit être fourni sous forme de fichier texte brut, sans en-tête ni pied de page, contenant uniquement le code SCSS.';
$string['extscssheading_task'] = 'Il existe une <a href="{$a}">tâche planifiée theme_boost_union\\task\\purge_cache</a> qui est désactivée par défaut mais que vous pouvez activer si vous souhaitez que Boost Union récupère et compile périodiquement le code SCSS externe.';
$string['extscsssource'] = 'Source SCSS externe';
$string['extscsssource_desc'] = 'Choisir le type de source à partir de laquelle vous souhaitez récupérer le SCSS externe.';
$string['extscsssourcedownload'] = 'URL de téléchargement publique';
$string['extscsssourcegithub'] = 'Dépôt Github privé';
$string['extscsssourcenone'] = 'Aucun';
$string['extscssurlpost'] = 'URL de téléchargement Post SCSS externe';
$string['extscssurlpost_desc'] = 'L’URL de téléchargement publique à partir de laquelle le Post SCSS externe doit être récupéré.';
$string['extscssurlpre'] = 'URL de téléchargement externe pré-SCSS';
$string['extscssurlpre_desc'] = 'L’URL de téléchargement publique à partir de laquelle le pré-SCSS externe doit être récupéré.';
$string['extscssvalidationsetting'] = 'Validation SCSS externe';
$string['extscssvalidationsetting_desc'] = 'Si ce paramètre est activé, le SCSS externe est validé s’il peut être compilé avant d’être ajouté à la pile SCSS. Le code SCSS externe qui ne peut pas être compilé est ignoré en silence et n’est pas utilisé. Cependant, cette validation n’est exécutée que sur le code SCSS externe, elle n’est pas exécutée sur la pile SCSS combinée qui serait le résultat de l’intégration du SCSS externe. Cela signifie que, dès que vous utilisez des variables SCSS du noyau Moodle ou Bootstrap dans votre SCSS externe, vous devez désactiver la validation et vérifier vous-même que le code SCSS est valide pour éviter les interfaces inaccessibles.';
$string['faviconheading'] = 'Icône de favori';
$string['faviconheading_desc'] = 'Remarque : Boost Union a son propre téléchargement de favicon et n’utilise pas le favicon du <a href="{$a}">paramètre de favicon du noyau Moodle</a>.<br />Boost Union permet en particulier de remplacer le téléchargement de favicon par des variantes.';
$string['faviconsetting'] = 'Icône de favori';
$string['faviconsetting_desc'] = 'Ici, vous pouvez télécharger une image personnalisée (format .ico ou .png) que le navigateur affichera comme icône de favori de votre site Web Moodle. Si aucune icône de favori personnalisée n’est téléchargée, une icône de favori Moodle standard sera utilisée.';
$string['flavoursappliesto'] = 'Appliquer à';
$string['flavoursapplytocategories'] = 'Appliquer aux catégories de cours';
$string['flavoursapplytocategories_help'] = 'Ici, on définit si cette variante doit être appliquée aux catégories de cours.';
$string['flavoursapplytocategories_ids'] = 'Catégories de cours';
$string['flavoursapplytocategories_ids_help'] = 'Ici, on définit une ou plusieurs catégories de cours particulières auxquelles cette variante doit être appliquée. Dès que la page Moodle fournie se trouve dans l’une des catégories de cours configurées, la variante est appliquée.';
$string['flavoursapplytocohorts'] = 'Appliquer aux cohortes';
$string['flavoursapplytocohorts_help'] = 'On définit ici si cette variante doit être appliquée aux cohortes.';
$string['flavoursapplytocohorts_ids'] = 'Cohortes';
$string['flavoursapplytocohorts_ids_help'] = 'Ici, on définit une ou plusieurs cohortes particulières auxquelles cette variante doit être appliquée. Dès que l’utilisateur est membre d’une des cohortes configurées, la variante est appliquée.<br /><br />À noter que, si on définit plus d’une cohorte, il n’est pas nécessaire que l’utilisateur soit un membre de toutes en même temps.<br /><br />À noter également qu’en l’état actuel de la mise en œuvre, les cohortes de catégories sont traitées comme s’il s’agissait de cohortes du système.';
$string['flavoursbackgroundimage'] = 'Image d’arrière plan';
$string['flavoursbackgroundimage_help'] = 'Avec ce paramètre, la variante remplacera l’image d’arrière-plan qui est configurée dans les paramètres d’apparence de Boost Union.';
$string['flavoursbacktooverview'] = 'Retour à l’aperçu des variantes';
$string['flavourscreateflavour'] = 'Créer la variante';
$string['flavoursdelete'] = 'Supprimer';
$string['flavoursdeleteconfirmation'] = 'Voulez-vous vraiment supprimer la variante <em>{$a}</em> ?';
$string['flavoursdeleteflavour'] = 'Supprimer la variante';
$string['flavoursdescription'] = 'Description';
$string['flavoursdescription_help'] = 'La description de la variante est juste utilisée en interne pour permettre d’identifier une variante particulière dans la liste des variantes.';
$string['flavoursedit'] = 'Modifier';
$string['flavourseditflavour'] = 'Modifier la variante';
$string['flavoursfavicon'] = 'Icône de favori';
$string['flavoursfavicon_help'] = 'Avec ce paramètre, la variante remplacera l’icône de favori qui est configuré dans les paramètres d’apparence de Boost Union.';
$string['flavoursflavours'] = 'variantes';
$string['flavoursgeneralsettings'] = 'Réglages généraux';
$string['flavoursincludesubcategories'] = 'Inclure les sous-catégories';
$string['flavoursincludesubcategories_help'] = 'Si cochée, la variante sera également appliquée aux sous-catégories des catégories choisies.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Avec ce paramètre, la variante remplacera le logo qui est configuré dans les paramètres d’apparence de Boost Union.';
$string['flavourslogocompact'] = 'Logo compact';
$string['flavourslogocompact_help'] = 'Avec ce paramètre, la variante remplacera le logo qui est configuré dans les paramètres d’apparence de Boost Union.';
$string['flavoursnothingtodisplay'] = 'Il n’y a pas encore de variantes créées. Veuillez créer votre première variante pour faire avancer les choses.';
$string['flavoursnotificationcreated'] = 'La variante a été créée avec succès';
$string['flavoursnotificationdeleted'] = 'La variante a été supprimée avec succès';
$string['flavoursnotificationedited'] = 'La variante a été modifiée avec succès';
$string['flavoursoverview_desc'] = '<p>Les variantes de Boost Union offrent la possibilité de remplacer certains paramètres d’apparence et de convivialité de Moodle dans des contextes particuliers. Sur cette page, on peut créer et gérer des variantes.</p><p>Dans chaque variante, on définit si elle doit être appliquée à des catégories de cours particulières ou à des cohortes particulières. Ensuite, lors de chaque rendu de page Moodle, Boost Union vérifie si une variante s’applique. À noter que, pour chaque rendu de page Moodle, seule la première version correspondante de la liste est appliquée et les versions restantes sont ignorées. Ainsi, l’ordre des variantes sur cette page est essentiel.</p><p>À noter également qu’après chaque modification apportée à l’ensemble des variantes, le cache du thème est purgé. Cela est nécessaire pour s’assurer que tous les éléments sont correctement envoyés et mis à jour dans le navigateur.</p>';
$string['flavourspreview'] = 'Aperçu';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Aperçu de la variante';
$string['flavourstitle'] = 'Titre';
$string['flavourstitle_help'] = 'Le titre de la variante est simplement utilisé en interne pour permettre de documenter une variante particulière dans la liste des variantes.';
$string['footerheading'] = 'Pied de page';
$string['footersuppresschatsetting'] = 'Supprimer le lien « Salle de conversation du cours »';
$string['footersuppresschatsetting_desc'] = 'Ce paramètre permet de supprimer le lien « Salle de conversation du cours » dans le pied de page. Ce lien apparaît par défaut dès qu‘une salle de conversation est configurée dans les paramètres du cours.';
$string['footersuppresscontactsetting'] = 'Supprimer le lien « Contacter l‘assistance du site »';
$string['footersuppresscontactsetting_desc'] = 'Ce paramètre permet de supprimer le lien « Contacter l‘assistance du site » dans le pied de page. Ce lien apparaît par défaut si le paramètre <a href="{$a->url}">Lien contact d‘assistance</a> est défini.';
$string['footersuppressfeedbacksetting'] = 'Supprimer le lien « Envoyer un feedback sur ce logiciel »';
$string['footersuppressfeedbacksetting_desc'] = 'Ce paramètre permet de supprimer le lien « Envoyer un feedback sur ce logiciel » dans le pied de page. Ce lien apparaît par défaut si le paramètre <a href="{$a->url}">Activer le feedback à propos de ce logiciel</a> est activé.';
$string['footersuppresshelpsetting'] = 'Supprimer le lien « Documentation pour cette page »';
$string['footersuppresshelpsetting_desc'] = 'Ce paramètre permet de supprimer le lien « Documentation pour cette page » dans le pied de page. Ce lien apparaît par défaut si le paramètre <a href="{$a->url}">URL du site Moodle Docs</a> est défini.';
$string['footersuppressiconssetting'] = 'Supprimer les icônes devant les liens de pied de page';
$string['footersuppressiconssetting_desc'] = 'Avec ce paramètre, vous pouvez supprimer entièrement les icônes devant les liens de pied de page. « Documentation pour cette page » comporte une icône de livre, « Services et assistance » une bouée de sauvetage, etc.';
$string['footersuppresslogininfosetting'] = 'Supprimer les informations sur l‘utilisateur connecté.';
$string['footersuppresslogininfosetting_desc'] = 'Ce paramètre permet de supprimer les informations sur l‘utilisateur connecté dans le pied de page, à savoir un lien vers la page de profil de l‘utilisateur connecté et un lien de déconnexion.';
$string['footersuppresspoweredsetting'] = 'Supprimer le lien « Fourni par Moodle »';
$string['footersuppresspoweredsetting_desc'] = 'Ce paramètre permet de supprimer l‘information « Fourni par Moodle » dans le pied de page. Cette information précise que le site utilise Moodle et fournit un lien vers Moodle HQ.';
$string['footersuppressservicessetting'] = 'Supprimer le lien « Services et assistance »';
$string['footersuppressservicessetting_desc'] = 'Ce paramètre permet de supprimer le lien « Services et assistance » dans le pied de page. Par défaut le lien <a href="{$a->url}">Services et assistance</a> est proposé aux administrateurs.';
$string['footersuppressstandardfooter'] = 'Supprimer du pied de page le contenu fourni par le plugin « {$a} »';
$string['footersuppressstandardfooter_desc'] = 'Ce paramètre permet de supprimer du pied de page le contenu fourni par le plugin « {$a} ». Les plugins (mêmes ceux intégrés à la distribution Moodle, mais qui techniquement sont des plugins) peuvent ajouter du contenu au pied de page s‘ils implémentent une fonction spéciale. Ce plugin implémente cette fonction et peut donc ajouter du contenu au pied de page dans certaines circonstances.';
$string['footersuppressthemeswitchsetting'] = 'Supprimer les liens de changement de thème';
$string['footersuppressthemeswitchsetting_desc'] = 'Ce paramètre permet de supprimer les liens de changement de thème dans le pied de page. Le système de gestion de thèmes spécifiques pour les dispositifs a été supprimé dans Moodle 4.3 mais les routines de rendu sont toujours présentes, mieux vaut donc prévenir que guérir.';
$string['footersuppressusertoursetting'] = 'Supprimer le lien « Relancer la visite guidée sur cette page »';
$string['footersuppressusertoursetting_desc'] = 'Ce paramètre permet de supprimer le lien « Relancer la visite guidée sur cette page » du pied de page. Ce lien permet de réactiver la visite guidée sur une page définie.';
$string['footertab'] = 'Pied de page';
$string['footnoteheading'] = 'Note de pied de page';
$string['footnotesetting'] = 'Note de pied de page';
$string['footnotesetting_desc'] = 'Tout ce que vous ajoutez à cette zone de texte sera affiché à la fin d’une page, dans le pied de page (pas le pied de page flottant) sur chaque page qui utilise les mises en page « tiroirs », « columns2 » ou « login ». Le contenu de cette zone peut être, par exemple, le copyright, les conditions d’utilisation ou le nom de votre organisation. <br/> Si vous souhaitez supprimer à nouveau la note de bas de page, videz simplement la zone de texte.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Problèmes Github</a>';
$string['h5pcontentmaxwidthsetting'] = 'Largeur maximale de la banque de contenu H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Ce paramètre permet de remplacer la largeur de la banque de contenu H5P de Moodle sans modifications SCSS manuelles. Cette largeur est utilisée pour l’éditeur H5P dans la banque de contenu. Elle n’est <em>pas</em> utilisée pour la largeur de l’activité H5P. Par défaut, Moodle utilise une largeur maximale de banque de contenu H5P de 960px. Vous pouvez entrer d’autres valeurs basées sur les pixels comme 1200px, mais vous pouvez également entrer une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Contenu de la page d’aide';
$string['helpcontentsetting_desc'] = 'Dans ce paramètre, on peut ajouter du contenu en texte enrichi qui sera affiché sur une page d’aide.';
$string['helpdisabled'] = 'La page d’aide est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['helpheading'] = 'Aide';
$string['helplinkpositionboth'] = 'Ajouter un lien vers la page d’aide à la note de bas de page et à l’icône de pied de page (point d’interrogation)';
$string['helplinkpositionfooter'] = 'Ajouter un lien vers la page d’aide à l’icône du pied de page (point d’interrogation)';
$string['helplinkpositionfootnote'] = 'Ajouter un lien vers la page d’aide à la note de bas de page';
$string['helplinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d’aide';
$string['helplinkpositionsetting'] = 'Position du lien de la page d’aide';
$string['helplinkpositionsetting_desc'] = 'Dans ce paramètre, il est possible de configurer si un lien vers la page d’aide doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, il est possible d’ajouter manuellement un lien vers {$a->url} depuis n’importe où dans Moodle.';
$string['helppagetitledefault'] = 'Aide';
$string['helppagetitlesetting'] = 'Titre de la page d’aide';
$string['helppagetitlesetting_desc'] = 'Dans ce paramètre, il est possible de définir le titre de la page d’aide. Ce texte sera également utilisé comme texte de lien vers la page d’aide si on configure la « Position du lien de la page d’aide » en conséquence.';
$string['hidenodesprimarynavigationsetting'] = 'Masquer les nœuds dans la navigation principale';
$string['hidenodesprimarynavigationsetting_desc'] = 'Ce paramètre permet de masquer un ou plusieurs nœuds de la navigation principale.<br /><br />
Remarque : ici, il est possible de simplement supprimer les nœuds de navigation. Mais pour ajouter des nœuds de navigation personnalisés, il faut penser à utiliser la fonctionnalité <a href="{$a->url}"> de menu intelligent de Boost Union</a>.';
$string['imprintcontentsetting'] = 'Contenu de l’impression';
$string['imprintcontentsetting_desc'] = 'Dans ce paramètre, vous pouvez ajouter du contenu en texte enrichi qui sera affiché sur la page d’impression.';
$string['imprintdisabled'] = 'L’impression est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['imprintheading'] = 'Impression';
$string['imprintlinkpositionboth'] = 'Ajouter un lien vers la page d’impression à la note de bas de page et à l’icône de pied de page (point d’interrogation)';
$string['imprintlinkpositionfooter'] = 'Ajouter un lien vers la page d’impression à l’icône du pied de page (point d’interrogation)';
$string['imprintlinkpositionfootnote'] = 'Ajouter un lien vers la page d’impression à la note de bas de page';
$string['imprintlinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d’impression';
$string['imprintlinkpositionsetting'] = 'Position du lien d’impression';
$string['imprintlinkpositionsetting_desc'] = 'Dans ce paramètre, vous pouvez configurer si un lien vers la page d’impression doit être ajouté automatiquement à la page Moodle. Si vous ne souhaitez pas afficher un lien automatiquement, vous pouvez ajouter manuellement un lien vers {$a->url} depuis n’importe où dans Moodle.';
$string['imprintpagetitledefault'] = 'Impression';
$string['imprintpagetitlesetting'] = 'Titre de la page d’impression';
$string['imprintpagetitlesetting_desc'] = 'Dans ce paramètre, vous pouvez définir le titre de la page d’impression. Ce texte sera également utilisé comme texte de lien vers la page d’impression si vous configurez « Position du lien d’impression » en conséquence.';
$string['infobannerbsclasssetting'] = 'Classe Boostrap de la bannière d’information n° {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Avec ce paramètre, vous pouvez sélectionner le style Bootstrap avec lequel la bannière d’informations n° {$a->no} doit être affiché. Si vous choisissez l’option « Aucune couleur Bootstrap », la bannière d’informations sera affichée sans aucune couleur Bootstrap particulière, ce qui vous donne la liberté de styliser la bannière vous-même dans l’éditeur de texte enrichi.';
$string['infobannerclose'] = 'Fermer';
$string['infobannercontentsetting'] = 'Contenu de la bannière d’information n° {$a->no}';
$string['infobannercontentsetting_desc'] = 'Ici, vous saisissez les informations qui doivent être affichées dans la bannière d’information n° {$a->no}.';
$string['infobannerdismissconfirm'] = 'Voulez-vous vraiment réinitialiser la visibilité de la bannière d’information n° {$a->no} et souhaitez-vous la réafficher pour tous les utilisateurs qui l’ont ignorée ?';
$string['infobannerdismissfail'] = 'La réinitialisation de la visibilité du bandeau d’information n° {$a->no} a échoué pour au moins un utilisateur';
$string['infobannerdismissiblesetting'] = 'Révocabilité de la bannière d’information n° {$a->no}';
$string['infobannerdismissiblesetting_desc'] = 'Avec ce paramètre, la bannière d’informations n° {$a->no} pourra être ignorée. Si l’utilisateur clique sur le bouton x dans la bannière d’informations, la bannière sera masquée de façon permanente pour cet utilisateur. La visibilité n’est en aucun cas réinitialisée automatiquement, même si vous modifiez le contenu de la bannière d’information. Si vous souhaitez réinitialiser la visibilité de la bannière d’informations, cliquez sur le bouton « Réinitialiser la visibilité » ci-dessous.';
$string['infobannerdismissreset'] = 'Réinitialiser la visibilité de la bannière d’informations ignorée';
$string['infobannerdismissresetbutton'] = 'Réinitialiser la visibilité de la bannière d’information n° {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilité de la bannière d’information n° {$a->no} a été réinitialisée';
$string['infobannerenabledsetting'] = 'Activer la bannière d’information n° {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Avec ce paramètre, vous pouvez activer la bannière d’information n° {$a->no}.';
$string['infobannerendsetting'] = 'Date de fin de la bannière d’information n° {$a->no}';
$string['infobannerendsetting_desc'] = 'Avec ce paramètre, vous pouvez définir jusqu’à quand la bannière d’information n° {$a->no} doit être affichée. La date configurée est interprétée comme l’heure du serveur et non comme l’heure de l’utilisateur.';
$string['infobannerheading'] = 'Bannière d’information n° {$a->no}';
$string['infobannermodeperpetual'] = 'Perpétuelle';
$string['infobannermodesetting'] = 'Mode d’affichage de la bannière d’information n° {$a->no}';
$string['infobannermodesetting_desc'] = 'Avec ce paramètre, vous pouvez définir si la bannière d’information n° {$a->no} doit être une bannière perpétuelle (qui est toujours affichée) ou une bannière à durée contrôlée (qui n’est affichée que dans l’intervalle de temps configuré)';
$string['infobannermodetimebased'] = 'Durée contrôlée';
$string['infobannerordersetting'] = 'Position de la bannière d’information no. {$a->no}';
$string['infobannerordersetting_desc'] = 'Avec ce paramètre, vous définissez la position d’ordre de la bannière d’information n° {$a->no}. Par défaut, les bannières d’informations sont classées de haut en bas comme vous les voyez sur cette page de paramètres ici. Cependant, vous pouvez décider d’attribuer une autre position avec ce paramètre. Si vous attribuez la même position à deux bannières d’information ou plus, elles seront à nouveau classées selon l’ordre indiqué sur cette page de paramètres.';
$string['infobannerpageloginpage'] = 'Page de connexion';
$string['infobannerpagessetting'] = 'Pages sur lesquelles afficher la bannière d’informations n° {$a->no}';
$string['infobannerpagessetting_desc'] = 'Avec ce paramètre, vous pouvez sélectionner les pages sur lesquelles la bannière d’information n° {$a->no} doit être affichée.';
$string['infobannerstartsetting'] = 'Heure de début de la bannière d’information n° {$a->no}';
$string['infobannerstartsetting_desc'] = 'Avec ce paramètre, vous pouvez définir à partir de quand la bannière d’information n° {$a->no} doit être affichée. La date configurée est interprétée comme l’heure du serveur et non comme l’heure de l’utilisateur.';
$string['infobannertab'] = 'Bannière d’information';
$string['invalidurl'] = 'L’URL fournie n’est pas valide';
$string['javascriptdisabledhint'] = 'Indice JavaScript désactivé';
$string['javascriptdisabledhint_desc'] = 'Avec ce paramètre, un indice apparaîtra en haut de la page Moodle si JavaScript n’est pas activé. Ceci est particulièrement utile car plusieurs fonctionnalités de Moodle ne fonctionnent pas sans JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript est désactivé dans votre navigateur.<br />De nombreuses fonctionnalités de Moodle ne seront pas utilisables ou sembleront brisées.<br />Veuillez activer JavaScript pour profiter pleinement de l’expérience Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Liens';
$string['loginbackgroundimage'] = 'Images d’arrière-plan de la page de connexion';
$string['loginbackgroundimage_desc'] = 'Les images à afficher en arrière-plan de la page de connexion. L’une de ces images sera choisie au hasard et affichée lorsque l’utilisateur visitera la page de connexion. Assurez-vous de ne pas utiliser de caractères non ASCII dans les noms de fichiers si vous voulez afficher du texte pour les images d’arrière-plan.';
$string['loginbackgroundimagepositionsetting'] = 'Position de l‘image d‘arrière-plan sur la page de connexion';
$string['loginbackgroundimagepositionsetting_desc'] = 'Ce paramètre permet de régler le positionnement de l‘image d‘arrière-plan dans la fenêtre du navigateur sur la page de connexion. La première valeur définit le positionnement horizontal, la seconde le positionnement vertical.';
$string['loginbackgroundimagesheading'] = 'Images d’arrière-plan de la page de connexion';
$string['loginbackgroundimagetextsetting'] = 'Afficher le texte des images d’arrière-plan de connexion';
$string['loginbackgroundimagetextsetting_desc'] = 'Avec ce paramètre facultatif, vous pouvez ajouter du texte, par exemple un avis de droit d’auteur sur vos images d’arrière-plan téléchargées. Ce texte apparaîtra en haut du pied de page sur la page de connexion. Cependant, pour des raisons d’espace sur l’écran, il n’est affiché que sur des tailles d’écran plus grandes.<br/>
Chaque ligne se compose de l’identifiant du fichier (le nom du fichier), du texte qui doit être affiché et de la couleur du texte, séparés par un caractère tuyau. Chaque déclaration doit être écrite dans une nouvelle ligne. <br/>
Par exemple :<br/>
background-image-1.jpg|Copyright : CC0|dark<br/>
Comme couleur de texte, vous pouvez utiliser les valeurs « dark » ou « light ».<br />
Vous pouvez déclarer des textes pour une quantité arbitraire de vos images d’arrière-plan de connexion téléchargées. Les textes seront ajoutés uniquement aux images dont le nom de fichier correspond à l’identifiant déclaré dans ce paramètre.';
$string['loginformheading'] = 'Formulaire de connexion';
$string['loginformpositionsetting'] = 'Position du formulaire de connexion';
$string['loginformpositionsetting_center'] = 'Centrée';
$string['loginformpositionsetting_desc'] = 'Ce paramètre permet d’optimiser le formulaire de connexion pour l’adapter à une plus grande variété d’images d’arrière-plan. Par défaut, le formulaire de connexion s’affiche centré sur la page de connexion. Alternativement, on peut le déplacer vers la gauche ou vers la droite de la page de connexion pour laisser apparaître d’autres parties de l’image d’arrière-plan. Bien sûr, on peut également modifier ce paramètre si aucune image d’arrière-plan n’est téléchargée du tout.';
$string['loginformpositionsetting_left'] = 'Alignée à gauche';
$string['loginformpositionsetting_right'] = 'Alignée à droite';
$string['loginformtransparencysetting'] = 'Transparence du formulaire de connexion';
$string['loginformtransparencysetting_desc'] = 'Ce paramètre permet de rendre le formulaire de connexion légèrement transparent pour faire ressortir encore plus l’image d’arrière-plan.';
$string['loginidpshowintrosetting'] = 'Texte pour la connexion par IdP';
$string['loginidpshowintrosetting_desc'] = 'Ce paramètre permet d‘afficher ou non le texte <em>« {$a} »</em> au dessus des boutons de connexion par fournisseur d‘identité. Par défaut ce texte est affiché et informe brièvement les utilisateurs de la nature de ces boutons. Si vous désactivez ce paramètre, le texte sera caché. Ceci permet de fournir une interface de connexion simple si vous n‘utilisez que des fournisseurs d‘identités externes comme OAuth2 ou OIDC.';
$string['loginlocalintro'] = 'Connexion avec votre compte Moodle';
$string['loginlocalloginenablesetting'] = 'Connexion locale';
$string['loginlocalloginenablesetting_desc'] = 'Ce paramètre permet d‘afficher ou non le formulaire de connexion locale. Par défaut, ce formulaire est affiché et permet aux utilisateurs de s‘identifier avec un compte local. En désactivant ce paramètre, le formulaire sera masqué. Ceci permet de ne proposer que la connexion via des fournisseurs d‘identité externes comme OAuth2 ou OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Attention : si vous masquez le formulaire de connexion locale, il se peut que les administrateurs ne puissent plus se connecter avec un compte local en cas de problème avec le fournisseur d’identité externe. Pour permettre une connexion locale dans ce cas de figure, il est possible de définir une <a href="{$a->url}">page de connexion locale séparée</a>. Sur cette page alternative, toutes les mesures de sécurité pour la connexion à Moodle s’appliquent.';
$string['loginlocalloginformhead'] = 'Connexion locale';
$string['loginlocalloginlocalnotdisabled'] = 'La connexion locale est possible depuis la page de connexion standard. Il n‘est donc pas utile de passer par cette page de connexion locale. Utilisez plutôt la <a href="{$a->url}">page de connexion standard</a> pour vous connecter.';
$string['loginlocalshowintrosetting'] = 'Texte pour la connexion locale';
$string['loginlocalshowintrosetting_desc'] = 'Ce paramètre permet d‘afficher ou non le texte <em>« {$a} »</em> au-dessus du formulaire de connexion locale. Par défaut, ce texte est masqué. Si vous l‘affichez, cela peut aider les utilisateurs à comprendre quelles informations d‘authentification ils doivent utiliser, notamment s‘il y a plusieurs méthodes de connexion possibles ou si vous avez modifié l‘ordre des méthodes de connexion.';
$string['loginorderfirsttimesignupsetting'] = 'Information pour les nouveaux utilisateurs et auto-enregistrement';
$string['loginorderguestsetting'] = 'Accès anonyme';
$string['loginorderheading'] = 'Ordre des méthodes de connexion';
$string['loginorderheading_desc'] = 'Ce paramètre permet de définir l‘ordre d‘affichage des méthodes d‘authentification sur la page de connexion. L‘ordre correspondra au tri ascendant des chiffres associés aux méthodes et ne tiendra pas compte des méthodes désactivés dans la configuration de Moodle.';
$string['loginorderheading_note'] = 'Note technique : l‘ordre d‘affichage sera géré au moyen de règles CSS flexbox et non en réarrangeant les éléments du DOM. Cela devrait parfaitement fonctionner sur les navigateurs modernes mais peut-être pas sur les navigateurs très anciens.';
$string['loginorderidpsetting'] = 'Connexion par IdP';
$string['loginorderlocalsetting'] = 'Connexion locale';
$string['loginpagetab'] = 'Page de connexion';
$string['loginprovidersheading'] = 'Fournisseurs d‘identités';
$string['logocompactsetting'] = 'Logo compact';
$string['logocompactsetting_desc'] = 'Ici, on peut télécharger une version compacte du même logo que ci-dessus, comme un emblème, un bouclier ou une icône. Cette image est notamment utilisée dans la barre de navigation en haut de chaque page Moodle. L’image doit être claire même à de petites tailles.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Ici, il est possible de télécharger un logo complet à utiliser comme décoration. Cette image est notamment utilisée sur la page de connexion. Cette image peut être assez haute résolution car elle sera réduite pour être utilisée.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Remarque : Boost Union a son propre téléchargement de logo et n’utilise pas le logo du <a href="{$a}">paramètre de logo du noyau Moodle</a>.<br />Boost Union permet en particulier de télécharger plus de formats d’images que le noyau de Moodle autorise et permet de remplacer les logos téléchargés dans ses variantes.';
$string['maintenancecontentsetting'] = 'Contenu de la page d’informations sur la maintenance';
$string['maintenancecontentsetting_desc'] = 'Dans ce paramètre, on peut ajouter du contenu en texte enrichi qui sera affiché sur une page d’informations de maintenance (qui n’est pas la même que la page de mode de maintenance intégrée de Moodle).';
$string['maintenancedisabled'] = 'La page d’informations sur la maintenance est désactivée pour ce site. Il n’y a rien à voir ici.';
$string['maintenanceheading'] = 'Maintenance';
$string['maintenancelinkpositionboth'] = 'Ajouter un lien vers la page d’informations sur la maintenance à la note de bas de page et à l’icône de pied de page (point d’interrogation)';
$string['maintenancelinkpositionfooter'] = 'Ajouter un lien vers la page d’informations sur la maintenance à l’icône du pied de page (point d’interrogation)';
$string['maintenancelinkpositionfootnote'] = 'Ajouter un lien vers la page d’informations sur la maintenance dans la note de bas de page';
$string['maintenancelinkpositionnone'] = 'Ne pas afficher automatiquement un lien vers la page d’informations sur la maintenance';
$string['maintenancelinkpositionsetting'] = 'Position du lien de la page d’informations sur la maintenance';
$string['maintenancelinkpositionsetting_desc'] = 'Dans ce paramètre, il est possible de configurer si un lien vers la page d’informations de maintenance doit être ajouté automatiquement à la page Moodle. Pour ne pas afficher un lien automatiquement, ajouter manuellement un lien vers {$a->url} depuis n’importe où dans Moodle.';
$string['maintenancepagetitledefault'] = 'Maintenance';
$string['maintenancepagetitlesetting'] = 'Titre de la page d’information de la maintenance';
$string['maintenancepagetitlesetting_desc'] = 'Dans ce paramètre, il est possible de définir le titre de la page d’informations de maintenance. Ce texte sera également utilisé comme texte de lien vers la page d’informations sur la maintenance si on configure la « Position du lien de la page d’informations sur la maintenance » en conséquence.';
$string['markbrokenlinkssetting'] = 'Marquer les liens cassés';
$string['markbrokenlinkssetting_desc'] = 'Ajoute une icône « chaîne cassée » devant les liens cassés (qui mènent vers des fichiers brouillon téléversés qui n‘ont pas été traités correctement) et colore le lien avec la couleur bootstrap « danger ». Au contraire des paramètres « Marquer liens externes » et « Marquer les liens mailto », on ne peut ici limiter la portée de ce paramètre, car le marquage des liens cassés est un indicateur d‘un problème qui doit être réglé manuellement.';
$string['markexternallinksscopesetting'] = 'Portée du marquage des liens externes';
$string['markexternallinksscopesetting_desc'] = 'Ce paramètre permet de définir dans quel contexte Boost Union doit marquer les liens externes. Par défaut, Boost Union marque les liens externes sur toute la page de Moodle et tente au mieux de gérer les cas limites dans lesquels ce marquage n‘a pas beaucoup de sens. Toutefois, il est possible de limiter la portée afin d‘éviter les cas limites.';
$string['markexternallinkssetting'] = 'Marquer les liens externes';
$string['markexternallinkssetting_desc'] = 'Ajoute une icône « lien externe » après les liens externes (qui conduisent l’utilisateur vers une cible en dehors de Moodle).';
$string['marklinksscopesetting_coursemain'] = 'Seulement dans le contenu principal de la page d‘accueil des cours';
$string['marklinksscopesetting_wholepage'] = 'Sur toute la page';
$string['markmailtolinksscopesetting'] = 'Portée du marquage des liens mailto';
$string['markmailtolinksscopesetting_desc'] = 'Ce paramètre permet de définir dans quel contexte Boost Union doit marquer les liens mailto. Par défaut, Boost Union marque les liens externes sur toute la page de Moodle. Toutefois, il est possible de limiter la portée afin d‘éviter des cas limites.';
$string['markmailtolinkssetting'] = 'Marquer les liens mailto';
$string['markmailtolinkssetting_desc'] = 'Ajoute une icône « enveloppe » devant les liens mailto';
$string['mediumcontentmaxwidthsetting'] = 'Largeur maximale du contenu moyen';
$string['mediumcontentmaxwidthsetting_desc'] = 'Ce paramètre permet de remplacer la largeur de contenu moyenne de Moodle sans modifications SCSS manuelles. Cette largeur de page est utilisée dans certaines activités comme l’activité de base de données. Par défaut, Moodle utilise une largeur maximale de contenu moyen de 1120px. Il est possible de saisir d’autres valeurs basées sur les pixels comme 1200px, mais vous pouvez également saisir une valeur basée sur un pourcentage comme 100% ou une valeur de largeur de fenêtre comme 90vw.';
$string['misctab'] = 'Divers';
$string['mobileappearanceheading'] = 'Apparence mobile';
$string['mobileappheading'] = 'Application mobile';
$string['mobilecss'] = 'CSS supplémentaire pour l’application mobile';
$string['mobilecss_desc'] = 'Ce paramètre permet d’écrire un code CSS personnalisé pour personnaliser l’interface de l’application mobile. Le code CSS sera uniquement ajouté à la représentation de l’application mobile de cette instance Moodle et ne sera pas affiché dans la version du navigateur Web. En savoir plus sur cette fonctionnalité dans la <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">docs de développement Moodle</a>.';
$string['mobilecss_donotchange'] = 'Cette étape est nécessaire pour envoyer le code CSS à l’application mobile. Ne modifiez pas l’URL à moins que vous ne souhaitiez vraiment supprimer à nouveau le code CSS de l’application mobile.';
$string['mobilecss_overwrite'] = 'Dès qu’on ajoute un code CSS à ce paramètre et qu’on enregistre le paramètre, le paramètre principal <a href="{$a->url}"> de Moodle <em>mobilecssurl</em></a> sera automatiquement remplacé par une URL du thème Boost Union. Actuellement, ce paramètre est défini sur <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Dès qu’on ajoute un code CSS à ce paramètre et qu’on enregistre le paramètre, le paramètre principal <a href="{$a->url}"> de Moodle <em>mobilecssurl</em></a> sera automatiquement défini vers une URL du thème Boost Union.';
$string['mobiletab'] = 'Application mobile';
$string['modiconactivity'] = 'Activité';
$string['modiconactivityunknown'] = 'Inconnu';
$string['modicongtmoodle4'] = 'Icône Moodle 4';
$string['modiconlistsetting'] = 'Liste des fichiers d’icônes personnalisées';
$string['modiconlistsetting_desc'] = 'Il s’agit de la liste des fichiers d’icônes personnalisées téléchargés dans la zone de fichiers d’icônes personnalisées ci-dessus. Tous les fichiers d’icônes valides sont répertoriés ici. En plus de cela, d’autres fichiers peut-être également téléchargés mais qui ne sont pas des fichiers d’icônes valides sont également affichés comme des fichiers endommagés.';
$string['modiconltmoodle311'] = 'Icône héritée de Moodle 3';
$string['modiconnamefail'] = 'Ce fichier a été téléchargé dans le bon dossier pour l’activité <em>{$a}</em>, mais le nom de fichier n’est pas valide. Veuillez changer le nom du fichier en <em>monologo.svg</em> / <em>monologo.png</em> (pour les icônes Moodle 4) ou en <em>icon.svg</em> / <em>icon .png</em> (pour les anciennes icônes de Moodle 3).';
$string['modiconnotexist'] = 'Ce fichier a été téléchargé à un emplacement inapproprié car il est impossible de déduire une activité particulière du chemin du fichier <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Activer les icônes personnalisées pour les activités et les ressources';
$string['modiconsenablesetting_desc'] = 'Ce paramètre permet de modifier les icônes des activités et des ressources utilisées par Moodle sur les pages de cours et dans le sélecteur d’activités.';
$string['modiconserrorcreatingpath'] = 'Le dossier pix_plugins/mod n’a pas pu être créé dans votre répertoire Moodledata.<br />Le message d’exception était :{$a}.';
$string['modiconsfiles'] = 'Fichiers d’icônes personnalisées';
$string['modiconsfiles_desc'] = 'Ici, on peut télécharger des icônes personnalisées pour tous ou seulement certains modules d’activité installés dans cette instance Moodle.';
$string['modiconsfileshowto'] = 'Pour télécharger une icône d’activité personnalisée particulière, commencer par créer un dossier avec le nom interne de l’activité, par ex. <em>assign</em> pour l’activité d’affectation. Dans ce dossier, télécharger l’icône en tant que fichier SVG appelé monologo.svg et, si possible, en tant que fichier PNG de secours appelé monologo.png. Pour personnaliser les icônes colorées qui ont été utilisées jusqu’à Moodle 3 et qui peuvent encore être utilisées par des plugins plus anciens, on peut également les télécharger sous forme de fichiers icon.svg et icon.png. Cependant, il est préférable de s’en tenir aux icônes SVG monochromatiques si possible pour de meilleurs résultats. Ensuite, il faut enregistrer la page des paramètres. Dès que le paramètre est enregistré avec au moins un fichier, une liste de fichiers apparaît ci-dessous qui aide à vérifier si les icônes personnalisées ont été téléchargées correctement.';
$string['modiconsfilestech'] = 'Note technique : après avoir enregistré le paramètre, la structure du dossier téléchargé et les fichiers d’icônes seront copiés dans le dossier pix_plugins/mod de votre répertoire Moodledata. C’est là que le noyau de Moodle recherche des icônes d’activité personnalisées. Tous les fichiers d’icônes qui peuvent déjà exister à cet endroit seront écrasés lorsque ce paramètre sera enregistré.';
$string['modiconsheading'] = 'Icônes d’activité';
$string['modiconsuccess3x'] = 'Cette icône sera utilisée pour l’activité <em>{$a}</em> en tant qu’icône héritée de Moodle 3.';
$string['modiconsuccess4x'] = 'Cette icône sera utilisée pour l’activité <em>{$a}</em> en tant qu’icône Moodle 4.';
$string['modiconversion'] = 'Version d’icône';
$string['navbarcolorsetting'] = 'Couleur de la barre de navigation';
$string['navbarcolorsetting_dark'] = 'Barre de navigation sombre avec une couleur de police claire';
$string['navbarcolorsetting_desc'] = 'Ce paramètre permet de changer la couleur de la barre de navigation de la barre de navigation claire par défaut à une barre sombre ou colorée.';
$string['navbarcolorsetting_light'] = 'Barre de navigation claire avec une couleur de police sombre (inchangée telle que présentée par le noyau Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Barre de navigation de couleur primaire avec une couleur de police claire';
$string['navbarcolorsetting_primarylight'] = 'Barre de navigation de couleur primaire avec une couleur de police sombre';
$string['navbarheading'] = 'Barre de navigation';
$string['navigationheading'] = 'Navigation';
$string['navigationtab'] = 'Navigation';
$string['offerscontentsetting'] = 'Contenu de la page « Offres »';
$string['offerscontentsetting_desc'] = 'Ce paramètre permet de rédiger contenu pour la page « Offres ».';
$string['offersdisabled'] = 'La page « Offres » est désactivée pour ce site. Aucune information n‘est donc disponible sur cette page.';
$string['offersheading'] = 'Offres';
$string['offerslinkpositionboth'] = 'Ajouter un lien vers la page « Offres » dans la note de bas de page et dans le pied de page (icône « ? »)';
$string['offerslinkpositionfooter'] = 'Ajouter un lien vers la page « Offres » dans le pied de page (icône « ? »)Position du lien « À propos de nous »';
$string['offerslinkpositionfootnote'] = 'Ajouter un lien vers la page « Offres » dans la note de bas de page';
$string['offerslinkpositionnone'] = 'Ne pas ajouter de lien automatiquement vers la page « À propos de nous »';
$string['offerslinkpositionsetting'] = 'Position du lien « Offres »';
$string['offerslinkpositionsetting_desc'] = 'Ce paramètre vous permet d’ajouter automatiquement un lien vers la page « Offres » dans le pied de page et/ou la note de bas de page. Si vous ne souhaitez pas que ce lien soit ajouté d’office, vous pouvez insérer le lien {$a->url} manuellement où cela vous convient.';
$string['offerspagetitledefault'] = 'Offres';
$string['offerspagetitlesetting'] = 'Titre de la page « Offres »';
$string['offerspagetitlesetting_desc'] = 'Ce paramètre vous permet de définir le titre de la page « Offres ». Ce texte sera également le texte du lien automatique si vous l’avez configuré dans le paramètre « Position du lien Offres ».';
$string['openoffcanvas'] = 'Tiroir hors canevas ouvert';
$string['outsideregionsheading'] = 'Régions extérieures';
$string['outsideregionsheading_desc'] = 'Les régions extérieures peuvent non seulement être activées avec les paramètres de mise en page ci-dessus, mais leur apparence peut également être personnalisée.';
$string['outsideregionsplacement'] = 'Placement horizontal des régions extérieures';
$string['outsideregionsplacement_desc'] = 'Ce paramètre permet de contrôler si, sur des écrans plus grands, les régions de bloc « Extérieur (gauche) » et « Extérieur (droite) » doivent être placées près de la zone de contenu principale ou plutôt près des bords de la fenêtre.';
$string['outsideregionsplacementnearwindowedges'] = 'Afficher les régions « Extérieur (gauche) » et « Extérieur (droite) » près des bords de la fenêtre';
$string['outsideregionsplacementnextmaincontent'] = 'Afficher les régions « Extérieur (gauche) » et « Extérieur (droite) » à côté de la zone de contenu principale';
$string['outsideregionswidthcoursecontentwidth'] = 'Largeur du contenu du cours';
$string['outsideregionswidthfullwidth'] = 'Pleine largeur';
$string['outsideregionswidthherowidth'] = 'Largeur de l’image de bandeau';
$string['page1contentsetting'] = 'Contenu de la page personnalisée 1';
$string['page1contentsetting_desc'] = 'Ce paramètre permet de rédiger contenu pour la page personnalisée 1.';
$string['page1disabled'] = 'La page personnalisée 1 est désactivée pour ce site. Aucune information n‘est donc disponible sur cette page.';
$string['page1heading'] = 'Page personnalisée 1';
$string['page1linkpositionboth'] = 'Ajouter un lien vers la page personnalisée 1 dans la note de bas de page et dans le pied de page (icône « ? »)';
$string['page1linkpositionfooter'] = 'Ajouter un lien vers la page personnalisée 1 dans le pied de page (icône « ? »)';
$string['page1linkpositionfootnote'] = 'Ajouter un lien vers la page personnalisée 1 dans la note de bas de page';
$string['page1linkpositionnone'] = 'Ne pas ajouter de lien automatiquement vers la page personnalisée 1';
$string['page1linkpositionsetting'] = 'Position du lien vers la page personnalisée 1';
$string['page1linkpositionsetting_desc'] = 'Ce paramètre vous permet d’ajouter automatiquement un lien vers la page personnalisée 1 dans le pied de page et/ou la note de bas de page. Si vous ne souhaitez pas que ce lien soit ajouté d’office, vous pouvez insérer le lien {$a->url} manuellement où cela vous convient.';
$string['page1pagetitledefault'] = 'Page personnalisée 1';
$string['page1pagetitlesetting'] = 'Titre de la page personnalisée 1';
$string['page1pagetitlesetting_desc'] = 'Ce paramètre vous permet de définir le titre de la page personnalisée. Ce texte sera également le texte du lien automatique si vous l’avez configuré dans le paramètre « Position du lien vers la page personnalisée 1 ».';
$string['page2contentsetting'] = 'Contenu de la page personnalisée 2';
$string['page2contentsetting_desc'] = 'Ce paramètre permet de rédiger contenu pour la page personnalisée 2.';
$string['page2disabled'] = 'La page personnalisée 2 est désactivée pour ce site. Aucune information n‘est donc disponible sur cette page.';
$string['page2heading'] = 'Page personnalisée 2';
$string['page2linkpositionboth'] = 'Ajouter un lien vers la page personnalisée 2 dans la note de bas de page et dans le pied de page (icône « ? »)';
$string['page2linkpositionfooter'] = 'Ajouter un lien vers la page personnalisée 2 dans le pied de page (icône « ? »)';
$string['page2linkpositionfootnote'] = 'Ajouter un lien vers la page personnalisée 2 dans la note de bas de page';
$string['page2linkpositionnone'] = 'Ne pas ajouter de lien automatiquement vers la page personnalisée 2';
$string['page2linkpositionsetting'] = 'Position du lien vers la page personnalisée 2';
$string['page2linkpositionsetting_desc'] = 'Ce paramètre vous permet d’ajouter automatiquement un lien vers la page personnalisée 2 dans le pied de page et/ou la note de bas de page. Si vous ne souhaitez pas que ce lien soit ajouté d’office, vous pouvez insérer le lien {$a->url} manuellement où cela vous convient.';
$string['page2pagetitledefault'] = 'Page personnalisée 2';
$string['page2pagetitlesetting'] = 'Titre de la page personnalisée 2';
$string['page2pagetitlesetting_desc'] = 'Ce paramètre vous permet de définir le titre de la page personnalisée. Ce texte sera également le texte du lien automatique si vous l’avez configuré dans le paramètre « Position du lien vers la page personnalisée 2 ».';
$string['page3contentsetting'] = 'Contenu de la page personnalisée 3';
$string['page3contentsetting_desc'] = 'Ce paramètre permet de rédiger contenu pour la page personnalisée 3.';
$string['page3disabled'] = 'La page personnalisée 3 est désactivée pour ce site. Aucune information n‘est donc disponible sur cette page.';
$string['page3heading'] = 'Page personnalisée 3';
$string['page3linkpositionboth'] = 'Ajouter un lien vers la page personnalisée 3 dans la note de bas de page et dans le pied de page (icône « ? »)';
$string['page3linkpositionfooter'] = 'Ajouter un lien vers la page personnalisée 3 dans le pied de page (icône « ? »)';
$string['page3linkpositionfootnote'] = 'Ajouter un lien vers la page personnalisée 3 dans la note de bas de page';
$string['page3linkpositionnone'] = 'Ne pas ajouter de lien automatiquement vers la page personnalisée 3';
$string['page3linkpositionsetting'] = 'Position du lien vers la page personnalisée 3';
$string['page3linkpositionsetting_desc'] = 'Ce paramètre vous permet d’ajouter automatiquement un lien vers la page personnalisée 3 dans le pied de page et/ou la note de bas de page. Si vous ne souhaitez pas que ce lien soit ajouté d’office, vous pouvez insérer le lien {$a->url} manuellement où cela vous convient.';
$string['page3pagetitledefault'] = 'Page personnalisée 3';
$string['page3pagetitlesetting'] = 'Titre de la page personnalisée 3';
$string['page3pagetitlesetting_desc'] = 'Ce paramètre vous permet de définir le titre de la page personnalisée. Ce texte sera également le texte du lien automatique si vous l’avez configuré dans le paramètre « Position du lien vers la page personnalisée 3 ».';
$string['pagelayoutstab'] = 'Mises en page';
$string['pagetab'] = 'Page';
$string['pagewidthheading'] = 'Largeur de la page';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Règles';
$string['policyoverviewnavigationsetting'] = 'Afficher la navigation sur la page de présentation des règles';
$string['policyoverviewnavigationsetting_desc'] = 'Par défaut, la page de présentation de la règle (fournie par tool_policy) n’affiche pas de menu de navigation ni de pied de page. Avec ce paramètre, vous pouvez afficher la navigation principale et le pied de page sur cette page.';
$string['presetbutton'] = 'Définir le préréglage de thème dans Boost';
$string['presetheading'] = 'Préréglages du thème';
$string['presetheading_desc'] = 'Les préréglages de thèmes peuvent être utilisés pour transformer radicalement l‘apparence du thème. Boost Union ne ré-implémente pas ce paramètre. Si vous souhaitez utiliser les préréglages de thème, fixez ce paramètre directement dans Boost. Boost Union en héritera et utilisera donc le préréglage sélectionné.';
$string['primarynavigationheading'] = 'Navigation principale';
$string['privacy:metadata'] = 'Le thème Boost Union n’enregistre aucune donnée personnelle sur un utilisateur.';
$string['region-content-lower'] = 'Contenu (inférieur)';
$string['region-content-upper'] = 'Contenu (supérieur)';
$string['region-footer-center'] = 'Pied de page (centre)';
$string['region-footer-left'] = 'Pied de page (gauche)';
$string['region-footer-right'] = 'Pied de page (droite)';
$string['region-header'] = 'Entête';
$string['region-none'] = 'Aucun';
$string['region-offcanvas-center'] = 'Hors canevas (au centre)';
$string['region-offcanvas-left'] = 'Hors canevas (à gauche)';
$string['region-offcanvas-right'] = 'Hors canevas (à droite)';
$string['region-outside-bottom'] = 'Extérieur (en bas)';
$string['region-outside-left'] = 'Extérieur (à gauche)';
$string['region-outside-right'] = 'Extérieur (à droite)';
$string['region-outside-top'] = 'Extérieur (en haut)';
$string['resourcescachecontrolnote'] = 'Veuillez noter que les fichiers sont envoyés au navigateur avec l’en-tête « Cache-Control » qui indique au navigateur de mettre le fichier en cache. Si vous êtes certain de ne pas modifier le fichier dans un proche avenir, vous pouvez utiliser l’URL persistante pour créer un lien vers le fichier. Cependant, si vous envisagez de modifier un fichier mais que vous conservez le même nom de temps en temps, vous devriez plutôt utiliser l’URL révisée et refaire le lien avec le fichier chaque fois que vous mettez à jour le fichier pour éviter que les navigateurs n’affichent en cache les versions obsolètes du fichier.';
$string['resourcestab'] = 'Ressources';
$string['scrollspysetting'] = 'Défilement-espion';
$string['scrollspysetting_desc'] = 'Avec ce paramètre, lors de l’activation et de la désactivation du mode d’édition, la position de défilement à l’endroit où se trouvait l’utilisateur lors de l’exécution de la bascule est conservée.';
$string['scssheading'] = 'SCSS brut';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Langue préférée';
$string['settingsoverview'] = 'Aperçu des paramètres';
$string['settingsoverview_all'] = 'Tous les paramètres sur une page';
$string['settingsoverview_all_desc'] = 'Vous pouvez ouvrir la page standard des paramètres de catégorie de Moodle pour Boost Union qui reprend tous les paramètres sur une seule page. Mais attention, cette page est très chargée.';
$string['settingsoverview_content_desc'] = 'Les paramètres de contenu global de votre site Moodle se retrouvent ici : pied de page, pages statiques, bannières d‘information, tuiles publicitaires et carrousels.';
$string['settingsoverview_feel_desc'] = 'Les paramètres de comportement global de votre site Moodle se retrouvent ici : éléments de navigation, aide à la navigation, blocs et liens.';
$string['settingsoverview_flavours_desc'] = 'Grâce aux variantes, vous pouvez adapter l‘apparence de votre site Moodle en fonction des cohortes et/ou des catégories de cours.';
$string['settingsoverview_functionality_desc'] = 'Les paramétrages des fonctionnalités additionnelles globales ou relatives aux cours se retrouvent ici.';
$string['settingsoverview_look_desc'] = 'Les paramètres pour configurer l‘image de marque de votre site Moodle se retrouvent ici : couleurs, icônes, images, dimensions et bien sur les règles SCSS personnalisées.';
$string['settingsoverview_smartmenus_desc'] = 'Les menus intelligents permettre d’étendre la navigation de votre site Moodle dans le menu principal et dans le menu utilisateur. Ils permettent également d’ajouter un menu en haut ou en bas de page.';
$string['settingsoverview_title'] = 'Aperçu des paramètres de Boost Union';
$string['showfullnameinusermenussetting'] = 'Afficher le nom complet dans le menu utilisateur';
$string['showfullnameinusermenussetting_desc'] = 'Ce paramètre permet d‘afficher le nom complet de l‘utilisateur connecté en-haut du menu utilisateur. Cela peut être particulièrement utile aux enseignants lors d‘examens afin de vérifier que l‘étudiant est bien connecté avec son propre compte ; cela peut également être utile pour l‘utilisateur. Contrairement au thème Classic qui affiche le nom complet de l‘utilisateur à côté de l‘avatar dans la barre de navigation, notre approche ne surcharge pas l‘espace précieux de la barre de navigation.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Connecté sous le nom :';
$string['showhintcourseguestaccessgeneral'] = 'Vous consultez actuellement ce cours en tant que <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Pour avoir un accès complet au cours, vous pouvez <a href="{$a->url}">vous inscrire vous-même à ce cours</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours lorsqu’un utilisateur y accède avec la fonction d’accès invité. Si le cours propose une auto-inscription active, un lien vers cette page est également présenté à l’utilisateur.';
$string['showhintcoursehiddengeneral'] = 'Ce cours est actuellement <strong>masqué</strong>. Seuls les enseignants inscrits peuvent accéder à ce cours lorsqu’il est masqué.';
$string['showhintcoursehiddensetting'] = 'Afficher l’indice dans les cours masqués';
$string['showhintcoursehiddensetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours tant que la visibilité du cours est masquée. Cela permet d’identifier l’état de visibilité d’un parcours en un coup d’œil sans avoir à consulter les paramètres du parcours.';
$string['showhintcoursehiddensettingslink'] = 'Vous pouvez modifier la visibilité dans les <a href="{$a->url}">paramètres du cours</a>.';
$string['showhintcourseselfenrolfrom'] = 'L’instance d’inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée à partir du {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'L’instance d’inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée de {$a->from} à {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Si vous ne souhaitez pas qu’un utilisateur Moodle puisse s’inscrire librement à ce cours, veuillez restreindre les paramètres d’auto-inscription.';
$string['showhintcourseselfenrolsetting'] = 'Afficher un indice pour l’auto-inscription sans clé d’inscription';
$string['showhintcourseselfenrolsetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours si le cours est visible et qu’une inscription sans clé d’inscription est actuellement possible.';
$string['showhintcourseselfenrolsince'] = 'L’instance d’inscription <strong>{$a->name}</strong> autorise actuellement l’auto-inscription sans restriction.';
$string['showhintcourseselfenrolsinceuntil'] = 'L’instance d’inscription <strong>{$a->name}</strong> autorise l’auto-inscription illimitée jusqu’au {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Ce cours est actuellement visible et l’<strong>auto-inscription sans clé d’inscription</strong> est actuellement possible.';
$string['showhintcourseselfenrolstartfuture'] = 'Ce cours est actuellement visible et l’<strong>auto-inscription sans clé d’inscription</strong> devrait devenir possible.';
$string['showhintcourseselfenrolunlimited'] = 'L’instance d’inscription <strong>{$a->name}</strong> permet une auto-inscription illimitée à l’infini.';
$string['showhintcourseselfenroluntil'] = 'L’instance d’inscription <strong>{$a->name}</strong> autorise l’auto-inscription illimitée jusqu’au {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Afficher l’indice pour l’accès invité';
$string['showhintforumnotifications'] = 'Ce cours est actuellement <strong>masqué</strong>. Cela signifie que <strong>les étudiants ne seront pas avertis</strong> en ligne ou par e-mail des messages que vous aurez postés dans ce forum.';
$string['showhintforumnotificationssetting'] = 'Afficher un indice pour les notifications du forum dans les cours masqués';
$string['showhintforumnotificationssetting_desc'] = 'Avec ce paramètre, un indice apparaîtra non seulement dans l’en-tête du cours, mais aussi dans les forums, tant que la visibilité du cours est masquée. Ceci a pour but de clarifier que les notifications dans un forum ne sont pas envoyées aux étudiants et d’aider les enseignants à comprendre cette situation.';
$string['shownavbarstarredcourses_config'] = 'Choisir mes cours favoris sur la page « Mes cours »';
$string['shownavbarstarredcourses_label'] = 'Cours favoris';
$string['shownavbarstarredcoursessetting'] = 'Accéder aux cours favoris depuis la barre de navigation';
$string['shownavbarstarredcoursessetting_desc'] = 'Ce paramètre permet d‘ajouter un menu déroulant qui liste les cours favoris à côté des icônes de notification et de messagerie';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Afficher le tiroir de bloc de droite de l’accueil du site lors de la première connexion';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Ce paramètre permet par défaut d’afficher ouvert le tiroir de blocs de droite de l’accueil du site. Cela ne s’applique qu’aux utilisateurs qui se connectent pour la toute première fois et n’écrase pas l’état de basculement de chaque utilisateur individuel.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Afficher le tiroir de bloc de droite de l’accueil du site lors de la connexion en tant qu’invité';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Ce paramètre permet par défaut d’afficher ouvert le tiroir de blocs de droite de l’accueil du site. Cela s’applique uniquement aux utilisateurs qui se connectent en tant qu’invités.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Afficher le bloc tiroir de droite de l’accueil du site lors de la visite';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Ce paramètre permet par défaut d’afficher ouvert le tiroir de blocs de droite de l’accueil du site. Cela s’applique uniquement aux utilisateurs qui ne sont pas connectés et n’écrase pas l’état de basculement de chaque utilisateur individuel.';
$string['showswitchedroleincoursesetting'] = 'Afficher l’indice de changement de rôle';
$string['showswitchedroleincoursesetting_desc'] = 'Avec ce paramètre, un indice apparaîtra dans l’en-tête du cours si l’utilisateur a changé de rôle dans le cours. Par défaut, ces informations ne sont affichées qu’à côté de l’avatar de l’utilisateur dans le menu utilisateur. En activant cette option, vous pouvez également afficher ces informations - ainsi qu’un lien pour revenir en arrière - dans la page du cours.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Par défaut, dans la page <a href="{$a}">Gestion des cours et des catégories</a>, il faut passer par les détails d‘un cours ou les paramètres d‘un cours avant de pouvoir le consulter. Ce paramètre permet d‘ajouter une icône « Consulter le cours » en regard de chaque cours dans la liste des cours d‘une catégorie.';
$string['showviewcourseiconincoursemgntsetting'] = 'Afficher l‘icône « Consulter le cours »';
$string['sitebrandingtab'] = 'Image de marque du site';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Tiroir de bloc de droite d’accueil du site';
$string['slidebackgroundimagealtsetting'] = 'Attribut « alt » de l‘image d‘arrière-plan de la diapositive {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Ce paramètre permet de définir un attribut « alt » pour l‘image d‘arrière-plan de la diapositive {$a->no}. Ce paramètre est optionnel, l‘image sera affichée même s‘il n‘est pas défini. Notez toutefois que ne pas définir d‘attribut « alt » réduit l‘accessibilité.';
$string['slidebackgroundimagesetting'] = 'Image d‘arrière plan de la diapositive {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Ce paramètre permet de téléverser une image qui constituera l‘arrière-plan de la diapositive {$a->no}. Assurez-vous que le contenu de la diapositive soit bien lisible sur l‘image d‘arrière-plan. Assurez-vous également que le rapport hauteur/largeur de toutes les images d‘arrière-plan soit équivalent, car celui-ci détermine la hauteur de la diapositive. Un rapport hauteur/largeur non homogène provoquerait un changement de taille de diapositive au sein du diaporama. Ce paramètre est obligatoire, la diapositive ne sera pas affichée si elle n‘est pas associée à une image d‘arrière-plan.';
$string['slidecaptionsetting'] = 'Légende de la diapositive {$a->no}';
$string['slidecaptionsetting_desc'] = 'Ce paramètre permet de définir une légende pour la diapositive {$a->no}. La légende sera centrée en-bas de la diapositive. Ce paramètre est optionnel, ne pas le définir n‘empêchera pas l‘affichage de la diapositive.';
$string['slidecontentsetting'] = 'Contenu de la diapositive {$a->no}';
$string['slidecontentsetting_desc'] = 'Ce paramètre permet d‘ajouter du contenu à la diapositive {$a->no}. Ce contenu sera affiché en-bas au centre de la diapositive. Si une légende est définie, le contenu sera affiché sous celle-ci. Notez que l‘éditeur de texte aligne le texte à gauche par défaut, mais vous pouvez modifier cela afin d‘obtenir un meilleur rendu. Evitez de définir un contenu trop long et testez le rendu sur des petits écrans car un contenu qui sortirait de la taille de la diapositive ne sera pas affiché. Ce paramètre est optionnel, ne pas le définir n‘empêchera pas l‘affichage de la diapositive.';
$string['slidecontentstylesetting'] = 'Style du contenu de la diapositive {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Foncé (couleur de police noire pour des images claires)';
$string['slidecontentstylesetting_darkshadow'] = 'Foncé et ombré (couleur de police noire avec un léger effet ombré pour des images claires)';
$string['slidecontentstylesetting_desc'] = 'Ce paramètre permet de modifier le style du contenu de la diapositive {$a->no}. Par défaut, la couleur de police est blanche et destinée à des images foncées. Vous pouvez toutefois modifier ce comportement pour adapter la couleur en fonction des images d‘arrière-plan. Notez que ce paramètre prévaudra sur une éventuelle couleur que vous auriez choisie dans l‘éditeur de texte.';
$string['slidecontentstylesetting_light'] = 'Clair (couleur de police blanche pour des images foncées)';
$string['slidecontentstylesetting_lightshadow'] = 'Clair et ombré (couleur de police blanche avec un léger effet ombré pour des images foncées)';
$string['slideenabledsetting'] = 'Activer la diapositive {$a->no}';
$string['slideenabledsetting_desc'] = 'Permet d‘afficher la diapositive {$a->no}';
$string['slideheading'] = 'Diapositive {$a->no}';
$string['slidelinksetting'] = 'Cible du lien pour la diapositive {$a->no}';
$string['slidelinksetting_desc'] = 'Ce paramètre permet d‘associer un lien (interne ou externe à Moodle) à la diapositive. Ce paramètre est optionnel, ne pas le définir n‘empêchera pas l‘affichage de la diapositive.';
$string['slidelinksourcesetting'] = 'Porté du lien de la diapositive {$a->no}';
$string['slidelinksourcesetting_both'] = 'Image d‘arrière-plan et éléments textuels';
$string['slidelinksourcesetting_desc'] = 'Ce paramètre permet de définir à quoi le lien doit être associé. Vous pouvez soit l‘associer à l‘image d‘arrière-plan, soit aux éléments textuels (légende et contenu), soit aux deux.';
$string['slidelinksourcesetting_image'] = 'Image d‘arrière plan uniquement';
$string['slidelinksourcesetting_text'] = 'Éléments textuels uniquement';
$string['slidelinktargetsetting'] = 'Cible du lien de la diapositive {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Si un lien est défini pour la diapositive {$a->no}, ce paramètre permet de choisir s‘il doit s‘ouvrir dans le même onglet ou ouvrir un nouvel onglet.';
$string['slidelinktargetsetting_newtab'] = 'Nouvel onglet';
$string['slidelinktargetsetting_samewindow'] = 'Même onglet';
$string['slidelinktitlesetting'] = 'Attribut « title » pour le lien de la diapositive {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Ce paramètre permet de définir un titre pour le lien (si le lien est défini) qui s‘affichera au survol de la diapositive {$a->no}. Ce paramètre est optionnel, le lien sera présent même si vous ne lui associez pas un titre. Notez toutefois que ne pas associer de titre à un lien réduit l‘accessibilité.';
$string['slideordersetting'] = 'Position du slide {$a->no}';
$string['slideordersetting_desc'] = 'Ce paramètre permet de définir l‘ordre d‘affichage de la diapositive {$a->no}. Par défaut, l‘ordre d‘affichage des diapositives correspond à leur numéro. Vous pouvez toutefois changer ce comportement grâce à ce paramètre. Si vous donnez la même position à deux ou plusieurs diapositives, c‘est leur numéro qui prévaudra.';
$string['slideranimationsetting'] = 'Animation du carrousel';
$string['slideranimationsetting_desc'] = 'Ce paramètre permet de définir la transition entre les diapositives. « Glissement » produit un effet de glissement de droite à gauche, « Fondu » applique un effet de fondu enchaîné, « Aucune » n‘applique aucune animation.';
$string['slideranimationsetting_fade'] = 'Fondu';
$string['slideranimationsetting_none'] = 'Auncune';
$string['slideranimationsetting_slide'] = 'Glissement';
$string['sliderarrownavsetting'] = 'Afficher les flèches de navigation';
$string['sliderarrownavsetting_desc'] = 'Ce paramètre permet d‘afficher des flèches de navigation sur les côtés des diapositives.';
$string['sliderfrontpagepositionsetting'] = 'Position du carrousel sur la page d‘accueil';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Après le contenu de la page d‘accueil (et après les tuiles publicitaires)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Après le contenu de la page d‘accueil (mais avant les tuiles publicitaires)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Avant le contenu de la page d‘accueil (mais après les tuiles publicitaires)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Avant le contenu de la page d‘accueil (et avant les tuiles publicitaires)';
$string['sliderfrontpagepositionsetting_desc'] = 'Le carrousel n‘est affiché que sur la page d‘accueil du site. Ce paramètre permet de définir si le carrousel doit être affiché avant ou après le contenu de la page d‘accueil. Si vous souhaitez que le carrousel soit le seul élément de la page d‘accueil, vous pouvez supprimer le reste du contenu de la page d‘accueil en modifiant les <a href="{$a->url}">paramètres de la page d‘accueil</a>.';
$string['slidergeneralheading'] = 'Paramètres généraux du carrousel';
$string['sliderindicatornavsetting'] = 'Activer les indicateurs de navigation';
$string['sliderindicatornavsetting_desc'] = 'Ce paramètre permet d‘afficher des indicateurs de navigation en-bas du carrousel.';
$string['sliderintervalsetting'] = 'Intervalle entre les slides';
$string['sliderintervalsetting_desc'] = 'Ce paramètre permet de régler la durée d‘affichage de chaque diapositive (en millisecondes). Vous pouvez définir une durée entre 1000 (1 seconde) et 10000 (10 secondes).';
$string['sliderkeyboardsetting'] = 'Navigation au clavier';
$string['sliderkeyboardsetting_desc'] = 'Ce paramètre permet d‘activer la navigation au clavier (touches fléchées). Désactiver cette fonction réduit l‘accessibilité.';
$string['sliderpausesetting'] = 'Pause au survol';
$string['sliderpausesetting_desc'] = 'Ce paramètre permet de mettre le défilement des diapositives en pause au survol de la souris. Désactiver cette fonction réduit l‘accessibilité.';
$string['sliderridesetting'] = 'Démarrage du défilement';
$string['sliderridesetting_afterinteraction'] = 'Par l‘utilisateur';
$string['sliderridesetting_desc'] = 'Ce parmètre permet de définir le démarrage du défilement. « Au chargement de la page » démarre le défilement automatiquement après le chargement de la page. « Par l‘utilisateur » démarre le défilement après lorsque l‘utilisateur interagit avec le carrousel. « Jamais » désactive le défilement automatique, l‘utilisateur doit faire défiler les diapositives manuellement.';
$string['sliderridesetting_never'] = 'Jamais';
$string['sliderridesetting_onpageload'] = 'Au chargement de la page';
$string['slidertab'] = 'Carrousel';
$string['sliderwrapsetting'] = 'Défilement en boucle';
$string['sliderwrapsetting_desc'] = 'Ce paramètre définit si le défilement doit se faire en boucle ou non. Si ce paramètre est désactivé, le défilement automatique s‘arrêtera à la dernière diapositive.';
$string['smartmenus'] = 'Menus intelligents';
$string['smartmenus_desc'] = '<p>Les menus intelligents permettent à l‘administrateur de créer des menus personnalisés qui peuvent s‘afficher à différents endroits du site, comme la barre de navigation, le menu utilisateur ou le menu inférieur sur mobile. Ces menus peuvent proposer différents types de contenus, comme des liens vers d‘autres pages ou ressources, des liens de catégorie ou de profil utilisateur.</p><p>Les administrateurs peuvent créer un nouveau menu, définir son contenu et paramétrer son affichage. Il peut également choisir où le menu sera affiché sur le site et s‘il est disponible pour tous les utilisateurs ou réservé à certains rôles.</p>';
$string['smartmenusbycohort'] = 'Cohorte';
$string['smartmenusbycohort_help'] = 'Restreindre l‘accès à une ou plusieurs cohortes';
$string['smartmenusbydate'] = 'Date';
$string['smartmenusbydate_help'] = 'Restreindre l‘accès de manière temporelle';
$string['smartmenusbydatefrom'] = 'À partir de';
$string['smartmenusbydatefrom_help'] = 'Masquer jusqu‘à ce que la date définie soit atteinte';
$string['smartmenusbydateuntil'] = 'Jusqu‘à';
$string['smartmenusbydateuntil_help'] = 'Masquer lorsque la date définie est atteinte';
$string['smartmenusbylanguage'] = 'Langue';
$string['smartmenusbylanguage_help'] = 'Restreindre l‘accès en fonction de la langue de l‘utilisateur';
$string['smartmenusbyrole'] = 'Rôle';
$string['smartmenusbyrole_help'] = 'Restreindre l‘accès en fonction des rôles utilisateurs';
$string['smartmenusdynamiccoursescompletionstatus'] = 'État d‘achèvement';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'L‘élément de menu « liste de cours dynamique » listera l‘ensemble des cours de l‘utilisateur qui correspondent à l‘état d‘achèvement sélectionné. Par exemple, si « En cours » est choisi, la liste ne reprendra que les cours dont la date de début est atteinte et la date de fin pas encore atteinte.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Terminé';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Inscrit';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'En cours';
$string['smartmenusdynamiccoursescoursecategory'] = 'Catégorie de cours';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'La liste de cours dynamique contiendra tous les cours des catégories sélectionnées';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Inclure les sous-catégories';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Si activé, la liste reprendra également les cours des sous-catégories de la catégorie sélectionnée.';
$string['smartmenusdynamiccoursesdaterange'] = 'Période';
$string['smartmenusdynamiccoursesdaterange_help'] = 'La liste de cours dynamique contiendra tous les cours qui correspondent à la période choisie.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'À venir';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Passé';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'En cours';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Rôle';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'La liste de cours dynamique contiendra tous les cours pour lesquels l‘utilisateur a le rôle sélectionné.';
$string['smartmenusexperimental'] = 'Attention : les menus intelligents sont totalement fonctionnels dans l‘état actuel de leur développement mais doivent tout de même être <em>considérés comme expérimentaux</em> en raison de la quantité de combinaisons possibles dans leur paramétrage, ce qui peut toujours mener à des comportements inattendus. Par conséquent, nous vous conseillons de les tester minutieusement. Si toutefois vous rencontrez des problèmes dans l‘utilisation des menus intelligents, merci de le signaler sur <a href="https://https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> en précisant clairement les étapes à remplir pour reproduire le problème.';
$string['smartmenusgeneralsectionheader'] = 'Paramètres généraux';
$string['smartmenusmenuaddnewitem'] = 'Ajouter un élément au menu';
$string['smartmenusmenucardform'] = 'Forme des cartes';
$string['smartmenusmenucardform_help'] = 'Pour les menus de sytle « cartes », choisissez la forme voulue pour les cartes, entre carré, portrait, paysage et largeur maximale';
$string['smartmenusmenucardformfullwidth'] = 'Largeur maximale';
$string['smartmenusmenucardformlandscape'] = 'Paysage';
$string['smartmenusmenucardformportrait'] = 'Portrait';
$string['smartmenusmenucardformsquare'] = 'Carré';
$string['smartmenusmenucardoverflowbehavior'] = 'Débordement du contenant';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Ce paramètre permet de choisir le comportement du menu lorsque son contenu déborde du contenant. Les possibilités sont l‘ajout d‘une barre de défilement ou le retour à la ligne.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Barre de défilement';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Retour à la ligne';
$string['smartmenusmenucardsize'] = 'Taille des cartes';
$string['smartmenusmenucardsize_help'] = 'Pour les menus de sytle « cartes », choisissez la taille voulue pour les cartes, entre XS, S, M et L maximale';
$string['smartmenusmenucardsizelarge'] = 'L';
$string['smartmenusmenucardsizemedium'] = 'M';
$string['smartmenusmenucardsizesmall'] = 'S';
$string['smartmenusmenucardsizetiny'] = 'XS';
$string['smartmenusmenucreate'] = 'Créer un menu';
$string['smartmenusmenucreatesuccess'] = 'Le menu intelligent a bien été créé';
$string['smartmenusmenucssclass'] = 'Classe CSS';
$string['smartmenusmenucssclass_help'] = 'Ce paramètre permet d‘ajouter une classe CSS au menu afin de pouvoir adapter son style.';
$string['smartmenusmenudeleteconfirm'] = 'Voulez-vous vraiment supprimer ce menu intelligent ?';
$string['smartmenusmenudeletesuccess'] = 'Le menu intelligent a bien été supprimé';
$string['smartmenusmenudescription'] = 'Description';
$string['smartmenusmenudescription_help'] = 'La description du menu. Elle est principalement utile pour la documentation interne, mais peut également être affichée dans le menu en activant le paramètre « Afficher la description ».';
$string['smartmenusmenuduplicate'] = 'Dupliquer le menu et son contenu';
$string['smartmenusmenuduplicatesuccess'] = 'Le menu et son contenu ont bien été dupliqués';
$string['smartmenusmenuedit'] = 'Modifier le menu';
$string['smartmenusmenueditsuccess'] = 'Le menu a bien été modifié';
$string['smartmenusmenuitemcardappearanceheader'] = 'Mise en forme de la carte';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Couleur d‘arrière-plan de la carte';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Permet de définir une couleur d‘arrière-plan pour la carte';
$string['smartmenusmenuitemcardimage'] = 'Image de la carte';
$string['smartmenusmenuitemcardimage_help'] = 'Permet de choisir une image à afficher à côté du titre de la carte';
$string['smartmenusmenuitemcardtextcolor'] = 'Couleur du titre de la carte';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Permet de choisir la couleur du titre de la carte';
$string['smartmenusmenuitemcreate'] = 'Ajouter un élément de menu';
$string['smartmenusmenuitemcreatesuccess'] = 'L‘élément de menu a bien été créé';
$string['smartmenusmenuitemcssclass'] = 'Classe CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Ce paramètre permet d‘ajouter une classe CSS à l‘élément de menu afin de pouvoir adapter son style.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Voulez-vous vraiment supprimer cet élément du menu intelligent ?';
$string['smartmenusmenuitemdeletesuccess'] = 'L’élément du menu intelligent a bien été supprimé';
$string['smartmenusmenuitemdisplayfield'] = 'Nom du cours';
$string['smartmenusmenuitemdisplayfield_help'] = 'Le nom qui sera utilisé comme titre de l‘élément de la liste de cours dynamique. Les possibilités sont le nom complet du cours ou le nom abrégé';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Nom complet';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Nom abrégé';
$string['smartmenusmenuitemdisplayoptions'] = 'Mise en forme du titre';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Permet de définir l‘apparence du titre de l‘élément';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Afficher seulement l‘icône (sur tous les dispositifs)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Afficher seulement l‘icône (sur mobiles)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Afficher le titre et l‘icône';
$string['smartmenusmenuitemduplicate'] = 'Dupliquer l‘élément de menu';
$string['smartmenusmenuitemduplicatesuccess'] = 'L‘élément de menu a bien été dupliqué';
$string['smartmenusmenuitemedit'] = 'Modifier l‘élément de menu';
$string['smartmenusmenuitemeditsuccess'] = 'L‘élément du menu intelligent a bien été modifié';
$string['smartmenusmenuitemicon'] = 'Icône';
$string['smartmenusmenuitemicon_help'] = 'L‘icône à afficher à côté du titre de l‘élément de menu';
$string['smartmenusmenuitemlinktarget'] = 'Cible du lien';
$string['smartmenusmenuitemlinktarget_help'] = 'Ce paramètre permet de choisir si le lien doit s‘ouvrir dans le même onglet ou ouvrir un nouvel onglet.';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Nouvel onglet';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Même onglet';
$string['smartmenusmenuitemlistsort'] = 'Tri de la liste de cours';
$string['smartmenusmenuitemlistsort_help'] = 'La liste de cours sera trié en fonction du critère et de l‘ordre de tri choisis.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'Identifiant technique croissant';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'Identifiant technique décroissant';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Numéro d‘identification croissant';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Numéro d‘identification descendant';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Nom complet croissant';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Nom complet décroissant';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Nom abrégé croissant';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Nom abrégé décroissant';
$string['smartmenusmenuitemmode'] = 'Format de l‘élément de menu';
$string['smartmenusmenuitemmode_help'] = '<p>Ce paramètre permet de définir la nature de l’élément de menu.</p><ul><li>Lien direct : l’élément de menu est un lien (option par défaut).</li><li>Sous-menu : l’élément permet au clic de déployer (ou de replier) un sous-menu. Ce format permet de construire un niveau de navigation supplémentaire, notamment pour déployer une liste de cours dynamique dans un sous-menu.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Ce menu intelligent est vide. Veuillez ajouter un élément à ce menu.';
$string['smartmenusmenuitemorder'] = 'Ordre';
$string['smartmenusmenuitemorder_help'] = 'Permet de spécifier la position de l‘élément dans le menu. Tous les éléments du menu seront ordonnés conformément à cette valeur.';
$string['smartmenusmenuitempresentationheader'] = 'Mise en forme de l‘élément';
$string['smartmenusmenuitemresponsive'] = 'Masquage responsive';
$string['smartmenusmenuitemresponsive_help'] = 'En cochant ces cases, l‘élément de menu sera masqué sur les dispositifs correspondants.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Ordinateur de bureau';
$string['smartmenusmenuitemresponsivemobile'] = 'Smartphone';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablette';
$string['smartmenusmenuitemrestriction'] = 'Restrictions d‘accès';
$string['smartmenusmenuitems'] = 'Éléments de menu';
$string['smartmenusmenuitemstructureheader'] = 'Structure de l‘élément';
$string['smartmenusmenuitemtextcount'] = 'Nombre de mots';
$string['smartmenusmenuitemtextcount_help'] = 'Définit un nombre maximum de mots à afficher pour les éléments d‘une liste de cours dynamique. Si ce paramètre n‘est pas défini, le titre entier sera affiché.';
$string['smartmenusmenuitemtextposition'] = 'Position du titre';
$string['smartmenusmenuitemtextposition_help'] = '<p>Permet de choisir la position du texte par rapport à l‘image de la carte. Les choix possibles sont : sous l‘image, superposition en-haut et superposition en-bas.</p><ul><li>Superposition en-haut : le titre de l‘élément est placé par superposition en-haut de l‘image.</li><li>Superposition en-bas : le titre de l‘élément est placé par superposition en-bas de l‘image</li><li>Sous l‘image : le titre de l‘élément est placé en-dessous de l‘image sans superposition</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Sous l’image';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Superposition en-bas';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Superposition en-haut';
$string['smartmenusmenuitemtitle'] = 'Nom';
$string['smartmenusmenuitemtitle_help'] = 'Le nom de l‘élément. Il sera utilisé comme étiquette pour cet élément du menu. Si vous souhaitez ajouter un séparateur dans le menu, choisissez « Titre » comme type d‘élément et utilisez des dièses (###) pour le nom de l‘élément.';
$string['smartmenusmenuitemtooltip'] = 'Info-bulle';
$string['smartmenusmenuitemtooltip_help'] = 'L‘info-bulle qui s‘affichera au survol de l‘élément';
$string['smartmenusmenuitemtype'] = 'Type d‘élément';
$string['smartmenusmenuitemtype_help'] = '<p>Choisissez le type d‘élément à ajouter, entre statique, titre et liste de cours dynamique.</p><ul><li>Statique : un élément statique est simplement un lien associé à une URL fixe.</li><li>Titre : un élément de ce type est utilisé pour regrouper des éléments de menus sous un titre commun. Ce type d‘élément n‘a pas de lien associé et n‘est pas cliquable</li><li>Liste de cours dynamique : un élément de ce type est utilisé pour afficher une liste de cours répondant à certains critères (catégorie de cours, rôle dans le cours, statut d‘achèvement du cours, intervalle de date). Le contenu d‘une liste dynamique de cours se met à jour automatiquement lorsqu‘on modifie les critères.</li></ul>';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Liste de cours dynamique';
$string['smartmenusmenuitemtypeheading'] = 'Titre';
$string['smartmenusmenuitemtypestatic'] = 'Statique';
$string['smartmenusmenuitemurl'] = 'URL du lien';
$string['smartmenusmenuitemurl_help'] = 'L‘URL statique associée à l‘élément de menu. Un clic sur l‘élément de menu renverra vers cette URL.';
$string['smartmenusmenulocation'] = 'Position(s) du menu';
$string['smartmenusmenulocation_help'] = '<p>Choisissez le ou les endroit(s) où vous souhaitez que le menu apparaisse :</p><ul><li>La navigation primaire se situe en-haut de la page, là où sont déjà présents les éléments de menu « Accueil », « Tableau de bord », « Mes cours » et « Administration du site ».</li><li>La barre de menu se situe au-dessus de la navigation primaire, tout en-haut de la page</li><li>Le menu utilisateur est accessible en cliquant sur l‘avatar de l‘utilisateur dans la barre de navigation.</li><li>La barre inférieure est située tout en-bas de l‘écran et permet de mettre en place une navigation tactile pour un accès facilité à certaines pages du site comme le tableau de bord, la page « Mes cours » ou encore la page d‘accueil.</li></ul><p>Notez que si vous activez la barre inférieure, le icône « hamburger » sera remplacée par le logo de votre site, vu que les utilisateurs pourront accéder à la navigation primaire via cette barre inférieure.</p>';
$string['smartmenusmenulocationbottom'] = 'Barre inférieure';
$string['smartmenusmenulocationmain'] = 'Navigation primaire';
$string['smartmenusmenulocationmenu'] = 'Barre de menu';
$string['smartmenusmenulocationuser'] = 'Menu utilisateur';
$string['smartmenusmenumode'] = 'Mode de déploiement';
$string['smartmenusmenumode_help'] = '<p>Choisissez le mode d’affichage.</p><ul><li>Sous-menu : le nom du menu constitue le nœud parent des éléments du menu. Ceux-ci sont déployés au clic sur le nom du menu. C’est l’option par défaut</li><li>En ligne : les éléments du menu sont placés l‘un après l‘autre directement dans la navigation. Cette option n‘est pas applicable aux menus de type « cartes »</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Comportement du menu « Plus »';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Choisissez le comportement à adopter s‘il n‘y a pas assez d‘espace disponible pour placer tous les menus.</p><ul><li>Ne rien changer : conserve le comportement par défaut de Moodle, les menus en trop seront placés automatiquement dans le menu « Plus ».</li><li>Placer dans le menu « Plus » : le menu est placé d‘office dans le menu « Plus », même s’il y a suffisamment d’espace disponible</li><li>Hors du menu « Plus » : </li>laisse le menu en dehors du menu « Plus » autant que faire se peut.</ul>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Placer dans le menu « Plus »';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Placer dans le menu « Plus »';
$string['smartmenusmenunothingtodisplay'] = 'Aucun menu intelligent n‘a été créé jusqu‘ici. Vous pouvez dès à présent créer votre premier menu intelligent.';
$string['smartmenusmenupresentationheader'] = 'Mise en forme du menu';
$string['smartmenusmenushowdescription'] = 'Afficher la description';
$string['smartmenusmenushowdescription_help'] = '<p>Choisissez d‘afficher ou non la description du menu et si oui, à quel endroit.</p><ul><li>Jamais : ne pas afficher la description dans le menu, elle ne sert qu‘à des fins de documentation (option par défaut).</li><li>Au-dessus : afficher la description au-dessus des éléments du menu.</li><li>En-dessous : afficher la description en-dessus des éléments du menu</li><li>Aide : afficher la description dans une info-bulle au-dessus des éléments du menu</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Au-dessus';
$string['smartmenusmenushowdescriptionbelow'] = 'En-dessous';
$string['smartmenusmenushowdescriptionhelp'] = 'Aide';
$string['smartmenusmenushowdescriptionnever'] = 'Jamais';
$string['smartmenusmenustructureheader'] = 'Structure du menu';
$string['smartmenusmenutitle'] = 'Nom';
$string['smartmenusmenutitle_help'] = 'Le nom du menu. Il sera utilisé comme étiquette pour le noeud parent de ce menu.';
$string['smartmenusmenutype'] = 'Présentation des éléments';
$string['smartmenusmenutype_help'] = 'Choisissez le type de présentation des éléments (liste ou cartes).</p><ul><li>Liste : les éléments sont affichés sous la forme d‘une liste de liens (option par défaut).</li><li>Cartes : les éléments du menu sont affichés sous la forme de cartes.</li></ul>';
$string['smartmenusmenutypecard'] = 'Cartes';
$string['smartmenusmenutypelist'] = 'Liste';
$string['smartmenusmodeinline'] = 'En ligne';
$string['smartmenusmodesubmenu'] = 'Sous-menu';
$string['smartmenusnorestrict'] = 'Aucune restriction';
$string['smartmenusoperator'] = 'Opérateur';
$string['smartmenusoperator_help'] = 'Choisissez l‘opérateur de combinaison pour une restriction par cohortes';
$string['smartmenusrestrictbycohortsheader'] = 'Restriction par cohortes';
$string['smartmenusrestrictbydateheader'] = 'Restriction par date';
$string['smartmenusrestrictbylanguageheader'] = 'Restriction par langue';
$string['smartmenusrestrictbyrolesheader'] = 'Restriction par rôles';
$string['smartmenusrolecontext'] = 'Contexte';
$string['smartmenusrolecontext_help'] = 'Choisissez dans quel contexte le rôle de l‘utilisateur doit être vérifié (n’importe quel contexte ou le contexte système seulement)';
$string['smartmenussavechangesandconfigure'] = 'Sauvegarder et configurer les éléments du menu';
$string['smartmenussettings'] = 'Paramètres du menu intelligent';
$string['speciallinksmarkupheading'] = 'Balisage des liens spéciaux';
$string['staticpagestab'] = 'Pages statiques';
$string['switchedroleto'] = 'Vous consultez actuellement ce cours avec le rôle : <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Purger le cache du thème';
$string['tilebackgroundimagepositionsetting'] = 'Emplacement de l’image d’arrière-plan de la tuile publicitaire {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Ce paramètre permet de contrôler le positionnement de l’image d’arrière-plan dans le conteneur {$a->no} de la tuile publicitaire. La première valeur est la position horizontale, la deuxième valeur est la position verticale.';
$string['tilebackgroundimagesetting'] = 'Tuile publicitaire {$a->no} image d’arrière-plan';
$string['tilebackgroundimagesetting_desc'] = 'Ici, il est possible de télécharger un fichier image qui sera affiché comme image d’arrière-plan derrière le contenu de la tuile publicitaire {$a->no}. Assurez-vous ou vérifiez que le contenu est toujours lisible sur l’image d’arrière-plan. Il s’agit d’un paramètre facultatif, la tuile publicitaire fonctionnera même si vous ne téléchargez aucune image d’arrière-plan.';
$string['tilecolumnssetting'] = 'Nombre de colonnes de tuiles publicitaires par ligne';
$string['tilecolumnssetting_desc'] = 'Ici, on définit le nombre de colonnes par ligne dans la grille de tuiles publicitaires présentée. Veuillez noter que ce nombre de colonnes s’applique aux ordinateurs de bureau/écrans plus grands. Sur les écrans plus petits et les écrans mobiles, les colonnes de tuiles publicitaires sont automatiquement enveloppées.';
$string['tilecontentsetting'] = 'Contenu de la tuile publicitaire {$a->no}';
$string['tilecontentsetting_desc'] = 'Saisir ici le contenu qui doit être affiché dans la tuile publicitaire {$a->no}. Le contenu est affiché au milieu de la tuile. Il s’agit d’un paramètre facultatif, la tuile publicitaire s’affichera même si vous ne définissez aucun contenu.';
$string['tilecontentstylesetting'] = 'Style de la tuile publicitaire {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Foncé (couleur de police noire pour des images d‘arrière-plan claires)';
$string['tilecontentstylesetting_darkshadow'] = 'Foncé et ombre (couleur de police noire et léger effet ombré pour des images d‘arrière-plan claires)';
$string['tilecontentstylesetting_desc'] = 'Ce paramètre permet de modifier le style du contenu de la tuile publicitaire {$a->no}. Par défaut, ce style est géré dans l’éditeur de texte ci-dessus. Cependant, afin de faciliter et d’homogénéiser l’habillage, vous pouvez surcharger ici le style défini dans l’éditeur de texte. Cela peut se révéler particulièrement utile lorsqu’on superpose du texte à une image d’arrière-plan.';
$string['tilecontentstylesetting_light'] = 'Clair (couleur de police blanche pour des images d‘arrière-plan foncées)';
$string['tilecontentstylesetting_lightshadow'] = 'Clair et ombré (couleur de police blanche et léger effet ombré pour des images d‘arrière-plan foncées)';
$string['tilecontentstylesetting_nochange'] = 'Ne rien changer (le style est géré via l‘éditeur de texte)';
$string['tileenabledsetting'] = 'Activer la tuile publicitaire {$a->no}';
$string['tileenabledsetting_desc'] = 'Ce paramètre permet d’activer la tuile publicitaire {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Position des tuiles publicitaires sur l’accueil du site';
$string['tilefrontpagepositionsetting_after'] = 'Après le contenu de l’accueil du site';
$string['tilefrontpagepositionsetting_before'] = 'Avant le contenu de l’accueil du site';
$string['tilefrontpagepositionsetting_desc'] = 'Les tuiles publicitaires sont affichées uniquement sur l’accueil du site. Ce paramètre permet de contrôler si les tuiles publicitaires sont affichées avant le contenu d’accueil du site ou après le contenu d’accueil du site. Pour afficher uniquement les tuiles publicitaires sur l’accueil du site et rien d’autre, tout autre contenu d’accueil du site peut être supprimé en modifiant les <a href="{$a->url}">paramètres d’accueil du site</a>.';
$string['tileheading'] = 'Tuile publicitaire {$a->no}';
$string['tileheightsetting'] = 'Hauteur des tuiles publicitaires';
$string['tileheightsetting_desc'] = 'Ce paramètre permet de contrôler la hauteur des tuiles publicitaires. La hauteur configurée est la hauteur minimale de chaque tuile. Si le contenu d’une tuile est supérieur à cette hauteur configurée, toute la rangée de tuiles sera automatiquement augmentée selon les besoins.';
$string['tilelinksetting'] = 'Lien URL de la tuile publicitaire {$a->no}';
$string['tilelinksetting_desc'] = 'Ici, il est possible de définir une URL (interne ou externe à Moodle) qui sera proposée comme bouton de lien à la fin de la tuile publicitaire {$a->no}. Il s’agit d’un paramètre facultatif, la tuile publicitaire fonctionnera même si aucune URL de lien n’est définie.';
$string['tilelinktargetsetting'] = 'Cible du lien vers la tuile publicitaire {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Ici, il est possible de définir la cible du lien qui est définie pour le bouton de lien dès que vous définissez une URL de lien dans la tuile publicitaire {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nouvel onglet';
$string['tilelinktargetsetting_samewindow'] = 'Même fenêtre';
$string['tilelinktitlefallback'] = 'Lien';
$string['tilelinktitlesetting'] = 'Titre du lien de la tuile publicitaire {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Ici, un titre de lien qui sera utilisé comme étiquette du bouton de lien peut être défini dès qu’on définit une URL de lien dans la tuile publicitaire {$a->no}. Veuillez noter que si on définit une URL de lien mais qu’on ne définit pas de titre de lien, le bouton de lien sera simplement étiqueté avec « Lien ».';
$string['tileordersetting'] = 'Position de l’ordre de la tuile publicitaire {$a->no}';
$string['tileordersetting_desc'] = 'Ce paramètre définit la position d’ordre de la tuile publicitaire {$a->no}. Par défaut, les tuiles publicitaires sont classées de haut en bas et de gauche à droite comme montré sur cette page de paramètres ici. Cependant, ce paramètre  permet de décider d’attribuer un autre ordre. Si on attribue la même position de commande à deux tuiles publicitaires ou plus, elles seront à nouveau classées selon l’ordre indiqué sur cette page de paramètres.';
$string['tilesgeneralheading'] = 'Paramètres généraux des tuiles publicitaires';
$string['tilestab'] = 'Tuiles publicitaires';
$string['tiletitlesetting'] = 'Titre de la publicité {$a->no}';
$string['tiletitlesetting_desc'] = 'Saisir ici le titre qui doit être affiché dans la tuile publicitaire {$a->no}. Il s’agit d’un paramètre facultatif, la tuile publicitaire s’affichera même si vous ne définissez pas de titre.';
$string['touchiconfilesios'] = 'Icônes d‘application pour iOS';
$string['touchiconfilesios_desc'] = 'Ce paramètre vous permet de téléverser des fichiers image qui serviront comme icône d‘application pour les dispositifs iOS lorsque l‘utilisateur ajoute le site Moodle sur son écran d‘accueil';
$string['touchiconfilesios_example'] = 'Exemple de nom de fichier : apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Les fichiers recommandés ont une taille suffisante pour être affichés correctement sur les appareils iOS actuels. Ces fichiers devraient être fournis. Les fichiers optionnels sont (ou ont été précédemment) supportés par les appareils iOS, mais ne doivent pas nécessairement être fournis, à moins que vous n’ayez des dispositifs anciens à supporter.';
$string['touchiconfilesios_optional'] = 'Fichiers optionnels pour iOS :';
$string['touchiconfilesios_recommended'] = 'Fichiers recommandés pour iOS :';
$string['touchiconfilesioslist'] = 'Liste des Icônes d‘application pour iOS';
$string['touchiconfilesioslist_desc'] = 'Il s‘agit de la liste des icônes que vous avez téléversés dans la zone de fichier des icônes d‘application pour iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Cette icône d‘application optionnelle pour iOS n‘a pas pu être téléversée.';
$string['touchiconlistiosoptionaluploaded'] = 'Cette icône d‘application optionnelle pour iOS a bien été téléversée.';
$string['touchiconlistiosrecommendedmissing'] = 'Cette icône d‘application recommandée pour iOS n‘a pas pu être téléversée.';
$string['touchiconlistiosrecommendeduploaded'] = 'Cette icône d‘application optionnelle pour iOS a bien été téléversée.';
$string['upgradenotice_2022080922'] = 'À partir de cette version, Boost Union a ses propres paramètres de logo et de logo compact et n’utilise plus ces fichiers des paramètres de base de Moodle.';
$string['upgradenotice_2022080922_copied'] = 'Le <strong>{$a}</strong> existant des paramètres de base de Moodle a été copié dans le paramètre Boost Union {$a} lors de cette mise à niveau. Merci de vérifier le résultat.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'logo compact';
$string['upgradenotice_2022080922_notcopied'] = 'Le paramètre <strong>{$a}</strong> dans Boost Union est maintenant vide. Pour utiliser un {$a} dans Boost Union à partir de maintenant, téléchargez-le simplement dans le paramètre Boost Union {$a} plus tard.';
$string['usermenuheading'] = 'Menu utilisateur';
