<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'it', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Etichetta Tecnologie assistive';
$string['acceptTerms'] = 'Accetto <a href=":url" target="_blank">le condizioni di utilizzo</a>';
$string['accountDetailsLinkText'] = 'qui';
$string['actions'] = 'Azioni';
$string['add'] = 'Aggiungi';
$string['addedandupdatedpp'] = 'Sono state aggiunte {$a->%new} librerie H5P e sono state aggiornate {$a->%old} precedenti.';
$string['addedandupdatedps'] = 'È stata aggiunta {$a->%new} libreria H5P ed è stata aggiornata {$a->%old} precedente.';
$string['addedandupdatedsp'] = 'Sono state aggiunte {$a->%new} librerie H5P e sono state aggiornate {$a->%old} precedenti.';
$string['addedandupdatedss'] = 'È stata aggiunta {$a->%new} libreria H5P ed è stata aggiornata {$a->%old} precedente.';
$string['addednewlibraries'] = 'Sono state aggiunte {$a->%new} nuove librerie H5P.';
$string['addednewlibrary'] = 'È stata aggiunta {$a->%new} nuova libreria H5P.';
$string['additionallicenseinfo'] = 'Informazioni aggiuntive sulla licenza';
$string['address'] = 'Indirizzo';
$string['age'] = 'Età destinatari';
$string['ageDescription'] = 'L\'età consigliata per i destinatari di questo contenuto. Ad esempio: "1,34-45,-50,59-".';
$string['altText'] = 'Testo alternativo';
$string['atto_h5p'] = 'Pulsante inserimento H5P';
$string['atto_h5p_description'] = 'Il Pulsante di Atto \'inserimento H5P\' consente di inserire contenuto H5P inserendo un URL, un codice di incorporamento oppure caricando un file H5P.';
$string['author'] = 'Autore';
$string['authorcomments'] = 'Commenti dell\'autore';
$string['authorcommentsdescription'] = 'Commenti per il redattore del contenuto (il testo non sarà visualizzato nelle informazioni di copyright).';
$string['authorname'] = 'Nome dell\'autore';
$string['authorrole'] = 'Ruolo dell\'autore';
$string['back'] = 'Indietro';
$string['by'] = 'di';
$string['cancelCrop'] = 'Annulla ritaglio';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'No';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Si';
$string['cancelPublishConfirmationDialogDescription'] = 'Sei sicuro di annullare il processo di condivisione?';
$string['cancelPublishConfirmationDialogTitle'] = 'Annulla condivisione';
$string['cancellabel'] = 'Annulla';
$string['ccattribution'] = 'Attribuzione (CC BY)';
$string['ccattributionnc'] = 'Attribuzione - Non commerciale (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribuzione - Non commerciale - Non opere derivate (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribuzione - Non commerciale - Condividi allo stesso modo (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribuzione - Non opere derivate (CC BY-ND)';
$string['ccattributionsa'] = 'Attribuzione - Condividi allo stesso modo (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changeHasBeenSubmitted'] = 'È stata inviata una modifica per';
$string['changedby'] = 'Modificato da';
$string['changedescription'] = 'Descrizione delle modifiche';
$string['changelog'] = 'Log delle modifche';
$string['changeplaceholder'] = 'Fotografia ritagliata, testo modificato, eccetera.';
$string['city'] = 'Città';
$string['close'] = 'Chiudi';
$string['confirmCrop'] = 'Conferma ritaglio';
$string['confirmdialogbody'] = 'Per favore conferma che desideri continuare. L\'azione non può essere annullata.';
$string['confirmdialogheader'] = 'Conferma azione';
$string['confirmlabel'] = 'Conferma';
$string['connectionLost'] = 'Il collegamento si è interrotto. I risultati saranno conservati e inviati quando la connessione sarà ristabilita.';
$string['connectionReestablished'] = 'Connessione ristabilita.';
$string['contactPerson'] = 'Persona di contatto';
$string['contactPersonDescription'] = 'H5P contatterà la persona di riferimento in caso di problemi con il contenuto condiviso dall\'editore. Il nome della persona di riferimento o altre informazioni non saranno pubblicate o condivise con terze parti';
$string['contentAvailable'] = 'Il contenuto sarà reso disponibile nell\'Hub in circa un giorno lavorativo';
$string['contentCopied'] = 'Il contenuto è stato copiato negli appunti';
$string['contentLicenseTitle'] = 'Informazioni sulla licenza del contenuto';
$string['contentUpdateSoon'] = 'Il contenuto sarà aggiornato presto';
$string['contentchanged'] = 'Il contenuto è cambiato dall\'ultima volta che lo hai utilizzato.';
$string['contentinuse'] = 'Questo contenuto potrebbe essere in uso in altri posti.';
$string['contenttype'] = 'Tipo di contenuto';
$string['copyright'] = 'Diritto di utilizzo';
$string['copyrightWarning'] = 'Il materiale protetto da copyright non può essere condiviso in H5P Content Hub. Se il contenuto è concesso in licenza con una licenza compatibile con OER come Creative Commons, sceglere la licenza appropriata. In caso contrario, questo contenuto non può essere condiviso.';
$string['copyrightinfo'] = 'Informazioni di copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Visualizza le Informazioni sul copyright di questo contenuto';
$string['couldNotParseJSONFromZip'] = 'Non è possibile analizzare JSON dal seguente pacchetto: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Non è possibile leggere file dal seguente pacchetto: {$a->%fileName}';
$string['country'] = 'Nazione';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Ritaglia immagine';
$string['currentStep'] = 'Passo :step di :total';
$string['date'] = 'Data';
$string['deletelibraryconfirm'] = '<p>Sei sicuro di eliminare la versione <em>\'{$a->version}\'</em> dalla libreria <em>\'{$a->name}\'</em>? Sarà rimossa la libreria e i relativi utilizzi.</p><p>L\'eliminazione non potrà essere annullata.</p>';
$string['deletelibraryversion'] = 'Elimina versione';
$string['deleting'] = 'Eliminazione libreria in corso';
$string['description'] = 'Descrizione';
$string['disablefullscreen'] = 'Disabilita schermo intero';
$string['discipline:dropdownButton'] = 'Pulsante a discesa';
$string['discipline:in'] = 'in';
$string['discipline:searchPlaceholder'] = 'Digitare per cercare tra le discipline';
$string['disciplineDescription'] = 'È possibile selezionare più discipline.';
$string['disciplineLabel'] = 'Discipline';
$string['disciplineLimitReachedMessage'] = 'È possibile selezionare fino a :numDisciplines  discipline';
$string['disciplines'] = 'Discipline';
$string['download'] = 'Scarica';
$string['downloadtitle'] = 'Scarica il contenuto come file H5P.';
$string['editInfoTitle'] = 'Modifica informazioni su <strong>:title</strong>';
$string['editcontent'] = 'Modifica contenuto H5P';
$string['editingFailed'] = 'Modifica non andata a buon fine.';
$string['editor'] = 'Redattore';
$string['emailAddress'] = 'Indirizzo email';
$string['emailAddressDescription'] = 'L\'indirizzo email verrà utilizzato da H5P per contattare l\'editore in caso di problemi con il contenuto o nel caso in cui l\'editore debba recuperare il proprio account. Non sarà pubblicato o condiviso con terze parti';
$string['embed'] = 'Incorpora';
$string['embedtitle'] = 'Visualizza il codice di incorporamento del contenuto';
$string['error:emptycontentid'] = 'L\'URL fornito non è corretto o non è possibile modificare questo file.';
$string['eventh5pdeleted'] = 'Eliminazione H5P';
$string['eventh5pviewed'] = 'Visualizzazione contenuto H5P';
$string['feature'] = 'Funzionalità';
$string['fetchtypesfailure'] = 'Non è stato possibile ricevere informazioni sui tipi di contenuto H5P disponibili. Si è verificato un problema con il collegamento al repository H5P';
$string['fileExceedsMaxSize'] = 'Uno dei file contenuti nel pacchetto supera la dimensione massima consentita.  ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Visualizzazione H5P';
$string['filter_displayh5p_description'] = 'Il filtro Visualizzazione H5P converte URL incorporate in contenuto H5P';
$string['fullscreen'] = 'Schermo intero';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'CSS Personalizzato';
$string['h5pcustomcss_help'] = 'CSS da applicare al contenuto H5P';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Il file H5p non è stato trovato.';
$string['h5pinvalidurl'] = 'L\'URL del contenuto H5P non è valido.';
$string['h5plibraryhandler'] = 'Gestore infrastruttura H5P';
$string['h5plibraryhandler_help'] = 'L\'infrastruttura H5P utilizzata per visualizzare contenuto H5P. Si raccomanda l\'utilizzo della versione più recente.';
$string['h5pmanage'] = 'Gestione tipi di contenuto H5P';
$string['h5poverview'] = 'Panoramica H5P';
$string['h5ppackage'] = 'Tipo di contenuto H5P';
$string['h5ppackage_help'] = 'Un tipo di contenuto H5P è un file con estensione H5P oppure ZIP che contiene le librerie necessarie per la visualizzazione del contenuto.';
$string['h5pprivatefile'] = 'Il contenuto H5P non può essere visualizzato poiché non puoi accedere a file .h5p.';
$string['h5psettings'] = 'Impostazioni H5P';
$string['h5ptitle'] = 'Visitare il sito H5P.org per trovare altri contenuti.';
$string['height'] = 'altezza';
$string['helpChoosingLicense'] = 'Aiutami a selezionare una licenza';
$string['hideadvanced'] = 'Nascondi avanzate';
$string['icon'] = 'Icona';
$string['iconDescription'] = '640x480px. Se non selezionata sarà usata l\'icona della categoria.';
$string['installedcontentlibraries'] = 'Librerie H5P installate';
$string['installedcontenttypes'] = 'Tipi di contenuto H5P installati';
$string['installedh5p'] = 'H5P installati';
$string['invalidAge'] = 'Formato di input non valido per l\'età tipica. Possibili formati di input, separato da virgole: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'Il file H5P non è stato trovato (il contexid non è valido)';
$string['invalidfile'] = 'Il file {$a->%filename}" ha un\'estensione non consentita. Le estensioni consentite sono le seguenti: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Nella libreria {$a->%library} è presente il file della lingua {$a->%file} che non è valido';
$string['invalidlanguagefile2'] = 'Nella libreria {$a->%library} è stato incluso il file della lingua {$a->%languageFile} che non è valido';
$string['invalidlibrarydata'] = 'Nella libreria {$a->%library} è stato fornito un dato non valido per {$a->%property}';
$string['invalidlibrarydataboolean'] = 'Nella libreria {$a->%library} è stato fornito un dato non valido per {$a->%property}. Era atteso un booleano.';
$string['invalidlibraryname'] = 'Il nome della libreria H5P non è valido: {$a->%name}';
$string['invalidlibrarynamed'] = 'La libreria H5P {$a->%library} utilizzata nel contenuto non è valida';
$string['invalidlibraryoption'] = 'L\'opzione {$a->%option} in {$a->%library} è illegale';
$string['invalidlibraryproperty'] = 'Non è possibile leggere la proprietà {$a->%property} in {$a->%library}';
$string['invalidmainjson'] = 'Manca un file h5p.json valido';
$string['invalidmultiselectoption'] = 'L\'opzione selezionata nella selezione multipla non è valida.';
$string['invalidpackage'] = 'Il tipo di contenuto H5P non è valido';
$string['invalidselectoption'] = 'L\'opzione selezionata non è valida.';
$string['invalidsemanticsjson'] = 'Nella libreria {$a->%name} è stato incluso un file semantics.json non valido';
$string['invalidsemanticstype'] = 'Errore interno H5P: tipo di contenuto sconosciuto "{$a->@type}" in semantics. Rimuovere il contenuto!';
$string['invalidstring'] = 'La stringa fornita non rispetta la semantica regexp. (Valore: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'È stato inviato all\'hub H5P';
$string['keywordExists'] = 'La parola chiave è già presente.';
$string['keywords'] = 'Parole chiave';
$string['keywordsDescription'] = 'È possibile inserire più parole chiave separata da virgola. Premere "Invio" o "Aggiungi" per confermare le parole chiave.';
$string['keywordsExits'] = 'Le parole chiave sono già presenti.';
$string['keywordsPlaceholder'] = 'Aggiungi parole chiave';
$string['language'] = 'Lingua';
$string['level'] = 'Livello';
$string['librariesmanagerdescription'] = '<p>H5P consente di creare contenuti interattivi mettendo a disposizione una serie di tipi contenuto.</p><p>Per garantire che nel sito siano utilizzati solamente contenuti H5P affidabili, è necessario:/p><ul><li>Caricare i tipi di contenuto H5P da h5p.org,<i>oppure</i></li><li>Abilitare l\'elaborazione pianificata \'Scaricamento tipi di contenuto H5P da h5p.org\'</li></ul><p>Da notare che gli utenti potranno utilizzare solamente i tipi di contenuto installati nel sito.</p>';
$string['librarydirectoryerror'] = 'Il nome della directory della libreria deve corrispondere a machineName o machineName-majorVersion.minorVersion (da library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licenza';
$string['licenseCC010'] = 'CC0 1.0 Universale (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universale';
$string['licenseCC10'] = '1.0 Generica';
$string['licenseCC20'] = '2.0 Generica';
$string['licenseCC25'] = '2.5 Generica';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Internazionale';
$string['licenseDescription'] = 'Selezionare la licenza del contenuto';
$string['licenseDetails'] = 'Dettagli licenza';
$string['licenseDialogDescription'] = 'Fare clic su una licenza specifica per ottenere informazioni sull\'uso corretto.';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Versione 1';
$string['licenseV2'] = 'Versione 2';
$string['licenseV3'] = 'Versione 3';
$string['licenseVersionDescription'] = 'Selezionare la versione della licenza';
$string['licensee'] = 'Licenziatario';
$string['licenseextras'] = 'Licenze extra';
$string['licenseversion'] = 'Versione delle licenza';
$string['lockh5pdeploy'] = 'Questo contenuto H5P non può essere visualizzato poiché è in fase di rilascio. Per favore riprova più tardi.';
$string['logoUploadText'] = 'Avatar o logo dell\'organizzazione';
$string['longDescription'] = 'Descrizione ampia';
$string['longDescriptionPlaceholder'] = 'Una descrizione più ampia del contenuto';
$string['mainTitle'] = 'Condivisione di <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Il file non può essere visualizzato perché il tipo di contenuto è disabilitato. Per favore contatta l\'amministratore per richiedere l\'abilitazione del tipo di contenuto.';
$string['maxLength'] = ':length è il numero massimo di caratteri';
$string['missingcontentfolder'] = 'Manca una cartella di contenuto valida.';
$string['missingcoreversion'] = 'Il sistema non è stato in grado di installare il componente {$a->% component} dal pacchetto, poiché è richiesta una versione più recente del plugin H5P. Al momento questo sito esegue la versione {$a->% corrente}, mentre la versione richiesta è {$a->% richiesto} o successiva. Riprovare dopo l\'aggiornamento.';
$string['missingdependency'] = 'Manca la dipendenza {$a->@dep} richiesta da {$a->@lib}.';
$string['missinglibrary'] = 'Manca la libreria obbligatoria {$a->@library}.';
$string['missinglibraryfile'] = 'Il file "{$a->%file}" non è presente nella libreria "{$a->%name}"';
$string['missinglibraryjson'] = 'Impossibile trovare il file library.json in un formato json valido per la libreria {$a->%name}';
$string['missinglibraryproperty'] = 'La proprietà richiesta {$a->%property} manca da {$a->%library}';
$string['missingmainlibrary'] = 'La libreria principale  è mancante';
$string['missingmbstring'] = 'L\'estensione PHP mbstring non è stata caricata, ma è richiesta da H5P per funzionare correttamente.';
$string['missinguploadpermissions'] = 'Da notare  che le librerie possono essere presenti esistere nel file caricato, ma non è consentito caricare nuove librerie. Contatta il tuo amministratore.';
$string['next'] = 'Successivo';
$string['nocopyright'] = 'Il contenuto non è corredato da informazioni sul copyright.';
$string['noextension'] = 'Il file che caricato non è un HTML5 Package valido (non ha l\'estensione .h5p).';
$string['noh5plibhandlerdefined'] = 'Non sono state installate infrastrutture H5P. Il contenuto H5p non potrà essere visualizzato.';
$string['nojson'] = 'Il file h5p.json non è valido';
$string['nopermissiontodeploy'] = 'Il file non può essere visualizzato poiché è stato caricato da un utente che non ha il privilegio di distribuire contenuti H5P.';
$string['nopermissiontoedit'] = 'Non sei autorizzato a modificare contenuto H5P.';
$string['notrustablefile'] = 'Il file non può essere visualizzato poiché è stato caricato da un utente che non ha il privilegio di aggiornare i tipi di contenuto H5P. Contatta l\'amministratore per richiedere l\'installazione del tipo di contenuto.';
$string['nounzip'] = 'Il file  caricato non è un HTML5 Package valido (non è possibile decomprimerlo).';
$string['offlineDialogBody'] = 'Non è stato possibile inviare le informazioni riguardo al completamento di questa azione. Si prega di controllare la connessione a internet.';
$string['offlineDialogHeader'] = 'La connessione al server è stata persa';
$string['offlineDialogRetryButtonLabel'] = 'Riprova ora';
$string['offlineDialogRetryMessage'] = 'Riprova tra :num...';
$string['offlineSuccessfulSubmit'] = 'Risultati inviati correttamente.';
$string['optionalInfo'] = 'Informazioni opzionali';
$string['originator'] = 'Ideatore';
$string['pd'] = 'Pubblico dominio';
$string['pddl'] = 'Public Domain Dedication e Licenza';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telefono';
$string['pleaseWait'] = 'Per favore attendere...';
$string['pluginname'] = 'Pacchetto H5P';
$string['privacy:metadata'] = 'Il sottosistema H5P non memorizza dati personali.';
$string['publisherDescription'] = 'Descrizione dell\'editore';
$string['publisherDescriptionText'] = 'Sarà visualizzato in "Informazioni sull\'editore" sui contenuti condivisi';
$string['publisherFieldDescription'] = 'Sarà visualizzato come "Nome dell\'editore" sui contenuti condivisi';
$string['publisherFieldTitle'] = 'Editore';
$string['registerOnHub'] = 'Registrati sull\'hub H5P';
$string['registrationFailed'] = 'Si è verificato un errore';
$string['registrationFailedDescription'] = 'Non è stato possibile creare un account. Per favore riprovare più tardi.';
$string['registrationTitle'] = 'Registrazione Hub H5P';
$string['remove'] = 'Rimuovi';
$string['removeChip'] = 'Rimuovi :chip dall\'elenco';
$string['removeImage'] = 'Elimina immagine';
$string['requiredInfo'] = 'Informazioni obbligatorie';
$string['resizescript'] = 'Includer questo script sul sito web se vuoi si desidera dimensionamento dinamico del contenuto incorporato:';
$string['resubmitScores'] = 'Tentativo di inviare risultati memorizzati';
$string['reuse'] = 'Riutilizza';
$string['reuseContent'] = 'Riutilizza contenuto';
$string['reuseDescription'] = 'Riutilizza questo contenuto.';
$string['reviewAndSave'] = 'Rivedi & Salva';
$string['reviewAndShare'] = 'Rivedi & Condividi';
$string['reviewInfo'] = 'Rivedi informazioni';
$string['reviewMessage'] = 'Prima di condividere, per favore rivedi le informazioni sottostanti';
$string['rotateLeft'] = 'Ruota a sinistra';
$string['rotateRight'] = 'Ruota a destra';
$string['saveChanges'] = 'Salva modifiche';
$string['screenshots'] = 'Schermate';
$string['screenshotsDescription'] = 'È possibile aggiungere fino a 5 schermate';
$string['share'] = 'Condividi';
$string['shareFailed'] = 'La condivisione non è andata a buon fine.';
$string['shareTryAgain'] = 'Qualcosa è andato storto, prova a condividere di nuovo.';
$string['shared'] = 'Condiviso';
$string['sharingNote'] = 'I dettagli relativi al contenuto potranno essere modificati dopo la condivisione.';
$string['shortDescription'] = 'Descrizione breve';
$string['shortDescriptionPlaceholder'] = 'Descrizione breve';
$string['showadvanced'] = 'Visualizza avanzate';
$string['showless'] = 'Visualizza di meno';
$string['showmore'] = 'Visualizza di più';
$string['size'] = 'Dimensione';
$string['someKeywordsExits'] = 'Alcune parole chiave sono già presenti.';
$string['source'] = 'Fonte';
$string['startingover'] = 'Stai per ricominciare.';
$string['status'] = 'Stato';
$string['subContentWarning'] = 'I contenuti secondari (immagini, domande, ecc.) saranno condivisi con :license se non diversamente specificato nello strumento di creazione';
$string['sublevel'] = 'Sottolivello';
$string['submitted'] = 'Inviato!';
$string['successfullyRegistred'] = 'L\'account  stato registrato correttamente sull\'Hub H5P';
$string['successfullyRegistredDescription'] = 'I dettagli dell\'account possono essere modificati';
$string['successfullyUpdated'] = 'Le impostazioni dell\'account H5P sono state modificate correttamente';
$string['task_h5p'] = 'Elaborazione pianificata H5P';
$string['task_h5p_description'] = 'L\'elaborazione pianificata H5P scarica da h5p.org i tipi di contenuto disponibili.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Titolo';
$string['undisclosed'] = 'Non divulgato';
$string['unpackedFilesExceedsMaxSize'] = 'La dimensione totale dei file non compressi supera il valore massimo consentito. ({$a->%used}';
$string['updateRegistrationOnHub'] = 'Salva impostazioni account';
$string['updatedlibraries'] = 'Aggiornate {$a->%old} librerie H5P.';
$string['updatedlibrary'] = 'Aggiornata {$a->%old} libreria H5P.';
$string['uploadlibraries'] = 'Carica tipi di contenuto H5P';
$string['uploadsuccess'] = 'I tipi di contenuto H5P sono stati caricati correttamente';
$string['width'] = 'larghezza';
$string['wrongversion'] = 'La versione delle libreria H5P {$a->%machineName} utiizzata in questo contenuto non è valida. Il contenuto utilizza {$a->%contentLibrary} invece di {$a->%semanticsLibrary}.';
$string['year'] = 'Anno';
$string['years'] = 'Anno(i)';
$string['yearsfrom'] = 'Anni (da)';
$string['yearsto'] = 'Anni (a)';
$string['zip'] = 'Zip';
