<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'it', version '4.3'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Contenuto "Chi siamo"';
$string['aboutuscontentsetting_desc'] = 'Con questa impostazione, è possibile aggiungere contenuti testuali ricchi che verranno mostrati nella pagina "Chi siamo".';
$string['aboutusdisabled'] = 'La pagina "Chi siamo" è disattivata per questo sito. Non c\'è nulla da vedere qui.';
$string['aboutusheading'] = 'Chi siamo';
$string['aboutuslinkpositionboth'] = 'Aggiungi un link alla pagina "Chi siamo" nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['aboutuslinkpositionfooter'] = 'Aggiungi un link alla pagina "Chi siamo" nell\'icona del piè di pagina (punto interrogativo)';
$string['aboutuslinkpositionfootnote'] = 'Aggiungi un link alla pagina "Chi siamo" nella nota a piè di pagina';
$string['aboutuslinkpositionnone'] = 'Non mostrare automaticamente un link alla pagina "Chi siamo"';
$string['aboutuslinkpositionsetting'] = 'Posizione link "Chi siamo"';
$string['aboutuslinkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina "Chi siamo" deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['aboutuspagetitledefault'] = 'Chi siamo';
$string['aboutuspagetitlesetting'] = 'Titolo pagina "Chi siamo"';
$string['aboutuspagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina "Chi siamo". Questo testo verrà utilizzato anche come testo del link alla pagina "Chi siamo", se si configura di conseguenza la voce \'Posizione del link "Chi siamo"\'.';
$string['activitybrandingtab'] = 'Branding delle attività';
$string['activityiconcoloradministrationsetting'] = 'Colore dell\'icona dell\'attività per "Amministrazione"';
$string['activityiconcoloradministrationsetting_desc'] = 'Il colore delle iconi dell\'attività per "Amministrazione"';
$string['activityiconcolorassessmentsetting'] = 'Colore dell\'icona dell\'attività per "Valutazione"';
$string['activityiconcolorassessmentsetting_desc'] = 'Il colore delle iconi dell\'attività per "Valutazione"';
$string['activityiconcolorcollaborationsetting'] = 'Colore dell\'icona dell\'attività per "Collaborazione"';
$string['activityiconcolorcollaborationsetting_desc'] = 'Il colore delle iconi dell\'attività per "Collaborazione"';
$string['activityiconcolorcommunicationsetting'] = 'Colore dell\'icona dell\'attività per "Comunicazione"';
$string['activityiconcolorcommunicationsetting_desc'] = 'Valutazione "Comunicazione"';
$string['activityiconcolorcontentsetting'] = 'Colore dell\'icona dell\'attività per "Contenuto"';
$string['activityiconcolorcontentsetting_desc'] = 'Il colore delle iconi dell\'attività per "Contenuto"';
$string['activityiconcolorinterfacesetting'] = 'Colore dell\'icona dell\'attività per "Interfaccia"';
$string['activityiconcolorinterfacesetting_desc'] = 'Il colore delle iconi dell\'attività per "Interfaccia"';
$string['activityiconcolorsheading'] = 'Colori delle icone delle attività';
$string['activitynavigationsetting'] = 'Elementi di navigazione tra le attività';
$string['activitynavigationsetting_desc'] = 'Con questa impostazione vengono visualizzati gli elementi per saltare all\'attività/risorsa precedente e successiva e il menu a tendina per saltare a un\'attività/risorsa distinta. Elementi dell\'interfaccia utente come questi esistevano già in Boost in Moodle Core fino a Moodle 3.11, ma sono stati rimossi in 4.0. Con Boost Union, è possibile riportarli.';
$string['activitypurposeadministration'] = 'Amministrazione';
$string['activitypurposeassessment'] = 'Valutazione';
$string['activitypurposecollaboration'] = 'Collaborazione';
$string['activitypurposecommunication'] = 'Comunicazione';
$string['activitypurposecontent'] = 'Contenuto';
$string['activitypurposeheading'] = 'Scopi delle icone delle attività';
$string['activitypurposeheading_desc'] = 'Con queste impostazioni, è possibile sovrascrivere il colore di sfondo dell\'icona dell\'attività, che è definito dallo scopo dell\'attività (e che è una caratteristica del plugin codificata in ogni attività).';
$string['activitypurposeheadingtechnote'] = 'Nota tecnica: a causa del modo in cui il core di Moodle implementa gli scopi delle attività e i loro colori, gli scopi delle attività sono sovrascrivibili con i CSS solo da Boost Union. Attualmente, tutte le aree del core di Moodle che mostrano icone di attività colorate dovrebbero essere coperte. Se si nota qualche area o plugin di terze parti che continua a mostrare i colori invariati degli scopi delle attività, si prega di segnalarlo su {$a}.';
$string['activitypurposeinterface'] = 'Interfaccia';
$string['activitypurposeother'] = 'Altro';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistente)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisionato)';
$string['additionalresourcesheading'] = 'Risorse aggiuntive';
$string['additionalresourceslistsetting'] = 'Elenco delle risorse aggiuntive';
$string['additionalresourceslistsetting_desc'] = 'Questo è l\'elenco dei file caricati nell\'area delle risorse aggiuntive. Gli URL indicati possono essere usati per collegarsi a questi file dall\'interno del CSS personalizzato, dalla nota a piè di pagina o da qualsiasi altro punto in cui sia necessario usare i file caricati, ma non si possono caricare i file sul posto.';
$string['additionalresourcessetting'] = 'Risorse aggiuntive';
$string['additionalresourcessetting_desc'] = 'Con questa impostazione è possibile caricare risorse aggiuntive nel tema. Il vantaggio di caricare file in quest\'area è che questi file possono essere consegnati senza controllare se l\'utente è connesso. Questo è anche il motivo per cui si dovrebbero aggiungere solo file non critici, a cui tutti dovrebbero poter accedere e che non hanno bisogno di essere protetti da un login valido. Non appena si è caricato almeno un file in quest\'area e si sono memorizzate le impostazioni, apparirà un elenco che fornirà l\'URL da utilizzare per fare riferimento a un determinato file.';
$string['administrationtab'] = 'Amministrazione';
$string['backgroundimagepositionsetting'] = 'Posizione dell\'immagine di sfondo';
$string['backgroundimagepositionsetting_desc'] = 'Con questa impostazione si controlla il posizionamento dell\'immagine di sfondo all\'interno della finestra del browser. Il primo valore è la posizione orizzontale, il secondo la posizione verticale.';
$string['backgroundimagesetting'] = 'Immagine di sfondo';
$string['backgroundimagesetting_desc'] = 'Qui è possibile caricare un\'immagine personalizzata da visualizzare come sfondo del sito. L\'immagine di sfondo caricata qui sostituirà l\'immagine di sfondo presente nei file di preselezione del tema.';
$string['backgroundimagesheading'] = 'Immagini generali di sfondo';
$string['backtotop'] = 'Torna all\'inizio';
$string['backtotopbuttonsetting'] = 'Pulsante "Torna all\'inizio"';
$string['backtotopbuttonsetting_desc'] = 'Con questa impostazione, nell\'angolo in basso a destra della pagina apparirà un pulsante "Torna all\'inizio", non appena l\'utente scorrerà la pagina verso il basso. Un pulsante di questo tipo esisteva già su Boost in Moodle Core fino a Moodle 3.11, ma è stato rimosso nella versione 4.0. Con Boost Union, è possibile ripristinarlo.';
$string['blockregionfooterwidth'] = 'Larghezza della regione di blocchi "Footer".';
$string['blockregionfooterwidth_desc'] = 'Con questa impostazione è possibile impostare la larghezza della regione del blocchi \'Footer\'. È possibile scegliere tra larghezza piena, larghezza del contenuto del corso e larghezza dell\'eroe.';
$string['blockregionoutsidebottomwidth'] = 'Larghezza della regione di blocchi "Outside (in basso)".';
$string['blockregionoutsidebottomwidth_desc'] = 'Con questa impostazione è possibile impostare la larghezza della regione del blocchi \'Outside (in basso)\'. È possibile scegliere tra larghezza piena, larghezza del contenuto del corso e larghezza dell\'eroe.';
$string['blockregionoutsideleftwidth'] = 'Larghezza della regione di blocchi "Outside (a sinistra)".';
$string['blockregionoutsideleftwidth_desc'] = 'Con questa impostazione è possibile impostare la larghezza della regione dei blocchi \'Outside (a sinistra)\'. È possibile scegliere tra larghezza piena, larghezza del contenuto del corso e larghezza dell\'eroe.';
$string['blockregionoutsiderightwidth'] = 'Larghezza della regione di blocchi "Outside (a destra)".';
$string['blockregionoutsiderightwidth_desc'] = 'Con questa impostazione è possibile impostare la larghezza della regione dei blocchi \'Outside (a destra)\'. È possibile scegliere tra larghezza piena, larghezza del contenuto del corso e larghezza dell\'eroe.';
$string['blockregionoutsidetopwidth'] = 'Larghezza della regione di blocchi "Outside (in alto)".';
$string['blockregionoutsidetopwidth_desc'] = 'Con questa impostazione è possibile impostare la larghezza della regione di blocchi \'Outside (in alto)\'. È possibile scegliere tra larghezza piena, larghezza del contenuto del corso e larghezza dell\'eroe.';
$string['blockregionsforlayout'] = 'Regioni di blocchi aggiuntive per il layout "{$a}".';
$string['blockregionsforlayout_desc'] = 'Con questa impostazione, è possibile abilitare regioni di blocchi aggiuntive per il layout \'{$a}\'.';
$string['blockregionsheading'] = 'Regioni di blocchi aggiuntive';
$string['blockregionsheading_desc'] = '<p>Boost Union fornisce un gran numero di regioni di blocchi aggiuntive che possono essere utilizzate per aggiungere e mostrare blocchi sull\'intera pagina Moodle:</p>
<ul><li>Le <em>regioni di blocchi Outside</em> sono posizionate su tutti e quattro i lati della pagina Moodle. Possono essere utilizzati per mostrare blocchi che accompagnano la pagina Moodle mostrata ma non appartengono direttamente al contenuto principale.</li>
<li>La <em>regione di blocchi Header</em> è posizionata tra l\'area esterna (in alto) e l\'area del contenuto principale. Può essere utilizzato per mostrare un blocco come informazione nell\'intestazione del corso.</li>
<li>Le <em>regioni di blocchi Content</em> vengono posizionate direttamente sopra e sotto il contenuto principale nell\'area del contenuto principale. Possono essere utilizzati per aggiungere blocchi al flusso del contenuto del corso.</li>
<li>Le <em>regioni di blocchi Footer</em> sono posizionate nella parte inferiore della pagina tra la regione di blocchi Outside (in basso) e la nota a piè di pagina. Hai tre regioni a piè di pagina disponibili per creare colonne, se necessario.</li>
<li>La <em>regione di blocchi Off-canvas</em> è in qualche modo speciale poiché si posiziona sopra l\'intera pagina Moodle come un cassetto. Il cassetto si apre dall\'icona a 9 punti all\'estrema destra della barra di navigazione. Hai a disposizione tre regioni fuori quadro per creare colonne, se necessario.</li></ul>
<p>Nota:</p>
<ul><li>Per impostazione predefinita, tutte le regioni di blocchi aggiuntive sono disabilitate. Abilita le regioni di blocchi particolari sui layout di pagina particolari in base alle tue esigenze. Cerca di concentrarti il più possibile: troppe regioni bloccate potrebbero sopraffare gli utenti finali.</li>
<li>Non appena viene abilitata un\'ulteriore regione di blocchi, questa è visibile per tutti gli utenti autenticati e modificabile da insegnanti e manager (a seconda del fatto se al particolare utente è consentito modificare quella particolare pagina Moodle, ovviamente). Ma ci sono anche capabilità theme/boost_union:viewregion* e theme/boost_union:editregion* che ti consentono di ottimizzare l\'utilizzo di ciascuna regione di blocchi in base alle tue esigenze.</li>
<li>Le regioni Outside (sinistra), Outside (destra), Content (in alto), Content (in basso) e la regione di blocchi Header non sono disponibili per tutti i layout di pagina.</li></ul>';
$string['blockregionsheading_experimental'] = 'Nota: le <em>regioni dei blocchi Outside (a sinistra) e Outside (a destra)</em> funzionano perfettamente allo stato attuale di implementazione, ma devono essere <em>considerate sperimentali</em> in quanto ancora non avvolgono correttamente su schermi di media larghezza. In questo contesto, usateli con cautela. Questo problema verrà risolto in una prossima versione.';
$string['blocksgeneralheading'] = 'Blocchi generali';
$string['blockstab'] = 'Blocchi';
$string['boost_union:configure'] = 'Essere in grado di configurare il tema come non amministratore';
$string['boost_union:editregioncontentlower'] = 'Modificare la regione di blocchi Content (in basso)';
$string['boost_union:editregioncontentupper'] = 'Modificare la regione di blocchi Content (in alto)';
$string['boost_union:editregionfootercenter'] = 'Modificare la regione di blocchi Footer (center)';
$string['boost_union:editregionfooterleft'] = 'Modificare la regione di blocchi Footer (a sinistra)';
$string['boost_union:editregionfooterright'] = 'Modificare la regione di blocchi Footer (a destra)';
$string['boost_union:editregionheader'] = 'Modificare la regione di blocchi Header';
$string['boost_union:editregionoffcanvascenter'] = 'Modificare la regione di blocchi Off-canvas (center)';
$string['boost_union:editregionoffcanvasleft'] = 'Essere in grado di modificare la regione di blocchi Off-canvas (a sinistra)';
$string['boost_union:editregionoffcanvasright'] = 'Modificare  la regione di blocchi Off-canvas (a destra)';
$string['boost_union:editregionoutsidebottom'] = 'Modificare la regione di blocchi Outside (in basso)';
$string['boost_union:editregionoutsideleft'] = 'Modificare  la regione di blocchi Outside (in alto)';
$string['boost_union:editregionoutsideright'] = 'Modificare  la regione di blocchi Outside (a destra)';
$string['boost_union:editregionoutsidetop'] = 'Modificare  la regione di blocchi Outside (a sinistra)';
$string['boost_union:viewhintcourseselfenrol'] = 'Essere in grado di visualizzare un suggerimento per l\'iscrizione spontanea senza limitazioni a un corso visibile.';
$string['boost_union:viewhintinhiddencourse'] = 'Essere in grado di vedere un suggerimento in un corso nascosto.';
$string['boost_union:viewregioncontentlower'] = 'Visualizzare la regione di blocchi Content (in basso)';
$string['boost_union:viewregioncontentupper'] = 'Visualizzare  la regione di blocchi Content (in alto)';
$string['boost_union:viewregionfootercenter'] = 'Visualizzare  la regione di blocchi Footer (center)';
$string['boost_union:viewregionfooterleft'] = 'Visualizzare la regione di blocchi Footer (a sinistra)';
$string['boost_union:viewregionfooterright'] = 'Visualizzare la regione di blocchi Footer (a destra)';
$string['boost_union:viewregionheader'] = 'Visualizzare la regione di blocchi Header';
$string['boost_union:viewregionoffcanvascenter'] = 'Visualizzare la regione di blocchi Off-canvas (center)';
$string['boost_union:viewregionoffcanvasleft'] = 'Visualizzare la regione di blocchi Off-canvas (a sinistra)';
$string['boost_union:viewregionoffcanvasright'] = 'Visualizzare la regione di blocchi Off-canvas (a destra)';
$string['boost_union:viewregionoutsidebottom'] = 'Visualizzare la regione di blocchi Outside (in basso)';
$string['boost_union:viewregionoutsideleft'] = 'Visualizzare la regione di blocchi Outside (in alto)';
$string['boost_union:viewregionoutsideright'] = 'Visualizzare la regione di blocchi Outside (a destra)';
$string['boost_union:viewregionoutsidetop'] = 'Visualizzare la regione di blocchi Outside (a sinistra)';
$string['bootstrapcolordangersetting'] = 'Colore bootstrap per "Pericolo"';
$string['bootstrapcolordangersetting_desc'] = 'Il colore bootstrap per "Pericolo"';
$string['bootstrapcolorinfosetting'] = 'Colore bootstrap per "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'Il colore bootstrap per "Info"';
$string['bootstrapcolorsheading'] = 'Colori Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Colore bootstrap per "Successo"';
$string['bootstrapcolorsuccesssetting_desc'] = 'Il colore bootstrap per "Successo"';
$string['bootstrapcolorwarningsetting'] = 'Colore Bootstrap per "Avviso"';
$string['bootstrapcolorwarningsetting_desc'] = 'Il colore Bootstrap per "Avviso"';
$string['bootstrapdangercolor'] = 'Colore pericolo';
$string['bootstrapdarkcolor'] = 'Colore scuro';
$string['bootstrapinfocolor'] = 'Colore info';
$string['bootstraplightcolor'] = 'Colore chiaro';
$string['bootstrapnone'] = 'Colore no bootstrap';
$string['bootstrapprimarycolor'] = 'Colore primario';
$string['bootstrapsecondarycolor'] = 'Colore secondario';
$string['bootstrapsuccesscolor'] = 'Colore successo';
$string['bootstrapwarningcolor'] = 'Colore avviso';
$string['brandcolorsheading'] = 'Colori del brand';
$string['breadcrumbsheading'] = 'Briciola';
$string['cachedef_flavours'] = 'Flavours che si applicano a un determinato ID di categoria di corso per l\'utente corrente';
$string['categorybreadcrumbs'] = 'Visualizza i breadcrumb della categoria nell\'intestazione del corso';
$string['categorybreadcrumbs_desc'] = 'Per impostazione predefinita, i breadcrumb della categoria del corso non vengono visualizzati nelle pagine del corso nell\'intestazione del corso. Con questa impostazione, puoi mostrare i breadcrumb della categoria del corso nell\'intestazione del corso sopra il nome del corso.';
$string['choosereadme'] = '<p>Il tema Boost Union è un tema figlio migliorato di Boost che ha lo scopo, da un lato, di rendere Boost semplicemente più configurabile e, dall\'altro, di fornire utili funzionalità aggiuntive per il funzionamento quotidiano di Moodle da parte di amministratori, insegnanti e studenti.</p><p>Boost Union è gestito da<br />Moodle an Hochschulen e.V.,</p><p>in collaborazione con<br />lern.link GmbH</p><p>insieme a<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Chiudi il cassetto Off-canvas';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Contenuto';
$string['configtitlefeel'] = 'Feel';
$string['configtitleflavours'] = 'Flavour';
$string['configtitlefunctionality'] = 'Funzionalità';
$string['configtitlelook'] = 'Look';
$string['contactcontentsetting'] = 'Contenuto pagina "Contatti"';
$string['contactcontentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina "Contatti" (che non è la stessa della pagina incorporata "Contatta il supporto del sito" di Moodle)..';
$string['contactdisabled'] = 'La pagina "Contatti" è disattivata per questo sito. Non c\'è nulla da vedere qui.';
$string['contactheading'] = 'Contatto';
$string['contactlinkpositionboth'] = 'Aggiungi un link alla pagina "Contatti" nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['contactlinkpositionfooter'] = 'Aggiungi un link alla pagina "Contatti" nell\'icona del piè di pagina (punto interrogativo)';
$string['contactlinkpositionfootnote'] = 'Aggiungi un link alla pagina "Contatti" nella nota a piè di pagina';
$string['contactlinkpositionnone'] = 'Non mostrare automaticamente un link alla pagina "Contatti"';
$string['contactlinkpositionsetting'] = 'Posizione link "Contatti"';
$string['contactlinkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina "Contatti" deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['contactpagetitledefault'] = 'Contatti';
$string['contactpagetitlesetting'] = 'Titolo della pagina "Contatti"';
$string['contactpagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina "Contatti". Questo testo verrà utilizzato anche come testo del link alla pagina "Contatti", se si configura di conseguenza la voce \'Posizione del link "Contatti"\'.';
$string['contentwidthheading'] = 'Larghezza del contenuto';
$string['coursecontentmaxwidthsetting'] = 'Larghezza massima contenuto del corso';
$string['coursecontentmaxwidthsetting_desc'] = 'Con questa impostazione, è possibile sovrascrivere la larghezza del contenuto del corso senza modifiche manuali di SCSS. Questa larghezza viene utilizzata come larghezza di pagina delle pagine del corso e all\'interno di diverse attività. Per impostazione predefinita, Moodle utilizza una larghezza massima del contenuto del corso di 830px. È possibile inserire altri valori in pixel, come 1200px, ma anche un valore in percentuale, come 100%, o un valore di larghezza di visualizzazione, come 90vw.';
$string['courseheaderheading'] = 'Intestazione del corso';
$string['courseheaderimageenabled'] = 'Visualizza l\'immagine del corso nell\'intestazione del corso';
$string['courseheaderimageenabled_desc'] = 'Se attivato, l\'immagine del corso (che può essere caricata nelle impostazioni del corso) viene visualizzata nell\'intestazione del corso. Le immagini dei corsi vengono visualizzate in aggiunta alla pagina "I miei corsi", dove sono sempre presenti.';
$string['courseheaderimagefallback'] = 'Immagine dell\'intestazione del corso di riserva';
$string['courseheaderimagefallback_desc'] = 'Se carichi un\'immagine in questa impostazione, verrà utilizzata come immagine di riserva e verrà visualizzata nell\'intestazione del corso se non viene caricata alcuna immagine del corso nelle impostazioni del corso di un corso particolare. Se non carichi un\'immagine qui, l\'immagine dell\'intestazione del corso verrà mostrata in un corso particolare solo se un\'immagine del corso viene caricata nelle impostazioni del corso di questo corso particolare.';
$string['courseheaderimageheight'] = 'Altezza dell\'immagine del corso nell\'intestazione del corso';
$string['courseheaderimageheight_desc'] = 'Con questa impostazione, è possibile controllare l\'altezza dell\'immagine del corso nell\'intestazione del corso';
$string['courseheaderimagelayout'] = 'Layout dell\'immagine del corso nell\'intestazione del corso';
$string['courseheaderimagelayout_desc'] = 'Con questa impostazione si controlla il layout dell\'immagine dell\'intestazione del corso e del titolo del corso.';
$string['courseheaderimagelayoutheadingabove'] = 'Titolo del corso sopra l\'immagine del corso';
$string['courseheaderimagelayoutstackeddark'] = 'Titolo del corso sovrapposto all\'immagine del corso (colore del carattere bianco per le immagini a sfondo scuro)';
$string['courseheaderimagelayoutstackedlight'] = 'Titolo del corso sovrapposto all\'immagine del corso (colore del carattere nero per le immagini a sfondo chiaro)';
$string['courseheaderimageposition'] = 'Posizione dell\'immagine del corso nell\'intestazione del corso';
$string['courseheaderimageposition_desc'] = 'Con questa impostazione si controlla il posizionamento dell\'immagine dell\'intestazione del corso all\'interno del contenitore dell\'immagine dell\'intestazione del corso. Il primo valore è la posizione orizzontale, il secondo la posizione verticale.';
$string['coursemanagementheading'] = 'Gestisci i corsi';
$string['courserelatedhintsheading'] = 'Suggerimenti relativi al corso';
$string['coursestab'] = 'Corsi';
$string['coursetab'] = 'Corso';
$string['cssh5pheading'] = 'CSS grezzo per H5P';
$string['cssh5psetting'] = 'CSS grezzo per H5P';
$string['cssh5psetting_desc'] = 'Utilizza questo campo per fornire il codice CSS che sarà applicato alla presentazione dei contenuti H5P da parte di mod_h5p e mod_hvp. Consultare i tipi di contenuto H5P per trovare i selettori CSS necessari.';
$string['customfontsfileurlpersistent'] = 'URL (persistene)';
$string['customfontsfileurlrevisioned'] = 'URL (revisionato)';
$string['customfontsheading'] = 'Font personalizzati';
$string['customfontslistsetting'] = 'Lista dei font personalizzati';
$string['customfontslistsetting_desc'] = 'Questo è l\'elenco dei font caricati nell\'area dei file dei font personalizzati. Gli snippet CSS forniti possono essere usati per aggiungere questi font al vostro SCSS personalizzato. Si noti che per ora è necessario occuparsi del valore del formato dei font e delle proprietà CSS font-family, font-style e font-weight, poiché Boost Union non è ancora in grado di analizzare i file dei font.';
$string['customfontssetting'] = 'Font personalizzati';
$string['customfontssetting_desc'] = 'Con questa impostazione è possibile caricare font personalizzati nel tema. Il vantaggio di caricare i font in quest\'area di file è che questi font possono essere consegnati senza controllare se l\'utente è connesso e possono essere utilizzati come font installati localmente ovunque nel sito. Dopo aver caricato almeno un font in quest\'area e averne memorizzato le impostazioni, apparirà un elenco che fornirà degli snippet di codice CSS che potrete usare come boilerplate per fare riferimento a particolari font nei vostri SCSS personalizzati.';
$string['dontchange'] = 'Non cambiare nulla';
$string['emailbrandinghtmldemobody'] = '<p>Il corpo della e-mail inizia qui.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Il corpo della e-mail termina qui.</p>';
$string['emailbrandinghtmlheading'] = 'Anteprima della e-mail HTML';
$string['emailbrandinghtmlintro'] = 'Questo è un\'anteprima di un messaggio e-mail HTML basato sui prefissi e suffissi di branding attualmente impostati nel language pack.';
$string['emailbrandinghtmlnopreview'] = 'Finora, le e-mail HTML non sono stati personalizzati nell\'ambito di questa funzione. Le e-mail saranno composti e inviati normalmente.';
$string['emailbrandinginstruction'] = 'How-to';
$string['emailbrandinginstruction0'] = 'Con questa funzione di Boost Union, è possibile applicare il branding a tutte le e-mail inviate da Moodle.';
$string['emailbrandinginstructionli1'] = 'Vai alla <a href="{$a->url}" target="_blank">pagina delle impostazioni di personalizzazione lingua</a> per aprire il language pack <em>{$a->lang}</em> per la modifica.';
$string['emailbrandinginstructionli2'] = 'Cerca e modifica queste stringhe nel language pack <code>theme_boost_union</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailtextsuffix</code>: questo snippet verrà aggiunto <em>alla fine / dopo il corpo</em> di tutte le <em>e-mail in HTML</em> che Moodle sta inviando.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailtextsuffix</code>: questo snippet verrà aggiunto <em>alla fine / dopo il corpo</em> di tutte le <em>e-mail HTML</em> che Moodle sta inviando.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: questo snippet verrà aggiunto <em>all\'inizio / prima del corpo</em> di tutte le <em>e-mail in testo semplice</em> che Moodle sta inviando.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: questo snippet verrà aggiunto <em>alla fine / dopo il corpo</em> di tutte le <em>e-mail in testo semplice</em> che Moodle sta inviando.';
$string['emailbrandinginstructionli3'] = 'Salva le modifiche nel language pack';
$string['emailbrandinginstructionli4'] = 'Torna a questa pagina e dai un\'occhiata alle anteprime delle e-mail qui sotto.';
$string['emailbrandingintroheading'] = 'Introduzione';
$string['emailbrandingintronote'] = 'Nota bene: si tratta di una funzionalità avanzata che utilizza alcuni accorgimenti per fornire opzioni di branding per le e-mail. Seguire attentamente le istruzioni.';
$string['emailbrandingpitfalls'] = 'Insidie';
$string['emailbrandingpitfalls0'] = 'L\'utilizzo di questa funzione presenta alcune insidie di cui è bene tenere conto:';
$string['emailbrandingpitfallsli1'] = 'È obbligatorio modificare le stringhe del language pack della <em>lingua predefinita corrente</em> di questo sito. Anche se sono installati più language pack, avranno effetto solo le modifiche alla lingua predefinita.';
$string['emailbrandingpitfallsli2'] = 'Non è possibile rispettare la lingua del destinatario. Pertanto, all\'interno dei vostri snippet di branding per le e-mail dovreste utilizzare termini che non tengano conto della lingua.';
$string['emailbrandingpitfallsli3'] = 'Se in futuro cambierai la lingua predefinita del sito, dovrai migrare le stringhe del language pack modificate al nuovo language pack predefinito.';
$string['emailbrandingpitfallsli4'] = 'Nei messaggi di posta elettronica in testo semplice, è presente un\'interruzione di riga e una riga vuota aggiunta automaticamente dopo il prefisso e una riga vuota aggiunta automaticamente prima dello snippet del suffisso. Questo per garantire che il suffisso e il prefisso non si attacchino direttamente al corpo della e-mail.';
$string['emailbrandingpitfallsli5'] = 'Nelle e-mail HTML, il prefisso e il suffisso vengono aggiunti direttamente prima e sopra il corpo del messaggio e-mail. Questo per far sì che possiate lavorare facilmente con i tag HTML, ma dovrete gestire voi stessi la spaziatura intorno al corpo.';
$string['emailbrandingpitfallsli6'] = 'Nelle e-mail HTML, è possibile aprire un tag HTML nello snippet del prefisso e chiudere il tag nello snippet del suffisso senza problemi. Basta ricordarsi di creare un HTML valido nella mail risultante.';
$string['emailbrandingtab'] = 'Branding delle e-mail';
$string['emailbrandingtextdemobody'] = 'Il corpo della e-mail inizia qui.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Il corpo della e-mail termina qui.';
$string['emailbrandingtextheading'] = 'Anteprima della e-mail in testo semplice';
$string['emailbrandingtextintro'] = 'Questo è un\'anteprima di un messaggio e-mail in testo semplice basato sui prefissi e suffissi di branding attualmente impostati nel language pack.';
$string['emailbrandingtextnopreview'] = 'Fino ad ora, le e-mail in testo semplice non sono state personalizzate all\'interno di questa funzionalità. Le e-mail verranno composte e inviate normalmente.';
$string['enableaboutussetting'] = 'Abilita pagina "Chi siamo"';
$string['enablecontactsetting'] = 'Abilita pagina "Contatto"';
$string['enablehelpsetting'] = 'Abilita pagina "Aiuto"';
$string['enableimprintsetting'] = 'Abilita pagina "Impronta"';
$string['enablemaintenancesetting'] = 'Abilita pagina "Informazioni sulla manutenzione"';
$string['enableofferssetting'] = 'Abilita pagina "Offerte"';
$string['enablepage1setting'] = 'Abilita pagina generica 1';
$string['enablepage2setting'] = 'Abilita pagina generica 2';
$string['enablepage3setting'] = 'Abilita pagina generica 3';
$string['error:infobannerdismissnonotdismissible'] = 'Il banner informativo non è dismissibile';
$string['error:infobannerdismissnonotvalid'] = 'Il numero del banner informativo fornito non è valido';
$string['faviconheading'] = 'Favicon';
$string['faviconheading_desc'] = 'Nota bene: Boost Union ha un proprio upload di favicon e non utilizza la favicon di <a href="{$a}">Impostazione favicon di Moodle core</a>.<br />Boost Union permette in particolare di sovrascrivere la favicon caricata all\'interno dei suoi flavour.';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Qui è possibile caricare un\'immagine personalizzata (formato .ico o .png) che il browser mostrerà come favicon del sito web di Moodle. Se non viene caricata alcuna favicon personalizzata, verrà utilizzata la favicon standard di Moodle.';
$string['flavoursappliesto'] = 'Applica a';
$string['flavoursapplytocategories'] = 'Applica a categorie di corso';
$string['flavoursapplytocategories_help'] = 'Qui si definisce se questo flavour deve essere applicato alle categorie di corso.';
$string['flavoursapplytocategories_ids'] = 'Categorie di corso';
$string['flavoursapplytocategories_ids_help'] = 'Qui si definiscono una o più categorie di corso a cui applicare il flavour. Non appena la pagina Moodle visualizzata si trova all\'interno di una delle categorie di corso configurate, il flavour viene applicato.';
$string['flavoursapplytocohorts'] = 'Applica a gruppi globali';
$string['flavoursapplytocohorts_help'] = 'Qui si definisce se questo flavour deve essere applicato agli gruppi globali.';
$string['flavoursapplytocohorts_ids'] = 'Gruppi globali';
$string['flavoursapplytocohorts_ids_help'] = 'Qui si definiscono una o più gruppi globali particolari a cui applicare il flavour. Non appena l\'utente è membro di una degli gruppi globali configurati, il flavour viene applicato.<br /><br />Si noti che, se si definiscono più gruppi globali, non è necessario che l\'utente sia membro di tutti contemporaneamente.<br /><br />Si noti inoltre che, allo stato attuale dell\'implementazione, i gruppi globali di categoria sono trattate come se fossero gruppi globali di sistema.';
$string['flavoursbackgroundimage'] = 'Immagine di sfondo';
$string['flavoursbackgroundimage_help'] = 'Con questa impostazione, il flavour sovrascrive l\' immagine di sfondo configurata nelle impostazioni dell\'aspetto di Boost Union.';
$string['flavoursbacktooverview'] = 'Torna alla panoramica dei flavour';
$string['flavourscreateflavour'] = 'Crea flavour';
$string['flavoursdelete'] = 'Eliminare';
$string['flavoursdeleteconfirmation'] = 'Sei sicuro di eliminare il flavour <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Eliminare flavour';
$string['flavoursdescription'] = 'Descrizione';
$string['flavoursdescription_help'] = 'La descrizione del flavour è usata solo internamente per consentire di identificare un particolare flavour nella panoramica degli flavour.';
$string['flavoursedit'] = 'Modificare';
$string['flavourseditflavour'] = 'Modificare flavour';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Con questa impostazione, il flavour sovrascrive la favicon configurata nelle impostazioni dell\'aspetto di Boost Union.';
$string['flavoursflavours'] = 'Flavour';
$string['flavoursgeneralsettings'] = 'Impostazioni generali';
$string['flavoursincludesubcategories'] = 'Includere le sottocategorie';
$string['flavoursincludesubcategories_help'] = 'Se selezionato, il flavour verrà applicato anche alle sottocategorie delle categorie scelte.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Con questa impostazione, il flavour sovrascrive il logo configurato nelle impostazioni dell\'aspetto di Boost Union.';
$string['flavourslogocompact'] = 'Logo compatto';
$string['flavourslogocompact_help'] = 'Con questa impostazione, il flavour sovrascrive il logo configurato nelle impostazioni dell\'aspetto di Boost Union.';
$string['flavoursnothingtodisplay'] = 'Non ci sono ancora flavour creati. Si prega di creare il primo flavour per far andare le cose.';
$string['flavoursnotificationcreated'] = 'Il flavour è stato creato con successo';
$string['flavoursnotificationdeleted'] = 'Il flavour è stato eliminato con successo';
$string['flavoursnotificationedited'] = 'Il flavour è stato modificato con successo';
$string['flavoursoverview_desc'] = '<p>I flavour di Boost Union offrono la possibilità di sovrascrivere particolari impostazioni di look & feel di Moodle in determinati contesti. In questa pagina è possibile creare e gestire i flavour</p><p>In ogni flavour si definisce se deve essere applicato a particolari categorie di corsi o a particolari gruppi globali. In seguito, durante il rendering di ogni pagina di Moodle, Boost Union verifica l\'applicabilità di un determinato flavour. Si noti che, per ogni rendering di pagina Moodle viene applicato solo il primo flavour corrispondente nell\'elenco e i restanti flavour vengono ignorati. Pertanto, l\'ordine dei flavour in questa pagina è fondamentale.</p><p>Si noti inoltre che dopo ogni modifica apportata all\'insieme dei flavour, la cache del tema viene cancellata. Questo è necessario per assicurarsi che tutte le risorse siano inviate al browser in modo corretto e aggiornato.</p>';
$string['flavourspreview'] = 'Anteprima';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Anteprima del flavour';
$string['flavourstitle'] = 'Titolo';
$string['flavourstitle_help'] = 'Il titolo dell\'flavour è usato solo internamente per consentire di documentare un particolare flavour nella panoramica degli flavour.';
$string['footertab'] = 'Piè di pagina';
$string['footnoteheading'] = 'Nota a piè pagina';
$string['footnotesetting'] = 'Nota a piè pagina';
$string['footnotesetting_desc'] = 'Qualsiasi cosa venga aggiunta a questa textarea verrà visualizzata alla fine di una pagina, nel piè di pagina (non nel piè di pagina fluttuante) di ogni pagina che utilizza i layout "drawers", "columns2" o "login". Il contenuto di quest\'area potrebbe essere, ad esempio, il copyright, le condizioni d\'uso o il nome della vostra organizzazione. <br/>Se si desidera rimuovere nuovamente la nota a piè pagina, è sufficiente svuotare l\'area di testo.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Larghezza massima deposito dei contenuti H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Con questa impostazione, è possibile sovrascrivere la larghezza del deposito di contenuti H5P di Moodle senza modifiche manuali di SCSS. Questa larghezza viene utilizzata per l\'editor H5P all\'interno del banco di contenuti. <em>Non</em> viene utilizzata per la larghezza dell\'attività H5P. Per impostazione predefinita, Moodle utilizza una larghezza massima del deposito di contenuti H5P di 960px. È possibile inserire altri valori in pixel, come 1200px, ma anche un valore in percentuale, come 100%, o un valore di larghezza di visualizzazione, come 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Contenuto pagina \'Aiuto\'';
$string['helpcontentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina "Aiuto"';
$string['helpdisabled'] = 'La pagina aiuto è disabilitata per questo sito. Non c\'è niente da vedere qui.';
$string['helpheading'] = 'Aiuto';
$string['helplinkpositionboth'] = 'Aggiungi un link alla pagina "Aiuto" nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['helplinkpositionfooter'] = 'Aggiungi un link alla pagina "Aiuto" nell\'icona del piè di pagina (punto interrogativo)';
$string['helplinkpositionfootnote'] = 'Aggiungi un link alla pagina "Aiuto" nella nota a piè di pagina';
$string['helplinkpositionnone'] = 'Non mostrare automaticamente un link alla pagina "Aiuto"';
$string['helplinkpositionsetting'] = 'Posizione link "Aiuto"';
$string['helplinkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina "Aiuto" deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['helppagetitledefault'] = 'Aiuto';
$string['helppagetitlesetting'] = 'Titolo della pagina "Aiuto"';
$string['helppagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina "Aiuto". Questo testo verrà utilizzato anche come testo del link alla pagina "Aiuto", se si configura di conseguenza la voce \'Posizione del link "Aiuto"\'.';
$string['hidenodesprimarynavigationsetting'] = 'Nascondi nodi nella navigazione primaria';
$string['hidenodesprimarynavigationsetting_desc'] = 'Con questa impostazione, è possibile nascondere uno o più nodi dalla navigazione primaria.<br /><br />
Nota bene: qui si possono solo rimuovere i nodi di navigazione. Ma se si desidera aggiungere nodi di navigazione personalizzati, si consiglia di utilizzare la <a href="{$a->url}">funzionalità smart menu di Boost Union</a>.';
$string['imprintcontentsetting'] = 'Contenuto impronta';
$string['imprintcontentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina "Informazione legale"';
$string['imprintdisabled'] = 'La pagina impronta è disabilitata per questo sito. Non c\'è niente da vedere qui.';
$string['imprintheading'] = 'Impronta';
$string['imprintlinkpositionboth'] = 'Aggiungi un link alla pagina "Informatione legale" nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['imprintlinkpositionfooter'] = 'Aggiungi un link alla pagina "Informazione legale" nell\'icona del piè di pagina (punto interrogativo)';
$string['imprintlinkpositionfootnote'] = 'Aggiungi un link alla pagina "Informazione legale" nella nota a piè di pagina';
$string['imprintlinkpositionnone'] = 'Non mostrare automaticamente un link alla pagina "Informazione legale"';
$string['imprintlinkpositionsetting'] = 'Posizione link "Informazione legale"';
$string['imprintlinkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina "Informazione legale" deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['imprintpagetitledefault'] = 'Impronta';
$string['imprintpagetitlesetting'] = 'Titolo della pagina "Informazione legale"';
$string['imprintpagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina "Informazione legale". Questo testo verrà utilizzato anche come testo del link alla pagina "Informazione legale", se si configura di conseguenza la voce \'Posizione del link "Informazione legale"\'.';
$string['infobannerbsclasssetting'] = 'Classe Bootstrap del banner informativo {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Con questa impostazione, è possibile selezionare lo stile Bootstrap con cui visualizzare il banner informativo {$a->no}. Se si sceglie l\'opzione "Nessun colore Bootstrap", il banner informativo sarà visualizzato senza alcun colore Bootstrap particolare, lasciando la libertà di creare il banner nell\'editor di testo.';
$string['infobannerclose'] = 'Chiudere';
$string['infobannercontentsetting'] = 'Contenuto del banner informativo {$a->no}';
$string['infobannercontentsetting_desc'] = 'Qui si inseriscono le informazioni che devono essere mostrate nel banner informativo {$a->no}.';
$string['infobannerdismissconfirm'] = 'È sicuro di volere ripristinare la visibilità del banner informativo {$a->no} e mostrarlo nuovamente a tutti gli utenti che lo hanno eliminato?';
$string['infobannerdismissfail'] = 'Il ripristinamento della visibilità del banner informativo {$a->no} è fallito per almeno un utente';
$string['infobannerdismissiblesetting'] = 'Banner informativo {$a->no} dismissibile';
$string['infobannerdismissiblesetting_desc'] = 'Con questa impostazione, è possibile rendere dismissibile il banner informativo {$a->no}. Se l\'utente fa clic sul pulsante x nel banner informativo, il banner sarà nascosto per questo utente in modo permanente. La visibilità non viene comunque ripristinata automaticamente, anche se si modifica il contenuto del banner informativo. Se si desidera ripristinare la visibilità del banner informativo, fare clic sul pulsante \'Ripristinare la visibilità\' in basso.';
$string['infobannerdismissreset'] = 'Ripristinare la visibilità del banner informativo dismesso';
$string['infobannerdismissresetbutton'] = 'Ripristinare la visibilità del banner informativo {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilità del banner informativo {$a->no} è stata ripristinata';
$string['infobannerenabledsetting'] = 'Abilitare il banner informativo {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Con questa impostazione, è possibile di abilitare il banner informativo {$a->no}.';
$string['infobannerendsetting'] = 'Info banner {$a->no} orario di fine';
$string['infobannerendsetting_desc'] = 'Con questa impostazione, è possibile definire fino a quando il banner informativo {$a->no} deve essere visualizzato. L\'ora configurata viene interpretata come ora del server, non come ora dell\'utente.';
$string['infobannerheading'] = 'Banner informativo {$a->no}';
$string['infobannermodeperpetual'] = 'Perpetuo';
$string['infobannermodesetting'] = 'Modalità di visualizzazione del banner informativo {$a->no}';
$string['infobannermodesetting_desc'] = 'Con questa impostazione, è possibile definire se il banner informativo {$a->no} debba essere un banner perpetuo (che viene mostrato sempre) o un banner a tempo (che viene mostrato solo nell\'intervallo di tempo configurato).';
$string['infobannermodetimebased'] = 'A tempo';
$string['infobannerordersetting'] = 'Info banner {$a->no} posizione dell\'ordine';
$string['infobannerordersetting_desc'] = 'Con questa impostazione si definisce la posizione del banner informativo {$a->no}. Per impostazione predefinita, i banner informativi sono ordinati dall\'alto verso il basso, come si vede in questa pagina di impostazioni. Tuttavia, si può decidere di assegnare un\'altra posizione d\'ordine con questa impostazione. Se si assegna la stessa posizione d\'ordine a due o più banner informativi, questi saranno ordinati di nuovo secondo l\'ordine di questa pagina di impostazioni.';
$string['infobannerpageloginpage'] = 'Pagina di login';
$string['infobannerpagessetting'] = 'Layout di pagina su cui visualizzare il banner informativo {$a->no}';
$string['infobannerpagessetting_desc'] = 'Con questa impostazione, è possibile selezionare i layout di pagina su cui visualizzare il banner informativo {$a->no}.';
$string['infobannerstartsetting'] = 'Info banner {$a->no} orario di inizio';
$string['infobannerstartsetting_desc'] = 'Con questa impostazione, è possibile definire da quando il banner informativo {$a->no} deve essere visualizzato. L\'ora configurata viene interpretata come ora del server, non come ora dell\'utente.';
$string['infobannertab'] = 'Banner informativo';
$string['javascriptdisabledhint'] = 'Suggerimenti JavaScript disabilitato';
$string['javascriptdisabledhint_desc'] = 'Con questa impostazione, nella parte superiore della pagina di Moodle appare un suggerimento se JavaScript non è abilitato. Questo è particolarmente utile perché diverse funzioni di Moodle non funzionano senza JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript è disabilitato nel vostro browser.<br />Molte funzioni di Moodle non saranno utilizzabili o appariranno interrotte.<br />Si prega di abilitare JavaScript per un\'esperienza completa di Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Link';
$string['loginbackgroundimage'] = 'Immagini di sfondo pagina di login';
$string['loginbackgroundimage_desc'] = 'Le immagini da visualizzare come sfondo della pagina di login. Una di queste immagini sarà scelta a caso e mostrata quando l\'utente visita la pagina di login. Assicurarsi di non utilizzare caratteri non ASCII nel nome del file se si desidera visualizzare il testo per le immagini di sfondo del login.';
$string['loginbackgroundimagepositionsetting'] = 'Posizione dell\'immagine di sfondo della pagina di login';
$string['loginbackgroundimagepositionsetting_desc'] = 'Con questa impostazione si controlla il posizionamento dell\'immagine di sfondo della pagina di login all\'interno della finestra del browser. Il primo valore è la posizione orizzontale, il secondo la posizione verticale.';
$string['loginbackgroundimagesheading'] = 'Immagini di sfondo pagina di login';
$string['loginbackgroundimagetextsetting'] = 'Testo visualizzato per le immagini di sfondo pagina login';
$string['loginbackgroundimagetextsetting_desc'] = 'Con questa impostazione opzionale è possibile aggiungere un testo, ad esempio una nota di copyright, alle immagini di sfondo caricate. Questo testo apparirà sopra al piè di pagina nella pagina di login. Tuttavia, per motivi di spazio sullo schermo, viene visualizzato solo su schermi di grandi dimensioni.<br/>
Ogni riga è composta dall\'identificatore del file (il nome del file), dal testo che deve essere visualizzato e dal colore del testo, separati da un carattere pipe. Ogni dichiarazione deve essere scritta in una nuova riga.<br/>
Ad esempio:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Come colore del testo, si possono usare i valori "dark" o "light".<br />
È possibile dichiarare i testi per un numero arbitrario di immagini di sfondo di login caricate. I testi saranno aggiunti solo alle immagini il cui nome di file corrisponde all\'identificatore dichiarato in questa impostazione.';
$string['loginformheading'] = 'Maschera di autenticazione';
$string['loginformpositionsetting'] = 'Posizione maschera di autenticazione';
$string['loginformpositionsetting_center'] = 'Centrato';
$string['loginformpositionsetting_desc'] = 'Con questa impostazione, è possibile ottimizzare la maschera di autenticazione per adattarla a una maggiore varietà di immagini di sfondo. Per impostazione predefinita, la maschera di autenticazione viene visualizzata al centro della pagina di login. In alternativa, è possibile spostarla a sinistra o a destra della pagina di login per far risaltare altre parti dell\'immagine di sfondo. Naturalmente, è possibile modificare questa impostazione anche se non sono state caricate immagini di sfondo.';
$string['loginformpositionsetting_left'] = 'Allineato a sinistra';
$string['loginformpositionsetting_right'] = 'Allineato a destra';
$string['loginformtransparencysetting'] = 'Trasparenza maschera di autenticazione';
$string['loginformtransparencysetting_desc'] = '';
$string['loginpagetab'] = 'Pagina di login';
$string['logocompactsetting'] = 'Logo compatto';
$string['logocompactsetting_desc'] = 'Qui è possibile caricare una versione compatta dello stesso logo di cui sopra, come un emblema, uno scudo o un\'icona. Questa immagine viene utilizzata soprattutto nella barra di navigazione in cima a ogni pagina di Moodle. L\'immagine deve essere chiara anche a piccole dimensioni.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Qui è possibile caricare un logo completo da utilizzare come decorazione. Questa immagine viene utilizzata soprattutto nella pagina di login. L\'immagine può essere ad alta risoluzione, perché verrà ridimensionata per l\'uso.';
$string['logosheading'] = 'Loghi';
$string['logosheading_desc'] = 'Nota bene: Boost Union ha un proprio logo da caricare e non utilizza il logo di <a href="{$a}">Impostazione logo di Moodle core</a>.<br />Boost Union permette di caricare più formati di immagine rispetto a quelli consentiti da Moodle Core e permette di sovrascrivere i loghi caricati all\'interno dei suoi flavour.';
$string['maintenancecontentsetting'] = 'Contenuto pagina "Informazioni sulla manutenzione"';
$string['maintenancecontentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina "Informazioni sulla manutenzione".';
$string['maintenancedisabled'] = 'La pagina "Informazioni sulla manutenzione" è disattivata per questo sito. Non c\'è nulla da vedere qui.';
$string['maintenanceheading'] = 'Manutenzione';
$string['maintenancelinkpositionboth'] = 'Aggiungi un link alla pagina "Informazioni sulla manutenzione" nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['maintenancelinkpositionfooter'] = 'Aggiungi un link alla pagina "Informazioni sulla manutenzione" nell\'icona del piè di pagina (punto interrogativo)';
$string['maintenancelinkpositionfootnote'] = 'Aggiungi un link alla pagina "Informazioni sulla manutenzione" nella nota a piè di pagina';
$string['maintenancelinkpositionnone'] = 'Non mostrare automaticamente un link alla pagina "Informazioni sulla manutenzione"';
$string['maintenancelinkpositionsetting'] = 'Posizione link "Informazioni sulla manutenzione"';
$string['maintenancelinkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina "Informazioni sulla manutenzione" deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['maintenancepagetitledefault'] = 'Manutenzione';
$string['maintenancepagetitlesetting'] = 'Titolo della pagina "Informazioni sulla manutenzione"';
$string['maintenancepagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina "Informazioni sulla manutenzione". Questo testo verrà utilizzato anche come testo del link alla pagina "Informazioni sulla manutenzione", se si configura di conseguenza la voce \'Posizione del link "Informazioni sulla manutenzione"\'.';
$string['markexternallinkssetting'] = 'Contrassegnare i link esterni';
$string['markexternallinkssetting_desc'] = 'Aggiunge un\'icona "link esterno" dopo i link esterni (che portano l\'utente a una destinazione esterna a Moodle).';
$string['mediumcontentmaxwidthsetting'] = 'Larghezza massima contenuto medio';
$string['mediumcontentmaxwidthsetting_desc'] = 'Con questa impostazione, è possibile sovrascrivere la larghezza del contenuto medio di Moodle senza modifiche manuali di SCSS. Questa larghezza di pagina viene utilizzata in alcune attività come quella del database. Per impostazione predefinita, Moodle utilizza una larghezza massima del contenuto medio di 1120px. È possibile inserire altri valori in pixel, come 1200px, ma anche un valore in percentuale, come 100%, o un valore di larghezza di visualizzazione, come 90vw.';
$string['misctab'] = 'Varie';
$string['mobileappearanceheading'] = 'Aspetto mobile';
$string['mobilecss'] = 'CSS aggiuntivo per l\'app mobile';
$string['mobilecss_desc'] = 'Con questa impostazione puoi scrivere codice CSS personalizzato per personalizzare l\'interfaccia della tua app mobile. Il codice CSS verrà aggiunto solo alla rappresentazione dell\'app mobile di questa istanza di Moodle e non verrà mostrato nella versione del browser web. Maggiori informazioni su questa funzionalità nei <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">documenti di sviluppo di Moodle</a>.';
$string['mobilecss_donotchange'] = 'Questo passaggio è necessario per inviare il codice CSS all\'app mobile. Non modificare l\'URL lì a meno che tu non voglia davvero rimuovere nuovamente il codice CSS dall\'app mobile.';
$string['mobilecss_overwrite'] = 'Non appena si aggiunge del codice CSS a questa impostazione e si salva l\'impostazione, l\'<a href="{$a->url}">impostazione di Moodle Core <em>mobilecssurl</em></a> sarà automaticamente impostata su un URL del tema Boost Union. Attualmente questa impostazione è impostata su <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Non appena si aggiunge del codice CSS a questa impostazione e si salva l\'impostazione, l\'<a href="{$a->url}">impostazione di Moodle Core <em>mobilecssurl</em></a> sarà automaticamente impostata su un URL del tema Boost Union.';
$string['mobiletab'] = 'Mobile app';
$string['modiconactivity'] = 'Attività';
$string['modiconactivityunknown'] = 'Sconosciuto';
$string['modicongtmoodle4'] = 'Icona Moodle 4';
$string['modiconlistsetting'] = 'Elenco dei file delle icone personalizzate';
$string['modiconlistsetting_desc'] = 'Questo è l\'elenco dei file di icone personalizzate che ha caricato nell\'area file di icone personalizzate qui sopra. Tutti i file di icone validi sono elencati qui. Inoltre, altri file caricati, ma non validi, sono mostrati come file non validi.';
$string['modiconltmoodle311'] = 'Icona legacy Moodle 3';
$string['modiconnamefail'] = 'Questo file è stato caricato nella cartella corretta per l\'attività <em>{$a}</em>, ma il nome del file non è valido. Modifica il nome del file in <em>monologo.svg</em> / <em>monologo.png</em> (per le icone Moodle 4) o in <em>icon.svg</em> / <em>icon .png</em> (per le icone legacy Moodle 3).';
$string['modiconnotexist'] = 'Questo file è stato caricato in una posizione non idonea, poiché è impossibile dedurre una particolare attività dal percorso del file <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Abilita icone personalizzate per attività e risorse';
$string['modiconsenablesetting_desc'] = 'Con questa impostazione è possibile modificare le icone delle attività e delle risorse utilizzate da Moodle nelle pagine del corso e nel selezionatore di attività.';
$string['modiconserrorcreatingpath'] = 'Non è stato possibile creare la cartella pix_plugins/mod nella directory Moodledata.<br />Il messaggio di eccezione era:{$a}.';
$string['modiconsfiles'] = 'File delle icone personalizzate';
$string['modiconsfiles_desc'] = 'Qui puoi caricare icone personalizzate per tutti o solo alcuni moduli di attività installati in questa istanza di Moodle.';
$string['modiconsfileshowto'] = 'Per caricare l\'icona di una particolare attività personalizzata, si inizia creando una cartella con il nome interno dell\'attività, ad esempio <em>assign</em> per l\'attività compito. In questa cartella, si carica l\'icona come file SVG chiamato monologo.svg e, se possibile, come file PNG di riserva chiamato monologo.png. Se si desidera personalizzare le icone colorate che sono state utilizzate fino a Moodle 3 e che potrebbero essere ancora utilizzate dai vecchi plugin, è possibile caricarle anche come file icon.svg e icon.png. Tuttavia, per ottenere risultati migliori, si consiglia di attenersi a icone SVG monocromatiche. Quindi, salvare la pagina delle impostazioni. Una volta salvate le impostazioni con almeno un file, apparirà un elenco di file che vi aiuterà a verificare se le icone personalizzate sono state caricate correttamente.';
$string['modiconsfilestech'] = 'Nota tecnica: dopo aver salvato l\'impostazione, la struttura della cartella caricata e i file delle icone saranno copiati nella cartella pix_plugins/mod della cartella Moodledata. È qui che il Moodle Core cerca le icone delle attività personalizzate. Tutti i file di icone eventualmente già presenti in questa cartella saranno sovrascritti quando si salva questa impostazione.';
$string['modiconsheading'] = 'Icone delle attività';
$string['modiconsuccess3x'] = 'Questa icona verrà utilizzata per l\'attività <em>{$a}</em> come icona legacy Moodle 3.';
$string['modiconsuccess4x'] = 'Questa icona verrà utilizzata per l\'attività <em>{$a}</em> come icona Moodle 4.';
$string['modiconversion'] = 'Versione icona';
$string['navbarcolorsetting'] = 'Colore barra di navigazione';
$string['navbarcolorsetting_dark'] = 'Barra di navigazione scura con colore del carattere chiaro';
$string['navbarcolorsetting_desc'] = 'Con questa impostazione, puoi cambiare il colore della barra di navigazione dalla barra di navigazione chiara predefinita a quella scura o colorata.';
$string['navbarcolorsetting_light'] = 'Barra di navigazione chiara con colore del carattere scuro (invariato come presentato da Moodle Core)';
$string['navbarcolorsetting_primarydark'] = 'Barra di navigazione nel colore primario con colore del carattere chiaro';
$string['navbarcolorsetting_primarylight'] = 'Barra di navigazione nel colore primario con colore del carattere scuro';
$string['navbarheading'] = 'Barra di navigazione';
$string['navigationheading'] = 'Navigazione';
$string['navigationtab'] = 'Navigazione';
$string['offerscontentsetting'] = 'Contenuto pagina "Offerte"';
$string['offerscontentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina "Offerte".';
$string['offersdisabled'] = 'La pagina "Offerte" è disattivata per questo sito. Non c\'è nulla da vedere qui.';
$string['offersheading'] = 'Offerte';
$string['offerslinkpositionboth'] = 'Aggiungi un link alla pagina "Offerte" nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['offerslinkpositionfooter'] = 'Aggiungi un link alla pagina "Offerte" nell\'icona del piè di pagina (punto interrogativo)';
$string['offerslinkpositionfootnote'] = 'Aggiungi un link alla pagina "Offerte" nella nota a piè di pagina';
$string['offerslinkpositionnone'] = 'Non mostrare automaticamente un link alla pagina "Offerte"';
$string['offerslinkpositionsetting'] = 'Posizione link "Offerte"';
$string['offerslinkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina "Offerte" deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['offerspagetitledefault'] = 'Offerte';
$string['offerspagetitlesetting'] = 'Titolo della pagina "Offerte"';
$string['offerspagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina "Offerte". Questo testo verrà utilizzato anche come testo del link alla pagina "Offerte", se si configura di conseguenza la voce \'Posizione del link "Offerte"\'.';
$string['openoffcanvas'] = 'Apri il cassetto Off-canvas';
$string['outsideregionsheading'] = 'Regioni Outside';
$string['outsideregionsheading_desc'] = 'Le regioni Outside non solo possono essere abilitate con le impostazioni di layout di cui sopra, ma è anche possibile personalizzare il loro aspetto.';
$string['outsideregionsplacement'] = 'Posizionamento orizzontale delle regioni Outside';
$string['outsideregionsplacement_desc'] = 'Con questa impostazione puoi controllare se, su schermi più grandi, le regioni di blocchi "Outside (a sinistra)" e "Outside (a destra)" devono essere posizionate vicino all\'area del contenuto principale o piuttosto vicino ai bordi della finestra.';
$string['outsideregionsplacementnearwindowedges'] = 'Mostra le regioni "Outside (a sinistra)" e "Outside (a destra)" vicino ai bordi della finestra';
$string['outsideregionsplacementnextmaincontent'] = 'Mostra le regioni "Outside (a sinistra)" e "Outside (a destra)" accanto all\'area del contenuto principale';
$string['outsideregionswidthcoursecontentwidth'] = 'Larghezza contenuto del corso';
$string['outsideregionswidthfullwidth'] = 'Larghezza intera';
$string['outsideregionswidthherowidth'] = 'Larghezza hero';
$string['page1contentsetting'] = 'Contenuto pagina generica 1';
$string['page1contentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina generica 1.';
$string['page1disabled'] = 'La pagina 1 generica è disabilitata per questo sito. Non c\'è nulla da vedere qui.';
$string['page1heading'] = 'Pagina generica 1';
$string['page1linkpositionboth'] = 'Aggiungi un link alla pagina generica 1 nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['page1linkpositionfooter'] = 'Aggiungi un link alla pagina generica 1 nell\'icona del piè di pagina (punto interrogativo)';
$string['page1linkpositionfootnote'] = 'Aggiungi un link alla pagina generica 1 nella nota a piè di pagina';
$string['page1linkpositionnone'] = 'Non mostrare automaticamente un link alla pagina generica 1';
$string['page1linkpositionsetting'] = 'Posizione link Pagina generica 1';
$string['page1linkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina generica 1 deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['page1pagetitledefault'] = 'Pagina generica 1';
$string['page1pagetitlesetting'] = 'Titolo della pagina generica 1';
$string['page1pagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina generica 1. Questo testo verrà utilizzato anche come testo del link alla pagina generica 1, se si configura di conseguenza la voce \'Posizione del link pagina generica 1\'.';
$string['page2contentsetting'] = 'Contenuto pagina generica 2';
$string['page2contentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina generica 2.';
$string['page2disabled'] = 'La pagina 2 generica è disabilitata per questo sito. Non c\'è nulla da vedere qui.';
$string['page2heading'] = 'Pagina generica 2';
$string['page2linkpositionboth'] = 'Aggiungi un link alla pagina generica 2 nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['page2linkpositionfooter'] = 'Aggiungi un link alla pagina generica 2 nell\'icona del piè di pagina (punto interrogativo)';
$string['page2linkpositionfootnote'] = 'Aggiungi un link alla pagina generica 2 nella nota a piè di pagina';
$string['page2linkpositionnone'] = 'Non mostrare automaticamente un link alla pagina generica 2';
$string['page2linkpositionsetting'] = 'Posizione link Pagina generica 2';
$string['page2linkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina generica 2 deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['page2pagetitledefault'] = 'Pagina generica 2';
$string['page2pagetitlesetting'] = 'Titolo della pagina generica 2';
$string['page2pagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina generica 2. Questo testo verrà utilizzato anche come testo del link alla pagina generica 2, se si configura di conseguenza la voce \'Posizione del link pagina generica 2\'.';
$string['page3contentsetting'] = 'Contenuto pagina generica 3';
$string['page3contentsetting_desc'] = 'In questa impostazione, è possibile aggiungere contenuto in formato rich text che verrà mostrato nella pagina generica 3.';
$string['page3disabled'] = 'La pagina 3 generica è disabilitata per questo sito. Non c\'è nulla da vedere qui.';
$string['page3heading'] = 'Pagina generica 3';
$string['page3linkpositionboth'] = 'Aggiungi un link alla pagina generica 3 nella nota a piè di pagina e nell\'icona del piè di pagina (punto interrogativo)';
$string['page3linkpositionfooter'] = 'Aggiungi un link alla pagina generica 3 nell\'icona del piè di pagina (punto interrogativo)';
$string['page3linkpositionfootnote'] = 'Aggiungi un link alla pagina generica 3 nella nota a piè di pagina';
$string['page3linkpositionnone'] = 'Non mostrare automaticamente un link alla pagina generica 3';
$string['page3linkpositionsetting'] = 'Posizione link Pagina generica 3';
$string['page3linkpositionsetting_desc'] = 'Con questa impostazione, è possibile configurare se un link alla pagina generica 3 deve essere aggiunto automaticamente alla pagina Moodle. Se non si vuole mostrare un link automaticamente, si può aggiungere manualmente un link a {$a->url} da qualsiasi punto di Moodle.';
$string['page3pagetitledefault'] = 'Pagina generica 3';
$string['page3pagetitlesetting'] = 'Titolo della pagina generica 3';
$string['page3pagetitlesetting_desc'] = 'Con questa impostazione, è possibile definire il titolo della pagina generica 3. Questo testo verrà utilizzato anche come testo del link alla pagina generica 3, se si configura di conseguenza la voce \'Posizione del link pagina generica 3\'.';
$string['pagetab'] = 'Pagina';
$string['pagewidthheading'] = 'Larghezza della pagina';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Preimpostazioni del tema';
$string['primarynavigationheading'] = 'Navigazione principale';
$string['privacy:metadata'] = 'Il tema Boost Union non memorizza alcun dato personale di alcun utente.';
$string['region-content-lower'] = 'Content (in basso)';
$string['region-content-upper'] = 'Content (in alto)';
$string['region-footer-center'] = 'Footer (center)';
$string['region-footer-left'] = 'Footer (a sinistra)';
$string['region-footer-right'] = 'Footer (a destra)';
$string['region-header'] = 'Header';
$string['region-none'] = 'Nessuna';
$string['region-offcanvas-center'] = 'Off-canvas (center)';
$string['region-offcanvas-left'] = 'Off-canvas (a sinistra)';
$string['region-offcanvas-right'] = 'Off-canvas (a destra)';
$string['region-outside-bottom'] = 'Outside (in basso)';
$string['region-outside-left'] = 'Outside (a sinistra)';
$string['region-outside-right'] = 'Outside (a destra)';
$string['region-outside-top'] = 'Outside (in alto)';
$string['resourcescachecontrolnote'] = 'Si noti che i file vengono inviati al browser con l\'intestazione "Cache-Control", che indica al browser di memorizzare il file nella cache. Se si è certi di non modificare il file nel prossimo futuro, si può usare l\'URL persistente per collegarsi al file. Tuttavia, se si prevede di modificare un file ma di mantenere lo stesso nome ogni tanto, si dovrebbe piuttosto utilizzare l\'URL revisionato e ricollegare il file dove è stato utilizzato ogni volta che si aggiorna il file, per evitare che i browser mostrino versioni obsolete del file prese della cache.';
$string['resourcestab'] = 'Risorse';
$string['scrollspysetting'] = 'Scroll-spy';
$string['scrollspysetting_desc'] = 'Con questa impostazione, quando si attiva e disattiva la modalità modifica, viene mantenuta la posizione di scorrimento in cui l\'utente si trovava al momento dell\'attivazione.';
$string['scssheading'] = 'SCSS grezzo';
$string['scsstab'] = 'SCSS';
$string['showhintcourseguestaccessgeneral'] = 'Sta visualizzando questo corso come <strong>{$a->role}</strong>';
$string['showhintcourseguestaccesslink'] = 'Per avere accesso completo al corso, è possibile <a href="{$a->url}">iscriversi a questo corso</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Con questa impostazione nell\'intestazione del corso apparirà un suggerimento quando un utente vi accede con la funzione di accesso ospite. Se il corso prevede un\'iscrizione spontanea, viene presentato all\'utente anche un link a quella pagina.';
$string['showhintcoursehiddengeneral'] = 'Questo corso è attualmente <strong>nascosto</strong>. Solo gli insegnanti iscritti possono accedere a questo corso quando è nascosto.';
$string['showhintcoursehiddensetting'] = 'Visualizza suggerimento nei corsi nascosti';
$string['showhintcoursehiddensetting_desc'] = 'Con questa impostazione nell\'intestazione del corso apparirà un suggerimento quando la visibilità del corso è nascosta. Questo aiuta a identificare lo stato di visibilità di un corso a colpo d\'occhio, senza dover guardare le impostazioni del corso.';
$string['showhintcoursehiddensettingslink'] = 'È possibile modificare la visibilità nelle <a href="{$a->url}">impostazioni del corso</a>.';
$string['showhintcourseselfenrolfrom'] = 'L\'istanza di iscrizione <strong>{$a->name}</strong> consente l\'iscrizione spontanea senza limitazioni dal {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'L\'istanza di iscrizione <strong>{$a->name}</strong> consente l\'iscrizione spontanea senza limitazioni dal {$a->from} fino al {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Se non si vuole che nessun utente di Moodle possa accedere liberamente a questo corso, si prega di limitare le impostazioni dell\'iscrizione spontanea.';
$string['showhintcourseselfenrolsetting'] = 'Visualizza suggerimento per l\'iscrizione spontanea senza chiave di iscrizione';
$string['showhintcourseselfenrolsetting_desc'] = 'Con questa impostazione, nell\'intestazione del corso apparirà un suggerimento se il corso è visibile e se è possibile un\'iscrizione senza chiave di iscrizione.';
$string['showhintcourseselfenrolsince'] = 'L\'istanza di iscrizione <strong>{$a->name}</strong> consente attualmente l\'iscrizione spontanea senza limitazioni.';
$string['showhintcourseselfenrolsinceuntil'] = 'L\'istanza di iscrizione <strong>{$a->name}</strong> consente attualmente l\'iscrizione spontanea senza limitazioni fino al {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Questo corso è attualmente visibile a tutti e l\'<strong>iscrizione spontanea</strong> è possibile.';
$string['showhintcourseselfenrolstartfuture'] = 'Questo corso è attualmente visibile a tutti e prevede di rendere possibile l\'<strong>iscrizione spontanea</strong>.';
$string['showhintcourseselfenrolunlimited'] = 'L\'istanza di iscrizione <strong>{$a->name}</strong> consente l\'iscrizione spontanea senza limitazioni a tempo indeterminato.';
$string['showhintcourseselfenroluntil'] = 'L\'istanza di iscrizione <strong>{$a->name}</strong> consente l\'iscrizione spontanea senza limitazioni fino al {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Mostrare suggerimento per l\'accesso agli ospiti';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Mostrare il cassetto dei blocchi destro del home del sito al primo accesso';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = '';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Mostrare il cassetto dei blocchi destro del home del sito durante il login come ospite';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = '';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Mostrare il cassetto dei blocchi destro della casa del sito durante la visita';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = '';
$string['showswitchedroleincoursesetting'] = 'Mostrare suggerimento per ruolo cambiato';
$string['showswitchedroleincoursesetting_desc'] = 'Con questa impostazione, nell\'intestazione del corso apparirà un suggerimento se l\'utente ha cambiato ruolo nel corso. Per impostazione predefinita, questa informazione viene visualizzata solo vicino all\'avatar dell\'utente nel menu utente. Attivando questa opzione, è possibile mostrare questa informazione, insieme a un link per tornare indietro, anche all\'interno della pagina del corso.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Per impostazione predefinita, nella pagina <a href="{$a}">Gestisci i corsi</a>, Moodle richiede di aprire i dettagli del corso o di passare attraverso le impostazioni del corso prima di poter fare clic su un ulteriore elemento dell\'interfaccia utente per visualizzare il corso. Attivando questa impostazione, è possibile aggiungere un\'icona "Visualizza corso" direttamente all\'elenco delle categorie nella pagina \'Gestisci i corsi\'.';
$string['showviewcourseiconincoursemgntsetting'] = 'Mostrare l\'icona \'visualizza corso\'';
$string['sitebrandingtab'] = 'Branding del sito';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Cassetto dei blocchi destro del home del sito';
$string['smartmenusmenudescription'] = 'Descrizione';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Nuova scheda';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenulocation_help'] = '<p>Seleziona la/e posizione/i in cui desideri che il menu appaia sulla pagina:</p><ul><li>La navigazione principale è nella parte superiore della pagina dove Moodle Core mostra già gli elementi di navigazione Home, Dashboard, I miei corsi e Amministrazione del sito.</li><li>La barra dei menu si trova sopra la navigazione principale, nella parte superiore della pagina.</li><li>È possibile accedere al menu utente facendo clic sull\'icona utente avatar nella barra di navigazione.</li><li>La barra inferiore è posizionata nella parte inferiore dello schermo e può essere utilizzata per implementare una navigazione con il pollice per un facile accesso ad aree importanti, come la dashboard, la pagina I miei corsi o la home page.</li></ul><p>Tieni presente che dopo aver abilitato la barra in basso, l\'icona dell\'hamburger verrà sostituita dal logo del tuo sito, perché gli utenti possono raggiungere la navigazione principale utilizzando la barra in basso.</li></ul></p>';
$string['smartmenusmenulocationmain'] = 'Navigazione principale';
$string['smartmenusmenushowdescription'] = 'Mostra descrizione';
$string['smartmenusmenutitle'] = 'Titolo';
$string['speciallinksmarkupheading'] = 'Markup dei link speciali';
$string['staticpagestab'] = 'Pagine statiche';
$string['switchedroleto'] = 'Sta visualizzando questo corso con il ruolo: <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Posizione dell\'immagine di sfondo riquadro pubblicitario {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Con questa impostazione, si controlla il posizionamento dell\'immagine di sfondo all\'interno del contenitore del riquadro pubblicitario {$a->no}. Il primo valore è la posizione orizzontale, il secondo la posizione verticale.';
$string['tilebackgroundimagesetting'] = 'Immagine di sfondo riquadro pubblicitario {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Consente di caricare un file immagine che verrà visualizzato come immagine di sfondo dietro il contenuto delriquadro pubblicitario {$a->no}. Assicurarsi o controllare che il contenuto sia ancora leggibile sull\'immagine di sfondo. Questa è un\'impostazione facoltativa, il riquadro pubblicitario funzionerà anche se non si carica alcuna immagine di sfondo.';
$string['tilecolumnssetting'] = 'Numero di colonne di riquadri pubblicitari per riga';
$string['tilecolumnssetting_desc'] = 'Qui si definisce il numero di colonne per riga nella griglia di riquadri pubblicitari presentate. Si noti che questo numero di colonne si applica agli schermi desktop / grandi. Su schermi più piccoli e su schermi mobili, le colonne degli riquadri pubblicitari vengono avvolte automaticamente.';
$string['tilecontentsetting'] = 'Contenuto riquadro pubblicitario {$a->no}';
$string['tilecontentsetting_desc'] = 'Qui si inserisce il contenuto che deve essere visualizzato nel riquadro pubblicitario {$a->no}. Il contenuto viene visualizzato al centro del riquadro. Si tratta di un\'impostazione facoltativa, il riquadro pubblicitario verrà visualizzato anche se non si imposta alcun contenuto.';
$string['tileenabledsetting'] = 'Abilitare riquadro pubblicitario {$a->no}';
$string['tileenabledsetting_desc'] = 'Con questa impostazione è possibile abilitare il riquadro pubblicitario {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posizione degli riquadri pubblicitari sulla home del sito';
$string['tilefrontpagepositionsetting_after'] = 'Dopo il contenuto della home del sito';
$string['tilefrontpagepositionsetting_before'] = 'Prima del contenuto della home del sito';
$string['tilefrontpagepositionsetting_desc'] = 'Riquadri pubblicitari vengono mostrate solamente sulla home del sito. Con questa impostazione, si controlla se gli riquadri pubblicitari vengono visualizzati prima del contenuto della home del sito o dopo il contenuto della home del sito. Se si desidera mostrare solo gli riquadri pubblicitari nella home del sito e nient\'altro, è possibile rimuovere tutti gli altri contenuti della home del sito modificando le <a href="{$a->url}">impostazioni della home del sito</a>.';
$string['tileheading'] = 'Riquadro pubblicitaro {$a->no}';
$string['tileheightsetting'] = 'Altezza riquadri pubblicitari';
$string['tileheightsetting_desc'] = 'Con questa impostazione si controlla l\'altezza degli riquadri pubblicitari. L\'altezza configurata è l\'altezza minima di ciascun riquadro. Se il contenuto di un riquadro è superiore all\'altezza configurata, l\'intera fila di riquadri sarà automaticamente resa più alta.';
$string['tilelinksetting'] = 'URL del link riquadro pubblicitario {$a->no}';
$string['tilelinksetting_desc'] = 'Qui è possibile impostare un URL (interno o esterno a Moodle) che sarà offerto come pulsante di collegamento alla fine del riquadro pubblicitario {$a->no}. Questa è un\'impostazione facoltativa, il riquadro pubblicitario funzionerà anche se non si imposta alcun URL di collegamento.';
$string['tilelinktargetsetting'] = 'Target del link riquadro pubblicitario {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Qui è possibile impostare la destinazione del link, che viene impostata per il pulsante di collegamento non appena si imposta un URL di collegamento nel riquadro pubblicitario {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nuovo tab';
$string['tilelinktargetsetting_samewindow'] = 'Stessa finestra';
$string['tilelinktitlefallback'] = 'Link';
$string['tilelinktitlesetting'] = 'Titolo link riquadro pubblicitario {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Qui è possibile impostare un titolo di collegamento che viene utilizzato come etichetta del pulsante di collegamento non appena si imposta un URL di collegamento nel riquadro pubblicitario {$a->no}. Si noti che se si imposta un URL di collegamento ma non un titolo, il pulsante del link sarà etichettato solo con \'Link\'.';
$string['tileordersetting'] = 'Ordine posizione riquadro pubblicitario {$a->no}';
$string['tileordersetting_desc'] = 'Con questa impostazione si definisce la posizione dell\'ordine del riquadro pubblicitario {$a->no}. Per impostazione predefinita, gli riquadri pubblicitari sono ordinati dall\'alto in basso e da sinistra a destra, come si vede in questa pagina di impostazioni. Tuttavia, si può decidere di assegnare un\'altra posizione d\'ordine con questa impostazione. Se si assegna la stessa posizione d\'ordine a due o più riquadri pubblicitari, questi verranno ordinati di nuovo secondo l\'ordine di questa pagina di impostazioni.';
$string['tilesgeneralheading'] = 'Riquadri pubblicitari generale';
$string['tilestab'] = 'Riquadri pubblicitari';
$string['tiletitlesetting'] = 'Titolo riquadro pubblicitario {$a->no}';
$string['tiletitlesetting_desc'] = 'È possibile inserisce il titolo da visualizzare nel riquadro pubblicitario {$a->no}. Si tratta di un\'impostazione facoltativa, il riquadro pubblicitario verrà visualizzato anche se non si imposta un titolo.';
$string['upgradenotice_2022080922'] = 'A partire da questa versione, Boost Union ha il proprio logo e le impostazioni del logo compatto e non utilizza più questi file dalle impostazioni di Moodle Core.';
$string['upgradenotice_2022080922_copied'] = 'L\'impostazione <strong>{$a}</strong> esistente nelle impostazioni di Moodle Core è stata copiata nell\'impostazione di Boost Union {$a} durante questo aggiornamento. Si prega di ricontrollare il risultato.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'compact logo';
$string['upgradenotice_2022080922_notcopied'] = 'The <strong>{$a}</strong> setting within Boost Union is empty now. If you want to use a {$a} within Boost Union from now on, just upload it into the Boost Union {$a} setting later.';
