<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'tr', version '4.3'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Hareketler';
$string['activityoresourceis'] = 'Etkinlik veya kaynak {$a}';
$string['addacondition'] = 'Koşul ekleyin';
$string['addarule'] = 'Bir kural ekleyin';
$string['addinstructions'] = 'Daha fazla bilgi ekleyin';
$string['additionalresources'] = 'Ek kaynaklar';
$string['addoninstallationerror'] = 'Eklenti (local_xp) ile ilgili bir sorun tespit ediyoruz, düzgün yüklenmemiş gibi görünüyor. Bir yönetici kurulumunu tamamlamalıdır.';
$string['addonnotactivated'] = 'Eklenti aktif değil.';
$string['addrulesformhelp'] = 'Son sütun, kriterler karşılandığında kazanılan deneyim puanlarının miktarını tanımlar.';
$string['admindefaultrulesintro'] = 'Aşağıdaki kurallar, bloğun eklendiği kurslar için varsayılan olarak kullanılacaktır.';
$string['admindefaultsettingsintro'] = 'Aşağıdaki ayarlar, blok bir kursa yeni eklendiğinde varsayılan olarak kullanılacaktır. Bazı ayarlar kilitlenebilir, bu durumda değerleri eklentinin tüm örneklerinde sıkı bir şekilde uygulanır.';
$string['admindefaultvisualsintro'] = 'Aşağıdakiler, blok bir derse yeni eklendiğinde varsayılan olarak kullanılacaktır.';
$string['anonymity'] = 'Anonimlik';
$string['anonymity_help'] = 'Bu ayar, katılımcıların birbirlerinin adını ve avatarını görüp göremeyeceğini kontrol eder.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> puan şu durumlarda kazanılır:';
$string['basexp'] = 'Algoritma tabanı';
$string['blockappearance'] = 'Blok görünümü';
$string['blockappearancemovedtopluginsettings'] = 'Blok görünümü ayarları, eklentinin ayarlar sayfasına taşındı.';
$string['cachedef_filters'] = 'Seviye filtreleri';
$string['cachedef_ruleevent_eventslist'] = 'Bazı olayların listesi';
$string['cannotshowblockconfig'] = 'Burada genellikle görünüm ayarlarını görüntülerdim, ancak bloğunuzu bulamadım. Bloğun görünümünü değiştirmek için [buraya]({$a}) (veya bloğu eklediğiniz yere) geri dönün, düzenleme modunu açın ve bloğun açılır menüsünde "Yapılandır" seçeneğini izleyin. Bloğu bulamazsanız kursunuza tekrar ekleyin.';
$string['cannotshowblockconfigsys'] = 'Burada genellikle görünüm ayarlarını görüntülerdim, ancak bloğunuzu bulamadım. Kullanıcılarınızın [ön sayfada]({$a->fp}) ve [varsayılan kontrol panelinde]({$a->mysys}) eksik olabilir veya her ikisinde birden bulunabilir. Ayarları buradan düzenlemek için, yalnızca birinde göründüğünden emin olun.';
$string['changelevelformhelp'] = 'Seviye sayısını değiştirirseniz, özel seviye rozetleri, rozetsiz seviyeleri önlemek için geçici olarak devre dışı bırakılacaktır. Seviye sayısını değiştirirseniz, bu formu kaydettikten sonra özel rozetleri yeniden etkinleştirmek için \'Görseller\' sayfasına gidin.';
$string['cheatguard'] = 'Hile koruması';
$string['clicktoselectcm'] = 'Bir aktivite veya kaynak seçmek için tıklayın';
$string['cmselector'] = 'Kurs modülü seçici';
$string['coefxp'] = 'Algoritma katsayısı';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configblockrankingsnapshot'] = 'Points gain disabled';
$string['configblockrankingsnapshot_help'] = 'Liderlik tablosu anlık görüntüsü kullanıcının sıralamasını gösterir. Ayrıca kullanıcının çevresindeki iki kişiyi de görüntülemeye çalışır. Bu özellik, liderlik tablosunun etkinleştirilmesini ve sıralamalarının görüntülenmesini gerektirir.';
$string['configdescription'] = 'Giriş';
$string['configdescription_help'] = 'Blokta, gösterilen kısa bir giriş. Öğrenciler mesajı reddedebilir ve bu durumda mesajı bir daha görmezler.';
$string['configheader'] = 'Ayarlar';
$string['configrecentactivity'] = 'Son ödülleri göster';
$string['configrecentactivity_help'] = 'Etkinleştirildiğinde, blok öğrenciyi puanlarla ödüllendiren son olayların kısa bir listesini gösterecektir.';
$string['configtitle'] = 'Başlık';
$string['configtitle_help'] = 'Bloğun başlığı.';
$string['congratulationsyouleveledup'] = 'Tebrikler!';
$string['coolthanks'] = 'Harika, teşekkürler!';
$string['courselog'] = 'Kurs günlüğü';
$string['coursereport'] = 'Kurs raporu';
$string['courserules'] = 'Kurs kuralları';
$string['courseselectedcolon'] = 'Kurs seçildi:';
$string['coursesettings'] = 'Kurs ayarları';
$string['coursevisuals'] = 'Kurs görselleri';
$string['customizelevels'] = 'Seviyeleri özelleştirin';
$string['dangerzone'] = 'Tehlikeli bölge';
$string['defaultlevels'] = 'Varsayılan seviyeler';
$string['defaultrules'] = 'Varsayılan kurallar';
$string['defaultrulesformhelp'] = 'Bunlar eklenti tarafından sağlanan varsayılan kurallardır, otomatik olarak varsayılan puanlar verir ve bazı gereksiz olayları göz ardı ederler. Kendi kurallarınız onlara göre önceliklidir.';
$string['defaultsettings'] = 'Varsayılan ayarları';
$string['defaultvisuals'] = 'Varsayılan görseller';
$string['deletecondition'] = 'Koşulu sil';
$string['deleterule'] = 'Kuralı sil';
$string['description'] = 'Açıklama';
$string['difference'] = 'Diff.';
$string['discoverlevelupplus'] = 'Level Up XP+\'ı Keşfedin';
$string['dismissnotice'] = 'Bildirimi kapat';
$string['displayeveryone'] = 'Herkesi göster';
$string['displaynneighbours'] = '{$a} komşularını görüntüle';
$string['displayoneneigbour'] = 'Bir komşuyu göster';
$string['displayparticipantsidentity'] = 'Katılımcı kimliğini göster';
$string['displayrank'] = 'Görüntü sıralaması';
$string['displayrelativerank'] = 'Göreceli bir sıra göster';
$string['documentation'] = 'Dokümantasyon';
$string['editinstructions'] = 'Bilgileri düzenleyin';
$string['enablecheatguard'] = 'Hile korumasını etkinleştir';
$string['enablecheatguard_help'] = 'Hile koruması, öğrencilerin aynı sayfayı hiç durmadan yenilemek veya aynı eylemi defalarca tekrarlamak gibi bariz teknikler kullanarak sistemi kötüye kullanmasını önlemek için basit ve ucuz bir mekanizma sunar.

[Daha fazla bilgi](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Bilgi sayfasını etkinleştir';
$string['enableinfos_help'] = '\'Hayır\' olarak ayarlandığında, öğrenciler bilgi sayfasını görüntüleyemez.';
$string['enableladder'] = 'Liderlik tablosunu etkinleştirin';
$string['enableladder_help'] = '\'Hayır\' olarak ayarlandığında, öğrenciler liderlik tablosunu görüntüleyemeyecektir.';
$string['enablelevelupnotif'] = 'Seviye atlama bildirimini etkinleştir';
$string['enablelevelupnotif_help'] = '\'Evet\' olarak ayarlandığında, öğrencilere ulaşılan yeni seviye için kendilerini tebrik eden bir açılır pencere görüntülenecektir.';
$string['enablelogging'] = 'Günlük kaydı etkinleştir';
$string['enablexpgain'] = 'Puan kazanmayı etkinleştirin';
$string['enablexpgain_help'] = '\'Hayır\' olarak ayarlandığında, hiç kimse kursta puan kazanmayacaktır. Bu, kazanılan puanları dondurmak veya belirli bir zamanda etkinleştirmek için kullanışlıdır.

Lütfen bunun _block / xp: winxp_ yeteneği kullanılarak daha ayrıntılı bir şekilde kontrol edilebileceğini unutmayın.';
$string['entersearchterm'] = 'Bir arama terimi girin';
$string['errorcontextcoursemismatchforwholesite'] = 'Bu <em>Seviye atlayın!</em> sayfasının URL\'si mevcut eklenti yapılandırmasıyla eşleşmiyor. Mevcut yapılandırmanız <em>Seviye atlayın!</em>\'ın \'Tüm site için\' kullanılacağını bildiriyor, ancak bu sayfa bunun \'Kurs başına\' kullanılmasını bekliyor. Doğru sayfaya gitmek için lütfen <a href="{$a->nexturl} ">burayı tıklayın</a>. Yapılandırmanızı değiştirmek istiyorsanız yönetici ayarını \'block_xp_context\' arayın.';
$string['errorcontextcoursemismatchpercourse'] = 'Bu <em>Seviye atlayın!</em> sayfasının URL\'si mevcut eklenti yapılandırmasıyla eşleşmiyor. Mevcut yapılandırmanız <em>Seviye atlayın!</em> \'Kurs başına\' kullanılacağını bildiriyor, ancak bu sayfa bunun \'Tüm site için\' kullanılmasını bekliyor. Büyük olasılıkla, farklı bir yapılandırmadayken kontrol paneline veya ön sayfaya eklenen bir <em>bloktan</em> kaynaklanmaktadır. Bloğu sonraki sayfalardan kaldırmalı ve bloğu yalnızca bireysel kursların içinden kullanmalısınız.';
$string['errorformvalues'] = 'Form değerlerinde bazı sorunlar var, lütfen bunları düzeltin.';
$string['errorlevelsincorrect'] = 'Minimum seviye sayısı 2\'dir';
$string['errornotalllevelsbadgesprovided'] = 'Tüm seviye rozetleri sağlanmadı. Eksik: {$a}';
$string['errorunknownevent'] = 'Hata: bilinmeyen olay';
$string['errorunknownmodule'] = 'Hata: bilinmeyen modül';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Gerekli puanlar, önceki seviyeye eşit veya daha düşüktür.';
$string['event_user_leveledup'] = 'Kullanıcı seviye atladı';
$string['eventis'] = 'Etkinlik {$a}';
$string['eventname'] = 'Etkinlik adı';
$string['eventproperty'] = 'Etkinlik özelliği';
$string['eventsrules'] = 'Etkinlik kuralları';
$string['eventsrules_help'] = 'Bu eklenti, öğrenciler tarafından gerçekleştirilen eylemlere puan atamak için olaylardan yararlanıyor.
Kendi kurallarınızı eklemek ve varsayılanları değiştirmek için aşağıdaki formu kullanabilirsiniz.

Öğrenciler kurstaki eylemleri gerçekleştirirken hangi olayların tetiklendiğini belirlemek için eklentinin _Log_ sayfasını kontrol etmeniz önerilir.

Ek kaynaklar:

- [Deneyim puanları nasıl hesaplanır?](https://docs.levelup.plus/xp/docs/getting-started/points-calculation?ref=blockxp_help)
- [Sorun giderme kuralları](https://docs.levelup.plus/xp/docs/troubleshooting/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Etkinlik zamanı';
$string['filterbyuser'] = 'Kullanıcıya göre filtrele';
$string['filtermodules'] = 'Filtre modülleri';
$string['for1day'] = '1 gün için';
$string['for1month'] = 'Bir ay için';
$string['for1week'] = 'Bir hafta için';
$string['for3days'] = '3 gün için';
$string['forever'] = 'Sonsuza dek';
$string['forthewholesite'] = 'Tüm site için';
$string['give'] = 'vermek';
$string['gotofullladder'] = 'Tam puan tablosuna git';
$string['grid'] = 'Izgara';
$string['hideparticipantsidentity'] = 'Katılımcı kimliğini gizle';
$string['hiderank'] = 'Rütbeyi gizle';
$string['ineffective'] = 'Etkisiz';
$string['infos'] = 'Bilgi';
$string['installed'] = 'Kurulmuş';
$string['instructions'] = 'Daha fazla bilgi';
$string['invalidxp'] = 'geçersiz puan değeri';
$string['keeplogs'] = 'Günlükleri tut';
$string['ladder'] = 'Liderler Sıralaması';
$string['ladderadditionalcols'] = 'Ek sütunlar';
$string['ladderadditionalcols_help'] = 'Bu ayar, skor tablosunda hangi ek sütunların görüntüleneceğini belirler.  Birden fazla sütun seçmek veya seçili bir sütunun seçimini kaldırmak için tıklarken CTRL veya CMD tuşuna basın.';
$string['ladderempty'] = 'Skor tablosu şu anda boş, daha sonra tekrar gelmeyi unutmayın!';
$string['learnmore'] = 'Daha fazla bilgi edin';
$string['level'] = 'Seviye';
$string['levelbadges'] = 'Seviye rozetleri';
$string['levelbadgesformhelp'] = 'Dosyaları [seviye].[dosya uzantısı] olarak adlandırın, örneğin: 1.png, 2.jpg, vb... Önerilen resim boyutu 100x100\'dür.';
$string['levelcount'] = 'Seviye sayısı';
$string['leveldesc'] = 'Seviye açıklaması';
$string['leveldesc_help'] = 'Seviyenin kısa bir açıklaması, bu bilgi sayfasında seviyenin yanında görüntülenir.  Bunu, seviyeye ulaşan öğrenciler için bir ödülü tanımlamak, bu seviyeye nasıl çalışılacağına ilişkin talimatları dahil etmek, seviyeyi eğlenceli bir şekilde tanımlamak için kullanabilirsiniz (örneğin, _Sadece en cesur ruhların bu seviyeye ulaştığı bilinmektedir_), vb. .';
$string['levelname'] = 'Seviye adı';
$string['levelname_help'] = 'Bazen görüntülenen varsayılan _Seviye #1_, _Düzey #2_ vb. yerine görüntülenecek kısa bir ad.  Bazı seviyelere isim verirseniz, hepsine isim vermenizi tavsiye ederiz!';
$string['levels'] = 'Seviyeler';
$string['levelswillbereset'] = 'Uyarı!  Bu formu kaydetmek, herkesin seviyelerini yeniden hesaplayacaktır!';
$string['levelup'] = 'Seviye atlama!';
$string['levelupplus'] = 'Seviye Atlama XP+';
$string['levelx'] = 'Seviye #{$a}';
$string['likenotice'] = '<strong>Eklentiyi beğendiniz mi?</strong> Lütfen bir dakikanızı ayırarak Moodle.org\'da <a href="{$a->moodleorg}" target="_blank">sık kullanılanlarınıza ekleyin</a> ve <a href="{$a->github}" target="_blank">GitHub\'da yıldız ekleyin</a>.';
$string['limitparticipants'] = 'Katılımcıları sınırla';
$string['limitparticipants_help'] = 'Bu ayar, skor tablosunda kimlerin görüntüleneceğini kontrol eder.  Komşular, mevcut kullanıcının üstünde ve altında sıralanan katılımcılardır.  Örneğin, \'2 komşuyu göster\' seçildiğinde, yalnızca mevcut kullanıcıdan doğrudan daha yüksek ve daha düşük olan iki katılımcı görüntülenecektir.';
$string['list'] = 'Liste';
$string['logging'] = 'Günlüğe kaydetme';
$string['manually'] = 'manuel olarak';
$string['maxactionspertime'] = 'Maks.  zaman çerçevesindeki eylemler';
$string['maxactionspertime_help'] = 'Verilen zaman dilimi içinde puan olarak sayılacak maksimum eylem sayısı.  Sonraki tüm işlemler göz ardı edilecektir.  Bu değer boş olduğunda veya sıfıra eşit olduğunda geçerli değildir.';
$string['maxlevelexcl'] = 'En üst seviye!';
$string['menu'] = 'Menü';
$string['missing'] = 'Eksik';
$string['movecondition'] = 'Taşıma koşulu';
$string['moverule'] = 'Kuralı taşı';
$string['name'] = 'İsim';
$string['navinfos'] = 'Bilgi';
$string['navladder'] = 'Lider Sıralaması';
$string['navlevels'] = 'Seviyeler';
$string['navlevelssetup'] = 'Kurulum';
$string['navlog'] = 'Kayıt';
$string['navpoints'] = 'Puanlar';
$string['navpromo'] = 'DP+';
$string['navreport'] = 'Bildiri';
$string['navrules'] = 'Tüzük';
$string['navsettings'] = 'Ayarlar';
$string['navvisuals'] = 'Görseller';
$string['nextlevelin'] = 'Sonraki seviye';
$string['nodescription'] = 'Açıklama yok';
$string['nologsrecordedyet'] = 'Günlükler henüz kaydedilmedi.';
$string['noname'] = 'İsimsiz';
$string['notesomesettingslocked'] = 'Bazı ayarların bir yönetici tarafından kilitlendiğinde düzenlenemeyeceğini unutmayın.';
$string['occasionally'] = 'Bazen';
$string['participant'] = 'Katılımcı';
$string['participants'] = 'Katılımcılar';
$string['participatetolevelup'] = 'Deneyim puanları kazanmak ve seviye atlamak için kursa katılın!';
$string['perpagecolon'] = 'Sayfa başına:';
$string['pickaconditiontype'] = 'Bir koşul türü seçin';
$string['pluginavailabilityxpdesc'] = 'Bu eklenti, eğitmenlerin etkinliklere erişimi öğrencilerin seviyelerine göre kısıtlamasına olanak tanır.';
$string['pluginenrolxpdesc'] = 'Bu eklenti, bir öğrencinin başka bir kurstaki seviyesine göre kurslara otomatik kayıt yapılmasını sağlar.';
$string['pluginname'] = 'Level Up XP';
$string['pluginshortcodesdesc'] = 'Bu eklenti, eğitmenlerin içeriğe XP ile ilgili öğeler (puan, seviye, liderlik tablosu, …) dahil ederek ve ayrıca bir öğrencinin seviyesine göre içeriği gizleyerek veya göstererek materyallerini özelleştirmelerine olanak tanır.';
$string['pluginsoutofsync'] = '__Eklentiler senkronize değil!__

Bu, _Seviye Atlama XP\'sini yükselttiğiniz, ancak _Seviye Atlama XP+_\'yi yükseltmediğiniz anlamına gelir.  Herhangi bir sorunu önlemek için elimizden gelenin en iyisini yapsak da, _Level Up XP_\'nin kendisi de dahil olmak üzere bazı özellikler artık düzgün çalışmayabilir.  _Level Up XP+_\'ı en son sürümüne yükseltmenizi öneririz.  [Daha fazlasını okuyun]({$a->url})';
$string['pointsintimelinker'] = 'her';
$string['pointsrequired'] = 'Gerekli puanlar';
$string['privacy:metadata:log'] = 'Bir olay günlüğünü saklar';
$string['privacy:metadata:log:eventname'] = 'Olay adı';
$string['privacy:metadata:log:time'] = 'Olduğu tarih';
$string['privacy:metadata:log:userid'] = 'Puan kazanan kullanıcı';
$string['privacy:metadata:log:xp'] = 'Etkinlik için verilen puanlar';
$string['privacy:metadata:prefintro'] = 'Kullanıcının bloğun girişini kapatıp kapatmadığını kaydeder';
$string['privacy:metadata:prefladderpagesize'] = 'Skor tablosunu görüntülerken kullanıcının tercih ettiği sayfa boyutu';
$string['privacy:metadata:preflevelup'] = 'Kullanıcının seviye atlama bildirimini görüp görmeyeceğini kaydeder';
$string['privacy:metadata:prefnotices'] = 'Kullanıcının destek bildirimini kapatıp kapatmadığını kaydeder';
$string['privacy:metadata:prefseenpromo'] = 'Kullanıcı tanıtım sayfasını görüntülediğinde kaydeder';
$string['privacy:metadata:xp'] = 'Kullanıcıların puanlarını ve seviyelerini saklar';
$string['privacy:metadata:xp:lvl'] = 'Kullanıcı seviyesi';
$string['privacy:metadata:xp:userid'] = 'Kullanıcı';
$string['privacy:metadata:xp:xp'] = 'kullanıcının puanları';
$string['privacy:path:addon'] = 'Ayriyeten';
$string['privacy:path:level'] = 'Seviye';
$string['privacy:path:logs'] = 'Kütükler';
$string['progress'] = 'İlerleme';
$string['progressbar'] = 'İlerleme çubuğu';
$string['promocheatguard'] = 'Bu hile koruması, uzun zaman dilimlerini kapsayacak şekilde tasarlanmamıştır.  Daha uzun zaman dilimlerinin ve diğer özelliklerin kilidini açmak için lütfen <em>Seviye Atlama XP+</em> sürümüne geçmeyi düşünün.  <a href="{$a->url}">Daha fazlasını buradan okuyun</a>.';
$string['promocontactintro'] = 'Daha fazla bilgi için bize ulaşın.  Isırmıyoruz ve hemen cevap veriyoruz!';
$string['promocontactus'] = 'İletişime geçin';
$string['promoemailusat'] = 'Bize _levelup@branchup.tech_ adresinden e-posta gönderin.';
$string['promoerrorsendingemail'] = 'Ah!  Mesajı gönderemedik... lütfen bize doğrudan şu adrese e-posta gönderin: {$a}.  Teşekkürler!';
$string['promoifpreferemailusat'] = 'Psst!  İsterseniz, bize doğrudan _{$a}_ adresinden e-posta gönderin.';
$string['promointro'] = 'Oyun ustası olun! Level Up XP+ ile ek özelliklerin kilidini açın ve oyunlaştırmayı yepyeni bir seviyeye taşıyın!';
$string['promointroinstalled'] = '_Level Up XP+_ eklentisi sisteminize yüklendi ve tüm özellikleri etkinleştirildi.';
$string['promorulesdidyouknow'] = '<em>Seviye Atlama XP+</em> ile öğrencilerin <em>kursları tamamlamak</em> ve <em>aktiviteler</em> için puan alabileceklerini ve hatta <em>notlarına göre puan alabileceklerini biliyor muydunuz? </em>?  <a href="{$a->url}">Burada daha fazlasını keşfedin</a>.';
$string['promoyourmessagewassent'] = 'Teşekkürler, mesajınız gönderildi.  Çok kısa süre içinde size geri döneceğiz.';
$string['property:action'] = 'Olay eylemi';
$string['property:component'] = 'Olay bileşeni';
$string['property:crud'] = 'Olay CRUD\'si';
$string['property:eventname'] = 'Etkinlik ismi';
$string['property:target'] = 'Etkinlik hedefi';
$string['rank'] = 'Rütbe';
$string['ranking'] = 'Sıralama';
$string['ranking_help'] = 'Rütbe, mevcut kullanıcının liderlik tablosundaki mutlak konumudur.  Göreceli sıralama, bir kullanıcı ile komşuları arasındaki deneyim puanlarındaki farktır.';
$string['reallydeleteuserstate'] = 'Bir kullanıcıyı silmek, yalnızca onu skor tablosundan çıkarmak için kullanışlıdır.  Diğer nedenlerle, puanlarını 0 olarak ayarlamanızı öneririz.  Bunları silmenin gelecekte puan kazanma yeteneklerini etkilemediğini unutmayın.

Daha da önemlisi, tüm site için _Seviye Atlama XP_ kullanırken, bunları silmek rapordan kaybolmalarına neden olur ve bu durumda onlara puanları yeniden atayamazsınız.  Ancak, kurs başına _Seviye Atlama XP_ kullanıyorsanız, öğrenci kursa kayıtlıysa raporda görünmeye devam edebilir.

Bu kullanıcının puanlarını gerçekten silmek istiyor musunuz?';
$string['reallydeleteuserstateandlogs'] = 'Bir kullanıcının silinmesi, onu skor tablosundan kaldırır ve ilişkili tüm günlüklerini kaldırır.

Günlüklerin kaldırılması, bir kullanıcının önceki işlemler için puanları yeniden kazanmasına olanak sağlayabilir.  Amacınız yalnızca puanlarını sıfırlamaksa, bunun yerine puanlarını 0 olarak ayarlamanızı öneririz.  Bir kullanıcıyı silmenin, gelecekte puan kazanma yeteneğini etkilemediğini unutmayın.

Daha da önemlisi, tüm site için _Seviye Atlama XP_ kullanırken, bunları silmek rapordan kaybolmalarına neden olur ve bu durumda onlara puanları yeniden atayamazsınız.  Ancak, kurs başına _Seviye Atlama XP_ kullanıyorsanız, öğrenci kursa kayıtlıysa raporda görünmeye devam edebilir.

Bu kullanıcının puanlarını ve günlüklerini gerçekten silmek istiyor musunuz?';
$string['reallyresetallcoursestodefaults'] = 'Tüm kurs kuralları gerçekten varsayılan kurallara sıfırlansın mı?  Bu eylem geri alınamaz.';
$string['reallyresetcourserulestodefaults'] = 'Kurs kuralları gerçekten varsayılan kurallara sıfırlansın mı?  Bu eylem geri alınamaz.';
$string['reallyresetdata'] = 'Bu kurstaki herkesin seviyelerini ve puanlarını gerçekten sıfırladınız mı?';
$string['reallyresetgroupdata'] = 'Bu gruptaki herkesin seviyelerini ve puanlarını gerçekten sıfırladınız mı?';
$string['reallyreverttopluginsdefaults'] = 'Varsayılan kurallar gerçekten eklenti tarafından önerilen varsayılanlara sıfırlansın mı?  Bu eylem geri alınamaz.';
$string['recentrewards'] = 'Son ödüller';
$string['recommendedplugins'] = 'Önerilen eklentiler';
$string['releasenotes'] = 'Sürüm notları';
$string['remaining'] = 'geriye kalan';
$string['removefilter'] = 'Filtreyi kaldır';
$string['reportisempty'] = 'Rapor boş, öğrenci henüz puan kazanmadı.';
$string['reportisemptyenrolstudents'] = 'Rapor boş, öğrenciler bu derse kaydoldu mu?';
$string['requires'] = 'Gereklilikler';
$string['resetallcoursestodefaults'] = 'Tüm kursları varsayılanlara sıfırla';
$string['resetallcoursestodefaultsintro'] = 'Tüm kursları yukarıdaki varsayılanlara sıfırlamak için aşağıdaki düğmeyi tıklayın.';
$string['resetcoursedata'] = 'Kurs verilerini sıfırla';
$string['resetcourserulestodefaults'] = 'Kurs kurallarını varsayılanlara sıfırla';
$string['resetgroupdata'] = 'Grup verilerini sıfırla';
$string['resultsfilteredforn'] = 'Sonuçlar {$a} için filtrelendi.';
$string['reverttopluginsdefaults'] = 'Eklentinin varsayılan ayarlarına geri dön';
$string['reverttopluginsdefaultsintro'] = 'Yukarıdaki varsayılanları eklentinin varsayılanlarına döndürmek istiyorsanız aşağıdaki düğmeyi kullanın.  Bu, mevcut derslerdeki kuralları etkilemez.';
$string['reward'] = 'Ödül';
$string['rule'] = 'Kural';
$string['rule:contains'] = 'içerir';
$string['rule:eq'] = 'eşittir';
$string['rule:eqs'] = 'kesinlikle eşittir';
$string['rule:gt'] = 'daha büyüktür';
$string['rule:gte'] = 'daha büyük veya eşittir';
$string['rule:lt'] = 'daha az';
$string['rule:lte'] = 'küçük veya eşittir';
$string['rule:regex'] = 'normal ifadeyle eşleşir';
$string['rulecm'] = 'Etkinlik veya kaynak';
$string['rulecm_help'] = 'Bu koşul, belirtilen etkinlikte veya kaynakta olay meydana geldiğinde karşılanır.';
$string['rulecmdesc'] = 'Etkinlik veya kaynak \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Etkinlik veya kaynak: \'{$a->coursename}\' içindeki \'{$a->contextname}\'.';
$string['rulecminfo'] = 'Bu koşul, eylemin belirli bir etkinlikte veya kaynakta gerçekleşmesini gerektirir.';
$string['ruleevent'] = 'Belirli olay';
$string['ruleeventdesc'] = 'Etkinlik \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Kullanıcıların küratörlüğünde bir etkinlik listesinden gerçekleştirmesi gereken eylemi seçin.';
$string['ruleproperty'] = 'Etkinlik özelliği';
$string['rulepropertydesc'] = '\'{$a->property}\' {$a->compare} \'{$a->value}\' özelliği.';
$string['rulepropertyinfo'] = 'Bu koşul, olayları ve özelliklerini teknik olarak anlayan uzman kullanıcılar içindir.';
$string['ruleset'] = 'koşullar kümesi';
$string['ruleset:all'] = 'TÜM koşullar doğrudur';
$string['ruleset:any'] = 'HERHANGİ BİR koşul doğrudur';
$string['ruleset:none'] = 'KOŞULLARIN HİÇBİRİ doğru değil';
$string['rulesetinfo'] = 'Birden çok koşulu tek bir koşulda birleştirin.';
$string['rulesformhelp'] = '<p>Bu eklenti, öğrenciler tarafından gerçekleştirilen eylemlere puan atfetmek için olayları kullanıyor.  Kendi kurallarınızı eklemek ve varsayılanları görüntülemek için aşağıdaki formu kullanabilirsiniz.</p>
<p>Kursta eylemler gerçekleştirirken hangi etkinliklerin tetiklendiğini belirlemek ve ayrıca etkinlikler hakkında daha fazla bilgi edinmek için eklentinin <a href="{$a->log}">günlüğünü</a> kontrol etmeniz önerilir. kendileri: <a href="{$a->list}">tüm etkinliklerin listesi</a>, <a href="{$a->doc}">geliştirici belgeleri</a>.</p>
<p>Son olarak, lütfen eklentinin aşağıdakileri her zaman göz ardı ettiğini unutmayın:
<ul>
<li>Yöneticiler, misafirler veya oturum açmamış kullanıcılar tarafından gerçekleştirilen işlemler.</li>
<li><em>block/xp:earnxp</em> yeteneğine sahip olmayan kullanıcılar tarafından gerçekleştirilen eylemler.</li>
<li>Hileyi önlemek için kısa bir süre içinde tekrarlanan eylemler.</li>
<li>Örneğin anonim bir Geri Bildirimde <em>anonim</em> olarak işaretlenen etkinlikler.</li>
<li>Eğitim düzeyindeki etkinlikler ise <em>Katılıyorum</em> düzeyine eşit değil.</li>
</ul>
</p>';
$string['ruletypecoursecompletion'] = 'Kurs tamamlama';
$string['searchandselectcourse'] = 'Bir kurs arayın ve seçin';
$string['searchandselectmodule'] = 'Bir etkinlik veya kaynak arayın ve seçin';
$string['send'] = 'Gönder';
$string['setpoints'] = 'Puan ayarları';
$string['shortcode:xpbadge'] = 'Mevcut kullanıcının seviyesine uygun rozet.';
$string['shortcode:xpiflevel'] = 'Mevcut kullanıcının seviyesi eşleştiğinde içeriği görüntüleyin.';
$string['shortcode:xpiflevel_help'] = 'Bu kısa kodu biçimlendirmek için aşağıdaki örneklere bakın.  Bir düzey kesin olarak belirtildiğinde, içerik diğer kurallardan bağımsız olarak görüntülenecektir.
İçeriğin görüntülenmesi için _granter_ ve _less than_ kurallarının tümü eşleşmelidir.  Dikkat edin, bu bazen içeriğin hiç görüntülenmemesine neden olabilir!
Öğretmenlerin veya düzenleme yetenekleri olan kullanıcıların her zaman her şeyi göreceğini unutmayın.

```
[xpif düzeyi 1 3 5]
Kullanıcının seviyesi tam olarak 1, 3 veya 5 ise görüntülenir.
[/xpifdüzeyi]

[xpif düzeyi >3]
Kullanıcının seviyesi 3\'ten büyükse görüntülenir.
[/xpifdüzeyi]

[xpif düzeyi >=3]
Kullanıcının seviyesi 3\'ten büyük veya eşitse görüntülenir.
[/xpifdüzeyi]

[xpif düzeyi >=10 <20 30]
Kullanıcının seviyesi 10\'dan büyük veya eşitse VE kesinlikle 20\'den küçükse görüntülenir
VEYA tam olarak 30\'a eşittir.
[/xpifdüzeyi]

[xpif düzeyi <=10 >=20]
Asla gösterilmez çünkü kullanıcının seviyesi asla 10\'dan az veya eşit olamaz VE 20\'den fazla veya eşit olamaz.
[/xpifdüzeyi]
```

Bu kısa kodların birbirinin içine YERLEŞTİRİLEMEYECEĞİNE dikkat edin.';
$string['shortcode:xpladder'] = 'Skor tablosunun bir bölümünü görüntüleyin.';
$string['shortcode:xpladder_help'] = 'Varsayılan olarak, skor tablosunun mevcut kullanıcıyı çevreleyen bir kısmı görüntülenecektir.

```
[xpladder]
```

Geçerli kullanıcının komşuları yerine ilk 10 öğrenciyi görüntülemek için "üst" parametresini ayarlayın.  Kullanıcı sayısını isteğe bağlı olarak "top=20" gibi görüntülenecek şekilde ayarlayabilirsiniz.

```
[xpladder üst]
[xpladder üst=15]
```

Tablonun altında tam puan tablosuna bir bağlantı otomatik olarak görüntülenecektir, böyle bir bağlantıyı görüntülemek istemiyorsanız, \'hidelink\' argümanını ekleyin.

```
[xpladder gizleme bağlantısı]
```

Varsayılan olarak tablo, ilerleme çubuğunu görüntüleyen ilerleme sütununu içermez.  Skor tablosunun ayarlarındaki ek sütunlarda böyle bir sütun seçildiyse, bunu görüntülemek için "ilerlemeli" bağımsız değişkenini kullanabilirsiniz.

```
[ilerleyen xpladder]
```

Bir kursta gruplar kullanıldığında, skor tablosunun hangi grubun görüntüleneceğini en iyi tahminin skor tablosunda olacağını unutmayın.';
$string['shortcode:xplevelname'] = 'Seviye adını görüntüleyin.';
$string['shortcode:xplevelname_help'] = 'Varsayılan olarak etiket, geçerli kullanıcının seviyesinin adını görüntüler.
Alternatif olarak, belirli bir düzeyin adını görüntülemek için "seviye" bağımsız değişkenini kullanabilirsiniz.

```
[xplevelname]
[xplevelname seviye=5]
```

"seviye" argümanı sağlanmışsa ve seviye mevcut değilse hiçbir şey görüntülenmez.';
$string['shortcode:xppoints'] = 'Deneyim noktaları olarak biçimlendirilmiş bir dizi noktayı görüntüleyin.';
$string['shortcode:xpprogressbar'] = 'Mevcut kullanıcının ilerleme çubuğu bir sonraki seviyeye doğru.';
$string['somefeaturesrequireotherplugins'] = 'Bazı özellikler, ek eklentilerin yüklenmesini gerektirir.';
$string['someoneelse'] = 'Başkası';
$string['somethinghappened'] = 'Bir şey oldu';
$string['taskcollectionloggerpurge'] = 'Toplama günlüklerini temizle';
$string['taskusagereport'] = 'Kullanım raporu';
$string['thankyou'] = 'Teşekkür ederim!';
$string['timebetweensameactions'] = 'Özdeş eylemler arasında gereken süre';
$string['timebetweensameactions_help'] = 'Daha önce gerçekleşmiş bir eylemin yeniden kabul edilmesi için gereken minimum süre.  Bir eylem, aynı bağlam ve nesneye yerleştirildiyse aynı kabul edilir, bir forum gönderisini okumak, aynı gönderi tekrar okunursa aynı kabul edilir.  Bu değer boş olduğunda veya sıfıra eşit olduğunda geçerli değildir.';
$string['timeformaxactions'] = 'Maksimum eylemler için zaman çerçevesi';
$string['timeformaxactions_help'] = 'Kullanıcının maksimum eylem sayısını aşmaması gereken zaman çerçevesi (saniye olarak).';
$string['tinytimedays'] = '{$a}g';
$string['tinytimehours'] = '{$a}s';
$string['tinytimeminutes'] = '{$a}d';
$string['tinytimenow'] = 'şimdi';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}hft';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Toplam';
$string['unknowneventa'] = 'Bilinmeyen olay ({$a})';
$string['updateandpreview'] = 'Güncelleme ve önizleme';
$string['upgradingplugins'] = 'eklentileri yükseltme';
$string['urlaccessdeprecated'] = 'Bu URL üzerinden erişim kullanımdan kaldırılmıştır, lütfen bağlantılarınızı güncelleyin.';
$string['usagereport'] = 'Kullanım raporunu paylaş';
$string['usagereport_desc'] = 'Anonim kullanım bilgilerini eklenti geliştiricileri ile periyodik olarak paylaşın.  Bu bilgi, eklentinin nasıl kullanıldığını daha iyi anlamanıza yardımcı olacak ve gelişimini etkileyecektir.  Paylaşılan bilgiler, Moodle sitesi hakkında temel bilgileri (URL, sürüm) ve eklenti hakkında kullanım bilgilerini (puan kazanan kullanıcı sayısı, ayarlara genel bakış, kullanılan kurallar, ...) içerir.';
$string['usealgo'] = 'Algoritmayı kullan';
$string['usecustomlevelbadges'] = 'Özel düzey rozetleri kullanın';
$string['usecustomlevelbadges_help'] = 'Evet olarak ayarlandığında, her düzey için bir görüntü sağlamalısınız.';
$string['usingalgo'] = 'Algoritma kullanma';
$string['value'] = 'Değer';
$string['valuessaved'] = 'Değerler başarıyla kaydedildi.';
$string['viewlogs'] = 'Günlükleri görüntüle';
$string['viewtheladder'] = 'merdiveni görüntüle';
$string['visualsintro'] = 'Seviyelerin görünümünü özelleştirmek için resimler yükleyin.';
$string['wewillreplyat'] = 'Şu adreste yanıt vereceğiz: _{$a}_.';
$string['when'] = 'Ne zaman';
$string['wherearexpused'] = 'Puanlar nerede kullanılır?';
$string['wherearexpused_desc'] = '\'Kurslarda\' olarak ayarlandığında, kazanılan puanlar yalnızca bloğun eklendiği kurs için hesaplanacaktır. \'Tüm site için\' olarak ayarlandığında, bir kullanıcı kurs başına seçici olmak yerine site içinde "seviye atlar", site genelinde kazanılan tüm puanlar kullanılır.';
$string['whoops'] = 'Hay aksi!';
$string['xp'] = 'Deneyim puanları';
$string['xp:addinstance'] = 'yeni bir blok ekle';
$string['xp:earnxp'] = 'puan kazanma';
$string['xp:manage'] = 'Deneyim puanlarının tüm yönlerini yönetin';
$string['xp:myaddinstance'] = 'Bloğu panoma ekle';
$string['xp:view'] = 'Bloğu ve ilgili sayfalarını görüntüleyin';
$string['xp:viewlogs'] = 'Günlükleri görüntüle';
$string['xp:viewreport'] = 'Raporu görüntüle';
$string['xpgaindisabled'] = 'Puan kazanma devre dışı';
$string['xprequired'] = 'DP gerekli';
$string['xptogo'] = '[[{$a}]] git';
$string['youreachedlevel'] = 'Şu seviyeye ulaştınız:';
$string['youreachedlevela'] = '{$a}. seviyeye ulaştınız!';
$string['yourmessage'] = 'Mesajın';
$string['yourownrules'] = 'Kendi kuralların';
