<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'tr', version '4.3'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Etkinlikler';
$string['addcategory'] = 'Kategori ekle';
$string['addcategoryerror'] = 'Kategori eklenemedi.';
$string['addexceptionerror'] = 'userid:gradeitem için istisna eklenirken hata oluştu.';
$string['addfeedback'] = 'Geri bildirim ekle';
$string['addgradeletter'] = 'Harf notu ekle';
$string['addidnumbers'] = 'ID numarası ekle';
$string['additem'] = 'Not ögesi ekle';
$string['additionalfeedback'] = 'Ek geribildirim';
$string['addoutcome'] = 'Kazanım ekle';
$string['addoutcomeitem'] = 'Kazanım ögesi ekle';
$string['addscale'] = 'Ölçek ekle';
$string['adjustedweight'] = 'Ağırlık ayarlı';
$string['aggregateextracreditmean'] = 'Notlarının ortalaması (ek kredi dahil)';
$string['aggregatemax'] = 'En yüksek not';
$string['aggregatemean'] = 'Not ortalaması';
$string['aggregatemedian'] = 'Not ortancası';
$string['aggregatemin'] = 'En düşük not';
$string['aggregatemode'] = 'Notlarının tepe değeri';
$string['aggregatenotonlygraded'] = 'Boş notları dahil et';
$string['aggregateonlygraded'] = 'Boş notları hariç tut';
$string['aggregateonlygraded_help'] = 'Boş not, not defterinden eksik olan nottur. Henüz puanlanmamış  bir ödev veya henüz girilmemiş sınav olabilir.

Bu ayar, boş notların toplama dahil edilip edilmeyeceğini veya endüşük not olarak kabul edildiği (örneğin, 0 ile 100 arasında puanlanmamış bir ödev için 0) ifade eder.';
$string['aggregateoutcomes'] = 'Toplama kazanımları dahil et';
$string['aggregateoutcomes_help'] = 'Etkinleştirilirse, kazanımlar toplanmaya dahil edilir. Bu, beklenmedik bir kategori toplamına neden olabilir.';
$string['aggregatesonly'] = 'Sadece toplamları göster';
$string['aggregatesubcatsupgradedgrades'] = 'Not: Toplama ayarları "Alt kategoriler dahil olmak üzere toplam", site güncellemesinin bir parçası olarak kaldırılmıştır. Bu kursda daha önce "Alt kategoriler dahil olmak üzere toplam" kullanıldığı için not defterindeki bu değişikliği gözden geçirmeniz önerilir.';
$string['aggregatesum'] = 'Doğal';
$string['aggregateweightedmean'] = 'Notların ağırlıklı ortalaması';
$string['aggregateweightedmean2'] = 'Notların basit ağırlıklı ortalaması';
$string['aggregation'] = 'Toplama (İcmal)';
$string['aggregation_help'] = 'Toplama (icmal), bir kategorideki notların nasıl birleştirileceğini belirler, ör.

* Not ortalaması - Not toplamı, notların toplam sayısına bölünür
* Notların ortancası - notlar büyüklüğüne göre sıralandığında tam ortaya düşen değer.
* En düşük not
* En yüksek not
* Notların modu - En sık tekrarlanan not
* Doğal - Tüm sınıf değerlerinin toplamı, ağırlıkça ölçeklendirilir';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Toplam katsayı';
$string['aggregationcoefextra'] = 'Ek kredi';
$string['aggregationcoefextra_help'] = 'Toplama "Doğal" veya "Basit ağırlıklı ortalamalar" ise ve ekstra kredi onay kutusu işaretlenmişse, sınıf maddesinin maksimum notu kategorinin maksimum notuna eklenmez. Bu, tüm not maddelerinde enyüksek not almadan kategorideki enyüksek notu elde etme olasılığına neden olacaktır. Site yöneticisi notları enyükseği
 aştıysa, enyüksek üzerinden notlar olabilir.

Birleştirme, \'Ortalama (ekstra kredili)\' ise ve ekstra kredi sıfırdan büyük bir değere ayarlanırsa, ekstra kredi, notun hesaplanmasından sonra toplama eklenmeden önce çarpılma faktörüdür anlamına gelmek.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Ek kredi';
$string['aggregationcoefextrasum_help'] = 'Ekstra kredi onay kutusu işaretlenirse, not öğsinin enyüksek notu kategorinin enyüksek notuna eklenmez; bu da kategorideki en yüksek notu (veya site yöneticisi tarafından etkinleştirilirse maksimumları aşan notları) elde etme olanağı sağlar; Tüm not ögelerinde  enyüksek not.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Ek kredi ağırlığı';
$string['aggregationcoefextraweight_help'] = 'Ekstra kredi ağırlığı sıfırdan büyük bir değere ayarlanırsa, not toplama sırasında ilave kredi olarak kullanılır. Sayı, ortalamanın hesaplanması için toplama eklenmeden önce notun çarpılmasına neden olan faktördür.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Öge ağırlığı';
$string['aggregationcoefweight_help'] = 'Öğe ağırlığı aynı kategorideki diğer not öğeleriyle karşılaştırıldığında öğenin önemini etkilemek için kategori toplama alanında kullanılır.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Muaf tutuldu)';
$string['aggregationhintexcluded'] = '( Dahil edilmedi )';
$string['aggregationhintextra'] = '( Ekstra kredi )';
$string['aggregationhintnovalue'] = '( Boş )';
$string['aggregationofa'] = '{$a}\'nın toplamı';
$string['aggregationposition'] = 'Toplam(icmalin) yeri';
$string['aggregationposition_help'] = 'Bu ayar, not defteri raporlarında kategori ve kurs toplam sütunlarının ilk önce gösterilip gösterilmeyeceğini belirler.';
$string['aggregationsvisible'] = 'Kullanılabilir toplama türleri';
$string['aggregationsvisiblehelp'] = 'Kullanılacak tüm toplama türlerini seçin. Birden fazla öge seçmek için Ctrl tuşunu basılı tutun.';
$string['allgrades'] = 'Kategorilere göre tüm notlar';
$string['allstudents'] = 'Tüm öğrenciler';
$string['allusers'] = 'Tüm kullanıcılar';
$string['aria-toggledropdown'] = 'Aşağıdaki açılır listesi açın';
$string['aria:dropdowngrades'] = 'Not ögeleri bulundu';
$string['autosort'] = 'Otomatik-sırala';
$string['availableidnumbers'] = 'Kullanılabilir Kimlik numaraları';
$string['average'] = 'Ortalama';
$string['averagesdecimalpoints'] = 'Sütun ortalamalarındaki ondalıklar';
$string['averagesdecimalpoints_help'] = 'Bu ayar, her bir ortalama için görüntülenecek ondalık basamak sayısını veya kategori veya not öğesinin genel ondalık basamak ayarının kullanılıp kullanılmayacağını (devralma) belirler.';
$string['averagesdisplaytype'] = 'Sütun ortalamaları görünüm türü';
$string['averagesdisplaytype_help'] = 'Bu ayar, ortalama (ortalama) gerçek notlar, yüzdeler veya harfler olarak mı yoksa kategori veya not öğesi için görüntüleme türünün mi kullanıldığını (devralın) gösterilip gösterilmeyeceğini belirler.';
$string['backupwithoutgradebook'] = 'Yedekleme Not Defteri yapılandırmasını içermez';
$string['badgrade'] = 'Sağlanan not geçersiz';
$string['badlyformattedscale'] = 'Lütfen değerlerin listesini virgülle ayırarak girin (en az iki değer gereklidir).';
$string['baduser'] = 'Sağlanan kullanıcı geçersiz';
$string['bonuspoints'] = 'Bonus puanlar';
$string['bulkcheckboxes'] = 'Toplu onay kutuları';
$string['calculatedgrade'] = 'Hesanplanan not';
$string['calculation'] = 'Hesaplama';
$string['calculation_help'] = 'Bir not hesaplaması, notları belirlemek için kullanılan bir formüldür. Formül eşit (=) işaretiyle başlamalı ve max, min ve sum gibi yaygın matematiksel operatörleri kullanabilir. İstenirse, diğer sınıf maddeleri, çift parantez içinde kimlik numaralarını yazarak hesaplamaya dahil edilebilir.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Hesaplama ekle';
$string['calculationedit'] = 'Hesaplama düzenle';
$string['calculationsaved'] = 'Hesaplama kaydedildi';
$string['calculationview'] = 'Hesaplamaya bak';
$string['calculationwarning'] = 'Bu kategori, kategori toplamı için bir toplama yerine bir değerlendirme puanı hesaplaması kullanır.';
$string['cannotaccessgroup'] = 'Üzgünüz, seçili grubun notlarına erişilemiyor.';
$string['categories'] = 'Kategoriler';
$string['category'] = 'Kategori';
$string['categoryedit'] = 'Kategori düzenle';
$string['categoryname'] = 'Kategori adı';
$string['categorytotal'] = 'Kategori toplamı';
$string['categorytotalfull'] = 'Toplam {$a->category}';
$string['categorytotalname'] = 'Kategori toplam adı';
$string['changedefaults'] = 'Varsayılanları değiştir';
$string['changereportdefaults'] = 'Rapor varsayılanlarını değiştir';
$string['chooseaction'] = 'Bir eylem seçin';
$string['choosecategory'] = 'Kategori seç';
$string['collapsecriterion'] = 'Ölçütü daralt';
$string['combo'] = 'Sekmeler ve açılı menü';
$string['compact'] = 'Kompakt';
$string['componentcontrolsvisibility'] = 'Bu notun gizli olup olmadığı etkinlik ayarları tarafından kontrol edilir.';
$string['contract'] = 'Kategorileri sıkıştır';
$string['contributiontocoursetotal'] = 'Kurs toplamına katkısı';
$string['controls'] = 'Kontroller';
$string['courseavg'] = 'Kurs ortalaması';
$string['coursegradecategory'] = 'Kurs notu kategorisi';
$string['coursegradedisplaytype'] = 'Kurs notu görünüm türü';
$string['coursegradedisplayupdated'] = 'Kurs notu görünüm türü güncellendi.';
$string['coursegradesettings'] = 'Kurs notu ayarları';
$string['coursename'] = 'Kurs adı';
$string['coursescales'] = 'Kurs ölçekleri';
$string['coursesettings'] = 'Kurs ayarları';
$string['coursesettingsexplanation'] = 'Kurs notu ayarları, not defterinin kurstaki tüm katılımcılar için nasıl görüneceğini belirler.';
$string['coursesiamtaking'] = 'Aldığım kurslar';
$string['coursesiamteaching'] = 'Ders Verdiğim Kurslar';
$string['coursetotal'] = 'Kurs toplamı';
$string['createcategory'] = 'Kategori oluştur';
$string['createcategoryerror'] = 'Yeni kategori oluşturulamadı';
$string['creatinggradebooksettings'] = 'Not defteri ayarları oluşturuluyor';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Mevcut ana koleksiyon';
$string['curveto'] = 'Çan eğrisi';
$string['decimalpoints'] = 'Tüm ondalık sayılar';
$string['decimalpoints_help'] = 'Bu ayar, her not için görüntülenecek ondalık basamak sayısını belirler. Bu ayarın, 5 ondalık basamak hassasiyetiyle yapılan not hesaplamaları üzerinde bir etkisi yoktur.';
$string['default'] = 'Varsayılan';
$string['defaultprev'] = 'Varsayılan ({$a})';
$string['deletecategory'] = 'Kategori sil';
$string['deletescale'] = 'Ölçeği sil';
$string['disablegradehistory'] = 'Not geçmişini etkisizleştir';
$string['disablegradehistory_help'] = 'Notlarla ilgili tablolardaki değişikliklerin tarihsel arama özelliğini geçersiz kılın. Bu, sunucuyu biraz hızlandırıp veritabanında boşluk kalmasını sağlayabilir.';
$string['displaylettergrade'] = 'Harfli notları göster';
$string['displaypercent'] = 'Yüzdeleri göster';
$string['displaypoints'] = 'Notları göster';
$string['displayweighted'] = 'Ağırlıklı notları göster';
$string['dropdown'] = 'Açılır menu';
$string['droplow'] = 'En düşüğü yoksay';
$string['droplow_help'] = 'Bu ayar, belirli sayıda en düşük notun toplamadan hariç tutar.';
$string['droplowestvalue'] = 'En düşük notun değerini ayarla';
$string['droplowestvalues'] = 'En düşük değerleri {$a} azaltın';
$string['dropped'] = 'Muat tutuldu';
$string['dropxlowest'] = 'Endüşük X Yoksay';
$string['dropxlowestwarning'] = 'NOT: En düşük X sayıda öğrenciyi yoksayı kullanırsanız, puanlama, kategorideki tüm ögeleri aynı puan değerinde varsayar. Eğer puan değerleri farklıysa sonuçlar belirsiz olabilir.';
$string['duplicatedgradeitem'] = '{$a} (copy)';
$string['duplicatescale'] = 'Öçeği çoğalt';
$string['edit'] = 'Düzenle';
$string['editcalculation'] = 'Hesaplama düzenle';
$string['editcalculationverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} hesaplamasını düzenle';
$string['editfeedback'] = 'Geri bildirim düzenle';
$string['editgrade'] = 'Not düzenle';
$string['editgradeletters'] = 'Harf notlarını düzenle';
$string['editoutcome'] = 'Kazanımı düzenle';
$string['editoutcomes'] = 'Kazanımları düzenle';
$string['editscale'] = 'Ölçeği düzenle';
$string['edittree'] = 'Kurulum';
$string['editverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} düzenle';
$string['enableajax'] = 'AJAX etkinleştir';
$string['enableajax_help'] = 'Değerlendirme raporuna AJAX işlevsellik katmanı ekler. Bu da, yaygın işlemlerin basitleşmesini ve hızlanmasını sağlar. Bu, Javascript\'in kullanıcının tarayıcısı düzeyinde açık oluşuna bağlıdır.';
$string['enableoutcomes'] = 'Kazanımları etkinleştir';
$string['enableoutcomes_help'] = 'Etkinleştirilirse, not öğelerine kazanım ifadelerine bağlı bir veya daha fazla ölçek kullanılarak not verilebilir.';
$string['encoding'] = 'Kodlama';
$string['encoding_help'] = 'Veriler için kullanılan karakter kodlamasını seçin. (Standart kodlama UTF-8\'tir.) Yanlış kodlama yanlışlıkla seçilirse, verileri içe aktarma için önizleme yaparken dikkat çekici olacaktır.';
$string['errorcalculationbroken'] = '{$a} not öğesinin hesaplanmasında hata.';
$string['errorcalculationnoequal'] = 'Formül, eşittir işareti ile başlamalı (=1+2)';
$string['errorcalculationunknown'] = 'Geçersiz formül';
$string['errorgradevaluenonnumeric'] = 'Düşük veya yüksek not için sayısal olmayan değer alındı';
$string['errornocalculationallowed'] = 'Bu öge için hesaplama izni yok';
$string['errornocategorisedid'] = 'Sınıflandırılmamış bir id alınamadı!';
$string['errornocourse'] = 'Kurs bilgisi alınamadı';
$string['erroroverweight'] = 'Ağırlık toplamı %100\'ü aşıyor.';
$string['errorreprintheadersnonnumeric'] = 'Başlıkların tekrar yazılması için sayısal olmayan değer alındı';
$string['errorsavegrade'] = 'Üzgünüz, not kaydedilemedi.';
$string['errorsettinggrade'] = 'Kaydetme hatası "{$a->itemname}" Kullanıcı kimliği için not {$a->userid}';
$string['errorunderweight'] = 'Ağırlık toplamı %100\'den az.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Not kategorisi kimliği {$a->id} için "Toplu yalnızca boş olmayan notları" ayarını güncelleme hatası';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Not kategorisi kimliği {$a->id} için "Toplu halde kazanımları dahil et" ayarı güncellenirken hata oluştu';
$string['errorupdatinggradecategoryaggregation'] = 'Not kategorisi kimliği {$a->id} toplama türünü güncelleme hatası';
$string['errorupdatinggradeitemaggregationcoef'] = '{$a->id} not öğe kimliğinin toplama katsayısının (ağırlık veya ekstra kredi) güncellenirken hata oluştu';
$string['eventgradedeleted'] = 'Not silindi';
$string['eventgradeexported'] = 'Not dışa aktarıldı';
$string['eventgradeitemcreated'] = 'Not ögesi oluşturuldu';
$string['eventgradeitemdeleted'] = 'Not ögesi silindi';
$string['eventgradeitemupdated'] = 'Not ögesi güncellendi';
$string['eventgradelettercreated'] = 'Harf notu oluşturuldu';
$string['eventgradeletterdeleted'] = 'Harf notu silindi';
$string['eventgradeletterupdated'] = 'Harf notu güncellendi';
$string['eventgradeviewed'] = 'Notlar not defterinde görüntülendi';
$string['eventscalecreated'] = 'Ölçek oluşturuldu';
$string['eventscaledeleted'] = 'Ölçek silindi';
$string['eventscaleupdated'] = 'Ölçek güncellendi';
$string['eventusergraded'] = 'Kullanıcıya not verlidi';
$string['excluded'] = 'Muaf tutuldu';
$string['excluded_help'] = 'İşaretliyse, not herhangi bir toplama dahil edilmeyecektir.';
$string['expand'] = 'Kategoriyi genişlet';
$string['expandcriterion'] = 'Ölçütü genişlet';
$string['export'] = 'Dışa aktar';
$string['exportalloutcomes'] = 'Tüm Kazanımlar dışa aktar';
$string['exportas'] = 'Şu olarak dışa aktar';
$string['exportfeedback'] = 'Dışa aktarıma geribildirimi dahil et';
$string['exportfeedback_desc'] = 'Bu, dışa aktarma sırasında geçersiz kılınabilir.';
$string['exportformatoptions'] = 'Dışa aktarma biçimi seçenekleri';
$string['exportonlyactive'] = 'Askıya alınmış kullanıcılar hariç';
$string['exportonlyactive_help'] = 'Yalnızca kayıtları etkin olan ve askıya alınmamış öğrencileri dışa aktarmaya dahil edin';
$string['exportplugins'] = 'Eklentileri dışa aktar';
$string['exportsettings'] = 'Ayarları dışa ver';
$string['exportto'] = 'Dışa çıkart';
$string['externalurl'] = 'Harici URL';
$string['externalurl_desc'] = 'Harici not defteri kullanılıyorsa URL burada belirtilmelidir.';
$string['extracreditvalue'] = '{$a} için ek kredi değeri';
$string['extracreditwarning'] = 'NOT: Bir kategorideki tüm ögelere ek kredi vermek, bu ögeleri not hesaplamasından çıkarır. Bu yüzden toplam not olmaz.';
$string['fail'] = 'Hata';
$string['feedback'] = 'Geri bildirim';
$string['feedback_help'] = 'Bu kutu nota ilişkin herhangi bir yorumun eklenmesini sağlar.';
$string['feedbackadd'] = 'Geri bildirim ekle';
$string['feedbackedit'] = 'Geri bildirim düzenle';
$string['feedbackfiles'] = 'Geri bildirim dosyaları';
$string['feedbackforgradeitems'] = '{$a} için görüşler';
$string['feedbackhistoryfiles'] = 'Geri bildirim geçmişi dosyaları';
$string['feedbackprovided'] = 'Geri bildirim sağlandı';
$string['feedbacks'] = 'Geri bildirimler';
$string['feedbacksaved'] = 'Geri bildirim kaydedildi';
$string['feedbackview'] = 'Geri bildirimi görüntüle';
$string['filterbothactive'] = 'İlk ({$a->first}) Son ({$a->last})';
$string['filterbyname'] = 'Ada göre filtrele';
$string['filterfirstactive'] = 'İlk ({$a->first})';
$string['filterlastactive'] = 'İlk ({$a->ilk})';
$string['finalgrade'] = 'Final notu';
$string['finalgrade_help'] = 'Geçersiz kılınan onay kutusu işaretlenmişse, bir not eklenebilir veya değiştirilebilir.';
$string['fixedstudents'] = 'Sabit öğrenci sütunları';
$string['fixedstudents_help'] = 'Öğrenci sütununu statik hale getirerek notların gözden kaybolmadan yatay olarak kaydırılmasını sağlar.';
$string['forceimport'] = 'İçe aktarmayı zorla';
$string['forceimport_help'] = 'İçe aktarma dosyası dışa aktarıldıktan sonra notlar güncellenmiş olsa bile, notların ithalatını zorla';
$string['forceoff'] = 'Zorunlu: Kapalı';
$string['forceon'] = 'Zorunlu: Açık';
$string['forelementtypes'] = 'seçili {$a} için';
$string['forstudents'] = 'Öğrenciler için';
$string['full'] = 'Tam';
$string['fullmode'] = 'Notları ve toplamları göster';
$string['generalsettings'] = 'Genel ayarlar';
$string['grade'] = 'Not';
$string['grade_help'] = 'Öğrenciye çalışma için verilecek not.';
$string['gradeadministration'] = 'Not yönetimi';
$string['gradealreadyupdated'] = 'i̇çe aktarma dosyasındaki notlar, değrlendici raporundan daha eski olduğu için {$a} not içe aktarılmadı. Yine de Notu iç aktar işlemine devam etmek için zorla alma seçeneğini kullanın.';
$string['gradeanalysis'] = 'Not analizi';
$string['gradebook'] = 'Not Defteri';
$string['gradebookcalculationsfixbutton'] = 'Not değişikliklerini kabul et ve hesaplama hatalarını düzelt';
$string['gradebookcalculationsuptodate'] = 'Not defterindeki hesaplamalar güncel. Değişiklikleri görmek için bu sayfayı yeniden yüklemeniz gerekebilir.';
$string['gradebookcalculationswarning'] = 'Not: Not defterinde görüntülenen notların hesaplanmasında bazı hatalar tespit edilmiştir. Kursunuz başlamadı veya devam ediyorsa, bazı notların değişmesine neden olacak olsa da, hataları aşağıdaki butona tıklayarak düzeltmeniz önerilir. Kursunuz zaten bitti ve notlar gönderildiyse, muhtemelen bu sorunu çözmek istemezsiniz.

Yeni sürüm {$a->currentversion}; Gradebook {$a>gradebookversion} sürümünü kullanıyorsunuz. <a href="{$a-> url} "> Defter hesaplama değişikliklerinde </a> değişikliklerin bir listesini görebilirsiniz.';
$string['gradebookhiddenerror'] = 'Notdefteri şu anda öğrencilerden herşeyi gizle olarak ayarlandı.';
$string['gradebookhistories'] = 'Not geçmişleri';
$string['gradebooknavigationmenu'] = 'Son ({$a->last})';
$string['gradebooksetup'] = 'Not defteri kurulumu';
$string['gradeboundary'] = 'Harf notu sınırı';
$string['gradeboundary_help'] = 'Bu ayar, minimum yüzdeyi belirler. Hangi notlara harfli not verilecek.';
$string['gradecategories'] = 'Notu kategorileri';
$string['gradecategory'] = 'Not kategorisi';
$string['gradecategoryonmodform'] = 'Not kategorisi';
$string['gradecategoryonmodform_help'] = 'Bu ayar, bu etkinliğin notlarının not defterine yerleştirildiği kategoriyi kontrol eder.';
$string['gradecategorysettings'] = 'Not kategorisi ayarları';
$string['gradedisplay'] = 'Not görünümü';
$string['gradedisplaytype'] = 'Not görünüm türü';
$string['gradedisplaytype_help'] = 'Bu ayar, notların değerlendici ve kullanıcı raporlarında nasıl görüntüleneceğini belirler. * Harf - Not defteri kurulumundaki \'Harfler\' bölümünde tanımlandığı gibi, bir not aralığını temsil etmek için harfler veya kelimeler kullanılır * Yüzde - Enyüksek ve düşük notlara göreli * Gerçek - Gerçek notlar veya ölçek değerleri';
$string['gradedon'] = 'Not verildi: {$a}';
$string['gradeexport'] = 'Notu dışa ver';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Not dışa aktarma özel profil alanları';
$string['gradeexportcustomprofilefields_desc'] = 'Bu özel profil alanlarını virgülle ayırarak not dışa aktarımına dahil edin.';
$string['gradeexportdecimalpoints'] = 'Not dışa aktarma ondalık basamakları';
$string['gradeexportdecimalpoints_desc'] = 'Dışa aktarma için görüntülenecek ondalık basamak sayısı. Bu, dışa aktarma sırasında geçersiz kılınabilir.';
$string['gradeexportdisplaytype'] = 'Not dışa aktarım görünüm türü';
$string['gradeexportdisplaytype_desc'] = 'Notlar, (en düşük ve en yüksek notlara istinaden)yüzde olarak ya da (A,B,C vs..gibi harfler halinde gerçek notlar olarak gösterilebilir. Bu, dışaverim sırasında geçersiz kılınabilir.';
$string['gradeexportdisplaytypes'] = 'Not dışa aktarma görüntüleme türleri';
$string['gradeexportuserprofilefields'] = 'Not, kullanıcı profil alanlarını dışa aktarma';
$string['gradeexportuserprofilefields_desc'] = 'Bu kullanıcı profili alanlarını, virgülle ayrılmış olarak not dışa aktarmasına dahil edin.';
$string['gradeforstudent'] = 'Son ({$a->son})';
$string['gradegrademinmax'] = 'Başlangıctaki endüşük ve en yüksek notlar';
$string['gradehelp'] = 'Not yardımı';
$string['gradehistorylifetime'] = 'Nott geçmişi ömrü';
$string['gradehistorylifetime_help'] = 'Tablolardaki notlarla ilgili değişikliklerin yapılış tarihçesini tutmak istediğiniz zaman aralığını belirtir. Bu aralığın mümkün olduğu kadar uzun tutulması önerilir. Başarım sorunları ya da sınırlı veritabanı alanı gibi sorunlarla karşılaşırsanız, daha düşük değer belirlemeye çalışın.';
$string['gradeimport'] = 'Notu içe aktar';
$string['gradeimportfailed'] = 'Not içe aktarma işlemi başarısız oldu. Ayrıntılar:';
$string['gradeitem'] = 'Not ögesi';
$string['gradeitemaddusers'] = 'Puanlamadan muaf tut';
$string['gradeitemadvanced'] = 'Gelişmiş not ögeleri';
$string['gradeitemadvanced_help'] = 'Not öğelerini düzenlerken gelişmiş olarak görüntülenmesi gereken tüm öğeleri seçin.';
$string['gradeitemislocked'] = 'Bu etkinlik, not defterinde kilitlenmiş. Bu etkinlikteki notlara yapılan değişiklikler, kilidi açılmadıkça not defterine kopyalanmayacaktır.';
$string['gradeitemlocked'] = 'Puanlama kilitlendi';
$string['gradeitemmembersselected'] = 'Puanlamadan muaf tutulanlar';
$string['gradeitemminmax'] = 'Not ögesi ayarlarında belirtildiği gibi endüşük ve enyüksek notlar';
$string['gradeitemnonmembers'] = 'Puanlamaya dahil edilenler';
$string['gradeitemremovemembers'] = 'Puanlamaya dahil edilenler';
$string['gradeitems'] = 'Not ögeleri';
$string['gradeitemsettings'] = 'Not ögesi ayarları';
$string['gradeitemsinc'] = 'Dahil edilecek not ögeleri';
$string['gradeletter'] = 'Harf notu';
$string['gradeletter_help'] = 'Harf notları, bir dizi notu temsil etmek için kullanılan Distinction, Merit, Pass, ... gibi harfler, A, B, C, ... veya kelimelerdir.';
$string['gradeletternote'] = 'Bir notu yok etmek için 3 alandan herhangi birini <br />boş bırakın ve \'Değişiklikleri Kaydet\'e basın.';
$string['gradeletteroverridden'] = 'Varsayılan harf notları şu anda geçersiz kılınmıştır.';
$string['gradeletters'] = 'Harf notları';
$string['gradelocked'] = 'Not kilitli';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'En yüksek not';
$string['grademax_help'] = 'Bu ayar, değer not türünü kullanırken enyüksek not belirler. Bir etkinliğe dayalı not öğesinin enyüksek notu etkinlik ayarları sayfasında ayarlanır.';
$string['grademin'] = 'En düşük not';
$string['grademin_help'] = 'Bu ayar, değer not türünü kullanırken endüşük notu belirler.';
$string['gradenotificationmessage'] = '"{$a}" için yaptığınız çalışmayla ilgili yeni geri bildirimleriniz var';
$string['gradenotificationsubject'] = 'Değerlendirilmeniz yapıldı';
$string['gradeoutcomeitem'] = 'Kazanıma not ver';
$string['gradeoutcomes'] = 'Kazanımlar';
$string['gradeoutcomescourses'] = 'Kurs kazanımları';
$string['gradepass'] = 'Geçme notu';
$string['gradepass_help'] = 'Bu ayar, geçmek için gereken minimum puanı belirler. Bu değer, etkinlik ve kurs tamamlama ve başarı notlarının yeşil ve başarısız notlarının kırmızı renkte vurgulandığı not defterinde kullanılır.';
$string['gradepassgreaterthangrade'] = 'Geçme notu, mümkün olan en yüksek nota {$a}';
$string['gradepointdefault'] = 'Varsayılan not puanı';
$string['gradepointdefault_help'] = 'Bu ayar, bir not öğesinde mevcut olan notun puan değeri için varsayılan değeri belirler.';
$string['gradepointdefault_validateerror'] = 'Bu ayar 1 ile en yüksek not puanı arasında bir tamsayı olmalıdır.';
$string['gradepointmax'] = 'En yüksek not puanı';
$string['gradepointmax_help'] = 'Bu ayar, bir etkinlikte kullanılabilen enyüksek not puanı değerini belirler.';
$string['gradepointmax_validateerror'] = 'Bu ayar 1 ile 10000 arasında bir tamsayı olmalıdır.';
$string['gradepreferences'] = 'Not tercihleri';
$string['gradepreferenceshelp'] = 'Not tercihleri Yardımı';
$string['gradepublishing'] = 'Yayımlamayı etkinleştir';
$string['gradepublishing_help'] = 'Not yayınlama, Moodle\'da oturum açmadan notları bir URL aracılığıyla içe ve dışa aktarmanın bir yoludur.  Etkinleştirilirse, notları yayınlama izni olan yöneticilere ve kullanıcılara (varsayılan olarak, yalnızca yönetici rolüne sahip kullanıcılar), her dersin not defterinde not dışa aktarma yayınlama ayarları sağlanır.';
$string['gradepublishinglink'] = 'İndirin: {$a}';
$string['gradereport'] = 'Not raporu';
$string['graderreport'] = 'Öğrenci raporu';
$string['grades'] = 'Başarı notları';
$string['gradesforuser'] = '{$a->user} için notlar';
$string['gradesmoduledeletionpendingwarning'] = 'Uyarı: Etkinlik silme işlemi devam ediyor! Bazı notlar kaldırılmak üzeredir.';
$string['gradesmoduledeletionprefix'] = '[Deletion in progress]';
$string['gradesonly'] = 'Sadece notları değiştir';
$string['gradessettings'] = 'Not ayarları';
$string['gradetype'] = 'Not türü';
$string['gradetype_help'] = '4 not tipi vardır: * Yok - Not vermek mümkün değil * Değer - En Yüksek ve en düşük  sayısal değer * Ölçek - Listedeki bir öğe * Metin - Yalnızca geri bildirim Yalnızca değer ve ölçek not türleri toplanabilir.  Etkinliğe dayalı bir not öğesinin not türü, etkinlik ayarları sayfasında belirlenir.';
$string['gradevaluetoobig'] = 'Not değerlerinden biri izin verilen enyüksek {$a} değerinden daha büyük';
$string['gradevaluetoosmall'] = 'Not değerlerinden biri izin verilen minimum {$a} notundan küçüktür';
$string['gradeview'] = 'Notu görüntüle';
$string['gradewasmodifiedduringediting'] = 'için girilen not{$a->username} için {$a->itemname}, daha yakın zamanda bir başkası tarafından güncellendiğinden yoksayıldı.';
$string['gradeweighthelp'] = 'Not ağırlığı Yardımı';
$string['gradingmodulename'] = '({$a}) puanlanıyor';
$string['groupavg'] = 'Grup ortalaması';
$string['hidden'] = 'Gizli';
$string['hidden_help'] = 'İşaretlenirse notlar öğrencilerden gizlenir. Not verme işlemi tamamlandıktan sonra notları serbest bırakmak için arzu edilirse gizli bir tarih belirlenebilir.';
$string['hiddenasdate'] = 'Gizli notlar için gönderim tarihini göster';
$string['hiddenasdate_help'] = 'Eğer kullanıcı saklı notları göremiyorsa,\'-\' yerine gönderim tarihini gösterin.';
$string['hiddenuntil'] = 'Bu zamana kadar gizli';
$string['hiddenuntildate'] = 'Bu zamana kadar gizli: {$a}';
$string['hideadvanced'] = 'Gelişmiş özellikleri gizle';
$string['hideaverages'] = 'Ortalamaları gizle';
$string['hidecalculations'] = 'Hesaplamaları gizle';
$string['hidecategory'] = 'Gizli';
$string['hideeyecons'] = 'Göster/gizle simgelerini gizle';
$string['hidefeedback'] = 'Geri bildirimi gizle';
$string['hideforcedsettings'] = 'Zorunlu ayarları gizle';
$string['hideforcedsettings_help'] = 'Puanlama  kullancı arayüzünde zorunlu ayarları gösterme.';
$string['hidegroups'] = 'Grupları gizle';
$string['hidelocks'] = 'Kilitleri gizle';
$string['hidenooutcomes'] = 'Kazanımları göster';
$string['hidequickfeedback'] = 'Hızlı gerbildirimi gizle';
$string['hideranges'] = 'Aralıkları gizle';
$string['hidetotalifhiddenitems'] = 'Gizli öğeler içeriyorsa toplamları gizle';
$string['hidetotalifhiddenitems_help'] = 'Bu ayar, gizli not öğeleri içeren toplamların öğrencilere gösterilip gösterilmeyeceğini veya tire ile değiştirilip değiştirilmeyeceğini (-) belirtir. Gösterilirse, toplam gizli öğeler hariç veya gizli öğeler dahilinde hesaplanabilir.

Gizli öğeler hariç tutulursa, öğretmen her zaman değerlendici raporda öğretmen tarafından görülen toplamdan farklı olacaktır, zira öğretmen her zaman tüm öğelerden hesaplanan, gizli veya sızdırılmış toplamları görür. Gizli öğeler dahil edilirse, öğrenciler gizli öğeleri hesaplayabilir.';
$string['hidetotalshowexhiddenitems'] = 'Gizli öğeler hariç toplamları göster';
$string['hidetotalshowinchiddenitems'] = 'Gizli öğeler de dahil toplamları göster';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} gizle';
$string['highgradeascending'] = 'Yüksek not (artan sıralama)';
$string['highgradedescending'] = 'Yüksek not (azalan sıralama)';
$string['highgradeletter'] = 'Yüksek';
$string['identifier'] = 'Kullanıcıyı ...ile tanımla';
$string['idnumbers'] = 'ID numaraları';
$string['ignore'] = 'Yok say';
$string['import'] = 'İçe al';
$string['importas'] = 'Şu şekilde içeri aktar';
$string['importcsv'] = 'CSV\'yi içe aktar';
$string['importcsv_help'] = 'Notlar aşağıdaki gibi bir CSV dosyasıyla içe aktarılabilir:

* Dosyanın her satırı tek bir kayıt içerir
* Her kayıt, virgüller veya alternatif bir ayırıcıyla ayrılmış bir dizi veri
* İlk kayıt, dosyanın geri kalanının formatını tanımlayan alan adlarının bir listesini içerir
* Kullanıcı kimliği verileri içeren bir alan adı gerekir - kullanıcı adı veya kimlik numarası veya e-posta adresi

Doğru biçimdeki bir dosya önce bazı notları dışa aktararak elde edilebilir. Dosya daha sonra düzenlenebilir ve bir CSV dosya raporu olarak kaydedilebilir.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Özel kazanımlar halinde içe aktar (yalnızca bu kurs)';
$string['importdata'] = 'Veri';
$string['importdata_help'] = 'Notlar, aşağıdaki biçime sahip bir OpenDocument veya Excel elektronik tablosundan doğrudan yapıştırılabilir:

 * En az bir sütun, kullanıcı kimlik verilerini (kullanıcı adı, e-posta adresi veya kimlik numarası) içermelidir.
 * Diğer sütunlar, mevcut etkinlikler veya not öğeleri için başlıklara sahip olmalıdır.

 Önce bazı notlar dışa aktarılarak doğru biçimlendirilmiş bir elektronik tablo elde edilebilir.  Elektronik tablo daha sonra daha fazla not eklemek için düzenlenebilir ve kaydedilebilir.

 Elektronik tablodan içe aktarmak istediğiniz sütunları seçip kopyalayın ve ardından bu alana yapıştırın.';
$string['importerror'] = 'Bir hata oluştu, bu yazı doğru parametrelerle çağrılmamıştır.';
$string['importfailed'] = 'İçe aktarma başarısız oldu. Hiçbir veri içe aktarılmadı.';
$string['importfeedback'] = 'Geri bildirim içe aktar';
$string['importfile'] = 'Dosyayı içe aktar';
$string['importfilemissing'] = 'Hiçbir dosya alınmadı, forma geri dönüp geçerli bir dosyanın yüklendiğinden emin olun.';
$string['importfrom'] = 'İçe al';
$string['importoutcomenofile'] = 'Yüklenen dosya boş veya bozuk.  Lütfen bunun geçerli bir dosya olduğunu doğrulayın. Sorun {$a} satırında tespit edildi; bu, veri satırlarının ilk satır (başlık satırı) kadar sütuna sahip olmaması veya içe aktarılan dosyada beklenen başlıkların eksik olması nedeniyle tetiklenir.  Geçerli başlığa sahip bir dosya örneği için dışa aktarılan dosyaya bakın.';
$string['importoutcomes'] = 'Kazanımları içe aktar';
$string['importoutcomes_help'] = 'Kazanımlar, csv dosyası aracılığıyla dışa vermede kullanılan biçim ile içeri de alınabilir.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'ID#{$a->id} ile içe aktarılın kazanım "{$a->name}"';
$string['importplugins'] = 'Eklentileri içe aktar';
$string['importpreview'] = 'İçealmayı gözden geçir';
$string['importsettings'] = 'Ayarları içe aktar';
$string['importskippednomanagescale'] = 'Yeni bir ölçek eklemeye izniniz yok, o yüzden "{$a}" sonucu yeni bir ölçek oluşturmayı gerektirdiğinden atlandı.';
$string['importskippedoutcome'] = 'Bu bağlamda "{$a}" kısa adına sahip bir kazanım zaten mevcut, içe aktarılan dosyadaki kazanım atlandı.';
$string['importstandard'] = 'Standart kazanım olarak içe aktarın';
$string['importsuccess'] = 'Notu içe aktarımı başarılı oldu';
$string['importxml'] = 'XML içe aktar';
$string['includescalesinaggregation'] = 'ÖLçekleri topamaya dahil edin';
$string['includescalesinaggregation_help'] = 'Ölçeklerin tüm kurslardaki not defterlerinde tüm toplanmış notlara sayı olarak dahil edilip edilmeyeceğini değiştirebilirsiniz. DİKKAT: Bu ayarın değiştirilmesi, tüm toplu notların yeniden hesaplanmasını zorunlu kılacaktır.';
$string['incorrectcourseid'] = 'Kurs kimliği hatalı';
$string['incorrectcustomscale'] = '(Yanlış özel ölçek, lütfen değiştirin.)';
$string['incorrectminmax'] = 'En az, en çoktan daha düşük olmalıdır';
$string['inherit'] = 'Devral';
$string['intersectioninfo'] = 'Öğrenci/Not bilgisi';
$string['invalidgradeexporteddate'] = 'Bir yıl önce veya ileride olduğundan veya biçimi geçersiz olduğu için verme tarihi geçersiz.';
$string['item'] = 'Öge';
$string['iteminfo'] = 'Öge bilgisi';
$string['iteminfo_help'] = 'Bu ayar öğe hakkında bilgi girmek için yer sağlar. Bu bilgiler başka hiçbir yerde görüntülenmez.';
$string['itemname'] = 'Öge adı';
$string['itemnamehelp'] = 'Modül tarafından yürütülen bu öğenin adı';
$string['items'] = 'Ögeler';
$string['itemsedit'] = 'Not ögesi düzenle';
$string['keephigh'] = 'En yüksek tut';
$string['keephigh_help'] = 'Eğer kurulmuşsa, bu seçenek yalnızca X en yüksek notları barındıracaktır. X bu seçenek için seçilmiş değerdir.';
$string['keephighestvalues'] = '{$a} en yüksek değerleri tutun';
$string['keymanager'] = 'Anahtar yöneticisi';
$string['lessthanmin'] = '{$a->itemname} ve {$a->username} için girilen not izin verilen asgari değerin altındadır.';
$string['letter'] = 'Harf';
$string['lettergrade'] = 'Harf notu';
$string['lettergradenonnumber'] = 'Düşük ve/veya Yüksek not için sayısal olmayan değer';
$string['letterpercentage'] = 'Harf(yüzde)';
$string['letterreal'] = 'Harf(gerçek)';
$string['letters'] = 'Harfler';
$string['linkedactivity'] = 'Bağlantılı etkinlik';
$string['linkedactivity_help'] = 'Bu ayar, bu hedefin bağlı olduğu bir etkinliğe işaret eder.  Bu, etkinlikde  not ile değerlendirilmeyen kriterlerde öğrenci performansını ölçmek için kullanılabilir.';
$string['linktoactivity'] = '{$a->name} etkinlik {$a->title}';
$string['lock'] = 'Kilitle';
$string['locked'] = 'Kilitli';
$string['locked_help'] = 'İşaretlenmişse, notlar artık ilgili etkinlikle otomatik olarak güncellenemez.';
$string['locktime'] = 'Bundan sonra kilitli';
$string['locktimedate'] = 'Bundan sonra kilitlli: {$a}';
$string['lockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} kilitle';
$string['lowest'] = 'En düşük';
$string['lowgradeletter'] = 'Düşük';
$string['manageoutcomes'] = 'Kazanımları yönet';
$string['manualitem'] = 'Elle ayarlanan öge';
$string['mapfrom'] = 'Eşleştirmeler';
$string['mapfrom_help'] = 'Kullanıcıyı tanımlamak için kullanıcı adı, kullanıcı kimliği veya e-posta adresi gibi verileri içeren e-tablodaki sütunu seçin.';
$string['mappings'] = 'Not ögesi eşleştirmeleri';
$string['mappings_help'] = 'Elektronik tablodaki her bir nota sütununda notları içe aktarmak için ilgili notu seçin.';
$string['mapto'] = 'Eşleştir';
$string['mapto_help'] = '\'Harita\' için seçilenle aynı tanımlayıcı verileri seçin.';
$string['max'] = 'En yüksek';
$string['maxgrade'] = 'En yüksek not';
$string['meanall'] = 'Tüm notlar';
$string['meangraded'] = 'Boş olmayan notlar';
$string['meanselection'] = 'Sütun ortalamaları için seçilen notlar';
$string['meanselection_help'] = 'Her bir sütunun ortalaması hesaplanırken notların olmadığı hücreler dahil edilmeli mi?';
$string['median'] = 'Ortanca';
$string['min'] = 'En düşük';
$string['minimum_show'] = 'Endüşük notu göster';
$string['minimum_show_help'] = 'Not ve ağırlıkların hesaplanmasında en düşük not kullanılır. Gösterilmemişse, Endüşük not sıfır olarak varsayılır ve düzenlenemez.';
$string['minmaxtouse'] = 'Hesaplamada kullanılan Endüşük ve Enyüksek notlar';
$string['minmaxtouse_desc'] = 'Bu ayar, not defterinde görüntülenen not hesaplarken notun verildiği andan itibaren endüşük ve en yüksek notların mı yoksa not öğesi ayarlarında belirlenen en düşük ve en yüksek notların mı kullanılacağını belirler. Tüm notlar yeniden hesaplanacağı ve yüksek sunucu yüküne neden olabileceği için bu ayarın youğunluğun az olduğu bir zamanda değiştirilmesi önerilir.';
$string['minmaxtouse_help'] = 'Bu ayar, not defterinde görüntülenen notu hesaplamasında notun ilk verildiği andaki  en düşük ve en yüksek notların mı yoksa not öğesinin ayarlarında belirtilen endüşük ve en yüksek notların mı kullanılacağını belirler.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Not: Görüntülenen notu hesaplarken kullanılan minimum ve maksimum notların bir değişikliğinden kaynaklanan not defterindeki tutarsızlığı gidermek için bazı notlar değiştirilmiştir. Değişikliklerin incelenmesi ve kabul edilmesi önerilir.';
$string['minmaxupgradefixbutton'] = 'Tutarsızlıkları çözme';
$string['minmaxupgradewarning'] = 'Not: Not defterinde görüntülenen notun hesaplanmasında kullanılan minimum ve maksimum notların bir değişikliğinden dolayı bazı notlarda tutarsızlık tespit edilmiştir. Tutarsızlığın aşağıdaki düğmeyi tıklayarak çözülmesi önerilir, ancak bu durum bazı notların değişmesine neden olacaktır.';
$string['missingitemtypeoreid'] = 'Dizi anahtarı (itemtype veya eid) eksik';
$string['missingscale'] = 'Ölçek seçilmeli';
$string['mode'] = 'Mod';
$string['modgrade'] = 'Not';
$string['modgrade_help'] = 'Bu etkinlik için kullanılan puanlama türünü seçin. "Ölçek" seçilirse, daha sonra "ölçek" açılır menüsünden ölçeği seçebilirsiniz. "Nokta" puanlamasını kullanıyorsanız, daha sonra bu etkinlik için mevcut olan en yüksek notu girebilirsiniz.';
$string['modgradecantchangegradetype'] = 'Türünü değiştiremezsiniz. Çünkü bu öge için zaten notlar mevcut.';
$string['modgradecantchangegradetypemsg'] = 'Bazı notlar zaten verilmiş olması nedeniyle not tipi değiştirilemez. Eğer enyüksek notu değiştirmek isterseniz, öncelikle mevcut notları tekrar ölçeklendirip artırmamaya karar vermelisiniz.';
$string['modgradecantchangegradetyporscalemsg'] = 'Bazı notlar zaten verilmiştir, bu nedenle not türü ve ölçeği değiştirilemez.';
$string['modgradecantchangeratingmaxgrade'] = 'Değerlendirme özelliğine sahip bir etkinlik de not verilmişse, enyüksek notu değiştiremezsiniz.';
$string['modgradecantchangescale'] = 'Ölçeği değiştiremezsiniz. Çünkü bu öge için zaten notlar mevcut.';
$string['modgradecategorycantchangegradetypemsg'] = 'Bu kategorinin geçersiz kılınmış not ögeleri vardır. Bu nedenle, bazı notlara zaten verildiğinden, not türü değiştirilemez. Eğer enyüksek notu değiştirmek isterseniz, öncelikle mevcut notları tekrar ölçeklendirip artırmamaya karar vermelisiniz.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Bu kategorinin geçersiz kılınmış not ögeleri vardır. Bu nedenle, bazı notlara zaten verilmiş olması nedeniyle, not türü ve ölçeği değiştirilemez.';
$string['modgradecategoryrescalegrades'] = 'Geçersiz kılınan notları yeniden ölçeklendir';
$string['modgradecategoryrescalegrades_help'] = 'Bir not defteri öğesindeki maksimum notları değiştirirken, bunun mevcut yüzde notlarının da değişmesine neden olup olmayacağını belirtmeniz gerekir.

Bu seçenek \'Evet\' olarak ayarlanırsa, mevcut geçersiz kılınmış notlar, yüzde notu aynı kalacak şekilde yeniden ölçeklendirilir.

Örneğin, bu seçenek \'Evet\' olarak ayarlanırsa, bir öğenin maksimum notunun 10\'dan 20\'ye değiştirilmesi, 6/10 (%60) olan bir notun 12/20 (%60) olarak yeniden ölçeklendirilmesine neden olur. Bu seçenek \'Hayır\' olarak ayarlandığında, not değişmeden kalır ve doğru puanları sağlamak için not öğelerinin manuel olarak ayarlanması gerekir.';
$string['modgradedonotmodify'] = 'Mevcut notları değiştirmeyin';
$string['modgradeerrorbadpoint'] = 'Geçersiz not değeri. Bu, 1 ile {$a} arasında bir tamsayı olmalıdır';
$string['modgradeerrorbadscale'] = 'Geçersiz ölçek seçildi. Lütfen aşağıdaki seçimlerden bir ölçek seçtiğinizden emin olun.';
$string['modgrademaxgrade'] = 'Enyüksek not';
$string['modgraderescalegrades'] = 'Mevcut notları yeniden ölçeklendir';
$string['modgraderescalegrades_help'] = 'Bir not defteri öğesindeki maksimum notları değiştirirken, bunun mevcut yüzde notlarının da değişmesine neden olup olmayacağını belirtmeniz gerekir.

Bu seçenek \'Evet\' olarak ayarlanırsa mevcut tüm notlar, yüzde notu aynı kalacak şekilde yeniden ölçeklendirilir.

Örneğin, bu seçenek \'Evet\' olarak ayarlanırsa, bir öğenin maksimum notunun 10\'dan 20\'ye değiştirilmesi, 6/10 (%60) olan bir notun 12/20 (%60) olarak yeniden ölçeklendirilmesine neden olur. Bu seçenek \'Hayır\' olarak ayarlandığında, not 6/10\'dan (%60) 6/20\'ye (%30) değişecek ve doğru puanları sağlamak için not öğelerinin manuel olarak ayarlanması gerekecektir.';
$string['modgradetype'] = 'Tür';
$string['modgradetypenone'] = 'Yok';
$string['modgradetypepoint'] = 'Puan';
$string['modgradetypescale'] = 'Ölçek';
$string['morethanmax'] = '{$a->username} için girilen {$a->itemname} not u izin verilenden daha büyüktür';
$string['moveselectedto'] = 'Seçilen öğeleri şuraya taşı:';
$string['movesitems'] = 'Öğeleri taşı';
$string['movingelement'] = '{$a} taşınıyor';
$string['multfactor'] = 'Çarpan';
$string['multfactor_help'] = 'Çarpan, bu not ögesi için tüm notların, en yüksek notun  değeri ile çarpılacağı faktördür.  Örneğin çarpan 2 ve en yüksek not 100 ise 50\'den küçük notlar 2 ile çarpılır ve 50 ve üzeri notlar 100 olarak değiştirilir.';
$string['multfactorvalue'] = '{$a} için çarpan değeri';
$string['mustchooserescaleyesorno'] = 'Mevcut notların yeniden ölçeklendirilip arttırılmayacağını seçmelisiniz.';
$string['mygrades'] = 'Kullanıcı menüsü notlar bağlantısı';
$string['mygrades_desc'] = 'Bu ayar, kullanıcı menüsünden harici not defterine bağlanma seçeneğine izin verir.';
$string['mypreferences'] = 'Tercihlerim';
$string['myreportpreferences'] = 'Rapor tercihlerim';
$string['myself'] = 'Kendim';
$string['navmethod'] = 'Gezinme yöntemi';
$string['neverdeletehistory'] = 'geçmişi hiçbir zaman silme';
$string['newcategory'] = 'Yeni kategori';
$string['newitem'] = 'Yeni not öğesi';
$string['newoutcomeitem'] = 'Yeni hedef öğesi';
$string['no'] = 'Hayır';
$string['nocategories'] = 'Bu kurs için not kategorisi eklenemedi veya bulunamadı';
$string['nocategoryname'] = 'Kategori adı girilmedi.';
$string['nocategoryview'] = 'Görülebilecek kategori yok';
$string['nocourses'] = 'Henüz kurs yok';
$string['noexistingoutcomes'] = 'Herhangi bir kazanım yok';
$string['noexistingscales'] = 'Herhangi bir ölçek yok';
$string['noforce'] = 'Zorunlu değil';
$string['nogradeletters'] = 'Harf Notu ayarlanmadı';
$string['nogradesreturned'] = 'Hiç not yok';
$string['noidnumber'] = 'ID numarası yok';
$string['nolettergrade'] = 'Harf notu yok';
$string['nomode'] = 'YOK';
$string['nonnumericweight'] = 'Sayısal olmayan değer alındı';
$string['nonunhideableverbose'] = 'Bu notun gizliliğini kaldırmak için {$a->itemname} öğesinin gizliliğini kaldırmanız gerekir.';
$string['nonunlockableverbose'] = 'Bu notun kilidini açmak için {$a->itemname} kilidini açmanız gerekir.';
$string['nonweightedpct'] = 'Ağırlıksız %';
$string['nooutcome'] = 'Kazanım yok';
$string['nooutcomes'] = 'Kazanım öğeleri bir kurs kazanımıyla bağlantılı olmalıdır, ancak bu kurs için herhangi bir kazanım yoktur. Bir tane eklemek ister misiniz?';
$string['nopermissiontoresetweights'] = 'Ağırlıkları sıfırlamak için izniniz yok';
$string['nopublish'] = 'Yayınlama';
$string['noreports'] = 'Bu sitede kayıtlı değilsin, herhangi bir kursa da kayıt olmadın.';
$string['norolesdefined'] = 'Yönetim > Notlar > Genel ayarlar > Aşamalı roller için tanımlanmış rol yok';
$string['noscales'] = 'Kazanımlar bir kurs ölçeğine ya da genel ölçeğe bağlı olmalıdır, ancak mevcutta hiç yok. Bir tane eklemek ister misiniz?';
$string['noselectedcategories'] = 'kategoriler seçilmedi.';
$string['noselecteditems'] = 'ögeler seçilmedi.';
$string['notenrolled'] = 'Şu anda herhangi bir kursa kayıtlı değilsiniz.';
$string['notteachererror'] = 'Bu özelliği kullanmak için eğitimci olmalısınız.';
$string['nousersloaded'] = 'Kullanıcılar yüklenemedi';
$string['nouserstograde'] = 'Not verilecek öğrenci yok';
$string['numberofgrades'] = 'Not sayısı';
$string['onascaleof'] = '{$a->grademin} ölçeğinin {$a->grademax} a';
$string['operations'] = 'İşlemler';
$string['options'] = 'Seçenekler';
$string['others'] = 'Diğerleri';
$string['otheruser'] = 'Kullanıcı';
$string['outcome'] = 'Kazanım';
$string['outcome_help'] = 'Bu ayar, bu not öğesinin not defterinde temsil edeceği sonucu belirler.';
$string['outcomeassigntocourse'] = 'Bu kursa başka bir kazanım daha atayın';
$string['outcomecategory'] = 'Kategoride kazanım oluştur';
$string['outcomecategorynew'] = 'Yeni kategori';
$string['outcomeconfirmdelete'] = '"{$a}" kazanımını silmek istediğinizden emin misiniz?';
$string['outcomecreate'] = 'Yeni kazanım ekle';
$string['outcomedelete'] = 'Kazanım sil';
$string['outcomefullname'] = 'Tam adı';
$string['outcomeitem'] = 'Kazanım ögesi';
$string['outcomeitemsedit'] = 'Kazanım ögesi düzenle';
$string['outcomereport'] = 'Kazanım raporu';
$string['outcomes'] = 'Kazanımlar';
$string['outcomescourse'] = 'Kursta kullanılan kazanımlar';
$string['outcomescoursecustom'] = 'Özel kullanıldı (silme yok)';
$string['outcomescoursenotused'] = 'Standart kullanılmadı';
$string['outcomescourseused'] = 'Standart kullanıldı (silme yok)';
$string['outcomescustom'] = 'Özel kazanımlar';
$string['outcomesdisabled'] = 'Kazanımlar ekinleştirilmemiş';
$string['outcomeshortname'] = 'Kısa ad';
$string['outcomesstandard'] = 'Standart kazanımlar';
$string['outcomesstandardavailable'] = 'Kullanılabilir standart kazanımlar';
$string['outcomestandard'] = 'Standart kazanrım';
$string['outcomestandard_help'] = 'Tüm kurslar için site genelinde standart bir kazanım mevcuttur.';
$string['overallaverage'] = 'Genel ortalama';
$string['overridden'] = 'Geçersiz kılınmıştır.';
$string['overridden_help'] = 'İşaretlenirse, not artık ilgili etkinlik içinden değiştirilemez.

Değerlendici raporunda bir not düzenlendiğinde, geçersiz kılınan onay kutusu otomatik olarak işaretlenir. Ancak notun ilgili etkinlik aracılığıyla değiştirilmesine izin vermek için işaret kaldırılabilir.';
$string['overriddennotice'] = 'Bu etkinlikteki final notunuz, elle ayarlandı.';
$string['overridecat'] = 'Kategori notlarının elle geçersiz kılmasına izin ver';
$string['overridecat_help'] = 'Bu ayarı devre dışı bırakmak kullanıcıların kategori notlarını geçersiz kılmasını imkansız hale getirir.';
$string['overridesitedefaultgradedisplaytype'] = 'Site varsayılanlarını yoksay';
$string['overridesitedefaultgradedisplaytype_help'] = 'İşaretlenirse, site varsayılanlarını kullanmak yerine kurs için not harfleri ve sınırları belirlenebilir.';
$string['overrideweightofa'] = '{$a} ağırlığının üzerine yaz';
$string['parentcategory'] = 'Ana kategori';
$string['pass'] = 'Geç';
$string['pctoftotalgrade'] = 'toplam notların %';
$string['percent'] = 'Yüzde';
$string['percentage'] = 'Yüzde';
$string['percentageletter'] = 'Yüzde (harf)';
$string['percentagereal'] = 'Yüzde (gerçek)';
$string['percentascending'] = 'Yüzde (artan sıralama)';
$string['percentdescending'] = 'Yüzde (azalan sıralama)';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Bağıl konum';
$string['plusfactor_help'] = 'Ofset, çarpan uygulandıktan sonra bu not ögesi için her nota eklenen bir sayıdır.';
$string['plusfactorvalue'] = '{$a} için ofset değeri';
$string['points'] = 'puanlar';
$string['pointsascending'] = 'Puana göre artan şekilde sırala';
$string['pointsdescending'] = 'Puana göre azalan şekilde sırala';
$string['positionfirst'] = 'İlk';
$string['positionlast'] = 'Son';
$string['preferences'] = 'Seçenekler';
$string['prefgeneral'] = 'Genel';
$string['prefletters'] = 'Harf Notlu ve aralıkları';
$string['prefrows'] = 'Özel sütunlar';
$string['prefshow'] = 'Göster/gizle geçiş anahtarları';
$string['previewrows'] = 'Ön izleme sıraları';
$string['privacy:metadata:categorieshistory'] = 'Not kategorilerinin önceki sürümlerinin kaydı';
$string['privacy:metadata:filepurpose'] = 'Bir kullanıcı için not defterinde saklanan geri bildirim dosyaları.';
$string['privacy:metadata:grade_import_newitem'] = 'Not içe aktarma işleminden yeni not_ögesi adlarını depolamak için geçici tablo';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Not içe aktarma işleminden yeni not_ögesi adlarını depolamak için geçici tablo';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Bir içe aktarma grubunu tanımlamak için benzersiz bir toplu iş kodu';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Yeni not ögesi adı';
$string['privacy:metadata:grade_import_values'] = 'Notları içe aktarmak için geçici tablo';
$string['privacy:metadata:grade_import_values:feedback'] = 'Not geriblidirimi';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Ham puan değeri';
$string['privacy:metadata:grade_import_values:importcode'] = 'Bir içe aktarma grubunu tanımlamak için benzersiz bir toplu iş kodu';
$string['privacy:metadata:grade_import_values:importer'] = 'Verileri içe aktaran kullanıcı';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Yalnızca geri bildirim içe aktarılmışsa işaretleyin';
$string['privacy:metadata:grade_import_values:userid'] = 'Notu içe aktarılan kullanıcı';
$string['privacy:metadata:grades'] = 'Not kaydı';
$string['privacy:metadata:grades:aggregationstatus'] = 'Toplama (icmal) durumu';
$string['privacy:metadata:grades:aggregationweight'] = 'Toplamadaki ağırlık';
$string['privacy:metadata:grades:feedback'] = 'Geri bildirim';
$string['privacy:metadata:grades:finalgrade'] = 'Not';
$string['privacy:metadata:grades:information'] = 'Not hakkında ek bilgi';
$string['privacy:metadata:grades:timemodified'] = 'Notun en son değiştirildiği zaman';
$string['privacy:metadata:grades:userid'] = 'Notu olan kullanıcının kimliği';
$string['privacy:metadata:grades:usermodified'] = 'Kaydı en son değiştiren kullanıcının kimliği';
$string['privacy:metadata:gradeshistory'] = 'Önceki notların kaydı';
$string['privacy:metadata:history:loggeduser'] = 'Sürüm oluşturma gerçekleştiğinde oturum açmış olan kullanıcının kimliği';
$string['privacy:metadata:history:timemodified'] = 'Not sürümlendirmenin gerçekleştiği zaman';
$string['privacy:metadata:itemshistory'] = 'Not öğelerinin önceki sürümlerinin kaydı';
$string['privacy:metadata:outcomes'] = 'Kazanım kaydı';
$string['privacy:metadata:outcomes:timemodified'] = 'Kaydın değiştirildiği zaman';
$string['privacy:metadata:outcomes:usermodified'] = 'Kaydı en son değiştiren kullanıcı';
$string['privacy:metadata:outcomeshistory'] = 'Kazanımların önceki sürümlerinin bir kaydı';
$string['privacy:metadata:scale'] = 'Ölçeklerin kaydı';
$string['privacy:metadata:scale:timemodified'] = 'Kaydın en son değiştirildiği zaman';
$string['privacy:metadata:scale:userid'] = 'Kaydı en son değiştiren kullanıcı';
$string['privacy:metadata:scalehistory'] = 'Ölçeklerin önceki sürümlerinin kaydı';
$string['privacy:path:relatedtome'] = 'Benimle ilişkilili olanlar';
$string['privacy:request:historyactiondelete'] = 'Sil';
$string['privacy:request:historyactioninsert'] = 'Ekle';
$string['privacy:request:historyactionupdate'] = 'Güncelle';
$string['privacy:request:unknowndeletedgradeitem'] = 'Bilinmiyor (not öğesi silindi)';
$string['profilereport'] = 'Kullanıcı profili raporu';
$string['profilereport_help'] = 'Kullanıcı profil sayfasında kullanılan puanlama raporu.';
$string['publishing'] = 'Yayın';
$string['publishingoptions'] = 'Not yayınlama seçenekleri';
$string['quickfeedback'] = 'Hızlı geribildirim';
$string['quickgrading'] = 'Hızlı puanlama';
$string['quickgrading_help'] = 'Etkinleştirildiğinde, düzenleme açıldığında, her not için bir metin giriş kutusu görünür ve aynı anda birçok notun düzenlenmesine izin verir. Güncelleme düğmesi tıklandığında değişiklikler kaydedilir ve vurgulanır.

Bir not, not verme raporunda düzenlendiğinde, geçersiz kılınmış bir bayrak ayarlanır, yani notun, ilgili faaliyetin içinden değiştirilemeyeceği anlamına gelir.';
$string['range'] = 'Aralık';
$string['rangedecimals'] = 'Ondalık nokta aralığı';
$string['rangedecimals_help'] = 'Aralık için görüntülenecek ondalık nokta sayısı.';
$string['rangesdecimalpoints'] = 'Aralıklarda gösterilen ondalık sayılar';
$string['rangesdecimalpoints_help'] = 'Bu ayar, her aralık için görüntülenecek ondalık basamak sayısını veya kategori ya da not öğesi için genel ondalık basamak ayarının kullanılıp kullanılmayacağını belirler (devralma).';
$string['rangesdisplaytype'] = 'Alarlık görünüm türü';
$string['rangesdisplaytype_help'] = 'Bu ayar, aralığın gerçek notlar, yüzdeler veya harfler olarak gösterilip gösterilmeyeceğini veya kategori veya not öğesinin görüntüleme türünün kullanılıp kullanılmayacağını belirtir (devralır).';
$string['rank'] = 'sıra';
$string['rawpct'] = 'Ham %';
$string['real'] = 'Gerçek';
$string['realletter'] = 'Gerçek (harf)';
$string['realpercentage'] = 'Gerçek (yüzde)';
$string['recalculatinggrades'] = 'Notları tekrar hesapla';
$string['recovergradesdefault'] = 'Varsayılan notu kurtar';
$string['recovergradesdefault_help'] = 'Varsayılan olarak, bir kullanıcıyı bir derste yeniden kaydederken eski notları kurtarabilirsiniz.';
$string['refreshpreview'] = 'Önizlemeyi yenile';
$string['regradeanyway'] = 'Her durumda yeniden not vermeyi seçin';
$string['removeallcoursegrades'] = 'Tüm notları sil';
$string['removeallcoursegrades_help'] = 'İşaretlendiğinde, not defterine el ile eklenen tüm not öğeleri, geçersiz kılınan, hariç tutulan, gizli ve kilitli notlarla ilgili notlar ve verilerle birlikte silinir. Yalnızca etkinliklerle ilişkili not öğeleri kalacaktır.';
$string['removeallcourseitems'] = 'Tüm ögeleri ve kategorileri sil';
$string['removeallcourseitems_help'] = 'İşaretlendiğinde, not defterine el ile eklenen tüm kategoriler ve not öğeleri, geçersiz kılınan, hariç tutulan, gizli ve kilitli notlarla ilgili notlar ve verilerle birlikte silinir. Yalnızca faaliyetlerle ilişkili sınıf öğeleri kalacaktır.';
$string['report'] = 'Rapor';
$string['reportdefault'] = 'Rapor varsayılanı ({$a})';
$string['reportplugins'] = 'Rapor eklentileri';
$string['reportsettings'] = 'Rapor ayarları';
$string['reprintheaders'] = 'Başlıkları tekrar yazdır';
$string['resetweights'] = '{$a->itemname} ağırlığını sıfırlama';
$string['resetweightsshort'] = 'Ağırlıkları sıfırla';
$string['respectingcurrentdata'] = 'şimdiki yapılandırma değişmemiş olarak bırakılıyor';
$string['rowpreviewnum'] = 'Sıraları ön izleyin';
$string['rowpreviewnum_help'] = 'İçe aktarma işlemini onaylamadan önce içe aktarılabilen veriler önizlenebilir. Bu ayar, önizlemede kaç satır görüntüleneceğini belirler.';
$string['savechanges'] = 'Değişiklikleri kaydet';
$string['savepreferences'] = 'Seçenekleri kaydet';
$string['scaleconfirmdelete'] = '"{$a}" ölçeğini silmek istediğinizden emin misiniz?';
$string['scaledpct'] = 'Oran %';
$string['searchcollapsedcolumns'] = 'Daraltılmış sütunları ara';
$string['seeallcoursegrades'] = 'Tüm kurs notlarına bak';
$string['select'] = '{$a} seç';
$string['selectalloroneuser'] = 'Tümünü ya da bir kullanıcıyı seçin';
$string['selectauser'] = 'Bir kullanıcı seçin';
$string['selectdestination'] = '{$a} hedefini seçin';
$string['selectgrouplink'] = 'Bir grup seç';
$string['selectuserlink'] = 'Bir kullanıcı seç';
$string['separator'] = 'Ayraç';
$string['separator_help'] = 'CSV dosyasında kullanılan ayırıcıyı seçin. (Normalde virgül.)';
$string['sepcolon'] = 'İki nokta üst üste';
$string['sepcomma'] = 'Virgül';
$string['sepsemicolon'] = 'Noktalı virgül';
$string['septab'] = 'Sekme';
$string['setcategories'] = 'Kategorileri ayarla';
$string['setcategorieserror'] = 'Ağırlık vermeden önce dersinizin kategorisini belirlemeniz gerekir.';
$string['setgradeletters'] = 'Harf notlarını ayarla';
$string['setpreferences'] = 'Seçenekleri ayarla';
$string['setting'] = 'Ayar';
$string['settings'] = 'Ayarlar';
$string['setup'] = 'Kurulum';
$string['setweights'] = 'Ağırlıkları ayarla';
$string['showactivityicons'] = 'Etkinlik simgelerini göster';
$string['showactivityicons_help'] = 'Etkinlik adları yanında etkinlik ikonları gösterilsin mi?';
$string['showallgrades'] = 'Tüm notları göster';
$string['showallhidden'] = 'Gizlileri göster';
$string['showallstudents'] = 'Tüm öğrencileri göster';
$string['showanalysisicon'] = 'Not analiz simgesini göster';
$string['showanalysisicon_desc'] = 'Varsayılan olarak not analizi simgesi gösterilip gösterilmeyeceği. Etkinlik modülü destekliyorsa, not analizi simgesi, notun daha ayrıntılı bir açıklaması ve nasıl elde edildiği ile ilgili bir sayfaya bağlar.';
$string['showanalysisicon_help'] = 'Etkinlik modülü destekliyorsa, not analizi simgesi, notun daha ayrıntılı bir açıklaması ve nasıl elde edildiği ile ilgili bir sayfaya bağlar.';
$string['showaverage'] = 'Ortalamayı göster';
$string['showaverage_help'] = 'Ortalama bir sütun gösterilip gösterilmeyeceği. Ortalama, az sayıda not üzerinden hesaplanırsa, katılımcıların başkalarının notlarını tahmin edebileceğini unutmayın. Performans nedenleriyle ortalama, gizli öğelere bağımlıysa yaklaşık değerdir.';
$string['showaverages'] = 'Sütun ortalamalarını göster';
$string['showaverages_help'] = 'Her bir sütun için ortalama gösterilsin mi?';
$string['showcalculations'] = 'Hesaplamaları göster';
$string['showcalculations_help'] = 'Etkinleştirilirse düzenleme sırasında her not öğesi ve kategori için bir hesap makinesi simgesi gösterilerek bir not öğesinin hesaplandığına dair görsel bir gösterge sağlanır.';
$string['showcontributiontocoursetotal'] = 'Kursun toplamına katkıyı göster';
$string['showcontributiontocoursetotal_help'] = 'Yüzdelik bir sütun gösterip göstermeyeceğini belirtir
Her not öğesinin kullanıcının kurs toplam yüzdesine ne kadar katkıda bulunduğunu (ağırlıklandırma uygulandıktan sonra).';
$string['showeyecons'] = 'Göster/gizle simgelerini göster';
$string['showeyecons_help'] = 'Her bir notun yakınında göster/sakla simgesi gösterilsin mi (kullanıcıya olan görünürlüğünü denetleyerek)';
$string['showfeedback'] = 'Geri bildirimi göster';
$string['showfeedback_help'] = 'Geri bildirim için bir sütun gösterip göstermeyeceğiniz.';
$string['showgrade'] = 'Notları göster';
$string['showgrade_help'] = 'Notlar için bir sütun gösterip göstermeyeceğiniz.';
$string['showgroups'] = 'Grupları göster';
$string['showhiddenitems'] = 'Gizli ögeleri göster';
$string['showhiddenitems_help'] = 'Gizli not öğelerinin tamamen gizlenip gizlenmediği veya gizli not öğelerinin adlarının öğrenciler tarafından görülüp görülmediği.

* Gizli göster - Gizli not öğe adları gösterilir ancak öğrenci notları gizlenir
* Yalnızca şu tarihe kadar gizli: - "Gizleme bitişi" tarih ayarına sahip not öğeleri, ayarlanan tarihe kadar tamamen gizlenir ve bu tarihten sonra tüm öğe gösterilir
* Gösterme - Gizli sınıf öğeleri tamamen gizlenir';
$string['showhiddenuntilonly'] = 'Yalnızca -e kadar gizli';
$string['showingaggregatesonly'] = 'Sadece toplamlar gösteriliyor';
$string['showingfullmode'] = 'Notlar ve toplamlar gösteriliyor';
$string['showinggradesonly'] = 'Sadece notlar göster';
$string['showlettergrade'] = 'Harf notlarını göster';
$string['showlettergrade_help'] = 'Harf notları için bir sütun gösterip göstermeyeceğiniz.';
$string['showlocks'] = 'Kilitleri göster';
$string['showlocks_help'] = 'Her bir notun yakınında kilitleme/kilidi açma simgesi gösterilsin mi';
$string['shownohidden'] = 'Gösterme';
$string['shownooutcomes'] = 'Kazanımları gizle';
$string['shownumberofgrades'] = 'Ortalamalardaki not sayılarını gösterin';
$string['shownumberofgrades_help'] = 'Her bir ortalamanın ardından parantez içi ortalaması hesaplanırken kullanılan notların adeti gösterilsin mi, örneğin 45 (34).';
$string['showonlyactiveenrol'] = 'Yalnızca etkin kayıtları göster';
$string['showonlyactiveenrol_help'] = 'Bu ayar, kayıtlı kayıtlı kullanıcılar yalnızca not defteri raporunda görünürse, belirler. Etkinleştirildiğinde, askıya alınmış kullanıcılar not defterinde gösterilmeyecektir.';
$string['showpercentage'] = 'Yüzdeyi gösterin';
$string['showpercentage_help'] = 'Her bir not öğesinin yüzde değeri gösterilsin mi';
$string['showquickfeedback'] = 'Hızlı geribildirim gösterin';
$string['showquickfeedback_help'] = 'Etkinleştirilirse, düzenleme açıldığında her not için kesikli kenarlığa sahip bir geri bildirim metin giriş kutusu görünür ve birçok not için geri bildirimin aynı anda düzenlenmesine olanak tanır. Güncelle düğmesine tıklandığında değişiklikler kaydedilir ve vurgulanır.

Not veren raporunda geri bildirim düzenlendiğinde bir geçersiz kılma bayrağının ayarlandığını, yani geri bildirimin artık ilgili faaliyet içinden değiştirilemeyeceğini unutmayın.';
$string['showrange'] = 'Aralıkları göster';
$string['showrange_help'] = 'Aralık için bir sütun gösterip göstermeyeceğiniz.';
$string['showranges'] = 'Aralıkları göster';
$string['showranges_help'] = 'Ek bir sıra üzerindeki her bir sütun için not erimi gösterilsin mi';
$string['showrank'] = 'Puanı göster';
$string['showrank_help'] = 'Her bir not öğesi için sınıfın geri kalanı ile ilişkili olarak kullanıcı pozisyonu gösterilsin mi';
$string['showuserimage'] = 'Kullanı profil resimlerini göster';
$string['showuserimage_help'] = 'Not raporundaki ismin yanında kullanıcı profili görüntüsü gösterilsin mi';
$string['showverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname}\'yi göster';
$string['showweight'] = 'Ağırlıkları göster';
$string['showweight_help'] = 'Not ağırlığı için bir sütun gösterip göstermeyeceğiniz.';
$string['simpleview'] = 'Tek görünüm';
$string['sitewide'] = 'Site-geneli';
$string['sort'] = 'sırala';
$string['sortasc'] = 'Sırala (artan)';
$string['sortbyfirstname'] = 'Ada göre sırala';
$string['sortbylastname'] = 'Soyada göre sırala';
$string['sortdesc'] = 'Sırala (azalan)';
$string['standarddeviation'] = 'Standart sapma';
$string['stats'] = 'İstatistikler';
$string['statslink'] = 'İstatistikler';
$string['student'] = 'Öğrenci';
$string['studentsperpage'] = 'Sayfa başına öğrenci sayısı';
$string['studentsperpage_help'] = 'Not raporunda her bir sayfa içn öğrenci sayısı görüntülensin mi';
$string['studentsperpagereduced'] = 'Sayfa başına düşen enyüksek öğrenci sayısı {$a->originalstudentsperpageı} \'dan {$a-> studentsperpage} düzeyine düşürüldü. PHP ayar max_input_vars değerini {$a->maxinputvars} değerinden artırmayı düşünün.';
$string['subcategory'] = 'Normal kategori';
$string['submissions'] = 'Gönderimler';
$string['submittedon'] = 'Gönderildi: {$a}';
$string['sumofgradesupgradedgrades'] = 'Not: Toplama yöntemi "Notların toplamı", site güncellemesinin bir parçası olarak "Doğal" olarak değiştirilmiştir. Bu kursdoa daha önce "Toplam notların toplamı" kullanıldığı için not defterindeki bu değişikliği gözden geçirmeniz önerilir.';
$string['switchtofullview'] = 'Tam görünüme geçiş yap';
$string['switchtosimpleview'] = 'Basit görünüme geçiş yap';
$string['tabs'] = 'Sekmeler';
$string['topcategory'] = 'En üst kategori';
$string['total'] = 'Toplam';
$string['totalweight100'] = 'Toplam ağırlık 100\'e eşittir';
$string['totalweightnot100'] = 'Toplam ağırlık 100\'e eşit değildir';
$string['turnfeedbackoff'] = 'Geri bildirimi kapat';
$string['turnfeedbackon'] = 'Geri bildirimi etkinleştir';
$string['typenone'] = 'Hiçbiri';
$string['typescale'] = 'Ölçek';
$string['typescale_help'] = 'Bu ayar, ölçek notu türünü kullanırken kullanılan ölçeği belirler. Bir etkinliğe dayalı not öğesinin ölçeği, etkinlik ayarları sayfasında ayarlanır.';
$string['typetext'] = 'Metin';
$string['typevalue'] = 'Değer';
$string['uncategorised'] = 'Kategorilendirilmemiş';
$string['unchangedgrade'] = 'Değişmemiş not';
$string['unenrolledusersinimport'] = 'Bu içe aktarma, şu anda bu kursa kayıtlı olmayan kullanıcılar için aşağıdaki notları içeriyordu: {$a}';
$string['unlimitedgrades'] = 'Sınırsız not';
$string['unlimitedgrades_help'] = 'Varsayılan olarak, puanlama not öğesinin endüşük ve enyüksek değerleri ile sınırlanır. Bu ayarın etkinleştirilmesi bu sınırı kaldırır ve doğrudan not defterine  %100\'den fazla not girilmesine izin verir.';
$string['unlock'] = 'Kilidi aç';
$string['unlockverbose'] = '{$a->category}$a->itemmodule {$a->itemname} kilidini aç';
$string['unused'] = 'Kullanılmamış';
$string['updatedgradesonly'] = 'Yalnızca yeni ya da güncellenmiş notları dışa verin';
$string['upgradedgradeshidemessage'] = 'Bildirimi reddet';
$string['upgradedminmaxrevertmessage'] = 'Değişiklikleri geri al';
$string['uploadgrades'] = 'Notları yükle';
$string['useadvanced'] = 'Gelişmiş özellikleri kullan';
$string['usedcourses'] = 'Kullanılan kurslar';
$string['usedgradeitem'] = 'Kullanılan ölçek ögesi';
$string['usenooutcome'] = 'Kazanım kullanma';
$string['usenoscale'] = 'Ölçek kullanma';
$string['usepercent'] = 'Yüzde kullan';
$string['user'] = 'Kullanıcı';
$string['userenrolmentsuspended'] = 'Kullanıcı kaydı askıya alındı';
$string['userfields_show'] = 'Kullanıcı alanlarını göster';
$string['userfields_show_help'] = 'Not verme raporunda e-posta adresi gibi ek kullanıcı alanlarını gösterin. Görüntülenen belirli alanlar, site ayarı showuseridentity tarafından kontrol edilir';
$string['usergrade'] = '{$a->gradeidnumber} öğesinde
kullanıcı {$a->fullname} ({$a->useridnumber})';
$string['userid'] = 'Kullanıcı kimliği';
$string['useridnumberwarning'] = 'Kimlik numarası olmayan kullanıcılar, dışa aktarılamadığı için dışa aktarmadan çıkarılır.';
$string['usermappingerror'] = 'Kullanıcı eşleme hatası: {$a->field} ile "{$a->value}" kullanıcısı bulunamadı.';
$string['usermappingerrorcurrentgroup'] = 'Kullanıcı geçerli gruba dahil değil.';
$string['usermappingerrormultipleusersfound'] = 'Kullanıcı eşleme hatası: "{$a->değer}"in {$a->alanı} ile birden çok kullanıcı bulundu.  Lütfen daha benzersiz bir eşleme alanı kullanın.';
$string['usermappingerrorusernotfound'] = 'Kullanıcı eşleme hatası. Kullanıcı bulunamadı.';
$string['userpreferences'] = 'Kullanıcı tercihleri';
$string['useweighted'] = 'Ağırlık kullan';
$string['verbosescales'] = 'Ayrıntılı ölçekler';
$string['verbosescales_help'] = 'Ayrıntılı ölçek, sayılar yerine kelimeler kullanır. Hem sayısal hem de ayrıntılı ölçekler içe aktarılacaksa \'Evet\' olarak ayarlayın. Yalnızca sayısal ölçekler içe aktarılacaksa, \'Hayır\' olarak ayarlayın.';
$string['viewas'] = 'Raporu şu şekilde görüntüleyin';
$string['viewbygroup'] = 'Grup';
$string['viewfeedback'] = 'Geri bildirimi görüntüle';
$string['viewgrades'] = 'Notları Görüntüle';
$string['weight'] = 'Ağırlık';
$string['weight_help'] = 'Bir kategorideki veya kurstaki birden çok notun göreli değerini belirlemek için kullanılan bir değer.';
$string['weightcourse'] = 'Kurs için ağırlıklı not kullan';
$string['weightedascending'] = 'Ağırlıklı yüzde (artan sıralama)';
$string['weighteddescending'] = 'Ağırlıklı yüzde (azalan sıralama)';
$string['weightedpct'] = 'Ağırlıklı %';
$string['weightedpctcontribution'] = 'Ağırlıklı % katılım';
$string['weightofa'] = '{$a} ağırlığı';
$string['weightorextracredit'] = 'Ağırlık veya ek kredi';
$string['weightoverride'] = 'Ağırlık ayarı';
$string['weightoverride_help'] = 'Bir not öğesi ağırlığının otomatik olarak hesaplanan değerine sıfırlanması için işaretini kaldırın. Kontrol edilmesi, ağırlığın otomatik olarak ayarlanmasını önleyecektir.';
$string['weights'] = 'Ağırlıklar';
$string['weightsadjusted'] = 'Ağırlıklarınız toplam 100 olacak şekilde ayarlandı.';
$string['weightsedit'] = 'Ağırlıkları ve ek kredileri düzenle';
$string['weightuc'] = 'Hesaplanan ağırlık';
$string['writinggradebookinfo'] = 'Not Defteri ayarları yazılıyor';
$string['xml'] = 'XML';
$string['yes'] = 'Evet';
$string['yourgrade'] = 'Notunuz';
