<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'et', version '4.3'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Autentimismeetodi logo';
$string['auth_shib_auth_logo_description'] = 'Esita Shibbolethi autentimismeetodi logo, mis on sinu kasutajatele tuttav. See võib olla sinu Shibbolethi föderatsiooni logo, nt. <tt>SWITCHaai Login</tt> or <tt>InCommon Login</tt> või midagi sarnast.';
$string['auth_shib_auth_method'] = 'Autentimisviisi nimi';
$string['auth_shib_auth_method_description'] = 'Sisestage Shibbolethi autentimisviisi nimi, mis on teie kasutajatele tuttav. Selleks võib olla teie Shibbolethi liidu nimi, nt <tt>SWITCHaai Login</tt> või <tt>InCommon Login</tt> või midagi sarnast.';
$string['auth_shib_changepasswordurl'] = 'Parooli muutmise URL';
$string['auth_shib_contact_administrator'] = 'Juhul kui te pole vastavate asutustega seotud ja vajate kursusele juurdepääsu selles serveris, võtke ühendust <a href="mailto:{$a}">Moodle’i administraatoriga</a>.';
$string['auth_shib_convert_data'] = 'Andmete muutmise rakendusliides';
$string['auth_shib_convert_data_description'] = 'Selle rakendusliidese abil saate muuta Shibbolethi hangitavaid andmeid. Üksikasjalikumad juhised leiate <a href="../auth/shibboleth/README.txt" target="_blank">seletusfailist</a>.';
$string['auth_shib_convert_data_warning'] = 'Faili pole olemas või see pole veebiserveri protsessi jaoks loetav.';
$string['auth_shib_idp_list'] = 'Identijad';
$string['auth_shib_idp_list_description'] = 'Sisestage identiteedipakkuja olemi ID-de loend, mille hulgast saab kasutaja sisselogimislehel valiku teha.<br />Igal real peab olema identiteedipakkuja olemi ID komaeraldusega mitmik (vt Shibbolethi metaandmete faili) ja identiteedipakkuja nimi, nagu see ripploendis kuvatakse.<br />Kolmanda valikulise parameetrina saate lisada Shibbolethi seansi algataja asukoha, mida kasutatakse juhul, kui teie Moodle’i installimine on mitmikliidu häälestuse osa.';
$string['auth_shib_instructions'] = 'Kui teie asutus seda toetab, siis Shibbolethi kaudu juurdepääsu saamiseks <a href="{$a}">logige sisse Shibbolethi kaudu</a>.<br />Muul juhul kasutage siin kuvatud tavapärast sisenemisvormi.';
$string['auth_shib_instructions_help'] = 'Siia võiksite kasutajate jaoks sisestada Shibbolethi kasutamise juhised. See kuvatakse sisselogimislehel juhiste jaotises. Juhis peaks sisaldama linki Shibbolethi kaitstud lehele, mis suunab kasutajad ümber lehele "<b>{$a}</b>", nii et Shibbolethi kasutajad saaksid Moodle’isse sisse logida. Kui jätate selle välja tühjaks, siis kasutatakse tavajuhiseid (mitte Shibbolethi-kohaseid).';
$string['auth_shib_instructions_key'] = 'Sisselogimisjuhised';
$string['auth_shib_integrated_wayf'] = 'Moodle’i WAYF-teenus';
$string['auth_shib_integrated_wayf_description'] = 'Selle lubamisel kasutab Moodle oma WAYF-teenust, mitte Shibbolethi jaoks konfigureeritud teenust. Moodle kuvab ripploendi sellel alternatiivsel sisselogimislehel, kus kasutaja peab valima oma identiteedipakkuja.';
$string['auth_shib_logout_return_url'] = 'Alternatiivne väljalogimise tagastus-URL';
$string['auth_shib_logout_return_url_description'] = 'Sisestage URL, kuhu Shibbolethi kasutajad väljalogimise järel suunatakse.<br />Kui see jäetakse tühjaks, suunatakse kasutajad samasse asukohta, kuhu Moodle kasutajad suunab';
$string['auth_shib_logout_url'] = 'Shibboleth teenusepakkuja väljalogimisohjuri URL';
$string['auth_shib_logout_url_description'] = 'Sisestage Shibbolethi teenusepakkuja väljalogimisohjuri URL. See on tavaliselt <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Kui soovite kasutada integreeritud WAYF-teenust, peate sisestama identiteedipakkuja olemi ID-de komaeraldusega loendi, olemi ID-de nimed ja soovi korral seansi algataja.';
$string['auth_shib_only'] = 'Ainult Shibboleth';
$string['auth_shib_only_description'] = 'Märkige see valik, kui soovite jõustada Shibbolethi-põhis autentimise.';
$string['auth_shib_username_description'] = 'Veebiserveri Shibboleth-keskkonna muutuja nimi, mida tuleks kasutada Moodle’i kasutajanimena.';
$string['auth_shibboleth_errormsg'] = 'Valige organisatsioon, mille liige olete';
$string['auth_shibboleth_login'] = 'Shibboleth\'iga sisenemine';
$string['auth_shibboleth_login_long'] = 'Logi Moodle’isse Shibbolethi kaudu';
$string['auth_shibboleth_manual_login'] = 'Käsitsi sisenemine';
$string['auth_shibboleth_select_member'] = 'Ma olen järgnevate liige...';
$string['auth_shibboleth_select_organization'] = 'Shibbolethi kaudu autentimiseks valige rippmenüüst oma organisatsioon:';
$string['auth_shibbolethdescription'] = 'Selle meetodi kasutamisel luuakse ja autenditakse kasutajad <a href="http://shibboleth.internet2.edu/" target="_blank">Shibbolethi</a> abil.<br />Tutvuge kindlasti ka <a href="../auth/shibboleth/README.txt" target="_blank">seletusfailiga</a>, milles selgitatakse, kuidas häälestada Moodle Shibbolethi kasutama.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Shibboleth autentimisplugin ei salvesta isikuandmeid.';
$string['shib_invalid_account_error'] = 'Näib, et olete Shibbolethis autenditud, kuid Moodle’is pole teie kasutajanime jaoks kehtivat kontot. Võimalik, et teie kontot pole olemas või see on peatatud.';
$string['shib_no_attributes_error'] = 'Näib, et olete Shibbolethis autenditud, kuid Moodle ei saanud kasutaja atribuute. Veenduge, et teie identiteedipakkuja väljastaks vajalikud atribuudid ({$a}) Moodle’it käitavale teenusepakkujale või andke veebiülemale sellest serverist teada.';
$string['shib_not_all_attributes_error'] = 'Moodle vajab teatud Shibbolethi atribuute, mida teil pole. Atribuudid on: {$a}<br />Võtke ühendust selle serveri veebiülemaga või oma identiteedipakkujaga.';
$string['shib_not_set_up_error'] = 'Shibbolethi autentimine ei näi olevat õigesti seadistatud, sest sellel lehel pole ühtegi Shibbolethi keskkonnamuutujat. Uurige <a href="README.txt">seletusfaili</a>, kust leiate Shibbolethi autentimise seadistamise üksikasjalikumad juhised, või võtke ühendust selle Moodle’i installi veebiülemaga.';
