<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'et', version '4.3'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Saate kuvada selle õppetesti eelvaate, aga tegeliku testisoorituskatse korral ei saaks te seda testi teha järgmistel põhjustel.';
$string['action'] = 'Toiming';
$string['activityoverview'] = 'Teil on õppeteste, mille tähtaeg on käes';
$string['adaptive'] = 'Adaptiivrežiim';
$string['adaptive_help'] = 'Kui see sisse lülitatud, siis on samas testisoorituskatses lubatud anda küsimusele mitu vastust. Seega näiteks kui vastus on märgitud valeks, on õpilasel lubatud kohe uuesti proovida. Olenevalt sättest „Rakenda trahvid“ võidakse tavaliselt iga vale soorituse korral lahutada tulemusest trahvipunktid.';
$string['add'] = 'Lisa';
$string['addaquestion'] = 'uus küsimus';
$string['addarandomquestion'] = 'juhuslik küsimus';
$string['addarandomquestion_help'] = 'Juhuküsimuse lisamise korral lisatakse sellest kategooriast juhuslikult valitud küsimus õppetesti. See tähendab seda, et õppurid saavad tõenäoliselt erineva küsimuste valiku. Ja kui testi on võimalik teha mitu korda, siis suure tõenäosusega saavad õppurid iga uue testisoorituskatse korral uue küsimuste valiku.';
$string['addarandomselectedquestion'] = 'Lisa juhuslikult valitud küsimus...';
$string['addasection'] = 'Lisa uus jaotisepealkiri';
$string['adddescriptionlabel'] = 'Lisa kirjeldus/silt';
$string['addingquestion'] = 'Küsimuse lisamine';
$string['addingquestions'] = '<p>Lehe selles osas saad hallata oma küsimuste andmebaasi. Küsimused on salvestatud kategooriate kaupa, et hoida neid korras, ja neid saab kasutada sinu kursuse mis tahes testis. Kui otsustad küsimused „avalikustada“, siis saad kasutada ka teiste kursuste testides.</p>
<p>Pärast küsimuse kategooria valimist või loomist saad küsimusi luua ja muuta. Selle lehe teisel küljel saad kõiki neid küsimusi valida oma testi lisamiseks.</p>';
$string['addmoreoverallfeedbacks'] = 'Lisa veel {no} tagasisidevälja';
$string['addnewgroupoverride'] = 'Lisa rühma testisätete ülekirjutus';
$string['addnewpagesafterselected'] = 'Lisa uued lehed valitud küsimuste järele';
$string['addnewquestionsqbank'] = 'Lisa küsimusi kategooriasse {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Lisa kasutaja testisätete ülekirjutus';
$string['addpagebreak'] = 'Lisa lehepiir';
$string['addpagehere'] = 'Lisa leht siia';
$string['addquestion'] = 'Lisa küsimus';
$string['addquestionfrombankatend'] = 'Lisa küsimustepangast lõppu';
$string['addquestionfrombanktopage'] = 'Lisa küsimustepangast lehele {$a}';
$string['addquestions'] = 'Lisa küsimusi';
$string['addquestionstoquiz'] = 'Lisa küsimusi käesolevasse testi';
$string['addrandom'] = 'Lisa {$a} juhuküsimust';
$string['addrandom1'] = '<< Lisa';
$string['addrandom2'] = 'juhuslikud küsimused';
$string['addrandomfromcategory'] = 'Juhuküsimuste lisamine kategooriast:';
$string['addrandomquestion'] = 'Lisa juhuküsimus';
$string['addrandomquestionatend'] = 'Lisa juhuküsimus lõppu';
$string['addrandomquestiontopage'] = 'Lisa juhuküsimus lehele {$a}';
$string['addrandomquestiontoquiz'] = 'Lisa juhuküsimus õppetesti {$a}';
$string['addselectedquestionstoquiz'] = 'Lisa valitud küsimused õppetesti';
$string['addselectedtoquiz'] = 'Lisa valitud küsimused testi';
$string['addtoquiz'] = 'Lisa õppetesti';
$string['affectedstudents'] = 'Mõjutatud {$a}';
$string['aftereachquestion'] = 'Pärast iga küsimuse lisamist';
$string['afternquestions'] = 'Pärast {$a} küsimuse lisamist';
$string['age'] = 'vanus';
$string['allattempts'] = 'Kõik testisoorituskatsed';
$string['allinone'] = 'Piiramatu';
$string['allowreview'] = 'Luba tagasivaadet';
$string['alreadysubmitted'] = 'Tõenäoliselt olete selle testisoorituskatse vastused juba esitanud.';
$string['alternativeunits'] = 'Alternatiivsed ühikud';
$string['alwaysavailable'] = 'Alati saadaval';
$string['alwayslatest'] = 'Alati viimane versioon';
$string['analysisoptions'] = 'Analüüsi valikud';
$string['analysistitle'] = 'Küsimuste analüüsi tabel';
$string['answer'] = 'Vastus';
$string['answered'] = 'Vastatud';
$string['answerhowmany'] = 'Kas üks või mitu vastust?';
$string['answers'] = 'Vastused';
$string['answersingleno'] = 'Lubatud on mitu õiget vastust';
$string['answersingleyes'] = 'Ainult üks vastus';
$string['answertoolong'] = 'Vastus on liiga pikk peale rida {$a} (255 tähemärki max.)';
$string['anytags'] = 'Ükskõik millised märgid';
$string['aon'] = 'AON-vorming';
$string['areyousureremoveselected'] = 'Kas soovite kindlasti eemaldada kõik valitud küsimused?';
$string['asshownoneditscreen'] = 'Nagu näidatud redigeerimiskuval';
$string['attempt'] = 'Testisoorituskatse {$a}';
$string['attemptalreadyclosed'] = 'See testisoorituskatse on juba lõpetatud.';
$string['attemptclosed'] = 'Testisoorituskatse pole veel suletud';
$string['attemptduration'] = 'Aega kulus';
$string['attemptedon'] = 'Katsetatud';
$string['attempterror'] = 'Te ei tohi seda õppetesti praegu teha. Põhjus: {$a}';
$string['attempterrorcontentchange'] = 'Selle testi eelvaadet pole enam olemas. (Kui testi muudetakse, kustutatakse kõik pooleliolevad eelvaated automaatselt.)';
$string['attempterrorcontentchangeforuser'] = 'Seda testikatset pole enam olemas.';
$string['attempterrorinvalid'] = 'Kehtetu testi katse ID';
$string['attemptfirst'] = 'Esimene soorituskatse';
$string['attemptgradeddelay'] = 'Hinnatud katse teatise viivitus';
$string['attemptgradeddelay_desc'] = 'Enne hinnatus katse teatise saatmist on rakendatud viivitus, et anda õpetajale aega veel hinde muutmiseks.';
$string['attemptincomplete'] = 'Katse ({$a} poolt) pole veel lõpetatud';
$string['attemptlast'] = 'Viimane soorituskatse';
$string['attemptnumber'] = 'Testisoorituskatse';
$string['attemptquiz'] = 'Alusta testi';
$string['attemptquiznow'] = 'Soorita test kohe';
$string['attemptreviewtitle'] = '{$a}: katse ülevaade';
$string['attemptreviewtitlepaged'] = '{$a->name}: Katsete ülevaade (leht {$a->currentpage}/{$a->totalpages})';
$string['attempts'] = 'Soorituskatsed';
$string['attempts_help'] = 'Lubatud katsete koguarv (mitte lisakatsete arv).';
$string['attemptsallowed'] = 'Testisoorituskatseid lubatud';
$string['attemptsdeleted'] = 'Õppetesti soorituskatsed on kustutatud';
$string['attemptselection'] = 'Vali, millist kasutaja katset analüüsida';
$string['attemptsexist'] = 'Seda testi on juba täidetud.<br/>Te ei saa enam küsimusi lisada või eemaldada.';
$string['attemptsnum'] = 'Testisoorituskatseid: {$a}';
$string['attemptsnumthisgroup'] = 'Testisoorituskatseid: {$a->total} (selles rühmas {$a->group})';
$string['attemptsnumyourgroups'] = 'Testisoorituskatseid: {$a->total} (teie rühmades {$a->group})';
$string['attemptsonly'] = 'Kuva ainult õppurid, kes on testi teinud';
$string['attemptstate'] = 'Olek';
$string['attemptstillinprogress'] = 'Testisoorituskatse on veel pooleli';
$string['attemptsummarytitle'] = '{$a}: katsete kokkuvõte';
$string['attemptsunlimited'] = 'Piiramatu katsete arv';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (page {$a->currentpage} {$a->totalpages})';
$string['autosaveperiod'] = 'Automaatse salvestamise viivitus';
$string['autosaveperiod_desc'] = 'Vastused saab testi käigus automaatselt salvestada. Vastused salvestatakse alati pärast muutmist ja pärast seda ooteaega. Siin peab tegema kompromissi: lühem ooteaeg suurendab serveri koormust, aga vähendab õppijate tööde kaotsimineku riski. Kui soovite seda ooteaega oluliselt vähendada, võiksite seda muuta samm-sammult ja jälgida serveri koormust. Kui koormus on liiga suur, muutke ooteaeg jälle lühemaks. Kui ooteaeg on 0, lülitatakse automaatne salvestamine välja.';
$string['back'] = 'Tagasi küsimuse eelvaatesse';
$string['backtocourse'] = 'Tagasi kursusele';
$string['backtoquestionlist'] = 'Tagasi küsimuste nimekirja';
$string['backtoquiz'] = 'Tagasi testi redigeerimise kuvale';
$string['basicideasofquiz'] = 'Testide koostamise põhimõtted';
$string['bestgrade'] = 'Parim hinne';
$string['bothattempts'] = 'Näita katsetanud ja mittekatsetanud õppureid';
$string['browsersecurity'] = 'Brauseriturve';
$string['browsersecurity_help'] = 'Kui valitud on „Täisekraanvaates hüpikaken koos mõningase JavaScripti-turbega“,

* käivitub test ainult siis, kui õppija veebibrauseris on JavaScript lubatud,
* avaneb test täisekraanvaatelises hüpikaknas, mis katab kõik muud aknad ja kus pole navigeerimisjuhtelemente,
* ei saa õppijad kasutada selliseid testi tegemist hõlbustavaid toiminguid nagu kopeerimine ja kleepimine (seda on piiratud nii palju kui võimalik).';
$string['cachedef_overrides'] = 'Kasutaja ja rühma ülekirjutuse info';
$string['calculated'] = 'Arvutuslik';
$string['calculatedquestion'] = 'Arvutuslik küsimus real {$a} pole toetatud. Küsimust eiratakse';
$string['cannotcreatepath'] = 'Teed ei saa luua ({$a})';
$string['cannoteditafterattempts'] = 'Te ei saa küsimusi lisada ega eemaldada, sest õppurid on seda testi juba teinud. ({$a})';
$string['cannotfindprevattempt'] = 'Ei leidnud eelmist testisoorituskatset, mida aluseks võtta.';
$string['cannotfindquestionregard'] = 'Ümberregistreerimiseks ei õnnestunud küsimusi saada.';
$string['cannotinsert'] = 'Küsimuse sisestamine ebaõnnestus';
$string['cannotinsertrandomquestion'] = 'Uut juhuküsimust ei saanud lisada!';
$string['cannotloadquestion'] = 'Küsimuse valikuid ei saanud laadida';
$string['cannotloadtypeinfo'] = 'Ei saa laadida küsimusetüübi spetsiifilist küsimuse infot';
$string['cannotopen'] = 'Ei saanud avada eksporditud faili ({$a})';
$string['cannotremoveallsectionslots'] = 'Oled jaotise „{$a}” all valinud kõik küsimused. Kõiki küsimusi ei tohi jaotise pealkirja alt eemaldada.';
$string['cannotremoveslots'] = 'Ei saa küsimusi eemaldada';
$string['cannotrestore'] = 'Küsimuseseansse ei saanud taastada';
$string['cannotreviewopen'] = 'Seda testisoorituskatset ei saa läbi vaadata, kuna see on veel avatud.';
$string['cannotsavelayout'] = 'Ei saanud salvestada paigutust';
$string['cannotsavenumberofquestion'] = 'Lehe kohta ei õnnestunud küsimuste arvu salvestada';
$string['cannotsavequestion'] = 'Ei saa küsimuste nimekirja salvestada';
$string['cannotsetgrade'] = 'Uut maksimaalset hinnet testile ei saanud määrata';
$string['cannotstartgradesmismatch'] = 'Selle testi tegemist ei saa alustada. Testi hindamisel peaks lähtuma maksimaalsest hindest {$a->grade}, aga ühegi testi küsimusega pole seotud hinnet. Selle saab parandada küsitluse muutmise lehel.';
$string['cannotstartmissingquestion'] = 'Selle õppetesti tegemist ei saa alustada. Testimääratlus sisaldab küsimust, mida pole olemas.';
$string['cannotstartnoquestions'] = 'Selle testi tegemist ei saa alustada. Testi pole veel seadistatud. Küsimusi pole lisatud.';
$string['cannotwrite'] = 'Ei saa kirjutada eksporditud faili ({$a})';
$string['canredoquestions'] = 'Luba ühe soorituskatse raames uuesti teha';
$string['canredoquestions_desc'] = 'Kui see säte on lubatud, kuvatakse õppijale pärast küsimuse lõpetamist küsimuse uuesti proovimise nupp. See võimaldab neil katsetada sama küsimuse teist versiooni, ilma et nad peaksid kogu testi esitama ja uut alustama. Seda valikut kasutatakse peamiselt harjutustestideks.

Säte mõjutab ainult neid küsimusi (aga mitte nt essee tüüpi küsimused) ja käitumisviise (nt vahetu tagasiside või mitme katsega interaktiivne režiim), mille puhul õppija saab küsimuse lõpetada enne kogu soorituskatse esitamist.';
$string['canredoquestions_help'] = 'Kui see säte on lubatud, kuvatakse õppijale pärast küsimuse lõpetamist küsimuse uuesti proovimise nupp. See võimaldab neil katsetada sama küsimuse teist versiooni, ilma et nad peaksid kogu testi esitama ja uut alustama. Seda valikut kasutatakse peamiselt harjutustestideks.

Säte mõjutab ainult neid küsimusi (aga mitte nt essee tüüpi küsimused) ja käitumisviise (nt vahetu tagasiside või mitme katsega interaktiivne režiim), mille puhul õppija saab küsimuse lõpetada enne kogu soorituskatse esitamist.';
$string['canredoquestionsyes'] = 'Jah, luba õpilasel valida teine küsimus';
$string['caseno'] = 'Ei, väikesed-suured tähed ei pea olema vastavuses';
$string['casesensitive'] = 'Tõstutundlikkus';
$string['caseyes'] = 'Jah, väikesed-suured tähed peavad olema vastavuses';
$string['categoryadded'] = 'Kategooria „{$a}“ lisati';
$string['categorydeleted'] = 'Kategooria „{$a}“ on kustutatud';
$string['categorynoedit'] = 'Teil ei ole muutmisõigust kategooriale \'{$a}\'.';
$string['categoryupdated'] = 'Kategooria on värskendatud.';
$string['close'] = 'Sule aken';
$string['closebeforeopen'] = 'Õppetesti ei saanud värskendada. Olete määranud avamiskuupäevast varasema sulgemiskuupäeva.';
$string['closed'] = 'Suletud';
$string['closepreview'] = 'Sulge eelvaade';
$string['closereview'] = 'Sulge ülevaade';
$string['comment'] = 'Kommentaar';
$string['commentorgrade'] = 'Kommenteeri või kirjuta hinne üle';
$string['comments'] = 'Kommentaarid';
$string['completedon'] = 'Lõpetatud';
$string['completionattemptsexhausted'] = 'Või kõik soorituskatsete limiit on täis';
$string['completionattemptsexhausted_help'] = 'Märgib testi lõpule viiduks, kui õppija on kasutanud ära maksimumarvu soorituskatseid.';
$string['completiondetail:minattempts'] = 'Katsed: {$a}';
$string['completiondetail:passgrade'] = 'Saa positiivne hinne';
$string['completiondetail:passorexhaust'] = 'Saa positiivne hinne või lõpeta kõik saadaolevad katsed';
$string['completionminattempts'] = 'Minimaalne katsete arv:';
$string['completionminattemptsdesc'] = 'Minimaalne kohustuslik katsete arv: {$a}';
$string['completionminattemptserror'] = 'Minimaalne katsete arv peab olema väiksem või võrdne lubatud katsetega.';
$string['completionminattemptsgroup'] = 'Nõua katseid';
$string['completionpass'] = 'Nõua läbimiseks vajalikku hinnet';
$string['completionpass_help'] = 'Kui see säte on lubatud, loetakse see tegevus lõpetatuks, kui õppija saab positiivse hinde.';
$string['completionpassdesc'] = 'Tegevuse lõpetamiseks peab õppija saama positiivse hinde';
$string['completionpassorattemptsexhausteddesc'] = 'Õpilane peab selle tegevuse lõpetamiseks saama positiivse hinde või lõpetama kõik saadaolevad katsed.';
$string['configadaptive'] = 'Kui määrate selle valiku väärtuseks Jah, saab õppur küsimusele vastata mitu korda isegi sama testisoorituskatse käigus.';
$string['configattemptsallowed'] = 'Piirang, mitu korda on õppuril lubatud testi teha.';
$string['configdecimaldigits'] = 'Numbrite arv, mida hinnete kuvamisel tuleks näidata pärast koma.';
$string['configdecimalplaces'] = 'Kümnendkohtade arv õppetesti hinnete kuvamisel.';
$string['configdecimalplacesquestion'] = 'Kümnendkohtade arv üksikküsimuste hinnete kuvamisel.';
$string['configdelay1'] = 'Kui määrad viivituse, peab õpilane seda aega ootama, enne kui ta saab pärast esimest katset testi proovida.';
$string['configdelay1st2nd'] = 'Kui seate siin viivitusaja, ei saa õppur alustada oma teist testisoorituskatset enne, kui esimese katse lõpust on möödunud siin määratud aeg.';
$string['configdelay2'] = 'Kui määrad siia viivituse, peab õpilane seda aega ootama, enne kui ta saab proovida oma kolmandat või hilisemat katset.';
$string['configdelaylater'] = 'Kui seate siin viivitusaja, ei saa õppur alustada oma kolmandat, neljandat, ... testisoorituskatset enne, kui eelmise katse lõpust on möödunud siin määratud aeg.';
$string['configeachattemptbuildsonthelast'] = 'Kui lubatud on mitu testisoorituskatset, siis sisaldab iga uus katse eelmise soorituse tulemusi.';
$string['configgrademethod'] = 'Saate määrata, millist hindamisviisi peaks õppuri testi lõpphinde arvutamiseks kasutama sel juhul, kui lubatud on mitu testisoorituskatset.';
$string['configintro'] = 'Siin määratud väärtused määratlevad vaikeväärtused, mida kasutatakse sätete vormis siis, kui koostate uue õppetesti. Saate konfigureerida ka selle, milliseid testisätteid peetakse täpsemateks säteteks.';
$string['configmaximumgrade'] = 'Vaikehinne, millest hakatakse testihinde arvutamisel punkte maha võtma.';
$string['confignavmethod'] = 'Vaba navigatsiooni korral saab küsimustele vastata mis tahes järjestuses, kasutades navigeerimisriba. Järjestikuse navigatsiooni korral peab küsimustele vastama rangelt järjest.';
$string['confignewpageevery'] = 'Testile küsimuste lisamise korral lisatakse lehepiirid automaatselt vastavalt siin valitud sättele.';
$string['configoutcomesadvanced'] = 'Kui see säte on sisse lülitatud, on testi muutmise vormi tulemuste sätted täpsemad sätted.';
$string['configpenaltyscheme'] = 'Adaptiivrežiimis lahutatakse iga vale vastuse korral trahv.';
$string['configpopup'] = 'Saate jõustada soorituskatse korral testi avanemise hüpikaknas ning kasutada JavaScripti nippe selleks, et piirata testi tegemise ajal kopeerimist ja kleepimist vms toiminguid.';
$string['configrequirepassword'] = 'Õppurid peavad testi tegemiseks sisestama selle parooli.';
$string['configrequiresubnet'] = 'Õppurid saavad testi teha ainult nendes arvutites.';
$string['configreviewoptions'] = 'Nende valikutega saab reguleerida seda, millist teavet kasutajad näevad, kui nad vaatavad tehtud õppetesti läbi või loevad õppetesti aruandeid.';
$string['configshowblocks'] = 'Saate testisoorituskatsete ajal kuvada plokid.';
$string['configshowuserpicture'] = 'Saate testisoorituskatsete ajal kuvada ekraanil kasutaja pildi.';
$string['configshufflewithin'] = 'Kui lubate selle valiku, siis segatakse osad, millest üksikküsimused koosnevad, juhuslikult iga kord, kui õppur alustab testisoorituskatset. Eelduseks on, et see valik on lubatud ka küsimusesätetes.';
$string['configtimelimit'] = 'Testide vaikimisi ajapiirang minutites. 0 tähendab, et piirangut pole.';
$string['configtimelimitsec'] = 'Õppetestide vaikeajapiirang sekundites. 0 tähendab ajapiirangu puudumist.';
$string['configurerandomquestion'] = 'Konfigureeri küsimus';
$string['confirmclose'] = 'Kui te oma töö esitate, ei saa te enam selle soorituskatse vastuseid muuta.';
$string['confirmremovequestion'] = 'Kas soovite selle {$a} küsimuse kindlasti eemaldada?';
$string['confirmremovesectionheading'] = 'Kas soovite jaotise „{$a}“ pealkirja kindlasti eemaldada?';
$string['confirmserverdelete'] = 'Kas olete kindel, et soovite kustutada serveri <b>{$a} </b> nimekirjast?';
$string['connectionerror'] = 'Võrguühendus katkes. (Automaatsalvestus nurjus).

Kirjutage üles kõik sellele lehele viimase paari minuti jooksul sisestatud vastused ja seejärel üritage ühendus uuesti luua.

Pärast ühenduse uuesti loomist peaks muudatused salvestama ning see teade kaob.';
$string['connectionok'] = 'Võrguühendus on taastatud. Võite turvaliselt jätkata.';
$string['containercategorycreated'] = 'See kategooria on loodud majutamaks kõiki originaalseid kategooriaid, mis on viidud õpikeskkonna tasemele allpool toodud põhjustel';
$string['continueattemptquiz'] = 'Jätka viimast testisoorituskatset';
$string['continuepreview'] = 'Jätka viimase eelvaate kuvamist';
$string['copyingfrom'] = 'Küsimusest  \'{$a}\' koopia tegemine';
$string['copyingquestion'] = 'Kopeeri küsimus';
$string['correct'] = 'Õige';
$string['correctanswer'] = 'Õige vastus';
$string['correctanswerformula'] = 'Õige vastuse valem';
$string['correctansweris'] = 'Õige vastus: {$a}';
$string['correctanswerlength'] = 'Tüvenumbrid';
$string['correctanswers'] = 'Õiged vastused';
$string['correctanswershows'] = 'Kuvatakse õige vastus';
$string['corrresp'] = 'Reageering õigele vastusele';
$string['countdown'] = 'Aja pöördloendus';
$string['countdownfinished'] = 'Test sulgub, Sa pead oma vastused kohe esitama.';
$string['countdowntenminutes'] = 'Test sulgub 10 minuti pärast.';
$string['coursetestmanager'] = 'Kursuse testide haldamise formaat';
$string['createcategoryandaddrandomquestion'] = 'Loo kategooria ja lisa juhuküsimus';
$string['createfirst'] = 'Te peate looma esmalt mõned lühivastustega küsimused.';
$string['createmultiple'] = 'Lisa testi mõned juhuslikud küsimused';
$string['createnewquestion'] = 'Koosta uus küsimus';
$string['createquestionandadd'] = 'Saate koostada uue küsimuse ja lisada selle testile.';
$string['custom'] = 'Kohandatud vorming';
$string['dataitemneed'] = 'Kehtiva küsimuse saamiseks pead lisama vähemalt ühe andmeüksuste komplekti';
$string['datasetdefinitions'] = 'Kategooria {$a} korduskasutatavad andmestikumääratlused';
$string['datasetnumber'] = 'Number';
$string['daysavailable'] = 'Mitu päeva avatud:';
$string['decimaldigits'] = 'Kümnendkohti hinnetes';
$string['decimalplaces'] = 'Kümnendkohti hinnetes';
$string['decimalplaces_help'] = 'Selle sättega saate määrata, mitu kümnendkohta kuvatakse hinnetes. See mõjutab ainult hinnete kuvamist, mitte andmebaasi salvestatavaid hindeid ega sisemisi arvutusi, mis tehakse kogu täpsusega.';
$string['decimalplacesquestion'] = 'Kümnendkohti küsimuste hinnetes.';
$string['decimalplacesquestion_help'] = 'Selle sättega saate määrata, mitu kümnendkohta kuvatakse üksikküsimuste hinnetes.';
$string['decimalpoints'] = 'Kümnendkohti';
$string['default'] = 'Vaikimisi';
$string['defaultgrade'] = 'Küsimuse vaikehinne';
$string['defaultinfo'] = 'Küsimuste vaikekategooria.';
$string['delay1'] = 'Viivitus esimese ja teise soorituskatse vahel';
$string['delay1st2nd'] = 'Sundviivitusaeg 1. ja 2. katse vahel';
$string['delay1st2nd_help'] = 'Kui see on lubatud, peab õppur ootama määratud aja, enne kui saab hakata testi tegema teist korda';
$string['delay2'] = 'Viivitus hilisemate soorituskatsete vahel';
$string['delaylater'] = 'Sundviivitusaeg hilisemate katsete vahel';
$string['delaylater_help'] = 'Kui see on lubatud, peab õppur ootama määratud aja, enne kui saab hakata testi tegema kolmandat või rohkemat korda.';
$string['deleteattemptcheck'] = 'Kas soovite täiesti kindlasti need testisoorituskatsed täielikult kustutada? NB! Testisooritused kustutatakse jäädavalt!';
$string['deleteselected'] = 'Kustuta valitud';
$string['deletingquestionattempts'] = 'Kustutan testi katseid';
$string['description'] = 'Kirjeldus';
$string['disabled'] = 'Keelatud';
$string['displayoptions'] = 'Kuvamissätted';
$string['donotuseautosave'] = 'Ära kasuta automaatsalvestust';
$string['download'] = 'Klõpsake eksporditud kategooriafaili allalaadimiseks.';
$string['downloadextra'] = '(fail on salvestatud ka kursuse failide juurde testi kausta)';
$string['dragtoafter'] = 'Pärast {$a}';
$string['dragtostart'] = 'Algusse';
$string['duplicateresponse'] = 'Seda esitust eirati, sest olete juba varem andnud täpselt samasuguse vastuse.';
$string['eachattemptbuildsonthelast'] = 'Iga testisoorituskatse põhineb eelmisel';
$string['eachattemptbuildsonthelast_help'] = 'Kui testi on lubatud teha mitu korda ja see säte on lubatud, sisaldab iga uus testisoorituskatse eelmise katse tulemusi. See võimaldab testi lõplikult sooritada mitme katsega.';
$string['edit_slotdisplaynumber_hint'] = 'Muuda küsimuse numbrit (kuni 16 sümbolit)';
$string['edit_slotdisplaynumber_label'] = '{$a} uus väärtus';
$string['editcategories'] = 'Muuda kategooriaid';
$string['editcategory'] = 'Muuda kategooriat';
$string['editcatquestions'] = 'Muuda kategooria küsimusi';
$string['editingquestion'] = 'Küsimuse muutmine';
$string['editingquiz'] = 'Õppetesti redigeerimine';
$string['editingquiz_help'] = 'Testi koostamisel ette tulevad põhimõisted:

* test – sisaldab küsimusi ühel või mitmel lehel
* küsimustepank – koht, kus talletatakse kõigi küsimuste koopiaid, mis on jagatud kategooriatesse
* juhuküsimused – õppija saab igal soorituskatsel erinevad küsimused, samuti võivad õppijad saada erinevad küsimused';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Õppetesti redigeerimine: {$a}';
$string['editmaxmark'] = 'Maksimumhinde muutmine';
$string['editoverride'] = 'Testisätete ülekirjutuse redigeerimine';
$string['editqcats'] = 'Muuda küsimuste kategooriaid';
$string['editquestion'] = 'Muuda küsimust';
$string['editquestions'] = 'Muuda küsimusi';
$string['editquiz'] = 'Muuda testi';
$string['editquizquestions'] = 'Muuda testi küsimusi';
$string['emailconfirmautosubmitsmall'] = 'Aitäh, et vastasid testile "{$a->quizname}"!';
$string['emailconfirmbody'] = 'Tere {$a->username}!

Aitäh kursuse „{$a->coursename}“ testi „{$a->quizname}“ vastuste esitamise eest (esitamisaeg: {$a->submissiontime}).

Selle teatega kinnitame, et oleme vastused kätte saanud.

Testi saad vaadata siin: {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Tere {$a->username}!

Kursuse „{$a->coursename}“ testi „{$a->quizname}“ vastuste esitamise aeg on läbi. Sinu kirjutatud vastused esitati automaatselt (esitamisaeg: {$a->submissiontime}).

Selle teatega kinnitame, et oleme vastused kätte saanud.

Testi saad vaadata siin: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Aitäh testi „{$a->quizname}“ vastuste esitamise eest';
$string['emailconfirmsubject'] = 'Testi esitamise kinnitus: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Tere {$a->studentname},

Sinu vastused testile "{$a->quizname}" kursusel "{$a->coursename}" {$a->attempttimefinish} on nüüd hinnatud.

Näed oma tulemust ja tagasisidet \'{$a->quizurl}\'.';
$string['emailmanualgradedsubject'] = 'Sinu katse testis "{$a->quizname}" on hinnatud';
$string['emailnotifybody'] = 'Tere {$a->username}!

{$a->studentname} on lõpetanud kursuse „{$a->coursename}“ testi „{$a->quizname}“ ({$a->quizurl}).

Esitatud testi saate läbi vaadata siin: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} on lõpetanud testi {$a->quizname}. Vt {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} on lõpetanud testi {$a->quizname}';
$string['emailoverduebody'] = 'Tere {$a->studentname},

alustasid testi „{$a->quizname}“ soorituskatset kursusel „{$a->coursename}“, aga pole seda seni esitanud. Selle oleks pidanud esitama hiljemalt {$a->attemptduedate}.

Kui soovid selle siiski esitada, mine aadressil {$a->attemptsummaryurl} ja klõpsa esitamise nuppu.
Seda tuleb teha hiljemalt {$a->attemptgraceend}, sest pärast seda esitatud soorituskatset ei arvestata.';
$string['emailoverduesmall'] = 'Te pole esitanud testi „{$a->quizname}“ soorituskatset. Kui soovite selle siiski esitada, minge aadressil {$a->attemptsummaryurl} enne {$a->attemptgraceend}.';
$string['emailoverduesubject'] = 'Testisoorituskatse on tähtaja ületanud: {$a->quizname}';
$string['empty'] = 'Tühi';
$string['enabled'] = 'Lubatud';
$string['endtest'] = 'Lõpeta testisoorituskatse...';
$string['erroraccessingreport'] = 'Te ei pääse sellele aruandele juurde';
$string['errorinquestion'] = 'Viga küsimuses';
$string['errormissingquestion'] = 'Viga: süsteemis pole küsimust IDga {$a}';
$string['errornotnumbers'] = 'Viga: vastused peavad olema arvulised';
$string['errorunexpectedevent'] = 'Leitud on testisoorituskatse {$a->attemptid} küsimuse {$a->questionid} sündmusekood {$a->event}, mida ei eeldatud.';
$string['essay'] = 'Essee';
$string['essayquestions'] = 'Küsimused';
$string['eventattemptautosaved'] = 'Testikatse on automaatsalvestatud';
$string['eventattemptdeleted'] = 'Testisoorituskatse on kustutatud';
$string['eventattemptmanualgradingcomplete'] = 'Testikatse käsitsi hindamine on lõpetatud';
$string['eventattemptpreviewstarted'] = 'Testi soorituskatse eelvaade käivitati';
$string['eventattemptquestionrestarted'] = 'Testikatse küsimus on taaskäivitatud';
$string['eventattemptreviewed'] = 'Testi soorituskatse vaadati läbi';
$string['eventattemptsummaryviewed'] = 'Testi kokkuvõtet vaadati';
$string['eventattemptupdated'] = 'Testikatse on värskendatud';
$string['eventattemptviewed'] = 'Testi soorituskatset vaadati';
$string['eventeditpageviewed'] = 'Testi muutmise lehte vaadati';
$string['eventoverridecreated'] = 'Testi ülekirjutus loodi';
$string['eventoverridedeleted'] = 'Testi ülekirjutus on kustutatud';
$string['eventoverrideupdated'] = 'Testi ülekirjutus värskendati';
$string['eventpagebreakcreated'] = 'Lehevahe on loodud';
$string['eventpagebreakdeleted'] = 'Lehevahe on kustutatud';
$string['eventquestionmanuallygraded'] = 'Küsimust hinnati käsitsi';
$string['eventquizattemptabandoned'] = 'Testisoorituskatse on hüljatud';
$string['eventquizattemptregraded'] = 'Testikatsetus ümber klassifitseeritud';
$string['eventquizattemptreopened'] = 'Testikatse on taasavatud';
$string['eventquizattemptstarted'] = 'Testisoorituskatset on alustatud';
$string['eventquizattemptsubmitted'] = 'Testisoorituskatse on tehtud';
$string['eventquizattempttimelimitexceeded'] = 'Testisoorituskatse ajapiirang on ületatud';
$string['eventquizgradeupdated'] = 'Testi hinne on värskendatud';
$string['eventquizrepaginated'] = 'Test on ümber nummerdatud';
$string['eventreportviewed'] = 'Testi aruannet vaadati';
$string['eventsectionbreakcreated'] = 'Sektsioonivahe on loodud';
$string['eventsectionbreakdeleted'] = 'Sektsioonivahe on kustutatud';
$string['eventsectionshuffleupdated'] = 'Sektsiooni paigutus värskendatud';
$string['eventsectiontitleupdated'] = 'Sektsiooni pealkiri värskendatud';
$string['everynquestions'] = 'Kõik {$a} küsimust';
$string['everyquestion'] = 'Kõik küsimused';
$string['everythingon'] = 'Kõik sees';
$string['existingcategory'] = 'Olemasolev kategooria';
$string['exportcategory'] = 'ekspordikategooria';
$string['exporterror'] = 'Ekspordi töötlemise käigus ilmnes tõrge';
$string['exportingquestions'] = 'Küsimusi eksporditakse faili';
$string['exportname'] = 'Faili nimi';
$string['exportquestions'] = 'Ekspordi küsimused faili';
$string['extraattemptrestrictions'] = 'Testisoorituskatsete lisapiirangud';
$string['false'] = 'Väär';
$string['feedback'] = 'Tagasiside';
$string['feedbackerrorboundaryformat'] = 'Tagasiside hindepiir saab olla kas protsent või number. Piiri {$a} väljale sisestatud väärtust ei tuntud ära';
$string['feedbackerrorboundaryoutofrange'] = 'Tagasiside hindepiirid peavad olema vahemikus 0–100%. Piiri {$a} väljale sisestatud väärtus on sellest väljaspool.';
$string['feedbackerrorjunkinboundary'] = 'Peate täitma tagasiside hindepiiride väljad midagi vahele jätmata.';
$string['feedbackerrorjunkinfeedback'] = 'Peate täitma tagasisideväljad midagi vahele jätmata.';
$string['feedbackerrororder'] = 'Tagasiside hindepiirid peavad olema järjestatud (alates suurimast). Piiri {$a} väljale sisestatud väärtus on vales järjestuses.';
$string['file'] = 'Fail';
$string['fileformat'] = 'Failivorming';
$string['fillcorrect'] = 'Täida õige vastusega';
$string['filloutnumericalanswer'] = 'Pakud vähemalt ühe võimaliku vastuse ja sallivuse. Esimest sobivat vastust kasutatakse hinde ja tagasiside määramiseks. Kui esitad tagasisidet, mille lõpus pole vastust, näidatakse seda õpilastele, kelle vastus pole kokkusobiv ühegi teise vastusega.';
$string['filloutoneanswer'] = 'Peate sisestama vähemalt ühe võimaliku vastuse. Tühjaks jäetud vastuseid ei kasutata. Sümbolit „*“ saab kasutada metamärgina, mis vastab mis tahes märgile. Esimest sobivat vastust kasutatakse hinde ja tagasiside määratlemisel.';
$string['filloutthreequestions'] = 'Pead sisestama vähemalt kolm küsimust. Tühjaks jäetud lahtreid ei kasutata.';
$string['fillouttwochoices'] = 'Vähemalt kaks valikuvälja peab olema täidetud. Tühjaks jäetud valikuvälju ei kasutata.';
$string['finishattemptdots'] = 'Lõpeta testisoorituskatse...';
$string['finishreview'] = 'Lõpeta läbivaatus';
$string['forceregeneration'] = 'jõusta regenereerimine';
$string['formatnotfound'] = 'Impordi-/ekspordivormingut {$a} ei leitud';
$string['formulaerror'] = 'Valemivead!';
$string['fractionsaddwrong'] = 'Teie valitud positiivsete hinnete summa ei anna kokku 100%<br />See annab kokku hoopis {$a}%<br />Kas soovite minna tagasi ja parandada seda küsimust?';
$string['fractionsnomax'] = 'Üks vastustest peaks olema 100%, nii et selle küsimuse eest<br />oleks võimalik saada täishinne.<br />Kas soovite minna tagasi ja parandada seda küsimust?';
$string['fromfile'] = 'failist:';
$string['functiondisabledbysecuremode'] = 'See funktsioon on praegu keelatud';
$string['generalfeedback'] = 'Üldine tagasiside';
$string['generalfeedback_help'] = 'Üldine tagasiside on tekst, mis kuvatakse pärast seda, kui küsimusele on vastatud. Erinevalt tagasisidest konkreetsele küsimusele, mis oleneb antud vastusest, kuvatakse üldise tagasiside korral alati sama tekst.';
$string['gobacktoquiz'] = 'Mine tagasi';
$string['graceperiod'] = 'Esitamise ajapikendus';
$string['graceperiod_desc'] = 'Kui sätetes on pärast tähtaja ületamist lubatud kasutada ajapikenduse perioodi töö esitamiseks, aga mitte vastuste muutmiseks, määratakse lisaperioodiks vaikimisi see periood.';
$string['graceperiod_help'] = 'Kui sätetes on pärast tähtaja ületamist lubatud kasutada ajapikenduse perioodi töö esitamiseks, aga mitte vastuste muutmiseks, määratakse lisaperioodiks see periood.';
$string['graceperiodmin'] = 'Viimane esitamise ajapikendus';
$string['graceperiodmin_desc'] = 'Testi lõpus võib tekkida probleem. Ühelt poolt soovime lasta õppijatel töötada kuni viimase hetkeni, kasutades taimerit, mis aja lõppedes testi automaatselt esitab. Teisalt võib server olla üle koormatud ja vastuste töötlemiseks läheb aega. Seega võetakse vastuseid vastu nii kaua pärast aja lõppemist, et õppijad ei kannataks serveri aeglase töö tõttu. Samas võib õppija petta ja kasutada neid sekundeid testi täitmiseks. Ilmselt tuleb teil leida kompromiss selle põhjal, kui usaldusväärseks te oma serveri tööd testide ajal peate.';
$string['graceperiodtoosmall'] = 'Ajapikendusperiood peab olema pikem kui {$a}.';
$string['grade'] = 'Hinne';
$string['gradeall'] = 'Hinda kõiki';
$string['gradeaverage'] = 'Keskmine hinne';
$string['gradeboundary'] = 'Hindepiir';
$string['gradeessays'] = 'Hinda esseesid';
$string['gradehighest'] = 'Kõrgeim hinne';
$string['grademethod'] = 'Hindamisviis';
$string['grademethod_help'] = 'Kui testi on lubatud teha mitu korda, saab lõplikku testi hinnet arvutada järgmistel viisidel:

* kõikide soorituskatsete parim hinne
* kõikide soorituskatsete keskmine hinne
* esimene soorituskatse (teisi katseid eiratakse)
* viimane soorituskatse (teisi katseid eiratakse)';
$string['gradesdeleted'] = 'Õppetesti hinded on kustutatud';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Läbimiseks vajalik hinne ei saa olla null, sest selle testi lõpetamiseks nõutakse läbimiseks vajalikku hinnet. Sisestage nullist erinev väärtus.';
$string['gradetopassnotset'] = 'Sellel kursusel pole määratud läbimiseks vajalikku hinnet, nii et te ei saa seda sätet kasutada. Määrake läbimiseks vajalik hinne testi seadetes.';
$string['gradetopassoutof'] = 'Läbimiseks vajalik tulemus: {$a->grade} / {$a->maxgrade}';
$string['gradingdetails'] = 'Selle esitatud töö hindepunktid: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Eelnevate trahvidega kokku teeb see <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Selle esitatud töö eest saite trahvi {$a}.';
$string['gradingdetailszeropenalty'] = 'Selle esitatud töö eest te trahvi ei saanud.';
$string['gradingmethod'] = 'Hindamisviis: {$a}';
$string['groupoverrides'] = 'Rühma testisätete ülekirjutused';
$string['groupoverridesdeleted'] = 'Rühma testisätete ülekirjutused on kustutatud.';
$string['groupsnone'] = 'Sellel kursusel pole rühmi';
$string['guestsno'] = 'Kahjuks ei saa külalised teste vaadata ega täita.';
$string['hidebreaks'] = 'Peida leheküljepaus';
$string['hidereordertool'] = 'Peida ümberjärjestamise tööriist';
$string['history'] = 'Vastuste ajalugu:';
$string['howquestionsbehave_desc'] = 'Vaikesäte, millega määratakse testiküsimuste toimimisviis.';
$string['imagedisplay'] = 'Pilt näitamiseks';
$string['import_help'] = 'See funktsioon võimaldab importida küsimusi välistest tekstifailidest.

Kui fail sisaldab märke, mis pole ASCII-märgid, tuleb kasutada UTF-8-kodeeringut. Eriti ettevaatlik tuleb olla failidega, mis on loodud Microsoft Office’i rakendustes, sest neis on tavaliselt kasutusel erikodeering, mida ei pruugita õigesti käidelda.

Impordi- ja ekspordivormingud on lisandressurss. Muud valikulised vormingud võivad olla saadaval moodulite ja lisandmoodulite andmebaasis';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'impordikategooria';
$string['importerror'] = 'Impordi töötlemise käigus ilmnes tõrge';
$string['importfilearea'] = 'Impordi olemasolevast kursusefailist...';
$string['importfileupload'] = 'Impordi üleslaaditavast failist...';
$string['importfromthisfile'] = 'Impordi sellest failist';
$string['importingquestions'] = 'Failist {$a} küsimuse importimine';
$string['importmax10error'] = 'Küsimuses on viga. Teil ei tohi olla üle kümne vastuse.';
$string['importmaxerror'] = 'Küsimuses on viga. Teil liiga palju vastuseid.';
$string['importquestions'] = 'Impordi küsimused failist';
$string['inactiveoverridehelp'] = '* Õppuril pole selle õppetesti tegemiseks õige rühm või roll';
$string['incorrect'] = 'Vale';
$string['indicator:cognitivedepth'] = 'Kognitiivne test';
$string['indicator:cognitivedepth_help'] = 'See näitaja põhineb kognitiivsel sügavusel, milleni õpilane on testide tegemisel jõudnud.';
$string['indicator:cognitivedepthdef'] = 'Kognitiivne test';
$string['indicator:cognitivedepthdef_help'] = 'Osaleja on selle analüüsivahemiku jooksul saavutanud selle testi tegevuste pakutava kognitiivse seotuse protsendi (tasemed = vaadet pole, vaade, esita, vaadake tagasisidet, kommenteerige tagasisidet, esitage pärast tagasiside vaatamist uuesti)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sotsiaalne test';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb sotsiaalsel ülatusel, mille õpilane testitegevuse käigus saavutas.';
$string['indicator:socialbreadthdef'] = 'Sotsiaalne test';
$string['indicator:socialbreadthdef_help'] = 'Osaleja on selle analüüsivahemiku jooksul saavutanud selle testi tegevuste pakutava sotsiaalse kaasatuse protsendi (tasemed = ei osale, osales üksi, osales koos teistega)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Iga õppija igale küsimusele antud reageering';
$string['info'] = 'Teave';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Üldise tagasiside väljade algne arv';
$string['initialnumfeedbacks_desc'] = 'Uut testi luues on saadaval nii palju üldise tagasiside välju. Kui test on loodud, kuvatakse vormis testi tagasiside jaoks vajalike väljade arv. Selle sätte väärtus peab olema vähemalt 1.';
$string['inprogress'] = 'Pooleli';
$string['introduction'] = 'Kirjeldus';
$string['invalidattemptid'] = 'Sellist testisoorituskatse tunnuskoodi pole olemas';
$string['invalidcategory'] = 'Kategooria ID ei sobi';
$string['invalidoverrideid'] = 'Testisätete ülekirjutuse sobimatu ID';
$string['invalidquestionid'] = 'Küsimuse ID ei sobi';
$string['invalidquizid'] = 'Õppetesti ID ei sobi';
$string['invalidrandomslot'] = 'Vale juhusliku küsimuse pesa ID.';
$string['invalidsource'] = 'Seda allikat ei aktsepteerita.';
$string['invalidsourcetype'] = 'Vigane allika tüüp';
$string['invalidstateid'] = 'Oleku ID ei sobi';
$string['lastanswer'] = 'Teie viimane vastus oli';
$string['layout'] = 'Paigutus';
$string['layoutasshown'] = 'Kuvatud lehepaigutus.';
$string['layoutasshownwithpages'] = 'Kuvatud lehepaigutus. <small>(Automaatne uus leht iga {$a} küsimuse kohta.)</small>';
$string['layoutshuffledandpaged'] = 'Juhujärjestuses küsimused, {$a} küsimust lehe kohta.';
$string['layoutshuffledsinglepage'] = 'Juhujärjestuses küsimused, kõik ühel lehel.';
$string['link'] = 'Link';
$string['listitems'] = 'Testi küsimuste loend';
$string['literal'] = 'Sõnaline';
$string['loadingquestionsfailed'] = 'Küsimusi ei saanud laadida: {$a}';
$string['makecopy'] = 'Salvesta uue küsimusena';
$string['managetypes'] = 'Halda küsimuste tüüpe ja servereid';
$string['manualgradequestion'] = 'Testi „{$a->quiz}“ küsimuse „{$a->question}“ õppija {$a->user} esitatud vastuse käsitsi hindamine';
$string['manualgrading'] = 'Hindamine';
$string['mark'] = 'Esita';
$string['markall'] = 'Esita leht';
$string['marks'] = 'Hindepunktid';
$string['marks_help'] = 'Iga küsimuse arvulised punktid ja soorituskatse kogupunktisumma.';
$string['match'] = 'Vastavusse seadmine';
$string['matchanswer'] = 'Sobiv vastus';
$string['matchanswerno'] = 'Sobiv vastus {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Maksimumhindepunktid';
$string['messageprovider:attempt_grading_complete'] = 'Teavitus, et sinu katse on hinnatud';
$string['messageprovider:attempt_overdue'] = 'Hoiatus, mis kuvatakse siis, kui testi tegemise tähtaeg on möödas';
$string['messageprovider:confirmation'] = 'Testivastuste esitamise kinnitus';
$string['messageprovider:submission'] = 'Testivastuste esitamise teatis';
$string['min'] = 'Min';
$string['minutes'] = 'minutit';
$string['missingcorrectanswer'] = 'Õige vastus peab olema antud';
$string['missingitemtypename'] = 'Puudub nimi';
$string['missingquestion'] = 'Näib, et seda küsimust pole enam olemas';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Testi tegevused võimaldavad õpetajal luua teste, mis sisaldavad eri tüüpi küsimusi (nt valikvastustega küsimus, vastavusse viimise tüüpi küsimus, lühivastusega küsimus ja arvuline küsimus).

Õpetaja saab lubada õppijatel teha mitu soorituskatset nii, et küsimuste järjekorda muudetakse või need asendatakse küsimusepangast juhuslikult valitud küsimustega. Testi sooritamiseks saab määrata ajalimiidi.

Iga katse hinnatakse automaatselt (v.a esseeküsimused) ja hinne kantakse hinnetelehele.

Õpetaja saab valida, kas õppijad saavad vaadata vihjeid, tagasisidet ja õigeid vastuseid.

Teste saab kasutada näiteks järgmiseks:

* kursuse eksamitena,
* lühitestidena lugemisülesannete raames või teema lõpus,
* eksamiks harjutamiseks varasemate eksamite põhjal,
* töö kohta kohe tagasiside andmiseks,
* enesehindamiseks.';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testid';
$string['moveselectedonpage'] = 'Teisalda valitud küsimused lehele: {$a}';
$string['multichoice'] = 'Valikvastusega';
$string['multipleanswers'] = 'Valige vähemalt üks vastus.';
$string['mustbesubmittedby'] = 'Selle katse vastused tuleb esitada {$a}';
$string['name'] = 'Nimi';
$string['navigatenext'] = 'Järgmine leht';
$string['navigateprevious'] = 'Eelmine leht';
$string['navmethod'] = 'Navigeerimisviis';
$string['navmethod_free'] = 'Vaba';
$string['navmethod_help'] = 'Järjestnavigeerimise korral peab õppur testi küsimustele vastava määratud järjekorras ning ei tohi tagasi pöörduda eelmistele lehtedele ega jätta edasi liikudes lehti vahele.';
$string['navmethod_seq'] = 'Järjest';
$string['navnojswarning'] = 'Hoiatus: need lingid ei salvesta teie vastuseid. Kasutage lehe allservas olevat nuppu „Järgmine“.';
$string['neverallononepage'] = 'Mitte kunagi, kõik küsimused on ühel lehel';
$string['newattemptfail'] = 'Tõrge: selle õppetesti uut soorituskatset ei saanud alustada';
$string['newcategory'] = 'Uus kategooria';
$string['newpage'] = 'Uus leht';
$string['newpage_help'] = 'Pikemate õppetestide korral on mõttekas jagada test mitmele lehele, piirates lehel kuvatavate küsimuste arvu. Küsimuste testi lisamise korral sisestatakse lehepiirid vastavalt sellele sättele automaatselt. Lehepiire saate hiljem siiski redigeerimislehel käsitsi muuta.';
$string['newpageevery'] = 'Alusta uut lehte automaatselt';
$string['newsectionheading'] = 'Uus pealkiri';
$string['noanswers'] = 'Ühtegi vastust pole valitud!';
$string['noattempts'] = 'Seda testi pole veel tehtud';
$string['noattemptsfound'] = 'Testisoorituskatseid ei leitud.';
$string['noattemptstoshow'] = 'Pole ühtegi testisoorituskatset, mida kuvada';
$string['nocategory'] = 'Sobimatu või kategooriat pole määratud';
$string['noclose'] = 'Sulgemiskuupäeva pole';
$string['nocommentsyet'] = 'Kommentaare pole veel.';
$string['noconnection'] = 'Hetkel pole ühendust seda küsimust töötleva veebiteenusega. Palun pöördu oma administraatori poole.';
$string['nodataset'] = 'mitte midagi – see pole metamärk';
$string['nodatasubmitted'] = 'Andmeid ei esitatud.';
$string['noessayquestionsfound'] = 'Käsitsi hinnatud küsimusi ei leitud';
$string['nogradewarning'] = 'Seda testi pole hinnatud, seetõttu ei saa te määrata hindest olenevat koondtagasisidet.';
$string['nomoreattempts'] = 'Rohkem testisoorituskatseid pole lubatud';
$string['none'] = 'Pole';
$string['noopen'] = 'Avamiskuupäeva pole';
$string['nooverridedata'] = 'Peate üle kirjutama vähemalt ühe testisätte.';
$string['nopossibledatasets'] = 'Mitte ühtegi võimalikku andmestikku';
$string['noquestionintext'] = 'See küsimuse tekst ei sisalda ühtegi lünka';
$string['noquestions'] = 'Küsimusi pole veel lisatud';
$string['noquestionsfound'] = 'Küsimusi ei leitud';
$string['noquestionsinquiz'] = 'Selles testis pole ühtegi küsimust';
$string['noquestionsnotinuse'] = 'See juhuküsimus pole kasutusel, kuna selle kategooriaväli on tühi.';
$string['noquestionsonpage'] = 'Tühi leht';
$string['noresponse'] = 'Vastus puudub';
$string['noreview'] = 'Teil pole selle õppetesti läbivaatamise luba';
$string['noreviewattempt'] = 'Teil pole selle testisoorituskatse läbivaatamise luba.';
$string['noreviewshort'] = 'Pole lubatud';
$string['noreviewuntil'] = 'Teil pole luba seda testi läbi vaadata enne {$a}';
$string['noreviewuntilshort'] = 'Saadaval kuni {$a}';
$string['noscript'] = 'Jätkamiseks peab JavaScript olema lubatud!';
$string['notavailabletostudents'] = 'Pange tähele: see test ei ole hetkel õppijatele avatud';
$string['notenoughrandomquestions'] = 'Küsimuse {$a->name} ({$a->id}) koostamiseks pole kategoorias {$a->category} piisavalt küsimusi.';
$string['notenoughsubquestions'] = 'Pole määratletud piisavalt alaküsimusi!<br />Kas soovite minna tagasi ja parandada seda küsimust?';
$string['notifyattemptsgradedtask'] = 'Saada testikatsete hindamise teatised';
$string['notimedependentitems'] = 'Praegune testimoodul ei toeta ajast sõltuvaid küsimusi. Te võite seada ajalimiidi kogu testile. Kas soovite valida teistsuguse küsimuse või (või sellest hoolimata kasutada praegust küsimust)?';
$string['notyetgraded'] = 'Hindeid pole';
$string['notyetviewed'] = 'Pole veel vaadatud';
$string['notyourattempt'] = 'See ei ole teie testisoorituskatse!';
$string['noview'] = 'Sisselogitud kasutajal pole luba selle õppetesti vaatamiseks';
$string['numattempts'] = '{$a->studentnum} kasutajat ({$a->studentstring}) on teinud {$a->attemptnum} testisoorituskatset';
$string['numberabbr'] = 'nr';
$string['numerical'] = 'Arvuline';
$string['numquestionsx'] = 'Küsimusi: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Ainult õpetajad võivad eksportida küsimusi';
$string['onlyteachersimport'] = 'Ainult toimetamisõigusega õpetajad võivad importida küsimusi';
$string['onthispage'] = 'See leht';
$string['open'] = 'Pole vastatud';
$string['openafterclose'] = 'Testi ei saanud värskendada. Oled määranud avatud kuupäeva peale sulgemiskuupäeva.';
$string['openclosedatesupdated'] = 'Õppetesti avamis- ja sulgemiskuupäevad on värskendatud';
$string['optional'] = 'valikuline';
$string['orderandpaging'] = 'Järjestus ja lehtedeks jaotus';
$string['orderandpaging_help'] = 'Numbrid 10, 20, 30, ... iga küsimuse vastas näitavad küsimuste järjestust. Numbrite suurendamise samm 10 jätab ruumi täiendavate küsimuste lisamiseks. Küsimuste ümberjärjestamiseks muutke numbreid ja klõpsake siis nuppu „Muuda küsimuste järjestust“.

Mõne kindla küsimuse järele lehepiiri lisamiseks märkige küsimuste kõrval olevad ruudud ja klõpsake siis nuppu „Lisa uued lehed valitud küsimuste järele“.

Küsimuste mitmele lehele jaotamiseks klõpsake nuppu „Muuda lehtedeks jaotust“ ja valige soovitud küsimuste arv lehe kohta.';
$string['orderingquiz'] = 'Järjestus ja lehtedeks jaotus';
$string['orderingquizx'] = 'Järjestus ja lehtedeks jaotus: {$a}';
$string['outcomesadvanced'] = 'Tulemused on täpsemad sätted';
$string['outof'] = '{$a->grade}, maksimaalne {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade}, maksimaalne {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Koondtagasiside';
$string['overallfeedback_help'] = 'Koondtagasiside on tekst, mis kuvatakse pärast õppetesti tegemist. Kui määratakse täiendavad hindepiirid (protsentides või numbrites), oleneb kuvatav tekst saadud hindest.';
$string['overdue'] = 'Tähtaja ületanud';
$string['overduehandling'] = 'Kui aeg saab otsa';
$string['overduehandling_desc'] = 'Selle sättega saab määrata, mis toimub siis, kui õppur ei esita õppetesti vastuseid enne ajalimiidi täitumist.';
$string['overduehandling_help'] = 'See säte määrab, mis saab siis, kui õppija ei esita testi soorituskatset enne aja lõppemist. Kui õppija sellel hetkel testi täidab, esitab taimer testi tema eest automaatselt, aga kui õppija on välja logitud, kontrollitakse käitumist selle sätte alusel.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Testisoorituskatse vastused tuleb esitada enne ajalimiidi täitumist, muidu katset ei arvestata';
$string['overduehandlingautosubmit'] = 'Avatud testisoorituskatsete vastused esitatakse automaatselt';
$string['overduehandlinggraceperiod'] = 'Pärast tähtaega saab ajapikendusperioodi jooksul esitada avatud soorituskatsed, aga küsimustele enam vastata ei saa.';
$string['overduemustbesubmittedby'] = 'See soorituskatse on tähtaja ületanud. See peaks olema juba esitatud. Kui soovite lasta selle testi hinnata, tuleb see esitada hiljemalt {$a}. Kui te seda selleks ajaks ei esita, ei arvestata selle soorituskatse eest saadud hindeid.';
$string['override'] = 'Kirjuta üle';
$string['overridedeletegroupsure'] = 'Kas soovite kindlasti kustutada rühma {$a} testisätete ülekirjutuse?';
$string['overridedeleteusersure'] = 'Kas soovite kindlasti kustutada kasutaja {$a} testisätete ülekirjutuse?';
$string['overridegroup'] = 'Kirjuta selle rühma sätted üle';
$string['overridegroupeventname'] = '{$a->quiz} – {$a->group}';
$string['overrides'] = 'Sätete ülekirjutused';
$string['overridesforquiz'] = 'Seadistuste ülekirjutused: {$a}';
$string['overridesnoneforgroups'] = 'Selle testi jaoks ei ole ühtegi rühma ülekirjutust loodud.';
$string['overridesnoneforusers'] = 'Selle testi jaoks ei ole ühtegi kasutaja ülekirjutust loodud.';
$string['overridessummary'] = 'Seadistuse ülekirjutus on olemas ({$a})';
$string['overridessummarygroup'] = 'Rühmad: {$a}';
$string['overridessummarythisgroup'] = 'Sellele rühmale kehtib seadistuse ülekirjutus ({$a})';
$string['overridessummaryuser'] = 'Kasutajad: {$a}';
$string['overridessummaryyourgroups'] = 'Rühmadele kehtib seadistuse ülekirjutus ({$a})';
$string['overrideuser'] = 'Kirjuta selle kasutaja sätted üle';
$string['overrideusereventname'] = '{$a->quiz} – sätete ülekirjutus';
$string['page-mod-quiz-attempt'] = 'Testi sooritamise leht';
$string['page-mod-quiz-edit'] = 'Õppetesti redigeerimise leht';
$string['page-mod-quiz-report'] = 'Kõik testi aruande lehed';
$string['page-mod-quiz-review'] = 'Soorituskatse läbivaatuse leht';
$string['page-mod-quiz-summary'] = 'Testi soorituskatse kokkuvõtte leht';
$string['page-mod-quiz-view'] = 'Testi teabe leht';
$string['page-mod-quiz-x'] = 'Mis tahes testi mooduli leht';
$string['pageshort'] = 'Lk';
$string['pagesize'] = 'Lehe formaat';
$string['parent'] = 'Ülem';
$string['parentcategory'] = 'Ülemkategooria';
$string['parsingquestions'] = 'Impordifaili küsimuste sõelumine.';
$string['partiallycorrect'] = 'Osaliselt õige';
$string['penalty'] = 'Trahv';
$string['penaltyscheme'] = 'Rakenda trahvid';
$string['penaltyscheme_help'] = 'Kui see säte on lubatud, lahutatakse vale vastuse korral küsimuse lõplikust punktisummast trahv. Karistuse määr on määratud küsimuse sätetes. See säte rakendub üksnes siis, kui adaptiivrežiim on lubatud.';
$string['percentcorrect'] = 'Õigete vastuste protsent';
$string['pleaseclose'] = 'Teie päring on töödeldud. Võid nüüd selle akna sulgeda.';
$string['pluginadministration'] = 'Õppetesti haldamine';
$string['pluginname'] = 'Test';
$string['popup'] = 'Kuva õppetest turvalises aknas';
$string['popupblockerwarning'] = 'See testi osa on turvalises režiimis, see tähendab, et pead testi tegema turvalises aknas. Lülita hüpikakende blokeerija välja. Aitäh.';
$string['popupnotice'] = 'Õppurid näevad seda testi turvalises aknas';
$string['preprocesserror'] = 'Eeltöötluse ajal ilmnes tõrge.';
$string['preview'] = 'Eelvaade';
$string['previewquestion'] = 'Kuva küsimuse eelvaade';
$string['previewquiz'] = '{$a} – eelvaade';
$string['previewquiznow'] = 'Kuva kohe õppetesti eelvaade';
$string['previewquizstart'] = 'Testi eelvaade';
$string['previous'] = 'Eelmine olek';
$string['privacy:metadata:core_question'] = 'Testitegevus salvestab küsimuse kasutamise teabe alamsüsteemi core_question.';
$string['privacy:metadata:quiz'] = 'Testitegevuses kasutatakse testiaruandeid.';
$string['privacy:metadata:quiz_attempts'] = 'Testi iga katse üksikasjad.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Katse number';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Lehekülg, millel kasutaja on.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Kas see on testi eelvaade.';
$string['privacy:metadata:quiz_attempts:state'] = 'Katse hetkestaatus.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Hinnete summa katsel.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Aeg, mil staatust kontrolliti.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'The time that the attempt was completed.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Katse värskendamise aeg.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Aeg, mil katset värskendati võrguühenduseta värskenduse kaudu.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Aeg, mil katset alustati.';
$string['privacy:metadata:quiz_grades'] = 'Selle testi üldhinde üksikasjad.';
$string['privacy:metadata:quiz_grades:grade'] = 'Selle testi üldhinne.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Testi hinnati';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Hinde muutmise aeg';
$string['privacy:metadata:quiz_grades:userid'] = 'Kasutaja keda hinnati';
$string['privacy:metadata:quiz_overrides'] = 'Selle testi alistamise üksikasjad';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Test koos alistamise infoga';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Uus testi sulgemise aeg';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Uus testi ajalimiit';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Uus testi avamise aeg';
$string['privacy:metadata:quiz_overrides:userid'] = 'Kasutaja, kes alistati';
$string['privacy:metadata:quizaccess'] = 'Testitegevuses kasutatakse testile juurdepääsu reegleid.';
$string['publish'] = 'Avalda';
$string['publishedit'] = 'Teil peab olema publitseeriva kursuse luba lisada ja muuta selle kategooria küsimusi';
$string['qbrief'] = 'K. {$a}';
$string['qname'] = 'nimi';
$string['qti'] = 'IMS-i QTI-vorming';
$string['qtypename'] = 'tüüp, nimi';
$string['question'] = 'Küsimus';
$string['questionbank'] = 'küsimustepangast';
$string['questionbankmanagement'] = 'Küsimustepanga haldamine';
$string['questionbehaviour'] = 'Küsimuse toimimine';
$string['questioncats'] = 'Küsimuse kategooriad';
$string['questiondeleted'] = 'See küsimus on kustutatud. Pöörduge oma õpetaja poole';
$string['questiondependencyadd'] = 'Pole piiranguid, mis reguleeriksid seda, millal saab küsimusele {$a->thisq} vastata • Klõpsake muutmiseks';
$string['questiondependencyfree'] = 'Sellel küsimusel pole piiranguid';
$string['questiondependencyremove'] = 'Küsimusele „{$a->thisq}“ ei saa proovida vastata enne, kui eelmine küsimus „{$a->previousq}“ on lõpule viidud. • Muutmiseks klõpsake';
$string['questiondependsonprevious'] = 'Sellele küsimusele saab vastata alles siis, kui olete andnud vastuse eelmisele küsimusele.';
$string['questioninuse'] = 'Küsimust \'{$a->questionname}\' kasutatakse hetkel: <br />{$a->quiznames}<br />Küsimust ei kustutata nendest testidest, vaid ainult kategooriast.';
$string['questionmissing'] = 'Selle sessiooni küsimus puudub';
$string['questionname'] = 'Küsimuse nimi';
$string['questionnonav'] = '<span class="accesshide">Küsimus </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Teave </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Küsimust {$a} pole andmebaasist laaditud';
$string['questionorder'] = 'Küsimuste järjestus';
$string['questionposition'] = 'Küsimuse {$a} uus koht järjestustes';
$string['questions'] = 'Küsimused';
$string['questionsetpreview'] = 'Küsimuste komplekti eelvaade';
$string['questionsinclhidden'] = 'Küsimused (kaasaarvatud peidetud)';
$string['questionsinthisquiz'] = 'Küsimused selles õppetestis';
$string['questionsmatchingfilter'] = 'Küsimused mis kattuvad selle filtriga: {$a}';
$string['questionsperpage'] = 'Küsimusi lehel';
$string['questionsperpageselected'] = 'Küsimused lehe kohta on määratud, nii et lehe otsimine on praegu fikseeritud. Selle tulemusel on lehitsemise juhtnupud keelatud. Saad seda muuta saidil {$a}.';
$string['questionsperpagex'] = 'Küsimusi lehekülje kohta: {$a}';
$string['questiontext'] = 'Küsimuse tekst';
$string['questiontextisempty'] = '[Tühi küsimuse tekst]';
$string['questiontype'] = 'Küsimusetüüp {$a}';
$string['questiontypesetupoptions'] = 'Küsimuste tüüpide seadistused:';
$string['questionversionlatest'] = 'v{$a} (viimane)';
$string['quiz:addinstance'] = 'Lisa uus õppetest';
$string['quiz:attempt'] = 'Õppetestide sooritamine';
$string['quiz:deleteattempts'] = 'Testisoorituskatsete kustutamine';
$string['quiz:emailconfirmsubmission'] = 'Kinnitusteate saamine testivastuste esitamisel';
$string['quiz:emailnotifyattemptgraded'] = 'Saa teavitus, kui sinu katse on hinnatud';
$string['quiz:emailnotifysubmission'] = 'Saa teavitusi selle kohta, et õpilased on testi vastuseid esitanud';
$string['quiz:emailwarnoverdue'] = 'Saa teavitus, kui sinu testikatse on aegunud';
$string['quiz:grade'] = 'Õppetestide käsitsi hindamine';
$string['quiz:ignoretimelimits'] = 'Testi ajapiirangu eiramine';
$string['quiz:manage'] = 'Õppetestide haldamine';
$string['quiz:manageoverrides'] = 'Testisätete ülekirjutuste haldamine';
$string['quiz:preview'] = 'Õppetestide eelvaate kuvamine';
$string['quiz:regrade'] = 'Testisoorituskatsete uuesti hindamine';
$string['quiz:reopenattempts'] = 'Taasava esitamata testikatsed';
$string['quiz:reviewmyattempts'] = 'Oma testisoorituskatsete läbivaatamine';
$string['quiz:view'] = 'Õppetesti teabe vaatamine';
$string['quiz:viewoverrides'] = 'Vaata testisätete ülekirjutusi';
$string['quiz:viewreports'] = 'Õppetesti aruannete vaatamine';
$string['quizavailable'] = 'Test on avatud kuni: {$a}';
$string['quizclose'] = 'Sule test';
$string['quizclosed'] = 'See õppetest on suletud {$a}';
$string['quizcloses'] = 'Õppetest suletakse';
$string['quizcloseson'] = 'See test suletakse {$a}';
$string['quizeventcloses'] = '{$a} sulgub';
$string['quizeventopens'] = '{$a} avaneb';
$string['quizisclosed'] = 'See õppetest on suletud';
$string['quizisclosedwillopen'] = 'Õppetest on suletud (avatakse {$a})';
$string['quizisopen'] = 'See õppetest on avatud';
$string['quizisopenwillclose'] = 'Õppetest on avatud (suletakse {$a})';
$string['quiznavigation'] = 'Õppetestis liikumine';
$string['quizopen'] = 'Ava test';
$string['quizopenclose'] = 'Avamis- ja sulgemiskuupäevad';
$string['quizopenclose_help'] = 'Õppurid saavad hakata õppetesti tegema pärast avamisaega ja peavad oma testisoorituskatsed lõpetama enne sulgemisaega.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'See test on avatud.';
$string['quizopenedon'] = 'Testi avamise aeg: {$a}';
$string['quizopens'] = 'Õppetest avatakse';
$string['quizopenwillclose'] = 'See test on avatud ja sulgub {$a} kell';
$string['quizordernotrandom'] = 'Testi järjekorda pole segatud';
$string['quizorderrandom'] = 'Testi järjekord on segatud';
$string['quizreport'] = 'Testi aruanne';
$string['quizsettings'] = 'Õppetestisätted';
$string['quiztimer'] = 'Õppetestitaimer';
$string['quizwillopen'] = 'See õppetest avatakse {$a}';
$string['random'] = 'Juhuslik küsimus';
$string['randomcreate'] = 'Loo juhuslikke küsimusi';
$string['randomediting'] = 'Juhusliku küsimuse redigeerimine';
$string['randomfromcategory'] = 'Juhuküsimus kategooriast:';
$string['randomfromexistingcategory'] = 'Juhuküsimus olemasolevast kategooriast';
$string['randomfromunavailabletag'] = '{$a} (kättesaamatu)';
$string['randomnosubcat'] = 'Küsimused ainult sellest kategooriast, mitte selle alamkategooriatest.';
$string['randomnumber'] = 'Juhuküsimuste arv';
$string['randomquestion'] = 'Juhuslik küsimus';
$string['randomquestion_help'] = 'Juhuslik küsimus on võimalus sisestada juhuslikult valitud küsimuste kategooriast või määratud sildi abil tegevusse.';
$string['randomquestiontags'] = 'Sildid';
$string['randomquestiontags_help'] = 'Võid valikukriteeriume veelgi piirata, määrates siin mõned küsimuste sildid.

"Juhuslikud" küsimused valitakse küsimuste hulgast, millel on kõik need sildid.';
$string['randomquestionusinganewcategory'] = 'Juhuküsimus, kasutades uut kategooriat';
$string['randomwithsubcat'] = 'Küsimused sellest kategooriast ja selle alamkategooriatest.';
$string['readytosend'] = 'Oled saatmas kogu oma testi hindamisele. Kas oled veendunud, et soovid jätkata?';
$string['reattemptquiz'] = 'Tee test uuesti';
$string['recentlyaddedquestion'] = 'Hiljuti lisatud küsimus!';
$string['recurse'] = 'Kaasa ka alamkategoorias asuvad küsimused';
$string['redoesofthisquestion'] = 'Muud küsimused, mida on proovitud sooritada: {$a}';
$string['redoquestion'] = 'Proovige teist sellesarnast küsimust';
$string['regrade'] = 'Hinda kõik testisoorituskatsed uuesti';
$string['regradecomplete'] = 'Kõik katsed on uuesti hinnatud';
$string['regradecount'] = '{$a->changed} hinnet {$a->attempt} hindest muudetud';
$string['regradedisplayexplanation'] = 'Hindamise ajal muutunud katseid kuvatakse hüperlinkidena küsimuste ülevaatamise aknasse.';
$string['regradenotallowed'] = 'Teil pole õigust seda testi uuesti hinnata';
$string['regradingquestion'] = 'Küsimuse "{$a}" uuesti hindamine.';
$string['regradingquiz'] = 'Testi „{$a}“ uuesti hindamine';
$string['remove'] = 'Eemalda';
$string['removeallgroupoverrides'] = 'Kustuta kõik rühma testisätete ülekirjutused.';
$string['removeallquizattempts'] = 'Kustuta kõik soorituskatsed';
$string['removealluseroverrides'] = 'Kustuta kõik kasutaja testisätete ülekirjutused.';
$string['removeemptypage'] = 'Eemalda tühi leht';
$string['removepagebreak'] = 'Eemalda lehepiir';
$string['removeselected'] = 'Eemalda valitud';
$string['rename'] = 'Nimeta ümber';
$string['renderingserverconnectfailed'] = 'Server {$a} ei suutnud RQP päringut töödelda. Kontrolli, kas URL on õige.';
$string['reorderquestions'] = 'Muuda küsimuste järjestust';
$string['reordertool'] = 'Kuva ümberjärjestustööriist';
$string['repaginate'] = 'Muuda lehtedeks jaotust, nii et igal lehel oleks {$a} küsimust';
$string['repaginatecommand'] = 'Muuda lehtedeks jaotust';
$string['repaginatenow'] = 'Muuda kohe lehtedeks jaotust';
$string['replace'] = 'Asenda';
$string['replacementoptions'] = 'Asenduse valikud';
$string['report'] = 'Aruanded';
$string['reportanalysis'] = 'Küsimuste analüüs';
$string['reportattemptsfrom'] = 'Testisoorituskatsete tegijad';
$string['reportattemptsthatare'] = 'Testisoorituskatsed, mis on';
$string['reportdisplayoptions'] = 'Kuvamissätted';
$string['reportfullstat'] = 'Detailne statistika';
$string['reportmulti_percent'] = 'Multi-protsendid';
$string['reportmulti_q_x_student'] = 'Mitme-õppija valikud';
$string['reportmulti_resp'] = 'Individuaalsed reageeringud';
$string['reportmustselectstate'] = 'Peate valima vähemalt ühe oleku.';
$string['reportnotfound'] = 'Aruanne pole teada ({$a})';
$string['reportoverview'] = 'Ülevaade';
$string['reportregrade'] = 'Hinda katseid uuesti';
$string['reportresponses'] = 'Vastuste üksikasjavaade';
$string['reports'] = 'Aruanded';
$string['reportshowonly'] = 'Kuva ainult testisoorituskatsed';
$string['reportshowonlyfinished'] = 'Kuva ainult üks lõpule viidud soorituskatse kasutaja kohta ({$a})';
$string['reportsimplestat'] = 'Lihtne statistika';
$string['reportusersall'] = 'kõik kasutajad, kes on testi teinud';
$string['reportuserswith'] = 'registreerunud kasutajad, kes on testi teinud';
$string['reportuserswithorwithout'] = 'registreerunud kasutajad, kes on või pole testi teinud';
$string['reportuserswithout'] = 'registreerunud kasutajad, kes pole testi teinud';
$string['reportwhattoinclude'] = 'Aruandesse kaasatavad andmed';
$string['requirepassword'] = 'Nõua parooli';
$string['requirepassword_help'] = 'Kui parool on määratud, peab õppur testi tegemiseks sisestama parooli.';
$string['requiresubnet'] = 'Nõua võrguaadressi';
$string['requiresubnet_help'] = 'Õppetestile juurdepääsu saab piirata, määrates osaliste või täielike IP-aadresside numbrite komaeraldusega loendi, nii et testi saab teha ainult kindlates kohtvõrgu (LAN) või Interneti alamvõrkudes. Sellest võib kasu olla vaatlejatega testide korral, et tagada inimeste juurdepääs testile ainult kindlatest kohtadest.';
$string['response'] = 'Reageering';
$string['responses'] = 'Vastused';
$string['results'] = 'Tulemused';
$string['returnattempt'] = 'Naase testisoorituskatse juurde';
$string['reuseifpossible'] = 'taaskasuta varem eemaldatut';
$string['reverttodefaults'] = 'Lähtesta õppetesti vaikesätted';
$string['review'] = 'Läbivaatus';
$string['reviewafter'] = 'Luba üle vaadata peale testi sulgemist';
$string['reviewalways'] = 'Luba üle vaadata igal ajal';
$string['reviewattempt'] = 'Vaata testisoorituskatse läbi';
$string['reviewbefore'] = 'Luba üle vaadata, kui test on avatud';
$string['reviewclosed'] = 'Pärast testi sulgemist';
$string['reviewduring'] = 'Testisoorituskatse ajal';
$string['reviewimmediately'] = 'Kohe pärast testisoorituskatset';
$string['reviewnever'] = 'Ära kunagi luba ülevaadet';
$string['reviewofquestion'] = 'Testi „{$a->quiz}“ küsimuse „{$a->question}“ õppija {$a->user} esitatud vastuse läbivaatamine';
$string['reviewopen'] = 'Hiljem, kui test on veel avatud';
$string['reviewoptions'] = 'Õppurid saavad läbi vaadata';
$string['reviewoptionsheading'] = 'Läbivaatusevalikud';
$string['reviewoptionsheading_help'] = 'Need sätted määravad selle, mis teave õppijatele kuvatakse, kui nad soorituskatset läbi vaatavad või testi aruande avavad.

**Soorituskatse ajal** kuvatavat reguleerivad sätted on asjakohased ainult mõnes režiimis (nt interaktiivne, mitme katsega), kus tagasisidet antakse jooksvalt soorituskatse ajal.

**Kohe pärast soorituskatset** kuvatavat reguleerivad sätted määravad selle, mis on nähtav kaks minutit pärast nupu „Esita kõik ja lõpeta“ klõpsamist.

Pärast seda, aga enne testi sulgemiskuupäeva kuvatakse sisu vastavalt sätetele **Hiljem, kui test on veel avatud** .

Sätted **Pärast testi sulgemist** rakenduvad pärast testi sulgemiskuupäeva möödumist. Kui testil pole sulgemiskuupäeva, ei rakendu need sätted kunagi.';
$string['reviewoverallfeedback'] = 'Koondtagasiside';
$string['reviewoverallfeedback_help'] = 'Tagasiside, mis antakse testisoorituskatse lõpus vastavalt õppuri saadud hindepunktidele.';
$string['reviewresponse'] = 'Vaata vastus läbi';
$string['reviewresponsetoq'] = 'Vaata vastus läbi (küsimus {$a})';
$string['reviewthisattempt'] = 'Vaadake oma selle testisoorituskatse vastused läbi';
$string['rqp'] = 'Kaugpangaküsimus';
$string['rqps'] = 'Välised küsimused';
$string['sameasoverall'] = 'Sama nagu üldhinnete korral';
$string['save'] = 'Salvesta';
$string['saveandedit'] = 'Salvesta muudatused ja muuda küsimusi';
$string['saveattemptfailed'] = 'Käesoleva testikatse salvestamine ebaõnnestus';
$string['savedfromdeletedcourse'] = 'Salvestatud kustutatud kursuselt  "{$a}"';
$string['savegrades'] = 'Salvesta hinded';
$string['savemyanswers'] = 'Salvesta minu vastused';
$string['savenosubmit'] = 'Salvesta ilma esitamiseta';
$string['saveoverrideandstay'] = 'Salvesta ja sisesta veel üks ülekirjutus';
$string['savequiz'] = 'Salvesta kogu test';
$string['saving'] = 'Salvestamine';
$string['savingnewgradeforquestion'] = 'Küsimuse-ID {$a} jaoks salvestatakse uus hinne.';
$string['savingnewmaximumgrade'] = 'Salvestatakse uus maksimumhinne.';
$string['score'] = 'Töötlemata punktisumma';
$string['scores'] = 'Punktisummad';
$string['search:activity'] = 'Õppetest – tegevuse teave';
$string['sectionheadingedit'] = 'Muuda pealkirja „{$a}“';
$string['sectionheadingremove'] = 'Eemalda pealkiri „{$a}“';
$string['seequestions'] = '(Vt küsimusi)';
$string['select'] = 'Valige';
$string['selectall'] = 'Vali kõik';
$string['selectattempt'] = 'Vali katsed';
$string['selectcategory'] = 'Vali kategooria';
$string['selectedattempts'] = 'Valitud katsed...';
$string['selectmultipleitems'] = 'Vali mitu üksust';
$string['selectmultipletoolbar'] = 'Vali mitu tööriistariba';
$string['selectnone'] = 'Tühjenda kõik ruudud';
$string['selectquestiontype'] = '-- Vali küsimuse tüüp --';
$string['serveradded'] = 'Server lisatud';
$string['serveridentifier'] = 'Identifikaator';
$string['serverinfo'] = 'Serveriteave';
$string['servers'] = 'Serverid';
$string['serverurl'] = 'Serveri URL';
$string['shortanswer'] = 'Lühivastus';
$string['show'] = 'Kuva';
$string['showall'] = 'Kuva kõik küsimused ühel lehel';
$string['showblocks'] = 'Kuva testisoorituskatsete ajal plokid';
$string['showblocks_help'] = 'Kui selle sätte väärtuseks on seatud Jah, kuvatakse testisoorituskatsete ajal tavalised plokid';
$string['showbreaks'] = 'Näita leheküljepiiri';
$string['showcategorycontents'] = 'Kuva kategooriasisu {$a->arrow}';
$string['showcorrectanswer'] = 'Kas näitan tagasisides õigeid vastuseid?';
$string['showdetailedmarks'] = 'Kuva hindepunktide üksikasjad';
$string['showeachpage'] = 'Kuva korraga üks leht';
$string['showfeedback'] = 'Kas kuvada pärast vastamist tagasiside?';
$string['showinsecurepopup'] = 'Kasuta õppetesti tegemiseks turvalisi hüpikaknaid';
$string['showlargeimage'] = 'Suur pilt';
$string['shownoattempts'] = 'Näita õppijaid, kes pole teinud katseid';
$string['shownoattemptsonly'] = 'Näita ainult õppijaid, kes pole teinud katseid';
$string['shownoimage'] = 'Pilti pole';
$string['showreport'] = 'Kuva aruanne';
$string['showsmallimage'] = 'Väike pilt';
$string['showteacherattempts'] = 'Näita õpetaja katseid';
$string['showuserpicture'] = 'Kuva kasutaja pilt';
$string['showuserpicture_help'] = 'Kui see on lubatud, kuvatakse õppuri nimi ja pilt nii testisoorituskatse kuval kui ka läbivaatuskuval, võimaldades vaatlejatega õppetesti korral hõlpsamini kindlaks teha, kas õppur on sisse loginud iseendana.';
$string['shuffle'] = 'Muuda küsimuste järjekorda';
$string['shuffleanswers'] = 'Muuda vastuste järjekorda';
$string['shuffledrandomly'] = 'Seatud juhujärjestusse';
$string['shufflequestions'] = 'Muuda küsimuste järjekorda';
$string['shufflequestions_help'] = 'Kui see on sisse lülitatud, muudetakse küsimuste järjekorda juhuslikult testi iga soorituskatse korral.

See muudab küsimuste jagamise õppijate jaoks raskemaks, samas on õppijatel sel juhul keerulisem ka teiega konkreetseid küsimusi arutada.';
$string['shufflewithin'] = 'Muuda küsimuseosade järjekorda';
$string['shufflewithin_help'] = 'Kui see valik on lubatud, siis segatakse osad, millest küsimused koosnevad, juhuslikult iga kord, kui õppur alustab testisoorituskatset. Eelduseks on, et see valik on lubatud ka küsimusesätetes. See säte rakendub vaid küsimustele, mis koosnevad mitmest osast (nt valikvastusega küsimused või vastavusse viimise küsimused).';
$string['singleanswer'] = 'Valige üks vastus.';
$string['sortage'] = 'Järjesta vanuse järgi';
$string['sortalpha'] = 'Järjesta alfabeetiliselt';
$string['sortquestionsbyx'] = 'Sorteeri küsimused: {$a}';
$string['sortsubmit'] = 'Järjesta küsimused';
$string['sorttypealpha'] = 'Järjesta liigi, nimetuse järgi';
$string['specificapathnotonquestion'] = 'Määratud faili tee pole küsimused määratud';
$string['specificquestionnotonquiz'] = 'Täpsustatud küsimust ei ole testis määratud';
$string['startagain'] = 'Alusta uuesti';
$string['startattempt'] = 'Alusta testi tegemist';
$string['startedon'] = 'Alustatud';
$string['startnewpreview'] = 'Käivita uus eelvaade';
$string['stateabandoned'] = 'Pole kunagi esitatud';
$string['statefinished'] = 'Lõpetatud';
$string['statefinisheddetails'] = 'Esitatud {$a}';
$string['stateinprogress'] = 'Pooleli';
$string['statenotloaded'] = 'Küsimuse {$a} olekut pole andmebaasist laaditud';
$string['stateoverdue'] = 'Tähtaja ületanud';
$string['stateoverduedetails'] = 'Peab olema esitatud {$a}';
$string['status'] = 'Olek';
$string['stoponerror'] = 'Lõpeta vea korral';
$string['submitallandfinish'] = 'Esita kõik ja lõpeta';
$string['subneterror'] = 'Vabandame, see küsimus on lukustatud, seega kättesaadav ainult teatud asukohtadest. Hetkel ei ole sinu arvuti lubatute nimekirjas.';
$string['subnetnotice'] = 'See küsimus on lukustatud, seega kättesaadav ainult teatud asukohtadest. Sinu arvuti ei kuulu lubatud alamvõrku. Aga õpetajana on sul lubatud eelvaadet näha nagunii.';
$string['subplugintype_quiz'] = 'Aruanne';
$string['subplugintype_quiz_plural'] = 'Aruanded';
$string['subplugintype_quizaccess'] = 'Pääsureegel';
$string['subplugintype_quizaccess_plural'] = 'Pääsureeglid';
$string['substitutedby'] = 'asendatakse';
$string['summaryofattempt'] = 'Testisoorituskatse kokkuvõte';
$string['summaryofattempts'] = 'Teie eelmiste testisoorituskatsete kokkuvõte';
$string['temporaryblocked'] = 'Sul pole ajutiselt lubatud testi uuesti proovida.<br />Saad teha järgmist katset:';
$string['theattempt'] = 'Testisoorituskatse';
$string['theattempt_help'] = 'Määrab, kas õppija saab soorituskatse läbi vaadata.';
$string['time'] = 'Aeg';
$string['timecompleted'] = 'Lõpetatud';
$string['timedelay'] = 'Sul pole lubatud testi teha, kuna sa ei ole enne uue testi katset viivitanud';
$string['timeleft'] = 'Aega jäänud';
$string['timelimit'] = 'Ajapiirang';
$string['timelimit_help'] = 'Kui see säte on lubatud, kuvatakse testi alguslehel ajapiirang ja testi navigeerimisplokis taimer.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Vabandame! Testi sooritamise aeg ületatud!';
$string['timestr'] = '%H:%M:%S %d.%m.%y';
$string['timesup'] = 'Aeg on läbi!';
$string['timetaken'] = 'Aega kulus';
$string['timing'] = 'Ajastus';
$string['tofile'] = 'faili';
$string['tolerance'] = 'Lubatav hälve';
$string['toomanyrandom'] = 'Nõutud juhuküsimuste arv on suurem kui selles kategoorias saadaolevate küsimuste arv!';
$string['top'] = 'Üles';
$string['totalmarksx'] = 'Hindepunktide kogusumma: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Kategoorias on kokku {$a} küsimust.';
$string['true'] = 'Tõene';
$string['truefalse'] = 'Tõene/väär';
$string['type'] = 'Tüüp';
$string['unfinished'] = 'avatud';
$string['ungraded'] = 'Hindamata';
$string['unit'] = 'Ühik';
$string['unknowntype'] = 'Küsimusetüüp real {$a} pole toetatud. Küsimust eiratakse';
$string['updateoverdueattemptstask'] = 'Tähtaja ületanud viktoriinikatsete värskendamine';
$string['updatequizslotswithrandomxofy'] = 'Testipesade värskendamine juhuslike küsimuste andmetega ({$a->done} / {$a->total})';
$string['updatesettings'] = 'Uuenda testi seadeid';
$string['updatingatttemptgrades'] = 'Testisoorituskatse hinnete värskendamine';
$string['updatingfinalgrades'] = 'Lõpphinnete värskendamine';
$string['updatingthegradebook'] = 'Hinnetelehe värskendamine.';
$string['upgradesure'] = '<div>Täpsemalt teeb testi moodul ulatusliku testi tabelite muudatuse ja seda uuendust pole veel piisavalt testitud. Tungivalt soovitatav on enne jätkamist andmebaasitabelid varundada.</div>';
$string['upgradingquizattempts'] = 'Testisoorituskatsete üleviimine uude tarkvaraversiooni: test {$a->done}/{$a->outof} (õppetesti ID {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Väga vanade testisoorituskatsete üleviimine uude tarkvaraversiooni: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'See kategooria liigutati õpikeskkonna tasemele, kuna pärast kursuse kustutamist kasutati selle kategooria küsimusi serveri teistes testides.';
$string['useroverrides'] = 'Kasutaja testisätete ülekirjutused';
$string['useroverridesdeleted'] = 'Kasutaja testisätete ülekirjutused on kustutatud.';
$string['usersnone'] = 'Õppurid ei pääse sellele testile juurde';
$string['validate'] = 'Valideeri';
$string['viewallanswers'] = 'Vaata {$a} testikatset';
$string['viewallreports'] = 'Kuva {$a} katse kokkuvõtted';
$string['viewed'] = 'Vaadatud';
$string['warningmissingtype'] = '<b>Seda küsimusetüüpi pole veel teie kasutuses olevasse Moodle’isse installitud.<br />Teavitage oma Moodle’i administraatorit.</b>';
$string['wheregrade'] = 'Kus on minu hinded?';
$string['wildcard'] = 'Metamärk';
$string['windowclosing'] = 'See aken sulgub mõne hetke pärast.';
$string['withsummary'] = 'koos kokkuvõtliku statistikaga';
$string['wronguse'] = 'Sa ei saa kasutada seda lehekülge niimoodi';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Selle õppetesti tegemiseks peate kõigepealt registreeruma kursusele';
$string['yourfinalgradeis'] = 'Teie lõpphinne selle testi eest on {$a}';
