<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'sl', version '4.3'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bigfile'] = 'Velika datoteka {$a}';
$string['courseexplanation'] = 'To orodje ustvarja standardne testne predmete, ki vsebujejo veliko razdelkov, dejavnosti in datotek.

 To je namenjeno zagotavljanju standardiziranega merila za preverjanje zanesljivosti in učinkovitosti različnih sistemskih komponent (kot sta varnostno kopiranje in obnavljanje).

 Test je pomemben, ker je bilo v preteklosti veliko primerov, kjer sistem, ki se sooča z resničnimi primeri uporabe (npr. predmeti s 1.000 dejavnostmi), ni deloval.

Predmeti, ustvarjeni s to funkcijo, lahko zasedejo veliko prostora v podatkovni bazi in datotečnem sistemu (več desetin gigabajtov). Če želite sprostiti ta prostor, izbrišite te predmete (in počakajte na različne postopke čiščenja).

**Te funkcije ne uporabljajte v živem sistemu**Uporabljajte samo na strežniku za razvijalce. (Da bi se izognili nenamerni uporabi, je ta funkcija onemogočena, razen če ste izbrali raven razhroščevanja RAZVIJALEC).';
$string['coursesize_0'] = 'XS (približno 10 KB; ustvarite v približno 1 sekundi)';
$string['coursesize_1'] = 'S (približno 10 MB; ustvarite v približno 30 sekundah)';
$string['coursesize_2'] = 'M (približno 100 MB; ustvarite v približno 2 minutah)';
$string['coursesize_3'] = 'L (približno 1 GB; ustvarite v približno 30 minutah)';
$string['coursesize_4'] = 'XL (približno 10 GB; ustvarite v približno 2 urah)';
$string['coursesize_5'] = 'XXL (približno 20 GB; ustvarite v približno 4 urah)';
$string['coursewithoutusers'] = 'Izbrani predmet nima uporabnikov';
$string['createcourse'] = 'Ustvari predmet';
$string['createtestplan'] = 'Ustvari testni načrt';
$string['creating'] = 'Ustvarjanje predmeta';
$string['done'] = 'dokončano ({$a}s)';
$string['downloadtestplan'] = 'Prenesi testni načrt';
$string['downloadusersfile'] = 'Prenesi datoteko uporabnikov';
$string['error_nocourses'] = 'Ni obstoječih predmetov za izdelavo testnega načrta';
$string['error_noforumdiscussions'] = 'Izbrani predmet ne vsebuje razprav na forumu';
$string['error_noforuminstances'] = 'Izbrani predmet ne vsebuje primerov modulov foruma';
$string['error_noforumreplies'] = 'Izbrani predmet ne vsebuje odgovorov na forumu';
$string['error_nonexistingcourse'] = 'Navedeni predmet ne obstaja';
$string['error_nopageinstances'] = 'Izbrani predmet ne vsebuje primerov modulov strani';
$string['error_notdebugging'] = 'Ni na voljo na tem strežniku, ker razhroščevanje ni nastavljeno na RAZVIJALEC';
$string['error_nouserspassword'] = 'Če želite ustvariti testni načrt, morate nastaviti $CFG->tool_generator_users_password v config.php';
$string['fullname'] = 'Testni predmet: {$a->size}';
$string['maketestcourse'] = 'Naredi testni predmet';
$string['maketestplan'] = 'Naredi testni načrt JMeter';
$string['notenoughusers'] = 'Izbrani predmet nima dovolj uporabnikov';
$string['pluginname'] = 'Generator razvojnih podatkov';
$string['privacy:metadata'] = 'Vtičnik za generiranje podatkov razvoja ne shrani nobenih osebnih podatkov.';
$string['progress_checkaccounts'] = 'Preverjanje uporabniških računov ({$a})';
$string['progress_coursecompleted'] = 'Predmet je dokončan ({$a}s)';
$string['progress_createaccounts'] = 'Ustvarjanje uporabniških računov ({$a->from} - {$a->to})';
$string['progress_createassignments'] = 'Ustvarjanje nalog ({$a})';
$string['progress_createbigfiles'] = 'Ustvarjanje velikih datotek ({$a})';
$string['progress_createcourse'] = 'Ustvarjanje predmeta {$a}';
$string['progress_createforum'] = 'Ustvarjanje foruma({$a} objav)';
$string['progress_createpages'] = 'Ustvarjanje strani ({$a})';
$string['progress_createsmallfiles'] = 'Ustvarjanje majhnih datotek ({$a})';
$string['progress_enrol'] = 'Vpis uporabnikov v predmet ({$a})';
$string['progress_sitecompleted'] = 'Stran je dokončana ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~ 10 MB; 3 predmeti, ustvarjeni v približno 30 sekundah)';
$string['sitesize_1'] = 'S (~ 50 MB; 8 predmetov, ustvarjenih v približno 2 minutah)';
$string['sitesize_2'] = 'M (~ 200 MB; 73 predmetov, ustvarjenih v približno 10 minutah)';
$string['sitesize_3'] = 'L (~ 1\'5 GB; 277 predmetov, ustvarjenih v približno 1\'5 urah)';
$string['sitesize_4'] = 'XL (~ 10 GB; 1065 predmetov, ustvarjenih v približno 5 urah)';
$string['sitesize_5'] = 'XL (~ 20 GB; 4177 predmetov, ustvarjenih v približno 10 urah)';
$string['size'] = 'Velikost predmetov';
$string['smallfiles'] = 'Male datoteke';
$string['targetcourse'] = 'Preizkusi ciljni predmet';
$string['testplanexplanation'] = 'To orodje ustvari datoteko načrta testa JMETER skupaj z datoteko uporabniških poverilnic.

 Ta načrt testa je zasnovan tako, da deluje skupaj z {$ a}, kar olajša zagon načrta testa v določenem okolju Moodle, zbira informacije o zagonih in primerja rezultate, zato ga morate prenesti in uporabiti skripto test_runner.sh ali pa sledite navodilom za namestitev in uporabo.

 Za uporabnike predmeta morate nastaviti geslo (npr. $CFG->tool_generator_users_password = \'moodle\'';
$string['testplansize_0'] = 'XS ({$a->users} uporabnikov, {$a->loops} zank in {$a->rampup} obdobje naraščanja)';
$string['testplansize_1'] = 'S ({$a->users} uporabnikov, {$a->loops} zank in {$a->rampup} obdobje naraščanja)';
$string['testplansize_2'] = 'M ({$a->users} uporabnikov, {$a->loops} zank in {$a->rampup} obdobje naraščanja)';
$string['testplansize_3'] = 'L ({$a->users} uporabnikov, {$a->loops} zank in {$a->rampup} obdobje naraščanja)';
$string['testplansize_4'] = 'XL ({$a->users} uporabnikov, {$a->loops} zank in {$a->rampup} obdobje naraščanja)';
$string['testplansize_5'] = 'XXL ({$a->users} uporabnikov, {$a->loops} zank in {$a->rampup} obdobje naraščanja)';
$string['updateuserspassword'] = 'Posodobite geslo uporabnikov predmeta';
$string['updateuserspassword_help'] = 'JMeter se mora prijaviti kot uporabniki predmeta, geslo uporabnika lahko nastavite z uporabo $CFG->tool_generator_users_password v config.php;a nastavitev posodobi geslo uporabnika tečaja v skladu s to $CFG->tool_generator_users_password. To je uporabno, če uporabljate predmet, ki ni bil generiran z orodjem ali če geslo uporabnika $CFG->tool_generator_users_password ni bilo nastavljeno, ko ste ustvarili testni predmet.';
