<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'zh_cn', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = '辅助技术标签';
$string['acceptTerms'] = '我接受 <a href=":url" target="_blank">使用条款</a>';
$string['accountDetailsLinkText'] = '这里';
$string['actions'] = '设置';
$string['add'] = '添加';
$string['addedandupdatedpp'] = '添加了 {$a->%new} 新 H5P 库并更新了 {$a->%old} 旧库。';
$string['addedandupdatedps'] = '添加了 {$a->%new} 新的 H5P 库并更新了 {$a->%old} 旧库。';
$string['addedandupdatedsp'] = '添加了 {$a->%new} 新的 H5P 库并更新了 {$a->%old} 旧库。';
$string['addedandupdatedss'] = '添加了 {$a->%new} 新的 H5P 库并更新了 {$a->%old} 旧库。';
$string['addednewlibraries'] = '添加了 {$a->%new} 新的 H5P 库。';
$string['addednewlibrary'] = '添加了 {$a->%new} 新的 H5P 库。';
$string['additionallicenseinfo'] = '关于许可证的附加信息';
$string['address'] = '地址';
$string['age'] = '典型年龄';
$string['ageDescription'] = '此内容的目标受众。可能的输入格式，以逗号分隔：“ 1,34 -45,- 50,59 -”。';
$string['altText'] = '替代文字';
$string['atto_h5p'] = '插入H5P按钮';
$string['atto_h5p_description'] = 'Atto 编辑器中的插入 H5P 按钮使用户能够通过输入 URL 或嵌入代码，或者通过上传 H5P 文件来插入 H5P 内容。';
$string['author'] = '作者';
$string['authorcomments'] = '作者评论';
$string['authorcommentsdescription'] = '内容编辑者的评论。(此文本将不作为版权信息的一部分发布。)';
$string['authorname'] = '作者的姓名';
$string['authorrole'] = '作者的角色';
$string['back'] = '返回';
$string['by'] = '由';
$string['cancelCrop'] = '取消裁剪';
$string['cancelPublishConfirmationDialogCancelButtonText'] = '不';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = '是';
$string['cancelPublishConfirmationDialogDescription'] = '您确实要取消分享过程吗？';
$string['cancelPublishConfirmationDialogTitle'] = '取消分享';
$string['cancellabel'] = '取消';
$string['ccattribution'] = '署名（CC BY-NC-ND）';
$string['ccattributionnc'] = '署名-非商业（CC BY-NC）';
$string['ccattributionncnd'] = '署名-非商业-禁止改作（CC BY-NC-ND）';
$string['ccattributionncsa'] = '署名- 非商业- 相同方式分享（CC BY-NC-SA）';
$string['ccattributionnd'] = '署名- 禁止改作（CC BY-NC-ND）';
$string['ccattributionsa'] = '署名- 相同方式分享（CC BY-NC-SA）';
$string['ccpdd'] = '公共领域贡献（CC0）';
$string['changeHasBeenSubmitted'] = '已提交更改';
$string['changedby'] = '更改人';
$string['changedescription'] = '更改描述';
$string['changelog'] = '更改日志';
$string['changeplaceholder'] = '照片裁剪，文字修改等。';
$string['city'] = '城市';
$string['close'] = '关闭';
$string['confirmCrop'] = '确认裁剪';
$string['confirmdialogbody'] = '请确认您要继续。 此操作无法撤消。';
$string['confirmdialogheader'] = '确认操作';
$string['confirmlabel'] = '确认';
$string['connectionLost'] = '连接断开。 连接恢复后，结果将被存储并发送。';
$string['connectionReestablished'] = '连接恢复。';
$string['contactPerson'] = '联系人';
$string['contactPersonDescription'] = '如果出版者分享的内容有任何问题，H5P将与联系人联系。联系人的姓名或其他信息将不会被公布或与第三方共享';
$string['contentAvailable'] = '您的内容通常一个工作日内即可出现在 Hub 中。';
$string['contentCopied'] = '内容已复制到剪贴板';
$string['contentLicenseTitle'] = '内容许可信息';
$string['contentUpdateSoon'] = '您的内容很快就会更新';
$string['contentchanged'] = '自您上次使用以来，此内容已更改。';
$string['contentinuse'] = '此内容可能在其他地方被使用。';
$string['contenttype'] = '内容类型';
$string['copyright'] = '使用权';
$string['copyrightWarning'] = '版权材料不能在H5P内容中心共享。如果内容使用的是对开放资源友好的许可协议，如知识共享协议，请选择合适的许可协议。否则，此内容不能共享。';
$string['copyrightinfo'] = '版权信息';
$string['copyrightstring'] = '版权';
$string['copyrighttitle'] = '查看此内容的版权信息。';
$string['couldNotParseJSONFromZip'] = '无法从包中解析 JSON：{$a->%fileName}';
$string['couldNotReadFileFromZip'] = '无法从包中读取文件：{$a->%fileName}';
$string['country'] = '国家';
$string['creativecommons'] = '创作共用';
$string['cropImage'] = '裁剪图像';
$string['currentStep'] = '步骤 :step 共 :total';
$string['date'] = '日期';
$string['deletelibraryconfirm'] = '<p>您确定要从库 <em>\'{$a->name}\'</em> 中删除版本 <em>\'{$a->version}\'</em> 吗？ 它将删除库及所有对它的使用。</p><p>此操作无法撤消。</p>';
$string['deletelibraryversion'] = '删除版本';
$string['deleting'] = '删除库';
$string['description'] = '描述';
$string['disablefullscreen'] = '禁用全屏';
$string['discipline:dropdownButton'] = '下拉按钮';
$string['discipline:in'] = '内';
$string['discipline:searchPlaceholder'] = '键入搜索学科';
$string['disciplineDescription'] = '您可以选择多个学科';
$string['disciplineLabel'] = '学科';
$string['disciplineLimitReachedMessage'] = '您最多可以选择 :numsubjects 学科';
$string['disciplines'] = '学科';
$string['download'] = '下载';
$string['downloadtitle'] = '将此内容下载为H5P文件。';
$string['editInfoTitle'] = '编辑 <strong>:title</strong> 的信息';
$string['editcontent'] = '编辑 H5P 内容';
$string['editingFailed'] = '编辑失败。';
$string['editor'] = '编辑';
$string['emailAddress'] = '电子邮件地址';
$string['emailAddressDescription'] = 'H5P将使用该电子邮件地址，以便在内容出现任何问题或发布者需要恢复其帐户时与发布者联系。它不会被发布或与任何第三方共享';
$string['embed'] = '嵌入';
$string['embedtitle'] = '查看此内容的嵌入代码。';
$string['error:emptycontentid'] = '给定的 URL 不正确，或者您无法编辑此文件。';
$string['eventh5pdeleted'] = 'H5P已删除';
$string['eventh5pviewed'] = '浏览过的 H5P 内容';
$string['feature'] = '特征';
$string['fetchtypesfailure'] = '无法获得有关可用 H5P 内容类型的信息。 H5P 存储库连接失败';
$string['fileExceedsMaxSize'] = '包内的文件之一超过了允许的最大文件大小。 ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = '显示H5P过滤器';
$string['filter_displayh5p_description'] = '这个显示的H5P过滤器将URL转换为嵌入的H5P内容。';
$string['fullscreen'] = '全屏';
$string['gpl'] = '通用公共许可证v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = '自定义 CSS';
$string['h5pcustomcss_help'] = '应用于 H5P 内容的 CSS。';
$string['h5peditor'] = 'H5P 编辑器';
$string['h5pfilenotfound'] = '未找到 H5P 文件';
$string['h5pinvalidurl'] = 'H5P 内容 URL 无效。';
$string['h5plibraryhandler'] = 'H5P 框架处理程序';
$string['h5plibraryhandler_help'] = 'H5P框架用于显示H5P内容。建议使用最新版本。';
$string['h5pmanage'] = '管理 H5P 内容类型';
$string['h5poverview'] = 'H5P概述';
$string['h5ppackage'] = 'H5P内容类型';
$string['h5ppackage_help'] = 'H5P 内容类型是具有 H5P 或 ZIP 扩展名的文件，其中包含显示内容所需的所有库。';
$string['h5pprivatefile'] = '无法显示此 H5P 内容，因为您无权访问 .h5p 文件。';
$string['h5psettings'] = 'H5P设置';
$string['h5ptitle'] = '访问 h5p.org 以检查更多内容。';
$string['height'] = '高度';
$string['helpChoosingLicense'] = '帮我选择一种许可证';
$string['hideadvanced'] = '隐藏高级';
$string['icon'] = '图标';
$string['iconDescription'] = '640x480px。如不选择内容将使用类别图标';
$string['installedcontentlibraries'] = '已安装的 H5P 库';
$string['installedcontenttypes'] = '已安装的 H5P 内容类型';
$string['installedh5p'] = '已安装 H5P';
$string['invalidAge'] = '典型年龄的输入格式无效。可能的输入格式，以逗号分隔：“ 1,34 -45,-50,-59-”。';
$string['invalidcontextid'] = '未找到 H5P 文件（无效的contextid）';
$string['invalidfile'] = '不允许文件“{$a->%filename}”。 仅允许具有以下扩展名的文件：{$a->%files-allowed}。';
$string['invalidlanguagefile'] = '库 {$a->%library} 中的语言文件 {$a->%file} 无效';
$string['invalidlanguagefile2'] = '无效的语言文件 {$a->%languageFile} 已包含在库 {$a->%name} 中';
$string['invalidlibrarydata'] = '为 {$a->%library} 中的 {$a->%property} 提供的数据无效';
$string['invalidlibrarydataboolean'] = '为 {$a->%library} 中的 {$a->%property} 提供的数据无效。 布尔预期。';
$string['invalidlibraryname'] = '无效的库名：{$a->%name}';
$string['invalidlibrarynamed'] = '内容中使用的 H5P 库 {$a->%library} 无效';
$string['invalidlibraryoption'] = '{$a->%library} 中的非法选项 {$a->%option}';
$string['invalidlibraryproperty'] = '无法读取 {$a->%library} 中的属性 {$a->%property}';
$string['invalidmainjson'] = '缺少有效的主 h5p.json 文件';
$string['invalidmultiselectoption'] = '多选中的选定选项无效。';
$string['invalidpackage'] = '无效的 H5P 内容类型';
$string['invalidselectoption'] = '选择中的选定选项无效。';
$string['invalidsemanticsjson'] = '无效的semantics.json 文件已包含在库{$a->%name} 中';
$string['invalidsemanticstype'] = 'H5P 内部错误：语义中的未知内容类型“{$a->@type}”。 删除内容！';
$string['invalidstring'] = '根据语义中的正则表达式，提供的字符串无效。 （值：“{$a->%value}”，正则表达式：“{$a->%regexp}”）';
$string['isNowSubmitted'] = '现已提交到H5P Hub';
$string['keywordExists'] = '关键字已存在！';
$string['keywords'] = '关键字';
$string['keywordsDescription'] = '可以添加多个以逗号分隔的关键字。按“Enter”或“Add”确认关键字';
$string['keywordsExits'] = '关键字已存在！';
$string['keywordsPlaceholder'] = '添加关键字';
$string['language'] = '语言';
$string['level'] = '水平';
$string['librariesmanagerdescription'] = '<p>H5P 使用户能够通过提供一系列内容类型来创建交互式内容。</p><p>要确保在您的网站上只使用受信任的 H5P 内容类型，您需要<i>要么</i> </p><ul><li>从 h5p.org 上传 H5P 内容类型<i>或</i></li><li>启用计划任务“从 h5p.org 下载可用的 H5P 内容类型”</ li></ul><p>请注意，用户将只能使用您网站上安装的 H5P 内容类型。</p>';
$string['librarydirectoryerror'] = '库目录名称必须匹配 machineName 或 machineName-majorVersion.minorVersion（来自 library.json）。 （目录：{$a->%directoryName}，machineName：{$a->%machineName}，majorVersion：{$a->%majorVersion}，minorVersion：{$a->%minorVersion}）';
$string['license'] = '许可证';
$string['licenseCC010'] = 'CC0 1.0通用（CC0 1.0）公共领域专用';
$string['licenseCC010U'] = 'CC0 1.0通用';
$string['licenseCC10'] = '1.0 一般';
$string['licenseCC20'] = '2.0 一般';
$string['licenseCC25'] = '2.5 一般';
$string['licenseCC30'] = '3.0 未迁移';
$string['licenseCC40'] = '4.0 国际';
$string['licenseDescription'] = '为您的内容选择许可证';
$string['licenseDetails'] = '许可证详情';
$string['licenseDialogDescription'] = '点击特定的许可证以获取关于正确使用的信息';
$string['licenseGPL'] = '通用公共许可证';
$string['licenseV1'] = '版本 1';
$string['licenseV2'] = '版本 2';
$string['licenseV3'] = '版本 3';
$string['licenseVersionDescription'] = '选择许可版本';
$string['licensee'] = '被许可方';
$string['licenseextras'] = '许可证附加条件';
$string['licenseversion'] = '许可证版本';
$string['lockh5pdeploy'] = '此 H5P 内容无法访问，因为它正在部署。 请稍后再试。';
$string['logoUploadText'] = '组织标志或头像';
$string['longDescription'] = '详细描述';
$string['longDescriptionPlaceholder'] = '您内容的详细描述';
$string['mainTitle'] = '分享<strong>:title</strong>';
$string['mainlibrarydisabled'] = '无法显示此文件，因为其内容类型已禁用。 请联系您的管理员要求启用内容类型。';
$string['maxLength'] = ':length是最大字符数';
$string['missingcontentfolder'] = '缺少有效的内容文件夹';
$string['missingcoreversion'] = '系统无法从包中安装 {$a->%component} 组件，因为它需要更新版本的 H5P 插件。 此站点当前运行的版本为 {$a->%current}，而所需的版本为 {$a->%required} 或更高版本。 请升级，然后重试。';
$string['missingdependency'] = '缺少 {$a->@lib} 所需的依赖项 {$a->@dep}。';
$string['missinglibrary'] = '缺少必需的库 {$a->@library}';
$string['missinglibraryfile'] = '库中缺少文件“{$a->%file}”：“{$a->%name}”';
$string['missinglibraryjson'] = '无法为库 {$a->%name} 找到具有有效 json 格式的 library.json 文件';
$string['missinglibraryproperty'] = '{$a->%library} 缺少必需的属性 {$a->%property}';
$string['missingmainlibrary'] = '丢失主库{$a->@library}';
$string['missingmbstring'] = 'mbstring PHP 扩展未加载。 H5P 需要它才能正常运行。';
$string['missinguploadpermissions'] = '请注意，您上传的文件中可能存在这些库，但您不能上传新的库。 请联系您的管理员。';
$string['next'] = '下一步';
$string['nocopyright'] = '没有此内容的版权信息。';
$string['noextension'] = '您上传的文件不是有效的 HTML5 包。 （它没有 .h5p 文件扩展名。）';
$string['noh5plibhandlerdefined'] = '没有安装任何 H5P 框架处理程序，因此无法显示 H5P 内容。';
$string['nojson'] = '主 h5p.json 文件无效';
$string['nopermissiontodeploy'] = '无法显示此文件，因为它是由没有部署 H5P 内容所需功能的用户上传的。';
$string['nopermissiontoedit'] = '您无权编辑 H5P 内容。';
$string['notrustablefile'] = '无法显示此文件，因为它已由无法更新 H5P 内容类型的用户上传。 请联系您的管理员询问要安装的内容类型。';
$string['nounzip'] = '您上传的文件不是有效的 HTML5 包。 （无法解压。）';
$string['offlineDialogBody'] = '我们无法发送有关您完成此任务的信息。 请检查您的互联网连接。';
$string['offlineDialogHeader'] = '您与服务器的连接已断开';
$string['offlineDialogRetryButtonLabel'] = '现在重试';
$string['offlineDialogRetryMessage'] = '重试中：num....';
$string['offlineSuccessfulSubmit'] = '成功提交结果。';
$string['optionalInfo'] = '可选信息';
$string['originator'] = '原创人';
$string['pd'] = '公共领域';
$string['pddl'] = '公共领域的贡献和许可';
$string['pdm'] = '公共领域商标 (PDM)';
$string['phone'] = '电话';
$string['pleaseWait'] = '请稍候……';
$string['pluginname'] = 'H5P包';
$string['privacy:metadata'] = 'H5P 子系统不存储任何个人数据。';
$string['publisherDescription'] = '发布者描述';
$string['publisherDescriptionText'] = '这将显示在分享内容的“发布者信息”之下';
$string['publisherFieldDescription'] = '这将显示为分享内容的“发布者名称”';
$string['publisherFieldTitle'] = '发布者';
$string['registerOnHub'] = '在 H5P Hub 上注册';
$string['registrationFailed'] = '发生了一个错误';
$string['registrationFailedDescription'] = '此时我们无法创建一个帐户。出了一些问题。请稍后再试。';
$string['registrationTitle'] = 'H5P Hub 注册';
$string['remove'] = '移除';
$string['removeChip'] = '从列表中移除 :chip';
$string['removeImage'] = '移除图像';
$string['requiredInfo'] = '必需信息';
$string['resizescript'] = '如果要动态调整嵌入内容的大小，请在您的站点上包含此脚本：';
$string['resubmitScores'] = '尝试提交存储的结果。';
$string['reuse'] = '重用';
$string['reuseContent'] = '重用内容';
$string['reuseDescription'] = '重用此内容。';
$string['reviewAndSave'] = '查看和保存';
$string['reviewAndShare'] = '查看和分享';
$string['reviewInfo'] = '查看信息';
$string['reviewMessage'] = '请在分享之前查看下面的信息';
$string['rotateLeft'] = '向左旋转';
$string['rotateRight'] = '向右旋转';
$string['saveChanges'] = '保存更改';
$string['screenshots'] = '截图';
$string['screenshotsDescription'] = '最多可向您的内容添加5张截图';
$string['share'] = '分享';
$string['shareFailed'] = '分享失败。';
$string['shareTryAgain'] = '出了点问题，请尝试再次分享。';
$string['shared'] = '已分享';
$string['sharingNote'] = '分享后所有内容详情仍可编辑';
$string['shortDescription'] = '简述';
$string['shortDescriptionPlaceholder'] = '您内容的简短描述';
$string['showadvanced'] = '显示高级';
$string['showless'] = '显示更少';
$string['showmore'] = '显示更多';
$string['size'] = '大小';
$string['someKeywordsExits'] = '部分关键字已存在';
$string['source'] = '来源';
$string['startingover'] = '您将重新开始。';
$string['status'] = '状态';
$string['subContentWarning'] = '子内容（图片、问题等）将在许可下共享，除非在创作工具中另有规定';
$string['sublevel'] = '子层级';
$string['submitted'] = '已提交！';
$string['successfullyRegistred'] = '您已成功注册 H5P Hub';
$string['successfullyRegistredDescription'] = '您的账号详情可以更改';
$string['successfullyUpdated'] = '您的 H5P Hub 帐户设置已成功更改';
$string['task_h5p'] = 'H5P计划任务';
$string['task_h5p_description'] = 'H5P 计划任务从 h5p.org 下载可用的 H5P 内容类型。';
$string['thumbnail'] = '缩略图';
$string['title'] = '标题';
$string['undisclosed'] = '未公开';
$string['unpackedFilesExceedsMaxSize'] = '解压文件的总大小超过了允许的最大大小。 ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = '保存账号设置';
$string['updatedlibraries'] = '更新了 {$a->%old} H5P 库。';
$string['updatedlibrary'] = '更新了 {$a->%old} H5P 库。';
$string['uploadlibraries'] = '上传 H5P 内容类型';
$string['uploadsuccess'] = 'H5P 内容类型上传成功';
$string['width'] = '宽度';
$string['wrongversion'] = '此内容中使用的 H5P 库 {$a->%machineName} 的版本无效。 内容包含 {$a->%contentLibrary}，但它应该是 {$a->%semanticsLibrary}。';
$string['year'] = '年';
$string['years'] = '年';
$string['yearsfrom'] = '年（从）';
$string['yearsto'] = '年（到）';
$string['zip'] = 'Zip';
