<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'es', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Etiqueta de Tecnologías Asistivas';
$string['acceptTerms'] = 'Yo acepto los <a href=":url" target="_blank">términos de uso</a>';
$string['accountDetailsLinkText'] = 'aquí';
$string['actions'] = 'Acciones';
$string['add'] = 'Añadir';
$string['addedandupdatedpp'] = 'Se añadieron {$a->%new} nuevas librerías H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedps'] = 'Se añadieron {$a->%new} nuevas librerías H5P y se actualizó {$a->%old} antigua.';
$string['addedandupdatedsp'] = 'Se añadieron {$a->%new} nuevas librerías H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedss'] = 'Se añadieron {$a->%new} nuevas librerías H5P y se actualizó {$a->%old} antigua.';
$string['addednewlibraries'] = 'Se añadieron {$a->%new} nuevas librerías H5P.';
$string['addednewlibrary'] = 'Se añadió {$a->%new} nueva librería H5P.';
$string['additionallicenseinfo'] = 'Cualquier información adicional acerca de la licencia';
$string['address'] = 'Dirección';
$string['age'] = 'Edad típica';
$string['ageDescription'] = 'La audiencia objetivo de este contenido. Formatos posibles separados por comas: "1,34-45,-50,59-".';
$string['altText'] = 'Texto alterno';
$string['atto_h5p'] = 'Insertar el botón H5P';
$string['atto_h5p_description'] = 'El botón "Insertar H5P" en el editor Atto permite a los usuarios insertar contenido H5P ya sea introduciendo una URL o un código de incrustación, o subiendo un archivo H5P.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentarios del autor';
$string['authorcommentsdescription'] = 'Comentarios para el editor del contenido. (Este texto no será publicado como parte de la información de copyright)';
$string['authorname'] = 'Nombre del autor';
$string['authorrole'] = 'Rol del autor';
$string['back'] = 'Regresar';
$string['by'] = 'por';
$string['cancelCrop'] = 'Cancelar el recortado';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'No';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Si';
$string['cancelPublishConfirmationDialogDescription'] = '¿Está seguro de querer cancelar el proceso de compartir?';
$string['cancelPublishConfirmationDialogTitle'] = 'Cancelar compartir';
$string['cancellabel'] = 'Cancelar';
$string['ccattribution'] = 'Atribución (CC BY)';
$string['ccattributionnc'] = 'Licencia de Atribución-No-Comercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Licencia de Atribución-No-Comercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Licencia de Atribución-No-Comercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Licencia de Atribución-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Licencia de Atribución-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Dedicación del Dominio Público (CC0)';
$string['changeHasBeenSubmitted'] = 'Un cambio ha sido enviado para';
$string['changedby'] = 'Cambiado por';
$string['changedescription'] = 'Descripción del cambio';
$string['changelog'] = 'Bitácora de cambios';
$string['changeplaceholder'] = 'Foto recortada, texto cambiado, etc.';
$string['city'] = 'Ciudad';
$string['close'] = 'Cerrar';
$string['confirmCrop'] = 'Confirmar el recortado';
$string['confirmdialogbody'] = 'Por favor confirme que desea proseguir. Esta acción no puede deshacerse.';
$string['confirmdialogheader'] = 'Confirmar acción';
$string['confirmlabel'] = 'Confirmar';
$string['connectionLost'] = 'Conexión perdida. Los resultados serán almacenados y enviados cuando la conexión sea restablecida.';
$string['connectionReestablished'] = 'Conexión restablecida';
$string['contactPerson'] = 'Persona para contacto';
$string['contactPersonDescription'] = 'H5P se pondrá en contacto con la persona en caso de que haya problemas con el contenido compartido por el publicador. El nombre de la persona de contacto o cualquier otra información no será publicada ni compartida con terceras partes.';
$string['contentAvailable'] = 'Su contenido normalmente estará disponible en el Hub en el transcurso de un día hábil.';
$string['contentCopied'] = 'El contenido es copiado al portapapeles';
$string['contentLicenseTitle'] = 'Información de licencia del contenido';
$string['contentUpdateSoon'] = 'Su contenido se actualizará pronto';
$string['contentchanged'] = 'Este contenido ha cambiado desde la última vez que lo utilizó.';
$string['contentinuse'] = 'Este contenido puede estar en uso en otros lugares.';
$string['contenttype'] = 'Tipo de Contenido';
$string['copyright'] = 'Derechos de uso';
$string['copyrightWarning'] = 'Material con derechos de autor reservados (copyrighted) no puede ser compartido en el Hub de Contenido H5P. Si el contenido está licenciado con una licencia amistosa para Recursos Educativos Abiertos como por ejemplo Creative Commons, por favor elija la licencia apropiada. En caso contrario el contenido no puede ser compartido.';
$string['copyrightinfo'] = 'Información del Copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Ver información de copyright para este contenido.';
$string['couldNotParseJSONFromZip'] = 'No se puede procesar JSON del paquete: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'No se puede leer del paquete: {$a->%fileName}';
$string['country'] = 'País';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Recortar imagen';
$string['currentStep'] = 'Paso :step de :total';
$string['date'] = 'Fecha';
$string['deletelibraryconfirm'] = '<p>Está seguro que desea eliminar la versión <em>\'{$a->version}\'</em> de la librería <em>\'{$a->name}\'</em>? Se quitará la librería y todas sus aplicaciones.</p><p>Esta operación no puede deshacerse.</p>';
$string['deletelibraryversion'] = 'Eliminar versión';
$string['deleting'] = 'Eliminando una librería';
$string['description'] = 'Descripción';
$string['disablefullscreen'] = 'Deshabilitar pantalla completa';
$string['discipline:dropdownButton'] = 'Botón desplegable';
$string['discipline:in'] = 'en';
$string['discipline:searchPlaceholder'] = 'Tipo a buscar para disciplinas';
$string['disciplineDescription'] = 'Usted puede seleccionar varias disciplinas';
$string['disciplineLabel'] = 'Disciplinas';
$string['disciplineLimitReachedMessage'] = 'Usted puede seleccionar hasta :numDisciplines disciplinas';
$string['disciplines'] = 'Disciplinas';
$string['download'] = 'Descargar';
$string['downloadtitle'] = 'Descargar este contenido como un archivo H5P.';
$string['editInfoTitle'] = 'Editar información para <strong>:title</strong>';
$string['editcontent'] = 'Editar contenido H5P';
$string['editingFailed'] = 'Falló la edición';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'Dirección Email';
$string['emailAddressDescription'] = 'La dirección de Email será usada por H5P para comunicarse con la persona que publica en caso de que hubiera problemas con el contenido, o en caso de que la persona que publica necesitara recuperar su cuenta. No será publicada ni compartida con terceros.';
$string['embed'] = 'Incrustar';
$string['embedtitle'] = 'Ver el contenido incrustado para este comentario';
$string['error:emptycontentid'] = 'La URL dada es incorrecta o usted no puede editar este archivo.';
$string['eventh5pdeleted'] = 'H5P eliminado';
$string['eventh5pviewed'] = 'Contenido H5P visto';
$string['feature'] = 'Característica';
$string['fetchtypesfailure'] = 'No se pudo obtener información sobre los tipos de contenido H5P disponibles. Falla en la conexión al repositorio H5P.';
$string['fileExceedsMaxSize'] = 'Uno de los archivos dentro del paquete excede el tamaño máximo de archivo permitido. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Filtro para mostrar H5P';
$string['filter_displayh5p_description'] = 'El filtro para mostrar H5P convierte las URL en contenido H5P incrustado.';
$string['fullscreen'] = 'Pantalla completa';
$string['gpl'] = 'Licencia Pública General v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'Personalizar CSS';
$string['h5pcustomcss_help'] = 'CSS a aplicar en sus módulos H5P.';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Archivo H5P no encontrado';
$string['h5pinvalidurl'] = 'URL de contenido H5P inválida';
$string['h5plibraryhandler'] = 'Manejador del marco H5P';
$string['h5plibraryhandler_help'] = 'El marco H5P utilizado para visualizar contenidos H5P. Se recomienda la última versión.';
$string['h5pmanage'] = 'Gestionar tipos de contenido H5P';
$string['h5poverview'] = 'Visión general del H5P';
$string['h5ppackage'] = 'Tipo de contenido H5P';
$string['h5ppackage_help'] = 'Un tipo de contenido H5P es un archivo con  extensión H5P o ZIP que contiene todas las librerías requeridas para mostrar el contenido.';
$string['h5pprivatefile'] = 'El contenido H5P no puede ser mostrado porque usted no tiene acceso al archivo .h5p.';
$string['h5psettings'] = 'Configuraciones de H5P';
$string['h5ptitle'] = 'Visitar H5P.org para revisar más contenido.';
$string['height'] = 'altura';
$string['helpChoosingLicense'] = 'Ayúdame a elegir una licencia';
$string['hideadvanced'] = 'Ocultar avanzadas';
$string['icon'] = 'Ícono';
$string['iconDescription'] = '640x480px. En caso contrario, el contenido seleccionado usará el ícono de la categoría';
$string['installedcontentlibraries'] = 'Librerías H5P instaladas';
$string['installedcontenttypes'] = 'Tipos de contenido H5P instalado';
$string['installedh5p'] = 'H5P instalado';
$string['invalidAge'] = 'Formato de entrada inválido para edad típica. Formatos de entrada posibles separados por comas: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'Archivo H5P no encontrado (contextid inválido)';
$string['invalidfile'] = 'Archivo "{$a->%filename}" no permitido. Solamente están permitidos archivos con las extensiones siguientes: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Archivo inválido de idioma {$a->%file} en librería {$a->%library}';
$string['invalidlanguagefile2'] = 'Archivo inválido de idioma {$a->%languageFile} ha sido incluido en la librería {$a->%name}';
$string['invalidlibrarydata'] = 'Datos inválidos proporcionados para {$a->%property} en {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Datos inválidos proporcionados para {$a->%property} en {$a->%library}. Booleano esperado.';
$string['invalidlibraryname'] = 'Nombre inválido de librería: {$a->%name}';
$string['invalidlibrarynamed'] = 'La librería H5P{$a->%library} usada en el contenido no es válida';
$string['invalidlibraryoption'] = 'Opción ilegal {$a->%option} en {$a->%library}';
$string['invalidlibraryproperty'] = 'No se puede leer la propiedad {$a->%property} en {$a->%library}';
$string['invalidmainjson'] = 'Falta un archivo principal h5p.json';
$string['invalidmultiselectoption'] = 'Opción seleccionada inválida en multi-selección.';
$string['invalidpackage'] = 'Tipo de contenido H5P inválido';
$string['invalidselectoption'] = 'Opción seleccionada inválida en selección.';
$string['invalidsemanticsjson'] = 'Archivo semantics.json inválido ha sido incluido en la librería {$a->%name}';
$string['invalidsemanticstype'] = 'Error interno H5P: tipo de contenido desconocido "{$a->@type}" en semántica. ¡Quitando contenido!';
$string['invalidstring'] = 'La cadena de caracteres proporcionada no es válida de acuerdo a regexp en semántica. (valor: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Ahora ha sido enviada al Hub H5P';
$string['keywordExists'] = '¡Ya existe palabra clave!';
$string['keywords'] = 'Palabras clave';
$string['keywordsDescription'] = 'Usted puede añadir varias palabras clave separadas por comas. Presione "Intro"  o "Añadir" para confirmar palabras clave';
$string['keywordsExits'] = '¡Ya existen palabras clave!';
$string['keywordsPlaceholder'] = 'Añadir palabras clave';
$string['language'] = 'Idioma';
$string['level'] = 'Nivel';
$string['librariesmanagerdescription'] = '<p>H5P les permite a los usuarios crear contenido interactivo al proporcionar un rango de tipos de contenido.</p><p>Para asegurar que solamente sean usados tipos de contenido confiables en su sitio, necesita <i>una de dos</i></p><ul><li>Subir tipos de contenido H5P desde h5p.org <i>o</i></li><li>Habilitar el trabajo agendado \'Descargar tipos de contenido disponible H5P desde h5p.org</li></ul><p>Tenga en cuenta que los usuarios solamente podrán usar los tipos de contenido H5P que estén instalados en su sitio.</p>';
$string['librarydirectoryerror'] = 'El nombre del directorio de la librería debe coincidir con machineName o machineName-majorVersion.minorVersion (de library.json). (Directorio: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licencia';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0)  Dedicación del Dominio Público';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérico';
$string['licenseCC20'] = '2.0 Genérico';
$string['licenseCC25'] = '2.5 Genérico';
$string['licenseCC30'] = '3.0 No Portada';
$string['licenseCC40'] = '4.0 Internacional';
$string['licenseDescription'] = 'Seleccionar una licencia para su contenido';
$string['licenseDetails'] = 'Detalles de la licencia';
$string['licenseDialogDescription'] = 'Haga clic en una licencia específica para obtener información acerca de su uso apropiado';
$string['licenseGPL'] = 'Licencia Pública General';
$string['licenseV1'] = 'Versión 1';
$string['licenseV2'] = 'Versión 2';
$string['licenseV3'] = 'Versión 3';
$string['licenseVersionDescription'] = 'Seleccionar una versión de licencia';
$string['licensee'] = 'Licenciatario';
$string['licenseextras'] = 'Extras de la licencia';
$string['licenseversion'] = 'Versión de la licencia';
$string['lockh5pdeploy'] = 'No se puede acceder a este contenido de H5P porque se está implementando. Por favor inténtelo de nuevo más tarde.';
$string['logoUploadText'] = 'Logo de organización o avatar';
$string['longDescription'] = 'Descripción extensa';
$string['longDescriptionPlaceholder'] = 'Descripción extensa de su contenido';
$string['mainTitle'] = 'Compartiendo <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Este archivo no puede ser mostrado porque su tipo de contenido está deshabilitado. Por favor póngase en contacto con su administrador para pedirle que sea habilitado el tipo de contenido.';
$string['maxLength'] = ':length es el número máximo de caracteres';
$string['missingcontentfolder'] = 'Falta una carpeta de contenido válida';
$string['missingcoreversion'] = 'El sistema no pudo instalar el componente {$a->%component} del paquete, ya que necesita una versión más nueva del plugin H5P. Este sitio actualmente está ejecutando la versión {$a->%current}, mientras que la versión requerida es {$a->%required} o mayor. Por favor actualice y después inténtelo nuevamente.';
$string['missingdependency'] = 'Falta dependencia {$a->@dep} requerida por {$a->@lib}.';
$string['missinglibrary'] = 'Falta librería requerida {$a->@library}';
$string['missinglibraryfile'] = 'El archivo "{$a->%file}" falta de la librería: "{$a->%name}"';
$string['missinglibraryjson'] = 'No se pudo encontrar el archivo library.json con formato json válido para la librería {$a->%name}';
$string['missinglibraryproperty'] = 'La propiedad requerida {$a->%property} está faltando de {$a->%library}';
$string['missingmainlibrary'] = 'Falta biblioteca principal {$a->@library}';
$string['missingmbstring'] = 'La extensión PHP mbstring no está cargada. H5P la necesita para funcionar adecuadamente.';
$string['missinguploadpermissions'] = 'Tenga en cuenta que las librerías podrían existir en el archivo que subió, pero usted no tiene permitido subir nuevas librerías. Por favor póngase en contacto con su administrador.';
$string['next'] = 'Siguiente';
$string['nocopyright'] = 'Sin información de copyright disponible para este contenido.';
$string['noextension'] = 'El archivo que subió no es un Paquete HTML5 válido (no tiene la extensión de archivo .h5p.)';
$string['noh5plibhandlerdefined'] = 'No hay instalado ningún controlador de marco H5P, por lo que no se puede mostrar el contenido de H5P.';
$string['nojson'] = 'El archivo principal h5p.json no es válido';
$string['nopermissiontodeploy'] = 'Este archivo no puede ser mostrado porque ha sido subido por un usuario sin la capacidad requerida para desplegar contenido H5P.';
$string['nopermissiontoedit'] = 'No dispone de permiso para editar contenido H5P.';
$string['notrustablefile'] = 'Este archivo no puede ser mostrado porque ha sido subido por un usuario sin la capacidad para actualizar tipos de contenido H5P. Por favor póngase en contacto con su administrador para pedirle que sea instalado el tipo de contenido.';
$string['nounzip'] = 'El archivo que subió no es un Paquete HTML5 válido. (No es posible descomprimirlo).';
$string['offlineDialogBody'] = 'No pudimos enviar información acerca de su finalización de este trabajo. Por favor revise su conexión de internet.';
$string['offlineDialogHeader'] = 'Se perdió su conexión al servidor';
$string['offlineDialogRetryButtonLabel'] = 'Reintentar ahora';
$string['offlineDialogRetryMessage'] = 'Reintentando en :num....';
$string['offlineSuccessfulSubmit'] = 'Resultados enviados exitosamente.';
$string['optionalInfo'] = 'Información opcional';
$string['originator'] = 'Originador';
$string['pd'] = 'Dominio Público';
$string['pddl'] = 'Dedicación y Licencia del Dominio Público';
$string['pdm'] = 'Marca de Dominio Público (PDM)';
$string['phone'] = 'Teléfono';
$string['pleaseWait'] = 'Por favor espere....';
$string['pluginname'] = 'Paquete H5P';
$string['privacy:metadata'] = 'El subsistema H5P no almacena ningún dato personal.';
$string['publisherDescription'] = 'Descripción de quien publica';
$string['publisherDescriptionText'] = 'Esto será mostrado bajo "Información del publicador" en contenido compartido';
$string['publisherFieldDescription'] = 'Esto será mostrado bajo "Nombre del publicador" en contenido compartido';
$string['publisherFieldTitle'] = 'Publicador';
$string['registerOnHub'] = 'Registrar en el Hub H5P';
$string['registrationFailed'] = 'Ocurrió un error';
$string['registrationFailedDescription'] = 'No pudimos crear una cuenta en este punto. Algo salió mal. Inténtelo nuevamente después.';
$string['registrationTitle'] = 'Registro en Hub H5P';
$string['remove'] = 'Quitar';
$string['removeChip'] = 'Quitar :chip de la lista';
$string['removeImage'] = 'Quitar imagen';
$string['requiredInfo'] = 'Información requerida';
$string['resizescript'] = 'Incluya este script en su sitio web si desea ajuste de tamaño dinámico del contenido incrustado.';
$string['resubmitScores'] = 'Intentando enviar resultados guardados.';
$string['reuse'] = 'Reutilizar';
$string['reuseContent'] = 'Reutilizar Contenido';
$string['reuseDescription'] = 'Reutilizar este contenido.';
$string['reviewAndSave'] = 'Revisar y Guardar';
$string['reviewAndShare'] = 'Revisar y Compartir';
$string['reviewInfo'] = 'Revisar información';
$string['reviewMessage'] = 'Por favor revise la información debajo antes de compartir';
$string['rotateLeft'] = 'Girar a la izquierda';
$string['rotateRight'] = 'Girar a la derecha';
$string['saveChanges'] = 'Guardar cambios';
$string['screenshots'] = 'Pantallazos';
$string['screenshotsDescription'] = 'Añadir hasta cinco pantallazos de su contenido';
$string['share'] = 'Compartir';
$string['shareFailed'] = 'Falló compartir.';
$string['shareTryAgain'] = 'Algo salió mal; por favor intente compartir nuevamente.';
$string['shared'] = 'Compartido';
$string['sharingNote'] = 'Todos los detalles del contenido pueden ser editados después de compartir';
$string['shortDescription'] = 'Descripción breve';
$string['shortDescriptionPlaceholder'] = 'Descripción breve de su contenido';
$string['showadvanced'] = 'Mostrar avanzadas';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar más';
$string['size'] = 'Tamaño';
$string['someKeywordsExits'] = 'Algunas de estas palabras clave ya existen';
$string['source'] = 'Origen';
$string['startingover'] = 'Usted comenzará de nuevo.';
$string['status'] = 'Estado';
$string['subContentWarning'] = 'Sub-contenido (imágenes, preguntas, etc) serán compartidos bajo :license a menos que se especifique otra cosa en la herramienta de autoría';
$string['sublevel'] = 'Subnivel';
$string['submitted'] = '¡Enviado!';
$string['successfullyRegistred'] = 'Usted ha registrado exitosamente una cuenta en el Hub H5P';
$string['successfullyRegistredDescription'] = 'Los detalles de su cuenta no pueden ser cambiados';
$string['successfullyUpdated'] = 'Las configuraciones de su cuenta en Hub H5P han sido cambiadas exitosamente.';
$string['task_h5p'] = 'Tarea programada H5P';
$string['task_h5p_description'] = 'La tarea programada H5P descarga los tipos de contenido H5P disponibles de h5p.org.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['undisclosed'] = 'No revelado';
$string['unpackedFilesExceedsMaxSize'] = 'El tamaño total de los archivos descomprimidos excede el tamaño máximo permitido. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Guardar configuraciones de la cuenta';
$string['updatedlibraries'] = 'Actualizó  {$a->%old} librerías H5P.';
$string['updatedlibrary'] = 'Actualizó  {$a->%old} librería H5P.';
$string['uploadlibraries'] = 'Subir tipos de contenido H5P';
$string['uploadsuccess'] = 'Tipos de contenido H5P subidos exitosamente';
$string['width'] = 'ancho';
$string['wrongversion'] = 'La versión de la librería H5P {$a->%machineName} usada en este contenido no es válida. El contenido contiene {$a->%contentLibrary}, pero debería de ser {$a->%semanticsLibrary}.';
$string['year'] = 'Año';
$string['years'] = 'Año(s)';
$string['yearsfrom'] = 'Años (desde)';
$string['yearsto'] = 'Años (hasta)';
$string['zip'] = 'ZIP';
