<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'sr_lt', version '4.3'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Prihvatam <a href=":url" target="_blank">uslove korišćenja</a>';
$string['accountdetailslinktext'] = 'ovde';
$string['action'] = 'Akcija';
$string['add'] = 'Dodaj';
$string['addedandupdatedpp'] = 'Dodato novih H5P biblioteka: {$a->%new}, i ažurirano starih: {$a->%old}.';
$string['addedandupdatedps'] = 'Dodato novih H5P biblioteka: {$a->%new}, i ažurirana {$a->%old} stara.';
$string['addedandupdatedsp'] = 'Dodata {$a->%new} nova H5P biblioteka, i ažurirano starih: {$a->%old}.';
$string['addedandupdatedss'] = 'Dodata {$a->%new} nova H5P biblioteka, i ažurirana {$a->%old} stara.';
$string['addednewlibraries'] = 'Dodato novih H5P biblioteka: {$a->%new}';
$string['addednewlibrary'] = 'Dodata {$a->%new} nova H5P biblioteka.';
$string['additionalinfo'] = 'Dodatne informacije';
$string['additionallicenseinfo'] = 'Sve dodatne informacije o licenci';
$string['addlibraries'] = 'Dodaj biblioteke';
$string['address'] = 'Adresa';
$string['age'] = 'Tipičan uzrast';
$string['agedescription'] = 'Ciljna publika za ovaj sadržaj. Mogući formati unosa odvojeni zarezima su: „1, 34-45,-50, 59-".';
$string['ajaxfailed'] = 'Pokušaj učitavanja podataka nije uspeo';
$string['alttext'] = 'Alt tekst';
$string['anunexpectedsave'] = 'Dogodilo se nešto neočekivano. Nismo uspeli da sačuvamo ovaj interaktivni sadržaj.';
$string['assistivetechnologieslabel'] = 'Ознака за асистивне технологије';
$string['attribution'] = 'Autorstvo 4.0';
$string['attributionnc'] = 'Autorstvo - Nekomercijalna licenca 4.0';
$string['attributionncnd'] = 'Autorstvo - Nekomercijalna licenca - Bez prerada 4.0';
$string['attributionncsa'] = 'Autorstvo - Nekomercijalna licenca - Deliti pod istim uslovima 4.0';
$string['attributionnd'] = 'Autorstvo - Licenca - Bez prerada 4.0';
$string['attributionsa'] = 'Autorstvo - Licenca - Deliti pod istim uslovima 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Komentari autora';
$string['authorcommentsdescription'] = 'Komentari za urednika interaktivnog sadržaja (ovaj tekst neće biti objavljen kao deo informacije o autorskim pravima)';
$string['authorname'] = 'Ime autora';
$string['authorrole'] = 'Uloga autora';
$string['back'] = 'Nazad';
$string['by'] = 'od strane';
$string['cancel'] = 'Otkaži';
$string['cancellabel'] = 'Otkaži';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Ne';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Da';
$string['cancelpublishconfirmationdialogdescription'] = 'Da li ste sigurni da želite da otkažete deljenje?';
$string['cancelpublishconfirmationdialogtitle'] = 'Otkaži deljenje';
$string['ccattribution'] = 'Autorstvo (CC BY)';
$string['ccattributionnc'] = 'Autorstvo - Nekomercijalna licenca (CC BY-NC)';
$string['ccattributionncnd'] = 'Autorstvo - Nekomercijalna licenca - Bez prerada (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Autorstvo - Nekomercijalna licenca - Deliti pod istim uslovima (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Autorstvo - Licenca - Bez prerada (CC BY-ND)';
$string['ccattributionsa'] = 'Autorstvo - Licenca - Deliti pod istim uslovima (CC BY-SA)';
$string['ccpdd'] = 'Posvećenost javnom vlasništvu (CC0)';
$string['ccpdm'] = 'Oznaka javnog vlasništva (PDM)';
$string['changedby'] = 'Promenio/la';
$string['changedescription'] = 'Opis promene';
$string['changehasbeensubmitted'] = 'Promena je predata za';
$string['changelog'] = 'Izmene zapisa';
$string['changeplaceholder'] = 'Fotografija izrezana, tekst promenjen, itd.';
$string['city'] = 'Grad';
$string['close'] = 'Zatvori';
$string['completionpass'] = 'Zahtevaj prelaznu ocenu';
$string['completionpass_help'] = 'Ako je ova opcija omogućena, ova aktivnost se smatra završenom kada učenik dobije prelaznu ocenu (kao što je navedeno u odeljku Ocena u podešavanjima H5P aktivnosti) ili višu.';
$string['completionpassdesc'] = 'Polaznik mora postići prelaznu ocenu kako bi završio ovu aktivnost';
$string['confirmdialogbody'] = 'Potvrdite da želite da nastavite. Ova akcija je nepovratna.';
$string['confirmdialogheader'] = 'Potvrdi akciju';
$string['confirmlabel'] = 'Potvrdi';
$string['connectionlost'] = 'Veza se prekinula. Rezultati će biti sačuvani i poslati kada ponovo uspostavite vezu.';
$string['connectionreestablished'] = 'Veza je ponovo uspostavljena.';
$string['contactperson'] = 'Kontakt osoba';
$string['contactpersondescription'] = 'H5P će kontaktirati osobu odgovornu za kontakt u slučaju da postoje problemi sa sadržajem koji je izdavač podelio. Ime kontakt osobe ili druge informacije neće biti objavljene niti deljene sa trećim licima';
$string['contentavailable'] = 'Vaš sadržaj će obično biti dostupan na H5P OER HUB-u u roku od jednog radnog dana.';
$string['contentchanged'] = 'Ovaj interaktivni sadržaj je promenjen od kada ste ga poslednji put koristili.';
$string['contentcopied'] = 'Sadržaj je kopiran u klipbord';
$string['contenthub:changesettings'] = 'Promenite podešavanja naloga <a href="{$a}">ovde</a>';
$string['contenthub:licenseagreementdescription'] = 'Molimo vas, pročitajte sledeći ugovor pre nego što nastavite';
$string['contenthub:licenseagreementmaintext'] = 'TODO';
$string['contenthub:licenseagreementtitle'] = 'End User License Agreement (EULA)';
$string['contenthub:nopermissions'] = 'Nemate ovlašćenje da registrujete sajt na čvorištu sa sadržajem.';
$string['contenthub:register'] = 'Registrujte nalog na H5P OER HUB-u <a href="{$a}">ovde</a>';
$string['contenthub:settings:box'] = 'H5P OER HUB Nalog';
$string['contenthub:settings:heading'] = 'H5P OER HUB - Podešavanja naloga';
$string['contenthubeditsharing'] = 'Uredite informacije o deljenju';
$string['contenthuboptions'] = 'H5P OER HUB - Opcije';
$string['contenthubsearchdescription'] = 'Pronađite i preuzmite deljeni sadržaj sa H5P HUB-a.';
$string['contenthubsearchenable'] = 'Omogućite deljeni sadržaj u H5P OER HUB-u';
$string['contenthubshare'] = 'Podelite na H5P OER HUB-u';
$string['contenthubsharinginprogress'] = 'Deljenje...';
$string['contenthubsyncchanges'] = 'Sinhronizujte promene';
$string['contenthubunshare'] = 'Opozovi deljenje';
$string['contentissyncing'] = 'Sadržaj se sinhronizuje.';
$string['contentlicensetitle'] = 'Informacije o licenci sadržaja';
$string['contentnotshared'] = 'Sadržaj se ne deli na H5P OER HUB-u.';
$string['contentstatefrequency'] = 'Učestalost snimanja statusa interaktivnog sadržaja';
$string['contentstatefrequency_help'] = 'Vremenski period, u sekundama, koliko često želite da korisnici automatski čuvaju svoj napredak. Povećajte ovaj broj ako imate problema sa velikim brojem AJAX zahteva.';
$string['contenttype'] = 'Tip interaktivnog sadržaja';
$string['contenttypecacheheader'] = 'Keš interaktivnog sadržaja';
$string['contentupdatesoon'] = 'Vaš sadržaj će se uskoro ažurirati';
$string['copyright'] = 'Prava korišćenja';
$string['copyrightinfo'] = 'Informacije o autorskim pravima';
$string['copyrightstring'] = 'Autorska prava';
$string['copyrighttitle'] = 'Pogledajte informacije o autorskim pravima za ovaj interaktivni sadržaj.';
$string['copyrightwarning'] = 'Materijal zaštićen autorskim pravima se ne može deliti na H5P Content Hubu. Ako je sadržaj pod licencom koja je prilagođena OER-u, kao što je Creative Commons, izaberite odgovarajuću licencu. Ako nije, ovaj sadržaj se ne može deliti.';
$string['couldnotcopy'] = 'Nije moguće kopirati datoteku';
$string['couldnotparsejsonfromzip'] = 'Nije moguće parsirati JSON iz paketa: %fileName';
$string['couldnotparsepostdata'] = 'Nije moguće parsirati podatke posta.';
$string['couldnotreadfilefromzip'] = 'Nije moguće pročitati datoteku iz paketa: %fileName';
$string['couldnotsave'] = 'Nije moguće sačuvati datoteku';
$string['country'] = 'Zemlja';
$string['create'] = 'Kreiraj';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Ažurirajte keš interaktivnog sadržaja';
$string['ctcacheconnectionfailed'] = 'Nije moguće uspostaviti vezu sa H5P OER HUB-om. Molimo, pokušajte ponovo kasnije.';
$string['ctcachedescription'] = 'Ako vodite računa da keš interaktivnih sadržaja bude ažuran onda ćete moći da pregledate, preuzmete i koristite najnovije biblioteke. Ovo se razlikuje od ažuriranja samih biblioteka.';
$string['ctcachelastupdatelabel'] = 'Poslednja promena';
$string['ctcacheneverupdated'] = 'Nikad';
$string['ctcachenolibraries'] = 'Nijedan tip interaktivnog sadržaja nije preuzet sa H5P OER HUB-a. Molimo, pokušajte ponovo kasnije.';
$string['ctcachesuccess'] = 'Keš biblioteke je uspešno ažuriran!';
$string['ctcachetaskname'] = 'Ažurirajte keš interaktivnog sadržaja';
$string['currentpage'] = 'Stranica $current od $total';
$string['currentstep'] = 'Korak :step od :total';
$string['dataviewreportlabel'] = 'Prikaži odgovore';
$string['date'] = 'Datum';
$string['description'] = 'Opis';
$string['disablefileextensioncheck'] = 'Onemogući proveru ekstenzije datoteke';
$string['disablefileextensioncheckwarning'] = 'Upozorenje! Onemogućavanje provere ekstenzije datoteke može da ima posledice po bezbednost sistema, jer omogućava postavljanje PHP datoteka. To bi omogućilo napadačima da pokrenu zlonamerni kôd na vašem sajtu. Proverite da li znate tačno koju datoteku postavljate.';
$string['disablefullscreen'] = 'Onemogući prikaz preko celog ekrana';
$string['disablehubconfirmationmsg'] = 'Da li i dalje želite da omogućite čvorište?';
$string['disablehubdescription'] = 'Preporučuje se da ova opcija bude omogućena. H5P OER HUB obezbeđuje jednostavan interfejs za preuzimanje novih tipova interaktivnog sadržaja i ažuriranje postojećih. Ubuduće, ova opcija će, takođe, olakšati deljenje i ponovno korišćenje interaktivnih sadržaja. Ako je ova opcija onemogućena, interaktivne sadržaje ćete morati da instalirati i ažurirati putem obrazaca za postavljanje datoteka.';
$string['disciplinedescription'] = 'Možete izabrati više disciplina';
$string['disciplinelabel'] = 'Discipline';
$string['disciplinelimitreachedmessage'] = 'Maksimalan broj disciplina koje možete izabrati: :numDisciplines';
$string['disciplines'] = 'Discipline';
$string['displayoptionalwaysshow'] = 'Uvek prikaži';
$string['displayoptionauthoroff'] = 'Kontrolisano od strane autora, standardno isključeno';
$string['displayoptionauthoron'] = 'Kontrolisano od strane autora, standardno uključeno';
$string['displayoptiondownloadalways'] = 'Uvek';
$string['displayoptiondownloadnever'] = 'Nikad';
$string['displayoptiondownloadpermission'] = 'Samo ako korisnik ima ovlašćenja da izveze H5P';
$string['displayoptionnevershow'] = 'Nikad ne prikazuj';
$string['displayoptionpermissions'] = 'Prikaži samo ako korisnik ima ovlašćenja da izveze H5P';
$string['displayoptionpermissionsembed'] = 'Prikaži samo ako korisnik ima ovlašćenja da ugradi H5P';
$string['displayoptions'] = 'Opcije prikaza';
$string['download'] = 'Preuzmi';
$string['downloadfailed'] = 'Preuzimanje zatražene biblioteke nije uspelo.';
$string['downloadtitle'] = 'Preuzmite ovaj interaktivni sadržaj kao H5P datoteku.';
$string['dropdownbutton'] = 'Dugme za padajući meni';
$string['editinfotitle'] = 'Uredite informacije za <strong>:title</strong>';
$string['editingfailed'] = 'Uređivanje nije uspelo.';
$string['editor'] = 'Editor';
$string['emailaddress'] = 'Adresa e-pošte';
$string['emailaddressdescription'] = 'H5P će koristiti adresu e-pošte da stupi u kontakt sa izdavačem u slučaju bilo kakvih problema sa sadržajem ili u slučaju da izdavač treba da povrati svoj nalog. Adrese e-pošte neće biti objavljen niti deljen sa trećim licima';
$string['emailconfirmbody'] = 'Poštovani/a {$a->username},

Hvala vam što ste poslali svoje odgovore u okviru \'{$a->hvpname}\' na kursu \'{$a->coursename}\'.

Ova poruka potvrđuje da su vaši odgovori sačuvani.

Ovoj H5P aktivnosti možete pristupiti na {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Hvala vam što ste poslali svoje odgovore na \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Potvrda o slanju za {$a->hvpname}';
$string['emailnotifybody'] = 'Poštovani/a {$a->username},

{$a->studentname} je završio/la \'{$a->hvpname}\' ({$a->hvpurl}) na kursu \'{$a->coursename}\'.

Možete pregledati ovaj pokušaj na {$a->hvpreporturl}.';
$string['emailnotifysmall'] = 'Полазник {$a->studentname} je završio/la aktivnost {$a->hvpname}. Pogledajte {$a->hvpreporturl}';
$string['emailnotifysubject'] = 'Полазник {$a->studentname} je završio/la aktivnost {$a->hvpname}';
$string['embed'] = 'Ugradi';
$string['embedloginfailed'] = 'Nemate pristup ovom interaktivnom sadržaju. Pokušajte da se prijavite.';
$string['embedtitle'] = 'Prikaži ugrađeni kôd za ovaj interaktivni sadržaj.';
$string['empty'] = 'Nema dostupnih rezultata';
$string['enableabout'] = 'Dugme "O H5P"';
$string['enablecopyright'] = 'Dugme za autorska prava';
$string['enabledlrscontenttypes'] = 'Omogućite LRS zavisan interatkivan sadržaj';
$string['enabledlrscontenttypes_help'] = 'Omogućava korišćenje interaktivnih sadržaja koji se oslanjaju  na LRS (Learning Record Store) kako bi funkcionisali ispravno, kao što je interaktivni sadržaj Upitnik (Questionnaire).';
$string['enabledownload'] = 'Dozvoli preuzimanje';
$string['enableembed'] = 'Ugradi dugme';
$string['enableframe'] = 'Prikaži traku akcije i okvir';
$string['enablehublabel'] = 'Koristi H5P OER HUB';
$string['enablejavascript'] = 'Omogući JavaScript.';
$string['enablesavecontentstate'] = 'Snimi status interaktivnog sadržaja';
$string['enablesavecontentstate_help'] = 'Automatski se snima trenutno stanje interaktivnih sadržaja za svakog korisnika. To znači da korisnik može da nastavi tamo gde je stao.';
$string['failedtodownloadh5p'] = 'Nije moguće preuzeti traženi H5P.';
$string['fileexceedsmaxsize'] = 'Jedna od datoteka unutar paketa premašuje maksimalnu dozvoljenu veličinu datoteke. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Datoteka nije pronađena na serveru. Proverite podešavanja za postavljanje datoteka.';
$string['filenotimage'] = 'Datoteka nije slika';
$string['filetypenotallowed'] = 'Tip datoteke nije dozvoljen.';
$string['finished'] = 'Završeno';
$string['fullscreen'] = 'Prikaz preko celog ekrana';
$string['gpl'] = 'General Public License v3';
$string['gradeheading'] = 'Rezultati za {$a}';
$string['gradetopassmustbeset'] = 'Ocena za prolaz ne može biti nula jer ova H5P aktivnost ima kao uslov za završetak prelaznu ocenu. Podesite vrednost različitu od nule.';
$string['gradetopassnotset'] = 'Ova H5P aktivnost još uvek nema podešenu ocenu za prolaz. Ona se može podesiti u odeljku Ocena na stranici za podešavanja aktivnosti H5P.';
$string['h5pfile'] = 'H5P datoteka';
$string['h5ptitle'] = 'Posetite H5P.org kako biste pronašli više interesantnih sadržaja.';
$string['helpchoosinglicense'] = 'Pomozite mi da izaberem licencu';
$string['hide'] = 'Sakrij';
$string['hideadvanced'] = 'Sakrij napredna podešavanja';
$string['hubcommunicationdisabled'] = 'Komunikacija sa H5P čvorištem je onemogućena jer je jedan ili više H5P uslova nije ispunjen.';
$string['hubisdisabled'] = 'Čvorište je onemogućeno. Možete ga ponovo omogućiti u H5P podešavanjima.';
$string['hubisdisableduploadlibraries'] = 'H5P OER HUB je onemogućeno dok se ovaj problem ne reši. I dalje možete postaviti biblioteke preko stranice "H5P Biblioteke".';
$string['hubsettingsheader'] = 'Tipovi interaktivnih sadržaja';
$string['hvp:addinstance'] = 'Kreiranje novih H5P aktivnosti';
$string['hvp:contenthubregistration'] = 'Registracija sajta na H5P OER HUB-u';
$string['hvp:emailconfirmsubmission'] = 'Dobijanje e-poruke sa potvrdom da je predat pokušaj rešavanja H5P aktivnosti';
$string['hvp:emailnotifysubmission'] = 'Dobijanje e-poruke sa obaveštenjem da je predat pokušaj rešavanja H5P aktivnosti';
$string['hvp:getcachedassets'] = 'Potrebno za pregled aktivnosti H5P aktivnosti';
$string['hvp:getembedcode'] = 'Prikaz H5P kôda za ugrađivanje kada je podešena opcija \'kontrolisano putem ovlašćenja\\';
$string['hvp:getexport'] = 'Preuzimanje h5p datoteke kada je podešena opcija \'kontrolisano putem ovlašćenja\\';
$string['hvp:installrecommendedh5plibraries'] = 'Instaliranje novih bezbednih tipova H5P interaktivnog sadržaja koje preporučuje H5P.org';
$string['hvp:manage'] = 'Uređivanje postojećih H5P aktivnosti';
$string['hvp:restrictlibraries'] = 'Ograničavanje pristupa određenim tipovima H5P interaktivnog sadržaja';
$string['hvp:savecontentuserdata'] = 'Čuvanje podataka o napredovanju korisnika za H5P aktivnosti';
$string['hvp:saveresults'] = 'Čuvanje rezultata iz završenih H5P aktivnosti';
$string['hvp:share'] = 'Deljenje sadržaja na H5P OER HUB-u';
$string['hvp:updatelibraries'] = 'Instaliranje novih H5P tipova interaktivnog sadržaja ili ažuriranje postojećih';
$string['hvp:userestrictedlibraries'] = 'Korišćenje ograničenih tipova H5P interaktivnog sadržaja';
$string['hvp:view'] = 'Pregled i interakcija sa H5P aktivnostima';
$string['hvp:viewallresults'] = 'Prikaz svih rezultata za završenih H5P aktivnosti';
$string['hvp:viewresults'] = 'Prikaz sopstvenih rezultata za završene H5P aktivnosti';
$string['icon'] = 'Ikonica';
$string['icondescription'] = '640x480px. Ako nije izabrano, sadržaj će koristiti ikonicu kategorije';
$string['in'] = 'u';
$string['installdenied'] = 'Nemate dozvolu da instalirate tipove interaktivnog sadržaja. Obratite se administratoru svog sajta.';
$string['installedlibraries'] = 'Instalirane biblioteke';
$string['intro'] = 'Uvod';
$string['invalidage'] = 'Neispravan format unosa za tipičan uzrast. Mogući formati unosa odvojeni zarezima: "1, 34-45, -50, -59-".';
$string['invalidaudioformat'] = 'Neispravan format audio datoteke. Koristite mp3 ili wav.';
$string['invalidcontentfolder'] = 'Neispravan direktorijum interaktivnog sadržaja';
$string['invalidcontenttype'] = 'Izabrani tip interaktivnog sadržaja nije ispravan.';
$string['invalidfieldtype'] = 'Neispravan tip datoteke';
$string['invalidfile'] = 'Datoteke "{$a->%filename}" nije dozvoljena. Dozvoljene su samo datoteke sa sledećim ekstenzijama: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Nije moguće poslati H5P.';
$string['invalidhvp'] = 'Neispravna H5P aktivnost';
$string['invalidimageformat'] = 'Neispravan format grafičke datoteke. Koristite jpg, png ili gif.';
$string['invalidlanguagefile'] = 'Neispravna jezička datoteka {$a->%file} u biblioteci {$a->%library}';
$string['invalidlanguagefile2'] = 'Neispravna jezička datoteka {$a->%languageFile} je uključena u biblioteku {$a->%name}';
$string['invalidlibrary'] = 'Neispravna biblioteka';
$string['invalidlibrarydata'] = 'Dobijeni neispravni podaci za {$a->%property} u {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Dobijeni neispravni podaci za {$a->%property} u {$a->%library}. Očekivani su Bulovi logički operatori.';
$string['invalidlibraryname'] = 'Neispravan naziv biblioteke: {$a->%name}';
$string['invalidlibrarynamed'] = 'Biblioteka H5P {$a->%library} koja se koristi u interaktivnom sadržaju nije ispravna';
$string['invalidlibraryoption'] = 'Nedopuštena opcija {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Nije moguće očitati svojstvo {$a->%property} u {$a->%library}';
$string['invalidmainjson'] = 'Nedostaje ispravna glavna h5p.json datoteka';
$string['invalidmultiselectoption'] = 'Neispravno izabrana opcija pri izboru više opcija';
$string['invalidparameters'] = 'Neispravni parametri';
$string['invalidselectoption'] = 'Neispravno izabrana opcija pri izboru opcije';
$string['invalidsemanticsjson'] = 'Neispravna datoteka semantics.json je uključena u datoteku {$a->%name}';
$string['invalidsemanticstype'] = 'H5P interna greška: nepoznati tip interaktivnog sadržaja "{$a->@type}" u semantici. Sadržaj se uklanja!';
$string['invalidstring'] = 'Dobijeni string nije ispravan prema pravilima korišćenja regularnih izraza (regexp) u semantici (value: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'H5P je dobio neispravan token. Osvežite stranicu i pokušajte ponovo';
$string['invalidvideoformat'] = 'Neispravan format video datoteke. Koristite mp4 ili webm.';
$string['invalidxapiresult'] = 'Nisu pronađeni xAPI rezultati za datu kombinaciju interaktivnog sadržaja i ID oznake korisnika';
$string['isnowsubmitted'] = 'Sada se dostavlja H5P OER HUB-u';
$string['javascriptloading'] = 'Sačekajte da se pokrene JavaScript...';
$string['keywordexists'] = 'Ključna reč već postoji!';
$string['keywords'] = 'Ključne reči';
$string['keywordsdescription'] = 'Možete dodati veći broj ključnih reči odvojenih zarezima. Pritisnite taster "Enter" ili dugme "Dodaj" kako biste potvrdili ključne reči';
$string['keywordsexists'] = 'Ključne reči već postoje!';
$string['keywordsplaceholder'] = 'Dodaj ključne reči';
$string['language'] = 'Jezik';
$string['level'] = 'Nivo';
$string['libraries'] = 'H5P biblioteke';
$string['librarydirectoryerror'] = 'Naziv direktorijuma biblioteke mora da se poklapa sa machineName ili machineName-majorVersion.minorVersion (iz datoteke library.json). (Direktorijum: {$a->%directoryName}, machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Akcije';
$string['librarylistinstancedependencies'] = 'Zavisnosti instance';
$string['librarylistinstances'] = 'Instance';
$string['librarylistlibrarydependencies'] = 'Zavisnosti biblioteke';
$string['librarylistrestricted'] = 'Ograničeno';
$string['librarylisttitle'] = 'Naslov';
$string['librarynotselected'] = 'Morate da izaberete tip interaktivnog sadržaja.';
$string['license'] = 'Licenca';
$string['licenseCC010'] = 'CC0 1.0 Univerzalna licenca (CC0 1.0) Posvećenost javnom vlasništvu';
$string['licenseCC010U'] = 'CC0 1.0 Univerzalna licenca';
$string['licenseCC10'] = '1.0 Nelokalizovana licenca';
$string['licenseCC20'] = '2.0 Nelokalizovana licenca';
$string['licenseCC25'] = '2.5 Nelokalizovana licenca';
$string['licenseCC30'] = '3.0 Nelokalizovana licenca';
$string['licenseCC40'] = '4.0 Međunarodna licenca';
$string['licenseGPL'] = 'Opšta javna licenca';
$string['licenseV1'] = 'Verzija 1';
$string['licenseV2'] = 'Verzija 2';
$string['licenseV3'] = 'Verzija 3';
$string['licensedescription'] = 'Izaberite licencu za svoj sadržaj';
$string['licensedetails'] = 'Detaljne informacije o licenci';
$string['licensedialogdescription'] = 'Kliknite na određenu licencu kako biste dobili informacije o pravilnom korišćenju';
$string['licensee'] = 'Nosilac licence';
$string['licenseextras'] = 'Dodaci licence';
$string['licenseversion'] = 'Verzija licence';
$string['licenseversiondescription'] = 'Izaberite verziju licence';
$string['loadingdata'] = 'Učitavanje podataka';
$string['logouploadtext'] = 'Logo ili avatar organizacije';
$string['longdescription'] = 'Duži opis';
$string['longdescriptionplaceholder'] = 'Duži opis vašeg sadržaja';
$string['lookforupdates'] = 'Potražite nove verzije H5P-a';
$string['maintitle'] = 'Deljenje <strong>:title</strong>';
$string['maximumgrade'] = 'Maksimalna ocena';
$string['maximumgradeerror'] = 'Unesite ispravan pozitivni ceo broj kao maksimalan broj poena koji se može osvojiti za ovu aktivnost';
$string['maxlength'] = ':length predstavlja maksimalan broj znakova';
$string['maxpostsizetoosmall'] = 'Vrednost vašeg PHP podešavanje za maksimalnu veličinu posta (post_max_size) je premala. Sa trenutnim podešavanjima, nećete moći da postavite datotke koje su veće od {$a->%number} MB. To može biti problem kada pokušavate da postavite H5P aktivnosti, slike i video zapise. Povećajte ovo podešavanje na vrednost veću od 5 MB.';
$string['maxscore'] = 'Maksimalan rezultat';
$string['maxuploadsizetoosmall'] = 'Vrednost vašeg PHP podešavanje za maksimalnu veličinu datoteke za postavljanje (upload_max_filesize) je premala. Sa trenutnim podešavanjima, nećete moći da postavite datotke koje su veće od {$a->%number} MB. To može biti problem kada pokušavate da postavite H5P aktivnosti, slike i video zapise. Povećajte ovo podešavanje na vrednost veću od 5 MB.';
$string['messageprovider:confirmation'] = 'Potvrda o vašim predatim pokušajima za H5P aktivnost';
$string['messageprovider:submission'] = 'Obaveštenje o predatim pokušajima za H5P aktivnost';
$string['missingcontentfolder'] = 'Nedostaje ispravan direktorijum interaktivnog sadržaja';
$string['missingcontentuserdata'] = 'Greška: nije moguće pronaći korisničke podatke za interaktivni sadržaj';
$string['missingcoreversion'] = 'Sistem nije mogao da instalira <em>{$a->%component}</em> komponentu iz paketa; sistem zahteva noviju verziju H5P dodatka. Ovaj sajt trenutno koristi verziju {$a->%current}, dok je verzija koja se zahteva {$a->%required} ili novija. Instalirajte novu verziju dodatka, a zatim pokušajte ponovo.';
$string['missingdependency'] = 'Nedostaje zavisnost {$a->@dep} koju zahteva {$a->@lib}.';
$string['missinglibrary'] = 'Nedostaje neophodna biblioteka {$a->@library}';
$string['missinglibraryfile'] = 'Datoteka "{$a->%file}" nedostaje u biblioteci: "{$a->%name}"';
$string['missinglibraryjson'] = 'Nije moguće pronaći library.json datoteku sa ispravnom bibliotekom {$a->%name}';
$string['missinglibraryproperty'] = 'Neophodno svojstvo {$a->%property} nedostaje u {$a->%library}';
$string['missingmbstring'] = 'PHP ekstenzija mbstring nije učitana. H5P zahteva ovu ekstenziju kako bi ispravno funkcionisano';
$string['missingparameters'] = 'Nedostaju parametri';
$string['missinguploadpermissions'] = 'Imajte na umu da u datoteci koja je postavljena  mogu da postoje biblioteke, ali vama nije dozvoljeno da postavite nove biblioteke. Kontaktirajte administratora u vezi sa ovim.';
$string['modulename'] = 'Interaktivni sadržaj';
$string['modulename_help'] = 'Modul aktivnost H5P omogućava da kreirate interaktivne sadržaje, kao što su interaktivni video klipovi, skupovi pitanja, pitanja ”prevuci i spusti”, pitanja višestrukog izbora, prezentacije i još mnogo toga.

Pored toga što predstavlja autorski alat za kreiranje bogatog multimedijalnog sadržaja, H5P vam pruža mogućnost da uvezete i izvezete H5P datoteke, kako biste ih efikasno ponovo koristili i delili sadržaje sa drugima.

Interakcije i njihovi rezultati se prate pomoću xAPI specifikacije i dostupni su u knjizi ocena vašeg Moodlea. Imajte na umu, da korisnici sa progamerskim veštinama mogu da varaju u H5P interakcijama i da ostvare maksimalan rezultat a da pritom ne znaju tačne odgovore. Zbog toga H5P ne treba koristiti za proveru znanja, pogotovo ne sumativnu.

Interaktivni H5P sadržaj dodajete tako što kreirate novi sadržaj koristeći ugrađeni alat za kreiranje ili tako što na server postavljate H5P datoteke koje ste pronašli na drugim H5P sajtovima.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktivni sadržaj';
$string['next'] = 'Sledeće';
$string['nextpage'] = 'Sledeća stranica';
$string['noanswersubmitted'] = 'Ovaj korisnik još nije poslao odgovor na H5P';
$string['nocontent'] = 'Nije moguće pronaći ili parsirati content.json datoteku';
$string['nocontenttype'] = 'Nije naveden tip interaktivnog sadržaja.';
$string['nocopyright'] = 'Nema informacija o autorskim pravima za ovaj interaktivni sadržaj';
$string['nodata'] = 'Ne postoje dostupni podaci koji odgovaraju vašim kriterijumima.';
$string['noexport'] = 'Nedostaje datoteka za izvoz.';
$string['noextension'] = 'Datoteka koju ste postavili nije ispravan HTML5 paket (nema ekstenziju datoteke .h5p).';
$string['noh5ps'] = 'Ne postoji interaktivni sadržaj dostupan za ovaj kurs.';
$string['nohubregistration'] = 'Nije registrovano na H5P OER HUB-u';
$string['nojson'] = 'Glavna h5p.json datoteka nije ispravna';
$string['nombstringexteension'] = 'PHP ekstenzija mbstring nije učitana. H5P -u je ova ekstenzija potrebno kako bi ispravno funkcionisao';
$string['noparameters'] = 'Nema parametara';
$string['noparse'] = 'Nije moguće parsirati glavna h5p.json datoteku';
$string['nopermissiontogettranslations'] = 'Nemate ovlašćenja za preuzimanje prevoda';
$string['nopermissiontorestrict'] = 'Nemate ovlašćenja da ograničite biblioteke.';
$string['nopermissiontosavecontentuserdata'] = 'Nemate ovlašćenja da sačuvate korisničke podatke za interaktivni sadržaj.';
$string['nopermissiontosaveresult'] = 'Nemate ovlašćenja da sačuvate rezultate za ovaj interaktivni sadržaj.';
$string['nopermissiontoupgrade'] = 'Nemate ovlašćenja da nadogradite biblioteke.';
$string['nopermissiontouploadcontent'] = 'Nemate ovlašćenja da postavite interaktivni sadržaj ovde.';
$string['nopermissiontouploadfiles'] = 'Nemate ovlašćenja da postavite datoteke ovde.';
$string['nopermissiontoviewcontenthubcache'] = 'Nemate ovlašćenja da vidite metapodatke za čvorište sadržaja.';
$string['nopermissiontoviewcontenttypes'] = 'Nemate ovlašćenja da vidite tipove interaktivnih sadržaja.';
$string['nopermissiontoviewresult'] = 'Nemate ovlašćenja da vidite rezultate za ovaj interaktivni sadržaj.';
$string['nosuchlibrary'] = 'Ne postoji takva biblioteka';
$string['notapplicable'] = 'N/A - nije primenjivo';
$string['nounzip'] = 'Datoteka koju ste postavili nije ispravan HTML5 paket (nije moguće raspakovati ga).';
$string['noversionattribution'] = 'Autorstvo';
$string['noversionattributionnc'] = 'Autorstvo - Nekomercijalna licenca';
$string['noversionattributionncnd'] = 'Autorstvo - Nekomercijalna licenca - Bez prerada';
$string['noversionattributionncsa'] = 'Autorstvo - Nekomercijalna licenca - Deliti pod istim uslovima';
$string['noversionattributionnd'] = 'Autorstvo - Licenca - Bez prerada';
$string['noversionattributionsa'] = 'Autorstvo - Licenca - Deliti pod istim uslovima';
$string['nowriteaccess'] = 'Otkriven je problem sa pristupom za upisivanje na serveru. Proverite da li vaš server može da upisuje u vaš direktorijum sa podacima.';
$string['noziparchive'] = 'Vaša PHP verzija ne podržava ZipArchive.';
$string['offlinedialogbody'] = 'Nismo bili u mogućnosti da pošaljemo informacije o vašem završetku ovog zadatka. Proverite svoju internet vezu.';
$string['offlinedialogheader'] = 'Vaša veza sa serverom je izgubljena';
$string['offlinedialogretrybuttonlabel'] = 'Pokušajte ponovo';
$string['offlinedialogretrymessage'] = 'Ponovni pokušaj za  :num....';
$string['offlinesuccessfulsubmit'] = 'Rezultati su uspešno poslati.';
$string['oldphpversion'] = 'Vaša PHP verzija je zastarela. H5P zahteva verziju 5.2. kako bi ispravno funkcionisano. Preporučuje se verzija 5.6 ili novija.';
$string['olduploadoldcontent'] = 'Pokušavate da postavite stariju verziju H5P sadržaja. Nadogradite interaktivni sadržaj na serveru na kojem se nalazi i pokušajte ponovo da ga postavite ili uključite H5P OER HUB kako bi server automatski nadogradio interaktivni sadržaj.';
$string['onlyupdate'] = 'Ažuriraj samo postojeće biblioteke';
$string['optionalinfo'] = 'Opcione informacije';
$string['options'] = 'Opcije';
$string['originator'] = 'Kreator';
$string['pd'] = 'Javno vlasništvo';
$string['pddl'] = 'Posvećenost javnom vlasništvu i licenca';
$string['pdm'] = 'Oznaka javnog vlasništva';
$string['phone'] = 'Telefon';
$string['pleasewait'] = 'Molimo, sačekajte...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Za pristup datoj krajnjoj
 tački potrebna je poruka';
$string['previouspage'] = 'Prethodna stranica';
$string['privacy:metadata:core_files'] = 'H5P aktivnost čuva datoteke koje su postavljene kao deo H5P sadržaja.';
$string['privacy:metadata:core_grades'] = 'H5P aktivnost čuva ocene korisnika koji su odgovorili na H5P sadržaj.';
$string['privacy:metadata:hvp_content_user_data'] = 'Opisuje trenutno stanje u kojem se nalazi interaktivni sadržaj za korisnika. Koristi se za vraćanje interaktivnog sadržaja u prethodno stanje.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Korisnički podaci koji se čuvaju.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identifikator tipa podataka.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Oznaka (zastavica) koja obeležava da li podatke treba obrisati kada se interaktivni sadržaj promeni.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID oznaka H5P sadržaja kojem podaci pripadaju.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID oznaka veze između interaktivnog sadržaja i korisničkih podataka.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Oznaka (zastavica) koja obeležava da li podatke treba unapred učitati u interaktivni sadržaj.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Podsadržaj H5P, 0 ako ovo nije podsadržaj.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID oznaka korisnika kojem podaci pripadaju.';
$string['privacy:metadata:hvp_events'] = 'Praćenje zapisa';
$string['privacy:metadata:hvp_events:content_id'] = 'ID oznaka interaktivnog sadržaja na kojem je izvršena akcija. 0 ako je reč o novom interaktivnom sadržaju ili ako nema sadržaja.';
$string['privacy:metadata:hvp_events:content_title'] = 'Naslov interaktivnog sadržaja';
$string['privacy:metadata:hvp_events:created_at'] = 'Vreme kada je događaj kreiran.';
$string['privacy:metadata:hvp_events:id'] = 'Jedinstveni ID oznaka događaja.';
$string['privacy:metadata:hvp_events:library_name'] = 'Biblioteka na koju događaj utiče.';
$string['privacy:metadata:hvp_events:library_version'] = 'Verzija biblioteka na koju događaj utiče.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Podvrsta događaja, akcije ili događaja.';
$string['privacy:metadata:hvp_events:type'] = 'Vrsta događaja';
$string['privacy:metadata:hvp_events:user_id'] = 'ID oznaka korisnika koji je izveo akciju.';
$string['privacy:metadata:hvp_xapi_results'] = 'Čuva xAPI događaje u H5P sadržaju.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Dodatne informacije koje H5P može da pošalje.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID oznaka interaktivnog sadržaja na kojem je događaj izveden.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Šablon tačnog odgovora';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Opis, zadatak ili pitanje interaktivnog sadržaja na kojem je izvedena akcija.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Jedinstvena ID oznaka xAPI događaja.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Tip interakcije.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Maksimalna rezultat koji se može postići za ovaj događaj.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID oznaka matičnog sadržaja kojem pripada interaktivni sadržaj na kojem je ovaj događaj
 izveden. Nula ako matični sadržaj ne postoji.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Postignut rezultat za događaj.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Odgovor koji je korisnik poslao.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID oznaka korisnika koji je izveo akciju.';
$string['publisherdescription'] = 'Opis izdavača';
$string['publisherdescriptiontext'] = 'Ovo će biti prikazano u odeljku "Informacije o izdavaču" na deljenom sadržaju';
$string['publisherfielddescription'] = 'Ovo će biti prikazano kao "Naziv izdavača" na deljenom sadržaju';
$string['publisherfieldtitle'] = 'Izdavač';
$string['question'] = 'Pitanje';
$string['registeronhub'] = 'Registrujte se na H5P OER HUB-u';
$string['registrationfailed'] = 'Došlo je do greške';
$string['registrationfaileddescription'] = 'Nismo bili u mogućnosti da otvorimo nalog u ovom trenutku. Nešto nije u redu. Pokušajte ponovo kasnije.';
$string['registrationtitle'] = 'H5P OER HUB Registracija';
$string['remove'] = 'Ukloni';
$string['removechip'] = 'Uklonite :chip sa spiska';
$string['removeimage'] = 'Ukloni sliku';
$string['removeoldlogentries'] = 'Uklonjanje starih H5P zapisa';
$string['removeoldmobileauthentries'] = 'Uklananje starih H5P unosa za potvrdu identieta putem mobilniih uređaja';
$string['removetmpfiles'] = 'Uklanjanje starih H5P privremenih datoteka';
$string['reportingquestionsremaininglabel'] = 'pitanja koja ostaju da budu ocenjena';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Rezultat u dnevniku ocena:';
$string['reportingscoredelimiter'] = 'od';
$string['reportingscorelabel'] = 'Rezultat:';
$string['reportnotsupported'] = 'Nije podržan';
$string['reportsubmitgradelabel'] = 'Pošalji ocenu';
$string['requiredinfo'] = 'Potrebne informacije';
$string['resizescript'] = 'Uključite ovaj skript na svom sajtu ako želite dinamičku promenu veličine ugrađenog interaktivnog sadržaja:';
$string['resubmitscores'] = 'Pokušaj slanja sačuvanih rezultata.';
$string['reuse'] = 'Ponovno korišćenje';
$string['reusecontent'] = 'Ponovna upotreba sadržaja';
$string['reusedescription'] = 'Ponovo upotrebite ovaj sadržaj.';
$string['reveal'] = 'Otkrij';
$string['reviewandsave'] = 'Pregledajte i sačuvajte';
$string['reviewandshare'] = 'Pregledajte i delite';
$string['reviewinfo'] = 'Pregledajte informacije';
$string['reviewmessage'] = 'Pregledajte informacije u nastavku pre nego što podelite sadržaj';
$string['reviseserversetupandretry'] = 'Kada revidirate podešavanja vašeg servera, možete ponovo omogućiti komunikaciju sa H5P čvorištem u H5P podešavanjima.';
$string['savechanges'] = 'Sačuvaj izmene';
$string['score'] = 'Rezultat';
$string['screenshots'] = 'Snimci ekrana';
$string['screenshotsdescription'] = 'Dodajte do pet snimaka ekrana svog sadržaja';
$string['search'] = 'Pretraži';
$string['searchplaceholder'] = 'Unesite tekst za pretragu disciplina';
$string['sendusagestatistics'] = 'Dajte svoj doprinos statistici korišćenja';
$string['sendusagestatistics_help'] = 'Statistički podaci o korišćenju automatski će biti prosleđeni kako bi pomogli programerima da bolje razumeju kako se H5P koristi i kako bi se odredile potencijalne oblasti poboljšanja. Pročitajte više o tome koji se <a {$a}>podaci prikupljaju na h5p.org</a>.';
$string['settings'] = 'H5P podešavanja';
$string['share'] = 'Podeli';
$string['shared'] = 'Podeljeno';
$string['sharefailed'] = 'Deljenje nije uspelo.';
$string['sharetryagain'] = 'Nešto nije u redu, pokušajte ponovo da podelite.';
$string['sharingnote'] = 'Svi detalji sadržaja mogu se uređivati nakon deljenja';
$string['shortdescription'] = 'Kratak opis';
$string['shortdescriptionplaceholder'] = 'Kratak opis vašeg sadržaja';
$string['showadvanced'] = 'Prikaži napredna podešavanja';
$string['showless'] = 'Prikaži manje';
$string['showmore'] = 'Prikaži više';
$string['sitecouldnotberegistered'] = 'Sajt nije mogao biti registrovan na H5P čvorištu. Obratite se administratoru sajta.';
$string['sitekey'] = 'Ključ sajta';
$string['sitekeydescription'] = 'Ključ sajta je jedinstveni tajni ključ koji služi za identifikaciju ovog sajta na H5P OER HUB-u.';
$string['sitekeyregistered'] = 'Dobili ste jedinstveni ključ koji vas identifikuje na H5P OER HUB-u prilikom preuzimanja novih verzija i ispravki. Ključ je dostupan na stranici "H5P OER HUB - Podešavanja naloga".';
$string['size'] = 'Veličina';
$string['somekeywordsexists'] = 'Neke od ovih ključnih reči već postoje';
$string['source'] = 'Izvor';
$string['sslnotenabled'] = 'Vaš server nema uključen SSL. SSL treba da uključiti kako bi se obezbedila bezbedna veza sa H5P čvorištem.';
$string['startingover'] = 'Započećete iz početka';
$string['subcontentwarning'] = 'Delovi sadržaja (kao što su slike, pitanja itd.) će se deliti pod licencom :license osim ako nije drugačije naznačeno u alatu za kreiranje sadržaja';
$string['sublevel'] = 'Podnivo';
$string['submitted'] = 'Predato!';
$string['successfullyregisteredwithhub'] = 'Vaš sajt je uspešno registrovan na H5P OER HUB-u.';
$string['successfullyregistred'] = 'Uspešno ste registrovali nalog na H5P OER HUB-u';
$string['successfullyregistreddescription'] = 'Detalji vašeg naloga mogu se promeniti';
$string['successfullyupdated'] = 'Podešavanja vašeg H5P OER HUB naloga uspešno su promenjena';
$string['thumbnail'] = 'Umanjena verzija slika';
$string['title'] = 'Naslov';
$string['unabletocreatedir'] = 'Nije moguće kreirati direktorijum.';
$string['unabletogetfieldtype'] = 'Nije moguće preuzeti tip polja.';
$string['undisclosed'] = 'Neotkriveno';
$string['unpackedfilesexceedsmaxsize'] = 'Ukupna veličina raspakovanih datoteka premašuje maksimalnu dozvoljenu veličinu. (%used > %max)';
$string['updatedlibraries'] = 'Ažurirano starih H5P biblioteka {$a->%old}.';
$string['updatedlibrary'] = 'Ažurirana {$a->%old} H5P biblioteka.';
$string['updatelibraries'] = 'Ažuriraj sve biblioteke';
$string['updateregistrationonhub'] = 'Sačuvajte podešavanja naloga';
$string['upgrade'] = 'Nadogradi H5P';
$string['upgradebuttonlabel'] = 'Nadogradi';
$string['upgradedone'] = 'Uspešno ste nadogradili {$a} instancu/e/i sadržaja';
$string['upgradeerror'] = 'Došlo je do greške prilikom obrade parametara:';
$string['upgradeerrorcontent'] = 'Nije moguće nadograditi interaktivni sadržaj %id:';
$string['upgradeerrordata'] = 'Nije moguće učitati podatke za biblioteku %lib.';
$string['upgradeerrormissinglibrary'] = 'Nedostaje obavezna biblioteka %lib.';
$string['upgradeerrornotsupported'] = 'Parametri sadrže %used koji nije podržan.';
$string['upgradeerrorparamsbroken'] = 'Parametri su neispravni.';
$string['upgradeerrorscript'] = 'Nije moguće učitati skript za nadogradnju za %lib.';
$string['upgradeerrortoohighversion'] = 'Parametri sadrže %used dok su podržani samo %supported ili novije verzije.';
$string['upgradeheading'] = 'Nadogradi interaktivni sadržaj {$a}';
$string['upgradeinprogress'] = 'Nadogradnja na %ver...';
$string['upgradeinvalidtoken'] = 'Greška: neispravan bezbednosni token!';
$string['upgradelibrarycontent'] = 'Nadogradi sadržaj biblioteke';
$string['upgradelibrarymissing'] = 'Greška: vaša biblioteka nedostaje!';
$string['upgrademessage'] = 'Nameravate da nadogradite {$a} instancu/e/i sadržaja. Molimo, izaberite verziju za nadogradnju.';
$string['upgradenoavailableupgrades'] = 'Ne postoje dostupna nadogradnje za ovu biblioteku.';
$string['upgradenothingtodo'] = 'Ne postoje instance interaktivnog sadržaja za nadogradnju.';
$string['upgradereturn'] = 'Povratak';
$string['upload'] = 'Postavi';
$string['uploadlibraries'] = 'Postavi biblioteke';
$string['uploadsizelargerthanpostsize'] = 'Vrednost vašeg PHP podešavanje za maksimalnu veličinu datoteke za postavljanje  (upload_max_filesize) je manja od vrednosti podešavanje za maksimalnu veličinu posta (post_max_size). Poznato je da ovo uzrokuje probleme u nekim instalacijama.';
$string['user'] = 'Korisnik';
$string['validatingh5pfailed'] = 'Provera ispravnosti h5p paketa nije uspela.';
$string['validationfailed'] = 'Traženi H5P nije bio ispravan';
$string['viewreportlabel'] = 'Izveštaj';
$string['welcomecommunity'] = 'Nadamo se da ćete uživati u H5P-u i da ćete se pridružiti  našoj rastućoj zajednici putem naših  <a {$a->forums}>foruma</a>.';
$string['welcomecontactus'] = 'Ukoliko imate bilo kakve povratne informacije, ne ustručavajte se da <a {$a}>nas kontaktirate</a>. Mi sve povratne informacije uzimamo veoma ozbiljno i posvećeni smo tome da H5P bude bolji svaki dan!';
$string['welcomegettingstarted'] = 'Da biste započeli korišćenjem H5P-a i Moodlea pogledajte naš <a {$a->moodle_tutorial}>vodič</a>. Takođe, pogledajte, inspiracije radi, <a {$a->example_content}>primer interaktivnog sadržaja</a> na H5P.org.<br>Kako biste lakše koristili H5P instalirani su najpopularniji tipovi sadržaja!';
$string['welcomeheader'] = 'Dobro došli u H5P svet!';
$string['wrongversion'] = 'Verzija H5P biblioteke {$a->%machineName} korišćena u ovom sadržaju nije ispravna. Interaktivni sadržaj sadrži {$a->%contentLibrary}, ali bi trebalo da bude {$a->%semanticsLibrary}.';
$string['year'] = 'Godina';
$string['years'] = 'Godina/e';
$string['yearsfrom'] = 'Godine (od)';
$string['yearsto'] = 'Godine (do)';
$string['zip'] = 'Zip';
