<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_turnitinsim', language 'sv', version '4.3'.
 *
 * @package     plagiarism_turnitinsim
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessoptions'] = 'Studentåtkomst';
$string['accessoptions_help'] = 'Studenter kommer att ha åtkomst till likhetsrapporten för deras inlämning när den har genererats.';
$string['accessstudents'] = 'Tillåt studenter att visa likhetsrapporter';
$string['addtoindex'] = 'Indexera alla inlämningar';
$string['code'] = 'Kod';
$string['connecttest'] = 'Testa Turnitin-anslutning';
$string['connecttestfailed'] = 'Anslutningstestet misslyckades.';
$string['connecttestsuccess'] = 'Anslutningstestet lyckades';
$string['dbexport'] = 'Databasexport';
$string['dbexporttable'] = 'Exportera data för {$a}';
$string['defaultsettings'] = 'Standardinställningar';
$string['errortoolarge'] = 'Den här filen kommer inte att skickas till Turnitin, eftersom den överskrider den maximala filstorleken på {$a}';
$string['eulaaccept'] = 'Jag accepterar licensvillkoren för Turnitin';
$string['eulaaccepted'] = 'Tack för att du accepterade de nya licensvillkoren för Turnitin. Alla framtida inlämningar kommer nu att skickas till Turnitin för bearbetning.';
$string['eulaalreadyaccepted'] = 'Du har redan godkänt det senaste slutanvändaravtalet från Turnitin.';
$string['euladecline'] = 'Jag accepterar inte licensvillkoren för Turnitin';
$string['euladeclined'] = 'Din inlämning kommer inte att skickas till Turnitin, eftersom du inte har accepterat licensvillkoren för Turnitin.';
$string['eulaheader'] = 'Licensvillkor för Turnitin';
$string['eulalink'] = 'För att den här inlämningen ska skickas till Turnitin måste du acceptera <a href="{$a}" target="_blank">licensvillkoren för Turnitin</a>.';
$string['eulalinkgeneric'] = 'Om du vill att någon av dina framtida inlämningar ska skickas till Turnitin måste du acceptera <a href="{$a}" target="_blank">licensvillkoren för Turnitin</a>.';
$string['eulalinkmodal'] = 'För att den här inlämningen ska skickas till Turnitin måste du acceptera <a href="#" class="eula_link">licensvillkoren för Turnitin</a>.';
$string['eulanotrequired'] = 'Du behöver inte godkänna slutanvändaravtalet från Turnitin.';
$string['excludebiblio'] = 'Bibliografi';
$string['excludeoptions'] = 'Uteslut från likhetsrapporter';
$string['excludeoptions_help'] = 'Markerade alternativ kommer inte att visas som en matchning i likhetsrapporter.';
$string['excludequotes'] = 'Citat';
$string['faultcode'] = 'Felkod';
$string['getwebhookfailure:message'] = 'Det kan finnas ett problem med webhooken som du har registrerat med Turnitin för Plagiarism-tillägget. Den schemalagda uppgiften att kontrollera det kunde inte ansluta till Turnitin. Se dina loggar.';
$string['getwebhookfailure:subject'] = 'Kontroll av Turnitin-webhook misslyckades';
$string['indexoptions'] = 'Inlämningsindexering';
$string['indexoptions_help'] = 'Indexerade inlämningar kommer att vara tillgängliga för jämförelse i likhetsrapporter.';
$string['invalidtablename'] = 'Tabellen {$a} kunde inte exporteras';
$string['line'] = 'Rad';
$string['message'] = 'Meddelande';
$string['messageprovider:digital_receipt_instructor'] = 'Digitalt Turnitin-instruktörskvitto';
$string['messageprovider:digital_receipt_student'] = 'Digitalt Turnitin-studentkvitto';
$string['messageprovider:get_webhook_failure'] = 'Kontroll av Turnitin-webhook misslyckades';
$string['messageprovider:new_eula'] = 'Nya licensvillkor för Turnitin';
$string['neweula:message'] = 'Turnitin har släppt nya licensvillkor. För ytterligare information, klicka <a href="{$a}">här</a>.';
$string['neweula:subject'] = 'Nya licensvillkor för Turnitin släppta';
$string['pluginname'] = 'Turnitin Integrity-tillägg';
$string['pluginsetup'] = 'Konfiguration';
$string['privacy:metadata:plagiarism_turnitinsim_client'] = 'För att skicka en inlämning till Turnitin måste specifika användardata utbytas mellan Moodle och Turnitin. För mer information om Moodle-tillägg och GDPR, besök: https://help.turnitin.com/feedback-studio/moodle/moodle-plugins-and-gdpr.htm';
$string['privacy:metadata:plagiarism_turnitinsim_client:firstname'] = 'Användarens förnamn skickas till Turnitin vid en Turnitin Viewer-start, så att användaren kan identifieras.';
$string['privacy:metadata:plagiarism_turnitinsim_client:lastname'] = 'Användarens efternamn skickas till Turnitin vid en Turnitin Viewer-start, så att användaren kan identifieras.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_content'] = 'Observera att innehållet i en fil/inlämning skickas till Turnitin för bearbetning.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_filename'] = 'Namnet på den inlämnade filen skickas till Turnitin så att den kan identifieras.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_title'] = 'Titeln på inlämningen skickas till Turnitin så att den kan identifieras.';
$string['privacy:metadata:plagiarism_turnitinsim_sub'] = 'Information som länkar en Moodle-inlämning till en Turnitin-inlämning.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:identifier'] = 'En hash som används av Moodle för att identifiera den skickade filen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:itemid'] = 'ID som identifierar inlämningen för den relevanta modultypen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:overallscore'] = 'Inlämningens totala likhetspoäng.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:submittedtime'] = 'En tidsstämpel som anger när användarens inlämning skickades till Turnitin.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:turnitinid'] = 'Det ID som används av Turnitin för att referera till inlämningen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:userid'] = 'ID för den användare som har gjort en inlämning.';
$string['privacy:metadata:plagiarism_turnitinsim_users'] = 'Information som länkar en Moodle-användare till en Turnitin-användare.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaaccepted'] = 'Den senaste versionen av licensvillkoren för Turnitin som accepterades av användaren.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaacceptedlang'] = 'Det språk på vilket användaren senast accepterade licensvillkoren för Turnitin.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaacceptedtime'] = 'En tidsstämpel som anger när användaren senast accepterade licensvillkoren för Turnitin.';
$string['privacy:metadata:plagiarism_turnitinsim_users:turnitinid'] = 'Det ID som används av Turnitin för att referera till användaren.';
$string['privacy:metadata:plagiarism_turnitinsim_users:userid'] = 'ID för den användare som har gjort en inlämning.';
$string['queuedrafts'] = 'Behandla inlämningsutkast';
$string['queuedrafts_help'] = 'Observera att inlämningsutkast inte kommer att indexeras i Turnitin för kontroll mot';
$string['receiptsinstructor:message'] = 'En inlämning med titeln <strong>{$a->submission_title}</strong> som gjordes till modulen <strong>{$a->module_name}</strong> i klassen <strong>{$a->course_fullname}</strong> har skickats till Turnitin.<br /><br />Inlämnings-ID: <strong>{$a->submission_id}</strong><br />Inlämningsdatum: <strong>{$a->submission_date}</strong>';
$string['receiptsinstructor:subject'] = 'Inlämning skickad till Turnitin';
$string['receiptstudent:message'] = 'Bästa {$a->firstname} {$a->lastname},<br /><br />Din fil <strong>{$a->submission_title}</strong> till modulen <strong>{$a->module_name}</strong> i klassen <strong>{$a->course_fullname}</strong> har skickats till Turnitin den <strong>{$a->submission_date}</strong>. Ditt inlämnings-ID är <strong>{$a->submission_id}</strong>.<br /><br />Tack för att du använder Turnitin,<br /><br />Turnitin-teamet';
$string['receiptstudent:subject'] = 'Det här är ditt digitala Turnitin-kvitto';
$string['reportgen0'] = 'Omedelbart';
$string['reportgen1'] = 'Omedelbart och generera igen på förfallodagen';
$string['reportgen2'] = 'Förfallodatum';
$string['reportgenoptions'] = 'Generera likhetsrapporter';
$string['reportgenoptions_help'] = '<strong>Omedelbart:</strong>Likhetsrapporter kommer att genereras omedelbart efter att filen har skickats.<br/><br/><strong>På förfallodatumet:</strong> Likhetsrapporter kommer endast att genereras på uppgiftens förfallodatum.<br/><br/><strong>Omedelbart och på förfallodatumet:</strong> En likhetsrapport kommer att genereras omedelbart efter att filen har skickats. Likhetsrapporten kommer att genereras igen på uppgiftens förfallodatum. Det här alternativet kan användas för att kontrollera samverkan inom en klass.';
$string['resubmittoturnitin'] = 'Skicka till Turnitin igen';
$string['savesuccess'] = 'Ändringar sparade';
$string['settingslearnmore'] = 'Läs mer om Turnitin-inställningarna';
$string['submissiondisplayerror:cannotextracttext'] = 'Rapport ej tillgänglig';
$string['submissiondisplayerror:cannotextracttext_help'] = 'Det gick inte att generera en rapport för den här inlämningen. Detta kan bero på att filtypen inte kan generera en rapport eller på att det inte finns tillräckligt med text.';
$string['submissiondisplayerror:corruptfile'] = 'Skadad fil';
$string['submissiondisplayerror:corruptfile_help'] = 'Den uppladdade filen verkar vara skadad.';
$string['submissiondisplayerror:eulanotaccepted'] = 'Licensvillkor ej accepterade';
$string['submissiondisplayerror:eulanotaccepted_help'] = 'Licensvillkoren för Turnitin måste accepteras av inlämnaren innan inlämningen kan kontrolleras angående likhet.';
$string['submissiondisplayerror:filelocked'] = 'Fil låst';
$string['submissiondisplayerror:filelocked_help'] = 'Den uppladdade filen kräver ett lösenord för att kunna öppnas.';
$string['submissiondisplayerror:generic'] = 'Filen skickades inte till Turnitin';
$string['submissiondisplayerror:generic_help'] = 'Den här filen har inte skickats till Turnitin, kontakta din systemadministratör';
$string['submissiondisplayerror:notsent'] = 'Filen skickades inte till Turnitin';
$string['submissiondisplayerror:notsent_help'] = 'Filen har inte skickats till Turnitin, eftersom Turnitin inte var aktiverat vid tidpunkten för inlämningen. Ändra eller ladda upp din inlämning igen om du vill att den ska skickas till Turnitin.';
$string['submissiondisplayerror:processingerror'] = 'Bearbetningsfel';
$string['submissiondisplayerror:processingerror_help'] = 'Ett ospecificerat fel inträffade vid behandling av inlämningarna.';
$string['submissiondisplayerror:toolarge'] = 'Filen är för stor';
$string['submissiondisplayerror:toolarge_help'] = 'Filen är för stor för att skicka till Turnitin. För att kontrollera originalitet, skicka en fil som är mindre än 100 MB.';
$string['submissiondisplayerror:toolittletext'] = 'Inte tillräckligt med text';
$string['submissiondisplayerror:toolittletext_help'] = 'Inlämningen har inte tillräckligt med text för att generera en likhetsrapport (en inlämning måste innehålla minst 20 ord)';
$string['submissiondisplayerror:toomanypages'] = 'För många sidor';
$string['submissiondisplayerror:toomanypages_help'] = 'Inlämningen har för många sidor för att generera en likhetsrapport (en inlämning får inte innehålla mer än 400 sidor)';
$string['submissiondisplayerror:toomuchtext'] = 'För mycket text';
$string['submissiondisplayerror:toomuchtext_help'] = 'Inlämningen har för mycket text för att generera en likhetsrapport (när den extraherade texten har konverterats till UTF-8 får inlämningen inte innehålla mer än {$a} text)';
$string['submissiondisplayerror:unknown'] = 'Ett fel uppstod med din inlämning';
$string['submissiondisplayerror:unknown_help'] = 'Det uppstod ett okänt fel med din inlämning, så den här filen har inte skickats till Turnitin. Kontakta din systemadministratör.';
$string['submissiondisplayerror:unsupportedfiletype'] = 'Filtypen stöds ej';
$string['submissiondisplayerror:unsupportedfiletype_help'] = 'Den uppladdade filtypen stöds inte.';
$string['submissiondisplaystatus:awaitingeula'] = 'Väntar på licensvillkor';
$string['submissiondisplaystatus:cannotextracttext'] = 'Rapport ej tillgänglig';
$string['submissiondisplaystatus:error'] = 'Fel';
$string['submissiondisplaystatus:notsent'] = 'Skickades inte';
$string['submissiondisplaystatus:pending'] = 'Väntande';
$string['submissiondisplaystatus:queued'] = 'I kö';
$string['submissiondisplaystatus:unknown'] = 'Okänt fel';
$string['taskadminupdate'] = 'Uppdatera lokal konfiguration för Turnitin Integrity-tillägg';
$string['taskgetreportscores'] = 'Hämta rapportresultat för Turnitin Integrity Plugin';
$string['taskoutputenabledfeaturesnotretrieved'] = 'Turnitin-aktiverade funktioner kunde inte hämtas';
$string['taskoutputenabledfeaturesretrievalfailure'] = 'Anrop av Turnitin-aktiverade funktioner misslyckades';
$string['taskoutputenabledfeaturesretrieved'] = 'Turnitin-aktiverade funktioner hämtade';
$string['taskoutputfailedconnection'] = 'Det uppstod ett problem med att ansluta till Turnitin-API:t';
$string['taskoutputfailedcvlaunchurl'] = 'Det uppstod ett problem med att begära en start-URL för Turnitin Viewer från Turnitin-API:t för inlämnings-ID: {$a}';
$string['taskoutputfailedreportrequest'] = 'Det uppstod ett problem med att begära att en originalitetsrapport skulle genereras från Turnitin-API:t för inlämnings-ID: {$a}';
$string['taskoutputfailedscorerequest'] = 'Det uppstod ett problem med att begära ett originalitetsrapportsresultat från Turnitin-API:t för inlämnings-ID: {$a}';
$string['taskoutputfailedupload'] = 'Det uppstod ett problem med en filuppladdning till Turnitin-API:t för inlämnings-ID: {$a}';
$string['taskoutputfileuploaded'] = 'Fil uppladdad till Turnitin-inlämning: {$a}';
$string['taskoutputlatesteulanotretrieved'] = 'Den senaste versionen av licensvillkoren kunde inte hämtas';
$string['taskoutputlatesteularetrievalfailure'] = 'Anropet av den senaste versionen av licensvillkoren misslyckades.';
$string['taskoutputlatesteularetrieved'] = 'Licensvillkorsversion {$a} hämtad.';
$string['taskoutputpluginnotconfigured'] = 'Uppgiften {$a} kunde inte köras, eftersom Turnitin Integrity-tillägget inte har konfigurerats. <br/>Gå till tilläggskonfigurationssidan i Webbplatsadministration för att lägga till dina Turnitin API-autentiseringsuppgifter.';
$string['taskoutputsubmissioncreated'] = 'Inlämning skapad i Turnitin: {$a}';
$string['taskoutputsubmissionnotcreatedeula'] = 'Inlämningen kunde inte skapas i Turnitin, eftersom inlämnaren inte har accepterat licensvillkoren.';
$string['taskoutputsubmissionnotcreatedgeneral'] = 'Inlämningen kunde inte skapas i Turnitin. Se dina loggar.';
$string['taskoutputwebhookcreated'] = 'Webhook skapad. Turnitin kommer att skicka återanrop till {$a}';
$string['taskoutputwebhookcreationfailure'] = 'Begäran om webhook-skapande misslyckades. Se dina loggar.';
$string['taskoutputwebhookdeleted'] = 'Webhook {$a} har tagits bort.';
$string['taskoutputwebhookdeletefailure'] = 'Webhook kunde inte tas bort. Se dina loggar.';
$string['taskoutputwebhooknotcreated'] = 'Webhook kunde inte skapas. Se dina loggar.';
$string['taskoutputwebhooknotdeleted'] = 'Webhook {$a} kunde inte tas bort.';
$string['taskoutputwebhooknotretrieved'] = 'Webhook {$a} kunde inte hämtas. En ny webhook kommer att skapas';
$string['taskoutputwebhookretrievalfailure'] = 'Hämtningsanrop för webhook {$a} misslyckades.';
$string['taskoutputwebhookretrieved'] = 'Webhook {$a} hämtad. Webhooken är aktiv.';
$string['tasksendqueuedsubmissions'] = 'Skicka köade filer från Turnitin Integrity-tillägget';
$string['turnitinapikey'] = 'API-nyckel för Turnitin';
$string['turnitinapiurl'] = 'URL för Turnitin-API';
$string['turnitinconfig'] = 'Tilläggskonfiguration';
$string['turnitinenablelogging'] = 'Aktivera diagnostikläge';
$string['turnitinfeatures'] = 'Turnitin Integrity-funktioner';
$string['turnitinfeatures::eulanotrequired'] = 'Användare behöver inte acceptera licensvillkoren för Turnitin';
$string['turnitinfeatures::eularequired'] = 'Alla användare måste acceptera licensvillkoren för Turnitin';
$string['turnitinfeatures::header'] = 'Turnitin Integrity-funktioner';
$string['turnitinfeatures::moreinfo'] = 'För mer information om aktiverade funktioner och tillgängliga paket från Turnitin, besök <a href="http://www.turnitin.com" target="_blank">http://www.turnitin.com</a>.';
$string['turnitinfeatures::repositories'] = 'Arkiv kontrolleras mot:';
$string['turnitinfeatures::viewoptions'] = 'Turnitin Viewer-alternativ:';
$string['turnitinhideidentity'] = 'Dölj studentens identitet från Turnitin';
$string['turnitinmodenabled'] = 'Aktivera Turnitin Integrity för {$a}';
$string['turnitinpluginenabled'] = 'Aktivera Turnitin';
$string['turnitinpluginsettings'] = 'Turnitin Integrity-tilläggsinställningar';
$string['turnitinsim'] = 'Turnitin Integrity-tillägg';
$string['turnitinsim:enable'] = 'Aktivera Turnitin Integrity';
$string['turnitinsim:viewfullreport'] = 'Visa originalitetsrapport';
$string['turnitinsiminternet'] = 'Kontrollera mot internetinnehåll';
$string['turnitinsimprivate'] = 'Kontrollera mot privat innehåll';
$string['turnitinviewermatchsubinfo'] = 'Tillåt instruktörer inom din instutition att visa inlämningsinformation för interna matchningar';
$string['turnitinviewersavechanges'] = 'Spara visningsändringar';
$string['turnitinviewerviewfullsource'] = 'Tillåt instruktörer inom din institution att visa den fullständiga texten i inlämningar för interna matchningar.';
$string['viewapilog'] = 'Visa API-loggar från {$a}';
$string['viewerpermissionferpa'] = 'Följande behörigheter påverkar hur data får delas inom din institution. Dessa uppgifter är din institutions exklusiva ansvar, så när du ställer in dessa behörigheter bör du överväga om de till fullo överensstämmer med institutionens policyer angående studentregister.';
$string['viewerpermissionoptions'] = 'Visningsbehörigheter';
$string['viewlogs'] = 'Loggar';
$string['webhook_description'] = 'Webhook för {$a}';
$string['webhookincorrectsignature'] = 'Webhook-återanrop misslyckades eftersom signaturen är felaktig';
