<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'sr_cr', version '4.3'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Није могуће креирати нови налог у Активном директоријуму. Проверите да ли су испуњени сви неопходни предуслови (LDAP конекција, везни корисник са одговарајућим правима итд.)';
$string['auth_ldap_attrcreators'] = 'Списак група или конекста чијим члановима је дозвоњено да креирају атрибуте. Раздвојите вишеструке групе са  \';\'. Обично нешто попут \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_attrcreators_key'] = 'Креатори атрибута';
$string['auth_ldap_auth_user_create_key'] = 'Креирај кориснике екстерно';
$string['auth_ldap_bind_dn'] = 'Ако желите да користите везног корисника за претрагу корисника, одредите то овде. Нешто налик на \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'Јединствено препознатљиво име';
$string['auth_ldap_bind_pw'] = 'Лозинка за везног корисника';
$string['auth_ldap_bind_pw_key'] = 'Лозинка';
$string['auth_ldap_bind_settings'] = 'Подешавања везивање';
$string['auth_ldap_changepasswordurl_key'] = 'URL за промену лозинке';
$string['auth_ldap_contexts'] = 'Списак контекста у којима се налазе корисници. Раздвојите различите контексте са \';\'. На пример: \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_contexts_key'] = 'Контексти';
$string['auth_ldap_create_context'] = 'Уколико омогућите креирање корисника помоћу потврде путем е-поште, наведите контекст у којем ће корисници бити креирани. Овај контекст треба да буде различит од других корисника како би се спречили сигурносни проблеми. Не морате да додајете овај контекст ldap_context враијабли. Moodle ће тражити кориснике из овог контекста аутоматски.<br /><b>Напомена!</b> Морате да измените метод user_create() у датотеци auth/ldap/auth.php како би овај начин креирање корисника фунцкионисао.';
$string['auth_ldap_create_context_key'] = 'Контекст за нове кориснике';
$string['auth_ldap_create_error'] = 'Грешка приликом креирања новог  корисника у LDAP серверу.';
$string['auth_ldap_expiration_desc'] = 'Изаберите \'{$a->no}\' како бисте онемогућили проверу истеклих лозинки или \'{$a->ldapserver}\' ако хоћете да време истека лозинке буде прочитано директно са LDAP севера.';
$string['auth_ldap_expiration_key'] = 'Провера истека лозинке';
$string['auth_ldap_expiration_warning_desc'] = 'Колико дана пре истека лозинке ће бити издато упозорење о томе.';
$string['auth_ldap_expiration_warning_key'] = 'Упозорење о истеку лозинке';
$string['auth_ldap_expireattr_desc'] = 'Опционо: Мења LDAP атрибут који чува време истека лозинке.';
$string['auth_ldap_expireattr_key'] = 'Атрибут истека лозинке';
$string['auth_ldap_graceattr_desc'] = 'Опционо: Надјачава продужене пријаве атрибут';
$string['auth_ldap_gracelogin_key'] = 'Атрибут продужене пријаве';
$string['auth_ldap_gracelogins_desc'] = 'Омогућите LDAP подршку за пријаву на сајт након истека лозинке. Након што лозинка истекне корисник може приступати систему све док је број дозвољених пријава након истека лозинке подешен на 0. Укључивањем овог подешавања, ако је лозинка истекла, биће приказана порука о броју дозвољених пријава након истека лозинке.';
$string['auth_ldap_gracelogins_key'] = 'Продужене пријаве';
$string['auth_ldap_groupecreators'] = 'Списак група или контекста чијим члановима је дозвоњено креирање група. Раздвојите вишеструке групе са \';\'. Обично, нешто попут \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_groupecreators_key'] = 'Креатори група';
$string['auth_ldap_host_url'] = 'Наведите LDAP сервер у облику URL адресе, као нпр. ldap://ldap.myorg.com/ или ldaps://ldap.myorg.com/. Раздвојите више сервера са знаком ; како бисте могли да обезбедите аутоматско пребацивање на други сервер уколико буде проблема са активним сервером.';
$string['auth_ldap_host_url_key'] = 'URL LDAP рачунара';
$string['auth_ldap_ldap_encoding'] = 'Кодни распоред који користи LDAP сервер, највероватније utf-8. Ако је изабран LDAP v2 Активни директоријум користи свој конфигурисани кодни распоред, као што је cp1252 или cp1250.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP кодни распоред';
$string['auth_ldap_login_settings'] = 'Подешавања за пријављивање на систем';
$string['auth_ldap_memberattribute'] = 'Опционо: надјачава атрибут чланства корисника, када корисници припадају групи. Обично \'члан\'.\'';
$string['auth_ldap_memberattribute_isdn'] = 'Опционо: Редефинише руковање вредностима атрибута чланова.';
$string['auth_ldap_memberattribute_isdn_key'] = 'Атрибути члана користи dn';
$string['auth_ldap_memberattribute_key'] = 'Атрибути члана';
$string['auth_ldap_no_mbstring'] = 'Да бисте креирали кориснике у Активном директоријуму потребна Вам је mbstring екстензија.';
$string['auth_ldap_noconnect'] = 'LDAP-модул није могуће повезати са  сервером: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-модул није могуће повезати са било којим сервером: {$a}';
$string['auth_ldap_noextension'] = 'Изгледа да PHP LDAP модул није присутан. Проверите да ли је овај модул инсталиран и омогућен, ако желите да га користите као додатак за проверу идентитета.';
$string['auth_ldap_objectclass'] = 'Опционо: Одређује objectClass која се користи за именовање/претрагу корисника у ldap_user_type. Обично нема потребе да ово мењате.';
$string['auth_ldap_objectclass_key'] = 'Класе објеката';
$string['auth_ldap_opt_deref'] = 'Одређују како се управља алијасима у току претраге. Изаберите једну од следећих вредности:
"Не" (LDAP_DEREF_NEVER) или "Да" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Дереференцирај алијасе';
$string['auth_ldap_passtype'] = 'Наведите формат новр или промењене лозинке на LDAP серверу.';
$string['auth_ldap_passtype_key'] = 'Формат лозинке';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP подешавања истека лозинке';
$string['auth_ldap_preventpassindb'] = 'Изаберите Да како би спречили да се лозинке похрањују у бази података Moodlea.';
$string['auth_ldap_preventpassindb_key'] = 'Спречи кеширање лозинке';
$string['auth_ldap_rolecontext'] = '{$a->localname} контекст';
$string['auth_ldap_rolecontext_help'] = 'LDAP контекст за који се користи за <i>{$a->localname}</i> мапирање. Више група раздвојите са \';\'. Обично нешто попут "cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-with-role-groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'Претражи кориснике из подконтекста.';
$string['auth_ldap_search_sub_key'] = 'Претражи подконтекст';
$string['auth_ldap_server_settings'] = 'Подешавања LDAP сервера';
$string['auth_ldap_suspended_attribute'] = 'Опционо: Кад је на располагању овај атрибут ће се користити за активирање/суспрендовање локално креираног корисничког налога.';
$string['auth_ldap_suspended_attribute_key'] = 'Суспендован атрибут';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() не подржава изабрани тип корисника: {$a}';
$string['auth_ldap_update_userinfo'] = 'Ажурирајте информације корисника (име, презиме, адресе...) из LDAP-a у Moodle. Специфицирајте подешавања за мапирање података према сопственим потребама.';
$string['auth_ldap_user_attribute'] = 'Опционо: Замењује атрибут који се користи за име/претрагу корисника. Обично \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Атрибути корисника';
$string['auth_ldap_user_exists'] = 'LDAP корисничко име већ постоји.';
$string['auth_ldap_user_settings'] = 'Подешавања за претраживање корисника';
$string['auth_ldap_user_type'] = 'Изаберите како се корисници чувају у LDAP-у. Ово подешавање такође одређује како ће функционисати истек лозинке, број дозвољених пријава након истека лозинке и креирање корисника.';
$string['auth_ldap_user_type_key'] = 'Тип корисника';
$string['auth_ldap_usertypeundefined'] = 'config.user_type није дефинисан или функција ldap_expirationtime2unix не подржава изабрани тип!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type није дефинисан или функција ldap_unixi2expirationtime не подржава изабрани тип!';
$string['auth_ldap_version'] = 'Верзија LDAP протокола коју користи Ваш сервер';
$string['auth_ldap_version_key'] = 'Верзија';
$string['auth_ldapdescription'] = 'Овај метод служи за проверу идентитета од стране спољашњег LDAP сервера.
Ако су додељено корисничко име и лозинка исправни, Moodle креира нову инстанцу корисника у својој бази података. Овај додатак може да чита корисничке атрибуте са LDAP-a и испуни тражена поља у Moodleu. Приликом наредних пријава на систем провераваће се само корисничко име и лозинка.';
$string['auth_ldapextrafields'] = 'Ова поља нису обавезна. Можете изабрати да испуните нека Moodle корисничка поља са информацијама из <b>LDAP поља</b> која овде одредите. <br />Ако поља оставите празна, онда се ништа неће пребацити са LDAP-a, тако да ће бити коришћене подразумеване Moodle вредности.<br />У сваком случају, корисници могу да уређују ова поља након приступа систему.';
$string['auth_ldapnotinstalled'] = 'Није могуће користити LDAP проверу идентитета.PHP LDAP модул није инсталиран.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Поставите на Да за покушај једне пријаве са NTLM доменом. <strong>Напомена:</strong> да би ово радило, захтевају се додатна подешавања веб-сервера, видети <a href="https://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>';
$string['auth_ntlmsso_enabled_key'] = 'Омогући';
$string['auth_ntlmsso_ie_fastpath'] = 'Поставите на \'Да\' како бисте омогућили NTLM SSO fast path (заобилази одређене кораке ако је веб читач клијента MS Internet Explorer).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Покушати примену NTLM-а са свим веб читачима';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE брза путања?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Да, покушај примену NTLM-а са свим веб читачима';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Да, сви други веб читачи користе стандардну форму за пријаву';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Није могуће извући корисничко име из заглавља REMOTE_USER. Да ли је конфигурисани формат исправан?';
$string['auth_ntlmsso_missing_username'] = 'Морате да наведете барем %username% у формату удаљеног корисничког имена';
$string['auth_ntlmsso_remoteuserformat'] = 'Ако сте као \'Тип провере идентитета\' изабрали \'NTLM\', овде можете да одредите формат удаљеног корисничког имена. Ако ово оставите празно користиће се подразумевани  DOMAIN\\username формат. Опционо, можете да користите резервисано поље <b>%domain%</b> како бисте одредили где се појављује назив домена, и обавезно, резервисано поље <b>%username%</b> како бисте одредили где се појављује корисничко име. <br /><br />Неки од чешће коришћених формата су:
<tt>%domain%\\%username%</tt> (MS Windows default), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> и, само <tt>%username%</tt> (ако не постоји део са са доменом).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Формат удаљеног корисничког имена';
$string['auth_ntlmsso_subnet'] = 'Уколико је подешено, биће покушана SSO конекцију само са клијентима у овој подмрежи. Формат: xxx.xxx.xxx.xxx/bitmask. Више подмрежа раздвојите \',\' (зарезом).';
$string['auth_ntlmsso_subnet_key'] = 'Подмрежа';
$string['auth_ntlmsso_type'] = 'Метод провере идентитета конфигурисан на веб серверу за проверу идентитета корисника (ако сте у дилеми, изаберите NTUM)';
$string['auth_ntlmsso_type_key'] = 'Тип провере идентитета';
$string['cannotmaprole'] = 'Улога "{$a->rolename}" не може да буде мапирана зато што је њен скраћени назив "{$a->shortname}" предуг и/или садржи цртице. Како бисте омогућили да улога буде мапирана скраћени назив улоге мора бити смањен на максимално {$a->charlimit} знак(ов)а и све цртице уклоњене. <a href="{$a->link}">Уреди улогу</a>';
$string['connectingldap'] = 'Повезивање са LDAP сервером...';
$string['connectingldapsuccess'] = 'Повезивање са вашим LDAP сервером је успело';
$string['creatingtemptable'] = 'Креирање привремене табеле {$a}';
$string['diag_contextnotfound'] = 'Контекст {$a} не постоји или га везно јединствено препознатљиво име (DN) не може прочитати.';
$string['diag_emptycontext'] = 'Пронађен је празан контекст.';
$string['diag_genericerror'] = 'LDAP грешка {$a->code} приликом читања {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Група {$a->group} за улогу {$a->localname} не постоји или га везно јединствено препознатљиво име (DN) не може прочитати.';
$string['diag_toooldversion'] = 'Мало је вероватно да модерни LDAP сервер користи LDAPv2 протокол. Погрешна подешавања могу да оштете вредности у корисничким пољима. Проверите са својим LDAP администратором.';
$string['didntfindexpiretime'] = 'Функција password_expire() није пронашла време истека';
$string['didntgetusersfromldap'] = 'Није добијен ниједан корисник са LDAP-а -- грешка? -- излаз';
$string['gotcountrecordsfromldap'] = 'Број записа добијен са LDAP-а: {$}';
$string['invalidusererrors'] = 'Упозорење! Број корисничких налога чије је креирање прескочено: {$а} .';
$string['invaliduserexception'] = 'Грешка: Није могуће креирати нови кориснички налог. Детаљне информације и разлог:
{$a}
Овај корисник се прескаче.';
$string['ldapnotconfigured'] = 'URL адреса LDAP сервера тренутно није конфигурсана';
$string['morethanoneuser'] = 'Пронађено је више од једног корисничког записа на LDAP-у. Користи се само први.';
$string['needbcmath'] = 'Потребна вам је BCMath екстензија како бисте користили проверу истека лозинке помоћу активног директоријума (Active Directory).';
$string['needmbstring'] = 'За промену лозинке у aктивном директоријуму, потребна Вам је mbstring екстензија';
$string['nodnforusername'] = 'Грешка у user_update_password(). Нема DN за: {$a->username}';
$string['noemail'] = 'Покушај да вам се пошаље е-порука није успео!';
$string['notcalledfromserver'] = 'Не би требало да буде позивано са веб сервера!';
$string['noupdatestobedone'] = 'Нема ажурирања које треба обавити';
$string['nouserentriestoremove'] = 'Нема корисничких налога које треба уклонити';
$string['nouserentriestorevive'] = 'Нема корисничких налога које треба поново активирати';
$string['nouserstobeadded'] = 'Нема корисника за додавање';
$string['ntlmsso_attempting'] = 'Покушава Single Sign On преко NTLM...';
$string['ntlmsso_failed'] = 'Аутоматско пријављивање није успело, покушајте са обичном страницом за пријављивљње...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO је онемогућен.';
$string['ntlmsso_unknowntype'] = 'Непознати ntlmsso тип!';
$string['pagedresultsnotsupp'] = 'LDAP странични приказ резултата није подржан (вашој верзији PHP-а недостаје подршка или сте подесили Moodle да користи верзију 2 LDAP протокола или Moodle не може да се повеже са LDAP сервером како би видео да ли је странични приказ доступан).';
$string['pagesize'] = 'Проверите да ли је ова вредност мања од ограничења вашег LDAP сервера за број резултата претраге по једној страници (максималан број резултата који може бити враћен у једном упиту)';
$string['pagesize_key'] = 'Величина странице';
$string['pluginname'] = 'LDAP сервер';
$string['pluginnotenabled'] = 'Додатак није омогућен!';
$string['privacy:metadata'] = 'Додатак за проверу идентитета LDAP сервер не чува никакве личне податке.';
$string['renamingnotallowed'] = 'Промена имена корисника није дозвољена на LDAP-у';
$string['rootdseerror'] = 'Грешка при слању упита rootDSE за активни директоријум';
$string['start_tls'] = 'Користи регуларни LDAP сервис (порт 389) са TLS шифровањем';
$string['start_tls_key'] = 'Користи TLS';
$string['syncroles'] = 'Синхронизaција системских улога из LDAP-а';
$string['synctask'] = 'Синхронизација LDAP корисника';
$string['systemrolemapping'] = 'Мапирање системских улога';
$string['updatepasserror'] = 'Грешка у user_update_password(). Кôд грешке: {$a->errno}; Текст грешке: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Грешка у user_update_password() приликом читања времена истека лозинке. Кôд грешке: {$a->errno}; Текст грешке: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Грешка у user_update_password() приликом промене истека лозинка истиче и/или продужене пријаве. Кôд грешке: {$a->errno}; Текст грешке: {$a->errstring}';
$string['updateremfail'] = 'Грешка приликон ажурирања LDAP записа. Кôд грешке: {$a->errno}; Текст грешке: {$a->errstring}<br/>Кључ ({$a->key}) - стара moodle вредност: \'{$a->ouvalue}\' нова вредност: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Није успело ажурирање LDAP-а са двосмисленим пољем {$a->key}; стара moodle вредност: \'{$a->ouvalue}\', нова вредност: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Није било могуће пронаћи корисника прилоком ажурирања спољашњег извора. Следе детаљније информације: search base: \'{$a->userdn}\'; search filter: \'(objectClass=*)\'; search attributes: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() не подржава изабрани тип корисника: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() не подржава изабрани тип корисника: {$a}';
$string['useracctctrlerror'] = 'Грешка при добијању userAccountControl за {$a}';
$string['userentriestoadd'] = 'Кориснички налози који ће бити додати: {$a}';
$string['userentriestoremove'] = 'Кориснички налози који ће бити уклоњени: {$a}';
$string['userentriestorevive'] = 'Кориснички налози који ће бити поново активирани: {$a}';
$string['userentriestoupdate'] = 'Кориснички налози који ће бити ажурирани: {$a}';
$string['usernotfound'] = 'Корисник није пронађен у LDAP-у.';
