<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'icontent', language 'pt', version '4.3'.
 *
 * @package     icontent
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['addafter'] = 'Adicionar nova página';
$string['addnewpage'] = 'Adicionar nova página';
$string['addquestion'] = 'Adicionar nova pergunta';
$string['advance'] = 'Seguinte';
$string['alldoubts'] = 'Todas as perguntas';
$string['answers'] = 'Respostas';
$string['answersevaluatedinfo'] = '<i class="fa fa-info-circle"></i> As respostas que já foram avaliadas não aparecem nesta lista. Para reavaliar, {$a}.';
$string['answerthequestions'] = 'Responder às perguntas';
$string['attempt'] = 'Tentativa';
$string['attemptsallowed'] = 'Tentativas permitidas';
$string['attemptsallowedhelp'] = 'Número de tentativas permitidas';
$string['attemptsallowedhelp_help'] = 'Escolha uma opção para definir o número de tentativas permitidas para responder.';
$string['bgcolor'] = 'Cor de fundo';
$string['bgcolorhelp'] = 'Cor de fundo';
$string['bgcolorhelp_help'] = 'Cor predefinida a usar como cor de fundo em todas as páginas.';
$string['bgcolorpagehelp'] = 'Cor de fundo';
$string['bgcolorpagehelp_help'] = 'Cor predefinida a usar como cor de fundo na página atual.';
$string['bgimage'] = 'Imagem de fundo';
$string['bgimagehelp'] = 'Imagem de fundo';
$string['bgimagehelp_help'] = 'Imagem predefinida que será usada como imagem de fundo em todas as páginas.';
$string['bgimagepagehelp'] = 'Imagem de fundo';
$string['bgimagepagehelp_help'] = 'Imagem predefinida que será usada como imagem de fundo na página atual.';
$string['bordercolor'] = 'Cor do contorno';
$string['bordercolorhelp'] = 'Cor da linha de contorno';
$string['bordercolorhelp_help'] = 'Clique para escolher a cor predefinida da linha de contorno de cada página.';
$string['bordercolorpagehelp'] = 'Cor da linha de contorno';
$string['bordercolorpagehelp_help'] = 'Clique para escolher a cor predefinida da linha de contorno da página atual.';
$string['borderwidth'] = 'Espessura';
$string['borderwidthhelp'] = 'Espessura';
$string['borderwidthhelp_help'] = 'Escolha a espessura predefinida dos contornos de cada página.';
$string['borderwidthpagehelp'] = 'Espessura';
$string['borderwidthpagehelp_help'] = 'Escolha a espessura predefinida dos contornos da página atual.';
$string['calculated'] = 'Calculado';
$string['calculatedmulti'] = 'Vários cálculos';
$string['calculatedsimple'] = 'Cálculos simples';
$string['choiceone'] = 'Escolha a opção correta:';
$string['choiceoneoption'] = 'Escolha uma opção:';
$string['choiceoneormore'] = 'Escolha {$a} opções:';
$string['clickhere'] = 'Clique aqui';
$string['collumns2'] = 'Até duas colunas';
$string['collumns3'] = 'Até três colunas';
$string['collumns4'] = 'Até quatro colunas';
$string['collumns5'] = 'Até cinco colunas';
$string['comments'] = 'Comentários';
$string['confdeleteattempt'] = 'Remover tentativas da página {$a->pagenum}';
$string['confpagedelete'] = 'Tem a certeza de que pretende apagar esta página, assim como todos os ficheiros e registos relacionados com a página?';
$string['confpagenotedelete'] = '<i class="fa fa-exclamation-triangle"></i> Tem a certeza de que pretende apagar esta anotação e todas as respostas? <span class="label label-warning">{$a} resposta(s)</span>';
$string['copyright'] = 'Direitos de autor';
$string['copyright_help'] = 'Espaço reservado para adicionar os créditos relativos aos direitos de autor.';
$string['coverpage'] = 'Página de rosto';
$string['coverpage_help'] = 'Permite criar uma página de rosto para o conteúdo. Se selecionar esta opção, adicione uma breve descrição no campo de conteúdo. Esta descrição aparece na capa. Se a descrição tiver mais de 500 caracteres, será adicionado um botão [Ler mais].';
$string['createdby'] = 'Criado por';
$string['description'] = 'Descrição';
$string['displayed'] = 'Página visível';
$string['displayedhelp'] = 'Visível';
$string['displayedhelp_help'] = 'Se ativar esta opção, a página estará visível.';
$string['doubt'] = 'Pergunta <span id="messagedoubt">{$a}</span>';
$string['doubtandnotes'] = 'Perguntas e anotações';
$string['doubts'] = 'Perguntas';
$string['doubtstotutor'] = 'Perguntas enviadas ao tutor';
$string['doubttutor'] = 'Perguntar apenas ao tutor';
$string['edit'] = 'Editar';
$string['editcurrentpage'] = 'Editar a página atual';
$string['editingpage'] = 'A editar página';
$string['effects'] = 'Efeitos';
$string['emptyquestionbank'] = '<i class="fa fa-exclamation-triangle"></i> A base de dados de perguntas está vazia.';
$string['erroridnotfound'] = '<i class="fa fa-exclamation-triangle"></i> Tem de especificar o parâmetro {$a}';
$string['essay'] = 'Ensaio';
$string['evaluate'] = 'Avaliar';
$string['evaluative'] = 'Avaliar item';
$string['evaluative_help'] = 'Se ativar esta opção, este recurso torna-se um item de avaliação.';
$string['eventnotecreated'] = 'Anotação adicionada';
$string['eventnotedeleted'] = 'Anotação apagada';
$string['eventnotelikecreated'] = 'Anotação útil criada';
$string['eventnotelikedeleted'] = 'Anotação útil apagada';
$string['eventnotereplied'] = 'Anotação respondida';
$string['eventnoteupdated'] = 'Anotação atualizada';
$string['eventpagecreated'] = 'Página criada';
$string['eventpagedeleted'] = 'Página apagada';
$string['eventpageupdated'] = 'Página atualizada';
$string['eventpageviewed'] = 'Página visualizada';
$string['eventquestionattemptcreated'] = 'Criada tentativa de resposta à pergunta';
$string['eventquestionattemptdeleted'] = 'Eliminada tentativa de resposta à pergunta';
$string['eventquestionpageviewed'] = 'Página visualizada';
$string['eventquestiontoevaluatecreated'] = 'Avaliação manual de perguntas';
$string['expandnotesarea'] = 'Expandir área de anotações';
$string['expandnotesarea_help'] = 'Marque para mostrar a área expandida das anotações.';
$string['expandquestionsarea'] = 'Expandir área das perguntas';
$string['expandquestionsarea_help'] = 'Marque para mostrar a área expandida das perguntas.';
$string['featured'] = 'Destacar';
$string['fluid'] = 'Fluir';
$string['goback'] = 'Última';
$string['grade'] = 'Avaliação';
$string['gradingscale'] = 'Notas (0 - {$a})';
$string['highcontrast'] = 'Alto contraste';
$string['highlighted'] = 'Destacado';
$string['highlights'] = 'Destaques';
$string['icontent'] = 'Conteúdo';
$string['icontent:addinstance'] = 'Adicionar nova página de conteúdos';
$string['icontent:answerquestionstryagain'] = 'Permitir respostas ilimitadas às perguntas das páginas';
$string['icontent:checkboxdoubttutornotes'] = 'Pergunta para o tutor';
$string['icontent:checkboxfeaturednotes'] = 'Destacar anotação';
$string['icontent:checkboxprivatenotes'] = 'Definir a anotação como privada';
$string['icontent:edit'] = 'Editar páginas de conteúdos';
$string['icontent:editnotes'] = 'Editar anotações';
$string['icontent:grade'] = 'Ver relatório da avaliação';
$string['icontent:likenotes'] = 'Anotações úteis';
$string['icontent:manage'] = 'Gerir conteúdo interativo';
$string['icontent:newquestion'] = 'Adicionar nova pergunta';
$string['icontent:removenotes'] = 'Eliminar anotações';
$string['icontent:replynotes'] = 'Responder';
$string['icontent:view'] = 'Visualizar o conteúdo interativo';
$string['icontent:viewnotes'] = 'Ver anotações';
$string['icontentfieldset'] = 'Exemplo de campo personalizado';
$string['icontentmenu'] = 'Menu das Páginas de conteúdos';
$string['icontentname'] = 'Nome das Páginas de conteúdos';
$string['icontentname_help'] = 'Ferramenta de ajuda associada ao nome do campo. É suportada a sintaxe Markdown.';
$string['infomaxquestionperpage'] = '<i class="fa fa-info-circle"></i> Adicionar até 3 perguntas por página.';
$string['labelprogressbar'] = '{$a}% completo';
$string['lastmodifiedby'] = 'Última modificação por';
$string['layout'] = 'Esquema de página';
$string['layouthelp'] = 'Esquema de página';
$string['layouthelp_help'] = 'Escolha o esquema de página';
$string['like'] = 'Gosto ({$a})';
$string['likes'] = 'Gosto';
$string['listdoubts'] = 'Lista de perguntas';
$string['manualgrading'] = 'Avaliação manual';
$string['manualreview'] = 'Revisão manual';
$string['manualreviewofparticipant'] = 'Avaliação manual da tentativa do participante {$a}';
$string['match'] = 'Corresponde';
$string['maximumdigits'] = 'Máximo de {$a} dígitos';
$string['maxnotesperpages'] = 'Número máximo de anotações por página';
$string['maxnotesperpageshelp'] = 'Número máximo de anotações por página';
$string['maxnotesperpageshelp_help'] = 'Digite o número máximo permitido de anotações por página (apenas números inteiros).';
$string['maxpages'] = 'Número máximo de páginas';
$string['maxpageshelp'] = 'Número máximo de páginas';
$string['maxpageshelp_help'] = 'Digite o número máximo de páginas permitido. Digitar apenas números inteiros. Importante: em termos de conteúdo de educação à distância, deve utilizar um máximo de 35 páginas.';
$string['modulename'] = 'Páginas de conteúdos';
$string['modulename_help'] = 'O módulo do Moodle Páginas de conteúdos foi projetado para que, a partir dele, criadores de conteúdos, tutores, professores e técnicos possam adicionar conteúdos em disciplinas, seguindo padrões de utilização e acessibilidade.
Esta ferramenta será responsável pela sinalização da boa prática de adição de texto, imagens, multimédia, entre outros. O conteúdo será distribuído em páginas, de modo que a monitorização do conteúdo não se torne algo desgastante e cansativo. O módulo também tem um marcador, de modo que o participante possa ser localizado, com base no seu último acesso e, além disto, permite a inserção de anotações públicas ou privadas, em que o participante pode fornecer feedback sobre o conteúdo estudado na página responder a comentários de outros participantes.
O módulo também permite inserir perguntas sobre o conteúdo abordado, proporcionando uma melhor interação entre o participante e a plataforma virtual de aprendizagem, e o recurso pode tornar-se um item de avaliação ou emitir avaliações fracionárias sobre os itens disponíveis na disciplina, tal como definido no plano de ação. A extensão descrita é totalmente responsiva e pode ser acedida por qualquer dispositivo.';
$string['modulenameplural'] = 'Páginas de conteúdos';
$string['msgaddquestionpage'] = 'Perguntas adicionadas com sucesso!';
$string['msgconfirmdeleteattempt'] = '<i class="fa fa-exclamation-triangle"></i> <span class="label label-warning"> {$a->totalanswers} respostas </span>encontradas na tentativa. Tem a certeza de que pretende remover a tentativa desta página?';
$string['msgstatusdisplay'] = 'Não é possível adicionar ou remover perguntas porque já foram registadas tentativas.';
$string['msgsucess'] = 'Dados guardados com sucesso!';
$string['msgsucessevaluate'] = 'Avaliações concluídas com sucesso: {$a}';
$string['msgsucessexclusion'] = 'Registos eliminados com sucesso!';
$string['multianswer'] = 'Resposta múltipla';
$string['multichoice'] = 'Escolha múltipla';
$string['mylistcomments'] = 'Minha lista de comentários';
$string['next'] = 'Seguinte';
$string['nextpage'] = 'Página seguinte';
$string['noeffect'] = 'Nenhum';
$string['nonotes'] = 'Página sem anotações';
$string['norecordsfound'] = '<i class="fa fa-info-circle"></i> Nenhum registo encontrado.';
$string['note'] = 'Anotações <span id="messagenotes">{$a}</span>';
$string['notedon'] = 'fez anotação em';
$string['numerical'] = 'Numérica';
$string['page'] = '<span>Página <em>{$a}</em></span>';
$string['pagenotfound'] = '<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Nenhuma página foi encontrada para esta instância de Páginas de conteúdos.';
$string['pagetitle'] = 'Título da página';
$string['partialresult'] = 'Resultado parcial';
$string['pluginadministration'] = 'Administração de Páginas de conteúdos';
$string['pluginname'] = 'Páginas de conteúdos';
$string['preview'] = 'Pré-visualização';
$string['previous'] = 'Anterior';
$string['previouspage'] = 'Página anterior';
$string['private'] = 'Privado';
$string['privates'] = 'Privado';
$string['progressbar'] = 'Barra de progressão';
$string['progressbar_help'] = 'Se ativar esta opção, é mostrada uma barra na parte inferior das páginas que indica a percentagem aproximada de conclusão.';
$string['questions'] = 'Perguntas';
$string['random'] = 'Aleatório';
$string['reassess'] = 'Reavaliar';
$string['remove'] = 'Apagar';
$string['removenote'] = 'Apagar anotação';
$string['removenotes'] = 'Apagar anotações';
$string['reply'] = 'Responder';
$string['respond'] = 'Responder';
$string['result'] = 'Resultado';
$string['resultlastattempt'] = 'Resultado da última tentativa';
$string['results'] = 'Resultados';
$string['rightanswers'] = 'Respostas corretas';
$string['save'] = 'Guardar';
$string['send'] = 'Enviar';
$string['sendallandfinish'] = 'Enviar tudo e terminar';
$string['sendanswers'] = 'Enviar respostas';
$string['sendattemp'] = 'Submeter tentativa';
$string['shortanswer'] = 'Resposta curta';
$string['showbgimage'] = 'Mostrar imagem de fundo';
$string['showbgimage_help'] = 'Selecione para mostrar imagem de fundo';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar mais';
$string['shownotesarea'] = 'Mostrar a área de anotações';
$string['shownotesarea_help'] = 'Selecione "Sim" para mostrar a área de anotações.';
$string['showtitle'] = 'Mostrar o título da página.';
$string['showtitle_help'] = 'Mostrar/ocultar o título da página.';
$string['state'] = 'Estado';
$string['statusview'] = 'Ver estado';
$string['strattempttitle'] = 'Tentativa realizada na página {$a->pagenum}, {$a->title}';
$string['strmanualgrading'] = 'Alunos com perguntas que precisam ser avaliadas manualmente';
$string['strmaxgrade'] = 'de 1,00';
$string['stropenanswer'] = '<span class="label label-info">{$a} resposta(s) a aguardar avaliação.</span>';
$string['strstate'] = 'Terminadas <br /> Submetidas {$a}.';
$string['strtoevaluate'] = '{$a->fraction} de {$a->maxfraction} ({$a->percentage}%). {$a->openanswer}';
$string['summary'] = 'Resumo';
$string['summaryattempts'] = 'Resumo das tentativas';
$string['toevaluate'] = 'Para avaliar';
$string['toreassess'] = ' para reavaliar';
$string['totalanswers'] = 'Total de respostas';
$string['transitioneffect'] = 'Transições';
$string['transitioneffecthelp'] = 'Efeitos de transição';
$string['transitioneffecthelp_help'] = 'Selecione o tipo de transição para a página atual.';
$string['truefalse'] = 'verdadeiro/falso';
$string['tryagain'] = 'Tentar novamente';
$string['type'] = 'Tipo';
$string['unlike'] = 'Não gosto ({$a})';
$string['usemaxgrade'] = 'Pontuação máxima';
$string['usemaxgrade_help'] = 'Se o recurso é um item de avaliação, pode informar qual a nota mais alta possível nesta atividade.';
$string['writedoubt'] = 'Escrever pergunta';
$string['writenotes'] = 'Adicionar anotação';
