<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'hu', version '4.3'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Művelet';
$string['actions'] = 'Műveletek';
$string['addappointment'] = 'Másik tanuló hozzáadása';
$string['addcommands'] = 'Idősáv hozzáadása';
$string['addondays'] = 'Találkozó erre a napra';
$string['addsession'] = 'Ismétlődő idősávok hozzáadása';
$string['addsingleslot'] = 'Egy idősáv hozzáadása';
$string['addslot'] = 'Ön létre tud hozni bármikor új találkozót.';
$string['addstudenttogroup'] = 'A tanuló hozzáadása a találkozó csoportba';
$string['allappointments'] = 'Minden időpont';
$string['allononepage'] = 'Minden időpont egy oldalon';
$string['allowgroup'] = 'Ekszkluzív idősáv - klikk a változtatáshoz';
$string['alreadyappointed'] = 'Nem lehet találkozót létrehozni. Az idősáv teljesen lefedve.';
$string['appointagroup_help'] = 'Válassza ki, hogy csak magának, vagy egy egész csoportnak szeretne időpontot foglalni.';
$string['appointfor'] = 'Foglaljon időpontot';
$string['appointforgroup'] = 'Csoportos találkozó: {$a}';
$string['appointingstudent'] = 'Találkozó ebbe az idősávba';
$string['appointingstudentinnew'] = 'Találkozó új idősávba';
$string['appointment'] = 'Találkozó';
$string['appointmentmode'] = 'Találkozó mód beállítása';
$string['appointmentmode_help'] = '<p>Itt kiválaszthat néhány változatot a találkozók fogadásának módjáról. </p> <p><ul> <li><strong>"<emph>n</emph> találkozó ebben az ütemezőben":</strong> A tanuló ebben a tevékenységben csak meghatározott számú időpontot foglalhat. Még ha a tanár "látott"-ként jelöli is meg őket, nem foglalhatnak le további találkozókat. A tanuló foglalási képességének visszaállításának egyetlen módja a régi "látott" rekordok törlése.</li> <li><strong>"Egyszerre <emph>n</emph> találkozó":</strong> A hallgató meghatározott számú időpontot foglalhat. Miután a megbeszélés véget ért, és a tanár "látott"-ként jelölte meg a tanulót, a tanuló további időpontokat foglalhat. A tanuló azonban bármikor <emph>n</emph> "nyitott" (nem látható) helyre korlátozódik. </li> </ul> </p>';
$string['appointmentno'] = 'Találkozó {$a}';
$string['appointmentnote'] = 'Jegyzetek a találkozóra (tanuló számára látható)';
$string['appointments'] = 'Találkozók';
$string['appointmentsgrouped'] = 'Időpontok szerint csoportosított találkozók';
$string['appointmentsummary'] = 'Találkozó {$a->startdate}, {$a->starttime} - {$a->endtime} ({$a->teacher})';
$string['appointsolo'] = 'csak én';
$string['appointsomeone'] = 'Új találkozó';
$string['areaappointmentnote'] = 'Állományok a találkozó jegyzeteiben';
$string['areaslotnote'] = 'Állományok az idősáv jegyzeteiben';
$string['areateachernote'] = 'Állományok a bizalmas jegyzetekben';
$string['attendable'] = 'Résztvevő';
$string['attendablelbl'] = 'Össz időzíthető tanuló';
$string['attended'] = 'Megjelent';
$string['attendedlbl'] = 'Megjelent tanulók száma';
$string['attendedslots'] = 'Elhasznált idősávok';
$string['availableslots'] = 'Elérhető idősávok';
$string['availableslotsall'] = 'Minden idősáv';
$string['availableslotsnotowned'] = 'Nem saját';
$string['availableslotsowned'] = 'Saját';
$string['bookaslot'] = 'Idősáv foglalása';
$string['bookingdetails'] = 'Foglalási részletek';
$string['bookingformoptions'] = 'Foglalási űrlap és a hallgató által megadott adatok';
$string['bookinginstructions'] = 'Foglalási utasítások';
$string['bookinginstructions_help'] = 'Ez a szöveg jelenik meg a hallgatók számára, mielőtt foglalnak. Például utasíthatja a tanulókat, hogyan töltsék ki az opcionális üzenetmezőt, vagy milyen fájlokat töltsenek fel.';
$string['bookslot'] = 'Időrés foglalása';
$string['bookwithteacher'] = 'Felelős';
$string['bookwithteacher_help'] = 'Felelős személy kiválasztása a találkozóra.';
$string['break'] = 'Idősávok közötti szünet';
$string['breaknotnegative'] = 'A szünet hossza nem lehet negatív';
$string['canbook1appointment'] = 'Ebben az idősávban még egy időpont foglalható.';
$string['canbooknappointments'] = 'Ebben az idősávban még {$a} időpont foglalható.';
$string['canbooknofurtherappointments'] = 'Nincs lehetőség további időpontot foglalni.';
$string['canbooksingleappointment'] = 'Ebben az idősávban csak egy időpont foglalható.';
$string['canbookunlimitedappointments'] = 'Ebben az idősávban bármennyi időpont foglalható.';
$string['cancelbooking'] = 'Foglalás lemondása';
$string['chooseexisting'] = 'Meglévő kiválasztása';
$string['choosingslotstart'] = 'Idősáv kezdete';
$string['choosingslotstart_help'] = 'Módosítsa (vagy válassza ki) a találkozó kezdési időpontját. Ha ez a találkozó más időpontokkal ütközik, a rendszer megkérdezi, hogy ez az időpont helyettesíti-e az összes ütköző találkozót. Vegye figyelembe, hogy az új idősáv paraméterek felülírnak minden korábbi beállítást.';
$string['comments'] = 'Megjegyzések';
$string['complete'] = 'Foglalt';
$string['confirmbooking'] = 'Foglalás megerősítése';
$string['confirmdelete-all'] = 'Ezzel törli az <b>összes</b> idősávot az ütemezőben. A törlés nem vonható vissza. Mindenképp folytatni szeretné?';
$string['confirmdelete-mine'] = 'Ezzel törli az összes idősávot az ütemezőben. A törlés nem vonható vissza. Mindenképp folytatni szeretné?';
$string['confirmdelete-myunused'] = 'Ezzel törli az összes fel nem használt idősávodat ebben az ütemezőben. A törlés nem vonható vissza. Mindenképp folytatni szeretné?';
$string['confirmdelete-one'] = 'Idősáv törlése?';
$string['confirmdelete-selected'] = 'Ezzel törli a kijelölt idősávokat. A törlés nem vonható vissza. Mindenképp folytatni szeretné?';
$string['confirmdelete-unused'] = 'Ezzel törli az összes fel nem használt idősávot ebben az ütemezőben. A törlés nem vonható vissza. Mindenképp folytatni szeretné?';
$string['confirmrevoke'] = 'Törli az összes találkozót az aktuális idősávból?';
$string['conflictingslots'] = '{$a}-kor az idősáv nem hozható létre ütköző idősávok miatt:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} perc) ebben az idősávban';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} perc) kurzus: {$a->courseshortname},  ütemező: {$a->schedulername}';
$string['contentformat'] = 'Formátum';
$string['contentformat_help'] = '<p>Három alapvető lehetőség van az exportálási formátumhoz, amelyek különböznek a több találkozót tartalmazó időszakok kezelési módjától.</p><p><ul><li><strong>Idősávonként egy sor</strong>: A kimeneti fájl idősávonként egy sort fog tartalmazni. Ha egy időköz több találkozót is tartalmaz, akkor a hallgató neve stb. helyett egy "(több)" jelölő jelenik meg.</li><li><strong>Találkozónként egy sor</strong>: A kimeneti fájl minden találkozóhoz egy sort fog tartalmazni. Ha egy időköz több találkozót is tartalmaz, akkor többször megjelenik a listában (adatai ismétlődnek).</li><li><strong>Időpontok szerint csoportosított találkozók</strong>: Egy időponthoz tartozó összes találkozó egy csoportba kerül, és egy fejléc előzi meg, amely a kérdéses időszakot jelzi. Előfordulhat, hogy ez nem működik jól a CSV kimeneti fájlformátummal, mivel az oszlopok száma nem állandó.</li></ul></p><p>Az "Előnézet" gombbal megnézheti ezeknek a lehetőségeknek a hatását.</p>';
$string['copytomyself'] = 'Másolat küldése saját magamnak';
$string['course'] = 'Kurzus';
$string['createexport'] = 'Exportfájl létrehozása';
$string['csvfieldseparator'] = 'Mezőelválasztó a CSV-hez';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'A találkozók összesített időtartama';
$string['datatoinclude'] = 'Csatolandó adatok';
$string['datatoinclude_help'] = 'Válassza ki azokat a mezőket, amelyeknek szerepelniük kell az exportálásban. Ezek mindegyike megjelenik a kimeneti fájl egy oszlopában.';
$string['date'] = 'Dátum';
$string['datelist'] = 'Áttekintés';
$string['defaultslotduration'] = 'Alapértelmezett idősáv-hossz';
$string['defaultslotduration_help'] = 'Alapértelmezett hossza az idősávokank percekben';
$string['deleteallslots'] = 'Minden idősáv törlése';
$string['deleteallunusedslots'] = 'Felhasználatlan idősávok törlése';
$string['deletecommands'] = 'Idősávok törlése';
$string['deletedconflictingslots'] = '{$a}-kor az ütköző idősávok törrésre kerültek:';
$string['deletemyslots'] = 'Saját idősávok törlése';
$string['deleteonsave'] = 'Találkozó törlése (az űrlap mentésekor)';
$string['deleteselection'] = 'Kiválasztott idősávok törlése';
$string['deletetheseslots'] = 'Törölje ezeket az idősávokat';
$string['deleteunusedslots'] = 'Felhasználatlan saját idősávok törlése';
$string['department'] = 'Honnan?';
$string['disengage'] = 'Találkozóim lemondása';
$string['displayfrom'] = 'Az idősáv mutatásának kezdete';
$string['distributetoslot'] = 'Kiosztás az egész csoportnak';
$string['divide'] = 'Felosztja idősávokra?';
$string['duration'] = 'Időtartam';
$string['durationrange'] = 'Az idősáv időtartamának {$a->min} és {$a->max} perc között kell lennie.';
$string['editbooking'] = 'Foglalás módosítása';
$string['email_applied_html'] = '<p>Időpont egyeztetés megtörtént: {$a->date}, {$a->time},<br/> Tanuló: <a href="{$a->attendee_url}">{$a->attendee}</a> a következő kurzusban: <p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p> <p>Ütemező: "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" Oldal: <a href="{$a->site_url}">{$a->site}</a></p>';
$string['email_applied_plain'] = 'Időpont egyeztetés megtörtént: {$a->date}, {$a->time}, Tanuló {$a->attendee} a következő kurzusban: {$a->course_short}: {$a->course} Ütemező: "{$a->module}" Oldal: {$a->site}';
$string['email_applied_subject'] = '{$a->course_short}: Új találkozó';
$string['email_cancelled_html'] = '<p><strong><span class="error">Találkozó törölve vagy áthelyezve:</span> {$a->date}</strong>, <strong>{$a->time}</strong>,<br/> Tanuló: <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> Kurzus: </p> <p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p> <p>Ütemező: "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" Oldal: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>';
$string['email_cancelled_plain'] = 'Találkozó törölve vagy áthelyezve {$a->date}, {$a->time}, Tanuló: {$a->attendee} Kurzus: {$a->course_short} : {$a->course} Ütemező: "{$a->module}" Oldal: {$a->site}';
$string['email_cancelled_subject'] = '{$a->course_short}: Találkozót a tanuló törölte vagy áthelyezte';
$string['email_invite_html'] = '<p>Kérem egyeztessen időpontot az alábbi linkre kattintva:</p><p><a href="{$a->scheduler_url}">{$a->scheduler_url}</a></p>';
$string['email_invite_subject'] = 'Meghívó: {$a->module}';
$string['email_invitereminder_html'] = '<p>Emlékeztetjük, hogy még nem egyeztetett időpontot. Kérjük válasszon mihamarabb idősávot az alábbi linkre kattintva:</p><p><a href="{$a->scheduler_url}">{$a->scheduler_url}</a></p>';
$string['email_invitereminder_subject'] = 'Emlékeztető: {$a->module}';
$string['email_reminder_html'] = '<p>Közelgő találkozója van <strong>{$a->date}</strong>, <strong>{$a->time}</strong> - <strong>{$a->endtime}</strong><br/> Kísérő: <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p> <p>Helyszín: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Közeledik a megbeszélés időpontja {$a->date}, {$a->time} - {$a->endtime} Résztvevő: {$a->attendant}. Helyszín: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Időpont emlékeztető';
$string['email_teachercancelled_html'] = '<p>Találkozó: <strong>{$a->date}</strong>, <strong>{$a->time} </strong>,<br/> with the {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> Kurzus:</p> <p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p> <p>Ütemező: "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" Oldal: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p> <p><strong><span class="error">lemondva</span></strong>. Kérem, foglaljon le új idősávot.</p>';
$string['email_teachercancelled_plain'] = 'Találkozó: {$a->date} at {$a->time}, {$a->staffrole} {$a->attendant} Kurzus: {$a->course_short}: {$a->course} Ütemező: "{$a->module}" Oldal: {$a->site} lemondva. Kérem, foglaljon le új idősávot.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: A tanár lemondta a találkozót';
$string['emailreminder'] = 'Emlékeztető e-mailben';
$string['emailreminderondate'] = 'Emlékeztető e-mailben ekkor';
$string['end'] = 'Vége';
$string['enddate'] = 'Eddig ismételje az idősávokat';
$string['event_appointmentlistviewed'] = 'Az ütemező találkozóinak listája megtekintve';
$string['event_bookingadded'] = 'Ütemező foglalás hozzáadva';
$string['event_bookingformviewed'] = 'Ütemező foglalási űrlap megtekintve';
$string['event_bookingremoved'] = 'Ütemező foglalás eltávolítva';
$string['event_slotadded'] = 'Ütemező idősáv hozzáadva';
$string['event_slotdeleted'] = 'Ütemező idősáv törölve';
$string['everyone'] = 'Mindenki';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Kizárólagos';
$string['exclusivity'] = 'Kizárólagosság';
$string['exclusivity_help'] = '<p>Korlátot állíthat be az adott helyre jelentkező hallgatók számára. </p> <p>Ha 1-es korlátot állít be (alapértelmezett), az azt jelenti, hogy a hely kizárólag egyetlen tanulóra vonatkozik.</p> <p>Ha például 3-as korlátot állít be, az azt jelenti, hogy legfeljebb három diák vehet részt foglaljon a nyílásba.</p> <p>Ha le van tiltva, tetszőleges számú diák lefoglalhatja a helyet; soha nem lesz "teli".</p>';
$string['exclusivityoverload'] = 'Az idősávra {$a} kinevezett diák van, ami több, mint amennyit ez a beállítás megenged.';
$string['exclusivitypositive'] = 'A tanulók számának 1 főnek vagy többnek kell lennie.';
$string['explaingeneralconfig'] = 'Ezeket a beállításokat csak a hely szintjén lehet beállítani, és a Moodle telepítés összes ütemezőjére vonatkoznak.';
$string['export'] = 'Export';
$string['exporthdr'] = 'Időpontok és találkozók exportálása';
$string['exporttimerange'] = 'Időtartomány';
$string['exporttimerangeall'] = 'Jövőbeni és elmúlt idősávok';
$string['exporttimerangefuture'] = 'Csak a jövőbeni idősávok';
$string['exporttimerangepast'] = 'Csak az elmúlt idősávok';
$string['field-appointmentnote'] = 'Megjegyzés (tanulónak)';
$string['field-attended'] = 'Résztvevő';
$string['field-date'] = 'Dátum';
$string['field-endtime'] = 'Idő vége';
$string['field-filecount'] = 'Feltöltött állományok száma';
$string['field-grade'] = 'Osztályzat';
$string['field-groupsmulti'] = 'Csoportok (több oszlop)';
$string['field-groupssingle'] = 'Csoportok';
$string['field-groupssingle-label'] = 'Csoportok (egy oszlop)';
$string['field-location'] = 'Helyszín';
$string['field-maxstudents'] = 'Max. tanulók';
$string['field-slotnotes'] = 'Idősáv jegyzetek';
$string['field-starttime'] = 'Kedzdete';
$string['field-studentemail'] = 'Tanuló e-mail címe';
$string['field-studentfirstname'] = 'Tanuló keresztneve';
$string['field-studentfullname'] = 'Tanuló teljes neve';
$string['field-studentidnumber'] = 'Tanuló id száma';
$string['field-studentlastname'] = 'Tanuló vezetékneve';
$string['field-studentnote'] = 'Üzenet a tanulótól';
$string['field-studentusername'] = 'Tanuló felhasználóneve';
$string['field-teachernote'] = 'Bizalmas foglalási jegyzetek (csak tanár)';
$string['fileformat'] = 'Állomány formátuma';
$string['fileformat_help'] = 'A következő fájlformátumok állnak rendelkezésre: <ul> <li>Vesszővel tagolt értékű (CSV) szövegfájlok. A mezőelválasztó, alapértelmezés szerint vessző, az alábbiakban választható. A CSV-fájlok a legtöbb táblázatkezelő alkalmazásban megnyithatók;</li> <li>Microsoft Excel fájlok (Excel 2007 formátum);</li> <li>Open Document táblázatok (ODS);</li> <li>HTML formátum - a kimeneti táblázatot megjelenítő weboldal, amely a böngésző nyomtatási funkciójával nyomtatható;</li> <li>PDF dokumentumok. Választhat fekvő és álló tájolás között.</li> </ul>';
$string['finalgrade'] = 'Végső osztályzat';
$string['firstslotavailable'] = 'Az első idősáv a következő napon lesz nyitva: {$a}';
$string['forbidgroup'] = 'Csoportos idősáv - kattintson a módosításhoz';
$string['forcewhenoverlap'] = 'Erőltesse az új idősávot, ha átfedés van';
$string['forcewhenoverlap_help'] = '<h3>Idősáv létrehozásának kényszerítése, ha a sávok átfedésben vannak</h3> <p>Ez a beállítás határozza meg, hogy a rendszer hogyan kezelje az idősávokat, ha átfedésben vannak más, már meglévő helyekkel.</p> <p>Ha engedélyezve van, az átfedésben lévő meglévő idősáv törlődik, létrejön az új idősáv.</p> <p>Ha le van tiltva, az átfedésben lévő meglévő idősáv megmarad, új idősáv <em>nem</em> jön létre.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Hallgatók választása';
$string['friday'] = 'Péntek';
$string['generalconfig'] = 'Általános konfiguráció';
$string['grade'] = 'Osztályzat';
$string['gradeingradebook'] = 'Osztályzat a naplóban';
$string['gradingstrategy'] = 'Értékelési stratégia';
$string['gradingstrategy_help'] = 'Az ütemezőben, ahol a tanulóknak több találkozójuk is lehet, válassza ki az osztályzatok összesítésének módját. Az érdemjegyzőkönyv megjelenítheti az <ul><li>átlagos osztályzatot vagy a</li><li>a tanuló által elért maximális osztályzatot</li></ul>.';
$string['group'] = 'csoport';
$string['groupbookings'] = 'Csoportos foglalás';
$string['groupbookings_help'] = 'Lehetővé teszi a tanulók számára, hogy csoportjuk minden tagja számára foglaljanak helyet. (Ne feledje, hogy ez elkülönül a "csoportos mód" beállítástól, amely szabályozza, hogy a tanulók milyen időközöket láthatnak.)';
$string['groupbreakdown'] = 'Csoport nagysága szerint';
$string['groupmodeyourgroups'] = 'Csoportos mód: {$a->groupmode}. Csak a(z) {$a->grouplist} tanulói foglalhatnak időpontot Önnél.';
$string['groupmodeyourgroupsempty'] = 'Csoportos mód: {$a->groupmode}. Ön egyetlen csoportnak sem tagja, ezért a hallgatók nem foglalhatnak Önnel időpontot.';
$string['groupscheduling'] = 'Csoportos foglalás engedélyezése';
$string['groupscheduling_desc'] = 'Lehetővé teszi a teljes csoportok egyidejű ütemezését. (A globális opción kívül a "Csoportos foglalás" beállítást engedélyezni kell a megfelelő ütemező példányban.)';
$string['groupsession'] = 'Csoportos foglalkozás';
$string['groupsize'] = 'Csoport nagysága';
$string['guardtime'] = 'Őrzési idő';
$string['guardtime_help'] = 'Az őrzési idő megakadályozza, hogy a hallgatók röviddel a találkozó előtt módosítsák a foglalásukat. <p>Ha az őrzési idő be van kapcsolva, és például 2 órára van állítva, akkor a tanulók nem tudnak olyan helyet foglalni, amely kevesebb, mint 2 órán belül kezdődik, és nem tudnak lemondani az időpontról. kevesebb, mint 2 órán belül elindul.</p>';
$string['guestscantdoanything'] = 'A vendégek itt nem tehetnek semmit.';
$string['howtoaddstudents'] = 'Ha tanulókat szeretne hozzáadni egy globális hatókörű ütemezőhöz, használja a modul szerepkör-beállítását.<br/>Modul szerepkör-definíciókat is használhat a hallgatók résztvevőinek meghatározásához.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Figyelmen kívül hagyja az ütemezési ütközéseket';
$string['ignoreconflicts_help'] = 'Ha ez a jelölőnégyzet be van jelölve, akkor a rés a kért dátumra és időpontra kerül, még akkor is, ha más helyek vannak egyidőben. Ez átfedő időpontokhoz vezethet egyes tanárok vagy tanulók esetében, ezért óvatosan kell használni.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Tartalmazza az üres idősávokat';
$string['includeslotsfor'] = 'Tartalmazza az idősávokat';
$string['incourse'] = 'kurzusban';
$string['introduction'] = 'Leírás';
$string['isnonexclusive'] = 'Nem kizárólagos';
$string['landscape'] = 'Fekvő';
$string['lengthbreakdown'] = 'Idősáv hossza szerint';
$string['limited'] = 'Limitált ({$a} maradt)';
$string['location'] = 'Helyszín';
$string['location_help'] = 'Adja meg a találkozó ütemezett helyét.';
$string['markasseennow'] = 'Jelölje látottnak';
$string['markseen'] = 'Tanulóval való találkozó után, kérjük, jelölje meg őket "Látott"-ként a felhasználói kép melletti jelölőnégyzetre kattintva.';
$string['maxgrade'] = 'Vegyük a legmagasabb osztályzatot';
$string['maxstudentlistsize'] = 'Tanulói lista maximum hossza';
$string['maxstudentlistsize_desc'] = 'Azon tanulók listájának maximális hossza, akiknek időpontot kell foglalniuk, ahogy az az ütemező tanári nézetében látható. Ha ennél több tanuló van, nem jelenik meg lista.';
$string['maxstudentsperslot'] = 'Időpontonkénti maximum tanulók száma';
$string['maxstudentsperslot_desc'] = 'A csoportos/nem kizárólagos helyek legfeljebb ennyi hallgatót tartalmazhatnak. Ne feledje, hogy ezen felül a "korlátlan" beállítás mindig választható egy slothoz.';
$string['meangrade'] = 'Vegyük az átlagot';
$string['meetingwith'] = 'Időpont:';
$string['meetingwithplural'] = 'Időpont:';
$string['message'] = 'Üzenet';
$string['messagebody'] = 'Üzenet törzse';
$string['messageprovider:bookingnotification'] = 'Értesítés időpont kérésről és lemondásról';
$string['messageprovider:invitation'] = 'Meghívás időpont foglalásra';
$string['messageprovider:reminder'] = 'Emlékeztető a közelgő foglalásról';
$string['messagesent'] = 'Üzenet elküldve: {$a}';
$string['messagesubject'] = 'Tárgy';
$string['minutes'] = 'perc';
$string['minutesperslot'] = 'perc idősávonként';
$string['missingstudents'] = '{$a} diák időpontot kérhet';
$string['missingstudentsmany'] = '{$a} diák időpontot kérhet. A lista nincs kimutatva a nagysága miatt.';
$string['mixindivgroup'] = 'Egyéni és csoportos foglalások is';
$string['mixindivgroup_desc'] = 'Ahol a csoportos ütemezés engedélyezve van, engedélyezze az egyéni foglalásokat is.';
$string['mode'] = 'Módszer';
$string['modeappointments'] = 'időpontot';
$string['modeintro'] = 'A tanuló bejelölhet';
$string['modeoneatatime'] = 'egyidőben';
$string['modeoneonly'] = 'ebben az ütemezőben';
$string['modulename'] = 'Ütemező';
$string['modulename_help'] = 'Az ütemező tevékenység segít a hallgatókkal való találkozók ütemezésében. A tanárok meghatározzák az értekezletek időpontját, majd a diákok kiválasztanak egyet a Moodle-ban. A tanárok pedig rögzíthetik a megbeszélés eredményét – és opcionálisan egy osztályzatot – az ütemezőn belül. A csoportos ütemezés támogatott; azaz egy-egy időpontban több diák is elfér, és opcionálisan lehetőség van egyidejűleg egész csoportra is időpontot egyeztetni.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Ütemezők';
$string['monday'] = 'Hétfő';
$string['multiple'] = '(több)';
$string['myappointments'] = 'Saját időpontok';
$string['myself'] = 'Saját';
$string['name'] = 'Ütemező neve';
$string['needteachers'] = 'Helyek nem adhatók hozzá, mivel ennek a kurzusnak nincsenek tanárai';
$string['negativerange'] = 'A tartomány negatív. Ez nem lehet.';
$string['never'] = 'Soha';
$string['nfiles'] = '{$a} fájlok';
$string['noappointments'] = 'Nincsenek találkozók';
$string['noexistingstudents'] = 'Nincs tanuló, aki elérhető lenne időzítésre.';
$string['nogroups'] = 'Nincs elérhető csoport az ütemezéshez.';
$string['noresults'] = 'Nincs találat.';
$string['noschedulers'] = 'Nincsenek ütemezők';
$string['noslots'] = 'Nincsenek elérhető időpontok.';
$string['noslotsavailable'] = 'A foglalás jelenleg nem elérhető.';
$string['noslotsopennow'] = 'Jelenleg nincs szabad hely foglalni.';
$string['nostudents'] = 'Nem lett tanuló időzítve';
$string['nostudenttobook'] = 'Nincs tanuló aki időzíthető lenne';
$string['note'] = 'Osztályzat';
$string['noteacherforslot'] = 'Nincs tanár a idősávokra';
$string['noteachershere'] = 'Nincs elérhető tanár';
$string['notenoughplaces'] = 'Sajnáljuk, nincs elég szabad találkozó ebben az idősávban.';
$string['notesrequired'] = 'A foglalás előtt szöveget kell beírnia ebbe a mezőbe.';
$string['notifications'] = 'Értesítések';
$string['notifications_help'] = 'Ha ez az opció engedélyezve van, a tanárok és a hallgatók értesítéseket kapnak, amikor találkozókat kérnek vagy lemondanak.';
$string['notseen'] = 'Nem látott';
$string['now'] = 'Most';
$string['occurrences'] = 'Előfordulások';
$string['odsformat'] = 'ODS';
$string['on'] = 'rajta';
$string['onedaybefore'] = '1 nappal az idősáv előtt';
$string['onelineperappointment'] = 'Találkozónként egy sor';
$string['onelineperslot'] = 'Idősávonként egy sor';
$string['oneslotadded'] = '1 idősáv hozzáadva';
$string['oneslotdeleted'] = '1 idősáv törölve';
$string['oneweekbefore'] = '1 héttel az idősáv előtt';
$string['onthemorningofappointment'] = 'A találkozó reggelén';
$string['options'] = 'Beálltások';
$string['otherstudents'] = 'Más résztvevők';
$string['outlineappointments'] = 'Részvétel a(z) {$a->attended} találkozón, {$a->upcoming} a közelgő.';
$string['outlinegrade'] = 'Osztályzat: {$a}.';
$string['overall'] = 'Összegző';
$string['overlappings'] = 'Néhány más idősáv átfedésben van';
$string['pageperteacher'] = 'Minden {$a} külön oldalra';
$string['pagination'] = 'Oldalbeosztás';
$string['pagination_help'] = 'Válassza ki, hogy az exportálásnak tartalmaznia kell-e külön oldalt minden tanár számára. Excelben és ODS fájlformátumban ezek az oldalak a munkafüzet lapjainak (munkalapjainak) felelnek meg.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF oldal tájolása';
$string['pluginadministration'] = 'Ütemező adminisztrációja';
$string['pluginname'] = 'Időpontok';
$string['portrait'] = 'Álló';
$string['preview'] = 'Előnézet';
$string['previewlimited'] = '(Az előnézet {$a} sorra korlátozódik.)';
$string['privacy:metadata:filepurpose'] = 'Az idősáv vagy találkozó megjegyzéseiben használt fájl';
$string['privacy:metadata:scheduler_appointment'] = 'Tanulói találkozót jelent az ütemezőben';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Tanári megjegyzés (látható a tanuló számára)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'A tanári jegyzet formátuma';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Hogy a találkozón részt vettek-e';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Osztályzat a találkozóra';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Tanuló aki lefoglalta az időpontot';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Tanuló megjegyzése';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Tanulói jegyzet formátuma';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Tanári jegyzet (privát)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Privát tanári jegyzet formátuma';
$string['privacy:metadata:scheduler_slots'] = 'Ütemező egy idősávját jelöli';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Időpont egyeztetés helye';
$string['privacy:metadata:scheduler_slots:duration'] = 'Az idősáv időtartama percekben';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'A tanulók maximális száma az idősávban';
$string['privacy:metadata:scheduler_slots:notes'] = 'Jegyzetek az idősávval kapcsolatban';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'A jegyzetek formátuma';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Az idősáv kezdési ideje';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'A idősávhoz társított tanár';
$string['purgeunusedslots'] = 'Törölje ki a múltban nem használt idősávokat';
$string['recipients'] = 'Címzettek';
$string['registeredlbl'] = 'Tanulói időpontfoglalás';
$string['reminder'] = 'Emlékeztető';
$string['requireupload'] = 'Fájl feltöltése szükséges';
$string['resetappointments'] = 'Találkozók és osztályzatok törlése';
$string['resetslots'] = 'Ütemező idősávjainak törlése';
$string['return'] = 'Vissza a kurzushoz';
$string['revealteachernotes'] = 'Tanári megjegyzések felfedése az adatvédelmi exportálás során';
$string['revealteachernotes_desc'] = 'Ha ezt a lehetőséget választja, akkor a bizalmas tanári megjegyzések (amelyek általában nem láthatók a diákok számára) megjelennek a tanulók számára az adatexportálási kérelmek során, azaz a privay API-n keresztül. Ennek a mezőnek az egyéni használata alapján kell eldöntenie, hogy a GDPR értelmében szerepelnie kell-e a tanulók adatexportálásában.';
$string['revoke'] = 'Időpont visszavonása';
$string['saturday'] = 'Szombat';
$string['save'] = 'Mentés';
$string['savechoice'] = 'Mentse el a választásomat';
$string['saveseen'] = 'Látott mentése';
$string['schedule'] = 'Ütemez';
$string['scheduleappointment'] = 'Időpont egyeztetése: {$a}';
$string['schedulecancelled'] = '{$a} : A találkozót törölték vagy áthelyezték';
$string['schedulegroups'] = 'Ütemezés csoportonként';
$string['scheduleinnew'] = 'Ütemezés új idősávba';
$string['scheduleinslot'] = 'Ütemezés';
$string['scheduler'] = 'Ütemező';
$string['scheduler:addinstance'] = 'Új ütemező hozzáadása';
$string['scheduler:appoint'] = 'Időpontok foglalása';
$string['scheduler:attend'] = 'Résztvevő tanulók';
$string['scheduler:canscheduletootherteachers'] = 'Foglaljon időpontot a többi alkalmazott számára';
$string['scheduler:canseeotherteachersbooking'] = 'Tekintse meg és böngésszen a többi tanár foglalásai között';
$string['scheduler:disengage'] = 'Ez a képesség elavult, és nem csinál semmit';
$string['scheduler:editallattended'] = 'Jelölje meg a tanulókat az összes találkozón részt vettként / nem vett részt.';
$string['scheduler:editallgrades'] = 'Szerkessze a jegyeket az összes találkozón.';
$string['scheduler:editallnotes'] = 'Szerkessze a jegyzeteket az összes találkozón.';
$string['scheduler:manage'] = 'Kezelje időpontjait és találkozóit';
$string['scheduler:manageallappointments'] = 'Az ütemező összes adatának kezelése';
$string['scheduler:seeotherstudentsbooking'] = 'Tekintse meg az idősávra foglalt többi diákot';
$string['scheduler:seeotherstudentsresults'] = 'Tekintse meg a többi idősávban lévő tanulók eredményeit';
$string['scheduler:seeoverviewoutsideactivity'] = 'Az áttekintő képernyőn megtekintheti az aktuális ütemezőtevékenységen kívül eső időközöket.';
$string['scheduler:viewfullslots'] = 'Az idősávok mutatása akkor is, ha teljesen lefoglaltak (a tanulói képernyőn)';
$string['scheduler:viewslots'] = 'A foglalásra nyitva álló idősávok mutatása (a tanulói képernyőn)';
$string['schedulestudents'] = 'Időbeosztás diákok szerint';
$string['scopemenu'] = 'Idősávok mutatása: {$a}';
$string['scopemenuself'] = 'Mutasd az idősávjaimat itt: {$a}';
$string['search:activity'] = 'Ütemező – tevékenységi információk';
$string['seen'] = 'Látott';
$string['selectedtoomany'] = 'Túl sok idősávot választott ki. Legfeljebb {$a} választható ki.';
$string['sendinvitation'] = 'Meghívó küldése';
$string['sendmessage'] = 'Üzenet küldése';
$string['sendreminder'] = 'Emlékeztető küldése';
$string['sendreminders'] = 'E-mail küldése az elkövetkező időpontokra';
$string['sepcolon'] = 'Kettőspont';
$string['sepcomma'] = 'Vessző';
$string['sepsemicolon'] = 'Pontosvessző';
$string['septab'] = 'Tabulátor';
$string['showemailplain'] = 'E-mail címek megjelenítése egyszerű szövegben';
$string['showemailplain_desc'] = 'Az ütemező tanári nézetében a mailto: hivatkozások mellett egyszerű szövegben jelenítse meg azoknak a diákoknak az e-mail címét, akiknek időpontra van szüksége.';
$string['showparticipants'] = 'Mutasd a résztvevőket';
$string['slot'] = 'Időpont';
$string['slot_is_just_in_use'] = 'Sajnáljuk, az időpontot egy másik tanuló kiválasztotta! Kérlek próbáld újra.';
$string['slotdatetime'] = '{$a->shortdatetime}, {$a->duration} perc';
$string['slotdatetimelabel'] = 'Dátum és idő';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status}, {$a->startdate}, {$a->starttime} - {$a->endtime}, {$a->location}, {$a->facilitator}.';
$string['slots'] = 'Időpontok';
$string['slotsadded'] = '{$a} hely hozzáadva';
$string['slotsdeleted'] = '{$a} hely törölve';
$string['slottype'] = 'Idősáv típusa';
$string['slotupdated'] = '1 idősáv frissítve';
$string['slotwarning'] = '<strong>Figyelmeztetés:</strong> Ennek az időszaknak a kiválasztott időpontra való áthelyezése ütközik az alább felsorolt időköz(zel)ökkel. Jelölje be az "Ütemezési ütközések figyelmen kívül hagyása" lehetőséget, ha ennek ellenére át szeretné helyezni a helyet.';
$string['staffbreakdown'] = '{$a} szerint';
$string['staffrolename'] = 'Tanári szerep neve';
$string['staffrolename_help'] = 'Annak a szerepnek a címkéje, aki fogadja a tanulókat. Ez nem feltétlenül "tanár".';
$string['start'] = 'Kezdet';
$string['startpast'] = 'A múltban nem hozhat létre üres idősávot';
$string['statistics'] = 'Statisztika';
$string['student'] = 'Tanuló';
$string['studentbreakdown'] = 'Tanulók szerint';
$string['studentcomments'] = 'Tanulói üzenetek';
$string['studentdetails'] = 'Tanuló részletei';
$string['studentfiles'] = 'Feltöltött fájlok';
$string['studentmultiselect'] = 'Minden tanuló csak egyszer választható ki ebben az idősávban';
$string['studentnote'] = 'Üzenet a tanulótól';
$string['studentprovided'] = 'Tanuló beadta: {$a}';
$string['students'] = 'Tanulók';
$string['sunday'] = 'Vasárnap';
$string['tab-otherappointments'] = 'A tanuló összes megbeszélése';
$string['tab-otherstudents'] = 'Tanulók ebben az idősávban';
$string['tab-thisappointment'] = 'Ez a találkozó';
$string['teacher'] = 'Felelős';
$string['teachernote'] = 'Bizalmas jegyzetek (csak a tanár számára láthatók)';
$string['teachersmenu'] = 'Idősávjai: {$a}';
$string['thiscourse'] = 'ebben a kurzusban';
$string['thisscheduler'] = 'ebben az ütemezőben';
$string['thissite'] = 'az egész portálon';
$string['thursday'] = 'Csütörtök';
$string['timefrom'] = 'Időponttól:';
$string['timerange'] = 'Időtartomány';
$string['timeto'] = 'Időpontig:';
$string['totalgrade'] = 'Összes osztályzat';
$string['tuesday'] = 'Kedd';
$string['unattended'] = 'Nem vett részt';
$string['unlimited'] = 'Korlátlan';
$string['unregisteredlbl'] = 'Nem időzített tanulók';
$string['upcomingslots'] = 'Soron lévő időpontok';
$string['updategrades'] = 'Osztályzatok frissítése';
$string['updatesingleslot'] = 'Idősáv frissítése';
$string['uploadmaxfiles'] = 'A feltöltött fájlok maximális száma';
$string['uploadmaxfiles_help'] = 'A hallgató által a foglalási űrlapon feltölthető fájlok maximális száma. A fájlfeltöltés nem kötelező, kivéve, ha a "Fájl feltöltése szükséges" négyzet be van jelölve. Ha 0-ra van állítva, a tanulók nem látnak fájlfeltöltési mezőt.';
$string['uploadmaxfilesglobal'] = 'A feltöltött fájlok maximális száma';
$string['uploadmaxfilesglobal_desc'] = 'A hallgató által a foglalási űrlapon feltölthető fájlok maximális száma. Ez tovább csökkenthető az egyes ütemezők szintjén.';
$string['uploadmaxsize'] = 'Maximális fájlméret';
$string['uploadmaxsize_help'] = 'A diákok által feltöltött fájlok maximális mérete. Ez a korlát fájlonként érvényes.';
$string['uploadrequired'] = 'Az idősáv lefoglalása előtt fel kell töltenie a fájlokat.';
$string['uploadstudentfiles'] = 'Fájlok feltöltése';
$string['usebookingform'] = 'Használja a foglalási űrlapot';
$string['usebookingform_help'] = 'Ha engedélyezve van, a tanulók külön foglalási képernyőt látnak, mielőtt helyet foglalnának. A foglalási képernyő megkövetelheti az adatok megadását, fájlok feltöltését vagy a captcha megoldását; lásd az alábbi lehetőségeket.';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Használja a CAPTCHA-t az új foglalásokhoz';
$string['usecaptcha_help'] = 'Ha engedélyezve van, a tanulóknak meg kell oldaniuk egy CAPTCHA biztonsági kérdést, mielőtt új foglalást hajtanának végre. Használja ezt a beállítást, ha azt gyanítja, hogy a tanulók automatizált programokat használnak az elérhető helyek lekérésére. <p>Nem jelenik meg captcha, ha a tanuló szerkeszt egy meglévő foglalást.</p>';
$string['usenotes'] = 'Használjon jegyzeteket a találkozókhoz';
$string['usenotesboth'] = 'Mindkét típusú jegyzetek';
$string['usenotesnone'] = 'Nem';
$string['usenotesstudent'] = 'Foglalási jegyzet, látható a tanár és tanuló számára';
$string['usenotesteacher'] = 'Bizalmas foglalási jegyzetek, csak a tanárok számára látható';
$string['usestudentnotes'] = 'Engedje meg, hogy a tanulók jegyzeteket írjanak';
$string['usestudentnotes_help'] = 'Ha engedélyezve van, a foglalási képernyő egy szövegmezőt tartalmaz, amelybe a tanulók beírhatnak egy üzenetet. A fenti "foglalási utasítások" segítségével tájékoztassa a tanulókat arról, hogy milyen információkat kell megadniuk.';
$string['viewbooking'] = 'Részletek';
$string['wednesday'] = 'Szerda';
$string['welcomebackstudent'] = 'További időpont foglalható az "Időpont foglalás" gombra kattintva.';
$string['welcomenewstudent'] = 'Az alábbi táblázat az elérhető időpontokat mutatja. Választásod a megfelelő "Időpont foglalás" gombbal lehetséges. Ha a későbbiek folyamán változtatni szeretnél, akkor ugyanezen az oldalon megteheted.';
$string['welcomenewteacher'] = 'Kérem klikkeljen az alul lévő gombra, ha új megbeszélési időpontot szeretne létrehozni.';
$string['what'] = 'Mi?';
$string['whathappened'] = 'Mi történt?';
$string['whatresulted'] = 'Mi lett az eredménye?';
$string['when'] = 'Mikor?';
$string['where'] = 'Hol?';
$string['who'] = 'Kivel?';
$string['whosthere'] = 'Ki van ott ?';
$string['xdaysbefore'] = '{$a} nappal az idősáv előtt';
$string['xweeksbefore'] = '{$a} héttel az idősáv előtt';
$string['yesallgroups'] = 'Igen, minden csoportra';
$string['yesingrouping'] = 'Igen, a(z) {$a} csoportban';
$string['yesoptional'] = 'Igen, tanuló számára opcionális';
$string['yesrequired'] = 'Igen, a tanulónak be kell írnia egy üzenetet';
$string['yourappointmentnote'] = 'Megjegyzések saját magadnak';
$string['yourslotnotes'] = 'Megjegyzések a találkozóhoz';
$string['yourstudentnote'] = 'Jegyzeteid';
$string['yourtotalgrade'] = 'Az összesített érdemjegye ebben a tevékenységben: <strong>{$a}</strong>.';
