<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'lt', version '4.3'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Suprantu ir sutinku su duomenų tvarkymo sutartimi';
$string['activityoverview'] = 'Turite artėjančių BigBlueButton sesijų';
$string['bbbduetimeoverstartingtime'] = 'Uždarymo laikas turi būti vėlesnis nei atidarymo laikas.';
$string['bbbdurationwarning'] = 'Didžiausia šios sesijos trukmė yra %duration% min.';
$string['bbbrecordallfromstartwarning'] = 'Ši sesija įrašoma nuo pradžių.';
$string['bbbrecordwarning'] = 'Sesija gali būti įrašoma.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Pridėti naują BigBlueButton kambarį';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Kurti tiesioginių sesijų egzempliorių';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Kurti egzempliorių su įrašais';
$string['bigbluebuttonbn:deleterecordings'] = 'Ištrinti įrašus';
$string['bigbluebuttonbn:importrecordings'] = 'Importuoti įrašus';
$string['bigbluebuttonbn:join'] = 'Prisijungti prie BigBlueButton kambario';
$string['bigbluebuttonbn:managerecordings'] = 'Tvarkyti įrašus';
$string['bigbluebuttonbn:protectrecordings'] = 'Apsaugoti įrašus';
$string['bigbluebuttonbn:publishrecordings'] = 'Skelbti įrašus';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Atšaukti įrašų apsaugą';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Atšaukti įrašų paskelbimą';
$string['bigbluebuttonbn:view'] = 'Peržiūrėti BigBlueButton kambarį';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Žiūrėti visus įrašymo formatus';
$string['bigbluebuttondisablednotification'] = 'BigBlueButton veiklos modulis buvo išjungtas ir jokia esama BigBlueButton kurso veikla šiuo metu nepasiekiama. Prieš iš naujo įgalindami šį papildinį, įsitikinkite, kad perskaitėte ir sutikote su <a href="{$a}" target="_blank">duomenų apdorojimo sutartimi</a> su Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'BigBlueButton veiklos modulis išjungtas.';
$string['cachedef_currentfetch'] = 'Duomenys, skirti įrašyti visus neseniai gautus įrašus.';
$string['cachedef_recordings'] = 'Įrašo metaduomenys';
$string['cachedef_serverinfo'] = 'Nuotolinio serverio informacija';
$string['cachedef_subplugins'] = 'Pagalbinių papildinių procedūrose naudojama talpykla, kad prireikus pagreitintų papildinių suradimo procesą.';
$string['cachedef_validatedurls'] = 'Patvirtintų URL patikrų talpykla';
$string['calendarstarts'] = '{$a} suplanuota';
$string['cannotperformaction'] = 'Su šiuo įrašu negalima atlikti veiksmo {$a}';
$string['completionattendance'] = 'Reikalingas dalyvavimas (minutėmis)';
$string['completionattendance_desc'] = 'Įeiti ir pasilikti kambaryje mažiausiai {$a} minutę (-es).';
$string['completionattendance_event_desc'] = 'Besimokantysis įėjo į kambarį arba išbuvo sesijoje mažiausiai {$a} min.';
$string['completionattendancegroup'] = 'Reikalingas dalyvavimas (minutėmis)';
$string['completionattendancegroup_help'] = 'Norint užbaigti susitikimą, būtina dalyvauti jame (n) minučių';
$string['completionengagement_desc'] = 'Susitikimo metu įsitraukti į veiklą';
$string['completionengagementchats'] = 'Pokalbiai';
$string['completionengagementchats_desc'] = 'Dalyvauti {$a} pokalbyje (-iuose).';
$string['completionengagementchats_event_desc'] = 'Iškėlė {$a} pokalbį (-us)';
$string['completionengagementemojis'] = 'Jaustukai';
$string['completionengagementemojis_desc'] = '{$a} kartą (-us) pakeisti savo jaustuką (-us).';
$string['completionengagementemojis_event_desc'] = '{$a} kartą (-us) pakeitė savo jaustuką (-us).';
$string['completionengagementgroup'] = 'Reikalauti dalyvavimo';
$string['completionengagementgroup_help'] = 'Norint užbaigti užsiėmimą, būtinas aktyvus dalyvavimas sesijos metu.';
$string['completionengagementpollvotes'] = 'Apklausos balsai';
$string['completionengagementpollvotes_desc'] = 'Balsuoti apklausose {$a} kartą (-us).';
$string['completionengagementpollvotes_event_desc'] = 'Atsakė į {$a} apklausą (-as)';
$string['completionengagementraisehand'] = 'Reikalauti pakelti ranką';
$string['completionengagementraisehand_desc'] = 'Pakelti ranką {$a} kartą (-us).';
$string['completionengagementraisehand_event_desc'] = 'Pakėlė ranką {$a} kartų';
$string['completionengagementtalks'] = 'Pokalbiai';
$string['completionengagementtalks_desc'] = 'Kalbėti {$a} kartą (-us)';
$string['completionengagementtalks_event_desc'] = 'Iškėlė {$a} pokalbį (-ius)';
$string['completionupdatestate'] = 'Baigimo atnaujinimo būsena';
$string['completionvalidatestate'] = 'Patvirtinti užbaigimą';
$string['completionvalidatestatetriggered'] = 'Suaktyvintas patvirtinimo užbaigimas.';
$string['completionview'] = 'Reikalauti peržiūros';
$string['completionview_desc'] = 'Peržiūrėti kambarį';
$string['completionview_event_desc'] = 'Žiūrėjo kambarį.';
$string['config_checksum_algorithm'] = '„BigBlueButton“ serverio kontrolinės sumos algoritmas';
$string['config_checksum_algorithm_description'] = 'SHA1 suderinamas su senesniais serveriais. SHA256 ir SHA512 yra saugesni. SHA512 yra suderinamas su FIPS 140-2.';
$string['config_default_messages'] = 'Default messages';
$string['config_default_messages_description'] = 'Nustatykite numatytuosius pranešimų nustatymus veikloms';
$string['config_disablecam_default'] = 'Išjungti pagal numatytuosius nustatymus įjungtą kamerą';
$string['config_disablecam_default_description'] = 'Jei įjungta, internetinės kameros bus išjungtos.';
$string['config_disablecam_editable'] = '"Išjungti internetinę kamerą" galima redaguoti';
$string['config_disablecam_editable_description'] = '"Išjungti internetinę kamerą" pagal numatytuosius nustatymus galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_disablemic_default'] = 'Išjungti mikrofoną, įjungtą pagal numatytuosius nustatymus';
$string['config_disablemic_default_description'] = 'Jei įjungta, mikrofonai bus išjungti.';
$string['config_disablemic_editable'] = '"Išjungti mikrofoną" galima redaguoti';
$string['config_disablemic_editable_description'] = '"Išjungti mikrofoną" pagal numatytuosius nustatymus galima redaguoti, kai pridedamas arba atnaujinamas egzempliorius.';
$string['config_disablenote_default'] = 'Išjungti bendrinamus užrašus, įgalintus pagal numatytuosius nustatymus';
$string['config_disablenote_default_description'] = 'Jei įjungta, bendrinami užrašai bus išjungti.';
$string['config_disablenote_editable'] = '"Išjungti bendrinamus užrašus" galima redaguoti';
$string['config_disablenote_editable_description'] = '"Išjungti bendrinamus užrašus" pagal numatytuosius nustatymus galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_disableprivatechat_default'] = 'Išjungti privatų pokalbį, įjungtą pagal numatytuosius nustatymus';
$string['config_disableprivatechat_default_description'] = 'Jei įjungta, privatus pokalbis bus išjungtas.';
$string['config_disableprivatechat_editable'] = '"Išjungti privatų pokalbį" galima redaguoti';
$string['config_disableprivatechat_editable_description'] = '"Išjungti privatų pokalbį" pagal numatytuosius nustatymus galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_disablepublicchat_default'] = 'Išjungti viešąjį pokalbį, įjungtą pagal numatytuosius nustatymus';
$string['config_disablepublicchat_default_description'] = 'Jei įjungta, viešasis pokalbis bus išjungtas.';
$string['config_disablepublicchat_editable'] = '"Išjungti viešąjį pokalbį" galima redaguoti';
$string['config_disablepublicchat_editable_description'] = '"Išjungti viešąjį pokalbį" pagal numatytuosius nustatymus galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_dpa_note'] = 'Pastaba: norėdami įvykdyti savo duomenų apsaugos įsipareigojimus, prieš naudodami paslaugų teikėją šiam papildiniui, turite įsitikinti, kad perskaitėte paslaugų teikėjo duomenų tvarkymo sutartį ir su ja sutinkate. Numatytosios nemokamos „BigBlueButton“ paslaugos atveju tai yra <a href="{$a}" target="_blank">Blindside Networks data processing agreement</a>. Pasitarkite su savo privatumo specialistais.';
$string['config_experimental_features'] = 'Eksperimentinės funkcijos';
$string['config_experimental_features_description'] = 'Eksperimentinių funkcijų konfigūracija.';
$string['config_extended_capabilities'] = 'Išplėstinės galimybės';
$string['config_extended_capabilities_description'] = 'Išplėstinių galimybių konfigūracija, kai BigBlueButton serveris jas siūlo.';
$string['config_general'] = 'Bendrieji nustatymai';
$string['config_general_description'] = 'Šie nustatymai naudojami visada.';
$string['config_guestaccess_enabled'] = 'Išorinė svečių prieiga';
$string['config_guestaccess_enabled_description'] = 'Leisti naudotojams, neturintiems paskyros jūsų svetainėje, pasiekti kambarį.';
$string['config_hideuserlist_default'] = 'Slėpti naudotojų sąrašą, įjungtą pagal numatytuosius nustatymus';
$string['config_hideuserlist_default_description'] = 'Jei įjungta, sesijos naudotojų sąrašas bus paslėptas.';
$string['config_hideuserlist_editable'] = 'Slėpti naudotojų sąrašą galima redaguoti';
$string['config_hideuserlist_editable_description'] = 'Slėpti naudotojų sąrašą pagal numatytuosius nustatymus galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_importrecordings'] = 'Importuoti įrašus';
$string['config_importrecordings_description'] = 'Šios nuostatos yra funkcijos specifinės';
$string['config_importrecordings_enabled'] = 'Įrašų importavimas įjungtas';
$string['config_importrecordings_enabled_description'] = 'Įjungus šią ir įrašymo funkciją, į veiklą galima importuoti įrašus iš skirtingų kursų.';
$string['config_importrecordings_from_deleted_enabled'] = 'Įgalintas ištrintų veiklų įrašų importavimas';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Įjungus šią ir importavimo įrašymo funkciją, galima importuoti įrašus iš veiklų, kurių kurse nebėra.';
$string['config_locksettings'] = 'Užrakinimo nustatymų konfigūracija';
$string['config_locksettings_description'] = 'Šie nustatymai įgalina arba išjungia naudotojo sąsajos parinktis užrakinti nustatymus, taip pat apibrėžia numatytąsias šių parinkčių vertes.';
$string['config_meetingevents_enabled'] = 'Registruoti tiesiogines sesijas';
$string['config_meetingevents_enabled_description'] = 'Jei įjungta, tiesioginės sesijos bus apdorojamos pasibaigus sesijai. Ši funkcija reikalinga veiklos užbaigimui ir veiks tik tuo atveju, jei BigBlueButton serveris gali apdoroti post_events scenarijus.';
$string['config_muteonstart'] = 'Nutildyti pradėjus';
$string['config_muteonstart_default'] = '„Nutildyta“ įjungta pagal numatymą';
$string['config_muteonstart_default_description'] = 'Jei įjungta, paleidus sesiją bus nutildyta.';
$string['config_muteonstart_description'] = 'Šie nustatymai įjungia arba išjungia naudotojo sąsajos parinktis, taip pat apibrėžia numatytąsias šių parinkčių vertes.';
$string['config_muteonstart_editable'] = '„Nutildyta" galima keisti';
$string['config_muteonstart_editable_description'] = 'Funkcijos „Nutildyta" numatytuosius nustatymus galima keisti, kai egzempliorius sukuriamas ar atnaujinamas.';
$string['config_participant'] = 'Dalyviai';
$string['config_participant_description'] = 'Šie nustatymai apibrėžia numatytuosius dalyvių vaidmenis.';
$string['config_participant_moderator_default'] = 'Moderatorius';
$string['config_participant_moderator_default_description'] = 'Ši taisyklė naudojama pagal numatytuosius nustatymus, kai pridedamas naujas kambarys.';
$string['config_poll_interval'] = 'Apklausos intervalas (sekundėmis), norint atnaujinti kambario būseną';
$string['config_poll_interval_description'] = 'Apklausos intervalas turi būti bent 2 sekundės. Jei reikia, galite sumažinti nuotolinio serverio apkrovą padidindami intervalą.';
$string['config_presentation_default'] = 'Numatytasis pristatymo failas';
$string['config_presentation_default_description'] = 'Failas gali būti pateiktas visuose kambariuose';
$string['config_preuploadpresentation'] = 'Pristatymo failas';
$string['config_preuploadpresentation_description'] = 'Šiais nustatymais įjungiamos arba išjungiamos naudotojo sąsajos parinktys, taip pat nustatomos numatytosios šių parinkčių reikšmės. Funkcija veikia tik tada, jei "Moodle" serveris yra prieinamas "BigBlueButton".';
$string['config_preuploadpresentation_editable'] = 'Pristatymo failas veiklos puslapyje';
$string['config_preuploadpresentation_editable_description'] = 'Galimybė veiklos nustatymuose įkelti pristatymo failą, kuris bus rodomas veiklos puslapyje.';
$string['config_profile_picture_enabled'] = 'Rodyti profilio nuotraukas';
$string['config_profile_picture_enabled_description'] = 'Ar BigBlueButton sesijose turėtų būti rodomos dalyvių profilio nuotraukos?';
$string['config_recording'] = 'Įrašymas';
$string['config_recording_all_from_start_default'] = 'Pradėti įrašymą nuo pradžių';
$string['config_recording_all_from_start_default_description'] = 'Ar pridedant naują „BigBlueButton“ kambarį, nustatymas „Pradėti įrašymą nuo pradžių“ turėtų būti įjungtas pagal numatytuosius nustatymus?';
$string['config_recording_all_from_start_editable'] = 'Pradėti įrašymą nuo pradžios';
$string['config_recording_all_from_start_editable_description'] = 'Ar "Pradėti įrašymą nuo pradžios" turėtų būti redaguojama BigBlueButton veiklos nustatymuose?';
$string['config_recording_default'] = 'Pagal numatytuosius nustatymus įjungtas įrašymas';
$string['config_recording_default_description'] = 'Ar pridedant naują BigBlueButton kambarį nustatymas "Sesiją galima įrašyti" turėtų būti įjungtas pagal numatytuosius nustatymus?';
$string['config_recording_description'] = 'Šie nustatymai yra specifiniai';
$string['config_recording_editable'] = 'Sesija gali būti įrašyta ir redaguojama';
$string['config_recording_editable_description'] = 'Ar „BigBlueButton“ veiklos nustatymuose galima redaguoti „Sesija gali būti įrašyta“?';
$string['config_recording_hide_button_default'] = 'Slėpti įrašymo mygtuką';
$string['config_recording_hide_button_default_description'] = 'Jei pažymėta, mygtukas "įrašyti" bus paslėptas';
$string['config_recording_hide_button_editable'] = 'Mygtukas "Slėpti įrašymą" yra redaguojamas';
$string['config_recording_hide_button_editable_description'] = 'Ar "Paslėpti įrašymo mygtuką" turėtų būti galima redaguoti BigBlueButton veiklos nustatymuose?';
$string['config_recording_protect_editable'] = 'Apsaugotų įrašų būseną galima redaguoti';
$string['config_recording_protect_editable_description'] = 'Jei pažymėta, sąsajoje yra įrašų apsaugos/apsaugos panaikinimo parinktys.';
$string['config_recording_refresh_period'] = 'Įrašymo atnaujinimo laikotarpis (sekundėmis)';
$string['config_recording_refresh_period_description'] = 'Kaip dažnai reikia pateikti BigBlueButton serverio užklausą, kad būtų atnaujinta nuotolinė įrašo informacija?';
$string['config_recording_safe_formats'] = 'Įrašymo formatai, kuriuos gali peržiūrėti visi';
$string['config_recording_safe_formats_description'] = 'Pasirinkti formatus, kuriuos galės peržiūrėti visi.
Visus kitus formatus galės peržiūrėti tik dėstytojai ir kiti naudotojai, naudodami mod/bigbluebuttonbn:viewallrecordingformats ir
  mod/bigbluebuttonbn:managerecordings galimybes.';
$string['config_recordingready_enabled'] = 'Siųsti pranešimą apie galimą įrašą';
$string['config_recordingready_enabled_description'] = 'Jei įjungta, bus išsiųstas pranešimas, kai bus pasiekiama įrašymo nuoroda. Šiai funkcijai reikia, kad „BigBlueButton“ serveryje būtų įjungtas scenarijus post_publish_recording_ready_callback.';
$string['config_recordings'] = 'Rodyti įrašus';
$string['config_recordings_asc_sort'] = 'Rikiuoti įrašus chronologine tvarka';
$string['config_recordings_asc_sort_description'] = 'Įrašai išdėstyti pagal datą chronologine arba atvirkštine chronologine tvarka (pirmiausia naujausias įrašas).';
$string['config_recordings_deleted_default'] = '„Įtraukti įrašus iš panaikintų veiklų“ įjungta pagal numatytuosius nustatymus';
$string['config_recordings_deleted_default_description'] = 'Jei įjungta, į įrašymo lentelę bus įtraukti bet kokios veiklos, kuri vėliau buvo ištrinta, įrašai.';
$string['config_recordings_deleted_editable'] = '„Įtraukti įrašus iš ištrintos veiklos“ funkciją galima redaguoti';
$string['config_recordings_deleted_editable_description'] = '„Įtraukti įrašus iš ištrintų veiklų“ pagal numatytuosius nustatymus galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_recordings_description'] = 'Šie nustatymai yra specifiniai';
$string['config_recordings_general'] = 'Rodyti įrašymo nustatymus';
$string['config_recordings_general_description'] = 'Šie nustatymai naudojami tik rodant įrašus';
$string['config_recordings_imported_default'] = 'Rodyti tik importuotas nuorodas, įgalintas pagal numatytuosius nustatymus';
$string['config_recordings_imported_default_description'] = 'Jei įjungta, įrašymo lentelėje bus įtrauktos tik importuotos nuorodos į įrašus.';
$string['config_recordings_imported_editable'] = 'Funkciją „Rodyti tik importuotas nuorodas" galima keisti';
$string['config_recordings_imported_editable_description'] = 'Funkcijos „Rodyti tik importuotas nuorodas" numatytuosius parametrus galima keisti kai egzempliorius yra sukuriamas ar atnaujinamas.';
$string['config_recordings_preview_default'] = 'Peržiūra įjungta pagal numatymą';
$string['config_recordings_preview_default_description'] = 'Jei įjungta, lentelėje yra pristatymo peržiūra.';
$string['config_recordings_preview_editable'] = 'Peržiūros funkciją galima redaguoti';
$string['config_recordings_preview_editable_description'] = '"Peržiūros funkciją" galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas.';
$string['config_scheduled'] = 'Suplanuotos sesijos';
$string['config_scheduled_description'] = 'Šie nustatymai apibrėžia numatytąjį suplanuotų seansų elgesį.';
$string['config_scheduled_pre_opening'] = 'Prieinama prieš atidarymo laiką';
$string['config_scheduled_pre_opening_description'] = 'Laikas minutėmis, kurį kambarys yra atidarytas prieš numatytą atidarymo laiką.';
$string['config_server_url'] = 'BigBlueButton serverio URL';
$string['config_server_url_description'] = 'Numatytieji kredencialai skirti <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">nemokamai BigBlueButton paslaugai, skirtai Moodle (atidaroma naujame lange)</a > teikia Blindside Networks su tokiais apribojimais:
<ol>
<li>Didžiausia kiekvienos sesijos trukmė yra 60 minučių</li>
<li>Didžiausias vienu metu naudotojų skaičius per seansą yra 25</li>
<li>Įrašai baigiasi po septynių (7) dienų ir jų negalima atsisiųsti</li>
<li>Besimokančiųjų internetines kameras mato tik moderatorius.</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton pasidalino paslaptimi';
$string['config_shared_secret_description'] = 'Jūsų BigBlueButton serverio saugumo paslaptis. Numatytoji paslaptis yra nemokama BigBlueButton paslauga, kurią teikia Blindside Networks.';
$string['config_uidelegation_enabled'] = 'UI delegavimas įjungtas';
$string['config_uidelegation_enabled_description'] = 'Šie nustatymai įgalina arba išjungia naudotojo sąsajos delegavimą BigBlueButton serveriui.';
$string['config_userlimit'] = 'Naudotojų limitas';
$string['config_userlimit_default'] = 'Naudotojų limitas įjungtas pagal numatytuosius nustatymus';
$string['config_userlimit_default_description'] = 'Naudotojų, kuriems pagal numatytuosius nustatymus leidžiama dalyvauti sesijoje, kai pridedamas naujas kambarys, skaičius. Nustatykite 0, jei norite leisti neribotą naudotojų skaičių.';
$string['config_userlimit_description'] = 'Šie nustatymai įgalina arba išjungia naudotojo sąsajos parinktis, taip pat apibrėžia numatytąsias šių parinkčių vertes.';
$string['config_userlimit_editable'] = '"Naudotojų limito funkciją" galima redaguoti';
$string['config_userlimit_editable_description'] = 'Pagal numatytuosius nustatymus naudotojo ribinė vertė gali būti redaguojama, kai pridedama arba atnaujinamas kambarys arba konferencija.';
$string['config_voicebridge'] = 'Balso tiltas';
$string['config_voicebridge_description'] = 'Šie nustatymai įgalina arba išjungia naudotojo sąsajos parinktis, taip pat apibrėžia numatytąsias šių parinkčių vertes.';
$string['config_voicebridge_editable'] = 'Galima redaguoti konferencijos balso tiltą';
$string['config_voicebridge_editable_description'] = 'Konferencijos balso tilto numeris gali būti visam laikui priskirtas kambariui. Kai jis yra priskirtas, jo negalima naudoti jokiam kitam kambariui.';
$string['config_waitformoderator'] = 'Laukti moderatoriaus';
$string['config_waitformoderator_cache_ttl'] = 'Moderatoriaus laukimo talpyklos TTL (sekundėmis)';
$string['config_waitformoderator_cache_ttl_description'] = 'Kad palaikytų didelę klientų apkrovą, šis papildinys naudoja talpyklą. Šis parametras apibrėžia, kiek laiko talpykloje bus saugoma iki kitos užklausos išsiuntimo į BigBlueButton serverį.';
$string['config_waitformoderator_default'] = '„Laukti moderatoriaus" įjungta pagal numatymą';
$string['config_waitformoderator_default_description'] = 'Ar pridedant naują „BigBlueButton“ kambarį, nustatymas „Laukti moderatoriaus“ turėtų būti įjungtas pagal numatytuosius nustatymus?';
$string['config_waitformoderator_description'] = 'Šie nustatymai yra specifiniai funkcijai';
$string['config_waitformoderator_editable'] = '„Laukti moderatoriaus" galima redaguoti';
$string['config_waitformoderator_editable_description'] = 'Ar „BigBlueButton“ veiklos nustatymuose galima redaguoti „Laukti moderatoriaus“?';
$string['config_waitformoderator_ping_interval'] = 'Laukti moderatoriaus ping\'o (sekundes)';
$string['config_waitformoderator_ping_interval_description'] = 'Kaip dažnai reikia įjungti serverio pingo signalą, kad būtų patikrinta, ar moderatorius įėjo į kambarį?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton naudoja config.php su visuotiniu kintamuoju, kuris buvo nebenaudojamas. Konvertuokite failą, nes būsimose versijose jis nebus palaikomas.';
$string['config_warning_curl_not_installed'] = 'Šiai funkcijai reikalingas CURL plėtinys, skirtas php, įdiegtas ir įgalintas. Nustatymai bus pasiekiami tik įvykdžius šią sąlygą.';
$string['config_welcome_default'] = 'Numatytasis pasveikinimo pranešimas';
$string['config_welcome_default_description'] = 'Dalyviams įėjus į kambarį rodomas sveikinimo pranešimas. Jei laukas paliekamas tuščias, naudojama kalbos eilutė „\'mod_form_field_welcome_default\'“.';
$string['config_welcome_editable'] = 'Numatytąjį pasveikinimo pranešimą gali redaguoti dėstytojai';
$string['config_welcome_editable_description'] = 'Sveikinimo žinutę galima redaguoti, kai egzempliorius pridedamas arba atnaujinamas';
$string['dpainfonotsigned'] = 'Prieš įjungdami šį papildinį, turite patvirtinti, kad perskaitėte <a href="{$a}">Blindside Networks duomenų apdorojimo sutartį</a> ir su ja sutinkate.';
$string['enablingbigbluebutton'] = 'Įgalinama BigBlueButton veikla';
$string['enablingbigbluebuttondpainfo'] = 'Kad įvykdytumėte savo duomenų apsaugos įsipareigojimus, prieš įgalindami šį papildinį, gali tekti įsitikinti, kad perskaitėte <a href="{$a}" target="_blank">Blindside Networks duomenų apdorojimo sutartį</a> ir su ja sutinkate. a>. Pasitarkite su savo privatumo specialistais.';
$string['end_session_confirm'] = 'Ar tikrai norite baigti sesiją?';
$string['end_session_confirm_title'] = 'Tikrai baigti sesiją?';
$string['end_session_notification'] = 'Sesija baigėsi.';
$string['ends_at'] = 'Baigiasi';
$string['event_activity_created'] = 'Veikla sukurta';
$string['event_activity_deleted'] = 'Veikla panaikinta';
$string['event_activity_updated'] = 'Veikla atnaujinta';
$string['event_live_session'] = 'Tiesioginis seanso įvykis';
$string['event_meeting_created'] = 'Susitikimas sukurtas';
$string['event_meeting_ended'] = 'Susitikimas priverstinai baigtas';
$string['event_meeting_joined'] = 'Prisijungta prie susitikimo';
$string['event_meeting_left'] = 'Atsijungta nuo susitikimo';
$string['event_recording_deleted'] = 'Įrašas panaikintas';
$string['event_recording_edited'] = 'Įrašas suredaguotas';
$string['event_recording_imported'] = 'Įrašas importuotas';
$string['event_recording_protected'] = 'Apsaugotas įrašymas';
$string['event_recording_published'] = 'Įrašas paskelbtas';
$string['event_recording_unprotected'] = 'Įrašymas neapsaugotas';
$string['event_recording_unpublished'] = 'Įrašas nepaskelbtas';
$string['event_recording_viewed'] = 'Įrašas peržiūrėtas';
$string['event_unknown'] = 'Nežinomas įvykis';
$string['general_error_cannot_create_meeting'] = 'Negalima sukurti sesijos.';
$string['general_error_cannot_get_recordings'] = 'Nepavyksta gauti įrašų.';
$string['general_error_no_answer'] = 'Tuščias atsakymas. Patikrinkite BigBlueButton serverio URL IR patikrinkite, ar veikia BigBlueButton serveris.';
$string['general_error_not_allowed_to_create_instances'] = 'Naudotojui neleidžiama kurti jokio tipo egzempliorių.';
$string['general_error_not_found'] = 'Nepavyko rasti BigBlueButton veiklos su {$a} ID.';
$string['general_error_unable_connect'] = 'Nepavyko prisijungti. Patikrinkite BigBlueButton serverio URL IR patikrinkite, ar veikia BigBlueButton serveris.
Details : {$a}';
$string['guest_invitation_full_message'] = 'Sveiki,
<p>Esate pakviesti į BigBlueButton sesiją <strong>{$a->name}</strong> kurse {$a->course_fullname}.</p> <p>Nuoroda: {$a->guestjoinurl}<br/>
<p>Slaptažodis: {$a->guestpassword}</p>
<p>Jei reikia pagalbos, susisiekite su {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Sveiki,

Esate pakviesti į BigBlueButton sesiją {$a->name} kurse {$a->course_fullname}.

Nuoroda: {$a->guestjoinurl}
Slaptažodis: {$a->guestpassword}

Jei reikia pagalbos, susisiekite su {$a->sender}.';
$string['guest_invitation_subject'] = 'Kvietimas: {$a->name} sesija {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Veikla nerasta.';
$string['guestaccess_add'] = 'Pridėti svečių';
$string['guestaccess_add_no_id'] = 'Nepateiktas BigBlueButton egzemplioriaus ID.';
$string['guestaccess_copy_link'] = 'Nukopijuoti nuorodą';
$string['guestaccess_copy_password'] = 'Kopijuoti slaptažodį';
$string['guestaccess_emails'] = 'Svečių el. pašto adresai';
$string['guestaccess_emails_help'] = 'El. pašto adresų sąrašas, atskirtas kableliais.';
$string['guestaccess_emails_invalidemail'] = 'Neteisingas el. pašto adresas: {$a}';
$string['guestaccess_feature_disabled'] = 'Svečio prieiga išjungta.';
$string['guestaccess_invite_failure'] = 'Klaida {$a->errors} kviečiant {$a->emails}.';
$string['guestaccess_invite_success'] = 'Kvietimas bus išsiųstas adresu (-ais) {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Prisijungti prie susitikimo';
$string['guestaccess_meeting_invalid_password'] = 'Neteisingas slaptažodis.';
$string['guestaccess_meeting_link'] = 'Susitikimo nuoroda';
$string['guestaccess_meeting_not_started'] = 'Susirinkimas dar neprasidėjo. Grįžkite vėliau.';
$string['guestaccess_meeting_password'] = 'Susitikimo slaptažodis';
$string['guestaccess_password'] = 'Slaptažodis';
$string['guestaccess_title'] = 'Pridėti svečių į šį susitikimą';
$string['guestaccess_username'] = 'Svečio naudotojo vardas';
$string['index_confirm_end'] = 'Ar norite baigti sesiją?';
$string['index_disabled'] = 'išjungtas';
$string['index_enabled'] = 'įjungtas';
$string['index_ending'] = 'Sesija baigiama... Palaukite';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} yra neteisingas';
$string['index_error_checksum'] = 'Įvyko kontrolinės sumos klaida. Patikrinkite, ar įvedėte teisingą paslaptį.';
$string['index_error_forciblyended'] = 'Nepavyko prisijungti prie sesijos, nes ji buvo baigta rankiniu būdu.';
$string['index_error_noinstances'] = 'BigBlueButton kambarių atvejų nėra';
$string['index_error_unable_display'] = 'Neįmanoma parodyti seansų. Patikrinkite BigBlueButton serverio URL ir patikrinkite, ar veikia BigBlueButton serveris.';
$string['index_heading'] = 'BigBlueButton kambariai';
$string['index_heading_actions'] = 'Veiksmai';
$string['index_heading_group'] = 'Grupė';
$string['index_heading_moderator'] = 'Moderatoriai';
$string['index_heading_name'] = 'Kambarys';
$string['index_heading_recording'] = 'Įrašas';
$string['index_heading_users'] = 'Naudotojai';
$string['index_heading_viewer'] = 'Dalyviai';
$string['indicator:cognitivedepth'] = 'Kognityvinis BigBlueButton';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį pasiekia besimokantysis, vykdydamas BigBlueButton veiklą.';
$string['indicator:socialbreadth'] = 'Socialinis BigBlueButton';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu pločiu, kurį pasiekia studentas, vykdydamas BigBlueButton veiklą.';
$string['instance_type_default'] = 'Kambarys su įrašais';
$string['instance_type_recording_only'] = 'Tik įrašai';
$string['instance_type_room_only'] = 'Tik kambarys';
$string['instanceprofilewithoutrecordings'] = 'Šis egzemplioriaus profilis negali rodyti įrašų';
$string['managebbbextplugins'] = 'Tvarkyti BigBlueButton plėtinių papildinius';
$string['messageprovider:instance_updated'] = '„BigBlueButton“ sesija atnaujinta';
$string['messageprovider:recording_ready'] = 'Galimas BigBlueButton įrašymas';
$string['minute'] = 'minutė';
$string['minutes'] = 'Minutės';
$string['mod_form_block_general'] = 'Bendra';
$string['mod_form_block_guestaccess'] = 'Svečio prieiga';
$string['mod_form_block_participants'] = 'Dalyviai';
$string['mod_form_block_presentation'] = 'Pristatymo turinys';
$string['mod_form_block_presentation_default'] = 'Numatytasis pristatymo turinys';
$string['mod_form_block_record'] = 'Įrašymo parametrai';
$string['mod_form_block_recordings'] = 'Įrašymo peržiūra';
$string['mod_form_block_room'] = 'Kambario nustatymai';
$string['mod_form_block_schedule'] = 'Sesijos laikas';
$string['mod_form_field_closingtime'] = 'Uždaryti';
$string['mod_form_field_conference_name'] = 'Sesijos pavadinimas';
$string['mod_form_field_disablecam'] = 'Išjungti internetines kameras';
$string['mod_form_field_disablemic'] = 'Išjungti mikrofonus';
$string['mod_form_field_disablenote'] = 'Išjungti bendrinamus užrašus';
$string['mod_form_field_disableprivatechat'] = 'Išjungti privatų pokalbį';
$string['mod_form_field_disablepublicchat'] = 'Išjungti viešąjį pokalbį';
$string['mod_form_field_duration'] = 'Trukmė';
$string['mod_form_field_duration_help'] = 'Nustačius susitikimo trukmę, bus nustatytas maksimalus laikas, per kurį susitikimas išliks gyvas iki įrašymo pabaigos';
$string['mod_form_field_guestallowed'] = 'Leisti svečio prieigą';
$string['mod_form_field_hideuserlist'] = 'Slėpti naudotojų sąrašą';
$string['mod_form_field_instanceprofiles'] = 'Tipas';
$string['mod_form_field_instanceprofiles_help'] = 'Jei norite įrašyti seansą, pasirinkite „Patalpa su įrašais“, kitu atveju „Tik kambarys“. Po seanso įrašymo, jei nebebus seansų, pasirinkite „Tik įrašai“.';
$string['mod_form_field_intro'] = 'Aprašymas';
$string['mod_form_field_intro_help'] = 'Trumpas kambario aprašymas.';
$string['mod_form_field_mustapproveuser'] = 'Svečius, kurie prisijungia, turi priimti moderatorius';
$string['mod_form_field_muteonstart'] = 'Nutildyta';
$string['mod_form_field_name'] = 'Kambario pavadinimas';
$string['mod_form_field_nosettings'] = 'Jokių nustatymų redaguoti negalima';
$string['mod_form_field_openingtime'] = 'Atidaryti';
$string['mod_form_field_participant_add'] = 'Pridėti priskyrimą';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderatorius';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Klausytojas';
$string['mod_form_field_participant_list'] = 'Priskyrimas';
$string['mod_form_field_participant_list_action_add'] = 'Pridėti';
$string['mod_form_field_participant_list_action_remove'] = 'Pašalinti';
$string['mod_form_field_participant_list_text_as'] = 'kaip';
$string['mod_form_field_participant_list_type_all'] = 'Visi naudotojai įtraukti';
$string['mod_form_field_participant_list_type_owner'] = 'Savininkas';
$string['mod_form_field_participant_list_type_role'] = 'Vaidmuo';
$string['mod_form_field_participant_list_type_user'] = 'Naudotojas';
$string['mod_form_field_record'] = 'Sesija gali būti įrašyta.';
$string['mod_form_field_recordallfromstart'] = 'Įrašyti viską nuo pradžios';
$string['mod_form_field_recordhidebutton'] = 'Slėpti įrašymo mygtuką';
$string['mod_form_field_recordings_deleted'] = 'Įtraukti įrašus iš panaikintos veiklos';
$string['mod_form_field_recordings_html'] = 'Rodyti lentelę paprastu HTML';
$string['mod_form_field_recordings_imported'] = 'Rodyti tik importuotas nuorodas';
$string['mod_form_field_recordings_preview'] = 'Rodyti įrašo peržiūrą';
$string['mod_form_field_room_name'] = 'Kambario pavadinimas';
$string['mod_form_field_userlimit'] = 'Naudotojų limitas';
$string['mod_form_field_userlimit_help'] = 'Didžiausias sesijos metu leidžiamas naudotojų skaičius. Nustatykite 0, kad leistų neribotą skaičių naudotojų.';
$string['mod_form_field_voicebridge'] = 'Balso tiltas  [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formato klaida. Turėtumėte įvesti skaičių nuo 1 iki 9999.';
$string['mod_form_field_voicebridge_help'] = 'Skaičius nuo 1 iki 9999, kurį dalyviai įveda norėdami prisijungti prie balso seanso naudodami skambinimo funkciją. Jei reikšmė yra 0, statinio balso tilto numerio bus nepaisoma ir BigBlueButton sugeneruos atsitiktinį skaičių. Skaičius 7 bus prieš keturis įvestus skaitmenis.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Ne unikali reikšmė. Šį numerį naudoja kitas kambarys.';
$string['mod_form_field_wait'] = 'Laukti moderatoriaus';
$string['mod_form_field_wait_help'] = 'Ar dalyviai turi palaukti moderatoriaus, kol galės patekti į kambarį?';
$string['mod_form_field_welcome'] = 'Pasisveikinimo pranešimas';
$string['mod_form_field_welcome_default'] = 'Sveiki atvykę į %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Pasisveikinimo pranešimas rodomas dalyviams įėjus į kambarį. Jei laukas paliekamas tuščias, rodomas numatytasis pranešimas, nustatytas svetainės administracijoje.';
$string['mod_form_locksettings'] = 'Užrakinimo nuostatos';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = '"BigBlueButton" yra atvirojo kodo internetinių konferencijų sistema, skirta mokymuisi internetu, kuri palaiko garso, vaizdo, pokalbių, skaidrių, ekrano bendrinimo, kelių naudotojų lentos, kambarių, apklausų ir jaustukų dalijimąsi realiuoju laiku.

Naudodami "BigBlueButton" galite sukurti kambarį, skirtą tokioms sesijoms kaip tiesioginės internetinės paskaitos ar bendradarbiavimas grupėse su nutolusiais besimokančiaisiais. Sesiją galima įrašyti ir vėliau atkurti.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton veikla';
$string['nosuchinstance'] = 'Nėra tokio atvejo {$a->entity}, kurio ID {$a->id}';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton kambarys buvo sukurtas.';
$string['notification_instance_created_small'] = 'Buvo sukurtas naujas BigBlueButton kambarys pavadinimu {$a->name}.';
$string['notification_instance_created_subject'] = 'Sukurtas naujas BigBlueButton kambarys';
$string['notification_instance_description'] = 'Aprašymas';
$string['notification_instance_end_date'] = 'Pabaigos data';
$string['notification_instance_name'] = 'Pavadinimas';
$string['notification_instance_start_date'] = 'Pradžios data';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton kambarys buvo atnaujintas.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton sesija buvo atnaujinta';
$string['notification_instance_updated_subject'] = 'Jūsų BigBlueButton kambarys buvo atnaujintas';
$string['notification_recording_ready_html'] = 'Sesijos įrašas dabar pasiekiamas BigBlueButton kambaryje <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Seanso įrašas dabar pasiekiamas BigBlueButton kambaryje {$a->name}. Eikite į {$a->link}, kad pasiektumėte įrašymo nuorodą.';
$string['notification_recording_ready_small'] = 'Yra BigBlueButton kambario {$a->name} įrašas.';
$string['notification_recording_ready_subject'] = 'Galimas įrašas';
$string['pluginadministration'] = 'BigBlueButton administravimas';
$string['pluginname'] = 'BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'Norėdami sukurti ir prisijungti prie "BigBlueButton" sesijų, naudotojų duomenys turi pasiekti serverį.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Visas naudotojo, prisijungusio prie BigBlueButton serverio, vardas.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Prie BigBlueButton serverio prisijungusio naudotojo ID.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton sesijos konfigūracija';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Taisyklių, apibrėžiančių naudotojų vaidmenį BigBlueButton sesijoje, sąrašas. Naudotojo ID gali būti saugomas, nes leidimai gali būti suteikti kiekvienam vaidmeniui arba naudotojui.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Saugo įvykius, suaktyvėjusius naudojant papildinį.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Naudotojo suaktyvinto įvykio tipas.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Seanso ID, prie kurio naudotojas turėjo prieigą.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Papildoma informacija, susijusi su sesija ar įrašu.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Laikas, kada buvo sukurtas žurnalas.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Įvykį suaktyvinusio naudotojo ID.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Saugo įrašų metaduomenis.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Paskutinį kartą įrašą pakeitusio naudotojo ID.';
$string['progress_createbigbluebuttonbn'] = 'BigBlueButton veiklos kūrimas ({$a})';
$string['recordings_from_deleted_activities'] = 'Ištrintų veiklų įrašai';
$string['recordingurlnotfound'] = 'Netinkamas įrašo URL.';
$string['removedevents'] = 'Deleted events';
$string['removedlogs'] = 'Ištrinti pasirinktiniai žurnalai';
$string['removedrecordings'] = 'Pašalinti įrašai';
$string['removedtags'] = 'Ištrintos žymos';
$string['report_join_info'] = '{$a} susitikimas (-ai)';
$string['report_play_recording_info'] = 'Leisti įrašai: {$a}';
$string['report_room_view'] = 'peržiūrėta';
$string['resetevents'] = 'Ištrinti įvykius';
$string['resetlogs'] = 'Ištrinti pasirinktinius žurnalus';
$string['resetlogs_help'] = 'Ištrynus žurnalus bus prarastos nuorodos į įrašus.';
$string['resetrecordings'] = 'Pašalinti įrašus';
$string['resetrecordings_help'] = 'Ištrynus įrašus jie bus nepasiekiami iš bet kur. Šio veiksmo anuliuoti negalima!';
$string['resettags'] = 'Ištrinti žymes';
$string['search:activity'] = 'BigBlueButton – informacija apie veiklą';
$string['search:tags'] = 'BigBlueButton – žymės informacija';
$string['sendnotification'] = 'Siųsti pranešimą';
$string['settings'] = 'BigBlueButton nustatymai';
$string['started_at'] = 'Prasidėjo';
$string['starts_at'] = 'Prasideda';
$string['subplugintype_bbbext'] = 'BigBlueButton veiklos plėtinys';
$string['subplugintype_bbbext_plural'] = 'BigBlueButton veiklos plėtiniai';
$string['taskname:check_dismissed_recordings'] = 'Patikrinti, ar nėra įrašų, kurie dar nebuvo rasti';
$string['taskname:check_pending_recordings'] = 'Gauti laukiančius įrašus';
$string['userlimitreached'] = 'Pasiektas seanso leidžiamas naudotojų skaičius.';
$string['view_conference_action_end'] = 'Baigti sesiją';
$string['view_conference_action_join'] = 'Prisijungti prie sesijos';
$string['view_error_action_not_completed'] = 'Veiksmo užbaigti nepavyko';
$string['view_error_bigbluebutton'] = 'BigBlueButton atsakė su klaidomis. {$a}';
$string['view_error_create'] = 'BigBlueButton serveris atsakė klaidos pranešimu. Kambario sukurti nepavyko.';
$string['view_error_current_state_not_found'] = 'Dabartinė būsena nerasta. Įrašas gali būti ištrintas arba BigBlueButton serveris nesuderinamas su atliktu veiksmu.';
$string['view_error_import_no_courses'] = 'Nėra kursų, kuriuose būtų galima ieškoti įrašų.';
$string['view_error_import_no_recordings'] = 'Šiame kurse nėra importuotinų įrašų.';
$string['view_error_invalid_session'] = 'Sesija baigėsi. Grįžkite į veiklos puslapį.';
$string['view_error_max_concurrent'] = 'Pasiektas leistinas vienu metu vykstančių sesijų skaičius.';
$string['view_error_meeting_not_running'] = 'Kažkas nutiko, sesija nevyksta.';
$string['view_error_no_group'] = 'Grupių nėra. Prieš bandydami prisijungti prie sesijos, turite sukurti keletą grupių.';
$string['view_error_no_group_student'] = 'Jūs nebuvote įtraukti į grupę. Prašome susisiekti su savo dėstytoju.';
$string['view_error_no_group_teacher'] = 'Grupių nėra. Turite sukurti keletą grupių.';
$string['view_error_unable_join'] = 'Nepavyko įeiti į kambarį. Patikrinkite BigBlueButton serverio URL IR patikrinkite, ar veikia BigBlueButton serveris.';
$string['view_error_unable_join_student'] = 'Nepavyko prisijungti prie BigBlueButton serverio.';
$string['view_error_unable_join_teacher'] = 'Nepavyko prisijungti prie BigBlueButton serverio. Susisiekite su administratoriumi.';
$string['view_error_url_missing_parameters'] = 'Šioje nuorodoje trūksta parametrų';
$string['view_error_userlimit_reached'] = 'Pasiektas seanso metu leidžiamas naudotojų skaičius.';
$string['view_groups_nogroups_warning'] = 'Kambarys sukonfigūruotas naudojant grupes, tačiau kurse nėra nustatytų grupių.';
$string['view_groups_notenrolled_warning'] = 'Kambarys sukonfigūruotas naudojant grupes, tačiau jūs nesate grupės narys.';
$string['view_groups_selection'] = 'Pasirinkite grupę ir prisijunkite';
$string['view_groups_selection_join'] = 'Prisijungti';
$string['view_groups_selection_warning'] = 'Kiekvienai grupei yra skirtas kambarys ir jūs galite patekti į daugiau nei vieną. Būtinai pasirinkite tinkamą.';
$string['view_login_moderator'] = 'Prisijungiama kaip moderatorius...';
$string['view_login_viewer'] = 'Prisijungiama kaip klausytojas...';
$string['view_message_and'] = 'ir';
$string['view_message_conference_has_ended'] = 'Sesija baigėsi.';
$string['view_message_conference_in_progress'] = 'Sesija vyksta.';
$string['view_message_conference_not_started'] = 'Sesija dar neprasidėjo.';
$string['view_message_conference_room_ready'] = 'Šis kambarys yra paruoštas. Jau dabar galite prisijungti prie sesijos.';
$string['view_message_conference_user_limit_reached'] = 'Pasiektas seanso metu leidžiamas naudotojų skaičius.';
$string['view_message_conference_wait_for_moderator'] = 'Laukiama kol prisijungs moderatorius.';
$string['view_message_cron_disabled'] = 'Įrašų sąrašas gali būti neatnaujintas. Susisiekite su svetainės administratoriumi ir nurodykite šią informaciją: {$a}';
$string['view_message_finished'] = 'Veikla baigėsi.';
$string['view_message_has_joined'] = 'prisijungė';
$string['view_message_have_joined'] = 'prisijungė';
$string['view_message_hour'] = 'valanda';
$string['view_message_hours'] = 'valandos';
$string['view_message_importrecordings_disabled'] = 'Įrašymo nuorodų importavimas serveryje išjungtas.';
$string['view_message_minute'] = 'minutė';
$string['view_message_minutes'] = 'minutės';
$string['view_message_moderator'] = 'Moderatorius';
$string['view_message_moderators'] = 'Moderatoriai';
$string['view_message_norecordings'] = 'Įrašų nėra.';
$string['view_message_notavailableyet'] = 'Ši sesija dar negalima.';
$string['view_message_recordings_disabled'] = 'Įrašai serveryje išjungti. „BigBlueButton“ veikla, kurios tipas yra „Tik įrašai“, negali būti naudojama.';
$string['view_message_room_closed'] = 'Kambarys uždarytas.';
$string['view_message_room_open'] = 'Kambarys atidarytas.';
$string['view_message_room_ready'] = 'Kambarys paruoštas';
$string['view_message_session_for'] = 'sesija';
$string['view_message_session_has_user'] = 'Yra';
$string['view_message_session_has_users'] = 'Yra';
$string['view_message_session_no_users'] = 'Nėra naudotojų šioje sesijoje';
$string['view_message_session_running_for'] = 'Sesija vykdoma';
$string['view_message_session_started_at'] = 'Sesija prasidėjo';
$string['view_message_tab_close'] = 'Šį skirtuką / langą reikia uždaryti rankiniu būdu';
$string['view_message_times'] = 'laikai';
$string['view_message_user'] = 'Naudotojas';
$string['view_message_users'] = 'Naudotojai';
$string['view_message_viewer'] = 'Klausytojas';
$string['view_message_viewers'] = 'Klausytojai';
$string['view_mobile_message_groups_not_supported'] = 'Šis egzempliorius įgalintas dirbti su grupėmis, tačiau programa mobiliesiems to dar nepalaiko. Naudokite interneto versiją.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Šiame puslapyje viršijote 45 sekundes. Norėdami prisijungti prie sesijos, atnaujinkite puslapį.';
$string['view_noguests'] = 'BigBlueButton kambarys nėra atviras svečiams.';
$string['view_nojoin'] = 'Neturite vaidmens, kuriam leista prisijungti prie šios sesijos.';
$string['view_recording'] = 'įrašą';
$string['view_recording_actionbar'] = 'Įrankiai';
$string['view_recording_activity'] = 'Veikla';
$string['view_recording_button_import'] = 'Importuoti įrašo nuorodas';
$string['view_recording_button_return'] = 'Grįžti atgal';
$string['view_recording_course'] = 'Kursas';
$string['view_recording_date'] = 'Data';
$string['view_recording_delete_confirmation'] = 'Ar tikrai norite ištrinti {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Šis įrašas turi {$a} nuorodų, kurios buvo importuotos į skirtingus kursus ar veiklą. Jei įrašas bus ištrintas, šios nuorodos taip pat bus pašalintos.';
$string['view_recording_delete_confirmation_warning_s'] = 'Šis įrašas susietas su {$a} nuoroda, kuri buvo importuota į kitą kursą ar veiklą. Jei įrašas bus ištrintas, ši nuoroda taip pat bus pašalinta.';
$string['view_recording_description'] = 'Aprašymas';
$string['view_recording_description_edithint'] = 'Gali būti pridėtas aprašas, padedantis atpažinti įrašą.';
$string['view_recording_description_editlabel'] = 'Redaguoti aprašymą';
$string['view_recording_duration'] = 'Trukmė';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Šio įrašo formato URL nepasiekiamas.';
$string['view_recording_format_notes'] = 'Pastabos';
$string['view_recording_format_podcast'] = 'Podcast\'as';
$string['view_recording_format_presentation'] = 'Įrašas';
$string['view_recording_format_screenshare'] = 'Ekrano bendrinimas';
$string['view_recording_format_statistics'] = 'Statistika';
$string['view_recording_format_video'] = 'Vaizdo įrašas';
$string['view_recording_import_confirmation'] = 'Ar tikrai norite importuoti šį įrašą?';
$string['view_recording_length'] = 'Ilgis';
$string['view_recording_link'] = 'importuota nuoroda';
$string['view_recording_link_warning'] = 'Tai nuoroda, nukreipianti į įrašą, sukurtą atliekant kitą kursą ar veiklą.';
$string['view_recording_list_action_delete'] = 'Naikinama';
$string['view_recording_list_action_edit'] = 'Atnaujinama';
$string['view_recording_list_action_play'] = 'Groti';
$string['view_recording_list_action_process'] = 'Apdorojimas';
$string['view_recording_list_action_protect'] = 'Apsauga';
$string['view_recording_list_action_publish'] = 'Publikavimas';
$string['view_recording_list_action_unprotect'] = 'Apsaugos atšaukimas';
$string['view_recording_list_action_unpublish'] = 'Paskelbimo atšaukimas';
$string['view_recording_list_action_update'] = 'Atnaujinama';
$string['view_recording_list_actionbar'] = 'Įrankiai';
$string['view_recording_list_actionbar_delete'] = 'Trinti';
$string['view_recording_list_actionbar_edit'] = 'Redaguoti';
$string['view_recording_list_actionbar_hide'] = 'Slėpti';
$string['view_recording_list_actionbar_import'] = 'Importuoti';
$string['view_recording_list_actionbar_protect'] = 'Padaryti privačiu';
$string['view_recording_list_actionbar_publish'] = 'Paskelbti';
$string['view_recording_list_actionbar_show'] = 'Rodyti';
$string['view_recording_list_actionbar_unprotect'] = 'Padaryti viešu';
$string['view_recording_list_actionbar_unpublish'] = 'Atšaukti paskelbimą';
$string['view_recording_list_activity'] = 'Veikla';
$string['view_recording_list_course'] = 'Kursas';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Aprašymas';
$string['view_recording_list_duration'] = 'Trukmė';
$string['view_recording_list_recording'] = 'Įrašas';
$string['view_recording_meeting'] = 'Susitikimas';
$string['view_recording_modal_button'] = 'Taikyti';
$string['view_recording_modal_title'] = 'Nustatyti įrašymo reikšmes';
$string['view_recording_name'] = 'Pavadinimas';
$string['view_recording_name_edithint'] = 'Gali būti pridėtas pavadinimas, kad būtų lengviau atpažinti įrašą.';
$string['view_recording_name_editlabel'] = 'Redaguoti pavadinimą';
$string['view_recording_playback'] = 'Įrašai';
$string['view_recording_preview'] = 'Peržiūra';
$string['view_recording_preview_help'] = 'Užveskite pelės žymeklį virš paveiksliuko, kad peržiūrėtumėte jį visu dydžiu';
$string['view_recording_protect_confirmation'] = 'Ar tikrai norite apsaugoti šį {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Šis įrašas turi {$a} nuorodų, kurios buvo importuotos į skirtingus kursus ar veiklą. Jei įrašas apsaugotas, tai taip pat turės įtakos importuotoms nuorodoms.';
$string['view_recording_protect_confirmation_warning_s'] = 'Šis įrašas susietas su {$a} nuoroda, kuri buvo importuota į kitą kursą ar veiklą. Jei įrašas apsaugotas, tai taip pat turės įtakos importuotoms nuorodoms.';
$string['view_recording_publish_confirmation'] = 'Ar tikrai norite paskelbti šį {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Šis įrašas turi {$a} nuorodų, kurios buvo importuotos į skirtingus kursus ar veiklą. Jei įrašas bus paskelbtas, šios nuorodos taip pat bus paskelbtos.';
$string['view_recording_publish_confirmation_warning_s'] = 'Šis įrašas susietas su {$a} nuoroda, kuri buvo importuota į kitą kursą ar veiklą. Jei įrašas bus paskelbtas, ši nuoroda taip pat bus paskelbta.';
$string['view_recording_publish_link_deleted'] = 'Šios nuorodos negalima paskelbti iš naujo, nes originalaus įrašo BigBlueButton serveryje nėra. Nuoroda turėtų būti pašalinta.';
$string['view_recording_publish_link_not_published'] = 'Šios nuorodos negalima paskelbti iš naujo, nes pradinis įrašas nebepublikuojamas.';
$string['view_recording_recording'] = 'Įrašoma';
$string['view_recording_select_course'] = 'Pirmiausia iškrentančiame meniu pasirinkite kursą';
$string['view_recording_tags'] = 'Žymos';
$string['view_recording_unprotect_confirmation'] = 'Ar tikrai norite panaikinti šio {$a} apsaugą?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Šis įrašas turi {$a} nuorodų, kurios buvo importuotos į skirtingus kursus ar veiklą. Jei įrašas neapsaugotas, jtai taip pat turės įtakos importuotoms nuorodoms.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Šis įrašas susietas su {$a} nuoroda, kuri buvo importuota į kitą kursą ar veiklą. Jei įrašas neapsaugotas, tai taip pat turės įtakos importuotoms nuorodoms.';
$string['view_recording_unprotect_link_deleted'] = 'Šios nuorodos negalima neapsaugoti, nes originalaus įrašo nėra BigBlueButton serveryje. Nuoroda turėtų būti pašalinta.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Ši nuoroda negali būti neapsaugota, nes originalus įrašas yra apsaugotas.';
$string['view_recording_unpublish_confirmation'] = 'Ar tikrai atšaukti šio {$a} paskelbimą?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Šis įrašas turi {$a} nuorodų, kurios buvo importuotos į skirtingus kursus ar veiklą. Jei įrašas neskelbiamas, šios nuorodos taip pat bus neskelbiamos.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Šis įrašas susietas su {$a} nuoroda, kuri buvo importuota į kitą kursą ar veiklą. Jei įrašas bus nebeskelbiamas, ši nuoroda taip pat bus nebeskelbiama.';
$string['view_recording_yui_first'] = 'Pirmas';
$string['view_recording_yui_go'] = 'Eiti';
$string['view_recording_yui_last'] = 'Paskutinis';
$string['view_recording_yui_next'] = 'Sekantis';
$string['view_recording_yui_page'] = 'Puslapis';
$string['view_recording_yui_prev'] = 'Ankstesnis';
$string['view_recording_yui_rows'] = 'Eilutės';
$string['view_recording_yui_show_all'] = 'Rodyti viską';
$string['view_room'] = 'Peržiūrėti kambarį';
$string['view_section_title_presentation'] = 'Pristatymo failas';
$string['view_section_title_recordings'] = 'Įrašai';
$string['view_warning_default_server'] = 'Šioje svetainėje naudojama <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank"> nemokama BigBlueButton paslauga, skirta Moodle (atidaroma naujame lange)</a>, teikiama Blindside Networks su šiais apribojimais:
<ol>
<li>Didžiausia kiekvienos sesijos trukmė yra 60 minučių</li>
<li>Didžiausias vienu metu esančių seanse naudotojų skaičius yra 25</li>
<li>Įrašai baigiasi po septynių (7) dienų ir jų negalima atsisiųsti</li>
<li>Besimokančiųjų internetines kameras mato tik moderatorius.</li>
</ol>';
$string['waitformoderator'] = 'Laukiama, kol prisijungs moderatorius.';
