<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'lt', version '4.3'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'ruošiamasi diegti';
$string['accept'] = 'Priimti';
$string['action'] = 'Veiksmas';
$string['actionchoice'] = 'Ką norėtumėte daryti su šiuo failu \'{$a}\'?';
$string['actions'] = 'Veiksmai';
$string['actionsfor'] = 'Veiksmas {$a}';
$string['actionsmenu'] = 'Veiksmų meniu';
$string['active'] = 'Aktyvu';
$string['activeusers'] = 'Aktyvieji naudotojai';
$string['activities'] = 'Veiklos';
$string['activities_help'] = 'Veiklos, pvz., forumai, apklausos ir vikiai, leidžia į kursus įtraukti interaktyviojo turinio.';
$string['activity'] = 'Veikla';
$string['activityclipboard'] = 'Perkeliama ši veikla: <b>{$a}</b>';
$string['activityheader'] = 'Veiklos meniu';
$string['activityicon'] = '{$a} piktograma';
$string['activityiscurrentlyhidden'] = 'Atsiprašome, bet ši veikla šiuo metu paslėpta';
$string['activitymodule'] = 'Veiklos modulis';
$string['activitymodules'] = 'Veiklos moduliai';
$string['activitynotready'] = 'Veikla dar neparengta';
$string['activityreport'] = 'Veiklos ataskaita';
$string['activityreports'] = 'Veiklos ataskaitos';
$string['activityselect'] = 'Pasirinkite šią veiklą - ji vėliau bus perkelta kitur';
$string['activitysince'] = 'Veikla nuo {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Naudotojo veikla';
$string['add'] = 'Įtraukti';
$string['addactivity'] = 'Įtraukti veiklą...';
$string['addactivitytosection'] = 'Įtraukti veiklą  \'{$a}\' sekcijoje';
$string['addadmin'] = 'Įtraukti administratorių';
$string['addblock'] = 'Įtraukti bloką';
$string['addcomment'] = 'Įtraukti komentarą...';
$string['addcondition'] = 'Įtraukti sąlygą';
$string['addcountertousername'] = 'Sukurti naudotoją pridedant numerį  prie naudotojo vardo';
$string['addcreator'] = 'Įtraukti kursų kūrėją';
$string['adddots'] = 'Įtraukti...';
$string['added'] = 'Įtraukta {$a}';
$string['addedtogroup'] = 'Įtraukta (-as) į grupę {$a}';
$string['addedtogroupnot'] = 'Neįtraukta (-as) į grupę {$a}';
$string['addedtogroupnotenrolled'] = 'Neįtraukta (-as) į grupę {$a}, nes neužregistruota (-as) klausyti kursų';
$string['addfilehere'] = 'Nuvilkite failus čia, kad pridėtumėte juos šio skyriaus apačioje';
$string['addinganew'] = 'Įtraukiama (-as) nauja (-as) „{$a}“';
$string['addinganewto'] = 'Įtraukiama (-as) nauja (-as) „{$a->what}“ į „{$a->to}“ dalį.';
$string['addingdatatoexisting'] = 'Įtraukiami duomenys';
$string['additionalcustomnav'] = 'Papildoma pasirinktinė navigacija';
$string['additionalnames'] = 'Papildomi pavadinimai';
$string['addlinkhere'] = 'Pridėti nuorodą';
$string['addnew'] = 'Įtraukti naują  {$a}';
$string['addnewcategory'] = 'Įtraukti naują kategoriją';
$string['addnewcourse'] = 'Įtraukti naują kursą';
$string['addnewuser'] = 'Įtraukti naują naudotoją';
$string['addnousersrecip'] = 'Įtraukti naudotojus, kurie nesinaudojo {$a} prie gavėjų sąrašo';
$string['addpagehere'] = 'Pridėti tekstą čia';
$string['addresource'] = 'Įtraukti išteklių...';
$string['addresourceoractivity'] = 'Įtraukti veiklą arba išteklių';
$string['addresourcetosection'] = 'Įtraukti išteklius į sekciją \'{$a}';
$string['address'] = 'Adresas';
$string['addsections'] = 'Įtraukti sekciją';
$string['addstudent'] = 'Įtraukti besimokantįjį';
$string['addsubcategory'] = 'Įtraukti antrinę kategoriją';
$string['addteacher'] = 'Įtraukti dėstytoją';
$string['admin'] = 'Administratorius';
$string['adminhelpaddnewuser'] = 'Rankiniu būdu sukurti naują naudotojo paskyrą';
$string['adminhelpassignadmins'] = 'Šioje svetainėje administratoriai  gali daryti ką nori ir eiti kur nori';
$string['adminhelpassigncreators'] = 'Kursų kūrėjai gali kurti naujus kursus';
$string['adminhelpassignsiteroles'] = 'Taikyti apibrėžtus svetainės vaidmenis konkretiems naudotojams';
$string['adminhelpassignstudents'] = 'Eikite į kursus ir įtraukite besimokančiuojus iš administratoriaus meniu';
$string['adminhelpauthentication'] = 'Galite naudoti vidines naudotojų paskyras arba išorines duomenų bazes';
$string['adminhelpbackup'] = 'Konfigūruokite automatinį atsarginių kopijų kūrimą ir jų grafiką';
$string['adminhelpconfiguration'] = 'Konfigūruokite svetainės išvaizdą ir veikimą';
$string['adminhelpconfigvariables'] = 'Konfigūruokite kintamuosius, turinčius įtakos bendrai svetainės veiklai';
$string['adminhelpcourses'] = 'Apibrėžkite kursus bei kategorijas ir priskirkite žmones, redaguokite laukiančius kursus';
$string['adminhelpeditorsettings'] = 'Apibrėžkite pagrindinius HTML rengyklės parametrus';
$string['adminhelpedituser'] = 'Naršykite po naudotojų paskyrų sąrašą ir redaguokite bet kurį iš jų';
$string['adminhelpenvironment'] = 'Patikrinkite, ar jūsų serveris atitinka esamus ir būsimus diegimo reikalavimus';
$string['adminhelpfailurelogs'] = 'Peržiūrėkite nepavykusio prisijungimo žurnalus';
$string['adminhelplanguage'] = 'Skirta kalbos paketui tikrinti ir redaguoti';
$string['adminhelplogs'] = 'Šioje svetainėje naršykite visos veiklos žurnalus';
$string['adminhelpmanageblocks'] = 'Valdykite įdiegtus blokus ir jų parametrus';
$string['adminhelpmanagedatabase'] = 'Tiesiogiai pasiekite duomenų bazę (būkite atsargūs)';
$string['adminhelpmanagefilters'] = 'Pasirinkite teksto filtrus ir kitus susijusius parametrus';
$string['adminhelpmanagemodules'] = 'Valdykite įdiegtus modulius ir jų parametrus';
$string['adminhelpmanageroles'] = 'Kurkite ir apibrėžkite vaidmenis, kuriuos galima taikyti naudotojams';
$string['adminhelpmymoodle'] = 'Konfigūruokite Mano „Moodle“ blokus, skirtus naudotojams';
$string['adminhelpreports'] = 'Svetainės lygio ataskaitos';
$string['adminhelpsitefiles'] = 'Skirta bendriesiems failams publikuoti ar išorinėms atsarginėms kopijoms įkelti';
$string['adminhelpsitesettings'] = 'Nustatykite, kaip atrodys svetainės pagrindinis puslapis';
$string['adminhelpstickyblocks'] = 'Konfigūruokite „Moodle“ nejudriuosius blokus';
$string['adminhelpthemes'] = 'Pasirinkite, kaip atrodys svetainė (spalva, šriftas ir kt.)';
$string['adminhelpuploadusers'] = 'Įkelkite naujas naudotojų paskyras iš tekstinio failo';
$string['adminhelpusers'] = 'Apibrėžkite savo naudotojus ir nustatykite autentifikavimą';
$string['adminhelpxmldbeditor'] = 'Sąsaja XMLDB failams redaguoti. Skirta tik programų kūrėjams.';
$string['administration'] = 'Valdymas';
$string['administrationsite'] = 'Administravimas';
$string['administrator'] = 'Administratorius';
$string['administratordescription'] = 'Paprastai administratoriai gali visuose svetainės kursuose daryti tai, ką nori.';
$string['administrators'] = 'Administratoriai';
$string['administratorsall'] = 'Visi administratoriai';
$string['administratorsandteachers'] = 'Administratoriai ir dėstytojai';
$string['advanced'] = 'Papildomai';
$string['advancedfilter'] = 'Išplėstinė paieška';
$string['advancedsettings'] = 'Išplėstiniai parametrai';
$string['afterresource'] = 'Po resurso "{$a}"';
$string['aftersection'] = 'Po sekcijos "{$a}"';
$string['again'] = 'vėl';
$string['agelocationverification'] = 'Amžiaus ir vietovės patvirtinimas';
$string['ajaxuse'] = 'AJAX ir „Javascript“';
$string['all'] = 'Viskas';
$string['allactions'] = 'Visi veiksmai';
$string['allactivities'] = 'Visos veiklos';
$string['allcategories'] = 'Visos kategorijos';
$string['allchanges'] = 'Visi pakeitimai';
$string['alldays'] = 'Visos dienos';
$string['allfiles'] = 'Visi failai';
$string['allgroups'] = 'Visos grupės';
$string['alllogs'] = 'Visi žurnalai';
$string['allmods'] = 'Visi {$a}';
$string['allow'] = 'Leisti';
$string['allowinternal'] = 'Leisti ir vidinius metodus';
$string['allownone'] = 'Neleisti nieko';
$string['allownot'] = 'Neleisti';
$string['allowstealthmodules'] = 'Leisti slaptas veiklas';
$string['allowstealthmodules_help'] = 'Jei įjungta, veiklos gali būti prieinamos, bet nerodomos matomose kurso puslapio sekcijose. Taip pat, nuorodos į slaptas veiklas turi būti nurodytos iš kitur, pavyzdžiui,  puslapio šaltinyje. Slaptos veiklos vis dar yra rodomos Įvertinimų knygelėje ir kitose ataskaitose.';
$string['allparticipants'] = 'Visi dalyviai';
$string['allteachers'] = 'Visi dėstytojai';
$string['alphanumerical'] = 'Gali būti sudaryta tik iš raidžių ir skaičių, brūkšnelio (-) arba taško (.)';
$string['alreadyconfirmed'] = 'Registracija jau patvirtinta';
$string['alternatename'] = 'Alternatyvus pavadinimas';
$string['always'] = 'Visada';
$string['and'] = '{$a->one} ir {$a->two}';
$string['answer'] = 'Atsakymas';
$string['any'] = 'Bet kas';
$string['appearance'] = 'Išvaizda';
$string['apply'] = 'Taikyti';
$string['applyfilters'] = 'Filtruoti';
$string['approve'] = 'Patvirtinti';
$string['areyousure'] = 'Ar Jūs tikras?';
$string['areyousuretorestorethis'] = 'Ar norite tęsti?';
$string['areyousuretorestorethisinfo'] = 'Vėliau galėsite pasirinkti įtraukti šią atsarginę kopiją į jau esamus kursus arba sukurti visiškai naujus kursus.';
$string['asc'] = 'Didėjimo tvarka';
$string['assessment'] = 'Vertinimas';
$string['assignadmins'] = 'Priskirti administratorius';
$string['assigncreators'] = 'Priskirti kūrėjus';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Priskirti visos svetainės vaidmenis';
$string['authenticateduser'] = 'Autentifikuotas naudotojas';
$string['authenticateduserdescription'] = 'Visi prisijungę naudotojai.';
$string['authentication'] = 'Autentifikavimas';
$string['authenticationplugins'] = 'Autentifikavimo papildiniai';
$string['autosubscribe'] = 'Automatinis forumo prenumeravimas';
$string['autosubscribeno'] = 'Ne: automatiškai neprenumeruoti diskusijų';
$string['autosubscribeyes'] = 'Taip: prenumeruoti forumą, kuriame paskelbiu diskusiją';
$string['availability'] = 'Pasiekiamumas';
$string['availablecourses'] = 'Kursai';
$string['back'] = 'Grįžti';
$string['backto'] = 'Grįžti į {$a}';
$string['backtocourselisting'] = 'Grįžti į kursų sąrašą';
$string['backtohome'] = 'Grįžti į pagrindinį';
$string['backtopageyouwereon'] = 'Grįžti į ankstesnį puslapį';
$string['backup'] = 'Atsarginis kopijavimas';
$string['backupactivehelp'] = 'Pasirinkite, ar turi būti automatiškai atliekamas atsarginis kopijavimas.';
$string['backupadhocpending'] = 'Laukiama kurso atsarginės kopijos ad hoc užduoties';
$string['backupcancelled'] = 'Atsarginis kopijavimas atšauktas';
$string['backupcoursefileshelp'] = 'Jei įjungta, kursų failai bus įtraukiami į automatines atsargines kopijas';
$string['backupdate'] = 'Atsarginės kopijos data';
$string['backupdatenew'] = '&nbsp; {$a->TAG} yra dabar {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} buvo {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} – {$a->recordname}<br />';
$string['backupdetails'] = 'Išsami atsarginės kopijos informacija';
$string['backuperrorinvaliddestination'] = 'Atsarginės kopijos aplankas neegzistuoja arba nėra įrašomas.';
$string['backupexecuteathelp'] = 'Pasirinkite, kada turi būti vykdomas atsarginis kopijavimas.';
$string['backupfailed'] = 'Kai kurie jūsų kursai nebuvo įrašyti!';
$string['backupfilename'] = 'atsarginė kopija';
$string['backupfinished'] = 'Sėkmingai baigtas atsarginis kopijavimas';
$string['backupfromthissite'] = 'Ar buvo atliktas šios svetainės atsarginis kopijavimas?';
$string['backupgradebookhistoryhelp'] = 'Jei įjungta, tai įvertinimų knygelės istorija bus įtraukta į automatines atsargines kopijas. Atkreipkite dėmesį, kad įvertinimų knygelės istorija turi būti įjungta serverio parametruose.';
$string['backupincludemoduleshelp'] = 'Pasirinkite, ar į automatines atsargines kopijas norite įtraukti kursų modulius (su naudotojų duomenimis ar be jų).';
$string['backupincludemoduleuserdatahelp'] = 'Pasirinkite, ar į automatines atsargines kopijas norite įtraukti modulių naudotojų duomenis.';
$string['backuplogdetailed'] = 'Išsamus vykdymo žurnalas';
$string['backuploglaststatus'] = 'Naujausias vykdymo žurnalas';
$string['backupmissinguserinfoperms'] = 'Pastaba: šioje atsarginėje kopijoje nėra naudotojų duomenų. Pratimų ir seminarų veiklos nebus įtrauktos į atsarginę kopiją, nes šie moduliai nesuderinami su tokio tipo atsarginiu kopijavimu.';
$string['backupnext'] = 'Paskesnė atsarginė kopija';
$string['backupnonisowarning'] = 'Įspėjimas: ši atsarginė kopija yra iš ne Unicode Moodle versijos (iki 1.6). Jei šioje atsarginėje kopijoje yra ne ISO-8859-1 tekstų, jie gali būti SUGADINTI, jei bandysite juos atkurti šioje Unicode Moodle versijoje. Daugiau informacijos apie tai, kaip tinkamai atkurti šią atsarginę kopiją, rasite <a href="https://docs.moodle.org/en/Backup_FAQ">DUK apie atsarginę kopiją</a>.';
$string['backupnotyetrun'] = 'Automatizuota atsarginė kopiją laukiama';
$string['backuporiginalname'] = 'Atsarginės kopijos pavadinimas';
$string['backuproleassignments'] = 'Šių vaidmenų atsarginių kopijų vaidmens priskyrimas';
$string['backupsavetohelp'] = 'Visas kelias į katalogą, kuriame norite išsaugoti atsargines kopijas';
$string['backupsitefileshelp'] = 'Jei įjungta, kursuose naudojami svetainės failai bus įtraukiami į automatines atsargines kopijas';
$string['backuptakealook'] = 'Peržiūrėkite savo atsarginio kopijavimo žurnalus: {$a}';
$string['backupuserfileshelp'] = 'Pasirinkite, ar naudotojų failai (pvz., profilių atvaizdai), turi būti įtraukiami į automatines atsargines kopijas';
$string['backupversion'] = 'Atsarginės kopijos versija';
$string['badges'] = 'Pasiekimai';
$string['block'] = 'Blokas';
$string['blockconfiga'] = 'Konfigūruojamas {$a} blokas';
$string['blockconfigbad'] = 'Šis blokas buvo netinkamai įdiegtas, todėl negali būti pateikta konfigūravimo sąsaja.';
$string['blocks'] = 'Blokai';
$string['blocksaddedit'] = 'Įtraukti / redaguoti blokus';
$string['blockseditoff'] = 'Išjungti blokų redagavimą';
$string['blocksediton'] = 'Įjungti blokų redagavimą';
$string['blocksetup'] = 'Nustatomos blokų lentelės';
$string['blocksuccess'] = '{$a} lentelės buvo sėkmingai nustatytos';
$string['brief'] = 'Trumpai';
$string['bulkactions'] = 'Masiniai veiksmai';
$string['bulkactionselect'] = '{$a} masinio veiksmo pasirinkimas';
$string['bulkcancel'] = 'Uždaryti masinį redagavimą';
$string['bulkmovecoursessuccess'] = 'Sėkmingai perkelti {$a->courses} kursai į {$a->category}';
$string['bulkselection'] = '{$a} pasirinkta';
$string['bycourseorder'] = 'Pagal kursų eilės tvarką';
$string['byname'] = 'pagal {$a}';
$string['bypassed'] = 'Apeita';
$string['cachecontrols'] = 'Talpyklos valdikliai';
$string['calltofeedback'] = 'Šios programinės įrangos kūrėjai norėtų jūsų atsiliepimų.';
$string['calltofeedback_give'] = 'Pateikti atsiliepimą apie šią programinę įrangą';
$string['calltofeedback_remind'] = 'Priminti vėliau';
$string['cancel'] = 'Atšaukti';
$string['cancelled'] = 'Atšaukta';
$string['categories'] = 'Kursų kategorijos';
$string['categoriesandcourses'] = 'Kursų kategorijos ir kursai';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Кategorija {$a} buvo įtraukta';
$string['categorybulkaction'] = 'Masiniai veiksmai pasirinktoms kategorijoms';
$string['categorycontents'] = 'Antrinės kategorijos ir kursai';
$string['categorycurrentcontents'] = '{$a} turinys';
$string['categorydeleted'] = 'Kategorija {$a} buvo panaikinta';
$string['categoryduplicate'] = 'Kategorija, kurios pavadinimas {$a}, jau yra';
$string['categoryheader'] = 'Kategorijos meniu';
$string['categoryhidden'] = '(paslėpta)';
$string['categorymodifiedcancel'] = 'Kategorija buvo modifikuota. Atšaukite ir bandykite dar kartą.';
$string['categoryname'] = 'Kategorijos pavadinimas';
$string['categorypath'] = 'Kategorijos kelias';
$string['categorysubcategoryof'] = '{$a->category} - subkategorija {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorija {$a} buvo atnaujinta';
$string['changedpassword'] = 'Slaptažodis pakeistas';
$string['changepassword'] = 'Pakeisti slaptažodį';
$string['changesmade'] = 'Pakeitimai atlikti';
$string['changesmadereallygoaway'] = 'Jūs padarėte pakeitimus. Ar Jūs tikras, kad norite palikti šį puslapį ir prarasti juos?';
$string['changessaved'] = 'Pakeitimai įrašyti';
$string['check'] = 'Tikrinti';
$string['checkactual'] = 'Faktinis';
$string['checkall'] = 'Tikrinti viską';
$string['checkexpected'] = 'Laukiamas';
$string['checkingbackup'] = 'Tikrinama atsarginė kopija';
$string['checkingcourse'] = 'Tikrinami kursai';
$string['checkingforbbexport'] = 'Tikrinamas „Blackboard“ eksportas';
$string['checkinginstances'] = 'Tikrinami egzemplioriai';
$string['checkingsections'] = 'Tikrinami skyriai';
$string['checklanguage'] = 'Tikrinti kalbą';
$string['checknone'] = 'Nieko netikrinti';
$string['checks'] = 'Patikros';
$string['checksok'] = 'Visi \'{$a}\' patikrinimai yra GERI';
$string['childcoursenotfound'] = 'Nerasti antriniai kursai';
$string['childcourses'] = 'Antriniai kursai';
$string['choose'] = 'Pasirinkite';
$string['choosecourse'] = 'Pasirinkite kursus';
$string['choosedots'] = 'Pasirinkite...';
$string['chooselivelogs'] = 'Arba stebėkite dabartinę veiklą';
$string['chooselogs'] = 'Pasirinkite, kuriuos žurnalus norite matyti';
$string['choosereportfilter'] = 'Pasirinkite ataskaitos filtrą';
$string['choosetheme'] = 'Parinkti temą';
$string['chooseuser'] = 'Pasirinkite naudotoją';
$string['city'] = 'Miestas / miestelis';
$string['cleaningtempdata'] = 'Valomi laikinieji duomenys';
$string['clear'] = 'Valyti';
$string['clearfilterrow'] = 'Pašalinti filtrų eilutę';
$string['clearfilters'] = 'Išvalyti filtrus';
$string['clearsearch'] = 'Išvalyti paieškos įvestį';
$string['clickhelpiconformoreinfo'] = '.. tęsiasi... Spustelėkite žinyno piktogramą, kad galėtumėte skaityti visą straipsnį.';
$string['clickhere'] = 'Spustelėkite čia...';
$string['clicktochangeinbrackets'] = '{$a} (Spauskite kad pakeisti)';
$string['clicktohideshow'] = 'Spustelėkite, kad išplėstumėte ar sutrauktumėte';
$string['closeblockdrawer'] = 'Uždaryti blokus';
$string['closebuttontitle'] = 'Uždaryti';
$string['closecourseindex'] = 'Užverti kurso rodyklę';
$string['closedrawer'] = 'Uždaryti blokus';
$string['closewindow'] = 'Uždaryti šį langą';
$string['collapse'] = 'Sutraukti';
$string['collapseall'] = 'Sutraukti viską';
$string['collapsecategory'] = 'Sutraukti {$a}';
$string['comebacklater'] = 'Grįžkite vėliau.';
$string['commentincontext'] = 'Rasti šį komentarą kontekste';
$string['comments'] = 'Komentarai';
$string['commentscount'] = 'Komentarai ({$a})';
$string['commentsnotenabled'] = 'Komentavimo galimybė neįgalinta';
$string['commentsrequirelogin'] = 'Norėdami peržiūrėti komentarus, turite prisijungti.';
$string['comparelanguage'] = 'Palyginti ir redaguoti esamą kalbą';
$string['complete'] = 'Baigta';
$string['completed'] = 'Baigta';
$string['completereport'] = 'Išsami ataskaita';
$string['configuration'] = 'Konfigūracija';
$string['confirm'] = 'Patvirtinti';
$string['confirmcheckfull'] = 'Ar esate visiškai tikri, kad norite patvirtinti {$a}?';
$string['confirmcoursemove'] = 'Ar Jūs tikras, kad norite perkelti šį kursą ({$a->course}) į šią kategoriją ({$a->category})?';
$string['confirmdeletesection'] = 'Ar esate visiškai tikras, kad norite visiškai panaikinti "{$a}" ir visas veiklas, esančias joje?';
$string['confirmed'] = 'Jūsų registracija patvirtinta';
$string['confirmednot'] = 'Jūsų registracija dar nepatvirtinta. Prašome ieškoti patvirtinimo laiško el. pašto dėžutėje.';
$string['considereddigitalminor'] = 'Esate per jaunas, kad galėtumėte sukurti paskyrą šioje svetainėje.';
$string['content'] = 'Turinys';
$string['contentbank'] = 'Interaktyvaus turinio bankas';
$string['contentexport_aboutthiscourse'] = 'Kurso santrauka';
$string['contentexport_coursesummary'] = 'Šis failas yra turinio, atsisiųsto iš <a href="{$a->courselink}">{$a->coursename}</a>, dalis.';
$string['contentexport_footersummary'] = 'Šis failas yra dalis turinio, atsisiųsto iš <a href="{$a->courselink}">{$a->coursename}</a>, kurį {$a->userfullname} atsisiuntė {$a->data}.';
$string['contentexport_modulesummary'] = 'Šis puslapis yra turinio dalis, atsisiųsta iš <a href="{$a->modulelink}">{$a->modulename}</a> {$a->date}. Atminkite, kad tam tikras turinys ir bet kokie failai, didesni nei {$a->maxfilesize}, neatsisiunčiami.';
$string['contentexport_viewfilename'] = 'Peržiūrėti failą {$a}';
$string['context'] = 'Kontekstas';
$string['contextlevel'] = 'Konteksto lygmuo';
$string['contextname'] = 'Konteksto pavadinimas';
$string['contextparent'] = 'Šakninis';
$string['contexturl'] = 'Koteksto URL';
$string['continue'] = 'Tęsti';
$string['continuetocourse'] = 'Spustelėkite čia, kad įvestumėte kursus';
$string['convertingwikitomarkdown'] = 'Vikis konvertuojamas į „Markdown“ formatą';
$string['cookiesenabled'] = 'Naršyklėje turi būti įjungti slapukai';
$string['cookiesenabled_help'] = 'Šioje svetainėje naudojami du slapukai:

Svarbiausias yra seanso slapukas, paprastai vadinamas MoodleSession. Turite leisti šį slapuką savo naršyklėje, kad būtų užtikrintas tęstinumas ir naršant svetainėje liktumėte prisijungę. Kai atsijungiate arba uždarote naršyklę, šis slapukas sunaikinamas (jūsų naršyklėje ir serveryje).

Kitas slapukas skirtas tik patogumui, paprastai vadinamas MOODLEID ar panašiai. Jis tiesiog prisimena jūsų naudotojo vardą naršyklėje. Tai reiškia, kad jums sugrįžus į šią svetainę prisijungimo puslapyje esantis naudotojo vardo laukas jau yra užpildytas už jus. Atsisakyti šio slapuko yra saugu – kiekvieną kartą prisijungdami turėsite iš naujo įvesti savo naudotojo vardą.';
$string['cookiesenabled_help_html'] = 'Šioje svetainėje naudojami du slapukai: <br/><br/>

Svarbiausias yra seanso slapukas, paprastai vadinamas MoodleSession. Turite leisti šį slapuką savo naršyklėje, kad būtų užtikrintas tęstinumas ir naršant svetainėje liktumėte prisijungę. Kai atsijungiate arba uždarote naršyklę, šis slapukas sunaikinamas (jūsų naršyklėje ir serveryje).
<br/><br/>

Kitas slapukas skirtas tik patogumui, paprastai vadinamas MOODLEID ar panašiai. Jis tiesiog prisimena jūsų naudotojo vardą naršyklėje. Tai reiškia, kad jums sugrįžus į šią svetainę prisijungimo puslapyje esantis naudotojo vardo laukas jau yra užpildytas už jus. Atsisakyti šio slapuko yra saugu – kiekvieną kartą prisijungdami turėsite iš naujo įvesti savo naudotojo vardą.';
$string['cookiesenabledonlysession'] = 'Naršyklėje turi būti įjungti slapukai';
$string['cookiesenabledonlysession_help'] = 'Šioje svetainėje naudojamas vienas seanso slapukas, paprastai vadinamas MoodleSession. Turite leisti šį slapuką savo naršyklėje, kad būtų užtikrintas tęstinumas ir naršant svetainėje liktumėte prisijungę. Kai atsijungiate arba uždarote naršyklę, šis slapukas sunaikinamas (jūsų naršyklėje ir serveryje).';
$string['cookiesnotenabled'] = 'Deja, slapukai šiuo metu neįjungti jūsų naršyklėje.';
$string['cookiesnotice'] = 'Slapukų pranešimas';
$string['copy'] = 'kopijuoti';
$string['copyasnoun'] = 'kopija';
$string['copycourse'] = 'Kopijuoti kursą';
$string['copyingcoursefiles'] = 'Kopijuojami kursų failai';
$string['copyingsitefiles'] = 'Kopijuojami kursuose naudojami svetainės failai';
$string['copyinguserfiles'] = 'Kopijuojami naudotojų failai';
$string['copyingzipfile'] = 'Kopijuojamas suglaudintasis failas';
$string['copyrightnotice'] = 'Įspėjimas dėl autorių teisių';
$string['copytoclipboard'] = 'Nukopijuoti į iškarpinę';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Kaina';
$string['costdefault'] = 'Įprastinė kaina';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Šalis';
$string['course'] = 'Kursas';
$string['courseadministration'] = 'Kursų informacija';
$string['courseapprovedemail'] = 'Jūsų naujo kurso užklausa yra patvirtinta, <a href="{$a->url}">{$a->name}</a>,  o jums paskirtas {$a->teacher} vaidmuo.';
$string['courseapprovedemail2'] = 'Jūsų naujo kurso užklausa buvo patvirtinta: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Nepavyko kursų įrašyti kaip patvirtintų.';
$string['courseapprovedsubject'] = 'Jūsų naujo kurso sukūrimo prašymas buvo patvirtintas!';
$string['courseavailable'] = 'Šiuos kursus gali pasiekti besimokantieji';
$string['courseavailablenot'] = 'Šių kursų besimokantieji pasiekti negali';
$string['coursebackup'] = 'Kursų atsarginė kopija';
$string['coursebulkaction'] = 'Masiniai veiksmai pasirinktiems kursams';
$string['coursecategories'] = 'Kursų kategorijos';
$string['coursecategory'] = 'Kurso kategorija';
$string['coursecategory_help'] = 'Šis parametras nurodo kategoriją, kurioje kursai bus pateikiami kursų sąraše.';
$string['coursecategorydeleted'] = 'Panaikinta kursų kategorija {$a}';
$string['coursecatmanagement'] = 'Kursų ir kategorijų valdymas';
$string['coursecompletion'] = 'Kursų užbaigimas';
$string['coursecompletions'] = 'Kursų užbaigimai';
$string['coursecreators'] = 'Kursų kūrėjas';
$string['coursecreatorsdescription'] = 'Kursų kūrėjai gali kurti naujus kursus.';
$string['coursedeleted'] = 'Panaikinti kursus {$a}';
$string['coursedetails'] = 'Kurso informacija';
$string['coursedisplay'] = 'Kurso maketas';
$string['coursedisplay_help'] = 'Kurso dalys gali būti rodomos viename puslapyje arba padalytos į kelis puslapius.';
$string['coursedisplay_multi'] = 'Rodyti vieną dalį puslapyje';
$string['coursedisplay_single'] = 'Rodyti visas dalis puslapyje';
$string['courseduration'] = 'Kurso trukmė';
$string['courseduration_desc'] = 'Kurso trukmė yra naudojama apskaičiuoti numatytą kurso pabaigos datą. Kurso pabaigos data yra naudojama nustatant ar kursas turėtų būti įtrauktas naudotojo kursų sąraše bei taip pat gali būti naudojama ataskaitose. Naudotojai po kurso pabaigos datos vis dar gali patekti į kursą.';
$string['courseenddateenabled'] = 'Kurso pabaigos data įjungta pagal numatymą';
$string['courseenddateenabled_desc'] = 'Parinktis nustato, ar kursų pabaigos data pagal numatytuosius nustatymus bus įtraukta į naujus kursus ir nustatoma pagal datą, apskaičiuotą pagal kurso trukmę.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Senstelėję kursų failai';
$string['coursefilesedit'] = 'Redaguoti senstelėjusius kursų failus';
$string['coursefileswarning'] = 'Kursų failai yra nerekomenduojami';
$string['coursefileswarning_help'] = 'Kursų failai nerekomenduojami naudoti nuo „Moodle 2.0“ versijos, geriau, kiek įmanoma, naudokite išorines saugyklas.';
$string['courseformatdata'] = 'Kursų formato duomenys';
$string['courseformatoptions'] = '{$a} formatavimo parinktys';
$string['courseformats'] = 'Kursų formatai';
$string['courseformatudpate'] = 'Atnaujinti formatą';
$string['coursegrades'] = 'Kursų įvertinimai';
$string['courseheader'] = 'Kurso meniu';
$string['coursehelpcategory'] = 'Pateikite kursus kursų sąraše, kad besimokantiesiems būtų lengviau juos surasti.';
$string['coursehelpforce'] = 'Taikyti kursų grupės režimą kiekvienai kursų veiklai.';
$string['coursehelpformat'] = 'Pagrindinis kursų puslapis bus rodomas šiuo formatu.';
$string['coursehelphiddensections'] = 'Kaip kurse rodomos paslėptos dalys besimokantiesiems.';
$string['coursehelpmaximumupload'] = 'Apibrėžkite maksimalų į šiuos kursus galimo įkelti failo dydį, kurį apriboja visos svetainės parametras.';
$string['coursehelpnewsitemsnumber'] = 'Skelbimų skaičius rodomas paskutinių skelbimų bloke pagrindiniame kurso puslapyje. Jei nurodyta nulis, skelbimų forumas nebus sukurtas.';
$string['coursehelpnumberweeks'] = 'Pagrindiniame kursų puslapyje rodomų savaičių / temų skaičius.';
$string['coursehelpshowgrades'] = 'Įjungti įvertinimų knygelės rodymą. Tai vis tiek leis įvertinimus rodyti atskirose veiklose.';
$string['coursehidden'] = 'Šių kursų šiuo metu besimokantieji pasiekti negali';
$string['courseinfo'] = 'Kursų informacija';
$string['courselegacyfiles'] = 'Senstelėję kursų failai';
$string['courselegacyfiles_help'] = 'Kursų failų sritis yra iš dalies suderinama su „Moodle 1.9“ ir ankstesnėmis versijomis. Visi šioje srityje esantys failai visada pasiekiami visiems kursų dalyviams (nesvarbu, ar yra sukurtas saitas) ir nėra jokio būdo sužinoti, kur šie failai naudojami „Moodle“. Jei šią sritį naudojate kursų failams saugoti, galite turėti įvairių privatumo ir saugos problemų, taip pat gali trūkti failų kuriant atsargines kopijas, importuojant kursus ir bendrai ar pakartotinai naudojant turinį. Todėl rekomenduojama nenaudoti šios srities, išskyrus atvejus, kai tikrai žinote, ką darote. Toliau pateiktame saite apie visa tai pateikiama daugiau informacijos ir nurodomi kai kurie geresni būdai, kaip „Moodle 2“ tvarkyti failus.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Paveldėti kurso failai: {$a}';
$string['coursenotaccessible'] = 'Negalima vieša prieiga prie šių kursų';
$string['courseoverview'] = 'Kursų apžvalga';
$string['courseoverviewfiles'] = 'Kurso paveiksliukas';
$string['courseoverviewfiles_help'] = 'Kurso paveikslėlis rodomas „Mano kursai“ ir galimų kursų sąraše pagrindiniame puslapyje. Svetainės administratoriai gali įjungti papildomus failų tipus ir kelių failų naudojimą. Jei naudojate kelis failus, visi jie bus rodomi galimų kursų sąraše pagrindiniame puslapyje.';
$string['courseoverviewfilesext'] = 'Kurso paveiksliuko failų plėtiniai';
$string['courseoverviewfileslimit'] = 'Kurso paveiksliuko failų limitas';
$string['courseoverviewgraph'] = 'Kursų apžvalgos diagrama';
$string['courseprofiles'] = 'Kursų profiliai';
$string['coursereasonforrejecting'] = 'Jūsų šios užklausos atmetimo priežastys';
$string['coursereasonforrejectingemail'] = 'Tai bus el. paštu išsiųsta užklausos pateikėjui';
$string['coursereject'] = 'Atmesti kurso sukūrimo prašymą';
$string['courserejected'] = 'Kursas buvo atmestas ir pranešta užklausos pateikėjui.';
$string['courserejectemail'] = 'Atsiprašome, tačiau jūsų naujo kurso sukūrimo prašymas buvo atmestas. Priežastis:

{$a}';
$string['courserejectreason'] = 'Pateikite savo šių kursų atmetimo priežastis<br />(bus išsiųsta užklausos pateikėjui)';
$string['courserejectsubject'] = 'Jūsų naujo kurso sukūrimo prašymas buvo atmestas';
$string['coursereport'] = 'Kursų ataskaita';
$string['coursereports'] = 'Kursų ataskaitos';
$string['courserequest'] = 'Naujo kurso sukūrimo prašymas';
$string['courserequestdetails'] = 'Informacija apie kursą';
$string['courserequestfailed'] = 'Dėl tam tikrų priežasčių jūsų kurso sukūrimo prašymo nepavyko išsaugoti';
$string['courserequestintro'] = 'Naudokite šią formą norėdami užklausti jums sukurti kursus.<br />Pabandykite užpildyti kiek galite daugiau informacijos, kad<br />administratoriams būtų aišku, dėl kokių priežasčių jums reikalingi šie kursai.';
$string['courserequestreason'] = 'Priežastys, kodėl reikalingas šis kursas';
$string['courserequestroleerror'] = 'Kūrėjo vaidmuo naujų kursų konfigūracijoje negalioja. Žr. <a href=„{$a}“>naudotojų politika</a>.';
$string['courserequestsuccess'] = 'Naujo kurso sukūrimo prašymas pateiktas.';
$string['courserequestsupport'] = 'Papildoma informacija, padedanti administratoriui įvertinti šį prašymą';
$string['courserequestwarning'] = 'Naudotojas, prašantis šio kurso bus automatiškai įregistruotas ir jam bus priskirtas {$a} vaidmuo.';
$string['courserestore'] = 'Kursų atkūrimas';
$string['coursereuse'] = 'Pakartotinis kurso naudojimas';
$string['courses'] = 'Kursai';
$string['coursesearch'] = 'Ieškoti kursų';
$string['coursesearch_help'] = 'Galite vienu metu ieškoti kelių žodžių ir patikslinti paiešką taip:

*žodis - rasti visų šio žodžio atitikimų tekste;
*+žodis - bus rasti tik tiksliai atitinkantys žodžiai;
* -žodis - rezultatai nebus įtraukti su šiuo žodžiu.';
$string['coursesectionsummaries'] = 'Kursų dalių suvestinės';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Masinis redagavimas {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Redaguoti {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Numatytieji kursų parametrai';
$string['coursesmovedout'] = 'Kursai perkelti iš {$a}';
$string['coursespending'] = 'Kursai, laukiantys patvirtinimo';
$string['coursestart'] = 'Kurso pradžia';
$string['coursesummary'] = 'Kurso santrauka';
$string['coursesummary_help'] = 'Trumpas jūsų kurso aprašymas. Kursų paieška ieško kurso aprašymo teksto, ne tik kursų pavadinimų.';
$string['coursetitle'] = 'Kursas: {$a->course}';
$string['coursetitlebulkediting'] = 'Masinio redagavimo kursas: {$a->course}';
$string['coursetitleediting'] = 'Redaguoti kursą: {$a->course}';
$string['courseupdates'] = 'Kurso atnaujinimas';
$string['coursevisibility'] = 'Kurso matomumas';
$string['coursevisibility_help'] = '* Rodyti: Kursas rodomas kursų sąraše ir besimokantieji gali jį pasiekti.
* Slėpti: Prieiga suteikiama tik dėstytojams ir kitiems naudotojams, turintiems galimybę peržiūrėti paslėptus kursus.';
$string['create'] = 'Kurti';
$string['createaccount'] = 'Kurti naują mano paskyrą';
$string['createcategory'] = 'Kurti kategoriją';
$string['createfolder'] = 'Kurti aplanką {$a}';
$string['createnew'] = 'Kurti naują';
$string['createnewcategory'] = 'Kurti naują kategoriją';
$string['createnewcourse'] = 'Kurti naują kursą';
$string['createnewsubcategory'] = 'Kurti naują subkategoriją';
$string['createsubcategoryof'] = 'Kurti {$a} subkategoriją';
$string['createuser'] = 'Kurti naudotoją';
$string['createuserandpass'] = 'Pasirinkite savo naudotojo vardą ir slaptažodį';
$string['createziparchive'] = 'Kurti suglaudintąjį archyvą';
$string['creatingblocks'] = 'Blokų kūrimas';
$string['creatingblocksroles'] = 'Vyksta blokų lygio vaidmenų priskyrimų kūrimas ir perrašymas';
$string['creatingblogsinfo'] = 'Tinklaraščių informacijos kūrimas';
$string['creatingcategoriesandquestions'] = 'Kategorijų ir klausimų kūrimas';
$string['creatingcoursemodules'] = 'Kursų modulių kūrimas';
$string['creatingcourseroles'] = 'Kursų lygio vaidmenų priskyrimų kūrimas ir perrašymas';
$string['creatingevents'] = 'Įvykių kūrimas';
$string['creatinggradebook'] = 'Įvertinimų knygelės kūrimas';
$string['creatinggroupings'] = 'Grupavimo kūrimas';
$string['creatinggroupingsgroups'] = 'Grupių sugrupavimas';
$string['creatinggroups'] = 'Grupių kūrimas';
$string['creatinglogentries'] = 'Žurnalo įrašų kūrimas';
$string['creatingmessagesinfo'] = 'Žinučių informacijos kūrimas';
$string['creatingmodroles'] = 'Modulių lygio vaidmenų priskyrimo kūrimas ir perrašymas';
$string['creatingnewcourse'] = 'Naujų kursų kūrimas';
$string['creatingrolesdefinitions'] = 'Vaidmenų apibrėžimų kūrimas';
$string['creatingscales'] = 'Skalių kūrimas';
$string['creatingsections'] = 'Dalių kūrimas';
$string['creatingtemporarystructures'] = 'Laikinųjų struktūrų kūrimas';
$string['creatinguserroles'] = 'Naudotojų lygio vaidmenų priskyrimų kūrimas ir perrašymas';
$string['creatingusers'] = 'Naudotojų kūrimas';
$string['creatingxmlfile'] = 'XML failo kūrimas';
$string['currency'] = 'Valiuta';
$string['currentcourse'] = 'Kursas';
$string['currentcourseadding'] = 'Dabartiniai kursai, į juos įtraukiami duomenys';
$string['currentcoursedeleting'] = 'Dabartinis kursas, jis bus naikinamas pirmiausia';
$string['currentlanguage'] = 'Vartojama kalba';
$string['currentlocaltime'] = 'jūsų dabartinis vietos laikas';
$string['currentpicture'] = 'Dabartinis paveikslėlis';
$string['currentrelease'] = 'Dabartinio leidimo informacija';
$string['currentversion'] = 'Dabartinė versija';
$string['databasechecking'] = '„Moodle“ duomenų bazės versija {$a->oldversion} atnaujinama į {$a->newversion}...';
$string['databaseperformance'] = 'Duomenų bazės našumas';
$string['databasesetup'] = 'Duomenų bazės nustatymas';
$string['databasesuccess'] = 'Sėkmingai atnaujinta duomenų bazės versija';
$string['databaseupgradebackups'] = 'Dabartinė atsarginės kopijos versija yra {$a}';
$string['databaseupgradeblocks'] = 'Dabartinė blokų versija yra {$a}';
$string['databaseupgradegroups'] = 'Dabartinė grupių versija yra {$a}';
$string['databaseupgradelocal'] = 'Vietinės duomenų bazės tinkinimo versija yra {$a}';
$string['databaseupgrades'] = 'Duomenų bazės atnaujinimas';
$string['dataformats'] = 'Datos formatai';
$string['date'] = 'Data';
$string['datechanged'] = 'Data pakeista';
$string['datemostrecentfirst'] = 'Data: visų pirma pateikiami naujausi';
$string['datemostrecentlast'] = 'Data: naujausi pateikiami pabaigoje';
$string['day'] = 'diena';
$string['days'] = 'dienos';
$string['decodinginternallinks'] = 'Vidinių saitų dekodavimas';
$string['default'] = 'Numatyta';
$string['defaultcategoryname'] = '1 kategorija';
$string['defaultcompetencescale'] = 'Numatytoji kompetencijos skalė';
$string['defaultcompetencescaledesc'] = 'Dvejetainė įvertinimo skalė, kurioje nėra jokios papildomos informacijos, išskyrus tuos atvejus, kai įrodomi įgūdžiai arba ne,';
$string['defaultcompetencescalenotproficient'] = 'Dar nekompetentingas';
$string['defaultcompetencescaleproficient'] = 'Kompetentingas';
$string['defaultcoursestudent'] = 'Besimokantysis';
$string['defaultcoursestudentdescription'] = 'Paprastai besimokantieji turi mažiau teisių kursuose.';
$string['defaultcoursestudents'] = 'Besimokantieji';
$string['defaultcoursesummary'] = 'Čia trumpai, bet įdomiai parašykite,  apie ką yra šis kursas';
$string['defaultcourseteacher'] = 'Dėstytojas';
$string['defaultcourseteacherdescription'] = 'Dėstytojai kursuose gali atlikti įvairius veiksmus, pvz., keisti veiklą ir įvertinti besimokančiuojus.';
$string['defaultcourseteachers'] = 'Dėstytojai';
$string['defaulteditor'] = 'Numatytoji tekstų rengyklė';
$string['defaulthomepageuser'] = 'Pradinis puslapis';
$string['defaulthomepageuser_help'] = 'Į kurį puslapį turėtumėte būti nukreipti prisijungę prie svetainės?';
$string['delete'] = 'Naikinti';
$string['deleteablock'] = 'Naikinti bloką';
$string['deleteall'] = 'Naikinti viską';
$string['deleteallcannotundo'] = 'Naikinti viską – negalima anuliuoti';
$string['deleteallcomments'] = 'Naikinti visus komentarus';
$string['deleteallratings'] = 'Naikinti visus įvertinimus';
$string['deletecategory'] = 'Naikinti kategoriją: {$a}';
$string['deletecategorycheck'] = 'Ar esate visiškai tikri, kad norite visiškai panaikinti šią kategoriją <b>{$a}</b>?<br />Tada visi kursai bus perkelti į pirminę kategoriją, jei tokia yra, arba į Kita.';
$string['deletecategorycheck2'] = 'Jei panaikinsite šią kategoriją, turėsite pasirinkti, ką daryti su kursais ir antrinėmis kategorijomis, kurias ji apima.';
$string['deletecategoryempty'] = 'Ši kategorija yra tuščia.';
$string['deletecheck'] = 'Naikinti {$a}?';
$string['deletecheckfiles'] = 'Ar tikrai norite naikinti šiuos failus?';
$string['deletecheckfull'] = 'Ar esate įsitikinę, kad norite visiškai pašalinti naudotoją {$a}, įskaitant registraciją, veiklas ir kitus naudotojo duomenis?';
$string['deletechecktype'] = 'Ar tikrai norite naikinti šį {$a->type}?';
$string['deletechecktypename'] = 'Ar tikrai norite naikinti {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Jūs ruošiatės panaikinti šiuos failus';
$string['deletecommentbyon'] = 'Ištrinti komentarą paskelbtą {$a->user} {$a->time}';
$string['deletecompletely'] = 'Visiškai panaikinti';
$string['deletecourse'] = 'Panaikinti kursus';
$string['deletecoursecheck'] = 'Ar tikrai norite visiškai panaikinti šį kursą ir jo duomenis?';
$string['deleted'] = 'Panaikinta';
$string['deletedactivity'] = 'Panaikinta {$a}';
$string['deletedcourse'] = '{$a} buvo visiškai panaikinti';
$string['deletednot'] = 'Nepavyko panaikinti {$a}.';
$string['deletepicture'] = 'Naikinti';
$string['deletesection'] = 'Trinti dalį';
$string['deleteselected'] = 'Naikinti pasirinktus';
$string['deleteselectedkey'] = 'Naikinti pasirinktą raktą';
$string['deletingcourse'] = 'Naikinama {$a}';
$string['deletingexistingcoursedata'] = 'Naikinami esami kurso duomenys';
$string['deletingolddata'] = 'Naikinami seni duomenys';
$string['department'] = 'Skyrius';
$string['deprecatedeventname'] = '{$a} (nebenaudojamas)';
$string['desc'] = 'Mažėjimo tvarka';
$string['description'] = 'Aprašas';
$string['descriptiona'] = 'Aprašymas: {$a}';
$string['deselectall'] = 'Naikinti visų žymėjimą';
$string['deselectnos'] = 'Panaikinkite visų "Ne" pasirinkimą';
$string['detailedless'] = 'Mažiau informacijos';
$string['detailedmore'] = 'Daugiau informacijos';
$string['details'] = 'Išsami informacija';
$string['digitalminor'] = 'Skaitmeninis nepilnametis';
$string['digitalminor_desc'] = 'Paprašykite savo tėvo/globėjo susisiekti:';
$string['directory'] = 'Katalogas';
$string['disable'] = 'Išjungti';
$string['disabledcomments'] = 'Komentarai yra išjungti';
$string['dismissnotification'] = 'Atmesti šį pranešimą';
$string['displayingfirst'] = 'Rodomi tik pirmi {$a->count} {$a->things}';
$string['displayingrecords'] = 'Rodoma įrašų: {$a}';
$string['displayingusers'] = 'Rodomi naudotojai nuo {$a->start} iki {$a->end}';
$string['displayonpage'] = 'Rodyti puslapyje';
$string['dndcourse'] = 'Galite vilkti ir palikti šį kursą, kad pakeisti rikiavimą arba perkelti į kitą kategoriją.';
$string['dndenabled_inbox'] = 'Norėdami įkelti failus, Jūs galite nutempti juos čia.';
$string['dndnotsupported'] = 'Drag and drop įkėlimas yra nepalaikomas';
$string['dndnotsupported_help'] = 'Jūsų naršyklė nepalaiko "drag and drop (vilkti ir palikti)" įkėlimo. Ši funkcija pasiekiama visose naujausiose „Chrome“, „Firefox“ ir „Safari“ versijose, taip pat „Internet Explorer“ 10 ir naujesnėse versijose.';
$string['dndnotsupported_insentence'] = '"drag and drop (vilkti ir palikti)" nepalaikomas';
$string['dnduploadwithoutcontent'] = 'Šiame įkėlime nėra turinio';
$string['dndworkingfile'] = 'Nutempkite failus į paskaitos sekcijas, norėdami juos įkelti';
$string['dndworkingfilelink'] = 'Nutempkite failus ar saitus į paskaitos sekcijas, norėdami juos įkelti';
$string['dndworkingfiletext'] = 'Nutempkite failus ar tekstą į paskaitos sekcijas, norėdami juos įkelti';
$string['dndworkingfiletextlink'] = 'Nutempkite failus, saitus ar tekstą į paskaitos sekcijas, norėdami juos įkelti';
$string['dndworkinglink'] = 'Nutempkite saitus į paskaitos sekcijas, norėdami juos įkelti';
$string['dndworkingtext'] = 'Nutempkite tekstą į paskaitos sekcijas, norėdami jį įkelti';
$string['dndworkingtextlink'] = 'Nutempkite tekstą ar saitus į paskaitos sekcijas, norėdami juos įkelti';
$string['documentation'] = '„Moodle“ dokumentacija';
$string['dontsortcategories'] = 'Nerūšiuoti kategorijų';
$string['dontsortcourses'] = 'Nerūšiuoti kursų';
$string['down'] = 'Žemyn';
$string['download'] = 'Atsisiųsti';
$string['downloadall'] = 'Atsisiųsti viską';
$string['downloadexcel'] = 'Atsisiųsti „Excel“ formatu';
$string['downloadfile'] = 'Atsisiųsti failą';
$string['downloadods'] = 'Atsisiųsti ODS formatu';
$string['downloadtext'] = 'Atsisiųsti tekstiniu formatu';
$string['doyouagree'] = 'Ar perskaitėte šias sąlygas ir jas supratote?';
$string['droptoupload'] = 'Nutempkite failus čia įkėlimui';
$string['duplicate'] = 'Dubliuoti';
$string['duplicatedmodule'] = '{$a} (kopija)';
$string['duplicatedsection'] = '{$a} (kopija)';
$string['edhelpaspellpath'] = 'Jei norite rengyklėje naudoti rašybos tikrinimą, serveryje TURI būti įdiegta <strong>„Aspell 0.50“</strong> arba naujesnė versija, o jūs turite nurodyti teisingą kelią, kaip pasiekti „Aspell“. „Unix“ / „Linux“ sistemose šis kelias paprastai yra <strong>/usr/bin/aspell</strong>, bet gali būti ir kitoks.';
$string['edhelpbgcolor'] = 'Apibrėžkite redagavimo srities fono spalvą.<br />Tinkamos reikšmės yra, pvz.,: #FFFFFF arba balta.';
$string['edhelpcleanword'] = 'Šis parametras įjungia arba išjungia „Word“ būdingo formato filtravimą.';
$string['edhelpenablespelling'] = 'Įjunkite arba išjunkite rašybos tikrinimą. Jei įjungtas, serveryje turi būti įdiegta <strong>„Aspell“</strong>. Antroji reikšmė – <strong>numatytasis žodynas</strong>. Ši reikšmė bus naudojama, jei „Aspell“ nėra žodyno naudotojo kalba.';
$string['edhelpfontfamily'] = 'Šriftų grupės ypatybė – tai šriftų grupių pavadinimų ir (arba) bendrųjų grupių pavadinimų sąrašas. Grupių pavadinimai turi būti atskirti kableliais.';
$string['edhelpfontlist'] = 'Apibrėžkite šriftus, naudojamus rengyklės išplečiamajame meniu.';
$string['edhelpfontsize'] = 'Numatytasis šrifto dydis nurodo šrifto dydį. <br />Tinkamos reikšmės yra, pvz.,: vidutinis, didelis, mažesnis, didesnis, 10pt, 11px.';
$string['edit'] = 'Redaguoti';
$string['edita'] = 'Redaguoti {$a}';
$string['editcategorysettings'] = 'Redaguoti kategorijos parametrus';
$string['editcategorythis'] = 'Redaguoti šią kategoriją';
$string['editcoursesettings'] = 'Redaguoti kursų parametrus';
$string['editfiles'] = 'Redaguoti failus';
$string['editgroupprofile'] = 'Redaguoti grupės profilį';
$string['editinga'] = 'Redaguojama {$a}';
$string['editingteachershort'] = 'Rengyklė';
$string['editlock'] = 'Šios reikšmės negalima redaguoti.';
$string['editmode'] = 'Redagavimo režimas';
$string['editmyprofile'] = 'Redaguoti profilį';
$string['editorbgcolor'] = 'Fono spalva';
$string['editorcleanonpaste'] = 'Valyti „Word“ HTML įklijuojant';
$string['editorcommonsettings'] = 'Bendrieji nustatymai';
$string['editordefaultfont'] = 'Numatytasis šriftas';
$string['editorenablespelling'] = 'Įjungti rašybos tikrinimą';
$string['editorfontlist'] = 'Šriftų sąrašas';
$string['editorfontsize'] = 'Numatytasis šrifto dydis';
$string['editorpreferences'] = 'Rengyklės nustatymai';
$string['editorresettodefaults'] = 'Grąžinti numatytąsias reikšmes';
$string['editorsettings'] = 'Rengyklės parametrai';
$string['editorshortcutkeys'] = 'Rengyklės sparčiųjų klavišų deriniai';
$string['editsection'] = 'Redaguoti dalį';
$string['editsectionname'] = 'Redaguoti dalies pavadinimą';
$string['editsettings'] = 'Redaguoti parametrus';
$string['editsummary'] = 'Redaguoti suvestinę';
$string['editthisactivity'] = 'Redaguoti šią veiklą';
$string['editthiscategory'] = 'Redaguoti šią kategoriją';
$string['edittitle'] = 'Keisti antraštę';
$string['edittitleinstructions'] = '"Escape" klavišas - atšaukti, "Enter" - kada baigsit';
$string['edituser'] = 'Redaguoti naudotojų paskyras';
$string['edulevel'] = 'Visi įvykiai';
$string['edulevel_help'] = '* Mokymas - dėstytojo atliekami veiksmai, pvz.: atnaujinti išteklių
* Dalyvavimas - besimokančiojo atliekami veiksmai, pavyzdžiui, skelbimas forume
* Kiti -  kitų vaidmenų naudototojų nei mokytojas ar studentas atliekami veiksmai';
$string['edulevelother'] = 'Kita';
$string['edulevelparticipating'] = 'Dalyvavimas';
$string['edulevelteacher'] = 'Mokymas';
$string['email'] = 'El. pašto adresas';
$string['emailactive'] = 'El. paštas suaktyvintas';
$string['emailagain'] = 'El. paštas (dar kartą)';
$string['emailalreadysent'] = 'Laiškas su slaptažodžiu jau išsiųstas. Patikrinkite savo el. paštą.';
$string['emailcharset'] = 'El. pašto simbolių rinkinys';
$string['emailconfirm'] = 'Patvirtinkite savo paskyrą';
$string['emailconfirmation'] = 'Sveiki,

gauta užklausa sukurti naują paskyrą svetainėje {$a->sitename}, naudojant šį jūsų el. pašto adresą.

Norėdami patvirtinti naują paskyrą, eikite šiuo interneto adresu:

 {$a->link}

Daugumoje pašto programų, adresas rodomas kaip mėlynas saitas, kurį galite tiesiog atverti spustelėjimu. Jei nepavyksta, nukopijuokite ir įklijuokite adresą į naršyklės lango viršuje esančią adreso eilutę.

Jei reikia pagalbos, susisiekite su svetainės administratoriumi,
{$a->admin}';
$string['emailconfirmationresend'] = 'Siųsti patvirtinimo el. laišką iš naujo';
$string['emailconfirmationsubject'] = '{$a}: paskyros patvirtinimas';
$string['emailconfirmsent'] = '<p>El. laiškas išsiųstas jūsų adresu <b>{$a}</b></p>
<p>Jame pateikti paprasti nurodymai, kaip užbaigti registraciją.</p>
<p>Jei iškils kokių sunkumų, susisiekite su svetainės administratoriumi.</p>';
$string['emailconfirmsentfailure'] = 'Nepavyko išsiųsti patvirtinimo el. laiško';
$string['emailconfirmsentsuccess'] = 'Patvirtinimo el. laiškas išsiųstas sėkmingai';
$string['emaildigest'] = 'Forumų santraukos tipas';
$string['emaildigest_help'] = 'Numatytieji forumo skelbimų santraukos nustatymai:
* Be santraukos- Jūs gausite po vieną el. laišką kiekvienam forumo skelbimui;
* Santrauka – Viskas - Jūs gausite po  el. laišką su pilnu kiekvieno forumo skelbimo turiniu;
* Santrauka - Temos - Jūs gausite vieną el. laišką per dieną su kiekvieno forumo skelbimo temomis.
Taip pat, jei norite, Jūs galite parinkti skirtingus nustatymus kiekvienam forumui atskirai.';
$string['emaildigestcomplete'] = 'Viskas (kasdienis el. laiškas su visais skelbimais)';
$string['emaildigestoff'] = 'Be santraukos (atskiras el. laiškas kiekvienam forumo skelbimui)';
$string['emaildigestsubjects'] = 'Temos (kasdienis el. laiškas tik su skelbimų temomis)';
$string['emaildisable'] = 'Šis el. pašto adresas yra išjungtas';
$string['emaildisableclick'] = 'Spustelėkite čia, kad išjungtumėte visų laiškų siuntimą šiuo adresu';
$string['emaildisplay'] = 'El. pašto matomumas';
$string['emaildisplay_help'] = '* Paslėptas – tik atitinkamus leidimus turintys naudotojai, pvz., dėstytojai, gali peržiūrėti jūsų el. pašto adresą.
* Matomas visiems – visi svetainės naudotojai gali peržiūrėti jūsų el. pašto adresą.
* Matomas kursų dalyviams – jūsų el. pašto adresą gali matyti tik tie kursų, į kuriuos esate įsiregistravęs, dalyviai.';
$string['emaildisplaycourse'] = 'Matomas kurso dalyviams';
$string['emaildisplaycoursemembersonly'] = '(Matomas kitiems kurso dalyviams)';
$string['emaildisplayeveryone'] = '(Matomas visiems)';
$string['emaildisplayhide'] = '(Paslėpta nuo visų, išskyrus naudotojus, turinčius atitinkamus leidimus)';
$string['emaildisplayno'] = 'Paslėptas';
$string['emaildisplayyes'] = 'Matomas visiems';
$string['emailenable'] = 'Šis el. pašto adresas yra įjungtas';
$string['emailenableclick'] = 'Spustelėkite čia, kad vėl įjungtumėte visų laiškų siuntimą šiuo adresu';
$string['emailexists'] = 'Šis el. pašto adresas jau užregistruotas.';
$string['emailexistshintlink'] = 'Atkurti pamirštą naudotojo vardą arba slaptažodį';
$string['emailexistssignuphint'] = 'Galbūt Jūs anksčiau sukūrėte paskyrą? {$a}';
$string['emailformat'] = 'El. pašto formatas';
$string['emailmustbereal'] = 'Pastaba: jūsų el. pašto adresas turi būti tikras';
$string['emailnotallowed'] = 'El. pašto adresai šiuose domenuose neleidžiami ({$a})';
$string['emailnotfound'] = 'Šio el. pašto adreso nepavyko rasti duomenų bazėje';
$string['emailonlyallowed'] = 'Šio el. pašto negalima naudoti. Leidžiami šie el. pašto domenai: {$a}.';
$string['emailpasswordchangeinfo'] = 'Sveiki, {$a->firstname},

kažkas (tikriausiai jūs) paprašė naujo jūsų paskyros \'{$a->username}\' svetainėje {$a->sitename} slaptažodžio.

Norėdami pakeisti savo slaptažodį, eikite šiuo žiniatinklio adresu:

{$a->link}

Daugumoje pašto programų tai turi būti rodoma kaip mėlynas saitas, kurį spustelėję, atversite adresą.  Jei nepavyksta, nukopijuokite ir įklijuokite šį adresą į naršyklės lango viršuje esančią adreso eilutę.

Jei reikia pagalbos, kreipkitės į svetainės administratorių {$a->admin}.';
$string['emailpasswordchangeinfodisabled'] = 'Sveiki, {$a->firstname},

kažkas (tikriausiai Jūs) paprašė naujo Jūsų paskyros, esančios \'{$a->sitename}\', slaptažodžio.

Deja, Jūsų paskyra šioje svetainėje išjungta ir jos negalima nustatyti iš naujo.
Kreipkitės į svetainės administratorių {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Sveiki, {$a->firstname},

kažkas (tikriausiai Jūs) paprašė naujo Jūsų paskyros, esančios \'{$a->sitename}\', slaptažodžio.

Deja, šioje svetainėje negalima iš naujo nustatyti slaptažodžių. Kreipkitės į svetainės administratorių {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: slaptažodžio keitimo informacija';
$string['emailpasswordconfirmation'] = 'Sveiki, {$a->firstname}, kažkas (tikriausiai jūs) paprašė naujo jūsų paskyros {$a->sitename} slaptažodžio. Norėdami tai patvirtinti ir el. paštu gauti naują slaptažodį, eikite šiuo žiniatinklio adresu: {$a->link} Daugumoje pašto programų tai turi būti rodoma kaip mėlynas saitas, kurį galite spustelėti. Jei nepavyksta, įklijuokite šį adresą į jūsų naršyklės lango viršuje esančią adreso eilutę. Jei reikia pagalbos, kreipkitės į svetainės administratorių {$a->admin}.';
$string['emailpasswordconfirmationsubject'] = '{$a}: slaptažodžio keitimo patvirtinimas';
$string['emailpasswordconfirmmaybesent'] = '<p>Jei nurodėte teisingą naudotojo vardą arba unikalų el. pašto adresą, jums turėjo būti išsiųstas el. laiškas.</p>
    <p>Jame pateikiamos paprastos instrukcijos, kaip patvirtinti ir užbaigti šį slaptažodžio keitimą.
Jei ir toliau kyla sunkumų, susisiekite su svetainės administratoriumi.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> Naudotojo paskyra, kurią nurodėte neturi užregistruoto elektroninio pašto adreso. </ p> Prašome susisiekti su svetainės administratoriumi. </ p>';
$string['emailpasswordconfirmnotsent'] = '<p>Pagal įvestas naudotojo detales nenustatyta esamų naudotojų paskyrų.</p>
    <p>Patikrinkite įvestą informaciją tada bandykite dar kartą.
Jei ir toliau susidursite su sunkumais, kreipkitės į svetainės administratorių. </p>';
$string['emailpasswordconfirmsent'] = 'Turėjo būti išsiųstas el. laiškas jūsų adresu <b>{$a}</b>. <br />Jame pateikti paprasti nurodymai, kaip patvirtinti ir užbaigti slaptažodžio keitimą. Jei iškils kokių sunkumų, kreipkitės į svetainės administratorių.';
$string['emailpasswordsent'] = 'Dėkojame, kad patvirtinote slaptažodžio keitimą. El. laiškas su nauju slaptažodžiu jums buvo išsiųstas adresu <br /><b>{$a->email}</b>.<br /> Naujasis slaptažodis sugeneruotas automatiškai. Galite <a href="{$a->link}">pakeisti savo slaptažodį</a> į lengviau įsimenamą.';
$string['emailresetconfirmation'] = 'Sveiki, {$a->firstname},

{$a->sitename} Jūsų paskyrai \'{$a->username}\' buvo paprašyta atnaujinti slaptažodį.

Norėdami patvirtinti šį prašymą, ir iš naujo nustatyti savo paskyros slaptažodį, eikite šiuo adresu:
<a href="{$a->link}">{$a->link}</a>

(Ši nuoroda galioja {$a->resetminutes} minutes (-ių) nuo to laiko, kai pirmą kartą buvo prašoma atnaujinti)

Jei neprašėte slaptažodžio atnaujinimo, Jums nereikia imtis jokių veiksmų.

Jei Jums reikia pagalbos, kreipkitės į svetainės administratorių,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Naujo slaptažodžio prašymas';
$string['emailresetconfirmsent'] = 'El. laiškas buvo išsiųstas adresu <b>{$a}</b>.
<br />Patvirtinkite ir užbaikite slaptažodžio keitimą.
Jei ir toliau susiduria su sunkumais, susisiekite su svetainės administratoriumi.';
$string['emailstop'] = 'Išjungti pranešimus';
$string['emailtoprivatefiles'] = 'Taip pat galite siųsti failus el. laišku kaip priedus tiesiai į Jūsų privačių failų saugyklą. Kaip įprasta pridėkite savo failus prie el. laiško ir siųskite juos {$a}';
$string['emailtoprivatefilesdenied'] = 'Administratorius išjungė parinktį įkelti savo asmeninius failus.';
$string['emailvia'] = '{$a->name} (per {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Veiklos';
$string['emojicategoryanimalsnature'] = 'Gyvūnai ir gamta';
$string['emojicategoryflags'] = 'Vėliavos';
$string['emojicategoryfooddrink'] = 'Maistas ir gėrimai';
$string['emojicategoryobjects'] = 'Objektai';
$string['emojicategorypeoplebody'] = 'Žmonės ir kūnas';
$string['emojicategoryrecent'] = 'Naujausi';
$string['emojicategorysmileysemotion'] = 'Šypsenėlės ir emocijos';
$string['emojicategorysymbols'] = 'Simboliai';
$string['emojicategorytravelplaces'] = 'Kelionės ir vietos';
$string['emptycmids'] = 'Tuščias kurso modulio ID';
$string['emptydragdropregion'] = 'tuščia sritis';
$string['emptysectionids'] = 'Tuščias skyriaus ID';
$string['enable'] = 'Įjungti';
$string['encryptedcode'] = 'Užšifruotas kodas';
$string['enddate'] = 'Kurso pabaigos data';
$string['enddate_help'] = 'Kurso pabaigos data neriboja besimokančiųjų prieigos prie kurso. Ji lemia, ar kursas yra įtrauktas į "Mano kursai" sąrašą kaip praėjęs.';
$string['enddatewithtaskenabled'] = 'Kurso pabaigos data';
$string['enddatewithtaskenabled_help'] = 'Data, kai kursas tampa paslėptas nuo besimokančiųjų ir jie nebegali jo pasiekti.';
$string['english'] = 'Anglų kalba';
$string['enrolmentmethods'] = 'Įregistravimo metodai';
$string['entercourse'] = 'Spustelėkite, kad įvestumėte šiuos kursus';
$string['enteremail'] = 'Įveskite savo el. pašto adresą';
$string['enteremailaddress'] = 'Įveskite savo el. pašto adresą, kad būtų galima iš naujo nustatyti jūsų slaptažodį ir jums el. paštu išsiųsti naują slaptažodį.';
$string['enterusername'] = 'Įveskite savo naudotojo vardą';
$string['entries'] = 'Įrašai';
$string['error'] = 'Klaida';
$string['errorcreatingactivity'] = 'Nepavyko sukurti veiklos "{$a}"';
$string['errorfiletoobig'] = 'Failas yra didesnis nei nustatytas {$a} baitų limitas';
$string['errornouploadrepo'] = 'Šioje svetainėje neįgalinta įkėlimo saugykla';
$string['errorwhenconfirming'] = 'Jūsų dar nepatvirtino, nes įvyko klaida. Jei čia patekote el. laiške spustelėję saitą, įsitikinkite, kad eilutė jūsų el. laiške nebuvo pertraukta ar sulaužyta. Jums gali tekti iškirpti ir įklijuoti norint atkurti tinkamą saitą.';
$string['eventcommentcreated'] = 'Komentaras sukurtas';
$string['eventcommentdeleted'] = 'Komentaras ištrintas';
$string['eventcommentsviewed'] = 'Komentarai peržiūrėti';
$string['eventconfiglogcreated'] = 'Konfigūracijos žurnalas sukurtas';
$string['eventcontentviewed'] = 'Turinys peržiūrėtas';
$string['eventcoursebackupcreated'] = 'Kurso atsarginė kopija sukurta';
$string['eventcoursecategorycreated'] = 'Kategorija sukurta';
$string['eventcoursecategorydeleted'] = 'Kategorija ištrinta';
$string['eventcoursecategoryupdated'] = 'Kategorija atnaujinta';
$string['eventcoursecategoryviewed'] = 'Kategorija peržiūrėta';
$string['eventcoursecontentdeleted'] = 'Kurso turinys ištrintas';
$string['eventcoursecreated'] = 'Kursas sukurtas';
$string['eventcoursedeleted'] = 'Kursas ištrintas';
$string['eventcourseended'] = 'Kursas baigėsi';
$string['eventcourseinformationviewed'] = 'Kurso santrauka peržiūrėta';
$string['eventcoursemodulecreated'] = 'Kurso modulis sukurtas';
$string['eventcoursemoduledeleted'] = 'Kurso modulis ištrintas';
$string['eventcoursemoduleinstancelistviewed'] = 'Kurso modulio egzemplioriaus sąrašas peržiūrėtas';
$string['eventcoursemoduleupdated'] = 'Kurso modulis atnaujintas';
$string['eventcoursemoduleviewed'] = 'Kurso modulis peržiūrėtas';
$string['eventcourseresetended'] = 'Kurso atstatymas baigėsi';
$string['eventcourseresetstarted'] = 'Kurso atstatymas prasidėjo';
$string['eventcourserestored'] = 'Kursas atkurtas';
$string['eventcoursesectioncreated'] = 'Kurso sekcija sukurta';
$string['eventcoursesectiondeleted'] = 'Kurso sekcija ištrinta';
$string['eventcoursesectionupdated'] = 'Kurso sekcija atnaujinta';
$string['eventcoursessearched'] = 'Ieškomi kursai';
$string['eventcoursestarted'] = 'Kursas prasidėjo';
$string['eventcourseupdated'] = 'Kursas atnaujintas';
$string['eventcourseuserreportviewed'] = 'Kurso naudotojo ataskaita peržiūrėta';
$string['eventcourseviewed'] = 'Kursas peržiūrėtas';
$string['eventdashboardreset'] = '"Mano pagrindinis" atstatymas';
$string['eventdashboardsreset'] = 'Darbalaukio nustatymas iš naujo';
$string['eventdashboardviewed'] = 'Mano pagrindinis peržiūrėtas';
$string['eventdatabasetextfieldcontentreplaced'] = 'Duomenų bazės visuotinė paieška ir keitimas';
$string['eventemailfailed'] = 'El. laiško nepavyko išsiųsti';
$string['eventmycoursesviewed'] = 'Mano peržiūrėti kursai';
$string['eventname'] = 'Įvykio pavadinimas';
$string['eventrecentactivityviewed'] = 'Naujausia veikla peržiūrėta';
$string['eventsearchindexed'] = 'Paieškos duomenys pažymėti';
$string['eventsearchresultsviewed'] = 'Paieškos rezultatai peržiūrėti';
$string['eventunknownlogged'] = 'Nežinomas įvykis';
$string['eventurlblocked'] = 'URL buvo užblokuotas';
$string['eventusercreated'] = 'Naudotojas sukurtas';
$string['eventuserdeleted'] = 'Naudotojas ištrintas';
$string['eventuserfeedbackgiven'] = 'Atsiliepimų nuoroda paspausta';
$string['eventuserfeedbackremind'] = 'Priminti vėliau atsiliepimo nuoroda spragtelėta';
$string['eventuserinfocategorycreated'] = 'Naudotojo profilio lauko kategorija sukurta';
$string['eventuserinfocategorydeleted'] = 'Naudotojo profilio lauko kategorija pašalinta';
$string['eventuserinfocategoryupdated'] = 'Naudotojo profilio lauko kategorija atnaujinta';
$string['eventuserinfofieldcreated'] = 'Naudotojo profilio laukas sukurtas';
$string['eventuserinfofielddeleted'] = 'Naudotojo profilio laukas pašalintas';
$string['eventuserinfofieldupdated'] = 'Naudotojo profilio laukas atnaujintas';
$string['eventuserlistviewed'] = 'Naudotojų sąrašas peržiūrėtas';
$string['eventuserloggedout'] = 'Naudotojas atsijungęs';
$string['eventuserpasswordpolicyfailed'] = 'Naudotojo slaptažodis neatitiko reikalavimų slaptažodžiui.';
$string['eventuserpasswordupdated'] = 'Naudotojo slaptažodis atnaujintas';
$string['eventuserprofileviewed'] = 'Naudotojo profilis peržiūrėtas';
$string['eventuserupdated'] = 'Naudotojas atnaujintas';
$string['everybody'] = 'Visi';
$string['executeat'] = 'Vykdyti';
$string['existing'] = 'Esami';
$string['existingadmins'] = 'Esami administratoriai';
$string['existingcourse'] = 'Esami kursai';
$string['existingcourseadding'] = 'Esami kursai, į juos įtraukiami duomenys';
$string['existingcoursedeleting'] = 'Esamas kursas, pirmiausia jis naikinamas';
$string['existingcreators'] = 'Esamų kursų kūrėjai';
$string['existingstudents'] = 'Įregistruoti besimokantieji';
$string['existingteachers'] = 'Esami dėstytojai';
$string['expand'] = 'Išskleisti';
$string['expandall'] = 'Išskleisti viską';
$string['expandcategory'] = 'Išskleisti {$a}';
$string['explanation'] = 'Paaiškinimas';
$string['explanationdigitalminor'] = 'Ši informacija reikalinga norint nustatyti, ar jūsų amžius viršija skaitmeninį sutikimo amžių. Tai amžius, kai asmuo gali sutikti, kad sąlygos ir jo duomenys būtų teisėtai saugomi ir tvarkomi.';
$string['extendperiod'] = 'Pratęsimo laikotarpis';
$string['extendsession'] = 'Tęsti sesiją';
$string['failedloginattempts'] = 'Nepavykusių bandymų prisijungti skaičius nuo paskutinio prisijungimo: {$a->attempts}';
$string['favourites'] = 'Pažymėti žvaigždute';
$string['feedback'] = 'Atsiliepimas';
$string['file'] = 'Failas';
$string['fileexists'] = 'Failas, kurio pavadinimas "{$a}", jau sukurtas';
$string['filemissing'] = '{$a} nėra';
$string['filereaderror'] = 'Nepavyko nuskaityti failo „{$a}“. Patikrinkite, ar tai tikrai failas, o ne aplankas.';
$string['files'] = 'Failai';
$string['filesanduploads'] = 'Įkeliami failai';
$string['filesfolders'] = 'Failai / katalogai';
$string['fileuploadwithcontent'] = 'Įkeliami failai negali turėti turinio parametro';
$string['filloutallfields'] = 'Prašome užpildyti visus šios formos laukus';
$string['filter'] = 'Filtras';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtras {$a}';
$string['filters'] = 'Filtrai';
$string['filtersetmatchdescription'] = 'Kaip derinami keli filtrai';
$string['filtertype'] = 'Filtro tipas';
$string['findmorecourses'] = 'Rasti daugiau kursų...';
$string['first'] = 'Pirma';
$string['firstaccess'] = 'Pirma prieiga';
$string['firstname'] = 'Vardas';
$string['firstnamephonetic'] = 'Vardas - fonetiškai';
$string['firstpage'] = 'Pirmasis puslapis';
$string['firstsiteaccess'] = 'Pirma prieiga prie svetainės';
$string['firsttime'] = 'Ar jūs čia pirmą kartą?';
$string['folder'] = 'Aplankas';
$string['folderclosed'] = 'Uždarytas aplankas';
$string['folderopened'] = 'Atidarytas aplankas';
$string['followingoptional'] = 'Šie elementai yra pasirinktiniai';
$string['followingrequired'] = 'Šie elementai yra būtini';
$string['for'] = 'Kam';
$string['force'] = 'Vykdyti priverstinai';
$string['forcelanguage'] = 'Reikalauti naudoti kalbą';
$string['forceno'] = 'Nevykdyti priverstinai';
$string['forcepasswordchange'] = 'Reikalauti keisti slaptažodį';
$string['forcepasswordchange_help'] = 'Jei šis žymės langelis pažymėtas, naudotoją paragins pakeisti slaptažodį jam prisijungus kitą kartą';
$string['forcepasswordchangecheckfull'] = 'Ar esate visiškai tikri, kad norite reikalauti pakeisti slaptažodį į {$a}?';
$string['forcepasswordchangenot'] = 'Nepavyko reikalauti pakeisti slaptažodį į {$a}';
$string['forcepasswordchangenotice'] = 'Norėdami tęsti, turite pakeisti slaptažodį.';
$string['forcepasswordresetfailurenotice'] = 'Dabartinis slaptažodis nebeatitinka nustatytų reikalavimų slaptažodžiui. Pagalbos galite kreiptis į „Moodle“ administratorių.
    {$a}';
$string['forcepasswordresetnotice'] = 'Jūsų dabartinis slaptažodis nebeatitinka nustatytų reikalavimų slaptažodžiui turite iš naujo nustatyti slaptažodį, norėdami prisijungti.
    {$a}';
$string['forcetheme'] = 'Priverstinai naudoti temą';
$string['forgotaccount'] = 'Pamiršote slaptažodį?';
$string['forgotten'] = 'Pamiršote savo naudotojo vardą ar slaptažodį?';
$string['forgottenduplicate'] = 'Šis el. pašto adresas naudojamas keliose paskyrose, vietoj jo įveskite naudotojo vardą';
$string['forgotteninvalidurl'] = 'Klaidingas slaptažodžio nustatymo iš naujo URL';
$string['format'] = 'Formatas';
$string['format_help'] = 'Kursų formatas nulemia kursų puslapio išdėstymą. * SCORM formatas – pirmoje kursų puslapio dalyje rodomas SCORM paketas (alternatyva SCORM / AICC moduliui). * Socialinis formatas – kursų puslapyje rodomas forumas. * Temų formatas – kursų puslapis išdėstytas dalimis pagal temas. * Savaitinis formatas – kursų puslapis suskirstytas savaitinėmis dalimis, pirma savaitė prasideda kursų pradžios datą.';
$string['formathtml'] = 'HTML formatas';
$string['formatmarkdown'] = '„Markdown“ formatas';
$string['formatplain'] = 'Paprastojo teksto formatas';
$string['formattext'] = '„Moodle“ automatinis formatas';
$string['forumpreferences'] = 'Forumo nustatymai';
$string['framesetinfo'] = 'Šis rėmelių rinkinio dokumentas apima:';
$string['from'] = 'Nuo';
$string['frontpagecategorycombo'] = 'Išskleidžiamasis sąrašas';
$string['frontpagecategorynames'] = 'Kategorijų sąrašas';
$string['frontpagecourselist'] = 'Kursų sąrašas';
$string['frontpagecoursesearch'] = 'Kurso paieškos laukelis';
$string['frontpagedescription'] = 'Svetainės pirmojo puslapio santrauka';
$string['frontpagedescriptionhelp'] = 'Ši santrauka gali būti rodoma svetainės pagrindiniame puslapyje, naudojant kurso / svetainės santraukos bloką.';
$string['frontpageenrolledcourselist'] = 'Mano kursai';
$string['frontpageformat'] = 'Svetainės pradinio puslapio formatas';
$string['frontpageformatloggedin'] = 'Svetainės pradinio puslapio formatas prisijungus';
$string['frontpagenews'] = 'Skelbimai';
$string['frontpagesettings'] = 'Svetainės pradinio puslapio parametrai';
$string['fulllistofcourses'] = 'Visi kursai';
$string['fullname'] = 'Visas pavadinimas';
$string['fullnamecourse'] = 'Visas kurso pavadinimas';
$string['fullnamecourse_help'] = 'Pavadinimas rodomas Mano kursai ir galimų kursų sąraše pagrindiniame puslapyje.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Visas naudotojo vardas';
$string['fullprofile'] = 'Visas profilis';
$string['fullsitename'] = 'Visas svetainės pavadinimas';
$string['functiondisabled'] = 'Ši funkcija šiuo metu išjungta';
$string['general'] = 'Bendra';
$string['geolocation'] = 'platuma – ilguma';
$string['gettheselogs'] = 'Gauti šiuos žurnalus';
$string['go'] = 'Vykdyti';
$string['gpl'] = 'Autoriaus teisės (C) nuo 1999 m. priklauso Martin Dougiamas (https://moodle.com)

Ši programa yra nemokama programinė įranga; ją galima platinti ir (arba) modifikuoti, laikantis GNU bendrosios viešosios licencijos sąlygų, išleistų Laisvosios programinės įrangos fondo. Tai gali būti 2-a ar (jūsų pasirinkta) bet kuri kita vėlesnė Licencijos versija.

Ši programa platinama tikintis, kad ji bus naudinga, bet BE JOKIŲ GARANTIJŲ, netgi be numanomos garantijos DĖL TINKAMUMO PARDUOTI ar TINKAMUMO KONKREČIAM TIKSLUI.

Išsamią informaciją rasite "Moodle" licencijos informacijos puslapyje: https://moodledev.io/general/license';
$string['gpl3'] = 'Autorių teisės (C) nuo 1999 m. Martin Dougiamas (https://moodle.com)

Ši programa yra nemokama programinė įranga: galite ją platinti ir (arba) modifikuoti pagal GNU bendrosios viešosios licencijos sąlygas, paskelbtas Free Software Foundation, 3 licencijos versiją arba (jūsų pasirinkimu) bet kurią vėlesnę versiją.

Ši programa platinama tikintis, kad ji bus naudinga, bet BE JOKIOS GARANTIJOS; net be numanomos TINKAMUMO PARDUOTI ar TINKAMUMO TAM TIKSLUI garantijos.

Daugiau informacijos rasite Moodle licencijos informacijos puslapyje: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL licencija';
$string['gradenoun'] = 'Įvertinimas';
$string['grades'] = 'Įvertinimai';
$string['gradeverb'] = 'Įvertinimas';
$string['gravatarenabled'] = 'Šioje svetainėje įgalintas <a href="https://www.gravatar.com/">Gravatar</a>. Jei neįkelsite profilio nuotraukos, „Moodle“ bandys įkelti jums profilio nuotrauką iš „Gravatar“.';
$string['group'] = 'Grupė';
$string['groupadd'] = 'Įtraukti naują grupę';
$string['groupaddusers'] = 'Įtraukti pasirinktus į grupę';
$string['groupfor'] = 'grupės';
$string['groupinfo'] = 'Informacija apie pasirinktą grupę';
$string['groupinfoedit'] = 'Redaguoti grupės parametrus';
$string['groupinfomembers'] = 'Informacija apie pasirinktus narius';
$string['groupinfopeople'] = 'Informacija apie pasirinktus žmones';
$string['groupmembers'] = 'Grupės nariai';
$string['groupmemberssee'] = 'Rodyti grupės narius';
$string['groupmembersselected'] = 'Pasirinktos grupės nariai';
$string['groupmode'] = 'Grupės režimas';
$string['groupmodeforce'] = 'Taikyti grupės režimą';
$string['groupmy'] = 'Mano grupė';
$string['groupnonmembers'] = 'Asmenys nesantys grupėje';
$string['groupnotamember'] = 'Atsiprašome, bet jūs nesate tos grupės narys';
$string['grouprandomassign'] = 'Atsitiktine tvarka priskirti visoms grupėms';
$string['groupremove'] = 'Pašalinti pasirinktą grupę';
$string['groupremovemembers'] = 'Pašalinti pasirinktus narius';
$string['groups'] = 'Kurso grupės';
$string['groupsnone'] = 'Nėra grupių';
$string['groupsseparate'] = 'Atskiros grupės';
$string['groupsvisible'] = 'Matomos grupės';
$string['guest'] = 'Svečias';
$string['guestdescription'] = 'Svečiai turi mažiausiai teisių ir paprastai negali niekur įvesti teksto.';
$string['guestskey'] = 'Leisti svečius, kurie turi raktą';
$string['guestsno'] = 'Neleisti svečių';
$string['guestsnotallowed'] = 'Atsiprašome, {$a} neleidžia įeiti svečiams.';
$string['guestsyes'] = 'Leisti svečius, kurie neturi rakto';
$string['guestuser'] = 'Svečio paskyra';
$string['guestuserinfo'] = 'Šis naudotojas yra specialusis naudotojas, o tai suteikia tik skaitymo prieigą prie kai kurių kursų.';
$string['help'] = 'Žinynas';
$string['helpprefix2'] = 'Žinynas apie {$a}';
$string['helpwiththis'] = 'Žinynas apie tai';
$string['hiddenassign'] = 'Paslėptas priskyrimas';
$string['hiddenfromstudents'] = 'Paslėpta nuo besimokančiųjų';
$string['hiddenoncoursepage'] = 'Prieinama, bet nerodoma kurso puslapyje';
$string['hiddensections'] = 'Paslėptos dalys';
$string['hiddensections_help'] = 'Paslėptos dalys besimokantiesiems gali būti rodomos kurso puslapyje kaip „nepasiekiamos" arba gali būti visiškai paslėptos.';
$string['hiddensectionscollapsed'] = 'Paslėptos dalys rodomos kaip nepasiekiamos';
$string['hiddensectionsinvisible'] = 'Paslėptos dalys yra visiškai nematomos';
$string['hiddenwithbrackets'] = '(paslėpta)';
$string['hide'] = 'Slėpti';
$string['hideadvancedsettings'] = 'Slėpti išplėstinius parametrus';
$string['hidechartdata'] = 'Slėpti diagramos duomenis';
$string['hidefromstudents'] = 'Paslėpti kurso puslapyje';
$string['hideoncoursepage'] = 'Padaryti prieinamą, bet nerodyti kurso puslapyje';
$string['hidepopoverwindow'] = 'Slėpti iššokantį langą';
$string['hidesection'] = 'Slėpti dalį {$a}';
$string['hidesettings'] = 'Slėpti parametrus';
$string['hideshowblocks'] = 'Slėpti arba rodyti blokus';
$string['highlight'] = 'Paryškinti';
$string['highlighted'] = 'Paryškinta';
$string['highlightoff'] = 'Šalinti paryškinimą';
$string['hits'] = 'Apsilankymai';
$string['hitsoncourse'] = '{$a->username} apsilankymai {$a->coursename}';
$string['hitsoncoursetoday'] = 'Šiandienos {$a->username} apsilankymai {$a->coursename}';
$string['home'] = 'Pagrindinis';
$string['homeheader'] = 'Pagrindinis meniu';
$string['hour'] = 'valanda';
$string['hours'] = 'valandos';
$string['howtomakethemes'] = 'Kaip kurti naujas temas';
$string['htmleditor'] = 'Naudoti HTML rengyklę (tik kai kuriose naršyklėse)';
$string['htmleditoravailable'] = 'Yra HTML rengyklė';
$string['htmleditordisabled'] = 'Jūs išjungėte HTML rengyklę savo naudotojo profilyje';
$string['htmleditordisabledadmin'] = 'Administratorius išjungė HTML rengyklę šioje svetainėje';
$string['htmleditordisabledbrowser'] = 'HTML rengyklė nepasiekiama, nes jūsų žiniatinklio naršyklė nesuderinama';
$string['htmlfilesonly'] = 'Tik HTML failai';
$string['htmlformat'] = 'Gražus HTML formatas';
$string['icon'] = 'Piktograma';
$string['idnumber'] = 'ID numeris';
$string['idnumbercourse'] = 'Kursų ID numeris';
$string['idnumbercourse_help'] = 'Naudojamas tik kursui sujungti su išorinėmis sistemomis. Palikite tuščią, jei neturite oficialaus kurso ID.';
$string['idnumbercoursecategory'] = 'Kategorijos ID numeris';
$string['idnumbercoursecategory_help'] = 'Kursų ID numeris naudojamas tik suderinant kategorijas su išorinėmis sistemomis ir nerodomas niekur svetainėje. Jei kategorijos turi oficialų kodinį pavadinimą, jį galima įvesti, kitu atveju šį lauką galima palikti tuščią.';
$string['idnumbergroup'] = 'Grupės ID numeris';
$string['idnumbergroup_help'] = 'Grupės ID numeris yra naudojamas tik tuomet, kai grupė lyginama su išorinėmis sistemomis ir jis nėra matomas šioje svetainėje. Jei grupė turi oficialų kodinį pavadinimą, jis gali būti įvestas čia. Priešingu atveju palikite šį lauką tuščią.';
$string['idnumbergrouping'] = 'Grupavimo ID numeris';
$string['idnumbergrouping_help'] = 'Grupavimo  ID numeris yra naudojamas tik tuomet, kai grupavimas lyginamas su išorinėmis sistemomis ir jis nėra matomas šioje svetainėje. Jei grupavimas turi oficialų kodinį pavadinimą, jis gali būti įvestas čia. Priešingu atveju palikite šį lauką tuščią.';
$string['idnumbermod'] = 'ID numeris';
$string['idnumbermod_help'] = 'Nustačius ID numerį, galima identifikuoti veiklą arba išteklių tokiais tikslais kaip įverčių skaičiavimas arba pasirinktinėms ataskaitoms. Priešingu atveju laukas gali būti paliktas tuščias.

Vertinamų veiklų ID numerį taip pat galima nustatyti įverčių knygelėje, tačiau jį redaguoti galima tik veiklos nustatymų puslapyje.';
$string['idnumbertaken'] = 'Šis ID numeris jau naudojamas';
$string['imagealt'] = 'Paveikslėlio aprašas';
$string['import'] = 'Importuoti';
$string['importdata'] = 'Importuoti kursų duomenis';
$string['importdataexported'] = 'Duomenys eksportuoti iš šaltinio kursų.<br /> Toliau importuojama į jūsų tikslinius kursus.';
$string['importdatafinished'] = 'Baigta importuoti, toliau eikite į savo kursus';
$string['importdatafrom'] = 'Rasti kursus, iš kurių importuoti duomenis:';
$string['inactive'] = 'Neaktyvu';
$string['include'] = 'Įtraukti';
$string['includeallusers'] = 'Įtraukti visus naudotojus';
$string['includecoursefiles'] = 'Įtraukti kursų failus';
$string['includecourseusers'] = 'Įtraukti kursų naudotojus';
$string['included'] = 'Įtraukta';
$string['includelogentries'] = 'Įtraukti žurnalo įrašus';
$string['includemodules'] = 'Įtraukti modulius';
$string['includemoduleuserdata'] = 'Įtraukti modulių naudotojų duomenis';
$string['includeneededusers'] = 'Įtraukti reikiamus naudotojus';
$string['includenoneusers'] = 'Neįtraukti jokių naudotojų';
$string['includeroleassignments'] = 'Įtraukti vaidmens priskyrimus';
$string['includesitefiles'] = 'Įtraukti šiuose kursuose naudojamus svetainės failus';
$string['includesubcategories'] = 'Įtraukti subkategorijas';
$string['includeuserfiles'] = 'Įtraukti naudotojo failus';
$string['increasesections'] = 'Padidinti sekcijų skaičių';
$string['indicator:accessesafterend'] = 'Kursas pasiekiamas po pabaigos datos';
$string['indicator:accessesafterend_help'] = 'Šis rodiklis parodo, ar besimokantysis įstojo į kursą po kurso pabaigos datos.';
$string['indicator:accessesbeforestart'] = 'Kursas pasiekiamas prieš pradžios datą';
$string['indicator:accessesbeforestart_help'] = 'Šis rodiklis parodo, ar besimokantysis įstojo į kursą prieš kurso pradžios datą.';
$string['indicator:activitiesdue'] = 'Veiklos įvykdyti';
$string['indicator:activitiesdue_help'] = 'Naudotojas turi įvykdyti veiklas.';
$string['indicator:anycourseaccess'] = 'Bet kokia prieiga prie kurso';
$string['indicator:anycourseaccess_help'] = 'Šis indikatorius rodo prieigą prie bet kurio kurso, kuriame naudotojas užsiregistravo.';
$string['indicator:anywrite'] = 'Bet koks rašymo veiksmas';
$string['indicator:anywrite_help'] = 'Šis rodiklis rodo bet kokį besimokančiojo atliktą rašymo (pateikimo) veiksmą.';
$string['indicator:anywriteincourse'] = 'Bet koks rašymo veiksmas kurse';
$string['indicator:anywriteincourse_help'] = 'Šis rodiklis rodo bet kokį rašymo (pateikimo) veiksmą, kurio besimokantysis imasi bet kurioje kurso veikloje.';
$string['indicator:completeduserprofile'] = 'Naudotojo profilis baigtas';
$string['indicator:completeduserprofile_help'] = 'Šis indikatorius rodo, kad besimokantysis užpildė savo naudotojo profilį.';
$string['indicator:completeduserprofiledef'] = 'Naudotojo profilis užpildytas';
$string['indicator:completeduserprofiledef_help'] = 'Su svetainės politika buvo sutikta, o naudotojas užpildė šiuos laukus: įstaiga, skyrius, adresas, miestas, šalis, URL.';
$string['indicator:completionenabled'] = 'Užbaigimo sekimas įjungtas';
$string['indicator:completionenabled_help'] = 'Šis indikatorius rodo, kad buvo įjungtas šio kurso baigimo sekimas.';
$string['indicator:nostudent'] = 'Besimokančiųjų registracija';
$string['indicator:nostudent_help'] = 'Šis indikatorius parodo besimokančiųjų prieinamumą kurse.';
$string['indicator:noteacher'] = 'Dėstytojų prieinamumas';
$string['indicator:noteacher_help'] = 'Šis indikatorius parodo dėstytojų prieinamumą kurse.';
$string['indicator:potentialcognitive'] = 'Kurso potencialus pažinimo gylis';
$string['indicator:potentialcognitive_help'] = 'Šis rodiklis pagrįstas potencialiu pažinimo gyliu, kurį galėtų pasiekti studentas, dalyvaujantis kurso veikloje.';
$string['indicator:potentialcognitivedef'] = 'Kurso potencialus pažinimo gylis';
$string['indicator:potentialcognitivedef_help'] = 'Kurso „gilaus“ pažinimo įsitraukimo laipsnis, pvz. darbo pateikimas atsiliepimui gauti, galimybė peržiūrėti kitų darbus ir galimybė peržiūrėti bei pateikti darbus iš naujo.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Kurso potencialus socialinis plotis';
$string['indicator:potentialsocial_help'] = 'Šis rodiklis pagrįstas potencialiu socialiniu plotu, kurį galėtų pasiekti besimokantysis, dalyvaujantis kurso veikloje.';
$string['indicator:potentialsocialdef'] = 'Kurso potencialus socialinis plotis';
$string['indicator:potentialsocialdef_help'] = 'Kurso „plataus“ socialinio įsitraukimo laipsnis, bendravimas su kitais dalyviais ir praktikos bendruomene už klasės ribų.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Skaityti veiksmų kiekį';
$string['indicator:readactions_help'] = 'Šis rodiklis parodo besimokančiojo skaitymo (peržiūros) veiksmų skaičių.';
$string['indicator:userforumstracking'] = 'Naudotojas seka forumus';
$string['indicator:userforumstracking_help'] = 'Šis rodiklis parodo, ar besimokantysis įjungė stebėjimą forumuose, ar ne.';
$string['info'] = 'Informacija';
$string['inprogress'] = 'Vykdoma';
$string['insertresourceoractivitybefore'] = 'Įterpti veiklą arba išteklių prieš „{$a->activityname}“';
$string['institution'] = 'Institucija';
$string['instudentview'] = 'besimokančiojo rodinyje';
$string['interests'] = 'Pomėgiai';
$string['interestslist'] = 'Pomėgių sąrašas';
$string['interestslist_help'] = 'Įveskite savo pomėgius po vieną, kurie bus rodomi jūsų profilio puslapyje kaip žymės.';
$string['invalidemail'] = 'Neteisingas el. pašto adresas';
$string['invalidlogin'] = 'Neteisingi prisijungimo duomenys, bandykite dar kartą';
$string['invalidtaskclassname'] = 'Netinkama užduoties klasė {$a}';
$string['invalidtaskid'] = 'Netinkamas užduoties ID';
$string['invalidusername'] = 'Naudotojo vardą gali sudaryti tik mažosios raidės ir skaičiai, apatinis brūkšnys (_), brūkšnelis (-), taškas (.) ar „eta“ simbolis (@).';
$string['invalidusernameupload'] = 'Netinkamas naudotojo vardas';
$string['ip_address'] = 'IP adresas';
$string['jump'] = 'Pereiti';
$string['jumpto'] = 'Pereiti į...';
$string['keep'] = 'Palikti';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Kalbos kryptis iš kairės į dešinę';
$string['langrtl'] = 'Kalbos kryptis iš dešinės į kairę';
$string['language'] = 'Kalba';
$string['languagegood'] = 'Šis kalbos paketas yra atnaujintas!';
$string['languageselector'] = 'Kalbos pasirinkimas';
$string['last'] = 'Paskutinis';
$string['lastaccess'] = 'Paskutinė prieiga';
$string['lastcourseaccess'] = 'Paskutinis apsilankymas kurse';
$string['lastedited'] = 'Paskutinį kartą redaguota';
$string['lastip'] = 'Paskutinis IP adresas';
$string['lastlogin'] = 'Paskutinis koregavimas';
$string['lastmodified'] = 'Paskutinį kartą keista';
$string['lastname'] = 'Pavardė';
$string['lastnamephonetic'] = 'Pavardė - fonetiškai';
$string['lastpage'] = 'Paskutinis puslapis';
$string['lastsiteaccess'] = 'Paskutinis apsilankymas svetainėje';
$string['lastyear'] = 'Pernai';
$string['latestlanguagepack'] = 'Naujausio kalbos paketo ieškokite moodle.org';
$string['layouttable'] = 'Maketo lentelė';
$string['leavetokeep'] = 'Palikti tuščia, kad būtų paliktas dabartinis slaptažodis';
$string['legacylogginginuse'] = 'Šioje svetainėje šiuo metu įgalintas rašymas į seną žurnalų saugyklą. Rašymas į šią žurnalų saugyklą nebenaudojamas. Parašykite į palaikomą žurnalų saugyklą, pvz., „standartinis“ arba „išorinis“.';
$string['legacythemeinuse'] = 'Ši svetainė jums rodoma suderinamumo režimu, nes jūsų naršyklė yra per sena.';
$string['license'] = 'Licencija';
$string['licenses'] = 'Licencijos';
$string['liketologin'] = 'Ar norėtumėte dabar prisijungti?';
$string['list'] = 'Sąrašas';
$string['listfiles'] = 'Failų sąrašas {$a}';
$string['listofallpeople'] = 'Visų žmonių sąrašas';
$string['listofcourses'] = 'Paskaitų sąrašas';
$string['loading'] = 'Kraunasi';
$string['loadinghelp'] = 'Įkeliama...';
$string['local'] = 'Vietinis';
$string['localplugins'] = 'Vietiniai papildiniai';
$string['localpluginsmanage'] = 'Valdyti vietinius papildinius';
$string['location'] = 'Vieta';
$string['locktimeout'] = 'Laukiant baigėsi operacijos laikas.';
$string['log_excel_date_format'] = 'MM mm dd h:mm';
$string['loggedinas'] = 'Prisijungė: {$a}';
$string['loggedinasguest'] = 'Šiuo metu naudojatės svečio prieiga';
$string['loggedinnot'] = 'Esate neprisijungę.';
$string['login'] = 'Prisijungti';
$string['login_failure_logs'] = 'Nepavykusių prisijungimų žurnalai';
$string['loginactivity'] = 'Naudotojo veikla';
$string['loginagain'] = 'Prisijungti dar kartą';
$string['loginalready'] = 'Jau esate prisijungę';
$string['loginas'] = 'Prisijungti kaip';
$string['loginaspasswordexplain'] = '<p>Norėdami naudoti šią funkciją turite įvesti specialų prisijungimo slaptažodį.<br />Jei jo nežinote, paklauskite savo serverio administratoriaus.</p>';
$string['loginguest'] = 'Svečio prieiga';
$string['loginsite'] = 'Prisijungti prie svetainės';
$string['loginsteps'] = 'Jei norite gauti visą prieigą prie svetainės, turite pirmiausiai sukurti savo paskyrą.';
$string['loginstepsnone'] = '<p>Sveiki!</p> <p>Kad gautumėte visą prieigą prie kursų, turite sukurti savo paskyrą.</p> <p>Tam tereikia sukurti naudotojo vardą bei slaptažodį ir juos naudoti šio puslapio formoje.</p> <p>Jei kas nors kitas jau pasirinko jūsų naudotojo vardą, turėsite bandyti dar kartą, naudodami kitą naudotojo vardą.</p>';
$string['loginto'] = 'Prisijungti prie {$a}';
$string['logoof'] = '{$a} logotipas';
$string['logout'] = 'Atsijungti';
$string['logoutconfirm'] = 'Ar tikrai nori atsijungti?';
$string['logs'] = 'Žurnalai';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">daugiau</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">daugiau</a> ]';
$string['lookback'] = 'Terminas';
$string['mailadmins'] = 'Informuoti administratorius';
$string['mailstudents'] = 'Informuoti besimokančiuojus';
$string['mailteachers'] = 'Informuoti dėstytojus';
$string['maincoursepage'] = 'Pagrindinis kurso puslapis';
$string['makeafolder'] = 'Kurti aplanką';
$string['makeavailable'] = 'Padaryti prieinamą';
$string['makeavailablecmtitle'] = 'Padaryti veiklą prieinamą';
$string['makeeditable'] = 'Jei nustatysite, kad {$a} galėtų redaguoti žiniatinklio serverio procesas (pvz., „Apache“), galėsite šį failą redaguoti tiesiogiai iš šio puslapio.';
$string['makethismyhome'] = 'Padaryti mano pagrindiniu puslapiu';
$string['makeunavailable'] = 'Padaryti neprieinamą';
$string['manageblocks'] = 'Blokai';
$string['managecategories'] = 'Tvarkyti kursų kategorijas';
$string['managecategorythis'] = 'Tvarkyti šią kategoriją';
$string['managecombined'] = 'Tvarkykite kursų kategorijas ir kursus';
$string['managecontentbanktypes'] = 'Tvarkyti turinio tipus';
$string['managecourses'] = 'Valdyti kursus';
$string['managedatabase'] = 'Duomenų bazė';
$string['managedataformats'] = 'Valdyti duomenų formatus';
$string['manageeditorfiles'] = 'Valdyti rengyklės naudojamus failus';
$string['managefilters'] = 'Filtrai';
$string['managemodules'] = 'Moduliai';
$string['manageroles'] = 'Vaidmenys ir teisės';
$string['markallread'] = 'Pažymėti visus kaip skaitytus';
$string['markedthistopic'] = 'Ši tema paryškinta kaip dabartinė tema';
$string['markthistopic'] = 'Paryškinti šią temą kaip dabartinę';
$string['match'] = 'Atitinka';
$string['matchingsearchandrole'] = '{$a->search} ir {$a->role} gretinimas';
$string['matchofthefollowing'] = 'iš šių:';
$string['maxareabytesreached'] = 'Failas (arba bendras kelių failų dydis) yra didesnis nei šioje srityje likusi erdvė.';
$string['maxfilesize'] = 'Maksimalus naujų failų dydis: {$a}';
$string['maxfilesreached'] = 'Jums leidžiama prikabinti maksimaliai {$a} failų (-ą) prie šio elemento';
$string['maximumchars'] = 'Maksimalus simbolių skaičius: {$a}';
$string['maximumgrade'] = 'Didžiausias įvertinimas';
$string['maximumgradex'] = 'Didžiausias įvertinimas: {$a}';
$string['maximumshort'] = 'Maks.';
$string['maximumupload'] = 'Maksimalus įkeliamų duomenų dydis';
$string['maximumupload_help'] = 'Didžiausias leistinas failo dydis, kurį besimokantysis gali įkelti į kursą. Papildomai galite dar labiau apriboti maksimalų įkeliamo failo dydį kiekvienai veiklai.';
$string['maxnumberweeks'] = 'Didžiausias dalių skaičius';
$string['maxnumberweeks_desc'] = 'Didžiausias išskleidžiamojo meniu skyrių skaičius (taikoma tik tam tikriems kurso formatams).';
$string['maxnumcoursesincombo'] = 'Peržiūrėti <a href="{$a->link}">{$a->numberofcourses} paskaitas</a>.';
$string['maxsectionslimit'] = 'Negalima sukurti naujos temos, nes ji viršytų didžiausią leistiną šio kurso temų skaičių ({$a}).';
$string['maxsize'] = 'Maks. dydis: {$a}';
$string['maxsizeandareasize'] = 'Maksimalus naujo failo dydis: {$a->size}, bendras apribojimas: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksimalus failo dydis: {$a->size}, maksimalus priedų skaičius: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimalus failo dydis: {$a->size}, maksimalus priedų skaičius: {$a->attachments}, bendras apribojimas: {$a->areasize}';
$string['memberincourse'] = 'Asmenys kursuose';
$string['menu'] = 'Meniu';
$string['message'] = 'Žinutė';
$string['messagebody'] = 'Žinutės tekstas';
$string['messagedselectedusers'] = 'Pasirinktiems naudotojams išsiųstos žinutės ir iš naujo nustatytas gavėjų sąrašas.';
$string['messagedselectedusersfailed'] = 'Siunčiant žinutes pasirinktiems naudotojams įvyko kažkokia triktis. Kai kurie naudotojai galėjo gauti el. laišką.';
$string['messageprovider:asyncbackupnotification'] = 'Asinchroniniai atsarginės kopijos / atkūrimo pranešimai';
$string['messageprovider:availableupdate'] = 'Yra naujų atnaujinimo pranešimų';
$string['messageprovider:backup'] = 'Pranešimai apie atsargines kopijas';
$string['messageprovider:badgecreatornotice'] = 'Pasiekimo kūrėjo pranešimai';
$string['messageprovider:badgerecipientnotice'] = 'Pasiekimo gavėjo pranešimai';
$string['messageprovider:competencyplancomment'] = 'Mokymosi plane paskelbtas komentaras';
$string['messageprovider:competencyusercompcomment'] = 'Kompetencijoje paskelbtas komentaras';
$string['messageprovider:coursecompleted'] = 'Kursas baigtas';
$string['messageprovider:coursecontentupdated'] = 'Kurso turinio pakeitimai';
$string['messageprovider:courserequestapproved'] = 'Pranešimas apie kursų kūrimo užklausos patvirtinimą';
$string['messageprovider:courserequested'] = 'Pranešimas apie kursų kūrimo užklausą';
$string['messageprovider:courserequestrejected'] = 'Pranešimas apie kursų kūrimo užklausos atmetimą';
$string['messageprovider:errors'] = 'Yra rimtų svetainės klaidų';
$string['messageprovider:errors_help'] = 'Tai rimtos klaidos, apie kurias turėtų sužinoti administratorius.';
$string['messageprovider:gradenotifications'] = 'Įvertinimų pranešimai';
$string['messageprovider:infected'] = 'Pranešimai apie antivirusines klaidas.';
$string['messageprovider:insights'] = 'Prognozių modelių sukurtos įžvalgos';
$string['messageprovider:instantmessage'] = 'Asmeninės naudotojų tarpusavio žinutės';
$string['messageprovider:instantmessage_help'] = 'Ši dalis konfigūruoja, kas nutinka su žinutėmis, kurios kitų šios svetainės naudotojų siunčiamos tiesiogiai jums.';
$string['messageprovider:messagecontactrequests'] = 'Žinutės kontakto užklausos pranešimas';
$string['messageprovider:newlogin'] = 'Nauji prisijungimo pranešimai';
$string['messageprovider:notices'] = 'Pranešimai apie nedideles problemas';
$string['messageprovider:notices_help'] = 'Pranešimai, kuriuos gali norėti pamatyti administratorius.';
$string['messageprovider:reportbuilderschedule'] = 'Tinkinti ataskaitų kūrimo priemonės tvarkaraščiai';
$string['messageselect'] = 'Pasirinkti šį naudotoją kaip žinutės gavėją';
$string['messageselectadd'] = 'Siųsti žinutę';
$string['middlename'] = 'Antrasis vardas';
$string['migratinggrades'] = 'Įvertinimų perkėlimas';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minutė';
$string['minutes'] = 'minutės';
$string['miscellaneous'] = 'Kita';
$string['missingcategory'] = 'Turite pasirinkti kategoriją';
$string['missingdescription'] = 'Nėra aprašo';
$string['missingemail'] = 'Nėra el. pašto adreso';
$string['missingfirstname'] = 'Nėra pavadinimo';
$string['missingfromdisk'] = 'Nėra diske';
$string['missingfullname'] = 'Nėra viso vardo';
$string['missinglastname'] = 'Trūksta pavardės';
$string['missingname'] = 'Nėra vardo';
$string['missingnewpassword'] = 'Nėra naujo slaptažodžio';
$string['missingpassword'] = 'Nėra slaptažodžio';
$string['missingrecaptchachallengefield'] = 'Nepavykęs „reCAPTCHA“ bandymas, bandykite dar kartą.';
$string['missingreqreason'] = 'Nėra priežasties';
$string['missingshortname'] = 'Nėra trumpojo pavadinimo';
$string['missingshortsitename'] = 'Nėra trumpojo svetainės pavadinimo';
$string['missingsitedescription'] = 'Nėra svetainės aprašo';
$string['missingsitename'] = 'Nėra svetainės pavadinimo';
$string['missingstrings'] = 'Tikrinti, ar nėra neišverstų žodžių ar frazių';
$string['missingstudent'] = 'Reikia kažką pasirinkti';
$string['missingsummary'] = 'Nėra suvestinės';
$string['missingteacher'] = 'Reikia kažką pasirinkti';
$string['missingurl'] = 'Nėra URL';
$string['missingusername'] = 'Nėra naudotojo vardo';
$string['moddoesnotsupporttype'] = '{$a->modname} modulis nepalaiko {$a->type} tipo įkėlimų';
$string['modhide'] = 'Slėpti';
$string['modified'] = 'Modifikuota';
$string['modshow'] = 'Rodyti';
$string['modshowcmtitle'] = 'Rodyti veiklą';
$string['moduleintro'] = 'Aprašas';
$string['modulesetup'] = 'Nustatomos modulių lentelės';
$string['modulesuccess'] = '{$a} lentelės buvo sėkmingai nustatytos';
$string['modulesused'] = 'Naudojami moduliai';
$string['modvisible'] = 'Pasiekiamumas';
$string['modvisible_help'] = '* Rodyti kurso puslapyje: prieinama besimokantiesiems (atsižvelgiant į prieigos apribojimus, kurie gali būti nustatyti).
* Slėpti kurso puslapyje: neprieinama besimokantiesiems.';
$string['modvisiblehiddensection'] = 'Pasiekiamumas';
$string['modvisiblehiddensection_help'] = '* Slėpti kurso puslapyje: neprieinama besimokantiesiems.
* Padaryti prieinamą, bet nerodyti kurso puslapyje: pasiekiama besimokantiesiems, jei pateikiate nuorodą. Veikla vis tiek bus rodoma įvertinimų knygelėje ir kitose ataskaitose.';
$string['modvisiblewithstealth'] = 'Pasiekiamumas';
$string['modvisiblewithstealth_help'] = '* Rodyti kurso puslapyje: prieinama besimokantiesiems (atsižvelgiant į prieigos apribojimus, kurie gali būti nustatyti).
* Slėpti kurso puslapyje: neprieinama besimokantiesiems.
* Padaryti prieinamą, bet nerodyti kurso puslapyje: pasiekiama besimokantiesiems, jei pateikiate nuorodą. Veikla vis tiek bus rodoma įvertinimų knygelėje ir kitose ataskaitose.';
$string['month'] = 'Mėnuo';
$string['months'] = 'Mėnesiai';
$string['moodledocs'] = '„Moodle“ dokumentai';
$string['moodledocslink'] = 'Šio puslapio dokumentacija';
$string['moodlelogo'] = 'MOODLE logo';
$string['moodlenet:cannotconnecttoserver'] = 'Nepavyksta prisijungti prie MoodleNet serverio';
$string['moodlenet:columnname'] = 'Pavadinimas';
$string['moodlenet:columnsenddate'] = 'Siuntimo data';
$string['moodlenet:columnsendstatus'] = 'Siuntimo būsena';
$string['moodlenet:columntype'] = 'Tipas';
$string['moodlenet:deletedactivity'] = 'Ištrinta veikla';
$string['moodlenet:deletedcourse'] = 'Ištrintas kursas';
$string['moodlenet:eventresourceexported'] = 'Išteklius eksportuotas';
$string['moodlenet:gotomoodlenet'] = 'Eiti į MoodleNet juodraščius';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet leidėjas nėra įgaliotas';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet leidėjas neįjungtas';
$string['moodlenet:issuerisnotset'] = '"MoodleNet" išdavėjas nenustatytas svetainės administravime';
$string['moodlenet:nosharedresources'] = 'Šiuo metu bendrinamų išteklių, kuriuos būtų galima rodyti, nėra.';
$string['moodlenet:outboundsettings'] = 'MoodleNet siuntimo nustatymai';
$string['moodlenet:packagingandsending'] = 'Failo supakavimas ir siuntimas į „MoodleNet“...';
$string['moodlenet:sharefailtext'] = 'Dalinantis jūsų turiniu MoodleNet įvyko klaida.<br>Vėliau bandykite dar kartą.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Dalinantis jūsų turiniu MoodleNet įvyko klaida.<br>Vėliau bandykite dar kartą arba <a href="{$a}">susisiekite su svetainės palaikymo komanda</a>';
$string['moodlenet:sharefailtitle'] = 'Kažkas nutiko';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Bendrinamo šaltinio dydis ({$a->filesize} baitai) viršija limitą {$a->filesizelimit} bitus.';
$string['moodlenet:sharenoticeactivity'] = 'Šia veikla dalijamasi su "MoodleNet" kaip šaltiniu.';
$string['moodlenet:sharenoticecourse'] = 'Šiuo kursu dalijamasi su „MoodleNet“ kaip ištekliumi.';
$string['moodlenet:sharenoticepartial'] = 'Pasirinkta veikla dalijamasi su „MoodleNet“ kaip ištekliumi.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} veikla bus įtraukta į kursą.';
$string['moodlenet:shareprogress'] = '„MoodleNet“ dalijimosi pažanga';
$string['moodlenet:shareprogressinfo'] = 'Sąraše rodomi kursai ir veiklos, kuriomis pasidalijote su „MoodleNet“.<br>Paspauskite ištekliaus pavadinimą, kad peržiūrėtumėte „MoodleNet“.';
$string['moodlenet:sharesuccesstext'] = 'Beveik baigta! Apsilankykite juodraščiuose „MoodleNet“, kad baigtumėte bendrinti turinį.';
$string['moodlenet:sharesuccesstitle'] = 'Išsaugota MoodleNet juodraščiuose';
$string['moodlenet:sharetomoodlenet'] = 'Bendrinti su MoodleNet';
$string['moodlenet:sharetyperesource'] = 'išteklius';
$string['moodlenet:sharinglargefile'] = 'Dėl didelių failų gali užtrukti.';
$string['moodlenet:sharingstatus'] = 'Bendrinama su MoodleNet';
$string['moodlenet:sharingto'] = 'Bendrinama su:';
$string['moodlerelease'] = '„Moodle“ leidimas';
$string['moodleservicesandsupport'] = 'Paslaugos ir palaikymas';
$string['moodleversion'] = '„Moodle“ versija';
$string['more'] = 'daugiau';
$string['moreactions'] = 'Daugiau veiksmų';
$string['morehelp'] = 'Daugiau informacijos';
$string['morehelpaboutmodule'] = 'Daugiau pagalbos apie veiklą {$a}';
$string['moreinfo'] = 'Daugiau info';
$string['moreinformation'] = 'Daugiau informacijos apie šią klaidą';
$string['moremenu'] = 'Daugiau';
$string['morenavigationlinks'] = 'Daugiau...';
$string['moreprofileinfoneeded'] = 'Prašome apie save pateikti daugiau informacijos';
$string['mostrecently'] = 'naujausia';
$string['move'] = 'Perkelti';
$string['movecategoriessuccess'] = 'Sėkmingai perkeltos {$a->count} kategorijos į kategoriją \'{$a->to}';
$string['movecategoriestotopsuccess'] = 'Sėkmingai perkeltos {$a->count} kategorijos į aukščiausią lygį';
$string['movecategorycontentto'] = 'Perkelti į';
$string['movecategorysuccess'] = 'Sėkmingai perkelta \'{$a->moved}\' kategorija į kategoriją \'{$a->to}';
$string['movecategoryto'] = 'Perkelti kategoriją į:';
$string['movecategorytotopsuccess'] = 'Sėkmingai perkelta \'{$a->moved}\' kategorija į aukščiausią lygį';
$string['movecontent'] = 'Perkelti {$a}';
$string['movecontentafter'] = 'Po "{$a}"';
$string['movecontentstoanothercategory'] = 'Perkelti turinį į kitą kategoriją';
$string['movecontenttothetop'] = 'Į sąrašo viršų';
$string['movecoursemodule'] = 'Perkelti veiklą';
$string['movecoursesection'] = 'Perkelti skyrių';
$string['movecourseto'] = 'Perkelti kursus į:';
$string['movedown'] = 'Perkelti žemyn';
$string['movefilestohere'] = 'Perkelti failus čia';
$string['movefull'] = 'Perkelti {$a} į šią vietą';
$string['movehere'] = 'Perkelti čia';
$string['moveleft'] = 'Perkelti kairėn';
$string['moveright'] = 'Perkelti dešinėn';
$string['movesection'] = 'Perkelti dalį {$a}';
$string['moveselectedcategoriesto'] = 'Perkelti pasirinktas kategorijas į';
$string['moveselectedcoursesto'] = 'Pasirinktus kursus perkelti į...';
$string['movetoanotherfolder'] = 'Perkelti į kitą aplanką';
$string['moveup'] = 'Perkelti aukštyn';
$string['mustchangepassword'] = 'Naujas slaptažodis turi skirtis nuo dabartinio';
$string['mustconfirm'] = 'Turite patvirtinti savo paskyrą';
$string['mycourses'] = 'Mano kursai';
$string['myfiles'] = 'Mano privatūs failai';
$string['myfilesmanage'] = 'Valdyti mano privačius failus';
$string['myhome'] = 'Mano pagrindinis';
$string['mymoodledashboard'] = 'Mano „Moodle“ ataskaitų sritis';
$string['myprofile'] = 'Mano profilis';
$string['name'] = 'Pavadinimas';
$string['namedfiletoolarge'] = 'Failas \'{$a->filename}\' yra per didelis ir negali būti įkeltas';
$string['nameforlink'] = 'Kaip Jūs norite pavadinti šį puslapį?';
$string['nameforpage'] = 'Pavadinimas';
$string['navigation'] = 'Naršymas';
$string['needed'] = 'Reikalinga';
$string['networkdropped'] = 'Aptikome, kad jūsų interneto ryšys yra nepatikimas arba nutrūko.<br />
Atminkite, kad pakeitimai gali būti tinkamai neįrašyti, kol ryšys nepagerės.';
$string['never'] = 'Niekada';
$string['neverdeletelogs'] = 'Niekada nenaikinti žurnalų';
$string['new'] = 'Naujas';
$string['newaccount'] = 'Nauja paskyra';
$string['newactivityname'] = 'Naujas veiklos vardas {$a}';
$string['newcourse'] = 'Naujas kursas';
$string['newloginnotificationbodyfull'] = '<p>Sveiki, {$a->userfullname},</p>
<p>Prie jūsų „{$a->sitename}“ paskyros ką tik buvo prisijungta iš naujo įrenginio.</p>
<ul>
<li>Jūsų paskyra: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Įrenginys: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Jei tai buvote jūs, jums nereikia nieko daryti.</p>
<p>Jei neatpažįstate šios veiklos, <a href="{$a->changepasswordlink}">pakeiskite slaptažodį</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Prie jūsų {$a} paskyros ką tik prisijungta iš naujo įrenginio.';
$string['newloginnotificationtitle'] = 'Naujas prisijungimas prie jūsų {$a} paskyros';
$string['newpassword'] = 'Naujas slaptažodis';
$string['newpassword_help'] = 'Įveskite naują slaptažodį arba palikite tuščią, kad naudotumėte dabartinį slaptažodį.';
$string['newpasswordfromlost'] = '<strong>PRANEŠIMAS:</strong> jūsų <strong>dabartinis slaptažodis</strong> turėjo būti jums išsiųstas <strong>antruoju</strong> iš dviejų el. laiškų, išsiųstų vykdant prarasto slaptažodžio atkūrimo procesą. Įsitikinkite, kad jau gavote savo pakaitinį slaptažodį prieš toliau atlikdami veiksmus šiame ekrane.';
$string['newpasswordtext'] = 'Sveiki, {$a->firstname},

Jūsų paskyros slaptažodis svetainėje {$a->sitename}
buvo nustatytas iš naujo ir suteiktas naujas laikinasis slaptažodis.

Dabartinė jūsų prisijungimo informacija yra:
     naudotojo vardas: {$a->username}
     slaptažodis: {$a->newpassword}

Norėdami pakeisti slaptažodį, eikite į šį puslapį:
{$a->link}

Daugumoje pašto programų tai rodoma kaip aktyvi nuoroda, kurią galite spustelėti.
Jei nepavyksta, nukopijuokite ir įklijuokite šį adresą į naršyklės adreso eilutę.


Linkėjimai,
{$a->sitename}
administratoriaus {$a->signoff}';
$string['newpicture'] = 'Naujas paveikslėlis';
$string['newpicture_help'] = 'Jei norite įtraukti naują paveikslėlį, naršykite ir pasirinkite vaizdą (JPG arba PNG formatu), tada spustelėkite Atnaujinti profilį. Vaizdas bus apkarpytas kaip kvadratas ir jo dydis pakeistas į 100 x 100 pikselių.';
$string['newpictureusernotsetup'] = 'Profilio nuotrauką galima pridėti tik tada, kai bus išsaugota visa reikalinga profilio informacija.';
$string['newsectionname'] = 'Naujas dalies {$a} pavadinimas';
$string['newsitem'] = 'naujienų elementas';
$string['newsitems'] = 'skelbimai';
$string['newsitemsnumber'] = 'Skelbimų skaičius';
$string['newsitemsnumber_help'] = 'Skelbimų forume pagal nutylėjimą nustatyta priverstinė prenumerata. Jame gali rašyti tik dėstytojai ir kiti atitinkamus leidimus turintys naudotojai.

Jei jums nereikalingas skelbimų forumas, nustatykite šią reikšmę į nulį.

Šis nustatymas taip pat lemia, kiek naujausių pranešimų bus rodoma naujausių pranešimų bloke.';
$string['newuser'] = 'Naujas naudotojas';
$string['newusernewpasswordsubj'] = 'Nauja naudotojo paskyra';
$string['newusernewpasswordtext'] = 'Sveiki, {$a->firstname},

„{$a->sitename}“ jums buvo sukurta nauja paskyra
ir išduotas naujas laikinas slaptažodis.

Dabartinė jūsų prisijungimo informacija yra:
    naudotojo vardas: {$a->username}
    slaptažodis: {$a->newpassword}
              (turėsite pakeisti slaptažodį
               kai prisijungiate pirmą kartą)

Norėdami pradėti naudotis „{$a->sitename}“, prisijunkite adresu
    {$a->link}

Jei reikia pagalbos, galite kreiptis į svetainės administratorių,
{$a->admin}';
$string['newusers'] = 'Nauji naudotojai';
$string['newwindow'] = 'Naujas langas';
$string['next'] = 'Pirmyn';
$string['nextpage'] = 'Kitas puslapis';
$string['nextsection'] = 'Kita dalis';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Nėra blokų, kuriuos galėtumėte įtraukti į šį puslapį.';
$string['nobody'] = 'Niekas';
$string['nochange'] = 'Nėra pakeitimų';
$string['nocomments'] = 'Jokių komentarų';
$string['nocourses'] = 'Nėra kursų';
$string['nocoursesfound'] = 'Nerasta kursų, kuriuose būtų žodžiai „{$a}“';
$string['nocoursestarttime'] = 'Kursas neturi pradžios datos.';
$string['nocoursesyet'] = 'Nėra šios kategorijos kursų';
$string['nodstpresets'] = 'Administratorius neįjungęs vasaros / žiemos laiko palaikymo.';
$string['nofilesselected'] = 'Nepasirinkti atkurti jokie failai';
$string['nofilesyet'] = 'Į jūsų kursus dar neįkelti jokie failai';
$string['nofiltersapplied'] = 'Filtrai netaikomi';
$string['nograde'] = 'Nėra įvertinimo';
$string['nohelpforactivityorresource'] = 'Šiuo metu nėra pagalbos dokumentų susietų su šiuo resursų ar veikla';
$string['noimagesyet'] = 'Į jūsų kursus dar neįkelti jokie vaizdai';
$string['nologsfound'] = 'Nerasta jokių žurnalų';
$string['nomatchingusers'] = 'Joks naudotojas neatitinka {$a}';
$string['nomorecourses'] = 'Daugiau nerasta jokių atitinkančių kursų';
$string['nomoreidnumber'] = 'Nenaudojamas ID numeris, kad būtų išvengta konfliktų';
$string['none'] = 'Nėra';
$string['noneditingteacher'] = 'Dėstytojas be redagavimo teisės';
$string['noneditingteacherdescription'] = 'Dėstytojas be redagavimo teisės gali dėstyti kursuose ir vertinti besimokančiuojus, bet negali koreguoti veiklų.';
$string['nonstandard'] = 'Nestandartiška';
$string['nopendingcourses'] = 'Nėra laukiančių patvirtinimo kursų';
$string['nopotentialadmins'] = 'Nėra potencialių administratorių';
$string['nopotentialcreators'] = 'Nėra potencialių kursų kūrėjų';
$string['nopotentialstudents'] = 'Nėra potencialių besimokančiųjų';
$string['nopotentialteachers'] = 'Nėra potencialių dėstytojų';
$string['norecentactivity'] = 'Nėra jokios naujos veiklos';
$string['noreplybouncemessage'] = 'Jūs atsakėte el pašto adresu, kuriuo negalima siųsti atsakymo. Jei norėjote atsakyti į forumo pranešimą, geriau bandykite atsakyti naudodamiesi {$a} forumu.

Jūsų el. laiško turinys:';
$string['noreplybouncesubject'] = '{$a} – atmestas el. laiškas.';
$string['noreplyname'] = 'Neatsakykite į šį el. laišką';
$string['noresetrecord'] = 'Nėra įrašo apie šią užklausą dėl atkūrimo. Pateikite naują slaptažodžio nustatymo iš naujo užklausą.';
$string['noresults'] = 'Nėra rezultatų';
$string['noresultsfor'] = '"{$a}" rezultatų nerasta';
$string['normal'] = 'Įprasta';
$string['normalfilter'] = 'Įprasta ieška';
$string['nosite'] = 'Nepavyko rasti kursų svetainės lygiu';
$string['nostudentsfound'] = 'Nerasta: {$a}';
$string['nostudentsingroup'] = 'Šioje grupėje dar nėra besimokančiųjų';
$string['nostudentsyet'] = 'Šiame kurse nėra besimokančiųjų.';
$string['nosuchemail'] = 'Nėra tokio el. pašto adreso';
$string['notavailable'] = 'Nepasiekiama';
$string['notavailablecourse'] = '{$a} negalima';
$string['noteachersyet'] = 'Dar nėra šių kursų dėstytojų';
$string['noteachingupcomingcourses'] = 'Būsimuose kursuose nėra dėstytojų ar besimokančiųjų';
$string['notenrolled'] = '{$a} neįsiregistravęs į šiuos kursus.';
$string['notenrolledprofile'] = 'Profilis nepasiekiamas, nes šis naudotojas neįsiregistravęs į šiuos kursus.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Pastaba:</strong> galimybė grąžinti datas atkuriant šią atsarginę kopiją buvo išjungta, nes jūs neturite reikiamų teisių.';
$string['noteuserschangednonetocourse'] = '<strong>Pastaba:</strong> atkuriant naudotojų duomenis (veiklose, failuose ar žinutėse) reikia atkurti kursų naudotojus. Šis parametras jums buvo pakeistas.';
$string['nothingnew'] = 'Nėra naujausios veiklos';
$string['nothingtodisplay'] = 'Nėra, ką rodyti';
$string['notice'] = 'Įspėjimas';
$string['noticenewerbackup'] = 'Šis atsarginės kopijos failas buvo sukurtas naudojant „Moodle“ {$a->backuprelease} ({$a->backupversion}), o tai naujesnė versija, nei jūsų šiuo metu įdiegto „Moodle“ {$a->serverrelease} ({$a->serverversion}). Dėl to gali būti nenuoseklumų, nes negalima garantuoti atsarginės kopijos failų atvirkštinio suderinamumo.';
$string['notifications'] = 'Pranešimai';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, naudotojas: {$a->info}, naudotojo pilnas vardas: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Šiuos žurnalus galite peržiūrėti {$a}/course/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Čia pateikiamas nepavykusių bandymų prisijungti {$a} skaičius nuo paskutinio pranešimo jums';
$string['notifyloginfailuressubject'] = '{$a} :: pranešimas apie nepavykusius bandymus prisijungti';
$string['notincluded'] = 'Neįtraukta';
$string['notingroup'] = 'Atsiprašome, bet turite priklausyti grupei, kad matytumėte šį puslapį.';
$string['notpublic'] = 'Ne vieša!';
$string['nousersfound'] = 'Nerasta naudotojų';
$string['nousersmatching'] = 'Nerasta naudotojų, atitinkančių {$a}';
$string['nousersyet'] = 'Dar nėra naudotojų';
$string['novalidcourses'] = 'Nėra tinkamų rodyti kursų';
$string['now'] = 'Dabar';
$string['numattempts'] = 'Nepavykusių bandymų prisijungti skaičius: {$a}';
$string['numberofcourses'] = 'Kursų skaičius';
$string['numberweeks'] = 'Dalių skaičius';
$string['numday'] = '{$a} diena';
$string['numdays'] = 'Dienų: {$a}';
$string['numhours'] = 'Valandų: {$a}';
$string['numletters'] = 'Raidžių: {$a}';
$string['numminutes'] = '{$a} minutės';
$string['nummonth'] = '{$a} mėnuo';
$string['nummonths'] = '{$a} mėn.';
$string['numseconds'] = '{$a} sek.';
$string['numviews'] = 'Peržiūrų: {$a}';
$string['numweek'] = '{$a} savaitė';
$string['numweeks'] = 'Savaičių: {$a}';
$string['numwords'] = 'Žodžių: {$a}';
$string['numyear'] = '{$a} metai';
$string['numyears'] = 'Metų: {$a}';
$string['ok'] = 'Gerai';
$string['oldpassword'] = 'Dabartinis slaptažodis';
$string['olduserdirectory'] = 'Tai SENAS naudotojų katalogas, kuris nebereikalingas. Galite saugiai jį naikinti. Jame esantys failai buvo nukopijuoti į NAUJĄ naudotojų katalogą.';
$string['opendrawerblocks'] = 'Atidaryti blokus';
$string['opendrawerindex'] = 'Atverti kurso rodyklę';
$string['opensinnewwindow'] = 'Atsidaro naujame lange';
$string['operator_and'] = 'ir';
$string['operator_andnot'] = 'ir';
$string['operator_or'] = 'arba';
$string['optional'] = 'pasirinktinai';
$string['options'] = 'Parinktys';
$string['order'] = 'Eilės tvarka';
$string['originalpath'] = 'Originalusis adresas';
$string['orphanedactivitiesinsectionno'] = 'Liekamoji veikla (section {$a})';
$string['other'] = 'Kita';
$string['outline'] = 'Struktūra';
$string['outlinereport'] = 'Struktūros ataskaita';
$string['page'] = 'Puslapis';
$string['pagea'] = '{$a} puslapis';
$string['pagedcontentnavigation'] = 'Puslapiavimo navigacija';
$string['pagedcontentnavigationactiveitem'] = 'Dabartinis puslapis, {$a} puslapis';
$string['pagedcontentnavigationitem'] = 'Eiti į puslapį {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Rodyti {$a} elementus puslapyje';
$string['pageheaderconfigablock'] = '%fullname% konfigūruojamas blokas';
$string['pagepath'] = 'Puslapio kelias';
$string['pageshouldredirect'] = 'Šis puslapis turi automatiškai peradresuoti. Jei niekas nevyksta, naudokite žemiau pateiktą nuorodą "Tęsti".';
$string['parentcategory'] = 'Pirminė kategorija';
$string['parentcoursenotfound'] = 'Nerasti pirminiai kursai';
$string['parentfolder'] = 'Pirminis aplankas';
$string['participants'] = 'Dalyviai';
$string['participantslist'] = 'Dalyvių sąrašas';
$string['participationratio'] = 'Dalyvavimo santykis';
$string['participationreport'] = 'Dalyvavimo ataskaita';
$string['password'] = 'Slaptažodis';
$string['passwordchanged'] = 'Slaptažodis pakeistas';
$string['passwordconfirmchange'] = 'Patvirtinkite slaptažodžio pakeitimą';
$string['passwordextlink'] = 'Toliau pateiktas saitas, skirtas jūsų prarastam slaptažodžiui atkurti. Jūs turėsite išeiti iš „Moodle“.';
$string['passwordforgotten'] = 'Pamirštas slaptažodis';
$string['passwordforgotteninstructions'] = 'Pirma jūsų informaciją reikia rasti naudotojų duomenų bazėje. Į atitinkamą lauką įveskite <strong>arba</strong> savo naudotojo vardą, arba užregistruotą el. pašto adresą. Abiejų įvesti nereikia.';
$string['passwordforgotteninstructions2'] = 'Jei norite iš naujo nustatyti slaptažodį, toliau pateikite savo naudotojo vardą arba el. pašto adresą. Jei jus rasime duomenų bazėje, jūsų el. pašto adresu bus išsiųstas el. laiškas su nurodymais, kaip vėl gauti prieigą.';
$string['passwordnohelp'] = 'Nėra žinyno informacijos, kaip rasti jūsų prarastą slaptažodį. Kreipkitės į savo „Moodle“ administratorių.';
$string['passwordpolicynomatch'] = 'Dabartinis slaptažodis nebeatitinka nustatytų reikalavimų slaptažodžiui.
   {$a}';
$string['passwordrecovery'] = 'Taip, padėkite man prisijungti';
$string['passwordsdiffer'] = 'Šie slaptažodžiai neatitinka';
$string['passwordsent'] = 'Slaptažodis buvo išsiųstas';
$string['passwordsenttext'] = '<p>Jūsų adresu {$a->email} išsiųstas el. laiškas.</p> <p><b>Patikrinkite savo el. paštą, ar jame yra naujas slaptažodis.</b></p> <p>Naujas slaptažodis sugeneruotas automatiškai. Galite <a href="{$a->link}">jį pakeisti į lengviau įsimenamą</a>.</p>';
$string['passwordset'] = 'Jūsų slaptažodis buvo nustatytas.';
$string['path'] = 'Kelias';
$string['pathnotexists'] = 'Tokio kelio nėra jūsų serveryje!';
$string['pathslasherror'] = 'Kelias negali baigtis pasviruoju brūkšniu!';
$string['paymentinstant'] = 'Naudokite toliau pateiktą mygtuką, kad sumokėtumėte ir būtumėte įregistruoti per kelias minutes.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> laukia</small>)';
$string['paymentrequired'] = 'Už šiuos kursus reikia mokėti.';
$string['payments'] = 'Mokėjimas';
$string['paymentsorry'] = 'Dėkojame už jūsų mokėjimą. Deja, jūsų mokėjimas dar nebuvo visiškai apdorotas ir jūs dar neužregistruoti dalyvauti kursuose „{$a->fullname}“. Bandykite įeiti į kursus po kelių sekundžių, bet jei ir toliau turėsite problemų, apie tai įspėkite {$a->teacher} ar svetainės administratorių.';
$string['paymentthanks'] = 'Dėkojame už jūsų mokėjimą. Jau esate įregistruoti į kursus:<br />„{$a}“';
$string['pendingrequests'] = 'Laukiančios užklausos';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Laikotarpio pabaiga ({$a})';
$string['perpage'] = 'Puslapyje';
$string['perpagea'] = 'Puslapyje: {$a}';
$string['personal'] = 'Asmeninis';
$string['personalprofile'] = 'Asmeninis profilis';
$string['phone'] = 'Telefonas';
$string['phone1'] = 'Telefonas';
$string['phone2'] = 'Mobilusis telefonas';
$string['phpinfo'] = 'PHP informacija';
$string['picture'] = 'Paveiksliukas';
$string['pictureof'] = '{$a} paveikslėlis';
$string['pictureofuser'] = 'Naudotojo paveikslėlis';
$string['placeholdertypeorselect'] = 'Įveskite arba pasirinkite..';
$string['pleaseclose'] = 'Uždarykite šį langą dabar.';
$string['pleasesearchmore'] = 'Dar paieškokite';
$string['pleaseusesearch'] = 'Naudokite paiešką';
$string['plugin'] = 'Papildinys';
$string['pluginarea'] = 'Sritis';
$string['plugincheck'] = 'Papildinių patikra';
$string['plugindeletefiles'] = 'Visi su papildiniu {$a->name} susiję duomenys buvo panaikinti iš duomenų bazės. Jei norite neleisti, kad papildinys iš naujo įsidiegtų, turite panaikinti šį katalogą iš savo serverio: {$a->directory}.';
$string['pluginitemid'] = 'Elemento ID';
$string['pluginmissingfromdisk'] = '{$a->name} (Trūksta diske)';
$string['pluginsetup'] = 'Nustatomos papildinių lentelės';
$string['policyaccept'] = 'Suprantu ir sutinku';
$string['policyagree'] = 'Norėdami toliau naudotis šia svetaine, turite sutikti su šia strategija. Ar sutinkate?';
$string['policyagreement'] = 'Svetainės strategijos sutartis';
$string['policyagreementclick'] = 'Svetainės politikos sutartis';
$string['popup'] = 'iššokantysis';
$string['popupwindow'] = 'Atidaryti failą naujame lange';
$string['popupwindowname'] = 'Iššokantysis langas';
$string['post'] = 'Įrašas';
$string['posts'] = 'Įrašai';
$string['potentialadmins'] = 'Potencialūs administratoriai';
$string['potentialcreators'] = 'Potencialūs kursų kūrėjai';
$string['potentialstudents'] = 'Potencialūs besimokantieji';
$string['potentialteachers'] = 'Potencialūs dėstytojai';
$string['poweredbymoodle'] = 'Teikiamas <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Nuostatos';
$string['preferredlanguage'] = 'Norima kalba';
$string['preferredtheme'] = 'Norima tema';
$string['preprocessingbackupfile'] = 'Iš anksto apdorojamas atsarginės kopijos failas';
$string['prev'] = 'Perž.';
$string['preview'] = 'Peržiūra';
$string['previeworchoose'] = 'Peržiūrėti arba pasirinkti temą';
$string['previous'] = 'Ankstesnis';
$string['previouslyselectedusers'] = 'Anksčiau pasirinkti naudotojai neatitinka {$a}';
$string['previouspage'] = 'Ankstesnis puslapis';
$string['previoussection'] = 'Ankstesnė dalis';
$string['primaryadminsetup'] = 'Nustatyti administratoriaus paskyrą';
$string['privacy:metadata:config_log'] = 'Konfigūracijos pakeitimų žurnalas.';
$string['privacy:metadata:config_log:name'] = 'Keičiasi nustatymo pavadinimas.';
$string['privacy:metadata:config_log:oldvalue'] = 'Ankstesnė šio nustatymo vertė.';
$string['privacy:metadata:config_log:plugin'] = 'Papildinys pakeistas.';
$string['privacy:metadata:config_log:timemodified'] = 'Laikas, kai buvo atliktas pakeitimas.';
$string['privacy:metadata:config_log:userid'] = 'Naudotojas, padaręs pakeitimą.';
$string['privacy:metadata:config_log:value'] = 'Nauja šio nustatymo vertė.';
$string['privacy:metadata:events_queue'] = 'Naudotojų įvykių, laukiančių apdorojimo, eilė.';
$string['privacy:metadata:events_queue:eventdata'] = 'Įvykio metu saugomi duomenys.';
$string['privacy:metadata:events_queue:stackdump'] = 'Bet koks su šiuo įvykiu susietas stacktrace.';
$string['privacy:metadata:events_queue:timecreated'] = 'Laikas, kai buvo sukurtas šis įvykis.';
$string['privacy:metadata:events_queue:userid'] = 'Su šiuo įvykiu susietas naudotojo ID';
$string['privacy:metadata:log'] = 'Praeities įvykių rinkinys';
$string['privacy:metadata:log:action'] = 'Veiksmo aprašymas';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kursas';
$string['privacy:metadata:log:info'] = 'Papildoma informacija';
$string['privacy:metadata:log:ip'] = 'Įvykio metu naudojamas IP adresas';
$string['privacy:metadata:log:module'] = 'modulis';
$string['privacy:metadata:log:time'] = 'Laikas, kai vyko veiksmas';
$string['privacy:metadata:log:url'] = 'Su įvykiu susijęs URL';
$string['privacy:metadata:log:userid'] = 'Veiksmą atlikusio naudotojo ID';
$string['privacy:metadata:moodlenet_share_progress'] = '„MoodleNet“ dalijimasis progreso informacija';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'Susijusio kurso modulio ID';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'Susijusio kurso ID';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'URL, kurį grąžina „MoodleNet“ po sėkmingo bendrinimo';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Laikas, kada pasidalijimas buvo atlikta';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Atlikto pasidalijimo tipas';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Naudotojas, atlikęs bendrinimą';
$string['privacy:metadata:oauth2_refresh_token'] = 'Atnaujinti prieigos raktą, naudojamą „OAuth 2.0“ ryšiui';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Išdavėjo, kurį atitinka prieigos raktas, ID';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Naudotojo, kurį atitinka prieigos raktas, ID';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Laikas, kai buvo sukurtas prieigos raktas';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Laikas, kada prieigos raktas buvo paskutinį kartą atnaujintas';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Atitinkamų sričių ir naudotojo atnaujinimo prieigos raktas';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Naudotojo, kurį atitinka prieigos raktas, ID';
$string['privacy:metadata:task_adhoc'] = 'Ad hoc užduočių būsena.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponentas, kuriam priklauso užduotis.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Ankstyviausias laikas atlikti šią užduotį.';
$string['privacy:metadata:task_adhoc:userid'] = 'Naudotojas, norintis vykdyti užduotį kaip.';
$string['privacy:metadata:task_log'] = 'Žurnalo išvestis žurnalui';
$string['privacy:metadata:task_log:component'] = 'Komponentas, kuriam priklauso užduotis.';
$string['privacy:metadata:task_log:userid'] = 'Naudotojas, kuriam priklausė užduotis.';
$string['privacy:metadata:upgrade_log'] = 'Atnaujinimo žurnalas.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Bet koks atšaukimas, susijęs su šiuo atnaujinimo žingsniu.';
$string['privacy:metadata:upgrade_log:details'] = 'Papildoma informacija, susijusi su atnaujinimu.';
$string['privacy:metadata:upgrade_log:info'] = 'Pagrindinė šio atnaujinimo veiksmo informacija.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Papildinys, kuris buvo atnaujintas.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nauja versija, į kurią reikia atnaujinti.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Laikas, kai įvyko atnaujinimas.';
$string['privacy:metadata:upgrade_log:type'] = 'Žurnalo įrašo tipas.';
$string['privacy:metadata:upgrade_log:userid'] = 'Naudotojas, kuris vykdė naujinimą.';
$string['privacy:metadata:upgrade_log:version'] = 'Sena papildinio versija.';
$string['private_files_handler'] = 'Saugoti el. laiško priedus naudotojo asmeninių failų saugykloje.';
$string['private_files_handler_name'] = 'Privačių failų el. laiškai';
$string['privatefiles'] = 'Asmeniniai failai';
$string['privatefilesmanage'] = 'Tvarkyti asmeninius failus';
$string['proceed'] = 'Tęsti';
$string['profile'] = 'Profilis';
$string['profilenotshown'] = 'Šio profilio aprašas nebus rodomas, kol asmuo nebus įsiregistravęs nors į vieną kursą.';
$string['progress'] = 'Progresas';
$string['publicprofile'] = 'Viešas profilis';
$string['publicsitefileswarning'] = 'Pastaba: čia padėtus failus gali pasiekti visi';
$string['publicsitefileswarning2'] = 'Pastaba: čia padėtus failus gali pasiekti visi žinantys (ar atspėję) URL. Saugumo sumetimais rekomenduojama visus atsarginių kopijų failus panaikinti iškart po jų atkūrimo.';
$string['publicsitefileswarning3'] = 'Pastaba: čia padėtus failus gali pasiekti visi žinantys (ar atspėję) URL. <br />Saugumo sumetimais atsarginių kopijų failus reikia įrašyti tik saugiame atsarginių kopijų duomenų aplanke.';
$string['question'] = 'Klausimas';
$string['questionsinthequestionbank'] = 'Klausimai klausimų banke';
$string['queued'] = 'Eilėje';
$string['quotausage'] = 'Dabar išnaudojama {$a->used} Jūsų turimo {$a->total} limito.';
$string['readinginfofrombackup'] = 'Nuskaitoma informacija iš atsarginės kopijos';
$string['readme'] = 'README';
$string['recentactivity'] = 'Naujausia veikla';
$string['recentactivityreport'] = 'Visa naujausios veiklos ataskaita...';
$string['recipientslist'] = 'Gavėjų sąrašas';
$string['recommended'] = 'Rekomenduojama';
$string['recreatedcategory'] = 'Iš naujo sukurta kategorija {$a}';
$string['redirect'] = 'Peradresuoti';
$string['reducesections'] = 'Sumažinti sekcijų skaičių';
$string['refresh'] = 'Atnaujinti';
$string['refreshingevents'] = 'Atnaujinami įvykiai';
$string['registration'] = '„Moodle“ registracija';
$string['registrationcontact'] = 'Susisiekti iš viešojo';
$string['registrationcontactno'] = 'Ne, nenoriu, kad su manimi susisiektų kiti žmonės';
$string['registrationcontactyes'] = 'Taip, pateikite formą, kad kiti „Moodle“ naudotojai galėtų su manimi susisiekti';
$string['registrationemail'] = 'El. pašto pranešimai';
$string['registrationinfo'] = '<p>Šis puslapis leidžia registruoti „Moodle“ svetainę moodle.org. Registracija yra nemokama. Pagrindinis šios registracijos pranašumas yra tas, kad būsite įtraukti į mažos apimties prenumeratos sąrašą ir gausite svarbius pranešimus, pvz., saugos įspėjimus arba informaciją apie naujus „Moodle“ leidimus.</p> <p>Numatyta, kad jūsų duomenys bus konfidencialūs ir niekada nebus parduoti arba perduoti niekam kitam. Informacija gali būti renkama tik palaikymo tikslais ir siekiant padėti kurti bendrą statistinį „Moodle“ bendruomenės vaizdą. </p> <p>Galite pasirinkti leisti savo svetainės pavadinimą, šalį ir URL įtraukti į viešąjį „Moodle“ svetainių sąrašą.</p> <p>Prieš įtraukiant į sąrašą, visi registracijos duomenys tikrinami rankiniu būdu, tačiau jei jau esate įtraukti, savo registracijos informaciją (taip pat savo įrašą viešajame sąraše) galite atnaujinti bet kuriuo metu iš naujo pateikdami šią formą.</p>';
$string['registrationinfotitle'] = 'Registracijos informacija';
$string['registrationsend'] = 'Siųsti registracijos informaciją į moodle.org';
$string['registrationyes'] = 'Taip, praneškite man apie naujus „Moodle“ leidimus, saugos įspėjimus ir kitas svarbias naujienas';
$string['reject'] = 'Atmesti';
$string['rejectdots'] = 'Atmesti...';
$string['relativedatesmode'] = 'Santykinių datų režimas';
$string['relativedatesmode_help'] = 'Rodyti kurso arba veiklos datas, palyginti su naudotojo kurso pradžios data.

Naudotojo kurso pradžios data bus jo registracijos pradžios data, nebent jie būtų užsiregistravę prieš kurso pradžią. Tokiu atveju jų pradžios data bus kurso pradžios data.

ĮSPĖJIMAS: tai eksperimentinė funkcija ir ne visos veiklos gali ją palaikyti. Sukūrus kursą šio kurso nustatymo keisti nebegalima.';
$string['relativedatesmode_warning'] = '<strong>Įspėjimas:</strong> sukūrus kursą santykinių datų režimo pakeisti negalima.';
$string['reload'] = 'Įkelti iš naujo';
$string['remoteappuser'] = 'Nuotolinis {$a} naudotojas';
$string['remove'] = 'Šalinti';
$string['removeadmin'] = 'Šalinti administratorių';
$string['removecreator'] = 'Šalinti kursų kūrėją';
$string['removestudent'] = 'Šalinti besimokantįjį';
$string['removeteacher'] = 'Šalinti dėstytoją';
$string['rename'] = 'Pervadinti';
$string['renamefileto'] = 'Pervadinti <b>{$a}</b> į';
$string['report'] = 'Ataskaita';
$string['reports'] = 'Ataskaitos';
$string['reporttype'] = 'Ataskaitos tipas';
$string['repositories'] = 'Saugyklos';
$string['requestcourse'] = 'Pateikti prašymą';
$string['requestedby'] = 'Užklausą pateikė';
$string['requestedcourses'] = 'Užklausti kursai';
$string['requestreason'] = 'Naujo kurso sukūrimo priežastis';
$string['requests'] = 'Užklausos';
$string['required'] = 'Būtina';
$string['requirespayment'] = 'Norint pasiekti šiuos kursus, reikia mokėti';
$string['resendemail'] = 'Siųsti el. laišką dar kartą';
$string['reset'] = 'Nustatyti iš naujo';
$string['resetcomponent'] = 'Komponentas';
$string['resetcourse'] = 'Nustatyti kursą iš naujo';
$string['resetinfo'] = 'Šis puslapis leidžia iš kursų pašalinti naudotojų duomenis, paliekant veiklas ir kitus nustatymus. Įspėjame, kad pasirinkdami tolesnius elementus ir paspaudę "Nustatyti kursą iš naujo" pasirinktus naudotojų duomenis iš šio kurso panaikinsite visam laikui.';
$string['resetnotimplemented'] = 'Nustatymas iš naujo neįvykdytas';
$string['resetrecordexpired'] = 'Naudota slaptažodžio nustatymo iš naujo nuoroda yra senesnė nei {$a} min. ir pasibaigė. Pradėkite naujo slaptažodžio nustatymą.';
$string['resetstartdate'] = 'Nustatymo iš naujo pradžios data';
$string['resetstatus'] = 'Būsena';
$string['resettable'] = 'Atstatyti lentelės nuostatas';
$string['resettask'] = 'Užduotis';
$string['resettodefaults'] = 'Nustatyti numatytąsias reikšmes';
$string['resortcourses'] = 'Rikiuoti kursus';
$string['resortsubcategoriesby'] = 'Rūšiuoti antrines kategorijas pagal {$a} didėjimo tvarka';
$string['resortsubcategoriesbyreverse'] = 'Rūšiuoti antrines kategorijas pagal {$a} mažėjančia tvarka';
$string['resource'] = 'Išteklius';
$string['resourcedisplayauto'] = 'Automatiškai';
$string['resourcedisplaydownload'] = 'Priverstinai vykdyti atsisiuntimą';
$string['resourcedisplayembed'] = 'Įdėti';
$string['resourcedisplayframe'] = 'Rėmelyje';
$string['resourcedisplaynew'] = 'Naujas langas';
$string['resourcedisplayopen'] = 'Atidaryti';
$string['resourcedisplaypopup'] = 'Iššokančiajame lange';
$string['resources'] = 'Ištekliai';
$string['resources_help'] = 'Išteklių tipai leidžia į kursus įterpti beveik bet kokio žiniatinklio turinio.';
$string['restore'] = 'Atkurti';
$string['restorecancelled'] = 'Atkūrimas atšauktas';
$string['restorecannotassignroles'] = 'Atkuriant reikia priskirti vaidmenis, o jūs neturite tam teisių';
$string['restorecannotcreateorassignroles'] = 'Atkuriant reikia sukurti arba priskirti vaidmenis, o jūs neturite tam teisių';
$string['restorecannotcreateuser'] = 'Atkuriant reikia sukurti naudotoją {$a} iš atsarginės kopijos failo, o jūs neturite tam teisių';
$string['restorecannotoverrideperms'] = 'Atkuriant reikia perrašyti teises, o jūs neturite tam teisių';
$string['restorecoursenow'] = 'Atkurti šiuos kursus dabar!';
$string['restoredaccount'] = 'Atkurta paskyra';
$string['restoredaccountinfo'] = 'Ši paskyra importuota iš kito serverio, o slaptažodis prarastas. Jei norite naują slaptažodį nustatyti el. paštu, spustelėkite Tęsti.';
$string['restorefinished'] = 'Atkūrimas sėkmingai baigtas';
$string['restoremnethostidmismatch'] = 'Naudotojo \'{$a}\' MNet prieglobos ID neatitinka vietinio MNet prieglobos ID.';
$string['restoreto'] = 'Atkurti';
$string['restoretositeadding'] = 'Įspėjimas: ketinate atkurti svetainės pradinį puslapį, pridėdami prie jo duomenų!';
$string['restoretositedeleting'] = 'Įspėjimas: ketinate atkurti svetainės pradinį puslapį, pirmiausia ištrindami duomenis!';
$string['restoreuserconflict'] = 'Bandant naudotoją {$a} atkurti iš atsarginės kopijos failo kils konfliktas';
$string['restoreuserinfofailed'] = 'Atkūrimo procesas sustabdytas, nes jūs neturite teisių atkurti naudotojų duomenis.';
$string['restoreusersprecheck'] = 'Tikrinami naudotojų duomenys';
$string['restoreusersprecheckerror'] = 'Tikrinant naudotojų duomenis aptikta problemų';
$string['restricted'] = 'Apribota';
$string['resultsfound'] = 'Rasta rezultatų: {$a}';
$string['retry'] = 'Bandyti dar kartą';
$string['returningtosite'] = 'Grįžti į šią žiniatinklio svetainę?';
$string['returntooriginaluser'] = 'Grįžti į {$a}';
$string['revert'] = 'Sugrąžinti';
$string['role'] = 'Vaidmuo';
$string['roleassignments'] = 'Vaidmenų priskyrimai';
$string['rolemappings'] = 'Vaidmenų susiejimas';
$string['rolerenaming'] = 'Vaidmenų pervardijimas';
$string['rolerenaming_help'] = 'Pakeiskite rodomus vaidmenų pavadinimus šiame kurse.';
$string['rolerenaming_success'] = 'Kursų vaidmenų pavadinimai atnaujinti.';
$string['roles'] = 'Vaidmenys';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Naujausių RSS straipsnių skaičius';
$string['rsserror'] = 'Įvyko klaida nuskaitant RSS duomenis';
$string['rsserrorauth'] = 'Jūsų RSS saitas neturi tinkamo autentifikavimo ženklo.';
$string['rsserrorguest'] = 'Ši informacijos santrauka duomenims pasiekti naudoja svečio prieigą, bet svečiai neturi teisės skaityti duomenis. Kaip tinkamas naudotojas apsilankykite pradinėje vietoje, iš kurios yra ši santrauka (URL), ir čia gaukite naują RSS saitą.';
$string['rsskeyshelp'] = '<p>Siekiant užtikrinti saugumą ir privatumą, RSS sklaidos kanalo URL yra specialus prieigos raktas, identifikuojantis naudotoją, kuriam jis skirtas. Tai neleidžia kitiems naudotojams pasiekti svetainės sričių, kurios jiems neleidžiamos.</p><p>Prieigos raktas sukuriamas automatiškai, kai pirmą kartą pasiekiate sritį, kurioje sukuriamas RSS sklaidos kanalas. Jei manote, kad jūsų RSS sklaidos kanalo prieigos raktas buvo pažeistas, galite pateikti užklausą dėl naujo spustelėdami nuorodą nustatyti iš naujo. Atminkite, kad jūsų dabartiniai RSS tiekimo URL adresai taps negaliojantys.</p>';
$string['rsstype'] = 'Šios veiklos RSS informacijos santrauka';
$string['save'] = 'Įrašyti';
$string['saveandnext'] = 'Įrašyti ir rodyti kitą';
$string['savechanges'] = 'Įrašyti keitimus';
$string['savechangesanddisplay'] = 'Įrašyti ir rodyti';
$string['savechangesandreturn'] = 'Išsaugoti ir grįžti';
$string['savechangesandreturntocourse'] = 'Įrašyti ir grįžti į kursą';
$string['savecomment'] = 'Įrašyti komentarą';
$string['savedat'] = 'Įrašyta:';
$string['savepreferences'] = 'Įrašyti nuostatas';
$string['saveto'] = 'Įrašyti į';
$string['scale'] = 'Skalė';
$string['scale_help'] = 'Skalė suteikia galimybę įvertinti veiklos atlikimą. Tai kableliais atskirtų reikšmių (nuo neigiamos iki teigiamos) sąrašas. Reikšmių pavyzdžiai: Nepatenkinamai, Nepakankamai gerai, Vidutiniškai, Gerai, Labai gerai, Puikiai.';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skalės';
$string['scalescustom'] = 'Pasirinktinės skalės';
$string['scalescustomcreate'] = 'Įtraukti naują skalę';
$string['scalescustomno'] = 'Dar nėra sukurtų pasirinktinių skalių';
$string['scalesstandard'] = 'Standartinės skalės';
$string['scalestandard'] = 'Standartinė skalė';
$string['scalestandard_help'] = 'Standartinė skalė pasiekiama visoje svetainėje, visuose kursuose.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Norėdami kurti pasirinktines skales, naudokite kursų administravimo meniu saitą Skalės...';
$string['scalestip2'] = 'Norėdami kurti pasirinktines skales, kursų administravimo meniu spustelėkite Įvertinimai, tada pasirinkite Redaguoti > Skalės.';
$string['schedule'] = 'Grafikas';
$string['screenshot'] = 'Momentinė ekrano kopija';
$string['search'] = 'Ieškoti';
$string['search_help'] = 'Jei norite paprastai ieškoti vieno ar daugiau žodžių bet kur tekste, tiesiog įveskite tarpais atskirtus žodžius. Naudojami visi žodžiai, ilgesni nei simboliai. Jei norite vykdyti išplėstinę paiiešką, paspauskite paieškos mygtuką nieko neįvedę į paieškos lauką, kad pasiektumėte išplėstinės paieškos formą.';
$string['searchactivities'] = 'Ieškoti veiklos pagal pavadinimą ar aprašymą';
$string['searchagain'] = 'Ieškoti dar kartą';
$string['searchbyemail'] = 'Ieškoti pagal el. pašto adresą';
$string['searchbyusername'] = 'Ieškoti pagal naudotojo vardą';
$string['searchcoursecategories'] = 'Ieškoti kategorijų';
$string['searchcourses'] = 'Ieškoti kursų';
$string['searchgroups'] = 'Ieškoti grupių';
$string['searchitems'] = 'Ieškoti elementų';
$string['searchoptions'] = 'Paieškos parinktys';
$string['searchresults'] = 'Ieškos rezultatai';
$string['searchusers'] = 'Ieškoti naudotojų';
$string['sec'] = 'sek.';
$string['seconds'] = 'sekundės';
$string['secondsleft'] = '{$a} sek.';
$string['secondstotime172800'] = '2 dienos';
$string['secondstotime259200'] = '3 dienos';
$string['secondstotime345600'] = '4 dienos';
$string['secondstotime432000'] = '5 dienos';
$string['secondstotime518400'] = '6 dienos';
$string['secondstotime604800'] = '1 savaitė';
$string['secondstotime86400'] = '1 diena';
$string['secretalreadyused'] = 'Slaptažodžio keitimo patvirtinimo saitas jau panaudotas, slaptažodis nebuvo pakeistas.';
$string['secs'] = 'sek.';
$string['section'] = 'Dalis';
$string['sectionactionnotsupported'] = 'Sekcijos veiksmas "{$a}" čia yra nepalaikomas';
$string['sectionname'] = 'Dalies pavadinimas';
$string['sections'] = 'Dalys';
$string['seealsostats'] = 'Taip pat žr.: statistika';
$string['selctauser'] = 'Pasirinkti naudotoją';
$string['select'] = 'Pasirinkti';
$string['selectacategory'] = 'Prašome pasirinkti kategoriją';
$string['selectacountry'] = 'Pasirinkti šalį';
$string['selectacourse'] = 'Pasirinkti kursą';
$string['selectacoursesite'] = 'Pasirinkti kursą ar nuorodą';
$string['selectagroup'] = 'Pasirinkti grupę';
$string['selectall'] = 'Pasirinkti viską';
$string['selectallusersonpage'] = 'Pasirinkti visus naudotojus šiame puslapyje';
$string['selectalluserswithcount'] = 'Pasirinkti visus {$a} naudotojus';
$string['selectamodule'] = 'Pasirinkite veiklos modulį';
$string['selectanaction'] = 'Pasirinkite veiklą';
$string['selectanoptions'] = 'Pasirinkti parinktį';
$string['selectaregion'] = 'Pasirinkti regioną';
$string['selectcategorysort'] = 'Kurias kategorijas norėtumėte rikiuoti?';
$string['selectcategorysortby'] = 'Pasirinkite kaip norite rikiuoti kategorijas';
$string['selectcoursesortby'] = 'Pasirinkite kaip norite rikiuoti kursus';
$string['selectdefault'] = 'Pasirinkti numatytąją reikšmę';
$string['selectedcategories'] = 'Pasirinktos kategorijos';
$string['selectedfile'] = 'Pasirinkti failą';
$string['selectednowmove'] = '{$a} failų pasirinkta perkelti. Dabar eikite į paskirties aplanką ir paspauskite Perkelti failus čia.';
$string['selectfiles'] = 'Pasirinkti failus';
$string['selectfiltertype'] = 'Pasirinkti';
$string['selectgroupsseparate'] = 'Pasirinkti atskiras grupes';
$string['selectgroupsvisible'] = 'Pasirinkti matomas grupes';
$string['selectitem'] = 'Pasirinkti „{$a}“';
$string['selectmoduletoviewhelp'] = 'Pasirinkite veiklą ar išteklių, norėdami gauti informacijos apie jį.

Dukart spustelėkite ant veiklos ar išteklio vardo norėdami greitai jį įtraukti.';
$string['selectnos'] = 'Pasirinkti visus „ne“';
$string['selectperiod'] = 'Pasirinkti laikotarpį';
$string['senddetails'] = 'Siųsti mano informaciją el. paštu';
$string['sent'] = 'Išsiųsta';
$string['separate'] = 'Atsietas';
$string['separateandconnected'] = 'Atsiejamasis ir jungiamasis pažinimo būdai';
$string['separateandconnectedinfo'] = 'Ši skalė grįsta atsiejamojo ir jungiamojo pažinimo būdų teorija. Joje apibrėžiami du skirtingi pažinimo būdai, nusakantys, kaip mes vertiname ir suvokiame tai, ką matome ir girdime.<ul><li><strong>Asmenys, kuriems būdingas atsiejamojo pažinimo būdas,</strong> lieka kiek įmanoma objektyvūs, atsiriboja nuo pojūčių ir emocijų. Diskutuodami su kitais jie linkę ginti savo idėjas, naudojasi logika tam, kad rastų silpniausias vietas oponento argumentuose .</li><li><strong> Asmenys, kuriems būdingas jungiamasis pažinimo būdas,</strong> yra jautresni kitiems. Jie yra empatiški, linkę išklausyti bei klausti, kol jaučia, kad supranta kitą ir gali pažvelgti į pasaulį pašnekovo akimis. Jie mokosi bandydami pasidalinti patirtimi, kurios įgijo bendraudami su kitais.</li></ul>';
$string['servererror'] = 'Įvyko klaida, bandant susisiekti su serveriu';
$string['serverlocaltime'] = 'Serverio vietos laikas';
$string['sessionforceclean'] = 'Saugumo sumetimais naudotojo sukurti scenarijai buvo išjungti per šią sesiją.';
$string['sessiontimeoutsoon'] = 'Jūsų sesija netrukus baigsis. Ar norite tęsti dabartinę sesiją?';
$string['setcategorytheme'] = 'Nustatyti kategorijos temą';
$string['setmode'] = 'Nustatyti režimą';
$string['setpassword'] = 'Nustatyti slaptažodį';
$string['setpasswordinstructions'] = 'Žemiau įveskite naują slaptažodį, tada išsaugokite pakeitimus.';
$string['settings'] = 'Parametrai';
$string['share'] = 'Bendrinti';
$string['shortname'] = 'Trumpasis pavadinimas';
$string['shortnamecollisionwarning'] = '[*] = šį trumpąjį pavadinimą jau naudoja kiti kursai ir jį reikės pakeisti patvirtinant';
$string['shortnamecourse'] = 'Trumpasis kurso pavadinimas';
$string['shortnamecourse_help'] = 'Pavadinimas rodomas srityse, kuriose vietos nedaug. Jis turi būti unikalus.';
$string['shortnametaken'] = 'Trumpasis pavadinimas jau naudojamas kitiems kursams ({$a})';
$string['shortnameuser'] = 'Naudotojo trumpasis vardas';
$string['shortsitename'] = 'Trumpasis svetainės pavadinimas (pvz., vieno žodžio)';
$string['show'] = 'Rodyti';
$string['showactions'] = 'Rodyti veiksmus';
$string['showactivitydates'] = 'Rodyti veiklos datas';
$string['showactivitydates_help'] = 'Rodyti veiklos datas kurso puslapyje.';
$string['showadvancededitor'] = 'Papildomai';
$string['showadvancedsettings'] = 'Rodyti išplėstinius parametrus';
$string['showall'] = 'Rodyti viską {$a}';
$string['showallcourses'] = 'Rodyti visus kursus';
$string['showallusers'] = 'Rodyti visus naudotojus';
$string['showblockcourse'] = 'Rodyti kursų sąrašą su bloku';
$string['showcategory'] = 'Rodyti {$a}';
$string['showchartdata'] = 'Rodyti diagramos duomenis';
$string['showcomments'] = 'Rodyti / slėpti komentarus';
$string['showcommentsnonjs'] = 'Rodyti komentarus';
$string['showdescription'] = 'Rodyti aprašymą kurso puslapyje';
$string['showdescription_help'] = 'Jei įgalinta, aprašymas, esantis aukščiau, bus rodomas kurso puslapyje iš karto po nuoroda į veiklą ar išteklių.';
$string['showgrades'] = 'Rodyti įvertinimų knygelę besimokantiesiems';
$string['showgrades_help'] = 'Leisti besimokantiesiems peržiūrėti visų jų kurso įvertinimų sąrašą.';
$string['showingacourses'] = 'Rodomi visi {$a} kursai';
$string['showingxofycourses'] = 'Rodomi kursai nuo {$a->start} iki {$a->end} iš {$a->total} kursų';
$string['showless'] = 'Rodyti mažiau';
$string['showlistofcourses'] = 'Rodyti kursų sąrašą';
$string['showmodulecourse'] = 'Rodyti kursų sąrašą su veikla';
$string['showmore'] = 'Rodyti daugiau';
$string['showoncoursepage'] = 'Rodyti kurso puslapyje';
$string['showonly'] = 'Rodyti tik';
$string['showperpage'] = 'Rodyti {$a} viename puslapyje';
$string['showpopoverwindow'] = 'Rodyti iššokantį langą';
$string['showrecent'] = 'Rodyti naują veiklą';
$string['showreports'] = 'Rodyti veiklos ataskaitas';
$string['showreports_help'] = 'Leisti besimokantiesiems peržiūrėti savo veiklos ataskaitas savo profilio puslapyje.';
$string['showsettings'] = 'Rodyti parametrus';
$string['showtheselogs'] = 'Rodyti šiuos žurnalus';
$string['showthishelpinlanguage'] = 'Rodyti žinyną šia kalba: {$a}';
$string['sidepanel'] = 'Šoninis skydelis';
$string['signoutofotherservices'] = 'Atsijungti nuo visų žiniatinklio programų';
$string['signoutofotherservices_help'] = 'Atsijunkite nuo visų įrenginių ir sistemų, kuriose naudojamos žiniatinklio paslaugos, pvz., mobiliosios programėlės. Naršyklės sesijos išliks aktyvios.';
$string['since'] = 'Nuo';
$string['sincelast'] = 'nuo paskutinio prisijungimo';
$string['site'] = 'Svetainė';
$string['sitedefault'] = 'Svetainės numatytoji reikšmė';
$string['sitedefaultspecified'] = 'Numatytoji svetainės parinktis ({$a})';
$string['siteerrors'] = 'Svetainės klaidos';
$string['sitefiles'] = 'Svetainės failai';
$string['sitefilesused'] = 'Šiuose kursuose naudojami svetainės failai';
$string['sitehome'] = 'Pagrindinis svetainės puslapis';
$string['sitelegacyfiles'] = 'Senstelėję svetainės failai';
$string['sitelogs'] = 'Svetainės žurnalai';
$string['sitenews'] = 'Svetainės skelbimai';
$string['sitepages'] = 'Svetainės puslapiai';
$string['sitepartlist'] = 'Jūs neturite reikiamų teisių peržiūrėti dalyvių sąrašą';
$string['sitepartlist0'] = 'Turite būti svetainės dėstytojas, kad galėtumėte peržiūrėti dalyvių sąrašą';
$string['sitepartlist1'] = 'Turite būti dėstytojas, kad galėtumėte peržiūrėti svetainės dalyvių sąrašą';
$string['sites'] = 'Svetainės';
$string['sitesection'] = 'Įtraukti temų dalį';
$string['sitesettings'] = 'Svetainės parametrai';
$string['siteteachers'] = 'Svetainės dėstytojai';
$string['size'] = 'Dydis';
$string['sizeb'] = 'baitai';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Praleista';
$string['skiptocategorylisting'] = 'Pereiti į kategorijų sąrašą';
$string['skiptocoursedetails'] = 'Pereiti į išsamią kursų informacija';
$string['skiptocourselisting'] = 'Pereiti į kurso sąrašus';
$string['socialheadline'] = 'Socialinis forumas – naujausios temos';
$string['someallowguest'] = 'Kai kuriuose kursuose galima svečio prieiga';
$string['someerrorswerefound'] = 'Nėra kai kurios informacijos arba ji neteisinga. Išsamesnės informacijos žr. toliau.';
$string['sort'] = 'Rūšiuoti';
$string['sortby'] = 'Rūšiuoti pagal';
$string['sortbyx'] = 'Rūšiuoti pagal {$a} didėjimo tvarka';
$string['sortbyxreverse'] = 'Rūšiuoti pagal {$a} mažėjimo tvarka';
$string['sorting'] = 'Rūšiavimas';
$string['sourcerole'] = 'Šaltinio vaidmuo';
$string['specifyname'] = 'Turite nurodyti pavadinimą.';
$string['standard'] = 'Standartinis';
$string['starpending'] = '([*] =kursai, laukiantys patvirtinimo)';
$string['startdate'] = 'Kurso pradžios data';
$string['startdate_help'] = 'Šia data nustatoma savaitinio formato kurso pirmosios savaitės pradžia. Ji taip pat yra kurso veiklos žurnalų pradžios data.

Jei iš naujo nustatysite kursą ir pakeisite šią datą, visos kurso datos bus perkeltos pagal naująją pradžios datą.';
$string['startdatewithtaskenabled'] = 'Kurso pradžios data';
$string['startdatewithtaskenabled_help'] = 'Data, kai kursas tampa matomas besimokantiesiems. Iki šios datos jie negalės pasiekti kurso.

Ši data taip pat lemia pirmosios savaitės pradžią kurso savaitiniu formatu ir yra kurso veiklos žurnalų pradžios data. Jei iš naujo nustatysite kursą ir pakeisite šią datą, visos kurso datos bus perkeltos naujos pradžios datos atžvilgiu.';
$string['startingfrom'] = 'Prasideda nuo';
$string['startsignup'] = 'Kurti naują paskyrą';
$string['state'] = 'Šalis/Regionas';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistikos diagrama';
$string['stats'] = 'Statistikos';
$string['statslogins'] = 'Prisijungimai';
$string['statsmodedetailed'] = 'Išsamus (naudotojo) rodinys';
$string['statsmodegeneral'] = 'Bendrasis rodinys';
$string['statsnodata'] = 'Nėra duomenų, susijusių su šiuo kursų ir laikotarpio deriniu.';
$string['statsnodatauser'] = 'Nėra duomenų, susijusių su šiuo kursų, naudotojo ir laikotarpio deriniu.';
$string['statsoff'] = 'Statistika šiuo metu neįjungta';
$string['statsreads'] = 'Peržiūros';
$string['statsreport1'] = 'Prisijungimai';
$string['statsreport10'] = 'Naudotojo veikla';
$string['statsreport11'] = 'Aktyviausi kursai';
$string['statsreport12'] = 'Aktyviausi kursai (svertiniai)';
$string['statsreport13'] = 'Kursai, kuriuose daugiausiai dalyvaujama (registracijos)';
$string['statsreport14'] = 'Kursai, kuriuose daugiausiai dalyvaujama (įrašai/peržiūros)';
$string['statsreport2'] = 'Peržiūros (visi vaidmenys)';
$string['statsreport3'] = 'Įrašai (visi vaidmenys)';
$string['statsreport4'] = 'Visa veikla (visi vaidmenys)';
$string['statsreport5'] = 'Visa veikla (peržiūros ir įrašai)';
$string['statsreport7'] = 'Naudotojų veikla (peržiūros ir įrašai)';
$string['statsreport8'] = 'Visa naudotojų veikla';
$string['statsreport9'] = 'Prisijungimai (svetainės kursai)';
$string['statsreportactivity'] = 'Visa veikla (visi vaidmenys)';
$string['statsreportactivitybyrole'] = 'Visa veikla (peržiūros ir įrašai)';
$string['statsreportforuser'] = 'kieno';
$string['statsreportlogins'] = 'Prisijungta/Prisijungimai';
$string['statsreportreads'] = 'Peržiūros (visi vaidmenys)';
$string['statsreporttype'] = 'Ataskaitos tipas';
$string['statsreportwrites'] = 'Įrašai (visi vaidmenys)';
$string['statsstudentactivity'] = 'Besimokančiojo veikla';
$string['statsstudentreads'] = 'Besimokančiojo peržiūros';
$string['statsstudentwrites'] = 'Besimokančiojo įrašai';
$string['statsteacheractivity'] = 'Dėstytojo veikla';
$string['statsteacherreads'] = 'Dėstytojo peržiūrėos';
$string['statsteacherwrites'] = 'Dėstytojo įrašai';
$string['statstimeperiod'] = 'Laikotarpis – paskutinis:';
$string['statsuniquelogins'] = 'Unikalūs prisijungimai';
$string['statsuseractivity'] = 'Visa veikla';
$string['statsuserlogins'] = 'Prisijungimai';
$string['statsuserreads'] = 'Peržiūros';
$string['statsuserwrites'] = 'Įrašai';
$string['statswrites'] = 'Įrašai';
$string['status'] = 'Būsena';
$string['statuscritical'] = 'Kritinis';
$string['statuserror'] = 'Klaida';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'Netaikoma';
$string['statusok'] = 'Gerai';
$string['statusunknown'] = 'Nežinomas';
$string['statuswarning'] = 'Įspėjimas';
$string['stringsnotset'] = 'Šios eilutės neapibrėžtos {$a}';
$string['studentnotallowed'] = 'Deja, negalite įvesti šių kursų kaip „{$a}“';
$string['students'] = 'Besimokantieji';
$string['studentsandteachers'] = 'Besimokantieji ir dėstytojai';
$string['subcategories'] = 'Subkategorijos';
$string['subcategory'] = 'Subkategorija';
$string['subcategoryof'] = 'Subkategorija {$a}';
$string['subject'] = 'Tema';
$string['submit'] = 'Pateikti';
$string['success'] = 'Pavyko';
$string['successduration'] = 'Sėkmingas ({$a} sek.)';
$string['summary'] = 'Suvestinė';
$string['summary_help'] = 'Suvestinė – tai trumpas tekstas, skirtas informuoti besimokančiuojus apie tam tikros temos ar savaitės veiklas. Šis tekstas rodomas kursų puslapyje po dalies pavadinimu.';
$string['summaryof'] = '{$a} suvestinė';
$string['supplyinfo'] = 'Daugiau informacijos';
$string['suspended'] = 'Sulaikyta';
$string['suspendedusers'] = 'Sulaikyti naudotojai';
$string['switchdevicedefault'] = 'Persijungti į standartinę temą';
$string['switchdevicerecommended'] = 'Persijungti į jūsų įrenginiui rekomenduojamą apipavidalinimą/temą';
$string['switchrolereturn'] = 'Grįžti į mano įprastą vaidmenį';
$string['switchroleto'] = 'Perjungti vaidmenį į...';
$string['switchroleto_help'] = 'Pasirinkite vaidmenį peržiūrai kaip yra matomas kursas tuo vaidmeniu.

Atkreipkite dėmesį, kad ši peržiūra nėra visiškai tiksli (<a href="https://docs.moodle.org/en/Switch_roles">Žiūrėti išsamią informaciją ir alternatyvas</a>).';
$string['tag'] = 'Žymė';
$string['tagalready'] = 'Tokia žymė jau yra';
$string['tagmanagement'] = 'Įtraukti / naikinti žymes...';
$string['tags'] = 'Žymės';
$string['targetrole'] = 'Tikslinis vaidmuo';
$string['teacheronly'] = 'tiktai dėl {$a}';
$string['teacherroles'] = '{$a} vaidmenys';
$string['teachers'] = 'Dėstytojai';
$string['textcopiedtoclipboard'] = 'Tekstas nukopijuotas į iškarpinę';
$string['textediting'] = 'Tekstų rengyklė';
$string['textediting_help'] = 'Jei pasirinkta HTML rengyklę, pvz., Atto arba TinyMCE, teksto įvesties lauke bus įrankių juosta su teksto redagavimo mygtukais.

Jei pasirinkta „Jabber“ žinutė, galima pasirinkti teksto įvesties srityje formatą, pvz., HTML arba Markdown.

Teksto rengyklių pasirinkimo sąrašą nustato svetainės administratorius.';
$string['texteditor'] = 'Naudoti įprastines žiniatinklio formas';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Paprastojo teksto formatas';
$string['thanks'] = 'Ačiū';
$string['theme'] = 'Apipavidalinimas';
$string['themes'] = 'Apipavidalinimai';
$string['themesaved'] = 'Įrašyta nauja tema';
$string['therearecourses'] = 'Čia yra {$a} paskaitų';
$string['thereareno'] = 'Nėra {$a} šiuose kursuose';
$string['thiscategory'] = 'Ši kategorija';
$string['thiscategorycontains'] = 'Ši kategorija apima';
$string['time'] = 'Laikas';
$string['timecreated'] = 'Sukūrimo laikas';
$string['timecreatedcourse'] = 'Kurso laikas sukurtas';
$string['timesplitting:deciles'] = 'Paskutinė dešimtoji';
$string['timesplitting:deciles_help'] = 'Šis analizės intervalas kursą padalija į dešimtąsias (10 lygių dalių), o kiekviena prognozė grindžiama tik naujausios ankstesnės dešimtosios dalies duomenimis.';
$string['timesplitting:decilesaccum'] = 'Visos ankstesnės dešimtosios';
$string['timesplitting:decilesaccum_help'] = 'Šis analizės intervalas kursą padalija į dešimtąsias (10 lygių dalių), o kiekviena prognozė grindžiama sukauptais visų ankstesnių dešimtųjų duomenimis.';
$string['timesplitting:nosplitting'] = 'Nėra laiko limito';
$string['timesplitting:nosplitting_help'] = 'Šiam modeliui neapibrėžtas joks analizės intervalas.';
$string['timesplitting:onemonthafterstart'] = 'Praėjus mėnesiui nuo pradžios';
$string['timesplitting:onemonthafterstart_help'] = 'Šis analizės intervalas sukuria prognozę praėjus 1 mėnesiui nuo analizuojamos pradžios.';
$string['timesplitting:oneweekafterstart'] = 'Savaitė po pradžios';
$string['timesplitting:oneweekafterstart_help'] = 'Šis analizės intervalas sukuria prognozę praėjus 1 savaitei nuo analizuojamos pradžios.';
$string['timesplitting:past3days'] = 'Paskutinės 3 dienos';
$string['timesplitting:past3days_help'] = 'Šis analizės intervalas sukuria prognozes kas 3 dienas. Rodiklių skaičiavimai bus pagrįsti pastarųjų 3 dienų duomenimis.';
$string['timesplitting:pastmonth'] = 'Praėjęs mėnuo';
$string['timesplitting:pastmonth_help'] = 'Šis analizės intervalas kiekvieną mėnesį generuoja prognozes. Rodiklių skaičiavimai bus pagrįsti praėjusio mėnesio duomenimis.';
$string['timesplitting:pastweek'] = 'Praėjusi savaitė';
$string['timesplitting:pastweek_help'] = 'Šis analizės intervalas kiekvieną savaitę generuoja prognozes. Rodiklių skaičiavimai bus pagrįsti praėjusia savaite.';
$string['timesplitting:quarters'] = 'Paskutinis ketvirtis';
$string['timesplitting:quarters_help'] = 'Šis analizės intervalas padalija kursą į ketvirčius (4 lygios dalys), o kiekviena prognozė grindžiama tik paskutinio praėjusio ketvirčio duomenimis.';
$string['timesplitting:quartersaccum'] = 'Visi ankstesni ketvirčiai';
$string['timesplitting:quartersaccum_help'] = 'Šis analizės intervalas padalija kursą į ketvirčius (4 lygias dalis), o kiekviena prognozė grindžiama sukauptais visų ankstesnių ketvirčių duomenimis.';
$string['timesplitting:singlerange'] = 'Nuo pradžios iki pabaigos';
$string['timesplitting:singlerange_help'] = 'Šis analizės intervalas visą kursą laiko vienu intervalu.';
$string['timesplitting:tenpercentafterstart'] = '10% po pradžios';
$string['timesplitting:tenpercentafterstart_help'] = 'Šis analizės intervalas sukuria prognozę, kai baigiama 10 % kurso.';
$string['timesplitting:upcoming3days'] = 'Artimiausios 3 dienos';
$string['timesplitting:upcoming3days_help'] = 'Šis analizės intervalas sukuria prognozes kas 3 dienas. Rodiklių skaičiavimai bus pagrįsti artimiausiomis 3 dienomis.';
$string['timesplitting:upcomingfortnight'] = 'Artimiausios dvi savaitės';
$string['timesplitting:upcomingfortnight_help'] = 'Šis analizės intervalas sukuria prognozes kas dvi savaites. Rodiklių skaičiavimai bus pagrįsti ateinančiomis dviem savaitėmis.';
$string['timesplitting:upcomingweek'] = 'Ateinanti savaitė';
$string['timesplitting:upcomingweek_help'] = 'Šis analizės intervalas kiekvieną savaitę generuoja prognozes. Rodiklių skaičiavimai bus pagrįsti ateinančia savaite.';
$string['timezone'] = 'Laiko juosta';
$string['to'] = 'Iki';
$string['tocontent'] = 'Perkelti į "{$a}"';
$string['tocreatenewaccount'] = 'Praleisti ir kurti naują paskyrą';
$string['today'] = 'Šiandien';
$string['todaylogs'] = 'Šiandienos žurnalas';
$string['toeveryone'] = 'visiems';
$string['toggleemojipicker'] = 'Perjungti jaustukų rinkiklį';
$string['togglesearch'] = 'Perjungti paieškos įvestį';
$string['toomanybounces'] = 'Šiuo el. pašto adresu nepristatyta per daug laiškų. Norėdami tęsti, <b>turite</b> jį pakeisti.';
$string['toomanytags'] = 'Ši paieška apima per daug žymų; kai kurios bus ignoruojamos.';
$string['toomanytoshow'] = 'Yra per daug naudotojų, kad būtų galima parodyti.';
$string['toomanyusersmatchsearch'] = 'Per daug naudotojų ({$a->count}) atitinka {$a->search}';
$string['toomanyuserstoshow'] = 'Per daug naudotojų ({$a}), kad būtų galima parodyti';
$string['toonly'] = 'tik {$a}';
$string['top'] = 'Viršus';
$string['topic'] = 'Tema';
$string['topichide'] = 'Slėpti šią temą nuo {$a}';
$string['topicoutline'] = 'Temos struktūra';
$string['topicshow'] = 'Rodyti šią temą {$a}';
$string['toplevelcategory'] = 'Aukščiausio lygio kategorija';
$string['total'] = 'Bendroji suma';
$string['totopofsection'] = 'Į viršų skyriuje "{$a}"';
$string['trackforums'] = 'Forumo sekimas';
$string['trackforumsno'] = 'Ne: nesekti pranešimų, kuriuos mačiau';
$string['trackforumsyes'] = 'Taip: man paryškinti naujus pranešimus';
$string['trysearching'] = 'Bandykite vietoj to ieškoti.';
$string['turneditingoff'] = 'Išjungti redagavimą';
$string['turneditingon'] = 'Įjungti redagavimą';
$string['unabletocopytoclipboard'] = 'Nepavyksta nukopijuoti teksto į iškarpinę';
$string['unauthorisedlogin'] = 'Naudotojo paskyra "{$a}" neprieinama šioje svetainėje';
$string['undecided'] = 'Nenuspręsta';
$string['unexistingcmid'] = 'Nerastas kurso modulio ID';
$string['unexistingsectionid'] = 'Nerastas kurso skyriaus ID';
$string['unfinished'] = 'Nebaigta';
$string['unknowncategory'] = 'Nežinoma kategorija';
$string['unknownerror'] = 'Nežinoma klaida';
$string['unknownuser'] = 'Nežinomas naudotojas';
$string['unlimited'] = 'Neribota';
$string['unpacking'] = 'Išpakuojama {$a}';
$string['unsafepassword'] = 'Nesaugus slaptažodis – pabandykite naudoti kitą';
$string['untilcomplete'] = 'Kol bus baigta';
$string['unusedaccounts'] = 'Paskyros, nenaudotos daugiau nei {$a} d., yra automatiškai išregistruojamos';
$string['unzip'] = 'Išskleisti';
$string['unzippingbackup'] = 'Išskleidžiama atsarginė kopija';
$string['up'] = 'Aukštyn';
$string['update'] = 'Redaguoti';
$string['updated'] = 'Atnaujinta {$a}';
$string['updatemymoodleoff'] = 'Stabdyti šio puslapio tinkinimą';
$string['updatemymoodleon'] = 'Tinkinti šį puslapį';
$string['updatemyprofile'] = 'Atnaujinti profilį';
$string['updatesevery'] = 'Atnaujinti kas {$a} sek.';
$string['updatethis'] = 'Atnaujinti {$a}';
$string['updatethiscourse'] = 'Atnaujinti šiuos kursus';
$string['updatinga'] = 'Atnaujinama: {$a}';
$string['updatingain'] = '{$a->what} atnaujinama {$a->in}';
$string['upload'] = 'Įkelti';
$string['uploadafile'] = 'Įkelti failą';
$string['uploadcantwrite'] = 'Nepavyko įrašyti failo į diską';
$string['uploadedfile'] = 'Failas sėkmingai įkeltas';
$string['uploadedfileto'] = '{$a->file} įkeltas į {$a->directory}';
$string['uploadedfiletoobig'] = 'Atsiprašome, bet šis failas yra per didelis (limitas yra {$a} B)';
$string['uploadextension'] = 'Failo įkėlimas sustabdytas dėl plėtinio';
$string['uploadfailednotrecovering'] = 'Nepavyko įkelti failų, nes su vienu failu {$a->name} buvo problemų.<br /> Problemų žurnalas:<br />{$a->problem}<br />Neatkuriama.';
$string['uploadfilelog'] = 'Failo {$a} įkėlimo žurnalas';
$string['uploadformlimit'] = 'Įkeltas failas viršijo maksimalų formos nustatytą dydžio limitą';
$string['uploadlabel'] = 'Pavadinimas:';
$string['uploadlimitwithsize'] = 'Maksimalus leidžiamas tipui „{$a->contextname}" dydis ({$a->displaysize})';
$string['uploadnewfile'] = 'Įkelti naują failą';
$string['uploadnofilefound'] = 'Nerastas joks failas, ar esate tikri, kad pasirinkote failą įkelti?';
$string['uploadnotallowed'] = 'Įkelti neleidžiama';
$string['uploadnotempdir'] = 'Nėra laikinojo aplanko';
$string['uploadoldfilesdeleted'] = 'Panaikinti jūsų įkėlimo srityje esantys seni failai';
$string['uploadpartialfile'] = 'Failas buvo tik iš dalies įkeltas';
$string['uploadproblem'] = 'Įkeliant failą {$a} įvyko nežinoma problema (gal jis buvo per didelis?)';
$string['uploadrenamedchars'] = 'Failas buvo pervardytas iš {$a->oldname} į {$a->newname}, nes buvo netinkamų simbolių.';
$string['uploadrenamedcollision'] = 'Failas buvo pervardytas iš {$a->oldname} į {$a->newname} dėl failo vardo konflikto.';
$string['uploadserverlimit'] = 'Įkeltas failas viršijo maksimalų serverio nustatytą dydžio limitą';
$string['uploadthisfile'] = 'Įkelti šį failą';
$string['url'] = 'URL';
$string['used'] = 'Naudojama';
$string['usedinnplaces'] = 'Naudojama {$a} vietose';
$string['user'] = 'Naudotojas';
$string['useraccount'] = 'Naudotojo paskyra';
$string['useractivity'] = 'Veikla';
$string['userconfirmed'] = 'Patvirtinta {$a}';
$string['userdata'] = 'Naudotojo duomenys';
$string['userdeleted'] = 'Ši naudotojo paskyra buvo panaikinta';
$string['userdescription'] = 'Aprašas';
$string['userdescription_help'] = 'Šiame lauke galite įvesti šiek tiek teksto apie save, kuris bus rodomas mūsų profilio puslapyje, kad matytų kiti.';
$string['userdetails'] = 'Naudotojo informacija';
$string['userfiles'] = 'Naudotojo failai';
$string['userlist'] = 'Naudotojų sąrašas';
$string['usermatchedon'] = 'Šis naudotojas atitinka paiešką pagal šį lauką';
$string['usermenu'] = 'Naudotojo meniu';
$string['usermenugoback'] = 'Grįžkti į naudotojo meniu';
$string['username'] = 'Naudotojo vardas';
$string['usernameemail'] = 'Naudotojo vardas ar el. paštas';
$string['usernameemailmatch'] = 'Šis naudotojo vardas ir el. pašto adresas nėra susiję su tuo pačiu naudotoju';
$string['usernameexists'] = 'Šis naudotojo vardas jau yra, pasirinkite kitą';
$string['usernamelowercase'] = 'Leidžiamos tik mažosios raidės';
$string['usernamenotfound'] = 'Naudotojo vardo nepavyko rasti duomenų bazėje';
$string['usernameoremail'] = 'Įveskite naudotojo vardą ar el. pašto adresą';
$string['usernotconfirmed'] = 'Nepavyko patvirtinti {$a}';
$string['userpic'] = 'Naudotojo paveikslėlis';
$string['userpreferences'] = 'Naudotojo nuostatos';
$string['users'] = 'Naudotojai';
$string['userselectorautoselectunique'] = 'Jei paiešką atitinka tik vienas naudotojas, pasirinkti jį automatiškai';
$string['userselectorpreserveselected'] = 'Palikti pasirinktus naudotojus net jei jie nebeatitinka paieškos';
$string['userselectorsearchanywhere'] = 'bet kur';
$string['userselectorsearchexactmatchonly'] = 'tik tikslūs atitikmenys';
$string['userselectorsearchfromstart'] = 'nuo pradžių';
$string['userselectorsearchmatching'] = 'Atitikimas:';
$string['usersnew'] = 'Nauji naudotojai';
$string['usersnoaccesssince'] = 'Neaktyvus daugiau nei';
$string['userswithfiles'] = 'Naudotojai su failais';
$string['useruploadtype'] = 'Naudotojo įkėlimo tipas: {$a}';
$string['userzones'] = 'Naudotojų zonos';
$string['usetheme'] = 'Naudoti temą';
$string['usingexistingcourse'] = 'Naudojami esami kursai';
$string['validatehtml'] = 'Patvirtinti HTML';
$string['valuealreadyused'] = 'Ši reikšmė jau buvo naudota.';
$string['version'] = 'Versija';
$string['view'] = 'Peržiūrėti';
$string['viewallcourses'] = 'Peržiūrėti visus kursus';
$string['viewallcoursescategories'] = 'Peržiūrėti visus kursus ir kategorijas';
$string['viewallresults'] = 'Peržiūrėti visus rezultatus ({$a})';
$string['viewallsubcategories'] = 'Žiūrėti visas subkategorijas';
$string['viewfileinpopup'] = 'Peržiūrėti failą iššokančiajame lange';
$string['viewing'] = 'Peržiūrimas:';
$string['viewmore'] = 'Rodyti daugiau';
$string['viewprofile'] = 'Peržiūrėti profilį';
$string['viewresults'] = 'Žiūrėti {$a} rezultatus';
$string['views'] = 'Peržiūros';
$string['viewsolution'] = 'peržiūrėti sprendimą';
$string['visible'] = 'Matoma';
$string['visible_help'] = 'Šis parametras nurodo, ar kursai rodomi kursų sąraše. Kursų negali įvesti bet kurie naudotojai, bet tik dėstytojai ir administratoriai.';
$string['visibletostudents'] = 'Kam matoma: {$a}';
$string['warning'] = 'Įspėjimas';
$string['warningdeleteresource'] = 'Įspėjimas: {$a} yra nurodytas ištekliuje. Ar norėtumėte atnaujinti išteklių?';
$string['wcagcheck'] = 'Žiniatinklio turinio pritaikomumo gairių (WCAG) patikra';
$string['webpage'] = 'Tinklalapis';
$string['week'] = 'Savaitė';
$string['weekhide'] = 'Slėpti šią savaitę nuo {$a}';
$string['weeklyoutline'] = 'Savaitinis išdėstymas';
$string['weeks'] = 'savaitės';
$string['weekshow'] = 'Rodyti šią savaitę {$a}';
$string['welcomeback'] = 'Sveiki, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Sveiki atvykę į {$a}';
$string['welcometocoursetext'] = 'Sveiki, čia kursas "{$a->coursename}"!

Jei dar neredagavote, turite redaguoti savo profilio puslapį, kad galėtume daugiau apie jus sužinoti:

{$a->profileurl}';
$string['welcometosite'] = 'Sveiki, {$a->firstname}! 👋';
$string['whatforlink'] = 'Ką jūs norite daryti su nuoroda?';
$string['whatforpage'] = 'Ką jūs norite daryti su tekstu?';
$string['whatisyourage'] = 'Kiek Jums metų?';
$string['whattocallzip'] = 'Kaip norite pavadinti ZIP failą?';
$string['whattodo'] = 'Ką daryti';
$string['wheredoyoulive'] = 'Kurioje šalyje gyvenate?';
$string['whyisthisrequired'] = 'Kodėl yra reikalinga?';
$string['windowclosing'] = 'Šis langas turi užsidaryti automatiškai. Jei ne, uždarykite jį dabar.';
$string['withchosenfiles'] = 'Su pasirinktais failais';
$string['withdisablednote'] = '{$a} (išjungta)';
$string['withoutuserdata'] = 'be naudotojų duomenų';
$string['withselectedusers'] = 'Su pasirinktais naudotojais';
$string['withuserdata'] = 'su naudotojų duomenimis';
$string['wontrunfuturescheduledtask'] = 'Nevykdys užduoties, kuri nebuvo nesėkminga ir kurią planuojama vykdyti ateityje';
$string['wordforstudent'] = 'Jūsų žodis, skirtas pavadinti besimokantįjį';
$string['wordforstudenteg'] = 'pvz., besimokantysis, dalyvis ir t. t.';
$string['wordforstudents'] = 'Jūsų žodis, skirtas pavadinti besimokančiuosius';
$string['wordforstudentseg'] = 'pvz., besimokantieji, dalyviai ir t. t.';
$string['wordforteacher'] = 'Jūsų žodis, skirtas pavadinti dėstytoją';
$string['wordforteachereg'] = 'pvz., dėstytojas, vadovas, mokytojas ir t. t.';
$string['wordforteachers'] = 'Jūsų žodis, skirtas pavadinti dėstytojus';
$string['wordforteacherseg'] = 'pvz., dėstytojai, vadovai, mokytojai ir t. t.';
$string['writingblogsinfo'] = 'Tinklaraščių informacijos rašymas';
$string['writingcategoriesandquestions'] = 'Kategorijų ir klausimų rašymas';
$string['writingcoursedata'] = 'Kursų duomenų rašymas';
$string['writingeventsinfo'] = 'Įvykių informacijos rašymas';
$string['writinggeneralinfo'] = 'Bendrosios informacijos rašymas';
$string['writinggradebookinfo'] = 'Įvertinimų knygelės informacijos rašymas';
$string['writinggroupingsgroupsinfo'] = 'Grupavimų ir grupių informacijos rašymas';
$string['writinggroupingsinfo'] = 'Grupavimų informacijos rašymas';
$string['writinggroupsinfo'] = 'Grupių informacijos rašymas';
$string['writingheader'] = 'Antraštės rašymas';
$string['writingloginfo'] = 'Žurnalų informacijos rašymas';
$string['writingmessagesinfo'] = 'Žinučių informacijos rašymas';
$string['writingmoduleinfo'] = 'Modulių informacijos rašymas';
$string['writingscalesinfo'] = 'Skalių informacijos rašymas';
$string['writinguserinfo'] = 'Naudotojų informacijos rašymas';
$string['wrongpassword'] = 'Klaidingas slaptažodis pagal šį naudotojo vardą';
$string['year'] = 'metai';
$string['years'] = 'metai';
$string['yes'] = 'Taip';
$string['youareabouttocreatezip'] = 'Ruošiatės sukurti ZIP failą, kuris apima';
$string['youaregoingtorestorefrom'] = 'Ruošiatės pradėti atkūrimo procesą';
$string['youhaveupcomingactivitiesdue'] = 'Jūs turite numatytas artėjančias  veiklas';
$string['youhaveupcomingactivitiesdueinfo'] = 'Sveiki, {$a},

<br/><br/>Jūs turite numatytas artėjančias veiklas:';
$string['youneedtoenrol'] = 'Norėdami atlikti šį veiksmą, turite įsiregistruoti į šį kursą.';
$string['yourlastlogin'] = 'Jūsų paskutinis prisijungimas';
$string['yourself'] = 'jūs pats';
$string['yourteacher'] = 'jūsų {$a}';
$string['yourwordforx'] = 'Jūsų žodis, skirtas pavadinti {$a}';
$string['zippingbackup'] = 'Glaudinama atsarginė kopija';
