<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dataprivacy', language 'el', version '4.3'.
 *
 * @package     tool_dataprivacy
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitiesandresources'] = 'Δραστηριότητες και πόροι';
$string['addcategory'] = 'Προσθήκη κατηγορίας';
$string['addnewdefaults'] = 'Προσθήκη μιας νέας προεπιλογής αρθρώματος';
$string['addpurpose'] = 'Προσθήκη σκοπού';
$string['addroleoverride'] = 'Προσθήκη παράκαμψης ρόλου';
$string['approve'] = 'Έγκριση';
$string['approvedrequestsubmitted'] = 'Το αίτημά σας έχει υποβληθεί και θα γίνει επεξεργασία του σύντομα.';
$string['approverequest'] = 'Έγκριση αιτήματος';
$string['automaticdatadeletionapproval'] = 'Αυτόματη έγκριση αιτήματος διαγραφής δεδομένων';
$string['automaticdatadeletionapproval_desc'] = 'Εάν ενεργοποιηθεί, οι αιτήσεις διαγραφής δεδομένων εγκρίνονται αυτόματα.<br/>Σημειώστε ότι η αυτόματη έγκριση ισχύει μόνο για νέα αιτήματα διαγραφής δεδομένων με ενεργοποιημένη αυτή τη ρύθμιση. Τα ήδη υπάρχοντα αιτήματα διαγραφής δεδομένων σε αναμονή έγκρισης θα πρέπει να εγκριθούν χειροκίνητα από τον Υπεύθυνο προστασίας δεδομένων.';
$string['automaticdataexportapproval'] = 'Αυτόματη έγκριση εξαγωγής δεδομένων';
$string['automaticdataexportapproval_desc'] = 'Εάν ενεργοποιηθεί, οι αιτήσεις εξαγωγής δεδομένων εγκρίνονται αυτόματα.<br/>Σημειώστε ότι η αυτόματη έγκριση ισχύει μόνο για νέα αιτήματα διαγραφής δεδομένων με ενεργοποιημένη αυτή τη ρύθμιση. Τα ήδη υπάρχοντα αιτήματα διαγραφής δεδομένων σε αναμονή έγκρισης θα πρέπει να εγκριθούν χειροκίνητα από τον υπεύθυνο προστασίας δεδομένων.';
$string['automaticdeletionrequests'] = 'Δημιουργία αιτημάτων αυτόματης διαγραφής δεδομένων';
$string['automaticdeletionrequests_desc'] = 'Εάν ενεργοποιηθεί, θα δημιουργηθεί αυτόματα ένα αίτημα διαγραφής δεδομένων για οποιονδήποτε χειροκίνητα διαγραμμένο λογαριασμό χρήστη.';
$string['bulkapproverequests'] = 'Έγκριση αιτημάτων';
$string['bulkdenyrequests'] = 'Απόρριψη αιτημάτων';
$string['cachedef_contextlevel'] = 'Σκοπός και κατηγορία επιπέδων πλαισίου';
$string['cachedef_purpose'] = 'Σκοποί δεδομένων';
$string['cachedef_purpose_overrides'] = 'Παρακάμψεις σκοπού στο εργαλείο απορρήτου δεδομένων';
$string['cancelrequest'] = 'Ακύρωση αιτήματος';
$string['cancelrequestconfirmation'] = 'Θέλετε πραγματικά να ακυρώσετε αυτό το αίτημα δεδομένων;';
$string['cannotreset'] = 'Δεν είναι δυνατή η επαναφορά αυτού του αιτήματος. Μόνο σε αιτήματα που απορρίφθηκαν μπορεί να γίνει επαναφορά.';
$string['categories'] = 'Κατηγορίες';
$string['categorieslist'] = 'Λίστα κατηγοριών δεδομένων';
$string['category'] = 'Κατηγορία';
$string['category_help'] = 'Μια κατηγορία στο μητρώο δεδομένων περιγράφει έναν τύπο δεδομένων. Μπορεί να προστεθεί μια νέα κατηγορία ή αν έχει επιλεγεί η επιλογή Κληρονομικότητα, εφαρμόζεται η κατηγορία δεδομένων από ένα υψηλότερο πλαίσιο. Τα περιβάλλοντα είναι (από χαμηλό σε υψηλό): Μπλοκ > Αρθρώματα δραστηριότητας > Μαθήματα > Κατηγορίες μαθημάτων > Χρήστης > Ιστότοπος.';
$string['categorycreated'] = 'Η κατηγορία δημιουργήθηκε';
$string['categorydefault'] = 'Προεπιλεγμένη κατηγορία';
$string['categorydefault_help'] = 'Η προεπιλεγμένη κατηγορία είναι η κατηγορία δεδομένων που εφαρμόζεται σε κάθε νέο στιγμιότυπο. Εάν έχει επιλεγεί η επιλογή Κληρονομικότητα, εφαρμόζεται η κατηγορία δεδομένων από ένα υψηλότερο πλαίσιο. Τα πλαίσια είναι (από χαμηλό σε υψηλό): Μπλοκ > Αρθρώματα δραστηριότητας > Μαθήματα > Κατηγορίες μαθημάτων > Χρήστης > Ιστότοπος.';
$string['categoryupdated'] = 'Η κατηγορία ενημερώθηκε';
$string['close'] = 'Κλείσιμο';
$string['compliant'] = 'Συμμορφούμενος';
$string['confirmapproval'] = 'Θέλετε πραγματικά να εγκρίνετε αυτό το αίτημα δεδομένων;';
$string['confirmbulkapproval'] = 'Θέλετε πραγματικά μαζική έγκριση των επιλεγμένων αιτημάτων δεδομένων;';
$string['confirmbulkdenial'] = 'Θέλετε πραγματικά μαζική απόρριψη των επιλεγμένων αιτημάτων δεδομένων;';
$string['confirmcompletion'] = 'Θέλετε πραγματικά να επισημάνετε αυτήν την αίτηση/έρευνα χρήστη ως ολοκληρωμένη;';
$string['confirmcontextdeletion'] = 'Θέλετε πραγματικά να επιβεβαιώσετε τη διαγραφή των επιλεγμένων πλαισίων; Αυτό θα διαγράψει επίσης όλα τα δεδομένα χρήστη για τα αντίστοιχα υπο-πλαίσιά τους.';
$string['confirmdenial'] = 'Θέλετε πραγματικά να απορρίψετε αυτό το αίτημα δεδομένων;';
$string['confirmrequestresubmit'] = 'Είστε βέβαιοι ότι θέλετε να ακυρώσετε το τρέχον αίτημα {$a->type} για {$a->username} και να το υποβάλετε ξανά;';
$string['contactdataprotectionofficer'] = 'Επικοινωνήστε με τον Υπεύθυνο Προστασίας Δεδομένων';
$string['contactdataprotectionofficer_desc'] = 'Εάν ενεργοποιηθεί, οι χρήστες θα μπορούν να επικοινωνούν με τον Υπεύθυνο Προστασίας Δεδομένων και να υποβάλουν αίτημα δεδομένων μέσω ενός συνδέσμου στη σελίδα του προφίλ τους.';
$string['contactdpoviaprivacypolicy'] = 'Παρακαλούμε επικοινωνήστε με τον Υπεύθυνο Προστασίας Δεδομένων όπως περιγράφεται στην πολιτική απορρήτου.';
$string['contextlevelname10'] = 'Ιστότοπος';
$string['contextlevelname30'] = 'Χρήστες';
$string['contextlevelname40'] = 'Κατηγορίες μαθημάτων';
$string['contextlevelname50'] = 'Μαθήματα';
$string['contextlevelname70'] = 'Αρθρώματα δραστηριοτήτων';
$string['contextlevelname80'] = 'Μπλοκ';
$string['contextpurposecategorysaved'] = 'Σκοπός και κατηγορία αποθηκεύτηκαν.';
$string['createcategory'] = 'Δημιουργία κατηγορίας δεδομένων';
$string['createdeletedatarequest'] = 'Δημιουργία αιτήματος διαγραφής δεδομένων';
$string['createnewdatarequest'] = 'Δημιουργία ενός νέου αιτήματος δεδομένων';
$string['createpurpose'] = 'Δημιουργία σκοπού δεδομένων';
$string['creationauto'] = 'Αυτόματα';
$string['creationmanual'] = 'Χειροκίνητα';
$string['datadeletion'] = 'Διαγραφή δεδομένων';
$string['datadeletionpagehelp'] = 'Τα δεδομένα για τα οποία έχει λήξει η περίοδος διατήρησης παρατίθενται εδώ. Παρακαλούμε, ελέγξτε και επιβεβαιώστε τη διαγραφή δεδομένων, η οποία στη συνέχεια θα εκτελείται από την χρονοπρογραμματισμένη εργασία «Διαγραφή ληγμένων πλαισίων».';
$string['dataprivacy:downloadallrequests'] = 'Κατεβάστε τα εξαγόμενα δεδομένα για όλους';
$string['dataprivacy:downloadownrequest'] = 'Λήψη των δικών σας εξαγόμενων δεδομένων';
$string['dataprivacy:makedatadeletionrequestsforchildren'] = 'Αίτημα διαγραφής δεδομένων για ανηλίκους';
$string['dataprivacy:makedatarequestsforchildren'] = 'Κάντε αιτήματα δεδομένων για ανήλικους';
$string['dataprivacy:managedataregistry'] = 'Διαχείριση μητρώου δεδομένων';
$string['dataprivacy:managedatarequests'] = 'Διαχείριση αιτημάτων δεδομένων';
$string['dataprivacy:requestdelete'] = 'Αίτημα διαγραφής δεδομένων για τον εαυτό σας';
$string['dataprivacy:requestdeleteforotheruser'] = 'Αίτημα διαγραφής δεδομένων για λογαριασμό άλλου χρήστη';
$string['dataregistry'] = 'Μητρώο δεδομένων';
$string['dataregistryinfo'] = 'Το μητρώο δεδομένων επιτρέπει να ορίζονται κατηγορίες (τύποι δεδομένων) και σκοποί (οι λόγοι επεξεργασίας των δεδομένων) για όλο το περιεχόμενο του ιστοτόπου - από τους χρήστες και τα μαθήματα έως τις δραστηριότητες και τα μπλοκ. Για κάθε σκοπό, μπορεί να οριστεί περίοδος διατήρησης. Όταν έχει λήξει μια περίοδος διατήρησης, τα δεδομένα σημαιοδοτούνται και παρατίθενται για διαγραφή, αναμένοντας την επιβεβαίωση διαχειριστή.';
$string['datarequestcreatedforuser'] = 'Δημιουργήθηκε αίτημα δεδομένων για {$a}';
$string['datarequestcreatedfromscheduledtask'] = 'Δημιουργήθηκε αυτόματα από χρονοπρογραμματισμένη εργασία (για προϋπάρχοντα διαγραμμένο χρήστη).';
$string['datarequestcreatedupondelete'] = 'Δημιουργήθηκε αυτόματα κατά τη διαγραφή χρήστη.';
$string['datarequestemailsubject'] = 'Αίτημα δεδομένων: {$a}';
$string['datarequests'] = 'Αιτήματα δεδομένων';
$string['dataretentionexplanation'] = 'Αυτή η περίληψη εμφανίζει τις προεπιλεγμένες κατηγορίες και σκοπούς για τη διατήρηση δεδομένων χρήστη. Ορισμένες περιοχές ενδέχεται να έχουν πιο συγκεκριμένες κατηγορίες και σκοπούς από αυτούς που αναφέρονται εδώ.';
$string['dataretentionsummary'] = 'Περίληψη διατήρησης δεδομένων';
$string['datecomment'] = '[{$a->date}]:
{$a->comment}';
$string['daterequested'] = 'Ημερομηνία αιτήματος';
$string['daterequesteddetail'] = 'Ημερομηνία αιτήματος:';
$string['defaultexpired'] = 'Δεδομένα για όλους τους χρήστες';
$string['defaultexpiredexcept'] = 'Δεδομένα για όλους τους χρήστες, εκτός από εκείνους που κατέχουν έναν από τους ακόλουθους ρόλους:<br>
{$a->unexpired}';
$string['defaultsinfo'] = 'Οι προεπιλεγμένες κατηγορίες και οι σκοποί εφαρμόζονται σε όλα τα νέα και υπάρχοντα στιγμιότυπα όπου δεν έχει οριστεί κάποια τιμή.';
$string['defaultssaved'] = 'Οι προεπιλογές αποθηκεύτηκαν';
$string['defaultswarninginfo'] = 'Προειδοποίηση: Η αλλαγή αυτών των προεπιλογών μπορεί να επηρεάσει την περίοδο διατήρησης των υπαρχόντων στιγμιοτύπων.';
$string['defaultunexpired'] = 'Μόνο δεδομένα για χρήστες που κατέχουν έναν από τους ακόλουθους ρόλους:<br>
{$a->expired}';
$string['defaultunexpiredwithexceptions'] = 'Μόνο δεδομένα για χρήστες που κατέχουν έναν από τους ακόλουθους ρόλους:<br>
{$a->expired}
Εκτός αν κατέχουν επίσης έναν από τους ακόλουθους ρόλους:<br>
{$a->unexpired}';
$string['deletecategory'] = 'Διαγραφή κατηγορίας';
$string['deletecategorytext'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε την κατηγορία «{$a}»;';
$string['deletedefaults'] = 'Διαγραφή των προεπιλογών: {$a}';
$string['deletedefaultsconfirmation'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την προεπιλεγμένη κατηγορία και σκοπό για {$a} ενότητες;';
$string['deleteexistingdeleteduserstask'] = 'Δημιουργία αίτησης διαγραφής δεδομένων για προϋπάρχοντες διαγραμμένους χρήστες';
$string['deleteexpiredcontextstask'] = 'Διαγραφή ληγμένων πλαισίων';
$string['deleteexpireddatarequeststask'] = 'Διαγραφή αρχείων εξαγωγής που έχουν λήξει';
$string['deletemyaccount'] = 'Διαγράψτε τον λογαριασμό μου';
$string['deletepurpose'] = 'Διαγραφή σκοπού';
$string['deletepurposetext'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε τον σκοπό «{$a}»;';
$string['deny'] = 'Απόρριψη';
$string['denyrequest'] = 'Απόρριψη αιτήματος';
$string['deprecated'] = 'Ξεπερασμένο';
$string['deprecatedexplanation'] = 'Αυτό το πρόσθετο χρησιμοποιεί μια παλιά έκδοση μιας από τις διασυνδέσεις απορρήτου και πρέπει να ενημερωθεί.';
$string['download'] = 'Λήψη';
$string['downloadexpireduser'] = 'Η λήψη έχει λήξει. Υποβάλετε ένα νέο αίτημα αν θέλετε να εξαγάγετε τα προσωπικά σας δεδομένα.';
$string['dporolemapping'] = 'Αντιστοίχιση ρόλων Υπευθύνου Προστασίας Δεδομένων';
$string['dporolemapping_desc'] = 'Ο Υπεύθυνος Προστασίας Δεδομένων μπορεί να διαχειριστεί αιτήματα δεδομένων. Πρέπει να επιτρέπεται η δυνατότητα tool/dataprivacy:managedatarequests σε ένα ρόλο που παρατίθεται ως επιλογή αντιστοίχισης ρόλου του Υπευθύνου Προστασίας Δεδομένων.';
$string['duplicaterole'] = 'Ο ρόλος αυτός έχει ήδη καθοριστεί';
$string['editcategories'] = 'Επεξεργασία κατηγοριών';
$string['editcategory'] = 'Επεξεργασία κατηγορίας';
$string['editdefaults'] = 'Επεξεργασία προεπιλογών: {$a}';
$string['editmoduledefaults'] = 'Επεξεργασία προεπιλογών αρθρώματος';
$string['editpurpose'] = 'Επεξεργασία σκοπού';
$string['editpurposes'] = 'Επεξεργασία σκοπών';
$string['effectiveretentionperiodcourse'] = '{$a} (μετά την ημερομηνία λήξης του μαθήματος)';
$string['effectiveretentionperioduser'] = '{$a} (από την τελευταία φορά που ο χρήστης πραγματοποίησε πρόσβαση στον ιστότοπο)';
$string['emailsalutation'] = 'Αγαπητέ/ή {$a},';
$string['errorcannotrequestdeleteforother'] = 'Δεν έχετε δικαίωμα δημιουργίας αίτησης διαγραφής για αυτόν τον χρήστη.';
$string['errorcannotrequestdeleteforself'] = 'Δεν έχετε δικαίωμα δημιουργίας αιτήματος διαγραφής για τον εαυτό σας.';
$string['errorcontactdpodisabled'] = 'Η επιλογή επικοινωνίας με τον υπεύθυνο απορρήτου έχει απενεργοποιηθεί.';
$string['errorcontexthasunexpiredchildren'] = 'Το πλαίσιο «{$a}» εξακολουθεί να έχει υπο-πλαίσια που δεν έχουν ακόμη λήξει. Δεν έχουν σημαιοδοτηθεί πλαίσια για διαγραφή.';
$string['errorinvalidrequestcomments'] = 'Το πεδίο σχολίων μπορεί να περιέχει μόνο απλό κείμενο.';
$string['errorinvalidrequestcreationmethod'] = 'Μη έγκυρη μέθοδος δημιουργίας αιτήματος!';
$string['errorinvalidrequeststatus'] = 'Άκυρη κατάσταση αιτήματος!';
$string['errorinvalidrequesttype'] = 'Μη έγκυρος τύπος αιτήματος!';
$string['errornocapabilitytorequestforothers'] = 'Ο χρήστης {$a->requestedby} δεν έχει τη δυνατότητα να κάνει ένα αίτημα δεδομένων για λογαριασμό του χρήστη {$a->userid}';
$string['errornoexpiredcontexts'] = 'Δεν υπάρχουν ληγμένα πλαίσια προς επεξεργασία';
$string['errorrequestalreadyexists'] = 'Έχετε ήδη ένα αίτημα σε εξέλιξη';
$string['errorrequestnotfound'] = 'Το αίτημα δεν βρέθηκε';
$string['errorrequestnotwaitingforapproval'] = 'Το αίτημα δεν αναμένει έγκριση. Είτε δεν είναι ακόμα έτοιμο είτε έχει ήδη υποβληθεί σε επεξεργασία.';
$string['errorsendingmessagetodpo'] = 'Παρουσιάστηκε σφάλμα κατά την προσπάθεια αποστολής μηνύματος στον/στην {$a}.';
$string['exceptionnotificationbody'] = '<p>Εξαίρεση συνέβη κατά την κλήση της <b>{$a->fullmethodname}</b>.<br>Αυτό σημαίνει ότι το πρόσθετο <b>{$a->component}</b> δεν ολοκλήρωσε την επεξεργασία δεδομένων. Οι ακόλουθες πληροφορίες εξαίρεσης μπορούν να μεταβιβαστούν στον δημιουργό του πρόσθετου:</p><pre>{$a->message}<br>

{$a->backtrace}</pre>';
$string['exceptionnotificationsubject'] = 'Εξαίρεση προέκυψε κατά την επεξεργασία δεδομένων απορρήτου';
$string['expandplugin'] = 'Ανάπτυξη και σύμπτυξη πρόσθετου.';
$string['expandplugintype'] = 'Ανάπτυξη και σύμπτυξη τύπου πρόσθετου.';
$string['expiredretentionperiodtask'] = 'Έληξε η περίοδος διατήρησης';
$string['expiredrolewithretention'] = '{$a->retention} (Expired)';
$string['expiry'] = 'Λήξη';
$string['explanationtitle'] = 'Εικόνες που χρησιμοποιήθηκαν σε αυτή τη σελίδα και τι σημαίνουν.';
$string['external'] = 'Επιπρόσθετα';
$string['externalexplanation'] = 'Ένα επιπρόσθετο πρόσθετο εγκαταστάθηκε σε αυτόν τον ιστότοπο.';
$string['filteroption'] = '{$a->category}: {$a->name}';
$string['frontpagecourse'] = 'Μάθημα αρχικής σελίδας';
$string['gdpr_art_6_1_a_description'] = 'Το υποκείμενο των δεδομένων έχει δώσει τη συγκατάθεσή του για την επεξεργασία των προσωπικών του δεδομένων για έναν ή περισσότερους ειδικούς σκοπούς';
$string['gdpr_art_6_1_a_name'] = 'Συγκατάθεση (GDPR Art. 6.1(a))';
$string['gdpr_art_6_1_b_description'] = 'Η επεξεργασία είναι αναγκαία για την εκτέλεση μιας σύμβασης στην οποία είναι υποκείμενο το πρόσωπο στο οποίο αναφέρονται τα δεδομένα ή για τη λήψη μέτρων κατόπιν αιτήματος του υποκειμένου των δεδομένων πριν από τη σύναψη μιας σύμβασης';
$string['gdpr_art_6_1_b_name'] = 'Σύμβαση (GDPR άρθρο 6.1 (β))';
$string['gdpr_art_6_1_c_description'] = 'Η επεξεργασία είναι απαραίτητη για τη συμμόρφωση με μια νομική υποχρέωση στην οποία υπόκειται ο υπεύθυνος επεξεργασίας';
$string['gdpr_art_6_1_c_name'] = 'Νομική υποχρέωση (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 6.1 (γ))';
$string['gdpr_art_6_1_d_description'] = 'Η επεξεργασία είναι απαραίτητη για την προστασία των ζωτικών συμφερόντων του υποκειμένου των δεδομένων ή άλλου φυσικού προσώπου';
$string['gdpr_art_6_1_d_name'] = 'Ζωτικά συμφέροντα (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 6.1 (δ))';
$string['gdpr_art_6_1_e_description'] = 'Η επεξεργασία είναι απαραίτητη για την εκτέλεση ενός καθήκοντος που εκτελείται προς το δημόσιο συμφέρον ή για την άσκηση δημόσιας εξουσίας που έχει ανατεθεί στον υπεύθυνο επεξεργασίας';
$string['gdpr_art_6_1_e_name'] = 'Δημόσια αποστολή (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 6.1 (ε))';
$string['gdpr_art_6_1_f_description'] = 'Η επεξεργασία είναι αναγκαία για τους νόμιμους σκοπούς των συμφερόντων που επιδιώκονται από τον υπεύθυνο επεξεργασίας ή από τρίτο, εκτός εάν τα συμφέροντα ή τα θεμελιώδη δικαιώματα και οι ελευθερίες του προσώπου στο οποίο αναφέρονται τα δεδομένα απαιτούν (υπερισχύουσα) προστασία δεδομένων προσωπικού χαρακτήρα, ιδίως όταν το πρόσωπο είναι παιδί';
$string['gdpr_art_6_1_f_name'] = 'Δικαιολογημένα συμφέροντα (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 6.1 (στ))';
$string['gdpr_art_9_2_a_description'] = 'Το πρόσωπο στο οποίο αναφέρονται τα δεδομένα έχει δώσει ρητά τη συγκατάθεσή του για την επεξεργασία αυτών των προσωπικών δεδομένων για έναν ή περισσότερους καθορισμένους σκοπούς, εκτός εάν η νομοθεσία της Ένωσης ή του κράτους μέλους προβλέπει ότι η απαγόρευση που αναφέρεται στην παράγραφο 1 του άρθρου 9 του Γενικού Κανονισμού Προστασίας Δεδομένων δεν μπορεί να αρθεί από το υποκείμενο των δεδομένων';
$string['gdpr_art_9_2_a_name'] = 'Ρητή συγκατάθεση (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 9.2 (α))';
$string['gdpr_art_9_2_b_description'] = 'Η επεξεργασία είναι απαραίτητη για την εκπλήρωση των υποχρεώσεων και την άσκηση συγκεκριμένων δικαιωμάτων του υπεύθυνου επεξεργασίας ή του υποκειμένου των δεδομένων στον τομέα της απασχόλησης, της κοινωνικής ασφάλισης και της κοινωνικής προστασίας, εφόσον επιτρέπεται από το δίκαιο της Ένωσης ή των κρατών μελών ή από μια συλλογική σύμβαση σύμφωνα με το δίκαιο των κρατών μελών που προβλέπει κατάλληλες διασφαλίσεις για τα θεμελιώδη δικαιώματα και τα συμφέροντα του υποκειμένου των δεδομένων';
$string['gdpr_art_9_2_b_name'] = 'Νόμος περί απασχόλησης και κοινωνικής ασφάλισης/προστασίας (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 9.2 (β))';
$string['gdpr_art_9_2_c_description'] = 'Η επεξεργασία είναι απαραίτητη για την προστασία των ζωτικών συμφερόντων του υποκειμένου των δεδομένων ή άλλου φυσικού προσώπου, όταν το πρόσωπο στο οποίο αναφέρονται τα δεδομένα είναι φυσικά ή νομικά ανίκανο να δώσει συγκατάθεση';
$string['gdpr_art_9_2_c_name'] = 'Προστασία ζωτικών συμφερόντων (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 9.2 (γ))';
$string['gdpr_art_9_2_d_description'] = 'Η επεξεργασία πραγματοποιείται στο πλαίσιο των νόμιμων δραστηριοτήτων του με κατάλληλες διασφαλίσεις από ίδρυμα, ένωση ή οποιοδήποτε άλλο μη κερδοσκοπικό όργανο με πολιτικό, φιλοσοφικό, θρησκευτικό ή συνδικαλιστικό σκοπό και με την προϋπόθεση ότι η επεξεργασία αφορά αποκλειστικά τα μέλη ή τα πρώην μέλη του σώματος ή σε πρόσωπα που έχουν τακτική επαφή με αυτό σε σχέση με τους σκοπούς του και ότι τα προσωπικά δεδομένα δεν αποκαλύπτονται εκτός αυτού του φορέα χωρίς τη συγκατάθεση των υποκειμένων των δεδομένων';
$string['gdpr_art_9_2_d_name'] = 'Νόμιμες δραστηριότητες σχετικά με τα μέλη / στενές επαφές ιδρύματος, ενώσεως ή άλλου μη κερδοσκοπικού οργανισμού (Γενικός Κανονισμός Προστασίας Δεδομένων άρθρο 9.2 (δ))';
$string['gdpr_art_9_2_e_description'] = 'Η επεξεργασία αφορά δεδομένα προσωπικού χαρακτήρα που δημοσιοποιούνται προδήλως από το υποκείμενο των δεδομένων';
$string['gdpr_art_9_2_e_name'] = 'Στοιχεία που δημοσιοποιούνται από το υποκείμενο των δεδομένων (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 9.2 (ε))';
$string['gdpr_art_9_2_f_description'] = 'Η επεξεργασία είναι απαραίτητη για τη σύσταση, άσκηση ή υπεράσπιση νομικών απαιτήσεων ή όταν τα δικαστήρια ενεργούν υπό την ιδιότητα του δικαστή';
$string['gdpr_art_9_2_f_name'] = 'Νομικές αξιώσεις και δικαστικές ενέργειες (GDPR άρθρο 9.2(f))';
$string['gdpr_art_9_2_g_description'] = 'Η επεξεργασία είναι απαραίτητη για λόγους σημαντικού δημοσίου συμφέροντος βάσει του δικαίου της Ένωσης ή των κρατών μελών, ο οποίος είναι ανάλογος προς τον επιδιωκόμενο σκοπό, σέβεται την ουσία του δικαιώματος προστασίας των δεδομένων και προβλέπει κατάλληλα και ειδικά μέτρα για τη διασφάλιση των θεμελιωδών δικαιωμάτων και των συμφερόντων του υποκειμένου των δεδομένων';
$string['gdpr_art_9_2_g_name'] = 'Σημαντικό δημόσιο συμφέρον (Γενικός Κανονισμός για την Προστασία Δεδομένων άρθρο 9.2 (ζ))';
$string['gdpr_art_9_2_h_description'] = 'Η επεξεργασία είναι απαραίτητη για τους σκοπούς της προληπτικής ή επαγγελματικής ιατρικής, για την εκτίμηση της εργασιακής ικανότητας του εργαζομένου, την ιατρική διάγνωση, την παροχή υγειονομικής ή κοινωνικής φροντίδας ή θεραπείας ή τη διαχείριση συστημάτων και υπηρεσιών υγείας ή κοινωνικής πρόνοιας με βάση την νομοθεσία της Ένωσης ή κράτους μέλους ή βάσει σύμβασης με έναν επαγγελματία υγείας και υπό τους όρους και τις εγγυήσεις που αναφέρονται στην παράγραφο 3 του άρθρου 9 του GDPR (Γενικός Κανονισμός για την Προστασία των Δεδομένων)';
$string['gdpr_art_9_2_h_name'] = 'Ιατρικοί σκοποί (Γενικός Κανονισμός Προστασίας Δεδομένων άρθρο 9.2 (η))';
$string['gdpr_art_9_2_i_description'] = 'Η επεξεργασία είναι απαραίτητη για λόγους δημόσιου συμφέροντος στον τομέα της δημόσιας υγείας, όπως η προστασία από σοβαρές διασυνοριακές απειλές κατά της υγείας ή η διασφάλιση υψηλού επιπέδου ποιότητας και ασφάλειας της υγειονομικής περίθαλψης και των φαρμάκων ή των ιατροτεχνολογικών προϊόντων, με βάση το δίκαιο της Ένωσης ή του κράτους μέλους, που προβλέπει κατάλληλα και ειδικά μέτρα για τη διασφάλιση των δικαιωμάτων και ελευθεριών του υποκειμένου των δεδομένων, και ιδίως του επαγγελματικού απορρήτου';
$string['gdpr_art_9_2_i_name'] = 'Δημόσια υγεία (Γενικός Κανονισμός Προστασίας Δεδομένων άρθρο 9.2(θ))';
$string['gdpr_art_9_2_j_description'] = 'Η επεξεργασία είναι απαραίτητη για σκοπούς αρχειοθέτησης για λόγους γενικού συμφέροντος, επιστημονικής ή ιστορικής έρευνας ή για στατιστικούς σκοπούς σύμφωνα με το άρθρο 89(1), βάσει του δικαίου της Ένωσης ή του κράτους μέλους, η οποία είναι ανάλογη προς τον επιδιωκόμενο στόχο, σέβεται την ουσία του δικαιώματος προστασίας των δεδομένων και προβλέπει κατάλληλα και ειδικά μέτρα για τη διασφάλιση των θεμελιωδών δικαιωμάτων και των συμφερόντων του υποκειμένου των δεδομένων';
$string['gdpr_art_9_2_j_name'] = 'Το δημόσιο συμφέρον ή η επιστημονική/ιστορική/στατιστική έρευνα (Γενικός Κανονισμός Προστασίας Δεδομένων άρθρο 9.2 (ι))';
$string['hide'] = 'Σύμπτυξη όλων';
$string['httpwarning'] = 'Όλα τα δεδομένα που έχουν ληφθεί από αυτόν τον ιστότοπο ενδέχεται να μην είναι κρυπτογραφημένα. Παρακαλούμε, επικοινωνήστε με το διαχειριστή του συστήματός σας και ζητήστε να εγκατασταθεί το SSL σε αυτόν τον ιστότοπο.';
$string['inherit'] = 'Κληρονομεί';
$string['lawfulbases'] = 'Νόμιμοι σκοποί';
$string['lawfulbases_help'] = 'Επιλέξτε τουλάχιστον μία επιλογή που θα χρησιμεύσει ως νόμιμος σκοπός για την επεξεργασία προσωπικών δεδομένων. Για λεπτομέρειες σχετικά με αυτούς του νόμιμους σκοπούς, παρακαλούμε, ανατρέξτε στο <a href="https://gdpr-info.eu/art-6-gdpr/" target="_blank">άρθρο 6.1 Γενικού Κανονισμού Προστασίας Δεδομένων</a>';
$string['markcomplete'] = 'Σημείωση ως πλήρες';
$string['markedcomplete'] = 'Η έρευνά σας σημειώθηκε ως ολοκληρωμένη από τον Υπεύθυνο Προστασίας Δεδομένων';
$string['message'] = 'Μήνυμα';
$string['messagelabel'] = 'Μήνυμα:';
$string['messageprovider:contactdataprotectionofficer'] = 'Αιτήματα δεδομένων';
$string['messageprovider:datarequestprocessingresults'] = 'Αποτελέσματα επεξεργασίας αιτήματος δεδομένων';
$string['messageprovider:notifyexceptions'] = 'Ειδοποιήσεις εξαιρέσεων αιτημάτων δεδομένων';
$string['moduleinstancename'] = '{$a->instancename} ({$a->modulename})';
$string['mypersonaldatarequests'] = 'Τα προσωπικά μου αιτήματα δεδομένων';
$string['nameandparent'] = '{$a->parent} / {$a->name}';
$string['nameemail'] = '{$a->name} ({$a->email})';
$string['nchildren'] = '{$a} παιδιά';
$string['newrequest'] = 'Νέο αίτημα';
$string['noactivitiestoload'] = 'Καμία δραστηριότητα';
$string['noassignedroles'] = 'Δεν έχουν ανατεθεί ρόλοι σε αυτό το πλαίσιο';
$string['noblockstoload'] = 'Κανένα μπλοκ';
$string['nocategories'] = 'Δεν υπάρχουν ακόμη κατηγορίες';
$string['nocoursestoload'] = 'Καμία δραστηριότητα';
$string['nodatarequests'] = 'Δεν υπάρχουν αιτήματα δεδομένων';
$string['nodatarequestsmatchingfilter'] = 'Δεν υπάρχουν δεδομένα που να ανταποκρίνονται στο συγκεκριμένο φίλτρο';
$string['noexpiredcontexts'] = 'Σε αυτό το επίπεδο πλαισίου δεν υπάρχουν δεδομένα για τα οποία έχει λήξει η περίοδος διατήρησης.';
$string['nopersonaldatarequests'] = 'Δεν έχετε καθόλου προσωπικά αιτήματα δεδομένων';
$string['nopurposes'] = 'Δεν υπάρχουν ακόμη σκοποί';
$string['nosubjectaccessrequests'] = 'Δεν υπάρχουν καθόλου αιτήματα δεδομένων στα οποία να χρειάζεται ενέργειά σας';
$string['nosystemdefaults'] = 'Ο σκοπός του ιστοτόπου και η κατηγορία δεν έχουν ακόμη οριστεί.';
$string['notset'] = 'Δεν έχει οριστεί (χρησιμοποιήστε την προεπιλεγμένη τιμή)';
$string['notyetexpired'] = '{$a} (δεν έχει ακόμη λήξει)';
$string['overrideinstances'] = 'Επαναφορά στιγμιοτύπων σε προσαρμοσμένες τιμές';
$string['pluginname'] = 'Απόρρητο δεδομένων';
$string['pluginname_help'] = 'Πρόσθετο Απορρήτου δεδομένων';
$string['pluginregistry'] = 'Μητρώο απορρήτου πρόσθετων';
$string['pluginregistrytitle'] = 'Μητρώο συμμόρφωσης απορρήτου πρόσθετων';
$string['privacy'] = 'Απόρρητο';
$string['privacy:metadata:preference:tool_dataprivacy_request-filters'] = 'Τα φίλτρα που εφαρμόζονται αυτήν τη στιγμή στη σελίδα αιτημάτων δεδομένων.';
$string['privacy:metadata:preference:tool_dataprivacy_request-perpage'] = 'Ο αριθμός αιτημάτων δεδομένων που προτιμά ο χρήστης να φαίνονται σε μια σελίδα.';
$string['privacy:metadata:request'] = 'Πληροφορίες από προσωπικά αιτήματα δεδομένων (πρόσβαση υποκειμένων και διαγραφή αιτημάτων) που έγιναν για αυτόν τον ιστότοπο.';
$string['privacy:metadata:request:comments'] = 'Οποιοδήποτε σχόλιο χρήστη συνοδεύει το αίτημα.';
$string['privacy:metadata:request:dpocomment'] = 'Σχόλια που έγιναν από τον Υπεύθυνο Προστασίας Δεδομένων σχετικά με το αίτημα.';
$string['privacy:metadata:request:requestedby'] = 'Το αναγνωριστικό του χρήστη που υποβάλλει το αίτημα, αν γίνει για λογαριασμό άλλου χρήστη.';
$string['privacy:metadata:request:timecreated'] = 'Η χρονοσήμανση που δείχνει πότε έγινε το αίτημα από τον χρήστη.';
$string['privacy:metadata:request:userid'] = 'Το αναγνωριστικό του χρήστη στον οποίο ανήκει η αίτηση';
$string['privacyofficeronly'] = 'Μόνο χρήστες που τους ανατέθηκε ο ρόλος του Υπεύθυνου Προστασίας Δεδομένων ({$a}) έχουν πρόσβαση σε αυτό το περιεχόμενο';
$string['privacyrequestexpiry'] = 'Ημερομηνία λήξης αίτησης δεδομένων';
$string['privacyrequestexpiry_desc'] = 'Ο χρόνος κατά τον οποίο τα εγκεκριμένα αιτήματα δεδομένων θα είναι διαθέσιμα για λήψη πριν λήξουν. Εάν είναι μηδέν, τότε δεν υπάρχει όριο χρόνου.';
$string['protected'] = 'Με προστασία';
$string['protectedlabel'] = 'Η διατήρηση αυτών των δεδομένων έχει ένα υψηλότερο νομικό προηγούμενο σε σχέση με το αίτημα ενός χρήστη να ξεχαστεί. Αυτά τα δεδομένα θα διαγραφούν μόνο μετά τη λήξη της περιόδου διατήρησης.';
$string['purpose'] = 'Σκοπός';
$string['purpose_help'] = 'Ο σκοπός περιγράφει το λόγο για την επεξεργασία των δεδομένων. Μπορεί να προστεθεί ένας νέος σκοπός ή αν επιλεγεί η κληρονομικότητα (Inherit), εφαρμόζεται ο σκοπός από ένα υψηλότερο/γενικότερο πλαίσιο. Τα πλαίσια είναι (από χαμηλότερο προς υψηλότερο): Μπλοκ > Ενότητες δραστηριότητας > Μαθήματα > Κατηγορίες μαθημάτων > Χρήστης > Ιστότοπος.';
$string['purposecreated'] = 'Σκοπός δημιουργίας';
$string['purposedefault'] = 'Προεπιλεγμένος σκοπός';
$string['purposedefault_help'] = 'Ο προεπιλεγμένος σκοπός είναι ο σκοπός που εφαρμόζεται σε κάθε νέο στιγμιότυπο. Εάν έχει επιλεγεί η κληρονομικότητα (Inherit), εφαρμόζεται ο σκοπός από ένα υψηλότερο/γενικότερο πλαίσιο. Τα πλαίσια είναι (από χαμηλότερο προς υψηλότερο): Μπλοκ > Αρθρώματα δραστηριότητας > Μαθήματα > Κατηγορίες μαθημάτων > Χρήστης > Ιστότοπος.';
$string['purposeoverview'] = 'Ένας σκοπός περιγράφει την προβλεπόμενη πολιτική χρήσης και διατήρησης αποθηκευμένων δεδομένων. Η βάση για την αποθήκευση και τη διατήρηση αυτών των δεδομένων περιγράφεται επίσης στο σκοπό.';
$string['purposes'] = 'Σκοποί';
$string['purposeslist'] = 'Λίστα σκοπών δεδομένων';
$string['purposeupdated'] = 'Ο σκοπός ενημερώθηκε';
$string['replyto'] = 'Απάντηση προς';
$string['requestactions'] = 'Ενέργειες';
$string['requestapproved'] = 'Η αίτηση εγκρίθηκε';
$string['requestby'] = 'Η αίτηση έγινε από';
$string['requestbydetail'] = 'Ζητήθηκε από:';
$string['requestcomments'] = 'Σχόλια';
$string['requestcomments_help'] = 'Αυτό το κουτάκι σας επιτρέπει να εισάγετε περισσότερες λεπτομέρειες σχετικά με το αίτημά σας για δεδομένα.';
$string['requestcreation'] = 'Δημιουργία';
$string['requestdenied'] = 'Το αίτημα απορρίφθηκε';
$string['requestemailintro'] = 'Έχετε λάβει ένα αίτημα δεδομένων:';
$string['requestfor'] = 'Χρήστης';
$string['requestmarkedcomplete'] = 'Το αίτημα έχει επισημανθεί ως ολοκληρωμένο';
$string['requestorigin'] = 'Ιστότοπος';
$string['requestsapproved'] = 'Τα αιτήματα εγκρίθηκαν';
$string['requestsdenied'] = 'Τα αιτήματα απορρίφθηκαν';
$string['requeststatus'] = 'Κατάσταση';
$string['requestsubmitted'] = 'Το αίτημά σας υποβλήθηκε στον Υπεύθυνο Προστασίας Δεδομένων του ιστοτόπου';
$string['requesttype'] = 'Τύπος';
$string['requesttype_help'] = 'Επιλέξτε τον λόγο επικοινωνίας με τον υπεύθυνο απορρήτου. Λάβετε υπόψη σας ότι η διαγραφή όλων των προσωπικών δεδομένων θα έχει ως αποτέλεσμα να μην μπορείτε πλέον να συνδεθείτε στον ιστότοπο.';
$string['requesttypedelete'] = 'Διαγραφή όλων των προσωπικών μου δεδομένων';
$string['requesttypedeleteshort'] = 'Διαγραφή';
$string['requesttypeexport'] = 'Εξαγωγή όλων των προσωπικών μου δεδομένων';
$string['requesttypeexportshort'] = 'Εξαγωγή';
$string['requesttypeothers'] = 'Γενική αναζήτηση πληροφοριών';
$string['requesttypeothersshort'] = 'Μήνυμα';
$string['requesttypeuser'] = '{$a->typename} ({$a->user})';
$string['requireallenddatesforuserdeletion'] = 'Να θεωρούνται τα μαθήματα χωρίς ημερομηνία λήξης ως ενεργά';
$string['requireallenddatesforuserdeletion_desc'] = 'Κατά τον υπολογισμό της λήξης του χρήστη, εξετάζονται διάφοροι παράγοντες:

* ο τελευταίος χρόνος σύνδεσης του χρήστη συγκρίνεται με την περίοδο διατήρησης για τους χρήστες, και
* εάν ο χρήστης είναι ενεργά εγγεγραμμένος σε οποιαδήποτε μαθήματα.

Όταν ελέγχετε την ενεργό εγγραφή σε ένα μάθημα, αν το μάθημα δεν έχει ημερομηνία λήξης, τότε αυτή η ρύθμιση χρησιμοποιείται για να προσδιοριστεί εάν το μάθημα θεωρείται ενεργό ή όχι.

Αν το μάθημα δεν έχει ημερομηνία λήξης και αυτή η ρύθμιση είναι ενεργοποιημένη, ο χρήστης δεν μπορεί να διαγραφεί.';
$string['requiresattention'] = 'Απαιτείται προσοχή.';
$string['requiresattentionexplanation'] = 'Αυτό το πρόσθετο δεν χρησιμοποιεί το API απορρήτου του Moodle. Εάν αυτό το πρόσθετο αποθηκεύσει προσωπικά δεδομένα, δεν θα είναι δυνατή η εξαγωγή ή η διαγραφή τους από το σύστημα απορρήτου του Moodle.';
$string['resubmitrequest'] = 'Υποβάλετε ξανά αίτημα {$a->type} για {$a->username}';
$string['resubmitrequestasnew'] = 'Επανυποβολή ως νέο αίτημα';
$string['resubmittedrequest'] = 'Το υπάρχον αίτημα «{$a->type}» για τον/την «{$a->username}» ακυρώθηκε και υποβλήθηκε εκ νέου';
$string['resultdeleted'] = 'Ζητήσατε πρόσφατα να διαγραφεί ο λογαριασμός σας και τα προσωπικά σας δεδομένα στο «{$a}». Αυτή η διαδικασία ολοκληρώθηκε και δεν θα μπορείτε πλέον να συνδεθείτε.';
$string['resultdownloadready'] = 'Το αντίγραφο των προσωπικών σας δεδομένων στο {$a} που ζητήσατε πρόσφατα είναι τώρα διαθέσιμο για λήψη από τον παρακάτω σύνδεσμο.';
$string['retentionperiod'] = 'Περίοδος διατήρησης';
$string['retentionperiod_help'] = 'Η περίοδος διατήρησης καθορίζει το χρονικό διάστημα που πρέπει να τηρούνται τα δεδομένα. Όταν λήξει η περίοδος διατήρησης, τα δεδομένα σημαιοδοτούνται και μπαίνουν σε λίστα για διαγραφή, αναμένοντας επιβεβαίωση διαχειριστή.';
$string['retentionperiodnotdefined'] = 'Δεν καθορίστηκε περίοδος διατήρησης';
$string['retentionperiodzero'] = 'Δεν υπάρχει περίοδος διατήρησης';
$string['reviewdata'] = 'Εξετάστε τα δεδομένα';
$string['role'] = 'Ρόλος';
$string['role_help'] = 'Ο ρόλος πάνω στον οποίο θα εφαρμοστεί η παράκαμψη.';
$string['roleoverride'] = 'Παράκαμψη ρόλου';
$string['roleoverrideoverview'] = 'Η προεπιλεγμένη πολιτική διατήρησης μπορεί να παρακαμφθεί για συγκεκριμένους ρόλους χρηστών, επιτρέποντάς σας να καθορίσετε πολιτική μεγαλύτερης ή μικρότερης διατήρησης. Ο χρήστης λήγει μόνο όταν έχουν λήξει όλοι οι ρόλοι του.';
$string['roleoverrides'] = 'Παρακάμψεις ρόλων';
$string['selectbulkaction'] = 'Παρακαλούμε επιλέξτε μια μαζική ενέργεια.';
$string['selectdatarequests'] = 'Παρακαλούμε επιλέξτε αιτήματα δεδομένων.';
$string['selectuserdatarequest'] = 'Επιλέξτε αίτημα δεδομένων «{$a->requesttype}» του/της «{$a->username}».';
$string['send'] = 'Αποστολή';
$string['sensitivedatareasons'] = 'Λόγοι επεξεργασίας ευαίσθητων προσωπικών δεδομένων';
$string['sensitivedatareasons_help'] = 'Επιλέξτε έναν ή περισσότερους λόγους που μπορούν να εφαρμοστούν οι οποίοι αίρουν την απαγόρευση επεξεργασίας ευαίσθητων προσωπικών δεδομένων που απαιτούνται για αυτόν τον σκοπό. Για περισσότερες πληροφορίες, παρακαλούμε δείτε το <a href="https://gdpr-info.eu/art-9-gdpr/" target="_blank">Άρθρο 9.2 Γενικού Κανονισμού Προσωπικών Δεδομένων</a>';
$string['setdefaults'] = 'Ορισμός προεπιλογών';
$string['showdataretentionsummary'] = 'Εμφάνιση περίληψης διατήρησης δεδομένων';
$string['showdataretentionsummary_desc'] = 'Εάν ενεργοποιηθεί, εμφανίζεται ένας σύνδεσμος προς την περίληψη διατήρησης δεδομένων στο υποσέλιδο σελίδας και στις σελίδες προφίλ χρήστη.';
$string['statusapproved'] = 'Εγκρίθηκε';
$string['statusawaitingapproval'] = 'Αναμένεται έγκριση';
$string['statuscancelled'] = 'Ακυρώθηκε';
$string['statuscomplete'] = 'Ολοκληρώθηκε';
$string['statusdeleted'] = 'Διαγράφηκε';
$string['statusdetail'] = 'Κατάσταση:';
$string['statusexpired'] = 'Έληξε';
$string['statuspending'] = 'Εκκρεμεί';
$string['statuspreprocessing'] = 'Προ-επεξεργασία';
$string['statusprocessing'] = 'Επεξεργασία...';
$string['statusready'] = 'Λήψη έτοιμη';
$string['statusrejected'] = 'Απορρίφθηκε';
$string['subjectscope'] = 'Εμβέλεια υποκειμένου';
$string['subjectscope_help'] = 'Η εμβέλεια υποκειμένου περιγράφει τους ρόλους που μπορούν να ανατεθούν σε αυτό το πλαίσιο.';
$string['summary'] = 'Περίληψη διαμόρφωσης μητρώου';
$string['systemconfignotsetwarning'] = 'Ένας σκοπός και μια κατηγορία δεν έχουν καθοριστεί. Όταν δεν έχουν καθοριστεί, όλα τα δεδομένα θα καταργηθούν κατά την επεξεργασία των αιτημάτων διαγραφής.';
$string['tobedeleted'] = 'Δεδομένα προς διαγραφή';
$string['unexpiredrolewithretention'] = '{$a->retention} (Δεν έχει λήξει)';
$string['user'] = 'Χρήστης';
$string['userlistexplanation'] = 'Αυτό το πρόσθετο έχει τον βασικό πάροχο, αλλά θα πρέπει επίσης να υλοποιήσει τον πάροχο λίστας χρηστών για πλήρη υποστήριξη της λειτουργίας απορρήτου.';
$string['userlistnoncompliant'] = 'Ο πάροχος λίστας χρηστών λείπει';
$string['viewrequest'] = 'Προβολή του αιτήματος';
$string['visible'] = 'Ανάπτυξη όλων';
