<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'el', version '4.3'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountid'] = 'Αναγνωριστικό λογαριασμού Zoom';
$string['actions'] = 'Ενέργειες';
$string['addparticipant'] = 'Προσθέστε συμμετέχοντα';
$string['addparticipantgroup'] = 'Προσθέστε ομάδα συμμετεχόντων';
$string['addroom'] = 'Προσθέστε αίθουσα';
$string['addroomalert'] = 'Προσθέστε αίθουσα πατώντας';
$string['addtocalendar'] = 'Προσθήκη στο ημερολόγιο';
$string['allmeetings'] = 'Όλες οι συσκέψεις';
$string['allmeetings_disable'] = 'Σύνδεσμος απενεργοποίησης όλων των συσκέψεων';
$string['allmeetings_enable'] = 'Σύνδεσμος ενεργοποίησης όλων των συσκέψεων';
$string['alternative_hosts'] = 'Εναλλακτικοί παρουσιαστές';
$string['alternative_hosts_disable'] = 'Απενεργοποίηση επιλογής εναλλακτικών παρουσιαστών';
$string['alternative_hosts_inputfield'] = 'Εμφάνιση της επιλογής εναλλακτικών παρουσιαστών σαν απλό εισαγωγικό πεδίο';
$string['alternative_hosts_picker'] = 'Εμφάνιση της επιλογής εναλλακτικών παρουσιαστών σαν πλαίσιο επιλογής χρήστη με αυτόματη συμπλήρωση';
$string['alternative_hosts_picker_noneselected'] = 'Δεν επιλέχθηκε εναλλακτικός παρουσιαστής';
$string['alternative_hosts_picker_placeholder'] = 'Επιλέξτε χρήστη (-ες)';
$string['apiendpoint'] = 'API άκρο του Zoom';
$string['apiendpoint_global'] = 'Καθολικό API άκρο';
$string['apiidentifier'] = 'Αναγνωριστικό Zoom API';
$string['apiurl'] = 'Διεύθυνση URL Zoom API';
$string['apiurl_desc'] = '';
$string['audio_both'] = 'Ήχος υπολογιστή και τηλέφωνο';
$string['audio_telephony'] = 'Μόνο τηλεφωνία';
$string['audio_voip'] = 'Μόνο ήχος υπολογιστή';
$string['authentication'] = 'Εξουσιοδότιση';
$string['autorecording_cloud'] = 'Υπολογιστικό νέφος (Cloud)';
$string['autorecording_local'] = 'Τοπικά';
$string['autorecording_none'] = 'Πουθενά';
$string['autorecording_userdefault'] = 'Χρήση προεπιλεγμένων ρυθμίσεων χρήστη Zoom';
$string['cachedef_zoomid'] = 'Το αναγνωριστικό χρήστη zoom του χρήστη';
$string['connectionok'] = 'Η σύνδεση λειτουργεί.';
$string['connectionstatus'] = 'Κατάσταση σύνδεσης';
$string['defaultsettings'] = 'Προεπιλεγμένες ρυθμίσεις Zoom';
$string['defaultsettings_help'] = 'Αυτές οι ρυθμίσεις ορίζουν τις προεπιλογές για όλες τις συναντήσεις Zoom και όλα τα ιστοσεμινάρια.';
$string['deleteroom'] = 'Διαγραφή αίθουσας';
$string['displaypassword'] = 'Εμφάνιση κωδικού.';
$string['downloadical'] = 'Λήψη ημερολογίου iCal';
$string['downloadical_disable'] = 'Απενεργοποίηση συνδέσμου λήψης ημερολογίου iCal';
$string['downloadical_enable'] = 'Eνεργοποίηση συνδέσμου λήψης ημερολογίου iCal';
$string['duration'] = 'Διάρκεια (λεπτά)';
$string['encryptiontype'] = 'Τύπος κρυπτογράφησης';
$string['encryptiontype_alwaysshow'] = 'Να εμφανίζεται πάντα η δυνατότητα επιλογής τύπου κρυπτογράφησης, ανεξάρτητα αν ο χρήστης μπορεί ή όχι να χρησιμοποιήσει κρυπτογράφηση από άκρο σε άκρο.';
$string['encryptiontype_disable'] = 'Απενεργοποίηση δυνατότητας επιλογής τύπου κρυπτογράφησης.';
$string['encryptiontype_showonlyife2epossible'] = 'Να εμφανίζεται η δυνατότητα επιλογής τύπου κρυπτογράφησης, μόνο αν ο χρήστης μπορεί να χρησιμοποιήσει κρυπτογράφηση από άκρο σε άκρο.';
$string['end_date_option_after'] = 'Μετά από';
$string['end_date_option_by'] = 'Από';
$string['enddate'] = 'Ημερομηνία λήξης';
$string['endtime'] = 'Ώρα λήξης';
$string['err_downloadicaldisabled'] = 'Η λήψη αρχείων ημερολογίου iCal των συναντήσεων Zoom απενεργοποιήθηκε.';
$string['err_duration_nonpositive'] = 'Η διάρκεια θα πρέπει να είναι θετικός αριθμός.';
$string['err_duration_too_long'] = 'Η διάρκεια δεν μπορεί να υπερβαίνει τις 150 ώρες.';
$string['err_end_date'] = 'Η επαναλαμβανόμενη ημερομηνία λήξης δεν μπορεί να είναι στο παρελθόν.';
$string['err_end_date_before_start'] = 'Η επαναλαμβανόμενη ημερομηνία λήξης δεν μπορεί να είναι πριν από την έναρξη.';
$string['err_invalid_password'] = 'Ο κωδικός ελέγχου πρόσβασης περιέχει μη αποδεκτούς χαρακτήρες.';
$string['err_long_timeframe'] = 'Ζητήθηκε πολύ μεγάλο χρονικό διάστημα, εμφάνιση αποτελεσμάτων τελευταίου μήνα του εύρους.';
$string['err_password'] = 'Ο κωδικός ελέγχου πρόσβασης μπορεί να περιέχει μόνο τους ακόλουθους χαρακτήρες: [a-z A-Z 0-9 @ - _ *]. Μέγιστο 10 χαρακτήρες.';
$string['err_password_required'] = 'Ο κωδικός ελέγχου πρόσβασης είναι απαραίτητος.';
$string['err_start_time_past'] = 'Η ημερομηνία έναρξης δεν μπορεί να είναι στο παρελθόν.';
$string['errorwebservice'] = 'Σφάλμα υπηρεσίας διαδικτύου Zoom: {$a}.';
$string['export'] = 'Εξαγωγή';
$string['firstjoin'] = 'Χρόνος δηλώσεων ένταξης';
$string['firstjoin_desc'] = 'Το νωρίτερο που μπορεί να μπει ένας χρήστης σε μια χρονοπρογραμματισμένη συνάντηση (λεπτά πριν από την έναρξη).';
$string['getmeetingrecordings'] = 'Λάβετε τις εγγραφές συνάντησης από το Zoom';
$string['getmeetingreports'] = 'Λάβετε την αναφορά συνάντησης από το Zoom';
$string['globalsettings'] = 'Καθολικές ρυθμίσεις';
$string['host'] = 'Παρουσιαστής';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/el-gr/articles/208220166">Εναλλακτικοί παρουσιαστές</a> μπορούν να εκκινούν τις συναντήσεις Zoom και να διαχειρίζονται τα δωμάτια αναμονής.';
$string['invalid_status'] = 'Η κατάσταση δεν είναι έγκυρη, ελέγξτε τη βάση δεδομένων.';
$string['invalidscheduleuser'] = 'Δεν μπορείτε να προγραμματίσετε τον καθορισμένο χρήστη.';
$string['join'] = 'Σύνδεση';
$string['join_meeting'] = 'Σύνδεση στη Σύσκεψη';
$string['joinbeforehost'] = 'Σύνδεση στη σύσκεψη πριν από τον παρουσιαστή';
$string['joinbeforehostenable'] = 'Να επιτρέπεται στους συμμετέχοντες να συνδέονται οποιαδήποτε στιγμή.';
$string['joinlink'] = 'Σύνδεσμος εισόδου';
$string['jointime'] = 'Ώρα σύνδεσης';
$string['leavetime'] = 'Ώρα αποχώρησης';
$string['licensesettings'] = 'Ρυθμίσεις άδειας χρήσης';
$string['licensesnumber'] = 'Αριθμός αδειών χρήσης';
$string['meeting_finished'] = 'Ολοκληρώθηκε';
$string['meeting_invite'] = 'Πληροφορίες τηλεφωνικής κλήσης';
$string['meeting_invite_hide'] = 'Απόκρυψη πρόσκλησης στη συνάντηση';
$string['meeting_invite_show'] = 'Εμφάνιση πρόσκλησης στη συνάντηση';
$string['meeting_nonexistent_on_zoom'] = 'Δεν υπάρχει στο Zoom';
$string['meeting_not_started'] = 'Δεν έχει ξεκινήσει';
$string['meeting_started'] = 'Σε εξέλιξη';
$string['meeting_time'] = 'Ώρα Έναρξης';
$string['meetingcapacitywarning'] = 'Προειδοποίηση χωρητικότητας συνάντησης';
$string['meetingcapacitywarning_disable'] = 'Απενεργοποίηση προειδοποίησης χωρητικότητας συνάντησης';
$string['meetingcapacitywarning_enable'] = 'Ενεργοποίηση προειδοποίησης χωρητικότητας συνάντησης';
$string['meetingcapacitywarningheading'] = 'Προειδοποίηση χωρητικότητας συνάντησης:';
$string['modulename'] = 'Σύσκεψη Zoom';
$string['modulename_help'] = 'Το Zoom είναι μια πλατφόρμα βίντεο και διαδικτυακών συσκέψεων που παρέχει στους εξουσιοδοτημένους χρήστες τη δυνατότητα να φιλοξενούν εντός σύνδεσης συναντήσεις.';
$string['modulenameplural'] = 'Συσκέψεις Zoom';
$string['month'] = 'Μήνας(-ες)';
$string['month_day_text'] = 'του μήνα';
$string['newmeetings'] = 'Νέες Συσκέψεις';
$string['nomeetinginstances'] = 'Δεν βρέθηκαν σύνοδοι για αυτή τη σύσκεψη.';
$string['noparticipants'] = 'Δεν βρέθηκαν συμμετέχοντες για αυτήν τη σύνοδο.';
$string['norecordings'] = 'Δεν βρέθηκαν εγγραφές για αυτή τη σύσκεψη.';
$string['norooms'] = 'Δεν υπάρχουν αίθουσες.';
$string['nosessions'] = 'Δεν βρέθηκαν σύνοδοι για το συγκεκριμένο εύρος.';
$string['nozooms'] = 'Δεν υπάρχουν συσκέψεις.';
$string['nozoomsfound'] = 'Δεν βρέθηκαν συναντήσεις για το συγκεκριμένο τμήμα.';
$string['off'] = 'Ανενεργό';
$string['oldmeetings'] = 'Ολοκληρωμένες Συσκέψεις';
$string['on'] = 'Ενεργό';
$string['option_audio'] = 'Επιλογές ήχου';
$string['option_audio_help'] = 'Με αυτή την επιλογή μπορείτε να επιτρέψετε στους χρήστες να καλούν μόνο μέσω τηλεφώνου, μόνο με τον ήχο του υπολογιστή ή και με τα δύο';
$string['option_authenticated_users'] = 'Μόνο αυθεντικοποιημένοι χρήστες';
$string['option_authenticated_users_help'] = 'Με αυτή την επιλογή απαιτείται όλοι οι συμμετέχοντες να συνδέονται με τον εξουσιοδοτημένο λογαριασμό τους Zoom ώστε να μπορούν να συμμετέχουν στη σύσκεψη. <em>Δεν</em> σχετίζεται με τη σύνδεση στο Moodle με κανέναν τρόπο.';
$string['option_auto_recording'] = 'Αυτόματη καταγραφή';
$string['option_auto_recording_help'] = 'Ενεργοποιώντας αυτή την επιλογή θα καταγράφεται αυτόματα η συνάντηση.';
$string['option_encryption_type'] = 'Κρυπτογράφηση';
$string['option_encryption_type_endtoendencryption'] = 'Κρυπτογράφηση από άκρο σε άκρο';
$string['option_host_video'] = 'Βίντεο παρουσιαστή';
$string['option_host_video_help'] = 'Με αυτή την επιλογή το βίντεο του παρουσιαστή θα είναι ορατό όταν συνδέεται στη σύσκεψη. Ακόμα και αν δεν ενεργοποιήσετε αυτή την επιλογή, ο παρουσιαστής θα μπορεί να εκκινήσει το βίντεό του.';
$string['option_jbh'] = 'Σύνδεση πριν από τον παρουσιαστή';
$string['option_mute_upon_entry'] = 'Σίγαση κατά την είσοδο';
$string['option_participants_video'] = 'Βίντεο συμμετεχόντων';
$string['option_participants_video_help'] = 'Με αυτή την επιλογή τα βίντεο των συμμετεχόντων θα είναι ορατά όταν συνδέονται στη σύσκεψη. Ακόμα και αν δεν ενεργοποιήσετε αυτή την επιλογή, οι συμμετέχοντες θα μπορούν να εκκινήσουν τα βίντεό τους.';
$string['option_proxyhost'] = 'Χρήση διακομιστή διαμεσολάβησης';
$string['option_waiting_room'] = 'Ενεργοποίηση χώρου αναμονής';
$string['participantdatanotavailable'] = 'Μη διαθέσιμες λεπτομέρειες';
$string['participantdatanotavailable_help'] = 'Τα δεδομένα των συμμετεχόντων δεν είναι διαθέσιμα για αυτήν τη σύνοδο Zoom (π.χ. λόγω συμμόρφωσης με το νόμο).';
$string['participantgroups'] = 'Ομάδες συμμετεχόντων';
$string['participants'] = 'Συμμετέχοντες';
$string['password'] = 'Κωδικός πρόσβασης';
$string['password_allowed_char'] = 'Ο κωδικός πρόσβασης μπορεί να περιέχει μόνο τους ακόλουθους χαρακτήρες: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = 'Μέγιστο {$a} διαδοχικών χαρακτήρων (abcd, 1111, 1234 κτλ.).';
$string['password_length'] = 'Ελάχιστο {$a} χαρακτήρων.';
$string['password_letter'] = 'Ο κωδικός πρόσβασης πρέπει να περιέχει τουλάχιστον 1 γράμμα.';
$string['password_lower_upper'] = 'Ο κωδικός πρόσβασης πρέπει να περιέχει πεζούς και κεφαλαίους χαρακτήρες.';
$string['password_max_length'] = 'Μέγιστο 10 χαρακτήρων.';
$string['password_number'] = 'Ο κωδικός πρόσβασης πρέπει να περιέχει τουλάχιστον 1 αριθμητικό ψηφίο.';
$string['password_only_numeric'] = 'Ο κωδικός πρόσβασης μπορεί να περιέχει μόνο αριθμούς και κανένα άλλο χαρακτήρα.';
$string['password_special'] = 'Ο κωδικός πρόσβασης πρέπει να έχει τουλάχιστον 1 ειδικό χαρακτήρα (@-_*).';
$string['passwordprotected'] = 'Προστασία Κωδικού Ελέγχου Πρόσβασης';
$string['pluginadministration'] = 'Διαχείριση συνάντησης Zoom';
$string['pluginname'] = 'Σύσκεψη Zoom';
$string['privacy:metadata:zoom_breakout_participants'] = 'Ο πίνακας βάσης δεδομένων που αποθηκεύει μία λίστα συμμετεχόντων σε αίθουσες παράλληλης συνεδρίας μίας σύσκεψης Zoom';
$string['privacy:metadata:zoom_breakout_participants:userid'] = 'Το αναγνωριστικό του συμμετέχοντα χρήστη.';
$string['privacy:metadata:zoom_meeting_details'] = 'Ο πίνακας βάσης δεδομένων που αποθηκεύει πληροφορίες για κάθε στιγμιότυπο σύσκεψης.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Το όνομα της συνάντησης στην οποία συμμετείχε ο χρήστης.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Ο πίνακας βάσης δεδομένων που αποθηκεύει πληροφορίες σχετικά με τους συμμετέχοντες στη συνάντηση.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Πόσο χρόνο βρισκόταν ο συμμετέχων στη συνάντηση';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Ο χρόνος ένταξης του συμμετέχοντα στη συνάντηση';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Ο χρόνος αποχώρησης του συμμετέχοντα από την συνάντηση';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Το όνομα του συμμετέχοντα';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου του συμμετέχοντα';
$string['recording'] = 'Καταγραφή';
$string['recordingadd'] = 'Προσθήκη καταγραφής';
$string['recordingdate'] = 'Ημερομηνία καταγραφής';
$string['recordingdelete'] = 'Θέλετε σίγουρα να διαγράψετε την καταγραφή "{$a}";';
$string['recordinghide'] = 'Απόκρυψη καταγραφής (τώρα εμφανίζεται)';
$string['recordinglink'] = 'Σύνδεσμος καταγραφής';
$string['recordingname'] = 'Τίτλος';
$string['recordingnotfound'] = 'Η καταγραφή δεν βρέθηκε.';
$string['recordingnotvisible'] = 'Η καταγραφή δεν είναι ορατή. Παρακαλούμε επικοινωνήστε με τον Διαχειριστή Συστήματος αν πιστεύετε ότι πρόκειται για σφάλμα.';
$string['recordingpasscode'] = 'Κωδικός πρόσβασης καταγραφής';
$string['recordings'] = 'Καταγραφές';
$string['recordingshow'] = 'Εμφάνιση καταγραφής (τώρα είναι κρυμμένη)';
$string['recordingshowtoggle'] = 'Εναλλαγή εμφάνισης καταγραφής';
$string['recordingurl'] = 'URL καταγραφής';
$string['recordingview'] = 'Προβολή καταγραφών';
$string['recordingvisibility'] = 'Οι καταγραφές αυτής της σύσκεψης είναι ορατές από προεπιλογή;';
$string['recreatesuccessful'] = 'Επιτυχής αναδημιουργία σύσκεψης.';
$string['recurrence_option_daily'] = 'Καθημερινά';
$string['recurrence_option_monthly'] = 'Μηνιαία';
$string['recurrence_option_no_time'] = 'Χωρίς συγκεκριμένη ώρα';
$string['recurrence_option_weekly'] = 'Εβδομαδιαία';
$string['recurrencetype'] = 'Επανάληψη';
$string['recurringmeeting'] = 'Επαναλαμβανόμενη σύσκεψη';
$string['recurringmeeting_help'] = 'Η ενεργοποίηση αυτής της επιλογής θα κάνει τη σύσκεψη επαναλαμβανόμενη χωρίς ημερομηνία ή ώρα λήξης. Στη συνέχεια, μπορείτε να έχετε πρόσβαση ανά πάσα στιγμή.';
$string['recurringmeetinglong'] = 'Επαναλαμβανόμενη σύσκεψη (σύσκεψη χωρίς ημερομηνία ή ώρα λήξης)';
$string['redefinelicenses'] = 'Επαναπροσδιορισμός αδειών χρήσης';
$string['register'] = 'Εγγραφή';
$string['registration'] = 'Απαιτείται εγγραφή';
$string['repeatinterval'] = 'Επανάληψη κάθε';
$string['report'] = 'Αναφορές';
$string['requirepasscode'] = 'Απαιτείται κωδικός πρόσβασης συνάντησης';
$string['room'] = 'Αίθουσα';
$string['roomname'] = 'Όνομα αίθουσας';
$string['rooms'] = 'Αίθουσες';
$string['schedule'] = 'Προγραμματισμός';
$string['schedulefor'] = 'Προγραμματισμός σύσκεψης για';
$string['schedulefor_help'] = 'Μπορείτε να προγραμματίσετε συσκέψεις εκ μέρους άλλου χρήστη. Ως προαπαιτούμενο, ο χρήστης πρέπει να σας έχει αποδώσει δικαίωμα προγραμματισμού στο Zoom. Ο επιλεγμένος χρήστης θα είναι παρουσιαστής της σύσκεψης και η δική του άδεια Zoom θα χρησιμοποιηθεί στη σύσκεψη.';
$string['scheduleforself'] = 'τον εαυτό σας';
$string['schedulingprivilege'] = 'Δικαίωμα προγραμματισμού';
$string['schedulingprivilege_disable'] = 'Απενεργοποίηση επιλογής δικαιώματος προγραμματισμού';
$string['schedulingprivilege_enable'] = 'Ενεργοποίηση επιλογής δικαιώματος προγραμματισμού';
$string['search:activity'] = 'Zoom - πληροφορίες δραστηριότητας';
$string['security'] = 'Ασφάλεια';
$string['selectionarea'] = 'Χωρίς επιλογή';
$string['sessions'] = 'Σύνοδοι';
$string['sessionsreport'] = 'Αναφορά συνόδων';
$string['sesskeyinvalid'] = 'Διαγνώστηκε άκυρη σύνοδος. Αδυναμία περαιτέρω ενεργειών.';
$string['setpasscode'] = 'Ορισμός κωδικού πρόσβασης';
$string['showmedia'] = 'Εμφάνιση ενότητας Πολυμέσων';
$string['showmedia_help'] = 'Με αυτή την επιλογή θα εμφανίζεται η ενότητα Πολυμέσων στη σελίδα δραστηριοτήτων της σύσκεψης.';
$string['showmediaonview'] = 'Εμφάνιση ενότητας Πολυμέσων στη σελίδα της σύσκεψης';
$string['showschedule'] = 'Εμφάνιση ενότητας Προγραμματισμού';
$string['showschedule_help'] = 'Με αυτή την επιλογή θα εμφανίζεται η ενότητα Προγραμματισμού στη σελίδα δραστηριοτήτων της σύσκεψης.';
$string['showscheduleonview'] = 'Εμφάνιση ενότητας Προγραμματισμού στη σελίδα της σύσκεψης';
$string['showsecurity'] = 'Εμφάνιση ενότητας Ασφάλειας';
$string['showsecurity_help'] = 'Με αυτή την επιλογή θα εμφανίζεται η ενότητα Ασφάλειας στη σελίδα δραστηριοτήτων της σύσκεψης.';
$string['showsecurityonview'] = 'Εμφάνιση ενότητας Ασφάλειας στη σελίδα της σύσκεψης';
$string['start'] = 'Έναρξη';
$string['start_meeting'] = 'Έναρξη Σύσκεψης';
$string['start_time'] = 'Όταν';
$string['starthostjoins'] = 'Έναρξη βίντεο όταν εισέλθει ο παρουσιαστής';
$string['startpartjoins'] = 'Έναρξη βίντεο όταν εισέλθουν οι συμμετέχοντες';
$string['starttime'] = 'Ώρα έναρξης';
$string['status'] = 'Κατάσταση';
$string['supplementaryfeaturessettings'] = 'Ρυθμίσεις συμπληρωματικών δυνατοτήτων';
$string['supplementaryfeaturessettings_desc'] = 'Αυτές οι ρυθμίσεις ελέγχουν αν και πώς θα παρέχονται στους χρήστες συμπληρωματικές δυνατότητες του Zoom.';
$string['title'] = 'Τίτλος';
$string['topic'] = 'Θέμα';
$string['unavailable'] = 'Δεν μπορείτε να συνδεθείτε αυτή τη στιγμή.';
$string['unavailablefinished'] = 'Η σύσκεψη έχει ήδη ολοκληρωθεί.';
$string['unavailablefirstjoin'] = 'Μπορείτε να συνδεθείτε το νωρίτερο {$a->mins} λεπτά πριν την προγραμματισμένη ώρα έναρξης.';
$string['unavailablenotstartedyet'] = 'Η σύσκεψη δεν έχει αρχίσει ακόμα.';
$string['updatemeetings'] = 'Ενημέρωση ρυθμίσεων σύσκεψης από το Zoom';
$string['usepersonalmeeting'] = 'Χρήση προσωπικού αναγνωριστικού σύσκεψης {$a}';
$string['waitingroom'] = 'Αίθουσα αναμονής ενεργοποιημένη';
$string['waitingroomenable'] = 'Ενεργοποίηση αίθουσας αναμονής';
$string['webinar'] = 'Ιστοσεμινάριο';
$string['webinar_help'] = 'Αυτή η επιλογή είναι διαθέσιμη μόνο στους προ-εξουσιοδοτημένους λογαριασμούς Zoom.';
$string['zoom:addinstance'] = 'Προσθήκη νέας σύσκεψης Zoom';
$string['zoom:view'] = 'Προβολή συσκέψεων Zoom';
$string['zoomerr'] = 'Προέκυψε σφάλμα με το Zoom';
$string['zoomerr_id_missing'] = 'Πρέπει να καθορίσετε ένα αναγνωριστικό αρθρώματος μαθήματος (course_module) ή ένα αναγνωριστικό στιγμιοτύπου';
$string['zoomerr_meetingnotfound'] = 'Δεν είναι δυνατή η εύρεση αυτής της σύσκεψης στο Zoom. Μπορείτε <a href="{$a->recreate}">να την ξαναδημιουργήσετε εδώ</a> ή <a href="{$a->delete}">να την διαγράψετε πλήρως</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Δεν είναι δυνατή η εύρεση αυτής της σύσκεψης στο Zoom. Παρακαλούμε επικοινωνήστε με τον παρουσιαστή της σύσκεψης, εάν έχετε ερωτήσεις.';
$string['zoomerr_usernotfound'] = 'Δεν είναι δυνατή η εύρεση του λογαριασμού σας στο Zoom. Εάν χρησιμοποιείτε το Zoom για πρώτη φορά, πρέπει να ενεργοποιήσετε τον λογαριασμό σας Zoom πραγματοποιώντας σύνδεση στο <a href="{$a}" target="_blank">{$a}</a>. Αφού ενεργοποιήσετε το λογαριασμό Zoom, φορτώστε ξανά αυτήν τη σελίδα και συνεχίστε τη ρύθμιση της συνάντησής σας. Διαφορετικά, βεβαιωθείτε ότι η διεύθυνση ηλε.ταχυδρομείου σας στο Zoom ταιριάζει με τη διεύθυνσή σας σε αυτό το σύστημα.';
$string['zoomurl'] = 'Διεύθυνση URL αρχικής σελίδας Zoom';
$string['zoomurl_desc'] = '';
