<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pt_br', version '4.3'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Buscar por todos os cursos';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Você ainda não está matriculado em nenhum curso.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Busque por todos os cursos disponíveis abaixo e comece a aprender.';
$string['addon.block_myoverview.noresult'] = 'Sua pesquisa não corresponde a nenhum curso.';
$string['addon.block_myoverview.noresultdescription'] = 'Reajuste sua busca ou navegue em todos os cursos abaixo.';
$string['addon.blog.errorloadentries'] = 'Erro ao carregar entradas de blog.';
$string['addon.blog.showonlyyourentries'] = 'Mostrar somente seus registros';
$string['addon.calendar.calendarevent'] = 'Evento do calendário';
$string['addon.calendar.calendarevents'] = 'Eventos do calendário';
$string['addon.calendar.calendarreminders'] = 'Lembretes do calendário';
$string['addon.calendar.currentmonth'] = 'Mês atual';
$string['addon.calendar.defaultnotificationtime'] = 'Tempo de notificação padrão';
$string['addon.calendar.errorloadevent'] = 'Erro ao carregar o evento.';
$string['addon.calendar.errorloadevents'] = 'Erro ao carregar os eventos.';
$string['addon.calendar.noevents'] = 'Não há eventos';
$string['addon.calendar.reminders'] = 'Lembretes';
$string['addon.calendar.setnewreminder'] = 'Definir um novo lembrete';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} antes';
$string['addon.competency.errornocompetenciesfound'] = 'Nenhuma competência encontrada';
$string['addon.competency.nocompetencies'] = 'Nenhuma competência';
$string['addon.coursecompletion.complete'] = 'Concluído';
$string['addon.coursecompletion.couldnotloadreport'] = 'Não foi possível carregar o relatório de conclusão do curso. Por favor, tente novamente mais tarde.';
$string['addon.enrol_self.confirmselfenrol'] = 'Tem certeza que deseja se inscrever neste curso?';
$string['addon.enrol_self.errorselfenrol'] = 'Ocorreu um erro durante a auto-inscrição.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Seus usuários não estão recebendo nenhuma notificação deste site em seus dispositivos móveis. Ative as notificações mobile na página de configurações de notificação.';
$string['addon.messages.contactlistempty'] = 'A lista de contatos está vazia';
$string['addon.messages.contactname'] = 'Nome do contato';
$string['addon.messages.deletemessage'] = 'Excluir mensagem';
$string['addon.messages.deletemessageconfirmation'] = 'Você tem certeza que deseja excluir esta mensagem? Ela será excluída somente do seu histórico de mensagens, mas ainda poderá ser visualizada pelo usuário que enviou ou recebeu a mensagem.';
$string['addon.messages.errordeletemessage'] = 'Erro ao excluir a mensagem.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Erro ao recuperar contatos do servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Erro ao recuperar discussões do servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Erro ao recuperar mensagens do servidor.';
$string['addon.messages.errorwhileretrievingusers'] = 'Erro ao recuperar usuários do servidor.';
$string['addon.messages.messagenotsent'] = 'A mensagem não foi enviada. Por favor, tente novamente mais tarde.';
$string['addon.messages.newmessages'] = 'Novas mensagens';
$string['addon.messages.nousersfound'] = 'Nenhum usuário encontrado';
$string['addon.messages.showdeletemessages'] = 'Mostrar mensagens excluídas';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Resultados de pesquisa';
$string['addon.messages.type_strangers'] = 'Outros';
$string['addon.messages.useentertosenddescdesktop'] = 'Se desabilitado, você pode usar Ctrl+Enter para enviar a mensagem.';
$string['addon.messages.useentertosenddescmac'] = 'Se desabilitado, você pode usar Cmd+Enter para enviar a mensagem.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Não foi possível enviar mensagens para a conversa {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Não foi possível enviar mensagem(ns) para o usuário {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor, aceite a declaração de envio.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Os detalhes da tarefa e o formulário de envio estarão disponíveis em <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Esta tarefa aceitará envios de <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Você não pode adicionar ou editar um envio no aplicativo porque a declaração de envio não pôde ser recuperada do site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Certos métodos de avaliação ainda não são suportados pelo aplicativo e não podem ser modificados.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Você não pode fazer um envio no aplicativo porque a declaração de envio não pôde ser recuperada do site.';
$string['addon.mod_assign.duedateno'] = 'Não há data de vencimento';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Você não pode adicionar ou editar um envio no aplicativo porque certos plugins ainda não são suportados para edição.';
$string['addon.mod_assign.errorshowinginformation'] = 'As informações de envio não podem ser exibidas.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Este feedback não é suportado pelo aplicativo e pode não conter todas as informações.';
$string['addon.mod_assign.gradenotsynced'] = 'Nota não sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Os participantes que não fizeram um envio não são mostrados.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Existem {{count}} rascunhos.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Existem {{count}} participantes.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Existem {{count}} envios que precisam de avaliação.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Existem {{count}} tarefas enviadas.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Existem {{count}} equipes.';
$string['addon.mod_assign.submissionnotsupported'] = 'Este envio não é suportado pelo aplicativo e pode não conter todas as informações.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'nota do usuário';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'A nota do envio foi modificada no site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'O envio do usuário foi modificado no site.';
$string['addon.mod_chat.confirmloss'] = 'Tem certeza? O histórico do chat pode ser perdido.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Erro ao conectar-se ao chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Erro ao obter dados do chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Erro ao obter usuários de chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Erro ao recuperar mensagens do servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Erro ao enviar a mensagem.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Você deve estar online para enviar mensagens.';
$string['addon.mod_chat.nosessionsfound'] = 'Nenhuma sessão encontrada';
$string['addon.mod_chat.showincompletesessions'] = 'Mostrar sessões incompletas';
$string['addon.mod_choice.errorgetchoice'] = 'Erro ao obter dados de escolha.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% dos usuários escolheram a opção: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Sua última resposta deve ser sincronizada antes de ser incluída nos resultados.';
$string['addon.mod_data.edittagsnotsupported'] = 'Desculpe, a edição de tags não é suportada pelo aplicativo.';
$string['addon.mod_data.errorapproving'] = 'Erro ao aprovar ou desaprovar o registro.';
$string['addon.mod_data.errordeleting'] = 'Erro ao excluir o registro.';
$string['addon.mod_data.gettinglocation'] = 'Obtendo localização';
$string['addon.mod_data.locationnotenabled'] = 'A localização não está habilitada';
$string['addon.mod_data.locationpermissiondenied'] = 'A permissão para acessar sua localização foi negada.';
$string['addon.mod_data.mylocation'] = 'Minha localização';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Desculpe, a busca por tags não é suportada pelo aplicativo.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'A pesquisa com CAPTCHA não pode ser concluída off-line, se não estiver configurada ou se o servidor estiver inativo.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Existem {{count}} respostas enviadas.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Esta pesquisa foi salva para ser enviada posteriormente.';
$string['addon.mod_feedback.questionscountdescription'] = 'Existem {{count}} questões.';
$string['addon.mod_folder.emptyfilelist'] = 'Não há arquivos para mostrar.';
$string['addon.mod_forum.errorgetforum'] = 'Erro ao obter dados do fórum.';
$string['addon.mod_forum.errorgetgroups'] = 'Erro ao obter as configurações do grupo.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Fórum não disponível nesta ordenação';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Tente alterar a ordenação ou entrar online para ver este fórum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Não foi possível criar uma nova discussão em todos os grupos.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Ainda não há discussões neste fórum.';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussões';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respostas';
$string['addon.mod_forum.postingroup'] = 'Postar no grupo "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Atualizar postagens';
$string['addon.mod_glossary.browsemode'] = 'Navegar pelos registros';
$string['addon.mod_glossary.byalphabet'] = 'Em ordem alfabética';
$string['addon.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoria';
$string['addon.mod_glossary.bynewestfirst'] = 'Mais recentes primeiro';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Recentemente atualizado';
$string['addon.mod_glossary.bysearch'] = 'Buscar';
$string['addon.mod_glossary.cannoteditentry'] = 'Não é possível editar o item';
$string['addon.mod_glossary.entriestobesynced'] = 'Itens a serem sincronizados';
$string['addon.mod_glossary.entrypendingapproval'] = 'Este item está aguardando aprovação.';
$string['addon.mod_glossary.errordeleting'] = 'Erro ao excluir o registro';
$string['addon.mod_glossary.errorloadingentries'] = 'Ocorreu um erro ao carregar os itens.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ocorreu um erro ao carregar o item.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ocorreu um erro ao carregar o glossário.';
$string['addon.mod_glossary.noentriesfound'] = 'Nenhuma entrada foi encontrada.';
$string['addon.mod_glossary.searchquery'] = 'Consulta de busca';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Baixar arquivo H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Erro ao obter dados da atividade H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'O pacote H5P não foi baixado. Você precisa baixá-lo para poder usá-lo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'O pacote H5P foi modificado desde o último download. Você precisa baixá-lo novamente para poder usá-lo.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Você precisa estar online para visualizar o pacote H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Ver tentativa {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descrição';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lição contém um salto para uma página de conteúdo aleatório. Não pode ser tentada no aplicativo até que seja iniciada em um navegador da web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Esta tentativa não pode mais ser revisada porque outra tentativa foi finalizada.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Esta tentativa foi finalizada offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Uma tentativa offline foi sincronizada. Você quer revisá-la?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'A tentativa foi finalizada no site.';
$string['addon.mod_lti.errorgetlti'] = 'Erro ao obter dados do módulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'A URL de lançamento não é válida.';
$string['addon.mod_lti.launchactivity'] = 'Iniciar a atividade';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Erro ao carregar o conteúdo da página.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Você pode preencher este questionário no aplicativo, mas precisará enviar a tentativa no navegador pelos seguintes motivos:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'A tentativa do questionário não pode ser enviada pelas seguintes razões:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Esta tentativa não foi sincronizada desde {{$a}}. Se você continuou esta tentativa em outro dispositivo desde então, pode perder dados.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocorreu um erro ao salvar as respostas. Você tem certeza que quer sair do questionário?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Esse questionário não pode ser preenchido no aplicativo porque o funcionamento da questão não é suportado pelo aplicativo:';
$string['addon.mod_quiz.errordownloading'] = 'Erro ao baixar os dados necessários.';
$string['addon.mod_quiz.errorgetattempt'] = 'Erro ao obter dados da tentativa.';
$string['addon.mod_quiz.errorgetquestions'] = 'Erro ao receber as questões.';
$string['addon.mod_quiz.errorgetquiz'] = 'Erro ao receber dados do questionário.';
$string['addon.mod_quiz.errorparsequestions'] = 'Ocorreu um erro ao ler as questões. Por favor, tente fazer esse questionário no navegador web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Esse questionário não pode ser preenchido no aplicativo porque possui questões que não são suportadas pelo aplicativo:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Esse questionário não pode ser tentado no aplicativo porque possui regras de acesso não suportadas pelo aplicativo:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ocorreu um erro ao salvar os dados da tentativa.';
$string['addon.mod_quiz.finishnotsynced'] = 'Concluído, mas não sincronizado';
$string['addon.mod_quiz.opentoc'] = 'Abrir popover de navegação';
$string['addon.mod_quiz.warningattemptfinished'] = 'A tentativa offline foi descartada pois já foi finalizada no site ou não foi encontrada.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algumas respostas offline foram descartadas porque as questões foram modificadas online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentativa não foi finalizada porque algumas respostas offline foram descartadas. Por favor, revise suas respostas e depois envie novamente a tentativa.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'O questionário contem questões que não são suportadas pelo aplicativo.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Erro ao carregar o conteúdo.';
$string['addon.mod_resource.openthefile'] = 'Abrir';
$string['addon.mod_resource.resourcestatusoutdated'] = 'O arquivo foi alterado desde a última vez que você o abriu.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Existe uma versão mais recente deste arquivo. Para vê-lo, conecte seu dispositivo à Internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'A nota não pôde ser calculada.';
$string['addon.mod_scorm.dataattemptshown'] = 'Estes dados pertencem à tentativa número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Ocorreu um erro ao criar uma nova tentativa offline. Por favor, tente novamente.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Erro baixar SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Erro ao obter dados SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Desculpe, o aplicativo só suporta SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'O download de pacotes SCORM está desabilitado no seu site Moodle. Por favor, contate o administrador do site Moodle.';
$string['addon.mod_scorm.errornovalidsco'] = 'Este pacote SCORM não tem um SCO visível para carregar.';
$string['addon.mod_scorm.errorpackagefile'] = 'Infelizmente, o aplicativo suporta apenas pacotes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Ocorreu um erro ao sincronizar. Por favor, tente novamente.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Esta tentativa tem dados que ainda não foram sincronizados.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Esta tentativa não pode ser enviada porque você excedeu o número máximo de tentativas.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este pacote SCORM não foi baixado. Será baixado automaticamente quando você o abrir.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este pacote SCORM foi modificado desde o último download. Será baixado automaticamente quando você o abrir.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Alguns dados offline da tentativa {{number}} foram descartados porque não puderam ser contados como uma nova tentativa.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algumas tentativas não puderam ser sincronizadas com o site porque a última tentativa online ainda não foi finalizada. Por favor, termine a tentativa online primeiro.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Desculpe, houve um problema ao enviar sua pesquisa. Por favor, tente novamente.';
$string['addon.mod_survey.errorgetsurvey'] = 'Erro ao obter dados da pesquisa.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Acessar URL';
$string['addon.mod_url.pointingtourl'] = 'A URL desse recurso direciona para';
$string['addon.mod_wiki.errorloadingpage'] = 'Ocorreu um erro ao carregar a página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Este wiki ainda não tem nenhum conteúdo.';
$string['addon.mod_wiki.gowikihome'] = 'Ir para a primeira página do wiki';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'O título não deve estar vazio';
$string['addon.mod_wiki.viewpage'] = 'Ver página';
$string['addon.mod_wiki.wikipage'] = 'Página wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estratégia de avaliação {{$a}} não suportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Você precisa inserir um título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'O envio foi modificado no site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'A avaliação foi modificada no site.';
$string['addon.notes.warningnotenotsent'] = 'Não foi possível adicionar ou excluir a(s) anotação(ões). {{error}}';
$string['addon.notifications.allownotifications'] = 'Permitir notificações';
$string['addon.notifications.errorgetnotifications'] = 'Erro ao receber notificações.';
$string['addon.notifications.notifications'] = 'Notificações';
$string['addon.notifications.playsound'] = 'Reproduzir som';
$string['addon.notifications.therearentnotificationsyet'] = 'Não há notificações.';
$string['addon.notifications.typeofnotification'] = 'Tipo de notificação';
$string['addon.privatefiles.couldnotloadfiles'] = 'A lista de arquivos não pôde ser carregada.';
$string['addon.privatefiles.emptyfilelist'] = 'Não há arquivos para mostrar.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Infelizmente, atualmente não é possível enviar arquivos para o seu site.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Limpar todos os dados do site?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Limpar dados de todos os cursos?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Limpar todos os dados de \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Downloads de cursos';
$string['addon.storagemanager.courseinfo'] = 'Baixe o conteúdo do curso para trabalhar offline. Sua atividade será sincronizada automaticamente quando seu dispositivo estiver online novamente.';
$string['addon.storagemanager.deleteallsitedata'] = 'Limpar todos os dados do site';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Isso limpará todos os dados de \'{{name}}\', incluindo todos os cursos e dados que permitem que você trabalhe offline.';
$string['addon.storagemanager.deletecourses'] = 'Limpar dados de todos os cursos';
$string['addon.storagemanager.deletedata'] = 'Limpar dados';
$string['addon.storagemanager.deletedatafrom'] = 'Excluir todos os dados baixados de \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Cursos baixados';
$string['addon.storagemanager.downloads'] = 'Downloads';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Erro ao limpar dados.';
$string['addon.storagemanager.managedownloads'] = 'Gerenciar downloads';
$string['addon.storagemanager.totaldownloads'] = 'Total de downloads';
$string['addon.storagemanager.totalspaceusage'] = 'Espaço total utilizado';
$string['appstoredescription'] = 'NOTA: Este aplicativo oficial Moodle Mobile vai funcionar apenas com sites de Moodle que foram configurados para permitir isso. Por favor, fale com o seu administrador do Moodle se você tiver quaisquer problemas para se conectar.

Se o seu site Moodle foi configurado corretamente, você pode usar este aplicativo para:

- Procurar o conteúdo de seus cursos, mesmo quando estiver offline
- Receber notificações instantâneas de mensagens e outros eventos
- Rapidamente encontrar e entrar em contato com outras pessoas em seus cursos
- Fazer upload de imagens, áudio, vídeos e outros arquivos do seu dispositivo móvel
- Visualizar suas notas do curso
- e mais!

Por favor, veja http://docs.moodle.org/en/Mobile_app para todas as últimas informações.

Nós realmente gostaríamos de receber quaisquer boas opiniões sobre a funcionalidade até agora e sugestões sobre o que mais você quer esse aplicativo faça!

O aplicativo requer as seguintes permissões:
Gravar áudio - Para gravação de áudio para enviar para o Moodle
Ler e modificar o conteúdo do cartão SD - Os conteúdos são baixados para o cartão SD para que você possa vê-los offline
Acesso à rede - Para ser capaz de se conectar com seu site Moodle e verificar se você está conectado ou não para mudar para o modo offline
Executar no início do sistema - Para você receber notificações locais, mesmo quando o aplicativo estiver sendo executado em segundo plano
Prevenir telefone de dormir - De forma que você possa receber notificações a qualquer momento';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apresentação Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Planilha Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Documento Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Áudio do Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Arquivo do Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Pasta do Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Planilhas Google';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Vídeo do Google Drive';
$string['core.ajaxendpointnotfound'] = 'Endpoint AJAX não encontrado. Isso pode acontecer se o site Moodle for muito antigo ou bloquear o acesso a este endpoint. O aplicativo Moodle  suporta apenas sistemas Moodle {{$a}} em diante.';
$string['core.browser'] = 'Navegador';
$string['core.calculating'] = 'Calculando';
$string['core.cannotconnect'] = 'Não é possível conectar ao site';
$string['core.cannotdownloadfiles'] = 'Sua escola ou instituição de ensino desabilitou o download de arquivos.';
$string['core.cannotinstallapk'] = 'Não é possível instalar arquivos .apk';
$string['core.cannotinstallapkinfo'] = 'Por motivos de segurança, você não pode instalar aplicativos desconhecidos em seu dispositivo a partir deste aplicativo. Se você ainda deseja prosseguir com a instalação, é necessário abri-lo em um navegador.';
$string['core.cannotlogoutpageblocks'] = 'Salve ou descarte suas alterações antes de continuar.';
$string['core.cannotopeninapp'] = 'Este arquivo pode não funcionar conforme esperado neste dispositivo. Você quer abrí-lo mesmo assim?';
$string['core.cannotopeninappdownload'] = 'Este arquivo pode não funcionar conforme esperado neste dispositivo. Você gostaria de baixá-lo mesmo assim?';
$string['core.captureaudio'] = 'Gravar áudio';
$string['core.capturedimage'] = 'Imagem tirada.';
$string['core.captureimage'] = 'Tirar foto';
$string['core.capturevideo'] = 'Gravar vídeo';
$string['core.certificaterror'] = 'O certificado deste site não é confiável para o seu dispositivo: {{details}}';
$string['core.clearsearch'] = 'Limpar busca';
$string['core.clearstoreddata'] = 'Limpar armazenamento {{$a}}';
$string['core.clicktoseefull'] = 'Clique para ver o conteúdo completo.';
$string['core.comments.commentsnotworking'] = 'Comentários não podem ser recuperados';
$string['core.comments.warningcommentsnotsent'] = 'Não foi possível sincronizar os comentários. {{error}}';
$string['core.confirmcanceledit'] = 'Tem certeza de que deseja sair desta página? Todas as alterações serão perdidas.';
$string['core.confirmleaveunknownchanges'] = 'Tem certeza de que deseja sair desta página? Se você tiver alterações não salvas, elas serão perdidas.';
$string['core.confirmloss'] = 'Tem certeza? Todas as alterações serão perdidas.';
$string['core.confirmopeninbrowser'] = 'Você deseja abri-lo em um navegador da web?';
$string['core.connectionlost'] = 'Conexão com o site perdida';
$string['core.contactsupport'] = 'Entre em contato com o suporte';
$string['core.contenteditingsynced'] = 'O conteúdo que você está editando foi sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Escolher conta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Escolha uma conta para abrir o link.';
$string['core.contentlinks.confirmurlothersite'] = 'Este link pertence a outro site. Você deseja abri-lo?';
$string['core.contentlinks.errornoactions'] = 'Não foi possível encontrar uma ação para executar com este link.';
$string['core.contentlinks.errornosites'] = 'Não foi possível encontrar nenhum site para lidar com este link.';
$string['core.contentlinks.errorredirectothersite'] = 'O URL de redirecionamento não pode apontar para um site diferente.';
$string['core.copiedtoclipboard'] = 'Texto copiado para a área de transferência';
$string['core.copytoclipboard'] = 'Copiar para a área de transferência';
$string['core.course.activitydisabled'] = 'Sua organização desabilitou esta atividade no aplicativo móvel.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Sua organização instalou um plugin que ainda não é suportado.';
$string['core.course.allsections'] = 'Todas as seções';
$string['core.course.aria:sectionprogress'] = 'Progresso da seção:';
$string['core.course.availablespace'] = 'Atualmente, você tem cerca de {{available}} de espaço livre.';
$string['core.course.cannotdeletewhiledownloading'] = 'Arquivos não podem ser excluídos enquanto a atividade está sendo baixada. Por favor, espere o download terminar.';
$string['core.course.confirmdownload'] = 'Você está prestes a baixar {{size}}.{{availableSpace}} Tem certeza de que deseja continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'Não foi possível calcular o tamanho do download.{{availableSpace}} Tem certeza de que deseja continuar?';
$string['core.course.confirmdownloadzerosize'] = 'Você está prestes a começar a baixar.{{availableSpace}} Tem certeza de que deseja continuar?';
$string['core.course.confirmlimiteddownload'] = 'Você não está atualmente conectado ao Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Você está prestes a baixar <strong>pelo menos</strong> {{size}}.{{availableSpace}} Tem certeza de que deseja continuar?';
$string['core.course.couldnotloadsectioncontent'] = 'Não foi possível carregar o conteúdo da seção, por favor tente mais tarde.';
$string['core.course.couldnotloadsections'] = 'Não foi possível carregar as seções. Por favor, tente novamente mais tarde.';
$string['core.course.downloadcoursesprogressdescription'] = 'Baixando cursos: baixados {{count}} de {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Baixando a seção: baixado {{count}} de {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Erro ao baixar curso.';
$string['core.course.errordownloadingsection'] = 'Erro ao baixar seção.';
$string['core.course.errorgetmodule'] = 'Erro ao obter dados da atividade.';
$string['core.course.insufficientavailablequota'] = 'Seu dispositivo não pôde alocar espaço para salvar este download. Reserve espaço para atualizações de aplicativos e do sistema. Por favor, limpe primeiro o espaço de armazenamento.';
$string['core.course.insufficientavailablespace'] = 'Você está tentando baixar {{size}}. Isso deixará o dispositivo com espaço insuficiente para funcionar normalmente. Por favor, limpe primeiro o espaço de armazenamento.';
$string['core.course.lastaccessedactivity'] = 'Última atividade acessada';
$string['core.course.manualcompletionnotsynced'] = 'Conclusão manual não sincronizada.';
$string['core.course.modulenotfound'] = 'Recurso ou atividade não encontrado. Por favor, verifique se você está online e se ainda está disponível.';
$string['core.course.nextactivity'] = 'Próxima atividade';
$string['core.course.nextactivitynotfound'] = 'Próxima atividade não encontrada. É possível que tenha sido ocultada ou excluída.';
$string['core.course.nocontentavailable'] = 'Nenhum conteúdo disponível no momento.';
$string['core.course.previousactivity'] = 'Atividade anterior';
$string['core.course.previousactivitynotfound'] = 'Atividade anterior não encontrada. É possível que tenha sido ocultada ou excluída.';
$string['core.course.refreshcourse'] = 'Atualizar curso';
$string['core.course.useactivityonbrowser'] = 'Você ainda pode usar isso no navegador do seu dispositivo';
$string['core.course.warningmanualcompletionmodified'] = 'A conclusão manual de uma atividade foi modificada no site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Alguma conclusão manual off-line do curso \'{{name}}\' foi excluída. {{erro}}';
$string['core.coursenogroups'] = 'Você não é membro de nenhum grupo deste curso.';
$string['core.courses.browserenrolinstructions'] = 'Vamos levá-lo ao navegador do seu dispositivo. Depois de concluir sua inscrição, volte para este aplicativo.';
$string['core.courses.cannotretrievemorecategories'] = 'Categorias mais profundas que o nível {{$a}} não podem ser recuperadas.';
$string['core.courses.completeenrolmentbrowser'] = 'Concluir inscrição no navegador';
$string['core.courses.confirmselfenrol'] = 'Tem certeza de que deseja se inscrever neste curso?';
$string['core.courses.downloadcourses'] = 'Baixar todos os cursos';
$string['core.courses.enrolme'] = 'Inscreva-me';
$string['core.courses.errorloadcategories'] = 'Ocorreu um erro ao carregar categorias.';
$string['core.courses.errorloadcourses'] = 'Ocorreu um erro ao carregar cursos.';
$string['core.courses.errorloadplugins'] = 'Os plugins necessários para este curso, não foram carregados corretamente. Por favor reinicie o aplicativo e tente novamente.';
$string['core.courses.errorsearching'] = 'Ocorreu um erro ao buscar.';
$string['core.courses.errorselfenrol'] = 'Ocorreu um erro ao se inscrever automaticamente.';
$string['core.courses.filtermycourses'] = 'Filtrar meus cursos';
$string['core.courses.notenrollable'] = 'Você não pode se inscrever neste curso.';
$string['core.courses.otherenrolments'] = 'Outras inscrições';
$string['core.courses.password'] = 'Chave de inscrição';
$string['core.courses.refreshcourses'] = 'Recarregar cursos';
$string['core.courses.searchcoursesadvice'] = 'Você pode usar o botão de busca para encontrar cursos para acessar como convidado ou se inscrever em cursos que permitam inscrição.';
$string['core.courses.selfenrolment'] = 'Autoinscrição';
$string['core.courses.showonlyenrolled'] = 'Mostrar apenas meus cursos';
$string['core.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo atual';
$string['core.datastoredoffline'] = 'Os dados foram armazenados no dispositivo porque não foi possível enviar agora. Os dados serão automaticamente enviados mais tarde.';
$string['core.deletedoffline'] = 'Offline excluído';
$string['core.deleting'] = 'Excluindo';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Dispensar';
$string['core.dontshowagain'] = 'Não mostrar novamente.';
$string['core.downloaded'] = 'Baixado';
$string['core.downloading'] = 'Baixando';
$string['core.editor.hidetoolbar'] = 'Ocultar barra de ferramentas';
$string['core.editor.toggle'] = 'Alternar editor';
$string['core.emptysplit'] = 'Esta página aparecerá em branco se o painel esquerdo estiver vazio ou estiver carregando.';
$string['core.endingtime'] = 'Horário final: {{$a}}';
$string['core.errorchangecompletion'] = 'Ocorreu um erro ao alterar o status de conclusão. Por favor, tente novamente.';
$string['core.errorcode'] = 'Código do erro: {{errorCode}}';
$string['core.errordeletefile'] = 'Erro ao excluir o arquivo. Por favor, tente novamente.';
$string['core.errordetailshide'] = 'Ocultar detalhes do erro';
$string['core.errordetailsshow'] = 'Mostrar detalhes do erro';
$string['core.errordownloading'] = 'Erro ao baixar o arquivo.';
$string['core.errordownloadingsomefiles'] = 'Erro ao baixar arquivos. Alguns arquivos podem estar faltando.';
$string['core.errorfileexistssamename'] = 'Já existe um arquivo com este nome.';
$string['core.errorinvalidform'] = 'Verifique se todos os campos obrigatórios estão preenchidos e se os dados inseridos estão no formato correto.';
$string['core.errorinvalidresponse'] = 'Resposta inesperada para {{method}} webservice.';
$string['core.errorloadingcontent'] = 'Erro ao carregar conteúdo.';
$string['core.errorofflinedisabled'] = 'A navegação offline está desabilitada no seu site. Você precisa estar conectado à internet para usar o aplicativo.';
$string['core.erroropenfiledownloading'] = 'Erro ao abrir arquivo: você precisa esperar o download ser concluído.';
$string['core.erroropenfilenoapp'] = 'Erro ao abrir arquivo: nenhum aplicativo encontrado para abrir este tipo de arquivo.';
$string['core.erroropenfilenoextension'] = 'Erro ao abrir arquivo: o arquivo não tem uma extensão.';
$string['core.erroropenpopup'] = 'Esta atividade está tentando abrir um pop-up. Isso não é suportado no aplicativo.';
$string['core.errorrenamefile'] = 'Erro ao renomear arquivo. Por favor, tente novamente.';
$string['core.errorsitesupport'] = 'Se o problema persistir, entre em contato com o suporte do site.';
$string['core.errorsomedatanotdownloaded'] = 'Se você baixou esta atividade, observe que alguns dados não são baixados durante o processo de download por motivos de desempenho e uso de dados.';
$string['core.errorsomethingwrong'] = 'Algo deu errado. Por favor, tente novamente.';
$string['core.errorsync'] = 'Ocorreu um erro ao sincronizar. Por favor, tente novamente.';
$string['core.errorsyncblocked'] = 'Este {{$a}} não pode ser sincronizado agora devido a um processo em andamento. Por favor, tente novamente mais tarde. Se o problema persistir, tente reiniciar o aplicativo.';
$string['core.errorurlschemeinvalidscheme'] = 'URL deve ser usado em outro aplicativo: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Esta URL do site não pode ser aberta neste aplicativo.';
$string['core.filenameexist'] = 'O nome do arquivo já existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Áudio';
$string['core.fileuploader.camera'] = 'Câmera';
$string['core.fileuploader.confirmuploadfile'] = 'Você está prestes a enviar {{size}}. Você tem certeza que quer continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Não foi possível calcular o tamanho do upload. Tem certeza de que deseja continuar?';
$string['core.fileuploader.discardrecording'] = 'Descartar gravação';
$string['core.fileuploader.errorcapturingaudio'] = 'Erro ao capturar áudio.';
$string['core.fileuploader.errorcapturingimage'] = 'Erro ao capturar imagem.';
$string['core.fileuploader.errorcapturingvideo'] = 'Erro ao capturar  vídeo.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Erro ao obter imagem do álbum.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Você precisa estar online para enviar arquivos.';
$string['core.fileuploader.errornoapp'] = 'Você não possui um aplicativo instalado para executar esta ação.';
$string['core.fileuploader.errorreadingfile'] = 'Erro ao ler arquivo.';
$string['core.fileuploader.errorwhileuploading'] = 'Houve um erro durante o envio do arquivo.';
$string['core.fileuploader.file'] = 'Arquivo';
$string['core.fileuploader.fileuploaded'] = 'O arquivo foi enviado com sucesso.';
$string['core.fileuploader.maxbytesfile'] = 'O arquivo {{$a.file}} é muito grande. O tamanho máximo que você pode enviar é {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'A permissão para acessar o microfone foi negada.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'O acesso ao microfone está restrito.';
$string['core.fileuploader.pauserecording'] = 'Pausar gravação';
$string['core.fileuploader.photoalbums'] = 'Álbuns de fotos';
$string['core.fileuploader.readingfile'] = 'Lendo arquivo';
$string['core.fileuploader.readingfileperc'] = 'Lendo arquivo: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Retomar a gravação';
$string['core.fileuploader.selectafile'] = 'Selecione um arquivo';
$string['core.fileuploader.startrecordinginstructions'] = 'Toque para iniciar a gravação';
$string['core.fileuploader.uploadafile'] = 'Enviar um arquivo';
$string['core.fileuploader.uploading'] = 'Enviando';
$string['core.fileuploader.uploadingperc'] = 'Enviando: {{$a}}%';
$string['core.fileuploader.video'] = 'Vídeo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Seguir para {{$a}}';
$string['core.h5p.errorgetemail'] = 'Erro ao obter o email do usuário. Por favor, verifique sua conexão e tente novamente.';
$string['core.h5p.offlinedisabled'] = 'O site não permite baixar pacotes H5P.';
$string['core.h5p.play'] = 'Reproduzir H5P';
$string['core.hasdatatosync'] = 'Esse {{$a}} tem informação offline que precisar ser sincronizada.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Este conteúdo não está funcionando?';
$string['core.image'] = 'Imagem';
$string['core.imageviewer'] = 'Visualizador de imagem';
$string['core.ioscookieshelp'] = 'O conteúdo incorporado pode exigir que os cookies funcionem. Por favor, vá para as configurações do aplicativo iOS, ative \'Permitir rastreamento entre sites\' e tente novamente.';
$string['core.lastdownloaded'] = 'Último baixado';
$string['core.lastsync'] = 'Última sincronização';
$string['core.loadmore'] = 'Ler mais';
$string['core.login.authenticating'] = 'Autenticando';
$string['core.login.changepasswordbutton'] = 'Alterar a senha';
$string['core.login.changepasswordhelp'] = 'Se você tiver problemas para alterar sua senha, tente novamente mais tarde ou entre em contato com sua escola ou instituição de ensino.';
$string['core.login.changepasswordinstructions'] = 'Você não pode alterar sua senha no aplicativo. Por favor, clique no botão seguinte para abrir o site em um navegador da web para alterar sua senha. Tenha em mente que você precisa fechar o navegador após alterar a senha, pois você não será redirecionado para o aplicativo.';
$string['core.login.changepasswordlogoutinstructions'] = 'Se preferir mudar de site ou sair, clique no botão seguinte:';
$string['core.login.changepasswordreconnectinstructions'] = 'Se você não alterou sua senha corretamente, você será informado para fazer novamente.';
$string['core.login.changepasswordsupportsubject'] = 'Preciso de ajuda para alterar minha senha';
$string['core.login.confirmdeletesite'] = 'Tem certeza de que deseja excluir a conta em {{sitename}}?';
$string['core.login.connect'] = 'Conectar!';
$string['core.login.connecttomoodle'] = 'Conectar ao Moodle';
$string['core.login.connecttomoodleapp'] = 'Você está tentando se conectar a um site Moodle regular. Por favor, baixe o aplicativo oficial Moodle para acessar este site.';
$string['core.login.connecttoworkplaceapp'] = 'Você está tentando se conectar a um site Moodle Workplace. Por favor, baixe o aplicativo Moodle Workplace para acessar este site.';
$string['core.login.contactyouradministrator'] = 'Contate o administrador do seu site para obter mais ajuda.';
$string['core.login.contactyouradministratorissue'] = 'Por favor, peça ao administrador do seu site para verificar o seguinte problema: {{$a}}';
$string['core.login.credentialsdescription'] = 'Por favor, forneça seu nome de usuário e senha para fazer login.';
$string['core.login.credentialshelp'] = 'Se você tiver problemas para fazer login, tente novamente mais tarde ou entre em contato com sua escola ou instituição de ensino.';
$string['core.login.credentialssupportsubject'] = 'Preciso de ajuda para fazer login';
$string['core.login.emailconfirmsentnoemail'] = '<p>Um e-mail deveria ter sido enviado para o seu endereço.</p><p>Ele contém instruções simples para completar seu registro.</p>';
$string['core.login.emailnotmatch'] = 'Os emails não correspondem';
$string['core.login.erroraccesscontrolalloworigin'] = 'A chamada de origem cruzada que você está tentando realizar foi rejeitada. Por favor, verifique https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Ocorreu um erro ao excluir esta conta. Por favor, tente novamente.';
$string['core.login.errorexampleurl'] = 'A URL https://campus.example.edu é apenas uma URL de exemplo, não é um site real. <strong>Por favor, use o URL do site da sua escola ou organização.</strong>';
$string['core.login.errorqrnoscheme'] = 'Esta URL não é uma URL de login válida.';
$string['core.login.errorupdatesite'] = 'Ocorreu um erro ao atualizar o token do site.';
$string['core.login.exceededloginattempts'] = 'Precisa de ajuda para fazer login? Tente {{recoverPassword}} ou entre em contato com o suporte do seu site.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'recuperando sua senha';
$string['core.login.exceededloginattemptssupportsubject'] = 'Não consigo fazer login';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Precisa de ajuda para fazer login? Tente entrar em contato com o suporte do seu site.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Precisa de ajuda para fazer login? Tente {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Parece que você está tendo problemas para acessar sua conta. Você pode entrar em contato com sua escola ou instituição de ensino ou tentar novamente mais tarde.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Não consigo redefinir minha senha';
$string['core.login.faqcannotconnectanswer'] = 'Por favor, entre em contato com o administrador do seu site.';
$string['core.login.faqcannotconnectquestion'] = 'Digitei o endereço do meu site corretamente, mas ainda não consigo me conectar.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Se você tentou pesquisar por endereço URL e ainda não conseguiu encontrar seu site Moodle, entre em contato com o suporte do Moodle em sua escola ou instituição de ensino.';
$string['core.login.faqcannotfindmysitequestion'] = 'Não consigo encontrar meu site pelo endereço de URL.';
$string['core.login.faqcantloginanswer'] = '<p>Depois de se conectar ao seu site Moodle, você poderá fazer login com seu nome de usuário e senha usuais.</p><br><p>Se você esqueceu seu nome de usuário ou senha, selecione a opção <strong>Esqueceu a senha?</strong>. Se ainda tiver problemas para fazer login ou não conseguir ver nenhuma opção para recuperar seu nome de usuário ou senha, entre em contato com o suporte do Moodle em sua escola ou organização de aprendizado.</p>';
$string['core.login.faqcantloginquestion'] = 'Não consigo fazer login.';
$string['core.login.faqmore'] = 'Confira <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">nosso FAQ</a> para mais respostas.';
$string['core.login.faqsetupsiteanswer'] = 'Visite {{$link}} para conferir as diferentes opções que você tem para criar seu próprio site Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Começar.';
$string['core.login.faqsetupsitequestion'] = 'Quero configurar meu próprio site Moodle.';
$string['core.login.faqtestappanswer'] = 'Para testar o aplicativo em um site de demonstração do Moodle, digite "professor" ou "aluno" no campo <strong>Seu site</strong> e toque em <strong>Conectar ao seu site</strong>.';
$string['core.login.faqtestappquestion'] = 'Posso testar o aplicativo em um site de demonstração?';
$string['core.login.faqwhatisurlanswer'] = '<p>Cada organização tem seu próprio endereço ou URL exclusiva para seu site Moodle. Para encontrar o endereço:</p><ol><li>Abra um navegador da Web e vá para a página de login do site Moodle.</li><li>Na parte superior da página, na barra de endereço, você verá o URL do seu site Moodle, por exemplo "campus.example.edu".<br>{{$image}}</li><li>Copie o endereço (não copie o /login e o que vem depois), cole-o no aplicativo Moodle e clique em "Conectar ao seu site"</li><li>Agora você pode fazer login no seu site usando seu nome de usuário e senha.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = 'Como posso encontrar meu site?';
$string['core.login.faqwhereisqrcode'] = 'Onde posso encontrar o QR code?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Se sua escola ou instituição de ensino habilitou este recurso, você encontrará um código QR na parte inferior da página de perfil do usuário no site.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Encontre seu site';
$string['core.login.helpmelogin'] = '<p>Existem milhares de sites Moodle em todo o mundo. Este aplicativo pode se conectar somente a sites Moodle que habilitaram o acesso para dispositivos móveis.</p><p>Se você não conseguir se conectar ao seu site Moodle, entre em contato com o administrador do site e peça a ele para ler <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Para testar o aplicativo em um site de demonstração do Moodle digite <i>teacher</i> ou <i>student</i> no campo<i>Endereço do site</i> e clique no <b>botão Conectar</b>.</p>';
$string['core.login.invalidaccount'] = 'Verifique seus detalhes de login e tente novamente.';
$string['core.login.invalidmoodleversion'] = 'A versão deste site Moodle é muito antiga. O aplicativo Moodle funciona com sites que usam {{$a}} ou mais recente.';
$string['core.login.invalidsite'] = 'URL do site inválido.';
$string['core.login.invalidtime'] = 'Tempo inválido';
$string['core.login.invalidvaluemax'] = 'O valor máximo é {{$a}}';
$string['core.login.invalidvaluemin'] = 'O valor mínimo é {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Você precisa autenticar novamente. Você precisa fazer login no site em uma janela do navegador.';
$string['core.login.loginbutton'] = 'Entrar';
$string['core.login.logininsiterequired'] = 'Você precisa fazer login no site em uma janela do navegador.';
$string['core.login.mobileservicesnotenabled'] = 'Os serviços móveis não estão habilitados no site.';
$string['core.login.notloggedin'] = 'Você precisa estar logado.';
$string['core.login.onboardingcreatemanagecourses'] = 'Criar e gerenciar seus cursos';
$string['core.login.onboardingenrolmanagestudents'] = 'Inscrever e gerenciar seus estudantes';
$string['core.login.onboardinggetstarted'] = 'Comece com o Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Eu já tenho um site Moodle';
$string['core.login.onboardingimalearner'] = 'Sou estudante';
$string['core.login.onboardingimaneducator'] = 'Sou professor';
$string['core.login.onboardingineedasite'] = 'Preciso de um site Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Forneça feedback em tempo hábil';
$string['core.login.onboardingtoconnect'] = 'Para se conectar ao aplicativo Moodle, você precisará de um site Moodle';
$string['core.login.onboardingwelcome'] = 'Bem-vindo ao aplicativo Moodle!';
$string['core.login.or'] = 'Ou';
$string['core.login.passwordrequired'] = 'Senha necessária';
$string['core.login.policyacceptmandatory'] = 'Eu entendo e concordo com as políticas obrigatórias do site';
$string['core.login.recaptchachallengeimage'] = 'Imagem de desafio reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Verificação expirada. Responda a pergunta de segurança novamente.';
$string['core.login.recaptchaincorrect'] = 'A resposta da pergunta de segurança está incorreta.';
$string['core.login.reconnect'] = 'Reconectar';
$string['core.login.reconnecthelp'] = 'Se você tiver problemas para se reconectar, tente novamente mais tarde ou entre em contato com sua escola ou instituição de ensino.';
$string['core.login.reconnectssodescription'] = 'Sua sessão expirou. Faça login novamente em uma janela do navegador para continuar.';
$string['core.login.reconnectsupportsubject'] = 'Preciso de ajuda para reconectar';
$string['core.login.reconnecttosite'] = 'Reconectar ao site';
$string['core.login.removeaccount'] = 'Remover conta';
$string['core.login.searchby'] = 'Buscar por:';
$string['core.login.selectsite'] = 'Por favor, selecione seu site:';
$string['core.login.signupplugindisabled'] = '{{$a}} não está habilitado.';
$string['core.login.signuprequiredfieldnotsupported'] = 'O formulário de inscrição contém um campo personalizado obrigatório que não é compatível com o aplicativo. Crie sua conta usando um navegador da web.';
$string['core.login.siteaddress'] = 'Endereço do site';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Existem {{count}} notificações não lidas.';
$string['core.login.sitehasredirect'] = 'Seu site contém pelo menos um redirecionamento HTTP. O aplicativo não pode seguir redirecionamentos, este pode ser o problema que está impedindo o aplicativo de se conectar ao seu site.';
$string['core.login.siteinmaintenance'] = 'Seu site está em modo de manutenção';
$string['core.login.sitenotallowed'] = 'Esse site não está mais disponível.';
$string['core.login.sitepolicynotagreederror'] = 'Não concordou com a política do site.';
$string['core.login.siteurl'] = 'URL do site';
$string['core.login.siteurlrequired'] = 'URL do site obrigatório, ou seja, <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'Ainda não consegue se conectar?';
$string['core.login.toggleremove'] = 'Editar lista de contas';
$string['core.login.usernamerequired'] = 'Nome de usuário obrigatório';
$string['core.login.visitchangepassword'] = 'Você deseja visitar o site para alterar a senha?';
$string['core.login.webservicesnotenabled'] = 'Web Services não estão habilitados no site.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Você ainda pode se conectar ao site digitando seu nome de usuário e senha.';
$string['core.login.yourenteredsite'] = 'Conecte-se ao seu site';
$string['core.lostconnection'] = 'Sua sessão expirou. Faça login novamente para continuar.';
$string['core.mainmenu.switchaccount'] = 'Mudar de conta';
$string['core.mainmenu.usermenutourdescription'] = 'Este é o lugar para verificar suas notas, alterar suas preferências ou trocar de conta.';
$string['core.mainmenu.usermenutourtitle'] = 'Explorar sua área pessoal';
$string['core.needhelp'] = 'Precisa de ajuda?';
$string['core.networkerroriframemsg'] = 'Este conteúdo não está disponível offline. Por favor, conecte-se à internet e tente novamente.';
$string['core.networkerrormsg'] = 'Houve um problema ao conectar-se ao site. Por favor, verifique sua conexão e tente novamente.';
$string['core.nooptionavailable'] = 'Nenhuma opção disponível';
$string['core.nopasswordchangeforced'] = 'Você não pode prosseguir sem alterar sua senha.';
$string['core.nopermissionerror'] = 'Desculpe, mas você não tem permissões para fazer isso no momento';
$string['core.notapplicable'] = 'n/d';
$string['core.notdownloadable'] = 'Não pode ser baixado';
$string['core.notsent'] = 'Não enviado';
$string['core.nummore'] = '{{$a}} mais';
$string['core.openfile'] = 'Abrir arquivo';
$string['core.openfullimage'] = 'Clique aqui para exibir a imagem em tamanho completo';
$string['core.openinbrowser'] = 'Abrir no navegador';
$string['core.openinbrowserdescription'] = 'Você será redirecionado para um navegador da web';
$string['core.openmodinbrowser'] = 'Abrir {{$a}} no navegador';
$string['core.opensecurityquestion'] = 'Abrir pergunta de segurança';
$string['core.opensettings'] = 'Abrir configurações';
$string['core.openwith'] = 'Abrir com...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Reproduzir';
$string['core.pulltorefresh'] = 'Puxe para atualizar';
$string['core.qrscanner'] = 'Scanner QR';
$string['core.question.cannotdeterminestatus'] = 'Não é possível determinar o status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Seu site ainda não suporta anexar arquivos às respostas.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Seu site ainda não suporta editar arquivos incorporados.';
$string['core.question.errorquestionnotsupported'] = 'Esse tipo de questão não é suportada pelo aplicativo: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Toque para selecionar e depois toque para soltar.';
$string['core.question.questionmessage'] = 'Questão {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Você será redirecionado para o site.';
$string['core.reminders.atthetime'] = 'Na hora do evento';
$string['core.reminders.custom'] = 'Personalizar...';
$string['core.reminders.customreminder'] = 'Lembrete personalizado';
$string['core.reminders.delete'] = 'Excluir lembrete';
$string['core.reminders.reminderset'] = 'Lembrete definido para {{$a}}';
$string['core.reminders.reminderunset'] = 'Lembrete excluído';
$string['core.reminders.setareminder'] = 'Definir um lembrete';
$string['core.reminders.setareminderfor'] = 'Definir um lembrete para "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Definir lembrete';
$string['core.reminders.timebefore'] = '{{value}} {{units}} antes';
$string['core.reminders.value'] = 'Valor';
$string['core.removefiles'] = 'Remover arquivos {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Pode haver filtros aplicados a esta exibição. Para editar filtros ou alterar a ordenação, <a href="{{$a}}">abra este relatório no seu navegador.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Ocultar colunas';
$string['core.reportbuilder.showcolumns'] = 'Mostrar colunas';
$string['core.requireduserdatamissing'] = 'Este usuário não possui alguns dados de perfil necessários. Insira os dados em seu site e tente novamente.<br>{{$a}}';
$string['core.resume'] = 'Retomar';
$string['core.retry'] = 'Tentar novamente';
$string['core.scanqr'] = 'Escanear o QR code';
$string['core.scrollbackward'] = 'Rolar para trás';
$string['core.scrollforward'] = 'Rolar para frente';
$string['core.search.allcategories'] = 'Todas as categorias';
$string['core.search.empty'] = 'O que você está procurando?';
$string['core.search.filtercategories'] = 'Filtrar resultados por';
$string['core.search.filtercourses'] = 'Pesquisar em';
$string['core.search.noresults'] = 'Nenhum resultado para "{{$a}}"';
$string['core.search.noresultshelp'] = 'Verifique erros de digitação ou tente usar palavras-chave diferentes';
$string['core.search.resultby'] = 'Por {{$a}}';
$string['core.searching'] = 'Buscando';
$string['core.serverconnection'] = 'Erro ao conectar ao servidor: {{details}}';
$string['core.settings.about'] = 'Sobre';
$string['core.settings.appsettings'] = 'Configurações do aplicativo';
$string['core.settings.appversion'] = 'Versão do aplicativo';
$string['core.settings.cannotsyncloggedout'] = 'Este site não pode ser sincronizado porque você saiu. Por favor, tente novamente quando estiver logado no site novamente.';
$string['core.settings.cannotsyncoffline'] = 'A sincronização do site falhou porque seu dispositivo não está conectado à Internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Seu dispositivo não está conectado ao Wi-Fi. Conecte-se a uma rede Wi-Fi ou desative a Economia de dados nas configurações do aplicativo.';
$string['core.settings.changelanguage'] = 'Mudar para {{$a}}';
$string['core.settings.changelanguagealert'] = 'Alterar o idioma reiniciará o aplicativo.';
$string['core.settings.colorscheme'] = 'Esquema de Cores';
$string['core.settings.colorscheme-dark'] = 'Escuro';
$string['core.settings.colorscheme-light'] = 'Claro';
$string['core.settings.colorscheme-system'] = 'Padrão do sistema';
$string['core.settings.colorscheme-system-notice'] = 'O modo padrão do sistema dependerá do suporte do seu dispositivo.';
$string['core.settings.compilationinfo'] = 'Informações de Compilação';
$string['core.settings.connecttosync'] = 'Seu dispositivo está off-line. Conecte-se à internet para sincronizar os sites.';
$string['core.settings.connectwifitosync'] = 'Conecte-se a uma rede Wi-Fi ou desative a Economia de dados para sincronizar os sites.';
$string['core.settings.copyinfo'] = 'Copiar informações do dispositivo para a área de transferência';
$string['core.settings.cordovadevicemodel'] = 'Modelo do dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versão do sistema operacional do dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Plataforma do dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID do dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versão do Cordova';
$string['core.settings.debugdisplaydescription'] = 'Se habilitado, modais de erro exibirão mais dados sobre o erro, se possível.';
$string['core.settings.developeroptions'] = 'Opções de desenvolvedor';
$string['core.settings.deviceinfo'] = 'Informações do Dispositivo';
$string['core.settings.deviceos'] = 'Sistema Operacional do Dispositivo';
$string['core.settings.displayformat'] = 'Formato de exibição';
$string['core.settings.enableanalytics'] = 'Habilitar análises';
$string['core.settings.enableanalyticsdescription'] = 'Se habilitado, o aplicativo coletará dados anônimos de uso.';
$string['core.settings.enabledownloadsection'] = 'Habilitar seções de download';
$string['core.settings.enablefirebaseanalytics'] = 'Habilitar análises do Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Se habilitado, o aplicativo coletará dados anônimos de uso.';
$string['core.settings.enablerichtexteditor'] = 'Habilitar editor de texto';
$string['core.settings.enablerichtexteditordescription'] = 'Se habilitado, um editor de texto estará disponível ao inserir conteúdo.';
$string['core.settings.enablesyncwifi'] = 'Permitir sincronização apenas quando estiver em Wi-Fi';
$string['core.settings.encryptedpushsupported'] = 'Notificações push criptografadas suportadas';
$string['core.settings.entriesincache'] = '{{$a}} registros em cache';
$string['core.settings.errorsyncsite'] = 'Erro ao sincronizar dados do site. Por favor, verifique sua conexão com a Internet e tente novamente.';
$string['core.settings.estimatedfreespace'] = 'Espaço livre estimado';
$string['core.settings.filesystemroot'] = 'Raiz do sistema de arquivos';
$string['core.settings.fontsize'] = 'Tamanho do texto';
$string['core.settings.forcedsetting'] = 'Esta configuração foi forçada pela configuração do seu site.';
$string['core.settings.helpusimprove'] = 'Ajude-nos a melhorar este aplicativo';
$string['core.settings.ioscookies'] = 'Rastreamento entre Sites';
$string['core.settings.ioscookiesdescription'] = 'O conteúdo incorporado do site pode exigir que os cookies entre sites funcionem. Para ativá-lo, acesse as configurações do aplicativo iOS e ative \'Permitir rastreamento entre sites\'.';
$string['core.settings.legaldisclaimer'] = 'Aviso Legal';
$string['core.settings.localnotifavailable'] = 'Notificações locais disponíveis';
$string['core.settings.locationhref'] = 'URL da visualização da web';
$string['core.settings.logintosync'] = 'Faça login para sincronizar';
$string['core.settings.navigatorlanguage'] = 'Idioma do navegador';
$string['core.settings.navigatoruseragent'] = 'Agente do usuário do navegador';
$string['core.settings.networkstatus'] = 'Status da conexão com a Internet';
$string['core.settings.opensourcelicenses'] = 'Licenças de Código Aberto';
$string['core.settings.privacypolicy'] = 'Política de privacidade';
$string['core.settings.publisher'] = 'Editor';
$string['core.settings.pushid'] = 'ID de notificações push';
$string['core.settings.reportinbackground'] = 'Relatar erros automaticamente';
$string['core.settings.screen'] = 'Informações da tela';
$string['core.settings.showdownloadoptions'] = 'Mostrar opções para baixar';
$string['core.settings.siteinfo'] = 'Informações do site';
$string['core.settings.sitesyncfailed'] = 'Falha na sincronização do site';
$string['core.settings.spaceusage'] = 'Uso de espaço';
$string['core.settings.syncdatasaver'] = 'Economia de dados: Sincronize apenas quando estiver em Wi-Fi';
$string['core.settings.synchronization'] = 'Sincronização';
$string['core.settings.synchronizenow'] = 'Sincronizar agora';
$string['core.settings.synchronizenowhelp'] = 'A sincronização do site enviará alterações pendentes, todas as atividades offline armazenadas no dispositivo e sincronizará alguns dados, como mensagens e notificações.';
$string['core.settings.syncsettings'] = 'Configurações de sincronização';
$string['core.settings.wificonnection'] = 'Conexão Wi-Fi';
$string['core.settings.youradev'] = 'Você agora é um desenvolvedor';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Escolha uma conta para armazenar o arquivo.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Já existe um arquivo com esse nome. Você deseja substituir o arquivo existente ou renomear ele para "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Não há sites armazenados. Por favor, adicione um site antes de compartilhar um arquivo com o aplicativo.';
$string['core.sharedfiles.nosharedfiles'] = 'Não existem arquivos compartilhados guardados nesse site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Você não tem arquivos para enviar aqui. Se você quer enviar um arquivo de um outro aplicativo, localiza aquele arquivo e clique no botão \'Abra em\'.';
$string['core.sharedfiles.rename'] = 'Renomear';
$string['core.sharedfiles.replace'] = 'Substituir';
$string['core.sharedfiles.sharedfiles'] = 'Arquivos compartilhados';
$string['core.sharedfiles.successstorefile'] = 'Arquivo armazenado com sucesso. Agora você pode selecionar esse arquivo para enviar para seus "arquivos privados" ou anexar em atividades.';
$string['core.sitenotfound'] = 'Site não encontrado';
$string['core.sitenotfoundhelp'] = 'Não encontramos o site que você digitou. Verifique se há erros de digitação ou tente novamente mais tarde. Se você continuar vendo esta mensagem, entre em contato com sua escola ou instituição de ensino.';
$string['core.siteunavailablehelp'] = 'O site "{{site}}" não está disponível no momento. Tente novamente mais tarde ou entre em contato com sua escola ou instituição de ensino.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Desculpe...';
$string['core.start'] = 'Começar';
$string['core.startingtime'] = 'Hora de início: {{$a}}';
$string['core.storingfiles'] = 'Armazenando arquivos';
$string['core.swipenavigationtourdescription'] = 'Deslize para a esquerda e para a direita para navegar.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Esta área não é compatível com o aplicativo.';
$string['core.tag.tagareabadgedescription'] = 'Existem {{count}} itens.';
$string['core.tag.warningareasnotsupported'] = 'Algumas áreas não são exibidas porque não são compatíveis com o aplicativo.';
$string['core.thereisdatatosync'] = 'Existem {{$a}} offline para sincronizar.';
$string['core.toggledelete'] = 'Alternar botões de exclusão';
$string['core.tryagain'] = 'Tentar novamente';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ops!';
$string['core.unexpectederror'] = 'Erro inesperado. Por favor, feche e abra novamente o aplicativo para tentar novamente';
$string['core.unicodenotsupported'] = 'Alguns emojis não são suportados neste site. Esses caracteres serão removidos quando a mensagem for enviada.';
$string['core.unicodenotsupportedcleanerror'] = 'Texto vazio foi encontrado ao limpar caracteres Unicode.';
$string['core.unknown'] = 'Desconhecido';
$string['core.unzipping'] = 'Descompactando';
$string['core.updaterequired'] = 'Atualização do aplicativo necessária';
$string['core.updaterequireddesc'] = 'Por favor, atualize seu aplicativo para a versão {{$a}}';
$string['core.user.completeprofile'] = 'Perfil Completo';
$string['core.user.completeprofilehelp'] = 'Se você tiver problemas para preencher seu perfil, tente novamente mais tarde ou entre em contato com sua escola ou instituição de ensino.';
$string['core.user.completeprofilenotice'] = 'Antes de continuar, preencha os campos obrigatórios em seu perfil de usuário.';
$string['core.user.completeprofilereconnectinstructions'] = 'Se você não completou seu perfil corretamente, você será informado a fazer isso novamente.';
$string['core.user.completeprofilesupportsubject'] = 'Preciso de ajuda para completar meu perfil';
$string['core.user.completeyourprofile'] = 'Complete seu perfil';
$string['core.user.contact'] = 'Contato';
$string['core.user.detailsnotavailable'] = 'Os detalhes deste usuário não estão disponíveis para você.';
$string['core.user.errorloaduser'] = 'Erro ao carregar usuário.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.user.support'] = 'Entre em contato com o suporte do site';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Usuário com ID {{id}}';
$string['core.usernologin'] = 'A autenticação foi revogada para esta conta';
$string['core.viewcode'] = 'Ver código';
$string['core.vieweditor'] = 'Ver editor';
$string['core.viewembeddedcontent'] = 'Ver conteúdo incorporado';
$string['core.wanttochangesite'] = 'Quer mudar de site ou sair?';
$string['core.warningofflinedatadeleted'] = 'Dados offline de {{component}} \'{{name}}\' foram excluídos. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Alterações mais recentes nesta atividade foram feitas em um dispositivo diferente.';
$string['core.warnopeninbrowser'] = '<p>Você está prestes a sair do aplicativo para abrir a seguinte URL no navegador do seu dispositivo. Deseja continuar?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '"Administradores do Site" são as pessoas que gerenciam o Moodle na sua escola/universidade/empresa ou instituição de ensino. Se você não sabe como entrar em contato com os administradores, entre em contato com seus professores/formadores.';
$string['core.whyisthishappening'] = 'Por que isso está acontecendo?';
$string['core.wsfunctionnotavailable'] = 'A função do serviço web não está disponível.';
$string['core.youreoffline'] = 'Seu dispositivo está offline';
$string['core.youreonline'] = 'Seu dispositivo está online novamente';
$string['core.zoomin'] = 'Mais zoom';
$string['core.zoomout'] = 'Reduzir o zoom';
$string['freemium.autologoutclosingtheapp'] = 'Imediatamente após sair do aplicativo';
$string['freemium.autologoutcustomtime'] = 'Tempo personalizado depois de sair do aplicativo';
$string['freemium.autologoutdefault'] = 'Padrão';
$string['freemium.autologouttitle'] = 'Sair automaticamente deste dispositivo';
$string['freemium.biometriclogin'] = 'Login biométrico';
$string['freemium.biometriclogindescription'] = 'Coloque o dedo no leitor de impressão digital.';
$string['freemium.biometricloginenablefaceid'] = 'Habilitar FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Habilitar Impressão Digital';
$string['freemium.biometricloginenabletouchid'] = 'Habilitar Touch ID';
$string['freemium.biometricloginloginwithfaceid'] = 'Entrar com FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Entrar com impressão digital';
$string['freemium.biometricloginloginwithtouchid'] = 'Entrar com TouchID';
$string['freemium.biometricloginskip'] = 'Pular por enquanto';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} ativado.';
$string['freemium.biometricloginturnoff'] = 'Você pode habilitar e desabilitar esse recurso a qualquer momento nas configurações.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Impressão digital';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Use o login biométrico com sua impressão digital ou seu rosto.';
$string['freemium.change'] = 'Alterar';
$string['freemium.coursesbatchdownloaddisabled'] = 'O download de cursos em lote não está habilitado para este site.';
$string['freemium.coursesdownloadlimitreached'] = 'O limite para baixar os cursos foi atingido! Você só pode ter {{limit}} cursos baixados, entre em contato com seu administrador para aumentar esse limite ou remova alguns cursos baixados de seu dispositivo.';
$string['freemium.downloadmainapplicationrequired'] = 'Você só pode se conectar a este site usando o aplicativo próprio.';
$string['freemium.downloadmainapplicationsuggestion'] = 'O site ao qual você está tentando se conectar tem um aplicativo próprio que você pode experimentar.';
$string['freemium.feature_autologout'] = 'Sair automaticamente';
$string['freemium.feature_biometriclogin'] = 'Acesso biométrico';
$string['freemium.feature_coursesdownload'] = 'Cursos baixados';
$string['freemium.feature_multimediapushnotifications'] = 'Notificações push de multimídia';
$string['freemium.feature_pushnotificationsdevices'] = 'Dispositivos de notificação por push';
$string['freemium.feature_qrlogin'] = 'Autenticar usando um código QR';
$string['freemium.feature_remotethemes'] = 'Temas Remotos';
$string['freemium.feature_sitelogo'] = 'Logo do site';
$string['freemium.notallowed'] = 'Não permitido';
$string['freemium.nottoday'] = 'Hoje não';
$string['freemium.qrlogindisabled'] = 'A autenticação no aplicativo usando um código QR não está habilitada para o site:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'O código QR expirou. Atualize a página com o código QR e digitalize-o novamente.';
$string['freemium.qrloginipmismatch'] = 'O dispositivo que você está usando para se conectar não parece estar na mesma rede que o dispositivo que exibe o código QR. Certifique-se de que ambos os dispositivos estejam conectados à mesma rede (por exemplo, mesma rede Wi-Fi).<br><br>Se o erro persistir, entre em contato com o administrador do site.';
$string['freemium.ratetheapp'] = 'Você está gostando do app?';
$string['freemium.ratetheapp_feedbackko'] = 'Diga-nos o que deu errado';
$string['freemium.ratetheapp_feedbackmessage'] = 'Seu feedback será anônimo';
$string['freemium.ratetheapp_feedbackok'] = 'Envie o feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Escreva algo aqui';
$string['freemium.ratetheapp_feedbacksent'] = 'Obrigado! Seu feedback foi enviado com sucesso';
$string['freemium.ratetheapp_sendtostore'] = 'Você poderia avaliar o nosso app? Isso vai nos ajudar a melhorá-lo.';
$string['freemium.remindmelater'] = 'Lembrar-me depois';
$string['freemium.settingsoptions_autologout'] = 'Logout automático';
$string['freemium.settingsoptionsfacial'] = 'Ativar login facial';
$string['freemium.settingsoptionsfingerprint'] = 'Ativar login de impressão digital';
$string['freemium.subscription'] = 'Assinatura do site';
$string['freemium.subscriptiondetails'] = 'Detalhes de inscrição';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} caracteres de idioma personalizados estão sendo ignorados';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} caracteres de menu personalizados estão sendo ignorados';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} recursos desativados configurados ainda estão ativados';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Seu tema personalizado não está sendo aplicado';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'O logotipo do seu site não está sendo aplicado';
$string['freemium.subscriptionfeature_limited'] = 'Limitado para {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Ilimitado';
$string['freemium.subscriptionplan'] = 'Plano de inscrição';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'expirado';
$string['freemium.subscriptionplan_free'] = 'Grátis';
$string['freemium.subscriptionplan_premium'] = 'Premium';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Atualize seu plano';
$string['freemium.subscriptionplan_validuntil'] = 'válido até {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Os planos de assinatura indicam quais restrições se aplicam a este site.';
$string['freemium.subscriptionplanlearnmore'] = 'Saiba mais';
$string['freemium.upsell_renewexpired'] = 'Sua assinatura expirou';
$string['freemium.upsell_renewexpiring'] = 'Sua assinatura expirará em {{ dias }} dias';
$string['freemium.upsell_renewtitle'] = 'Renovar sua assinatura';
$string['freemium.upsell_upgradefreeaccept'] = 'Atualizar';
$string['freemium.upsell_upgradefreemessage'] = 'Você está atualmente no plano gratuito, atualize para desbloquear mais recursos.';
$string['freemium.upsell_upgradefreepostpone'] = 'Mais tarde';
$string['freemium.upsell_upgradefreetitle'] = 'Atualize seu plano';
$string['pluginname'] = 'Strings de idioma do aplicativo Moodle';
$string['privacy_metadata'] = 'Este plugin não armazena nenhum dado do usuário.';
$string['workplace.teams.isoverdue'] = 'Tem itens vencidos ou expirados';
