<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'uk', version '4.3'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Колір фону';
$string['background_color_desc'] = 'Колір фону для верхньої частини та футера!';
$string['background_color_random'] = 'Випадкова тема {$a}';
$string['background_text_color'] = 'Колір тексту';
$string['background_text_color_desc'] = 'Колір тексту для верхньої частини та футера!';
$string['choosereadme'] = 'Boost Magnific — це тема, створена з любов\'ю, щоб привнести яскраві кольори в Moodle.';
$string['contact_address'] = 'Адреса';
$string['contact_email'] = 'Електронна пошта';
$string['contact_phone'] = 'Номер телефону';
$string['content_type_default'] = 'За замовчуванням Moodle';
$string['content_type_empty'] = '(Без контенту)';
$string['content_type_footer'] = 'Тип контенту для футера';
$string['content_type_footer_desc'] = 'Виберіть тип контенту, який ви хочете відображати у футері.';
$string['content_type_home'] = 'Тип контенту для домашньої сторінки';
$string['content_type_home_desc'] = 'Виберіть тип контенту, який ви хочете відображати на домашній сторінці.';
$string['content_type_html'] = 'Сторінка для створення за допомогою редактора';
$string['continuar'] = 'Продовжити навчання';
$string['countlesson'] = '{$a} урок';
$string['countlessons'] = '{$a} уроки';
$string['course_access'] = 'Доступ до курсу';
$string['course_moore'] = 'Більше деталей';
$string['customcss'] = 'Користувацький CSS';
$string['customcss_desc'] = 'Будь-які правила CSS, які ви додасте до цієї текстової області, будуть відображатися на всіх сторінках, що дозволяє легко налаштувати цю тему.';
$string['custommenuitems'] = 'Користувацькі елементи верхнього меню';
$string['custommenuitems_desc'] = 'Ви можете створити власне меню поруч з верхніми меню. Головне меню повинно починатися з краю, а підменю повинні бути позначені дефісом (-). Кількість дефісів визначає глибину елемента. Таким чином, елементи з одним дефісом з\'являються в підменю під попереднім елементом верхнього рівня, а елементи з двома дефісами з\'являються в підменю під попереднім підменю.
Вміст кожного елемента меню має складатися з трьох елементів (<strong>мітка</strong> | <strong>url</strong> | <strong>підказка</strong> | <strong>мова</strong>), кожен розділений символом "|".
<ul>
<li><strong>мітка</strong>: Це текст, який буде відображатися в елементі меню. Для кожного елемента меню ви повинні вказати мітку.</li>
<li><strong>url</strong>: Це URL, на який користувач буде перенаправлений при натисканні на елемент меню. Це необов\'язково; якщо не вказано, елемент не буде пов\'язаний ні з чим.<br>
Інші атрибути, такі як "target", можуть бути додані в кінці URL.</li>
<li><strong>підказка</strong>: Якщо ви надасте URL, ви також можете вибрати надавати підказку для створеного посилання з URL. Це необов\'язково, і якщо не визначено, мітка використовується як підказка для елемента меню.</li>
<li><strong>мова</strong>: Ви можете додати код мови (або список кодів через кому) як четвертий елемент рядка. Рядок буде відображатися тільки в разі вибору користувачем зазначеної мови(й).</li>
</ul>
Нижче наведено приклад того, як ви створюєте власне меню:
<blockquote><pre>
Курси
-Всі курси | /course/
-Мої курси
--Приклад курсу
---Приклад курсу 7 | /course/view.php?id=7
---Приклад курсу 9 | /course/view.php?id=9
--Тестовий курс
---Тестовий курс 2 | /course/view.php?id=2
---Тестовий курс 5 | /course/view.php?id=5
Google
-Гугл будь-якою мовою | https://google.com/" target="_blank
-Гугл в Мексиці | https://www.google.com.mx/" target="_blank|Мітка Гугл|en
-Гугл португальською | https://google.com.br/" target="_blank|Мітка Гугл|pt,pt_br,pt_br_kids
Сторінка підтримки | https://support.com/" target="_blank
</pre></blockquote>
Для Moodle з підтримкою кількох мов, значення <strong>мітки</strong> має бути відформатоване як <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Більше інформації про меню</a>';
$string['editor_link_footer'] = 'Редагувати блок футера для мови {$a}';
$string['editor_link_footer_all'] = 'Редагувати блок футера для всіх мов';
$string['editor_link_home'] = 'Редагувати домашню сторінку для мови {$a}';
$string['editor_link_home_all'] = 'Редагувати домашню сторінку для всіх мов';
$string['favicon'] = 'Іконка сайту';
$string['favicon_desc'] = 'Іконка сайту відображається поряд з назвою сторінки у вкладці браузера. Відображається іконка Moodle, якщо не вказано інший.';
$string['fontfamily'] = 'Шрифти тексту на сайті';
$string['fontfamily_desc'] = 'Виберіть шрифт, який ви хочете використовувати для тексту на вашому сайті Moodle.';
$string['fontfamily_menus'] = 'Шрифти меню';
$string['fontfamily_menus_desc'] = 'Виберіть шрифт, який ви хочете використовувати для меню на вашому сайті Moodle.';
$string['fontfamily_sitename'] = 'Шрифт для назви сайту';
$string['fontfamily_sitename_desc'] = 'Шрифт, який буде застосовано до назви сайту, якщо логотип не надано.';
$string['fontfamily_title'] = 'Шрифти заголовків тексту';
$string['fontfamily_title_desc'] = 'Виберіть шрифт, який ви хочете використовувати для заголовків на вашому сайті Moodle.';
$string['fontpreview'] = 'Попередній перегляд списку шрифтів';
$string['footer_contact_title'] = 'Назва блоку контактів';
$string['footer_contact_title_default'] = 'Зв\'язатися з нами';
$string['footer_contact_title_desc'] = 'Введіть назву блоку, який з\'явиться в футері з контактними даними.';
$string['footer_description'] = 'Опис';
$string['footer_description_desc'] = 'Опишіть ваш Moodle, що ви робите, і ця інформація буде показана під логотипом у футері Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Показувати ім\'я професора';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Якщо вибрано, показує імена професорів у списку курсів!';
$string['footer_frontpage_blockcourses_text'] = 'Короткий текст, що пояснює блок "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Додайте текст, що розповідає про "{$a}"!';
$string['footer_links_title'] = 'Заголовок блоку посилань';
$string['footer_links_title_default'] = 'Важливі посилання';
$string['footer_show_copywriter'] = 'Показати \'Зроблено з ❤️\'';
$string['footer_show_copywriter_desc'] = 'Скасуйте, якщо хочете приховати \'Зроблено з ❤️\'';
$string['footer_social_title'] = 'Заголовок блоку соціальних посилань';
$string['footer_social_title_default'] = 'Слідуйте за нами в соціальних мережах';
$string['footer_social_title_desc'] = 'Введіть заголовок блоку, який з\'явиться в футері з даними ваших соціальних мереж.';
$string['footerblink'] = 'Посилання футера';
$string['footerblink_desc'] = 'Ви можете налаштувати посилання футера, які будуть показані темами.<br>Кожен рядок складається з тексту меню або ключа мови, тексту (необов\'язково) і URL посилання, розділених вертикальними рисками. Наприклад:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Контактний блок';
$string['footerblock_copywriter'] = 'Зроблено з ❤️';
$string['footerblock_description'] = 'Блок опису';
$string['footerblock_links'] = 'Блок посилань';
$string['footerblock_social'] = 'Блок соціальних мереж';
$string['free_name'] = 'Безкоштовно';
$string['frontpage_about_description'] = 'Опишіть, чим ви займаєтесь';
$string['frontpage_about_description_desc'] = 'Опишіть у максимум 5 рядках мету вашого Moodle';
$string['frontpage_about_enable'] = 'Увімкнути блок \'Про\'';
$string['frontpage_about_enable_desc'] = 'Якщо вибрано, блок \'Про\' з\'явиться під банером!';
$string['frontpage_about_info'] = 'Коробка даних {$a}';
$string['frontpage_about_logo'] = 'Інший логотип, який буде показано тут';
$string['frontpage_about_logo_desc'] = 'Якщо встановлено, цей логотип буде використовуватися замість верхнього логотипу.<br>Порожній логотип використовує верхній логотип!';
$string['frontpage_about_number'] = 'Кількість даних';
$string['frontpage_about_number_desc'] = 'Введіть кількість зазначеної інформації';
$string['frontpage_about_text'] = 'Назва даних';
$string['frontpage_about_text_1_defalt'] = 'Курси';
$string['frontpage_about_text_2_defalt'] = 'Викладачі';
$string['frontpage_about_text_3_defalt'] = 'Студенти';
$string['frontpage_about_text_4_defalt'] = 'Уроки';
$string['frontpage_about_text_desc'] = 'Введіть назву даних, що будуть показані на головній сторінці';
$string['frontpage_about_title'] = 'Заголовок блоку \'Про\'';
$string['frontpage_about_title_default'] = 'Наша глобальна спільнота';
$string['heart'] = 'Якщо вам подобається ця тема, не забудьте натискати ❤️ на сторінці тем <a href="{$a}" target="_blank">натискаючи тут</a>';
$string['instructor'] = 'Інструктор';
$string['login_backgroundcolor'] = 'Колір фону';
$string['login_backgroundcolor_desc'] = 'Виберіть колір фону для сторінки відновлення пароля';
$string['login_backgroundfoto'] = 'Фонове зображення';
$string['login_backgroundfoto_desc'] = 'Виберіть фонове зображення для сторінки відновлення пароля/створення акаунта. За замовчуванням зображення: {$a}';
$string['login_forgot_description'] = 'Текст збоку на екрані забутого пароля';
$string['login_forgot_description_desc'] = 'Текст, який з\'являється тільки на екрані забутого пароля';
$string['login_login_description'] = 'Текст збоку на екрані входу';
$string['login_login_description_desc'] = 'Текст, який з\'являється тільки на екрані входу';
$string['login_signup_description'] = 'Текст збоку на екрані створення акаунта';
$string['login_signup_description_desc'] = 'Текст, який з\'являється тільки на екрані створення акаунта';
$string['login_theme'] = 'Тема входу';
$string['login_theme_block'] = 'Центральний білий блок з необов\'язковим фоном';
$string['login_theme_desc'] = 'Виберіть тему для області входу';
$string['login_theme_image_login'] = 'Фонове зображення та вхід збоку';
$string['login_theme_imagetext_login'] = 'Фонова картинка, текст на зображенні та вхід з боку';
$string['login_theme_login'] = 'Тільки екран входу, без зображення збоку';
$string['logo_color'] = 'Кольоровий логотип';
$string['logo_color_desc'] = 'Будь ласка, завантажте свій кольоровий ЛОГОТИП, якщо хочете додати його вгорі. Цей логотип буде відображатися під час прокручування сторінки, а меню буде відображатися на білому фоні.';
$string['logo_write'] = 'Логотип верхнього меню під час прокручування';
$string['logo_write_desc'] = 'Будь ласка, завантажте свій логотип, якщо хочете додати його вгорі. Цей логотип буде відображатися, коли прокрутка залишатиметься зверху, а меню буде відображатися на кольоровому фоні.';
$string['matricular'] = 'Записатися';
$string['mycourses_color'] = 'Колір фону блоку';
$string['mycourses_color_desc'] = 'Колір фону для блоку.';
$string['mycourses_icon'] = 'Іконка';
$string['mycourses_icon_desc'] = 'Представницька іконка для блоку. Розмір іконки повинен бути 48x48 пікселів.';
$string['mycourses_info'] = 'Блок {$a}';
$string['mycourses_numblocos'] = 'Без блоків';
$string['mycourses_numblocos_desc'] = 'Скільки зображень ви хочете в слайд-шоу?';
$string['mycourses_numblocos_nenhum'] = 'Без слайдів на головній сторінці';
$string['mycourses_title'] = 'Коротка назва блоку';
$string['mycourses_title_desc'] = 'Коротка та описова назва для блоку.';
$string['mycourses_url'] = 'Посилання на блок';
$string['mycourses_url_desc'] = 'URL, куди переходити при натисканні на блок. Це може бути зовнішнє посилання або внутрішнє посилання в межах платформи.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'Тема Boost Magnific не зберігає жодних особистих даних користувачів.';
$string['settings_about_heading'] = 'Про ваш Moodle';
$string['settings_css_heading'] = 'Шрифти та CSS';
$string['settings_footer_heading'] = 'Блок підвалу';
$string['settings_icons_change_icons'] = 'Змініть стандартну іконку в списку курсів';
$string['settings_login_heading'] = 'Екран входу';
$string['settings_mycourses_heading'] = 'Блоки моїх курсів';
$string['settings_slideshow_heading'] = 'Слайд-шоу';
$string['settings_theme_heading'] = 'Тема';
$string['settings_top_heading'] = 'Верхнє меню';
$string['sitefonts'] = 'Додаткові шрифти Google';
$string['sitefonts_desc'] = 'Вставте код @import з Google Fonts, як вказано на зображенні нижче. Після збереження поле \'Шрифт сайту\' буде оновлено, відображаючи ці шрифти. Ви можете додавати кілька @import за необхідності.';
$string['slidecaption_desc'] = 'Введіть підпис, який буде використано на слайді';
$string['slideshow_image'] = 'Зображення слайду';
$string['slideshow_image_desc'] = 'Зображення повинно бути 1250px X 400px.';
$string['slideshow_info'] = 'Слайд {$a}';
$string['slideshow_numslides'] = 'Скільки зображень у SlideShow';
$string['slideshow_numslides_desc'] = 'Скільки зображень ви хочете в SlideShow?';
$string['slideshow_numslides_nenhum'] = 'Без слайдів на головній сторінці';
$string['slideshow_text'] = 'Короткий опис для слайду';
$string['slideshow_text_desc'] = 'Вставте короткий текст про слайд.';
$string['slideshow_url'] = 'Посилання на кнопку слайду';
$string['slideshow_url_desc'] = 'Вставте посилання на місце призначення для кнопки зображення слайду';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL вашого Facebook для організації.';
$string['social_instagram'] = 'Ваш Instagram';
$string['social_instagram_desc'] = 'URL вашого Instagram для організації.';
$string['social_linkedin'] = 'Ваш Linkedin';
$string['social_linkedin_desc'] = 'URL вашого Linkedin для організації.';
$string['social_twitter'] = 'Ваш Twitter';
$string['social_twitter_desc'] = 'URL вашого Twitter для організації.';
$string['social_youtube'] = 'Ваш Youtube';
$string['social_youtube_desc'] = 'URL вашого Youtube для організації.';
$string['theme_boost_magnific_about_editbooton'] = 'Редагувати блок \'Про\'';
$string['theme_boost_magnific_frontpage_bloco'] = 'Блок "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Блоки на головній сторінці';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Редагувати блоки';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Редагувати SlideShow';
$string['theme_color'] = 'Вибір кольору';
$string['theme_color-color_buttons'] = 'Колір кнопок';
$string['theme_color-color_buttons_desc'] = 'Колір, що використовується для кнопок, додаючи візуальну цілісність і акцентуючи інтерактивні дії.';
$string['theme_color-color_primary'] = 'Основний колір';
$string['theme_color-color_primary_desc'] = 'Основний колір теми, зазвичай використовується для виділення та акцентування елементів.';
$string['theme_color-color_secondary'] = 'Другорядний колір';
$string['theme_color-color_secondary_desc'] = 'Другорядний колір, що доповнює основний колір, використовується для виділення другорядних елементів або для контрастування з основним кольором.';
$string['theme_color_desc'] = 'Виберіть кольори текстів і кнопок Moodle або натисніть на лінію нижче:';
$string['theme_color_heading'] = 'Вибір кольору середовища';
$string['theme_color_sugestion'] = 'Пропозиція кольору';
$string['theme_color_sugestion_text'] = 'Натисніть на лінію, щоб застосувати колір до полів нижче:';
$string['theme_login_branco'] = 'Тільки екран входу, без бокового зображення, з формою на білому фоні';
$string['top_color_heading'] = 'Колір прокручування вгору';
$string['top_scroll'] = 'Закріпити меню при прокручуванні сторінки';
$string['top_scroll_background_color'] = 'Колір фону верхнього меню при прокрутці';
$string['top_scroll_background_color_desc'] = 'Встановіть колір фону при прокрутці сторінки.';
$string['top_scroll_desc'] = 'Якщо увімкнено, меню буде закріплене у верхній частині екрану під час прокрутки сторінки, забезпечуючи легкий доступ до опцій меню.';
$string['top_scroll_text_color'] = 'Колір тексту меню при прокрутці';
$string['top_scroll_text_color_desc'] = 'Встановіть колір тексту меню при прокрутці сторінки.';
$string['vvveb_footer_contact_title_default'] = 'Зв\'яжіться з нами';
$string['vvveb_home_access'] = 'Доступ до курсу';
$string['vvveb_home_automatically_catalogo'] = 'Не редагуйте. Цей блок буде автоматично замінений каталогом курсів.';
$string['vvveb_home_automatically_category'] = 'Не редагуйте. Цей блок буде автоматично замінений категоріями курсів.';
$string['vvveb_home_automatically_my_course'] = 'Не редагуйте. Цей блок буде автоматично замінений курсами, на які студент записаний.';
$string['vvveb_home_automatically_popular'] = 'Не редагуйте. Цей блок буде автоматично замінений найпопулярнішими курсами.';
$string['vvveb_home_catalogo_heading'] = 'Каталог курсів';
$string['vvveb_home_category_heading'] = 'Категорії курсів';
$string['vvveb_home_mycourses_heading'] = 'Мої курси';
$string['vvveb_home_popular_course'] = 'Популярні курси';
$string['vvveb_home_team_subtitle'] = 'Ми група професіоналів, відданих своїй справі';
$string['vvveb_home_team_title'] = 'Познайомтеся з нашою командою';
