<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_invitation', language 'fr', version '4.3'.
 *
 * @package     enrol_invitation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a_day'] = '1 jour';
$string['a_minute'] = '1 minute';
$string['about_hour'] = 'Environ 1 heure';
$string['about_x_hours'] = 'Environ {$a} heures';
$string['accepteddescription'] = 'L’utilisateur avec l’identifiant {$a->userid} a accepté une invitation pour le cours avec l’identifiant {$a->courseid}.';
$string['action_extend_invite'] = 'Étendre la durée de l’invitation';
$string['action_resend_invite'] = 'Renvoyer l’invitation';
$string['action_revoke_invite'] = 'Révoquer l’invitation';
$string['anonymoususer'] = '(inconnu)';
$string['assignrole'] = 'Attribuer le rôle';
$string['customnamecourse'] = 'Format personnalisé';
$string['customsubjectformat'] = '{$a->shortname} - {$a->fullname}';
$string['default_subject'] = 'Invitation au cours : {$a}';
$string['defaultinvitevalues'] = 'Valeurs d’invitation par défaut';
$string['defaultsubjectformat'] = 'Format de sujet par défaut';
$string['defaultsubjectformat_desc'] = 'Ce format de nom de cours par défaut sera utilisé dans le sujet lors de l’envoi de courriels d’invitation. Ceci n’affecte que les instances de la méthode d’inscription au moment où elles sont créées. En sélectionnant <strong>format personnalisé</strong>, vous pouvez <a href="../admin/tool/customlang/">personnaliser la chaîne de langue <strong>« customsubjectformat »</strong> du plugin <strong>enrol_invitation</strong> en utilisant n’importe quelle combinaison de nom de cours abrégé ou non. Lorsque le plugin est installé, le format personnalisée est « shortname - fullname ».';
$string['deleteddescription'] = 'L’utilisateur avec l’identifiant {$a->userid} a supprimé une invitation au cours avec l’identifiant « {$a->courseid} » pour « {$a->email} ».';
$string['editenrolment'] = 'Modifier l’inscription';
$string['email_clarification'] = 'Vous pouvez spécifier plusieurs adresses de courriel en les séparant par des points-virgules, des virgules, des espaces ou des fins de ligne';
$string['emailaddressnumber'] = 'Adresse courriel {$a}';
$string['emailmessageuserenrolled'] = 'Bonjour,

{$a->userfullname} ({$a->useremail}) a accepté votre invitation au cours {$a->coursefullname} en tant que « {$a->rolename} ». Vous pouvez vérifier l’état de cette invitation en visualisant :

* La liste des participants : {$a->courseenrolledusersurl}
* L’historique des invitations : {$a->invitehistoryurl}

{$a->sitename}
 -------------
{$a->supportemail}';
$string['emailmsghtml'] = 'Aperçu';
$string['emailmsghtml_help'] = '<p>Bonjour,</p>
<p>Vous êtes invité à vous joindre au cours suivant :</p>
<ul>
  <li>Nom du cours : <b>{$a->coursename}</b></li>
  <li>Date de début : <b>{$a->start}</b></li>
  <li>Date de fin : <b>{$a->end}</b></li>
</ul>
{$a->message}
<p>Veuillez vous connecter pour confirmer votre inscription au cours.</p>
<p>En utilisant ce lien, vous confirmez que vous êtes la personne à qui s’adresse ce courriel et cette invitation.</p>
<p><a class="btn btn-primary" href="{$a->inviteurl}">{$a->acceptinvitation}</a></p>
<p>If you do not want to join this course, please use the following link instead:</p>
<p>Si vous ne souhaitez pas vous joindre à ce cours, veuillez plutôt utiliser le lien suivant :</p>
<p><a class="btn btn-danger" href="{$a->rejecturl}">{$a->rejectinvitation}</a></p>
<p>Ce lien expirera le <b>{$a->expiration}</b></p>
<p>Nous espérons vous voir dans le cours.</p>';
$string['emailmsgunsubscribe'] = '<span class="apple-link">Si vous considérez avoir reçu ce message par erreur, si vous avez besoin d’aide ou si vous ne souhaitez plus recevoir d’invitations pour ce cours, veuillez contacter : </span> <a href="mailto:{$a->supportemail}">{$a->supportemail}</a>.';
$string['emailtitleuserenrolled'] = '{$a->userfullname} a accepté l’invitation au cours {$a->coursefullname}.';
$string['enrolconfimation'] = 'Confirmation de l’étudiant requise';
$string['err_cohortlist'] = 'Ou vos devez choisir des cohortes ici.';
$string['err_userlist'] = 'Ou vos devez choisir des utilisateurs ici.';
$string['event_invitation_accepted'] = 'Accepter';
$string['event_invitation_attempted'] = 'Essayer';
$string['event_invitation_deleted'] = 'Supprimé';
$string['event_invitation_rejected'] = 'Refus';
$string['event_invitation_sent'] = 'Envoyer';
$string['event_invitation_updated'] = 'Modifié';
$string['event_invitation_viewed'] = 'Consulté';
$string['expiredtoken'] = 'Le jeton d’invitation est expiré ou il a déjà été utilisé.';
$string['extend_invite_sucess'] = 'Durée de l’invitation étendue';
$string['failuredescription'] = 'Échec : Identifiant d’utilisateur {$a->userid}, identifiant de cours « {$a->courseid} ». Raison {$a->errormsg}.';
$string['half_minute'] = 'la moitié d’une minute';
$string['header_email'] = 'Qui voulez-vous inviter ?';
$string['header_role'] = 'Quel rôle voulez-vous attribuer à l’invité ?';
$string['historyactions'] = 'Actions';
$string['historydateexpiration'] = 'Date d’expiration';
$string['historydatesent'] = 'Date d’envoi';
$string['historyexpires_in'] = 'Expire dans';
$string['historyinvitee'] = 'Invité';
$string['historyrole'] = 'Rôle';
$string['historystatus'] = 'Statut';
$string['historyundefinedrole'] = 'Rôle introuvable. Veuillez renvoyer l’invitation et choisir un autre rôle.';
$string['invitation:config'] = 'Configurer les instances d’invitation';
$string['invitation:enrol'] = 'Inviter des utilisateurs';
$string['invitation:manage'] = 'Administrer les attribution d’invitation';
$string['invitation:unenrol'] = 'Retirer l’attribution d’utilisateurs au cours';
$string['invitation:unenrolself'] = 'Retirer sa propre attribution au cours';
$string['invitation_acceptance_title'] = 'Acceptation d’invitation';
$string['invitationacceptance'] = '<p>Vous êtes invité au cours <strong>{$a->coursefullname}</strong> en tant que <strong>{$a->rolename}</strong>. Veuillez confirmer que vous acceptez de vous joindre à ce cours.</p>';
$string['invitationacceptancebutton'] = 'Accepter l’invitation';
$string['invitationrejectbutton'] = 'Refuser l’invitation';
$string['invitationrejected'] = 'Invitation refusée';
$string['invitationsuccess'] = 'Invitation envoyée';
$string['inviteexpiration'] = 'Expiration de l’invitation';
$string['inviteexpiration_desc'] = 'Durée durant laquelle une invitation est valide (en secondes). Par défaut : 2 semaines.';
$string['invitehistory'] = 'Historique des invitations';
$string['inviteusers'] = 'Inviter des utilisateurs';
$string['invtitation_rejected_notice'] = '<p>Cette invitation a été refusée.</>';
$string['less_minute'] = 'Moins d’une minute';
$string['less_than_x_seconds'] = 'Moins de {$} secondes';
$string['loggedinnot'] = '<p>Vous devez vous connecter avant d’accepter cette invitation.</p>';
$string['message'] = 'Message';
$string['message_help_link'] = 'Voir les consignes envoyées aux invités';
$string['noenddate'] = 'Aucune date de fin';
$string['noinvitationinstanceset'] = 'Aucune instance d’inscription par invitation n’a été trouvée. Merci d’ajouter d’abord une instance d’inscription par invitation à votre cours.';
$string['noinvitehistory'] = 'Aucune invitation envoyée jusqu’à maintenant';
$string['nopermissiontosendinvitation'] = 'Vous n’êtes pas autorisé à envoyer des invitations';
$string['norole'] = 'Veuillez choisir un rôle.';
$string['notify_inviter'] = 'Me notifier à {$a->email} lorsque les utilisateurs invités acceptent cette invitation';
$string['notsentdescription'] = 'Échec de l’envoi d’une invitation au cours avec identifiant « {$a->courseid} » par l’utilisateur avec l’identifiant {$a->userid}, car il n’existe pas de compte avec l’adresse courriel « {$a->email} ».';
$string['pluginname'] = 'Invitation';
$string['pluginname_desc'] = 'Le module d’invitation permet d’envoyer des invitations par courriel. Ces invitations ne peuvent être utilisées qu’une seule fois. Les utilisateurs cliquent sur le lien transmis dans le courriel et sont automatiquement inscrits au cours.';
$string['registeredonly'] = 'N’envoyer les invitations qu’aux utilisateurs enregistrés';
$string['registeredonly_help'] = 'L’invitation ne sera envoyée qu’aux courriels d’utilisateurs ayant déjà un compte.';
$string['rejecteddescription'] = 'L’utilisateur avec l’identifiant {$a->userid} a refusé une invitation au cours avec l’identifiant « {$a->courseid} ».';
$string['reminder'] = 'Rappel :';
$string['resend_invite_sucess'] = 'Invitation renvoyée';
$string['returntocourse'] = 'Revenir au cours';
$string['returntoinvite'] = 'Envoyer une autre invitation';
$string['revoke_invite_sucess'] = 'Invitation révoquée';
$string['sentdescription'] = 'L’utilisateur avec l’identifiant {$a->userid} a envoyé une invitation au cours avec l’identifiant « {$a->courseid} » à « {$a->email} ».';
$string['show_from_email'] = 'Permettre aux utilisateurs invités de me contacter à {$a->email} (Votre adresse apparaitra comme expéditeur du courriel. Sinon, l’expéditeur sera {$a->supportemail}.)';
$string['status'] = 'Autoriser l’inscription par invitation';
$string['status_desc'] = 'Autoriser les utilisateurs à inviter des gens à s’inscrire au cours par défaut.';
$string['status_invite_active'] = 'Actif';
$string['status_invite_expired'] = 'Expiré';
$string['status_invite_invalid'] = 'Non valide';
$string['status_invite_rejected'] = 'Refusé';
$string['status_invite_resent'] = 'Renvoyé';
$string['status_invite_revoked'] = 'Révoqué';
$string['status_invite_used'] = 'Accepté';
$string['status_invite_used_expiration'] = '(l’accès prend fin le {$a})';
$string['status_invite_used_noaccess'] = '(n’a plus accès)';
$string['subject'] = 'Sujet';
$string['unenrol'] = 'Désinscrire l’utilisateur';
$string['unenroluser'] = 'Voulez-vous vraiment désinscrire « {$a->user} » du cours « {$a->course} » ?';
$string['updateddescription'] = 'L’utilisateur d’identifiant {$a->userid} a lancé l’invitation pour le cours d’identifiant « {$a->courseid} » à « {$a->email} ».';
$string['used_by'] = 'par {$a->username} ({$a->roles}, {$a->useremail}) sur {$a->timeused}';
$string['usedefaultvalues'] = 'Utiliser l’invitation avec les valeurs par défaut';
$string['usernotmatch'] = '<p>L’invitation est destinée à un autre utilisateur.</p>';
$string['vieweddescription'] = 'L’utilisateur avec l’identifiant {$a->userid} a consulté l’invitation pour le cours avec l’identifiant « {$a->courseid} ».';
$string['x_days'] = '{$a} jours';
$string['x_minutes'] = '{$a} minutes';
