<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'fr', version '4.3'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Ajouter une nouvelle session';
$string['addmanageremailaddress'] = 'Ajouter l’adresse courriel du responsable';
$string['addmanageremailinstruction'] = 'Vous n’avez pas entré l’adresse courriel de votre responsable. Merci de la fournir ci-dessous pour vous inscrire à cette session.';
$string['addnewfield'] = 'Ajouter un nouveau champ personnalisé';
$string['addnewfieldlink'] = 'Créer un nouveau champ personnalisé';
$string['addnewnotice'] = 'Ajouter un nouvel avis sur le site';
$string['addnewnoticelink'] = 'Créer un nouvel avis sur le site';
$string['addremoveattendees'] = 'Ajouter/enlever des inscriptions';
$string['addsession'] = 'Ajouter une nouvelle session.';
$string['addstudent'] = 'Ajouter un étudiant';
$string['alllocations'] = 'Toutes les villes';
$string['allowoverbook'] = 'Autoriser la surréservation';
$string['allowoverbook_help'] = 'Lorsque "Autoriser surréservation " est cochée , les apprenants seront en mesure de vous inscrire à une session Face-to-face , même si elle est déjà pleine . <br /> Quand un apprenant des signes pour une session qui est déjà pleine , ils recevront un e-mail informant qu’ils ont été en liste d’attente pour la session et sera informé quand une réservation est disponible';
$string['allsessionsin'] = 'Toutes les sessions de {$a}';
$string['alreadysignedup'] = 'Vous vous êtes déjà inscrit(e) à cette activité.';
$string['answer'] = 'S’inscrire';
$string['answercancel'] = 'Se désinscrire';
$string['approvalreqd'] = 'Approbation exigée';
$string['approve'] = 'Approuver';
$string['assessmentyour'] = 'Votre évaluation';
$string['attendance'] = 'Présence';
$string['attendanceinstructions'] = 'Sélectionner les utilisateurs qui ont assisté à la session';
$string['attendedsession'] = 'A assisté à la session';
$string['attendees'] = 'Inscrits';
$string['booked'] = 'Réservé';
$string['bookingcancelled'] = 'Votre inscription a été annulée';
$string['bookingcompleted'] = 'Votre inscription a été enregistrée';
$string['bookingfull'] = 'Session complète';
$string['bookingopen'] = 'Session ouverte';
$string['bookingstatus'] = 'Vous êtes inscrit(e) à la session suivante';
$string['calendareventdescriptionbooking'] = 'Vous êtes inscrit(e) à <a href="{$a}">cette session</a>.';
$string['calendareventdescriptionsession'] = 'Vous avez créé <a href="{$a}">cette session</a>.';
$string['calendaroptions'] = 'Options du calendrier';
$string['cancelbooking'] = 'Annuler l’inscription';
$string['cancelbookingfor'] = 'Annuler l’inscription pour {$a}';
$string['cancellation'] = 'Annulation';
$string['cancellationconfirm'] = 'Voulez-vous vraiment annuler votre inscription à cette session ?';
$string['cancellationinstrmngr'] = '# Avis pour le gestionnaire';
$string['cancellationinstrmngr_help'] = 'Quand ** Envoyer un avis pour le gestionnaire ** est cochée, le texte dans la ** Avis pour le gestionnaire ** champ est envoyé au gestionnaire d’un apprenant informant qu’ils ont annulé une réservation Face-to-Face.';
$string['cancellationmessage'] = 'Message d’annulation';
$string['cancellationmessage_help'] = '# Message d’annulation

Ce message est envoyé par courriel quand un utilisateur annule son inscription à une session.';
$string['cancellations'] = 'Annulations';
$string['cancellationsent'] = 'Vous devriez recevoir un courriel d’annulation immédiatement.';
$string['cancellationsentmgr'] = 'Vous et votre responsable devriez recevoir un courriel d’annulation immédiatement.';
$string['cancellationstablesummary'] = 'Liste des personnes qui ont annulé leur session inscrits.';
$string['cancelreason'] = 'Raison';
$string['cannotapproveatcapacity'] = 'Vous ne pouvez pas approuver tous les autres participants que cette session est pleine .';
$string['cannotsignupsessioninprogress'] = 'Vous ne pouvez pas vous inscrire , cette session est en cours';
$string['cannotsignupsessionover'] = 'Vous ne pouvez pas vous inscrire , cette session est terminée.';
$string['capacity'] = 'Places réservées';
$string['capacity_help'] = '**Capacité** est le nombre de sièges disponibles dans une session. Lorsqu’une séance face-to-face a atteint sa capacité maximale le détails de la session ne s’affichent pas sur la page du parcours. Les détails s’affichent en grisé sur la "Afficher toutes les sessions" à la page et l’apprenant ne peut pas s’inscrire à la session. &nbsp;';
$string['changemanageremailaddress'] = 'Changer l’adresse courriel du responsable';
$string['changemanageremailinstruction'] = 'Merci d’entrer l’adresse courriel de votre responsable ci-dessous.';
$string['clearall'] = 'Tout effacer';
$string['closed'] = 'Fermé';
$string['conditions'] = 'Conditions';
$string['confirm'] = 'Confirmez';
$string['confirmanager'] = 'Confirmez l’adresse courriel de votre responsable';
$string['confirmation'] = 'Confirmation';
$string['confirmationinstrmngr'] = '# Avis pour le gestionnaire';
$string['confirmationinstrmngr_help'] = 'Lorsque " Envoyer un avis au gestionnaire " est cochée, le texte dans le champ «Avis pour le gestionnaire " est envoyé à un gestionnaire informant qu’un membre du personnel a signé pour une session Face-to-Face . *';
$string['confirmationmessage'] = 'Message de confirmation';
$string['confirmationmessage_help'] = '# Message de confirmation

Ce message est envoyé par courriel quand un utilisateur s’inscrit à une session.';
$string['confirmationsent'] = 'Vous devriez recevoir un courriel de confirmation immédiatement.';
$string['confirmationsentmgr'] = 'Vous et votre responsable devriez recevoir un courriel de confirmation immédiatement.';
$string['confirmmanageremailaddress'] = 'Confirmez l’adresse courriel de votre responsable';
$string['confirmmanageremailaddressquestion'] = 'Est-ce que <b>{$a}</b> est toujours l’adresse de courriel de votre responsable ?';
$string['confirmmanageremailinstruction1'] = 'Vous avez précédemment fourni l’adresse courriel suivante comme étant celle de votre responsable.';
$string['confirmmanageremailinstruction2'] = 'Est-ce que c’est toujours l’adresse de courriel de votre responsable ?';
$string['continuetologin'] = 'Cliquez sur Continuer pour vous connecter.';
$string['copy'] = 'Copier';
$string['copyingsession'] = 'Copier en tant que nouvelle session';
$string['copysession'] = 'Copier la session';
$string['cost'] = 'Coût';
$string['crontask'] = 'Travaux d’entretien Face-to-Face';
$string['currentstatus'] = 'Statut actuel';
$string['customfieldsheading'] = 'Champs de session personnalisée';
$string['date'] = 'Date';
$string['dateadd'] = 'Ajouter une nouvelle date';
$string['dateremove'] = 'Supprimer cette date';
$string['datesignedup'] = 'Date d’inscription';
$string['datetext'] = 'Vous êtes inscrit(e) à cette date';
$string['decidelater'] = 'Décider plus tard';
$string['decline'] = 'Refuser';
$string['delete'] = 'Effacer';
$string['deleteall'] = 'Tout supprimer';
$string['deletesession'] = 'Supprimer la session';
$string['deletesessionconfirm'] = 'Voulez-vous vraiment supprimer cette session et toutes les inscriptions pour cette session ?';
$string['deletingsession'] = 'Suppression de la session à {$a}';
$string['description'] = 'Texte d’introduction';
$string['description_help'] = '** Description ** est la description du cours qui affiche lorsqu’un apprenant enrôle sur une session Face-to-Face . Le ** Description ** affiche également dans le calendrier de formation .';
$string['details'] = 'Détails';
$string['details_help'] = 'Les détails sont liés à chaque session.

Si la zone Détails est remplie, ce texte sera affiché sur la page d’inscription pour les utilisateurs.

Par défaut, ce texte apparaît également dans les courriels de confirmation, de rappel, d’annulation et de placement en liste d’attente.';
$string['discountcode'] = 'Code de réduction';
$string['discountcode_help'] = 'Ce code est le code demandé pour obtenir une réduction sur le prix de la formation.

Si l’utilisateur ne tape pas le code de réduction, c’est le le prix normal qui est pris en compte lors de l’inscription.';
$string['discountcost'] = 'Coût réduit';
$string['discountcost_help'] = 'Le prix réduit est le montant demandé aux utilisateurs qui ont une carte de membre.

Si un utilisateur entre son identifiant de membre lors de l’inscription, c’est le prix réduit qui apparaît dans la colonne prix.';
$string['due'] = 'du';
$string['duration'] = 'Durée';
$string['duration_help'] = 'La durée est la durée totale de la formation en heures.

Par exemple:
*   *"2 heures"* se tape: **2**
*   *"1 heure et demi"* se tape: **1.5**
*   *"45 minutes"* se tape: **0.75**

Si la formation se passe sur deux périodes ou plus la durée est le total des durées de ces périodes.

Ce champ est optionnel.';
$string['early'] = '{$a} tôt';
$string['editingsession'] = 'Édition de la session de {$a}';
$string['editsession'] = 'Editer la session';
$string['email:instrmngr'] = 'Information du responsable';
$string['email:message'] = 'Message';
$string['email:subject'] = 'Sujet';
$string['emailmanager'] = 'Envoyer information au responsable';
$string['emptylocation'] = 'Ville est vide';
$string['error:addalreadysignedupattendee'] = '{$a} est déjà inscrit(e) à cette activité.';
$string['error:addattendee'] = 'Impossible d’ajouter {$a} à cette session.';
$string['error:cancelbooking'] = 'Il y a eu un problème lors de l’annulation de votre inscription';
$string['error:cannotemailmanager'] = 'Courriel de rappel envoyé pour l’enregistrement {$a->submissionid} à l’utilisateur {$a->userid}, mais impossible d’envoyer le message à l’adresse courriel du responsable ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'Échec de l’envoi du courriel pour l’enregistrement {$a->submissionid} à l’utilisateur {$a->userid} ({$a->useremail}).';
$string['error:cannotsendconfirmationmanager'] = 'Un message de confirmation a été envoyé sur votre adresse courriel, mais il y a eu un problème pour envoyer une copie du message à votre responsable.';
$string['error:cannotsendconfirmationthirdparty'] = 'Un message de confirmation a été envoyé sur votre adresse courriel et sur celle de votre responsable , mais il y a eu un problème pour envoyer une copie du message au responsable de la formation.';
$string['error:cannotsendconfirmationuser'] = 'Il y a eu un problème pour envoyer un message de confirmation sur votre adresse courriel.';
$string['error:cannotsendconfirmationusermanager'] = 'Le message d confirmation n’a pu être envoyé ni sur votre adresse courriel, ni sur celle de votre responsable.';
$string['error:couldnotaddsession'] = 'Échec de l’ajout de session';
$string['error:couldnotcopysession'] = 'Échec de la copie de session';
$string['error:couldnotdeletesession'] = 'Échec de la suppression de session';
$string['error:couldnotupdatemanageremail'] = 'Échec de la mise à jour de l’adresse courriel de votre responsable';
$string['error:couldnotupdatesession'] = 'Échec de la mise à jour de la session';
$string['error:coursemisconfigured'] = 'L’inscription est mal configurée';
$string['error:cronprefix'] = 'Erreur: facetoface cron:';
$string['error:emptylocation'] = 'La ville est vide';
$string['error:emptymanageremail'] = 'L’adresse courriel du responsable est vide';
$string['error:emptyvenue'] = 'Le lieu est vide';
$string['error:enrolmentfailed'] = 'Impossible d’inscrire {$a} dans ce cours.';
$string['error:eventoccurred'] = 'Impossible de vous inscrire dans un cours passé.';
$string['error:incorrectcoursemodule'] = 'Course module is incorrect';
$string['error:incorrectcoursemoduleid'] = 'Course module is incorrect';
$string['error:incorrectcoursemodulesession'] = 'Course Module Face-to-face Session was incorrect';
$string['error:incorrectfacetofaceid'] = 'Face-to-face ID was incorrect';
$string['error:invaliduserid'] = 'Identifiant d’utilisateur non valide';
$string['error:mustspecifycoursemodulefacetoface'] = 'Must specify a course module or a facetoface ID';
$string['error:nomanageremail'] = 'Vous n’avez pas fourni d’adresse courriel pour votre responsable';
$string['error:problemsigningup'] = 'Il y a eu un problème pour vous inscrire';
$string['error:removeattendee'] = 'Impossible d’enlever {$a} de cette session.';
$string['excelformat'] = 'Excel';
$string['export'] = 'Exporter';
$string['exportattendance'] = 'Exporter la présence';
$string['exporttofile'] = 'Exporter vers un fichier';
$string['facetoface'] = 'Inscriptions';
$string['facetoface:addattendees'] = 'Ajouter des étudiants d’une session de formation';
$string['facetoface:editsessions'] = 'Ajouter, copier et supprimer des sessions de formation';
$string['facetoface:overbook'] = 'Inscription à une session à pleine capacité.';
$string['facetoface:removeattendees'] = 'Enlever des étudiants d’une session de formation';
$string['facetoface:signup'] = 'S’inscrire à une session';
$string['facetoface:takeattendance'] = 'Noter la présence';
$string['facetoface:view'] = 'Voir les activités et sessions de formation';
$string['facetoface:viewattendees'] = 'Voir les listes d’inscrits et de présence';
$string['facetoface:viewcancellations'] = 'Voir la liste des annulations';
$string['facetoface:viewemptyactivities'] = 'Voir les sessions vides';
$string['facetofacebooking'] = 'Réservation Face-to-face';
$string['facetofacename'] = 'Nom de l’évènement';
$string['facetofacesession'] = 'Session Face-to-face';
$string['feedback'] = 'Commentaire';
$string['feedbackupdated'] = 'Commentaire mis à jour pour {$a} personnes';
$string['floor'] = 'Etage';
$string['format'] = 'Format';
$string['full'] = 'Date complète';
$string['goback'] = 'Retour';
$string['import'] = 'Importation';
$string['info'] = 'Information';
$string['late'] = '{$a} en retard';
$string['location'] = 'Ville';
$string['location_help'] = 'Lieu indique le lieu de la session (ville, département, région, etc).

Le lieu est affiché sur la page de cours avec les dates et heures de début et de fin de session. Il est aussi indiqué sur la page d’inscription, la page "Afficher toutes les sessions" et tous les courriels envoyés.

Sur la page "Afficher toutes les sessions", la liste des sessions peut aussi être filtrée par lieu.';
$string['lookfor'] = 'Recherche';
$string['manageradded'] = 'L’adresse courriel de votre responsable a été acceptée';
$string['managerchanged'] = 'L’adresse courriel de votre responsable a été changée';
$string['manageremail'] = 'Courriel du responsable';
$string['manageremailaddress'] = 'Adresse courriel du responsable';
$string['manageremailformat'] = 'L’adresse de courriel doit avoir le format suivant pour être acceptée : « {$a} »';
$string['manageremailinstruction'] = 'Pour vous inscrire à une session de formation, un courriel de confirmation doit vous être envoyé, ainsi qu’une copie à votre responsable';
$string['manageremailinstructionconfirm'] = 'Merci de confirmer que ceci est bien l’adresse courriel de votre responsable:';
$string['managername'] = 'Nom du responsable';
$string['managerupdated'] = 'L’adresse courriel de votre responsable a été mise à jour';
$string['maximumpoints'] = 'Nombre maximum de points';
$string['maximumsize'] = 'Nombre maximum d’inscrits';
$string['message'] = 'Changement d’inscription à la formation {$a->coursename} !

Une place s’est libérée pour la session du  {$a->duedate} ({$a->name}) dans le cours {$a->coursename}.
Vous avez été inscrit. Si la date ne vous convient plus, veuillez vous désinscrire : <a href=\'{$a->url}\'>{$a->url}</a>.';
$string['mods_help'] = '# Activités de formation

Ces activités sont utilisées pour gérer des séances qui nécessitent une inscription préalable.

Chaque activité est proposée en tant qu’une ou plusieurs sessions identiques. Ces sessions peuvent être organisées sur un ou plusieurs jours.

Des messages de rappel sont envoyés aux utilisateurs et à leurs responsables quelques jours avant que la session ne commence. Les utilisateurs peuvent s’inscrire ou annuler leur inscription.';
$string['modulename'] = 'Inscription';
$string['modulenameplural'] = 'Inscriptions';
$string['moreinfo'] = 'Plus d’information';
$string['newmanageremailaddress'] = 'Adresse courriel du responsable';
$string['nofacetofaces'] = 'Il n’y a pas d’inscriptions';
$string['none'] = 'Aucun';
$string['noremindersneedtobesent'] = 'Aucun rappel ne nécessite d’être envoyé';
$string['normalcost'] = 'Coût normal';
$string['normalcost_help'] = 'Le prix normal est celui demandé aux utilisateurs qui n’ont pas de carte de membre.

Le prix normal est celui affiché dans le carnet de notes, à moins que l’utilisateur n’est donné un identifiant de membre lors de l’inscription.';
$string['nosignedupusers'] = 'Aucun utilisateur n’est inscrit pour cette session';
$string['note'] = 'Note';
$string['notefull'] = 'Même si la session est complète, vous pouvez encore vous inscrire: vous serez mis sur liste d’attente (en rouge). Si quelqu’un se désinscrit, le premier étudiant de la liste sera placé dans la liste des inscrits et recevra une confirmation par courriel.';
$string['notificationboth'] = 'Courriel et iCalendar';
$string['notificationemail'] = 'Courriel seulement';
$string['notificationical'] = 'iCalendar seulement';
$string['notificationtype'] = 'Type de notification';
$string['notsubmittedyet'] = 'Pas encore évalué';
$string['noupcoming'] = 'Aucune session prévue';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 heure';
$string['oneminute'] = '1 minute';
$string['options'] = 'Options';
$string['or'] = 'ou';
$string['order'] = 'Ordre';
$string['place'] = 'Responsable';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['points'] = 'Points';
$string['pointsplural'] = 'Points';
$string['previoussessions'] = 'Sessions passées';
$string['printversionid'] = 'Version imprimable: sans nom';
$string['printversionname'] = 'Version imprimable: avec nom';
$string['really'] = 'Voulez-vous vraiment supprimer tous les résultats pour cette formation';
$string['registeredon'] = 'Inscrit(e) le';
$string['registrations'] = 'Inscriptions';
$string['reminder'] = 'Rappel';
$string['remindermessage'] = 'Message de rappel';
$string['remindermessage_help'] = '# Message de rappel

Ce message est envoyé par courriel quelques jours avant le début de la session.';
$string['reminderperiod'] = 'Envoyer le rappel combien de jours avant ?';
$string['reminderperiod_help'] = '# Période de rappel

Le message de rappel sera envoyé ce nombre de jours avant le début de la session.';
$string['room'] = 'Salle';
$string['room_help'] = 'C’est le numéro de la salle ou a lieu la formation.

Ce numéro est affiché sur la page d’inscription, la page "Afficher toutes les sessions et dans tous les courriels.';
$string['saveallfeedback'] = 'Enregistrer toutes les réponses';
$string['saveattendance'] = 'Enregistrer la présence';
$string['scheduledsession'] = 'Session à venir';
$string['scheduledsessions'] = 'Sessions à venir';
$string['seatsavailable'] = 'Nombre de places restantes';
$string['seeattendees'] = 'Afficher les inscrits';
$string['sentremindermanager'] = 'Envoyer un courriel de rappel au responsable de l’utilisateur';
$string['sentreminderuser'] = 'Envoyer un courriel de rappel à l’utilisateur';
$string['sessiondate'] = 'Date de la session';
$string['sessiondatetime'] = 'Date et heure de la session';
$string['sessiondatetimeknown'] = 'Date et heure de la session connues';
$string['sessiondatetimeknown_help'] = '**Si les date et heure de la session sont connues**

Si \'Oui\' est donné comme valeur pour ce paramètre ces dates et heures seront affichées sur la page de la formation (si la session est à venir et ouverte à l’inscription), la page "Afficher toutes les sessions," la page d’inscription, ainsi que tous les courriels liés à la session.

Quand un utilisateur s’inscrit à une session avec dates et heures connues:

*   L’utilisateur et son responsable recevront un courriel de confirmation (celui configuré par les champs "Sujet de la confirmation" et "message de confirmation" dans les paramètres de la formation).
*   Ils recevront aussi un courriel de rappel (celui configuré par les champs "Sujet du rappel" et "message de rappel" dans les paramètres de la formation. Le rappel sera envoyé le nombre de jours donné par "Période de rappel" avant la session.)

**Si les date et heure de la session ne sont pas connues**

Si \'Oui\' est donné comme valeur pour ce paramètre, le texte "A définir" sera affiché sur la page de la formation, la page "Afficher toutes les sessions," la page d’inscription, ainsi que tous les courriels liés à la session.

Quand un utilisateur s’inscrit à une session "à définir":

*   il ne reçoit pas le message de confirmation, mais celui configuré par les champs "Sujet de message d’attente" et "message d’attente" dans les paramètres de la formation.).
*   il ne recevra pas de rappel.
*   il ne recevra pas de courriel d’annulation.';
$string['sessionfinishtime'] = 'Heure de fin de session';
$string['sessionover'] = 'Session terminée';
$string['sessions'] = 'Sessions';
$string['sessionsoncoursepage'] = 'Sessions affichées sur la page du cours';
$string['sessionsoncoursepage_help'] = '# Sessions sur la page d’inscription

C’est le nombre de sessions de formation affichées par page.';
$string['sessionstartdate'] = 'Date de début de la session';
$string['sessionstarttime'] = 'Heure de début de la session';
$string['sessionvenue'] = 'Lieu de la session';
$string['setting:addchangemanageremail'] = 'Demander aux utilisateurs l’adresse courriel de leur responsable';
$string['setting:addchangemanageremail_caption'] = 'Courriel du responsable :';
$string['setting:addchangemanageremaildefault'] = 'Demandez aux utilisateurs pour l’adresse courriel de leur directeur.';
$string['setting:defaultcancellationinstrmngr'] = 'Messages d’annulation par défaut envoyés aux responsables.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Message d’annulation (responsable)';
$string['setting:defaultcancellationinstrmngrdefault'] = '***Information***

L’inscription de [firstname] [lastname] a été annulée pour la formation suivante et vous êtes désigné comme son responsable.

*** L’annulation de l’inscription de [firstname] [lastname]est en copie ci-dessous ****';
$string['setting:defaultcancellationmessage'] = 'Message d’annulation par défaut envoyés aux utilisateurs.';
$string['setting:defaultcancellationmessage_caption'] = 'Message d’annulation';
$string['setting:defaultcancellationmessagedefault'] = 'Ce message vous confirme que votre inscription à la session suivante a été annulée :

***INSCRIPTION ANNULÉE***

Participant : [firstname] [lastname]
Session : [facetofacename]

Durée : [duration]
Date(s) :
[alldates]

Ville : [session:location]
Lieu : [session:venue]
Salle : [session:room]';
$string['setting:defaultcancellationsubject'] = 'Sujet par défaut des messages d’annulation.';
$string['setting:defaultcancellationsubject_caption'] = 'Sujet d’annulation';
$string['setting:defaultcancellationsubjectdefault'] = 'Annulation de l’inscription à la formation';
$string['setting:defaultconfirmationinstrmngr'] = 'Messages de confirmation par défaut envoyés aux responsables.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Message de confirmation (responsable)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '***Information***

[firstname] [lastname] a été inscrit pour la formation suivante et vous avez été désigné comme son responsable.

Si vous n’êtes pas son responsable et avez reçu ce message par erreur, merci de le signaler en y répondant. Si vous avez des inquiétudes concernant le fait que votre personnel suit ce cours, veuillez en discuter directement avec eux.

*** L’inscription de [firstname] [lastname] est en copie ci-dessous ****';
$string['setting:defaultconfirmationmessage'] = 'Messages de confirmation par défaut envoyés aux utilisateurs.';
$string['setting:defaultconfirmationmessage_caption'] = 'Message de confirmation';
$string['setting:defaultconfirmationmessagedefault'] = 'Ce message vous confirme que vous êtes inscrit(e) à la formation suivante :

Participant : [firstname] [lastname]
Formation : [facetofacename]
Coût : [cost]

Durée : [duration]
Date(s) :
[alldates]

Ville : [session:location]
Lieu : [session:venue]
Salle : [session:room]

***Veuillez arriver dix minutes avant le début de la formation***

Pour changer la date ou annuler votre inscription

Pour changer la date, il faut d’abord annuler cette inscription et vous réinscrire à une autre date. Pour annuler votre inscription, retournez sur le site, ensuite à la page de cette formation et choisissez « Annuler » sur la page d’information sur les inscriptions.

[details]

Vous recevrez un rappel [reminderperiod] jours ouverts avant cette formation.';
$string['setting:defaultconfirmationsubject'] = 'Sujet par défaut des messages de confirmation.';
$string['setting:defaultconfirmationsubject_caption'] = 'Sujet de confirmation';
$string['setting:defaultconfirmationsubjectdefault'] = 'Confirmation d’inscription : [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Messages de rappel par défaut envoyés aux responsables.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Message de rappel (responsable)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Rappel seulement ***

Un membre de votre personnel, [firstname] [lastname], est inscrit pour assister à la formation ci-dessus et a également reçu ce message de rappel.

Si vous n’êtes pas leur chef d’équipe / directeur et pensez avoir reçu ce message par erreur, merci d’y répondre pour le signaler.

*** Le courriel de rappel à [firstname] [lastname] est en copie ci-dessous ****';
$string['setting:defaultremindermessage'] = 'Messages de rappel par défaut envoyés aux utilisateurs.';
$string['setting:defaultremindermessage_caption'] = 'Message de rappel';
$string['setting:defaultremindermessagedefault'] = 'Ce message vous rappelle que vous êtes inscrit(e) à la formation suivante :

Participant : [firstname] [lastname]
Formation : [facetofacename]
Coût : [cost]

Durée : [duration]
Date(s) :
[alldates]

Ville : [session:location]
Lieu : [session:venue]
Salle : [session:room]

***Veuillez arriver dix minutes avant le début de la formation***

Pour changer la date ou annuler votre inscription

Pour changer la date, il faut d’abord annuler cette inscription et vous réinscrire à une autre date. Pour annuler votre inscription, retournez sur le site, ensuite à la page de cette formation et choisissez « Annuler » sur la page d’information sur les inscriptions

[details]';
$string['setting:defaultremindersubject'] = 'Sujet par défaut des messages de rappel.';
$string['setting:defaultremindersubject_caption'] = 'Sujet de rappel';
$string['setting:defaultremindersubjectdefault'] = 'Rappel d’inscription:[facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestinstrmngrdefault'] = 'Cet avis à pour intention de vous informer que [firstname] [lastname] a fait une demande d’inscription à la formation suivante, il est indiqué que vous êtes son chef d’équipe / directeur.

Formation : [facetofacename]
Coût : [cost]

Durée: [duration]
Date(s) :
[alldates]

Ville : [session:location]
Lieu : [session:venue]
Salle : [session:room]

Veuillez suivre l’hyperlien suivant pour approuver cette demande d’inscription :
[attendeeslink]#unapproved


*** La demande d’inscription de [firstname] [lastname] paraît ci-dessous ****';
$string['setting:defaultrequestmessagedefault'] = 'Votre demande d’inscription à la formation suivante a été envoyée à votre directeur :

Participant : [firstname] [lastname]
Formation : [facetofacename]
Coût : [cost]

Durée: [duration]
Date(s) :
[alldates]

Ville : [session:location]
Lieu : [session:venue]
Salle : [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Demande d’inscription : [facetofacename], [starttime]-[finishtime]';
$string['setting:defaultvalue'] = 'Valeur par défault';
$string['setting:defaultwaitlistedmessage'] = 'Messages de liste d’attente par défaut envoyés aux utilisateurs.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Message de liste d’attente';
$string['setting:defaultwaitlistedmessagedefault'] = 'Ce message vous informe que vous avez été ajouté(e) à la liste d’attente pour :

Formation : [facetofacename]
Lieu : [session:venue]
Participant : [firstname] [lastname]

***Notez que ceci n’est pas une confirmation d’inscription***

Vous avez fait part de votre intérêt pour cette formation et serez contacté(e) directement quand des places seront disponibles.

Pour vous retirer de cette liste d’attente, veuillez retourner au cours et cliquer sur Annuler la réservation. Veuillez noter qu’il n’y a pas de courriel de confirmation de suppression de liste d’attente.';
$string['setting:defaultwaitlistedsubject'] = 'Sujet par défaut des messages de liste d’attente.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Sujet de liste d’attente';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Information de liste d’attente pour [facetofacename]';
$string['setting:disableicalcancel'] = 'Désactiver les messages d’annulation avec une pièce jointe iCalendar.';
$string['setting:disableicalcancel_caption'] = 'Désactiver les annulations iCalendar :';
$string['setting:fromaddress'] = 'Ce qui apparaîtra dans le champ « De » des courriels de rappel envoyés par ce module.';
$string['setting:fromaddress_caption'] = 'Courriel d’envoi :';
$string['setting:fromaddressdefault'] = 'moodle@exemple.com';
$string['setting:hidecost'] = 'Masquer les champs de coût et code promotionnel.';
$string['setting:hidecost_caption'] = 'Masquer le coût :';
$string['setting:hidediscount'] = 'Masquer seulement le champ de code promotionnel.';
$string['setting:hidediscount_caption'] = 'Masquer le coût réduit :';
$string['setting:isfilter'] = 'Afficher sous forme d’un filtre';
$string['setting:manageraddressformat'] = 'Suffixe qui doit être présent dans l’adresse de courriel du directeur pour que celle-ci soit considérée valide.';
$string['setting:manageraddressformat_caption'] = 'Suffixe obligatoire :';
$string['setting:manageraddressformatreadable'] = 'Description rapide des restrictions en matière d’adresse courriel des directeurs. Ce paramètre n’a aucun effet si le précédent n’est pas utilisé.';
$string['setting:manageraddressformatreadable_caption'] = 'Exemple du format :';
$string['setting:manageraddressformatreadabledefault'] = 'nom.prénom@societe.fr';
$string['setting:oneemailperday'] = 'Envoyer un seul message de confirmation pour les sessions de plus d’une journée.';
$string['setting:oneemailperday_caption'] = 'Un message par jour :';
$string['setting:possiblevalues'] = 'Liste des valeurs possible';
$string['setting:sessionroles'] = 'Les utilisateurs affectés aux rôles sélectionnés dans un cours peuvent être suivis avec chaque session de face-à-face';
$string['setting:sessionroles_caption'] = 'Rôle de session :';
$string['setting:showinsummary'] = 'Afficher dans les exportations et les listes';
$string['setting:type'] = 'Type de champ';
$string['showbylocation'] = 'Montrer par ville';
$string['sign-ups'] = 'Inscriptions';
$string['signup'] = 'Inscription';
$string['signupfor'] = 'Inscription pour {$a}';
$string['signupforsession'] = 'Inscription pour une session future ouverte';
$string['status'] = 'Statut';
$string['status_booked'] = 'Réservé';
$string['subject'] = 'Changement dans l’inscription au cours {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Inscriptions';
$string['submit'] = 'S’inscrire';
$string['submitted'] = 'Inscrit';
$string['summary'] = 'Résumé';
$string['suppressemail'] = 'Empêcher les envois de courriels';
$string['suppressemail_help'] = '# Empêcher l’envoi de courriels

Utilisez cette option si vous désirez ajouter/enlever des utilisateurs à cette sesssion sans que les avis par courriel ne soient envoyés.';
$string['takeattendance'] = 'Noter la présence';
$string['thirdpartyemailaddress'] = 'Adresse du tiers';
$string['thirdpartyemailaddress_help'] = '# Adresse courriel d’un tiers

Vous pouvez spécifier l’adresse courriel d’un tiers (comme un formateur externe par exemple) qui recevra un courriel à chaque fois qu’un utilisateur s’inscrit à une session.';
$string['thirdpartywaitlist'] = 'Aviser le tiers des ajouts à la liste d’attente';
$string['thirdpartywaitlist_help'] = '# Aviser le tiers des ajouts à la liste d’attente

Si vous désirez aviser le tiers par courriel lorsque des utilisateurs s’incrivent sur une liste d’attente, activez cette option.

Si cette option est désactivée, le tiers ne recevra des avis par courriels que lors d’une inscription ou d’une annulation dans une session prévue.

Cette option est utile dans le cas où un tiers désire attendre qu’il y ait un certain nombre d’inscriptions avant d’offrir une session.';
$string['time'] = 'Heure';
$string['timecancelled'] = 'Heure d’annulation';
$string['timedue'] = 'Limite d’inscription';
$string['timefinish'] = 'Heure de fin';
$string['timefinish_help'] = 'C’est le moment auquel la session se termine.';
$string['timesignedup'] = 'Heure d’inscription';
$string['timestart'] = 'Heure de début';
$string['timestart_help'] = 'C’est le moment auquel la session commence.';
$string['unknowndate'] = '(date inconnue)';
$string['unknowntime'] = '(heure inconnue)';
$string['upcomingsessions'] = 'Sessions futures';
$string['usercancelledon'] = 'L’utilisateur a annulé son inscription le {$a}';
$string['usernotsignedup'] = 'Statut: non-inscrit';
$string['usersignedup'] = 'Statut: inscrit';
$string['usersignedupon'] = 'L’utilisateur s’est inscrit le {$a}';
$string['venue'] = 'Lieu';
$string['venue_help'] = 'C’est l’endroit ou la session aura lieu.

Il est affiché pour le personnel sur la page d’inscription, la page "Afficher toutes les sessions" et dans tous les messages par courriel.';
$string['viewallsessions'] = 'Afficher toutes les sessions';
$string['viewsubmissions'] = 'Afficher les inscriptions';
$string['wait-list'] = 'Liste d’attente';
$string['wait-listed'] = 'À définir';
$string['waitlistedmessage'] = 'Message de liste d’attente';
$string['xhours'] = '{$a} heures';
$string['xminutes'] = '{$a} minutes';
$string['youarebooked'] = 'Vous êtes inscrit(e) à la session suivante';
$string['youremailaddress'] = 'Votre adresse de courriel';
