<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_afterburner', language 'de', version '4.3'.
 *
 * @package     theme_afterburner
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Afterburner</h2>
<img src="afterburner/pix/screenshot.jpg" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Afterburner:</h2>
<p>Afterburner ist ein Drei-Spalten-Design mit variabler Breite für Moodle 2.0. Das Design integriert das Login und Logout in das zusätzliche Menü.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf dem in Moodle enthaltenen Grunddesign Base. Wenn Sie Änderungen über die angebotenen Einstellungen hinaus vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen. Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Danksagungen</h2>
<p>Dieses Design wurde ursprünglich von Patrick Malley von NewSchool Learning (patrick@newschoollearning.com) aus einem Design von Rocket Themes (www.rockettheme.com)  für Moodle 1.9 entwickelt und von Mary Evans of NewSchool Learning (contact@newschoollearning.com) für Moodle 2.0 portiert.</p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
</div>
</div>';
$string['configtitle'] = 'Afterburner-Einstellungen';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach geändert werden.';
$string['footnote'] = 'Fußzeile';
$string['footnotedesc'] = 'Fußnote oder Fußzeilentext einfügen';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Wenn Sie das Standardlogo ersetzen möchten, laden Sie Ihre Logo-Datei hoch. <br />Das Standardlogos hat das Format .jpg und ist 320 Pixel breit und 75 Pixel hoch.';
$string['pluginname'] = 'Afterburner';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
