<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mobile', language 'sr_cr', version '4.3'.
 *
 * @package     tool_mobile
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adodbdebugwarning'] = 'ADOdb отклањање грешака је омогућено. Требало би да буде онемогућено приликом провере идентитета из екстерне базе података односно приликом подешавања додатка за упис из екстерне базе података.';
$string['androidappid'] = 'Јединствени идентификатор Android апликације';
$string['androidappid_desc'] = 'Можете ово подешавање оставити као подразумевано, осим ако имате прилагођену Android апликацију.';
$string['apppolicy'] = 'URL адреса правилника за коришћење апликације';
$string['apppolicy_help'] = 'URL адреса правилника за кориснике мобилне апликације се налази на страници \'О апликацији\'. Ако је поље остављено празно, користиће се URL адреса правилника о коришћењу сајта.';
$string['apprequired'] = 'Ова функционалност је доступна само када се приступа преко Moodle мобилне или десктоп апликације.';
$string['autologinkeygenerationlockout'] = 'Генерисање кључа за аутоматску пријаву је блокирано. Морате да сачекате {$a} минут/а између два захтева.';
$string['autologinmintimebetweenreq'] = 'Минимално време између захтева за аутоматско пријављивање';
$string['autologinmintimebetweenreq_desc'] = 'Минимално време између захтева за аутоматско пријављивање путем мобилне апликације. Ако се од корисника апликације често тражи да унесу своје податке, када гледају садржај уграђен са сајта, онда подесите нижу вредност.';
$string['autologinnotallowedtoadmins'] = 'Аутоматска пријава није дозвољена администраторима сајта.';
$string['autologout'] = 'Обавезна аутоматска одјава за ваше кориснике';
$string['autologout_desc'] = 'Из разлога безбедности, можете приморати своје кориснике да се аутоматски одјаве када напусте или затворе апликацију, или када апликација пређе у позадину. Корисници ће морати поново да се пријаве када се врате у апликацију.';
$string['autologoutcustom'] = 'Прилагођено време након што корисници напусте или затворе апликацију';
$string['autologoutinmediate'] = 'Одмах након што корисници напусте или затворе апликацију';
$string['autologouttime'] = 'Тајмер за аутоматску одјаву';
$string['cachedef_plugininfo'] = 'Ово чува списак додатака са додатним модулима за мобилне уређаје';
$string['cachedef_subscriptiondata'] = 'Ово чува информације о претплати на Moodle апликацију.';
$string['clickheretolaunchtheapp'] = 'Кликните овде ако се апликација не отвори аутоматски.';
$string['configmobilecssurl'] = 'CSS датотека за прилагођавање интерфејса ваше мобилне апликације';
$string['customlangstrings'] = 'Прилагођени језички стрингови';
$string['customlangstrings_desc'] = 'Речи и фразе које се приказују у апликацији могу се овде прилагодити. Унесите сваки језички стринг у нови ред у следећем формату:  идентификатор стринга, прилагођени тј. преведени стринг и кôд језика, који су међусобно одвојени вертикалном цртом |. На пример:
<pre>
mm.user.student|Learner|en
mm.user.student|Ученик|sr_cr
</pre>
За комплетан списак идентификатора стрингова и више информација погледајте документацију.';
$string['custommenuitems'] = 'Прилагођене ставке менија';
$string['custommenuitems_desc'] = 'Додатне ставке у менију мобилне апликације могу се укључити тако што ћете их овде навести. Унесите сваку ставку прилагођеног менија у нови рад, у следећем формату: текст ставке, URL адреса линка, начин отварања линка и кôд језика (опционо, за приказ ставке само корисницима наведеног језика), међусобно одвојене вертикалном цртом |.

Начини отварања линка су: \'app\' (за повезивање са активношћу коју апликација подржава), \'inappbrowser\' (за отворање линка у веб читачу без напуштања апликације), \'browser\' (за отварање линка у подразумеваном веб читачу мобилног уређаја изван апликације) и \'embedded\' (за приказ унутар iframe ознаке на новој страници у апликацији).

Када ставкама недостаје превод за дати језик, оне ће користити друге језике као резервни, осим ако се кôду језика дода "_only"

На пример:
<pre>
App help|https://someurl.xyz/help|inappbrowser
My grades|https://someurl.xyz/local/mygrades/index.php|embedded|en
Mis calificaciones|https://someurl.xyz/local/mygrades/index.php|embedded|es
You will only see this in English|https://someurl.xyz/english|browser|en_only
</pre>';
$string['darkmode'] = 'Тамни режим';
$string['disabledfeatures'] = 'Искључене функције';
$string['disabledfeatures_desc'] = 'Изаберите овде које функције у мобилној апликацији желите да искључите за свој сајт. Имајте у виду да поједине функције које се овде налазе на списку могу да буду искључене путем других подешавања сајта. Да бисте видели промене мораћете прво да се одјавите и поново пријавите.';
$string['displayerrorswarning'] = 'Приказ порука за отклањање грешака је омогућен. Требало би да буде онемогућен.';
$string['downloadcourse'] = 'Преузми курс';
$string['downloadcourses'] = 'Преузми курсеве';
$string['enablesmartappbanners'] = 'Омогући банере апликација';
$string['enablesmartappbanners_desc'] = 'Ако је ова опција омогућена, банер који рекламира Moodle Mobile апликације биће приказан када се сајту приступа преко веб читача мобилног уређаја.';
$string['filetypeexclusionlist'] = 'Списак искључених типова датотека';
$string['filetypeexclusionlist_desc'] = 'Изаберите све типове датотека који нису за употребу на мобилном уређају. Такве датотеке ће бити наведене на курсу, а ако корисник покуша да их отвори, приказаће се упозорење у којем се наводи да врста датотеке није намењена за употребу на мобилном уређају. Корисник тада може отказати или занемарити упозорење и свеједно отворити датотеку.';
$string['filetypeexclusionlistplaceholder'] = 'Списак искључених типова датотека на мобилним уређајима';
$string['forcedurlscheme'] = 'Ако желите да дозволите да само ваша прилагођена, брендирана апликација буде отворена од стране веб читача онда овде наведите њену URL схему. Ако желите да дозволите само званичну апликацију, подесите подразумевану вредност. Оставите поље празно ако желите да дозволите коришћење било које апликације.';
$string['forcedurlscheme_key'] = 'URL схема';
$string['forcelogout'] = 'Обавезна одјава';
$string['forcelogout_desc'] = 'Ако је омогућена ова опција, корисници ће увек бити потпуно одјављени чак и када се пребацује са једносг на други налог. Следећи пут када буду хтели да приступе сајту мораће поново да унесу своју лозинку.';
$string['getmoodleonyourmobile'] = 'Преузмите мобилну апликацију';
$string['h5poffline'] = 'Прикажи H5P садржај офлајн';
$string['httpsrequired'] = 'HTTPS  неопходан';
$string['insecurealgorithmwarning'] = 'Изгледа да HTTPS сертификат користи небезбедан алгоритам за потписивање (SHA-1). Молимо покушајте да ажурирате сертификат.';
$string['invalidcertificatechainwarning'] = 'Чини се да је ланац сертификата неисправан. Овај сертификат може да функционише за веб читач али не и за мобилну апликацију.';
$string['invalidcertificateexpiredatewarning'] = 'Изгледа да је HTTPS сертификат за сајт истекао.';
$string['invalidcertificatestartdatewarning'] = 'Изгледа да HTTPS сертификат за сајт још није валидан (са почетним датумом у будућности).';
$string['invalidprivatetoken'] = 'Неисправан токен. Токен не сме да буде празан или прослеђен помоћу параметра GET.';
$string['invaliduserquotawarning'] = 'Корисничка квота (ограничење простор на диску) је подешена на неисправан број. Треба је подесити на исправну (целобројну) вредност у безбедносним подешавањима сајта.';
$string['iosappid'] = 'Јединствени идентификатор iOS апликације';
$string['iosappid_desc'] = 'Можете ово подешавање оставити као подразумевано, осим ако имате прилагођену iOS апликацију.';
$string['launchviasiteinbrowser'] = 'Покрени путем сајта у системском веб читачу';
$string['loginintheapp'] = 'Преко апликације';
$string['logininthebrowser'] = 'Преко прозора веб читача (за SSO  додатке)';
$string['loginintheembeddedbrowser'] = 'Преко уграђеног веб читача (за SSO додатке)';
$string['logoutconfirmation'] = 'Да ли сте сигурни да желите да се одјавите из мобилне апликације на свим својим мобилним уређајима? Одјављивањем ћете морати поново да унесете своје корисничко име и лозинку у мобилну апликацију на свим уређајима на којима имате инсталирану апликацију.';
$string['mainmenu'] = 'Главни мени';
$string['managefiletypes'] = 'Управљање типовима датотека';
$string['minimumversion'] = 'Ако је наведена верзија апликације (3.8.0 или новија), од свих корисника који користе старију верзију апликације биће затражено да надограде своју апликацију пре него што им се дозволи приступ веб сајту.';
$string['minimumversion_key'] = 'Потребна је минимална верзија апликације';
$string['mobileapp'] = 'Мобилна апликација';
$string['mobileappearance'] = 'Изглед за мобилне уређаје';
$string['mobileappenabled'] = 'Овај сајт је омогућио приступ мобилној апликацији, <br /><a href="{$a}">Преузмите мобилну апликацију</a>.';
$string['mobileappsubscription'] = 'Претплата на Moodle апликацију';
$string['mobileauthentication'] = 'Провера идентитета за мобилне уређаје';
$string['mobilecssurl'] = 'CSS';
$string['mobilefeatures'] = 'Мобилне функције';
$string['mobilenotificationsdisabledwarning'] = 'Слање обавештења на мобилне уређаје није омогућено. Потребно је их је омогућити у \'Подешавања за слање обавештења\'.';
$string['mobilesettings'] = 'Подешавања за мобилне уређаје';
$string['moodleappsportalfeatureswarning'] = 'Имајте у виду да неке функције могу бити ограничене, зависно од вашег пакета претплате на Moodle апликацију. За више информација посетите <a href="{$a}" target="_blank">Портал Moodle апликације</a>.';
$string['notifications'] = 'Обавештења';
$string['notificationsactivedevices'] = 'Активни уређаји';
$string['notificationscurrentactivedevices'] = 'Уређаји који примају обавештења овог месеца';
$string['notificationsignorednotifications'] = 'Обавештења нису послата';
$string['notificationslimitreached'] = 'Прекорачено је месечно ограничење броја активних корисничких уређаја. Обавештења за неке кориснике неће бити послата. Препоручује се да надоградите свој план коришћења апликације на  <a href="{$a}" target="_blank">Порталу Moodle апликације</a>.';
$string['notificationsmissingwarning'] = 'Није могуће преузети статистичке податке о обавештењима Moodle апликацији. То је највероватније зато што обавештења за мобилне уређаје још увек нису омогућена на сајту. Можете их омогућити у Администрација сајта / Слање порука / Мобилни уређаји';
$string['notificationsnewdevices'] = 'Нови уређаји';
$string['notificationsseemore'] = 'Напомена: статистика коришћења Moodle апликације не израчунава се у реалном времену. Да бисте приступили детаљнијој статистици, укључујући податке из претходних месеци, пријавите се на <a href="{$a}" target="_blank">Портал Moodle апликације</a>.';
$string['notificationssentnotifications'] = 'Обавештења послата';
$string['oauth2identityproviders'] = 'OAuth 2 даваоци идентитета';
$string['offlineuse'] = 'Офлајн коришћење';
$string['pluginname'] = 'Алати Moodle апликације';
$string['pluginnotenabledorconfigured'] = 'Додатак није омогућен или подешен.';
$string['privacy:metadata:core_userkey'] = 'Кориснички кључеви који се користе за креирање кључа за аутоматско пријављивање за текућег корисника.';
$string['privacy:metadata:preference:tool_mobile_autologin_request_last'] = 'Датум последњег захтева за кључ за аутоматско пријављивање. Између сваког захтева потребно је 6 минута.';
$string['qrcodedisabled'] = 'Приступ путем QR кôда онемогућен';
$string['qrcodeformobileappaccess'] = 'QR кôд за приступ путем мобилне апликације';
$string['qrcodeformobileapploginabout'] = 'Скенирајте QR кôд својом мобилном апликацијом и аутоматски ћете бити пријављени на систем. QR кôд истиче за {$a}.';
$string['qrcodeformobileappurlabout'] = 'Скенирајте QR кôд својом мобилном апликацијом како бисте унели URL адресу у своју апликацији.';
$string['qrcodetype'] = 'Приступ путем QR кôда';
$string['qrcodetype_desc'] = 'Може се обезбедити QR кôд за кориснике мобилне апликације који ће га скенирати. Ово се може користити за попуњавање URL адресе сајта, или тамо где је веб сајт заштићен HTTPS протоколом, како би корисници аутоматски били пријављени, без потребе да унесу корисничко име и лозинку.';
$string['qrcodetypelogin'] = 'QR кôд са аутоматском пријавом';
$string['qrcodetypeurl'] = 'QR кôд са URL адресом сајта';
$string['qrkeyttl'] = 'Трајање кључа за QR провере идентитета';
$string['qrkeyttl_desc'] = 'Временски период за који QR кôд за аутоматску пријаву важи.';
$string['qrsameipcheck'] = 'Провера исте IP адресе приликом QR провере идентитета';
$string['qrsameipcheck_desc'] = 'Да ли корисници морају да користе исту мрежу за генерисање и скенирање QR кôда за пријаву. Онемогућите подешавање само ако корисници пријаве проблеме са пријавом помоћу QR кôда.';
$string['qrsiteadminsnotallowed'] = 'Из безбедносних разлога пријава на систем путем QR кôда није дозвољена за администраторе сајта или ако сте пријављени као други корисник.';
$string['readingthisemailgettheapp'] = 'Да ли ово читате у е-поруци? <a href="{$a}">Преузмите мобилну апликацију и примајте обавештења на свом мобилном уређају</a>.';
$string['remoteaddons'] = 'Удаљени додаци';
$string['responsivemainmenuitems'] = 'Прилагодљиве ставке менија';
$string['scanqrcode'] = 'Скенирај QR кôд';
$string['selfsignedoruntrustedcertificatewarning'] = 'Чини се да је HTTPS сертификат самопотписан или није поуздан. Мобилна апликација ће радити само са поузданим сајтовима. Користите било који онлајн SSL сервис за проверу како бисте дијагностиковали проблем. Уколико провера покаже да је ваш сертификат у реду, можете занемарити ово упозорење.';
$string['setuplink'] = 'Страница за преузимање апликације';
$string['setuplink_desc'] = 'URL адреса странице са линковима за преузимање мобилне апликације са App Store и Google Play. Линк за преузимање апликације се приказује у подножју странице и на корисничком профилу. Оставите празно да се не би приказивао линк.';
$string['smartappbanners'] = 'Банери апликација';
$string['subscription'] = 'Претплата';
$string['subscriptioncreated'] = 'Датум почетка';
$string['subscriptionerrorrequest'] = 'Дошло је до неочекиване грешке при покушају преузимања ваших података о претплати на Moodle апликацију.';
$string['subscriptionexpiration'] = 'Датум истека';
$string['subscriptionfeaturenotapplied'] = 'Ова функција је конфигурисана на вашем сајту, али није укључена у ваш пакет за коришћења Moodle апликације. Стога подешавање неће имати ефекта.';
$string['subscriptionfeatures'] = 'Функције претплате';
$string['subscriptionlimitsurpassed'] = 'Ограничење претплате је премашено';
$string['subscriptionregister'] = 'За више информација о различитим пакетима за коришћење апликације, као и за приступ статистици о коришћењу Moodle апликације, посетите <a href="{$a}" target="_blank">Портал Moodle апликације</a>.';
$string['subscriptionsseemore'] = 'Напомена: Приказане информације се не ажурирају у реалном времену. Можда ћете морати да се одјавите и поново пријавите како бисте видели промене. За информације о промени вашег пакета за коришћење апликације, пријавите се на <a href="{$a}" target="_blank">Портал Moodle апликације</a>.';
$string['switchaccount'] = 'Промени налог';
$string['typeoflogin'] = 'Тип пријаве на систем';
$string['typeoflogin_desc'] = 'Ако сајт користи SSO метод провере идентитета онда изаберите опцију \'преко прозора веб читача\' или \'преко уграђеног веб читача\'. Уграђени веб читач пружа боље корисничко искуство, мада не функционише са свим SSO додацима.';
$string['viewqrcode'] = 'Погледајте QR кôд';
