<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'cs', version '4.3'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Proces zálohování byl dokončen';
$string['asyncbackupcompletebutton'] = 'Pokračovat';
$string['asyncbackupcompletedetail'] = 'Proces zálohování byl úspěšně dokončen. <br/>Zálohu můžete otevřít na stránce <a href="{$a}"> obnovit. </a>';
$string['asyncbackuperror'] = 'Proces zálohování selhal';
$string['asyncbackuperrordetail'] = 'Proces zálohování selhal. Obraťte se na správce systému.';
$string['asyncbackuppending'] = 'Proces zálohování čeká na vyřízení';
$string['asyncbackupprocessing'] = 'Probíhá zálohování';
$string['asyncbadexecution'] = 'Špatné provedení ovladače záloh. Je {$a}, mělo by být 2';
$string['asynccheckprogress'] = 'Průběh můžete kdykoliv zkontrolovat na  <a href="{$a}"> obnova stránky. </a>';
$string['asyncemailenable'] = 'Povolit Oznámení';
$string['asyncemailenabledetail'] = 'Je-li tato možnost povolena, uživatelé obdrží oznámení o dokončení asynchronního zálohování nebo obnovy.';
$string['asyncgeneralsettings'] = 'Asynchronní zálohování/obnovení';
$string['asyncmessagebody'] = 'Oznámení';
$string['asyncmessagebodydefault'] = 'Vaše {operation} (ID: {backupid}) byla úspěšně dokončena! <br/> <br/> Můžete si ji prohlédnout zde: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Oznámení, které se má odeslat po dokončení asynchronního zálohování nebo obnovení.';
$string['asyncmessagesubject'] = 'Předmět';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} úspěšně dokončena';
$string['asyncmessagesubjectdetail'] = 'Předmět oznámení';
$string['asyncnowait'] = 'Nemusíte tady čekat, proces bude pokračovat na pozadí.';
$string['asyncprocesspending'] = 'Čeká na vyřízení';
$string['asyncrestorecomplete'] = 'Proces obnovení byl dokončen';
$string['asyncrestorecompletebutton'] = 'Pokračovat';
$string['asyncrestorecompletedetail'] = 'Proces obnovení byl úspěšně dokončen. Kliknutím na tlačítko Pokračovat přejdete na <a href="{$a}"> kurz pro obnovenou položku. </a>';
$string['asyncrestoreerror'] = 'Proces obnovení se nezdařil';
$string['asyncrestoreerrordetail'] = 'Proces obnovení se nezdařil. Obraťte se na správce systému.';
$string['asyncrestoreinprogress'] = 'Obnovuje se';
$string['asyncrestoreinprogress_help'] = 'Asynchronní obnova kurzu právě probíhá a průběh je zobrazen zde.';
$string['asyncrestorepending'] = 'Proces obnovení čeká na vyřízení';
$string['asyncrestoreprocessing'] = 'Probíhá obnovení';
$string['asyncreturn'] = 'Návrat do kurzu';
$string['autoactivedescription'] = 'Zda se má povolit automatické zálohování. Je-li vybrána možnost "Ručně", mohou být automatické zálohy provedeny pouze příslušným CLI skriptem. Ten se dá spouštět buď ručně nebo pomocí naplánované úlohy (cron) na serveru.';
$string['autoactivedisabled'] = 'Zakázáno';
$string['autoactiveenabled'] = 'Povoleno';
$string['autoactivemanual'] = 'Ručně';
$string['automatedbackupschedule'] = 'Časový plán';
$string['automatedbackupschedulehelp'] = 'Zvolte, ve kterých dnech v týdnu se má provádět automatické zálohování';
$string['automatedbackupsinactive'] = 'Automatické zálohy nebyly správcem systému povoleny';
$string['automatedbackupstatus'] = 'Stav automatických záloh';
$string['automateddeletedays'] = 'Odstranit zálohy starší než';
$string['automatedmaxkept'] = 'Maximální počet uchováváných záloh';
$string['automatedmaxkepthelp'] = 'Určuje maximální počet posledních automatizovaných záloh, které mají být uchovávány pro každý kurz. Starší zálohy budou automaticky smazány.';
$string['automatedminkept'] = 'Minimální počet uchováváných záloh';
$string['automatedminkepthelp'] = '';
$string['automatedsettings'] = 'Nastavení automatických záloh';
$string['automatedsetup'] = 'Nastavení automatických záloh';
$string['automatedstorage'] = 'Úložiště automatických záloh';
$string['automatedstoragehelp'] = 'Zvolte umístění, kam chcete zálohy ukládat poté, co jsou automaticky vytvořeny.';
$string['backupactivity'] = 'Zálohování činnosti: {$a}';
$string['backupautoactivitiesdescription'] = 'Nastaví výchozí nastavení pro zahrnutí aktivit do zálohy. Aby odpadkový koš fungoval, musí být toto nastavení povoleno.';
$string['backupcourse'] = 'Zálohování kurzu: {$a}';
$string['backupcoursedetails'] = 'Podrobnosti kurzu';
$string['backupcoursesection'] = 'Sekce: {$a}';
$string['backupcoursesections'] = 'Sekce kurzu';
$string['backupdate'] = 'Datum pořízení';
$string['backupdetails'] = 'Podrobnosti zálohy';
$string['backupdetailsnonstandardinfo'] = 'Vybraný soubor nemá standardní 2.x formát MBZ. Proces obnovy se jej nejprve pokusí na stadardní formát převést a teprve poté obnovit.';
$string['backupformat'] = 'Formát';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Neznámý formát';
$string['backuplog'] = 'Technické informace a varování';
$string['backupmode'] = 'Režim';
$string['backupmode10'] = 'Obecné';
$string['backupmode20'] = 'Import';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Ze stejného serveru';
$string['backupmode50'] = 'Automatizovaný';
$string['backupmode60'] = 'Konvertován';
$string['backupmode70'] = 'Asynchronní';
$string['backupsection'] = 'Zálohování sekce kurzu: {$a}';
$string['backupsettings'] = 'Nastavení zálohování';
$string['backupsitedetails'] = 'Informace o stránkách';
$string['backupstage16action'] = 'Pokračovat';
$string['backupstage1action'] = 'Další';
$string['backupstage2action'] = 'Další';
$string['backupstage4action'] = 'Provést zálohu';
$string['backupstage8action'] = 'Pokračovat';
$string['backuptype'] = 'Typ';
$string['backuptypeactivity'] = 'Činnost';
$string['backuptypecourse'] = 'Kurz';
$string['backuptypesection'] = 'Sekce';
$string['backupversion'] = 'Verze zálohy';
$string['cannotfindassignablerole'] = 'Záloha obsahuje roli {$a}, kterou nelze namapovat na žádnou z rolí, kterou jste oprávnění přiřazovat.';
$string['choosefilefromactivitybackup'] = 'Oblast se zálohami činností';
$string['choosefilefromactivitybackup_help'] = 'Zálohy Aktivit vytvořené při použití výchozího nastavení jsou uloženy zde.';
$string['choosefilefromautomatedbackup'] = 'Automatické zálohování';
$string['choosefilefromautomatedbackup_help'] = 'Obsahuje automaticky generované zálohy.';
$string['choosefilefromcoursebackup'] = 'Oblast se zálohami kurzů';
$string['choosefilefromcoursebackup_help'] = 'Zálohy kurzu vytvořené při použití výchozího nastavení jsou uloženy zde.';
$string['choosefilefromuserbackup'] = 'Oblast pro soukromé zálohy kurzů';
$string['choosefilefromuserbackup_help'] = 'Soubory záloh vytvořené s anonymizovanými uživateli jsou uloženy zde.';
$string['config_keep_groups_and_groupings'] = 'Ve výchozím nastavení zachovat stávající studijní skupiny a seskupení.';
$string['config_keep_roles_and_enrolments'] = 'Ve výchozím nastavení zachovat stávající role a zápisy.';
$string['config_overwrite_conf'] = 'Umožňuje uživateli přepsat aktuální konfiguraci kurzu';
$string['config_overwrite_course_fullname'] = 'Ve výchozím nastavení přepsat celé jméno kurzu jménem ze záložního souboru. To vyžaduje oprávnění  „Přepsat konfiguraci kurzu“, které mají být kontrolovány a aktuální uživatel musí mít možnost měnit celé jméno kurzu (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Ve výchozím nastavení přepsat krátké jméno kurzu jménem ze záložního souboru. To vyžaduje oprávnění „Přepsat konfiguraci kurzu“, které mají být kontrolovány a aktuální uživatel musí mít možnost měnit krátké jméno kurzu (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Ve výchozím nastavení přepsat datum zahájení kurzu datem ze záložního souboru. To vyžaduje oprávnění „Přepsat konfiguraci kurzu“, které mají být kontrolovány a aktuální uživatel musí mít možnost zapsat datum  do obnoveného kurzu (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Nastavení výchozí hodnoty pro zahrnování činností do záloh';
$string['configgeneralanonymize'] = 'Zda ve výchozím nastavení anonymizovat veškeré údaje týkající se uživatelů';
$string['configgeneralbadges'] = 'Nastavení výchozí hodnoty pro zahrnování  odznaků do záloh.';
$string['configgeneralblocks'] = 'Nastavení výchozí hodnoty pro zahrnování postranních bloků do záloh';
$string['configgeneralcalendarevents'] = 'Nastavení výchozí hodnoty pro zahrnování  událostí kalendáře do záloh.';
$string['configgeneralcomments'] = 'Nastavení výchozí hodnoty pro zahrnování komentářů do záloh';
$string['configgeneralcompetencies'] = 'Nastavení výchozí hodnoty pro zahrnování  kompetencí do záloh.';
$string['configgeneralcontentbankcontent'] = 'Nastavit výchozí nastavení pro zahrnutí obsahu banky obsahu do zálohy.';
$string['configgeneralfiles'] = 'Nastaví výchozí nastavení pro zahrnutí souborů do zálohy. Poznámka: Zákaz tohoto nastavení bude mít za následek zálohu, která zahrnuje pouze odkazy na soubory. To není problém, pokud je záloha obnovena na stejném webu a soubory nebyly odstraněny nastavením „Vysypat koš“ (filescleanupperiod).';
$string['configgeneralfilters'] = 'Nastavení výchozí hodnoty pro zahrnování filtrů do záloh';
$string['configgeneralgroups'] = 'Výchozí  nastaví pro začlenění skupin a seskupení do zálohy.';
$string['configgeneralhistories'] = 'Nastavení výchozí hodnoty pro zahrnování uživatelské historie do záloh';
$string['configgenerallogs'] = 'Zda do záloh zahrnovat protokoly';
$string['configgeneralpermissions'] = 'Pokud je povoleno, budou importována oprávnění role. To může přepsat stávající oprávnění pro registrované uživatele.';
$string['configgeneralquestionbank'] = 'Zda do záloh zahrnovat banku úloh. POZNÁMKA: Vypnutím tohoto nastavení se vypne zálohování činností, které využívají banku úloh, jako je test.';
$string['configgeneralroleassignments'] = 'Zda do záloh zahrnovat přiřazení rolí';
$string['configgeneralusers'] = 'Nastavení výchozí hodnoty pro zahrnování uživatelů do záloh';
$string['configgeneraluserscompletion'] = 'Zda do záloh zahrnovat informace o splnění činností v kurzu';
$string['configgeneralxapistate'] = 'Nastaví výchozí nastavení pro zahrnutí stavu uživatele v obsahu, jako jsou aktivity H5P v záloze.';
$string['configlegacyfiles'] = 'Nastaví výchozí hodnotu pro zahrnutí starších souborů kurzu do zálohy. Starší soubory kurzů pocházejí z verzí Moodle starších než 2.0.';
$string['configloglifetime'] = 'Toto nastavení určuje dobu, po kterou chcete zachovat protokoly o zálohách. Záznamy, které jsou starší než tato doba, jsou automaticky smazány. Doporučujeme ponechat tuto hodnotu nízkou, jelikož tyto protokoly mohou zabrat značné množství místa.';
$string['configrestoreactivities'] = 'Nastavit výchozí nastavení pro obnovení činnosti.';
$string['configrestorebadges'] = 'Nastavit výchozí nastavení pro obnovení odznaků.';
$string['configrestoreblocks'] = 'Nastavit  výchozí nastavení pro obnovení bloků.';
$string['configrestorecalendarevents'] = 'Nastavit výchozí nastavení pro obnovení událostí kalendáře.';
$string['configrestorecomments'] = 'Nastavit výchozí nastavení pro obnovení komentářů.';
$string['configrestorecompetencies'] = 'Nastavit výchozí nastavení pro obnovení kompetencí.';
$string['configrestorecontentbankcontent'] = 'Nastavit výchozí nastavení pro obnovení obsahu banky obsahu.';
$string['configrestoreenrolments'] = 'Nastavit výchozí nastavení pro obnovení metod zápisu.';
$string['configrestorefilters'] = 'Nastavit výchozí nastavení pro obnovení filtrů.';
$string['configrestoregroups'] = 'V případě, že byly skupiny a seskupení zařazeny do zálohy, nastavit jejich výchozí hodnoty .';
$string['configrestorehistories'] = 'V případě, že byl uživatel zařazen do zálohy, nastavit výchozí hodnoty pro obnovení historie uživatele .';
$string['configrestorelogs'] = 'Je-li povoleno, budou standardně obnoveny protokoly, pokud byly zahrnuty do zálohy.';
$string['configrestorepermissions'] = 'Pokud je povoleno, oprávnění role budou obnovena. To může přepsat stávající oprávnění pro registrované uživatele.';
$string['configrestoreroleassignments'] = 'Je-li povoleno, bude standardně obnoveno přiřazení rolí, pokud bylo zahrnuto do zálohy.';
$string['configrestoreusers'] = 'Určí výchozí hodnoty nastavení obnovy uživatelů, pokud byli zahrnuty do zálohy.';
$string['configrestoreuserscompletion'] = 'Je-li povoleno, budou standardně obnoveny údaje plnění a absolvování uživatelů, pokud byly zahrnuty do zálohy.';
$string['configrestorexapistate'] = 'Nastaví výchozí hodnotu pro obnovení stavu uživatele v obsahu, jako jsou aktivity H5P.';
$string['confirmcancel'] = 'Zrušit zálohování';
$string['confirmcancelimport'] = 'Zrušit import';
$string['confirmcancelno'] = 'Nerušit';
$string['confirmcancelquestion'] = 'Určitě zrušit? Veškeré zadané informace budou ztraceny.';
$string['confirmcancelrestore'] = 'Zrušit obnovení';
$string['confirmcancelyes'] = 'Zrušit zálohu';
$string['confirmnewcoursecontinue'] = 'Upozornění na nový kurz';
$string['confirmnewcoursecontinuequestion'] = 'V průběhu obnovy bude vytvořen dočasný kurz a obsah zálohy do něj bude zkopírován. Chcete-li zrušit obnovení klikněte na Zrušit. Při obnovování nezavírejte prohlížeč.';
$string['copiesinprogress'] = 'V tomto kurzu probíhají kopie. <a href="{$a}"> Zobrazit průběh kopírování. </a>';
$string['copycoursedesc'] = 'Tento kurz bude duplikován a zařazen do vybrané kategorie kurzu.';
$string['copycourseheading'] = 'Kopírovat kurz';
$string['copycoursetitle'] = 'Kopírovat kurz: {$a}';
$string['copydest'] = 'Cíl';
$string['copyfieldnotfound'] = 'Nebyla nalezena požadovaná data pro pole: {$a}';
$string['copyformfail'] = 'AJAX odeslání formuláře kopie kurzu se nezdařilo.';
$string['copyingcourse'] = 'Probíhá kopírování kurzu';
$string['copyingcourseshortname'] = 'kopírování';
$string['copyop'] = 'Aktuální operace';
$string['copyprogressheading'] = 'Probíhá kopírování kurzu';
$string['copyprogressheading_help'] = 'Tato tabulka ukazuje stav všech vašich nedokončených kopií kurzu.';
$string['copyprogresstitle'] = 'Průběh kopírování kurzu';
$string['copyreturn'] = 'Zkopírovat a zpět';
$string['copysource'] = 'Zdroj';
$string['copyview'] = 'Zkopírovat a zobrazit';
$string['coursecategory'] = 'Kategorie, do které bude kurz obnoven';
$string['courseid'] = 'Původní ID';
$string['coursesettings'] = 'Nastavení kurzu';
$string['coursetitle'] = 'Název';
$string['currentstage1'] = 'Počáteční nastavení';
$string['currentstage16'] = 'Dokončení';
$string['currentstage2'] = 'Nastavení schématu';
$string['currentstage4'] = 'Potvrzení a přehled';
$string['currentstage8'] = 'Provést zálohu';
$string['enableasyncbackup'] = 'Povolit asynchronní zálohy';
$string['enableasyncbackup_help'] = 'Je-li povoleno, budou operace zálohování a obnovy prováděny asynchronně. To poskytuje lepší uživatelskou zkušenost, která uživatelům umožňuje provádět jiné operace během zálohování nebo obnovy.  To nemá vliv na import a export.';
$string['enterasearch'] = 'Vložte vyhledávací dotaz';
$string['error_block_for_module_not_found'] = 'Nalezena osamocená instance bloku (id: {$a->bid}) modulu kurzu (id: {$a->mid}) . Tento blok nebude zálohován';
$string['error_course_module_not_found'] = 'Nalezen osamocený modul kurzu (id: {$a}) . Tento modul nebude zálohován.';
$string['errorcopyingbackupfile'] = 'Před obnovením se nepodařilo zkopírovat záložní soubor do dočasné složky.';
$string['errorfilenamemustbezip'] = 'Soubor, jehož název vkládáte, musí být ZIP soubor a musí mít příponu .mbz';
$string['errorfilenamerequired'] = 'Musíte zadat platný název souboru pro tuto zálohu';
$string['errorfilenametoolong'] = 'Název souboru musí mít délku menší než 255 znaků.';
$string['errorinvalidformat'] = 'Neznámý formát zálohy';
$string['errorinvalidformatinfo'] = 'Vybraný soubor nemá standardní 2.x formát MBZ a nemůže být obnoven.';
$string['errorminbackup20version'] = 'Tento záložní soubor byl vytvořen ve vývojové verzi zálohování Moodle ({$a->backup}). Minimální požadovaná verze je {$a->min}. Nemůže být obnoven.';
$string['errorrestorefrontpagebackup'] = 'Na titulní stránce můžete obnovit pouze zálohu titulní stránky.';
$string['executionsuccess'] = 'Soubor zálohy byl úspěšně vytvořen.';
$string['extractingbackupfileto'] = 'Extrahování záložního souboru do: {$a}';
$string['failed'] = 'Záloha se nezdařila';
$string['filealiasesrestorefailures'] = 'Selhání obnovy zástupců.';
$string['filealiasesrestorefailures_help'] = 'Zástupci jsou symbolické odkazy na jiné soubory, včetně těch uložených v externích úložištích. V některých případech je Moodle nedokáže obnovit – například při obnově zálohy na jiném serveru, nebo pokud je odkazovaný soubor neexistuje.

Další podrobnosti a aktuální důvod selhání lze nalézt v protokolu obnovy.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Některé zástupce zahrnuté v souboru zálohy nelze obnovit. Následující seznam obsahuje jejich očekávané umístění a zdrojový soubor odkazující na původní místo.';
$string['filename'] = 'Název souboru';
$string['filereferencesincluded'] = 'Záloha obsahuje zástupce externích souborů. Na jiných serverech nemusí být někteří zástupci obnovitelní.';
$string['filereferencesnotsamesite'] = 'Záloha je z jiného serveru, některé odkazy na soubory nebylo možno obnovit.';
$string['filereferencessamesite'] = 'Záloha je ze stejného serveru, ale některé odkazy na soubory nebylo možno ani přesto obnovit.';
$string['generalactivities'] = 'Zahrnout moduly činností nebo studijní materiály';
$string['generalanonymize'] = 'Anonymizovat informace';
$string['generalbackdefaults'] = 'Obecné výchozí nastavení zálohování';
$string['generalbadges'] = 'Zahrnout odznaky';
$string['generalblocks'] = 'Zahrnout bloky';
$string['generalcalendarevents'] = 'Zahrnout události z kalendáře';
$string['generalcomments'] = 'Zahrnout komentáře';
$string['generalcompetencies'] = 'Zahrnout kompetence';
$string['generalcontentbankcontent'] = 'Zahrnout obsah banky obsahu';
$string['generalenrolments'] = 'Zahrnout metody zápisu';
$string['generalfiles'] = 'Zahrnout soubory';
$string['generalfilters'] = 'Zahrnout filtry';
$string['generalgradehistories'] = 'Zahrnout historii';
$string['generalgroups'] = 'Zahrnout skupiny a seskupení';
$string['generalhistories'] = 'Zahrnout historii';
$string['generallegacyfiles'] = 'Zahrnout staré soubory kurzů';
$string['generallogs'] = 'Zahrnout protokoly';
$string['generalpermissions'] = 'Zahrnout přepsaná oprávnění';
$string['generalquestionbank'] = 'Zahrnout banku úloh';
$string['generalrestoredefaults'] = 'Obecné výchozí nastavení obnovy';
$string['generalrestoresettings'] = 'Obecné obnovení nastavení';
$string['generalroleassignments'] = 'Zahrnout přidělení rolí';
$string['generalsettings'] = 'Obecná nastavení zálohování';
$string['generalusers'] = 'Zahrnout uživatele';
$string['generaluserscompletion'] = 'Zahrnout informaci o splnění činností v kurzu';
$string['generalxapistate'] = 'Zahrnout stav uživatele v obsahu, jako jsou aktivity H5P';
$string['hidetypes'] = 'Skrýt volby typů modulů';
$string['importbackupstage16action'] = 'Pokračovat';
$string['importbackupstage1action'] = 'Další';
$string['importbackupstage2action'] = 'Další';
$string['importbackupstage4action'] = 'Provést import';
$string['importbackupstage8action'] = 'Pokračovat';
$string['importcurrentstage0'] = 'Výběr kurzu';
$string['importcurrentstage1'] = 'Počáteční nastavení';
$string['importcurrentstage16'] = 'Dokončit';
$string['importcurrentstage2'] = 'Nastavení schématu';
$string['importcurrentstage4'] = 'Potvrzení a přehled';
$string['importcurrentstage8'] = 'Provést import';
$string['importfile'] = 'Importovat soubor zálohy';
$string['importgeneralduplicateadminallowed'] = 'Umožnit správci řešení konfliktů';
$string['importgeneralduplicateadminallowed_desc'] = 'Pokud je na instalaci účet s uživatelským jménem "admin" a správce se snaží obnovit záložní soubor obsahující účet s uživatelským jménem "admin" může to způsobit konflikt. Je-li toto nastavení povoleno, bude konflikt vyřešen změnou uživatelského jména v záložním souboru na "admin_xyz".';
$string['importgeneralmaxresults'] = 'Maximum kurzů zobrazených pro import';
$string['importgeneralmaxresults_desc'] = 'Určuje počet kurzů, které jsou zobrazeny v prvním kroku procesu importu';
$string['importgeneralsettings'] = 'Výchozí hodnoty importu';
$string['importrootsettings'] = 'Nastavení importu';
$string['importsettings'] = 'Obecné nastavení importu';
$string['importsuccess'] = 'Import je kompletní. Pro návrat do kurzu klikněte na pokračovat.';
$string['includeactivities'] = 'Zahrnout:';
$string['includeditems'] = 'Zahrnuté položky:';
$string['includefilereferences'] = 'Zástupci externích souborů';
$string['includesection'] = 'Sekce {$a}';
$string['includeuserinfo'] = 'Uživatelská data';
$string['inprogress'] = 'Probíhá zálohování';
$string['jumptofinalstep'] = 'Přejít na poslední krok';
$string['keep'] = 'Ponechat';
$string['keptroles'] = 'Zahrnout zápisy rolí';
$string['keptroles_help'] = 'Uživatelé s vybranými rolemi budou zařazeni do nového kurzu. Pokud není povolena možnost „Zahrnout uživatelská data“, nebudou žádná uživatelská data zkopírována.';
$string['locked'] = 'Zamčeno';
$string['lockedbyconfig'] = 'Toto nastavení bylo zamčeno výchozím nastavením zálohování';
$string['lockedbyhierarchy'] = 'Zamčeno kvůli závislostem';
$string['lockedbypermission'] = 'Nemáte dostatečná oprávnění pro změnu tohoto nastavení';
$string['loglifetime'] = 'Uchovat protokoly';
$string['managefiles'] = 'Správa záložních souborů';
$string['mergerestoredefaults'] = 'Při sloučení do jiného kurzu, obnovit výchozí nastavení';
$string['missingfilesinpool'] = 'Některé soubory nemohly být během zálohování uloženy, nebude je možné obnovit.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Verze Moodle';
$string['morecoursesearchresults'] = 'Nalezeno více než {$a} kurzů, zobrazit prvních {$a} výsledků';
$string['moreresults'] = 'Příliš mnoho výsledků, zadejte přesnější vyhledávání.';
$string['nomatchingcourses'] = 'Žádné kurzy k zobrazení';
$string['norestoreoptions'] = 'Žádné kategorie nebo stávající kurzy, do kterých by bylo možno obnovit.';
$string['originalwwwroot'] = 'URL zálohy';
$string['overwrite'] = 'Přepsat';
$string['pendingasyncdeletedetail'] = 'Tento kurz má čekající asynchronní zálohu. <br/> Kurzy nelze smazat, dokud tato záloha nedokončí.';
$string['pendingasyncdetail'] = 'Asynchronní zálohy umožňují uživateli mít pouze jednu nevyřízenou zálohu zdroje. <br/> Asynchronní zálohy stejného zdroje nemohou být zařazeny do fronty, což by pravděpodobně vedlo k více zálohám se stejným obsahem.';
$string['pendingasyncedit'] = 'Pro tento kurz je vyžadována nevyřízená záloha nebo kopie. Tento kurz neupravujte, dokud nebude dokončeno.';
$string['pendingasyncerror'] = 'Čeká se na dokončení zálohy';
$string['preparingdata'] = 'Příprava dat';
$string['preparingui'] = 'Příprava zobrazení stránky';
$string['previousstage'] = 'Předchozí';
$string['privacy:metadata:backup:detailsofarchive'] = 'Tento archiv může obsahovat různé uživatelské údaje týkající se kurzu, jako jsou známky, zápisy uživatelů a údaje o činnostech.';
$string['privacy:metadata:backup:externalpurpose'] = 'Účelem tohoto archivu je ukládat informace týkající se kurzu, který může být v budoucnu obnoven.';
$string['privacy:metadata:backup_controllers'] = 'Seznam operací zálohování';
$string['privacy:metadata:backup_controllers:itemid'] = 'ID kurzu';
$string['privacy:metadata:backup_controllers:operation'] = 'Operace, která byla provedena, např. obnova.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Čas vytvoření akce';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Čas úpravy akce';
$string['privacy:metadata:backup_controllers:type'] = 'Typ položky, na které se pracuje, např. aktivita.';
$string['qcategory2coursefallback'] = 'Kategorie testových úloh "{$a->name}", původně umístěna v systémovém kontextu nebo v kontextu kategorie kurzů, bude v průběhu obnovy vytvořena v kontextu kurzu.';
$string['qcategorycannotberestored'] = 'Kategorie testových úloh "{$a->name}" nemůže být v průběhu obnovy vytvořena';
$string['question2coursefallback'] = 'Kategorie testových úloh "{$a->name}", původně umístěna v systémovém kontextu nebo v kontextu kategorie kurzů, bude v průběhu obnovy vytvořena v kontextu kurzu.';
$string['questioncannotberestored'] = 'Úlohy "{$a->name}" nemohou být při obnově vytvořeny';
$string['recyclebin_desc'] = 'Tato nastavení budou použita také pro koš.';
$string['replacerestoredefaults'] = 'Při obnovování kurzu do jiného kurzu s mazáním obsahu, obnovit výchozí hodnoty';
$string['restoreactivity'] = 'Obnova modulu činnosti';
$string['restorecourse'] = 'Obnova kurzu';
$string['restorecoursesettings'] = 'Nastavení kurzu';
$string['restoredcourseid'] = 'Obnovený kurz ID: {$a}';
$string['restoreexecutionsuccess'] = 'Kurz byl úspěšně obnoven.';
$string['restorefileweremissing'] = 'Některé soubory nelze obnovit, protože chyběly v záloze.';
$string['restorenewcoursefullname'] = 'Nové jméno kurzu';
$string['restorenewcourseshortname'] = 'Nové krátké jméno kurzu';
$string['restorenewcoursestartdate'] = 'Nové datum začátku kurzu';
$string['restorerolemappings'] = 'Obnova mapování rolí';
$string['restorerootsettings'] = 'Obnova nastavení';
$string['restoresection'] = 'Obnova sekcí';
$string['restorestage1'] = 'Potvrdit';
$string['restorestage16'] = 'Přehled';
$string['restorestage16action'] = 'Provést obnovu';
$string['restorestage1action'] = 'Další';
$string['restorestage2'] = 'Místo obnovy';
$string['restorestage2action'] = 'Další';
$string['restorestage32'] = 'Provést obnovu';
$string['restorestage32action'] = 'Pokračovat';
$string['restorestage4'] = 'Nastavení';
$string['restorestage4action'] = 'Další';
$string['restorestage64'] = 'Dokončení';
$string['restorestage64action'] = 'Pokračovat';
$string['restorestage8'] = 'Schéma';
$string['restorestage8action'] = 'Další';
$string['restoretarget'] = 'Cíl obnovy';
$string['restoretocourse'] = 'Obnovit do kurzu:';
$string['restoretocurrentcourse'] = 'Obnovit do tohoto kurzu';
$string['restoretocurrentcourseadding'] = 'Začlenit zálohovaný kurz do tohoto kurzu';
$string['restoretocurrentcoursedeleting'] = 'Odstranit obsah tohoto kurzu a poté obnovit';
$string['restoretoexistingcourse'] = 'Obnovit do stávajícího kurzu';
$string['restoretoexistingcourseadding'] = 'Začlenit zálohovaný kurz do stávajícího kurzu';
$string['restoretoexistingcoursedeleting'] = 'Odstranit obsah stávajícího kurzu a poté obnovit';
$string['restoretonewcourse'] = 'Obnovit jako nový kurz';
$string['restoringcourse'] = 'Probíhá obnova kurzu';
$string['restoringcourseshortname'] = 'obnovování';
$string['rootenrolmanual'] = 'Obnovit jako ruční zápis do kurzu';
$string['rootsettingactivities'] = 'Zahrnout moduly činností nebo studijní materiály';
$string['rootsettinganonymize'] = 'Anonymizovat uživatelská data';
$string['rootsettingbadges'] = 'Zahrnout odznaky';
$string['rootsettingblocks'] = 'Zahrnout bloky';
$string['rootsettingcalendarevents'] = 'Zahrnout události kalendáře';
$string['rootsettingcomments'] = 'Zahrnout komentáře';
$string['rootsettingcompetencies'] = 'Zahrnout kompetence';
$string['rootsettingcontentbankcontent'] = 'Zahrnout obsah banky obsahu';
$string['rootsettingcustomfield'] = 'Zahrnout vlastní pole';
$string['rootsettingenrolments'] = 'Zahrňte metody zápisu';
$string['rootsettingenrolments_always'] = 'Ano, vždy';
$string['rootsettingenrolments_never'] = 'Ne, obnovit uživatele jako ruční zápis';
$string['rootsettingenrolments_withusers'] = 'Ano, ale pouze v případě, že jsou zahrnuti uživatelé';
$string['rootsettingfiles'] = 'Zahrnout soubory';
$string['rootsettingfilters'] = 'Zahrnout filtry';
$string['rootsettinggradehistories'] = 'Zahrnout historii známkování';
$string['rootsettinggroups'] = 'Zahrnout skupiny a seskupení';
$string['rootsettingimscc1'] = 'Převést na IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Převést na IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Zahrnout staré soubory kurzů';
$string['rootsettinglogs'] = 'Zahrnout protokoly o činnosti v kurzu';
$string['rootsettingpermissions'] = 'Zahrnout přepsaná oprávnění';
$string['rootsettingquestionbank'] = 'Zahrnout banku úloh';
$string['rootsettingroleassignments'] = 'Zahrnout přidělení rolí';
$string['rootsettings'] = 'Nastavení zálohy';
$string['rootsettingusers'] = 'Zahrnout zapsané uživatele';
$string['rootsettinguserscompletion'] = 'Zahrnout podrobnosti o splnění činností v kurzu';
$string['rootsettingxapistate'] = 'Zahrnout stav uživatele v obsahu, jako jsou aktivity H5P';
$string['samesitenotification'] = 'Tato záloha byla vytvořena pouze s odkazy na soubory, nikoli se samotnými soubory. Obnovení bude fungovat pouze na tomto webu.';
$string['sectionactivities'] = 'Činnosti';
$string['sectioninc'] = 'Zahrnuto v záloze bez dat uživatelů';
$string['sectionincanduser'] = 'Zahrnuto v záloze včetně dat uživatlů';
$string['selectacategory'] = 'Vyberte kategorii';
$string['selectacourse'] = 'Vyberte kurz';
$string['setting_course_fullname'] = 'Název kurzu';
$string['setting_course_shortname'] = 'Krátký název kurzu';
$string['setting_course_startdate'] = 'Začátek kurzu';
$string['setting_keep_groups_and_groupings'] = 'Zachovat aktuální skupiny a sestupení';
$string['setting_keep_roles_and_enrolments'] = 'Zachovat aktuální role a zápisy';
$string['setting_overwrite_conf'] = 'Přepsat konfiguraci kurzu';
$string['setting_overwrite_course_fullname'] = 'Přepsat celý název kurzu';
$string['setting_overwrite_course_shortname'] = 'Přepsat krátký název kurzu';
$string['setting_overwrite_course_startdate'] = 'Přepsat datum zahájení kurzu';
$string['showtypes'] = 'Zobrazit volby typů modulů';
$string['sitecourseformatwarning'] = 'Toto je záloha titulní stránky, tato záloha může být obnovena pouze na titulní stránce.';
$string['skiphidden'] = 'Přeskočit skryté kurzy';
$string['skiphiddenhelp'] = 'Vyberte, zda chcete přeskočit skryté kurzy';
$string['skipmodifdays'] = 'Přeskočit kurzy nezměněné od';
$string['skipmodifdayshelp'] = 'Vyberte pro přeskočení kurzů, které nebyly změněny po zadaný počet dnů';
$string['skipmodifprev'] = 'Přeskočit kurzy nezměněné od předchozí zálohy';
$string['skipmodifprevhelp'] = 'Vyberte, zda chcete přeskočit kurzy nezměněné od předchozí zálohy. Vyžaduje přihlášení.';
$string['status'] = 'Stav';
$string['storagecourseandexternal'] = 'Oblast se zálohami kurzů a určený adresář';
$string['storagecourseonly'] = 'Oblast se zálohami kurzů';
$string['storageexternalonly'] = 'Určený adresář pro automatické zálohování';
$string['successful'] = 'Záloha byla úspěšná';
$string['successfulcopy'] = 'Kopírování úspěšné';
$string['successfulrestore'] = 'Obnova byla úspěšná';
$string['timetaken'] = 'Délka pokusu';
$string['title'] = 'Název';
$string['totalcategorysearchresults'] = 'Celkem kategorií: {$a}';
$string['totalcoursesearchresults'] = 'Celkem kurzů: {$a}';
$string['undefinedrolemapping'] = 'Mapování rolí není definováno pro archetyp "{$a}".';
$string['unnamedsection'] = 'Nepojmenovaná sekce';
$string['userdata'] = 'Zahrnout uživatelská data';
$string['userdata_help'] = 'Pokud je povoleno, Pokud je tato možnost povolena, budou data, jako jsou příspěvky na fóru, zadání úkolů atd., Zkopírována do nového kurzu pro všechny uživatele s rolí vybranou v části „Zahrnout zápisy rolí“.';
$string['userinfo'] = 'Informace uživatele';
