<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'cs', version '4.3'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Rozumím a přijímám smlouvu o zpracování údajů';
$string['activityoverview'] = 'Máte nadcházející relace BigBlueButton';
$string['bbbduetimeoverstartingtime'] = 'Čas uzavření této činnosti musí být větší než je čas zahájení';
$string['bbbdurationwarning'] = 'Maximální doba trvání této relace je %duration%  minut';
$string['bbbrecordallfromstartwarning'] = 'Tato relace od začátku se nahrává.';
$string['bbbrecordwarning'] = 'Relace je nahrávána.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Přidat novou BigBlueButton učebnu';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Vytvořit instanci živých relací';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Vytvořit instanci s nahráváním';
$string['bigbluebuttonbn:deleterecordings'] = 'Odstranit nahrávky';
$string['bigbluebuttonbn:importrecordings'] = 'Importovat nahrávky';
$string['bigbluebuttonbn:join'] = 'Připojit k učebně BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Správa nahrávek';
$string['bigbluebuttonbn:protectrecordings'] = 'Chránit nahrávky';
$string['bigbluebuttonbn:publishrecordings'] = 'Publikovat nahrávky';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Zrušit ochranu nahrávek';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Zrušit publikování nahrávek';
$string['bigbluebuttonbn:view'] = 'Zobrazit BigBlueButton učebnu';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Zobrazit všechny formáty nahrávání';
$string['bigbluebuttondisablednotification'] = 'Modul aktivity BigBlueButton byl deaktivován a žádné stávající aktivity kurzu BigBlueButton nejsou v současné době přístupné. Před opětovnou aktivací tohoto pluginu se prosím ujistěte, že jste si přečetli a přijali <a href="{$a}" target="_blank">smlouvu o zpracování dat</a> se společností Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Modul aktivity BigBlueButton je deaktivován.';
$string['cachedef_currentfetch'] = 'Data pro seznam všech nedávno načtených nahrávek.';
$string['cachedef_recordings'] = 'Metadata záznamu';
$string['cachedef_serverinfo'] = 'Informace o vzdáleném serveru';
$string['cachedef_subplugins'] = 'Mezipaměť používaná rutinami subpluginu k urychlení procesu zjišťování zásuvných modulů v případě potřeby.';
$string['cachedef_validatedurls'] = 'Mezipaměť kontrol ověřených URL';
$string['calendarstarts'] = '{$a} je naplánováno na';
$string['cannotperformaction'] = 'U tohoto záznamu nelze provést akci {$a}';
$string['completionattendance'] = 'Vyžadovat účast (minuty)';
$string['completionattendance_desc'] = 'Vstoupit do učebny a zůstat v relaci alespoň {$a} minut.';
$string['completionattendance_event_desc'] = 'Student vstoupil do učebny a zůstal v relaci alespoň {$a} minut';
$string['completionattendancegroup'] = 'Vyžadovat účast (minuty)';
$string['completionattendancegroup_help'] = 'K dokončení je nutná účast na schůzi po dobu (n) minut.';
$string['completionengagement_desc'] = 'Zapojit se během setkání do aktivit.';
$string['completionengagementchats'] = 'Chaty';
$string['completionengagementchats_desc'] = 'Zúčastnit se {$a} chatů.';
$string['completionengagementchats_event_desc'] = 'Vyvoláno {$a} chatů';
$string['completionengagementemojis'] = 'Emodži';
$string['completionengagementemojis_desc'] = 'Změnit  jejich emotikony {$a}krát.';
$string['completionengagementemojis_event_desc'] = 'Změněno {$a}krát  emotikony';
$string['completionengagementgroup'] = 'Vyžadovat účast';
$string['completionengagementgroup_help'] = 'K dokončení je nutná aktivní účast během relace';
$string['completionengagementpollvotes'] = 'Hlasování v anketě';
$string['completionengagementpollvotes_desc'] = 'Hlasovat {$a}krát v anketách.';
$string['completionengagementpollvotes_event_desc'] = 'Hlasoval {$a}krát v anketách';
$string['completionengagementraisehand'] = 'Vyžadovat hlasování';
$string['completionengagementraisehand_desc'] = 'Přihlásit se {$a}krát .';
$string['completionengagementraisehand_event_desc'] = 'Vyvoláno {$a} hlasování';
$string['completionengagementtalks'] = 'Diskuse';
$string['completionengagementtalks_desc'] = '{$a}krát konverzovat';
$string['completionengagementtalks_event_desc'] = 'Vyvoláno {$a} konverzací';
$string['completionupdatestate'] = 'Stav aktualizace dokončení';
$string['completionvalidatestate'] = 'Potvrdit dokončení';
$string['completionvalidatestatetriggered'] = 'Bylo spuštěno ověření dokončení.';
$string['completionview'] = 'Vyžadovat zobrazení';
$string['completionview_desc'] = 'Připojit do učebny';
$string['completionview_event_desc'] = 'Připojil se k učebně.';
$string['config_checksum_algorithm'] = 'Algoritmus kontrolního součtu BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 je kompatibilní se staršími servery. SHA256 a SHA512 jsou bezpečnější. SHA512 je kompatibilní s FIPS 140-2.';
$string['config_default_messages'] = 'Výchozí zprávy';
$string['config_default_messages_description'] = 'Nastavit výchozí hodnoty zpráv pro aktivity';
$string['config_disablecam_default'] = 'Ve výchozím nastavení zakázat webovou kameru';
$string['config_disablecam_default_description'] = 'Pokud je povoleno, budou webové kamery zakázány.';
$string['config_disablecam_editable'] = 'Zákaz webové kamery lze upravit';
$string['config_disablecam_editable_description'] = 'Ve výchozím nastavení lze zakázat webovou kameru, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disablemic_default'] = 'Ve výchozím nastavení zakázat mikrofon';
$string['config_disablemic_default_description'] = 'Pokud je povoleno, mikrofony budou zakázány.';
$string['config_disablemic_editable'] = 'Zákaz mikrofonu lze upravit';
$string['config_disablemic_editable_description'] = 'Ve výchozím nastavení lze zakázat mikrofon, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disablenote_default'] = 'Ve výchozím nastavení zakázat sdílené poznámky';
$string['config_disablenote_default_description'] = 'Pokud je povoleno, sdílené poznámky budou zakázány.';
$string['config_disablenote_editable'] = 'Zákaz sdílených poznámek lze upravit';
$string['config_disablenote_editable_description'] = 'Ve výchozím nastavení lze zakázat sdílené poznámky, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disableprivatechat_default'] = 'Ve výchozím nastavení je zakázán soukromý chat';
$string['config_disableprivatechat_default_description'] = 'Pokud je povoleno, soukromý chat bude zakázán.';
$string['config_disableprivatechat_editable'] = 'Zákaz soukromého chatu lze upravit';
$string['config_disableprivatechat_editable_description'] = 'Ve výchozím nastavení lze zakázat soukromý chat, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_disablepublicchat_default'] = 'Ve výchozím nastavení zakázat veřejný chat';
$string['config_disablepublicchat_default_description'] = 'Pokud je povoleno, bude veřejný chat zakázán.';
$string['config_disablepublicchat_editable'] = 'Zákaz veřejného chatu lze upravit';
$string['config_disablepublicchat_editable_description'] = 'Ve výchozím nastavení lze zakázat veřejný chat, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_dpa_note'] = 'Poznámka: Abyste splnili své povinnosti v oblasti ochrany dat, musíte se před použitím poskytovatele služeb pro tento plugin ujistit, že jste si přečetli a přijali smlouvu o zpracování dat poskytovatele služeb. Pro výchozí bezplatnou službu BigBlueButton je toto <a href="{$a}" target="_blank">smlouva o zpracování dat společnosti Blindside Networks</a>. Požádejte o radu své vlastní odborníky na ochranu osobních údajů.';
$string['config_experimental_features'] = 'Experimentálních funkce';
$string['config_experimental_features_description'] = 'Konfigurace experimentálních funkcí.';
$string['config_extended_capabilities'] = 'Rozšířené možnosti';
$string['config_extended_capabilities_description'] = 'Konfigurace pro rozšířené možnosti, které server BigBlueButton nabízí.';
$string['config_general'] = 'Obecné nastavení';
$string['config_general_description'] = 'Tato nastavení jsou vždy použita.';
$string['config_guestaccess_enabled'] = 'Externí přístup pro hosty';
$string['config_guestaccess_enabled_description'] = 'Umožnit uživatelům bez účtu na vašem webu přístup do místnosti.';
$string['config_hideuserlist_default'] = 'Ve výchozím nastavení skrýt seznam uživatelů';
$string['config_hideuserlist_default_description'] = 'Pokud je povoleno, seznam uživatelů relace bude skrytý.';
$string['config_hideuserlist_editable'] = 'Skrytí seznamu uživatelů lze upravit';
$string['config_hideuserlist_editable_description'] = 'Ve výchozím nastavení lze zakázat skrytí seznamu uživatelů, které lze upravit při přidání nebo aktualizaci instance.';
$string['config_importrecordings'] = 'Import nahrávek';
$string['config_importrecordings_description'] = 'Tato nastavení jsou specifická pro danou funkci.';
$string['config_importrecordings_enabled'] = 'Povolení importu nahrávek';
$string['config_importrecordings_enabled_description'] = 'Pokud je tato funkce a funkce nahrávání povolena, je možné importovat nahrávky z různých kurzů do činnosti.';
$string['config_importrecordings_from_deleted_enabled'] = 'Je povoleno importovat nahrávky ze smazaných aktivit';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Je-li tato funkce a funkce nahrávání importu povolena, je možné importovat nahrávky z činností, které již nejsou v kurzu.';
$string['config_locksettings'] = 'Konfigurace nastavení zamykání';
$string['config_locksettings_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní pro uzamčení nastavení a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_meetingevents_enabled'] = 'Zaregistrovat živé relace';
$string['config_meetingevents_enabled_description'] = 'Pokud je povoleno, živé relace budou zpracovány po skončení relace. Tato funkce je vyžadována pro dokončení aktivity a bude fungovat pouze v případě, že server BigBlueButton je schopen zpracovávat skripty post_events.';
$string['config_muteonstart'] = 'Ztlumení na startu';
$string['config_muteonstart_default'] = 'Ve výchozím nastavení je výchozí zvuk ztlumen';
$string['config_muteonstart_default_description'] = 'Pokud je povoleno, bude relace při startu ztlumena.';
$string['config_muteonstart_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_muteonstart_editable'] = 'Ztlumení na startu lze upravit';
$string['config_muteonstart_editable_description'] = 'Ve výchozím nastavení může být ztlumení při spuštění upraveno při přidání nebo aktualizaci instance.';
$string['config_participant'] = 'Účastníci';
$string['config_participant_description'] = 'Tato nastavení definuje výchozí roli pro účastníky.';
$string['config_participant_moderator_default'] = 'Moderátor';
$string['config_participant_moderator_default_description'] = 'Toto pravidlo je ve výchozím nastavení použito při přidání nové učebny.';
$string['config_poll_interval'] = 'Interval dotazování (v sekundách) pro obnovení stavu učebny';
$string['config_poll_interval_description'] = 'Interval dotazování musí být alespoň 2 sekundy. V případě potřeby můžete snížit zatížení vzdáleného serveru zvýšením intervalu.';
$string['config_presentation_default'] = 'Výchozí soubor prezentace';
$string['config_presentation_default_description'] = 'Soubor může být poskytnut pro použití ve všech učebnách.';
$string['config_preuploadpresentation'] = 'Soubor prezentace';
$string['config_preuploadpresentation_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti. Tato funkce funguje pouze v případě, že je server Moodle dostupný pro BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Soubor prezentace na stránce aktivity';
$string['config_preuploadpresentation_editable_description'] = 'Možnost v nastavení aktivity nahrát soubor prezentace, který se zobrazí na stránce aktivity.';
$string['config_profile_picture_enabled'] = 'Zobrazit profilové obrázky';
$string['config_profile_picture_enabled_description'] = 'Měly by se v relacích BigBlueButton zobrazovat profilové obrázky účastníků?';
$string['config_recording'] = 'Záznam';
$string['config_recording_all_from_start_default'] = 'Spustit nahrávání od začátku';
$string['config_recording_all_from_start_default_description'] = 'Mělo by být při přidávání nové učebny BigBlueButton ve výchozím nastavení povoleno nastavení „Spustit nahrávání od začátku“?';
$string['config_recording_all_from_start_editable'] = 'Spuštění nahrávání od začátku lze upravovat';
$string['config_recording_all_from_start_editable_description'] = 'Mělo by být "Spustit nahrávání od začátku" upravitelné v nastavení aktivity BigBlueButton?';
$string['config_recording_default'] = 'Ve výchozím nastavení je nahrávání povoleno';
$string['config_recording_default_description'] = 'Mělo by být při přidávání nové učebny BigBlueButton ve výchozím nastavení povoleno nastavení „Relace může být zaznamenána“?';
$string['config_recording_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_recording_editable'] = 'Relace může být zaznamenána lze upravovat';
$string['config_recording_editable_description'] = 'Měla by být možnost „Relace může být zaznamenána“ upravována v nastavení aktivity BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Skrýt tlačítko nahrávání';
$string['config_recording_hide_button_default_description'] = 'Pokud je zaškrtnuto, tlačítko pro záznam bude skryto';
$string['config_recording_hide_button_editable'] = 'Skrýt tlačítko nahrávání lze upravit';
$string['config_recording_hide_button_editable_description'] = 'Mělo by být „Skrýt tlačítko nahrávání“ upravitelné v nastavení aktivity BigBlueButton?';
$string['config_recording_protect_editable'] = 'Stav chráněných nahrávek lze upravit';
$string['config_recording_protect_editable_description'] = 'Pokud je zaškrtnuto, rozhraní obsahuje volbu pro ochranu/zrušení ochrany nahrávek.';
$string['config_recording_refresh_period'] = 'Doba obnovení záznamu (v sekundách)';
$string['config_recording_refresh_period_description'] = 'Jak často by se měl server BigBlueButton dotazovat, aby se obnovily vzdálené informace pro nahrávku?';
$string['config_recording_safe_formats'] = 'Formáty záznamu, které si může zobrazit každý';
$string['config_recording_safe_formats_description'] = 'Vyberat formáty, které mohou zobrazit všichni. Všechny ostatní formáty mohou zobrazit pouze učitelé a ostatní uživatelé s formáty mod/bigbluebuttonbn:viewwallrecording a možnosti mod/bigbluebuttonbn:managerecordings.';
$string['config_recordingready_enabled'] = 'Odeslat oznámení o dostupnosti nahrávky';
$string['config_recordingready_enabled_description'] = 'Pokud je povoleno, bude odesláno upozornění, jakmile bude k dispozici odkaz na nahrávání. Tato funkce vyžaduje, aby byl na serveru BigBlueButton povolen skript post_publish_recording_ready_callback.';
$string['config_recordings'] = 'Zobrazit nahrávky';
$string['config_recordings_asc_sort'] = 'Řadit nahrávky ve vzestupném pořadí';
$string['config_recordings_asc_sort_description'] = 'Nahrávky jsou seřazeny podle data, buď chronologického nebo obráceného chronologického pořadí (nejnovější nahrávka jako první).';
$string['config_recordings_deleted_default'] = 'Zahrnout nahrávky ze smazaných činností standardně povolených';
$string['config_recordings_deleted_default_description'] = 'Pokud je povoleno, záznamová tabulka bude obsahovat nahrávky všech aktivit, které byly mezitím smazány.';
$string['config_recordings_deleted_editable'] = 'Vložené nahrávky z funkce smazaných činností lze upravovat';
$string['config_recordings_deleted_editable_description'] = 'Vložené nahrávky ze smazaných činností lze ve výchozím nastavení upravovat při přidání nebo aktualizaci instance.';
$string['config_recordings_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_recordings_general'] = 'Zobrazit nastavení nahrávání';
$string['config_recordings_general_description'] = 'Tato nastavení se používají pouze při zobrazování záznamů';
$string['config_recordings_imported_default'] = 'Standardně zobrazit pouze importované odkazy';
$string['config_recordings_imported_default_description'] = 'Pokud je zapnuta, bude záznamová tabulka obsahovat pouze odkazy na importované nahrávky.';
$string['config_recordings_imported_editable'] = 'Zobrazovat lze pouze funkci importu importovaných odkazů';
$string['config_recordings_imported_editable_description'] = 'Zobrazit pouze importované odkazy ve výchozím nastavení lze upravovat při přidání nebo aktualizaci instance.';
$string['config_recordings_preview_default'] = 'Náhled je ve výchozím nastavení povolen';
$string['config_recordings_preview_default_description'] = 'Pokud je tato volba povolena, tabulka obsahuje náhled prezentace.';
$string['config_recordings_preview_editable'] = 'Funkce náhledu lze upravovat';
$string['config_recordings_preview_editable_description'] = 'Funkce náhledu může být upravena při přidání nebo aktualizaci instance.';
$string['config_scheduled'] = 'Plánované relace';
$string['config_scheduled_description'] = 'Tato nastavení definují některá chování standardně pro naplánované relace.';
$string['config_scheduled_pre_opening'] = 'Přístupné před časem otevření';
$string['config_scheduled_pre_opening_description'] = 'Doba v minutách, po kterou má být učebna přístupná před plánovanou dobou otevření.';
$string['config_server_url'] = 'Adresa URL serveru BigBlueButton';
$string['config_server_url_description'] = 'Výchozí přihlašovací údaje jsou pro <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">bezplatnou službu BigBlueButton pro Moodle (otevře se v novém okně)</a > poskytuje Blindside Networks s následujícími omezeními:

<ol>
<li>Maximální délka každé relace je 60 minut</li>
<li>Maximální počet souběžných uživatelů na relaci je 25</li>
<li>Platnost nahrávek vyprší po sedmi (7) dnech a nelze je stáhnout</li>
<li>Webové kamery studentů jsou viditelné pouze pro moderátora.</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton sdílený klíč';
$string['config_shared_secret_description'] = 'Bezpečnostní heslo vašeho serveru BigBlueButton. Tato výchozí heslo  je pro bezplatný server BigBlueButton poskytovaný Blindside Networks.';
$string['config_uidelegation_enabled'] = 'Delegování UI je povoleno';
$string['config_uidelegation_enabled_description'] = 'Tato nastavení povolují nebo zakazují delegování UI na server BigBlueButton.';
$string['config_userlimit'] = 'Limit uživatele';
$string['config_userlimit_default'] = 'Ve výchozím nastavení je povolen limit uživatelů';
$string['config_userlimit_default_description'] = 'Počet uživatelů povolených v relaci ve výchozím nastavení při přidání nové učebny. Pokud je číslo nastaveno na 0, není nastaven žádný limit';
$string['config_userlimit_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_userlimit_editable'] = 'Funkci omezení uživatele lze upravit';
$string['config_userlimit_editable_description'] = 'Ve výchozím nastavení lze omezit limitní hodnotu uživatelů při přidání nebo aktualizaci učebny.';
$string['config_voicebridge'] = 'Hlasový most';
$string['config_voicebridge_description'] = 'Tato nastavení povolují nebo zakazují možnosti v uživatelském rozhraní a také definují výchozí hodnoty pro tyto možnosti.';
$string['config_voicebridge_editable'] = 'Konferenční hlasový most lze upravit';
$string['config_voicebridge_editable_description'] = 'Číslo hlasového mostu konference může být trvale přiřazeno k učebně. Při přiřazení nelze toto číslo použít žádnou jinou učebnu.';
$string['config_waitformoderator'] = 'Čekání na moderátora';
$string['config_waitformoderator_cache_ttl'] = 'Čekání na vyrovnávací paměť moderátora TTL (sekundy)';
$string['config_waitformoderator_cache_ttl_description'] = 'Pro podporu velkého zatížení klientů tento plugin využívá cache. Tento parametr definuje dobu, po kterou bude mezipaměť uchovávána před odesláním dalšího požadavku na server BigBlueButton.';
$string['config_waitformoderator_default'] = 'Čekání na moderátora je standardně povoleno';
$string['config_waitformoderator_default_description'] = 'Čekání na moderátora je standardně povoleno při přidávání nové učebny.';
$string['config_waitformoderator_description'] = 'Tato nastavení jsou specifická pro danou funkci';
$string['config_waitformoderator_editable'] = 'Čekání na moderátora lze upravit';
$string['config_waitformoderator_editable_description'] = 'Mělo by být „Čekání na moderátora“ upravitelné v nastavení aktivity BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Čekání na ping moderátora (sekundy)';
$string['config_waitformoderator_ping_interval_description'] = 'Jak často by měl být serveru posílán ping, aby se zkontrolovalo, zda moderátor vstoupil do učebny?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton využívá config.php s globální proměnnou, která byla zastaralá. Soubor prosím převeďte, protože nebude podporován v budoucích verzích.';
$string['config_warning_curl_not_installed'] = 'Tato funkce vyžaduje rozšíření CURL pro php nainstalované a povolené. Nastavení budou přístupná pouze v případě, že je tato podmínka splněna.';
$string['config_welcome_default'] = 'Výchozí uvítací zpráva';
$string['config_welcome_default_description'] = 'Když účastníci vstoupí do učebny, zobrazí se uvítací zpráva. Pokud pole zůstane prázdné, použije se jazykový řetězec \'mod_form_field_welcome_default\'.';
$string['config_welcome_editable'] = 'Výchozí uvítací zprávu mohou učitelé upravovat';
$string['config_welcome_editable_description'] = 'Uvítací zprávu lze upravit při přidání nebo aktualizaci instance';
$string['dpainfonotsigned'] = 'Před povolením tohoto rozšíření musíte potvrdit, že jste si přečetli a přijali <a href="{$a}">Smlouvu o zpracování dat Blindside Networks</a>.';
$string['enablingbigbluebutton'] = 'Povolit aktivity BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Abyste splnili své povinnosti v oblasti ochrany údajů, musíte před povolením tohoto pluginu potvrdit, že jste si přečetli a přijali <a href="{$a}" target="_blank">Smlouvu o zpracování dat se společností Blindside Networks Inc.</a>. Požádejte o radu své vlastní odborníky na ochranu osobních údajů.';
$string['end_session_confirm'] = 'Opravdu chcete ukončit relaci?';
$string['end_session_confirm_title'] = 'Opravdu ukončit relaci?';
$string['end_session_notification'] = 'Relace byla nyní ukončena.';
$string['ends_at'] = 'Konec v';
$string['event_activity_created'] = 'Činnost vytvořena';
$string['event_activity_deleted'] = 'Činnost odstraněna';
$string['event_activity_updated'] = 'Činnost aktualizována';
$string['event_live_session'] = 'Událost žívá relace';
$string['event_meeting_created'] = 'Schůzka bylo vytvořena';
$string['event_meeting_ended'] = 'Schůzka nuceně ukončena';
$string['event_meeting_joined'] = 'Schůzka připojena';
$string['event_meeting_left'] = 'Schůzka proběhla';
$string['event_recording_deleted'] = 'Záznam byl vymazán';
$string['event_recording_edited'] = 'Záznam byl upraven';
$string['event_recording_imported'] = 'Záznam byl importován';
$string['event_recording_protected'] = 'Záznam je chráněn';
$string['event_recording_published'] = 'Záznam byl zveřejněn';
$string['event_recording_unprotected'] = 'Záznam je nechráněný';
$string['event_recording_unpublished'] = 'Publikování záznamu bylo zrušeno';
$string['event_recording_viewed'] = 'Záznam byl zobrazen';
$string['event_unknown'] = 'Neznámá událost';
$string['general_error_cannot_create_meeting'] = 'Relaci nelze vytvořit.';
$string['general_error_cannot_get_recordings'] = 'Nelze získat nahrávky.';
$string['general_error_no_answer'] = 'Prázdná odpověď. Zkontrolujte prosím adresu URL serveru BigBlueButton A zkontrolujte, zda server BigBlueButton běží.';
$string['general_error_not_allowed_to_create_instances'] = 'Uživatel nemá povoleno vytvářet jakýkoli typ instance.';
$string['general_error_not_found'] = 'Aktivitu BigBlueButton nelze najít s ID ({$a}).';
$string['general_error_unable_connect'] = 'Nelze se připojit. Zkontrolujte adresu URL serveru BigBlueButton A zkontrolujte, zda je spuštěn server BigBlueButton.
Podrobnosti: {$a}';
$string['guest_invitation_full_message'] = 'Zdravíme,
<p>byli jste pozváni jako host na relaci BigblueButton {$a->name} v kurzu {$a->course_fullname}.</p>

<p>Odkaz: {$a->guestjoinurl}<br/>
 <p>Heslo: {$a->heslo hosta}</p>
 <p>Pokud potřebujete pomoc, kontaktujte {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Zdravíme,

byli jste pozváni jako host na relaci BigblueButton {$a->name} v kurzu {$a->course_fullname}.

Odkaz: {$a->guestjoinurl}
Heslo: {$a->heslo hosta}

Pokud potřebujete pomoc, kontaktujte {$a->sender}.';
$string['guest_invitation_subject'] = 'Pozvánka: relace {$a->name} na {$a->course_fullname}!';
$string['guestaccess_activitynotfound'] = 'Aktivita nenalezena.';
$string['guestaccess_add'] = 'Přidat hosty';
$string['guestaccess_add_no_id'] = 'Nebylo poskytnuto žádné ID instance bigbluebutton.';
$string['guestaccess_copy_link'] = 'Zkopírovat odkaz';
$string['guestaccess_copy_password'] = 'Zkopírovat heslo';
$string['guestaccess_emails'] = 'E-maily hostů';
$string['guestaccess_emails_help'] = 'Seznam e-mailových adres oddělených čárkami.';
$string['guestaccess_emails_invalidemail'] = 'Neplatný e-mail: {$a}';
$string['guestaccess_feature_disabled'] = 'Přístup hostů zakázán.';
$string['guestaccess_invite_failure'] = 'Chyba {$a->errors} při pozvání {$a->emails}.';
$string['guestaccess_invite_success'] = 'Pozvánka bude odeslána na adresu {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Připojit se ke schůzce';
$string['guestaccess_meeting_invalid_password'] = 'Nesprávné heslo.';
$string['guestaccess_meeting_link'] = 'Odkaz na schůzku';
$string['guestaccess_meeting_not_started'] = 'Schůzka ještě nezačala. Prosím zkuste to znovu později.';
$string['guestaccess_meeting_password'] = 'Heslo schůzky';
$string['guestaccess_password'] = 'Heslo';
$string['guestaccess_title'] = 'Přidat hosty na tuto schůzku';
$string['guestaccess_username'] = 'Uživatelské jméno hosta';
$string['index_confirm_end'] = 'Přejete si ukončit relaci?';
$string['index_disabled'] = 'zakázán';
$string['index_enabled'] = 'povolen';
$string['index_ending'] = 'Ukončování relaci ... čekejte prosím';
$string['index_error_bbtn'] = 'ID BigBlueButton {$a} je nesprávné';
$string['index_error_checksum'] = 'Došlo k chybě kontrolního součtu. Zkontrolujte, zda jste zadali správné heslo.';
$string['index_error_forciblyended'] = 'K této relaci se nelze připojit, protože byla manuálně ukončena.';
$string['index_error_noinstances'] = 'Není to instance učebny BigBlueButton';
$string['index_error_unable_display'] = 'Relaci nelze zobrazit. Zkontrolujte adresu URL serveru BigBlueButton a zkontrolujte, zda je server BigBlueButton běží.';
$string['index_heading'] = 'Učebna BigBlueButton';
$string['index_heading_actions'] = 'Činnosti';
$string['index_heading_group'] = 'Skupina';
$string['index_heading_moderator'] = 'Moderátoři';
$string['index_heading_name'] = 'Učebna';
$string['index_heading_recording'] = 'Záznam';
$string['index_heading_users'] = 'Uživatelé';
$string['index_heading_viewer'] = 'Diváci';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitivní';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na kognitivní hloubce dosažené studentem v aktivitě BigBlueButton.';
$string['indicator:socialbreadth'] = 'Sociální BigBlueButton';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě BigBlueButton.';
$string['instance_type_default'] = 'Učebna  s nahrávkami';
$string['instance_type_recording_only'] = 'Pouze nahrávky';
$string['instance_type_room_only'] = 'Pouze učebna';
$string['instanceprofilewithoutrecordings'] = 'Tento profil instance nemůže zobrazovat nahrávky';
$string['managebbbextplugins'] = 'Správa doplňků rozšíření BigBlueButton';
$string['messageprovider:instance_updated'] = 'Relace BigBlueButton byla aktualizována';
$string['messageprovider:recording_ready'] = 'Nahrávka BigBlueButton je k dispozici';
$string['minute'] = 'minuta';
$string['minutes'] = 'minuty';
$string['mod_form_block_general'] = 'Obecné';
$string['mod_form_block_guestaccess'] = 'Přístup pro hosty';
$string['mod_form_block_participants'] = 'Role přiřazená během živé relace';
$string['mod_form_block_presentation'] = 'Obsah prezentace';
$string['mod_form_block_presentation_default'] = 'Výchozí obsah prezentace';
$string['mod_form_block_record'] = 'Nastavení záznamu';
$string['mod_form_block_recordings'] = 'Zobrazit záznam';
$string['mod_form_block_room'] = 'Nastavení učebny';
$string['mod_form_block_schedule'] = 'Načasování relace';
$string['mod_form_field_closingtime'] = 'Zavřít';
$string['mod_form_field_conference_name'] = 'Název relace';
$string['mod_form_field_disablecam'] = 'Zakázat webové kamery';
$string['mod_form_field_disablemic'] = 'Zakázat mikrofony';
$string['mod_form_field_disablenote'] = 'Zakázat sdílené poznámky';
$string['mod_form_field_disableprivatechat'] = 'Zakázat soukromý chat';
$string['mod_form_field_disablepublicchat'] = 'Zakázat veřejný chat';
$string['mod_form_field_duration'] = 'Trvání';
$string['mod_form_field_duration_help'] = 'Nastavení trvání schůzky stanovuje dobu maximální délky do ukončení záznamu';
$string['mod_form_field_guestallowed'] = 'Povolit přístup hostů';
$string['mod_form_field_hideuserlist'] = 'Skrýt seznam uživatelů';
$string['mod_form_field_instanceprofiles'] = 'Typ instance';
$string['mod_form_field_instanceprofiles_help'] = 'Pokud má být relace nahrána, vyberte „Učebna s nahrávkami“, jinak „Pouze učebna“. Pokud po nahrání relace nebudou žádné další relace, vyberte "Pouze nahrávky".';
$string['mod_form_field_intro'] = 'Popis';
$string['mod_form_field_intro_help'] = 'Stručný popis učebny.';
$string['mod_form_field_mustapproveuser'] = 'Uživatel musí být schválen moderátory';
$string['mod_form_field_muteonstart'] = 'Ztlumení při zahájení';
$string['mod_form_field_name'] = 'Název učebny';
$string['mod_form_field_nosettings'] = 'Nelze upravit žádná nastavení';
$string['mod_form_field_openingtime'] = 'Otevřít';
$string['mod_form_field_participant_add'] = 'Přidat účastníka';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderátor';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Divák';
$string['mod_form_field_participant_list'] = 'Účastníci';
$string['mod_form_field_participant_list_action_add'] = 'Přidat';
$string['mod_form_field_participant_list_action_remove'] = 'Odstranit';
$string['mod_form_field_participant_list_text_as'] = 'připojuje se k relaci jako';
$string['mod_form_field_participant_list_type_all'] = 'Všichni uživatelé zapsáni';
$string['mod_form_field_participant_list_type_owner'] = 'Vlastník';
$string['mod_form_field_participant_list_type_role'] = 'Role';
$string['mod_form_field_participant_list_type_user'] = 'Uživatel';
$string['mod_form_field_record'] = 'Relaci lze zaznamenat.';
$string['mod_form_field_recordallfromstart'] = 'Záznam od zahájení';
$string['mod_form_field_recordhidebutton'] = 'Skrýt tlačítko nahrávání';
$string['mod_form_field_recordings_deleted'] = 'Zahrnout nahrávky z odstraněných aktivit';
$string['mod_form_field_recordings_html'] = 'Zobrazit tabulku v prostém html';
$string['mod_form_field_recordings_imported'] = 'Zobrazit pouze importované odkazy';
$string['mod_form_field_recordings_preview'] = 'Zobrazit náhled záznamu';
$string['mod_form_field_room_name'] = 'Název učebny';
$string['mod_form_field_userlimit'] = 'Limit uživatelů';
$string['mod_form_field_userlimit_help'] = 'Povolený maximální počet uživatelů na relaci. Pokud je limit nastaven na 0, počet uživatelů bude neomezený.';
$string['mod_form_field_voicebridge'] = 'Hlasový přístup [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Chyba formátování. Měli byste zadat číslo mezi 1 a 9999.';
$string['mod_form_field_voicebridge_help'] = 'Číslo mezi 1 a 9999, které účastníci zadají, aby se připojili k hlasové relaci při použití telefonického připojení. Pokud je hodnota 0, bude číslo statického hlasového mostu ignorováno a BigBlueButton vygeneruje náhodné číslo. Před zadanými čtyřmi číslicemi bude předpona číslo 7.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Není to jedinečná hodnota. Toto číslo používá jiná učebna.';
$string['mod_form_field_wait'] = 'Čekání na moderátora';
$string['mod_form_field_wait_help'] = 'Musí účastníci čekat na moderátora, než mohou vstoupit do učebny?';
$string['mod_form_field_welcome'] = 'Uvítací zpráva';
$string['mod_form_field_welcome_default'] = 'Vítejte na %%CONFNAME%%';
$string['mod_form_field_welcome_help'] = 'Když účastníci vstoupí do učebny, zobrazí se uvítací zpráva. Pokud pole zůstane prázdné, zobrazí se výchozí zpráva nastavená v administraci webu.';
$string['mod_form_locksettings'] = 'Nastavení zámku';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton je webový konferenční systém s otevřeným zdrojovým kódem určený pro online výuku, který podporuje sdílení zvuku, videa, chatu, snímků, sdílení obrazovky, tabule pro více uživatelů, oddělených učeben, hlasování a emotikonů v reálném čase.

Pomocí BigBlueButton můžete vytvořit učebnu pro relaci, jako jsou živé online kurzy, virtuální úřední hodiny nebo skupinová spolupráce se vzdálenými studenty. Sezení lze nahrát pro pozdější přehrávání.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Aktivita BigBlueButton';
$string['nosuchinstance'] = 'Žádná taková instance {$a->entity} s ID: {$a->id}';
$string['notification_instance_created_intro'] = 'Učebna <a href="{$a->link}">{$a->name}</a> BigBlueButton byla vytvořena.';
$string['notification_instance_created_small'] = 'Byla vytvořena nová učebna BigBlueButton s názvem {$a->name}';
$string['notification_instance_created_subject'] = 'Byla vytvořena nová učebna  BigBlueButton';
$string['notification_instance_description'] = 'Popis';
$string['notification_instance_end_date'] = 'Datum ukončení';
$string['notification_instance_name'] = 'Titul';
$string['notification_instance_start_date'] = 'Datum zahájení';
$string['notification_instance_updated_intro'] = 'Učebna <a href="{$a->link}">{$a->name}</a> BigBlueButton byla aktualizována.';
$string['notification_instance_updated_small'] = 'Relace BigBlueButton {$a->name} byla aktualizována';
$string['notification_instance_updated_subject'] = 'Vaše učebna  BigBlueButton byla aktualizována';
$string['notification_recording_ready_html'] = 'Nyní je k dispozici záznam z relace v učebně BigBlueButton <b><a href="{$a->link}">{$a->name}</a></b>.';
$string['notification_recording_ready_plain'] = 'Nyní je k dispozici záznam z relace v učebně BigBlueButton {$a->name}. Pro přístup k odkazu na nahrávku přejděte na {$a->link}.';
$string['notification_recording_ready_small'] = 'Pro učebnu BigBlueButton {$a->name} je k dispozici záznam.';
$string['notification_recording_ready_subject'] = 'Nahrávka k dispozici';
$string['pluginadministration'] = 'Správa BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Aby bylo možné vytvořit připojení k relacím BigBlueButton, je třeba si vyměňitt uživatelská data se serverem.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Celé jméno uživatele přistupujícího k serveru BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID uživatele přistupujícího k serveru BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Konfigurace relace BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Seznam pravidel, která definují roli, kterou budou mít uživatelé v relaci BigBlueButton. ID uživatele může být uloženo, protože oprávnění lze udělit pro roli nebo uživatele.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Ukládá události spuštěné při použití pluginu.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Typ události spuštěné uživatelem.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID relace, ke které měl uživatel přístup.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Další informace týkající se relace nebo záznamu.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Čas, kdy byl protokol vytvořen.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID uživatele uživatele, který událost spustil.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Uložit metadata o nahrávkách.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Uživatelské ID uživatele, který naposledy změnil nahrávku.';
$string['progress_createbigbluebuttonbn'] = 'Vytvoření aktivity BigBlueButton ({$a})';
$string['recordings_from_deleted_activities'] = 'Záznamy ze smazaných aktivit';
$string['recordingurlnotfound'] = 'Adresa URL záznamu je neplatná.';
$string['removedevents'] = 'Odstraněné události';
$string['removedlogs'] = 'Odstraněny vlastní protokoly';
$string['removedrecordings'] = 'Odstraněné nahrávky';
$string['removedtags'] = 'Odstraněné štítky';
$string['report_join_info'] = '{$a} schůzek';
$string['report_play_recording_info'] = 'Přehráno {$a} nahrávek';
$string['report_room_view'] = 'shlédnuto';
$string['resetevents'] = 'Odstranit události';
$string['resetlogs'] = 'Odstranit protokoly';
$string['resetlogs_help'] = 'Odstranění protokolů způsobí ztrátu odkazů na nahrávky.';
$string['resetrecordings'] = 'Odstranit nahrávky';
$string['resetrecordings_help'] = 'Odstraněním nahrávek budou nedostupné odkudkoli. Tuto akci nelze vrátit zpět!';
$string['resettags'] = 'Odstranit štítky';
$string['search:activity'] = 'BigBlueButton - informace o aktivitě';
$string['search:tags'] = 'BigBlueButton - informace o štítcích';
$string['sendnotification'] = 'Odeslat oznámení';
$string['settings'] = 'Nastavení BigBlueButton';
$string['started_at'] = 'Zahájeno';
$string['starts_at'] = 'Začátek v';
$string['subplugintype_bbbext'] = 'Rozšíření aktivity BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Rozšíření aktivity BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Zkontrolujte nahrávky, které dosud nebyly nalezeny';
$string['taskname:check_pending_recordings'] = 'Načíst čekající nahrávky';
$string['userlimitreached'] = 'Bylo dosaženo počtu povolených uživatelů v relaci.';
$string['view_conference_action_end'] = 'Ukončení relace';
$string['view_conference_action_join'] = 'Připojení k relaci';
$string['view_error_action_not_completed'] = 'Akci nelze dokončit';
$string['view_error_bigbluebutton'] = 'BigBlueButton odpověděl chybami. {$a}';
$string['view_error_create'] = 'Server BigBlueButton odpověděl chybovou zprávou. Učebnu nelze vytvořit.';
$string['view_error_current_state_not_found'] = 'Aktuální stav nebyl nalezen. Záznam mohl být odstraněn nebo server BigBlueButton není kompatibilní s provedenou akcí.';
$string['view_error_import_no_courses'] = 'Žádné kurzy k vyhledání nahrávek.';
$string['view_error_import_no_recordings'] = 'V tomto kurzu nejsou žádné nahrávky pro import.';
$string['view_error_invalid_session'] = 'Platnost relace vypršela. Vraťte se na hlavní stránku aktivity.';
$string['view_error_max_concurrent'] = 'Bylo dosaženo počtu povolených souběžných relací.';
$string['view_error_meeting_not_running'] = 'Něco se pokazilo, relace neběží.';
$string['view_error_no_group'] = 'Nejsou žádné skupiny. Než se pokusíte připojit k relaci, musíte vytvořit nějaké skupiny.';
$string['view_error_no_group_student'] = 'Nejste zapsáni ve skupině. Obraťte se na svého učitele.';
$string['view_error_no_group_teacher'] = 'Nejsou nastaveny žádné skupiny. Musíte vytvořit nějaké skupiny.';
$string['view_error_unable_join'] = 'Nelze se připojit do učebny. Zkontrolujte adresu URL serveru BigBlueButton a zkontrolujte, zda je server BigBlueButton běží.';
$string['view_error_unable_join_student'] = 'Nelze se připojit k serveru BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Nelze se připojit k serveru BigBlueButton. Obraťte se na správce.';
$string['view_error_url_missing_parameters'] = 'Na této adrese URL chybí parametry';
$string['view_error_userlimit_reached'] = 'Bylo dosaženo limitu počtu uživatelů povolených v relaci.';
$string['view_groups_nogroups_warning'] = 'Učebna byla nakonfigurována pro použití skupin, ale kurz nemá definované skupiny.';
$string['view_groups_notenrolled_warning'] = 'Učebnabyla nakonfigurována pro použití skupin, ale nejste zaregistrováni v žádné z nich.';
$string['view_groups_selection'] = 'Vyberte skupinu, ke které se chcete připojit a potvrďte akci';
$string['view_groups_selection_join'] = 'Připojit';
$string['view_groups_selection_warning'] = 'Pro každou skupinu je jedna učebna a máte přístup k více než jedné. Nezapomeňte vybrat tu správnou.';
$string['view_login_moderator'] = 'Přihlásit se jako moderátor ...';
$string['view_login_viewer'] = 'Přihlásit se jako divák ...';
$string['view_message_and'] = 'a';
$string['view_message_conference_has_ended'] = 'Tato relace skončila.';
$string['view_message_conference_in_progress'] = 'Tato relace probíhá.';
$string['view_message_conference_not_started'] = 'Tato relace ještě nezačala.';
$string['view_message_conference_room_ready'] = 'Tato učebna je připravena. Nyní se můžete k relaci připojit.';
$string['view_message_conference_user_limit_reached'] = 'Bylo dosaženo limitu počtu uživatelů povolených v relaci.';
$string['view_message_conference_wait_for_moderator'] = 'Čekání na připojení moderátora.';
$string['view_message_cron_disabled'] = 'Seznam nahrávek nemusí být aktuální. Obraťte se prosím na správce webu s následujícími informacemi: {$a}.';
$string['view_message_finished'] = 'Tato aktivita skončila.';
$string['view_message_has_joined'] = 'připojil se';
$string['view_message_have_joined'] = 'připojili se';
$string['view_message_hour'] = 'hodina';
$string['view_message_hours'] = 'hodin';
$string['view_message_importrecordings_disabled'] = 'Funkce pro import odkazů na nahrávání je na serveru zakázána.';
$string['view_message_minute'] = 'minuta';
$string['view_message_minutes'] = 'minut';
$string['view_message_moderator'] = 'Moderátor';
$string['view_message_moderators'] = 'Moderátoři';
$string['view_message_norecordings'] = 'Nejsou k dispozici žádné nahrávky.';
$string['view_message_notavailableyet'] = 'Tato relace zatím není k dispozici.';
$string['view_message_recordings_disabled'] = 'Nahrávky byly na tomto serveru deaktivovány. Činnosti BigBlueButton typu "Pouze nahrávky" nelze použít.';
$string['view_message_room_closed'] = 'Tato učebna je zavřena.';
$string['view_message_room_open'] = 'Tato učebna je otevřena.';
$string['view_message_room_ready'] = 'Tato učebna je připravena.';
$string['view_message_session_for'] = 'relace pro';
$string['view_message_session_has_user'] = 'Tady je';
$string['view_message_session_has_users'] = 'Tady jsou';
$string['view_message_session_no_users'] = 'V této relaci nejsou žádní uživatelé';
$string['view_message_session_running_for'] = 'Tato relace již běží';
$string['view_message_session_started_at'] = 'Relace začala v';
$string['view_message_tab_close'] = 'Tato karta / okno musí být zavřeno ručně';
$string['view_message_times'] = 'krát';
$string['view_message_user'] = 'Uživatel';
$string['view_message_users'] = 'Uživatelé';
$string['view_message_viewer'] = 'Divák';
$string['view_message_viewers'] = 'Diváků';
$string['view_mobile_message_groups_not_supported'] = 'Tato instance umožňuje práci se skupinami, ale mobilní aplikace to nepodporuje. Použijte prosím webovou verzi.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Na této stránce jste překročili 45 sekund. Chcete-li se připojit k relaci, obnovte stránku.';
$string['view_noguests'] = 'BigBlueButton učebna není otevřena pro hosty.';
$string['view_nojoin'] = 'Nemáte roli, která se může připojit k této relaci.';
$string['view_recording'] = 'nahrávka';
$string['view_recording_actionbar'] = 'Panel nástrojů';
$string['view_recording_activity'] = 'Aktivita';
$string['view_recording_button_import'] = 'Importujte odkazy na nahrávky';
$string['view_recording_button_return'] = 'Zpět';
$string['view_recording_course'] = 'Kurz';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Opravdu chcete {$a} smazat?';
$string['view_recording_delete_confirmation_warning_p'] = 'Tato nahrávka má přidružené odkazy {$a}, které byly importovány do různých kurzů nebo aktivit. Pokud je nahrávka smazána, budou tyto odkazy také odstraněny';
$string['view_recording_delete_confirmation_warning_s'] = 'K této nahrávce je přiřazen odkaz {$a}, který byl importován do jiného kurzu nebo aktivity. Pokud je nahrávka smazána, bude také odkaz odstraněn';
$string['view_recording_description'] = 'Popis';
$string['view_recording_description_edithint'] = 'K identifikaci nahrávky může být přidán popis.';
$string['view_recording_description_editlabel'] = 'Upravit popis';
$string['view_recording_duration'] = 'Doba trvání';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Adresa URL pro tento formát záznamu je nedostupná.';
$string['view_recording_format_notes'] = 'Poznámky';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Prezentace';
$string['view_recording_format_screenshare'] = 'Sdílena obrazovka';
$string['view_recording_format_statistics'] = 'Statistika';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Opravdu chcete importovat tuto nahrávku?';
$string['view_recording_length'] = 'Délka';
$string['view_recording_link'] = 'importovaný odkaz';
$string['view_recording_link_warning'] = 'Toto je odkaz směřující na nahrávku, která byla vytvořena v jiném kurzu nebo aktivitě.';
$string['view_recording_list_action_delete'] = 'Odstranění';
$string['view_recording_list_action_edit'] = 'Aktualizace';
$string['view_recording_list_action_play'] = 'Spustit';
$string['view_recording_list_action_process'] = 'Zpracování';
$string['view_recording_list_action_protect'] = 'Ochrana';
$string['view_recording_list_action_publish'] = 'Publikování';
$string['view_recording_list_action_unprotect'] = 'Zrušit ochranu';
$string['view_recording_list_action_unpublish'] = 'Zrušit publikování';
$string['view_recording_list_action_update'] = 'Aktualizace';
$string['view_recording_list_actionbar'] = 'Nástroje';
$string['view_recording_list_actionbar_delete'] = 'Odstranit';
$string['view_recording_list_actionbar_edit'] = 'Upravit';
$string['view_recording_list_actionbar_hide'] = 'Skrýt';
$string['view_recording_list_actionbar_import'] = 'Importovat';
$string['view_recording_list_actionbar_protect'] = 'Nastavit jako soukromé';
$string['view_recording_list_actionbar_publish'] = 'Publikovat';
$string['view_recording_list_actionbar_show'] = 'Zobrazit';
$string['view_recording_list_actionbar_unprotect'] = 'Nastavit jako veřejné';
$string['view_recording_list_actionbar_unpublish'] = 'Zrušit publikování';
$string['view_recording_list_activity'] = 'Činnost';
$string['view_recording_list_course'] = 'Kurz';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Popis';
$string['view_recording_list_duration'] = 'Trvání';
$string['view_recording_list_recording'] = 'Zaznamenávání';
$string['view_recording_meeting'] = 'Schůzka';
$string['view_recording_modal_button'] = 'Aplikovat';
$string['view_recording_modal_title'] = 'Nastavit hodnoty pro záznam';
$string['view_recording_name'] = 'Název';
$string['view_recording_name_edithint'] = 'K identifikaci nahrávky lze přidat název.';
$string['view_recording_name_editlabel'] = 'Upravit název';
$string['view_recording_playback'] = 'Přehrávání';
$string['view_recording_preview'] = 'Náhled';
$string['view_recording_preview_help'] = 'Umístěním kurzoru na obrázek jej zobrazíte v plné velikosti';
$string['view_recording_protect_confirmation'] = 'Jste si jisti, že chcete {$a} chránít?';
$string['view_recording_protect_confirmation_warning_p'] = 'K této nahrávce je přidruženo {$a} odkazů, které byly importovány v různých kurzech nebo aktivitách. Pokud je nahrávka chráněna, ovlivní to také importované odkazy.';
$string['view_recording_protect_confirmation_warning_s'] = 'K této nahrávce je přidružen odkaz {$a}, který byl importován v jiném kurzu nebo aktivitě. Pokud je nahrávka chráněna, ovlivní to také importované odkazy.';
$string['view_recording_publish_confirmation'] = 'Opravdu chcete {$a} publikovat?';
$string['view_recording_publish_confirmation_warning_p'] = 'K této nahrávce je přidruženo {$a} odkazů, které byly importovány v různých kurzech nebo aktivitách. Pokud bude nahrávka zveřejněna, budou zveřejněny i tyto odkazy.';
$string['view_recording_publish_confirmation_warning_s'] = 'K této nahrávce je přidružen odkaz {$a}, který byl importován v jiném kurzu nebo aktivitě. Pokud bude nahrávka zveřejněna, bude zveřejněn i tento odkaz.';
$string['view_recording_publish_link_deleted'] = 'Tento odkaz nelze znovu publikovat, protože aktuální nahrávka na aktuálním serveru BigBlueButton neexistuje. Odkaz by měl být odstraněn.';
$string['view_recording_publish_link_not_published'] = 'Tento odkaz nelze znovu publikovat, protože skutečný nahrávka není publikována.';
$string['view_recording_recording'] = 'Záznam';
$string['view_recording_select_course'] = 'Nejprve vyberte kurz v rozbalovací nabídce';
$string['view_recording_tags'] = 'Štítky';
$string['view_recording_unprotect_confirmation'] = 'Opravdu chcete zrušit ochranu {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'K této nahrávce je přidruženo {$a} odkazů, které byly importovány v různých kurzech nebo aktivitách. Pokud je nahrávka nechráněná, ovlivní to také importované odkazy.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'K této nahrávce je přidružen odkaz {$a}, který byl importován v jiném kurzu nebo aktivitě. Pokud je nahrávka nechráněná, ovlivní to také importované odkazy';
$string['view_recording_unprotect_link_deleted'] = 'Tímto odkazem nelze zrušit ochranu, protože aktuální nahrávka na aktuálním serveru BigBlueButton neexistuje. Odkaz by měl být odstraněn.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Tímto odkazem nelze zrušit ochranu, protože skutečný nahrávka je chráněna';
$string['view_recording_unpublish_confirmation'] = 'Opravdu chcete zrušit publikování tohoto {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Tato nahrávka má přidružené odkazy {$a}, které byly importovány v různých kurzech nebo aktivitách. Pokud není nahrávka publikována, budou také nepublikovány tyto odkazy.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'K této nahrávce je přidružen odkaz {$a}, který byl importován v jiném kurzu nebo aktivitě. Pokud není nahrávka publikována, bude zrušen také odkaz.';
$string['view_recording_yui_first'] = 'První';
$string['view_recording_yui_go'] = 'Přejít';
$string['view_recording_yui_last'] = 'Poslední';
$string['view_recording_yui_next'] = 'Další';
$string['view_recording_yui_page'] = 'Stránka';
$string['view_recording_yui_prev'] = 'Předchozí';
$string['view_recording_yui_rows'] = 'Řádky';
$string['view_recording_yui_show_all'] = 'Zobrazit vše';
$string['view_room'] = 'Zobrazit učebnu';
$string['view_section_title_presentation'] = 'Soubor prezentace';
$string['view_section_title_recordings'] = 'Nahrávky';
$string['view_warning_default_server'] = 'Tento web používá <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">bezplatnou službu BigBlueButton pro Moodle (otevře se v novém okně)</a> poskytuje Blindside Networks s následujícími omezeními:

 <ol>
<li>Maximální délka každé relace je 60 minut</li>
<li>Maximální počet souběžných uživatelů na relaci je 25</li>
<li>Platnost nahrávek vyprší po sedmi (7) dnech a nelze je stáhnout</li>
<li>Webové kamery studentů jsou viditelné pouze pro moderátora.</li>
</ol>';
$string['waitformoderator'] = 'Čeká se na připojení moderátora.';
