<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'cs', version '4.3'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Činnosti';
$string['addcategory'] = 'Přidat kategorii';
$string['addcategoryerror'] = 'Nepodařilo se přidat kategorii';
$string['addexceptionerror'] = 'Vyskytla se chyba při přidávání výjimky pro userid:gradeitem';
$string['addfeedback'] = 'Přidat komentář';
$string['addgradeletter'] = 'Přidat slovní známku';
$string['addidnumbers'] = 'Přidat identifikátory';
$string['additem'] = 'Přidat položku hodnocení';
$string['additionalfeedback'] = 'Další zpětná vazba';
$string['addoutcome'] = 'Přidat očekávaný výstup';
$string['addoutcomeitem'] = 'Přidat hodnocený výstup';
$string['addscale'] = 'Přidat škálu';
$string['adjustedweight'] = 'Přizpůsobit váhu';
$string['aggregateextracreditmean'] = 'Průměr známek (včetně extra bodového zisku)';
$string['aggregatemax'] = 'Nejvyšší známka';
$string['aggregatemean'] = 'Průměr známek';
$string['aggregatemedian'] = 'Medián známek';
$string['aggregatemin'] = 'Nejnižší známka';
$string['aggregatemode'] = 'Modus známek';
$string['aggregatenotonlygraded'] = 'Včetně prázdných známek';
$string['aggregateonlygraded'] = 'Do souhrnné známky zahrnout pouze neprázdné známky';
$string['aggregateonlygraded_help'] = '<p>Neexistující známky je možno považovat za minimální nebo je nezahrnout do výpočtu souhrnné známky.</p>';
$string['aggregateoutcomes'] = 'Zahrnout očekávané výstupy v souhrnné známce';
$string['aggregateoutcomes_help'] = '<p>Zahrnutí očekávaných výstupů do souhrnné známky nemusí vést k požadovanému výsledku. Proto máte možnost je zahrnout nebo ne.</p>';
$string['aggregatesonly'] = 'Zobrazit pouze souhrnné známky';
$string['aggregatesubcatsupgradedgrades'] = 'Poznámka: Nastavení agregace "Souhrn zahrnující podkategorie" byla odstraněna v rámci aktualizace stránek. Vzhledem k tomu,  dříve byl použita v tomto kurzu  "Souhrn zahrnující podkategorie", doporučujeme, abyste si zkontrolovali zadání přehledu známek.';
$string['aggregatesum'] = 'Přirozená váha';
$string['aggregateweightedmean'] = 'Vážený průměr známek';
$string['aggregateweightedmean2'] = 'Jednoduchý vážený průměr známek';
$string['aggregation'] = 'Souhrnná známka';
$string['aggregation_help'] = 'Souhrnná známka určuje, jak se vypočítávají známky v kategorii, například

* Průměr známek- součet všech známek dělený celkovým počtem známek
* Medián známek- prostřední známka v řadě známek seřazených podle velikosti.
* Nejnižší známka
* Nejvyšší známka
* Modus známek - známka, která se vyskytuje nejčastěji
* Přirozená váha - součet všech známek dělený součtem vah (vážený průměr, kdy Moodle navrhne váhy sám)

<p>Všechny známky v dané kategorii (a případně i v jejích podkategoriích) mohou být shrnuty do jediné známky za danou kategorii. Souhrnná známka za danou kategorii může být vypočítávána různými způsoby. Následující text objasňuje jednotlivé způsoby výpočtu souhrnné známky.</p>

<p>Nejprve jsou známky převedeny na procentuální hodnotu z intervalu <0; 1>, tomuto procesu se říká normalizace. Poté je vypočítána souhrnná známka pomocí jedné z funkcí uvedené dále. Nakonec je takto vypočtená známka převedena na odpovídající hodnotu z rozsahu nastaveného pro danou kategorii (tj. do intervalu mezi nejnižší a nejvyšší známkou definovanou v nastavení kategorie).</p>

<p><strong>Důležité:</strong> Prázdná známka je prostě chybějící záznam v modulu klasifikace a může mít více významů.  Může jít o studenta, který dosud neodevzdal zadaný úkol, nebo o případ, kdy učitel ještě neoznámkoval zaslané řešení, případně byla známka ručně odstraněna správcem klasifikace. Pečlivě si rozmyslete, jaký význam mají prázdná pole známek a podle toho i nastavte výpočet souhrnné známky.</p>

<p>Ve všech následujících příkladech jsou uvažovány tři bodované položky hodnocení označené jako A1, A2 a A3. Za A1 šlo získat maximálně 100 bodů, student získal 70. Za A2 bylo možno získat 80 bodů, daný student získal jen 20. V položce A3 student získal 10 bodů z 10 možných. Všechny jsou položy A1, A2 a A3 jsou zařazeny do stejné kategorie, která má nastavenu nejvyšší možnou známku 100.</p>

<dl id="grade-aggregation-help">
    <dt>Průměr známek</dt>
    <dd>Součet známek dělený jejich počtem.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, nejvyšší možná za danou kategorii 100:<br />
                     <code>(0.7 + 0.25 + 1.0)/3 = 0.65 --> 65/100</code></dd>

    <dt>Vážený průměr</dt>
        <dd>Každé položce může být přiřazena váha, která se poté promítá do výpočtu aritmetického průměru. Čím větší váhu položka má, tím více souhrnnou známku ovlivňuje.</dd>
        <dd class="example">A1 70/100 s vahou 10, A2 20/80 s vahou 5,
                            A3 10/10 s vahou 3, nejvyšší možná známka za danou kategorii 100:
        <br /><code>(0.7*10 + 0.25*5 + 1.0*3)/18 = 0.625 --> 62.5/100</code></dd>

    <dt>Jednoduchý vážený průměr</dt>
        <dd>Od <em>Váženého průměru</em> se liší tím, že váha je u každé položky určena automaticky jako <em>Nejvyšší známka</em> - <em>Nejnižší známka</em>. Úkol, za který je možno získat až 100 bodů, má pak váhu 100, úkol s maximem 10 bodů má váhu 10.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, nejvyšší možná za danou kategorii 100:<br />
                         <code>(0.7*100 + 0.25*80 + 1.0*10)/190 = 0.526 --> 52.6/100</code></dd>

    <dt>Průměr známek (včetně známek navíc)</dt>
        <dd>Drobně modifikovaný aritmetický průměr. Starší, nyní již nepodporovaný způsob výpočtu souhrnné známky, který je zde zařazen jen pro účely zpětné kompatibility se staršími aktivitami.</dd>

    <dt>Medián známek</dt>
        <dd>Prostřední známka (příp. průměr dvou prostředních známek) v řadě známek seřazených podle velikosti. Výhodou oproti průměru je, že medián není tolik ovlivněn výjimečnými hodnotami známek (tj. známkami hodně vzdálenými od průměru).</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, nejvyšší možná za danou kategorii 100:<br />
                         <code>median(0.7 ; 0.25 ; 1.0) --> 0.7 --> 70/100</code></dd>

    <dt>Nejnižší známka</dt>
        <dd>Výsledkem je nejnižší známka po normalizaci. Často se používá v kombinaci s nastavením <em>Do souhrnné známky zahrnout pouze neprázdné známky</em>.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, nejvyšší možná za danou kategorii 100:<br />
                         <code>min(0.7 ; 0.25 ; 1.0) = 0.25 --> 25/100</code></dd>

    <dt>Nejvyšší známka</dt>
        <dd>Výsledkem je nejvyšší známka po normalizaci.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, nejvyšší možná za danou kategorii 100:<br />
                         <code>max(0.7 ; 0.25 ; 1.0) = 1.0 --> 100/100</code></dd>

    <dt>Modus známek</dt>
        <dd>Modus je známka, která se vyskytuje nejčastěji. Často se používá pro nenumerické typy známek. Výhodou oproti průměru je, že modus není tolik ovlivněn výjimečnými hodnotami známek (tj. známkami hodně vzdálenými od průměru). Modus ztrácí význam, pokud stejné maximální četnosti dosahuje vícero hodnot (pouze jedna z nich je zaznamenána) nebo pokud se všechny známky od sebe liší (každá z nich má četnost 1).</dd>
        <dd class="example">A1 70/100, A2 35/50, A3 20/80, A4 10/10, A5 7/10 nejvyšší možná za danou kategorii 100:<br />
                         <code>mode(0.7; 0.7; 0.25; 1.0; 0.7) = 0.7 --> 70/100</code></dd>

    <dt>Součet známek</dt>
        <dd>Součet nenormalizovaných hodnot všech zahrnutých známek. Škály jsou ignorovány. Toto je jediný typ výpočtu shouhrnné známky, při kterém nejsou známky normalizovány. <em>Nejvyšší možná známka</em> za danou kategorii je vypočtena automaticky jakou součet nejvyšších možných známek dílčích položek.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10:<br />
                         <code>70 + 20 + 10 = 100/190</code></dd>
</dl>';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Koeficient souhrnné známky';
$string['aggregationcoefextra'] = 'Extra bodový zisk';
$string['aggregationcoefextra_help'] = 'Při použití typu souhrnné známky "Přirozená váha" nebo "Jednoduchý vážený průměr" a jsou zaškrtnuty políčka pro bonus, nebude maximální hodnota položky přidána do maximální známky kategorie. To bude mít za následek možnost dosažení maximální známky v kategorii, aniž by student získal maximální počet bodů ve všech položkách známek. V případě, že správce webu povolil známky nad maximum, může dojít k hodnocení, které je větší než maximální limit.

Pokud používáte souhrnnou známku "Průměr známek (včetně extra bodového zisku)" a zadáte zde hodnotu větší než nula, budou známky za tuto položku hodnocení při výpočtu souhrnné známky považovány za známku navíc. Nastavená hodnota slouží jako součinitel, kterým se násobí skutečná hodnota známky předtím, než se přičte k součtu všech známek.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Extra bodový zisk';
$string['aggregationcoefextrasum_help'] = 'Při použití typu souhrnné známky "Součet známek" mohou vybrané položky hodnocení fungovat jako bonusové. To znamená, že nejvyšší možná známka za tuto položku nebude přičtena k celkové nejvyšší možné známce za celou kategorii, ale samotná známka ano.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Váha pro extra body';
$string['aggregationcoefextraweight_help'] = 'Zadáte-li zde hodnotu větší než nula, budou známky za tuto položku hodnocení při výpočtu souhrnné známky považovány za známku navíc. Nastavená hodnota slouží jako součinitel, kterým se násobí skutečná hodnota známky, předtím než se přičte k součtu všech známek za danou kategorii. Současně není položka započítána do počtu položek, kterým se součet všech známek za kategorii dělí.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Váha položky';
$string['aggregationcoefweight_help'] = '<p>Váha aplikovaná na všechny známky v této položce hodnocení, která se použije při výpočtu souhrnné známky.</p>';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Ignorované)';
$string['aggregationhintexcluded'] = '(Vypuštěné)';
$string['aggregationhintextra'] = '(Přičteno)';
$string['aggregationhintnovalue'] = '(Prázdné)';
$string['aggregationofa'] = 'Agregace {$a}';
$string['aggregationposition'] = 'Umístění souhrnné známky';
$string['aggregationposition_help'] = '<p>Definuje umístění sloupce se souhrnnou známkou vzhledem ke známkám, z nichž je souhrnná známka počítána.</p>';
$string['aggregationsvisible'] = 'Dostupné typy souhrnných známek';
$string['aggregationsvisiblehelp'] = 'Označte všechny typy výpočtu souhrnných známek, které mají být dostupné. Držte klávesu Ctrl k označení více položek.';
$string['allgrades'] = 'Všechny známky podle kategorie';
$string['allstudents'] = 'Všichni studenti';
$string['allusers'] = 'Všichni uživatelé';
$string['aria-toggledropdown'] = 'Přepnout následující rozevírací seznam';
$string['aria:dropdowngrades'] = 'Byly nalezeny položky hodnocení';
$string['autosort'] = 'Automatické řazení';
$string['availableidnumbers'] = 'Dostupné identifikátory';
$string['average'] = 'Průměr';
$string['averagesdecimalpoints'] = 'Počet desetinných míst v průměrech';
$string['averagesdecimalpoints_help'] = 'Určuje počet desetinných míst, která budou zobrazena v průměru pro každý sloupec nebo zda se použije (dědičnost) celkové nastavení desetinných míst pro kategorii nebo položku hodnocení.';
$string['averagesdisplaytype'] = 'Typ zobrazení průměrů';
$string['averagesdisplaytype_help'] = '<p>Určuje, jak bude zobrazován průměr u každého sloupce. Je-li zvoleno "Dědit", je použit stejný typ zobrazení, jaký je nastaven u hodnot v daném sloupci.</p>';
$string['backupwithoutgradebook'] = 'Záloha neobsahuje konfiguraci klasifikace';
$string['badgrade'] = 'Přiřazená známka není platná';
$string['badlyformattedscale'] = 'Vložte čárkami oddělený seznam hodnot. Vyžadovány jsou alespoň dvě položky.';
$string['baduser'] = 'Poskytnutý uživatel není platný';
$string['bonuspoints'] = 'Bonusové body';
$string['bulkcheckboxes'] = 'Hromadná zaškrtávátka';
$string['calculatedgrade'] = 'Vypočítávaná známka';
$string['calculation'] = 'Výpočet';
$string['calculation_help'] = 'Pro výpočet známky je možno použít vzorec. Vzorec je předpis začínající znakem rovnítka, který může používat běžné algebraické operace a další funkce, jako např. min, max nebo sum. Do výpočtu lze zahrnout i hodnotu dalších známek tak, že se jejich ID uvede v dvojitých hranatých závorkách.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Přidat výpočet';
$string['calculationedit'] = 'Upravit výpočet';
$string['calculationsaved'] = 'Výpočet uložen';
$string['calculationview'] = 'Zobrazit výpočet';
$string['calculationwarning'] = 'Tato kategorie používá spíše výpočet hodnocení pro součet kategorií než agregaci.';
$string['cannotaccessgroup'] = 'Bohužel, nemáte přístup ke známkám ve vybrané skupině.';
$string['categories'] = 'Kategorie';
$string['category'] = 'Kategorie';
$string['categoryedit'] = 'Upravit kategorii';
$string['categoryname'] = 'Název kategorie';
$string['categorytotal'] = 'Celkem v kategorii';
$string['categorytotalfull'] = '{$a->category} - celkem';
$string['categorytotalname'] = 'Název pro celkovou známku v kategorii';
$string['changedefaults'] = 'Změnit výchozí hodnoty';
$string['changereportdefaults'] = 'Změnit výchozí nastavení přehledu';
$string['chooseaction'] = 'Vyberte akci ...';
$string['choosecategory'] = 'Vyberte kategorii';
$string['collapsecriterion'] = 'Sbalit kritérium';
$string['combo'] = 'Záložky a rozbalovací menu';
$string['compact'] = 'Kompaktní';
$string['componentcontrolsvisibility'] = 'Nastavením činnosti určuje, zda je tato známka skryta.';
$string['contract'] = 'Sbalit kategorii';
$string['contributiontocoursetotal'] = 'Podíl z celkové známky';
$string['controls'] = 'Řízení';
$string['courseavg'] = 'Průměr kurzu';
$string['coursegradecategory'] = 'Kategorie známek kurzu';
$string['coursegradedisplaytype'] = 'Typ zobrazování známek v kurzu';
$string['coursegradedisplayupdated'] = 'Typ zobrazování známek v kurzu byl aktualizován';
$string['coursegradesettings'] = 'Nastavení hodnocení v kurzu';
$string['coursename'] = 'Název kurzu';
$string['coursescales'] = 'Škály kurzu';
$string['coursesettings'] = 'Nastavení hodnocení v kurzu';
$string['coursesettingsexplanation'] = 'Nastavení hodnocení kurzu určuje, jak se budou známky zobrazovat všem účastníkům kurzu.';
$string['coursesiamtaking'] = 'Zapsané kurzy';
$string['coursesiamteaching'] = 'Učím v kurzech';
$string['coursetotal'] = 'Celkem za kurz';
$string['createcategory'] = 'Vytvořit kategorii';
$string['createcategoryerror'] = 'Nelze vytvořit novou kategorii';
$string['creatinggradebooksettings'] = 'Vytvářím nastavení klasifikace';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Typ souhrnné známky v nadřazené kategorii';
$string['curveto'] = 'Přepočítat na';
$string['decimalpoints'] = 'Počet desetinných míst';
$string['decimalpoints_help'] = 'Určuje, na kolik desetinných míst se budou zobrazovat známky v klasifikaci. Toto nastavení neovlivňuje přesnost výpočtů známek, které jsou prováděny s přesností na pět desetinných míst.';
$string['default'] = 'Výchozí';
$string['defaultprev'] = 'Výchozí ({$a})';
$string['deletecategory'] = 'Odstranit kategorii';
$string['deletescale'] = 'Odstranit škálu';
$string['disablegradehistory'] = 'Zakázat historii známek';
$string['disablegradehistory_help'] = 'Vypíná sledování historie změn v tabulkách hodnocení. Zpracování pak může probíhat trochu rychleji a šetří se místo v databázi.';
$string['displaylettergrade'] = 'Zobrazit slovní známky';
$string['displaypercent'] = 'Zobrazit známky v procentech';
$string['displaypoints'] = 'Zobrazit body';
$string['displayweighted'] = 'Zobrazit vážené známky';
$string['dropdown'] = 'Rozbalovací nabídka';
$string['droplow'] = 'Ignorovat X nejnižších';
$string['droplow_help'] = '<p>Je-li zde nastavena nějaká hodnota X, pak bude ignorováno X nejnižších (nejhorších) známek.</p>';
$string['droplowestvalue'] = 'Nastavit nejnižší hodnotu známky';
$string['droplowestvalues'] = 'Ignorováno {$a} nejnižších hodnot';
$string['dropped'] = 'Ignorováno';
$string['dropxlowest'] = 'Ignorovat X nejhorších';
$string['dropxlowestwarning'] = 'Pozn.: Pokud používáte funkci \'Ignorovat X nejhorších\', předpokládá se, že všechny položky v dané kategorii mají stejnou hodnotu počtu bodů. Pokud se tyto hodnoty liší, výsledky jsou nepředvídatelné.';
$string['duplicatedgradeitem'] = '{$a} (kopie)';
$string['duplicatescale'] = 'Duplikovat škálu';
$string['edit'] = 'Upravit';
$string['editcalculation'] = 'Upravit výpočet';
$string['editcalculationverbose'] = 'Upravit výpočet pro {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Upravit komentář';
$string['editgrade'] = 'Upravit známku';
$string['editgradeletters'] = 'Upravit slovní známky';
$string['editoutcome'] = 'Upravit očekávaný výstup';
$string['editoutcomes'] = 'Upravit očekávané výstupy';
$string['editscale'] = 'Upravit škálu';
$string['edittree'] = 'Nastavit';
$string['editverbose'] = 'Upravit {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Povolit AJAX';
$string['enableajax_help'] = 'Přidává funkce založené na technologii AJAX do celkového přehledu hodnocení, které zjednodušují a urychlují běžné operace. Prohlížeč musí mít zapnutu podporu JavaScriptu.';
$string['enableoutcomes'] = 'Povolit očekávané výstupy';
$string['enableoutcomes_help'] = 'Je-li povoleno, je možno používat hodnocení činností studentů jednu nebo více škál, které jsou svázány s očekávaným výstupem.';
$string['encoding'] = 'Kódování';
$string['encoding_help'] = 'Vyberte kódování znaků použité pro data. (Standardní kódování je UTF-8). Pokud je omylem vybráno nesprávné kódování, bude to patrné při prohlížení importovaných dat.';
$string['errorcalculationbroken'] = 'Chyba ve výpočtu položky hodnocení {$a}.';
$string['errorcalculationnoequal'] = 'Vzorec musí začínat rovnítkem (např. =1+2)';
$string['errorcalculationunknown'] = 'Neplatný vzorec';
$string['errorgradevaluenonnumeric'] = 'Nenumerická hodnota známky:';
$string['errornocalculationallowed'] = 'Tato položka neumožňuje provádět výpočty';
$string['errornocategorisedid'] = 'Nelze získat id nekategorizovaných';
$string['errornocourse'] = 'Nepodařilo se získat informace o kurzu';
$string['erroroverweight'] = 'Celková váha přesahuje 100 %.';
$string['errorreprintheadersnonnumeric'] = 'Nenumerická hodnota v opakujícím se záhlaví';
$string['errorsavegrade'] = 'Nepodařilo se uložit známku';
$string['errorsettinggrade'] = 'Chyba ukládání  "{$a->itemname}" známek uživatele {$a->userid}';
$string['errorunderweight'] = 'Celková váha je menší než 100 %.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Chyba aktualizace  "Souhrn neprázdných hodnocení" nastavení hodnocení kategorie ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Chyba aktualizace  "Do souhrnu zahrnout výstupy"  nastavení hodnocení kategorie ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Chyba aktualizace typu hodnocení kategorie ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Chyba aktualizace koeficientu hodnocení (váha nebo přičtení ke známce) u položky ID {$a->id}';
$string['eventgradedeleted'] = 'Známka odstraněna';
$string['eventgradeexported'] = 'Známka exportována';
$string['eventgradeitemcreated'] = 'Vytvořena položka známky';
$string['eventgradeitemdeleted'] = 'Položka hodnocení byla odstraněna';
$string['eventgradeitemupdated'] = 'Položka byla aktualizována';
$string['eventgradelettercreated'] = 'Vytvořeno písmeno slovní známky';
$string['eventgradeletterdeleted'] = 'Písmeno slovní známky odstraněno';
$string['eventgradeletterupdated'] = 'Písmeno slovní známky aktualizováno';
$string['eventgradeviewed'] = 'Známky byla zobrazeny v přehledu';
$string['eventscalecreated'] = 'Škála vytvořena';
$string['eventscaledeleted'] = 'Škála odstraněna';
$string['eventscaleupdated'] = 'Škála aktualizována';
$string['eventusergraded'] = 'Známky uživatele jsou editovány v Klasifikaci';
$string['excluded'] = 'Vyřazeno';
$string['excluded_help'] = '<p>Je-li zapnuta volba Vyřazeno, bude tato známka vyloučena ze všech výpočtů souhrnné známky na úrovni nadřazené položky hodnocení nebo kategorie. Tudíž souhrnnou známku neovlivní.</p>';
$string['expand'] = 'Rozbalit kategorii';
$string['expandcriterion'] = 'Rosbalit kritérium';
$string['export'] = 'Export';
$string['exportalloutcomes'] = 'Exportovat všechny očekávané výstupy';
$string['exportas'] = 'Exportovat jako';
$string['exportfeedback'] = 'Zahrnout komentář v exportu';
$string['exportfeedback_desc'] = 'Toto může být přepsáno během exportu.';
$string['exportformatoptions'] = 'Volby exportního formátu';
$string['exportonlyactive'] = 'Vypustit pozastavené uživatele';
$string['exportonlyactive_help'] = 'Zahrnout pouze studenty, kteří jsou zapsáni a jejichž účet nebyl pozastaven';
$string['exportplugins'] = 'Moduly pro export';
$string['exportsettings'] = 'Nastavení exportu';
$string['exportto'] = 'Exportovat do';
$string['externalurl'] = 'Externí URL';
$string['externalurl_desc'] = 'Je-li užita externí klasifikace,  zadejte zde adresu URL.';
$string['extracreditvalue'] = 'Hodnota Extra bodového zisku {$a}';
$string['extracreditwarning'] = 'Poznámka: Pokud nastavíte všechny položky v kategorii jako \'Extra bodový zisk\', vyloučíte je z dalších výpočtů známek. Kategorie totiž nebude obsahovat žádný celkový počet bodů.';
$string['fail'] = 'Nesplněno';
$string['feedback'] = 'Komentář';
$string['feedback_help'] = '<p>Poznámky přidávané učitelem ke známkám. Může se jednat o rozsáhlé osobní sdělení stejně jako o nějaký jednoduchý kód odkazující se na vaše zaběhnuté způsoby a systémy.</p>';
$string['feedbackadd'] = 'Přidat komentář';
$string['feedbackedit'] = 'Upravit komentář';
$string['feedbackfiles'] = 'Soubory zpětné vazby';
$string['feedbackforgradeitems'] = 'Komentář pro {$a}';
$string['feedbackhistoryfiles'] = 'Soubory historie zpětné vazby';
$string['feedbackprovided'] = 'Poskytnuta zpětná vazba';
$string['feedbacks'] = 'Komentáře';
$string['feedbacksaved'] = 'Komentář uložen';
$string['feedbackview'] = 'Zobrazit komentář';
$string['filterbothactive'] = 'První ({$a->first}) Poslední ({$a->last})';
$string['filterbyname'] = 'Filtrovat podle názvu';
$string['filterfirstactive'] = 'První ({$a->first})';
$string['filterlastactive'] = 'Poslední ({$a->last})';
$string['finalgrade'] = 'Výsledná známka';
$string['finalgrade_help'] = '<p>Uložená výsledná známka po provedení všech výpočtů.</p>';
$string['fixedstudents'] = 'Statický sloupec se jmény';
$string['fixedstudents_help'] = 'Umožňuje pohybovat s tabulkou známek, aniž byste ztratili přehled o jménech studentů.';
$string['forceimport'] = 'Vynutit import';
$string['forceimport_help'] = 'Vynutí import známek, i když známky byly aktualizovány po exportu souboru.';
$string['forceoff'] = 'Vnutit: Vypnuto';
$string['forceon'] = 'Vnutit: Zapnuto';
$string['forelementtypes'] = 'pro vybrané: {$a}';
$string['forstudents'] = 'Pro studenty';
$string['full'] = 'Úplný';
$string['fullmode'] = 'Zobrazit známky a souhrnné známky';
$string['generalsettings'] = 'Obecné nastavení';
$string['grade'] = 'Známka';
$string['grade_help'] = 'Získané hodnocení studenta za jeho práci.';
$string['gradeadministration'] = 'Správa známek';
$string['gradealreadyupdated'] = '{$a} známek nebylo importováno, neboť známky v importním souboru jsou starší než v systému. Chcete-li je přesto načíst, použijte vynucený import.';
$string['gradeanalysis'] = 'Analýza hodnocení';
$string['gradebook'] = 'Klasifikace';
$string['gradebookcalculationsfixbutton'] = 'Přijmout změny známek a opravit chyby ve výpočtu';
$string['gradebookcalculationsuptodate'] = 'Výpočty v klasifikaci jsou aktuální. Možná budete muset znovu načíst tuto stránku, abyste viděli změny.';
$string['gradebookcalculationswarning'] = 'Poznámka: Ve výpočtu hodnocení zobrazených v klasifikačním záznamu byly zjištěny některé chyby. Jestli váš kurz nezačal nebo probíhá, doporučuje se opravit chyby kliknutím na tlačítko níže, ačkoli to povede k tomu, že některá hodnocení se změní. Jestli váš kurz již skončil a hodnocení byla odeslána, pravděpodobně tento problém nebudete chtít opravit.

Novější verze je {$a->currentversion}; vy používáte verzi klasifikačního záznamu {$a->gradebookversion}. Seznam změn si můžete prohlédnout na <a href="{$a->url}">Změny výpočtu klasifikačního záznamu</a>.';
$string['gradebookhiddenerror'] = 'Klasifikace je momentálně studentům skrytá.';
$string['gradebookhistories'] = 'Historie známek';
$string['gradebooknavigationmenu'] = 'Nabídka v přehledu známek';
$string['gradebooksetup'] = 'Nastavení hodnocení';
$string['gradeboundary'] = 'Meze slovní známky';
$string['gradeboundary_help'] = '<p>Procentuální hranice, nad kterou bude přiřazována slovní známka (pokud je použit způsob zobrazení Slovní známka).</p>';
$string['gradecategories'] = 'Kategorie známek';
$string['gradecategory'] = 'Kategorie známek';
$string['gradecategoryonmodform'] = 'Kategorie známek';
$string['gradecategoryonmodform_help'] = 'Toto nastavení určuje kategorii, do níž budou známky z této činnosti zařazeny.';
$string['gradecategorysettings'] = 'Nastavení kategorizace známek';
$string['gradedisplay'] = 'Zobrazení známek';
$string['gradedisplaytype'] = 'Typ zobrazení známek';
$string['gradedisplaytype_help'] = 'Toto nastavení určuje, jak budou zobrazeny známky v celkovém přehledu hodnocení a v přehledu hodnocení jednoho uživatele.

* Slovní známka - Písmeno nebo slova jsou používána k reprezentaci rozsahu stupňů, jak definovaný v \'slovní známky\' v nastavení hodnocení
* Procento - ve vztahu k nejnižší a nejvyšší možné hodnotě
* Reálné číslo - Skutečná známka nebo hodnota stupně';
$string['gradedon'] = 'Známkování: {$a}';
$string['gradeexport'] = 'Export hodnocení';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Export vlastních polí profilu';
$string['gradeexportcustomprofilefields_desc'] = 'Seznam vlastních polí v uživatelském profilu, které mají být zahrnuty do exportu známek. Názvy polí oddělte čárkami.';
$string['gradeexportdecimalpoints'] = 'Desetinná místa v exportovaných známkách';
$string['gradeexportdecimalpoints_desc'] = 'Počet desetinných míst, která budou zobrazena při exportu. Toto nastavení můžete v průběhu exportu měnit.';
$string['gradeexportdisplaytype'] = 'Typ zobrazení exportovaných známek';
$string['gradeexportdisplaytype_desc'] = 'Během exportu mohou být známky zobrazeny jako skutečně získané známky (skutečná hodnota), jako procenta (relativně vůči nejnižší a nejvyšší možné) nebo jako slovní známky (např. písmena či slova). Toto nastavení lze pro každý export ještě měnit.';
$string['gradeexportdisplaytypes'] = 'Typy zobrazení exportu známek';
$string['gradeexportuserprofilefields'] = 'Pole uživatelského profilu v exportu známek';
$string['gradeexportuserprofilefields_desc'] = 'Zahrnout tato pole uživatelského profilu v exportu známek, oddělená čárkou';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item} {$a->feedback}';
$string['gradegrademinmax'] = 'Počáteční minimální a maximální známky';
$string['gradehelp'] = 'Nápověda ke známkám';
$string['gradehistorylifetime'] = 'Životnost historie známek';
$string['gradehistorylifetime_help'] = 'Po jak dlouhou dobu uchovávat historii změn v tabulkách hodnocení. Doporučuje se nastavit co nejdelší. Pokud pozorujete problémy s výkonem nebo máte limitované databázové zdroje, můžete zkusit nastavit menší hodnotu.';
$string['gradeimport'] = 'Import hodnocení';
$string['gradeimportfailed'] = 'Import známek se nezdařil. Podrobné informace:';
$string['gradeitem'] = 'Položka hodnocení';
$string['gradeitemaddusers'] = 'Vyřadit z hodnocení';
$string['gradeitemadvanced'] = 'Pokročilé volby položky hodnocení';
$string['gradeitemadvanced_help'] = 'Vyberte všechny prvky, které by měly být při editaci položek hodnocení zobrazeny jako pokročilé.';
$string['gradeitemislocked'] = 'Tato činnost je v klasifikaci zamknutá. Žádné změny v jejích známkách se do klasifikace nezkopírují, dokud nebude činnost odemknuta.';
$string['gradeitemlocked'] = 'Známkování uzamknuto';
$string['gradeitemmembersselected'] = 'Vyřazeni z hodnocení';
$string['gradeitemminmax'] = 'Počáteční minimální a maximální známky, jak je uvedeno v nastavení položky hodnocení';
$string['gradeitemnonmembers'] = 'Zahrnuti do hodnocení';
$string['gradeitemremovemembers'] = 'Zahrnout do hodnocení';
$string['gradeitems'] = 'Položky hodnocení';
$string['gradeitemsettings'] = 'Nastavení položky hodnocení';
$string['gradeitemsinc'] = 'Zahrnuté položky hodnocení';
$string['gradeletter'] = 'Slovní známka';
$string['gradeletter_help'] = '<p>Písmeno nebo jiný symbol reprezentující definovaný interval známek.</p>';
$string['gradeletternote'] = 'Chcete-li odstranit slovní známku, odstraňte obsah kteréhokoli ze<br />tří textových polí pro tuto známku a stiskněte \'Uložit změny\'.';
$string['gradeletteroverridden'] = 'Výchozí hodnoty Slovních známek  jsou aktuálně přepsány.';
$string['gradeletters'] = 'Slovní známky';
$string['gradelocked'] = 'Známka je uzamknuta';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Nejvyšší známka';
$string['grademax_help'] = '<p>Při použití typu známky "hodnota" může být nastavena nejvyšší možná známka. U známkovaných modulů činností se nejvyšší možná známka definuje ve formuláři pro nastavení příslušného modulu.</p>';
$string['grademin'] = 'Nejnižší možná známka';
$string['grademin_help'] = '<p>Při použití typu známky "hodnota" může být nastavena nejnižší možná známka.</p>';
$string['gradenotificationmessage'] = 'Máte novou zpětnou vazbu o své práci pro „{$a}“';
$string['gradenotificationsubject'] = 'Byl jste hodnocen';
$string['gradeoutcomeitem'] = 'Položka hodnocení - očekávaný výstup';
$string['gradeoutcomes'] = 'Očekávaný výstup';
$string['gradeoutcomescourses'] = 'Očekávané výstupy v kurzu';
$string['gradepass'] = 'Potřebná známka';
$string['gradepass_help'] = '<p>Zde lze nastavit hraniční známku, kterou uživatelé musejí získat, aby tuto položku hodnocení zdárně absolvovali.</p>';
$string['gradepassgreaterthangrade'] = 'Požadovaná známka nemůže být větší, než je maximální možná známka {$a}';
$string['gradepointdefault'] = 'Výchozí body známky';
$string['gradepointdefault_help'] = 'Toto nastavení určuje výchozí hodnotu bodů, která je v položce dostupná.';
$string['gradepointdefault_validateerror'] = 'Toto nastavení musí být číslo mezi 1 a maximální hodnotou známky.';
$string['gradepointmax'] = 'Maximální hodnota bodů';
$string['gradepointmax_help'] = 'Toto nastavení určuje maximální  bodovou hodnotu známky, kterou je v činnosti dostupná.';
$string['gradepointmax_validateerror'] = 'Toto nastavení musí být celé číslo mezi 1 a 10000.';
$string['gradepreferences'] = 'Předvolby známky';
$string['gradepreferenceshelp'] = 'Nápověda k předvolbám hodnocení';
$string['gradepublishing'] = 'Povolit zveřejnění';
$string['gradepublishing_help'] = 'Publikování známek je způsob importu a exportu známek prostřednictvím adresy URL, aniž byste byli přihlášeni k Moodle.
Pokud je tato možnost zapnuta, je administrátorům a uživatelům s oprávněním publikovat známky (ve výchozím nastavení jsou uživatelé s rolí manažer) poskytnuto nastavení exportu známek publikovaným v každé klasifikaci kurzu.';
$string['gradepublishinglink'] = 'Stáhnout: {$a}';
$string['gradereport'] = 'Celkový přehled hodnocení';
$string['graderreport'] = 'Celkový přehled hodnocení';
$string['grades'] = 'Známky';
$string['gradesforuser'] = 'Známky uživatele {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Varování: Probíhá odstraňování některých částí kurzu. Příslušné známky budou odstraněny.';
$string['gradesmoduledeletionprefix'] = '[Probíhá odstranění]';
$string['gradesonly'] = 'Zobrazit pouze známky';
$string['gradessettings'] = 'Nastavení známky';
$string['gradetype'] = 'Typ známky';
$string['gradetype_help'] = '<p>Určuje použitý typ známky: "žádná" (hodnocení není možné), "hodnota" (umožňuje nastavit nejvyšší a nejnižší možnou známku), "škála" (umožňuje nastavení škály) nebo "text" (umožňuje pouze komentáře). Pouze známky typu "hodnota" nebo "škála" mouhou být započítávány do souhrnných známek. U známkovaných modulů činností se typ známky definuje ve formuláři pro nastavení příslušného modulu.</p>';
$string['gradevaluetoobig'] = 'Jedna ze známek je větší, než je povolená maximální hodnota {$a}';
$string['gradevaluetoosmall'] = 'Jedna z hodnot hodnocení je menší než povolené minimum {$a}';
$string['gradeview'] = 'Zobrazit známku';
$string['gradewasmodifiedduringediting'] = 'Známka z činnosti {$a->itemname} pro uživatele {$a->username} byla ignorována, neboť někdo jiný ji mezitím upravil.';
$string['gradeweighthelp'] = 'Nápověda k vahám známek';
$string['gradingmodulename'] = 'Hodnocení ({$a})';
$string['groupavg'] = 'Skupinový průměr';
$string['hidden'] = 'Skryto';
$string['hidden_help'] = 'Zda se mají známky skrýt před studenty. Je možno rovněž nastavit skrytí známek až do jistého data.';
$string['hiddenasdate'] = 'Zobrazit datum u skrytých známek';
$string['hiddenasdate_help'] = 'Pokud uživatel nemůže vidět udělenou známku, zobraz namísto \'-\' datum odevzdání.';
$string['hiddenuntil'] = 'Skryto do';
$string['hiddenuntildate'] = 'Skryto do: {$a}';
$string['hideadvanced'] = 'Skrýt pokročilé možnosti';
$string['hideaverages'] = 'Skrýt průměry';
$string['hidecalculations'] = 'Skrýt výpočty';
$string['hidecategory'] = 'Skryto';
$string['hideeyecons'] = 'Skrýt ikonu "ukázat/skrýt"';
$string['hidefeedback'] = 'Skrýt komentáře';
$string['hideforcedsettings'] = 'Skrýt vnucené nastavení';
$string['hideforcedsettings_help'] = 'Nezobrazovat vynucená nastavení v uživatelském rozhraní známkování.';
$string['hidegroups'] = 'Skrýt skupiny';
$string['hidelocks'] = 'Skrýt zámky';
$string['hidenooutcomes'] = 'Zobrazit očekávané výstupy';
$string['hidequickfeedback'] = 'Skrýt rychlý komentář';
$string['hideranges'] = 'Skrýt rozsahy';
$string['hidetotalifhiddenitems'] = 'Skrýt výsledky zahrnující skryté položky';
$string['hidetotalifhiddenitems_help'] = 'Toto nastavení určuje, zda se mají studentům zobrazit výsledné známky, pokud jsou v nich zahrnuty nějaké skryté položky. Nemají-li být zobrazeny, bude namísto nich uvedena pouze pomlčka. Pokud se mají zobrazit, lze dále nastavit, zda se to výsledné známky započítávají i skryté dílčí položky či nikoliv.

Pokud nejsou skryté položky zahrnuty do výsledné známky, uvidí učitelé a studenti rozdílné hodnoty výsledných známek, neboť učitelé vždy vidí všechny známky (včetně skrytých). Pokud jsou skryté položky zahrnuty do výpočtu souhrnné známky, mohou být studenti schopni dopočítat si jejich hodnotu.';
$string['hidetotalshowexhiddenitems'] = 'Zobrazovat výslednou známku bez započítání skrytých známek';
$string['hidetotalshowinchiddenitems'] = 'Zobrazovat výslednou známku vypočítanou i ze skrytých známek';
$string['hideverbose'] = 'Skrýt {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Třídit podle známky vzestupně';
$string['highgradedescending'] = 'Třídit podle známky sestupně';
$string['highgradeletter'] = 'Do';
$string['identifier'] = 'Identifikovat uživatele podle';
$string['idnumbers'] = 'Identifikátory ID';
$string['ignore'] = 'Ignorovat';
$string['import'] = 'Import';
$string['importas'] = 'Importovat jako';
$string['importcsv'] = 'Importovat CSV';
$string['importcsv_help'] = 'Známky lze importovat pomocí CSV souboru s následujícím formátem:

* Každý záznam je na samostatném řádku
* Každý záznam se tvořen posloupností údajů oddělených  vybraným oddělovačem
* První záznam představuje záhlaví a obsahuje požadované identifikační údaje uživatele - buď uživatelské jméno nebo ID číslo nebo e-mailovou adresu

Správný formát souboru, je možno získat tak, že nejprve vyexportujete některé známky. Soubor pak lze upravit a uložit jako soubor ve formátu CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importovat jako výstupy vlastní pouze pro tento kurz';
$string['importdata'] = 'Data';
$string['importdata_help'] = 'Známky lze vložit přímo z tabulky OpenDocument nebo Excel ve formátu následujícím způsobem:

* Minimálně jeden sloupec by měl obsahovat údaje o identitě uživatele - uživatelské jméno, e -mailovou adresu nebo ID číslo.
* Jiné sloupce by měly mít záhlaví pro stávající aktivity nebo položky hodnocení.

Správně formátovanou tabulku lze získat nejprve exportováním některých známek. Tabulku lze poté upravit, přidat další známky a uložit.

Vyberte a zkopírujte sloupce, které chcete importovat z tabulky, a poté je vložte do tohoto pole.';
$string['importerror'] = 'Objevila se chyba. Skript nebyl volán se správnými parametry.';
$string['importfailed'] = 'Import selhal. Žádná data nebyla načtena.';
$string['importfeedback'] = 'Importovat komentáře';
$string['importfile'] = 'Importovat soubor';
$string['importfilemissing'] = 'Nebyl obdržen žádný soubor. Jděte zpět do formuláře a ujistěte se že nahráváte platný soubor.';
$string['importfrom'] = 'Importovat z';
$string['importoutcomenofile'] = 'Nahraný soubor je prázdný nebo poškozený. Prosím ověřte, že používáte platný soubor. Problém se objevil na řádku {$a}. Taková chyba se může objevit, pokud daný řádek nemá tolik tolik sloupců, kolik má první řádek se záhlavním nebo pokud v souboru chybí záhlaví. Prohlédněte si formát exportovaného souboru pro ilustraci platného záhlaví.';
$string['importoutcomes'] = 'Importovat očekávané výstupy';
$string['importoutcomes_help'] = 'Výsledky mohou být importovány pomocí CSV souboru ve stejném formátu  export výsledků v CSV souboru.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importován výstup "{$a->name}" s identifikátorem #{$a->id}';
$string['importplugins'] = 'Moduly pro import';
$string['importpreview'] = 'Náhled importu';
$string['importsettings'] = 'Nastavení importu';
$string['importskippednomanagescale'] = 'Nemáte oprávnění vytvářet nové škály. Očekávaný výstup "{$a}" byl přeskočen, protože vyžaduje vytvoření nové škály.';
$string['importskippedoutcome'] = 'Očekávaný výstup s krátkým názvem "{$a}" již v tomto kontextu existuje. Stejně pojmenovaný očekávaný výstup v souboru byl přeskočen.';
$string['importstandard'] = 'Importovat jako standardní výstupy pro celý server';
$string['importsuccess'] = 'Import proběhl úspěšně';
$string['importxml'] = 'Importovat XML';
$string['includescalesinaggregation'] = 'Zahrnout škály v souhrnných známkách';
$string['includescalesinaggregation_help'] = 'Zda se mají škály započítat jako čísla do všech souhrnných známek ve všech klasifikacích všech kurzů. UPOZORNĚNÍ: změna tohoto nastavení si vynutí přepočítání všech souhrnných známek.';
$string['incorrectcourseid'] = 'Nesprávné ID kurzu';
$string['incorrectcustomscale'] = '(Neplatná vlastní škála - zvolte jinou)';
$string['incorrectminmax'] = 'Nejnižší musí být nižší než nejvyšší';
$string['inherit'] = 'Dědit';
$string['intersectioninfo'] = 'Student/Známka';
$string['invalidgradeexporteddate'] = 'Datum exportu je neplatné, neboť je starší než jeden rok, nebo je v budoucnosti, nebo je jeho formát chybný.';
$string['item'] = 'Položka';
$string['iteminfo'] = 'Informace k položce';
$string['iteminfo_help'] = '<p>Prostor pro doplňující informace o položce hodnocení. Vložený text se nikde nezobrazuje.</p>';
$string['itemname'] = 'Název položky';
$string['itemnamehelp'] = 'Název položky. U známkovaných činností se přebírá z modulu.';
$string['items'] = 'Položky';
$string['itemsedit'] = 'Upravit položku hodnocení';
$string['keephigh'] = 'Uvažovat pouze X nejvyšších';
$string['keephigh_help'] = 'Je-li zde nastavena nějaká hodnota X, pak bude uvažováno pouze X nejvyšších (nejlepších) známek.';
$string['keephighestvalues'] = 'Ponechat {$a} nejlepších známek';
$string['keymanager'] = 'Správa klíčů';
$string['lessthanmin'] = 'Známka z položky hodnocení "{$a->itemname}" u uživatele {$a->username} je menší než nejnižší povolená.';
$string['letter'] = 'Slovní známka';
$string['lettergrade'] = 'Slovní známka';
$string['lettergradenonnumber'] = 'Nenumerická hodnota v Od a/nebo Do';
$string['letterpercentage'] = 'Slovní známka (procenta)';
$string['letterreal'] = 'Slovní známka (skutečná hodnota)';
$string['letters'] = 'Slovní známky';
$string['linkedactivity'] = 'Propojená činnost';
$string['linkedactivity_help'] = '<p>Volitelné nastavení. Propojuje tuto položku hodnocení s některým z modulů činností. Tímto způsobem můžete měřit výkon studenta podle kritérií neuvažovaných ve známce za danou činnost.</p>';
$string['linktoactivity'] = '{$a->name} na činnost {$a->title}';
$string['lock'] = 'Zamknout';
$string['locked'] = 'Zamknuto';
$string['locked_help'] = 'Je-li zaškrtnuto, nebude hodnota zanesené známky aktualizována příslušným modulem činnosti.';
$string['locktime'] = 'Zamknout po';
$string['locktimedate'] = 'Zamknuto po: {$a}';
$string['lockverbose'] = 'Zamknout {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Nejhorší';
$string['lowgradeletter'] = 'Od';
$string['manageoutcomes'] = 'Spravovat výstupy';
$string['manualitem'] = 'Ruční položka';
$string['mapfrom'] = 'Mapovat z';
$string['mapfrom_help'] = 'Vyberte sloupec v datech tabulky obsahující identifikaci uživatele, jako je uživatelské jméno, ID uživatele nebo e-mailovou adresu.';
$string['mappings'] = 'Mapování položek hodnocení';
$string['mappings_help'] = 'Pro každý sloupec známek v tabulce, vyberte příslušnou položku známky k importu známek.';
$string['mapto'] = 'Mapovat na';
$string['mapto_help'] = 'Vyberte stejné identifikační údaje jako vybrané pro "Mapovat z ".';
$string['max'] = 'Nejlepší';
$string['maxgrade'] = 'Nejlepší možná známka';
$string['meanall'] = 'Všechny zmámky';
$string['meangraded'] = 'Neprázdné známky';
$string['meanselection'] = 'Známky vybrané pro průměry ve sloupci';
$string['meanselection_help'] = 'Zda mají být buňky, které neobsahují žádnou známku, zahrnuty při výpočtu průměru v každém sloupci.';
$string['median'] = 'Medián';
$string['min'] = 'Nejhorší';
$string['minimum_show'] = 'Zobrazit minimální známku';
$string['minimum_show_help'] = 'Nejnižší známka je použita pro výpočet známek a vah. Není-li zobrazena, bude nastavena standardně na nulu a nebude možné ji editovat.';
$string['minmaxtouse'] = 'Minimální a maximální známky použité ve výpočtech';
$string['minmaxtouse_desc'] = 'Toto nastavení určuje, zda se má použít počáteční minimální a maximální známky z doby, kdy byla známka nastavena, nebo minimální a maximální známky, jak je uvedeno v nastavení pro položku známky, při výpočtu známky zobrazené v Klasifikaci známek. Doporučuje se, aby toto nastavení bylo modifikován mimo provozní špičku, protože přepočet všech známek může mít za následek vysoké zatížení serveru.';
$string['minmaxtouse_help'] = 'Toto nastavení určuje, zda se má použít počáteční minimální a maximální známky z doby, kdy byla známka nastavena, nebo minimální a maximální známky, jak je uvedeno v nastavení pro položku známky, při výpočtu známky zobrazené v Klasifikaci známek.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Poznámka: Některá hodnocení se změnila, aby se vyřešila nekonzistence v klasifikačním záznamu způsobená změnou minimálního a maximálního hodnocení používaného při výpočtu zobrazeného hodnocení. Doporučuje se, abyste tyto změny posoudil a přijal.';
$string['minmaxupgradefixbutton'] = 'Vyřešit nesrovnalosti';
$string['minmaxupgradewarning'] = 'Poznámka: U některých hodnocení byla zjištěna nekonzistence z důvodu změny minimálního a maximálního hodnocení používaného při výpočtu hodnocení zobrazeného v klasifikačním záznamu. Doporučuje se tuto nekonzistenci vyřešit stlačením tlačítka níže, ačkoli to povede k tomu, že některá hodnocení se změní.';
$string['missingitemtypeoreid'] = 'Chybí klíč pole  (itemtype or eid)';
$string['missingscale'] = 'Musí být zvolená škála';
$string['mode'] = 'Modus';
$string['modgrade'] = 'Známka';
$string['modgrade_help'] = 'Zvolte typ známkování pro tuto činnost. Použijete-li škálu, můžete poté zvolit její typ pomocí rozbalovací nabídky u možnosti Škála. Zvolíte-li body, můžete pro tuto činnost nastavit maximální počet bodů.';
$string['modgradecantchangegradetype'] = 'Nemůžete změnit typ, protože známky pro tuto položku již existují.';
$string['modgradecantchangegradetypemsg'] = 'Již byly přiděleny některé známky, takže typ známky nelze změnit. Chcete-li změnit maximální počet bodů, je třeba nejprve zvolit, zda má nebo nemá proběhnout nové oznámkování, které změní stávající známky.';
$string['modgradecantchangegradetyporscalemsg'] = 'Již byly přiděleny některé známky, takže typ známky nebo škály nelze změnit.';
$string['modgradecantchangeratingmaxgrade'] = 'Maximální počet bodů nemůžete změnit, protože pro některou činnost existují známky.';
$string['modgradecantchangescale'] = 'Škálu nemůžete měnit, protože pro tuto položku existují známky.';
$string['modgradecategorycantchangegradetypemsg'] = 'Tato kategorie je spojena klasifikovanými položkami, které byly přepsány. Z tohoto důvodu již proběhlo známkování, takže typ známky nelze změnit. Chcete-li změnit maximální počet bodů, je třeba nejprve zvolit, zda má nebo nemá proběhnout nové oznámkování, které změní stávající známky.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Tato kategorie je spojena klasifikovanými položkami, které byly přepsány. Z tohoto důvodu již proběhlo známkování, takže typ známky nelze změnit.';
$string['modgradecategoryrescalegrades'] = 'Změnit škály přepsaných známek';
$string['modgradecategoryrescalegrades_help'] = 'Při změně maximální známky v položce hodnocení je třeba určit, zda to způsobí nebo nezpůsobí stejnou procentuální změnu u existujících známek.

Je-li tato volba nastavena na "Ano", budou upraveny veškeré stávající známky tak, že procento známky zůstává stejné.

Například, pokud je tato možnost nastavena na "Ano", změna maximálního počtu bodů  položky z 10 na 20 by změnila známku ze 6/10 (60%) na 12/20 (60%). S touto volbou nastavenou na "Ne", zůstane známka beze změny, pro zajištění správné známky je vyžadován manuální nastavení položek známek .';
$string['modgradedonotmodify'] = 'Neupravujte existující známky';
$string['modgradeerrorbadpoint'] = 'Neplatná hodnota známky. Musí to být celé číslo mezi 1 a {$a}';
$string['modgradeerrorbadscale'] = 'Neplatná škála. Vyberte škálu z uvedeného výběru.';
$string['modgrademaxgrade'] = 'Maximum bodů';
$string['modgraderescalegrades'] = 'Změnit škálu existujících známek';
$string['modgraderescalegrades_help'] = 'Při změně maximální známky v položce hodnocení je třeba určit, zda to způsobí nebo nezpůsobí stejnou procentuální změnu u existujících známek.

Je-li tato volba nastavena na "Ano", budou upraveny veškeré stávající známky tak, že procento známky zůstává stejné.

Například, pokud je tato možnost nastavena na "Ano", změna maximálního počtu bodů  položky z 10 na 20 by změnila známku ze 6/10 (60%) na 12/20 (60%). S touto volbou nastavenou na "Ne", zůstane známka beze změny, pro zajištění správné známky je vyžadován manuální nastavení položek známek .';
$string['modgradetype'] = 'Typ';
$string['modgradetypenone'] = 'Žádná';
$string['modgradetypepoint'] = 'Body';
$string['modgradetypescale'] = 'Škála';
$string['morethanmax'] = 'Známka z položky hodnocení "{$a->itemname}" z uživatele  {$a->username} je větší než nejvyšší možná.';
$string['moveselectedto'] = 'Přesunout označené položky do:';
$string['movesitems'] = 'Přesunout položky';
$string['movingelement'] = 'Přesun {$a}';
$string['multfactor'] = 'Vynásobit známky';
$string['multfactor_help'] = '<p>Činitel, kterým budou vynásobeny všechny známky této položky hodnocení.</p>';
$string['multfactorvalue'] = 'Hodnota multiplikátoru {$a}';
$string['mustchooserescaleyesorno'] = 'Musíte vybrat, zda chcete změnit škálu existujících známek nebo ne.';
$string['mygrades'] = 'Odkaz na známky v uživatelské nabídce';
$string['mygrades_desc'] = 'Toto nastavení umožňuje možnost propojení s externím zadávání známek z uživatelské nabídky.';
$string['mypreferences'] = 'Mé předvolby';
$string['myreportpreferences'] = 'Mé předvolby přehledu';
$string['myself'] = 'Já sám';
$string['navmethod'] = 'Metoda navigace';
$string['neverdeletehistory'] = 'Nikdy neodstraňovat historii';
$string['newcategory'] = 'Nová kategorie';
$string['newitem'] = 'Nová položka hodnocení';
$string['newoutcomeitem'] = 'Nový očekávaný výstup';
$string['no'] = 'Ne';
$string['nocategories'] = 'V tomto kurzu nebylo možno přidat nebo nalézt kategorie známek';
$string['nocategoryname'] = 'Nebylo dáno jméno kategorie';
$string['nocategoryview'] = 'Žádná kategorie k zobrazení pro';
$string['nocourses'] = 'Nenalezeny žádné kurzy';
$string['noexistingoutcomes'] = 'Neexistují žádné výstupy.';
$string['noexistingscales'] = 'Neexistují žádné škály.';
$string['noforce'] = 'Nevnucovat';
$string['nogradeletters'] = 'Nebyly nastaveny slovní známky';
$string['nogradesreturned'] = 'Nebyly nalezeny žádné známky';
$string['noidnumber'] = 'Žádné identifikátory';
$string['nolettergrade'] = 'Žádné slovní známky pro';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Vložena nenumerická hodnota pro';
$string['nonunhideableverbose'] = 'Chcete-li odkrýt toto hodnocení, musíte odkrýt {$a->itemname}.';
$string['nonunlockableverbose'] = 'Chcete-li odemknout toto hodnocení, musíte odemknout {$a->itemname}.';
$string['nonweightedpct'] = 'nevážená %';
$string['nooutcome'] = 'Bez očekávaných výstupů';
$string['nooutcomes'] = 'Hodnocené výstupy musí být provázány s očekávanými výstupy kurzu, ale v tomto kurzu nebyly ještě žádné očekávané výstupy nadefinovány. Přejete si je nyní přidat?';
$string['nopermissiontoresetweights'] = 'Nemáte oprávnění k vymazání váhy známky';
$string['nopublish'] = 'Nezveřejňovat';
$string['noreports'] = 'Nejste zapsán do žádného kurzu anebo neučíte v kurzech.';
$string['norolesdefined'] = 'Nejsou definované žádné role v nabídce Správa stránek > Hodnocení > Obecné nastavení > Role pro hodnocení';
$string['noscales'] = 'Očekávané výstupy lze hodnotit pomocí některé z vlastních nebo standardních (globálních) škál. V tomto kurzu není žádná škála k dispozici. Přejete si nyní škálu přidat?';
$string['noselectedcategories'] = 'nebyly vybrány žádné kategorie';
$string['noselecteditems'] = 'nebyly vybrány žádné položky';
$string['notenrolled'] = 'Aktuálně nejste zapsán do žádného kurzu.';
$string['notteachererror'] = 'Přístup k těmto údajům mají pouze učitelé.';
$string['nousersloaded'] = 'Nebyli nahráni žádní uživatelé';
$string['nouserstograde'] = 'Žádní uživatelé k hodnocení';
$string['numberofgrades'] = 'Počet známek';
$string['onascaleof'] = 'na škále od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Úkony';
$string['options'] = 'Možnosti';
$string['others'] = 'Ostatní';
$string['otheruser'] = 'Uživatel';
$string['outcome'] = 'Očekávaný výstup';
$string['outcome_help'] = 'Určuje očekávaný výstup, který bude tato položka reprezentovat v klasifikaci. Jsou uvedeny pouze očekávané výstupy zahrnuté v tomto kurzu.';
$string['outcomeassigntocourse'] = 'Přidat další očekávaný výstup kurzu';
$string['outcomecategory'] = 'Vytvořit očekávané výstupy v kategorii';
$string['outcomecategorynew'] = 'Nová kategorie';
$string['outcomeconfirmdelete'] = 'Jste si jistí, že chcete odstranit očekávaný výstup "{$a}"?';
$string['outcomecreate'] = 'Přidat nový očekávaný výstup';
$string['outcomedelete'] = 'Odstranit očekávaný výstup';
$string['outcomefullname'] = 'Celý název';
$string['outcomeitem'] = 'Hodnocený očekávaný výstup';
$string['outcomeitemsedit'] = 'Upravit hodnocený výstup';
$string['outcomereport'] = 'Přehled očekávaných výstupů';
$string['outcomes'] = 'Očekávané výstupy';
$string['outcomescourse'] = 'Očekávané výstupy použité v kurzu';
$string['outcomescoursecustom'] = 'Vlastní použitý (neodstrňovat)';
$string['outcomescoursenotused'] = 'Standardní nepoužitý';
$string['outcomescourseused'] = 'Standardní použitý (neodstraňovat)';
$string['outcomescustom'] = 'Vlastní očekávané výstupy';
$string['outcomesdisabled'] = 'Výsledky nejsou povoleny';
$string['outcomeshortname'] = 'Krátký název';
$string['outcomesstandard'] = 'Standardní očekávané výstupy';
$string['outcomesstandardavailable'] = 'Dostupné standardní očekávané výstupy';
$string['outcomestandard'] = 'Standardní očekávané výstupy';
$string['outcomestandard_help'] = '<p>Standardní očekávaný výstup je dostupný na celém serveru ve všech kurzech.</p>';
$string['overallaverage'] = 'Celkový průměr';
$string['overridden'] = 'Přenastaveno';
$string['overridden_help'] = '<p>Tento příznak znemožňuje další pokusy o automatickou úpravu hodnoty známky. Většinou je nastaven interně samotným Moodlem, ale může být ručně zapnut nebo vypnut pomocí tohoto formulářového prvku.</p>';
$string['overriddennotice'] = 'Vaše výsledná známka za tuto činnost byla ručně upravena.';
$string['overridecat'] = 'Povolit ruční přepis známky kategorie';
$string['overridecat_help'] = 'Zákaz tohoto nastavení znemožňuje uživatelům přepsat známky kategorie';
$string['overridesitedefaultgradedisplaytype'] = 'Přenastavit výchozí hodnoty serveru';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Zda se má povolit přenastavování výchozích hodnot týkajících se zobrazování známek na tomto serveru. Aktivují se formulářové prvky pro nastavení vlastních slovních známek a jejich hraničních hodnot dle vašeho výběru.</p>';
$string['overrideweightofa'] = 'Přepsat váhu {$a}';
$string['parentcategory'] = 'Nadřazená kategorie';
$string['pass'] = 'Splněno';
$string['pctoftotalgrade'] = '% celkové známky';
$string['percent'] = 'Procenta';
$string['percentage'] = 'Procentuální hodnota';
$string['percentageletter'] = 'Procenta (slovní známka)';
$string['percentagereal'] = 'Procenta (skutečná hodnota)';
$string['percentascending'] = 'Třídit podle procent vzestupně';
$string['percentdescending'] = 'Třídit podle procent sestupně';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Přičíst ke známkám';
$string['plusfactor_help'] = '<p>Číslo, které bude přičteno ke každé známce v této položce. Známky se nejprve násobí hodnotou činitelem uvedeným v poli "Násobit známky", teprve poté se k nim přičítá hodnota pole "Přičíst ke známkám".</p>';
$string['plusfactorvalue'] = 'Přičtená hodnota {$a}';
$string['points'] = 'bodů';
$string['pointsascending'] = 'Třídit podle bodů vzestupně';
$string['pointsdescending'] = 'Řadit podle bodů sestupně';
$string['positionfirst'] = 'První';
$string['positionlast'] = 'Poslední';
$string['preferences'] = 'Předvolby';
$string['prefgeneral'] = 'Obecné';
$string['prefletters'] = 'Slovní známky a jejich hraniční hodnoty';
$string['prefrows'] = 'Zvláštní řádky';
$string['prefshow'] = 'Ukázat/skrýt';
$string['previewrows'] = 'Náhled řádků';
$string['privacy:metadata:categorieshistory'] = 'Záznam předchozích verzí kategorií známek';
$string['privacy:metadata:filepurpose'] = 'Soubory zpětné vazby uložené ve známkách uživatele.';
$string['privacy:metadata:grade_import_newitem'] = 'Dočasná tabulka pro ukládání nových jmen grade_item z importu známek';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Jedinečný kód dávky pro identifikaci jedné dávky importu';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Uživatel importující data';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Název nové položky známky';
$string['privacy:metadata:grade_import_values'] = 'Dočasná tabulka pro import známek';
$string['privacy:metadata:grade_import_values:feedback'] = 'Komentář známky';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Prvotní hodnota známky';
$string['privacy:metadata:grade_import_values:importcode'] = 'Jedinečný kód dávky pro identifikaci jedné dávky importu';
$string['privacy:metadata:grade_import_values:importer'] = 'Uživatel importující data';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Příznak, zda byly importovány pouze komentáře';
$string['privacy:metadata:grade_import_values:userid'] = 'Uživatel, jehož známka byla importována';
$string['privacy:metadata:grades'] = 'Záznam známek';
$string['privacy:metadata:grades:aggregationstatus'] = 'Stav agregace';
$string['privacy:metadata:grades:aggregationweight'] = 'Váha v souhrnném výpočtu';
$string['privacy:metadata:grades:feedback'] = 'Komentář';
$string['privacy:metadata:grades:finalgrade'] = 'Známka';
$string['privacy:metadata:grades:information'] = 'Další informace o hodnocení';
$string['privacy:metadata:grades:timemodified'] = 'Čas poslední změny známky';
$string['privacy:metadata:grades:userid'] = 'ID známkovaného uživatele';
$string['privacy:metadata:grades:usermodified'] = 'ID uživatele, který naposledy změnil záznam';
$string['privacy:metadata:gradeshistory'] = 'Záznam předchozích známek';
$string['privacy:metadata:history:loggeduser'] = 'ID uživatele, který byl přihlášen při provedení verzování';
$string['privacy:metadata:history:timemodified'] = 'Čas, kdy došlo k verzování';
$string['privacy:metadata:itemshistory'] = 'Záznam předchozích verzí položek známky';
$string['privacy:metadata:outcomes'] = 'Záznam očekávaných výstupů';
$string['privacy:metadata:outcomes:timemodified'] = 'Čas změny záznamu';
$string['privacy:metadata:outcomes:usermodified'] = 'Uživatel, který naposledy změnil záznam';
$string['privacy:metadata:outcomeshistory'] = 'Záznam předchozích verzí očekávaných výstupů';
$string['privacy:metadata:scale'] = 'Záznam škál';
$string['privacy:metadata:scale:timemodified'] = 'Čas poslední změny záznamu';
$string['privacy:metadata:scale:userid'] = 'Uživatel, který změnil záznam naposledy';
$string['privacy:metadata:scalehistory'] = 'Záznam předchozích verzí škál';
$string['privacy:path:relatedtome'] = 'Související se mnou';
$string['privacy:request:historyactiondelete'] = 'Odstranit';
$string['privacy:request:historyactioninsert'] = 'Vložit';
$string['privacy:request:historyactionupdate'] = 'Upravit';
$string['privacy:request:unknowndeletedgradeitem'] = 'Neznámé (položka hodnocení byla smazána)';
$string['profilereport'] = 'Přehled známek uživatele';
$string['profilereport_help'] = 'Přehled hodnocení použitý na stránce s uživatelským profilem';
$string['publishing'] = 'Zveřejnění';
$string['publishingoptions'] = 'Nastavení publikování známek';
$string['quickfeedback'] = 'Rychlý komentář';
$string['quickgrading'] = 'Rychlé hodnocení';
$string['quickgrading_help'] = '<p>Rychlé hodnocení vkládá malé textové pole do všech buněk tabulky v celkovém přehledu hodnocení. Můžete tak najednou vyplnit větší množství známek a všechny je uložit najednou pomocí tlačítka Aktualizovat.</p>';
$string['range'] = 'Rozsah';
$string['rangedecimals'] = 'Desetinná místa';
$string['rangedecimals_help'] = 'Počet desetinných míst pro zobrazení rozsahu známky.';
$string['rangesdecimalpoints'] = 'Počet desetinných míst v rozsahu';
$string['rangesdecimalpoints_help'] = 'Toto nastavení určuje počet desetinných míst, která se mají zobrazit pro každý rozsah, nebo zda se použije celkové nastavení desetinných míst pro kategorii nebo známku (zdědí se).';
$string['rangesdisplaytype'] = 'Typ zobrazení rozsahu';
$string['rangesdisplaytype_help'] = '<p>Jak zobrazovat rozsahy hodnot. Je-li zvoleno "Dědit", je použit stejný typ zobrazení, jaký je nastaven u hodnot v daném sloupci.</p>';
$string['rank'] = 'Umístění';
$string['rawpct'] = 'Hrubých %';
$string['real'] = 'Skutečná hodnota';
$string['realletter'] = 'Skutečná hodnota (slovní známka)';
$string['realpercentage'] = 'Skutečná hodnota (procenta)';
$string['recalculatinggrades'] = 'Přepočítat známky';
$string['recovergradesdefault'] = 'Obnovit výchozí hodnocení';
$string['recovergradesdefault_help'] = 'Při obnoveném zápisu studenta do kurzu se obnoví staré hodnocení.';
$string['refreshpreview'] = 'Obnovit náhled';
$string['regradeanyway'] = 'Přesto znovu oznámkovat';
$string['removeallcoursegrades'] = 'Odstranit všechny známky';
$string['removeallcoursegrades_help'] = 'Zaškrtnutím pole odstraníte všechny známky, které byly ručně zapsané do klasifikace v kurzu, zároveň s potlačenými, vyloučenými, skrytými a zamknutými známkami. Zachovají se pouze položky známek související s činnostmi.';
$string['removeallcourseitems'] = 'Odstranit všechny položky a kategorie';
$string['removeallcourseitems_help'] = 'Zaškrtnutím pole odstraníte všechny kategorie a položky známek, které byly do klasifikace vloženy ručně, zároveň s potlačenými, vyloučenými, skrytými a zamknutými známkami a daty. Zachovají se pouze položky známek související s činnostmi.';
$string['report'] = 'Přehled';
$string['reportdefault'] = 'Výchozí pro přehled ({$a})';
$string['reportplugins'] = 'Typy přehledů';
$string['reportsettings'] = 'Nastavení přehledu';
$string['reprintheaders'] = 'Opakovat záhlaví';
$string['resetweights'] = 'Obnovit váhu {$a->itemname}';
$string['resetweightsshort'] = 'Obnovit váhy';
$string['respectingcurrentdata'] = 'ponechat stávající konfiguraci nezměněnou';
$string['rowpreviewnum'] = 'Náhled řádků';
$string['rowpreviewnum_help'] = 'Před potvrzením importu dat si můžete zobrazit náhled dat k importování. Toto nastavení určuje, kolik řádků má být zobrazeno v rámci náhledu.';
$string['savechanges'] = 'Uložit změny';
$string['savepreferences'] = 'Uložit předvolby';
$string['scaleconfirmdelete'] = 'Skutečně chcete odstranit škálu "{$a}"?';
$string['scaledpct'] = 'Škálovaná %';
$string['searchcollapsedcolumns'] = 'Prohledat sbalené sloupce';
$string['seeallcoursegrades'] = 'Zobrazit všechny známky v kurzu';
$string['select'] = 'Vyberte {$a}';
$string['selectalloroneuser'] = 'Vyberte všechny nebo jednoho uživatele';
$string['selectauser'] = 'Vyberte uživatele';
$string['selectdestination'] = 'Vyberte cíl pro {$a}';
$string['selectgrouplink'] = 'Vybrat skupinu';
$string['selectuserlink'] = 'Vybrat uživatele';
$string['separator'] = 'Oddělovač';
$string['separator_help'] = 'Vyberte oddělovač použitý v souboru CSV. (Obvykle je to čárka).';
$string['sepcolon'] = 'Dvojtečka';
$string['sepcomma'] = 'Čárka';
$string['sepsemicolon'] = 'Středník';
$string['septab'] = 'Tabulátor';
$string['setcategories'] = 'Nastavit kategorie';
$string['setcategorieserror'] = 'Před nastavením jejich vah musíte nejdřive ve vašem kurzu definovat kategorie známek.';
$string['setgradeletters'] = 'Nastavit slovní známky';
$string['setpreferences'] = 'Nastavit předvolby';
$string['setting'] = 'Nastavení';
$string['settings'] = 'Nastavení';
$string['setup'] = 'Nastavit';
$string['setweights'] = 'Nastavit váhy';
$string['showactivityicons'] = 'Ukázat ikony činností';
$string['showactivityicons_help'] = '<p>Zda zobrazovat ikony činností vedle jejich názvů.</p>';
$string['showallgrades'] = 'Zobrazit všechny známky';
$string['showallhidden'] = 'Zobrazit skryté';
$string['showallstudents'] = 'Ukázat všechny studenty';
$string['showanalysisicon'] = 'Zobrazit ikonu analýzy hodnocení';
$string['showanalysisicon_desc'] = 'Zda se má zobrazit ikona analýzy hodnocení. Pokud daná činnost podporuje hodnocení, ikona odkazuje na stránku s detailním vysvětlením, jak bylo hodnocení získáno.';
$string['showanalysisicon_help'] = 'Pokud to podporuje modul činnosti, ikona analýza známky odkazuje na stránku s podrobnější vysvětlení známky a jak to byla získána.';
$string['showaverage'] = 'Zobrazit průměr';
$string['showaverage_help'] = 'Zda se má zobrazovat sloupec s průměrnou hodnotou. Studenti mohou být schopni odhadnout známky ostatních studentů, je-li průměr počítán z malého množství známek. Z důvodů výkonnosti je průměr pouze přibližný, pokud závisí na nějaké skryté položce.';
$string['showaverages'] = 'Ukázat průměry sloupců';
$string['showaverages_help'] = 'Zda zobrazovat průměrnou hodnotu každého sloupce.';
$string['showcalculations'] = 'Ukázat výpočty';
$string['showcalculations_help'] = 'Pokud je povoleno, při úpravách se pro každou položku hodnocení a kategorii zobrazí ikona kalkulačky s vizuálním indikátorem, že je položka hodnocení vypočítaná.';
$string['showcontributiontocoursetotal'] = 'Zobrazit podíl z celkové známky kurzu';
$string['showcontributiontocoursetotal_help'] = 'Zobrazit další sloupec, který obsahuje vypočítaný podíl z celkové známky kurzu (po použití váhy známky)?';
$string['showeyecons'] = 'Ukázat ikony "ukázat/skrýt"';
$string['showeyecons_help'] = 'Zda zobrazovat ikonu "ukázat/skrýt" u každé známky (ovlivňuje viditelnost dané známky pro uživatele).';
$string['showfeedback'] = 'Ukázat komentáře';
$string['showfeedback_help'] = 'Zda se má zobrazit sloupec obsahující doplňující komentáře ke známkám.';
$string['showgrade'] = 'Zobrazit známky';
$string['showgrade_help'] = 'Zda se má zobrazit sloupec se známkami.';
$string['showgroups'] = 'Ukázat skupiny';
$string['showhiddenitems'] = 'Ukázat skryté položky';
$string['showhiddenitems_help'] = 'Určuje, jak se mají zobrazovat skryté položky hodnocení a jejich názvy.

* Zobrazit skryté - studenti vidí názvy skrytých položek, ale nikoliv známku samotnou
* Pouze skryté do - položky s nastaveným datem "skrýt do" jsou zcela skryty až do nastaveného data. Poté je celá položka zobrazena normálně.
* Nezobrazovat - skryté položky se nezobrazují vůbec (ani název, ani známky)';
$string['showhiddenuntilonly'] = 'Pouze skryté do';
$string['showingaggregatesonly'] = 'Zobrazení pouze souhrnných známek';
$string['showingfullmode'] = 'Zobrazení známek a souhrnných známek';
$string['showinggradesonly'] = 'Zobrazit pouze známky';
$string['showlettergrade'] = 'Ukázat slovní hodnocení';
$string['showlettergrade_help'] = 'Zda se má zobrazit sloupec slovního hodnocení.';
$string['showlocks'] = 'Ukázat zámky';
$string['showlocks_help'] = 'Zda zobrazovat ikonu zamknout/odemknout u každé známky.';
$string['shownohidden'] = 'Nezobrazovat';
$string['shownooutcomes'] = 'Skrýt výstupy';
$string['shownumberofgrades'] = 'Zobrazovat počet známek v průměrech';
$string['shownumberofgrades_help'] = 'Zda zobrazit počet známek, z nichž byl vypočítán průměr v závorkách za tímto průměrem, např. 45 (34).';
$string['showonlyactiveenrol'] = 'Zobrazit pouze aktivní zapsané studenty';
$string['showonlyactiveenrol_help'] = 'Toto nastavení určuje, zda budou v sestavě známek zobrazení jen aktivní zapsaní uživatelé. Jsou-li povoleni pozastavení uživatelé, nebudou v sestavě známek uvedeni.';
$string['showpercentage'] = 'Ukázat procenta';
$string['showpercentage_help'] = 'Zda se má zobrazit procentuální hodnota u každé položky hodnocení.';
$string['showquickfeedback'] = 'Ukázat rychlý komentář';
$string['showquickfeedback_help'] = 'Rychlý komentář vkládá malé textové pole do všech buněk tabulky v celkovém přehledu hodnocení. Můžete tak najednou vyplnit větší množství komentářů a všechny je uložit najednou pomocí tlačítka Aktualizovat.';
$string['showrange'] = 'Ukázat rozsahy';
$string['showrange_help'] = 'Zda se má zobrazit sloupec rozsahu.';
$string['showranges'] = 'Ukázat rozsahy';
$string['showranges_help'] = 'Zda přidat řádek pro zobrazení rozsahu známek v každém sloupci.';
$string['showrank'] = 'Ukázat umístění';
$string['showrank_help'] = 'Zda se má zobrazit pro každou položku hodnocení umístění daného uživatele oproti zbytku třídy.';
$string['showuserimage'] = 'Zobrazovat fotografie uživatelů';
$string['showuserimage_help'] = 'Zda v celkovém přehledu hodnocení zobrazovat fotografie uživatelů vedle jejich jména.';
$string['showverbose'] = 'Zobrazit {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Ukázat váhy';
$string['showweight_help'] = 'Zda se má zobrazit sloupec s váhami známek.';
$string['simpleview'] = 'Jednoduché zobrazení';
$string['sitewide'] = 'Pro celý server';
$string['sort'] = 'řadit';
$string['sortasc'] = 'Řadit vzestupně';
$string['sortbyfirstname'] = 'Řadit podle jména';
$string['sortbylastname'] = 'Řadit podle příjmení';
$string['sortdesc'] = 'Řadit sestupně';
$string['standarddeviation'] = 'Standardní odchylka';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Stat';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Studentů na stránku';
$string['studentsperpage_help'] = 'Počet studentů na stránce v celkovém přehledu hodnocení.';
$string['studentsperpagereduced'] = 'Snižte maximální počet studentů na stránce z {$a->originalstudentsperpage} na {$a->studentsperpage}. Zvažte nastavení PHP max_input_vars from {$a->maxinputvars}.';
$string['subcategory'] = 'Normální kategorie';
$string['submissions'] = 'Odevzdané úkoly';
$string['submittedon'] = 'Odevzdáno: {$a}';
$string['sumofgradesupgradedgrades'] = 'Poznámka: Metoda agregace "Vážený součet známek" byla změněna na "Součet známek", jako součást aktualizace stránek. Vzhledem k tomu, že v tomto kurzu byl použit "Vážený součet známek" , doporučujeme,  abyste si zkontrolovali zadání přehledu známek.';
$string['switchtofullview'] = 'Přepnout do úplného režimu';
$string['switchtosimpleview'] = 'Přepnout do zjednodušeného režimu';
$string['tabs'] = 'Záložky';
$string['topcategory'] = 'Nadkategorie';
$string['total'] = 'Celkem';
$string['totalweight100'] = 'Celková váha je rovna 100';
$string['totalweightnot100'] = 'Celková váha není rovna 100';
$string['turnfeedbackoff'] = 'Vypnout komentáře';
$string['turnfeedbackon'] = 'Zapnout komentáře';
$string['typenone'] = 'Žádná';
$string['typescale'] = 'Škála';
$string['typescale_help'] = '<p>Pro typ "škála" je potřeba zvolit typ použité škály. U známkovaných modulů činností se použitá škála definuje ve formuláři pro nastavení příslušného modulu.</p>';
$string['typetext'] = 'Text';
$string['typevalue'] = 'Hodnota';
$string['uncategorised'] = 'Nezařazeno';
$string['unchangedgrade'] = 'Známka nezměněná';
$string['unenrolledusersinimport'] = 'Import obsahoval následující známky uživatelů, kteří momentálně nejsou zapsáni v tomto kurzu: {$a}';
$string['unlimitedgrades'] = 'Neomezené známky';
$string['unlimitedgrades_help'] = 'Při výchozím chování jsou hodnoty známek omezeny maximální a minimální možnou hodnotou pro danou položku hodnocení. Tímto nastavením lze tyto limity odstranit a umožnit tak např. vkládat známky nad 100% přímo do třídní knihy.';
$string['unlock'] = 'Odemknout';
$string['unlockverbose'] = 'Odemknout {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nepoužito';
$string['updatedgradesonly'] = 'Exportovat pouze nové nebo aktualizované známky';
$string['upgradedgradeshidemessage'] = 'Odmítnout oznámení';
$string['upgradedminmaxrevertmessage'] = 'Vrátit změny';
$string['uploadgrades'] = 'Nahrát známky';
$string['useadvanced'] = 'Zobrazit pokročilé možnosti';
$string['usedcourses'] = 'Použité kurzy';
$string['usedgradeitem'] = 'Použité položky hodnocení';
$string['usenooutcome'] = 'Nepoužívej žádné očekávané výstupy';
$string['usenoscale'] = 'Nepoužívej žádné škály';
$string['usepercent'] = 'Použít procenta';
$string['user'] = 'Uživatel';
$string['userenrolmentsuspended'] = 'Zápis uživatele pozastaven';
$string['userfields_show'] = 'Zobrazit uživatelská pole';
$string['userfields_show_help'] = 'Do sestavy známek zobrazit další uživatelská pole, jako je e-mailová adresa.  Zobrazení vybraných polí  je řízeno nastavením stránky zobrazit identitu.';
$string['usergrade'] = 'Uživatel {$a->fullname} ({$a->useridnumber}), položka {$a->gradeidnumber}';
$string['userid'] = 'ID uživatele';
$string['useridnumberwarning'] = 'Uživatelé bez identifikačního čísla, jsou vyloučeny z exportu, protože nelze importovat';
$string['usermappingerror'] = 'Chyba mapování uživatele: Nelze najít uživatele s {$a->field} z "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Uživatel není členem aktuální skupiny.';
$string['usermappingerrormultipleusersfound'] = 'Chyba mapování uživatele: Více uživatelů nalezených s {$a->field} ze "{$a->value}".Použijte prosím unikátní pole pro mapování.';
$string['usermappingerrorusernotfound'] = 'Chyba mapování uživatele: Nelze najít uživatele.';
$string['userpreferences'] = 'Uživatelské předvolby';
$string['useweighted'] = 'Použít váhy';
$string['verbosescales'] = 'Doslovné škály';
$string['verbosescales_help'] = 'Podrobná škála používá slova spíše než čísla. Nastavte "Ano", pokud mají být impotovány numerické známky a škály. Nastavte "Ne", pokud jsou importovány jen číselné známky.';
$string['viewas'] = 'Zobrazit přehled jako';
$string['viewbygroup'] = 'Skupina';
$string['viewfeedback'] = 'Zobrazit zpětnou vazbu';
$string['viewgrades'] = 'Zobrazit známky';
$string['weight'] = 'Váha';
$string['weight_help'] = 'Hodnota použitá ke stanovení relativní hodnoty známek v kategorii nebo kurzu.';
$string['weightcourse'] = 'Použij vážené známky pro kurz';
$string['weightedascending'] = 'Třídit podle vážených procent vzestupně';
$string['weighteddescending'] = 'Třídit podle vážených procent sestupně';
$string['weightedpct'] = 'vážená %';
$string['weightedpctcontribution'] = 'vážená';
$string['weightofa'] = 'Váha {$a}';
$string['weightorextracredit'] = 'Váha nebo extra zisk';
$string['weightoverride'] = 'upravení váhy';
$string['weightoverride_help'] = 'Abyste resetovali  automaticky vypočtenou  váhu své známky, zrušte zaškrtnutí. Zabráníte tím automatickému nastavení vah.';
$string['weights'] = 'Váhy';
$string['weightsadjusted'] = 'Vaše váhy byly upraveny na celkových 100.';
$string['weightsedit'] = 'Upravit váhy a extra zisky';
$string['weightuc'] = 'Vypočtená váha';
$string['writinggradebookinfo'] = 'Zapisuji nastavení klasifikace';
$string['xml'] = 'XML';
$string['yes'] = 'Ano';
$string['yourgrade'] = 'Vaše známka';
