<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'teamup', language 'af', version '4.3'.
 *
 * @package     teamup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abc'] = 'Serie #';
$string['addanewquestion'] = 'Voeg \'n nuwe vraag by';
$string['addnewcriterion'] = '+ Voeg kriterium by';
$string['addnewquestion'] = 'Voeg nuwe Vraag by';
$string['addnewsubcriterion'] = 'Voeg nuwe subkriterium by';
$string['addtogrouping'] = 'Voeg by groepring';
$string['afterdate'] = 'Jy sal nie jou vraelys ná hierdie datum kan wysig nie.';
$string['aggFilter'] = 'Filter aan';
$string['aggregate'] = 'Aggregaat';
$string['aggregatelabel'] = 'Groepeer soortgelyke individue';
$string['all'] = 'alle';
$string['allstudents'] = 'Alle studente';
$string['analyzeaggregatewarning'] = '<br><span style="color:{color};">Kriterium {answer}: <b> {nbstudent} </b> => Hulle sal waarskynlik {nbgroup} groepe van {nbstudentgroup} studente met {reste} studente versprei hê</span>';
$string['analyzeaggregatewarningOK'] = '<br><span style="color:{color};"> Kriterium {answer}: <b> {nbstudent} </b> => Hulle sal waarskynlik {nbgroup} groepe van {nbstudentgroup} studente hê</span>';
$string['analyzebalancewarning'] = '<span style=\\"color:red;\\">Die resultaat is nie numeries nie, kies asseblief \'n geskikte vraag.</span>';
$string['analyzeclustercriterion'] = 'Die aantal studente wat aan hierdie kriteria voldoen is <b> {nbstudent} </b> versprei oor <b> {nbteam} </b> spanne';
$string['analyzeclustersuccess'] = '<br>Daar kan twee studente in alle groepe met hierdie kriteria wees.';
$string['analyzeclusterwarning'] = '<br><span style="color:red;">Aandag: daar kan nie twee studente in alle groepe met hierdie kriteria wees nie.</span>';
$string['analyzedistributecriterion'] = '<br> Kriterium {answer} : <b>{nbstudent}</b>=> <b>{status}</b>';
$string['analyzedistributesuccess'] = 'Geen probleem om dit na <b> {nbteam} </b> spanne te versprei nie';
$string['analyzedistributewarning'] = '<span style=\\"color:red;\\">Aandag: probleem met verspreiding daarvan na <b> {nbteam} </b> spanne</span>';
$string['and'] = 'EN';
$string['answers'] = 'Antwoorde';
$string['answersSubmitted'] = 'Jou antwoorde is ingedien';
$string['answertype'] = 'Antwoordtipe';
$string['any'] = 'enige';
$string['anyOption'] = 'Kies enige (of geen) van die volgende:';
$string['assignrandomly'] = 'Wys Lukraak toe';
$string['atleastoneOption'] = 'Kies <strong>minstens een</strong> van die volgende:';
$string['average'] = 'Gemiddeld';
$string['averagesuccess'] = 'Die gemiddeld is redelik naby aan die algehele gemiddeld';
$string['averagewarning'] = 'Die gemiddeld is te ver van die globale gemiddeld';
$string['balance'] = 'Balans';
$string['balancelabel'] = 'Balansvlak';
$string['bankQuestion'] = 'Vraagbank';
$string['bidon'] = 'vals';
$string['bornes'] = 'Grense';
$string['buildteams'] = 'Groepskepping';
$string['cannotupdate'] = 'Jy kan nie \'n teamup-eksemplaar bywerk nadat dit oopgemaak het nie.';
$string['closedate'] = 'Sluitingsdatum';
$string['cluster'] = 'Kluster';
$string['clusterlabel'] = 'Vermy minderhede';
$string['confirmgroupbuilding'] = 'Is jy seker jy wil jou groepe nou skep?';
$string['creategroups'] = 'Skep Groepe binne Moodle';
$string['createteams'] = 'Skep die groepe';
$string['criterionquestion'] = 'Minstens een student wat {question} beantwoord het:';
$string['deleteAllRed'] = 'Wis alle studente sonder \'n antwoord uit';
$string['distribute'] = 'Versprei';
$string['distributelabel'] = 'Versprei soortgelyke individue';
$string['distributionmode'] = 'Verspreidingsmodus';
$string['dontassigngrouptogrouping'] = 'Moet nie groepe aan \'n Groepering toewys nie';
$string['equalize'] = 'Effeneer';
$string['equalizeHelp'] = 'Dwing effenering van die aantal studente in elke groep. Dit is soms nodig ná optimisering';
$string['exportexcel'] = 'Laai alle antwoorde in Excel af';
$string['fiveOption'] = 'Kies vyf van die volgende:';
$string['fourOption'] = 'Kies vier van die volgende:';
$string['groupName'] = 'Groepname';
$string['groupNoOptimal'] = 'Nie-optimale groepe';
$string['groupSchemaName'] = 'Naamgewingskema vir die groepe';
$string['groupTitle'] = 'Groep';
$string['groupcreationsuccess'] = 'Die groepe is suksesvol geskep';
$string['helperror'] = 'Jy moet \'n course_module-ID of \'n eksemplaar-ID spesifiseer';
$string['helpserie'] = '<p>
                                          Die groepskeppingmodule kan gebruik word om reekse te skep. <br>
                                          Reekse is groepe van studente wat met alfabetiese volgorde as enkele kriterium geskep is.<br>
                                          Hierdie groepe ontvang die prefiksterm \\"Series\\" bv: \\"Series 01\\" <br>
                                          Die nuttigheid van Reeksgroepe is dat hulle gebruik word as filters op die lys van studente.<br>
                                          By verstek skep jy groepe van alle studente in die klas. <br>
                                          Reekse laat toe dat hulle op \'n subgroep van spesifieke studente geskep word. <br>
                                          Dit is nuttig vir onder andere groot klasse. <br>
                                          Dit is moontlik om self reekse te skep, ongeag die reeksknoppie. <br>
                                          Wanneer die groep in Moodle geskep word, wanneer die naam van hierdie groep versoek word, begin die groepnaam met Series bv. \\"Real Class Series\\". <br>
                                          Cella laat toe dat jy die aantal deelnemers in die kursus verminder deur assistente of studente wat nie teenwoordig is nie, in berekening te bring.<br>
                                          Wanneer die reeks geskep is, verdwyn die reeksknoppie. Om dit weer te laat verskyn, indien nodig, moet jy al die reeksgroepe uitwis.<br>
                                          Dit is egter steeds moontlik om dit te skep deur Series as prefiks aan die groepnaam te plaas.<br>
                                        </p>';
$string['helpserie_help'] = 'Reekskonsep';
$string['idincorrect'] = 'Kursusmodule-ID was verkeerd of is verkeerd gekonfigureer';
$string['import'] = 'Voer in';
$string['importquestionsfrom'] = 'Voer vrae in vanaf';
$string['intro'] = 'Inleiding';
$string['intro_help'] = 'Die inleiding tot jou Team up-eksemplaar.';
$string['jserror01'] = 'Voer asseblief minstens twee antwoorde in';
$string['jserror02'] = 'Voer asseblief minstens vier antwoorde in';
$string['jserror03'] = 'Voer asseblief minstens vyf antwoorde in';
$string['jserror04'] = 'Voer asseblief minstens ses antwoorde in';
$string['keepAllRed'] = 'Behou slegs studente sonder antwoord';
$string['modulename'] = 'TeamUp';
$string['modulename_help'] = 'TeamUp is \'n hulpmiddel om studente aan Moodle-groepe toe te wys, gebaseer op hul antwoorde op \'n reeks vrae wat jy spesifiseer.
Die idee is om \'n aantal meervoudigekeusevrae te skryf, uiteindelik met beperkings, en om die studente se antwoorde te gebruik om groepe saam te stel, met 4 benaderings:
* Aggregaat: Groepeer studente met \'n sekere eienskap saam in dieselfde groepe
* Versprei: Versprei studente met \'n sekere eienskap oor alle groepe, sodat elke groep dieselfde aantal van hulle het
* Kluster: Verseker dat studente met \'n sekere eienskap nie in \'n groep geïsoleer word nie
* Balanseer: Verseker gelyke kragtigheid van groepe, gebaseer op \'n numeriese telling
Die algoritme vul die groepe sodat almal dieselfde aantal groeplede het.

TeamUp is \'n vertakking van die Moodle-invoegtoepassing <a href=\\"https://moodle.org/plugins/mod_teambuilder\\" target=\\"_blank\\"> Team Builder </a> wat ons as model gebruik het om ons koppelvlak te ontwerp.
Die TeamUp-herverdelingsalgoritme en die opsies is geïnspireer deur die Open Source-projek <a href=\\"https://www.groupeng.org/GroupENG\\" target=\\"_blank\\"> GroupEng </a>.';
$string['modulenameplural'] = 'TeamUp';
$string['name'] = 'Naam';
$string['namingscheme_help'] = 'Die by-simbool (@/aapstertjie) kan gebruik word om groepe te skep met name wat letters bevat. Byvoorbeeld: Groep @ sal groepe genereer wat Groep A, Groep B, Groep C, ... genoem word.

Die hekkiesimbool (#) kan gebruik word om groepe te skep met name wat getalle bevat. Byvoorbeeld: Groep # sal groepe genereer wat Groep 1, Groep 2, Groep 3, ... genoem word.

As jy \'n kriterium gebruik om soortgelyke individue saam te groepeer, kan jy die geassosieerde opsie in die groep opbring deur die "*" karakter te gebruik, voorbeeld van aanbevole benamingskema: "Groep # - *"
(Onthou om redelike kort opsies vir hierdie kriterium op te stel, om lang groepname te vermy.)';
$string['nbGroupSuccess'] = 'Aantal groepe suksesvol voltooi';
$string['nbStudent'] = 'Aantal studente';
$string['noanswer'] = 'Hierdie student het nie gereageer nie.';
$string['noeditingafteropentime'] = 'Jy kan nie die vraelys wysig as dit reeds oopgemaak is nie.';
$string['none'] = 'Geen';
$string['noneedtocomplete'] = 'Dit is nie nodig dat jy die vraelys voltooi nie.';
$string['notopen'] = 'Hierdie vraelys is nie oop nie.';
$string['numberofteams'] = 'Aantal spanne';
$string['oneOption'] = 'Kies <strong>een</strong> van die volgende:';
$string['opendate'] = 'Aanvangsdatum';
$string['or'] = 'OF';
$string['pleaseatleastonequestion'] = 'Voer asseblief minstens \'n vraag in';
$string['pleasenever'] = 'Moet asseblief NOOIT hierdie bladsy met F5 (soortgelyk) of die navigasieverfrisknoppie verfris nie. Kliek asseblief eerder op die aktiwiteitnaam op die broodkrummel';
$string['pleasequestion'] = 'Voer asseblief \'n vraag in';
$string['pleasewait'] = 'Dankie vir jou geduld';
$string['pluginadministration'] = 'TeamUp-administrasie';
$string['pluginname'] = 'TeamUp';
$string['prefixteamnames'] = 'Prefiks groepname met Groeperingsnaam';
$string['presentation'] = '<h3> Module-oorsig </h3>
<p>
Die doel van die TeamUp-module is om die skep van groepe toe te laat, gebaseer op \'n meervoudigeantwoordvraagopname, met moontlike beperkings.

<p>
Die eerste oortjie, <b>Vraelys</b>, laat jou toe om die vrae vir studente te skep.<br>
<p>Voorskou vrae</b>, die tweede oortjie, verskaf die vraelys aan studente om te beantwoord. <br>
Die laaste oortjie, <b>Groepskepping</b>, stel jou in staat om die groepskepping te lanseer.

</p>

<p>
Die groepskepping vind in twee stappe plaas. Die eerste is \'n simulasie.
Tydens sumulasie is dit moontlik om kriteria te wysig om dit te hersorteer en om studente per hand uit een groep na \'n ander te skuif.
Met die volgende stap word die groepe werklik in Moodle geskep. <br>
Moet nie vergeet om <button type=\\"button\\" class=\\"creategroups\\" style=\\"font-size: 1.0em;\\" id=\\"\\">Skep Groepe binne Moodle</button> te kliek om die groepskepping te finaliseer nie.<br>
</p>

<p>
Daar is 4 operateurs om groepe te skep. <br>
Daar is vier basiese operateurs om groepe te skep. <br>
<table class="mod-teamup-table">
  <tr><td>Groepeer soortgelyke individue</td><td> = Vorm groepe waarvan die lede soortgelyk aan gedefinieerde kriteria is. Die skep van homogene groepe. Toegepas op diskrete waardes, met geen verpligting hoegenaamd numeries nie.</td></tr>
  <tr><td>Versprei soortgelyke individue</td><td> = Versprei kwalifiserende studente oor die groepe. Toegepas op diskrete waardes, met geen verpligting hoegenaamd numeries nie.</td></tr>
  <tr><td>Vermy minderhede</td><td> = Verdeel studente sodat minstens twee studente wat \'n kriterium deel in dieselfde groep is (veral vir minderhede). Toegepas op diskrete waardes, met geen verpligting hoegenaamd numeries nie.</td></tr>
  <tr><td>Balanseer Vlak</td><td> = Skep groepe wat \\"right\\" is, wie se totale kragte soortgelyk in alle groepe is (gewoonlik op akademiese uitslae gebaseer). Toegepas op numeriese waardes (volgehou en diskreet).</td></tr>
</table>
</p>

<p>
Wanner jy \'n groepverspreiding vooraf besigtig, kan jy op \'n studentblok kliek om die inligting en antwoorde in \'n nutswenk te sien. <br>
As een student nie deur die groepverspreiding hoef te gaan nie, kan jy op die X ten opsigte van die naam kliek om hom uit die groepvoorskou te verwyder.
</p>

<u>Die aksiestafie:</u><br>
Aantal spanne:<input id="nbteam" min="1" style="width:40px;height:21px;margin-top:5px;margin-right:5px;" value="31" type="number" disabled="">31 / 123(4)</span>&nbsp;<button type=\\"button\\" id=\\"buildteams\\" class="">
<strong>Voorskou</strong></button>&nbsp;<button type=\\"button\\" id=\\"resetteams\\" class=\\"\\">Herstel</button>&nbsp;<button type=\\"button\\" id=\\"prettify\\" style=\\"\\">Optimaliseer</button>&nbsp;<button type=\\"button\\" id=\\"equalize\\" style=\\"\\">Effeneer</button>
<ul>
  <li> Die aantal spanne stel die aantal studente in elke groep vas. Byvoorbeeld: 123 studente in 31 groepe het 4 individue per groep tot gevolg.</li>
  <li>Voorskou: Hierdie knoppie lanseer die groepskepping met die gekose kriteria. </li>
  <li>Herstel: Hierdie knoppie maak alle groepe leeg en stel studente in die deel <b> nie geraak tot groepe nie</b>.</li>
  <li>Optimaliseer: Hierdie knoppie bring sekere veranderinge in studentverspreiding aan om kriteria te verbeter. Sukses word nie gewaarborg nie, maar jy kan optimalisering etlike kere herhaal.</li>
  <li>Effeneer: Dwing om die getal studente in elke groep te effeneer. Dit is soms ná optimalisering nodig.</li>
</ul>
</p>';
$string['prettify'] = 'Optimaliseer';
$string['prettifyHelp'] = 'Hierdie knoppie bring sekere veranderinge aan in studentverspreiding om die kriteria te verbeter. Sukses word nie gewaarborg nie, maar jy kan die optimalisering etlike kere herhaal.';
$string['preview'] = 'Voorskou';
$string['previewQuestion'] = 'Besigtig vrae vooraf';
$string['prioritize'] = 'Prioritiseer';
$string['prioritizeequal'] = 'gelyke groepgetalle';
$string['prioritizemostcriteria'] = 'voldoen aan die meeste kriteria';
$string['privacy:metadata:teamup_response'] = 'Inligting oor die gebruiker se antwoorde op \'n gegewe TeamUp-aktiwiteit';
$string['privacy:metadata:teamup_response:answerid'] = 'Die antwoord wat die gebruiker gekies het.';
$string['privacy:metadata:teamup_response:userid'] = 'Die gebruiker wat die antwoord gegee het.';
$string['question'] = 'Vraag';
$string['questionnaire'] = 'Vraelys';
$string['replay'] = 'Speelweer sonder herstel';
$string['reportDetail'] = 'Gedetailleerde verslag';
$string['resetteams'] = 'Herstel';
$string['save'] = 'Berg';
$string['saved'] = 'Geberg!';
$string['savequestionnaire'] = 'Berg Vraelys';
$string['saving'] = 'Word geberg ...';
$string['selectany'] = 'Kies enige (of geen) opsie';
$string['selectatleastone'] = 'Kies een of meer opsies';
$string['selectfive'] = 'Kies vyf opsies';
$string['selectfour'] = 'Kies vier opsies';
$string['selectone'] = 'Kies een opsie';
$string['selectthree'] = 'Kies drie opsies';
$string['selecttwo'] = 'Kies twee opsies';
$string['standarddeviation'] = 'Standaardafwyking';
$string['summary'] = 'Opsomming';
$string['teamup'] = 'TeamUp';
$string['teamup:addinstance'] = 'Voeg \'n nuwe TeamUp-module by';
$string['teamup:build'] = 'Bou groepe uit opnamerespons';
$string['teamup:create'] = 'Skep opname';
$string['teamup:respond'] = 'Beantwoord Vraelys';
$string['teamupsuccess'] = 'Suksesvolle groepverspreiding';
$string['teamupsuccessnbr'] = 'Aantal groepe suksesvol voltooi';
$string['teamupwarning'] = 'Verspreiding het misluk';
$string['threeOption'] = 'Kies drie van die volgende:';
$string['total'] = 'Totaal';
$string['twoOption'] = 'Kies twee van die volgende:';
$string['unassignedtoteams'] = 'Nie aan groepe toegewys nie';
$string['updateanswer'] = 'Laat bywerking van antwoorde toe';
