<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'mn', version '4.3'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Хаяг';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Холбоост бичвэр оруулах/өөрчлөх';
$string['advanced:backcolor_desc'] = 'Дэвсгэр өнгө сонгох';
$string['advanced:block'] = 'Загвар';
$string['advanced:blockquote'] = 'Эшлэл';
$string['advanced:blockquote_desc'] = 'Эшлэл';
$string['advanced:bold_desc'] = 'Тод (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Тоочсон жагсаалт оруулах/хасах';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Тусгай тэмдэгт оруулах';
$string['advanced:cleanup_desc'] = 'Замбараагүй кодыг цэгцлэх';
$string['advanced:clipboard_msg'] = 'Хуулах, таслах, буулгах үйлдэл нь Mozilla болон Firefox дээр боломжгүй. Та илүү ихийг мэдэхийг хүсэж байна уу?';
$string['advanced:code'] = 'Код';
$string['advanced:code_desc'] = 'HTML код засах';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Хуулах';
$string['advanced:custom1_desc'] = 'Тайлбарлах хэсэг';
$string['advanced:cut_desc'] = 'Таслах';
$string['advanced:dd'] = 'Тодорхойлолтын тайлбар';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Нэр томьёоны тодорхойлолт';
$string['advanced:font_size'] = 'Фонтын хэмжээ';
$string['advanced:fontdefault'] = 'Фонтын нэр';
$string['advanced:forecolor_desc'] = 'Бичвэрийн өнгийг сонгох';
$string['advanced:h1'] = 'Гарчиг 1';
$string['advanced:h2'] = 'Гарчиг 2';
$string['advanced:h3'] = 'Гарчиг 3';
$string['advanced:h4'] = 'Гарчиг 4';
$string['advanced:h5'] = 'Гарчиг 5';
$string['advanced:h6'] = 'Гарчиг 6';
$string['advanced:help_desc'] = 'Тусламж';
$string['advanced:help_shortcut'] = 'Хэрэгслийн мөр рүү шилжихэд ALT-F10, тусламж руу шилжихэд ALT-0 дарна уу.';
$string['advanced:hr_desc'] = 'Хэвтээ шугам оруулах';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Зураг оруулах/өөрчлөх';
$string['advanced:image_props_desc'] = 'Зургийн шинж чанар';
$string['advanced:indent_desc'] = 'Догол мөрийн хэмжээг нэмэгдүүлэх';
$string['advanced:italic_desc'] = 'Налуу (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Голд зэрэгцүүлэх';
$string['advanced:justifyfull_desc'] = 'Хоёр талд зэрэг зэрэгцүүлэх';
$string['advanced:justifyleft_desc'] = 'Зүүн зэрэгцүүлэх';
$string['advanced:justifyright_desc'] = 'Баруун зэрэгцүүлэх';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Холбоос оруулах/өөрчлөх';
$string['advanced:more_colors'] = 'Бусад өнгө...';
$string['advanced:newdocument'] = 'Та бүх агуулгыг устгахдаа итгэлтэй байна уу?';
$string['advanced:newdocument_desc'] = 'Шинэ баримт';
$string['advanced:numlist_desc'] = 'Дугаарласан жагсаалт оруулах/хасах';
$string['advanced:outdent_desc'] = 'Догол мөрийн хэмжээг багасгах';
$string['advanced:paragraph'] = 'Цогцолбор';
$string['advanced:paste_desc'] = 'Буулгах';
$string['advanced:path'] = 'Зам';
$string['advanced:pre'] = 'Урьдчилсан хэлбэржүүлэлт';
$string['advanced:redo_desc'] = 'Дахин хийх (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Хэлбэржүүлэлт устгах';
$string['advanced:rich_text_area'] = 'Олон хэлбэрт бичвэр талбар';
$string['advanced:samp'] = 'Жишээ код';
$string['advanced:shortcuts_desc'] = 'Хэрэглэх тусламж';
$string['advanced:striketrough_desc'] = 'Дарсан';
$string['advanced:style_select'] = 'Хэв';
$string['advanced:sub_desc'] = 'Суурь хэлбэр';
$string['advanced:sup_desc'] = 'Зэрэг хэлбэр';
$string['advanced:toolbar'] = 'Хэрэгслийн мөр';
$string['advanced:toolbar_focus'] = 'Хэрэгслийн товч руу үсрэхэд: Alt+Q; Засварлагч руу үсрэхэд: Alt-Z; Элементийн зам руу үсрэхэд: Alt-X';
$string['advanced:underline_desc'] = 'Доогуур зураас (Ctrl+U)';
$string['advanced:undo_desc'] = 'Буцаах (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Холбоос салгах';
$string['advanced:visualaid_desc'] = 'Туслах шугам/үл үзэгдэх элементүүдийг харуулах/далдлах';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Зохиогч';
$string['advanced_dlg:about_general'] = 'Тухай';
$string['advanced_dlg:about_help'] = 'Тусламж';
$string['advanced_dlg:about_license'] = 'Лиценз';
$string['advanced_dlg:about_loaded'] = 'Ачаалагдсан нэмэлт хэрэгслүүд';
$string['advanced_dlg:about_plugin'] = 'Нэмэлт хэрэгсэл';
$string['advanced_dlg:about_plugins'] = 'Нэмэлт хэрэгслүүд';
$string['advanced_dlg:about_title'] = 'TinyMCE тухай';
$string['advanced_dlg:about_version'] = 'Хувилбар';
$string['advanced_dlg:accessibility_help'] = 'Хэрэглэх тусламж';
$string['advanced_dlg:accessibility_usage_title'] = 'Нийтлэг хэрэглээ';
$string['advanced_dlg:anchor_invalid'] = 'Холбоост бичвэрийн нэрийг зөв тодорхойлно уу.';
$string['advanced_dlg:anchor_name'] = 'Холбоост бичвэрийн нэр';
$string['advanced_dlg:anchor_title'] = 'Холбоост бичвэр оруулах/өөрчлөх';
$string['advanced_dlg:charmap_title'] = 'Тусгай тэмдэгт оруулах';
$string['advanced_dlg:charmap_usage'] = 'Шилжихдээ зүүн болон баруун сумыг ашиглана.';
$string['advanced_dlg:code_title'] = 'HTML код засварлах';
$string['advanced_dlg:code_wordwrap'] = 'Үгээр тасалж мөр шилжих';
$string['advanced_dlg:colorpicker_color'] = 'Өнгө:';
$string['advanced_dlg:colorpicker_name'] = 'Нэр:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Нэрлэсэн';
$string['advanced_dlg:colorpicker_named_title'] = 'Нэрлэсэн өнгө';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Нийлүүр';
$string['advanced_dlg:colorpicker_palette_title'] = 'Өнгөний нийлүүр';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Шилж сонгох';
$string['advanced_dlg:colorpicker_picker_title'] = 'Өнгө шилж сонгогч';
$string['advanced_dlg:colorpicker_title'] = 'Өнгө сонгоно уу';
$string['advanced_dlg:image_align'] = 'Зэрэгцүүлэлт';
$string['advanced_dlg:image_align_baseline'] = 'Суурь шугам';
$string['advanced_dlg:image_align_bottom'] = 'Доор';
$string['advanced_dlg:image_align_left'] = 'Зүүн';
$string['advanced_dlg:image_align_middle'] = 'Дунд';
$string['advanced_dlg:image_align_right'] = 'Баруун';
$string['advanced_dlg:image_align_textbottom'] = 'Бичвэрийн доор';
$string['advanced_dlg:image_align_texttop'] = 'Бичвэрийн дээр';
$string['advanced_dlg:image_align_top'] = 'Дээр';
$string['advanced_dlg:image_alt'] = 'Зургийн тайлбар';
$string['advanced_dlg:image_border'] = 'Хүрээ';
$string['advanced_dlg:image_dimensions'] = 'Хэмжээс';
$string['advanced_dlg:image_hspace'] = 'Хөндлөн зай';
$string['advanced_dlg:image_list'] = 'Зургийн жагсаалт';
$string['advanced_dlg:image_src'] = 'Зургийн URL зам';
$string['advanced_dlg:image_title'] = 'Зураг оруулах/өөрчлөх';
$string['advanced_dlg:image_vspace'] = 'Босоо зай';
$string['advanced_dlg:invalid_color_value'] = 'Өнгөний утга буруу байна';
$string['advanced_dlg:link_is_email'] = 'Таны оруулсан URL нь цахим шуудангийн хаяг шиг харагдаж байна. Та түүнд mailto: гэсэн угтвар нэмэхийг хүсэж байна уу?';
$string['advanced_dlg:link_is_external'] = 'Таны оруулсан URL нь гадаад холбоос шиг харагдаж байна. Зөв холбоос болгохын тулд http:// нэмэх үү?';
$string['advanced_dlg:link_list'] = 'Холбоосын жагсаалт';
$string['advanced_dlg:link_target'] = 'Цонх';
$string['advanced_dlg:link_target_blank'] = 'Шинэ цонхонд нээх';
$string['advanced_dlg:link_target_same'] = 'Тухайн цонхонд нээх';
$string['advanced_dlg:link_title'] = 'Холбоос оруулах/өөрчлөх';
$string['advanced_dlg:link_titlefield'] = 'Гарчиг';
$string['advanced_dlg:link_url'] = 'URL холбоос';
$string['advhr:advhr_desc'] = 'Хөндлөн шугам оруулах';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Энгийн';
$string['advhr_dlg:noshade'] = 'Сүүдэргүй';
$string['advhr_dlg:size'] = 'Өндөр';
$string['advhr_dlg:width'] = 'Өргөн';
$string['advhr_dlg:widthunits'] = 'хэмжих нэгж';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Зураг оруулах/засварлах';
$string['advimage_dlg:align'] = 'Зэрэгцүүлэлт';
$string['advimage_dlg:align_baseline'] = 'Суурь шугам';
$string['advimage_dlg:align_bottom'] = 'Доор';
$string['advimage_dlg:align_left'] = 'Зүүн';
$string['advimage_dlg:align_middle'] = 'Дунд';
$string['advimage_dlg:align_right'] = 'Баруун';
$string['advimage_dlg:align_textbottom'] = 'Бичвэрийн доор';
$string['advimage_dlg:align_texttop'] = 'Бичвэрийн дээр';
$string['advimage_dlg:align_top'] = 'Дээр';
$string['advimage_dlg:alt'] = 'Зургийн тайлбар';
$string['advimage_dlg:alt_image'] = 'Хоёрдогч зураг';
$string['advimage_dlg:border'] = 'Хүрээ';
$string['advimage_dlg:classes'] = 'Анги';
$string['advimage_dlg:constrain_proportions'] = 'Хэмжээс';
$string['advimage_dlg:dialog_title'] = 'Зураг оруулах/засах';
$string['advimage_dlg:dimensions'] = 'Хэмжээс';
$string['advimage_dlg:example_img'] = 'Зургийн харагдах байдлыг урьдчилан харах';
$string['advimage_dlg:general'] = 'Ерөнхий';
$string['advimage_dlg:height'] = 'Өндөр';
$string['advimage_dlg:hspace'] = 'Хөндлөн зай';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Зургийн жагсаалт';
$string['advimage_dlg:langcode'] = 'Хэлний код';
$string['advimage_dlg:langdir'] = 'Бичих чиглэл';
$string['advimage_dlg:list'] = 'Зургийн жагсаалт';
$string['advimage_dlg:long_desc'] = 'Дэлгэрэнгүй тайлбар';
$string['advimage_dlg:ltr'] = 'Зүүнээс баруун';
$string['advimage_dlg:map'] = 'Бүсчилсан зураг';
$string['advimage_dlg:misc'] = 'Элдэв зүйлс';
$string['advimage_dlg:missing_alt'] = 'Зургийн тайлбар оруулахгүй цааш үргэлжлүүлэхдээ итгэлтэй байна уу? Зарим хөгжлийн бэрхшээлтэй хэрэглэгч болон бичвэр хөтөч эсвэл зураг харуулахгүй байхаар тохируулсан веб хөтөч ашиглаж буй хэрэглэгчид ойлгомжгүй байдал үүсэхийг анхаарна уу.';
$string['advimage_dlg:mouseout'] = 'Хулгана гарахад';
$string['advimage_dlg:mouseover'] = 'Хулгана ороход';
$string['advimage_dlg:preview'] = 'Урьдчилан харах';
$string['advimage_dlg:rtl'] = 'Баруунаас зүүн';
$string['advimage_dlg:src'] = 'Зургийн URL';
$string['advimage_dlg:style'] = 'Загвар';
$string['advimage_dlg:swap_image'] = 'Зураг солих';
$string['advimage_dlg:tab_advanced'] = 'Нарийвчилсан';
$string['advimage_dlg:tab_appearance'] = 'Харагдац';
$string['advimage_dlg:tab_general'] = 'Ерөнхий';
$string['advimage_dlg:title'] = 'Гарчиг';
$string['advimage_dlg:vspace'] = 'Босоо зай';
$string['advimage_dlg:width'] = 'Өргөн';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Холбоос оруулах/засах';
$string['advlink_dlg:accesskey'] = 'Хандах товч';
$string['advlink_dlg:advanced_props'] = 'Нарийвчилсан шинж';
$string['advlink_dlg:advanced_tab'] = 'Нарийвчилсан';
$string['advlink_dlg:anchor_names'] = 'Холбоост бичвэр';
$string['advlink_dlg:classes'] = 'Анги';
$string['advlink_dlg:encoding'] = 'Товлосон кодчилол';
$string['advlink_dlg:event_props'] = 'Үзэгдэл';
$string['advlink_dlg:events_tab'] = 'Үзэгдэл';
$string['advlink_dlg:general_props'] = 'Ерөнхий шинж';
$string['advlink_dlg:general_tab'] = 'Ерөнхий';
$string['advlink_dlg:height'] = 'Өндөр';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Таны оруулсан URL нь цахим шуудангийн хаяг шиг харагдаж байна. Та түүнд mailto: гэсэн угтвар нэмэхийг хүсэж байна уу?';
$string['advlink_dlg:is_external'] = 'Таны оруулсан URL нь гадаад холбоос шиг харагдаж байна. Зөв холбоос болгохын тулд http:// гэсэн утгвар нэмэх үү?';
$string['advlink_dlg:langcode'] = 'Хэлний код';
$string['advlink_dlg:langdir'] = 'Бичих чиглэл';
$string['advlink_dlg:link_list'] = 'Холбоосын жагсаалт';
$string['advlink_dlg:list'] = 'Холбоосын жагсаалт';
$string['advlink_dlg:ltr'] = 'Зүүнээс баруун';
$string['advlink_dlg:mime'] = 'Товлосон MIME төрөл';
$string['advlink_dlg:popup'] = 'Жаваскрипт нэмэлт цонх';
$string['advlink_dlg:popup_dependent'] = 'Хамааралтай (Зөвхөн Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Хаягийн мөр харуулах';
$string['advlink_dlg:popup_menubar'] = 'Цэсийн мөр харуулах';
$string['advlink_dlg:popup_name'] = 'Цонхны нэр';
$string['advlink_dlg:popup_opts'] = 'Сонголт';
$string['advlink_dlg:popup_position'] = 'Байрлал (X/Y)';
$string['advlink_dlg:popup_props'] = 'Нэмэлт цонхны шинж';
$string['advlink_dlg:popup_resizable'] = 'Цонхны хэмжээг өөрчлөхийг зөвшөөрөх';
$string['advlink_dlg:popup_return'] = '\'return false\' оруулах';
$string['advlink_dlg:popup_scrollbars'] = 'Гүйлгүүр харуулах';
$string['advlink_dlg:popup_size'] = 'Хэмжээ';
$string['advlink_dlg:popup_statusbar'] = 'Төлөвийн мөр харуулах';
$string['advlink_dlg:popup_tab'] = 'Нэмэлт цонх';
$string['advlink_dlg:popup_toolbar'] = 'Хэрэгслийн мөр харуулах';
$string['advlink_dlg:popup_url'] = 'Нэмэлт цонхны URL';
$string['advlink_dlg:rel'] = 'Хуудаснаас товлосон руу хамаарал';
$string['advlink_dlg:rev'] = 'Товлосноос хуудас руу хамаарал';
$string['advlink_dlg:rtl'] = 'Баруунаас зүүн';
$string['advlink_dlg:style'] = 'Формат';
$string['advlink_dlg:tabindex'] = 'Табаар шилжих дугаар';
$string['advlink_dlg:target'] = 'Товлосон';
$string['advlink_dlg:target_blank'] = 'Шинэ цонхонд нээх';
$string['advlink_dlg:target_langcode'] = 'Товлосон хэл';
$string['advlink_dlg:target_name'] = 'Товлосон нэр';
$string['advlink_dlg:target_parent'] = 'Үндсэн цонх /фрэймд нээх';
$string['advlink_dlg:target_same'] = 'Тухайн цонхонд/фрэймд нээх';
$string['advlink_dlg:target_top'] = 'Хамгийн дээд фрэймд нээх (бүх фрэймийг солих)';
$string['advlink_dlg:title'] = 'Холбоос оруулах/засах';
$string['advlink_dlg:titlefield'] = 'Гарчиг';
$string['advlink_dlg:url'] = 'URL холбох';
$string['advlink_dlg:width'] = 'Өргөн';
$string['advlist:circle'] = 'Тойрог';
$string['advlist:def'] = 'Үндсэн';
$string['advlist:disc'] = 'Диск';
$string['advlist:lower_alpha'] = 'Жижиг үсэг';
$string['advlist:lower_greek'] = 'Жижиг грек үсэг';
$string['advlist:lower_roman'] = 'Жижиг латин үсэг';
$string['advlist:square'] = 'Дөрвөлжин';
$string['advlist:types'] = 'Төрөл';
$string['advlist:upper_alpha'] = 'Том үсэг';
$string['advlist:upper_roman'] = 'Том латин үсэг';
$string['aria:rich_text_area'] = 'Олон хэлбэрт бичвэр талбар';
$string['autosave:restore_content'] = 'Автоматаар хадгалагдсан агуулгыг сэргээх';
$string['autosave:unload_msg'] = 'Хэрэв энэ хуудсыг орхивол таны хийсэн өөрчлөлтүүд устах болно.';
$string['autosave:warning_message'] = 'Хадгалсан агуулгыг сэргээх үед засварлагч дээр байгаа бүх агуулга устах болно.

Та хадгалсан агуулгаа сэргээхдээ итгэлтэй байна уу?';
$string['availablebuttons'] = 'Ашиглах боломжтой товчууд';
$string['colors:000000'] = 'Хар';
$string['colors:000080'] = 'Хар хөх';
$string['colors:0000FF'] = 'Хөх';
$string['colors:003300'] = 'Хар ногоон';
$string['colors:003366'] = 'Номин хар';
$string['colors:008000'] = 'Ногоон';
$string['colors:008080'] = 'Цайвар';
$string['colors:00CCFF'] = 'Тэнгэрийн хөх';
$string['colors:00FF00'] = 'Тод ногоон';
$string['colors:00FFFF'] = 'Усан цэнхэр';
$string['colors:333300'] = 'Гүн ногоон';
$string['colors:333333'] = 'Хар саарал';
$string['colors:333399'] = 'Гүн цэнхэр';
$string['colors:3366FF'] = 'Тод цэнхэр';
$string['colors:339966'] = 'Далай ногоон';
$string['colors:33CCCC'] = 'Оюу';
$string['colors:666699'] = 'Хөх саарал';
$string['colors:800000'] = 'Улаан хүрэн';
$string['colors:800080'] = 'Нил ягаан';
$string['colors:808000'] = 'Шар ногоон';
$string['colors:808080'] = 'Саарал';
$string['colors:993300'] = 'Гүн шаргал';
$string['colors:993366'] = 'Бор';
$string['colors:999999'] = 'Үнсэн саарал';
$string['colors:99CC00'] = 'Шар ногоон';
$string['colors:99CCFF'] = 'Гүехэн хөх';
$string['colors:C0C0C0'] = 'Мөнгөлөг';
$string['colors:CC99FF'] = 'Гүн ягаан';
$string['colors:CCFFCC'] = 'Цайвар ногоон';
$string['colors:CCFFFF'] = 'Цайвар цэнхэр';
$string['colors:FF0000'] = 'Улаан';
$string['colors:FF00FF'] = 'Үзмэн ягаан';
$string['colors:FF6600'] = 'Улбар шар';
$string['colors:FF9900'] = 'Хув';
$string['colors:FF99CC'] = 'Ягаан';
$string['colors:FFCC00'] = 'Алтлаг';
$string['colors:FFCC99'] = 'Улаан шарга';
$string['colors:FFFF00'] = 'Шар';
$string['colors:FFFF99'] = 'Цайвар шар';
$string['colors:FFFFFF'] = 'Цагаан';
$string['common:apply'] = 'Хэрэглэх';
$string['common:browse'] = 'Гүйлгэн үзэх';
$string['common:cancel'] = 'Цуцлах';
$string['common:class_name'] = 'Анги';
$string['common:clipboard_msg'] = 'Хуулах/таслах/буулгах үйлдэл нь Mozilla болон Firefox хөтөч дээр боломжгүй. Та илүү дэлгэрэнгүй мэдээлэл авах уу?';
$string['common:clipboard_no_support'] = 'Одоогоор таны хөтөч дээр дэмжигдээгүй байна. Та үүний оронд товчилбор хэрэглэнэ үү.';
$string['common:close'] = 'Хаах';
$string['common:edit_confirm'] = 'Та энэ бичвэр талбарт WYSIWYG горим ашиглахыг хүсэж байна уу?';
$string['common:insert'] = 'Оруулах';
$string['common:invalid_data'] = 'Алдаа: Та улаанаар тэмдэглэсэн алдаатай утгыг оруулсан байна.';
$string['common:invalid_data_min'] = '{#field} нь {#min}-с их тоо байх ёстой';
$string['common:invalid_data_number'] = '{#field} нь тоо байх ёстой';
$string['common:invalid_data_size'] = '{#field} нь тоо эсвэл хувь байх ёстой.';
$string['common:more_colors'] = 'Бусад өнгө...';
$string['common:not_set'] = '-- Тогтоогоогүй --';
$string['common:popup_blocked'] = 'Программд шаардлагатай цонхыг таны нэмэлт цонх-блоклогч  идэвхгүй болгосон байна. Программыг бүрэн зөв ажиллуулахын тулд нэмэлт цонх-блоклогчийг идэвхгүй болгох хэрэгтэй.';
$string['common:update'] = 'Шинэчлэх';
$string['common:value'] = '(утга)';
$string['contextmenu:align'] = 'Зэрэгцүүлэлт';
$string['contextmenu:center'] = 'Голлуулах';
$string['contextmenu:full'] = 'Дүүргэх';
$string['contextmenu:left'] = 'Зүүн';
$string['contextmenu:right'] = 'Баруун';
$string['customconfig'] = 'Хэрэглэгчийн тохируулга';
$string['customconfig_desc'] = 'JSON файлын формат дахь хэрэглэгчийн нарийвчилсан TinyMCE тохиргоо, жишээ нь: {"option1" : "value2", "option2" : "value2"}. Энд заасан сонголтууд нь стандарт болон нэмэлт хэрэгслийн тохиргоог хүчингүй болгодог.';
$string['customtoolbar'] = 'Засварлагчийн хэрэгслийн мөр';
$string['customtoolbar_desc'] = 'Хоосон мөрөөс бусад бүх мөр нь таслалаар тусгаарлагдсан товчны нэрсийг агуулах бөгөөд бүлэг тусгаарлахдаа "wrap" ашиглана. TinyMCE засварлагчийн үндсэн товчны жагсаалтыг <a href="{$a}" target="_blank">{$a}</a> -с хараарай.<br /> Эхний мөр нь байнга харагдах бөгөөд хоёр болон гурав дахь мөрийн харагдах эсэхийг тохируулах боломжтой.';
$string['directionality:ltr_desc'] = 'Зүүнээс баруун чиглэлтэй';
$string['directionality:rtl_desc'] = 'Баруунаас зүүн чиглэлтэй';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Сэтгэл хөдлөл';
$string['emotions_dlg:cool'] = 'Дориун';
$string['emotions_dlg:cry'] = 'Уйлах';
$string['emotions_dlg:desc'] = 'Сэтгэл хөдлөл';
$string['emotions_dlg:embarassed'] = 'Сандарсан';
$string['emotions_dlg:foot_in_mouth'] = 'Амаа барих';
$string['emotions_dlg:frown'] = 'Урвайх';
$string['emotions_dlg:innocent'] = 'Цайлган';
$string['emotions_dlg:kiss'] = 'Үнсэх';
$string['emotions_dlg:laughing'] = 'Инээх';
$string['emotions_dlg:money_mouth'] = 'Мөнгө олох';
$string['emotions_dlg:sealed'] = 'Амаа хамхих';
$string['emotions_dlg:smile'] = 'Инээмсэглэх';
$string['emotions_dlg:surprised'] = 'Гайхах';
$string['emotions_dlg:title'] = 'Сэтгэл хөдлөл оруулах';
$string['emotions_dlg:tongue_out'] = 'Хэлээ гаргах';
$string['emotions_dlg:undecided'] = 'Эргэлзэх';
$string['emotions_dlg:usage'] = 'Зүүн болон баруун сум ашиглаж шилжинэ.';
$string['emotions_dlg:wink'] = 'Нүд ирмэх';
$string['emotions_dlg:yell'] = 'Хашхирах';
$string['fontselectlist'] = 'Боломжтой фонтын жагсаалт';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Баримтын шинж';
$string['fullpage_dlg:active_color'] = 'Идэвхтэй өнгө';
$string['fullpage_dlg:add'] = 'Шинэ элемент нэмэх';
$string['fullpage_dlg:add_base'] = 'Суурь элемент';
$string['fullpage_dlg:add_comment'] = 'Тайлбар бичих талбар';
$string['fullpage_dlg:add_link'] = 'Холбоос элемент';
$string['fullpage_dlg:add_meta'] = 'Meta элемент';
$string['fullpage_dlg:add_script'] = 'Скрипт элемент';
$string['fullpage_dlg:add_style'] = 'Загвар элемент';
$string['fullpage_dlg:add_title'] = 'Гарчиг элемент';
$string['fullpage_dlg:advanced_props'] = 'Нарийвчилсан';
$string['fullpage_dlg:advanced_tab'] = 'Нарийвчилсан';
$string['fullpage_dlg:appearance_bgprops'] = 'Дэвсгэрийн шинжүүд';
$string['fullpage_dlg:appearance_linkprops'] = 'Холбоосын өнгө';
$string['fullpage_dlg:appearance_marginprops'] = 'Үндсэн хэсгийн захаас авах зай';
$string['fullpage_dlg:appearance_style'] = 'Stylesheet болон хэлбэржүүлэх шинж';
$string['fullpage_dlg:appearance_tab'] = 'Харагдац';
$string['fullpage_dlg:appearance_textprops'] = 'Бичвэрийн шинжүүд';
$string['fullpage_dlg:author'] = 'Зохиогч';
$string['fullpage_dlg:base_element'] = 'Суурь элемент';
$string['fullpage_dlg:bgcolor'] = 'Дэвсгэр өнгө';
$string['fullpage_dlg:bgimage'] = 'Дэвсгэр зураг';
$string['fullpage_dlg:bottom_margin'] = 'Доороос авах зай';
$string['fullpage_dlg:charset'] = 'Тэмдэгтийн олонлог';
$string['fullpage_dlg:comment_element'] = 'Тайлбар';
$string['fullpage_dlg:content'] = 'Агуулга';
$string['fullpage_dlg:copyright'] = 'Зохиогчийн эрх';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'DocType';
$string['fullpage_dlg:encoding'] = 'Тэмдэгт кодчилол';
$string['fullpage_dlg:font_face'] = 'Фонт';
$string['fullpage_dlg:font_size'] = 'Бичгийн хэмжээ';
$string['fullpage_dlg:fontface'] = 'Фонтын бүлэг';
$string['fullpage_dlg:fontsize'] = 'Бичгийн хэмжээ';
$string['fullpage_dlg:general_props'] = 'Ерөнхий';
$string['fullpage_dlg:head_elements'] = 'Гарчиг элемент';
$string['fullpage_dlg:hover_color'] = 'Дээр нь хүрэх өнгө';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Мэдээлэл';
$string['fullpage_dlg:langcode'] = 'Хэлний код';
$string['fullpage_dlg:langdir'] = 'Бичих чиглэл';
$string['fullpage_dlg:langprops'] = 'Хэл ба кодчилол';
$string['fullpage_dlg:language'] = 'Хэл';
$string['fullpage_dlg:left_margin'] = 'Зүүнээс авах зай';
$string['fullpage_dlg:link_color'] = 'Холбоосын өнгө';
$string['fullpage_dlg:link_element'] = 'Холбоос элемент';
$string['fullpage_dlg:ltr'] = 'Зүүнээс баруун';
$string['fullpage_dlg:media'] = 'Медиа';
$string['fullpage_dlg:meta_description'] = 'Тайлбар';
$string['fullpage_dlg:meta_element'] = 'Meta элемент';
$string['fullpage_dlg:meta_index_follow'] = 'Индекслээд холбоосыг дагана';
$string['fullpage_dlg:meta_index_nofollow'] = 'Индекслээд холбоосыг дагаж болохгүй';
$string['fullpage_dlg:meta_keywords'] = 'Түлхүүр үг';
$string['fullpage_dlg:meta_noindex_follow'] = 'Индекслэхгүй боловч холбоосыг дагана';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Индекслэхгүй, холбоосыг дагахгүй';
$string['fullpage_dlg:meta_props'] = 'Meta мэдээлэл';
$string['fullpage_dlg:meta_robots'] = 'Робот';
$string['fullpage_dlg:meta_tab'] = 'Ерөнхий';
$string['fullpage_dlg:meta_title'] = 'Гарчиг';
$string['fullpage_dlg:movedown'] = 'Сонгосон элементийг доош зөөх';
$string['fullpage_dlg:moveup'] = 'Сонгосон элементийг дээш зөөх';
$string['fullpage_dlg:name'] = 'Нэр';
$string['fullpage_dlg:properties'] = 'Шинж';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Сонгосон элементийг хасах';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Баруун захын зай';
$string['fullpage_dlg:rtl'] = 'Баруунаас зүүн';
$string['fullpage_dlg:script_element'] = 'Script элемент';
$string['fullpage_dlg:src'] = 'Эх сурвалж';
$string['fullpage_dlg:style'] = 'Загвар';
$string['fullpage_dlg:style_element'] = 'Загварын элемент';
$string['fullpage_dlg:stylesheet'] = 'Stylesheet';
$string['fullpage_dlg:target'] = 'Товлосон';
$string['fullpage_dlg:text_color'] = 'Бичвэрийн өнгө';
$string['fullpage_dlg:textcolor'] = 'Өнгө';
$string['fullpage_dlg:title'] = 'Баримтын шинж';
$string['fullpage_dlg:title_element'] = 'Гарчиг элемент';
$string['fullpage_dlg:top_margin'] = 'Дээд захын зай';
$string['fullpage_dlg:type'] = 'Төрөл';
$string['fullpage_dlg:value'] = 'Утга';
$string['fullpage_dlg:visited_color'] = 'Зочилсон өнгө';
$string['fullpage_dlg:xml_pi'] = 'XML тодорхойлолт';
$string['fullscreen:desc'] = 'Дэлгэц дүүрэн харуулах горимыг асаах/унтраах';
$string['iespell:download'] = 'ieSpell олдсонгүй. Та суулгахыг хүсэж байна уу?';
$string['iespell:iespell_desc'] = 'Дүрмийн алдаа шалгах';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Ням,Даваа,Мягмар,Лхагва,Пүрэв,Баасан,Бямба,Ням';
$string['insertdatetime:day_short'] = 'Ня,Да,Мя,Лх,Пү,Ба,Бя,Ня';
$string['insertdatetime:insertdate_desc'] = 'Огноо оруулах';
$string['insertdatetime:inserttime_desc'] = 'Хугацаа оруулах';
$string['insertdatetime:months_long'] = '1 дүгээр сар,2 дугаар сар,3 дугаар сар,4 дүгээр сар,5 дугаар сар,6 дугаар сар,7дугаар сар,8 дугаар сар,9 дугаар сар,10 дугаар сар,11 дүгээр сар,12 дугаар сар';
$string['insertdatetime:months_short'] = '1,2,3,4,5,6,7,8,9,10,11,12';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Абсолютаар байршуулах горимыг асаах/унтраах';
$string['layer:backward_desc'] = 'Цаашлуулах';
$string['layer:content'] = 'Шинэ давхарга...';
$string['layer:forward_desc'] = 'Наашлуулах';
$string['layer:insertlayer_desc'] = 'Шинэ давхарга оруулах';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Медиа эмбэд хийх/засах';
$string['media:edit'] = 'Эмбэд хийсэн Мультимедиа засах';
$string['media_dlg:advanced'] = 'Нарийвчилсан';
$string['media_dlg:align'] = 'Зэрэгцүүлэх';
$string['media_dlg:align_bottom'] = 'Доор';
$string['media_dlg:align_bottom_left'] = 'Зүүн доор';
$string['media_dlg:align_bottom_right'] = 'Баруун доор';
$string['media_dlg:align_center'] = 'Голд';
$string['media_dlg:align_left'] = 'Зүүн';
$string['media_dlg:align_right'] = 'Баруун';
$string['media_dlg:align_top'] = 'Дээр';
$string['media_dlg:align_top_left'] = 'Зүүн дээр';
$string['media_dlg:align_top_right'] = 'Баруун дээр';
$string['media_dlg:altsource1'] = 'Эх сурвалжийн сонголт 1';
$string['media_dlg:altsource2'] = 'Эх сурвалжийн сонголт 2';
$string['media_dlg:audio'] = 'HTML5 аудио';
$string['media_dlg:autogotourl'] = 'Автоматаар очих URL';
$string['media_dlg:autohref'] = 'Автоматаар шилжих HREF';
$string['media_dlg:autostart'] = 'Автомат эхлэл';
$string['media_dlg:balance'] = 'Тэнцвэржүүлэлт';
$string['media_dlg:base'] = 'Суурь';
$string['media_dlg:baseurl'] = 'Үндсэн URL';
$string['media_dlg:bgcolor'] = 'Дэвсгэр';
$string['media_dlg:cache'] = 'Кэш';
$string['media_dlg:captioningid'] = 'Тайлбарын ID';
$string['media_dlg:center'] = 'Голлуулах';
$string['media_dlg:class_name'] = 'Класс';
$string['media_dlg:console'] = 'Консол';
$string['media_dlg:constrain_proportions'] = 'Харьцааг барих';
$string['media_dlg:controller'] = 'Тохируулагч';
$string['media_dlg:controls'] = 'Удирдлага';
$string['media_dlg:correction'] = 'Засваргүй';
$string['media_dlg:currentmarker'] = 'Сонгогдсон тэмдэглэгч';
$string['media_dlg:currentposition'] = 'Одоогийн байрлал';
$string['media_dlg:defaultframe'] = 'Өгөгдмөл фрэйм';
$string['media_dlg:embedded_audio_options'] = 'Эмбэдэд аудионы тохиргоо';
$string['media_dlg:embeddedaudio'] = 'Эмбэдэд аудио';
$string['media_dlg:enabled'] = 'Идэвхтэй';
$string['media_dlg:enablejavascript'] = 'JavaScript идэвхжүүлэх';
$string['media_dlg:endtime'] = 'Төгсөх цаг';
$string['media_dlg:file'] = 'Файл/URL';
$string['media_dlg:flash'] = 'Флаш';
$string['media_dlg:flash_options'] = 'Флаш тохируулга';
$string['media_dlg:flashvars'] = 'Флаш хувьсагч';
$string['media_dlg:fullscreen'] = 'Дэлгэц дүүрэн';
$string['media_dlg:general'] = 'Ерөнхий';
$string['media_dlg:hidden'] = 'Далдалсан';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Хэвтээ-зай';
$string['media_dlg:html5_audio_options'] = 'Аудио тохиргоо';
$string['media_dlg:html5_video_options'] = 'HTML5 видео тохиргоо';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Зургийн төлөв';
$string['media_dlg:invokeurls'] = 'Дуудах URLs';
$string['media_dlg:kioskmode'] = 'Киоск горим';
$string['media_dlg:list'] = 'Жагсаалт';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Давтах';
$string['media_dlg:maintainaspect'] = 'Зургийн харьцааг хадгалах';
$string['media_dlg:menu'] = 'Цэс харуулах';
$string['media_dlg:mute'] = 'Дуугүй';
$string['media_dlg:name'] = 'Нэр';
$string['media_dlg:nojava'] = 'Жава байхгүй';
$string['media_dlg:numloop'] = 'Давтах тоо';
$string['media_dlg:play'] = 'Автоматаар тоглуулах';
$string['media_dlg:playcount'] = 'Тоглуулах тоо';
$string['media_dlg:playeveryframe'] = 'Фрэйм бүрийг тоглуулна';
$string['media_dlg:poster'] = 'Зурагт хуудас';
$string['media_dlg:prefetch'] = 'Урьдчилан дуудах';
$string['media_dlg:preload'] = 'Урьдчилан ачаалах';
$string['media_dlg:preload_auto'] = 'Хэрэглэгчийн хөтөч шийдэх';
$string['media_dlg:preload_metadata'] = 'Дүрс бичлэгийн meta өгөгдлийг урьдчилан ачаалах';
$string['media_dlg:preload_none'] = 'Урьдчилан ачаалахгүй';
$string['media_dlg:preview'] = 'Урьдчилан харах';
$string['media_dlg:progress'] = 'Явц';
$string['media_dlg:qt_options'] = 'Quicktime тохиргоо';
$string['media_dlg:qt_stream_warn'] = 'Нарийвчилсан тохиргоо хэсэг дэх \'QT эх сурвалж\' талбарт шууд дамжуулах RTSP нөөцийг, \'эх сурвалж\' талбарт шууд дамжуулахгүй хувилбарыг оруулах шаардлагатай.';
$string['media_dlg:qtsrc'] = 'QT эх сурвалж';
$string['media_dlg:qtsrcchokespeed'] = 'Цацах хурд';
$string['media_dlg:quality'] = 'Чанар';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Давтамж';
$string['media_dlg:realmedia'] = 'Real Медиа';
$string['media_dlg:rmp_options'] = 'Real Медиа тоглуулагчийн тохиргоо';
$string['media_dlg:salign'] = 'S-Зэрэгцүүлэлт';
$string['media_dlg:scale'] = 'Хуваарилалт';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave-тохиргоо';
$string['media_dlg:shuffle'] = 'Санамсаргүйгээр тоглуулах';
$string['media_dlg:size'] = 'Хэмжээ';
$string['media_dlg:sound'] = 'Дуу';
$string['media_dlg:source'] = 'Эх сурвалж';
$string['media_dlg:starttime'] = 'Эхлэх цаг';
$string['media_dlg:stretchtofit'] = 'Дүүргэж сунгах';
$string['media_dlg:swstretchhalign'] = 'Хөндлөн сунгаж тааруулах';
$string['media_dlg:swstretchstyle'] = 'Сунгах загвар';
$string['media_dlg:swstretchvalign'] = 'Босоо сунгаж тааруулах';
$string['media_dlg:target'] = 'Товлосон';
$string['media_dlg:targetcache'] = 'Товлосон кэш';
$string['media_dlg:title'] = 'Мультимедиа агуулга шигтгэж оруулах/ засварлах';
$string['media_dlg:type'] = 'Төрөл';
$string['media_dlg:uimode'] = 'UI горим';
$string['media_dlg:video'] = 'HTML5 дүрс бичлэг';
$string['media_dlg:volume'] = 'Дууны хүч';
$string['media_dlg:vspace'] = 'Босоо зай';
$string['media_dlg:windowlessvideo'] = 'Цонхгүй дүрс бичлэг';
$string['media_dlg:windowsmedia'] = 'Windows медиа';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows медиа тоглуулагчийн тохиргоо';
$string['nonbreaking:nonbreaking_desc'] = 'Хоосон зай тэмдэгт оруулах';
$string['pagebreak:desc'] = 'Хэвлэхэд зориулж хуудас таслалт оруулах';
$string['paste:paste_text_desc'] = 'Энгийн бичвэр болгон буулгах';
$string['paste:paste_word_desc'] = 'Word-оос буулгах';
$string['paste:plaintext_mode'] = 'Одоо энгийн бичвэрийн горимд буулгах төлөвт байна. Ердийн буулгах горим руу буцахын тулд дахин товшино уу. Буулгалт хийсний дараа ердийн буулгах горим руу буцах болно.';
$string['paste:plaintext_mode_stick'] = 'Одоо энгийн бичвэрийн горимд буулгах төлөвт байна. Ердийн буулгах горим руу буцахын тулд дахин товшино уу.';
$string['paste:selectall_desc'] = 'Бүгдийг сонгох';
$string['paste_dlg:text_linebreaks'] = 'Мөр таслалтыг үлдээнэ';
$string['paste_dlg:text_title'] = 'Бичвэрийг цонхонд буулгахдаа гарын Ctrl+V товчийг ашиглана.';
$string['paste_dlg:word_title'] = 'Бичвэрийг цонхонд буулгахдаа гарын Ctrl+V товчийг ашиглана.';
$string['pluginname'] = 'TinyMCE HTML засварлагч (хуучин)';
$string['preview:preview_desc'] = 'Урьдчилан харах';
$string['print:print_desc'] = 'Хэвлэх';
$string['privacy:metadata'] = 'TinyMCE HTML засварлагч нэмэлт хэрэгсэл нь хувийн мэдээлэл хадгалдаггүй.';
$string['save:cancel_desc'] = 'Бүх өөрчлөлтийг цуцлах';
$string['save:save_desc'] = 'Хадгалах';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Хайх/орлуулах';
$string['searchreplace:search_desc'] = 'Хайх';
$string['searchreplace_dlg:allreplaced'] = 'Тэмдэгт мөрийн олдсон бүх тохиолдлуудад орлуулсан.';
$string['searchreplace_dlg:direction'] = 'Хайх чиглэл';
$string['searchreplace_dlg:down'] = 'Доош';
$string['searchreplace_dlg:findnext'] = 'Үргэлжлүүлэн хайх';
$string['searchreplace_dlg:findwhat'] = 'Хайх бичвэр';
$string['searchreplace_dlg:mcase'] = 'Том/Жижиг бичилт ялгах';
$string['searchreplace_dlg:notfound'] = 'Хайлтыг хийж дууссан. Хайсан тэмдэгт мөр олдсонгүй.';
$string['searchreplace_dlg:replace'] = 'Орлуулах';
$string['searchreplace_dlg:replace_title'] = 'Хайх/орлуулах';
$string['searchreplace_dlg:replaceall'] = 'Бүгдийг орлуулах';
$string['searchreplace_dlg:replacewith'] = 'Орлуулагч';
$string['searchreplace_dlg:search_title'] = 'Хайх';
$string['searchreplace_dlg:searchnext_desc'] = 'Дахин хайх';
$string['searchreplace_dlg:up'] = 'Дээш';
$string['settings'] = 'Ерөнхий тохиргоо';
$string['simple:bold_desc'] = 'Тод (Ctrl+B)';
$string['simple:bullist_desc'] = 'Тоочсон жагсаалт оруулах/хасах';
$string['simple:cleanup_desc'] = 'Замбараагүй кодыг цэгцлэх';
$string['simple:italic_desc'] = 'Налуу (Ctrl+I)';
$string['simple:numlist_desc'] = 'Дугаарласан жагсаалт оруулах/хасах';
$string['simple:redo_desc'] = 'Цуцлах (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Дарсан';
$string['simple:underline_desc'] = 'Доогуур зураас (Ctrl+U)';
$string['simple:undo_desc'] = 'Буцаах (Ctrl+Z)';
$string['spellchecker:desc'] = 'Үгийн алдаа шалгагчийг идэвхжүүлэх/идэвхгүй болгох';
$string['spellchecker:ignore_word'] = 'Үг үл хэрэгсэх';
$string['spellchecker:ignore_words'] = 'Бүгдийг үл хэрэгсэх';
$string['spellchecker:langs'] = 'Хэл';
$string['spellchecker:learn_word'] = 'Сурах үг';
$string['spellchecker:menu'] = 'Үгийн алдаа шалгагчийн тохиргоо';
$string['spellchecker:no_mpell'] = 'Дүрмийн алдаа олдсонгүй.';
$string['spellchecker:no_sug'] = 'Саналгүй';
$string['spellchecker:sug'] = 'Санал';
$string['spellchecker:wait'] = 'Түр хүлээнэ үү...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'CSS загвар засах';
$string['style_dlg:apply'] = 'Хэрэглэх';
$string['style_dlg:background'] = 'Дэвсгэр';
$string['style_dlg:background_attachment'] = 'Хавсралт';
$string['style_dlg:background_color'] = 'Дэвсгэр өнгө';
$string['style_dlg:background_hpos'] = 'Хөндлөн байрлал';
$string['style_dlg:background_image'] = 'Дэвсгэр зураг';
$string['style_dlg:background_repeat'] = 'Давтах';
$string['style_dlg:background_tab'] = 'Дэвсгэр';
$string['style_dlg:background_vpos'] = 'Босоо байрлал';
$string['style_dlg:block'] = 'Блок';
$string['style_dlg:block_display'] = 'Үзүүлэн';
$string['style_dlg:block_letterspacing'] = 'Үсэг хоорондын зай';
$string['style_dlg:block_tab'] = 'Блок';
$string['style_dlg:block_text_align'] = 'Бичвэр зэрэгцүүлэх';
$string['style_dlg:block_text_indent'] = 'Бичвэрийн догол мөр';
$string['style_dlg:block_vertical_alignment'] = 'Босоо зэрэгцүүлэлт';
$string['style_dlg:block_whitespace'] = 'Хоосон зай';
$string['style_dlg:block_wordspacing'] = 'Үг хоорондын зай';
$string['style_dlg:border'] = 'Хүрээ';
$string['style_dlg:border_tab'] = 'Хүрээ';
$string['style_dlg:bottom'] = 'Доор';
$string['style_dlg:box'] = 'Хайрцаг';
$string['style_dlg:box_clear'] = 'Цэвэрлэх';
$string['style_dlg:box_float'] = 'Хөвөх';
$string['style_dlg:box_height'] = 'Өндөр';
$string['style_dlg:box_tab'] = 'Хайрцаг';
$string['style_dlg:box_width'] = 'Өргөн';
$string['style_dlg:bullet_image'] = 'Тоочих хэлбэр';
$string['style_dlg:clip'] = 'Тайрах';
$string['style_dlg:color'] = 'Өнгө';
$string['style_dlg:height'] = 'Өндөр';
$string['style_dlg:left'] = 'Зүүн';
$string['style_dlg:list'] = 'Жагсаалт';
$string['style_dlg:list_tab'] = 'Жагсаалт';
$string['style_dlg:list_type'] = 'Төрөл';
$string['style_dlg:margin'] = 'Гадаад зай';
$string['style_dlg:overflow'] = 'Хэтрэлт';
$string['style_dlg:padding'] = 'Дотоод зай';
$string['style_dlg:placement'] = 'Байрлуулах';
$string['style_dlg:position'] = 'Байршил';
$string['style_dlg:positioning_tab'] = 'Байршуулах';
$string['style_dlg:positioning_type'] = 'Төрөл';
$string['style_dlg:right'] = 'Баруун';
$string['style_dlg:same'] = 'Бүгдэд ижил';
$string['style_dlg:style'] = 'Загвар';
$string['style_dlg:text'] = 'Бичвэр';
$string['style_dlg:text_blink'] = 'Анивчих';
$string['style_dlg:text_case'] = 'Үсгийн хэлбэр';
$string['style_dlg:text_color'] = 'Өнгө';
$string['style_dlg:text_decoration'] = 'Чимэглэл';
$string['style_dlg:text_font'] = 'Фонт';
$string['style_dlg:text_lineheight'] = 'Мөрийн өндөр';
$string['style_dlg:text_none'] = 'Хоосон';
$string['style_dlg:text_overline'] = 'Дээгүүр нь зурсан';
$string['style_dlg:text_props'] = 'Бичвэр';
$string['style_dlg:text_size'] = 'Хэмжээ';
$string['style_dlg:text_striketrough'] = 'Дарсан';
$string['style_dlg:text_style'] = 'Загвар';
$string['style_dlg:text_tab'] = 'Бичвэр';
$string['style_dlg:text_underline'] = 'Доогуур нь зурсан';
$string['style_dlg:text_variant'] = 'Онцлог';
$string['style_dlg:text_weight'] = 'Өргөн нарийн';
$string['style_dlg:title'] = 'CSS загвар засварлах';
$string['style_dlg:toggle_insert_span'] = 'Бичвэр хооронд зай оруулах';
$string['style_dlg:top'] = 'Дээр';
$string['style_dlg:visibility'] = 'Харагдахуйц';
$string['style_dlg:width'] = 'Өргөн';
$string['style_dlg:zindex'] = 'Z индекс';
$string['subplugintype_tinymce'] = 'Нэмэлт хэрэгсэл';
$string['subplugintype_tinymce_plural'] = 'Нэмэлт хэрэгсэл';
$string['table:cell'] = 'Нүд';
$string['table:cell_desc'] = 'Хүснэгтийн нүдний шинж';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Багана';
$string['table:col_after_desc'] = 'Баруун талд нь багана оруулах';
$string['table:col_before_desc'] = 'Зүүн талд нь багана оруулах';
$string['table:copy_row_desc'] = 'Мөрийг хуулах';
$string['table:cut_row_desc'] = 'Мөрийг тасалж авах';
$string['table:del'] = 'Хүснэгтийг устгах';
$string['table:delete_col_desc'] = 'Баганыг устгах';
$string['table:delete_row_desc'] = 'Мөрийг устгах';
$string['table:desc'] = 'Хүснэгт үүсгэх/засварлах';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Нүднүүдийг нэгтгэх';
$string['table:paste_row_after_desc'] = 'Доор нь шинэ мөр нэмж буулгах';
$string['table:paste_row_before_desc'] = 'Дээр нь шинэ мөр нэмж буулгах';
$string['table:props_desc'] = 'Хүснэгтийн шинж';
$string['table:row'] = 'Мөр';
$string['table:row_after_desc'] = 'Доор нь мөр оруулах';
$string['table:row_before_desc'] = 'Дээр нь мөр оруулах';
$string['table:row_desc'] = 'Мөрийн шинж';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Нэгтгэсэн нүдийг салгах';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Нарийвчилсан шинж';
$string['table_dlg:advanced_tab'] = 'Нарийвчилсан';
$string['table_dlg:align'] = 'Зэрэгцүүлэлт';
$string['table_dlg:align_bottom'] = 'Доор';
$string['table_dlg:align_default'] = 'Өгөгдмөл';
$string['table_dlg:align_left'] = 'Зүүн';
$string['table_dlg:align_middle'] = 'Голд';
$string['table_dlg:align_right'] = 'Баруун';
$string['table_dlg:align_top'] = 'Дээр';
$string['table_dlg:bgcolor'] = 'Дэвсгэр өнгө';
$string['table_dlg:bgimage'] = 'Дэвсгэр зураг';
$string['table_dlg:border'] = 'Хүрээ';
$string['table_dlg:bordercolor'] = 'Хүрээний өнгө';
$string['table_dlg:caption'] = 'Хүснэгтийн нэр';
$string['table_dlg:cell_all'] = 'Хүснэгтийн бүх нүдийг шинэчлэх';
$string['table_dlg:cell_cell'] = 'Сонгогдсон нүдийг шинэчлэх';
$string['table_dlg:cell_col'] = 'Баганын бүх нүдийг шинэчлэх';
$string['table_dlg:cell_limit'] = 'Нүдний тоо {$cells} (байж болох хамгийн их тоо)-с хэтэрсэн байна.';
$string['table_dlg:cell_row'] = 'Мөрийн бүх нүдийг шинэчлэх';
$string['table_dlg:cell_title'] = 'Хүснэгтийн нүдний шинж';
$string['table_dlg:cell_type'] = 'Нүдний төрөл';
$string['table_dlg:cellpadding'] = 'Нүдний хүрээнээс авах зай';
$string['table_dlg:cellspacing'] = 'Нүдний зай';
$string['table_dlg:col_limit'] = 'Баганын тоо {$cols} (байж болох хамгийн их тоо)-с хэтэрсэн байна.';
$string['table_dlg:colgroup'] = 'Баганын бүлэг';
$string['table_dlg:cols'] = 'Багана';
$string['table_dlg:frame'] = 'Фрэйм';
$string['table_dlg:frame_all'] = 'бүх';
$string['table_dlg:frame_cols'] = 'Багана';
$string['table_dlg:frame_groups'] = 'Бүлэг';
$string['table_dlg:frame_none'] = 'хоосон';
$string['table_dlg:frame_rows'] = 'мөр';
$string['table_dlg:general_props'] = 'Ерөнхий тохиргоо';
$string['table_dlg:general_tab'] = 'Ерөнхий';
$string['table_dlg:height'] = 'Өндөр';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Хэлний код';
$string['table_dlg:langdir'] = 'Бичих чиглэл';
$string['table_dlg:ltr'] = 'Зүүнээс баруун';
$string['table_dlg:merge_cells_title'] = 'Хүснэгтийн нүднүүдийг нэгтгэх';
$string['table_dlg:mime'] = 'Товлосон MIME төрөл';
$string['table_dlg:missing_scope'] = 'Та хүснэгтэд гарчиг мөр үүсгэхгүй үргэлжлүүлэхдээ итгэлтэй байна уу? Хэрэв гарчиг үүсгэхгүй бол зарим хөгжлийн бэрхшээлтэй хүмүүст хүснэгтийн агуулгыг ойлгоход хүндрэлтэй байх магадлалтай.';
$string['table_dlg:row_all'] = 'Бүх мөрийг шинэчлэх';
$string['table_dlg:row_even'] = 'Тэгш мөрүүдийг шинэчлэх';
$string['table_dlg:row_limit'] = 'Мөрийн тоо {$rows} (байж болох хамгийн их тоо)-с хэтэрсэн байна.';
$string['table_dlg:row_odd'] = 'Сондгой мөрүүдийг шинэчлэх';
$string['table_dlg:row_row'] = 'Сонгогдсон мөрийг шинэчлэх';
$string['table_dlg:row_title'] = 'Мөрийн шинж';
$string['table_dlg:rowgroup'] = 'Мөрийн бүлэг';
$string['table_dlg:rows'] = 'Мөр';
$string['table_dlg:rowtype'] = 'Мөрийн төрөл';
$string['table_dlg:rtl'] = 'Баруунаас зүүн';
$string['table_dlg:rules'] = 'Шугам';
$string['table_dlg:rules_above'] = 'дээр';
$string['table_dlg:rules_below'] = 'доор';
$string['table_dlg:rules_border'] = 'хүрээ';
$string['table_dlg:rules_box'] = 'хайрцаг';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Хамрах хүрээ';
$string['table_dlg:style'] = 'Загвар';
$string['table_dlg:summary'] = 'Дүгнэлт';
$string['table_dlg:tbody'] = 'Хүснэгтийн агуулга';
$string['table_dlg:td'] = 'Хүснэгтийн нүд';
$string['table_dlg:tfoot'] = 'Хөл';
$string['table_dlg:th'] = 'Гарчиг';
$string['table_dlg:thead'] = 'Толгой';
$string['table_dlg:title'] = 'Хүснэгт үүсгэх/засварлах';
$string['table_dlg:valign'] = 'Босоо зэрэгцүүлэлт';
$string['table_dlg:width'] = 'Өргөн';
$string['template:desc'] = 'Урьдчилан тодорхойлсон хэв оруулах';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Ням,Даваа,Мягмар,Лхагва,Пүрэв,Баасан,Бямба,Ням';
$string['template_dlg:day_short'] = 'Ня,Да,Мя,Лх,Пү,Ба,Бя,Ня';
$string['template_dlg:desc'] = 'Урьдчилан тодорхойлсон хэв оруулах';
$string['template_dlg:desc_label'] = 'Тайлбар';
$string['template_dlg:label'] = 'Хэв';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = '1дүгээр сар,2 дугаар сар,3 дугаар сар,4 дүгээр сар,5 дугаар сар,6 дугаар сар,7дугаар сар,8 дугаар сар,9 дугаар сар,10 дугаар сар,11 дүгээр сар,12 дугаар сар';
$string['template_dlg:months_short'] = '1-р сар,2-р сар,3-р сар,4-р сар,5-р сар,6-р сар,7-р сар,8-р сар,9-р сар,10-р сар,11-р сар,12-р сар';
$string['template_dlg:preview'] = 'Урьдчилан харах';
$string['template_dlg:select'] = 'Хэв сонгох';
$string['template_dlg:title'] = 'Хэв';
$string['template_dlg:warning'] = 'Санамж: Хэвийг өөр хэвээр шинэчлэхэд өгөгдөл алдагдаж болзошгүй!';
$string['visualblocks:desc'] = 'Блок элементүүдийг харуулах/далдлах';
$string['visualchars:desc'] = 'Удирдах тэмдэгт харуулах/далдлах';
$string['wordcount:words'] = 'Үгс:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Товчилсон үг';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Товчлол';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Шинж оруулах/засах';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Эшлэл';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Устсан бичвэр';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Нэмэгдсэн бичвэр';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Атрибут';
$string['xhtmlxtras_dlg:attribs_title'] = 'Атрибут оруулах/засах';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Атрибут';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Үзэгдэл';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Хандах товч';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Эшлэл';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Анги';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Огноо/цаг';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Хэл';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Бичвэрийн чиглэл';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Загвар';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Табаар очих дугаар';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Гарчиг';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Зүүнээс баруун';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Баруунаас зүүн';
$string['xhtmlxtras_dlg:events_tab'] = 'Үзэгдэл';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Элементийн атрибут';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Элементийн үзэгдэл';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Ерөнхий тохиргоо';
$string['xhtmlxtras_dlg:general_tab'] = 'Ерөнхий';
$string['xhtmlxtras_dlg:insert_date'] = 'Одоогийн огноо/цаг оруулах';
$string['xhtmlxtras_dlg:option_ltr'] = 'Зүүнээс баруун';
$string['xhtmlxtras_dlg:option_rtl'] = 'Баруунаас зүүн';
$string['xhtmlxtras_dlg:remove'] = 'Хасах';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Товчилсон үг элемент';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Товчлол элемент';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Эшлэл элемент';
$string['xhtmlxtras_dlg:title_del_element'] = 'Устсан бичвэрийн элемент';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Нэмсэн бичвэрийн элемент';
