<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'mn', version '4.3'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Дүгнэх интерфэйсийн үйлдэл';
$string['actionsforpost'] = 'Нийтлэлийн үйлдэл';
$string['activitydate:due'] = 'Товлосон:';
$string['activityoverview'] = 'Шинэ хэлэлцүүлгийн нийтлэлүүд байна';
$string['addanewdiscussion'] = 'Мэтгэлцээний шинэ сэдэв нэмэх';
$string['addanewquestion'] = 'Шинэ асуулт нэмэх';
$string['addanewtopic'] = 'Шинэ сэдэв нэмэх';
$string['addreply'] = 'Хариу нэмэх';
$string['addtofavourites'] = 'Энэ мэтгэлцээнийг одоор тэмдэглэх';
$string['advancedsearch'] = 'Өргөтгөсөн хайлт';
$string['alldiscussions'] = 'Бүх мэтгэлцээн';
$string['allforums'] = 'Бүх хэлэлцүүлэг';
$string['allowdiscussions'] = 'Энэ хэлэлцүүлэгт {$a}-г нийтлэх боломжтой юу?';
$string['allowsallsubscribe'] = 'Энэ хэлэлцүүлэгт хүн бүр нэгдэх эсэхээ сонгох боломжтой';
$string['allowsdiscussions'] = 'Энэ хэлэлцүүлэгт хүн бүр нэг мэтгэлцээний сэдэв эхлүүлэх боломжтой.';
$string['allsubscribe'] = 'Бүх хэлэлцүүлэгт нэгдэх';
$string['allunsubscribe'] = 'Бүх хэлэлцүүлэгээс гарах';
$string['allusers'] = 'Бүх хэрэглэгч';
$string['alreadyfirstpost'] = 'Энэ нийтлэл нь мэтгэлцээний эхний бичлэг болсон байна';
$string['anyfile'] = 'Ямар нэгэн файл';
$string['areaattachment'] = 'Хавсралтууд';
$string['areapost'] = 'Зурвасууд';
$string['attachment'] = 'Хавсралт';
$string['attachment_help'] = 'Та хэлэлцүүлгийн нийтлэлд нэг эсвэл хэд хэдэн файл хавсаргах боломжтой. Зураг хавсаргасан бол энэ нь зурвасын дараа харагдах болно.';
$string['attachmentname'] = 'Хавсралт {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Нийтлэлийн id байхгүй бол хавсралтуудыг экспортлох боломжгүй';
$string['attachments'] = 'Хавсралтууд';
$string['attachmentswordcount'] = 'Хавсралт болон үгийн тоо';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} {$a->author}-д хувийн зурвасаар хариулж байна';
$string['authorreplyingtoauthor'] = '{$a->respondant} {$a->author}-д хариулж байна';
$string['availability'] = 'Хүртээмжтэй байдал';
$string['blockafter'] = 'Нийтлэлийн тооны хязгаар';
$string['blockafter_help'] = 'Энэ тохиргоогоор өгөгдсөн хугацаанд хэрэглэгчийн нийтлэх боломжтой нийтлэлийн хамгийн их тоог заана.  mod/forum:postwithoutthrottling боломжтой хэрэглэгчид энэ хязгаарлалт нөлөөлөхгүй.';
$string['blockperiod'] = 'Хориглох хугацаа';
$string['blockperiod_help'] = 'Суралцагчдыг тодорхойлсон хугацаанд өгөгдсөн тооноос илүү нийтлэл нийтлэхийг хориглож болно. mod/forum:postwithrottling боломжтой хэрэглэгчид энэ хязгаарлалт нөлөөлөхгүй.';
$string['blockperioddisabled'] = 'Хориглохгүй';
$string['blogforum'] = 'Блог хэлбэрээр харагдах стандарт хэлэлцүүлэг';
$string['bynameondate'] = 'дэргэд {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Хэрэглэгчийн хэлэлцүүлгийг мөшгөх төлөв';
$string['calendardue'] = '{$a}-н хугацаа дуусна';
$string['cancelreply'] = 'Хариуг цуцлах';
$string['cannotadd'] = 'Энэ хэлэлцүүлэгт мэтгэлцээн нэмэх боломжгүй байна';
$string['cannotadddiscussion'] = 'Энэ хэлэлцүүлэгт мэтгэлцээн нэмэхэд бүлгийн гишүүнчлэл шаардлагатай.';
$string['cannotadddiscussionall'] = 'Та бүх оролцогч нарт зориулсан мэтгэлцээний шинэ сэдэв нэмэх эрхгүй байна.';
$string['cannotadddiscussiongroup'] = 'Та ямар ч бүлэгт гишүүнчлэлгүй тул мэтгэлцээн үүсгэх боломжгүй.';
$string['cannotaddsubscriber'] = '{$a} id-тай хэрэглэгчийн энэ хэлэлцүүлэгт нэмж чадсангүй!';
$string['cannotaddteacherforumto'] = 'Хичээл дэх хэсэг 0 -д багшийн хувиргасан хэлэлцүүлгийн жишээ нэмж чадсангүй';
$string['cannotcreatediscussion'] = 'Шинэ мэтгэлцээн үүсгэж чадсангүй';
$string['cannotcreateinstanceforteacher'] = 'Багшийн хэлэлцүүлэгт шинэ хичээлийн модулийн жишээ үүсгэж чадсангүй';
$string['cannotdeletepost'] = 'Та энэ нийтлэлийг устгах боломжгүй!';
$string['cannoteditposts'] = 'Та бусад хүмүүсийн нийтлэлийг засварлах боломжгүй!';
$string['cannotexportforum'] = 'Та энэ хэлэлцүүлгийг экспортлох боломжгүй';
$string['cannotfavourite'] = 'Уучлаарай, та мэтгэлцээнийг одоор тэмдэглэх эрхгүй байна.';
$string['cannotfinddiscussion'] = 'Энэ хэлэлцүүлгээс мэтгэлцээн олдсонгүй';
$string['cannotfindfirstpost'] = 'Энэ хэлэлцүүлгийн эхний нийтлэл олдсонгүй';
$string['cannotfindorcreateforum'] = 'Хуудасны үндсэн зарын хэлэлцүүлгийг олж эсвэл үүсгэж чадсангүй';
$string['cannotfindparentpost'] = '{$a} нийтлэлийн толгой эх сурвалжийг олж чадсангүй';
$string['cannotmovefromsingleforum'] = 'Энгийн нэг мэтгэлцээний хэлэлцүүлгээс мэтгэлцээнийг зөөх боломжгүй';
$string['cannotmovenotvisible'] = 'Хэлэлцүүлэг харагдахгүй байна';
$string['cannotmovetonotexist'] = 'Та тэр хэлэлцүүлэг рүү шилжих боломжгүй - тийм хэлэлцүүлэг байхгүй байна!';
$string['cannotmovetonotfound'] = 'Энэ хичээлээс зорилтод хэлэлцүүлэг олдсонгүй.';
$string['cannotmovetosingleforum'] = 'Энгийн нэг мэтгэлцээний хэлэлцүүлэг рүү мэтгэлцээнийг зөөх боломжгүй';
$string['cannotpindiscussions'] = 'Уучлаарай, та мэтгэлцээнийг бэхлэх эрхгүй байна.';
$string['cannotpurgecachedrss'] = 'Эх сурвалж ба/эсвэл очих хэлэлцүүлэг(үүд)-ийн кэшилсэн RSS мэдэгдлийг цэвэрлэж чадсангүй - өөрийн файлын хэлэлцүүлгийн зөвшөөрлийг шалгана уу.';
$string['cannotremovesubscriber'] = '{$a}  хэрэглэгчийн энэ хэлэлцүүлгээс хасах боломжгүй!';
$string['cannotreply'] = 'Та энэ нийтлэлд хариулах боломжгүй';
$string['cannotsplit'] = 'Энэ хэлэлцүүлгийн мэтгэлцээнүүдийг хуваах боломжгүй';
$string['cannotsubscribe'] = 'Уучлаарай, та нэгдэхийн тулд бүлгийн гишүүн болсон байх ёстой.';
$string['cannottrack'] = 'Тэр хэлэлцүүлгийг мөшгөхөө зогсоож чадсангүй';
$string['cannotunsubscribe'] = 'Та тэр хэлэлцүүлгээс гарах боломжгүй';
$string['cannotupdatepost'] = 'Та энэ нийтлэлийг шинэчлэх боломжгүй';
$string['cannotuseseperategroupsandsingletopic'] = 'Тусдаа бүлгүүдийг нэг энгийн хэлэлцүүлгээр ашиглах боломжгүй.';
$string['cannotusesingletopicandseperategroups'] = 'Нэг энгийн мэтгэлцээнийг тусдаа бүлгүүдэд ашиглах боломжгүй.';
$string['cannotviewpostyet'] = 'Та нийтлэл нэмээгүй учраас энэ хэлэлцүүлгийн бусад суралцагчийн нийтлэлийг унших боломжгүй.';
$string['cannotviewusersposts'] = 'Танд үзүүлэх боломжтой энэ хэрэглэгчийн нийтлэл алга байна.';
$string['cleanreadtime'] = 'Хуучин нийтлэлүүдийг уншсан цагаар тэмдэглэх';
$string['clicktofavourite'] = 'Та энэ мэтгэлцээнийг одоор тэмдэглээгүй байна. Одоор тэмдэглэх бол товшино уу.';
$string['clicktolockdiscussion'] = 'Энэ мэтгэлцээнийг түгжих бол товшино уу';
$string['clicktosubscribe'] = 'Та энэ мэтгэлцээнд нэгдээгүй байна. Нэгдэх бол товшино уу.';
$string['clicktounfavourite'] = 'Та энэ мэтгэлцээнийг одоор тэмдэглэсэн байна. Цуцлах бол товшино уу.';
$string['clicktounlockdiscussion'] = 'Энэ мэтгэлцээний түгжээг тайлах бол товшино уу';
$string['clicktounsubscribe'] = 'Та энэ мэтгэлцээнд нэгдсэн байна. Мэтгэлцээнээс гарах бол товшино уу.';
$string['close'] = 'Хаах';
$string['closegrader'] = 'Дүгнэгчийг хаах';
$string['completiondetail:discussions'] = 'Мэтгэлцээнийг эхлүүлэх: {$a}';
$string['completiondetail:posts'] = 'Хэлэлцүүлгийн нийтлэл болгох: {$a}';
$string['completiondetail:replies'] = 'Хариу нийтлэл: {$a}';
$string['completiondiscussions'] = 'Суралцагч мэтгэлцээн үүсгэх ёстой:';
$string['completiondiscussionsdesc'] = 'Суралцагч хамгийн багадаа {$a} мэтгэлцээн үүсгэх ёстой';
$string['completiondiscussionsgroup'] = 'Мэтгэлцээн шаардах';
$string['completiondiscussionshelp'] = 'Мэтгэлцээнийг дуусгахыг шаардах';
$string['completionposts'] = 'Суралцагч нийтлэл оруулах эсвэл хариу бичих ёстой:';
$string['completionpostsdesc'] = 'Суралцагч хамгийн багадаа {$a} мэтгэлцээн эсвэл хариу нийтлэх ёстой';
$string['completionpostsgroup'] = 'Нийтлэл шаардах';
$string['completionpostshelp'] = 'дуусгахад мэтгэлцээн эсвэл хариу шаардлагатай';
$string['completionreplies'] = 'Суралцагч хариу нийтлэх ёстой:';
$string['completionrepliesdesc'] = 'Суралцагч хамгийн багадаа {$a} хариу нийтлэх ёстой';
$string['completionrepliesgroup'] = 'Хариу шаардах';
$string['completionreplieshelp'] = 'Дуусгахад хариу шаардлагатай';
$string['configcleanreadtime'] = '"Уншсан" хүснэгтээс хуучин нийтлэлүүдийг цэвэрлэх өдрийн цаг.';
$string['configdigestmailtime'] = 'Цахим шуудангийн хэлбэрээр илгээхийг сонгосон хүмүүст өдөр бүр цахим шуудангаар илгээх болно. Энэ тохиргоо нь өдрийн аль цагт захидал илгээхийг удирддаг (энэ цагаас хойш ажиллах дараагийн крон үүнийг илгээх болно).';
$string['configdisplaymode'] = 'Мэтгэлцээний харах горимыг тохируулаагүй тохиолдолд өгөгдмөлөөр харуулах горим';
$string['configenablerssfeeds'] = 'Энэ сонголт нь бүх хэлэлцүүлгийн хувьд RSS мэдэгдлийн боломжийг идэвхжүүлнэ. Гэхдээ хэлэлцүүлэг бүрийн тохиргоонд мэдэгдлийг идэвхжүүлэх шаардлагатай хэвээр байна.';
$string['configenabletimedposts'] = 'Хэрэв та шинэ хэлэлцүүлгийн мэтгэлцээн нийтлэхдээ харуулах хугацааг тохируулахыг хүсвэл "тийм" гэж тохируулна уу.';
$string['configlongpost'] = 'Энэ уртаас дээш тооны тэмдэгт (HTML тагийг оруулахгүй) бүхий аливаа нийтлэлийг урт гэж үзнэ. Веб хуудасны нүүрэн хэсэг, олон нийтийн хэлбэртэй хичээлийн хуудаснууд эсвэл хэрэглэгчийн хувийн мэдээлэл дээр байгаа нийтлэлүүдийг forum_shortpost болон forum_longpost гэсэн утгуудын хооронд тасалж товчилсон байдаг.';
$string['configmanydiscussions'] = 'Хэлэлцүүлгийн нэг хуудсанд харагдах хамгийн их мэтгэлцээний тоо';
$string['configmaxattachments'] = 'Нэг нийтлэлд зөвшөөрөх хавсралтын өгөгдмөл хамгийн их тоо.';
$string['configmaxbytes'] = 'Веб хуудас дээрх бүх хэлэлцүүлгийн хавсралтын өгөгдмөл дээд хэмжээ (хичээлийн хязгаарлалт болон бусад тохиргооноос хамаарна)';
$string['configoldpostdays'] = 'Хуучин нийтлэлийг уншигдахаар байлгах өдрийн тоо';
$string['configreplytouser'] = 'Хэлэлцүүлгийн нийтлэлийг шуудангаар илгээхдээ хүлээн авагчид хэлэлцүүлгээр бус хувийн байдлаар хариулах боломж олгохын тулд цахим шуудан нь тухайн хэрэглэгчийн цахим шуудангийн хаягийг агуулсан байх ёстой юу? "Тийм" гэж тохируулсан ч гэсэн хэрэглэгч хувийн мэдээлэл дээрээ цахим шуудангийн хаягаа нууцлах боломжтой.';
$string['configrssarticlesdefault'] = 'Хэрэв RSS мэдэгдлийг идэвхжүүлсэн тохиолдолд нийтлэлийн (хэлэлцүүлэг эсвэл нийтлэл) өгөгдмөл тоог тохируулна.';
$string['configrsstypedefault'] = 'Хэрэв RSS мэдэгдлийг идэвхжүүлсэн тохиолдолд үйл ажиллагааны өгөгдмөл төрлийг тохируулна.';
$string['configshortpost'] = 'Энэ уртаас доош тооны тэмдэгт (HTML тагийг оруулахгүй) бүхий аливаа нийтлэлийг богино гэж үзнэ (доорхийг хар).';
$string['configsubscriptiontype'] = 'Захиалгын горимын өгөгдмөл тохиргоо.';
$string['configtrackingtype'] = 'Уншсан эсэхийг хянах өгөгдмөл тохиргоо.';
$string['configtrackreadposts'] = 'Хэрэв та хэрэглэгч бүрийн уншсан/уншаагүй байдлыг хянахыг хүсвэл "тийм" гэж тохируулна уу.';
$string['configusermarksread'] = 'Хэрэв "тийм" гэж тохируулсан бол хэрэглэгч нийтлэлийг уншсан гэж гараар тэмдэглэх ёстой. Хэрэв "үгүй" гэж тохируулсан бол нийтлэлийг үзэхэд уншсан гэж тэмдэглэнэ.';
$string['confirmsubscribe'] = 'Та \'{$a}\' хэлэлцүүлэгт нэгдмээр байна уу?';
$string['confirmsubscribediscussion'] = 'Та {$a->forum}\' хэлэлцүүлгийн  \'{$a->discussion}\' мэтгэлцээнд нэгдмээр байна уу?';
$string['confirmunsubscribe'] = 'Та \'{$a}\' хэлэлцүүлгээс гармаар байна уу?';
$string['confirmunsubscribediscussion'] = 'Та {$a->forum}\' хэлэлцүүлгийн  \'{$a->discussion}\' мэтгэлцээнээс гармаар байна уу?';
$string['couldnotadd'] = 'Үл мэдэгдэх алдааны улмаас таны нийтлэлийг нэмж чадсангүй';
$string['couldnotdeletereplies'] = 'Уучлаарай, хүмүүс үүнд аль хэдийн хариу бичсэн тул устгах боломжгүй';
$string['couldnotupdate'] = 'Үл мэдэгдэх алдааны улмаас таны нийтлэлийг шинэчилж чадсангүй';
$string['created'] = 'Үүссэн';
$string['crontask'] = 'Хэлэлцүүлгийн цахим шуудангууд болон засвар үйлчилгээний ажлууд';
$string['cutoffdate'] = 'Таслах огноо';
$string['cutoffdate_help'] = 'Тохируулсан тохиолдолд тус огнооноос хойш хэлэлцүүлэгт нийтлэл бичихийг зөвшөөрөхгүй.';
$string['cutoffdatereached'] = 'Энэ хэлэлцүүлэгт нийтлэх огноо дууссан тул та цаашид энэ хэлэлцүүлэгт нийтлэл бичих боломжгүй.';
$string['cutoffdatevalidation'] = 'Таслах огноо нь товлосон огнооноос эрт байж болохгүй.';
$string['delete'] = 'Устгах';
$string['deleteddiscussion'] = 'Мэтгэлцээний сэдвийг устгасан байна';
$string['deletedpost'] = 'Нийтлэлийг устгасан байна';
$string['deletedposts'] = 'Эдгээр нийтлэлийг устгасан байна.';
$string['deleteduser'] = 'Устгасан хэрэглэгч';
$string['deletesure'] = 'Та энэ нийтлэлийг устгамаар байна уу?';
$string['deletesureplural'] = 'Та энэ нийтлэл болон болон бүх хариуг устгамаар байна уу? ({$a} нийтлэл)';
$string['digestmailheader'] = 'Энэ бол таны {$a->sitename} хэлэлцүүлгийн шинэ нийтлэлүүдийн өдөр тутмын тойм юм. Хэлэлцүүлгийн цахим шуудангийн өгөгдмөл тохиргоог өөрчлөхийн тулд {$a->userprefs} руу очно уу.';
$string['digestmailpost'] = 'Хэлэлцүүлгийн тоймын тохиргоог өөрчлөх';
$string['digestmailpostlink'] = 'Хэлэлцүүлгийн тоймын тохиргоог өөрчлөх: {$a}';
$string['digestmailprefs'] = 'Таны хэрэглэгчийн мэдээлэл';
$string['digestmailsubject'] = '{$a}: Хэлэлцүүлгийн тойм';
$string['digestmailtime'] = 'Тойм мэдээний цахим шууданг илгээх цаг';
$string['digestsentusers'] = 'Тойм мэдээний цахим шууданг {$a} хэрэглэгч рүү амжилттай илгээлээ.';
$string['disallowsubscribe'] = 'Захиалгыг зөвшөөрөхгүй';
$string['disallowsubscribeteacher'] = 'Захиалгыг зөвшөөрөхгүй (багшаас бусдад)';
$string['disallowsubscription'] = 'Захиалга';
$string['disallowsubscription_help'] = 'Таныг мэтгэлцээнд нэгдэх боломжгүй байхаар энэ хэлэлцүүлгийг тохируулсан байна.';
$string['discussion'] = 'Мэтгэлцээн';
$string['discussionlistsortbycreatedasc'] = 'Хуучнаас шинэ рүү эрэмбэлэх';
$string['discussionlistsortbycreateddesc'] = 'Шинээс хуучин руу эрэмбэлэх';
$string['discussionlistsortbydiscussionasc'] = 'Мэтгэлцээний нэрийн өсөх дарааллаар эрэмбэлэх';
$string['discussionlistsortbydiscussiondesc'] = 'Мэтгэлцээний нэрийн буурах дарааллаар эрэмбэлэх';
$string['discussionlistsortbygroupasc'] = 'Бүлгийн өсөх дарааллаар эрэмбэлэх';
$string['discussionlistsortbygroupdesc'] = 'Бүлгийн буурах дарааллаар эрэмбэлэх';
$string['discussionlistsortbylastpostasc'] = 'Сүүлчийн нийтлэлийн хуучнаас шинэ рүү эрэмбэлэх';
$string['discussionlistsortbylastpostdesc'] = 'Сүүлчийн нийтлэлийн шинээс хуучин руу эрэмбэлэх';
$string['discussionlistsortbyrepliesasc'] = 'Хариултын тоогоор нь өсөх дарааллаар эрэмбэлэх';
$string['discussionlistsortbyrepliesdesc'] = 'Хариултын тоогоор нь буурах дарааллаар эрэмбэлэх';
$string['discussionlistsortbystarterasc'] = 'Мэтгэлцээнийг эхлүүлэгчийн нэрээр нь өсөх дарааллаар эрэмбэлэх';
$string['discussionlistsortbystarterdesc'] = 'Мэтгэлцээнийг эхлүүлэгчийн нэрээр нь буурах дарааллаар эрэмбэлэх';
$string['discussionlocked'] = 'Энэ мэтгэлцээн түгжигдсэн тул та цаашид хариулт өгөх боломжгүй';
$string['discussionlockingdisabled'] = 'Мэтгэлцээнийг түгжиж болохгүй';
$string['discussionlockingheader'] = 'Мэтгэлцээнийг түгжих';
$string['discussionmoved'] = 'Энэ мэтгэлцээнийг \'{$a}\' руу зөөсөн байна.';
$string['discussionmovedpost'] = 'Энэ мэтгэлцээнийг <a href="{$a->forumhref}">{$a->forumname}</a> хэлэлцүүлгийн <a href="{$a->discusshref}">энд</a> зөөсөн байна.';
$string['discussionname'] = 'Мэтгэлцээний нэр';
$string['discussionnownotsubscribed'] = '{$a->name}-д \'{$a->forum}\' хэлэлцүүлгийн \'{$a->discussion}\' мэтгэлцээний шинэ нийтлэлийн талаар МЭДЭГДЭХГҮЙ.';
$string['discussionnowsubscribed'] = 'Танд \'{$a->forum}\' хэлэлцүүлгийн \'{$a->discussion}\' мэтгэлцээний шинэ нийтлэлийн талаар мэдэгдэнэ.';
$string['discussionpin'] = 'Бэхлэх';
$string['discussionpinned'] = 'Бэхлэгдсэн';
$string['discussionpinned_help'] = 'Бэхлэгдсэн мэтгэлцээн нь хэлэлцүүлгийн дээд хэрэгт харагдана.';
$string['discussions'] = 'Мэтгэлцээн';
$string['discussionsplit'] = 'Мэтгэлцээнийг хуваасан байна';
$string['discussionsstartedby'] = '{$a} хэрэглэгчийн эхлүүлсэн мэтгэлцээнүүд';
$string['discussionsstartedbyrecent'] = '{$a} хэрэглэгчийн саяхан эхлүүлсэн мэтгэлцээнүүд';
$string['discussionsstartedbyuserincourse'] = 'Мэтгэлцээнүүдийг {$a->coursename} хичээлийн {$a->fullname} эхлүүлсэн';
$string['discussionsstartedincourse'] = '{$a}-д эхлүүлсэн мэтгэлцээнүүд';
$string['discussionstartedby'] = '{$a} хэрэглэгчийн эхлүүлсэн мэтгэлцээнүүд';
$string['discussionsubscribed'] = 'Та энэ мэтгэлцээнд нэгдсэн байна.';
$string['discussionsubscribestart'] = 'Энэ мэтгэлцээнд шинэ нийтлэл орвол надад мэдэгдэнэ үү';
$string['discussionsubscribestop'] = 'Энэ мэтгэлцээнд шинэ бичлэг орвол надад мэдэгдэх хэрэггүй';
$string['discussionsubscription'] = 'Мэтгэлцээний захиалга';
$string['discussionsubscription_help'] = 'Та мэтгэлцээнд нэгдсэнээр тухайн мэтгэлцээний шинэ нийтлэлийн мэдэгдлийг хүлээн авна гэсэн үг.';
$string['discussionunpin'] = 'Бэхлэхээ болих';
$string['discussionunsubscribed'] = 'Та энэ мэтгэлцээнээс гарсан байна.';
$string['discussthistopic'] = 'Энэ сэдвээр мэтгэлцэх';
$string['discusstopicname'] = 'Энэ сэдвээр мэтгэлцэх: {$a}';
$string['displayend'] = 'Төгсгөлийг харуулах';
$string['displayend_help'] = 'Энэ тохиргоогоор тодорхой хугацааны дараа мэтгэлцээний нийтлэлийг нуух хэрэгтэй эсэхийг заана. Администратор мэтгэлцээний нийтлэлийг дурын үедээ үзэх боломжтой.';
$string['displayenddate'] = 'Төгсгөлийг харуулах: {$a}';
$string['displaymode'] = 'Харуулах горим';
$string['displayperiod'] = 'Харуулах хугацаа';
$string['displaystart'] = 'Эхлэлийг харуулах';
$string['displaystart_help'] = 'Энэ тохиргоогоор тодорхой хугацааны дараа мэтгэлцээний нийтлэлийг харуулах хэрэгтэй эсэхийг заана. Администратор мэтгэлцээний нийтлэлийг дурын үедээ үзэх боломжтой.';
$string['displaystartdate'] = 'Эхлэлийг харуулах: {$a}';
$string['displaywordcount'] = 'Үгийн тоог харуулах';
$string['displaywordcount_help'] = 'Энэ тохиргоо нь нийтлэл бүрийн үгийн тоо харагдах эсэхийг тодорхойлно.';
$string['duedate'] = 'Товлосон огноо';
$string['duedate_help'] = 'Энэ нь хэлэлцүүлэгт нийтлэл бичихийг дуусгах огноо. Хэдийгээр энэ огноог хуанли дээр хэлэлцүүлгийн товлосон (эцсийн) огноо гэж харуулсан ч энэ өдрөөс хойш нийтлэхийг зөвшөөрдөг. Тодорхой өдрөөс хойш хэлэлцүүлэгт нийтлэхээс сэргийлэхийн тулд хэлэлцүүлгийг таслах огноог тогтооно.';
$string['duedatetodisplayincalendar'] = 'Хуанлид харуулах товлосон огноо';
$string['eachuserforum'] = 'Хүн бүр нэг мэтгэлцээн эхлүүлэх';
$string['edit'] = 'Засварлах';
$string['editdiscussion'] = 'Мэтгэлцээнийг засварлах';
$string['editdiscussiontopic'] = 'Мэтгэлцээний сэдвийг засварлах';
$string['editedby'] = '{$a->name} засварласан - анхны мэдүүлэг {$a->огноо}';
$string['editedpostupdated'] = '{$a}\'-н нийтлэл шинэчлэгдсэн';
$string['editing'] = 'Засварлаж байна';
$string['emaildigestcompleteshort'] = 'Нийтлэлийг дуусгах';
$string['emaildigestdefault'] = 'Өгөгдмөл ({$a})';
$string['emaildigestoffshort'] = 'Тойм мэдээгүй';
$string['emaildigestsubjectsshort'] = 'Зөвхөн гарчигууд';
$string['emaildigesttype'] = 'Цахим шуудангаар тойм мэдээ авах сонголтууд';
$string['emaildigesttype_help'] = 'Хэлэлцүүлэг бүрээр таны хүлээн авах мэдэгдлийн төрөл.

* Өгөгдмөл - Хэрэглэгчийн хувийн мэдээлэлд тодорхойлсон тойм мэдээний тохиргооны дагуу мэдэгдэл авна. Хэрэв та хувийн мэдээллээ шинэчилбэл уг өөрчлөлт энд бас тусгагдана;
* Тойм мэдээгүй - та хэлэлцүүлгийн нийтлэл тус бүрээр цахим шуудан хүлээн авна;
* Тойм мэдээ - бүрэн нийтлэл - хэлэлцүүлгийн нийтлэл тус бүрийн бүрэн агуулгыг агуулсан мэдээг өдөрт нэг удаа цахим шуудангаар хүлээн авах болно;
* Тойм мэдээ - зөвхөн гарчиг - хэлэлцүүлгийн нийтлэл тус бүрийн гарчгийг агуулсан мэдээг өдөрт нэг удаа цахим шуудангаар хүлээн авах болно;';
$string['emptymessage'] = 'Таны нийтлэлд ямар нэг зүйл буруу байна. Магадгүй та нийтлэлээ хоосон үлдээсэн эсвэл хавсралт нь хэт том байна. Тиймээс таны оруулсан өөрчлөлтүүдийг хадгалаагүй.';
$string['errorcannotlock'] = 'Та мэтгэлцээнийг түгжих эрхгүй байна.';
$string['errordiscussionnotfound'] = 'Мэтгэлцээн олдсонгүй';
$string['erroremptymessage'] = 'Нийтлэлийн зурвас хоосон байж болохгүй';
$string['erroremptysubject'] = 'Нийтлэлийн гарчиг хоосон байж болохгүй.';
$string['errorenrolmentrequired'] = 'Та энэ агуулгад хандахын тулд энэ хичээлд бүртгүүлсэн байх ёстой';
$string['errorforumnotfound'] = 'Энэ мэтгэлцээнд хамаарах хэлэлцүүлэг олдсонгүй';
$string['errorwhiledelete'] = 'Бичлэгийг устгахад алдаа гарлаа.';
$string['eventassessableuploaded'] = 'Зарим агуулгыг нийтэлсэн байна.';
$string['eventcoursesearched'] = 'Хичээлийг хайсан';
$string['eventdiscussioncreated'] = 'Мэтгэлцээнийг үүсгэсэн';
$string['eventdiscussiondeleted'] = 'Мэтгэлцээнийг утгасан';
$string['eventdiscussionmoved'] = 'Мэтгэлцээнийг зөөсөн';
$string['eventdiscussionpinned'] = 'Мэтгэлцээнийг бэхэлсэн';
$string['eventdiscussionsubscriptioncreated'] = 'Мэтгэлцээний захиалга үүссэн';
$string['eventdiscussionsubscriptiondeleted'] = 'Мэтгэлцээний захиалгыг утгасан';
$string['eventdiscussionunpinned'] = 'Мэтгэлцээнийг бэхлэхээ больсон';
$string['eventdiscussionupdated'] = 'Мэтгэлцээнийг шинэчилсэн';
$string['eventdiscussionviewed'] = 'Мэтгэлцээнийг харсан';
$string['eventpostcreated'] = 'Нийтлэл үүсгэсэн';
$string['eventpostdeleted'] = 'Нийтлэлийг устгасан';
$string['eventpostupdated'] = 'Нийтлэлийг шинэчлэсэн';
$string['eventreadtrackingdisabled'] = 'Уншсан эсэхийг хянахыг идэвхгүй болгосон';
$string['eventreadtrackingenabled'] = 'Уншсан эсэхийг хянахыг идэвхжүүлсэн';
$string['eventsubscribersviewed'] = 'Захиалагч үзсэн';
$string['eventsubscriptioncreated'] = 'Захиалга үүссэн';
$string['eventsubscriptiondeleted'] = 'Захиалгыг утгасан';
$string['eventuserreportviewed'] = 'Хэрэглэгчийн тайланг үзсэн';
$string['everyonecanchoose'] = 'Бүх хүн нэгдэхээр сонгох боломжтой';
$string['everyonecannowchoose'] = 'Одоо бүх хүн нэгдэхээр сонгох боломжтой';
$string['everyoneisnowsubscribed'] = 'Энэ мэтгэлцээнд одоо бүх хүн нэгдсэн';
$string['everyoneissubscribed'] = 'Энэ мэтгэлцээнд бүх хүн нэгдсэн';
$string['existingsubscribers'] = 'Одоо байгаа захиалагчид';
$string['export'] = 'Экспортлох';
$string['exportattachmentname'] = '{$a} хавсралтыг багц руу экспортлох';
$string['exportdiscussion'] = 'Мэтгэлцээнийг бүхлээр нь багц руу экспортлох';
$string['exporthumandates'] = 'Хүн унших боломжтой огноо';
$string['exporthumandates_help'] = 'Огноог хүний унших форматаар эсвэл цагийн тэмдэг (тоонуудын дараалал) хэлбэрээр экспортлох эсэх.';
$string['exportoptions'] = 'Экспортлох тохиргоо';
$string['exportstriphtml'] = 'HTML-ийг хасах';
$string['exportstriphtml_help'] = 'Хэлэлцүүлгийн нийтлэл дэх p, br зэрэг HTML тагийг хасах эсэх.';
$string['favourites'] = 'Одоор тэмдэглэсэн';
$string['favouriteupdated'] = 'Таны од сонголт шинэчлэгдсэн байна.';
$string['firstpost'] = 'Анхны нийтлэл';
$string['forcedreadtracking'] = 'Албадан уншихыг хянахыг зөвшөөрөх';
$string['forcedreadtracking_desc'] = 'Мэтгэлцээнийг албадан уншихыг хянах горимд тохируулахыг зөвшөөрдөг. Олон хэлэлцүүлэг, нийтлэл бүхий хичээл нь хэрэглэгчийн гүйцэтгэл буурахад хүргэдэг. Унтраах үед өмнө нь "Албадан" гэж тохируулсан мэтгэлцээнийг нэмэлт гэж үзнэ.';
$string['forcesubscribed'] = 'Энэ мэтгэлцээнд хүн бүр заавал нэгдэх ёстой';
$string['forcesubscribed_help'] = 'Энэ хэлэлцүүлэгт таныг мэтгэлцээнээс гарах боломжгүй байхаар тохируулсан байна';
$string['forum'] = 'Хэлэлцүүлэг';
$string['forum:addinstance'] = 'Шинэ хэлэлцүүлэг нэмэх';
$string['forum:addnews'] = 'Зарлал нэмэх';
$string['forum:addquestion'] = 'Асуулт нэмэх';
$string['forum:allowforcesubscribe'] = 'Албадан нэгдэхийг зөвшөөрөх';
$string['forum:canoverridecutoff'] = 'Хэлэлцүүлэгт таслах огнооноос хойш нийтлэх';
$string['forum:canoverridediscussionlock'] = 'Түгжсэн мэтгэлцээнд хариулах';
$string['forum:canposttomygroups'] = 'Таны хандах боломжтой бүх бүлэгт нийтлэх';
$string['forum:cantogglefavourite'] = 'Одоор тэмдэглэсэн мэтгэлцээн';
$string['forum:createattachment'] = 'Хавсралтууд үүсгэх';
$string['forum:deleteanypost'] = 'Дурын нийтлэлийг устгах (хэдийд ч)';
$string['forum:deleteownpost'] = 'Өөрийн нийтлэлийг устгах (тогтоосон хугацаанд)';
$string['forum:editanypost'] = 'Дурын бичлэгийг засварлах';
$string['forum:exportdiscussion'] = 'Мэтгэлцээнийг бүхлээр нь экспортлох';
$string['forum:exportforum'] = 'Мэтгэлцээнийг экспортлох';
$string['forum:exportownpost'] = 'Өөрийн нийтлэлийг экспортлох';
$string['forum:exportpost'] = 'Нийтлэл экспортлох';
$string['forum:grade'] = 'Дүнгийн хэлэлцүүлэг';
$string['forum:managesubscriptions'] = 'Захиалагчийг удирдах';
$string['forum:movediscussions'] = 'Мэтгэлцээнийг зөөх';
$string['forum:pindiscussions'] = 'Мэтгэлцээнийг бэхлэх';
$string['forum:postprivatereply'] = 'Нийтлэлд хувийн байдлаар хариулах';
$string['forum:postwithoutthrottling'] = 'Нийтлэлийн хязгаарт үл хамаарах';
$string['forum:rate'] = 'Нийтлэлийг үнэлэх';
$string['forum:readprivatereplies'] = 'Хувийн хариултыг харах';
$string['forum:replynews'] = 'Зарлалд хариулах';
$string['forum:replypost'] = 'Нийтлэлд хариулах';
$string['forum:splitdiscussions'] = 'Мэтгэлцээнийг хуваах';
$string['forum:startdiscussion'] = 'Шинэ мэтгэлцээн эхлүүлэх';
$string['forum:viewallratings'] = 'Хувь хүмүүсийн өгсөн бүх боловсруулаагүй үнэлгээг харах';
$string['forum:viewanyrating'] = 'Хүн бүрийн хүлээн авсан нийт үнэлгээг харах';
$string['forum:viewdiscussion'] = 'Мэтгэлцээнийг харах';
$string['forum:viewhiddentimedposts'] = 'Нуусан хугацаатай нийтлэлүүдийг харах';
$string['forum:viewqandawithoutposting'] = 'Үргэлж Q(асуулт) болон A(хариулт) нийтлэлийг харах';
$string['forum:viewrating'] = 'Таны хүлээн авсан нийт үнэлгээг харах';
$string['forum:viewsubscribers'] = 'Захиалагчдыг харах';
$string['forumauthorhidden'] = 'Зохиолч (Нуугдсан)';
$string['forumblockingalmosttoomanyposts'] = 'Таны нийтлэх боломжит тоо дуусаж байна. Та сүүлийн {$a->blockperiod} хугацаанд {$a->numposts} удаа нийтэлсэн бөгөөд хязгаар нь {$a->blockafter} байна.';
$string['forumbodydeleted'] = 'Энэ хэлэлцүүлгийн нийтлэлийн агуулгыг устгасан бөгөөд цаашид хандах боломжгүй.';
$string['forumbodyhidden'] = 'Энэ нийтлэлийг одоогоор нуусан байна. Магадгүй та эхлээд мэтгэлцээнд нийтэл бичих, нийтэлсэн мэдэгдлийг илгээх ёстой байж болох юм. Эсвэл одоо нийтлэлд заасан харуулах хугацаа биш байж магадгүй.';
$string['forumgrader'] = 'Хэлэлцүүлгийг үнэлэгч';
$string['forumgradingnavigation'] = 'Хэлэлцүүлгийг үнэлэх удирдлагын мөр';
$string['forumgradingpanel'] = 'Хэлэлцүүлгийг үнэлэх самбар';
$string['forumintro'] = 'Танилцуулга';
$string['forumname'] = 'Хэлэлцүүлгийн нэр';
$string['forumposts'] = 'Хэлэлцүүлгийн нийтлэлүүд';
$string['forums'] = 'Хэлэлцүүлэг';
$string['forumsubjectdeleted'] = 'Хэлэлцүүлгийн нийтлэл хасагдсан байна';
$string['forumsubjecthidden'] = 'Сэдэв (нуугдсан)';
$string['forumtracked'] = 'Уншаагүй нийтлэлүүдийг хянаж байна';
$string['forumtrackednot'] = 'Уншигдаагүй бичлэгүүд нь тэмдэглэгдэхгүй.';
$string['forumtype'] = 'Хэлэлцүүлгийн төрөл';
$string['forumtype_help'] = 'Хэлэлцүүлгийн 5 төрөл:

* Энгийн нэг мэтгэлцээн - Хүн бүр хариулж болох энгийн нэг хэлэлцүүлгийн сэдэв (Тусдаа бүлгүүдэд ашиглахгүй)
* Хүн бүр нэг мэтгэлцээн нийтлэх - Суралцагч бүр бүх хүн хариулах боломжтой яг нэг шинэ хэлэлцүүлгийн сэдэв нийтлэх боломжтой
* Q(асуулт) ба A(хариулт) хэлэлцүүлэг - Суралцагч бүр бусад суралцагчдын нийтлэлийг үзэхийн өмнө эхлээд багшийн бичсэн асуултад хариулах ёстой
* Блог хэлбэрээр харагдах стандарт хэлэлцүүлэг - Хэн ч хүссэн үедээ шинэ хэлэлцүүлэг эхлүүлэх боломжтой бөгөөд хэлэлцүүлгийн сэдвүүдийг нэг хуудсанд "Энэ сэдвийг хэлэлцэх" холбоосоор харуулсан нээлттэй хэлэлцүүлэг
* Үндсэн хэрэглээнд зориулсан стандарт хэлэлцүүлэг - Хэн ч ямар ч хугацаанд шинэ хэлэлцүүлэг эхлүүлж болох нээлттэй хэлэлцүүлэгт';
$string['generalforum'] = 'Үндсэн хэрэглээнд зориулсан стандарт хэлэлцүүлэг';
$string['generalforums'] = 'Ерөнхий хэлэлцүүлгүүд';
$string['grade_forum_header'] = 'Хэлэлцүүлгийг бүхэлд нь үнэлэх';
$string['grade_forum_name'] = 'Бүтэн хэлэлцүүлэг';
$string['grade_forum_title'] = 'Дүн';
$string['grade_rating_name'] = 'Үнэлгээ';
$string['graded'] = 'Дүгнэсэн';
$string['gradedby'] = 'Дүгнэсэн:';
$string['gradeforrating'] = 'Үнэлгээний дүн: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Үнэлгээний дүнг нуусан';
$string['gradeforwholeforum'] = 'Хэлэлцүүлгийн дүн: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Хэлэлцүүлгийн дүнг нуусан';
$string['gradeitem:forum'] = 'Хэлэлцүүлэг';
$string['gradeitemnameforrating'] = '{$a->name} үнэлэх';
$string['gradeitemnameforwholeforum'] = '{$a->name} бүтэн хэлэлцүүлэг';
$string['grades:gradesavedfor'] = '{$a->fullname}-н дүнг хадгалсан';
$string['grades:gradesavefailed'] = '{$a->fullname}-н дүнг хадгалах боломжгүй: {$a->error}';
$string['gradeusers'] = 'Хэрэглэгчийн дүн';
$string['grading'] = 'Дүн';
$string['gradingstatus'] = 'Дүнгийн төлөв:';
$string['hiddenforumpost'] = 'Нуусан хэлэлцүүлгийн нийтлэл';
$string['hidegraderpanel'] = 'Дүгнэх самбарыг нуух';
$string['hidepreviousrepliescount'] = 'Өмнөх хариуг ({$a}) нуух';
$string['hideusersearch'] = 'Хэрэглэгчийн хайлтыг нуух';
$string['indexoutoftotal'] = 'нийт {$a->total}-ээс {$a->index}';
$string['indicator:cognitivedepth'] = 'Хэлэлцүүлгийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн хэлэлцүүлгийн үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд тулгуурладаг.';
$string['indicator:cognitivedepthdef'] = 'Хэлэлцүүлгийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд Хэлэлцүүлгийн үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд оролцогчийн хүрсэн хувь хэмжээ (Түвшин = Харах боломжгүй, Харах, Илгээх, Санал хүсэлтийг харах, Санал хүсэлтийн талаар сэтгэгдэл бичих, Санал хүсэлтийг үзсэний дараа дахин илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Хэлэлцүүлгийн нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн хэлэлцүүлгийн үйл ажиллагаанд хүрсэн нийгмийн хүрээнд тулгуурладаг.';
$string['indicator:socialbreadthdef'] = 'Хэлэлцүүлгийн нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд Хэлэлцүүлгийн үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд оролцогчийн хүрсэн хувь хэмжээ (Түвшин = оролцоогүй, ганцаараа оролцогч, бусадтай оролцогч)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = '{$a} -д';
$string['inreplyto'] = '{$a}-н хариуд';
$string['introblog'] = 'Эдгээр блог руу оруулсан материалууд байхгүй болсон тул энэ форумын бичлэгүүдийг энэ хичээлийн хэрэглэгч нарын блогоос ийшээ автоматаар хуулагдсан байна';
$string['intronews'] = 'Ерөнхий мэдээ ба зарлалууд';
$string['introsocial'] = 'Өөрийн ярилцахыг хүссэн сэдвээр хэлэлцүүлэг нээх';
$string['introteacher'] = 'Зөвхөн багшийн тэмдэглэл ба мэтгэлцээний хэлэлцүүлэг';
$string['invalidaccess'] = 'Энэ хуудсанд зөв хандсангүй';
$string['invaliddigestsetting'] = 'Цахим шуудангийн тойм мэдээний тохиргоог буруу хийсэн байна';
$string['invaliddiscussionid'] = 'Мэтгэлцээний ID буруу эсвэл байхаа больсон';
$string['invalidforcesubscribe'] = 'Албадмал захиалгын горим буруу байна';
$string['invalidforumid'] = 'Хэлэлцүүлгийн ID буруу';
$string['invalidparentpostid'] = 'Эх нийтлэлийн ID буруу байна';
$string['invalidpostid'] = 'Нийтлэлийн ID буруу байна - {$a}';
$string['lastpost'] = 'Хамгийн сүүлчийн нийтлэл';
$string['learningforums'] = 'Сургалтын хэлэлцүүлгүүд';
$string['lockdiscussion'] = 'Энэ мэтгэлцээнийг цоожлох';
$string['lockdiscussionafter'] = 'Хэсэг хугацаанд идэвхгүй байсны дараа мэтгэлцээнийг түгжих';
$string['lockdiscussionafter_help'] = 'Сүүлийн хариултаас хойш тодорхой хугацаа өнгөрсний дараа мэтгэлцээнийг автоматаар түгжиж болно.

Түгжигдсэн мэтгэлцээнд хариу бичих чадвартай хэрэглэгчид хариу бичих замаар түгжээг тайлах боломжтой.';
$string['locked'] = 'Түгжигдсэн';
$string['lockupdated'] = 'Цоожлох тохиргоог шинэчилсэн байна';
$string['longpost'] = 'Урт нийтлэл';
$string['mailnow'] = 'Хэлэлцүүлгийн нийтлэлийн мэдэгдлийг засварлах хугацааны хоцрогдолгүйгээр илгээнэ үү';
$string['managesubscriptionsoff'] = 'Захиалгыг удирдаж дуусгана уу';
$string['managesubscriptionson'] = 'Захиалагчдыг удирдах';
$string['manydiscussions'] = 'Нэг хуудаст харагдах мэтгэлцээний тоо';
$string['markalldread'] = 'Энэ мэтгэлцээний бүх нийтлэлийг уншсан гэж тэмдэглэх';
$string['markallread'] = 'Энэ хэлэлцүүлгийн бүх нийтлэлийг уншсан гэж тэмдэглэх';
$string['markasread'] = 'Уншсан гэж тэмдэглэх';
$string['markasreadonnotification'] = 'Хэлэлцүүлгийн нийтлэлийн мэдэгдэл илгээх үед';
$string['markasreadonnotification_help'] = 'Хэлэлцүүлгийн нийтлэлийн талаар танд мэдэгдэх үед хэлэлцүүлгийг хянах зорилгоор уг нийтлэлийг уншсан гэж тэмдэглэх эсэхээ сонгож болно.';
$string['markasreadonnotificationno'] = 'Нийтлэлийг уншсан гэж тэмдэглэхгүй';
$string['markasreadonnotificationyes'] = 'Нийтлэлийг уншсан гэж тэмдэглэнэ';
$string['markread'] = 'Уншсан тэмдэг';
$string['markreadbutton'] = 'Уншсан тэмдэг  <br />';
$string['markunread'] = 'Уншаагүй тэмдэг';
$string['markunreadbutton'] = 'Уншаагvй тэмдэг <br />';
$string['maxattachments'] = 'Хавсралтын хамгийн их тоо';
$string['maxattachments_help'] = 'Энэ тохиргоо нь хэлэлцүүлгийн бичлэгт хавсаргаж болох файлын хамгийн их тоог заана.';
$string['maxattachmentsize'] = 'Хавсралтын хамгийн их хэмжээ нь';
$string['maxattachmentsize_help'] = 'Энэ тохиргоо нь хэлэлцүүлгийн бичлэгт хавсаргаж болох дээд хэмжээг заана.';
$string['maxtimehaspassed'] = 'Уучлаарай, ({$a}) энэ нийтлэлийг хангалттай олон удаа зассан байна!';
$string['message'] = 'Зурвас';
$string['messageinboundattachmentdisallowed'] = 'Таны хариу хавсралт агуулсан байна. Энэ хэлэлцүүлэг нь хавсралтыг зөвшөөрөхгүй тул таны хариултыг нийтлэх боломжгүй.';
$string['messageinboundfilecountexceeded'] = 'Хэлэлцүүлэгт зөвшөөрөгдсөн дээд хязгаар ({$a->forum->maxattachments}) -аас олон хавсралт агуулж байгаа тул таны хариултыг нийтлэх боломжгүй байна.';
$string['messageinboundfilesizeexceeded'] = 'Таны хавсаргах файлын нийт хэмжээ  ({$a->filesize}) хэлэлцүүлэгт зөвшөөрөгдсөн ({$a->maxbytes}) хэмжээнээс илүү гарсан учир таны хариулсан нийтлэлийг оруулах боломжгүй.';
$string['messageinboundforumhidden'] = 'Хэлэлцүүлэг одоогоор боломжгүй байгаа тул таны хариултыг нийтлэх боломжгүй байна.';
$string['messageinboundnopostforum'] = 'Танд {$a->forum->name} форумд нийтлэх зөвшөөрөл байхгүй тул таны хариуг нийтлэх боломжгүй.';
$string['messageinboundthresholdhit'] = 'Таны нийтлэлийн тоо хэлэлцүүлэгт нийтлэх боломжтой нийтлэлийн босгод хүрсэн тул таны хариуг нийтлэх боломжгүй байна.';
$string['messageprovider:digests'] = 'Нэгсэн хэлэлцүүлгийн тойм мэдээ';
$string['messageprovider:posts'] = 'Нэгсэн хэлэлцүүлгийн нийтлэлүүд';
$string['missingsearchterms'] = 'Дараах хайлтын нэр томьёо нь зөвхөн энэ зурвасын HTML хэсэгт хүчинтэй:';
$string['modeflatnewestfirst'] = 'Шинэ хариултуудыг хамгийн эхэнд харуулах';
$string['modeflatoldestfirst'] = 'Хуучин хариултуудыг хамгийн эхэнд харуулах';
$string['modenested'] = 'Хариултуудыг үүрлэсэн хэлбэрээр харуулах';
$string['modenestedv2'] = 'Хариултуудыг бие биедээ багтсан хэлбэрээр харуулах';
$string['modethreaded'] = 'Хариултуудыг хэлхмэл хэлбэрээр харуулах';
$string['modulename'] = 'Хэлэлцүүлэг';
$string['modulename_help'] = 'Хэлэлцүүлгийн үйл ажиллагааны модуль нь оролцогчдод шууд бус (тухайлбал, урт хугацааны туршид явагдах) хэлэлцүүлэг хийх боломжийг олгодог.

Хэд хэдэн төрлийн хэлэлцүүлгээс сонгох боломжтой, тухайлбал хэн ч хүссэн үедээ шинэ хэлэлцүүлэг эхлүүлэх боломжтой стандарт хэлэлцүүлэг; суралцагч бүр яг нэг мэтгэлцээнийг нийтлэх боломжтой хэлэлцүүлэг; эсвэл суралцагч бусад суралцагчийн нийтлэлийг үзэхийн өмнө нийтлэл бичих ёстой асуулт хариултын форум. Багш нь хэлэлцүүлгийн нийтлэлд файл хавсаргахыг зөвшөөрч болно. Хавсаргасан зургуудыг хэлэлцүүлгийн нийтлэлд харуулна.

Оролцогчид хэлэлцүүлгийн шинэ нийтлэлийн мэдэгдлийг хүлээн авахын тулд хэлэлцүүлэгт нэгдэж (захиалж) болно. Багш захиалгын горимыг сонголттой, албадан эсвэл автоматаар тохируулах эсвэл захиалгаас бүрэн сэргийлэх боломжтой. Шаардлагатай бол суралцагчийг тухайн хугацаанд өгөгдсөн тооноос илүү нийтлэл оруулахыг хориглож болно; ингэснээр нь хувь хүмүүсийг хэлэлцүүлэгт давамгайлахаас сэргийлж чадна.

Хэлэлцүүлгийн нийтлэлийг багш эсвэл суралцагчид (үе тэнгийнхний үнэлгээ) үнэлж болно. Эцсийн үнэлгээг гарган журналд тэмдэглэж болно.

Хэлэлцүүлгийг дараах зорилгоор ашиглаж болно

* Суралцагчид бие биеэ таньж мэдэх нийтийн орон зай болгож
* Хичээлтэй холбоотой зарлал тавих (албадан захиалгатай мэдээний форум ашиглах)
* Хичээлийн агуулга эсвэл унших материалыг хэлэлцэхэд зориулагдсан
* Өмнө нь нүүр тулсан уулзалтаар хөндсөн асуудлыг онлайнаар үргэлжлүүлэхийн тулд
* Зөвхөн багш нарын мэтгэлцээнд зориулагдсан (нуусан хэлэлцүүлэг ашиглах)
* Багш, суралцагчид зөвлөгөө өгөх тусламжийн төв
* Багш-суралцагч хооронд харилцаа үүсгэх бүс болгож  (тусдаа бүлгүүдтэй, нэг бүлэгт нэг суралцагчтай хэлэлцүүлэг ашиглах)
* Оюутнууд ухаан бодлоо уралдуулж, эргэцүүлж,шийдэл боловсруулж, санал болгох нэмэлт ажлуудад (тухайлбал, "тархины тоглоомууд")';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Хэлэлцүүлэг';
$string['more'] = 'илүү';
$string['movedmarker'] = '(Зөөсөн)';
$string['movethisdiscussionlabel'] = 'Одоогийн мэтгэлцээнийг заасан хэлэлцүүлэг рүү зөөх';
$string['movethisdiscussionto'] = 'Энэ мэтгэлцээнийг ... рүү зөөх:';
$string['mustprovidediscussionorpost'] = 'Экспорт хийхийн тулд мэтгэлцээний ID эсвэл нийтлэлийн ID-г оруулах ёстой.';
$string['myprofileotherdis'] = 'Хэлэлцүүлэг мэтгэлцээн';
$string['myprofileowndis'] = 'Миний хэлэлцүүлэг мэтгэлцээн';
$string['myprofileownpost'] = 'Миний хэлэлцүүлгийн нийтлэл';
$string['namenews'] = 'Зарлал';
$string['namenews_help'] = 'Хичээлийн зарын хэлэлцүүлэг нь зар зарлал түгээх тусгай хэлэлцүүлэг бөгөөд хичээл үүсгэх үед автоматаар үүсдэг. Нэг хичээл нь зөвхөн нэг зарын хэлэлцүүлэгтэй байж болно. Зөвхөн багш болон администратор зар нийтлэх боломжтой. "Сүүлийн зарлал" блокт сүүлийн үеийн зарлалыг харуулна.';
$string['namesocial'] = 'Нийгмийн хэлэлцүүлэг';
$string['nameteacher'] = 'Багшийн хэлэлцүүлэг';
$string['newforumposts'] = 'Хэлэлцүүлгийн шинэ нийтлэлүүд';
$string['nextdiscussiona'] = 'Дараагийн мэтгэлцээн: {$a}';
$string['nextuser'] = 'Өөрчлөлтийг хадгалаад дараагийн хэрэглэгч рүү очих';
$string['noattachments'] = 'Энэ нийтлэл хавсралтгүй байна';
$string['nodiscussions'] = 'Энэ хэлэлцүүлэг одоогоор мэтгэлцээний сэдэвгүй байна';
$string['nodiscussionsstartedby'] = '{$a} хэлэлцүүлэгт одоогоор эхэлсэн мэтгэлцээн байхгүй байна';
$string['nodiscussionsstartedbyyou'] = 'Та ямар ч мэтгэлцээн эхлүүлээгүй байна';
$string['noguestpost'] = 'Зөвхөн нэвтэрсэн хэрэглэгч энэ хэлэлцүүлэгт нийтлэх боломжтой.';
$string['noguestpost:title'] = 'Үргэлжлүүлэхийн тулд нэвтэрнэ үү';
$string['noguestsubscribe'] = 'Уучлаарай, зочин нэгдэх боломжгүй';
$string['noguesttracking'] = 'Уучлаарай, зочин хэрэглэгч хянах тохиргоо хийх боломжгүй байна.';
$string['nomorepostscontaining'] = '\'{$a}\' агуулсан нийтлэл олдсонгүй.';
$string['nonews'] = 'Одоогоор зарлал нийтлээгүй байна.';
$string['noonecansubscribenow'] = 'Захиалга хийхийг хориглосон байна';
$string['nopermissiontosubscribe'] = 'Та хэлэлцүүлгийн захиалгагчдыг харах эрхгүй байна';
$string['nopermissiontoview'] = 'Та энэ нийтлэлийг харах эрхгүй байна';
$string['nopostforum'] = 'Уучлаарай, та энэ хэлэлцүүлэгт нийтлэх эрхгүй байна.';
$string['noposts'] = 'Нийтлэл байхгүй';
$string['nopostsmadebyuser'] = '{$a} нийтлэл бичээгүй байна';
$string['nopostsmadebyyou'] = 'Та нийтлэл бичих эрхгүй байна';
$string['noquestions'] = 'Энэ хэлэлцүүлэгт одоогоор асуулт оруулаагүй байна';
$string['nosubscribers'] = 'Одоогоор хэлэлцүүлэгт нэгдсэн хэрэглэгч байхгүй байна';
$string['notexists'] = 'Мэтгэлцээн байхгүй болсон';
$string['notgraded'] = 'Дүгнээгүй';
$string['nothingnew'] = '{$a}-т шинэ зүйл алга';
$string['notingroup'] = 'Уучлаарай, та энэ хэлэлцүүлгийг үзэхийн тулд бүлгийн гишүүн байх шаардлагатай.';
$string['notinstalled'] = 'Хэлэлцүүлгийн модулийг суулгаагүй байна';
$string['notlocked'] = 'Түгжих';
$string['notpartofdiscussion'] = 'Энэ нийтлэл нь мэтгэлцээний нэг хэсэг биш!';
$string['notrackforum'] = 'Уншаагүй нийтлэлийг хянахгүй';
$string['notsubscribed'] = 'Нэгдэх';
$string['nousersmatch'] = 'Өгөгдсөн шалгуурт тохирох хэрэглэгч олдсонгүй';
$string['noviewdiscussionspermission'] = 'Та энэ хэлэлцүүлгийн мэтгэлцээнүүдийг харах эрхгүй байна';
$string['nowallsubscribed'] = 'Та {$a} дахь бүх хэлэлцүүлэгт нэгдсэн байна.';
$string['nowallunsubscribed'] = 'Та {$a} дахь бүх хэлэлцүүлгээс гарсан байна.';
$string['nowgradinguser'] = '{$a} дүгнэж байна';
$string['nownotsubscribed'] = '\'{$a->forum}\'-д оруулсан шинэ нийтлэлийн талаар мэдэгдэл {$a->name}-д очихгүй';
$string['nownottracking'] = '{$a->name}  \'{$a->forum}\' хэлэлцүүлгийг хянахаа больсон.';
$string['nowsubscribed'] = '\'{$a->forum}\'-д оруулсан шинэ нийтлэлийн талаар танд мэдэгдэх болно';
$string['nowtracking'] = '{$a->name} нь \'{$a->forum}\' хэлэлцүүлгийг одоо хянаж байна.';
$string['numberofreplies'] = 'Хариу нийтлэлийн тоо: {$a}';
$string['numposts'] = '{$a} нийтлэл';
$string['olderdiscussions'] = 'Хуучин мэтгэлцээн';
$string['oldertopics'] = 'Хуучин сэдэв';
$string['oldpostdays'] = 'Хэдэн өдрийн дараа унших';
$string['page-mod-forum-discuss'] = 'Хэлэлцүүлгийн мэтгэлцээний модулийн хэлхмэл хуудас';
$string['page-mod-forum-view'] = 'Хэлэлцүүлгийн модулийн үндсэн хуудас';
$string['page-mod-forum-x'] = 'Хэлэлцүүлгийн модулийн дурын хуудас';
$string['parent'] = 'Эх үүсвэрийг харуулах';
$string['parentofthispost'] = 'Энэ нийтлэлийн эх үүсвэр';
$string['permalink'] = 'Байнгын холбоос';
$string['permanentlinktoparentpost'] = 'Энэ нийтлэлийн эх үүсвэр лүү холбох байнгын холбоос';
$string['permanentlinktopost'] = 'Энэ нийтлэл рүү холбох байнгын холбоос';
$string['pindiscussion'] = 'Энэ мэтгэлцээнийг бэхлэх';
$string['pinupdated'] = 'Бэхлэх сонголтыг шинэчилсэн байна';
$string['pluginadministration'] = 'Хэлэлцүүлэгийн удирдлага';
$string['pluginname'] = 'Хэлэлцүүлэг';
$string['postadded'] = '<p>Таны нийтлэл амжилттай нэмэгдлээ.</p> <p>Хэрэв та ямар нэг өөрчлөлт оруулахыг хүсвэл танд засвар хийх {$a} байна.</p>';
$string['postaddedsuccess'] = 'Таны нийтлэл амжилттай нэмэгдлээ.';
$string['postaddedtimeleft'] = 'Хэрэв та ямар нэг өөрчлөлт оруулахыг хүсвэл танд засвар хийх {$a} байна.';
$string['postbymailsuccess'] = 'Таны хариу "{$a->subject}" амжилттай нийтлэгдлээ: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Таны хариу <a href="{$a->discussionurl}">{$a->subject}</a> амжилттай нийтлэгдлээ.';
$string['postbyuser'] = '{$a->user} хэрэглэгчийн нийтлэл {$a->post}';
$string['postincontext'] = 'Энэ нийтлэлийг агуулгаар харах';
$string['postisprivatereply'] = 'Энэ бол хувийн хариулт юм. (Багш нар болон хувийн хариултыг харах боломжтой бусад хэрэглэгчид үүнийг харж болно.)';
$string['postmailinfo'] = 'Энэ бол {$a} дээр нийтэлсэн зурвасын хуулбар.';
$string['postmailinfolink'] = 'Энэ бол {$a->coursename} хичээлд нийтэлсэн зурвасын хуулбар.

Хариу бичихийн тулд {$a->replylink} холбоосыг дарна уу';
$string['postmailnow'] = '<p>Энэ нийтлэлийг хэлэлцүүлгийн бүх захиалагчдад шуудангаар илгээх болно.</p>';
$string['postmailreply'] = 'Хариу бичихийн тулд {$a} холбоосыг дарна уу';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Ихэвчлэн холбогдоогүй байхдаа мэддэг';
$string['postrating2'] = 'Холбогдоогүй байхдаа болон холбогдсон байхдаа';
$string['postrating3'] = 'Ихэвчлэн холбогдож мэддэг';
$string['posts'] = 'Нийтлэлүүд';
$string['postsfrom'] = '...аас нийтэлсэн нийтлэлүүд:';
$string['postsmadebyuser'] = '{$a}-н оруулсан нийтлэлүүд';
$string['postsmadebyuserincourse'] = '{$a->coursename} хичээлд {$a->fullname} хэрэглэгчийн оруулсан нийтлэлүүд';
$string['postsmadeincourse'] = '{$a} хичээлд оруулсан нийтлэлүүд';
$string['poststo'] = 'Нийтлэлүүд:';
$string['posttoforum'] = 'Хэлэлцүүлэгт нийтлэх';
$string['posttomygroups'] = 'Хуулбарыг бүх бүлгүүдэд нийтлэх';
$string['posttomygroups_help'] = 'Энэ зурвасын хуулбарыг таны хандах эрхтэй бүх бүлэгт нийтэлнэ. Таны хандах эрхгүй бүлгийн оролцогчид энэ нийтлэлийг харахгүй';
$string['postupdated'] = 'Таны нийтлэлийг шинэчилсэн';
$string['potentialsubscribers'] = 'Боломжит захиалагчид';
$string['prevdiscussiona'] = 'Өмнөх мэтгэлцээн: {$a}';
$string['previoususer'] = 'Өөрчлөлтийг хадгалаад өмнөх хэрэглэгч рүү шилжих';
$string['privacy:digesttypenone'] = 'Энэ хэлэлцүүлгийн тойм мэдээний төрөлтэй холбоотой ямар ч мэдээлэл агуулаагүй.';
$string['privacy:digesttypepreference'] = 'Та дараах хэлэлцүүлгийн тойм мэдээний төрлийг хүлээж авахаар сонгосон байна: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Та энэ хэлэлцүүлэгт дараах захиалгын сонголтыг сонгосон байна: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Хэлэлцүүлэг нь нийтлэлийн үнэлгээг дэмжих үнэлгээний дэд системийг ашигладаг.';
$string['privacy:metadata:core_tag'] = 'Хэлэлцүүлгийн нийтлэлийн тагийг дэмжихийн тулд тагийн дэд системийг ашигладаг.';
$string['privacy:metadata:forum_digests'] = 'Хэлэлцүүлэг бүрийн тойм мэдээний сонголтын талаарх мэдээлэл.';
$string['privacy:metadata:forum_digests:forum'] = 'Хэлэлцүүлгийг захиалсан:';
$string['privacy:metadata:forum_digests:maildigest'] = 'Тойм мэдээний сонголт.';
$string['privacy:metadata:forum_digests:userid'] = 'Тойм мэдээний сонголт бүхий хэрэглэгчийн ID.';
$string['privacy:metadata:forum_discussion_subs'] = 'Бие даасан хэлэлцүүлгийн мэтгэлцээний захиалгын тухай мэдээлэл';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Захиалсан мэтгэлцээний ID.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Захиалга эхэлсэн цаг.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Мэтгэлцээнийг захиалсан хэрэглэгчийн ID.';
$string['privacy:metadata:forum_discussions'] = 'Бие даасан хэлэлцүүлгийн мэтгэлцээнийг үүсгэсэн хэрэглэгчийн тухай мэдээлэл';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - энэ талбар юу хадгалах вэ';
$string['privacy:metadata:forum_discussions:name'] = 'Зохиогчийн сонгосон мэтгэлцээний нэр.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Мэтгэлцээнийг сүүлд өөрчилсөн цаг.';
$string['privacy:metadata:forum_discussions:userid'] = 'Мэтгэлцээнийг үүсгэсэн хэрэглэгчийн ID';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Мэтгэлцээнийг ямар нэг байдлаар хамгийн сүүлд өөрчилсөн хэрэглэгчийн ID.';
$string['privacy:metadata:forum_grades'] = 'Хэлэлцүүлгийн үнэлгээний өгөгдөл';
$string['privacy:metadata:forum_grades:forum'] = 'Дүгнэгдсэн хэлэлцүүлэг';
$string['privacy:metadata:forum_grades:grade'] = 'Авсан дүн';
$string['privacy:metadata:forum_grades:userid'] = 'Дүгнэсэн хэрэглэгч';
$string['privacy:metadata:forum_posts'] = 'Хэлэлцүүлэг тус бүрийн тойм мэдээний сонголтын талаарх мэдээлэл.';
$string['privacy:metadata:forum_posts:created'] = 'Нийтлэлийг үүсгэсэн цаг.';
$string['privacy:metadata:forum_posts:discussion'] = 'Нийтлэлд орсон хэлэлцүүлэг.';
$string['privacy:metadata:forum_posts:message'] = 'Хэлэлцүүлгийн нийтлэлийн зурвас.';
$string['privacy:metadata:forum_posts:modified'] = 'Нийтлэлийг сүүлд өөрчилсөн цаг.';
$string['privacy:metadata:forum_posts:parent'] = 'Хариу бичсэн эх үүсвэр нийтлэл.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Хариу илгээсэн хэрэглэгчийн ID.';
$string['privacy:metadata:forum_posts:subject'] = 'Хэлэлцүүлгийн нийтлэлийн гарчиг.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Хэлэлцүүлгийн нийтлэлийн зурвас.';
$string['privacy:metadata:forum_posts:userid'] = 'Хэлэлцүүлгийн нийтлэлийг үүсгэсэн хэрэглэгчийн ID.';
$string['privacy:metadata:forum_queue'] = 'Тойм мэдээний хэлбэрээр шуудангаар илгээгдэх нийтлэлүүдийн түр бүртгэл';
$string['privacy:metadata:forum_queue:discussionid'] = 'Хэлэлцүүлгийн мэтгэлцээний ID';
$string['privacy:metadata:forum_queue:postid'] = 'Хэлэлцүүлгийн нийтлэлийн ID';
$string['privacy:metadata:forum_queue:timemodified'] = 'Эх нийтлэлийг өөрчилсөн цаг';
$string['privacy:metadata:forum_queue:userid'] = 'Нийтлэлийн талаар мэдэгдэх шаардлагатай хэрэглэгч';
$string['privacy:metadata:forum_read'] = 'Хэрэглэгч ямар нийтлэл уншсан тухай мэдээлэл.';
$string['privacy:metadata:forum_read:discussionid'] = 'Нийтлэлд байгаа мэтгэлцээн.';
$string['privacy:metadata:forum_read:firstread'] = 'Нийтлэлийг анх уншсан цаг.';
$string['privacy:metadata:forum_read:lastread'] = 'Нийтлэлийг хамгийн сүүлд уншсан цаг.';
$string['privacy:metadata:forum_read:postid'] = 'Уншсан нийтлэл.';
$string['privacy:metadata:forum_read:userid'] = 'Энэ бичлэгтэй хамааралтай хэрэглэгчийн ID.';
$string['privacy:metadata:forum_subscriptions'] = 'Хэрэглэгч ямар хэлэлцүүлэгт нэгдсэн тухай мэдээлэл.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Нэгдсэн хэлэлцүүлэг.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Энэ хэлэлцүүлгийн захиалгатай хамааралтай хэрэглэгчийн ID.';
$string['privacy:metadata:forum_track_prefs'] = 'Хэрэглэгч ямар хэлэлцүүлгийн нийтлэлийг уншсаныг хянахаар сонгосон тухай мэдээлэл.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Уншсаныг хянахаар идэвхжүүлсэн хэлэлцүүлэг.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Энэ хэлэлцүүлгийг хянах сонголттой хамааралтай хэрэглэгчийн ID.';
$string['privacy:metadata:preference:autosubscribe'] = 'Мэтгэлцээн доторх нийтлэлд хариу бичихдээ тухайн мэтгэлцээнд нэгдэх эсэх.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Мэтгэлцээний жагсаалтыг эрэмбэлэх дараалал';
$string['privacy:metadata:preference:maildigest'] = 'Веб сайтын хэмжээнд тойм мэдээний сонголт';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Хэлэлцүүлгийн нийтлэлийг зурвасаар хүлээн авахдаа уншсан гэж тэмдэглэх эсэх.';
$string['privacy:metadata:preference:trackforums'] = 'Уншсаныг хянахыг идэвхжүүлэх эсэх.';
$string['privacy:postwasread'] = 'Энэ нийтлэлийг хамгийн анх {$a->firstread}-нд хамгийн сүүлд {$a->lastread}-нд уншсан байна.';
$string['privacy:readtrackingdisabled'] = 'Та энэ хэлэлцүүлэг дэх нийтлэлийг уншсаныг хянахгүй гэж сонгосон.';
$string['privacy:request:delete:discussion:name'] = 'Зохиогчийн хүсэлтээр устгах';
$string['privacy:request:delete:post:message'] = 'Энэ нийтлэлийн агуулгыг зохиогчийн хүсэлтээр устгасан байна.';
$string['privacy:request:delete:post:subject'] = 'Зохиогчийн хүсэлтээр устгах';
$string['privacy:subscribedtoforum'] = 'Та энэ хэлэлцүүлэгт нэгдсэн байна.';
$string['privatereply'] = 'Хувийн байдлаар хариулах';
$string['privatereply_help'] = 'Хувийн байдлаар хариулах үед таны нийтлэл багш зэрэг хувийн хариултыг харах чадвартай хэрэглэгчдэд мөн харагдана.';
$string['processingdigest'] = '{$a} хэрэглэгчийн тойм мэдээний цахим шууданг боловсруулж байна';
$string['processingpost'] = '{$a} нийтлэлийг боловсруулж байна';
$string['prune'] = 'Хуваах';
$string['prunediscussion'] = 'Мэтгэлцээнийг хуваах';
$string['prunedpost'] = 'Энэ нийтлэлээс шинэ мэтгэлцээн үүсгэсэн';
$string['pruneheading'] = 'Мэтгэлцээнийг хувааж энэ нийтлэлийг шинэ мэтгэлцээн рүү зөөх';
$string['qandaforum'] = 'Q(Асуулт) ба A(Хариулт) хэлэлцүүлэг';
$string['qandanotify'] = 'Энэ бол асуулт, хариултын хэлэлцүүлэг. Бусдын хариуг харахын тулд та эхлээд өөрийн хариуг нийтлэх ёстой';
$string['re'] = 'Хариу:';
$string['readtherest'] = 'Энэ сэдвийн үлдсэн хэсгийг унших';
$string['removeallforumtags'] = 'Хэлэлцүүлгийн бүх тагийг хасах';
$string['removefromfavourites'] = 'Мэтгэцээний од тэмдэглэгээг авах';
$string['replies'] = 'Хариултууд';
$string['repliesmany'] = 'Одоогоор {$a} хариу ирсэн';
$string['repliesone'] = 'Одоогоор {$a} хариу ирсэн';
$string['reply'] = 'Хариу';
$string['reply_handler'] = 'Хэлэлцүүлгийн нийтлэлд цахим шуудангаар хариулах';
$string['reply_handler_name'] = 'Хэлэлцүүлгийн нийтлэлд хариу бичих';
$string['replyauthorself'] = '{$a} (та)';
$string['replyforum'] = 'Хэлэлцүүлэгт хариу илгээх';
$string['replyingtoauthor'] = '{$a}-д хариулж байна...';
$string['replyplaceholder'] = 'Хариултаа бичнэ үү...';
$string['replypostdiscussion'] = 'Мэтгэлцээнд хариу бичих';
$string['replytopostbyemail'] = 'Та энэ нийтлэлд цахим шуудангаар хариулах боломжтой.';
$string['replytouser'] = 'Цахим шуудангийн хаяг ашиглан хариулах';
$string['resetdigests'] = 'Бүх Нэг-хэрэглэгчийн хэлэлцүүлгийн тойм мэдээний сонголтыг устгах';
$string['resetforums'] = '... хэлэлцүүлгээс нийтлэл утсгах:';
$string['resetforumsall'] = 'Бүх нийтлэлийг устгах';
$string['resetsubscriptions'] = 'Хэлэлцүүлгийн бүх захиалгыг утсгах';
$string['resettrackprefs'] = 'Хэлэлцүүлгийн бүх хянах тохиргоог утсгах';
$string['rssarticles'] = 'Сүүлд оруулсан RSS нийтлэлийн тоо';
$string['rssarticles_help'] = 'Энэ тохиргоо нь RSS мэдэгдэлд оруулах нийтлэлийн (мэтгэлцээн эсвэл нийтлэл) тоог зааж өгдөг. Ерөнхийдөө 5-аас 20-ийн хооронд байна.';
$string['rsssubscriberssdiscussions'] = 'Мэтгэлцээний RSS мэдэгдэл';
$string['rsssubscriberssposts'] = 'Нийтлэлийн RSS мэдэгдэл';
$string['rsstype'] = 'Энэ үйл ажиллагааны RSS мэдэгдэл';
$string['rsstype_help'] = 'Энэ үйл ажиллагааны RSS мэдэгдлийг идэвхжүүлэхдээ мэдэгдэлд мэтгэлцээн эсвэл нийтлэлийн алийг нь багтаахаа сонгоно уу.';
$string['rsstypedefault'] = 'RSS мэдэгдлийн төрөл';
$string['search'] = 'Хайх';
$string['search:activity'] = 'Хэлэлцүүлэг - үйл ажиллагааны мэдээлэл';
$string['search:post'] = 'Хэлэлцүүлэг - нийтлэлүүд';
$string['searchdatefrom'] = 'Нийтлэлүүд үүнээс шинэ байх ёстой';
$string['searchdateto'] = 'Нийтлэлүүд үүнээс хуучин байх ёстой';
$string['searchforumintro'] = 'Дараах талбаруудын нэг буюу хэд хэдэн хэсэгт хайлтын нэр томьёог оруулна уу:';
$string['searchforums'] = 'Хэлэлцүүлэг хайх';
$string['searchfullwords'] = 'Эдгээр үгс нь бүтэн үг шиг харагдах ёстой';
$string['searchnotwords'] = 'Эдгээр үгийг агуулахгүй';
$string['searcholderposts'] = 'Хуучин нийтлэл хайх...';
$string['searchphrase'] = 'Нийтлэлд яг энэ хэллэг байх ёстой';
$string['searchresults'] = 'Хайлтын үр дүн';
$string['searchsubject'] = 'Эдгээр үг нь сэдэвт байх ёстой';
$string['searchtags'] = 'тагтай байх:';
$string['searchuser'] = 'Энэ нэр зохиогчтой тохирч байх ёстой';
$string['searchuserid'] = 'Зохиогчийн Moodle системийн ID';
$string['searchusers'] = 'Хэрэглэгч хайх';
$string['searchwhichforums'] = 'Аль хэлэлцүүлгээс хайхаа сонгоно уу';
$string['searchwords'] = 'Эдгээр үг нийтлэлийн аль ч хэсэгт байж болно.';
$string['seeallposts'] = 'Энэ хэрэглэгчийн бичсэн бүх нийтлэлийг харах';
$string['sendstudentnotificationsdefault'] = '"Суралцагчид мэдэгдэх" өгөгдмөл тохиргоо';
$string['sendstudentnotificationsdefault_help'] = 'Үнэлгээний маягт дээрх "Суралцагчид мэдэгдэх" чагтан нүдний өгөгдмөл утгыг тохируулна уу.';
$string['sendstudentnotificationsno'] = 'Үгүй';
$string['sendstudentnotificationsyes'] = 'Тийм, суралцагчид мэдэгдэл илгээнэ';
$string['settings'] = 'Тохиргоо';
$string['shortpost'] = 'Богино нийтлэл';
$string['showgraderpanel'] = 'Дүгнэх самбарыг харуулах';
$string['showingcountoftotaldiscussions'] = 'Мэтгэлцээний жагсаалт. Нийт  {$a->total} мэтгэлцээнээс {$a->count}-ийг харуулав';
$string['showmoreusers'] = 'Илүү олон хэрэглэгчийг харуулах';
$string['showpreviousrepliescount'] = 'Өмнөх хариултуудыг харуулах ({$a})';
$string['showsubscribers'] = 'Одоо байгаа захиалагчдыг харуулах/засварлах';
$string['showusersearch'] = 'Хэрэглэгчийн хайлтыг харуулах';
$string['singleforum'] = 'Энгийн нэг мэтгэлцээн';
$string['smallmessage'] = '{$a->user} {$a->forumname} - нд нийтлэл бичсэн';
$string['smallmessagedigest'] = 'Хэлэлцүүлгийн тойм мэдээ нь {$a} зурвас агуулсан';
$string['starredonly'] = 'Одоор тэмдэглэсэн мэтгэлцээнийг хайх';
$string['startedby'] = '... хэрэглэгч эхлүүлсэн:';
$string['subject'] = 'Сэдэв';
$string['subscribe'] = 'Энэ хэлэлцүүлэгт нэгдэх';
$string['subscribeall'] = 'Энэ хэлэлцүүлэгт бүх хүнийг нэгдүүлэх';
$string['subscribed'] = 'Нэгдсэн';
$string['subscribediscussion'] = 'Энэ мэтгэлцээнд нэгдэх';
$string['subscribeenrolledonly'] = 'Уучлаарай, зөвхөн бүртгүүлсэн хэрэглэгч хэлэлцүүлгийн нийтлэлийн тухай мэдэгдэл авах хүсэлт гаргах боломжтой.';
$string['subscribenone'] = 'Бүх хүнийг энэ хэлэлцүүлгээс гаргах';
$string['subscribers'] = 'Захиалагчид';
$string['subscriberstowithcount'] = '"{$a->name}"-ийн  ({$a->count}) захиалагч';
$string['subscribestart'] = 'Энэ хэлэлцүүлэгт оруулсан шинэ нийтлэлийн талаар надад мэдэгдэл илгээнэ үү';
$string['subscribestop'] = 'Энэ хэлэлцүүлэгт оруулсан шинэ нийтлэлийн талаар надад мэдэгдэх хэрэггүй';
$string['subscription'] = 'Захиалга';
$string['subscription_help'] = 'Хэрэв та хэлэлцүүлэгт нэгдсэн (захиалагч болсон) бол хэлэлцүүлгийн шинэ нийтлэлийн талаар мэдэгдэл хүлээн авна гэсэн үг юм. Ихэнхдээ та нэгдэх эсэхээ өөрөө сонгох боломжтой ч заримдаа албадан нэгдүүлдэг тул хүн бүр мэдэгдэл хүлээн авдаг.';
$string['subscriptionandtracking'] = 'Захиалга болон хянах';
$string['subscriptionauto'] = 'Автоматаар нэгдэх';
$string['subscriptiondisabled'] = 'Нэгдэх боломжгүй';
$string['subscriptionforced'] = 'Албадан нэгдүүлэх';
$string['subscriptionmode'] = 'Нэгдэх горим';
$string['subscriptionmode_help'] = 'Оролцогч хэлэлцүүлэгт нэгдсэн (захиалагч болсон) тохиолдолд хэлэлцүүлгийн нийтлэлийн мэдэгдлийг хүлээн авна гэсэн үг юм. Нэгдэх горимын 4 сонголт байдаг:

* Сайн дураар нэгдэх - Оролцогчид нэгдэх эсэхээ сонгох боломжтой
* Албадан нэгдүүлэх- Хүн бүр нэгдэх бөгөөд гарах боломжгүй
* Автоматаар нэгдэх- Хүн бүрийг анх шууд нэгдүүлэх бөгөөд хэрэглэгч хүссэн үедээ гарах боломжтой
* Нэгдэх боломжгүй - Нэгдэхийг зөвшөөрөхгүй';
$string['subscriptionmodeconfirm'] = 'Та нэгдэх горимыг {$a} горимоор солихыг хүсэж байна уу?';
$string['subscriptionoptional'] = 'Сайн дураар нэгдэх';
$string['subscriptions'] = 'Захиалагчид';
$string['tagarea_forum_posts'] = 'Хэлэлцүүлгийн нийтлэлүүд';
$string['tagsdeleted'] = 'Хэлэлцүүлгийн тагуудыг устгасан';
$string['thisforumhasduedate'] = 'Энэ хэлэлцүүлэгт нийтлэл оруулах товлосон хугацаа нь {$a}.';
$string['thisforumisdue'] = 'Энэ хэлэлцүүлэгт нийтлэл оруулах товлосон хугацаа нь {$a} байсан.';
$string['thisforumisthrottled'] = 'Энэ хэлэлцүүлэг нь заагдсан хугацаанд нийтэлж болох хэлэлцүүлгийн нийтлэлийн хязгаартай байна. Одоогоор {$a->blockperiod} хугацаанд {$a->blockafter} бичлэг байна.';
$string['timed'] = 'Хугацаатай';
$string['timeddiscussion'] = 'Хугацаатай мэтгэлцээн';
$string['timedhidden'] = 'Хугацаатай төлөв: Суралцагчаас нуух';
$string['timedposts'] = 'Хугацаатай нийтлэлүүд';
$string['timedvisible'] = 'Хугацаатай төлөв: Бүх хэрэглэгчдэд харагдах';
$string['timestartenderror'] = 'Харуулах дуусах хугацаа нь эхлэх хугацаанаас өмнө байж болохгүй';
$string['togglediscussionmenu'] = 'Мэтгэлцээний цэсийг сэлгэх';
$string['togglefullscreen'] = 'Бүтэн дэлгэцийг сэлгэх';
$string['togglesettingsdrawer'] = 'Тохиргоо агуулагчийг сэлгэх';
$string['trackforum'] = 'Уншаагүй зурвасуудыг хянах';
$string['tracking'] = 'Хянах';
$string['trackingoff'] = 'Хаах';
$string['trackingon'] = 'Албадсан';
$string['trackingoptional'] = 'Сонголттой';
$string['trackingtype'] = 'Уншсаныг хянах';
$string['trackingtype_help'] = 'Уншсаныг хянах нь оролцогчдод шинэ нийтлэлийг тодруулж харуулан, шалгах боломжийг олгодог.

Хэрэв та сонголттой гэж тохируулсан бол оролцогчид хэлэлцүүлгийн хяналтыг асаах эсвэл унтраах эсэхээ сонгох боломжтой. (Хэрэглэгчид мөн хэлэлцүүлгийн тохиргоондоо хэлэлцүүлгийн хяналтыг идэвхжүүлэх ёстой.)

Хэрэв администратор "Уншсаныг хянахыг албадан зөвшөөрөх"-ийг идэвхжүүлсэн бол албадсан сонголтыг цаашид ашиглах боломжтой. Энэ нь хэрэглэгчийн хэлэлцүүлгийн тохиргооноос үл хамааран хянах нь үргэлж идэвхтэй болдог гэсэн үг юм.';
$string['trackreadposts_header'] = 'Хэлэлцүүлгийг хянаж байна';
$string['unlockdiscussion'] = 'Энэ мэтгэлцээний түгжээг тайлах';
$string['unpindiscussion'] = 'Энэ мэтгэлцээнийг бэхлэхээ болих';
$string['unread'] = 'Уншаагүй';
$string['unreadpost'] = 'Уншаагүй нийтлэл';
$string['unreadposts'] = 'Уншаагүй нийтлэлүүд';
$string['unreadpostsnumber'] = '{$a} уншаагүй нийтлэл';
$string['unreadpostsone'] = '1 уншаагүй нийтлэл';
$string['unsubscribe'] = 'Хэлэлцүүлгээс гарах';
$string['unsubscribeall'] = 'Бүх хэлэлцүүлгээс гарах';
$string['unsubscribeallconfirm'] = 'Та {$a->forums} хэлэлцүүлэг болон {$a->discussions} мэтгэлцээнд нэгдсэн байна. Та бүх хэлэлцүүлэг, мэтгэлцээнээс гарч (захиалгаа цуцлах), мэтгэлцээний автоматаар нэгдэх сонголтыг идэвхгүй болгохдоо итгэлтэй байна уу?';
$string['unsubscribeallconfirmdiscussions'] = 'Та {$a->discussions} мэтгэлцээнд нэгдсэн байна. Та бүх мэтгэлцээнээс гарч (захиалгаа цуцлах), мэтгэлцээний автоматаар нэгдэх сонголтыг идэвхгүй болгохдоо итгэлтэй байна уу?';
$string['unsubscribeallconfirmforums'] = 'Та {$a->forums} хэлэлцүүлэгт нэгдсэн байна. Та бүх хэлэлцүүлгээс гарч (захиалгаа цуцлах) мэтгэлцээний автоматаар нэгдэх сонголтыг идэвхгүй болгохдоо итгэлтэй байна уу?';
$string['unsubscribealldone'] = 'Бүх сонголттой хэлэлцүүлгийн захиалгыг устгасан. Та албадан нэгдүүлсэн хэлэлцүүлгээс мэдэгдэл хүлээн авсан хэвээр байх болно. Хэлэлцүүлгийн мэдэгдлийг удирдахын тулд Миний хувийн мэдээллийн тохиргоонд байх Зурвас илгээх хэрэг рүү очно уу.';
$string['unsubscribeallempty'] = 'Та ямар ч хэлэлцүүлэгт нэгдээгүй байна. Энэ серверийн бүх мэдэгдлийг идэвхгүй болгохын тулд Миний хувийн мэдээллийн тохиргооны "Мессеж" рүү очно уу.';
$string['unsubscribed'] = 'Гарсан (Захиалгыг цуцалсан)';
$string['unsubscribediscussion'] = 'Энэ мэтгэлцээнээс гарах';
$string['unsubscribediscussionlink'] = 'Энэ мэтгэлцээнээс гарах: {$a}';
$string['unsubscribelink'] = 'Энэ хэлэлцүүлгээс гарах: {$a}';
$string['unsubscribeshort'] = 'Гарах (Захиалгыг цуцлах)';
$string['useexperimentalui'] = 'Нэг нэгдээ багтсан мэтгэлцээний харагдах хэлбэрийг ашиглах';
$string['usermarksread'] = 'Зурвас уншсан тэмдэглэгээг гараар хийх';
$string['usernavigation'] = 'Хэрэглэгчийн удирдлагын мөр';
$string['usersforumposts'] = 'Хэрэглэгчийн хэлэлцүүлгийн нийтлэл';
$string['viewalldiscussions'] = 'Бүх мэтгэлцээнийг харах';
$string['viewconversation'] = 'Мэтгэлцээнийг харах';
$string['viewgrades'] = 'Дүнг харах';
$string['viewparentpost'] = 'Эх үүсвэр нийтлэлийг харах';
$string['viewthediscussion'] = 'Мэтгэлцээнийг харах';
$string['warnafter'] = 'Нийтлэлийн дээд хязгаар дөхөж буй анхааруулга';
$string['warnafter_help'] = 'Суралцагчид тухайн хугацаанд зөвшөөрөгдсөн нийтлэлийн дээд хязгаарт ойртоход анхааруулж болно. Энэ тохиргоо нь хэдэн нийтлэлийн дараа анхааруулахыг зааж өгдөг. Mod/forum:postwithrottling чадвартай хэрэглэгчид нийтлэлийн хязгаарлалт нөлөөлөхгүй.';
$string['warnformorepost'] = 'Анхааруулга! Энэ хэлэлцүүлэгт нэгээс илүү мэтгэлцээн байна - хамгийн сүүлийн үеийн хэрэглээ';
$string['yournewquestion'] = 'Таны шинэ асуулт';
$string['yournewtopic'] = 'Таны мэтгэлцээний шинэ сэдэв';
$string['yourreply'] = 'Таны хариу';
