<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'mn', version '4.3'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Идэвхжүүлэлт';
$string['activityloading'] = 'Та дараах үйл ажиллагаа руу автоматаар шилжих болно:';
$string['activityoverview'] = 'Танд анхаарал хандуулах шаардлагатай SCORM багцууд байна';
$string['activitypleasewait'] = 'Үйл ажиллагааг ачаалж байна, түр хүлээнэ үү...';
$string['adminsettings'] = 'Администратор тохиргоо';
$string['advanced'] = 'Параметрүүд';
$string['aicchacpkeepsessiondata'] = 'AICC HACP уулзалтын өгөгдөл';
$string['aicchacpkeepsessiondata_desc'] = 'Гадаад AICC HACP уулзалтын өгөгдлийг хадгалах хугацаа (уртаар тохируулахад хүснэгтийг хуучин өгөгдлөөр дүүргэх боловч алдааг шалгахад тустай)';
$string['aicchacptimeout'] = 'AICC HACP хугацаа хэтэрсэн';
$string['aicchacptimeout_desc'] = 'Гадаад AICC HACP уулзалт нээлттэй хэвээр байх хугацааг минутаар илэрхийлнэ';
$string['aiccuserid'] = 'AICC нь хэрэглэгчийн id дугаарыг дамжуулах';
$string['aiccuserid_desc'] = 'AICC стандарт нь Moodle-тэй харьцуулахад маш хязгаарлагдмал бөгөөд хэрэглэгчийн нэрд зөвхөн үсэг, цифр, зураас болон доогуур зураасыг ашиглахыг зөвшөөрдөг. Цэг, зай болон @ тэмдгийг зөвшөөрөхгүй. Идэвхжүүлсэн тохиолдолд хэрэглэгчийн нэрийн оронд хэрэглэгчийн ID дугаарыг AICC багц руу дамжуулна.';
$string['aliasonly'] = 'Сангаас imsmanifest.xml файлыг сонгохдоо энэ файлын нэр/товчлолыг ашиглах ёстой.';
$string['allowapidebug'] = 'API алдааг шалгах болон мөшгөхийг идэвхжүүлэх';
$string['allowtypeaicchacp'] = 'Гадаад AICC HACP идэвхжүүлэх';
$string['allowtypeaicchacp_desc'] = 'Идэвхжүүлсэн тохиолдолд гадаад AICC багцаас илгээх хүсэлтэд хэрэглэгч нэвтрэх шаардлагагүйгээр AICC HACP гадаад харилцааг зөвшөөрөх болно.';
$string['allowtypeexternal'] = 'Гадаад багцын төрлийг идэвхжүүлэх';
$string['allowtypeexternalaicc'] = 'Шууд AICC URL идэвхжүүлэх';
$string['allowtypeexternalaicc_desc'] = 'Идэвхжүүлсэн тохиолдолд энгийн AICC багц руу шууд url оруулахыг зөвшөөрдөг';
$string['allowtypelocalsync'] = 'Татсан багцын төрлийг идэвхжүүлэх';
$string['apidebugmask'] = 'API алдааг шалгах маск - &lt;username&gt;:&lt;activityname&gt; дээр энгийн regex ашиглана уу. Жишээлбэл admin:.* нь зөвхөн админ хэрэглэгчийн алдааг шалгана';
$string['areacontent'] = 'Агуулгын файлууд';
$string['areapackage'] = 'Багцын файлууд';
$string['asset'] = 'Хөрөнгө';
$string['assetlaunched'] = 'Хөрөнгө - Үзсэн';
$string['attempt'] = 'Оролдлого';
$string['attempt1'] = '1 оролдлого';
$string['attempts'] = 'Оролдлогууд';
$string['attemptsmanagement'] = 'Оролдлогын удирдлага';
$string['attemptstatusall'] = 'Удирдах самбар болон нүүр хуудас';
$string['attemptstatusentry'] = 'Зөвхөн нүүр хуудас';
$string['attemptstatusmy'] = 'Зөвхөн удирдах самбар';
$string['attemptsx'] = '{$a} оролдлого';
$string['attr_error'] = '{$a->tag} таг дахь шинжийн ({$a->attr}) буруу утга.';
$string['autocommit'] = 'Автоматаар хадгалах';
$string['autocommit_help'] = 'Идэвхжүүлбэл SCORM өгөгдөл автоматаар мэдээллийн санд хадгалагдана. Өгөгдлөө байнга хадгалдаггүй SCORM судлагдахуунуудад хэрэгтэй.';
$string['autocommitdesc'] = 'Хэрэв SCORM багц үүнийг хадгалахгүй бол SCORM өгөгдлийг автоматаар хадгална.';
$string['autocontinue'] = 'Автоматаар үргэлжлүүлэх';
$string['autocontinue_help'] = 'Хэрэв идэвхжүүлбэл дараагийн сургалтын судлагдахуунууд автоматаар нээгдэх бөгөөд бусад тохиолдолд Үргэлжлүүлэх товчийг ашиглах шаардлагатай.';
$string['autocontinuedesc'] = 'Хэрэв идэвхжүүлбэл дараагийн сургалтын судлагдахуунууд автоматаар нээгдэх бөгөөд бусад тохиолдолд Үргэлжлүүлэх товчийг ашиглах шаардлагатай.';
$string['averageattempt'] = 'Дундаж оролдлого';
$string['badarchive'] = 'Та хүчинтэй шахсан файл оруулах ёстой';
$string['badimsmanifestlocation'] = 'imsmanifest.xml файл олдсон боловч энэ нь таны шахсан файлын үндсэн хэсэгт байгаагүй тул SCORM-оо дахин багцална уу.';
$string['badmanifest'] = 'Зарим алдаа илэрлээ: Алдааны бүртгэлийг харна уу';
$string['browse'] = 'Урьдчилан харах';
$string['browsed'] = 'Гvйлгэн харах';
$string['browsemode'] = 'Урьдчилах харах горим';
$string['browserepository'] = 'Санг гүйлгэн харах';
$string['calculatedweight'] = 'Тооцоолсон жин';
$string['calendarend'] = '{$a} хаах';
$string['calendarstart'] = '{$a} нээх';
$string['cannotaccess'] = 'Та энэ скриптийг ингэж дуудах боломжгүй';
$string['cannotfindsco'] = 'SCO олдсонгүй';
$string['chooseapacket'] = 'Багцыг сонгох эсвэл шинэчилнэ үү';
$string['closebeforeopen'] = 'Та хаах огноог нээх огнооноос өмнө тодорхойлсон байна.';
$string['collapsetocwinsize'] = 'Цонхны хэмжээ дараахаас бага байх үед TOC-ийг хураах:';
$string['collapsetocwinsizedesc'] = 'Энэ тохиргоо нь TOC-ийг автоматаар хураах цонхны хэмжээг зааж өгөх боломжийг олгоно.';
$string['compatibilitysettings'] = 'Тохиромжтой байдлын тохиргоо';
$string['completed'] = 'Дууссан';
$string['completiondetail:allscos'] = 'Энэ үйл ажиллагааны бүх хэсгийг гүйцэтгэх';
$string['completiondetail:completionscore'] = '{$a} буюу түүнээс дээш оноо авах';
$string['completiondetail:completionstatuscompleted'] = 'Үйл ажиллагааг дуусгах';
$string['completiondetail:completionstatuscompletedorpassed'] = 'Үйл ажиллагааг дуусгасан эсвэл тэнцсэн';
$string['completiondetail:completionstatuspassed'] = 'Үйл ажиллагаанд тэнцсэн';
$string['completionscorerequired'] = 'Шаардлагатай хамгийн бага оноо';
$string['completionscorerequired_help'] = 'Энэ тохиргоог идэвхжүүлснээр хэрэглэгчээс энэ SCORM үйл ажиллагааг дуусгасан гэж тэмдэглэхийн тулд дор хаяж хамгийн бага оноог шаардах ба, мөн түүнчлэн Үйл ажиллагааг Дуусгах бусад шаардлагуудыг хангахыг шаардана.';
$string['completionscorerequireddesc'] = 'Дуусгахад хамгийн багадаа {$a} оноо шаардлагатай';
$string['completionstatus_completed'] = 'Дууссан';
$string['completionstatus_passed'] = 'Баталсан';
$string['completionstatusallscos'] = 'Дууссан төлөвийг буцаахын тулд бүх scos-ыг шаардах';
$string['completionstatusallscos_help'] = 'Зарим SCORM багцууд нь олон бүрэлдэхүүн хэсэг буюу "scos"-ыг агуулдаг - үүнийг идэвхжүүлсэн үед багц доторх бүх scos нь энэ үйл ажиллагааг дууссан гэж тэмдэглэхийн тулд холбогдох lesson_status-ыг буцаана.';
$string['completionstatusrequired'] = 'Төлөв шаардах';
$string['completionstatusrequired_help'] = 'Нэг буюу хэд хэдэн төлөвийг сонгож тэмдэглэснээр хэрэглэгч энэ SCORM үйл ажиллагааг дууссан гэж тэмдэглэхийн тулд шалгасан төлөвөөс аль нэгийг нь гүйцэтгэх, мөн Үйл ажиллагааг дуусгахад шаардагдах бусад шаардлагыг хангах хэрэгтэй болно.';
$string['completionstatusrequireddesc'] = 'Суралцагч дараах төлөвүүдээс дор хаяж нэг төлөвтэй байх ёстой: {$a}';
$string['confirmloosetracks'] = 'АНХААРУУЛГА: Багцыг сольсон эсвэл өөрчилсөн бололтой. Хэрэв багцын бүтэц өөрчлөгдсөн бол шинэчлэлтийн явцад зарим хэрэглэгчийн ул мөр алдагдаж болзошгүй.';
$string['contents'] = 'Агуулга';
$string['coursepacket'] = 'Хичээлийн багц';
$string['coursestruct'] = 'Хичээлийн бүтэц';
$string['crontask'] = 'SCORM-д зориулсан арын боловсруулалт';
$string['currentwindow'] = 'Одоогийн цонх';
$string['datadir'] = 'Файл системийн алдаа: Хичээлийн өгөгдлийн лавлахыг үүсгэж чадахгvй байна.';
$string['defaultdisplaysettings'] = 'Өгөгдмөл дэлгэцлэх тохиргоо';
$string['defaultgradesettings'] = 'Өгөгдмөл үнэлгээний тохиргоо';
$string['defaultothersettings'] = 'Бусад өгөгдмөл тохиргоо';
$string['deleteallattempts'] = 'Бүх SCORM оролдлогыг устгах';
$string['deleteattemptcheck'] = 'Та эдгээр оролдлогыг бүрмөсөн устгахдаа итгэлтэй байна уу?';
$string['deleteselected'] = 'Сонгогдсон оролдлогуудыг устгах';
$string['deleteuserattemptcheck'] = 'Та эдгээр оролдлогыг бүрмөсөн устгахдаа итгэлтэй байна уу?';
$string['details'] = 'Ул мөрийн дэлгэрэнгүй';
$string['directories'] = 'Лавлах холбооснуудыг харуулах';
$string['disabled'] = 'Идэвхгүй болгох';
$string['display'] = 'Багцыг харуулах';
$string['displayactivityname'] = 'Үйл ажиллагааны нэрийг харуулах';
$string['displayactivityname_help'] = 'Өмнөх SCORM тоглуулагчийн үйл ажиллагааны нэрийг харуулах эсэх.';
$string['displayattemptstatus'] = 'Оролдлогын төлөвийг харуулах';
$string['displayattemptstatus_help'] = 'Энэ сонголт нь хэрэглэгчдийн оролдлогын хураангуйг удирдлагын самбар болон/эсвэл SCORM нүүр хуудасны хичээлийн тойм блокт харуулахыг зөвшөөрдөг.';
$string['displayattemptstatusdesc'] = 'Хэрэглэгчийн оролдлогын хураангуйг удирдлагын самбар болон/эсвэл SCORM нүүр хуудсан дээрх хичээлийн тойм блокт харуулсан эсэх.';
$string['displaycoursestructure'] = 'Нүүр хуудсанд хичээлийн бүтцийг харуулах';
$string['displaycoursestructure_help'] = 'Идэвхжүүлсэн тохиолдолд агуулгын хүснэгтийг SCORM тойм хуудсан дээр харуулна.';
$string['displaycoursestructuredesc'] = 'Идэвхжүүлсэн тохиолдолд агуулгын хүснэгтийг SCORM тойм хуудсан дээр харуулна.';
$string['displaydesc'] = 'SCORM багцыг шинэ цонхонд харуулах эсэх.';
$string['displaysettings'] = 'Харуулах тохиргоо';
$string['dnduploadscorm'] = 'SCORM багц нэмэх';
$string['domxml'] = 'DOMXML гадаад сан';
$string['element'] = 'Элемент';
$string['enter'] = 'Оруулах';
$string['entercourse'] = 'Хичээл оруулах';
$string['errorlogs'] = 'Алдааны бүртгэл';
$string['eventattemptdeleted'] = 'Оролдлогыг устгасан';
$string['eventinteractionsviewed'] = 'Харилцан үйлчлэлийг үзсэн';
$string['eventreportviewed'] = 'Тайланг үзсэн';
$string['eventscolaunched'] = 'Sco нээгдсэн';
$string['eventscorerawsubmitted'] = 'SCORM боловсруулаагүй оноог илгээсэн';
$string['eventstatussubmitted'] = 'SCORM төлөвийг илгээсэн';
$string['eventtracksviewed'] = 'Ул мөрийг үзсэн';
$string['eventuserreportviewed'] = 'Хэрэглэгчийн тайлан үзсэн';
$string['everyday'] = 'Өдөр бүр';
$string['everytime'] = 'Хэрэглэх бүрт';
$string['exceededmaxattempts'] = 'Та оролдлого хийх дээд хязгаарт хүрсэн байна.';
$string['exit'] = 'Хичээлээс гарах';
$string['exitactivity'] = 'Үйл ажиллагаанаас гарах';
$string['expired'] = 'Уучлаарай, энэ үйл ажиллагаа  {$a} -нд хаагдсан бөгөөд цаашид боломжгүй.';
$string['external'] = 'Гадаад багцын цагийг шинэчлэх';
$string['failed'] = 'Амжилтгүй';
$string['finishscorm'] = 'Хэрэв та энэ нөөцийг үзэж дууссан бол, {$a}';
$string['finishscormlinkname'] = 'энд дарж хичээлийн хуудас руу буцна';
$string['firstaccess'] = 'Анхны хандалт';
$string['firstattempt'] = 'Анхны оролдлого';
$string['floating'] = 'Чөлөөтэй';
$string['forceattemptalways'] = 'Үргэлж';
$string['forceattemptoncomplete'] = 'Өмнөх оролдлого дууссан, тэнцсэн эсвэл амжилтгүй үед';
$string['forcecompleted'] = 'Хүчээр дуусгасан';
$string['forcecompleted_help'] = 'Идэвхжүүлсэн тохиолдолд одоогийн оролдлогыг хүчээр "дууссан" төлөвтэй болгоно. (Зөвхөн SCORM 1.2 багцад боломжтой)';
$string['forcecompleteddesc'] = 'Энэ сонголт нь хүчээр дуусгах тохиргооны өгөгдмөл утгыг тохируулна';
$string['forcejavascript'] = 'Хэрэглэгчдийг JavaScript-г идэвхжүүлэхийг албадах';
$string['forcejavascript_desc'] = 'Идэвхжүүлсэн тохиолдолд (үүнийг санал болгодог) энэ нь хэрэглэгчийн хөтөч дээр JavaScript дэмжигдээгүй/идэвхжээгүй үед SCORM судлагдахуун руу нэвтрэхээс сэргийлнэ. Идэвхгүй болговол хэрэглэгч SCORM-г үзэж болох боловч API холболт амжилтгүй болж, дүнгийн мэдээллийг хадгалахгүй.';
$string['forcejavascriptmessage'] = 'Энэ судлагдахууныг үзэхэд JavaScript шаардлагатай учир хөтөч дээрээ JavaScript-ийг идэвхжүүлээд дахин оролдоно уу.';
$string['forcenewattempts'] = 'Шинэ оролдлого хийх';
$string['forcenewattempts_help'] = 'Гурван сонголт байна:

* Үгүй - Хэрэв өмнөх оролдлого нь дууссан, тэнцсэн эсвэл амжилтгүй тохиолдолд суралцагчийг хянан горимд оруулах эсвэл шинэ оролдлого эхлүүлэх сонголтоор хангана.
* Өмнөх оролдлого дууссан, тэнцсэн эсвэл амжилтгүй үед - Энэ нь SCORM багцаас "дууссан", "тэнцсэн" эсвэл "амжилтгүй" гэсэн төлөвийг тохируулдаг.
* Үргэлж - SCORM үйл ажиллагаанд дахин орох бүрт шинэ оролдлого үүсэх бөгөөд суралцагч өмнөх оролдлого хийсэн цэг рүү буцахгүй.';
$string['found'] = 'Тунхаг олдсон';
$string['frameheight'] = 'Цонх эсвэл фреймын өндөр';
$string['framewidth'] = 'Цонх эсвэл фреймын өргөн';
$string['fromleft'] = 'Зүүн талаас';
$string['fromtop'] = 'Дээд талаас';
$string['fullscreen'] = 'Дэлгэцийг дүүргэж харуулах';
$string['general'] = 'Ерөнхий өгөгдөл';
$string['gradeaverage'] = 'Дундаж дүн';
$string['gradeforattempt'] = 'Оролдлогын дүн';
$string['gradehighest'] = 'Хамгийн өндөр дvн';
$string['grademethod'] = 'Дүгнэх арга';
$string['grademethod_help'] = 'Дүгнэх арга нь тухайн үйл ажиллагааны нэг удаагийн оролдлогыг хэрхэн дүгнэхийг тодорхойлдог.

Дүгнэх дөрвөн арга байдаг:

* Сурах объектууд - Дуусгасан/тэнцсэн сургалтын объектын тоо
* Хамгийн өндөр дүн- Бүх тэнцсэн сургалтын объектуудад авсан хамгийн өндөр оноо
* Дундаж дүн- Бүх онооны дундаж
* Нийлбэр дүн - Бүх онооны нийлбэр';
$string['grademethoddesc'] = 'Дүгнэх арга нь тухайн үйл ажиллагааны нэг удаагийн оролдлогын дүнг хэрхэн тооцоолохыг тодорхойлдог.';
$string['gradereported'] = 'Тайлагнасан дүн';
$string['gradescoes'] = 'Сургалтын судлагдахуунууд';
$string['gradesettings'] = 'Дүгнэх тохиргоо';
$string['gradesum'] = 'Нийлбэр дүн';
$string['height'] = 'Өндөр';
$string['hidden'] = 'Нуусан';
$string['hidebrowse'] = 'Урьдчилан харах горимыг хүчингүй болгох';
$string['hidebrowse_help'] = 'Урьдчилан харах горим нь суралцагч оролдлого хийхээсээ өмнө үйл ажиллагааг гүйлгэн харах боломж олгодог. Урьдчилан харах горимыг идэвхгүй болговол урьдчилан харах товчийг нуух болно.';
$string['hidebrowsedesc'] = 'Урьдчилан харах горим нь суралцагч оролдлого хийхээсээ өмнө үйл ажиллагааг гүйлгэн харах боломж олгодог.';
$string['hideexit'] = 'Гарах холбоосыг нуух';
$string['hidereview'] = 'Урьдчилан харах товчийг нуух';
$string['hidetoc'] = 'Тоглуулагч дээр хичээлийн бүтцийг харуулах';
$string['hidetoc_help'] = 'SCORM тоглуулагч дээр агуулгын хүснэгт хэрхэн харагдах вэ';
$string['hidetocdesc'] = 'Энэ тохиргоо нь SCORM тоглуулагч дээр агуулгын хүснэгт хэрхэн харагдахыг тодорхойлно.';
$string['highestattempt'] = 'Хамгийн олон оролдлого';
$string['identifier'] = 'Асуулт танигч';
$string['incomplete'] = 'Бүрэн бус';
$string['indicator:cognitivedepth'] = 'SCORM-ын танин мэдэхүйн гүн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн SCORM үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд суурилдаг.';
$string['indicator:cognitivedepthdef'] = 'SCORM-ын танин мэдэхүйн гүн';
$string['indicator:cognitivedepthdef_help'] = 'Энэ шинжилгээний интервалын хугацаанд SCORM үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Харагдахгүй, Харах, Илгээх, Хариу харах)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'SCORM-ын нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн SCORM үйл ажиллагаанд хүрсэн нийгмийн хүрээнд суурилдаг.';
$string['indicator:socialbreadthdef'] = 'SCORM-ын нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд SCORM-ийн үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд оролцогчийн хүрсэн хувь(Түвшин = Оролцоогүй, Ганцаар оролцсон)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Мэдээлэл';
$string['interactions'] = 'Харилцан үйлчлэл';
$string['invalidactivity'] = 'SCORM үйл ажиллагаа буруу байна';
$string['invalidhacpsession'] = 'HACP сейшн хүчингүй байна';
$string['invalidmanifestname'] = 'Зөвхөн imsmanifest.xml эсвэл .zip файлуудыг сонгож болно';
$string['invalidmanifestresource'] = 'АНХААРУУЛГА: Таны тунхагт дараах нөөцүүдийг эш татсан боловч олдсонгүй:';
$string['invalidstatus'] = 'Хүчингүй төлөв';
$string['invalidurl'] = 'Хүчингүй URL тодорхойлсон байна';
$string['invalidurlhttpcheck'] = 'Хүчингүй URL тодорхойлсон байна. Алдааны зурвас:<pre>{$a->cmsg}</pre>';
$string['last'] = 'Сүүлд хандсан';
$string['lastaccess'] = 'Сүүлчийн хандалт';
$string['lastattempt'] = 'Сүүлчийн дуусгасан оролдлого';
$string['lastattemptlock'] = 'Эцсийн оролдлогын дараа түгжих';
$string['lastattemptlock_help'] = 'Идэвхжүүлсэн тохиолдолд суралцагч бүх хуваарилагдсан оролдлогоо дуусгасны дараа SCORM тоглуулагчийг ажиллуулахаас сэргийлнэ.';
$string['lastattemptlockdesc'] = 'Идэвхжүүлсэн тохиолдолд суралцагч бүх хуваарилагдсан оролдлогоо дуусгасны дараа SCORM тоглуулагчийг ажиллуулахаас сэргийлнэ.';
$string['location'] = 'Байрлалын мөр харуулах';
$string['masteryoverride'] = 'Чадварын оноо нь төлөвийг хүчингүй болгон';
$string['masteryoverride_help'] = 'Идэвхжүүлсэн бөгөөд чадварын оноо өгсөн бол LMSFinish дуудаж, боловсруулаагүй оноог тохируулсан үед боловсруулаагүй оноо болон чадварын оноог ашиглан төлөвийг дахин тооцоолох ба SCORM-аас өгсөн аливаа төлөвийг ("бүрэн бус" гэх мэт) хүчингүй болгоно.';
$string['masteryoverridedesc'] = 'Энэ сонголт нь тохиргоог хүчингүй болгох өгөгдмөл чадварын оноог тохируулна';
$string['max'] = 'Хамгийн өндөр оноо';
$string['maximumattempts'] = 'Оролдлогын тоо';
$string['maximumattempts_help'] = 'Энэ тохиргоо нь оролдлогын тоог хязгаарлах боломжийг олгодог. Энэ нь зөвхөн SCORM 1.2 болон AICC багцуудад боломжтой.';
$string['maximumattemptsdesc'] = 'Энэ сонголт нь үйл ажиллагааны өгөгдмөл хамгийн их оролдлогыг тохируулдаг';
$string['maximumgradedesc'] = 'Энэ сонголт нь үйл ажиллагааны өгөгдмөл дээд дүнг тогтоодог';
$string['menubar'] = 'Цэсний мөрийг харуулах';
$string['min'] = 'Доод оноо';
$string['missing_attribute'] = '{$a->tag} таг дахь {$a->attr} шинж орхигдсон байна.';
$string['missing_tag'] = '{$a->tag}  таг орхигдсон байна.';
$string['missingparam'] = 'Шаардлагатай параметр орхигдсон эсвэл буруу байна';
$string['mode'] = 'Горим';
$string['modulename'] = 'SCORM багц';
$string['modulename_help'] = 'SCORM багц нь сургалтын судлагдахуунд тохирсон стандартын дагуу багцлагдсан файлуудын цуглуулга юм. SCORM үйл ажиллагааны модуль нь SCORM эсвэл AICC багцуудыг шахсан файл хэлбэрээр байршуулж, хичээлд нэмэх боломжийг олгодог.

Агуулга нь ихэвчлэн хоорондоо шилжих боломжтой хэд хэдэн хуудсан дээр харагдана. Агуулгын хүснэгт, удирдлагын мөр гэх мэтийг агуулсан нэмэлт цонхонд агуулгыг харуулах төрөл бүрийн сонголтууд байдаг. SCORM үйл ажиллагаа нь ихэнхдээ асуултуудыг агуулдаг бөгөөд журналд дүнг тэмдэглэдэг.

SCORM үйл ажиллагааг дараах зорилгоор ашиглаж болно

* Мультимедиа агуулга болон хөдөлгөөнт дүрсийг үзүүлэхэд
* Үнэлгээний хэрэгсэл болгон';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'SCORM багцууд';
$string['myaiccsessions'] = 'Миний AICC уулзалтууд';
$string['myattempts'] = 'Миний оролдлогууд';
$string['nav'] = 'Удирдлагын мөрийг харуулах';
$string['nav_help'] = 'Энэ тохиргоо нь удирдлагын товчлууруудын байрлал болон тэдгээрийн харуулах эсэхийг тодорхойлдог.

3 сонголт байна:

* Үгүй - Удирдлагын товчлууруудыг харуулахгүй
* Агуулгын доор - Удирдлагын товчлууруудыг SCORM багцын агуулгын доор харуулна
* Хөвөгч - Удирдлагын товчлууруудыг багцад тодорхойлсны дагуу дээрээс болон зүүнээс байрлуулан хөвөгч хэлбэрээр харуулна.';
$string['navdesc'] = 'Энэ тохиргоо нь удирдлагын товчлууруудын байрлал болон тэдгээрийн харуулах эсэхийг тодорхойлдог.';
$string['navigation'] = 'Удирдлагын мөр';
$string['navpositionleft'] = 'Удирдлагын товчлуурын байрлалыг зүүнээс цэгээр илэрхийлнэ.';
$string['navpositiontop'] = 'Удирдлагын товчлуурын байрлалыг дээрээс цэгээр илэрхийлнэ.';
$string['networkdropped'] = 'SCORM тоглуулагч таны интернэт холболт найдваргүй эсвэл тасалдсан болохыг тогтоосон. Хэрэв та энэ SCORM үйл ажиллагааг үргэлжлүүлбэл таны үйл явцыг хадгалахгүй байж магадгүй.

Та одоо үйл ажиллагааг орхиж, найдвартай интернэт холболттой болсон үедээ үргэлжлүүлэх хэрэгтэй.';
$string['newattempt'] = 'Шинээр оролдох';
$string['next'] = 'Yргэлжлүүлэх';
$string['no_attributes'] = '{$a->tag} таг нь атрибуттай байх ёстой';
$string['no_children'] = '{$a->tag} таг нь хүүхэдтэй байх ёстой';
$string['noactivity'] = 'Тайлагнах зүйл байхгүй';
$string['noattemptsallowed'] = 'Зөвшөөрсөн оролдлогын тоо';
$string['noattemptsmade'] = 'Таны оролдож үзсэн тоо';
$string['nolimit'] = 'Хязгааргүй оролдлого';
$string['nomanifest'] = 'Буруу файлын багц - imsmanifest.xml эсвэл AICC бүтэц байхгүй байна';
$string['noprerequisites'] = 'Уучлаарай, та энэ үйл ажиллагаанд хандахад шаардлагатай урьдчилсан нөхцөлийг хангаагүй байхгүй.';
$string['noreports'] = 'Харуулах тайлан байхгүй';
$string['normal'] = 'Хэвийн';
$string['noscriptnoscorm'] = 'Таны хөтөч javascript-ийг дэмждэггүй эсвэл javascript-ийг хүчингүй болгосон байна. SCORM багц тоглохгүй эсвэл өгөгдлийг зөвөөр хадгалж чадахгүй байх магадлалтай.';
$string['not_corr_type'] = 'Төрөл нь {$a->tag} тагд тохирохгүй байна';
$string['notattempted'] = 'Оролдоогүй';
$string['notopenyet'] = 'Уучлаарай, энэ үйл ажиллагааг {$a} хүртэл гүйцэтгэх боломжгүй байна.';
$string['objectives'] = 'Зорилго';
$string['openafterclose'] = 'Та нээх огноог хаах огнооноос хойш тодорхойлсон байна';
$string['optallstudents'] = 'бүх хэрэглэгч';
$string['optattemptsonly'] = 'зөвхөн оролдлого хийсэн хэрэглэгч';
$string['options'] = 'Сонголтууд (Зарим хөтчөөс сэргийлсэн)';
$string['optionsadv'] = 'Сонголтууд (Нарийвчилсан)';
$string['optionsadv_desc'] = 'Хэрэв сонгосон бол өргөн ба өндрийг нарийвчилсан тохиргоонд оруулах болно.';
$string['optnoattemptsonly'] = 'зөвхөн оролдлого хийгээгүй хэрэглэгч';
$string['organization'] = 'Зохион байгуулалт';
$string['organizations'] = 'Зохион байгуулалт';
$string['othersettings'] = 'Нэмэлт тохиргоо';
$string['package'] = 'Багцын файл';
$string['package_help'] = 'Багцын файл нь SCORM/AICC хичээлийн тодорхойлолтын файлыг агуулсан шахсан (эсвэл pif) файл байна.';
$string['packagedir'] = 'Файл системийн алдаа: Багцын лавлагааг үүсгэж чадсангүй';
$string['packagefile'] = 'Багцын файлыг заагаагүй байна';
$string['packagehdr'] = 'Багц';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Энэ тохиргоо нь файл сонгогчоор файлыг сонгохын оронд SCORM багцын URL замыг зааж өгөх боломжийг олгодог.';
$string['page-mod-scorm-x'] = 'Дурын SCORM модулийн хуудас';
$string['pagesize'] = 'Хуудасны хэмжээ';
$string['passed'] = 'Тэнцсэн';
$string['php5'] = 'PHP 5 (DOMXML үндсэн сан)';
$string['pluginadministration'] = 'SCORM багцын удирдлага';
$string['pluginname'] = 'SCORM багц';
$string['popup'] = 'Шинэ цонх';
$string['popuplaunched'] = 'Энэхүү SCORM багцыг нэмэлт цонхонд харуулсан. Хэрэв та энэ судлах материалыг үзэж дууссан бол энд дарж хичээлийн хуудас руу буцна уу.';
$string['popupmenu'] = 'Нээгдэх цэсэд';
$string['popupopen'] = 'Багцыг шинэ цонхонд нээх';
$string['popupsblocked'] = 'Энэ SCORM багцыг тоглуулахыг зогсоож, нэмэлт цонхыг хориглосон бололтой. Дахин оролдохын өмнө хөтчийнхөө тохиргоог шалгана уу.';
$string['position_error'] = '{$a->tag} таг нь {$a->parent} тагийн хүүхэд болж чадахгvй';
$string['preferencespage'] = 'Зөвхөн энэ хуудасны тохиргоо';
$string['preferencesuser'] = 'Зөвхөн энэ тайлангийн тохиргоо';
$string['prev'] = 'Өмнөх';
$string['privacy:metadata:aicc:data'] = 'AICC/SCORM дэд системээс дамжуулсан хувийн мэдээлэл.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Энэхүү нэмэлт хэрэгсэл нь AICC HACP ашиглан өгөгдлийг гадагш илгээдэг.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Мөшгөх хичээлийн төлөв';
$string['privacy:metadata:aicc_session:scormmode'] = 'Мөшгөх элементийн горим';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Мөшгөх элементийн төлөв';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Мөшгөх уулзалтын цаг';
$string['privacy:metadata:aicc_session:timecreated'] = 'Мөшгөсөн элементийг үүсгэсэн цаг';
$string['privacy:metadata:attempt'] = 'Оролдлогын тоо';
$string['privacy:metadata:scoes_track:element'] = 'Мөшгөх элементийн нэр';
$string['privacy:metadata:scoes_track:value'] = 'Өгөгдсөн элементийн утга';
$string['privacy:metadata:scorm_aicc_session'] = 'AICC HACP-ийн уулзалтын мэдээлэл';
$string['privacy:metadata:timemodified'] = 'Мөшгөсөн элементийг сүүлд өөрчилсөн цаг';
$string['privacy:metadata:userid'] = 'SCORM үйл ажиллагаанд хандсан хэрэглэгчийн ID';
$string['protectpackagedownloads'] = 'Багцын татан авалтыг хамгаалах';
$string['protectpackagedownloads_desc'] = 'Идэвхжүүлсэн тохиолдолд SCORM багцуудыг зөвхөн тухайн хэрэглэгч course:manageactivities чадвартай бол татаж авах боломжтой. Хэрэв идэвхгүй болговол SCORM багцуудыг үргэлж (гар утас болон бусад хэрэгслээр) татаж авах боломжтой  байна.';
$string['raw'] = 'Боловсруулаагүй оноо';
$string['regular'] = 'Албан ёсны тунхаг';
$string['report'] = 'Тайлан';
$string['reportcountallattempts'] = '{$a->nbattempts} илэрцээс {$a->nbusers} хэрэглэгчдэд зориулсан {$a->nbattempts} оролдлого';
$string['reportcountattempts'] = '{$a->nbresults} илэрц ({$a->nbusers} хэрэглэгч)';
$string['reports'] = 'Тайлан';
$string['repositorynotsupported'] = 'Энэ сан нь imsmanifest.xml файлтай шууд холбогдохыг дэмждэггүй.';
$string['response'] = 'Хариу үйлдэл';
$string['result'] = 'Yр дүн';
$string['results'] = 'Үр дүн';
$string['review'] = 'Хянах';
$string['reviewmode'] = 'Хянах горим';
$string['rightanswer'] = 'Зөв хариулт';
$string['scoes'] = 'Сургалтын судлагдахуун';
$string['score'] = 'Оноо';
$string['scorm:addinstance'] = 'Шинэ SCORM багц нэмэх';
$string['scorm:deleteownresponses'] = 'Өөрийн оролдлогуудыг устгах';
$string['scorm:deleteresponses'] = 'SCORM оролдлогуудыг устгах';
$string['scorm:savetrack'] = 'Ул мөрийг хадгалах';
$string['scorm:skipview'] = 'Тоймыг алгасах';
$string['scorm:viewreport'] = 'Тайланг харах';
$string['scorm:viewscores'] = 'Оноог харах';
$string['scormclose'] = 'Дуусах хугацаа:';
$string['scormcourse'] = 'Судлах хичээл';
$string['scormloggingoff'] = 'API бүртгэлийг унтраасан байна';
$string['scormloggingon'] = 'API бүртгэлийг асаасан байна';
$string['scormopen'] = 'Эхлэх хугацаа';
$string['scormresponsedeleted'] = 'Хэрэглэгчийн оролдлогуудыг устгах';
$string['scormstandard'] = 'SCORM стандарт горим';
$string['scormstandarddesc'] = 'Идэвхгүй болсон үед Moodle нь SCORM 1.2 багцуудад тодорхойлолтоос илүү ихийг хадгалах боломжийг олгодог бөгөөд хэрэглэгчийн нэрийг SCORM багц руу дамжуулахдаа Moodle системийн бүтэн нэрийн форматын тохиргоог ашигладаг.';
$string['scormtype'] = 'Төрөл';
$string['scormtype_help'] = 'Энэ тохиргоо нь багцыг хичээлд хэрхэн оруулахыг тодорхойлдог. 4 хүртэлх сонголт байна:

* Байршуулсан багц - Файл сонгогчоор сонгосон SCORM багцыг идэвхжүүлнэ
* Гадаад SCORM тунхаг - imsmanifest.xml URL замыг зааж өгнө. Тайлбар: Хэрэв URL нь таны веб хуудаснаас өөр домэйн нэртэй байвал дүнг хадгалахгүй учир "Татаж авсан багц" нь илүү сайн сонголт болно.
* Татаж авсан багц - Багцын URL-г зааж өгнө. Багцыг задлах ба дотооддоо хадгалах ба гадаад SCORM багцыг шинэчлэх үед шинэчлэгдэх болно.
* Гадаад AICC URL - энэ URL нь нэг AICC Үйл ажиллагааны эхлүүлэх URL юм. Үүний эргэн тойронд хуурмаг багц бий болно.';
$string['scrollbars'] = 'Цонхыг гүйлгэж харахыг зөвшөөрөх';
$string['search:activity'] = 'SCORM багц - үйл ажиллагааны мэдээлэл';
$string['selectall'] = 'Бүгдийг сонгох';
$string['selectnone'] = 'Бүгдийг цуцлах';
$string['show'] = 'Харуулах';
$string['sided'] = 'Хажуу тал руу';
$string['skipview'] = 'Суралцагч агуулгын бүтцийн хуудсыг алгасах';
$string['skipview_help'] = 'Энэ тохиргоо нь агуулгын бүтцийн хуудсыг хэзээ нэгэн цагт алгасах (харуулахгүй) боломжтой эсэхийг тодорхойлдог. Хэрэв багц нь зөвхөн нэг сургалтын судлагдахуун агуулж байвал агуулгын бүтцийн хуудсыг үргэлж алгасах боломжтой байна.';
$string['skipviewdesc'] = 'Энэ тохиргоо нь хуудасны агуулгын бүтцийг хэзээ алгасах тухай өгөгдмөл тохиргоог тодорхойлдог';
$string['slashargs'] = 'АНХААРУУЛГА: энэ хуудасны аргументад налуу зураасыг идэвхгүй болгосон бөгөөд объектууд санаснаар ажиллахгүй байж магадгүй!';
$string['stagesize'] = 'Yеийн хэмжээ';
$string['stagesize_help'] = 'Эдгээр тохиргоо нь сургалтын судлагдахууны фрейм/цонхны өргөн, өндрийг зааж өгдөг.';
$string['started'] = 'Эхэлсэн:';
$string['status'] = 'Төлөв';
$string['statusbar'] = 'Төлөвийн мөрийг харуулах';
$string['student_response'] = 'Хариу';
$string['subplugintype_scormreport'] = 'Тайлан';
$string['subplugintype_scormreport_plural'] = 'Тайлан';
$string['suspended'] = 'Түдгэлзсэн';
$string['syntax'] = 'Өгүүлбэр зүйн алдаа';
$string['tag_error'] = '{$a->value}-г агуулсан үл мэдэх ({$a->tag}) таг';
$string['time'] = 'Цаг';
$string['title'] = 'Гарчиг';
$string['toc'] = 'TOC';
$string['too_many_attributes'] = '{$a->tag} таг нь маш олон атрибуттай';
$string['too_many_children'] = '{$a->tag} таг нь маш олон хүүхэд тагтай';
$string['toolbar'] = 'Хэрэгслийн мөрийг харуулах';
$string['totaltime'] = 'Цаг';
$string['trackcorrectcount'] = 'Зөв тоо';
$string['trackcorrectcount_help'] = 'Асуултын зөв хариултын тоо';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Энэ нь таны SCORM багцаас энэ асуултанд тохируулсан танигч бөгөөд SCORM-ийн тодорхойлолт нь асуултын бичвэрийг бүрэн хэмжээгээр өгөхийг зөвшөөрөхгүй байна.';
$string['trackingloose'] = 'АНХААРУУЛГА: Энэ багцын мөшгөсөн өгөгдөл устах болно!';
$string['tracklatency'] = 'Хүлээх хугацаа';
$string['tracklatency_help'] = 'Суралцагчдаас асуултын хариултыг авч дуусах хугацаа болон эхний хариултын  хоорондох хугацаа.';
$string['trackpattern'] = 'Үлгэр';
$string['trackpattern_help'] = 'Энэ нь асуултын зөв хариулт болох бөгөөд суралцагчийн хариултад харуулахгүй.';
$string['trackresponse'] = 'Хариулт';
$string['trackresponse_help'] = 'Энэ бол асуултад суралцагчийн өгсөн хариулт';
$string['trackresult'] = 'Үр дүн';
$string['trackresult_help'] = 'Суралцагч зөв хариулт оруулсан бол харуулна.';
$string['trackscoremax'] = 'Хамгийн өндөр оноо';
$string['trackscoremax_help'] = 'Боловсруулаагүй оноонд оноож болох хамгийн дээд утга';
$string['trackscoremin'] = 'Хамгийн бага оноо';
$string['trackscoremin_help'] = 'Боловсруулаагүй оноонд оноож болох хамгийн доод утга';
$string['trackscoreraw'] = 'Боловсруулаагүй оноо';
$string['trackscoreraw_help'] = 'min ба max утгуудаар хязгаарлагдсан мужтай харьцуулахад суралцагчийн гүйцэтгэлийг харуулсан тоо';
$string['tracksuspenddata'] = 'Өгөгдлийг түдгэлзүүлэх';
$string['tracksuspenddata_help'] = 'Суралцагчийн уулзалт хооронд өгөгдөл хадгалах, сэргээх зайгаар хангах';
$string['tracktime'] = 'Цаг';
$string['tracktime_help'] = 'Оролдлогыг эхлүүлсэн цаг';
$string['tracktype'] = 'Төрөл';
$string['tracktype_help'] = '"сонголт", "товч хариулт" гэх мэт асуултын төрөл';
$string['trackweight'] = 'Жин';
$string['trackweight_help'] = 'Оноог тооцоолоход асуултад оноосон жин.';
$string['type'] = 'Төрөл';
$string['typeaiccurl'] = 'Гадаад AICC URL';
$string['typeexternal'] = 'Гадаад SCORM тунхаг';
$string['typelocal'] = 'Байршуулсан багц';
$string['typelocalsync'] = 'Татаж авсан багц';
$string['undercontent'] = 'Агуулгын доор';
$string['unziperror'] = 'Багцыг задлах үед алдаа гарлаа';
$string['updatefreq'] = 'Автоматаар шинэчлэх давтамж';
$string['updatefreq_error'] = 'Багц файлыг гаднаас байршуулсан үед автоматаар шинэчлэх давтамжийг зааж өгөх боломжтой';
$string['updatefreq_help'] = 'Энэ нь гадаад багцыг автоматаар татаж авах болон шинэчлэх боломжийг олгодог';
$string['updatefreqdesc'] = 'Энэ сонголт нь үйл ажиллагааг автоматаар шинэчлэх давтамжийг тохируулдаг';
$string['validateascorm'] = 'Багцыг батлах';
$string['validation'] = 'Баталгаажуулалтын үр дүн';
$string['validationtype'] = 'Энэ сонголт нь SCORM тунхгийг баталгаажуулахад ашигладаг DOMXML санг тохируулдаг. Хэрэв та мэдэхгүй бол сонгосон сонголтыг өөрчлөлгүй үлдээнэ үү.';
$string['value'] = 'Утга';
$string['versionwarning'] = 'Тунхгийн хувилбар нь 1.3-аас хуучин хувилбар бөгөөд {$a->tag} таг дээр анхааруулж байна';
$string['viewallreports'] = '{$a} оролдлогуудын тайланг харах';
$string['viewalluserreports'] = '{$a} хэрэглэгчийн тайланг харах';
$string['whatgrade'] = 'Оролдлогыг дүгнэх';
$string['whatgrade_help'] = 'Хэрэв олон оролдлого хийхийг зөвшөөрсөн бол энэ тохиргоо нь журналд хамгийн өндөр, дундаж, эхний эсвэл сүүлчийн гүйцэтгэсэн оролдлогыг бүртгэх эсэхийг заана. Сүүлчийн гүйцэтгэсэн оролдлого сонголт нь "амжилтгүй" гэсэн төлөвтэй оролдлогуудыг оруулаагүй болно.

Олон удаагийн оролдлогыг зохицуулах тухай тэмдэглэл:

* Шинэ оролдлого эхлүүлэх сонголтыг агуулгын бүтцийн хуудасны чагтан нүдээр тохируулах тул хэрэв та нэгээс олон оролдлогыг зөвшөөрөхийг хүсвэл тухайн хуудас руу нэвтрэх эрх олгож байгаа эсэхээ шалгаарай.
* Зарим SCORM багцууд шинэ оролдлогыг ухаалгаар шийддэг бол ихэнх нь тийм биш юм. Хэрэв суралцагч өмнө нь хийсэн оролдлогыг дахин оруулбал SCORM агуулга нь өмнөх оролдлогуудыг дарж бичихгүй байх дотоод логикгүй бол оролдлого "дууссан" эсвэл "тэнцсэн" байсан ч гэсэн тэдгээрийг дарж бичдэг.
* "Хүчээр дуусгах", "Шинээр оролдох" болон "Сүүлчийн оролдлогын дараа түгжих" тохиргоонууд нь олон оролдлогын цаашдын удирдлагыг хангана.';
$string['whatgradedesc'] = 'Олон оролдлого хийхийг зөвшөөрсөн тохиолдолд хамгийн өндөр, дундаж, эхний эсвэл сүүлчийн гүйцэтгэсэн оролдлогыг журналд бүртгэнэ.';
$string['width'] = 'Өргөн';
$string['window'] = 'Цонх';
$string['youmustselectastatus'] = 'Та шаардлагатай төлөвийг сонгох ёстой';
