<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ar', version '4.3'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'سيطرة الوصول';
$string['actionaftercorrectanswer'] = 'العمل بعد الاجابة الصحيحة';
$string['actionaftercorrectanswer_help'] = 'بعد إجابة السؤال بشكل صحيح، هناك 3 خيارات بالنسبة للصفحة الحالية:

* عادي - متابعة مسار الدرس
* إظهار صفحة مخفية - يتم إظهار الصفحات بترتيب عشوائي مع عدم إظهار الصفحة الواحدة مرتين
* إظهار صفحة غير مجاب عليها - يتم إظهار الصفحات بترتيب عشوائي مع إعادة إظهار الصفحات ذات الأسئلة غير المجاب عليها مراراً';
$string['actions'] = 'الإجراءات';
$string['activitylink'] = 'إربطه مع النشاط التالي';
$string['activitylink_help'] = 'لتوفير رابط عند انتهاء الدرس لنشاط آخر في المساق، إختر ذلك النشاط من القائمة المنسدلة';
$string['activitylinkname'] = 'إذهب إلى {$a}';
$string['activityoverview'] = 'لديك دروس مستحقة';
$string['addabranchtable'] = 'إضافة صفحة محتوى';
$string['addanendofbranch'] = 'إضافة نهاية التفرع';
$string['addanewpage'] = 'إضافة صفحة جديدة';
$string['addaquestionpage'] = 'إضافة صفحة سؤال';
$string['addaquestionpagehere'] = 'إضافة صفحة سؤال هنا';
$string['addbranchtable'] = 'إضافة صفحة محتوى';
$string['addcluster'] = 'إضافة عنقود';
$string['addedabranchtable'] = 'تمت إضافة صفحة محتوى';
$string['addedanendofbranch'] = 'تمت إضافة نهاية تفرع';
$string['addedaquestionpage'] = 'تمت إضافة صفحة سؤال';
$string['addedcluster'] = 'تمت إضافة عنقود';
$string['addedendofcluster'] = 'تمت إضافة نهاية العنقود';
$string['addendofbranch'] = 'إضافة نهاية التفرع';
$string['addendofcluster'] = 'إضافة نهاية العنقود';
$string['addessay'] = 'أنشئ صفحة سؤال مقالة';
$string['addmatching'] = 'أنشئ صفحة سؤال مطابقة';
$string['addmultichoice'] = 'أنشئ صفحة سؤال متعدد الخيارات';
$string['addnewgroupoverride'] = 'إضافة تجاوز مجموعة';
$string['addnewuseroverride'] = 'إضافة تجاوز مستخدم';
$string['addnumerical'] = 'أنشئ صفحة سؤال رقمي';
$string['addpage'] = 'اضف صفحة';
$string['addshortanswer'] = 'أنشئ صفحة سؤال إجابة قصيرة';
$string['addtruefalse'] = 'أنشئ صفحة سؤال صح/خطأ';
$string['allotheranswers'] = 'كل الإجابات الأخرى';
$string['allotheranswersjump'] = 'كل الإجابات الأخرى تذهب إلى';
$string['allotheranswersscore'] = 'درجة كل الإجابات الأخرى';
$string['allowofflineattempts'] = 'إسمح بمحاولة الدرس بدون الاتصال بالإنترنت باستعمال تطبيق الجوال';
$string['allowofflineattempts_help'] = 'عند تمكينه، سيتمكن مستعمل تطبيق الجوال من تنزيل الدرس ومحاولته بدون الاتصال بالإنترنت. سيتم تنزيل كل الإجابات المحتملة والصحيحة أيضاً.
ملاحظة: من غير الممكن تمكين محاولة الدرس دون اتصال إن كان محدداً بوقت.';
$string['anchortitle'] = 'بداية المحتوى الأساسي';
$string['and'] = 'و';
$string['answer'] = 'أجب';
$string['answeredcorrectly'] = 'الأجابة صحيحة';
$string['answersfornumerical'] = 'إجابات الأسئلة الرقمية ينبغي مضاهاتها مع قيمتين صغرى وعظمى';
$string['arrangebuttonshorizontally'] = 'هل تريد ترتيب أزرار المحتوى أفقياً؟';
$string['attempt'] = 'محاولة: {$a}';
$string['attemptheader'] = 'المحاولة';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'محاولات';
$string['attemptsdeleted'] = 'المحاولات المحذوفة';
$string['attemptsremaining'] = 'لديك {$a} محاولة/محاولات باقية';
$string['available'] = 'متاح من';
$string['averagescore'] = 'متوسط الدرجة';
$string['averagetime'] = 'متوسط الوقت';
$string['branch'] = 'محتوى';
$string['branchtable'] = 'محتوى';
$string['cachedef_overrides'] = 'معلومات تجاوز المستخدمين والمجموعات';
$string['cancel'] = 'إلغاء';
$string['cannotfindanswer'] = 'خطأ: تعذر العثور على الإجابة';
$string['cannotfindattempt'] = 'خطأ: تعذر العثور على المحاولة';
$string['cannotfindessay'] = 'خطأ: تعذر العثور على المقالة';
$string['cannotfindfirstgrade'] = 'خطأ: تعذر العثور على التقديرات';
$string['cannotfindfirstpage'] = 'خطأ: تعذر العثور على الصفحة الأولى';
$string['cannotfindgrade'] = 'خطأ: تعذر العثور على التقديرات';
$string['cannotfindnewestgrade'] = 'خطأ: تعذر العثور على الدرجة الأحدث';
$string['cannotfindnextpage'] = 'الحفظ الاحتياطي للدرس: تعذر العثور على الصفحة اللاحقة!';
$string['cannotfindpagerecord'] = 'إضافة نهاية التفرع: تعذر العثور على سجل الصفحة';
$string['cannotfindpages'] = 'تعذر العثور على صفحات الدرس';
$string['cannotfindpagetitle'] = 'تأكيد الحذف: تعذر العثور على عنوان الصفحة';
$string['cannotfindpreattempt'] = 'تعذر العثور على سجل المحاولة السابقة!';
$string['cannotfindrecords'] = 'خطأ: تعذر العثور على سجلات الدرس';
$string['cannotfindtimer'] = 'خطأ: تعذر العثور على سجلات توقيت الدرس';
$string['cannotfinduser'] = 'خطأ: تعذر العثور على المستخدمين';
$string['canretake'] = '{$a} يستطيع إعادة أخذ';
$string['casesensitive'] = 'استعمال التعابير الاعتيادية';
$string['casesensitive_help'] = 'قم بتأشير الخانة لاستعمال التعابير الاعتيادية لتحليل الإجابات.';
$string['checkbranchtable'] = 'تحقق من صفحة المحتوى';
$string['checkedthisone'] = 'أختر هذا';
$string['checknavigation'] = 'تأكد من روابط التنقل';
$string['checkquestion'] = 'فحص السؤال';
$string['classstats'] = 'إحصائيات الصف';
$string['clicktodownload'] = 'أنقر على الرابط الآتي لتنزيل الملف.';
$string['closebeforeopen'] = 'تعذر تحديث الدرس. لقد جعلت تاريخ الإغلاق قبل تاريخ الفتح.';
$string['cluster'] = 'عنقود';
$string['clusterjump'] = 'سؤال غير مرئي ضمن العنقود';
$string['clustertitle'] = 'عنقود';
$string['collapsed'] = 'مختزل';
$string['comments'] = 'تعليقاتك';
$string['completed'] = 'تم';
$string['completederror'] = 'اتم الدرس';
$string['completethefollowingconditions'] = 'عليك تلبية الشرط/الشروط الآتية في <b>{$a}</b> الدرس قبل أن تتمكن من المتابعة.';
$string['completiondetail:reachend'] = 'متابعة النشاط حتى النهاية';
$string['completiondetail:timespent'] = 'قضاء ما لا يقل عن {$a} في هذا النشاط';
$string['completionendreached'] = 'يتطلب بلوغ النهاية';
$string['completionendreached_desc'] = 'ينبغي على الطالب بلوغ صفحة نهاية الدرس لإكمال هذا النشاط';
$string['completiontimespent'] = 'ينبغي على الطالب العمل على هذا النشاط على الأقل لـ';
$string['completiontimespentdesc'] = 'ينبغي على الطالب العمل على هذا النشاط على الأقل لـ {$a}';
$string['completiontimespentgroup'] = 'يتطلب قضاء وقت';
$string['conditionsfordependency'] = 'شرط/شروط التبِعات';
$string['configintro'] = 'القيم المحددة هنا تمثل القيم الافتراضية المستعملة في نماذج الإعدادات عند إنشاء نشاط درس جديد. الإعدادات المعلمة على أنها متقدمة ستظهر فقط عند النقر على رابط \'أظهر المزيد...\'.';
$string['configmaxanswers'] = 'أقصى عدد من الإجابات في الصفحة إفتراضياً';
$string['configmediaclose'] = 'يعرض زر إغلاق كجزء من النافذة المنبثقة المنشأة لملف وسائط مرتبط';
$string['configmediaheight'] = 'يحدد إرتفاع  النافذة المنبثقة المعروض لملف وسائط مرتبط';
$string['configmediawidth'] = 'يحدد عرض النافذة المنبثقة المعروض لملف وسائط مرتبط';
$string['configpassword_desc'] = 'فيما إذا كانت كلمة المرور مطلوبة للوصول إلى الدرس.';
$string['configslideshowbgcolor'] = 'لون الخلفية عند عرض الشرائح إذا تم تمكينه';
$string['configslideshowheight'] = 'يحدد إرتفاع عرض الشرائح إذا تم تمكينه';
$string['configslideshowwidth'] = 'يحدد عرض عرض الشرائح إذا تم تمكينه';
$string['configtimelimit_desc'] = 'إذا تم تحديد الوقت، سيتم عرض تنبيه عند بدء الدرس مع عداد وقت عكسي. إذا تم ضبطه على 0 فلن يكون هناك تحديد للوقت';
$string['confirmdelete'] = 'إحذف الصفحة';
$string['confirmdeletionofthispage'] = 'تأكيد حذف هذه الصفحة';
$string['congratulations'] = 'مبروك - لقد وصلت إلى نهاية الدرس';
$string['continue'] = 'استمر';
$string['continuetoanswer'] = 'استمر في تغيير الإجابات.';
$string['continuetonextpage'] = 'استمر إلى الصفحة التالية.';
$string['correctanswerjump'] = 'قفزة الإجابة الصحيحة';
$string['correctanswerscore'] = 'درجة الإجابة الصحيحة';
$string['correctresponse'] = 'الاجابة الصحيحة';
$string['createaquestionpage'] = 'إنشاء صفحة سؤال';
$string['credit'] = 'الرصيد';
$string['customscoring'] = 'درجة مخصصة';
$string['customscoring_help'] = 'عند تمكينه، سيكون بالإمكان إدخال درجة رقمية مستقلة لكل إجابة (موجبة أو سالبة).';
$string['deadline'] = 'الموعد النهائي';
$string['defaultessayresponse'] = 'سيتم تقييم مقالتك من قبل المعلم';
$string['deleteallattempts'] = 'حذف كل محاولات الدرس';
$string['deletedefaults'] = 'تم حذف {$a} إفتراضي الدرس';
$string['deletedpage'] = 'حذف صفحة';
$string['deletepagenamed'] = 'إحذف الصفحة: {$a}';
$string['deleting'] = 'حذف';
$string['deletingpage'] = 'حذف الصفحة: {$a}';
$string['dependencyon'] = 'يعتمد على';
$string['dependencyon_help'] = 'هذا الإعداد يسمح بأن يكون الوصول إلى هذا الدرس معتمداً على أداء الطالب في درس آخر ضمن نفس المساق. يمكن استعمال أي تشكيلة من شروط؛ الوقت المنقضي، الإكمال، و "التقدير أفضل من".';
$string['description'] = 'الوصف';
$string['deselectallattempts'] = 'إلغاء تحديد كل المحاولات';
$string['detailedstats'] = 'إحصائيات تفصيلية';
$string['didnotanswerquestion'] = 'لم تتم إجابة هذا السؤال';
$string['didnotreceivecredit'] = 'لم يتلقَّ رصيداً';
$string['disabled'] = 'مُعطِّل';
$string['displaydefaultfeedback'] = 'استعمل الإفادة الافتراضية';
$string['displaydefaultfeedback_help'] = 'عند تمكينه، فعند عدم العثور على الإفادة الخاصة بسؤال معين، سيتم استعمال الإفادة الافتراضية؛ "هذه هي الإجابة الصحيحة" أو "هذه هي الإجابة الخاطئة" بدلاً منها.';
$string['displayinleftmenu'] = 'هل تُعرض في القائمة؟';
$string['displayleftif'] = 'أدنى درجة لعرض القائمة';
$string['displayleftif_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي على الطالب إحراز علامة معينة قبل إظهار قائمة الدرس له. هذا سيجبر الطالب على خوض الدرس بأكمله في محاولته الأولى، وبعد حصوله على العلامة المحددة هنا سيتمكن من استعمال القائمة للمراجعة.';
$string['displayleftmenu'] = 'أظهر القائمة';
$string['displayleftmenu_help'] = 'عند تمكينه، سيتم إظهار القائمة للطلبة لتسمح لهم بالتنقل ما بين صفحات الدرس.';
$string['displaymode'] = 'وضع العرض';
$string['displayofgrade'] = 'أعرض الدرجة (للطلاب فقط)';
$string['displayreview'] = 'أعط خيار محاولة السؤال مرة أخرى';
$string['displayreview_help'] = 'عند تمكينه، سيكون بإمكان الطالب إعادة محاولة الإجابة على السؤال بدون إحراز نقاط عند إجابته عليه بشكل خاطئ أولاً، أو الاستمرار بالدرس. إذا اختار الطالب الاستمرار إلى سؤال آخر، فالسؤال المحدد (الخاطئ) ستتم إضافته إلى قائمة المتابعة. إفتراضياً، انتقالات الإجابة الخاطئة موضوعة على الخيار "هذه الصفحة" والدرجة المخصصة لها هي 0، لذلك من الموصى به أن تقوم بضبطها للانتقال إلى صفحة أخرى لتفادي الالتباس لدى طلبتك.';
$string['displayscorewithessays'] = '<p>لقد أحرزت {$a->score} من أصل {$a->tempmaxgrade} للأسئلة المقيمة تلقائياً.</p>
<p>أسئلة المقالة البالغ عددها {$a->essayquestions} سيتم تقييمها وإضافتها إلى درجتك النهائية لاحقاً.</p>
<p>علامتك الحالية بدون أسئلة المقالة هي {$a->score} من أصل {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'درجتك هي {$a->score} (من أصل {$a->grade}).';
$string['duplicatepagenamed'] = 'تكرار الصفحة: {$a}';
$string['edit'] = 'تحرير';
$string['editbranchtable'] = 'تحرير صفحة محتوى';
$string['editcluster'] = 'يجري تحرير عنقود';
$string['editendofbranch'] = 'يجري تحرير صفحة نهاية التفرع';
$string['editendofcluster'] = 'يجري تحرير صفحة نهاية العنقود';
$string['editessay'] = 'يجري تحرير صفحة سؤال مقالة';
$string['editinglesson'] = 'تحرير الدرس';
$string['editingquestionpage'] = 'تحرير صفحة السؤال {$a}';
$string['editlesson'] = 'تحرير الدرس';
$string['editlessonsettings'] = 'حرر إعدادات الدرس';
$string['editmatching'] = 'يجري تحرير صفحة سؤال مطابقة';
$string['editmultichoice'] = 'يجري تحرير صفحة سؤال متعدد الخيارات';
$string['editnumerical'] = 'يجري تحرير صفحة سؤال رقمي';
$string['editoverride'] = 'تحرير التجاوز';
$string['editpage'] = 'تحرير محتويات الصفحة';
$string['editpagecontent'] = 'تحرير محتويات الصفحة';
$string['editquestion'] = 'تحرير صفحة السؤال';
$string['editshortanswer'] = 'يجري تحرير صفحة سؤال إجابة قصيرة';
$string['edittruefalse'] = 'يجري تحرير صفحة سؤال صح/خطأ';
$string['email'] = 'بريد الإلكتروني';
$string['emailallgradedessays'] = 'إرسال إشعارات المقالات المصححة';
$string['emailgradedessays'] = 'إرسال إشعارات المقالات المصححة';
$string['emailsuccess'] = 'تم إرسال الإشعارات بنجاح';
$string['emptypassword'] = 'كلمة المرور لا يمكن تركها فارغة';
$string['enabled'] = 'مُمَكَّنة';
$string['endofbranch'] = 'نهاية التفرع';
$string['endofcluster'] = 'نهاية العنقود';
$string['endofclustertitle'] = 'نهاية عنقود';
$string['endoflesson'] = 'نهاية الدرس';
$string['enteredthis'] = 'قد أدخل هذا';
$string['enterpassword'] = 'الرجاء إدخال كلمة المرور';
$string['eolstudentoutoftime'] = 'إنتباه: لقد نفذ الوقت المخصص لك لهذا الدرس. إجابتك الأخيرة قد لا تكون محسوبة إذا كانت بعد انتهاء الوقت.';
$string['eolstudentoutoftimenoanswers'] = 'لم تجبن على أي أسئلة. لقد تلقيت 0 لهذا الدرس.';
$string['essay'] = 'مقالى';
$string['essayemailmessage2'] = '<p>موجه المقالة: {$a->question}</p><p>إجابتك: <em>{$a->response}</em></p><p>تعليقات المقيم: <em>{$a->comment}</em></p><p>لقد تلقيت {$a->earned} من أصل {$a->outof} لسؤال المقالة هذا.</p><p>علامتك في الدرس {$a->lesson} قد تغيرت إلى {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>لقد تلقيت {$a->earned} من أصل {$a->outof} لسؤال المقالة هذا.</p><p>علامتك في الدرس {$a->lesson} قد تغيرت إلى {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'الدرجة المتاحة لسؤال الدرس';
$string['essaynotgradedyet'] = 'هذه المقالة لم تُمنح لها علامة بعد';
$string['essayresponses'] = 'ردود المقال';
$string['essays'] = 'مقالات';
$string['essayscore'] = 'درجة المقالة';
$string['eventcontentpageviewed'] = 'صفحة محتوى تمت معاينتها';
$string['eventessayassessed'] = 'مقالة تم تقييمها';
$string['eventessayattemptviewed'] = 'محاولة مقالة تمت معاينتها';
$string['eventhighscoreadded'] = 'الدرجة العليا للدرس أُضيفت';
$string['eventhighscoresviewed'] = 'الدرجة العليا للدرس تمت معاينتها';
$string['eventlessonended'] = 'درس تم إنهاؤه';
$string['eventlessonrestarted'] = 'درس أُعيد بدؤه';
$string['eventlessonresumed'] = 'درس تم استئنافه';
$string['eventlessonstarted'] = 'درس تم بدؤه';
$string['eventoverridecreated'] = 'تجاوز درس تم إنشاؤه';
$string['eventoverridedeleted'] = 'تجاوز درس تم حذفه';
$string['eventoverrideupdated'] = 'تجاوز درس تم تحديثه';
$string['eventpagecreated'] = 'صفحة تم إنشاؤها';
$string['eventpagedeleted'] = 'صفحة تم حذفها';
$string['eventpagemoved'] = 'صفحة تم نقلها';
$string['eventpageupdated'] = 'صفحة تم تحديثها';
$string['eventquestionanswered'] = 'سؤال تمت إجابته';
$string['eventquestionviewed'] = 'سؤال تمت معاينته';
$string['false'] = 'خاطىء';
$string['fileformat'] = 'صيغة الملف';
$string['finalwrong'] = 'ليس تماماً';
$string['finish'] = 'نهاية';
$string['firstanswershould'] = 'الجواب الأول ينبغي أن ينتقل إلى صفحة "الإجابة الصحيحة"';
$string['firstwrong'] = 'لقد أجبت بشكل غير صحيح. هل ترغب بمحاولة السؤال مرة أخرى؟ إذا أجبته بشكل صحيح الآن، لن تحتسب لك درجة عليه).';
$string['flowcontrol'] = 'تحكم المسيرة';
$string['fractionsaddwrong'] = 'الدرجات الموجبة التي اخترتها لا تبلغ 100%<br />بل إنها تبلغ {$a}%<br />هل تريد الرجوع لتصويب هذا السؤال؟';
$string['fractionsnomax'] = 'لا بد أن يكون أحد الإجابات يمثل 100%، حتى يكون<br />ممكناً إحراز الدرجة الكاملة لهذا السؤال.<br />هل تريد الرجوع لتصويب هذا السؤال؟';
$string['full'] = 'موسع';
$string['general'] = 'عام';
$string['gotoendoflesson'] = 'إذهب إلى نهاية الدرس';
$string['grade'] = 'الدرجة';
$string['gradebetterthan'] = 'أحرز درجة أفضل من (%)';
$string['gradebetterthanerror'] = 'إحصل على درجة أفضل من {$a} بالمئة';
$string['graded'] = 'تم رصد درجة';
$string['gradeessay'] = 'تقييم أسئلة المقالة، فهناك ({$a->notgradedcount} غير مقيمة و {$a->notsentcount} غير مرسلة)';
$string['gradeis'] = 'الدرجة هي {$a}';
$string['gradeoptions'] = 'نقاط الدرجة';
$string['groupoverrides'] = 'مجموعة تتخطى';
$string['groupoverridesdeleted'] = 'تم حذف تجاوز المجموعة';
$string['groupsnone'] = 'لا توجد مجموعات يمكنك الوصول إليها.';
$string['handlingofretakes'] = 'معالجة إعادة الدرس';
$string['handlingofretakes_help'] = 'إذا تم السماح بإعادة الدرس، هذا الإعداد يحدد ما إذا كانت علامته هي متوسط كل محاولاته أم أقصاها.';
$string['havenotgradedyet'] = 'لم تصحح بعد';
$string['here'] = 'هنا';
$string['highscore'] = 'الدرجة العليا';
$string['hightime'] = 'الوقت الأقصى';
$string['importcount'] = 'يتم استيراد {$a} من الأسئلة';
$string['importquestions'] = 'استيراد أسئلة';
$string['importquestions_help'] = 'هذه الميزة تسمح باستيراد أنواع متعددة من الأسئلة عبر ملف نصي.';
$string['inactiveoverridehelp'] = '* هذا التجاوز غير مُمَكَّن لأن وصول المستخدم إلى النشاط مقيد. هذا قد يُعزى إلى تعيينات الأدوار أو المجموعات، تقييدات الوصول الأخرى، أو كون النشاط مخفي.';
$string['indicator:cognitivedepth'] = 'الدرس معرفياً';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط الدرس.';
$string['indicator:cognitivedepthdef'] = 'الدرس معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات الدرس خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم، معاينة الرد، التعليق على الرد، إعادة التقديم بعد معاينة الرد)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'الدرس إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط الدرس .';
$string['indicator:socialbreadthdef'] = 'الدرس إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'قد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات الدرس خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً، المشاركة مع الآخرين)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'صفحة مدرجة';
$string['invalidfile'] = 'ملف غير صحيح';
$string['invalidid'] = 'لم يتم تمرير مُعرَّف وحدة المساق أو مُعرَّف وحدة الدرس';
$string['invalidlessonid'] = 'مُعرَّف الدرس لم يكن صحيحاً';
$string['invalidoverrideid'] = 'مُعرَّف التجاوز غير صحيح';
$string['invalidpageid'] = 'مُعرَّف الصفحة غير صحيح';
$string['jump'] = 'القفز إلى';
$string['jumps'] = 'الانتقالات';
$string['jumps_help'] = 'لكل جواب (للأسئلة) أو وصف (لصفحات المحتوى) هناك انتقالة مصاحبة. يمكن جعل الانتقالة نسبية، مثل "هذه الصفحة" أو "الصفحة التالية"، أو مطلقة عبر تحديد صفحة بعينها ضمن الدرس.';
$string['jumpsto'] = 'القفز إلى <em>{$a}</em>';
$string['leftduringtimed'] = 'لقد غادرت في أثناء درس محدد بوقت.<br />لطفاً، أنقر على الاستمرار لإعادة بدئه.';
$string['leftduringtimednoretake'] = 'لقد غادرت في أثناء درس محدد بوقت وأنت.<br />غير مسموح لك بإعادته أو الاستمرار فيه.';
$string['leftduringtimedsession'] = 'لقد غادرت في أثناء درس محدد بوقت .';
$string['lesson:addinstance'] = 'إضافة درس جديد';
$string['lesson:edit'] = 'تحرير نشاط الدرس';
$string['lesson:grade'] = 'منح التقديرات لأسئلة مقالة الدرس';
$string['lesson:manage'] = 'إدارة نشاط الدرس';
$string['lesson:manageoverrides'] = 'إدارة تجاوزات الدرس';
$string['lesson:view'] = 'معاينة نشاط الدرس';
$string['lesson:viewreports'] = 'معاينة تقارير الدرس';
$string['lessonbeingpreviewed'] = 'يجري استعراض الدرس حاليًا.';
$string['lessonclosed'] = 'تم أغلاق هذا الدرس في {$a}';
$string['lessoncloses'] = 'اغلاق الدرس';
$string['lessoneventcloses'] = '{$a} يُغلق';
$string['lessoneventopens'] = '{$a} يُفتح';
$string['lessonformating'] = 'تنسيق الدرس';
$string['lessonmenu'] = 'قائمة الدرس';
$string['lessonnotready'] = 'هذا الدرس غير جاهز لبدئه بعد. لطفاً، تواصل مع {$a}.';
$string['lessonnotready2'] = 'هذا الدرس غير جاهز لبدئه بعد';
$string['lessonopen'] = 'سيفتح هذا الدرس في {$a}';
$string['lessonopens'] = 'الدرس يفتح';
$string['lessonpagelinkingbroken'] = 'تعذر العثور على الصفحة الأولى، لا بد أن ربط صفحات الدرس فيه مشكلة. لطفاً، تواصل مع المشرف.';
$string['lessonstats'] = 'إحصائيات الدرس';
$string['linkedmedia'] = 'وسائط مرتبطة';
$string['loginfail'] = 'فشلت عملية الدخول، اعد المحاولة';
$string['lowscore'] = 'الدرجة الدنيا';
$string['lowtime'] = 'أقل وقت';
$string['manageoverrides'] = 'إدارة التجاوزات';
$string['manualgrading'] = 'منح التقديرات للمقالات';
$string['matchesanswer'] = 'طابق مع الاجابة';
$string['matching'] = 'مطابقة';
$string['matchingpair'] = 'مطابقة أزواج {$a}';
$string['maxgrade'] = 'الدرجة القصوى';
$string['maxgrade_help'] = 'هذا الإعداد يحدد الدرجة العليا للدرس. عند ضبطه على 0، لن يظهر الدرس في صفحات التقديرات.';
$string['maximumnumberofanswersbranches'] = 'أقصى عدد من الإجابات';
$string['maximumnumberofanswersbranches_help'] = 'هذا الإعداد يحدد أقصى عدد من الإجابات التي يمكن استعمالها في الدرس. إذا تم الاقتصار على أسئلة صح/خطأ، يمكن جعله 2. يمكن تغيير هذا الإعداد في أي وقت نظراً لأنه يؤثر فقط على ما يراه المعلم وليس على البيانات.';
$string['maximumnumberofattempts'] = 'أقصى عدد من المحاولات لكل سؤال';
$string['maximumnumberofattempts_help'] = 'هذا الإعداد يحدد أقصى عدد من المحاولات المسموح بها لكل سؤال. إذا أجاب الطالب بشكل غير صحيح على سؤال ما مراراً، وتم الوصول إلى العدد الأقصى من المحاولات، سيتم عرض الصفحة التالية من الدرس له.';
$string['maximumnumberofattemptsreached'] = 'تم الوصول إلى أقصى عدد مسموح به من المحاولات - الانتقال إلى الصفحة التالية';
$string['mediaclose'] = 'أظهر زر الإغلاق';
$string['mediafile'] = 'وسائط مرتبطة';
$string['mediafile_help'] = 'يمكن رفع ملف وسائط لاستعماله في الدرس. عندها، سيتم عرض رابط \'أنقر هنا للمعاينة\' في كتلة مسماة \'وسائط مرتبطة\' في كل صفحة من الدرس.';
$string['mediafilepopup'] = 'أنقر هنا للمعاينة';
$string['mediaheight'] = 'إرتفاع النافذة المنبثقة';
$string['mediawidth'] = 'عرض النافذة المنبثقة';
$string['messageprovider:graded_essay'] = 'إشعار بتقييم مقالة الدرس';
$string['minimumnumberofquestions'] = 'الحد الأقصى لعدد الأسئلة';
$string['minimumnumberofquestions_help'] = 'هذا الإعداد يحدد أدنى عدد من الأسئلة التي سيتم استعمالها لحساب العلامة لهذا النشاط.';
$string['missingname'] = 'الرجاء إدخال الكنية';
$string['modattempts'] = 'إسمح للطالب بالمراجعة';
$string['modattempts_help'] = 'عند تمكينه، سيتمكن الطلاب من التنقل في الدرس مرة أخرى من البداية.';
$string['modattemptsnoteacher'] = 'معاينة الطالب تعمل فقط للطلاب';
$string['modulename'] = 'درس';
$string['modulename_help'] = 'إن وحدة نشاط الدرس تُمكن المعلم من توليد نشاطات تنطوي على تقديم المحتوى والتمارين بأشكال مرنة ومشوقة. يمكن للمعلم استعمال الدرس لإنشاء مجموعة متسلسلة من صفحات المحتوى أو لبناء نشاط توجيهي يوفر مسارات أو خيارات متعددة للمتعلم. في كلا الحالتين، يمكن للمعلم أن يرتئي زيادة مستوى انخراط الطلبة في الدرس وتعميق استيعابهم عبر تضمينه أسئلة متنوعة، مثل متعدد الاختيارات، المطابقة، والإجابة القصيرة. إعتماداً على الإجابة التي يختارها الطالب وكيفية تطوير الدرس من قبل المعلم، يمكن للطالب؛ الانتقال إلى الصفحة التالية، أن يؤخذ إلى صفحة سابقة، أو تغييره مساره في الدرس بشكل كامل.

يمكن منح تقديرات في الدرس مع توثيقها في سجل التقديرات.

يمكن استعمال الدروس:

* للتعليم الموجه ذاتياً في موضوع جديد
* لتمارين السيناريوهات المتعددة أو المحاكاة/اتخاذ القرار
* للمراجعة التمييزية مع مجموعة مختلفة من أسئلة المراجعة إعتماداً على الإجابات المعطاة للأسئلة الأولية';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'دروس';
$string['move'] = 'أنقل الصفحة';
$string['movedpage'] = 'حرك الصفحة';
$string['movepagehere'] = 'أنقل الصفحة إلى هناء';
$string['movepagenamed'] = 'أنقل الصفحة: {$a}';
$string['moving'] = 'نقل الصفحة: {$a}';
$string['multianswer'] = 'متعدد الإجابات';
$string['multianswer_help'] = 'قم بتأشير الخانة إذا كانت هناك أكثر من إجابة صحيحة.';
$string['multichoice'] = 'متعدد الخيارات';
$string['multipleanswer'] = 'متعدد الإجابات';
$string['nameapproved'] = 'تم الموافقة على الاسم';
$string['namereject'] = 'عذراً، تم رفض اسمك من قبل المرشح.<br />لطفاً، حاول اسماً آخر.';
$string['new'] = 'جديد';
$string['nextpage'] = 'الصفحة اللاحقة';
$string['noanswer'] = 'لم تُعطَ إجابة سؤال واحد أو أكثر. لطفاً، إرجع إليها وقدم لها إجابة.';
$string['noattemptrecordsfound'] = 'لم يتم العثور على أي سجلات للمحاولة: لذا لم تعطى درجة';
$string['nobranchtablefound'] = 'لم يتم العثور على صفحة محتوى';
$string['noclose'] = 'لا تاريخ إغلاق';
$string['nocommentyet'] = 'لا يوجد أي تعليق بعد';
$string['nocoursemods'] = 'لم يتم العثور على أنشطة';
$string['nocredit'] = 'لا درجة';
$string['nodeadline'] = 'لا موعد نهائي';
$string['noessayquestionsfound'] = 'لا توجد أسئلة مقالية في هذا الدرس.';
$string['nohighscores'] = 'لا توجد درجات عليا';
$string['nolessonattempts'] = 'لم يتم إجراء محاولات مسبقة في هذا الدرس';
$string['nolessonattemptsgroup'] = 'لم يتم تقديم محاولات من قبل {$a} عضو/أعضاء من المجموعة في هذا الدرس.';
$string['none'] = 'لا شيء';
$string['nooneansweredcorrectly'] = 'لم يقم أي شخص بإعطاء الاجابة الصحيحة';
$string['nooneansweredthisquestion'] = 'لم يقم أي شخص بإعطاء الاجابة الصحيحة لهذا السؤال';
$string['noonecheckedthis'] = 'لم يقم أحد بتأشيره.';
$string['nooneenteredthis'] = 'لم يقم أحد بإدخاله.';
$string['noonehasanswered'] = 'لم يقم أحد بإجابة سؤال مقالة بعد.';
$string['noonehasansweredgroup'] = 'لم يقم أحد في {$a} بإجابة سؤال مقالة بعد.';
$string['noopen'] = 'لا تاريخ فتح';
$string['nooverridecreated'] = 'لم يتم إنشاء أي تجاوزات.';
$string['nooverridedata'] = 'ينبغي عليك تجاوز إعداد واحد على الأقل في الدرس.';
$string['noretake'] = 'ليس مسموحًا لك بإعادة أخذ هذا الدرس.';
$string['normal'] = 'عادي - تابع مسار الدرس';
$string['notcompleted'] = 'غير مكتمل';
$string['notcompletedwithdate'] = 'غير مكتمل ({$a})';
$string['notdefined'] = 'لم يعرف';
$string['notenoughsubquestions'] = 'عدد الاسئلة الفرعية غير كافي!<br /> هل ترغب في العودة لتعديل هذا السؤال.';
$string['notenoughtimespent'] = 'لقد أكملت هذا الدرس في {$a->timespent}، وهو أقل من الوقت المطلوب البالغ {$a->timerequired}. قد تريد إعادة الدرس مرة أخرى.';
$string['notgraded'] = 'لم يتم التقييم';
$string['notitle'] = 'بلا عنوان';
$string['notyetcompleted'] = 'لقد تم البدء بالدرس، ولكنه غير مكتمل بعد';
$string['numberofcorrectanswers'] = 'عدد الاجابات الصحيحة: {$a}';
$string['numberofcorrectanswersheader'] = 'عدد الإجابات الصحيحة';
$string['numberofcorrectmatches'] = 'عدد الاجابات الصحيصة المتطابقة: {$a}';
$string['numberofpagestoshow'] = 'عدد ما يظهر من الصفحات';
$string['numberofpagestoshow_help'] = 'هذا الإعداد يحدد عدد الصفحات الظاهرة من الدرس. هو عملي فقط للدروس ذات الصفحات الظاهرة بشكل عشوائي (عند ضبط "الإجراء بعد الإجابة الصحيحة" إلى "أظهر صفحة غير مرئية" أو "أظهر صفحة غير مجاب عليها"). عند جعله صفراً، سيتم إظهار كافة الصفحات.';
$string['numberofpagesviewed'] = 'عدد الصفحات التي تم مشاهدتها: {$a}';
$string['numberofpagesviewedheader'] = 'عدد الأسئلة التي تمت إجابتها';
$string['numberofpagesviewednotice'] = 'عدد الأسئلة التي تمت إجابتها: {$a->nquestions} (عليك إجابة ما لا يقل عن {$a->minquestions})';
$string['numerical'] = 'رقمي';
$string['numericanswer'] = 'جواب رقمي';
$string['numericanswer_help'] = 'يمكنك تحديد رقم واحد أو مدى من الأرقام باستعمال النقطتين. على سبيل المثال 2:5 تعني أي إجابة تتراوح ما بين 2 و 5 بضمنها هذان الرقمان تعتبر صحيحة.';
$string['offlinedatamessage'] = 'لقد عملت على هذه المحاولة باستعمال الجوال. تم حفظ البيانات في هذا الموقع منذ {$a}. لطفاً، تحقق فيما إذا كان لديك أي عمل غير محفوظ بعد.';
$string['ongoing'] = 'عرض محصلة الدرجة';
$string['ongoing_help'] = 'عند تمكينه، ستعرض كل صفحة ما أحرزه الطالب من نقاط قياساً بالإجمالي الممكن له حتى ذلك الحين.';
$string['ongoingcustom'] = 'لقد أحرزت {$a->score} نقطة/نقاط من أصل {$a->currenthigh} حتى الحين.';
$string['ongoingnormal'] = 'لقد أجبتَ بشكل صحيح {$a->correct} من أصل {$a->viewed} محاولات.';
$string['onpostperpage'] = 'منشور واحد فقط لكل صفحة';
$string['openafterclose'] = 'لقد جعلت تاريخ الفتح بعد تاريخ الإغلاق';
$string['options'] = 'خيارات';
$string['or'] = 'أو';
$string['ordered'] = 'مرتب';
$string['other'] = 'أخر';
$string['outof'] = 'من {$a}';
$string['override'] = 'تجاوز';
$string['overridedeletegroupsure'] = 'هل أنت متأكد من رغبتك في حذف تجاوز المجموعة {$a}؟';
$string['overridedeleteusersure'] = 'هل أنت متأكد من رغبتك في حذف تجاوز المستخدم {$a}؟';
$string['overridegroup'] = 'تجاوز المجموعة';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'التجاوزات';
$string['overrideuser'] = 'تجاوز المستخدم';
$string['overrideusereventname'] = '{$a->lesson} - تجاوز';
$string['overview'] = 'عرض عام';
$string['overview_help'] = 'الدرس مكون من عدد من الصفحات وصفحات المحتوى إختيارياً. تضم الصفحة بعض المحتوى وعادة ما تنتهي بسؤال. هناك انتقالة تقترن بكل إجابة. يمكن أن تكون الانتقالة نسبية، مثل "هذه الصفحة" أو "الصفحة التالية"، أو مطلقة عبر تحديد أي صفحة بعينها ضمن الدرس. صفحة المحتوى هي صفحة تحتوي على مجموعة انتقالات أو روابط إلى صفحات أخرى في الدرس، كما في جدول المحتويات.';
$string['page'] = 'صفحة: {$a}';
$string['page-mod-lesson-edit'] = 'تحرير صفحة الدرس';
$string['page-mod-lesson-view'] = 'معاينة صفحة الدرس أو استعراضها';
$string['page-mod-lesson-x'] = 'أي صفحة درس';
$string['pageanswers'] = 'إجابات الصفحة';
$string['pagecontents'] = 'محتويات الصفحة';
$string['pageresponses'] = 'استجابات الصفحة';
$string['pages'] = 'صفحات';
$string['pagetitle'] = 'عنوان الصفحة';
$string['password'] = 'كلمة مرور';
$string['passwordprotectedlesson'] = '{$a} درس مؤمن بكلمة مرور';
$string['pleasecheckoneanswer'] = 'الرجاء اختيار إجابة واحدة';
$string['pleasecheckoneormoreanswers'] = 'الرجاء اختيار إجابة واحدة أو أكثر';
$string['pleaseenteryouranswerinthebox'] = 'لطفاً، أدخل إجابتك في مربع الحوار';
$string['pleasematchtheabovepairs'] = 'الرجاء مقابلة الزوجين السابقين';
$string['pluginadministration'] = 'إدارة الدرس';
$string['pluginname'] = 'الدرس';
$string['pointsearned'] = 'النقاط المكتسبة';
$string['postprocesserror'] = 'وقع خطأ خلال المعالجة القبلية!';
$string['postsuccess'] = 'تمت المشاركة بنجاح';
$string['practice'] = 'درس تدريبي';
$string['practice_help'] = 'الدرس التدريبي لا يظهر في سجل الدرجات.';
$string['preprocesserror'] = 'وقع خطأ خلال المعالجة البعدية!';
$string['prerequisiteisobsolete'] = 'من المساق إزالة خيار المتطلبات المسبقة من الدرس. لطفاً، استعمل تقييدات الوصول بدلاً منه.';
$string['prerequisitelesson'] = 'المتطلبات المسبقة للدرس';
$string['preview'] = 'استعراض';
$string['previewlesson'] = 'معاينة {$a}';
$string['previewpagenamed'] = 'استعراض الصفحة: {$a}';
$string['previouspage'] = 'الصفحة السابقة';
$string['privacy:metadata:attempts'] = 'سجل لعدد محاولات الصفحة';
$string['privacy:metadata:attempts:answerid'] = 'مُعرَّف الإجابة';
$string['privacy:metadata:attempts:correct'] = 'فيما إذا كانت المحاولة صحيحة';
$string['privacy:metadata:attempts:pageid'] = 'مُعرَّف الصفحة';
$string['privacy:metadata:attempts:retry'] = 'رقم المحاولة';
$string['privacy:metadata:attempts:timeseen'] = 'وقت القيام بالمحاولة';
$string['privacy:metadata:attempts:useranswer'] = 'تفاصيل عن إجابة المستخدم';
$string['privacy:metadata:attempts:userid'] = 'مُعرَّف المستخدم';
$string['privacy:metadata:branch'] = 'سجل الصفحات التي تمت معاينتها';
$string['privacy:metadata:branch:flag'] = 'فيما إذا تم تحديد الصفحة التالية عشوائياً';
$string['privacy:metadata:branch:nextpageid'] = 'مُعرَّف الصفحة التالية';
$string['privacy:metadata:branch:pageid'] = 'مُعرَّف الصفحة';
$string['privacy:metadata:branch:retry'] = 'رقم المحاولة';
$string['privacy:metadata:branch:timeseen'] = 'وقت معاينة الصفحة';
$string['privacy:metadata:branch:userid'] = 'مُعرَّف المستخدم';
$string['privacy:metadata:grades'] = 'سجل لتقديرات كل درس';
$string['privacy:metadata:grades:completed'] = 'وقت منح الدرجة';
$string['privacy:metadata:grades:grade'] = 'الدرجة المعطاة';
$string['privacy:metadata:grades:userid'] = 'مُعرَّف المستخدم';
$string['privacy:metadata:overrides'] = 'سجل للتجاوزات لكل درس';
$string['privacy:metadata:overrides:available'] = 'وقت محاولة الدرس';
$string['privacy:metadata:overrides:deadline'] = 'الموعد النهائي لإكمال الدرس';
$string['privacy:metadata:overrides:maxattempts'] = 'أقصى عدد للمحاولات';
$string['privacy:metadata:overrides:password'] = 'كلمة المرور للوصول إلى الدرس';
$string['privacy:metadata:overrides:retake'] = 'فيما إذا كان يُسمح بإعادة الدرس';
$string['privacy:metadata:overrides:review'] = 'فيما إذا كان يُسمح بإعادة محاولة السؤال';
$string['privacy:metadata:overrides:timelimit'] = 'الوقت المحدد لإكمال الدرس، بالثواني';
$string['privacy:metadata:overrides:userid'] = 'مُعرَّف المستخدم';
$string['privacy:metadata:timer'] = 'سجل محاولات الدرس';
$string['privacy:metadata:timer:completed'] = 'فيما إذا كانت المحاولة مكتملة';
$string['privacy:metadata:timer:lessontime'] = 'وقت آخر فعالية سجلناها للمستخدم';
$string['privacy:metadata:timer:starttime'] = 'تاريخ بدء المحاولة';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'وقت آخر فعالية سجلناها للمستخدم من تطبيق الجوال';
$string['privacy:metadata:timer:userid'] = 'مُعرَّف المستخدم';
$string['privacy:metadata:userpref:lessonview'] = 'طريقة العرض المفضلة عند تحرير الدروس';
$string['privacy:path:essayanswers'] = 'أجوبة المقالة';
$string['privacy:path:essayresponses'] = 'استجابات المقالة';
$string['privacy:path:pages'] = 'الصفحات';
$string['processerror'] = 'وقع خطأ خلال المعالجة!';
$string['progressbar'] = 'شريط التقدم';
$string['progressbar_help'] = 'عند تمكينه، سيتم عرض شريط أسفل صفحات الدرس ليظهر النسبة المئوية التقريبية لما تم إكماله منه.';
$string['progressbarteacherwarning'] = 'شريط التقدم لا يظهر لـ {$a}';
$string['progressbarteacherwarning2'] = 'لن تشاهد شريط التقدم لأنك تستطيع تحرير هذا الدرس';
$string['progresscompleted'] = 'لقد أكملت {$a}% من الدرس';
$string['qtype'] = 'نوع الصفحة';
$string['question'] = 'السؤال';
$string['questionoption'] = 'السؤال';
$string['questiontype'] = 'نوع السؤال';
$string['randombranch'] = 'محتوى صفحة عشوائي';
$string['randompageinbranch'] = 'سؤال عشوائي ضمن صفحة محتوى';
$string['rank'] = 'مستوى';
$string['rawgrade'] = 'الدرجة الخام';
$string['receivedcredit'] = 'الدرجة المتلقاة';
$string['redisplaypage'] = 'إعادة عرض الصفحة';
$string['removeallgroupoverrides'] = 'حذف كل تجاوزات المجموعة';
$string['removealluseroverrides'] = 'حذف كل تجاوزات المستخدم';
$string['report'] = 'تقرير';
$string['reports'] = 'التقارير';
$string['response'] = 'إجابة';
$string['retakesallowed'] = 'يُسمح بإعادة الدرس';
$string['retakesallowed_help'] = 'عند تمكينه، يمكن للطلاب محاولة الدرس أكثر من مرة.';
$string['returnto'] = 'عودة إلى {$a}';
$string['returntocourse'] = 'عودة إلى المساق';
$string['reverttodefaults'] = 'الرجوع إلى افتراضات الدرس';
$string['review'] = 'مراجعة';
$string['reviewlesson'] = 'مراجعة الدرس';
$string['reviewquestionback'] = 'نعم، أرغب في المحاولة ثانياً';
$string['reviewquestioncontinue'] = 'لا، فقط أريد التقدم نحو السؤال التالي';
$string['sanitycheckfailed'] = 'فشل فحص السلامة: تم حذف هذه المحاولة';
$string['save'] = 'احفظ';
$string['savechanges'] = 'حفظ التغييرات';
$string['savechangesandeol'] = 'إحفظ كل التغييرات ثم اذهب إلى نهاية الدرس.';
$string['saveoverrideandstay'] = 'إحفظ وأدخل تجاوزاً آخر';
$string['savepage'] = 'حفظ الصفحة';
$string['score'] = 'الدرجة';
$string['score_help'] = 'عند تمكين الدرجات المخصصة في إعدادات الدرس، يمكن عندها إعطاء درجة رقمية (موجبة أو سالبة) لكل إجابة.';
$string['scores'] = 'الدرجات';
$string['search:activity'] = 'الدرس - معلومات النشاط';
$string['secondpluswrong'] = 'ليس تماماً. هل ترغب بالمحاولة ثانية؟';
$string['selectallattempts'] = 'إختر كل المحاولات';
$string['selectaqtype'] = 'إختر نوع السؤال';
$string['selectreport'] = 'إختر التقرير';
$string['sent'] = 'مرسلة';
$string['shortanswer'] = 'إجابة قصيرة';
$string['showanunansweredpage'] = 'إظهار الصفحة التي لم تتم الإجابة عليها';
$string['showanunseenpage'] = 'أظهر صفحة غير مرئية';
$string['singleanswer'] = 'إجابة مفردة';
$string['skip'] = 'تخطى التنقل';
$string['slideshow'] = 'عرض الشرائح';
$string['slideshow_help'] = 'عند تمكينه، سيتم عرض الدرس بشكل شرائح، ذات عرض وارتفاع ثابتين.';
$string['slideshowbgcolor'] = 'لون خلفية عرض الشرائح';
$string['slideshowheight'] = 'إرتفاع عرض الشرائح';
$string['slideshowwidth'] = 'عرض عرض الشرائح';
$string['startlesson'] = 'إبدء الدرس';
$string['studentattemptlesson'] = '{$a->lastname}، {$a->firstname} في المحاولة رقم {$a->attempt}';
$string['studentname'] = '{$a} الاسم';
$string['studentoneminwarning'] = 'تحذير: بقيت لديك دقيقة واحدة أو أقل لإكمال الدرس.';
$string['studentoutoftimeforreview'] = 'إنتباه: لقد نفد منك الوقت لمراجعة هذا الدرس';
$string['studentresponse'] = 'استجابة {$a}';
$string['submit'] = 'تسليم';
$string['submitname'] = 'اسم التسليم';
$string['teacherjumpwarning'] = 'لقد تم استعمال {$a->cluster} انتقال عنقودي أو {$a->unseen} انتقال إلى صفحات غير مرئية في هذا الدرس. سيتم الانتقال إلى الصفحة التالية بدلاً عنه. سجل دخولك بصفة طالب لاختبار تلك الانتقالات.';
$string['teacherongoingwarning'] = 'الدرجة الحالية تُعرض فقط للطلاب. قم بتسجيل الدخول بصفة طالب لاختبار الدرجة الحالية.';
$string['teachertimerwarning'] = 'عداد الوقت يعمل فقط مع الطلاب. إختبر العداد عبر تسجيل الدخول بصفة طالب.';
$string['thatsthecorrectanswer'] = 'تلك هي الإجابة الصحيحة';
$string['thatsthewronganswer'] = 'هذه إجابة خاطئة';
$string['thefollowingpagesjumptothispage'] = 'الصفحات التالية تنتقل إلى هذه الصفحة';
$string['thispage'] = 'هذه الصفحة';
$string['timeisup'] = 'انتهى الوقت';
$string['timelimit'] = 'محدد الوقت';
$string['timelimit_help'] = 'عند تمكينه، سيتم عرض تنبيه بشأن تحديد الوقت عند بدء الدرس مع عداد الوقت العكسي. أي إجابات معطاة بعد انقضاء الوقت لن تمنح درجات.';
$string['timelimitwarning'] = 'لديك {$a} لإنهاء الدرس.';
$string['timeremaining'] = 'الزمن المتبقي';
$string['timespenterror'] = 'إقض {$a} دقيقة على الأقل في الدرس';
$string['timespentminutes'] = 'الوقت الذي تم قضاءه (دقائق)';
$string['timetaken'] = 'الزمن المستنفذ';
$string['totalpagesviewedheader'] = 'عدد الصفحات التي تمت معاينتها';
$string['true'] = 'صواب';
$string['truefalse'] = 'صح/خطأ';
$string['unabledtosavefile'] = 'تعذر حفظ الملف الذي رفعته';
$string['unknownqtypesnotimported'] = 'لم يتم استيراد {$a} سؤال/أسئلة لأنها ذات نوع سؤال غير مدعم';
$string['unseenpageinbranch'] = 'سؤال لم تتم مشاهدته ضمن صفحة محتوى';
$string['unsupportedqtype'] = 'نوع سؤال غير مدعوم ({$a})!';
$string['updatedpage'] = 'صفحة محدثة';
$string['updatefailed'] = 'فشل التحديث';
$string['updatepagenamed'] = 'قم بتحديث الصفحة: {$a}';
$string['usemaximum'] = 'استعمل الحد الأقصى';
$string['usemean'] = 'استخدم المتوسط الحسابي';
$string['usepassword'] = 'درس محمي بكلمة مرور';
$string['usepassword_help'] = 'عند تمكينه، سيتطلب الوصول إلى الدرس كلمة مرور.';
$string['useroverrides'] = 'تجاوزات المستخدم';
$string['useroverridesdeleted'] = 'تم حذف تجاوزات المستخدم';
$string['usersnone'] = 'لا طلاب لديهم وصول إلى هذا الدرس';
$string['viewessayanswers'] = 'معاينة إجابات المقالة';
$string['viewgrades'] = 'معاينة التقديرات';
$string['viewreports'] = 'معاينة {$a->attempts} محاولات مكتملة للطالب {$a->student}';
$string['viewreports2'] = 'معاينة {$a} محاولات مكتملة';
$string['warning'] = 'تنبيه';
$string['welldone'] = 'أحسنت!';
$string['whatdofirst'] = 'ماذا تفضل أن تفعل أولاً؟';
$string['withselectedattempts'] = 'مع المحاولات المحددة...';
$string['wronganswerjump'] = 'إنتقالة الإجابة الخاطئة';
$string['wronganswerscore'] = 'درجة الإجابة الخاطئة';
$string['wrongresponse'] = 'إجابة خاطئة';
$string['youhaveseen'] = 'لقد شاهدت مسبقاً أكثر من صفحة من هذا الدرس.<br />هل تريد البدء من آخر صفحة شاهدتها؟';
$string['youranswer'] = 'إجابتك';
$string['yourcurrentgradeis'] = 'درجتك الحالية هي {$a}';
$string['yourcurrentgradeisoutof'] = 'درجتك الحالية هي {$a->grade} من {$a->total}';
$string['youshouldview'] = 'عليك أن تجيب على: {$a} على الأقل';
