<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'sl', version '4.3'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Napaka pri nalaganju vnosov v blog.';
$string['addon.blog.showonlyyourentries'] = 'Prikaži samo svoje vnose';
$string['addon.calendar.calendarevent'] = 'Koledarski dogodek';
$string['addon.calendar.calendarevents'] = 'Koledarski dogodki';
$string['addon.calendar.calendarreminders'] = 'Koledarski opomniki';
$string['addon.calendar.currentmonth'] = 'Trenutni mesec';
$string['addon.calendar.defaultnotificationtime'] = 'Privzeti čas obveščanja';
$string['addon.calendar.errorloadevent'] = 'Napaka pri nalaganju dogodka';
$string['addon.calendar.errorloadevents'] = 'Napaka pri nalaganju dogodkov.';
$string['addon.calendar.noevents'] = 'Ni dogodkov';
$string['addon.calendar.reminders'] = 'Opomniki';
$string['addon.calendar.setnewreminder'] = 'Nastavi nov opomnik';
$string['addon.competency.errornocompetenciesfound'] = 'Ni najdenih kompetenc';
$string['addon.competency.nocompetencies'] = 'Brez kompetenc';
$string['addon.coursecompletion.complete'] = 'Končano';
$string['addon.coursecompletion.couldnotloadreport'] = 'Poročila o zaključku predmeta ni bilo mogoče naložiti. Prosim poskusite kasneje.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurirajte naprave';
$string['addon.messages.contactlistempty'] = 'Seznam stikov je prazen';
$string['addon.messages.contactname'] = 'Ime kontakta';
$string['addon.messages.deletemessage'] = 'Izbriši sporočilo';
$string['addon.messages.deletemessageconfirmation'] = 'Ali ste prepričani, da želite izbrisati to sporočilo? Izbrisana bo samo iz vaše zgodovine sporočanja, uporabnik, ki je sporočilo poslal ali prejel, pa ga bo še vedno videl.';
$string['addon.messages.errordeletemessage'] = 'Napaka med brisanjem sporočila.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Napaka pri pridobivanju stikov s strežnika.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Napaka pri pridobivanju razprav s strežnika.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Napaka pri prenosu sporočil s strežnika.';
$string['addon.messages.errorwhileretrievingusers'] = 'Napaka pri pridobivanju uporabnikov iz strežnika.';
$string['addon.messages.messagenotsent'] = 'Sporočilo ni bilo poslano. Prosim poskusite kasneje.';
$string['addon.messages.newmessages'] = 'Nova sporočila';
$string['addon.messages.nousersfound'] = 'Uporabnikov ni bilo mogoče najti';
$string['addon.messages.showdeletemessages'] = 'Pokaži izbrisana sporočila';
$string['addon.messages.type_blocked'] = 'Blokirano';
$string['addon.messages.type_offline'] = 'Nepovezan';
$string['addon.messages.type_online'] = 'Povezan';
$string['addon.messages.type_search'] = 'Rezultati iskanja';
$string['addon.messages.type_strangers'] = 'Drugo';
$string['addon.messages.useentertosenddescdesktop'] = 'Če onemogočeno, lahko za pošiljanje sporočila uporabite Ctrl + Enter.';
$string['addon.messages.useentertosenddescmac'] = 'Če onemogočeno, lahko za pošiljanje sporočila uporabite Cmd + Enter.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Sporočila ni bilo mogoče poslati v pogovor {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Uporabnikom {{user}} sporočila ni bilo mogoče poslati. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Sprejmite izjavo o oddaji.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Oddaje v aplikaciji ne morete urediti, ker izjave o oddaji ni bilo mogoče pridobiti s spletnega mesta.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Določenih metod ocenjevanja aplikacija še ne podpira in jih zato ni mogoče spreminjati.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Oddaja v aplikaciji ni mogoča, ker izjave o oddaji ni bilo mogoče pridobiti s spletnega mesta.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Oddaje v aplikaciji ne morete urediti, ker določeni vtičniki še niso podprti za urejanje.';
$string['addon.mod_assign.errorshowinginformation'] = 'Podatkov o oddaji ni mogoče prikazati.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Ker aplikacija te vrste povratne informacije ne podpira, morda ne vsebuje vseh informacij.';
$string['addon.mod_assign.gradenotsynced'] = 'Ocena ni sinhronizirana';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Udeleženci, ki niso oddali niso prikazani.';
$string['addon.mod_assign.submissionnotsupported'] = 'Ker aplikacija ne podpira oddaj, morda ne vsebuje vseh informacij.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'uporabnikova ocena';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Ocena oddaje je bila spremenjena.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Uporabnikova oddaja je bila spremenjena na strani.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Napaka med povezavo s klepetom.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Napaka med pridobivanjem podatkov klepeta.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Napaka pri pridobivanju uporabnikov klepeta.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Napaka med prenosom sporočil s strežnika.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Napaka pri pošiljanju sporočila.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Za pošiljanje sporočil morate biti povezani na splet.';
$string['addon.mod_chat.nosessionsfound'] = 'Tem ni bilo mogoče najti';
$string['addon.mod_chat.showincompletesessions'] = 'Pokaži nedokončane teme.';
$string['addon.mod_choice.errorgetchoice'] = 'Napaka pri pridobivanju podatkov izbire.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% uporabnikov je izbralo možnost: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Vaš zadnji odgovor mora biti sinhroniziran preden bo vključen v rezultate.';
$string['addon.mod_data.edittagsnotsupported'] = 'Aplikacija žal ne podpira urejanja oznak.';
$string['addon.mod_data.errorapproving'] = 'Napaka pri odobritvi ali zavrnitvi vnosa.';
$string['addon.mod_data.errordeleting'] = 'Napaka pri brisanju vnosa.';
$string['addon.mod_data.gettinglocation'] = 'Pridobivanje lokacije';
$string['addon.mod_data.locationnotenabled'] = 'Lokacija ni omogočena';
$string['addon.mod_data.locationpermissiondenied'] = 'Dovoljenje za dostop do vaše lokacije je bilo zavrnjeno.';
$string['addon.mod_data.mylocation'] = 'Moja lokacija';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Aplikacija žal ne podpira iskanja po oznakah.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Odziva, ki vsebuje CAPTCHA, ni mogoče izpolniti brez povezave, ali če ni nastavljen, ali če strežnik ne deluje.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Odziv je shranjen in bo oddan kasneje.';
$string['addon.mod_folder.emptyfilelist'] = 'Datotek ni na voljo.';
$string['addon.mod_forum.errorgetforum'] = 'Napaka pri pridobivanju podatkov foruma.';
$string['addon.mod_forum.errorgetgroups'] = 'Napaka pri pridobivanju nastavitev skupine.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nove razprave ni bilo mogoče ustvariti v vseh skupinah.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Na tem forumu še ni razprav.';
$string['addon.mod_forum.group'] = 'Skupina';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} razprav';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} odgovorov';
$string['addon.mod_forum.refreshposts'] = 'Osveži objave';
$string['addon.mod_glossary.browsemode'] = 'Brskaj po vnosih';
$string['addon.mod_glossary.byalphabet'] = 'Po abecedi';
$string['addon.mod_glossary.byauthor'] = 'Razvrsti po avtorju';
$string['addon.mod_glossary.bycategory'] = 'Razvrsti po kategoriji';
$string['addon.mod_glossary.bynewestfirst'] = 'Novejši najprej';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Nedavno posodobljeni';
$string['addon.mod_glossary.bysearch'] = 'Išči';
$string['addon.mod_glossary.cannoteditentry'] = 'Vnosa ni mogoče urediti';
$string['addon.mod_glossary.entriestobesynced'] = 'Vnosi, ki jih je potrebno sinhronizirati';
$string['addon.mod_glossary.entrypendingapproval'] = 'Ta vnos čaka na odobritev.';
$string['addon.mod_glossary.errorloadingentries'] = 'Pri nalaganju vnosov je prišlo do napake.';
$string['addon.mod_glossary.errorloadingentry'] = 'Pri nalaganju vnosa je prišlo do napake.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Pri nalaganju besednjaka je prišlo do napake.';
$string['addon.mod_glossary.noentriesfound'] = 'Vnosov ni bilo mogoče najti.';
$string['addon.mod_glossary.searchquery'] = 'Iskalna poizvedba';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Naloži H5P datoteko';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Napaka pri prejemanju podatkov H5P aktivnosti';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P paket ni naložen. Za uporabo ga morate naložiti.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P paket je bil spremenjen odkar ste ga zadnjič naložili. Za uporabo ga morate ponovno naložiti.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Za ogled H5P paketa morate biti online.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Poskus ogleda {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Prikaži opis';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ta lekcija vsebuje skok na naključno stran z vsebino. Dokler se ne zažene v spletnem brskalniku, je v aplikaciji ni mogoče poskusiti.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Tega poskusa ni mogoče več oddati, ker je bil končan že naslednji poskus.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Ta poskus je bil končan brez povezave na splet.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Poskus brez povezave je bil sinhroniziran. Ali ga želite pregledati?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Poskus je bil končan na spletnem mestu.';
$string['addon.mod_lti.errorgetlti'] = 'Napaka pri pridobivanju podatkov modula.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Začetni URL naslov ni veljaven.';
$string['addon.mod_lti.launchactivity'] = 'Začnite dejavnost';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Napaka med nalaganjem vsebine na strani.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Kviz lahko rešite v aplikaciji, vendar ga morate oddati v brskalniku iz naslednjih razlogov:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Odgovorov kviza ni mogoče oddati iz naslednjih razlogov:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Ta poskus ni bil sinhroniziran od {{$a}}. Če ste z reševanjem nadaljevali v drugi napravi, lahko izgubite podatke.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Med shranjevanjem odgovorov je prišlo do napake. Ali ste prepričani, da želite zapustiti kviz?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Tega kviza v aplikaciji ni mogoče rešiti, ker aplikacija ne podpira teh tipov vprašanj:';
$string['addon.mod_quiz.errordownloading'] = 'Napaka pri prenosu zahtevanih podatkov.';
$string['addon.mod_quiz.errorgetattempt'] = 'Napaka pri pridobivanju podatkov o poskusu.';
$string['addon.mod_quiz.errorgetquestions'] = 'Napaka pri pridobivanju vprašanj.';
$string['addon.mod_quiz.errorgetquiz'] = 'Napaka pri pridobivanju podatkov kviza.';
$string['addon.mod_quiz.errorparsequestions'] = 'Pri branju vprašanj je prišlo do napake. Poskusite odpreti kviz v spletnem brskalniku.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Tega kviza v aplikaciji ni mogoče rešiti, ker vsebuje samo tipe vprašanj, ki jih aplikacija ne podpira:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Tega kviza v aplikaciji ni mogoče rešiti, ker ima pravila za dostop, ki jih aplikacija ne podpira:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Med shranjevanjem podatkov o poskusih je prišlo do napake.';
$string['addon.mod_quiz.finishnotsynced'] = 'Končano, vendar ne sinhronizirano';
$string['addon.mod_quiz.opentoc'] = 'Odpri navigacijsko okno';
$string['addon.mod_quiz.warningattemptfinished'] = 'Poskus brez povezave na splet je zavržen, ker je bil končan na spletnem mestu ali ni bil najden.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Nekateri odgovori brez povezave na splet so bili zavrženi, ker so bila vprašanja spremenjena na spletu.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Poskus je nedokončan, ker so bili nekateri odgovori brez povezave na splet zavrženi. Preglejte svoje odgovore in nato poskusite znova.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Ta kviz vsebuje tipe vprašanj, ki jih aplikacija ne podpira:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Napaka med nalaganjem vsebine.';
$string['addon.mod_resource.openthefile'] = 'Odpri datoteko';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Ocene ni bilo mogoče izračunati.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ti podatki pripadajo poskusu številka {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Pri ustvarjanju novega poskusa brez povezave na splet je prišlo do napake. Prosim poskusite znova.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Napaka pri prenosu SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Napaka pri pridobivanju podatkov SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Žal aplikacija podpira samo SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Prenos paketov SCORM je onemogočen. Obrnite se na skrbnika spletnega mesta.';
$string['addon.mod_scorm.errornovalidsco'] = 'V tem paketu SCORM ni viden SCO za nalaganje.';
$string['addon.mod_scorm.errorpackagefile'] = 'Žal aplikacija podpira samo pakete ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Med sinhronizacijo je prišlo do napake. Prosim poskusite ponovno.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Ta poskus vsebuje podatke, ki niso bili sinhronizirani.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Tega poskusa ni mogoče poslati, ker ste presegli največje število poskusov.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Ta paket SCORM ni prenesen. Ko ga odprete, bo prenesen samodejno.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Ta paket SCORM je bil spremenjen od zadnjega prenosa. Ko ga odprete, bo prenesen samodejno.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Nekateri podatki brez povezave na splet iz poskusa {{number}} so bili zavrženi, ker jih ni bilo mogoče šteti za nov poskus.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Nekaterih poskusov ni bilo mogoče sinhronizirati s spletnim mestom, ker zadnji spletni poskus še ni končan. Pred novim poskusom zaključite spletni poskus.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Pri oddaji ankete je žal prišlo do težave. Prosim poskusite ponovno.';
$string['addon.mod_survey.errorgetsurvey'] = 'Napaka pri pridobivanju podatkov ankete.';
$string['addon.mod_survey.results'] = 'Rezultati';
$string['addon.mod_url.accessurl'] = 'Dostop do URL naslova';
$string['addon.mod_url.pointingtourl'] = 'URL, na katerega kažejo viri.';
$string['addon.mod_wiki.errorloadingpage'] = 'Pri nalaganju strani je prišlo do napake.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Ta wiki še nima vsebine.';
$string['addon.mod_wiki.gowikihome'] = 'Pojdite na prvo stran wikija';
$string['addon.mod_wiki.subwiki'] = 'Pod-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Naslov ne sme biti prazen';
$string['addon.mod_wiki.viewpage'] = 'Prikaži stran';
$string['addon.mod_wiki.wikipage'] = 'Wiki stran';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategija ocenjevanja {{$a}} ni podprta';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Vnesti morate naslov.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Oddaja je bila spremenjena na spletnem mestu.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Ocena je bila spremenjena na spletnem mestu.';
$string['addon.notes.warningnotenotsent'] = 'Opombe k predmetu {{course}} ni bilo mogoče dodati. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Napaka pri pridobivanju obvestil.';
$string['addon.notifications.notifications'] = 'Obvestila';
$string['addon.notifications.playsound'] = 'Predvajaj zvok';
$string['addon.notifications.therearentnotificationsyet'] = 'Ni obvestil.';
$string['addon.storagemanager.deletecourses'] = 'Odstrani podatke vseh predmetov';
$string['addon.storagemanager.deletedatafrom'] = 'Prenos podatkov iz {{name}}';
$string['appstoredescription'] = 'OPOMBA: Ta uradna aplikacija Moodle Mobile bo delovala SAMO s spletnimi mesti Moodle, ki so bila nastavljena, da to omogočajo. Če imate težave pri povezovanju, se posvetujte s skrbnikom Moodle.

Če je vaše spletno mesto Moodle pravilno nastavljeno, lahko to aplikacijo uporabite za:

- brskanje po vsebin predmetov, tudi ko ste brez povezave
- prejemanje takojšnjih obvestil o sporočilih in drugih dogodkih
- hitro iskanje in navezava stika z udeleženci v svojih predmetih
- nalaganje slik, zvoka, video posnetkov in drugih datotek iz svoje mobilne naprave
- ogledovanje ocen predmeta
- in še veliko več!

Za vse najnovejše informacije preberite https://docs.moodle.org/sl/Moodle_app.

Vaše mnenje je pomembno, zato nam pošljite ocene o funkcionalnosti ter predloge o tem, kaj si želite imeti v aplikaciji!

Aplikacija zahteva naslednja dovoljenja:
Snemanje zvoka - Za snemanje zvoka za nalaganje v Moodle
Branje in spreminjanje vsebine vaše SD kartice - Vsebina se naloži na SD kartico, tako da si jih lahko ogledate brez povezave
Dostop do omrežja - da se povežete s spletnim mestom Moodle in preverite, če ste povezani na splet ali ne in preklopite na način brez povezave na splet
Zaženi ob zagonu - da prejmete lokalna obvestila, tudi če se aplikacija izvaja v ozadju
Preprečite spanje telefona - da lahko kadar koli prejmete potisna obvestila';
$string['core.browser'] = 'Brskalnik';
$string['core.cannotconnect'] = 'Neuspešna povezava';
$string['core.cannotdownloadfiles'] = 'Prenos datotek je onemogočen. Obrnite se na skrbnika spletnega mesta.';
$string['core.cannotopeninapp'] = 'Ta datoteka na tej napravi morda ne bo delovala po pričakovanjih. Jo želite kljub temu odpreti?';
$string['core.cannotopeninappdownload'] = 'Ta datoteka na tej napravi morda ne bo delovala po pričakovanjih. Jo želite kljub temu naložiti?';
$string['core.captureaudio'] = 'Snemanje zvoka';
$string['core.capturedimage'] = 'Posneta slika.';
$string['core.captureimage'] = 'Slikaj';
$string['core.capturevideo'] = 'Snemanje videoposnetka';
$string['core.clearsearch'] = 'Počisti iskanje';
$string['core.clearstoreddata'] = 'Počisti pomnilnik {{$a}}';
$string['core.clicktoseefull'] = 'Kliknite za ogled celotne vsebine.';
$string['core.comments.commentsnotworking'] = 'Komentarjev ni mogoče pridobiti';
$string['core.comments.warningcommentsnotsent'] = 'Komentarjev ni bilo mogoče sinhronizirati. {{error}}';
$string['core.confirmcanceledit'] = 'Ali ste prepričani, da želite zapustiti to stran? Vse spremembe bodo izgubljene.';
$string['core.confirmleaveunknownchanges'] = 'Ste prepričani, da želite zapustiti to stran? Če imate neshranjene spremembe bodo te izgubljene.';
$string['core.confirmloss'] = 'Ste prepričani? Vse spremembe bodo izgubljene.';
$string['core.confirmopeninbrowser'] = 'Ali želite odpreti v spletnem brskalniku?';
$string['core.contenteditingsynced'] = 'Vsebina, ki jo urejate, je bila sinhronizirana.';
$string['core.contentlinks.chooseaccount'] = 'Izberite račun';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Izberite račun, s katerim boste odprli povezavo.';
$string['core.contentlinks.confirmurlothersite'] = 'Ta povezava pripada drugemu mestu. Ali jo vseeno želite odpreti?';
$string['core.contentlinks.errornoactions'] = 'Dejanja, ki bi ga izvedli s to povezavo, ni bilo mogoče najti.';
$string['core.contentlinks.errornosites'] = 'Za to povezavo ni bilo mogoče najti nobenega spletnega mesta.';
$string['core.contentlinks.errorredirectothersite'] = 'URL naslov za preusmeritev ne sme kazati na drugo mesto.';
$string['core.copiedtoclipboard'] = 'Besedilo kopirano v odložišče';
$string['core.copytoclipboard'] = 'Kopiraj v odložišče.';
$string['core.course.activitydisabled'] = 'Vaša organizacija je onemogočila to dejavnost v aplikaciji za mobilne naprave.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Vaša organizacija je namestila vtičnik, ki še ni podprt.';
$string['core.course.allsections'] = 'Vsi sklopi';
$string['core.course.availablespace'] = 'Trenutno imate približno {{available}} prostega prostora.';
$string['core.course.cannotdeletewhiledownloading'] = 'Datotek ni mogoče izbrisati dokler se aktivnost nalaga. Počakajte, da se nalaganje zaključi.';
$string['core.course.confirmdownload'] = 'Prenesti nameravate {{size}}.{{availableSpace}} Ali ste prepričani, da želite nadaljevati?';
$string['core.course.confirmdownloadunknownsize'] = 'Velikosti prenosa ni bilo mogoče izračunati. {{availableSpace}} Ali ste prepričani, da želite nadaljevati?';
$string['core.course.confirmdownloadzerosize'] = 'Prenos se bo začel. {{availableSpace}} Ali ste prepričani, da želite nadaljevati?';
$string['core.course.confirmlimiteddownload'] = 'Trenutno niste povezani z Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Zdaj nameravate prenesti <strong>vsaj</strong> {{size}}. {{availableSpace}} Ali ste prepričani, da želite nadaljevati?';
$string['core.course.couldnotloadsectioncontent'] = 'Vsebine razdelka ni bilo mogoče naložiti. Prosim poskusite kasneje.';
$string['core.course.couldnotloadsections'] = 'Poglavja ni bilo mogoče naložiti. Prosim poskusite kasneje.';
$string['core.course.errordownloadingcourse'] = 'Napaka pri prenosu predmeta.';
$string['core.course.errordownloadingsection'] = 'Napaka pri prenosu poglavja.';
$string['core.course.errorgetmodule'] = 'Napaka pri pridobivanju podatkov o dejavnosti.';
$string['core.course.insufficientavailablequota'] = 'Naprava ni mogla dodeliti prostora za shranjevanje tega prenosa. Morda je prostor rezerviran za posodobitve aplikacij in sistemov. Pred prenosom počistite nekaj prostora za shranjevanje.';
$string['core.course.insufficientavailablespace'] = 'Prenesti poskušate {{size}}. Vaša naprava bo zato imela premalo prostora za normalno delovanje. Najprej počistite nekaj prostora za shranjevanje.';
$string['core.course.manualcompletionnotsynced'] = 'Ročno zaključevanje ni bilo sinhronizirano.';
$string['core.course.nocontentavailable'] = 'Trenutno vsebine ni na voljo.';
$string['core.course.refreshcourse'] = 'Osveži predmet';
$string['core.course.useactivityonbrowser'] = 'Še vedno ga lahko uporabljate v spletnem brskalniku naprave.';
$string['core.course.warningmanualcompletionmodified'] = 'Ročno zaključevanje dejavnosti je bilo spremenjeno na spletnem mestu.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Nekatera ročna zaključevanja predmeta "{{name}}" brez povezave na splet so bila izbrisana. {{error}}';
$string['core.coursenogroups'] = 'Niste član nobene skupine tega tečaja.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorije globlje od ravni {{$a}} ni mogoče najti.';
$string['core.courses.confirmselfenrol'] = 'Ali ste prepričani, da se želite vpisati v ta predmet?';
$string['core.courses.downloadcourses'] = 'Prenesi predmete';
$string['core.courses.enrolme'] = 'Vpiši me';
$string['core.courses.errorloadcategories'] = 'Pri nalaganju kategorij je prišlo do napake.';
$string['core.courses.errorloadcourses'] = 'Pri nalaganju predmetov je prišlo do napake.';
$string['core.courses.errorloadplugins'] = 'Vtičnikov, ki jih zahteva ta tečaj, ni bilo mogoče pravilno naložiti. Znova zaženite aplikacijo, da poskusite znova.';
$string['core.courses.errorsearching'] = 'Pri iskanju je prišlo do napake.';
$string['core.courses.errorselfenrol'] = 'Pri samovpisu je prišlo do napake.';
$string['core.courses.filtermycourses'] = 'Filtriraj moje predmete';
$string['core.courses.notenrollable'] = 'V ta predmet se ne morete vpisati.';
$string['core.courses.password'] = 'Ključ za vpis';
$string['core.courses.searchcoursesadvice'] = 'Z gumbom \'išči predmete\' lahko poiščete predmete, do katerih lahko dostopate kot gost ali se vpišete na predmete, ki to omogočajo.';
$string['core.courses.selfenrolment'] = 'Samovpis';
$string['core.courses.totalcoursesearchresults'] = 'Vseh tečajev: {{$a}}';
$string['core.currentdevice'] = 'Trenutna naprava';
$string['core.datastoredoffline'] = 'Podatkov ni bilo mogoče poslati in so shranjeni v napravi. Kasneje bodo poslani samodejno.';
$string['core.deletedoffline'] = 'Izbrisano brez povezave na splet';
$string['core.deleting'] = 'Brisanje';
$string['core.desktop'] = 'Namizje';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Zavrzi';
$string['core.dismiss'] = 'Opusti';
$string['core.downloaded'] = 'Preneseno';
$string['core.downloading'] = 'Prenos';
$string['core.editor.hidetoolbar'] = 'Skrij orodno vrstico';
$string['core.editor.toggle'] = 'Preklopi urejevalnik';
$string['core.emptysplit'] = 'Ta stran bo videti prazna, če je lev panel prazen ali se nalaga.';
$string['core.errorchangecompletion'] = 'Pri spremembi statusa zaključevanja je prišlo do napake. Prosim poskusite ponovno.';
$string['core.errordeletefile'] = 'Napaka pri brisanju datoteke. Prosim poskusite ponovno.';
$string['core.errordownloading'] = 'Napaka med prenosom datoteke.';
$string['core.errordownloadingsomefiles'] = 'Napaka med prenosom datotek. Morda niso prenesene vse datoteke.';
$string['core.errorfileexistssamename'] = 'Datoteka s tem imenom že obstaja.';
$string['core.errorinvalidform'] = 'Obrazec vsebuje neveljavne podatke. Preverite, ali so vsa obvezna polja izpolnjena in ali so podatki veljavni.';
$string['core.errorinvalidresponse'] = 'Prejet je neveljaven odgovor. Če se napaka ponovi, se obrnite na skrbnika spletnega mesta.';
$string['core.errorloadingcontent'] = 'Napaka pri nalaganju vsebine.';
$string['core.errorofflinedisabled'] = 'Brskanje brez povezave na splet je na vašem spletnem mestu onemogočeno. Za uporabo aplikacije morate biti povezani z internetom.';
$string['core.erroropenfilenoapp'] = 'Napaka pri odpiranju datoteke: za odpiranje te vrste datotek ni bilo mogoče najti nobene aplikacije.';
$string['core.erroropenfilenoextension'] = 'Napaka pri odpiranju datoteke: datoteka nima pripone.';
$string['core.erroropenpopup'] = 'Ta dejavnost poskuša odpreti pojavno okno. To v aplikaciji ni podprto.';
$string['core.errorrenamefile'] = 'Napaka pri preimenovanju datoteke. Prosim poskusite ponovno.';
$string['core.errorsomedatanotdownloaded'] = 'Če ste prenesli to aktivnost, upoštevajte, da se nekateri podatki med postopkom prenosa ne bodo prenesli zaradi učinkovitosti in porabe podatkov.';
$string['core.errorsync'] = 'Med sinhronizacijo je prišlo do napake. Prosim poskusite znova.';
$string['core.errorsyncblocked'] = '{{$a}} trenutno ni mogoče sinhronizirati zaradi postopka, ki se trenutno izvaja. Prosim poskusite kasneje. Če se težava še vedno pojavlja, poskusite znova zagnati aplikacijo.';
$string['core.errorurlschemeinvalidscheme'] = 'Ta URL je namenjen za uporabo v drugi aplikaciji: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL-ja te strani ni mogoče odpreti v tej aplikaciji.';
$string['core.filenameexist'] = 'Ime datoteke že obstaja: {{$a}}';
$string['core.fileuploader.audio'] = 'Zvok';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Naložili boste {{size}}. Ali ste prepričani, da želite nadaljevati?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Velikosti prenosa ni bilo mogoče določiti. Ali ste prepričani, da želite nadaljevati?';
$string['core.fileuploader.errorcapturingaudio'] = 'Napaka pri zajemu zvoka.';
$string['core.fileuploader.errorcapturingimage'] = 'Napaka pri zajemu slike.';
$string['core.fileuploader.errorcapturingvideo'] = 'Napaka pri zajemu videoposnetka.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Napaka pri pridobivanju slike iz albuma.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Če želite naložiti datoteke, morate biti povezani na splet.';
$string['core.fileuploader.errornoapp'] = 'Za izvajanje tega dejanja nimate nameščene potrebne aplikacije.';
$string['core.fileuploader.errorreadingfile'] = 'Napaka pri branju datoteke.';
$string['core.fileuploader.errorwhileuploading'] = 'Med nalaganjem datoteke je prišlo do napake.';
$string['core.fileuploader.file'] = 'Datoteka';
$string['core.fileuploader.fileuploaded'] = 'Datoteka je bila uspešno naložena.';
$string['core.fileuploader.maxbytesfile'] = 'Datoteka {{$a.file}} je prevelika. Največja velikost, ki jo lahko naložite, je {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Foto albumi';
$string['core.fileuploader.readingfile'] = 'Branje datoteke';
$string['core.fileuploader.readingfileperc'] = 'Branje datoteke: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Izberite datoteko';
$string['core.fileuploader.uploadafile'] = 'Naloži datoteko';
$string['core.fileuploader.uploading'] = 'Nalaganje';
$string['core.fileuploader.uploadingperc'] = 'Nalaganje: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Napaka pri pridobivanju uporabnikovega e-naslova. Preverite vašo povezavo in poskusite znova.';
$string['core.h5p.offlinedisabled'] = 'Spletno mesto ne dovoljuje prenašanja paketov H5P.';
$string['core.h5p.play'] = 'Predvajaj H5P';
$string['core.hasdatatosync'] = '{{$ a}} vsebuje podatke brez povezave na splet, ki jih je potrebno sinhronizirati.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Slika';
$string['core.imageviewer'] = 'Pregledovalnik slik';
$string['core.lastdownloaded'] = 'Nazadnje preneseno';
$string['core.lastsync'] = 'Nazadnje sinhronizirano';
$string['core.loadmore'] = 'Naloži več';
$string['core.login.authenticating'] = 'Preverjanje pristnosti';
$string['core.login.changepasswordbutton'] = 'Odpri stran za spremembo gesla';
$string['core.login.changepasswordhelp'] = 'Če imate težave pri spremembi gesla, se obrnite na skrbnika spletnega mesta. "Administratorji spletnih mest" upravljajo Moodle na vaši šoli / univerzi / podjetju ali učni organizaciji. Če ne veste, kako jih kontaktirati, se obrnite na učitelje.';
$string['core.login.changepasswordinstructions'] = 'V aplikaciji ne morete spremeniti gesla. Kliknite spodnji gumb, če želite odpreti spletno mesto v spletnem brskalniku, kjer lahko spremenite geslo. Upoštevajte, da morate po spremembi gesla zapreti brskalnik, saj ne boste avtomatsko preusmerjeni na aplikacijo.';
$string['core.login.changepasswordlogoutinstructions'] = 'Če želite spremeniti spletno mesto ali se odjaviti, kliknite gumb:';
$string['core.login.changepasswordreconnectinstructions'] = 'Kliknite gumb, da se ponovno povežete s spletnim mestom. (Upoštevajte, da se v primeru, da gesla ne boste uspešno spremenili, vrnete na prejšnji zaslon).';
$string['core.login.confirmdeletesite'] = 'Ali ste prepričani, da želite izbrisati spletno mesto {{sitename}}?';
$string['core.login.connect'] = 'Povežite se!';
$string['core.login.connecttomoodle'] = 'Povežite se na Moodle';
$string['core.login.connecttomoodleapp'] = 'Poskušate se povezati z običajnim spletnim mestom Moodle. Za dostop do te strani si morate prenesti uradno aplikacijo Moodle.';
$string['core.login.connecttoworkplaceapp'] = 'Poskušate se povezati s spletnim mestom Moodle Workplace. Za dostop do te strani si morate prenesti aplikacijo Moodle Workplace.';
$string['core.login.contactyouradministrator'] = 'Za pomoč se obrnite na skrbnika spletnega mesta.';
$string['core.login.contactyouradministratorissue'] = 'Prosite upravitelja spletnega mesta, naj preveri to težavo: {{$a}}';
$string['core.login.credentialsdescription'] = 'Za prijavo vnesite svoje uporabniško ime in geslo.';
$string['core.login.emailconfirmsentnoemail'] = '<p> Na vašem e-poštem naslovu imate novo sporočilo. </p> <p> Vsebuje enostavna navodila za dokončanje registracije. </p> <p> Če imate težave še naprej, se obrnite na skrbnika spletnega mesta. </ p>';
$string['core.login.emailnotmatch'] = 'E-poštna naslova se ne ujemata.';
$string['core.login.erroraccesscontrolalloworigin'] = 'Klic prek različnih izvorov, ki ste ga skušali izvesti, je bil zavrnjen. Preverite https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Pri brisanju tega spletnega mesta je prišlo do napake. Prosim poskusite ponovno.';
$string['core.login.errorexampleurl'] = 'URL https://campus.example.edu je le primerek URL-ja in ni resnična stran. <strong>Uporabite URL spletišča vaše šole ali organizacije.</strong>';
$string['core.login.errorqrnoscheme'] = 'Ta URL ni veljaven prijavni URL.';
$string['core.login.errorupdatesite'] = 'Pri posodabljanju žetona spletnega mesta je prišlo do napake.';
$string['core.login.faqcannotconnectanswer'] = 'Obrnite se na administratorja vašega spletišča.';
$string['core.login.faqcannotconnectquestion'] = 'Naslov spletišča sem vnesel pravilno, kljub temu se ne morem povezati.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Ste ime vnesli pravilno? Mogoče je, da vaše spletišče ni vključeno v naš javni imenik spletišč. Če je še vedno ne najdete vnesite naslov spletišča.';
$string['core.login.faqcannotfindmysitequestion'] = 'Ne najdem mojega spletišča.';
$string['core.login.faqsetupsiteanswer'] = 'Obiščite {{$link}} za ogled možnosti za izdelavo lastnega Moodle spletišča.';
$string['core.login.faqsetupsitelinktitle'] = 'Začnite.';
$string['core.login.faqsetupsitequestion'] = 'Želim vzpostaviti lastno Moodle spletišče.';
$string['core.login.faqtestappanswer'] = 'Za preizkus aplikacije v Moodle Demo Site vnesite "teacher" ali "student" v polje "Vaše spletišče" in kliknite na gumb "Povežite se na vaše spletišče".';
$string['core.login.faqtestappquestion'] = 'Želim le preizkusiti aplikacijo, kaj lahko naredim?';
$string['core.login.faqwhatisurlanswer'] = '<p>Vsaka organizacije ima lasten unikatni naslov oz. URL za svoje Moodle spletišče. Da poiščete naslov:</p><ol><li>Odprite spletni brskalnik in obiščite prijavno stran vašega Moodle spletišča.</li><li>Na vrhu strani, v naslovni vrstici, boste videli URL naslov vašega Moodle spletišča npr. "ucilnice.primer.si".<br>{{$image}}</li><li>Kopirajte naslov (ne kopirajte /login in kar pride za tem), prilepite v Moodle aplikacijo in nato kliknite gumb "Povežite se na vaše spletišče"</li><li>Zdaj se lahko prijavite v vaše spletišče z vašim uporabniškim imenom in geslom..</li>';
$string['core.login.faqwhatisurlquestion'] = 'Kakšen je naslov mojega spletišča? Kako najdem URL spletišča?';
$string['core.login.faqwhereisqrcode'] = 'Kje lahko najdem QR kodo?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Če jo je vaša organizacija omogočila lahko QR kodo najdete na spletišču na dnu vaše profilne strani.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Poiščite svoje spletno mesto';
$string['core.login.helpmelogin'] = '<p> Po vsem svetu je na tisoče Moodle strani. Ta aplikacija se lahko poveže samo s spletnimi mesti Moodle, ki imajo posebej omogočen dostop do aplikacije za mobilne naprave. </p> <p> Če se s svojim spletnim mestom Moodle ne morete povezati, se obrnite na skrbnika spletnega mesta in ga prosite, naj prebere <a href = "http://docs.moodle.org/sl/Mobile_app" target = "_blank"> http://docs.moodle.org/sl/Mobile_app </a> </p> <p> Če pa želite preizkusiti aplikacijo na Moodle demo spletni strani, v polje <i>Site address</i> vpišite <i>teacher</i> ali <i>student</i> in kliknite <b>Connect button</b>.</p>';
$string['core.login.invalidaccount'] = 'Preverite prijavne podatke ali prosite svojega skrbnika, da preveri konfiguracijo spletnega mesta.';
$string['core.login.invalidmoodleversion'] = '<p> Neveljavna različica spletnega mesta Moodle. Aplikacija Moodle podpira samo sisteme Moodle od {{$a}} naprej. </p>
<p> Lahko se obrnete na skrbnike spletnega mesta in jih prosite, naj posodobijo sistem Moodle. </p>
<p> "Administratorji spletnega mesta" so ljudje, ki upravljajo Moodle na vaši šoli / univerzi / podjetju ali učni organizaciji. Če ne veste, kako vzpostaviti stik z njimi, se obrnite na učitelje. </p>';
$string['core.login.invalidsite'] = 'URL naslov spletnega mesta ni veljaven.';
$string['core.login.invalidtime'] = 'Neveljaven čas';
$string['core.login.invalidvaluemax'] = 'Maksimalna vrednost je {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimalna vrednost je {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Ponovno se morate avtenticirati. Na spletno mesto se morate prijaviti v oknu brskalnika.';
$string['core.login.loginbutton'] = 'Prijavi se';
$string['core.login.logininsiterequired'] = 'Na spletno mesto se morate prijaviti v oknu brskalnika.';
$string['core.login.mobileservicesnotenabled'] = 'Mobilni dostop na vašem spletnem mestu ni omogočen. Če menite, da bi dostop moral biti omogočen, se obrnite na skrbnika spletnega mesta.';
$string['core.login.notloggedin'] = 'Biti morate prijavljeni.';
$string['core.login.onboardingcreatemanagecourses'] = 'Ustvarite in upravljajte vaše predmete';
$string['core.login.onboardingenrolmanagestudents'] = 'Vpišite in upravljajte vaše udeležence';
$string['core.login.onboardinggetstarted'] = 'Začnite uporabljati Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Že imam Moodle spletišče';
$string['core.login.onboardingimalearner'] = 'Sem učenec';
$string['core.login.onboardingimaneducator'] = 'Sem učitelj';
$string['core.login.onboardingineedasite'] = 'Potrebujem Moodle spletišče';
$string['core.login.onboardingprovidefeedback'] = 'Preskrbite pravočasne povratne informacije';
$string['core.login.onboardingtoconnect'] = 'Za povezavo z Moodle aplikacijo potrebujete Moodle spletišče';
$string['core.login.onboardingwelcome'] = 'Dobrodošli v Moodle aplikaciji';
$string['core.login.or'] = 'ALI';
$string['core.login.passwordrequired'] = 'Potrebno je geslo';
$string['core.login.recaptchachallengeimage'] = 'Slika reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Preverjanje je poteklo. Znova odgovorite na varnostno vprašanje.';
$string['core.login.recaptchaincorrect'] = 'Odgovor na varnostno vprašanje ni pravilen.';
$string['core.login.reconnect'] = 'Ponovno se povežite';
$string['core.login.reconnectssodescription'] = 'Vaš žeton za preverjanje pristnosti ni veljaven ali pa je potekel. Na spletno mesto se morate znova povezati in prijaviti v oknu brskalnika.';
$string['core.login.searchby'] = 'Išči po:';
$string['core.login.selectsite'] = 'Izberite svoje spletno mesto:';
$string['core.login.signupplugindisabled'] = '{{$a}} ni omogočen.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Obrazec za registracijo vsebuje zahtevano polje, ki ni podprto v aplikaciji. Vaš račun ustvarite z uporabo spletnega brskalnika.';
$string['core.login.siteaddress'] = 'Vaše spletišče';
$string['core.login.sitehasredirect'] = 'Vaše spletno mesto vsebuje vsaj eno preusmeritev HTTP. Aplikacija ne more slediti preusmeritvam. To lahko aplikaciji prepreči povezavo z vašim spletnim mestom.';
$string['core.login.siteinmaintenance'] = 'Vaše spletno mesto je v načinu vzdrževanja.';
$string['core.login.sitepolicynotagreederror'] = 'Nestrinjanje s politiko spletnega mesta.';
$string['core.login.siteurl'] = 'URL naslov spletnega mesta';
$string['core.login.siteurlrequired'] = 'Potreben je URL naslov spletnega mesta, tj. Http://www.yourmoodlesite.org </i>';
$string['core.login.stillcantconnect'] = 'Se še vedno ne morete povezati?';
$string['core.login.usernamerequired'] = 'Zahtevano je uporabniško ime';
$string['core.login.visitchangepassword'] = 'Ali želite obiskati spletno mesto, kjer lahko spremenite geslo?';
$string['core.login.webservicesnotenabled'] = 'Na vašem spletišču spletne storitve niso omogočene. Za pomoč se obrnite na vašega administratorja.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Še vedno se lahko povežete na spletišče z vnosom vašega uporabniškega imena in gesla.';
$string['core.login.yourenteredsite'] = 'Povežite se na vaše spletišče';
$string['core.lostconnection'] = 'Vaš žeton za preverjanje pristnosti ni veljaven ali pa je potekel. Na spletno mesto se boste morali znova povezati.';
$string['core.needhelp'] = 'Potrebujete pomoč?';
$string['core.networkerroriframemsg'] = 'Brez povezave na splet do te vsebine ni mogoče dostopati. Povežite se z internetom in poskusite znova.';
$string['core.networkerrormsg'] = 'Pri povezovanju s spletnim mestom je prišlo do težave. Preverite povezavo in poskusite znova.';
$string['core.nooptionavailable'] = 'Na voljo ni nobene možnosti';
$string['core.nopasswordchangeforced'] = 'Brez zamenjave gesla ne morete nadaljevati.';
$string['core.nopermissionerror'] = 'Trenutno žal nimate dovoljenj za to';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Ni poslano';
$string['core.nummore'] = 'Še {{$a}}';
$string['core.openfile'] = 'Odpri datoteko';
$string['core.openfullimage'] = 'Kliknite tukaj za prikaz slike v polni velikosti';
$string['core.openinbrowser'] = 'Odpri v brskalniku';
$string['core.openmodinbrowser'] = 'Odpri {{$a}} v brskalniku';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Za osvežitev podrsaj navzdol';
$string['core.qrscanner'] = 'QR čitalnik';
$string['core.question.cannotdeterminestatus'] = 'Stanja ni mogoče določiti';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Vaše spletišče še ne podpira pripenjanje datotek k odgovorom.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Vaše  spletišče še ne podpira urejanja vdelanih datotek.';
$string['core.question.errorquestionnotsupported'] = 'Aplikacija te vrste vprašanj ne podpira: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tapnite za izbiro datoteke in nato še enkrat, da jo spustite.';
$string['core.question.questionmessage'] = 'Vprašanje {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Preusmerjeni boste na spletno mesto.';
$string['core.removefiles'] = 'Odstrani datoteke {{$a}}';
$string['core.requireduserdatamissing'] = 'Uporabnik nima nekaterih zahtevanih podatkov o profilu. Vnesite podatke na svojem spletnem mestu in poskusite znova.<br>{{$a}}';
$string['core.retry'] = 'Ponovni poskus';
$string['core.scanqr'] = 'Prečitaj QR kodo';
$string['core.searching'] = 'Iskanje';
$string['core.settings.about'] = 'O';
$string['core.settings.appsettings'] = 'Nastavitve aplikacije';
$string['core.settings.appversion'] = 'Različica aplikacije';
$string['core.settings.cannotsyncloggedout'] = 'Tega spletišča ni mogoče sinhronizirati, ker ste odjavljeni. Poskusite znova, ko boste ponovno prijavljeni v spletišče.';
$string['core.settings.cannotsyncoffline'] = 'Sinhronizacija ni možna brez povezave na splet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Sinhronizacija ni mogoča, ker trenutne nastavitve omogočajo sinhronizacijo samo, ko ste povezani z Wi-Fi. Povežite se z omrežjem Wi-Fi.';
$string['core.settings.colorscheme'] = 'Barvna shema';
$string['core.settings.colorscheme-dark'] = 'Temno';
$string['core.settings.colorscheme-light'] = 'Svetlo';
$string['core.settings.compilationinfo'] = 'Informacije o kodnem prevodu';
$string['core.settings.copyinfo'] = 'Kopirajte podatke o napravi v odložišče';
$string['core.settings.cordovadevicemodel'] = 'Cordova model naprave';
$string['core.settings.cordovadeviceosversion'] = 'Cordova naprava verzija OS';
$string['core.settings.cordovadeviceplatform'] = 'Platforma Cordova';
$string['core.settings.cordovadeviceuuid'] = 'Cordova naprava UUID';
$string['core.settings.cordovaversion'] = 'Cordova verzija';
$string['core.settings.debugdisplaydescription'] = '';
$string['core.settings.deviceinfo'] = 'Informacije o napravi';
$string['core.settings.deviceos'] = 'OS naprava';
$string['core.settings.displayformat'] = 'Oblika prikaza';
$string['core.settings.enabledownloadsection'] = 'Omogoči prenose';
$string['core.settings.enablefirebaseanalytics'] = 'Omogoči analitiko Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Če je omogočeno, bo aplikacija zbirala uporabo anonimnih podatkov.';
$string['core.settings.enablerichtexteditor'] = 'Omogoči urejevalnik besedil';
$string['core.settings.enablerichtexteditordescription'] = 'Če je omogočeno, bo ob vnosu vsebine na voljo urejevalnik besedil.';
$string['core.settings.enablesyncwifi'] = 'Dovoli sinhronizacijo samo, ko je v omrežju Wi-Fi';
$string['core.settings.entriesincache'] = '{{$a}} vnosov v predpomnilnik';
$string['core.settings.errorsyncsite'] = 'Napaka pri sinhronizaciji podatkov spletnega mesta. Preverite internetno povezavo in poskusite znova.';
$string['core.settings.estimatedfreespace'] = 'Predvidena količina prostega prostora';
$string['core.settings.filesystemroot'] = 'Korenski datotečni sistem';
$string['core.settings.fontsize'] = 'Velikost besedila';
$string['core.settings.forcedsetting'] = 'To nastavitev je prisilila konfiguracija vašega spletnega mesta.';
$string['core.settings.localnotifavailable'] = 'Lokalna obvestila na voljo';
$string['core.settings.locationhref'] = 'Odpri spletni URL naslov';
$string['core.settings.navigatorlanguage'] = 'Navigacijski jezik';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Status internetne povezave';
$string['core.settings.opensourcelicenses'] = 'Odprto kodne licence';
$string['core.settings.privacypolicy'] = 'Politika zasebnosti';
$string['core.settings.publisher'] = 'Izdajatelj';
$string['core.settings.pushid'] = 'ID potisnih obvestil';
$string['core.settings.reportinbackground'] = 'Samodejno prijavi napake';
$string['core.settings.screen'] = 'Informacije o zaslonu';
$string['core.settings.showdownloadoptions'] = 'Pokaži možnosti prenosa';
$string['core.settings.siteinfo'] = 'Podatki o spletnem mestu';
$string['core.settings.spaceusage'] = 'Poraba prostora';
$string['core.settings.synchronization'] = 'Sinhronizacija';
$string['core.settings.synchronizenow'] = 'Sinhroniziraj zdaj';
$string['core.settings.synchronizenowhelp'] = 'S sinhronizacijo spletnega mesta bodo poslane vse spremembe in dejavnosti brez povezave na splet, ki so shranjene v napravi. Sinhronizirali se bodo tudi nekateri drugi podatki, kot so sporočila in obvestila.';
$string['core.settings.syncsettings'] = 'Nastavitve za sinhronizacijo';
$string['core.settings.wificonnection'] = 'Povezava Wi-Fi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Izberite račun, v katerega želite shraniti datoteko.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Datoteka s tem imenom že obstaja. Želite zamenjati obstoječo datoteko ali jo preimenovati v "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Spletna mesta niso shranjena. Pred skupno rabo datoteke z aplikacijo, dodajte spletno mesto.';
$string['core.sharedfiles.nosharedfiles'] = 'Na tem mestu ni shranjenih datotek v skupni rabi.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Tu ni nobenih datotek. Če želite naložiti datoteko iz druge aplikacije, poiščite datoteko in kliknite gumb »Odpri v«.';
$string['core.sharedfiles.rename'] = 'Preimenuj';
$string['core.sharedfiles.replace'] = 'Zamenjaj';
$string['core.sharedfiles.sharedfiles'] = 'Deljene datoteke';
$string['core.sharedfiles.successstorefile'] = 'Datoteka je uspešno shranjena. Izberite datoteko, ki jo želite naložiti v svoje zasebne datoteke ali uporabiti v dejavnosti.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Oprostite...';
$string['core.storingfiles'] = 'Shranjevanje datotek';
$string['core.tablet'] = 'Tablični računalnik';
$string['core.tag.errorareanotsupported'] = 'Aplikacija te oznake ne podpira.';
$string['core.tag.warningareasnotsupported'] = 'Nekate oznake niso prikazane, ker jih aplikacija ne podpira.';
$string['core.thereisdatatosync'] = 'Obstajajo brez povezave {{$a}}, ki jih je potrebno sinhronizirati.';
$string['core.tryagain'] = 'Poskusi ponovno';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ojoj!';
$string['core.unexpectederror'] = 'Nepričakovana napaka. Zaprite in znova odprite aplikacijo in poskusite znova.';
$string['core.unicodenotsupported'] = 'Nekateri smeškoti na tej strani niso podprti. Ko bo sporočilo poslano, bodo takšni znaki odstranjeni.';
$string['core.unicodenotsupportedcleanerror'] = 'Pri čiščenju znakov Unicode je bilo najdeno prazno besedilo.';
$string['core.unknown'] = 'Neznano';
$string['core.unzipping'] = 'Nestisnjeno';
$string['core.updaterequired'] = 'Potrebna je posodobitev aplikacije';
$string['core.updaterequireddesc'] = 'Posodobite aplikacijo na različico {{$a}}';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Podrobnosti tega uporabnika niso na voljo.';
$string['core.user.errorloaduser'] = 'Napaka pri nalaganju uporabnika.';
$string['core.user.sendemail'] = 'E-poštno sporočilo';
$string['core.viewcode'] = 'Prikaži kodo';
$string['core.vieweditor'] = 'Prikaži urejevalnik';
$string['core.viewembeddedcontent'] = 'Prikaži vdelano vsebino';
$string['core.warningofflinedatadeleted'] = 'Podatki brez povezave na splet od {{component}} \'{{name}}\' so bili izbrisani. {{error}}';
$string['core.whoissiteadmin'] = '"Administratorji spletišča" so ljudje, ki upravljajo Moodle na vaši šoli/univerzi/podjetju ali izobraževalni ustanovi. Če ne veste, kako vzpostaviti stik z njimi, se obrnite na vaše učitelje/vodje usposabljanja.';
$string['core.whyisthishappening'] = 'Zakaj se to dogaja?';
$string['core.wsfunctionnotavailable'] = 'Funkcija spletne storitve ni na voljo.';
$string['core.youreoffline'] = 'Ste brez povezave na splet';
$string['core.youreonline'] = 'Spet ste povezani';
$string['pluginname'] = 'Jezikovni nizi Moodle Mobile';
