<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'da', version '4.3'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Adgang afvist';
$string['accountlocked'] = 'Din konto er låst. Et link til at låse kontoen op er sendt via email.';
$string['accounts'] = 'Konti';
$string['accountunlocked'] = 'Din konto er låst op. Du kan logge ind igen.';
$string['addcategory'] = 'Tilføj en kategori';
$string['additionalhtml'] = 'Ekstra HTML';
$string['additionalhtml_desc'] = 'Disse indstillinger giver dig mulighed for at skrive HTML som du vil have føjet til hver side. Du kan skrive HTML der vil blive tilføjet i selve HEAD-tagget, umiddelbart efter BODY-tagget er åbnet, eller før det er lukket. <br />Herved kan du føje brugerdefinerede sidehoveder eller sidefødder til hver side eller nemt tilføje understøttelse af tjenester som Google Analytics uafhængigt af det valgte layout.';
$string['additionalhtml_heading'] = 'Yderligere HTML der skal tilføjes hver side.';
$string['additionalhtmlfooter'] = 'I bunden af body-tagget.';
$string['additionalhtmlfooter_desc'] = 'Indhold her vil blive tilføjet hver side i bunden af body-tagget.';
$string['additionalhtmlhead'] = 'I HEAD';
$string['additionalhtmlhead_desc'] = 'Indholdet her vil blive føjet til bunden af HEAD-tagget på hver side.';
$string['additionalhtmltopofbody'] = 'I toppen af body-tagget.';
$string['additionalhtmltopofbody_desc'] = 'Indhold her vil blive tilføjet alle sider straks efter åbning af body-tagget.';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Administratorer kan se alt';
$string['adminseesallevents'] = 'Administratorer kan se alle begivenheder';
$string['adminseesownevents'] = 'Administratorer er som andre brugere';
$string['advancedfeatures'] = 'Avancerede funktioner';
$string['agedigitalconsentverification'] = 'Verifikation af digital lavalder';
$string['agedigitalconsentverification_desc'] = 'Aktiverer verifikation af den digitale lavalder inden brugerne får vist siden til selvoprettelse af en ny konto. Det beskytter dit websted mod at mindreårige opretter konti uden deres forældres/værges samtykke. Samtidig vises <a target="_blank" href="{$a}">kontaktinformationer</a> til yderligere assistance.';
$string['ageofdigitalconsentmap'] = 'Digital lavalder';
$string['ageofdigitalconsentmap_desc'] = 'Den generelle digitale lavalder og alderen i lande hvor den adskiller sig fra standarden, kan angives her. Skriv hver alder på en ny linje i formatet: landekode, alder (adskilt af komma). Standardalderen indikeres af * på landekodens plads. Landekoder følger standarden i ISO 3366-2.';
$string['allcountrycodes'] = 'Alle landekoder';
$string['allowattachments'] = 'Tillad bilag';
$string['allowbeforeblock'] = 'Tilladt liste vil blive behandlet først';
$string['allowbeforeblockdesc'] = 'Som standard vil blokerede IP\'er matches først. Er indstillingen aktieret vil tilladte IP\'er håndteres inden de blokerede.';
$string['allowcategorythemes'] = 'Tillad kategorilayouts';
$string['allowcohortthemes'] = 'Tillad brugergruppelayouts';
$string['allowcoursethemes'] = 'Tillad kursuslayouts';
$string['allowedemaildomains'] = 'Tilladte e-maildomæner';
$string['allowediplist'] = 'Tilladt IP-liste';
$string['allowemailaddresses'] = 'Tilladte e-maildomæner';
$string['allowemojipicker'] = 'Emoji-vælger';
$string['allowframembedding'] = 'Tillad indlejring i frame';
$string['allowframembedding_help'] = 'Er indstillingen aktiveret, kan denne side indlejres i en "frame" på et eksternt system som anbefalet ved brug af tilmeldingsplugin\'et "Udgiv som LTI-værktøj". Elles anbefales det af sikkerhedsmæssige hensyn at lade indstillingen være deaktiveret. Bemærk også at indstillingen ignoreres i mobil-appen og indlejring i en frame tillades altid.';
$string['allowguestmymoodle'] = 'Tillad gæsteadgang til betjeningspanelet';
$string['allowindexing'] = 'Tillad søgemaskiner at indeksere sitet';
$string['allowindexing_desc'] = 'Her bestemmes om søgemaskiner må indeksere dit site. "Overalt" tillader indeksering af alle sider - også når tvungen login er aktiveret. Vil du undgå spam i forbindelse med indekseret tilmeldingsside skal du vælge  "Overalt bortset fra login- og tilmeldingssider". "Ingen steder" vil bede søgemaskiner om ikke at indeksere webstedet. Bemærk at dette blot er et tag i i koden i sidehovedet. Det er op søgemaskinerne at respektere tagget.';
$string['allowindexingeverywhere'] = 'Overalt';
$string['allowindexingexceptlogin'] = 'Overalt bortset fra login- og tilmeldingssider';
$string['allowindexingnowhere'] = 'Ingen steder';
$string['allowobjectembed'] = 'Tillad EMBED og OBJECT tags';
$string['allowthemechangeonurl'] = 'Tillad skift af layout i URL\'en';
$string['allowuserblockhiding'] = 'Tillad brugere at skjule blokke';
$string['allowusermailcharset'] = 'Tillad brugere at vælge tegnsæt';
$string['allowuserswitchrolestheycantassign'] = 'Tillad brugere uden beføjelse til at tildele roller, at skifte rolle.';
$string['allowuserthemes'] = 'Tillad brugerlayouts';
$string['alternativefullnameformat'] = 'Alternativt fulde navn-format';
$string['alternativefullnameformat_desc'] = 'Dette definerer, hvordan navne vises til brugere med beføjelsen "viewfullnames" (som standard brugere med rollen som administrator, lærer eller medunderviser). Pladsholdere der kan anvendes, er som for indstillingen "Fulde navn-format".';
$string['always'] = 'Altid';
$string['appearance'] = 'Udseende';
$string['aspellpath'] = 'Sti til aspell';
$string['authentication'] = 'Brugergodkendelse';
$string['authpreventaccountcreation'] = 'Undgå kontooprettelse under godkendelse';
$string['authpreventaccountcreation_help'] = 'Når en bruger godkendes, oprettes automatisk en konto på sitet hvis ikke den allerede eksisterer. Hvis en ekstern database som f.eks. LDAP, bruges til godkendelse, men du vil begrænse adgang til sitet til brugere med eksisterende konti, skal du aktivere denne indstilling. Nye konti skal oprettes manuelt eller via muligheden for at uploade brugere. Bemærk at denne indstilling ikke gælder MNet-godkendelse.';
$string['authsettings'] = 'Administrer godkendelse af brugere';
$string['autolang'] = 'Lad Moodle vælge sprog automatisk';
$string['autolangusercreation'] = 'Sæt brugerens browsersprog som det foretrukne sprog ved oprettelse af brugerkonto';
$string['autologinguests'] = 'Automatisk gæstelogin';
$string['availableto'] = 'Tilgængelig for';
$string['availabletoanyone'] = 'Tilgængeligt for alle der besøger websitet';
$string['availabletoauthenticated'] = 'Begrænset til godkendte brugere';
$string['backgroundcolour'] = 'Transparent farve';
$string['backup_shortname'] = 'Brug kursusnavn som backup-filnavn';
$string['backup_shortnamehelp'] = 'Anvender kursusnavn som en del af backup-filens navn.';
$string['backups'] = 'Backups';
$string['badwordsconfig'] = 'Angiv en liste med uønskede ord adskilt af komma.';
$string['badwordsdefault'] = 'Hvis denne liste er tom, så benyttes standardlisten fra oversættelsen.';
$string['badwordslist'] = 'Liste over uønskede ord';
$string['blockediplist'] = 'Blokeret IP-liste';
$string['blockinstances'] = 'Antal i brug';
$string['blockmultiple'] = 'Flere';
$string['blockprotect'] = 'Beskyt forekomster';
$string['blockprotect_help'] = 'Hvis du låser en bestemt type blok, vil det ikke være muligt for andre at tilføje eller slette forekomster af blokken. (Du kan selvfølgelig låse blokken op igen hvis du har brug for at redigere den).

Formålet med indstillingen er at beskytte blokke som "Navigation" og "Indstillinger" fra sletning, da blokkene kan være meget vanskelige at få genskabt.';
$string['blockprotectblock'] = 'Beskyt instanser af {$a}';
$string['blockprotected'] = '{$a} blok instanser er beskyttede.';
$string['blocksettings'] = 'Administrer blokke';
$string['blockunprotect'] = 'Fjern beskyttelse';
$string['blockunprotectblock'] = 'Fjern beskyttelse af instanser for {$a}';
$string['blockunprotected'] = '{$a} blok instanser er ikke beskyttede';
$string['bloglevel'] = 'Blogsynlighed';
$string['bookmarkadded'] = 'Bogmærke tilføjet';
$string['bookmarkalreadyexists'] = 'Du har allerede gemt et bogmærke til denne side.';
$string['bookmarkdeleted'] = 'Bogmærke slettet.';
$string['bookmarkthispage'] = 'Gem et bogmærke til denne side';
$string['cacheapplication'] = 'Application cache';
$string['cacheapplicationhelp'] = 'Chachede objekter er delt mellem brugere og udløber efter en fastlagt ttl. (time to live)';
$string['cachejs'] = 'Javascript-cache';
$string['cachejs_help'] = 'Caching af javascript og komprimering forbedrer i høj grad sidernes indlæsningstid og ydelse. Dette er stærkt anbefalet for sites i drift. Udviklere har måske behov for at deaktivere indstillingen.';
$string['cacherequest'] = 'Cache til forespørgsler';
$string['cacherequesthelp'] = 'Brugerspecifik cache som udløber når forespørgslen er færdig. Udviklet til at udskifte områder hvor vi bruger statiske lagre.';
$string['cachesession'] = 'Sessions-cache';
$string['cachesessionhelp'] = 'Brugerspecifik cache som udløber når en brugers session stopper. Udviklet for at undgå session bloat/strain.';
$string['cachesettings'] = 'Cache-indstillinger';
$string['cachetemplates'] = 'Cache skabeloner';
$string['cachetemplates_help'] = 'Cache af skabeloner vil forbedre indlæsning af sider og anbefales kraftigt på sider i drift. Udviklere vil formentlig deaktivere funktionen.';
$string['caching'] = 'Cacher';
$string['calendar_weekend'] = 'Weekenddage';
$string['calendarexportsalt'] = 'Eksporter kalender-"salt"';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertype';
$string['calendartype_desc'] = 'Vælg en standard kalendertype for hele sitet. Denne indstilling kan overskrives på kursusniveau eller af en enkelt bruger i sin personlige profil.';
$string['campaign'] = 'Kampagne';
$string['cannotdeletemodfilter'] = 'Du kan ikke afinstallere "{$a->filter}" fordi det er en del af modulet "{$a->module}".';
$string['cannotuninstall'] = '{$a} kan ikke afinstalleres.';
$string['categoryemail'] = 'E-mail';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot er forkert defineret i config.php. Tegnet "/" i slutningen skal fjernes.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot er forkert defineret i config.php. Den skal matche den URL du bruger til at tilgå denne side.';
$string['change'] = 'ret';
$string['checkboxno'] = 'Nej';
$string['checkboxyes'] = 'Ja';
$string['checkupgradepending'] = 'Opgrader';
$string['choosefiletoedit'] = 'Vælg fil der skal redigeres';
$string['cleanup'] = 'Oprydning';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'j';
$string['cliexitgraceful'] = 'Afslutter elegant, vent lidt ...';
$string['cliexitnow'] = 'Afslutter lige NU';
$string['cliincorrectvalueerror'] = 'Fejl, "{$a->value}" er en forkert værdi for "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Forkert værdi, prøv igen!';
$string['clistatusdisabled'] = 'Status: deaktiveret';
$string['clistatusenabled'] = 'Status: aktiveret';
$string['clistatusenabledlater'] = 'status: CLI\'s vedligeholdelsestilstand bliver aktiveret {$a}';
$string['clitypevalue'] = 'tast værdi';
$string['clitypevaluedefault'] = 'tast værdi, tryk på Enter for at bruge standardværdien ({$a})';
$string['cliunknowoption'] = 'Ukendte optioner:
{$a}
Brug optionen --help.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'For at rydde de resterende caches efter omstilling af brugertrafik til ny kode:

php admin/cli/purge_caches.php --muc
php admin/cli/purge_caches.php --js
php admin/cli/purge_caches.php --filter
php admin/cli/purge_caches.php --other

Du bør udføre disse cache-rydninger enkeltvis med en pause mellem kommandoerne for at reducere belastningsspidser på webserveren.';
$string['cliupgradedefault'] = 'Ny indstilling: {$a}';
$string['cliupgradedefaultheading'] = 'Sætter nye standardværdier';
$string['cliupgradedefaultverbose'] = 'Ny indstilling: {$a->name}, standardværdi: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Opgradering via kommandolinje fra {$a->oldversion} til {$a->newversion} fuldført.';
$string['cliupgrademaintenancenotrequired'] = 'Denne opgradering VIL IKKE resultere i vedligeholdelsestilstand for brugerne';
$string['cliupgrademaintenancerequired'] = 'Denne opgradering VIL resultere i en vedligeholdelsestilstand for brugerne';
$string['cliupgradenoneed'] = 'Det er ikke nødvendigt at opgradere den installerede version {$a}. Men tak fordi du kom forbi!';
$string['cliupgradepending'] = 'En opgradering venter';
$string['cliupgradesetlock'] = 'Upgradering er blevet låst til udelukkende udførelse af CLI';
$string['cliupgradeunsetlock'] = 'Den eksisterende lås til opgradering af CLI udførelse er blevet fjernet.';
$string['cliyesnoprompt'] = 'j (betyder ja) og n (betyder nej)';
$string['close'] = 'Luk';
$string['cohort_customfield'] = 'Brugerdefinerede felter for brugergruppe';
$string['commentsperpage'] = 'Antal kommentarer per side';
$string['commonactivitysettings'] = 'Almindelige indstillinger';
$string['commonfiltersettings'] = 'Almindelige filterindstillinger';
$string['commonsettings'] = 'Almindelige indstillinger';
$string['componentinstalled'] = 'Komponent installeret';
$string['computedfromlogs'] = 'Beregnet ud fra logs siden {$a}.';
$string['condifmodeditdefaults'] = 'Standardværdier bruges i indstillingsformularen når du opreetter en ny aktivitet eller et nyt materiale.';
$string['confeditorhidebuttons'] = 'Vælg de knapper der skal skjules i HTML-editoren.';
$string['configallcountrycodes'] = 'Dette er listen over lande, der kan vælges i for eksempel en brugers profil. Hvis den er tom (standard) vil listen i countries.php i den engelske standardsprogpakke blive brugt. Det er listen fra ISO 3166-1. Ellers kan du angive en kommasepareret liste af koder, for eksempel "GB, FR, ES". Hvis du tilføjer nye, ikke-standard koder her, vil du være nødt til at tilføje dem til countries.php i både den engelske, den danske og evt. andre brugte sprogpakker.';
$string['configallowassign'] = 'For hver rolle i venstre kolonne skal du vælge, hvilke roller de kan tildele andre.';
$string['configallowattachments'] = 'Er indstillingen aktiveret, kan e-mails sendt fra sitet have bilag som f.eks badges.';
$string['configallowcategorythemes'] = 'Aktiverer du dette kan der vælges layout på kategoriniveau. Det vil påvirke alle underliggende kategorier og kurser, der ikke har specificeret deres eget layout. ADVARSEL: Aktivering af kategorilayouts kan påvirke ydelsen.';
$string['configallowcohortthemes'] = 'Aktiverer du dette kan der vælges layout på brugergruppeniveau. Det vil påvirke alle brugere med kun en brugergruppe eller flere men med samme layout.';
$string['configallowcoursethemes'] = 'Er indstillingen aktiveret, kan kurser vælge deres eget layout. Kursuslayoutet bliver brugt uanset hvad der ellers er valgt som layout (sitewide, bruger, kategori, brugergrupper eller URL-valgte layouts).';
$string['configallowedemaildomains'] = 'Liste over maildomæner der må bruges som afsender i "Fra"-feltet på udgående mail. Er feltet tomt vil noreply-adressen blive brugt. Jokertegn kan bruges, f.eks. vil *.eksempel.dk tillade alle mails fra subdomæner under eksempel.dk, men ikke fra eksempel.dk, som vil kræve sin egen post.';
$string['configallowemailaddresses'] = 'Hvis du vil at begrænse nye mailadresser til bestemte domæner, så skriv dem her adskilt af mellemrum. Mails fra alle andre domæner vil blive afvist. Tillad subdomæner ved at tilføje dem med et foranstillet ".". Accepterer du både et domæne og dets subdomæner, skal du skrive dem to gange, én gang med et foranstillet "." og en gang uden, for eksempel .skole.eksempel.dk og skole.eksempel.dk.';
$string['configallowemojipicker'] = 'Med emojivælgeren kan brugerne tilføje smilies og andre emojis til en tekst via emojivælgerknappen i Attos værktøjslinje.';
$string['configallowemojipickerincompatible'] = 'Din databasekonfiguration understøtter ikke emojis fuldt ud. For at aktivere emojivælgeren skal du <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">upgrade your database for full unicode support</a>.';
$string['configallowguestmymoodle'] = 'Er indstillingen aktiveret, er betjeningspanelet tilgængeligt for gæster, ellers omdirigeres de til Moodles forside.';
$string['configallowobjectembed'] = 'Af sikkerhedsgrunde kan almindelige brugere normalt ikke indlejre multimediefiler (som flash) vha. EMBED- og OBJECT-tags i deres HTML (det kan dog gøres sikkert vha. multimedie-plugin-filtre). Hvis du ønsker at tillade disse tags så aktiver denne indstilling.';
$string['configallowoverride'] = 'Tillad brugere med rollerne til venstre at overskrive rollerne i hver kolonne.';
$string['configallowoverride2'] = 'For hver rolle i venstre kolonne skal du vælge, hvilke roller de kan angive tilsidesættelser for.<br />Brugere skal også have enten beføjelsen moodle/role:override eller moodle/role:safeoverride.';
$string['configallowswitch'] = 'For hver rolle i venstre kolonne skal du vælge, hvilke roller de kan skifte til.<br />Brugere skal også have beføjelsen moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Hvis indstillingen er aktiveret, kan layoutet ændres ved at tilføje enten<br />?theme=layoutnavn eller <br />&theme=layoutnavn (hvis ? allerede bruges i URL\'en) <br />til enhver Moodle-URL (f.eks.: domæne.dk/course/view.php?id=2&theme=classic).';
$string['configallowuserblockhiding'] = 'Skal brugere kunne maksimere eller minimere blokke på webstedet? Denne funktion bruger javascript og cookies for at huske tilstanden af hver blok der kan minimeres, og påvirker kun hvordan brugeren ser siden.';
$string['configallowusermailcharset'] = 'Ved at aktivere dette, vil hver bruger være i stand til at vælge sit tegnsæt til brug i e-mail til sig selv fra Moodle.';
$string['configallowuserswitchrolestheycantassign'] = 'Som standard kræves moodle/role:assign hvis brugere skal kunne skifte rolle. Hvis indstillingen aktiveres fjernes dette krav og rullemenuen "Skift rolle til" vil indeholde de roller der alene bestemmes af indstillingerne i tabellen "Tillad rolletildeling".
Det anbefales at indstillingerne i tabellen "Tillad rolletildeling" ikke gør det muligt for brugere at skifte til en rolle der giver dem flere beføjelser end de har i kraft af deres eksisterende rolle.';
$string['configallowuserthemes'] = 'Hvis du tillader dette kan brugerne selv vælge hvilket layout de vil bruge. Brugerlayoutet bliver brugt selvom der er valgt et andet på sitet (dog ikke hvis der er valgt et andet layout på kurset).';
$string['configallowview'] = 'For hver rolle i venstre kolonne skal du vælge, hvilke roller de kan se, søge og filtrere efter.';
$string['configallusersaresitestudents'] = 'Skal alle brugere ses som deltagere i aktiviteter på forsiden? Hvis du svarer "ja" så vil enhver bruger have mulighed for at deltage i disse aktiviteter. Hvis du svarer "nej", vil kun brugere der allerede deltager i mindst ét kursus, kunne deltage i aktiviteter på forsiden. Kun administratorer og lærere specifikt tilknyttet aktiviteten kan fungere som lærere for disse forsideaktiviteter.';
$string['configauthenticationplugins'] = 'Vælg de godkendelses-plugins du vil bruge og arranger dem i "failthrough"-orden.';
$string['configautolang'] = 'Brug browserens sprogindstilling, hvis ikke der er valgt standardsprog for webstedet.';
$string['configautolangusercreation'] = 'Er indstillingen aktiveret når en brugers konto oprettes automatisk ved første login (f.eks. ved hjælp af LDAP- eller OAuth 2-godkendelse), angives brugerens browsersprog som det foretrukne sprog. Ellers angives standardsproget for webstedet som brugerens foretrukne sprog.';
$string['configautologinguests'] = 'Skal besøgene automatisk logges ind som gæster hvis de besøger et kursus med gæsteadgang?';
$string['configbloglevel'] = 'Med denne indstilling kan du begrænse fra hvilket niveau brugernes blogge kan ses på dette websted. Bemærk at der er tale om den maximale kontekst for LÆSEREN, ikke forfatteren eller typer af blogindlæg. Blogge kan også deaktiveres helt hvis dét er meningen.';
$string['configcalendarcustomexport'] = 'Aktiver tilpasset datointerval-eksport af kalender';
$string['configcalendarexportsalt'] = 'Denne vilkårlige tekst bliver brugt til at gøre godkendelsestokens mere sikre når du eksporterer kalendere. Vær opmærksom på at alle aktuelle tokens vil blive ugyldige hvis du ændrer denne \'hash salt\'.';
$string['configcookiesecure'] = 'Hvis serveren kun accepterer https-forbindelser, anbefales det at aktivere sikre cookies. Hvis aktiveret bør du sikre at webserveren ikke accepterer http:// eller er sat op til permanent at viderestille til https://. Når <em>wwwroot</em>-adressen ikke starter med https:// ignoreres denne indstilling.';
$string['configcountry'] = 'Hvis du har valgt et land her, vil det blive valgt som standard for nye brugeroprettelser. Tving en bruger til at vælge land ved at lade dette felt være tomt.';
$string['configcoursegraceperiodafter'] = 'Klassificer tidligere kurser som i gang i dette antal dage efter kursets slutdato.';
$string['configcoursegraceperiodbefore'] = 'Klassificer fremtidige kurser som i gang i dette antal dage inden kursets startdato.';
$string['configcourseoverviewfilesext'] = 'En komma-separeret liste med tilladte billedfiltyper i kursusbeskrivelser.';
$string['configcourseoverviewfileslimit'] = 'Det antal filer der maksimalt kan vises sammen med kursusbeskrivelsen på siden med kursuslisten. Første billedfil bruges som kursusbillede i kursusoversigten på brugernes betjeningspanel, de øvrige filer vises kun i kursuslisten.';
$string['configcourserequestnotify'] = 'Skriv brugernavn på den person der skal underrettes når der anmodes om et nyt kursus.';
$string['configcourserequestnotify2'] = 'Brugere der vil blive underrettet når der anmodes om et nyt kursus. Her listes kun brugere som må godkende kursusønsker.';
$string['configcoursesperpage'] = 'Skriv hvor mange kurser der kan vises pr. side i en kursusliste.';
$string['configcourseswithsummarieslimit'] = 'Det maksimale antal kurser der vises i en kursusoversigt med beskrivelser, før der vises færre oplysninger.';
$string['configcronclionly'] = 'Kørsel af cron fra en webbrowser kan afsløre fortrolig information til anonyme brugere. Det anbefales derfor kun at køre cron fra kommandolinjen eller angive en cronadgangskode til fjernadgang.';
$string['configcronremotepassword'] = 'Det betyder at cron.php ikke kan køres fra en webbrowser uden at angive en kode som en del af URL\'en på denne måde: <pre> https://site.minskole.dk/admin/cron.php?password=SesamLukDigOp </pre>Er feltet tomt kræves ingen kode.';
$string['configcurlcache'] = 'Time-to-live for cURL cache i sekunder.';
$string['configcustommenuitems'] = 'En brugerdefineret menu kan konfigureres her. Indtast hvert menupunkt på en ny linje med formatet: menutekst, en link-URL (valgfrit, ikke for et topmenupunkt med underpunkter), en tooltip-titel (valgfrit) og en sprogkode eller en kommasepareret liste af koder (valgfrit, for kun at vise linjen til brugere med det angivne sprog), adskilt af pipe-tegn. Linjer, der starter med en bindestreg, vises som menupunkter i den foregående topniveaumenu, og #### udgør en skillelinje. Eksempel:
<pre>
Kurser
-Alle kurser|/course/
-Søg kursus|/course/search.php
-###
-OSS/FAQ|https://domæne.tld/oss|Ofte stillede spørgsmål
-Preguntas más frecuentes|https://example.org/pmf||es
Mobile app|https://domæne.tld/app|Download vores app
</pre>';
$string['configcustomusermenuitems'] = 'Du kan konfigurere indholdet af brugermenuen (med undtagelse af log ud-linket, som automatisk tilføjes). Hver linje er opdelt med "|"-tegn og består af 1) en tekst i formen "sprogstrengsnavn, sprogkomponentnavn" (dvs. identifikation af en tekststreng i sprogpakken) eller som uformateret tekst, og 2) en URL. Punkterne kan grupperes ved at tilføje en linje med et eller flere #-tegn.';
$string['configdbsessions'] = 'Aktiveres denne indstilling vil information om aktuelle sessioner gemmes i databasen. Bemærk at alle logges ud - også dig selv - hvis du ændrer indstillingen nu. Bruger du MySQL, bør du sikre at \'max_allowed_packet\' i my.cnf (eller my.ini) står til mindst 4M. Andre sessionsdrivere kan konfigureres direkte i config.php, se yderligere info på siden config-dist.php. Denne mulighed forsvinder herfra hvis du specificerer sessionsdriver i config.php.';
$string['configdebug'] = 'Denne indstilling forårsager at PHP\'s fejlrapportering vil vise advarsler som fejl. Dette er hovedsaglig en indstilling til brug for udviklere.';
$string['configdebugdisplay'] = 'Slået til, vil fejlrapportering gå til html-siden. Dette er praktisk, men ødelægger xhtml, js, cookies og http-header. Deaktiveret vil det sende output til din serverlog, og gøre debugging lettere. Php-indstillingen error_log kontrol, styrer hvor der logges.';
$string['configdebugpageinfo'] = 'Aktiver, hvis du ønsker sideinformation vist i sidefoden.';
$string['configdebugvalidators'] = 'Aktiver denne hvis du vil have links til eksterne godkendelsesservere i sidefoden. Du skal måske oprette en ny bruger med brugernavnet <em>w3cvalidator</em>, og tillade gæsteadgang. Disse ændringer kan muliggøre uautoriseret adgang til serveren, brug ikke muligheden på servere i produktion.';
$string['configdefaulthomepage'] = 'Hvilken side skal brugerne omdirigeres til efter at være logget ind? Indstillingen bestemmer også det første link i navigationen for brugere af Classic-baserede layouts.';
$string['configdefaultrequestcategory'] = 'Kurser efterspurgt af brugere med beføjelse til at efterspørge kurser på systemniveau, placeres i denne kategori hvis ikke de kan vælge en anden kategori.';
$string['configdefaultrequestedcategory'] = 'Hvilken kategori skal nye kurser som standard tilhøre når de bliver godkendt?';
$string['configdefaultuserroleid'] = 'Alle der er logget ind, vil få denne rolles beføjelser på webstedsniveau OVENI de andre roller de måtte have. Standardrollen er "Godkendt bruger". Bemærk at dette ikke konflikter med deres andre roller med mindre du forbyder nogle beføjelser, det sikrer bare at alle har beføjelser der ikke kan tildeles på kursusniveau (som at læse i fora, skrive blogindlæg, skrive i egen kalender mv.)';
$string['configdeleteincompleteusers'] = 'Efter denne periode vil brugerkonti uden fornavn, efternavn eller e-mail, blive slettet.';
$string['configdeleteunconfirmed'] = 'Ved visse godkendelsesmetoder, såsom mailbaseret selvregistrering, skal brugerne bekræfte deres konto indenfor en vis tid. Efter denne frist slettes alle ubekræftede konti.';
$string['configdenyemailaddresses'] = 'For at forbyde e-mailadresser fra visse domæner kan de skrives her. Alle andre domæner accepteres. For at forbyde Hotmail- og Yahooadresser kan f.eks. skrives <strong>hotmail.com yahoo.com</strong>';
$string['configdisableuserimages'] = 'Stop brugernes tilladelse til at ændre billede i deres profil.';
$string['configdisplayloginfailures'] = 'Dette vil vise information til brugere om tidligere mislykkede forsøg på login.';
$string['configdndallowtextandlinks'] = 'Aktiver eller deaktiver træk og slip af tekst og links på en kursusside på samme måde som træk og slip af filer. Bemærk, at trække tekst i Firefox eller mellem andre browsere er upålidelig og kan resultere i at ingen data bliver uploadet, eller at beskadiget tekst bliver uploadet.';
$string['configdoclang'] = 'Dette sprog vil blive brugt i links til dokumentationssider.';
$string['configdocroot'] = 'Definerer stien til Moodle Docs for at give kontekst-specifik dokumentation via links til "Hjælp og dokumentation" i bunden af hver side. Hvis feltet er tomt, vil links ikke blive vist.';
$string['configdoctonewwindow'] = 'er indstillingen aktiveret, vil links til Moodle Docs blive vist i et nyt vindue.';
$string['configduration_high'] = 'Værdien er for høj. Den maksimale værdi er {$a}.';
$string['configduration_low'] = 'Værdien er for lav. Den minimaleværdi er {$a}.';
$string['configeditordictionary'] = 'Denne værdi bruges hvis aspell ikke har en ordbog på brugerens eget sprog.';
$string['configeditorfontlist'] = 'Vælg de skrifttyper der skal vises i HTML-editorens rullemenu.';
$string['configemailchangeconfirmation'] = 'Kræver en e-mailgodkendelse når brugerne ændrer e-mailadressen i deres profil.';
$string['configemaildkimselector'] = 'DKIM-vælgeren er vilkårlig, og dine DNS-resultater skal svare hertil.';
$string['configemailfromvia'] = 'Tilføj via-information i "Fra"-sektionen af udgående mails. Det fortæller modtageren hvor mailen kommer fra og hjælper med at forhindre at man kommer til at svare på en mail der ikke kan besvares (noreply).';
$string['configemailheaders'] = 'Rå mail-overskrifter, der skal føjes ordret til alle udgående mail.';
$string['configemailsubjectprefix'] = 'Tekst der skal bruges som præfiks i emnefeltet på udgående mail.';
$string['configenableanalytics'] = 'Analysemodeller såsom "Studerende i fare for at droppe ud" eller "Kommende forestående aktiviteter", kan generere forudsigelser, sende underretninger med indsigter og tilbyde yderligere handlinger såsom at sende besked til brugere.';
$string['configenableblogs'] = 'Denne indstilling giver alle webstedets brugere deres egen blog.';
$string['configenablecalendarexport'] = 'Aktiver export eller abonnement på kalendere.';
$string['configenablecomments'] = 'Aktiver kommentarer';
$string['configenablecourserequests'] = 'Er indstillingen aktiveret, vil brugere med beføjelse til at efterspørge nye kurser (moodle/course:request) kunne efterspørge et kursus. Ingen standardrolle har  denne beføjelse. Den kan tilføjes på system- eller kategoriniveau.';
$string['configenabledevicedetection'] = 'Aktiverer detektion af mobiler, smartphones, tabletter eller standardenheder (stationære pc\'er, bærbare computere, osv) for anvendelse af layoutskabeloner og andre funktioner.';
$string['configenablemobilewebservice'] = 'Aktiver mobiltjeneste til den officielle Moodle-app eller andre apps der efterspørger den. For mere information, læs {$a}';
$string['configenablerssfeeds'] = 'Er indstillingen aktiveret, bliver rss-feeds genereret af forskellige funktioner på tværs af webstedet, såsom blogs, fora, databaseaktiviteter og ordlister. Bemærk, at rss-feeds også skal være aktiveret for det pågældende aktivitesmodul.';
$string['configenablerssfeedsdisabled'] = 'Dette er ikke muligt fordi RSS-feed er deaktiveret for hele sitet. Det skal først aktiveres under indstilling af variabler på administrationssiden.';
$string['configenablerssfeedsdisabled2'] = 'Rss er deaktiveret på serverniveau. Funktionen kan aktiveres under Siteadministration → Avancerede funktioner.';
$string['configenablestats'] = 'Hvis du vælger "ja" her, vil Moodles cronjob behandle og indsamle statistik. Afhængig af mængden af trafik til dit websted kan dette tage et stykke tid. Hvis du aktiverer denne funktion, kan du se grafer og statistik om hvert kursus eller for hele webstedet.';
$string['configenabletrusttext'] = 'Som standard vil Moodle altid rense tekst fra brugerne for at fjerne potentielt farlige scripts, media mv., som kan udgøre en sikkerhedsrisiko. Dette "Trusted Content"-system er en metode til at give specielt betroede brugere mulighed for at inkludere disse avancerede features i deres indhold uden indblanding. Vil du aktivere dette system skal du først aktivere denne indstilling og derpå give en specifik rolle tilladelse til "the Trusted Content". Tekster fra denne bruger vil blive mærket som ok og vil ikke blive renset inden de vises.';
$string['configenablewebservices'] = 'Webservices muliggør at andre systemer som fx Moodles app, vil kunne logge på denne Moodle og udføre operationer. For at opnå ekstra sikkerhed skal denne funktion deaktiveres medmindre du faktisk bruger den med appen eller en ekstern service/værktøj der bruger integration via webservice.';
$string['configenablewsdocumentation'] = 'Aktiver auto-generering af webservices-dokumentation. En bruger kan få adgang til sin egen dokumentation på hans sikkerhedsnøgleside {$a}. Der vises kun dokumentation for de aktiverede protokoller.';
$string['configerrorlevel'] = 'Vælg hvor meget der skal til for at vise en PHP-advarsel. "Normal" er typisk det bedste valg.';
$string['configexportlookahead'] = 'Dage at se fremad under eksport';
$string['configexportlookback'] = 'Dage at se tilbage under eksport';
$string['configextendedusernamechars'] = 'Er indstillingen aktiveret, kan brugere at benytte alle tegn bortset fra store bogstaver i deres brugernavn. Ellers kan brugernavne kun indeholde tal, små bogstaver, understregning (_), bindestreg (-), punktum (.) og at-symbol (@).';
$string['configextramemorylimit'] = 'Visse scripts såsom søgning, backup/gendan eller cron, kræver større hukommelse. Angiv højere værdi for store sites.';
$string['configfilterall'] = 'Filtrer alle strenge, inklusiv overskrifter, titler, navigationslinje og så videre. Det kan især være hensigtsmæssigt når man bruger et flersproget filter, ellers vil det blot belaste sitet mere uden væsentlig gavn.';
$string['configfiltermatchoneperpage'] = 'Automatiske linkfiltre vil kun generere et enkelt link til den første forekomst af ord der matcher i teksten på siden. Flere match vil de blive ignoreret.';
$string['configfiltermatchonepertext'] = 'Automatisk linkfilter vil kun generere et link for første ord der matcher filtret i hver tekstblok på siden. Hvis der er flere forekomster vil disse blive ignoreret. Denne indstilling vil blive ignoreret hvis "Filtrer en forekomst per side" er aktiveret.';
$string['configfilternavigationwithsystemcontext'] = 'Normal brug af filtreringen er bundet til den kontekst, hvori den bruges (f.eks. kursuskontekst), men for stednavigationen kan det give forbedringer i ydeevnen, hvis alt filtreres eksplicit med stedkontekst, når der bruges filtrering af "indhold og overskrifter".';
$string['configfilteruploadedfiles'] = 'Denne indstilling forårsager at Moodle sender alle uploadede HTML- og tekstfiler igennem et evt. filter før de bliver vist.';
$string['configforcelogin'] = 'Normalt kan forsiden af webstedet og kursuslister (men ikke kurser) læses uden at folk logger sig ind. Hvis du ønsker at folk skal logge ind før de kan gøre noget som helst på webstedet, skal du aktivere denne indstilling.';
$string['configforceloginforprofiles'] = 'Denne indstilling tvinger folk til at logge ind som registrerede brugere (ikke gæster) før de kan se andre brugeres profiler. Deaktiverer du indstillingen kan det ske, at nogle brugere lægger reklame (spam) eller andet upassende indhold i deres profil, som derefter er synlig for hele verden. ';
$string['configfrontpage'] = 'De her valgte elementer vil blive vist på webstedets forside.';
$string['configfrontpagecourselimit'] = 'Maksimalt antal kurser';
$string['configfrontpagecourselimithelp'] = 'Maksimalt antal kurser, der skal vises på webstedets forside i kursusoversigten.';
$string['configfrontpageloggedin'] = 'De her valgte elementer vil blive vist på sitets forside for brugere, der er logget ind.';
$string['configfullnamedisplay'] = 'Dette definerer, hvordan navne vises, når de vises i deres fulde længde. Standardværdien, "language", overlader det til strengen "fullnamedisplay" i den aktuelle sprogpakke. Nogle sprog har forskellige konventioner for navnevisning.

For de fleste etsprogede websteder er det mest almindelige "fornavn efternavn", men du kan vælge at skjule efternavne helt. Pladsholdere der kan anvendes, er: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename og alternatename.';
$string['configgeoipfile'] = 'Placering af GeoLite2 Citys binære datafil. Denne fil er ikke en del af Moodledistributionen og skal hentes særskilt fra <a href="https://www.maxmind.com/">MaxMind</a>. Du kan enten købe en kommerciel version eller bruge den gratis version. Du skal registrere dig for at hente databasenfilen. Det kan du gøre på siden<a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Når du har registreret dig og hentet pakken, skal den pakkes ud i mappen "{$a}" på din server.';
$string['configgetremoteaddrconf'] = 'Hvis din server er bag en reverse proxy, kan du bruge denne indstilling til at angive hvilke HTTP-headers det kan betros at indeholde den eksterne IP-adresse. Headerne læses i rækkefølge ved brug af den først tilgængelige.';
$string['configgradebookroles'] = 'Denne indstilling gør det muligt at kontrollere hvem der kan ses i karakterbogen. Brugere bliver nødt til at have mindst een af disse roller på et kursus for at blive vist i karakterbogen på kurset.';
$string['configgradeexport'] = 'Vælg hvilke eksportformater til karakterbogen du foretrækker til eksport af karakterer. Udvalgte plugins vil derefter indstille og bruge et "sidst eksporteret"-felt for hver karakter. For eksempel kan dette resultere i at eksporterede poster bliver identificeret som værende "nye" eller "opdateret". Marker ingen, hvis ikke du er sikker.';
$string['confighiddenuserfields'] = 'Vælg hvilke brugerinformationsfelter du ønsker at skjule fra andre brugere end lærere og kursusadministratorer. Dette vil give øget beskyttelse af de studerendes privatliv. Vælg flere felter ved at holde CTRL nede.';
$string['configidnumber'] = 'Denne indstilling angiver: <br /> (a) Brugere bliver ikke spurgt om et ID-nummer. (b) Brugere kan angive et ID-nummer men kan også lade være. (c) Brugere skal angive et ID-nummer. Hvis brugeren har skrevet et ID-nummer bliver det vist i deres profil.';
$string['configintro'] = 'På denne side kan du specificere et antal konfigurationsvariable for at hjælpe Moodle med at fungere tilfredsstillende på din server. Som regel fungerer standardværdierne fint og du kan altid ændre på dem senere.';
$string['configintroadmin'] = 'På denne side skal du konfigurere din hovedadministratorkonto som har fuld kontrol over hele webstedet. Vær sikker på at bruge et sikkert brugernavn og adgangskode samt en gyldig e-mailadresse. Du kan oprette flere administratorkonti senere.';
$string['configintrosite'] = 'På denne side kan du konfigurere forsiden og navnet på webstedet. Du kan altid vende tilbage hertil og ændre disse indstillinger ved at bruge \'Forside\'-linket på administratormenuen.';
$string['configiplookup'] = 'Når du klikker på en IP-adresse (f.eks. 34.12.222.93) som i loggen, vises et kort med et bud på hvor IP\'en kommer fra. Du kan vælge mellem forskellige plugins hertil, hver har de deres fordele og ulemper.';
$string['configkeeptagnamecase'] = 'Marker dette hvis du ønsker at tags beholder den oprindeligt indtastede brug af små og store bogstaver';
$string['configlang'] = 'Vælg et standardsprog for hele webstedet. Brugere kan vælge alternative sprog i deres profilindstillinger senere.';
$string['configlanglist'] = 'Er dette felt tomt, kan brugeren vælge mellem alle tilgængelige sprog i Moodle. Alternativt kan du angive hvilke sprog brugerne skal kunne vælge imellem. Det gøres ved at liste sprogkoderne for de mulige sprog adskilt af kommaer som for eksempel: da,en,fr. Du kan også angive et andet navn for et sprog ved at bruge formatet: sprogkode|sprognavn, for eksempel da_rum|Dansk,de_kids|Deutsch.';
$string['configlangmenu'] = 'Vælg om der skal vises en sprogmenu på forsiden, loginsiden osv. Dette påvirker ikke brugerens mulighed for at vælge et sprog tilknyttet deres egen profil.';
$string['configlangstringcache'] = 'Cacher alle sprogstrenge i kompilerede filer i datamappen. Hvis du oversætter Moodle eller ændre sprogstrenge i Moodles kildekode vil du nok deaktivere denne indstilling. Ellers kan du med fordel lade den være aktiveret af ydelseshensyn.';
$string['configlatinexcelexport'] = 'Vælg tegnkodning til Excel-eksport.';
$string['configlocale'] = 'Lokalindstillinger for dit websted - de vil blive brugt som format og sprog for datoer uanset valgt sprogpakke (dagenes navne påvirkes dog ikke). Du skal have disse lokaldata installeret på dit operativsystem (f.eks. for Linux en_US.UTF-8 or da_DK.UTF-8). Som regel skal feltet ikke udfyldes.';
$string['configlockrequestcategory'] = 'Er indstillingen aktiveret, vil brugere med beføjelse til at efterspørge nye kurser på systemniveau, ikke kunne vælge en kategori til dem. En anden måde at begrænse brugeres kursusefterspørgsel på i kun en kategori er, at tilføje beføjelsen i kategorikonteksten.';
$string['configloglifetime'] = 'Dette angiver hvor lang tid du ønsker at gemme logfiler med brugeraktiviteter. Logs der er ældre end her angivet, bliver automatisk slettet. Det er bedst at gemme logfilerne så længe du kan, i tilfælde af at du får brug for dem. Hvis du har en meget belastet server eller har problemer med ydeevnen, så kan du prøve at sætte levetiden for logfilerne ned. Værdier lavere end 30 kan ikke anbefales, da statistikken i så fald ikke kan arbejde tilfredsstillende.';
$string['configlookahead'] = 'Kommende begivenheder næste antal dage:';
$string['configmailnewline'] = 'Ny linje-tegn brugt i mails. CRLF kræves i henhold til RFC 822bis. Nogle mailservere konverterer automatisk fra LF til CRLF, andre konverterer fejlagtigt fra CRLF til CRCRLF, andre igen afviser mails med LF (f.eks. qmail). Prøv at ændre denne indstilling hvis du har problemer med ikke leverede mails eller med dobbelte nye linjer.';
$string['configmaxbytes'] = 'Dette angiver hvor store filer der kan uploades til webstedet. Indstillingen er begrænset af PHP-indstillingerne "post_max_size" og "upload_max_filesize" samt af Apache-indstillingen "LimitRequestBody". Værdien begrænser hvor store værdier der kan vælges på kursus- og modulniveau. Hvis serverens grænse er valgt, vil webserverens maksimumsgrænse blive brugt.';
$string['configmaxconsecutiveidentchars'] = 'Adgangskoder må ikke have mere end dette antal på hinanden følgende ens tegn. Brug 0 for at deaktivere denne kontrol.';
$string['configmaxeditingtime'] = 'Angiver hvor lang tid brugerne har til rette deres indlæg i et forum, et komentarfelt mv. Normalt er 30 minutter en god værdi.';
$string['configmaxevents'] = 'Max. antal "Kommende begivenheder"?';
$string['configmaxusersperpage'] = 'Maksimalt antal brugere der vises i brugervælgeren i kursus, gruppe, brugergruppe, webservice osv.';
$string['configmessaging'] = 'Er indstillingen aktiveret, kan brugere sende beskeder til hinanden på sitet.';
$string['configmessagingallowemailoverride'] = 'Tillad brugere at få e-mailmeddelelser, der sendes til en anden end e-mailadressen i deres profil';
$string['configmessagingallusers'] = 'Er indstillingen aktiveret, kan brugerne se en liste over samtlige brugere når de skal vælge en at skrive til, og i  beskedindstillingerne har de mulighed for at acceptere beskeder fra alle på sitet. Er indstillingen deaktiveret, kan brugerne kun se en liste over deres medstuderende, og de har kun to muligheder i beskedindstillingerne - kun at acceptere beskeder fra deres kontaktliste eller fra alle medstuderende på deres kurser.';
$string['configmessagingdefaultpressenter'] = 'Hvorvidt "Send ved at trykke på Enter" som standard er aktieret i brugernes beskedindstillinger.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Læste og ulæste underretninger kan blive slettet for at spare plads. Hvor gamle skal underretninger være før de slettes?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Læste notifikationer kan blive slettet for at spare plads. Hvor længe skal der gå efter en notifikation er læst, før den slettes?';
$string['configminpassworddigits'] = 'Adgangskoder skal have mindst dette antal tal.';
$string['configminpasswordlength'] = 'Adgangskoder skal mindst have dette antal tegn.';
$string['configminpasswordlower'] = 'Adgangskoder skal mindst have dette antal små bogstaver.';
$string['configminpasswordnonalphanum'] = 'Adgangskoder skal have mindst dette antal ikke-alfanumeriske tegn.';
$string['configminpasswordupper'] = 'Adgangskoder skal have mindst dette antal store bogstaver.';
$string['configmycoursesperpage'] = 'Det maksimale antal kurser der vises på en brugers liste over egne kurser.';
$string['configmymoodleredirect'] = 'Denne indstilling sender ikke-admins til /my, når de logges ind og erstatter topelementet i brødkrummelinkene til /my';
$string['configmypagelocked'] = 'Denne indstilling forhindrer standardsiden bliver redigeret af eventuelle ikke-administratorer';
$string['confignavcourselimit'] = 'Begrænser hvor mange kurser der vises i navigationen.';
$string['confignavshowallcourses'] = 'Indstillingen styrer om brugere der er tilmeldt kurser, kan se hele kursuslisten i navigationen foruden listen over egne kurser.';
$string['confignavshowcategories'] = 'Vis kursuskategorier i navigationslinjen og navigationsblokke. Dette gælder ikke kurser brugeren i øjeblikket deltager på, de vil stadig være opført under mine kurser uden kategorier.';
$string['confignoreplyaddress'] = 'E-mails bliver nogen gange sendt ud på vegne af brugere, f.eks. forumindlæg. Den e-mailadresse du angiver her, vil stå som "Fra" adresse på de e-mails som bliver sendt fra de brugere som har valgt at hemmeligholde deres e-mail.';
$string['confignotifyloginfailures'] = 'Send meddelelser om loginfiaskoer til disse udvalgte brugere. Dette kræver at internt loglager (f.eks Standard Logstore) er aktiveret.';
$string['confignotifyloginthreshold'] = 'Hvis meddelelser om mislykkede login er slået til, hvor mange mislykkede loginforsøg af den samme bruger eller IP-adresse er det værd at sende en e-mail om?';
$string['confignotloggedinroleid'] = 'Brugere, som ikke er logget ind, vil få denne rolles beføjelser på site-niveau. Som regel vil \'gæst\' være hvad du vælger her, men måske vil du oprette en rolle der er mere eller mindre restriktiv. Sådan noget som at skrive indlæg vil stadig kræve at man logger ind på behørig vis.';
$string['configopentowebcrawlers'] = 'Hvis du aktiverer denne indstilling kan Google søge på siden som gæst. Derudover vil folk som følger et link fra Google automatisk blive logget ind som gæst. Dette vil selvfølgelig kun være tilfældet hvis kurset tillader gæsteadgang.';
$string['configoverride'] = 'Defineret i config.php';
$string['configpasswordpolicy'] = 'Er indstillingen aktiveret, tjekkes om adgangskoder lever op til indstillingerne herunder. Aktivering af adgangskodepolitikken påvirker ikke eksisterende brugere før de beslutter sig for, eller afkræves, at ændre deres adgangskode, eller at indstillingen "Tjek adgangskode ved login" er aktiveret.';
$string['configpasswordpolicycheckonlogin'] = 'Med denne indstilling vil adgangskoder ved hvert login blive tjekket for om de matcher adgangskodepolitikken.
Aktiveres fx efter opdatering af adgangskodepolitikken.';
$string['configpasswordresettime'] = 'Dette angiver hvor længe man har til at bekræfte en anmodning om en ny adgangskode. 30 minutter er normalt passende.';
$string['configpathtodu'] = 'Stien til du. Ofte noget i stil med /usr/bin/du. Hvis du skriver dette vil sider der viser indholdet af mapper, blive en del hurtigere når der er mange filer.';
$string['configpathtophp'] = 'Sti til PHP CLI. Antagelig noget a la /usr/bin/php. Hvis du indtaster den, kan cron-scripts køres fra det administrative webinterface.';
$string['configperfdebug'] = 'Hvis du aktiverer dette vil parse-tiden blive vist i bunden af siden i standardlayoutet.';
$string['configprofileroles'] = 'Roller, der er anført i brugerprofiler og på deltagersiden.';
$string['configprofilesforenrolledusersonly'] = 'For at forhindre misbrug af spammere holdes profilbeskrivelser af brugere, der endnu ikke er tilmeldt nogen kurser, skjulte. Nye brugere skal mindst tilmeldes et kursus, før de kan tilføje en beskrivelse i deres profil.';
$string['configprotectusernames'] = 'Er indstillingen aktiveret, vil formularen til glemt adgangskode ikke vise hints til gæt af brugernavn eller mailadresse.';
$string['configproxybypass'] = 'Kommasepareret liste med (delvise) værtsnavne eller ip-adresser, der skal kunne omgå proxyen (f.eks. 192,168., .minskole.dk)';
$string['configproxyfixunsafe_help'] = 'Dette forsøger at rette interne opkald, som ikke går gennem proxyen, ved at tilføje MoodleBot User Agent og bruge proxyen.';
$string['configproxyhost'] = 'Hvis denne server skal bruge en proxycomputer (f.eks. en firewall) for at komme på Internettet, så skriv proxy hostnavn og port her.';
$string['configproxylogunsafe_help'] = 'Dette forsøger at logge interne opkald, som ikke går gennem proxyen, men som burde.';
$string['configproxypassword'] = 'Eventuel krævet adgangskode for adgang til internettet via en proxy  (kræver PHP cURL extension).';
$string['configproxyport'] = 'Hvis denne server skal bruge en proxy-computer, skriv proxy-porten her';
$string['configproxytype'] = 'Type web proxy (PHP5 og cURL-udvidelsen  kræves til SOCKS5- support).';
$string['configproxyuser'] = 'Eventuelt krævet brugernavn for adgang til internettet via en proxy (kræver PHP cURL extension).';
$string['configrecaptchaprivatekey'] = 'Tekststreng med diverse tegn (privat nøgle) der bruges i kommunikationen mellem din Moodleserver og recaptcha-serveren. ReCAPTCHA-nøgler kan fås fra <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Tekststreng med tegn (webstedsnøgle), der bruges til at vise reCAPTCHA-elementet i tilmeldingsformularen og formularen til support af webstedet. ReCAPTCHA-nøgler kan fås fra <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Ord for studerende brugt på ønskede kurser.';
$string['configrequestedstudentsname'] = 'Ord for studerende brugt i ønskede kurser.';
$string['configrequestedteachername'] = 'Ord for lærer brugt i ønskede kurser.';
$string['configrequestedteachersname'] = 'Ord for lærere brugt i ønskede kurser.';
$string['configreverseproxyignore'] = 'Hvis serveren er bag flere reverse proxyer der føjes til overskriften X-Forwarded-For, skal du angive en kommasepareret liste over IP-adresser eller undernet for de reverse proxyer der skal ignoreres, for at finde brugerens korrekte IP-adresse.';
$string['configsectioninterface'] = 'Grænseflade';
$string['configsectionmail'] = 'Post';
$string['configsectionmaintenance'] = 'Vedligeholdelse';
$string['configsectionmisc'] = 'Diverse';
$string['configsectionoperatingsystem'] = 'Operativsystem';
$string['configsectionpermissions'] = 'Tilladelser';
$string['configsectionrequestedcourse'] = 'Kursusanmodninger';
$string['configsectionsecurity'] = 'Sikkerhed';
$string['configsectionstats'] = 'Statistik';
$string['configsectionuser'] = 'Bruger';
$string['configsecureforms'] = 'Moodle kan føje et ekstra sikkerhedsniveau til accept af data fra webformularer. Er det aktiveret, bliver browserens HTTP_REFERER-variabel sammenholdt med det der bliver sendt til Moodle vha. formularer. Dette kan i få tilfælde give problemer hvis der er en firewall imellem, f.eks. kan zonealarm eller proxier være konfigureret til at fjerne HTTP_REFERER fra http-trafikken. Symptomerne er, at man bliver hængene i formularen. Hvis brugerne har den type problemer med ex. loginsiden, kan du slå det fra. Det gør dog sitet mere sårbart for \'Brute force\'-angreb. Hvis du er i tvivl, lad da denne indstilling være slået til.';
$string['configservicespage'] = 'Indtast URL\'en til en side for tjenester og support, eller lad feltet stå tomt for at linke til Moodle-tjenester på moodle.com. Linket vises kun for webstedsadministratorer';
$string['configsessioncookie'] = 'Denne indstilling angiver navnet på den cookie der bliver brugt til Moodlesessioner. Den er valgfri, og forhindrer sammenblanding af cookies hvis der er flere kopier af Moodle der kører på samme websted.';
$string['configsessioncookiedomain'] = 'Her kan du ændre det domæne Moodles cookies er tilgængelige fra. Dette kan bruges til Moodletilpasninger (f.eks. godkendelses- eller tilmeldings-plugins) som skal kunne dele Moodles sessionsinformation med en webapplikation på et andet subdomæne. <strong>ADVARSEL: det anbefales på det kraftigste at beholde standardindstillingen (tomt felt) - forkert udfyldelse vil forhindre alle login på siden.</strong>';
$string['configsessioncookiepath'] = 'Hvis du har brug for at ændre den mappe hvori Moodle gemmer sessionscookies på webserveren, kan du angive mappen her. Ellers skal den som standard være \'/\'.';
$string['configsessiontimeout'] = 'Hvis brugere er inaktive på siden i lang tid (uden af skifte sider) så bliver de automatisk logget ud (deres session slutter). Denne variabel specificerer hvor lang tid der skal gå før de bliver logget ud.';
$string['configsessiontimeoutwarning'] = 'Hvis brugere er passive på siden i lang tid, bliver de advaret om at deres session er ved at udløbe. Her kan du angive hvornår det skal være.';
$string['configsessiontimeoutwarningcheck'] = 'Advarsel om timeout skal komme før selve timeout\'en.';
$string['configshowcommentscount'] = 'Vis kommentarantal. Det vil koste endnu en forespørgsel, når man viser kommentarlink';
$string['configshowicalsource'] = 'Vis iCal-begivenhedens kilde.';
$string['configshowsiteparticipantslist'] = 'Alle studerende og lærere vises i brugerlisten. Hvem skal kunne se brugerlisten for hele sitet?';
$string['configsitedefaultlicense'] = 'Standardlicens på siden';
$string['configsitedefaultlicensehelp'] = 'Standardlicens til publicering af indhold på dette site';
$string['configsitemailcharset'] = 'Standardtegnsæt på e-mails sendt fra sitet.';
$string['configsitemaxcategorydepth'] = 'Maksimal kategoridybde';
$string['configsitemaxcategorydepthhelp'] = 'Dette angiver den maksimale dybde af viste udvidede underkategorier ved visning af kategorier eller "komboliste". Dybere niveauer vises som links og brugeren kan udvide med en AJAX-forespørgsel.';
$string['configslasharguments'] = '"Slash-argumenter" (der bruger <em>PATH_INFO</em>) kræves af SCORM-pakker og materialer med flere filer for at blive vist korrekt. Understøtter din webserver ikke "slash-argumenter" og har du ikke mulighed for at konfigurere det, kan denne indstilling deaktiveres, skønt visse ting så ikke vil virke.<br />Bemærk: Brugen af "slash-argumenter" vil være krævet i fremtidige versioner af Moodle.';
$string['configsmartpix'] = 'Med dette aktiveret serveres ikoner gennem et PHP-script der søger i det aktuelle layout, derpå alle moderlayouts og endelig i Moodles mappe, /pix. Dette reducerer nødvendigheden af at dublere billedfiler i layoutskabeloner, men koster en smule på ydeevnen.';
$string['configsmtpauthtype'] = 'Her sættes godkendelsestypen til brug på smtp-serveren.';
$string['configsmtphosts'] = 'Angiv fuldt navn på en eller flere STMP-servere som Moodle skal bruge til at sende mail fra (f.eks. mail.a.com, mail.b.com osv.). En ikke-standard port (f.eks. andre end port 25) kan angives med syntaksen [server]:[port] (f.eks. \'mail.a.dk:587\'). Til sikre forbindelser bruges port 465 som regel med SSL og port 587 med TLS. Angiv om nødvendigt sikkerhedsprotokol herunder. Hvis du intet angiver vil Moodle bruge PHP\'s standardmetode til afsendelse af mail.';
$string['configsmtpmaxbulk'] = 'Antal beskeder der kan afsendes per SMTP-session. Gruppering af beskeder kan gøre afsendelse af e-mail hurtigere. Værdier under 2 giver en ny SMTP-session til hver e-mail.';
$string['configsmtpoauthservice'] = 'Vælg den OAuth 2-tjeneste, der er konfigureret til at kommunikere med SMTP-serveren. Hvis tjenesten endnu ikke findes, skal du oprette den. Bemærk, at du skal indstille SMTP-godkendelsestypen til XOAUTH2.';
$string['configsmtpsecure'] = 'Angiv den korrekte protokol her hvis smtp-serveren kræver en sikker forbindelse.';
$string['configsmtpuser'] = 'Hvis du har angivet en STMP-server herover og serveren kræver brugernavn og adgangskode, så indtast dem her.';
$string['configstartwday'] = 'Første ugedag';
$string['configstatsfirstrun'] = 'Dette angiver hvor langt tilbage logfiler skal behandles <b>første gang</b> cronjobbet genererer statistikken. Hvis der er en del trafik og siden befinder sig på en delt server, er det ikke en god ide at gå for langt tilbage, da det godt kan tage en del tid og er ret ressourcekrævende. (ifm. denne indstilling er 1 måned=28 dage. I grafer og rapporter er 1måned = 1 kalendermåned.)';
$string['configstatsmaxruntime'] = 'Statistikbehandling kan være ret ressourcekrævende, så brug en kombination af dette felt og det næste, for at angive hvornår det skal gøres og hvor længe det skal gøres for.';
$string['configstatsmaxruntime2'] = 'Statistik kan være ret intensiv at indsamle. Angiv den maksimalt tilladte tid til indsamling af en dags statistik. Højeste antal dage behandlet i en cron er 31.';
$string['configstatsmaxruntime3'] = 'Her styres hvor lang tid det må tage at beregne statistikken for en dag under hensyntagen til at statistikbehandling kan være krævende for serveren. Det højeste antal dage der må behandles i en cron-kørsel kan angives herunder.';
$string['configstatsruntimedays'] = 'Her styres hvor mange dage hver statistikkørsel maksimalt må behandle. Når statistikken er ajourført, vil kun en dag behandles, så juster værdien afhængig af hvor stort presset er på serveren, reducer antallet hvis du skal have korterevarende cron-kørsler.';
$string['configstatsruntimestart'] = 'På hvilket tidspunkt skal cronjobbet begynde at generere statistikken? Det anbefales at skrive forskellige tidspunkter hvis der er flere Moodleinstallationer på den samme fysiske server.';
$string['configstatsuserthreshold'] = 'Her angives hvor mange tilmelde brugere der skal til, før et kursus inkluderes i statistiske beregninger.';
$string['configstrictformsrequired'] = 'Aktiverer du denne indstilling forhindrer du brugerne i kun at skrive et mellemrum eller linjeskift i obligatoriske felter i formularer.';
$string['configstripalltitletags'] = 'Deaktiver denne indstilling hvis du vil tillade html-tags i aktivitets- og materialenavne.';
$string['configsupportavailability'] = 'Bestemmer hvem der har adgang til at kontakte webstedets support via sidefoden.';
$string['configsupportemail'] = 'Hvis SMTP er konfigureret på dette websted, og der ikke er angivet en supportside, vil denne e-mailadresse modtage meddelelser, der sendes via supportformularen. Hvis afsendelsen mislykkes, vises mailadressen for de loggede brugere.';
$string['configsupportname'] = 'Navnet på den person eller instans, der yder support via supportformularen eller supportsiden.';
$string['configsupportpage'] = 'Indtast URL\'en til en supportside, eller lad feltet være tomt for at linke til en kontaktformular. linket vises i sidefoden.';
$string['configtempdatafoldercleanup'] = 'Fjern midlertidige datafiler fra datamappen, hvis de er ældre end det angivne tidspunkt';
$string['configthemedesignermode'] = 'Normalt gemmes billeder og stilark i browsere og på serveren af ydelsesmæssige årsager i ret lang tid. Hvis du designer layouts eller skriver kode kan det være en fordel at bruge denne tilstand så du er fri for cachelagrede versioner. Advarsel: Dette vil gøre siden langsommere for alle brugere! Alternativt kan du nulstille layoutcachen manuelt fra layoutvælger-siden.';
$string['configthemelist'] = 'Hvis dette felt er tomt kan brugeren vælge mellem alle layouts. Du kan begrænse udvalget ved at skrive en kommasepareret liste med layouts her f.eks. standard,orangewhite.';
$string['configtimezone'] = 'Dette er standard tidszone til visning af datoer - hver bruger kan overskrive denne indstilling i deres profil. Cron-opgaver og andre serverindstillinger specificeres i denne tidszone. Du skal ændre indstillingen hvis den vises som "ugyldig tidszone".';
$string['configuseblogassociations'] = 'Må brugere kunne organisere deres blog ved at knytte opslagene til kurser og kursusmoduler?';
$string['configusesitenameforsitepages'] = 'Er indstillingen aktiveret, vil sitets korte navn blive brugt i stedet for "Webstedssider" i navigationsblokken.';
$string['configusetags'] = 'Vil du aktivere tags-funktionalitet over hele siden?';
$string['configvariables'] = 'Variable';
$string['configverifychangedemail'] = 'Aktiverer verificering af ændrede e-mailadresser vha. indstillinger for tilladte og ikke-tilladte e-maildomæner. Hvis denne indstilling er deaktiveret vil domænebestemmelsen kun gælde ved oprettelse af nye brugere.';
$string['configvisiblecourses'] = 'Vis kurser i skjulte kategorier som normalt';
$string['configwarning'] = 'Pas på med at ændre på disse indstillinger - forkerte værdier kan forårsage problemer.';
$string['configyuicomboloading'] = 'Denne valgmulighed aktiverer kombineret optimering af filhentning for YUI-biblioteker. Denne indstilling bør af ydelsesmæssige hensyn være aktiveret på sites i drift.';
$string['confirmation'] = 'Godkendelse';
$string['confirmcontextlock'] = '{$a->contextname} er aktuelt optøet. Frysning vil gøre det til read-only så ændringer forhindres. Er du sikker på at du vil fortsætte?';
$string['confirmcontextunlock'] = '{$a->contextname} er aktuelt frossent. Optøning vil muliggøre at brugere kan foretage ændringer.  Er du sikker på at du vil fortsætte?';
$string['confirmdeletecomments'] = 'Du er ved at slette kommentarer - er du sikker?';
$string['confirmed'] = 'Godkendt';
$string['contactsitesupport'] = 'Kontakt webstedssupport';
$string['contenttypeuninstalling'] = 'Der er {$a->count} tilfælde af indhold understøttet af {$a->type} der vil blive slettet. Er du sikker på at du vil fortsætte?';
$string['contextlockappliestoadmin'] = 'Kontekst-frysning gælder administratorer';
$string['contextlockappliestoadmin_desc'] = 'Er indstillingen deaktiveret, vil administratorer kunne ændre frosne kontekster.';
$string['contextlocking'] = 'Kontekstfrysning';
$string['contextlocking_desc'] = 'Her kan valgte kategorier, kurser, aktiviteter eller blokke sættes som read-onlly.';
$string['cookiesecure'] = 'Kun sikre cookies.';
$string['country'] = 'Standardvalg for land';
$string['course_customfield'] = 'Brugerdefinerede kursusfelter';
$string['coursecolor'] = 'Farve {$a}';
$string['coursecolorheading_desc'] = 'Alle kurser uden et kursusbillede angivet i kursusindstillingerne vises på Mine kurser-siden med et mønstret kursuskort. Farverne, der bruges i mønstret, kan angives nedenfor.';
$string['coursecolorsettings'] = 'Farver på kursusbrikker';
$string['coursecontact'] = 'Kursers kontaktpersoner';
$string['coursecontact_desc'] = 'Med denne indstilling kan du kontrollere hvem der skal stå i kursusbeskrivelsen. Brugere med en af disse roller vil blive vist.';
$string['coursecontactduplicates'] = 'Vis alle kontaktpersoner i kurser';
$string['coursecontactduplicates_desc'] = 'Er indstillingen aktiveret, vil brugere med mere end en af de valgte kursuskontakt-roller vises i kursusbeskrivelsen med hver af deres roller. Ellers vil de vises med bare en rolle (den der står højest på listen i "Definer roller" i siteadministrationen)';
$string['coursecreationguide'] = 'URL vejledning til oprettelse af Moodle-kursus';
$string['coursecreationguide_help'] = 'Definerer vejen til en hurtigstart-vejledning med korte videoer og generelle tips til oprettelse af kurser. Et link til vejledningen vises på Mine kurser-siden, når der ikke er nogen kurser at vise. Kun brugere med mulighed for at oprette kurser vil se linket.';
$string['coursegraceperiodafter'] = 'Udvidet periode for tidligere kurser';
$string['coursegraceperiodbefore'] = 'Udvidet periode for fremtidige kurser';
$string['courselistshortnames'] = 'Vis fulde kursusnavn';
$string['courselistshortnames_desc'] = 'Er indstillingen aktiveret, vil korte kursusnavne vises sammen med de fulde navne i kursuslister. Om nødvendigt kan udvidede kursusnavne tilpasses ved at redigere sprogstrengen "courseextendednamedisplay" ved hjælp af værktøjet til sprogredigering.';
$string['coursemgmt'] = 'Kursus- og kategorihåndtering';
$string['courseoverview'] = 'Kursusoversigt';
$string['coursepage'] = 'Luk side';
$string['courserequestnotify'] = 'Underretning om kursusanmodning';
$string['courserequestnotifyemail'] = 'Bruger {$a->user} har efterspurgt et nyt kursus <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Kursusanmodning';
$string['courserequestspending'] = 'Afventende kursusforespørgsler';
$string['courses'] = 'Kurser';
$string['coursesperpage'] = 'Kurser pr. side';
$string['courseswithsummarieslimit'] = 'Kurser med resumébegrænsning';
$string['creatornewroleid'] = 'Kursusadministratorers rolle i nye kurser';
$string['creatornewroleid_help'] = 'Hvis brugeren ikke allerede har tilladelse til at redigere det nye kursus, vil vedkommende automatisk tilmeldes med denne rolle.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Aktiver cron';
$string['cron_enabled_desc'] = 'Cron bør normalt være aktiveret, men denne indstilling gør det muligt at deaktivere midlertidigt, for eksempel før en servergenstart. Hvis deaktiveret, forhindres systemet i at starte nye baggrundsopgaver. Bemærk at cron ikke bør deaktiveres i lang tid, da det vil forhindre vigtige funktioner i at fungere.';
$string['cron_help'] = 'Vedligeholdelsesscriptet, cron.php, udfører planlagte opgaver i forskellige intervaller - som for eksempel afsendelse af mails med kopier af nye forumindlæg. Scriptet skal opsættes til at køre med jævne mellemrum, ideelt set hvert minut.';
$string['cron_keepalive'] = 'Hold i live';
$string['cron_keepalive_desc'] = 'Den tidsperiode, der skal bruges til at fortsætte med at afsøge efter yderligere opgaver. Denne indstilling sikrer, at cron altid kører. Hvis du bruger dedikerede opgavekørere, skal du sætte værdien til 0. Ellers skal du sætte den til en værdi, der ligner grænsen for samtidige adhoc-opgaver. Undgå længere tidsperioder. Den maksimale tidsperiode er 15 minutter.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Kørsel af cron-job kun via kommandolinje';
$string['cronerrorclionly'] = 'Beklager, administrator har lukket for internetadgang til denne side';
$string['cronerrorpassword'] = 'Beklager, du har ikke angivet en gyldig adgangskode.';
$string['croninfrequent'] = 'Der var {$a->actual} mellem de to sidste cron-kørsler, som bør køre hvert {$a->expected} Vi anbefaler at sætte cron til at køre noget oftere.';
$string['cronremotepassword'] = 'Cron-adgangskode til ekstern adgang';
$string['cronwarning'] = 'Cron-scriptet <a href="{$a->url}">admin/cron.php script</a> har ikke været kørt i  {$a->actual}, men skulle køre hvert {$a->expected}';
$string['cronwarningcli'] = 'Scriptet <code>admin/cli/cron.php</code> har ikke været kørt i {$a->actual}, men skulle køre {$a->expected}.';
$string['cronwarningnever'] = 'Scriptet <code>admin/cli/cron.php</code> har aldrig kørt, men skulle være kørt hver {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">Scriptet admin/cron.php</a> har aldrig været kørt, det burde køre hver {$a->expected}.';
$string['ctyperequired'] = 'Php-endelsen ctype kræves nu af Moodle for at forbedre ydelsen og for at kunne tilbyde flersprogs-kompatibilitet.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'Moodle kræver nu cURL PHP-udvidelsen for at kunne kommunikere med Moodles filarkiver.';
$string['curlsecurityallowedport'] = 'Tilladte cURL-porte';
$string['curlsecurityallowedportsyntax'] = 'Portnumre som cURL kan forbinde til. Kun heltal er gyldige. Skriv hvert tal på en ny linje. Lades feltet stå tomt, tillades alle porte. Udfyldes feltet, skal I de fleste tilfælde både bort 443 og 80 specificeres for at  cURL kan forbinde til standardporte til HTTPS og HTTP.';
$string['curlsecurityblockedhosts'] = 'Liste med cURL-blokerede hosts';
$string['curlsecurityblockedhostssyntax'] = 'Skriv en host per linje. Der kan skrives enten fulde IPv4- eller IPv6-adresser (såsom 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) som matcher en enkelt host, eller CIDR-notation (såsom 231.3.56.10-20 eller fe80::1111-bbbb) hvor spændet gælder den sidste gruppe adresser, eller domænenavne (såsom localhost eller eksempel.dk), eller joker-domænenavne (såsom *.eksempel.dk eller *.eksempel.dk). Tomme linjer er ikke tilladt.';
$string['curlsecurityurlblocked'] = 'URL\'en er blokeret';
$string['curltimeoutkbitrate'] = 'Hvilken bitrate skal bruges til at beregne cURL timeouts (Kbps)?';
$string['curltimeoutkbitrate_help'] = 'Denne indstilling bruges til at beregne en passende timeout under store cURL-anmodninger. Som en del af denne beregning, vil en HTTP HEAD-anmodning udføres for at vurdere indholdets størrelse. Hvis denne sættes til 0, vil anmodningen deaktiveres.';
$string['currenttheme'] = 'Nuværende layout';
$string['customcheck'] = 'Andre tjek';
$string['custommenu'] = 'Skræddersyet menu';
$string['custommenuitems'] = 'Brugerdefinerede menupunkter';
$string['customusermenuitems'] = 'Brugermenupunkter';
$string['datarootsecurityerror'] = '<p><strong>SIKKERHEDSADVARSEL!</strong></p><p>Din datamappe er fejlplaceret og er synlig på nettet. Det betyder at dine private filer er tilgængelige for hele verden, og nogle af dem kan bruges af en hacker til at få uautoriseret administrativ adgang til dit site!</p>
<p>Du <em>skal</em> flytte datamappen ({$a}) til et sted udenfor din offentlige web-mappe og opdatere <code>$CFG->dataroot</code>-indstillingen i config.php, så den passer med den nye placering.</p>';
$string['datarootsecuritywarning'] = 'Din webstedskonfiguration er muligvis ikke sikker. Kontroller at data-rodmappen ({$a}) ikke er direkte tilgængelig fra internettet.';
$string['dbprefixtoolong'] = 'Præfikset for din webstedsdatabase ($CFG->prefix) er for langt ({$a->current} tegn). Det maksimale antal tilladte tegn er {$a->maximum}.';
$string['dbsessions'] = 'Gem sessioner i databasen';
$string['debug'] = 'Debug-beskeder';
$string['debugall'] = 'ALLE: Vis alle relevante PHP-debug-beskeder';
$string['debugdeveloper'] = 'UDVIKLER: viser extra Moodle-debug-beskeder for udviklere.';
$string['debugdisplay'] = 'Vis debug-beskeder';
$string['debugging'] = 'Fejlfinding';
$string['debugminimal'] = 'MINIMAL: Vis kun fatale fejl';
$string['debugnone'] = 'INGEN: Viser hverken fejl eller advarsler';
$string['debugnormal'] = 'NORMAL: Viser fejl, advarsler og beskeder';
$string['debugpageinfo'] = 'Vis sideinformation';
$string['debugsqltrace'] = 'Vis originalen af SQL-kald';
$string['debugsqltrace1'] = 'Vis kun en enkelt opkaldslinje';
$string['debugsqltrace100'] = 'Vis den fulde staksporing';
$string['debugsqltrace2'] = 'Vis to linjer af staksporing';
$string['debugsqltrace_desc'] = 'Hvis aktiveret, vil en delvis eller fuld PHP-staksporing tilføjes til SQL\'en som en kommentar.';
$string['debugstringids'] = 'Vis hvor i sprogpakken sprogstrengene findes';
$string['debugstringids_desc'] = 'Er indstillingen aktiveret, vises navnet på sprogfilen og strengens id ved siden af hver tekststreng når "?strings=1" eller (hvis adressen allerede indeholder et "?") "&strings=1" er føjet til en sides URL.';
$string['debugtemplateinfo'] = 'Vis information for skabelon';
$string['debugtemplateinfo_desc'] = 'Hvis aktiveret, vises de skabeloner, der bruges til gengivelse, som kommentarer i sidens HTML. Efter ændring af denne indstilling skal du rydde cache. Brug denne funktion kun til midlertidig fejlfinding, da det medfører HTML-valideringsfejl og kan ødelægge side scripts. Det kan også ødelægge kernefunktionalitet!';
$string['debugvalidators'] = 'Vis validator links';
$string['defaultcity'] = 'Standardvalg for by';
$string['defaultcity_help'] = 'Den by du angiver her, vil som standard vælges når nye brugere oprettes.';
$string['defaultformatnotset'] = 'Fejl ved bestemmelse af standard kursusformat. Tjek indstillinger for sitet.';
$string['defaulthomepage'] = 'Startside for brugere';
$string['defaultrequestcategory'] = 'Standardkategori for kursusanmodninger';
$string['defaultsettinginfo'] = 'Standard: {$a}';
$string['defaultuserroleid'] = 'Standardrolle for <i>alle</i> brugere';
$string['deleteincompleteusers'] = 'Slet ufærdige brugere efter';
$string['deleteunconfirmed'] = 'Slet brugere der ikke er godkendte efter';
$string['deleteuser'] = 'Slet bruger';
$string['density'] = 'Tæthed';
$string['denyemailaddresses'] = 'Ulovlige e-maildomæner';
$string['development'] = 'Udvikling';
$string['devicedetectregex'] = 'Enhedsgenkendelse regulære udtryk';
$string['devicedetectregex_desc'] = '<p>Som udgangspunkt kan Moodle genkende enheder af typen standard (pc\'er, bærbare m.m.), mobile enheder (mobiltelefoner og små håndholdte enheder), tablets (iPads, Androidtablets) og legacy (Internet Explorer 6-brugere). Layoutvælgeren kan bruges til at anvende forskellige layoutskabeloner til disse typer. Denne indstilling tillader regulære udtryk til genkendelse af ekstra enhedstyper (disse har forrang frem for standardtyperne).</p> <p>For eksempel kan du indtaste det regulære udtryk \'/(MIDP-1.0|Maemo|Windows CE)/\' for at kunne genkende disse hyppigt anvendte \'feature phones\' og tilføje returværdien \'featurephone\'. Dette vil medføre at \'featurephone\' føjes til layoutvælgeren så du kan vælge et layout til brug på disse enheder. Andre telefoner vil stadig benytte det layout der er angivet til mobile enheder.</p>';
$string['devicedetectregexexpression'] = 'Regulært udtryk';
$string['devicedetectregexvalue'] = 'Returværdi';
$string['devicetype'] = 'Enhedstype';
$string['devlibdirpresent'] = 'Mapper med udviklingsbiblioteker, specielt <em>/vendor</em> og <em>/node_modules</em>, bør ikke være på offentlige sider. Se flere oplysninger på siden <a href="{$a->moreinfourl}">Security overview report</a>.';
$string['disabled'] = 'Deaktiveret';
$string['disableplugin'] = 'Deaktiver {$a}';
$string['disableuserimages'] = 'Deaktiver brugerprofilbilleder';
$string['displayerrorswarning'] = 'Du bør ikke bruge PHP-indstillingen <em>display_errors</em> på en Moodleinstallation i drift, da nogle fejlmeddelelser kan afsløre sensitiv information om din server.';
$string['displayloginfailures'] = 'Vis forkerte loginforsøg';
$string['divertallemails'] = 'Viderestilling af e-mail';
$string['divertallemailsdetail'] = 'Anvendes som en beskyttelsesforanstaltning i udviklingsmiljøer, når du tester e-mails og bør ikke bruges i produktionen.';
$string['divertallemailsexcept'] = 'Undtagelser fra omdirigering af mail';
$string['divertallemailsexcept_desc'] = 'En liste over mail-undtagelsesregler adskilt af enten kommaer eller nye linjer. Hver regel fortolkes som et regulært udtryk, f.eks.<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Omdiriger alle mails';
$string['divertallemailsto_desc'] = 'Hvis en mailadresse er angivet, vil alle mails blive omdirigeret til denne enkelte adresse i stedet.';
$string['dndallowtextandlinks'] = 'Upload tekst/links ved hjælp af træk og slip';
$string['doclang'] = 'Sprog for docs';
$string['docroot'] = 'Moodle Docs\' dokumentmappe';
$string['doctonewwindow'] = 'Åbn i nyt vindue';
$string['doesnotfit'] = 'Indstillinger til e-mailvisning';
$string['doesnotfitdetail'] = 'Visningsindstillinger for mails fra Moodle.';
$string['download'] = 'Download';
$string['downloadcoursecontentallowed'] = 'Funktionen download kursusindhold tilgængelig';
$string['downloadcoursecontentallowed_desc'] = 'Hvorvidt funktionen download kursusindhold er tilgængelig i kurser. Er den det, kan download af kursusindhold aktiveres/deaktiveres med indstillingen "Aktiver download kursusindhold" i kursusindstillingerne. (Standardindstillingen sættes i  <a href={$a} target="_blank">Standard kursusindstillinger</a>).';
$string['durationunits'] = 'varighedsenheder';
$string['edithelpdocs'] = 'Rediger hjælpefiler';
$string['editlang'] = '<b>Rediger</b>';
$string['editorbackgroundcolor'] = 'Baggrundsfarve';
$string['editordictionary'] = 'Editor-ordbog';
$string['editorfontfamily'] = 'Skrifttypenavn';
$string['editorfontlist'] = 'Skrifttypeliste';
$string['editorfontsize'] = 'Skrifttypestørrelse';
$string['editorhidebuttons'] = 'Skjulte knapper';
$string['editorkillword'] = 'Wordformat-filter';
$string['editorspelling'] = 'Editor stavning';
$string['editorspellinghelp'] = 'Aktiver eller deaktiver stavekontrol. Aktivering kræver at <strong>aspell</strong> er installeret på serveren.';
$string['editstrings'] = 'Rediger ord eller sætninger';
$string['emailchangeconfirmation'] = 'Bekræftelse på ændring af e-mailadresse';
$string['emaildkim'] = 'DomainKeys Identified Mail (DKIM) e-mail-signering';
$string['emaildkiminfo'] = 'Hvis både DKIM-vælgeren er angiveet, og der findes en privat certifikatfil, der matcher e-mailadressens "Fra"-domæne i $CFG->dataroot/dkim/[domain]/[selector].private, underskrives e-mailen. I de fleste tilfælde (f.eks. hvis tilladte maildomæner er tomme) er der kun brug for et enkelt certifikat i <pre>{$a->path}</pre>. For yderligere oplysninger om opsætning, se dokumentationen <a href="{$a->docs}">Mail configuration</a>.';
$string['emaildkimselector'] = 'DKIM-vælger';
$string['emailfromvia'] = 'Mail via-information';
$string['emailheaders'] = 'Brevhoveder i mail';
$string['emailsubjectprefix'] = 'Præfiks til mailemne';
$string['emoticonalt'] = 'Alternativ tekst';
$string['emoticoncomponent'] = 'Billed-komponent';
$string['emoticonimagename'] = 'Smiley-navn';
$string['emoticons'] = 'Smileys';
$string['emoticons_desc'] = 'Denne formular definerer smileys på dit site. Du kan fjerne en række fra tabellen ved at gemme formularen med en tom række. En ny smiley tilføjes ved at udfylde felterne i den sidste tomme række. Tabellens oprindelige indhold kan gendannes ved at følge linket herover.

* Tekst (obligatorisk) - Denne tekst vil blive erstattet af smileyen. Den skal bestå af mindst to tegn.
* Smiley-navn (obligatorisk) - Smileyens filnavn uden extension, relativ til komponententens \'pix\'-mappe.
* Billed-komponent (obligatorisk) - Moodle-komponenten der sørger for ikonet.
* Alternativ tekst (frivillig) - Streng-identifikator og kodekomponent til alternativ tekst til smileyen.';
$string['emoticonsreset'] = 'Gendan humørikoner til standardværdier';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Tom';
$string['enableanalytics'] = 'Analytisk';
$string['enableblogs'] = 'Aktiver blogs';
$string['enablecalendarexport'] = 'Aktiver kalendereksport';
$string['enablecomments'] = 'Aktiver kommentarer';
$string['enablecommunicationsubsystem'] = 'Aktiver kommunikationsudbydere';
$string['enablecommunicationsubsystem_desc'] = 'Tillad integration med kommunikationsudbydere såsom Matrix, så lærere og studerende kan kommunikere lettere. Du kan administrere disse integrationer under <a href="settings.php?section=managecommunicationproviders">Plugins</a>.';
$string['enablecourserelativedates'] = 'Aktiver relative kursusdatoer';
$string['enablecourserelativedates_desc'] = 'Tillad kurser at blive opsat til at vise datoer relativt til brugerens startdato på kurset.';
$string['enablecourserequests'] = 'Aktiver kursusanmodninger';
$string['enabled'] = 'Aktiveret';
$string['enabledashboard'] = 'Aktiver betjeningspanel';
$string['enabledashboard_help'] = 'Betjeningspanelet viser som standard tidslinje, kalender og senest tilgåede elementer. Du kan indstille et andet standard betjeningspanel til alle og give brugerne mulighed for at tilpasse deres eget betjeningspanel. Hvis det er deaktiveret, skal du vælge til en anden værdi til "Startside for brugere" end betjeningspanel.';
$string['enabledevicedetection'] = 'Aktiver enhedsgenkendelse';
$string['enableglobalsearch'] = 'Aktiver global søgning';
$string['enableglobalsearch_desc'] = 'Er indstillingen aktiveret, vil data  blive indekseret og synkroniseret af en planlagt kørsel.';
$string['enablegravatar'] = 'Anvend Gravatar';
$string['enablegravatar_help'] = 'Er indstillingen aktiveret, vil Moodle forsøge at finde et brugerprofilbillede fra Gravatar hvis brugeren har uploadet et billede.';
$string['enablemobilewebservice'] = 'Aktiver webservice for mobile enheder';
$string['enablepdfexportfont'] = 'Aktiver PDF skrifttyper';
$string['enablepdfexportfont_desc'] = 'Hvis din side har kurser på forskellige sprog, som kræver andre skrifttyper i genererede PDF-filer, kan du give muligheden for at angive skrifttypen i kursusindstillingerne. Du skal angive tilgængelige skrifttyper i $CFG->pdfexportfont i config.php';
$string['enableplugin'] = 'Aktivér {$a}';
$string['enablerecordcache'] = 'Aktiver database-cache';
$string['enablerssfeeds'] = 'Aktiver RSS-feed';
$string['enablesearchareas'] = 'Aktiver søgeområder';
$string['enablesharingtomoodlenet'] = 'Aktivér deling til MoodleNet (udgående)';
$string['enablesharingtomoodlenet_desc'] = 'Tillad brugerne  at dele kursusindhold til en konfigureret MoodleNet-instans, hvis de har rettighed til det.';
$string['enablestats'] = 'Aktiver statistik';
$string['enabletrusttext'] = 'Aktiver betroet indhold';
$string['enableuserfeedback'] = 'Aktiver feedback til denne software';
$string['enableuserfeedback_desc'] = 'Er indstillingen aktiveret, vises et link, "Giv feedback på denne software", i sidefoden så brugere kan give Moodle HQ feedback på Moodle-softwaren. Er indstillingen "Næste påmindelse om feedback" valgt, vil brugeren blive påmindet på betjeningspanelet med de angivne intervaller. Vælges "Aldrig", deaktiveres påmindelserne mens linket i sidefoden bevares.';
$string['enablewebservices'] = 'Aktiver webservices';
$string['enablewsdocumentation'] = 'Webservices-dokumentation';
$string['encryptedpassword_edit'] = 'Angiv en ny værdi';
$string['encryptedpassword_set'] = '(Sat og krypteret)';
$string['enroladminnewcourse'] = 'Tilmeld automatisk admin i nye kurser';
$string['enroladminnewcourse_help'] = 'Når administratorer tilføjer et nyt kursus, skal de så automatisk tilmeldes og tildeles producentrollen i nye kurser?';
$string['enrolinstancedefaults'] = 'Standarder for tilmeldingsforemomster';
$string['enrolinstancedefaults_desc'] = 'Standard tilmeldingsindstillinger i nye kurser.';
$string['enrolmultipleusers'] = 'Tilmeld brugerne';
$string['entitytasklog'] = 'Opgavelog';
$string['environment'] = 'Serveropsætning';
$string['environmenterrortodo'] = 'Du bliver nødt til at løse de ovenstående problemer (fejl) der er ved serveropsætningen før du kan installere denne version af Moodle';
$string['environmenterrorupgrade'] = 'Advarsel: Du skal adressere alle systemmæssige problemer (fejl) fundet herover, før du fortsætter med opgraderingen af denne Moodleversion! Opgradering uden at fikse disse systemkrav kan volde problemer såsom tab af data. Er du sikker på at du vil fortsætte med opgraderingen?';
$string['environmentmariadbwrongdbtype'] = 'Forkert $CFG->dbtype: Du skal ændre den i din config.php-fil, fra  \'mysqli\' til \'mariadb\'..';
$string['environmentmustfixsetting'] = 'PHP-indstillingen skal ændres.';
$string['environmentok'] = 'Din server opfylder alle minimumskrav.';
$string['environmentrecommendcustomcheck'] = 'fejler denne test indikerer det et potentielt problem';
$string['environmentrecommendinstall'] = 'anbefales installeret og aktiveret';
$string['environmentrecommendversion'] = 'version {$a->needed} er anbefalet og du kører {$a->current}';
$string['environmentrequirecustomcheck'] = 'Denne test skal bestås';
$string['environmentrequireinstall'] = 'skal være installeret og aktiveret';
$string['environmentrequireversion'] = 'minimumskravet er version {$a->needed} og du kører {$a->current}';
$string['environmentsettingok'] = 'anbefalet indstilling er fundet';
$string['environmentshouldfixcustomcheck'] = 'bør aktiveres for de bedste resultater';
$string['environmentshouldfixsetting'] = 'PHP-indstillingen skal ændres.';
$string['environmentxmlerror'] = 'Fejl ved læsning af serveropsætningens data ({$a->error_code})';
$string['errordeletingconfig'] = 'En fejl er opstået under sletning af konfigurationsposterne til plugin\'et "{$a}".';
$string['errorsetting'] = 'Kunne ikke gemme indstillingen:';
$string['errorwithsettings'] = 'Visse indstillinger kunne ikke ændres som følge af en fejl.';
$string['eventshandlersinuse'] = 'De følgende plugins i dit system bruger forældede Events 1 API-håndteringer: "{$a}". Opdater dem til at bruge Events 2 API. Se https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Alle der kan \'{$a}\\';
$string['exceptions'] = 'undtagelser';
$string['execpathnotallowed'] = 'Indstiller eksekverbare og lokale stier som er deaktiveret i config.php';
$string['experimental'] = 'Eksperimentiel';
$string['experimentalsettings'] = 'Eksperimentielle indstillinger';
$string['extendedusernamechars'] = 'Tillad udvidede tegn i brugernavne';
$string['extramemorylimit'] = 'Grænse for ekstra php-hukommelse';
$string['fatalsessionautostart'] = '<p>Der er fundet en alvorlig konfigurationsfejl, underret serveradministratoren.</p><p>Moodle kræver en ændring i php-indstillingerne for at kunne køre tilfredsstillende.</p><p><code>session.auto_start</code> skal sættes til <code>off</code>.</p><p>Indstillingen kan ændres ved at redigere <code>php.ini</code>, Apache/IIS <br />konfigurationen eller <code>.htaccess</code>-filen på serveren.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Faviconet vises ved siden af sidens titel i browserfanen. Der vises et Moodle-favicon, hvis der ikke er angivet et brugerdefineret favicon.';
$string['feedbacksettings'] = 'Feedback-indstillinger';
$string['fileconversioncleanuptask'] = 'Ryd midlertidige poster til filkonverteringer.';
$string['filecreated'] = 'Der er oprettet en ny fil';
$string['filescleanupperiod'] = 'Ryd filer i affaldsdyngen';
$string['filescleanupperiod_help'] = 'Hvor tit filer i affaldsdyngen slettes. Der er tale om filer associeret med indhold der ikke længere eksisterer, for eksempel når et kursus er slettet. Bemærk: Indstillingen kan resultere i manglende filer på et kursus der er taget backup af, slettet og derpå gendannet, hvis indstillingen "Inkluder filer" (backup_auto_files) i "Indstillinger for automatisk backup" er deaktiveret';
$string['filesizeunits'] = 'enheder til filstørrelse';
$string['filestoredin'] = 'Gem i mappen:';
$string['filestoredinhelp'] = 'Hvor filen gemmes';
$string['filterall'] = 'Filtrer alle strenge';
$string['filtermatchoneperpage'] = 'Filtrer en forekomst per side';
$string['filtermatchonepertext'] = 'Filtrer første forekomst per tekstblok';
$string['filternavigationwithsystemcontext'] = 'Filternavigation med systemkontekst';
$string['filters'] = 'Filtre';
$string['filtersettings'] = 'Håndter filtre';
$string['filtersettingsgeneral'] = 'Generelle filterindstillinger';
$string['filteruploadedfiles'] = 'Filtrer uploadede filer';
$string['forceclean'] = 'Rensning af indhold overalt';
$string['forceclean_desc'] = 'Indhold tilføjet sitet renses normal inden det vises for at fjerne eventuelle sikkerhedstrusler. For at muliggøre scripts, medier, inline frames mv., renses indholdet imidlertid ikke visse steder såsom i aktivitetsbeskrivelser, websider eller HTML-blokke. Aktiveres denne indstilling vil ALT indhold blive renset. Det kan resultere i at eksisterende indhold ikke længere vises korrekt.';
$string['forcelogin'] = 'Tving brugere til at logge ind';
$string['forceloginforprofileimage'] = 'Tving brugere til at logge ind for at kunne se brugeres profilbilleder';
$string['forceloginforprofileimage_help'] = 'Er indstillingen aktiveret, skal brugere logge ind for at kunne se brugerprofilbilleder, og standard-brugerbilledet vil blive brugt i alle e-mails.';
$string['forceloginforprofiles'] = 'Tving brugere til at logge ind for at se profiler';
$string['forcetimezone'] = 'Gennemtving tidszone';
$string['formatuninstallwithcourses'] = 'Der findes {$a->count} kurser der bruger {$a->format}. Deres format vil blive ændret til {$a->defaultformat} (dette sites default format). Visse format-specifikke data kan gå tabt. Er du sikker på at du vil fortsætte?';
$string['frontpage'] = 'Forside';
$string['frontpagebackup'] = 'Forside-backup';
$string['frontpagedefaultrole'] = 'Standardrolle på forsiden';
$string['frontpagefilters'] = 'Forsidefiltre';
$string['frontpageloggedin'] = 'Elementer på forsiden når brugere er logget ind';
$string['frontpageoverrides'] = 'Undtagelser til kompetencer på forsiden';
$string['frontpagequestions'] = 'Forsidespørgsmål';
$string['frontpagerestore'] = 'Forsidegendannelse';
$string['frontpageroles'] = 'Forsideroller';
$string['frontpagesettings'] = 'Forsideindstillinger';
$string['fullnamedisplay'] = 'Format til fulde navn';
$string['fullnamedisplayprivate'] = 'Fuldnavns-format - privat';
$string['gdrequired'] = 'GD-udvidelsen kræves nu af Moodle til billedkonvertering.';
$string['generalsettings'] = 'Generelle indstillinger';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Logget IP-adressekilde';
$string['globalsearch'] = 'Global søgning';
$string['globalsearchmanage'] = 'Administrer global søgning';
$string['googlemapkey3'] = 'Google Maps API V3 nøgle';
$string['googlemapkey3_help'] = 'Du skal indtaste en speciel nøgle for at kunne bruge Google Maps til at visualisere IP-adresseopslag. Du kan få en gratis nøgle på siden <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Gå til første tomme streng';
$string['gradebook'] = 'Karakterbog';
$string['gradebookroles'] = 'Brugere, der kan få karakterer';
$string['gradeexport'] = 'Primær metode til karaktereksport';
$string['gravatardefaulturl'] = 'Gravatars standardbilled-URL';
$string['gravatardefaulturl_help'] = 'Gravatar skal bruge et standardbillede til visning hvis den ikke kan finde et billede for en given bruger. Angiv en fuld URL til et billede. Hvis du lader feltet være tomt, vil Moodle forsøge at bruge det mest passende bilede for den side du ser. Vær også opmærksom på, at Gravatar har en række koder som kan bruges til at <a href="https://en.gravatar.com/site/implement/images/#default-image">generere standardbilleder</a>.';
$string['group_customfield'] = 'Gruppe brugerdefinerede felter';
$string['groupenrolmentkeypolicy'] = 'Politik for gruppetimeldingsnøgle';
$string['groupenrolmentkeypolicy_desc'] = 'Aktiverer du denne indstilling, tjekkes gruppetilmeldingsnøgler mod den gældende adgangskodepolitik herover.';
$string['grouping_customfield'] = 'Gruppering brugerdefinerede felter';
$string['guestroleid'] = 'Rolle til gæsteprofil';
$string['guestroleid_help'] = 'Denne rolle gives automatisk til besøgende. Den bruges også midlertidigt til ikke tilmeldte brugere der kommer ind på et kursus via plugin\'et til gæstetilmelding.';
$string['h5pgetcontenttypestask'] = 'Hent tilgængelige H5P-indholdstyper fra h5p.org';
$string['helpadminseesall'] = 'Skal administratorer i sitekalenderen kunne se og filtrere alle begivenheder i alle kursuskalendere eller kun dem fra kurser de deltager i? Administratorer kan under alle omstændigheder tilgå en kursuskalender direkte fra et kursus og ad den vej redigere i den.';
$string['helpcalendarcustomexport'] = 'Aktiver muligheden for skræddersyet datointerval i kalendereksport. Kalendereksport skal være aktiveret for at dette træder i kraft.';
$string['helpexportlookahead'] = 'Hvor mange dage udi fremtiden skal kalenderen se efter aftaler under eksport ved brug af det brugerdefinerede datointerval';
$string['helpexportlookback'] = 'Hvor mange dage i fortiden skal kalenderen se efter aftaler under eksport ved brug af det brugerdefinerede datointerval';
$string['helpforcetimezone'] = 'Du kan tillade brugere selv at vælge deres tidszone eller tvinge alle brugere til at bruge den samme tidszone.';
$string['helpshowicalsource'] = 'Er indstillingen aktiveret, vil abonnementsnavn og link blive vist for iCal-importerede aftaler';
$string['helpsitemaintenance'] = 'For opgraderinger og andet vedligeholdelse.';
$string['helpstartofweek'] = 'Hvilken dag starter ugen i kalenderen?';
$string['helpupcominglookahead'] = 'Hvor mange dage frem skal kalenderen se efter kommende begivenheder?';
$string['helpupcomingmaxevents'] = 'Hvor mange begivenheder skal som standard maksimalt vises til brugere?';
$string['helpweekenddays'] = 'Hvilke dage skal betragtes som weekend og vises med en anden farve?';
$string['hiddenuserfields'] = 'Skjul brugerfelter';
$string['hidefromall'] = 'Skjul for alle brugere';
$string['hidefromnone'] = 'Skjul ikke for nogen';
$string['hidefromstudents'] = 'Skjul for studerende';
$string['hookcallbacknotcallable'] = 'Dette callback kan ikke kaldes. Dette kan skyldes, at klassen eller metoden ikke eksisterer, eller at metoden ikke er offentlig.';
$string['hookcallbacks'] = 'Callbacks';
$string['hookcallbacks_help'] = 'Listen af call back, som vil blive kaldt når hooken er udsendt

Rækkefølgen der vises er rækkefølgen, hvori tilbagekaldelserne bliver kaldt

En call back med højere prioritet vil blive kaldt før dem med lavere prioritet';
$string['hookclassmissing'] = 'Hook-klassen kunne ikke findes';
$string['hookclassmissing_desc'] = 'Hook discovery agenten har returneret en class, der ikke findes';
$string['hookconfigoverride'] = 'Overskreven';
$string['hookconfigoverride_help'] = 'Definitionen på dette callback er blevet opdateret i websitens konfigurationsfil, config.php';
$string['hookdescription'] = 'Beskrivelse';
$string['hookdescriptionmissing'] = 'Hook\'en har ikke en beskrivelsesmetode';
$string['hookname'] = 'Hook';
$string['hooksoverview'] = 'Hook-overblik';
$string['hookunknown'] = 'Hook ikke fundet';
$string['hookunknown_desc'] = 'Objektet, som dette callback lytter til, er ikke tilgængeligt. Det kan være blevet fjernet eller omdøbt, eller det er muligvis ikke tilgængeligt i denne version af Moodle.';
$string['hostname'] = 'Hostnavn';
$string['htmleditor'] = 'HTML-editor';
$string['htmleditorsettings'] = 'HTML-editorindstillinger';
$string['htmlsettings'] = 'HTML-indstillinger';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-sikkerhed';
$string['iconvrequired'] = 'Installation af ICONV-udvidelsen er påkrævet.';
$string['igbinary322buggyversion'] = 'Udvidelsen php-igbinary, der er installeret på webstedet, kan medføre problemer, når den kører med PHP 7.2. Det anbefales, at du enten opgraderer til php-igbinary 3.2.5 eller nyere, eller alternativt opgraderer til PHP 7.3 eller nyere.';
$string['ignore'] = 'Ignorer';
$string['includemoduleuserdata'] = 'Inkluder brugerdata fra moduler';
$string['incompatibleblocks'] = 'Inkompatible blokke';
$string['incompleteunicodesupport'] = 'Den aktuelle opsætning af MySQL eller MariaDB bruger \'utf8\', som ikke understøtter fire bytes tegn og dermed ikke visse humørikoner. Forsøg på at bruge disse tegn vil resultere i en fejl når posten opdateres og informationer sendt til databasen mistes. Overvej at ændre dine indstillinger til \'utf8mb4\'. Se dokumentationen for yderligere information.';
$string['indexdata'] = 'Indeksdata';
$string['indexinginfo'] = 'Den anbefalede metode til indeksering af dit sites indhold er ved brug af den planlagte opgave "Indeksering til global søgefunktion"';
$string['installhijacked'] = 'Installationen skal færdiggøres fra den oprindelige IP-adresse, beklager.';
$string['installsessionerror'] = 'Kan ikke initialisere PHP-sessionen, kontroller at din browser accepterer cookies.';
$string['intlrecommended'] = 'Filtypenavnet Intl bruges til at forbedre internationliseringsunderstøttelse, såsom lokalitetsbestemt sortering';
$string['intlrequired'] = 'Intl-udvidelsen er påkrævet for at forbedre understøttelsen af internationalisering, f.eks. sortering efter lokalitet og internationale domænenavne';
$string['invalidagedigitalconsent'] = 'Den digitale lavalder er ikke gyldig: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL\'en til glemt adgangskode er ugyldig.';
$string['invalidsection'] = 'Ugyldig sektion.';
$string['invalidthemepreset'] = 'Den valgte fil med foruddefinitioner er ikke kompatibel med dette layout. SCSS-kompileringsfejlen var: "{$a}"';
$string['invaliduserchangeme'] = 'Brugernavnet "changeme" er reserveret -- Du kan desværre ikke oprette en bruger med det.';
$string['ipblocked'] = 'Dette websted er i øjeblikket ikke tilgængeligt.';
$string['ipblocker'] = 'IP-blokering';
$string['ipblockersyntax'] = 'Indtast alle data på samme linje. Gyldige data er enten fuldstændige ip-adresser (såsom <b>192.168.10.1</b>) som matcher en enkelt host, eller delvise adresser (såsom <b>192.168</b>) som matcher enhver adresse der starter med disse tal, eller CIDR-notation (såsom <b>231.54.211.0/20</b>), eller en række ip-adresser (såsom <b>231.3.56.10-20</b>) hvor den sidste del af adressen indikerer hvilken rækkevide adresserne kan spænde over. Domænenavne (såsom "eksempel.dk") understøttes ikke. Tomme linjer og tekst med foranstillet "#" ignoreres.';
$string['iplookup'] = 'IP-adresseopslag';
$string['iplookupgeoplugin'] = '<a href="https://www.geoplugin.com">geoPlugin</a>-servicen bliver p.t. brugt til at lede efter geografisk information. For mere præcise resultater anbefaler vi at der installeres en lokal kopi af MaxMind GeoLite-databasen.';
$string['iplookupinfo'] = 'Den gratis online NetGeo-server bruges til at slå IP-adressers placering op. Databasen vedligeholdes dog ikke længere og kan returnere forkerte data. Det anbefales at installere en lokal kopi af den gratis GeoLite2 City-database fra MaxMind.<br />
Hvis der er angivet en Google Maps API V3-nøgle, vises IP-adressens placering ved hjælp af Google Maps. Du skal have en Google-konto og ansøge om en Google Maps API-nøgle. Hvis der ikke er angivet en Google Maps API V3-nøgle, vises IP-adressens placering ved hjælp af OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Dette produkt inkluderer GeoLite2-data fra MaxMind, som kan fås her: <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Dit websted bruger et brugerdefineret administratorkatalog. Denne funktion understøttes ikke længere og vil blive fjernet efter Moodle 4.2.';
$string['ishttpswarning'] = 'Dit site er ikke sikret med HTTPS. Det anbefales kraftigt at du flytter dit site til HTTPS for at øge sikkerheden og forbedre integration med andre systemer.';
$string['keeptagnamecase'] = 'Bevar tag-navnets brug af store og små bogstaver';
$string['lang'] = 'Standardsprog';
$string['langcache'] = 'Sprogmenu-cache';
$string['langcache_desc'] = 'Cache af sprogmenuen. Hvis den er aktiveret vil listen med tilgængelige oversættelser caches. Cachen opdateres automatisk når du installerer eller sletter en sprogpakke via sprogpakkemanageren. Installerer du en sprogpakke manuelt må du bruge \'Ryd al cache\'-funktionen for at opdatere sproglisten.';
$string['langlist'] = 'Sprog i sprogmenuen';
$string['langmenu'] = 'Vis sprogmenu';
$string['langmenuinsecurelayout'] = 'Vis sprogmenuen i sikkert layout';
$string['langmenuinsecurelayout_desc'] = 'Er indstillingen aktiveret, kan en bruger der bruger et sikkert layout, skifte sprog under en besvarelse af en quiz eller andre aktiviteter';
$string['langpackwillbeupdated'] = 'BEMÆRK: Moodle vil forsøge at downloade opdateringer til dine sprogpakker under opgraderingen.';
$string['langstringcache'] = 'Gem alle sprogstrenge i mellemlageret';
$string['languagesettings'] = 'Sprogindstillinger';
$string['latinexcelexport'] = 'Excel-tegnkode';
$string['legacyfilesaddallowed'] = 'Tillad tilføjelse til legacy kursusfiler';
$string['legacyfilesaddallowed_help'] = 'Hvis et kursus har legacy kursusfiler tillades det at nye filer og mapper kan tilføjes til dette.';
$string['legacyfilesinnewcourses'] = 'Arvede kursusfiler i nye kurser';
$string['legacyfilesinnewcourses_help'] = 'Som standard findes legacy-kursusfiler alene på kurser der er opgraderet fra Moodle 1.9. Vær opmærksom på at nogle funktioner såsom backup og gendan, ikke er kompatible med denne indstilling.';
$string['libcurlwarning'] = 'Det har vist sig at libcurl ikke understøtter CURLOPT_PROTOCOL. Af sikkerhedsmæssige grunde anbefales det at opdatere installationen af libcurl.';
$string['licensesettings'] = 'Licensindstillinger';
$string['linkadmincategories'] = 'Link admin kategorier';
$string['linkadmincategories_help'] = 'Er indstillingen aktiveret, vil admin-indstillingskategorier blive vist som links i navigationen og vil pege på admin-kategorisiderne';
$string['linkcoursesections'] = 'Link altid til kursussektioner';
$string['linkcoursesections_help'] = 'Forsøg altid at linke til en kursussektion. Kursussektioner vil sædvanligvis kun blive vist som links hvis kursusformatet viser en enkelt sektion pr. side. Med denne indstilling aktiveret, vil et link altid blive dannet.';
$string['loading'] = 'Indlæser';
$string['localetext'] = 'Webstedets lokationsindstilling';
$string['localstringcustomization'] = 'Skræddersy lokal sprogpakke';
$string['location'] = 'Lokation';
$string['locationsettings'] = 'Lokationsindstilling';
$string['locked'] = 'Låst';
$string['lockoutduration'] = 'Varighed for konto låst';
$string['lockoutduration_desc'] = 'En låst konto vil altid blive låst op efter udløb af denne varighed';
$string['lockoutemailbody'] = 'Din konto med brugernavnet "{$a->username}" på serveren "{$a->sitename}" er blevet låst ude efter adskillige ugyldige loginforsøg.

For at låse kontoen op bedes du straks gå til denne adresse:

{$a->link}.

I de fleste mailprogrammer vil denne fremstå som et blåt link som du kan klikke på. Virker det ikke, kan du kopiere adressen og indsætte den i adressefeltet øverst i dit browservindue.

Har du brug for hjælp, kan du kontakte sidens administrator:
{$a->admin}';
$string['lockoutemailsubject'] = 'Din konto på {$a} er låst ude';
$string['lockouterrorunlock'] = 'Ugyldig information til oplåsning af konto';
$string['lockoutthreshold'] = 'Konto-låsningsgrænse';
$string['lockoutthreshold_desc'] = 'Vælg antallet af fejlslagne loginforsøg der skal resultere i at kontoen låses. Denne funktion kan misbruges i denial of service-angreb';
$string['lockoutwindow'] = 'Konto-låsnings observations-vindue';
$string['lockoutwindow_desc'] = 'Observationstid for spærring af konto. Hvis der ikke er mislykkede loginforsøg, vil tælleren blive nulstillet efter det angivne tidsrum.';
$string['lockrequestcategory'] = 'Forhindr valg af kategori';
$string['log'] = 'Logs';
$string['logguests'] = 'Log gæsteadgang';
$string['logguests_help'] = 'Denne indstilling muliggør logning af handlinger foretaget af gæste-konti og brugere der ikke er logget ind. Sider med meget trafik bør overveje at deaktivere denne logning af ydelsesmæssige hensyn. Det anbefales at aktivere denne indstilling på en installation i drift.';
$string['logininfoinsecurelayout'] = 'Vis bruger der er logget ind i sikkert layout';
$string['logininfoinsecurelayout_desc'] = 'Er indstillingen aktiveret, vil det fulde navn på brugere der er logget ind ved brug af sikker layout, blive vist i navigationslinjen under besvarelse af en quiz eller andre aktiviteter';
$string['loginpageautofocus'] = 'Autofokuser formular på loginside';
$string['loginpageautofocus_help'] = 'Aktivering af denne indstilling forbedrer brugervenligheden på loginsiden, men autofokusfelter kan betragtes som værende et tilgængelighedsproblem.';
$string['loglifetime'] = 'Gem logs i';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Et komplet logo, der kan bruges som dekoration i nogle layouts (f.eks. kernetemaer). Dette billede kan have en ret høj opløsning, da det skaleres ned til brug (og lagres i cache for at forbedre ydeevnen). Logoer, der er bredere end høje, giver normalt bedre resultater.';
$string['logocompact'] = 'Kompakt logo';
$string['logocompact_desc'] = 'En kompakt udgave af det samme logo som ovenfor, f.eks. et emblem, et skjold eller et ikon. Billedet skal være tydeligt, selv i små størrelser.';
$string['logossettings'] = 'Logoer';
$string['logstorenotrequired'] = 'Loglager ikke obligatorisk';
$string['logstoressupported'] = 'Loglagre der understøtter denne rapport';
$string['longtimewarning'] = '<b>Bemærk at denne proces kan tage en rum tid.</b>';
$string['mailnewline'] = 'Tegn for ny linje i mail';
$string['maintenancemode'] = 'I vedligeholdelsestilstand';
$string['maintenancemodeisscheduled'] = 'Denne side overgår til vedligeholdesestilstand om {$a->min} min. {$a->sec} sek.';
$string['maintenancemodeisscheduledlong'] = 'Sitet sættes i vedligeholdelsestilstand om {$a->hour} tim. {$a->min} min. {$a->sec} sek.';
$string['maintfileopenerror'] = 'Fejl ved læsning af vedligeholdelsesfiler!';
$string['maintinprogress'] = 'Vedligeholdelse i gang...';
$string['managecontextlock'] = 'Frys dette indhold';
$string['managecontextlocklocked'] = '{$a->contextname} og underliggende kontekster er nu frosne.';
$string['managecontextlockunlocked'] = '{$a->contextname} og underliggende kontekster er nu tøet op.';
$string['managecontextunlock'] = 'Optø dette indhold';
$string['managecustomfields'] = 'Håndter brugerdefinerede felttyper';
$string['manageformats'] = 'Administrer kursusformater';
$string['manageformatsgotosettings'] = 'Standard formatet kan ændres i {$a}';
$string['managelang'] = 'Administrer';
$string['manageqbanks'] = 'Administrer plugins til spørgsmålsbanken';
$string['manageqbehaviours'] = 'Administrer spørgsmåls opførsel';
$string['manageqtypes'] = 'Administrer spørgsmålstyper';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Udgivelseskandidat';
$string['maturity200'] = 'Stabil version';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Tip: Du bør overveje at køre dette scrip med muligheden --allow-unstable';
$string['maturitycoreinfo'] = 'Dit site kører på ustabil "{$a}" udviklingskode.';
$string['maturitycorewarning'] = 'Den version af Moodle som du er ved at installere eller opgradere til, indeholder ustabil "{$a}" udviklingskode som ikke er hensigtsmæssigt til brug på de fleste sites i drift.

Hvis det ikke er det du ønsker, bør du sikre dig at du opdaterer fra en STABIL gren af Moodlekoden.

Se Moodle Docs for yderligere information.';
$string['maxbytes'] = 'Maksimal størrelse på uploadede filer';
$string['maxconsecutiveidentchars'] = 'Fortløbende ens tegn';
$string['maxeditingtime'] = 'Tidsrum ændring af forumindlæg';
$string['maxsizeperdownloadcoursefile'] = 'Maksimal filstørrelse';
$string['maxsizeperdownloadcoursefile_desc'] = 'Hvor stor hver fil må være når kursusindhold downloades. Filer over denne størrelse vil blive udeladt fra download.';
$string['maxtimelimit'] = 'Maksimal tidsgrænse';
$string['maxtimelimit_desc'] = 'For at begrænse den maksimale PHP-eksekveringstid som Moodle vil tillade uden at der kan vises output, kan du indtaste en værdi i sekunder her. 0 vil medføre at Moodles standardrestriktioner bruges. Hvis du har en front-end server med dens egen tidsgrænse, bør du sætte denne værdi til mindre for at modtage PHP-fejl i loggen. Vedrører ikke CLI-scripts.';
$string['maxusersperpage'] = 'Maksimalt antal brugere pr. side';
$string['mbstringrecommended'] = 'Det anbefales at installere/aktivere biblioteket MBSTRING for at forbedre webstedets ydeevne, især hvis sitet understøtter ikke-latinske sprog og tegn.';
$string['mbstringrequired'] = 'Installation af MBSTRING-biblioteket er nødvendig for at forbedre webstedets ydeevne, især hvis dit websted understøtter ikke-latinske sprog.';
$string['mediapluginavi'] = 'Aktiver .avi-filter';
$string['mediapluginflv'] = 'Aktiver .flv-filter';
$string['mediapluginimg'] = 'Aktiver automatisk indlejring af linkede billeder';
$string['mediapluginmov'] = 'Aktiver .mov-filter';
$string['mediapluginmp3'] = 'Aktiver .mp3-filter';
$string['mediapluginmpg'] = 'Aktiver .mpg-filter';
$string['mediapluginogg'] = 'Aktiver ogg-filter';
$string['mediapluginogv'] = 'Aktiver .ogv-filter';
$string['mediapluginram'] = 'Aktiver .ram-filter';
$string['mediapluginrm'] = 'Aktiver .rm-filter';
$string['mediapluginrpm'] = 'Aktiver .rpm-filter';
$string['mediapluginswf'] = 'Aktiver .swf-filter';
$string['mediapluginswfnote'] = 'Som en standard sikkerhedsforanstaltning bør almindelige brugere ikke have mulighed for at indlejre swf flash-filer.';
$string['mediapluginwmv'] = 'Aktiver .wmv-filter';
$string['mediapluginyoutube'] = 'Aktiver YouTube-linksfilter';
$string['messaging'] = 'Aktiver beskedsystem';
$string['messagingallowemailoverride'] = 'Tilsidesættelse af notifikationsmail';
$string['messagingallusers'] = 'Aktiver beskeder på tværs af kurser';
$string['messagingcategory'] = 'Beskedsystem';
$string['messagingdefaultpressenter'] = 'Send som standard beskeder med tryk på Enter-tasten';
$string['messagingdeleteallnotificationsdelay'] = 'Slet alle underretninger';
$string['messagingdeletereadnotificationsdelay'] = 'Slet læste beskeder';
$string['messagingssettings'] = 'Indstillinger for beskedsystem';
$string['minpassworddigits'] = 'Tal';
$string['minpasswordlength'] = 'Adgangskodelængde';
$string['minpasswordlower'] = 'Små bogstaver';
$string['minpasswordnonalphanum'] = 'Ikke-alfanumeriske tegn';
$string['minpasswordupper'] = 'Store bogstaver';
$string['misc'] = 'Diverse';
$string['mlbackendsettings'] = 'Backend-indstillilnger til maskinlæring';
$string['mnetrestore_extusers'] = '<strong>OBS!:</strong> Denne backupfil indeholder Moodle Network-brugerkonti fra en anden Moodleinstallation og disse vil blive gendannet som en del af processen.';
$string['mnetrestore_extusers_admin'] = '<strong>Bemærk:</strong> Denne backupfil stammer tilsyneladende fra en anden Moodleinstallation og indeholder brugerkonti fra eksterne Moodle Network. Gendannelsesprocessen vil forsøge at matche Moodle Network-hosts for alle oprettede brugere. De brugere der ikke kan matches, vil automatisk ændres til intern godkendelse (i stedet for mnet). Gendannelsesloggen indeholder informationer herom.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Bemærk:</strong> Denne backupfil lader til at være fra en anden Moodleinstallation og indeholder eksterne Moodle Netværk-brugerkonti, der kan fejle ved gendannelse. Denne operation er ikke supporteret. Hvis du er sikker på at den stammer fra denne Moodleinstallation, eller du er sikker på at alle de nødvendige Moodle Netværk Hosts er konfigureret, vil du måske alligevel vælge at gendanne.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Bemærk:</strong> Denne backupfil stammer tilsyneladende fra en anden Moodleinstallation og indeholder brugerkonti fra eksterne Moodle Network. Du har ikke tilladelse til at gennemføre denne type gendannelse. Kontakt sitets administrator, eller alternativt kan du vælge at gendanne kurset uden brugerinformation (moduler, filer...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Eksterne Moodle Network-bruger {$a->username} (fra {$a->mnethosturl}) flyttet til lokal {$a->auth} godkendt bruger.';
$string['mobilenotconfiguredwarning'] = 'Moodles Mobil-app er ikke aktiveret';
$string['modassignmentinuse'] = 'Dit site bruger stadig Assignment 2.2 plugin. Før opgradering skal du 1) tage backup af alle Assignment 2.2 aktiviteter, som du ønsker at beholde, og gendanne dem som Assignment aktiviteter, og 2) slette alle Assignment 2.2 data fra databasen.';
$string['modassignmentsubpluginsexist'] = 'Assignment 2.2 subplugins kan være til stede. Modulet /assignment mappen og alle dens subplugins skal fjernes før opgradering.';
$string['modeditdefaults'] = 'Standardværdier i indstillingerne for aktiviteter';
$string['modsettings'] = 'Administrer aktiviteter';
$string['modulesecurity'] = 'Modulsikkerhed';
$string['moodleapp'] = 'Moodle-app';
$string['moodleapp_help'] = '<p>Med den gratis Moodle-app kan brugere tilgå deres kurser på mobile enheder. Ekstra funktioner fås med en Pro eller Premium app plan.
<a href="https://moodle.com/mobile-app">Hent Moodle-appen</a><br />
<a href="https://apps.moodle.com">Moodle Apps Portal</a>';
$string['moodlebrandedapp'] = 'Moodles firma-app';
$string['moodlebrandedapp_help'] = '<p>Moodle-appen med firmanavn har samme funktionalitet som vores gratis app kombineret med et skræddersyet udseende og navn.</p>
<a href="https://moodle.com/branded-app">Om Moodles firma-app</a>';
$string['moodlebrandedappreference'] = 'Alternativt kan du vælge en <a href="https://moodle.com/branded-app/">Moodle-app med firmanavn</a> og dit eget skræddersyede layout.';
$string['moodlepartners'] = 'Moodle Partners';
$string['moodlepartners_help'] = 'Moodle Partners er serviceudbydere der er certificeret af Moodle HQ til at levere Moodleservice af høj kvalitet til din organisations e-læringsmiljø.<br>
<a href="https://moodle.com/about-partners/">Om vores partnere</a><br>
<a href="https://moodle.com/partners">Find en Moodle-partner</a>';
$string['moodleservices'] = 'Moodleservice';
$string['moodleservices_help'] = 'Vær sikker på at få det bedste ud af dit læringsmiljø i Moodle ved at bruge disse Moodleservicer:';
$string['multilangforceold'] = 'Gennemtving den gamle flersprogssynkaks: &lt;span&gt; uden class="multilang" og &lt;lang&gt;';
$string['mustenablestats'] = 'Statistik er endnu ikke aktiveret på dette websted.';
$string['mycourses'] = 'Mine kurser';
$string['mycoursesperpage'] = 'Antal kurser';
$string['mydashboard'] = 'Standard systembetjeningspanel';
$string['mymoodle'] = 'Betjeningspanel';
$string['mymoodleredirect'] = 'Tving brugere til at bruge "Min Moodle"';
$string['mypage'] = 'Standard betjeningspanelside';
$string['mypagelocked'] = 'Lås standardside';
$string['myprofile'] = 'Standard profilside';
$string['navadduserpostslinks'] = 'Tilføj links til brugers forumindlæg';
$string['navadduserpostslinks_help'] = 'Er indstillingen aktiveret, vil to links tilføjes navigationsblokken til hhv. de tråde brugeren har oprettet, og de indlæg brugeren har sendt til fora på sitet.';
$string['navcourselimit'] = 'Antal kurser vist';
$string['navigationupgrade'] = 'Denne opgradering introducerer to nye navigationsblokke, der vil erstatte disse blokke: Administration, Kurser, Aktiviteter og Deltagere. Hvis du havde sat særlige tilladelser på de blokke, du bør tjekke at alt opfører sig som du ønsker det.';
$string['navshowallcourses'] = 'Vis alle kurser';
$string['navshowcategories'] = 'Vis kursuskategorier';
$string['navshowfrontpagemods'] = 'Vis forside-aktiviteter i navigationen';
$string['navshowfrontpagemods_help'] = 'Er indstillingen aktiveret, vises forside-aktiviteter i navigationen under webstedssider. Vedrører kun layouts baseret på Classic.';
$string['navshowfullcoursenames'] = 'Vis kursers fulde navne';
$string['navshowfullcoursenames_help'] = 'Er indstillingen aktiveret, vil kursets fulde navn blive brugt i navigationen i stedet for det korte navn.';
$string['navshowmycoursecategories'] = 'Vis mine kurser efter kategori';
$string['navshowmycoursecategories_help'] = 'Er indstillingen aktiveret, vises listen over mine kurser efter kategori (gælder kun Classic-baserede layouts).';
$string['navsortmycourseshiddenlast'] = 'Sorter mine skjulte kurser til sidst';
$string['navsortmycourseshiddenlast_help'] = 'Er indstillingen aktiveret, vil skjulte kurser vises efter synlige (for brugere der kan se skjulte kurser). Ellers vil alle kurser uanset synlighed vises i overensstemmelse med indstillingen "Sorter mine kurser".';
$string['navsortmycoursessort'] = 'Rækkefølge af kurser i navigationsblokken';
$string['navsortmycoursessort_help'] = 'Skal kurserne vises i den sorteringsrækkefølge, der er angivet i Webstedsadministration > Kurser > Administrer kurser og kategorier, eller alfabetisk efter kursusindstilling? Denne indstilling gælder kun for Classic-baserede layouts.';
$string['never'] = 'Aldrig';
$string['neverdeleteruns'] = 'Slet aldrig kørsler';
$string['newestdocindexed'] = 'Nyeste dokument indekseret';
$string['nobookmarksforuser'] = 'Du har ingen bogmærker';
$string['nodatabase'] = 'Ingen database';
$string['noemaileverwarning'] = '<strong>Bemærk:</strong> Alle udgående e-mails er blevet deaktiveret';
$string['nohttpsformobilewarning'] = 'Det anbefales at aktivere https med et gyldigt certifikat. Moodle vil altid først forsøge at bruge en sikker forbindelse.';
$string['nomissingstrings'] = 'Alle strenge er oversat.';
$string['none'] = 'Ingen';
$string['nonewsettings'] = 'Der er ikke tilføjet nye indstillinger ved denne opdatering';
$string['nonexistentbookmark'] = 'Det efterspurgte bogmærke eksisterer ikke';
$string['noreplyaddress'] = 'Noreply-adresse';
$string['noreplydomain'] = 'Noreply og domæne';
$string['noreplydomaindetail'] = 'Indstillinger for noreply og konfigurerede domæner';
$string['noresults'] = 'Ingen resultater fundet';
$string['noroles'] = 'Ingen roller';
$string['nosupportedlogstore'] = 'Ingen understøttede loglagre fundet';
$string['noteunneededblocks'] = 'Bemærk: Blokke, der er indstillet til at blive vist, vil ikke blive vist i menuen "Tilføj en blok" på et kursus, hvis de er angivet i layoutindstillingen "Unødvendige blokke".';
$string['notifications'] = 'Meddelelser';
$string['notifyloginfailures'] = 'E-mail fejlslagne logins til';
$string['notifyloginthreshold'] = 'Begrænsning for e-mailmeddelelser';
$string['notloggedinroleid'] = 'Rolle til besøgende';
$string['numberofmissingstrings'] = 'Antal tomme strenge: {$a}';
$string['numberofstrings'] = 'Antal strenge: {$a->strings}<br />Heraf ikke oversatte: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Opdaterings-token\'et for en af OAuth-servicerne {$a->issuer} på dit websted {$a->siteurl} er udløbet. Det vil begrænse funktionaliteten på plugins der bruger denne service. Problemet klares ved at besøge konfigurationssiden for OAuth 2 Servicer og klikke på ikonet "Connect system account" i tabelrækken for denne service. Husk at logge ind med samme servicekonto til OAuth-systemet hver gang.';
$string['oauthrefreshtokenexpiredshort'] = 'Opdaterings-token\'et er udløbet for {$a->issuer} på dit websted {$a->siteurl}.';
$string['onlynoreply'] = 'Kun hvis fra en noreply-adresse';
$string['opcacherecommended'] = 'PHP opcode caching forbedrer ydeevnen og nedsætter krav til memory. OPcache-filtypen anbefales og er fuldt understøttet.';
$string['opensslrecommended'] = 'Det anbefales kraftigt at der installeres det valgfrie bibliotek OpenSSL - det muliggør aktivering af Moodle Networking-funktionaliteten';
$string['opensslrequired'] = 'OpenSSL PHP-udvidelsen kræves nu af Moodle for at kunne give en stærkere kryptografisk service.';
$string['opentowebcrawlers'] = 'Åben for Google';
$string['optionalmaintenancemessage'] = 'Besked der vises under vedligeholdelse af webstedet.';
$string['oracledatabaseinuse'] = 'Oracle DB-support fjernes. Moodle 4.5 vil være den sidste version med Oracle DB-support. For detaljer, se meddelelsen på moodle.org <a href="Afskrivning" target="_blank" rel="noreferrer">https://moodle.org/mod/forum/discuss.php?d=456122">Afskrivning af Oracle-databasesupport i LMS</a>';
$string['order1'] = 'Første';
$string['order2'] = 'Anden';
$string['order3'] = 'Tredje';
$string['order4'] = 'Fjerde';
$string['outgoingmailconfig'] = 'Konfiguration af udgående mail';
$string['overridetossl'] = 'HTTPS til login er nu forældet. Dette site er nu tvunget til SSL. Fjern denne advarsel ved at redigere config.php så wwwroot står med https://';
$string['pageinfodebugsummary'] = 'Denne side er: {$a}';
$string['passwordchangelogout'] = 'Log ud efter ændring af adgangskode';
$string['passwordchangelogout_desc'] = 'Er indstillingen aktiveret, vil alle browsersessioner afsluttes ved ændring af adgangskode - bortset fra den hvorfra den nye adgangskode er angivet. (Denne indstilling har ikke indflydelse på adgangskodeændringer via massebrugerupload).';
$string['passwordchangetokendeletion'] = 'Fjern webservices adgangs-token når adgangskoden er ændret';
$string['passwordchangetokendeletion_desc'] = 'Er indstillingen aktiveret, vil alle adgangs-tokens til webservice slettes når en adgangskode er ændret.';
$string['passwordpolicy'] = 'Adgangskodepolitik';
$string['passwordpolicycheckonlogin'] = 'Tjek adgangskode ved login';
$string['passwordresettime'] = 'Maksimal tid til at validere anmodning om nulstilling af adgangskode';
$string['passwordreuselimit'] = 'Rotationsgrænse for adgangskode';
$string['passwordreuselimit_desc'] = 'Antal gange en bruger skal ændre adgangskode før den må genbruges. Hashes af tidligere brugte koder gemmes i en lokal database. Denne funktion er muligvis ikke kompatibel med eksterne godkendelsesplugins.';
$string['pathtodot'] = 'Sti til dot';
$string['pathtodot_help'] = 'Stien til dot. I Linux noget i stil med /usr/bin/dot. I Windows noget a la C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe, og på Mac noget i retning af /opt/local/bin/dot. For at kunne generere grafik fra dot-filer skal du have en eksekverbar dot installeret og pege på den her.';
$string['pathtodu'] = 'Sti til du';
$string['pathtogs'] = 'Sti til ghostscrip';
$string['pathtogs_help'] = 'På de fleste Linuxinstallationer, kan denne sti angives som "/usr/bin/gs". På Windows bør stien være "c:\\gs\\bin\\gswin32c.exe" (vær sikker på at der ikke mellemrum i stien - om nødvendigt kan du kopiere filerne "gswin32c.exe" and "gsdll32.dll" til en ny mappe uden mellemrum i stien)';
$string['pathtopdftoppm'] = 'Sti til pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> er et bibliotek til PDF-rendering, som indeholder værktøjet pdftoppm til konvertering af PDF-filer til PNG. Ydelsen er generelt bedre end ved brug af Ghostscript, især for store filer. Hvis pdftoppm er til rådighed, vil det blive brugt frem for Ghostscript. På de fleste Linux-installationer kan stien angives som /usr/bin/pdftoppm. Ellers skal du installere pakken poppler-utils eller poppler, afhængigt af din Linux-distribution. På Windows leveres den af Cygwin-installationer.';
$string['pathtopgdump'] = 'Sti til pg_dump';
$string['pathtopgdumpdesc'] = 'Dette er kun nødvendigt hvis du har mere end en pg_dump installeret på serveren (f.eks. hvis der er flere versioner af postgresql installeret)';
$string['pathtopgdumpinvalid'] = 'Ugyldig sti til pg_dump - enten er den forkert eller også er den ikke eksekverbar.';
$string['pathtophp'] = 'Sti til PHP CLI';
$string['pathtopsql'] = 'Sti til psql';
$string['pathtopsqldesc'] = 'Dette er kun nødvendigt hvis du har mere end en psql installeret på serveren (f.eks. hvis der er flere versioner af postgresql installeret)';
$string['pathtopsqlinvalid'] = 'Forkert sti til psql - enten en forkert sti eller den er ikke eksekverbar.';
$string['pathtopython'] = 'Sti til Python';
$string['pathtopythondesc'] = 'Sti til dit Python-program (både Python 2 og Python 3 accepteres).';
$string['pathtosassc'] = 'Sti til SassC';
$string['pathtosassc_help'] = 'Specificering af placeringen af den binære SassC vil skifte SASS-kompileren fra Moodles PHP-implementering til SassC. Se mere på siden https://github.com/sass/sassc';
$string['pcreunicodewarning'] = 'Det anbefales kraftigt at bruge PCRE PHP-filformat som er kompatibelt med Unicodetegn.';
$string['perfdebug'] = 'Ydeevne info';
$string['perfdebugdeferred'] = 'Venter til scriptet er færdigt med at vise performance debuginformation ...';
$string['performance'] = 'Ydeevne';
$string['pgcluster'] = 'PostgreSQL Klynge';
$string['pgclusterdescription'] = 'PostgreSQL-version/cluster-parameter til brug for kommandolinjeoperationer. Har du kun en postgresql på serveren eller du ikke er sikker på hvad det er, kan du lade feltet stå tomt.';
$string['phpfloatproblem'] = 'Uventet problem observeret ved håndtering af php-\'float\'-numre - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Din side er registreret hos moodle.org, det skete sidst {$a}.<br />Den planlagte opgave "Sideregistrering" holder din registrering ajour. Du kan også altid manuelt opdatere registreringen.';
$string['pleaserefreshregistrationnewdata'] = 'Registreringsinformationerne er ændret. Bekræft det med knappen "Opdater registrering"';
$string['pleaserefreshregistrationunknown'] = 'Dit site er registreret men registreringsdatoen er ukendt. Opdater din registrering vha. knappen "Opdater registrering" eller tilsikr dig at den planlagte "Site registrering" er aktiveret så din registrering automatisk opdateres';
$string['plugin'] = 'Plugin';
$string['plugin_disabled'] = '{$a} deaktiveret.';
$string['plugin_enabled'] = '{$a} aktiveret.';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Tjek plugin-afhængigheder';
$string['pluginscheckfailed'] = 'Afhængighedstjek mislykkedes for {$a->pluginslist}';
$string['pluginschecktodo'] = 'Du skal adressere alle plugin-kravene før du fortsætter med at installere denne Moodleversion!';
$string['pluginsoverview'] = 'Plugin-oversigt';
$string['pluginsoverviewsee'] = 'Se yderligere oplysninger i <a href="{$a->url}">Plugin-oversigten</a>';
$string['policysettings'] = 'Politikindstillinger';
$string['privacy:metadata'] = 'Plugin\'et Administration gemmer ingen personlige data.';
$string['privacyandpolicies'] = 'Privatlivsbeskyttelse og politikker';
$string['privacysettings'] = 'Indstillinger for privatlivsbeskyttelse';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Kategorinavn (skal være unikt)';
$string['profilecategorynamenotunique'] = 'Dette navn bruges allerede til en anden kategori';
$string['profilecommonsettings'] = 'Almindelige indstillinger';
$string['profileconfirmcategorydeletion'] = 'Der er {$a} felt(er) i denne kategori som vil blive flyttet til den overliggende kategori (eller under hvis den er i øverste kategori).<br />Ønsker du stadig at slette kategorien?';
$string['profileconfirmfielddeletion'] = 'Der er {$a} brugerpost(er) for dette felt som vil blive slettet. <br />Ønsker du stadig at slette dette felt?';
$string['profilecreatecategory'] = 'Opret en ny profilkategori';
$string['profilecreatefield'] = 'Opret et nyt profilfelt';
$string['profilecreatenewcategory'] = 'Opretter en ny kategori';
$string['profilecreatenewfield'] = 'Opretter et nyt &quot;{$a}&quot; profilfelt';
$string['profiledefaultcategory'] = 'Andre felter';
$string['profiledefaultchecked'] = 'Angivet som standard';
$string['profiledefaultdata'] = 'Standardværdi';
$string['profiledeletecategory'] = 'Sletter en kategori';
$string['profiledeletefield'] = 'Sletter feltet "{$a}"';
$string['profiledescription'] = 'Beskrivelse af feltet';
$string['profiledscript'] = 'Dette script er profileret';
$string['profiledscriptview'] = 'Se profileringsinformation for dette script';
$string['profileeditcategory'] = 'Redigerer kategorien {$a}';
$string['profileeditfield'] = 'Redigerer profilfeltet {$a}';
$string['profilefield'] = 'Profilfelt';
$string['profilefieldcolumns'] = 'Kolonner';
$string['profilefieldispassword'] = 'Er dette et felt til adgangskode?';
$string['profilefieldlink'] = 'Link ';
$string['profilefieldlink_help'] = 'For at ændre teksten til et link, indtast en URL indeholdende $$ hvor $$ vil blive erstattet med teksten. Indtast for eksempel https://twitter.com/$$ for at ændre et Twitter-ID til et link';
$string['profilefieldlinktarget'] = 'Link-destination';
$string['profilefieldmaxlength'] = 'Maksimal længde';
$string['profilefieldmaxlength_help'] = 'Hvis du vil bruge dette felt i indstillingen "Vis brugeridentitet", skal grænsen være 255 tegn eller mindre.';
$string['profilefieldrows'] = 'Rækker';
$string['profilefields'] = 'Brugerprofilfelter';
$string['profilefieldsize'] = 'Vis størrelse';
$string['profileforceunique'] = 'Skal data være unik?';
$string['profileinvaliddata'] = 'Ugyldig værdi';
$string['profilelocked'] = 'Er dette felt låst?';
$string['profilemenudefaultnotinoptions'] = 'Standardværdien er ikke en af valgmulighederne';
$string['profilemenunooptions'] = 'Ingen menumuligheder angivet';
$string['profilemenuoptions'] = 'Menupunkter (et pr. linje)';
$string['profilemenutoofewoptions'] = 'Der skal være mindst 2 muligheder';
$string['profilename'] = 'Navn';
$string['profilenofieldsdefined'] = 'Der er ikke defineret nogen felter';
$string['profilerequired'] = 'Er dette felt obligatorisk?';
$string['profileroles'] = 'Synlige profilroller';
$string['profilesforenrolledusersonly'] = 'Profiler kun for tilmeldte brugere';
$string['profileshortname'] = 'Kort navn (skal være unikt)';
$string['profileshortnameinvalid'] = 'Dette korte navn kan kun have alfanumeriske tegn (bogstaver og tal) eller understreg (_)';
$string['profileshortnamenotunique'] = 'Dette korte navn er allerede i brug';
$string['profilesignup'] = 'Vis på tilmeldings-side?';
$string['profilespecificsettings'] = 'Specifikke indstillinger';
$string['profilevisible'] = 'Hvem må feltet være synligt for?';
$string['profilevisible_help'] = '* Ikke synlig - Til private data der kun kan ses af administratorer
* Synlig for brugeren - Til private data der kun kan ses af brugeren og administratorer
* Synlig for brugeren, lærere og administratorer - For private data, der kun kan ses af brugeren, administratorer og lærere (på kursusprofilen)
* Synlig for alle';
$string['profilevisibleall'] = 'Synlig for alle';
$string['profilevisiblenone'] = 'Ikke synlig';
$string['profilevisibleprivate'] = 'Synlig for brugeren';
$string['profilevisibleteachers'] = 'Synlig for brugere, lærere og administratorer';
$string['profiling'] = 'Profilering';
$string['profilingallowall'] = 'Kontinuerlig profilering';
$string['profilingallowall_help'] = 'Aktiverer du denne indstilling, kan du altid bruge PROFILEALL-parameteret (PGC) overalt til at aktivere profilering af alle kørte scripts i en Moodlesession. Tilsvarende kan du bruge PROFILEALLSTOP-parameteret til at standse den.';
$string['profilingallowme'] = 'Selektiv profilering';
$string['profilingallowme_help'] = 'Aktiverer du denne indstilling, kan du overalt selektivt bruge parameteret PROFILEME (PGC) og dermed profilere scriptet. Tilsvarende kan du bruge parameteret DONTPROFILEME til at undgå profilering';
$string['profilingautofrec'] = 'Automatisk profilering';
$string['profilingautofrec_help'] = 'Ved konfigurering af denne indstilling vil nogle forespørgsler vælges (tilfældigt valgt baseret på  den angivne frekvens - 1 af N), automatisk profileres og resultater gemt til videre analyse. Bemærk at denne profileringsmetode følger indstillingerne for inkluder/ekskluder. Deaktiver automatisk profilering med et 0.';
$string['profilingenabled'] = 'Aktiver profilering';
$string['profilingenabled_help'] = 'Aktiverer du denne indstilling, vil profilering være tilgængelig på dette site og du vil kunne konfigurere hvordan i de næste indstillinger.';
$string['profilingexcluded'] = 'Ekskluder profilering';
$string['profilingexcluded_help'] = 'Liste med URL\'er (comma or newline separated, absolute skipping wwwroot, callable) der vil blive ekskluderet fra dem der er defineret i indstillingen "Profiler disse"';
$string['profilingimportprefix'] = 'Præfiks til profileringsimport';
$string['profilingimportprefix_desc'] = 'Alle importerede profileringer vil få dette præfiks, så de er nemmere at få øje på.';
$string['profilingincluded'] = 'Profiler disse';
$string['profilingincluded_help'] = 'Liste over (komma- eller linjeskift-separerede,  wwwroot undertage, kaldbare) URLs, der automatisk vil blive profileret. Eksempler: /index.php, /course/view.php. Accepterer også * wildchar på enhver position. Eksempler: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Bevar profilering kører';
$string['profilinglifetime_help'] = 'Angiv den tid, du vil beholde oplysninger om gamle profileringer. Ældre beskæres med jævne mellemrum. Bemærk, at dette udelukker enhver profilering, der er markeret som "referencekørsel".';
$string['profilingslow'] = 'Profiler langsomme sider';
$string['profilingslow_help'] = 'Ved at indstille en minimumstid i sekunder profileres alle langsommere sider. Kun profiler, der er langsommere end en eksisterende profil for det samme script, bevares. Sæt til 0 for at deaktivere. Bemærk, at dette overholder ekskluderingsindstillingerne.';
$string['protectusernames'] = 'Beskyt brugernavne';
$string['proxybypass'] = 'Proxy-bypass-værter';
$string['proxyfixunsafe'] = 'ret uproxiede kald';
$string['proxyhost'] = 'Proxy-vært';
$string['proxylogunsafe'] = 'Log uproxiede kald';
$string['proxypassword'] = 'Proxy-kode';
$string['proxyport'] = 'Proxyport';
$string['proxytype'] = 'Proxytype';
$string['proxyuser'] = 'Proxy-brugernavn';
$string['purgecaches'] = 'Ryd al cache';
$string['purgecachesconfirm'] = 'Moodle kan gemme layouts, javascript, sprogstrenge, filtreret tekst, rss-feeds og mange andre kalkulerede data i et mellemlager, cachen. Rydning af mellemlagre vil slette disse data fra servere og tvinge browsere til at genindlæse dem, så du kan være sikker på at se de seneste, mest opdaterede værdier genereret ud fra den aktuelle kode. Der er ingen farer forbundet med rydning af cachen, men dit site kan fremtræde lidt langsommere indtil serveren og klienter har kalkuleret de nye data og lagt dem i cachen.';
$string['purgecachesfinished'] = 'Al cache er ryddet';
$string['purgecachesnoneselected'] = 'Vælg en eller flere cache der skal ryddes';
$string['purgecachespage'] = 'Ryd cache';
$string['purgefiltercache'] = 'Tekstfiltre';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Sprogstrenge';
$string['purgemuc'] = 'Alle MUC-caches';
$string['purgeothercaches'] = 'Alle fil- og diverse andre caches';
$string['purgeselectedcaches'] = 'Ryd valgt cache';
$string['purgeselectedcachesfinished'] = 'Alle de valgte cache blev ryddet.';
$string['purgetemplates'] = 'Skabeloner';
$string['purgethemecache'] = 'Layouts';
$string['query'] = 'Forespørgsel';
$string['question'] = 'Spørgsmål';
$string['questionbehaviours'] = 'Spørgsmåls opførsel';
$string['questioncwqpfscheck'] = 'Et eller flere tilfældige spørgsmål er sat til valg af spørgsmål fra et miks af delte og ikke delte spørgsmålskategorier. Se den <a href="{$a->reporturl}">mere detaljerede rapport her</a>, og se også <a href="{$a->docsurl}">Moodle Docs</a>.';
$string['questioncwqpfsok'] = 'Godt. Der er ikke nogen "tilfældige" spørgsmål i dine quizzer som er indstillet til at udvælge spørgsmål fra en blanding af delte og udelte spørgsmålskategorier.';
$string['questiontype'] = 'Spørgsmålstype';
$string['questiontypes'] = 'Spørgsmålstyper';
$string['quizattemptsupgradedmessage'] = 'I Moodle 2.1 var der en større opgradering af spørgsmål. Det var dengang muligt at udskyde dele af databaseopdateringen til at blive kørt senere. Før opgradering til Moodle 2.7 skal denne opgradering være færdiggjort.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA\'s hemmelige (private) nøgle';
$string['recaptchapublickey'] = 'ReCAPTCHA\'s (offentlige) webstedsnøgle';
$string['referrernone'] = 'Browserstandard';
$string['referrerpolicy'] = 'Referrer-politik';
$string['referrerpolicydesc'] = 'Indstil headeren Referrer Policy til at blive inkluderet i svar fra dit websted.';
$string['register'] = 'Registrer dit site';
$string['registration'] = 'Registrering';
$string['registration_help'] = 'Som registreret:

* Vil du modtage sikkerhedsadvarsler
* Kan du aktivere mobilappens push-meddelelser fra dit site
* Bidrager du til Moodles statistik over det verdensomspændende fællesskab';
$string['registrationwarning'] = 'Dit site er endnu ikke registreret.';
$string['registrationwarningcontactadmin'] = 'Dit site er endnu ikke registreret. Underret gerne administrator.';
$string['releasenoteslink'] = 'For information om denne version af Moodle, se online <a target="_blank" href="{$a}">udgivelsesbemærkningerne </a>';
$string['rememberuserlicensepref'] = 'Husk brugeres licens-indstillinger';
$string['rememberuserlicensepref_help'] = 'Er indstillingen aktiveret, vil brugerens senest valgte licens være foreslået når en fil uploades i filvælgeren. Ellers vil sitets standardlicens være valgt på forhånd.';
$string['rememberusername'] = 'Husk brugernavn';
$string['rememberusername_desc'] = 'Aktiver denne hvis du ønsker at gemme permanente cookies med brugernavne under brugerlogin. Permanente cookies kan anses for at være et brud på privatlivets fred hvis disse bruges uden samtykke.';
$string['replacefrontsearch'] = 'Bruges til søgning på sitets startside';
$string['reportsmanage'] = 'Administrer rapporter';
$string['required'] = 'Påkrævet';
$string['requiredentrieschanged'] = 'Bemærk: Efter opgradering er indstillingen "Krævede poster før visning" påtvunget i de følgende databaseaktiviteter:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Kræver beskrivelse af aktivitet';
$string['requiremodintro_desc'] = 'Er indstillingen aktiveret, vil brugere blive tvunget til at angive en beskrivelse for hver aktivitet';
$string['requires'] = 'Kræver';
$string['resetindentation'] = 'Nulstil indrykning på tværs af hele sitet';
$string['resetindentation_help'] = 'Dette vil fjerne enhver indrykning, der tidligere er sat for alle kurser på sitet i {$a->format}.';
$string['resetindentation_title'] = 'Nulstil indrykning på tværs af hele sitet?';
$string['resetindentationsuccess'] = 'Indrykning nulstillet';
$string['restorecourse'] = 'Gendan et kursus';
$string['restorernewroleid'] = 'Rolle til den der har gendannet kurset';
$string['restorernewroleid_help'] = 'Hvis brugeren ikke allerede har tilladelse til at redigere et nyligt gendannet kursus, vil vedkommende automatisk få denne rolle og om nødvendigt tilmeldes kurset. Vælg "Ingen" hvis ikke du vil have at alle, der gendanner kurser, skal kunne redigere alle gendannede kurser.';
$string['resultfilter'] = 'Filtrer efter resultater';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignorer reverse proxies';
$string['riskconfig'] = 'Brugere kunne ændre webstedets indstillinger og funktion.';
$string['riskconfigshort'] = 'Konfigurationsrisiko';
$string['riskdataloss'] = 'Brugere kunne ødelægge store mængder indhold eller oplysninger';
$string['riskdatalossshort'] = 'Risiko for tab af data';
$string['riskmanagetrust'] = 'Brugere kunne ændre personlige indstillinger for andre brugere';
$string['riskmanagetrustshort'] = 'Administrer trusts';
$string['riskpersonal'] = 'Brugere kunne opnå adgang til private informationer om andre brugere.';
$string['riskpersonalshort'] = 'Privatlivs risiko';
$string['riskspam'] = 'Brugere kunne sende spam til webstedsbrugere eller andre.';
$string['riskspamshort'] = 'Spam risiko';
$string['riskxss'] = 'Brugere kunne uploade filer og tekster der kunne bruges til cross-site scripting (XSS)';
$string['riskxssshort'] = 'XSS riskiko';
$string['roleswithexceptions'] = '{$a->roles}, med {$a->exceptions}';
$string['rssglobaldisabled'] = 'Deaktiveret på siteniveau';
$string['save'] = 'Gem';
$string['savechanges'] = 'Gem ændringer';
$string['scssinvalid'] = 'SCSS-koden er ugyldig, fejler med: {$a}';
$string['search'] = 'Søg';
$string['searchablecourses'] = 'Søgbare kurser';
$string['searchallavailablecourses'] = 'Søgbare kurser';
$string['searchallavailablecourses_desc'] = 'I visse situationer kan søgemaskinen fejle når der søges i mange kurser samtidig. Vælg "Søg kun i kurser brugeren deltager på" hvis du vil begrænse antallet af gennemsøgte kurser.';
$string['searchallavailablecourses_off'] = 'Søg kun i kurser brugeren deltager på';
$string['searchallavailablecourses_on'] = 'Søg i alle kurser brugeren har adgang til';
$string['searchallavailablecoursesdesc'] = 'Søgning kun i tilmeldte kurser begrænser søgning til kun at omfatte kursusnavn, -beskrivelse og -indhold i kurser som brugeren er tilmeldt. Ellers vil søgning omfatte kursusinformation og -indhold i alle kurser brugeren har adgang til, såsom kurser med gæsteadgang.';
$string['searchalldeleted'] = 'Alt indekseret indhold er slettet';
$string['searchalternatesettings'] = 'Alternative indstillinger kun ved forespørgsel';
$string['searchalternatesettings_desc'] = 'Hvis du fuldfører disse indstillinger, kan du vælge "alternative indstillinger" for denne søgemaskine i indstillingen for søgemaskinen "Kun forespørgsler" på siden "Administrer global søgning". Dette er kun relevant, når du skifter mellem to søgemaskiner af samme type.';
$string['searchareadisabled'] = 'Søgefelt deaktiveret';
$string['searchareaenabled'] = 'Søgefelt aktiveret';
$string['searchareas'] = 'Søgefelter';
$string['searchbanner'] = 'Søgeoplysninger';
$string['searchbannerenable'] = 'Vis søgeoplysninger';
$string['searchbannerenable_desc'] = 'Er indstillingen aktiveret, vises teksten nedenfor øverst på søgeskærmen for alle brugere. Dette kan bruges til at informere brugerne, når vedligeholdelse af søgemaskine udføres.';
$string['searchdefaultcategory'] = 'Standard søgekategori';
$string['searchdefaultcategory_desc'] = 'Resultater fra det valgte søgeområdes kategori vil blive vist som standard.';
$string['searchdeleteindex'] = 'Slet al indekseret indhold';
$string['searchdisplay'] = 'Visningsmuligheder for søgeresultater';
$string['searchenablecategories'] = 'Vis resultater i separate kategorier';
$string['searchenablecategories_desc'] = 'Er indstillingen aktiveret, vises søgeresultater i separate kategorier.';
$string['searchengine'] = 'Søgemaskine';
$string['searchenginealternatesettings'] = '{$a} (alternate settings)';
$string['searchenginequeryonly'] = 'Søgemaskine kun til forespørgsler';
$string['searchenginequeryonly_desc'] = 'Denne søgemaskine vil kun blive brugt til at foretage forespørgsler, ikke indeksering. Ved at bruge denne funktion kan du genindeksere i en anden søgemaskine, mens brugerforespørgsler fortsætter på denne.';
$string['searchenginequeryonly_none'] = 'Ingen (brug hovedsøgemaskinen til forespørgsler)';
$string['searchenginequeryonlysame'] = 'Søgemaskinen kun til forespørgsler og hovedsøgemaskinen kan ikke have samme værdi.';
$string['searchhideallcategory'] = 'Skjul alle resultaters kategori';
$string['searchhideallcategory_desc'] = 'Er indstillingen markeret, vil kategorien med alle resultater være skjult på siden med søgeresultater';
$string['searchincludeallcourses'] = 'Inkluder alle synlige kurser';
$string['searchincludeallcourses_desc'] = 'Er indstillingen aktiveret, vil søgeresultater medtage synlige kursers navn og beskrivelse, også hvis brugeren ikke har adgang til kursernes indhold.';
$string['searchindexactions'] = 'Indekshandlinger';
$string['searchindexdeleted'] = 'Indeks slettet';
$string['searchindextime'] = 'Tidsbegrænsning for indeksering';
$string['searchindextime_desc'] = 'Når store mængder indhold skal indekseres, vil den planlagte kørsel stoppe når dette tidsrum er nået, og fortsætte igen ved næste kørsel.';
$string['searchindexupdated'] = 'Søgemaskineindhold er opdateret';
$string['searchindexwhendisabled'] = 'Indekser når deaktiveret';
$string['searchindexwhendisabled_desc'] = 'Tillader den planlagte kørsel at opbygge søgeindekset selv når søgning er deaktiveret. Det kan være hensigtsmæssigt hvis søgefunktionen skal gøres klar til brug inden den er åben for deltagerne.';
$string['searchinsettings'] = 'Søg i indstillingerne';
$string['searchlastrun'] = 'Sidste kørsel (time, # docs, # records, # ignores)';
$string['searchmanagement'] = 'Søgningshåndtering';
$string['searchmanagement_desc'] = 'Disse muligheder kan bruges, når du foretager ændringer på websteder med meget store søgeindekser, der tager lang tid at genopbygge.';
$string['searchmaxtopresults'] = 'Maksimalt antal topresultater';
$string['searchmaxtopresults_desc'] = 'Det største antal højest rangerede resultater, der skal vises over søgeresultaterne for kursusindhold, kurser og brugere.';
$string['searchnotavailable'] = 'Søgning er ikke tilgængelig';
$string['searchoptions'] = 'Søgeindstillinger';
$string['searchpartial'] = '(endnu ikke helt indekseret)';
$string['searchreindexed'] = 'Al siteindhold er genindekseret.';
$string['searchreindexindex'] = 'Genindekser al siteindhold';
$string['searchresults'] = 'Søgeresultater';
$string['searchsetupinfo'] = 'Indstillinger for søgning';
$string['searchteacherroles'] = 'Lærerroller';
$string['searchteacherroles_desc'] = 'Vælg alle roller, der får brugere med rollen til at stå højere i søgeresultaterne.';
$string['searchtopresults'] = 'Bedste resultater';
$string['searchupdateindex'] = 'Opdater indekseret indhold';
$string['sectionerror'] = 'Sektionsfejl!';
$string['secureforms'] = 'Ekstra sikkerhed ved formularer';
$string['security'] = 'Sikkerhed';
$string['selectdevice'] = 'Vælg enhed';
$string['selectsearchengine'] = 'Vælg søgemaskine';
$string['selecttheme'] = 'Vælg layout';
$string['server'] = 'Server';
$string['serverchecks'] = 'Serverkontrol';
$string['serverlimit'] = 'Serverens grænse';
$string['servicespage'] = 'Service og support link';
$string['sessionautostartwarning'] = '<p>Alvorlig konfigurationsfejl opdaget, underret serveradministratoren. </p><p> For at Moodle kan køre tilfredsstillende, er det påkrævet at administrator ændrer php-indstillingerne.</p><p><code>session.auto_start</code> bør indstilles til <code>off</code>.</p><p>Denne indstilling kontrolleres ved redigering af <code>php.ini</code>, Apache/IIS <br />konfiguration eller <code>.htaccess</code>-filen på serveren.</p>';
$string['sessioncookie'] = 'Cookie-suffiks';
$string['sessioncookiedomain'] = 'Cookie-domæne';
$string['sessioncookiepath'] = 'Cookie-sti';
$string['sessionhandling'] = 'Sessionshåndtering';
$string['sessiontimeout'] = 'Timeout';
$string['sessiontimeoutwarning'] = 'Advarsel om timeout';
$string['settingdependenton'] = 'Denne indstilling kan være skjult afhængig af værdien af  <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Fil-upload kræves for normal operation, aktiver dette i php-konfigurationen.';
$string['settingmaxinputvars'] = 'Det anbefales, at PHP-indstillingen max_input_vars er mindst 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP-indstillingen max_input_vars skal være mindst 5000.';
$string['settingmemorylimit'] = 'Utilstrækkelig memory påvist. Forhøj memory-grænsen i php-indstillingerne.';
$string['settingsafemode'] = 'Moodle er ikke fuldt kompatibel med "safe mode". Anmod serveradminstratoren om at fjerne denne mulighed. At køre Moodle i "safe mode" er ikke understøttet og du kan forvente adskillige problemer hvis du alligevel gør dette.';
$string['setupsearchengine'] = 'Indstil søgemaskine';
$string['showcommentscount'] = 'Vis antal kommentarer';
$string['showdetails'] = 'Vis detaljer';
$string['showuseridentity'] = 'Vis brugeridentitet';
$string['showuseridentity_desc'] = 'Ved valg af eller søgning efter brugere og på brugerlister skal disse felter vises foruden deres fulde navn. Felterne vises kun til brugere med beføjelsen \'moodle/site:viewuseridentity\', som standard lærere og administratorer. (Indstillingen giver mest mening hvis du vælger et eller to felter der er obligatoriske på din institution).

Felter markeret med * er brugerdefinerede brugerprofilfelter. Du kan vælge disse felter, men der er i øjeblikket nogle skærme, som ikke viser dem.';
$string['simplexmlrequired'] = 'Moodle kræver nu php-udvidelsen SimpleXML.';
$string['sitemailcharset'] = 'Tegnsæt';
$string['sitemaintenance'] = 'Dette websted er i øjeblikket ikke tilgængeligt grundet vedligeholdelsesarbejde.';
$string['sitemaintenancemode'] = 'Vedligeholdelsestilstand';
$string['sitemaintenanceoff'] = 'Vedligeholdelsen er afsluttet og webstedet fungerer normalt igen.';
$string['sitemaintenanceon'] = 'Webstedet er i vedligeholdelsestilstand så kun administratorer kan logge ind.';
$string['sitemaintenanceoncli'] = 'Dit site er p.t. i CLI-vedligeholdelsestilstand, ingen web adgang er tilladt.';
$string['sitemaintenancetitle'] = '{$a} under vedligeholdelse';
$string['sitemaintenancewarning'] = 'Sitet er i øjeblikket i vedligeholdelsestilstand og kun administratorer kan logge ind. For at returnere til normaltilstand skal vedligeholdelsestilstanden <a href="maintenance.php">deaktiveres</a>.';
$string['sitemaintenancewarning2'] = 'Siden kører i vedligeholdelsestilstand (kun administratorer kan logge ind). Returner til normal brugstilstand på siden <a href="{$a}">deaktiver vedligeholdelsestilstand</a>.';
$string['sitemenubar'] = 'Sidenavigation';
$string['sitenameintitle'] = 'Inkludér sitenavn i sidens titel';
$string['sitenameintitle_help'] = 'Denne indstilling tilføjer webstedets navn i slutningen af sidetitlen. Det anbefales at inkludere webstedets navn i sidetitlen, da det vil forbedre webstedets tilgængelighed ved at tillade brugere hurtigt at identificere den side, de aktuelt befinder sig på.';
$string['sitepolicies'] = 'Sikkerhedsindstillinger';
$string['sitepolicy'] = 'URL til siteretningslinjer';
$string['sitepolicy_help'] = 'URL\'en til eventuelle regler brugerne skal acceptere før siden kan tilgås. Indstillingen har kun betydning hvis politikhåndteringen er sat til standard (core).';
$string['sitepolicyguest'] = 'URL til sitepolitik for gæster';
$string['sitepolicyguest_help'] = 'URL\'en til politikken for sitet som gæster skal godkende inden de kan komme ind. Bemærk: Indstillingen kræver at anvendelse af sitepolitik er sat som standard (core).';
$string['sitepolicyhandler'] = 'Politikhåndtering';
$string['sitepolicyhandler_desc'] = 'Dette bestemmer hvordan politikker og brugersamtykker håndteres. Med standardhåndteringen (core) kan man have en URL til webstedspolitik og en til webstedspolitik for gæster. Politikhåndteringen muliggør opsætning af politik for websted, privatlivsbeskyttelse og andre emner. Desuden kan brugersamtykker vises og samtykker kan gives på vegne af mindreårige.';
$string['sitepolicyhandlercore'] = 'Standard (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Hvis denne indstilling er valgt vil en emnesektion blive vist på webstedets forside.';
$string['sixtyfourbitsrequired'] = 'Det er blevet opdaget, at dit websted ikke bruger en 64-bit PHP-version. Du skal opgradere dit system (operativsystem, PHP...) inden installation af denne Moodle-version.';
$string['sixtyfourbitswarning'] = 'Det viser sig, at dit site ikke bruger en 64-bit PHP-version. Det anbefales at du opgraderer dit site for at sikre fremtidig kompatibilitet.';
$string['slasharguments'] = 'Brug slash-argumenter';
$string['slashargumentswarning'] = 'Det anbefales at brug af \'slash\'-argumenter aktiveres. Det vil blive krævet fremover. Læs evt. mere i Moodle Docs: <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smartpix'] = 'Smart pix-søgning';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Type SMTP-godkendelse';
$string['smtpdetail'] = 'SMTP-indstillinger (Simple Mail Transfer Protokol) for at sende e-mail';
$string['smtphosts'] = 'SMTP-værtsadresse';
$string['smtpmaxbulk'] = 'SMTP-sessionsgrænse';
$string['smtppass'] = 'SMTP-kode';
$string['smtpsecure'] = 'SMTP-sikkerhed';
$string['smtpuser'] = 'SMTP-brugernavn';
$string['soaprecommended'] = 'Installation af den valgfrie SOAP-udvidelse er gavnlig for webservices og visse plugin.';
$string['sort_fullname'] = 'Kursets fulde navn';
$string['sort_idnumber'] = 'Kursets id-nummer';
$string['sort_shortname'] = 'Kursets korte navn';
$string['sort_sortorder'] = 'Sorteringsrækkefølge';
$string['spellengine'] = 'Stavekontrol';
$string['spelllanguagelist'] = 'Sprogliste til stavekontrol';
$string['splrequired'] = 'Moodle kræver nu php-udvidelsen SPL.';
$string['stats'] = 'Statistik';
$string['statsfirstrun'] = 'Maksimal kørselsinterval';
$string['statsmaxruntime'] = 'Maksimal kørselstid';
$string['statsmoodleorg'] = 'statistikken fra det verdensomspændende Moodlefællesskab';
$string['statsruntimedays'] = 'Dage at behandle';
$string['statsruntimestart'] = 'Start ved';
$string['statsuserthreshold'] = 'Bruger minimum';
$string['stickyblocks'] = 'Faste blokke';
$string['stickyblockscourseview'] = 'Kursusside';
$string['stickyblocksduplicatenotice'] = 'Hvis en blok du tilføjer her allerede er tilføjet på en side, vil det resultere i dubletter. <br />Kun den fastgjorte blok vil ikke kunne ændres, dubletten vil stadig kunne redigeres.';
$string['stickyblocksmymoodle'] = 'Min Moodle';
$string['stickyblockspagetype'] = 'Konfigurer sidetype';
$string['strictformsrequired'] = 'Strikt validering af obligatoriske felter';
$string['stripalltitletags'] = 'Fjern html-tags fra alle aktivitetsnavne';
$string['supportandservices'] = 'Support og service';
$string['supportavailability'] = 'Supporttilgængelighed';
$string['supportcontact'] = 'Kontakt til support';
$string['supportemail'] = 'Support-e-mail';
$string['supportemailsubject'] = 'Anmodning om support på webstedet - {$a}';
$string['supportname'] = 'Supporters navn';
$string['supportpage'] = 'Link til support på webstedet';
$string['suspenduser'] = 'Suspender brugerkonto';
$string['switchlang'] = 'Skift sprogmappe';
$string['systempaths'] = 'Systemstier';
$string['tablenosave'] = 'Ændring i tabellen herover gemmes automatisk.';
$string['tablesnosave'] = 'Ændringer i tabellerne herover gemmes automatisk.';
$string['tabselectedtofront'] = 'På tabeller med tabulatorer skal den valgte række placeres forrest.';
$string['tabselectedtofronttext'] = 'Bring valgte tabulatorrække til front';
$string['task_adhoc_concurrency_limit'] = 'Grænse for samtidige ad hoc-opgaver';
$string['task_adhoc_concurrency_limit_desc'] = 'Antal tilladte samtidige ad hoc-opgaver. Hvis grænsen er høj vil planlagte opgaver måske ikke køre regelmæssigt når der er mange ad hoc-opgaver. "0" vil forhindre kørsel af ad hoc-opgaver.';
$string['task_adhoc_max_runtime'] = 'Løbetid på ad hoc-opgaver';
$string['task_adhoc_max_runtime_desc'] = 'Alderen på en ad hoc opgave, før den frigøres. En lav varighed anbefales, da der ikke er nogen grænse for antallet af ad hoc-opgaver der står i kø. Hvis dette tal er for højt, og du har en stor ad hoc-opgavekø, køres planlagte opgaver muligvis ikke regelmæssigt.';
$string['task_dbreads'] = 'Database-læsninger';
$string['task_dbstats'] = 'Database';
$string['task_dbwrites'] = 'Database-skrivninger';
$string['task_duration'] = 'Varighed';
$string['task_endtime'] = 'Sluttid';
$string['task_logmode'] = 'Hvornår der skal logges';
$string['task_logmode_all'] = 'Gem log-output fra alle jobs';
$string['task_logmode_desc'] = 'Du kan vælge hvornår logningen skal foregå. Som standard gemmes logs altid. Du kan deaktivere logning helt eller nøjes med at logge opgaver der fejler.';
$string['task_logmode_failonly'] = 'Gem kun logs for job der fejler';
$string['task_logmode_none'] = 'Log intet';
$string['task_logoutput'] = 'Opgaveresultat';
$string['task_logretainruns'] = 'Bevar kørsler';
$string['task_logretainruns_desc'] = 'Antal kørsler for hver opgave der skal bevares. Denne indstilling interagerer med indstillingen "Opbevaringsperiode": det, der nås først, gælder.';
$string['task_logretention'] = 'Opbevaringsperiode';
$string['task_logretention_desc'] = 'Den maksimale periode logfiler skal opbevares i. Denne indstilling interagerer med indstillingen "Behold kørsler": det, der nås først, gælder';
$string['task_logtostdout'] = 'Vis log-output';
$string['task_logtostdout_desc'] = '';
$string['task_result'] = 'Resultat';
$string['task_result:failed'] = 'Mislykkedes';
$string['task_scheduled_concurrency_limit'] = 'Grænse for samtidige planlagte opgaver';
$string['task_scheduled_concurrency_limit_desc'] = 'Antal tilladte kørsler af samtidige planlagte opgaver. En høj grænse kan betyde høj belasting som kan påvirke serverens ydeevne. 0 vil helt forhindre kørsel af planlagte opgaver.';
$string['task_scheduled_max_runtime'] = 'Levetid for planlagte opgaver';
$string['task_scheduled_max_runtime_desc'] = 'Alderen på en planlagt opgavekører, før den frigøres';
$string['task_starttime'] = 'Starttid';
$string['task_stats:dbreads'] = '{$a} læser';
$string['task_stats:dbwrites'] = '{$a} skriver';
$string['task_status'] = 'Opgavestatus';
$string['task_status_desc'] = 'Opgaven \'{$a->name}\' er {$a->status}. For detaljer, se {$a->class}{$a->extradescription} i <a href="{$a->gotourl}">Planlagte opgaver</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Planlagt';
$string['taskadmintitle'] = 'Opgaver';
$string['taskanalyticscleanup'] = 'Oprydning i Analytics';
$string['taskautomatedbackup'] = 'Automatiske backups';
$string['taskautomatedbackup_report'] = 'Automatiseret backup-rapport';
$string['taskbackupcleanup'] = 'Ryd backuptabeller, logs og filer';
$string['taskbadgesadhoc'] = 'belønningsbadge';
$string['taskbadgescron'] = 'Tilføj tildel-badge-adhocopgaver';
$string['taskbadgesmessagecron'] = 'Baggrundsbehandling til afsendelse af badge-underretninger';
$string['taskblogcron'] = 'Synkroniser eksterne blogs';
$string['taskcachecleanup'] = 'Fjern udløbne cache-forekomster';
$string['taskcachecron'] = 'Baggrundsbehandling af caches';
$string['taskcalendarcron'] = 'Send kalendernotifikationer';
$string['taskcheckforupdates'] = 'Tjek for opdateringer';
$string['taskcompletiondaily'] = 'Gennemførelse markeret som startet';
$string['taskcompletionregular'] = 'Beregn regulær færdiggørrelsesdata';
$string['taskcontextcleanup'] = 'Ryd op i kontekster';
$string['taskcreatecontexts'] = 'Opret manglende kontekster';
$string['taskdeletecachetext'] = 'Slet gamle cachede tekstposter';
$string['taskdeleteincompleteusers'] = 'Slet ukomplette brugere';
$string['taskdeleteunconfirmedusers'] = 'Slet ubekræftede brugere';
$string['taskeventscron'] = 'Baggrundsbehandling af begivenheder';
$string['taskfiletrashcleanup'] = 'Tøm papirkurven';
$string['taskglobalsearchindex'] = 'Indeksering til søgning på hele sitet';
$string['taskglobalsearchoptimize'] = 'Global søge-indeksoptimering';
$string['taskgradecron'] = 'Baggrundsbehandling af karakterbogen';
$string['taskgradehistorycleanup'] = 'Baggrundsbehandling til rydning af tabeller med karakterhistorik';
$string['taskh5pcleanup'] = 'Oprydning i ubrugte H5P-filer';
$string['tasklegacycron'] = 'Legacy cron-behandling for plugins';
$string['tasklockcleanuptask'] = 'Ryd op i metadata for adhoc opgaver';
$string['tasklogcleanup'] = 'Oprydning i opgavelogs';
$string['tasklogging'] = 'Konfiguration af opgave-log';
$string['tasklogs'] = 'Opgave-logs';
$string['taskmessagingcleanup'] = 'Baggrundsbehandling af beskeder';
$string['taskpasswordresetcleanup'] = 'Ryd op i forsøg på nulstillinger af adgangskode';
$string['taskplagiarismcron'] = 'Baggrundsbehandling af legacy cron i plagierings-plugins';
$string['taskportfoliocron'] = 'Baggrundsbehandling af portefølje-plugins';
$string['taskprocessing'] = 'Opgavebehandling';
$string['taskquestioncron'] = 'Baggrundsoprydning i forhåndsvisning af spørgsmål';
$string['taskquestionstatscleanupcron'] = 'Baggrundsbehandling til oprydning i cachen til spørgsmålsstatistik';
$string['taskrefreshsystemtokens'] = 'Opdater OAuth-tokens for servicekonti';
$string['taskregistrationcron'] = 'Site registrering';
$string['tasksendfailedloginnotifications'] = 'Send notifikationer om mislykkede login';
$string['tasksendnewuserpasswords'] = 'Send nye brugeradgangskoder';
$string['tasksessioncleanup'] = 'Ryd op i gamle sessioner';
$string['taskstatscron'] = 'Baggrundsbehandling af statistik';
$string['tasktagcron'] = 'Baggrundsbehandling af tags';
$string['tasktempfilecleanup'] = 'Slet forældede temp filer';
$string['tasktype'] = 'Type';
$string['tempdatafoldercleanup'] = 'Ryd op i midlertidige datafiler ældre end';
$string['templates'] = 'Skabeloner';
$string['testoutgoingmailconf'] = 'Test konfiguration af udgående mail';
$string['testoutgoingmailconf_errorcommunications'] = 'Dit site kunne ikke kommunikere med mailserveren. Tjek din konfiguration af udgående mail';
$string['testoutgoingmailconf_fromemail'] = 'Fra brugernavn eller e-mailadresse';
$string['testoutgoingmailconf_fromemail_help'] = 'Dette felt emulerer afsendelse af meddelelsen fra den pågældende bruger, men From-headeren, der anvendes i den reelle e-mail, afhænger af andre indstillinger, f.eks. tilladte domæner';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Ugyldig fra brugernavn eller email. Det skal være et gyldigt emailformat eller et allerede eksisterende brugernavn i Moodle.';
$string['testoutgoingmailconf_message'] = 'Dette er en test til bekræftelse af at du har konfigureret dit sites udgående mail rigtigt.  Sendt: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Send en testbesked';
$string['testoutgoingmailconf_sentmail'] = 'Sitet har sendt en testbesked til mailserveren.<br />Fra: {$a->fromemail}<br />Til: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: testbesked. {$a->additional} Sendt: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Ekstra emne';
$string['testoutgoingmailconf_toemail'] = 'Til mailadressen';
$string['testoutgoingmaildetail'] = 'Bemærk: Gem din konfiguration inden du tester.<br />{$a}';
$string['testsiteupgradewarning'] = 'Du bruger aktuelt testsiden {$a}, opgrader den ved hjælp af kommandolinjeværktøjet';
$string['themedefinedinconfigphp'] = 'Temaet kan ikke ændres fordi det er sat til {$a} i config.php';
$string['themedesignermode'] = 'Layoutdesign-tilstand';
$string['themedesignermodewarning'] = 'Layoutdesign-tilstand er aktiveret. Bør ikke aktiveres på sites i drift da det kan reducere ydelsen betragteligt.';
$string['themelist'] = 'Layoutliste';
$string['themenoselected'] = 'Der er ikke valgt et layout';
$string['themeresetcaches'] = 'Ryd layout-cache';
$string['themeselect'] = 'Vælg et andet layout';
$string['themeselector'] = 'Layoutvælger';
$string['themesettings'] = 'Layoutindstillinger';
$string['therewereerrors'] = 'Der var fejl i dine data';
$string['thirdpartylibrary'] = 'Bibliotek';
$string['thirdpartylibrarylocation'] = 'Lokation';
$string['thirdpartylibs'] = '3. parts biblioteker';
$string['timezone'] = 'Standard tidszone';
$string['timezoneforced'] = 'Dette er gennemtvunget af administratoren';
$string['timezoneinvalid'] = 'Ugyldig tidszone "{$a}"';
$string['timezoneisforcedto'] = 'Tving alle brugere til at bruge';
$string['timezonenotforced'] = 'Brugere kan selv vælge tidszone';
$string['timezonephpdefault'] = 'Standard PHP-tidszone ({$a})';
$string['timezoneserver'] = 'Servertidszone ({$a})';
$string['tlswarning'] = 'Der ser ikke ud til at være en PHP/cURL-udvidelse med TLSv1.2-understøttelse. Nogle servicer virker måske ikke. Det anbefales stærkt at opgradere TLS-bibliotekerne.';
$string['tokenduration'] = 'Brugeroprettet-token varighed';
$string['tokenduration_desc'] = 'Hvor længe en brugeroprettet token til webservices (fx via mobilappen) er gyldig.';
$string['tokenizerrecommended'] = 'Installation af den valgfrie PHP Tokenizer-udvidelse er anbefalet. Den forbedrer funktionaliteten af Moodle Networking.';
$string['tools'] = 'Adminværktøjer';
$string['toolsmanage'] = 'Administrer adminværktøjer';
$string['unattendedoperation'] = 'Ikke-overvåget operation';
$string['unbookmarkthispage'] = 'Fjern bogmærke til denne side';
$string['unicoderequired'] = 'Alle data skal gemmes i Unicode (UTF-8). Nye installationer skal helst installeres i databaser der har UTF-8 som standard tegnsæt. Hvis du opgraderer fra en tidligere installation bør du migrere eksisterende data til UTF-8 (se Admin siderne)';
$string['uninstallplugin'] = 'Afinstaller';
$string['unlockaccount'] = 'Lås konto op';
$string['unoconvwarning'] = 'Den installerede version af unoconv understøttes ikke.';
$string['unsettheme'] = 'Nulstil layout';
$string['unsupported'] = 'Understøttes ikke';
$string['unsupporteddbfileformat'] = 'Din database bruger filformatet Antelope. Fuld support af utf-8 i MySQL og MariaDB kræver Antelope Barracuda. Skift til Barracuda-filformatet. Se flere oplysninger i dokumentationen <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a>.';
$string['unsupporteddbfilepertable'] = 'For fuld support af utf-8 kræver både MySQL og MariaDB at du ændrer din MySGL-indstilling \'innodb_file_per_table\' til \'ON\'. Se dokumentationen for yderligere oplysninger.';
$string['unsupporteddblargeprefix'] = 'Til fuld support af utf-8 kræver både MySQL og MariaDB at du ændrer din MySQL-indstilling \'innodb_large_prefix\' til \'ON\'. Se flere oplysninger i dokumentationen.';
$string['unsupporteddbstorageengine'] = 'Det anvendte databasesystem supporteres ikke længere.';
$string['unsupporteddbtablerowformat'] = 'Din database har tabeller der bruger af Antelope som filformat. Det anbefales at tabellerne konverteres til Barracuda-filformatet. Se dokumentationen <a href="https://docs.moodle.org/en/cli">Administration via command line</a> for oplysninger omkring et værktøj til at konvertere InnoDB tabeller til Barracuda.';
$string['unsupportedphpversion7'] = 'PHP version 7 er ikke understøttet';
$string['unsupportedphpversion71'] = 'PHP 7.1 understøttes ikke.';
$string['unsupportedphpversion72'] = 'PHP version 7.2 understøttes ikke.';
$string['unsupportedphpversion73'] = 'PHP version 7.3 understøttes ikke';
$string['unsupportedphpversion74'] = 'PHP version 7.4 understøttes ikke';
$string['unsupportedphpversion80'] = 'PHP version 8.0 understøttes ikke.';
$string['unsupportedphpversion81'] = 'PHP version 8.1 og højere er ikke understøttet.';
$string['unsupportedphpversion82'] = 'PHP versionen 8.2 og højere er ikke understøttet.';
$string['unsupportedphpversion83'] = 'PHP versionen 8.3 og højere er ikke understøttet.';
$string['unsuspenduser'] = 'Aktiver brugerkonto';
$string['updateaccounts'] = 'Opdater eksisterende konti';
$string['updateautocheck'] = 'Tjek automatisk for tilgængelige opdateringer';
$string['updateautocheck_desc'] = 'Hvis aktiveret, vil dit site automatisk se efter tilgængelige opdateringer af såvel Moodlekoden som alle ekstra plugins. Hvis der er en opdatering tilgængelig, vil admins modtage en besked.';
$string['updateavailable'] = 'Der er en nyere Moodleversion tilgængelig';
$string['updateavailable_moreinfo'] = 'Yderligere informationer...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updateavailabledetailslink'] = 'Se {$a->url} for yderligere oplysninger';
$string['updateavailableforplugin'] = 'Der er en nyere version af nogle af dine plugins tilgængelig';
$string['updateavailableinstall'] = 'Installer denne opdatering';
$string['updateavailableinstallall'] = 'Installer tilgængelige opdateringer ({$a})';
$string['updateavailableinstallallhead'] = 'Installerer tilgængelige opdateringer';
$string['updateavailablenot'] = 'Din Moodlekode er up-to-date!';
$string['updateavailablerecommendation'] = 'Det anbefales kraftigt at du opdaterer dit site til den seneste version for at modtage alle de nyeste sikkerheds- og fejlrettelser.';
$string['updatecomponent'] = 'Opdater komponent';
$string['updateminmaturity'] = 'Krævet modenhed af kode (min.)';
$string['updateminmaturity_desc'] = 'Notificer kun om opdateringer hvis den tilgængelige kode som minimum lever op til den valgte modenhed. Opdateringer for plugins uden angivelse modenhedsstatus rapporteres altid uanset denne indstilling.';
$string['updatenotificationfooter'] = 'Dit Moodlesite {$a->siteurl} er konfigureret til automatisk at tjekke for tilgængelige opdateringer. Du modtager denne besked fordi du er administrator for dette site. Du kan deaktivere automatiske tjek for tilgængelige opdateringer i Siteadministration -> Server -> Opdateringsnotifikationer. Du kan tilpasse leveringen af beskeden i dine personlige indstillinger.';
$string['updatenotifications'] = 'Opdateringsnotifikationer';
$string['updatenotificationsubject'] = 'Moodleopdateringer er tilgængelige ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notificer om nye builds';
$string['updatenotifybuilds_desc'] = 'Hvis aktiveret, vil den tilgængelige opdatering af Moodlekoden også angives når et nyt "build" af den nuværende version er tilgængelig. "Builds" er kontinuerlige forbedringer af en given Moodleversion. De udgives ugentligt. Hvis deaktiveret, vil den tilgængelige opdatering kun angives hvis der er udgivet en nyere version af Moodle. Tjek af plugins er ikke påvirket af denne indstilling.';
$string['upgradeerror'] = 'Ukendt fejl under opgradering af {$a->plugin} til version {$a->version}. Kan ikke fortsætte.';
$string['upgradeforumread'] = 'En ny funktion er blevet tilføjet i Moodle 1.5 til at holde styr på læste/ikke læste forumindlæg.<br />For at benytte denne funktionalitet bliver du nødt til at <a href="{$a}">opdatere tabellerne</a>.';
$string['upgradeforumreadinfo'] = 'En ny funktion er blevet tilføjet i Moodle 1.5 til at holde styr på læste/ikke læste forumindlæg.<br />For at benytte denne funktionalitet bliver du nødt til at opdatere dine tabeller med informationer om de eksisterende poster. Afhængig af størrelsen på sitet kan dette godt tage en del tid (timer) og kan være ret belastene for databasen, så det er bedst at gøre dette i stille perioder. Sitet vil fungere normalt under opdateringen, og brugerne vil ikke blive påvirket. Når du starter opdateringen bør du lade den køre til ende, (hold browservinduet åbent). Hvis du kommer til at stoppe opdateringen ved at lukke vinduet, så kan du fortsætte igen.
<br /><br />Ønsker du at starte opdateringsprocessen nu?';
$string['upgradekeyreq'] = 'Opgraderingsnøgle påkrævet';
$string['upgradekeyset'] = 'Opgraderingsnøgle (efterlad tom for ikke at angive denne)';
$string['upgradelogs'] = 'For fuld funktionalitet skal de gamle logfiler opgraderes. <a href="{$a}">Yderligere information</a>';
$string['upgradelogsinfo'] = 'Der er lavet nogle ændringer i den måde logfiler bliver gemt på. For at du stadig kan se alle logininformationer sorteret efter aktivitet, skal logfilerne opgraderes. Afhængig af logfilernes størrelse kan dette godt tage lang tid (måske op til flere timer) og være ret belastende for databaseserveren for store sites. Når du først har startet processen bør du lade den arbejde færdig (ved at lade browservinduet stå åbent). For andre vil sitet stadig fungere fint selvom logfilerne bliver opdateret.<br /><br />Ønsker du at opgradere logfilerne nu?';
$string['upgradepluginsfirst'] = 'Det anbefales at installere alle tilgængelige opdateringer først.';
$string['upgradepluginsinfo'] = 'Opdaterer plugins';
$string['upgradepluginsinfo_help'] = 'Der er opdateringer tilgængelig for nogle af dine plugins. Du bør installere disse før du opgraderer din Moodledatabase. Hvis dit site ikke understøtter automatisk udrulning af opdateringer, er du nødt til manuelt at downloade og installere nye plugin-versioner på din server.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nye indstillinger';
$string['upgradesettingsintro'] = 'Nedestående indstillinger er blevet tilføjet med den sidste opgradering af Moodle. Foretag eventuelle ændringer af standardindstillingerne og tryk på "Gem" i bunden af denne side.';
$string['upgradestalefiles'] = 'Der er fundet mere end en version af Moodle. Opgradering kan ikke fortsætte';
$string['upgradestalefilesinfo'] = 'Moodles opdateringsproces er blevet sat på pause da der er fundet PHP-scripts fra mindst to hovedversioner af Moodle i Moodles systemmappe.

Dette kan medføre betydelige problemer senere, så for at kunne fortsætte med opdateringen bedes du sikre dig at Moodles systemmappe kun indeholder filer fra en enkelt version af Moodle.

Den anbefalede metode til at rense din systemmappe er som følger:

* omdøb den nuværende systemmappe til "moodle_old"
* opret en ny systemmappe der kun indeholder filer fra enten en downloadet standard Moodlepakke eller fra Moodles Git-filarkiv
* flyt den originale config.php fil og alle ikke-standard plugins fra systemmappen "moodle_old" til den nye systemmappe.

Når du har en ren Moodlesystemmappe, bedes du genopfriske denne side for at genoptage opdateringen af Moodle.

Denne advarsel kommer ofte som følge af at der er udpakket en standard Moodlepakke oven i en tidligere version af Moodle. Denne metode er OK for mindre opgraderinger, men anbefales ikke for større opgraderinger af systemet.

Denne advarsel kan også skyldes et ukomplet checkout eller opdateringsoperation fra Gits filarkiv, og i dette tilfælde er du sandsynligvis blot nødt til at afvente at operationen fuldføres, eller evt. køre den relevante oprydningskommando eller prøve at gentage operationen.

Du kan finde yderligere information i opgraderingsdokumentationen <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Opgrader Moodles database nu';
$string['upgradesure'] = '<p>Moodles filer er blevet ændret, du er lige ved automatisk at opgradere serveren til version:</p> <p><strong>{$a}</strong> </p> <p>Når serveren én gang er opdateret kan det ikke laves om<br /><br />Vær opmærksom på at dette kan tage et godt stykke tid.</p> <p>Er du sikker på at du vil fortsætte?</p>';
$string['upgradetimedout'] = 'Opgraderingen fik timeout, genstart opgraderingen';
$string['upgradingdata'] = 'Opgraderer data';
$string['upgradinglogs'] = 'Opgraderer logfiler';
$string['upgradingversion'] = 'Opgraderer til ny version';
$string['upwards'] = 'opefter';
$string['useblogassociations'] = 'Aktiver tilknytninger';
$string['user'] = 'Bruger';
$string['userbulk'] = 'Samlet behandling af flere brugere';
$string['userbulkdownload'] = 'Eksporter brugere som';
$string['userdefaultpreferences'] = 'Standard brugerindstillinger';
$string['userfeedbackafterupgrade'] = 'Efter store opgraderinger';
$string['userfeedbackencouragement'] = '<p>En ny funktion i Moodle 3.9 gør det muligt for brugerne via et eksternt undersøgelsessite at give Moodle HQ feedback på Moodle-softwaren. Moodle HQ hoster undersøgelsessiden, og der sendes ingen brugeridentificerbar information til den.</p>
<p>Moodle HQ stræber efter at være åben og transparent omkring sin indsamling af data. Derfor vil vi sikre at du kender og har kontrol over denne funktion.</p>
<p>Feedback vil i høj grad hjælpe Moodle HQ med at forbedre Moodle-softwaren. Funktionen aktiveres på siden <a href="{$a}">Feedback-indstillinger</a>.</p>';
$string['userfeedbacknextreminder'] = 'Næste feedback-påmindelse';
$string['userfeedbacknextreminder_desc'] = 'Hvornår skal vi igen anmode brugeren om feedback?';
$string['userfeedbackperiodically'] = 'Periodisk';
$string['userfeedbackremindafter'] = 'Vis påmindelse efter';
$string['userfeedbackremindafter_desc'] = 'Påmind brugere om at give feedback igen efter dette antal dage.';
$string['userfiltersdefault'] = 'Standard brugerfiltre';
$string['userfiltersdefault_desc'] = 'Vælg de filtre der skal kunne vælges på siderne "Vis brugerliste" og "Samlet behandling af flere brugere". Hold Ctrl-knappen nede for at vælge flere felter. Ikke valgte felter vil være tilgængelige ved at klikke på linket "Vis mere".';
$string['userimagesdisabled'] = 'Brugerbilleder er deaktiveret';
$string['userlist'] = 'Vis brugerliste';
$string['usermanagement'] = 'Brugerhåndtering';
$string['userpolicies'] = 'Brugerpolitikker';
$string['userpreference'] = 'Valgfrit';
$string['userquota'] = 'Plads til private filer';
$string['userquota_desc'] = 'Højeste mængde data hver bruger kan gemme i deres private filområde.';
$string['users'] = 'Brugere';
$string['usesitenameforsitepages'] = 'Brug sitenavn til "Webstedssider"';
$string['usetags'] = 'Aktiver tags-funktionalitet';
$string['validateemptylineerror'] = 'Tomme linjer er ugyldige';
$string['validateerror'] = 'Denne værdi er ikke gyldig';
$string['validateerrorlist'] = 'Disse indtastninger er ugyldige: {$a}';
$string['validateiperror'] = 'Ugyldige IP-adresser: {$a}';
$string['verifychangedemail'] = 'Begræns domæner ved ændring af e-mailadresse';
$string['warningcurrentsetting'] = 'Ugyldig kursusværdi: {$a}';
$string['warningiconvbuggy'] = 'Din version af iconv-biblioteket understøtter ikke "the //IGNORE modifier". Du kan installere udvidelsen mbstring, den kan bruges i stedet for at rense strenge med ugyldige UTF-8-tegn.';
$string['webproxy'] = 'Web-proxy';
$string['webproxyinfo'] = 'Udfyld disse felter, hvis ikke Moodle har direkte adgang til internettet. Internetadgang er nødvendig til download af \'environment data\', sprogpakker, RSS-feeds, tidszoner mv.<br /><em>Ekstensionen PHP cURL anbefales på det kraftigste.</em>';
$string['xmlrpcwebserviceenabled'] = 'Det er blevet opdaget, at XML-RPC Web Service-protokollen er aktiveret på dit site. Denne funktion er afhængig af PHP XML-RPC-udvidelsen, som ikke længere vedligeholdes af PHP.';
$string['yuicomboloading'] = 'Indlæser YUI combo';
$string['ziprequired'] = 'Php-udvidelsen zip er nu påkrævet af Moodle, binære info-zip-filer eller PclZip-bibliotek bruges ikke længere.';
