<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'folder', language 'zh_cn', version '4.4'.
 *
 * @package     folder
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bynameondate'] = '按{$a->name}-{$a->date}';
$string['contentheader'] = '内容';
$string['display'] = '显示文件夹内容';
$string['display_help'] = '如果选择在课程页面上显示文件夹内容，则不会有指向单独页面的链接。仅当勾选“在课程页面上显示说明”时，说明才会显示。请注意，在这种情况下，无法记录参与者查看操作。';
$string['displayinline'] = '内嵌在课程页面';
$string['displaypage'] = '在单独的页面';
$string['dnduploadmakefolder'] = '解压文件并创建文件夹';
$string['downloadfolder'] = '下载文件夹';
$string['eventallfilesdownloaded'] = '文件夹的ZIP压缩文件已下载';
$string['eventfolderupdated'] = '文件夹已更新';
$string['folder:addinstance'] = '添加一个新文件夹';
$string['folder:managefiles'] = '在文件夹模块中管理文件';
$string['folder:view'] = '查看文件夹内容';
$string['foldercontent'] = '文件和子文件夹';
$string['forcedownload'] = '强制下载文件';
$string['forcedownload_help'] = '某些文件（如图像或HTML文件）是否应显示在浏览器中而不是下载。请注意，出于安全原因，仅当能够管理文件夹中文件的所有用户都是受信任的用户时，才应取消选中该设置。';
$string['indicator:cognitivedepth'] = '文件夹资源认知深度';
$string['indicator:cognitivedepth_help'] = '这个指标是基于学生在文件夹资源中所达到的认知深度。';
$string['indicator:cognitivedepthdef'] = '文件夹认知';
$string['indicator:cognitivedepthdef_help'] = 'The participant has reached this percentage of the cognitive engagement offered by the Folder resources during this analysis interval (Levels = No view, View)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = '文件夹资源社会广度';
$string['indicator:socialbreadth_help'] = '这个指标是基于学生在文件夹资源中所达到的社会宽度。';
$string['indicator:socialbreadthdef'] = '文件夹社交';
$string['indicator:socialbreadthdef_help'] = '在此分析间隔期间，参与者已达到文件夹资源提供的社交参与百分比（级别=无参与，仅参与者一人）';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['maxsizetodownload'] = '文件夹下载的最大容量限制(MB)';
$string['maxsizetodownload_help'] = '当以压缩文件下载时，这个文件夹最大可以达到多少。若设为0，表示大小没有限制。';
$string['modulename'] = '文件夹';
$string['modulename_help'] = '文件夹模块可以让教师在一个单一文件夹里展示一堆相关的文件，减少在课程页面上下上下滚动。

一个压缩的文件夹可以被上传并解压缩以供显示，或者建立一个空文件夹并把文件上传到这里。

文件夹模块可以用于：

*存放同一主题的一系列文件，例如，一整套考古主题的PDF文件，或供学生写作用的一组图片文件。

*在课程页面中提供教师上传共享文件的空间(保持文件夹隐藏状态，只有教师才能看到)';
$string['modulename_link'] = 'mod/folder/view';
$string['modulenameplural'] = '文件夹';
$string['newfoldercontent'] = '新文件夹内容';
$string['noautocompletioninline'] = '查看活动时自动完成不能与“显示内联”选项一起选择';
$string['page-mod-folder-view'] = '文件夹模块主页';
$string['page-mod-folder-x'] = '任意文件夹模块页面';
$string['pluginadministration'] = '文件夹管理';
$string['pluginname'] = '文件夹';
$string['privacy:metadata'] = '文件夹资源插件不存储任何个人数据。';
$string['search:activity'] = '文件夹';
$string['showdownloadfolder'] = '显示下载文件夹的按钮';
$string['showdownloadfolder_help'] = '若启用，文件夹内容旁边会显示一个按钮，用来以压缩文件下载。';
$string['showexpanded'] = '显示展开的子文件夹';
$string['showexpanded_help'] = '如果设为“是”，子文件夹将被默认展开显示；否则他们将被折叠显示。';
