<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'zh_cn', version '4.4'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = '关于';
$string['actingasrole'] = '您当前的用户角色不同';
$string['activatetemplateoverride'] = '激活“{$a}”的模板覆盖';
$string['activatetemplateoverridedesc'] = '勾选后，如果包含文本，则“{$a->setting}”设置中的值将用作“{$a->template}”模板。';
$string['activebreadcrumb'] = '活跃线索背景颜色';
$string['activebreadcrumbdesc'] = '设置活跃线索颜色的背景颜色，以及线索栏的其余部分。';
$string['activitiesheading'] = '活动';
$string['alertaccess'] = '警告可见性';
$string['alertaccessadmins'] = '管理员可见';
$string['alertaccessdesc'] = '设置警告可见性的访问限制类型。 注意：如果使用“添加自定义配置文件字段限制”，则需要在下面为配置文件字段添加值。';
$string['alertaccessglobal'] = '所有人可见';
$string['alertaccessprofile'] = '添加自定义配置字段限制';
$string['alertaccessusers'] = '对登录用户可见';
$string['alertannounce'] = '公告';
$string['alertannouncedesc'] = '在提示框中显示公告。';
$string['alertbackgroundcolorinfo'] = '消息背景颜色';
$string['alertbackgroundcolorinfodesc'] = '信息类提示框的背景颜色';
$string['alertbackgroundcolorsuccess'] = '公告背景颜色';
$string['alertbackgroundcolorsuccessdesc'] = '公告类提示框的背景颜色';
$string['alertbackgroundcolorwarning'] = '警告信息背景颜色';
$string['alertbackgroundcolorwarningdesc'] = '警告类提示框的背景颜色';
$string['alertbordercolorinfo'] = '消息边框颜色';
$string['alertbordercolorinfodesc'] = '信息类提示框的边框颜色';
$string['alertbordercolorsuccess'] = '公告边框颜色';
$string['alertbordercolorsuccessdesc'] = '公告类提示框的边框颜色';
$string['alertbordercolorwarning'] = '警告边框颜色';
$string['alertbordercolorwarningdesc'] = '警告类提示框的边框颜色';
$string['alertcolorinfo'] = '消息颜色';
$string['alertcolorinfodesc'] = '信息类提示框的图标颜色';
$string['alertcolorsheading'] = '自定义顶置提示框';
$string['alertcolorsuccess'] = '公告颜色';
$string['alertcolorsuccessdesc'] = '公告类提示框的图标颜色';
$string['alertcolorwarning'] = '警告颜色';
$string['alertcolorwarningdesc'] = '警告类提示框的图标颜色';
$string['alertcount'] = '提示个数';
$string['alertcountdesc'] = '下面编辑区域中显示的提示条数。';
$string['alertdesc'] = '输入并自定义要作为提示显示在网站顶部的文本。 可以设置多个警报以针对不同的用户类型。';
$string['alertdisabled'] = '已禁用';
$string['alertdisabledesc'] = '禁用此提示。';
$string['alerthiddencourse'] = '课程隐藏提示';
$string['alerthiddencoursedesc'] = '提示教师课程是隐藏的';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = '单击此处更新设置';
$string['alerthiddencoursetext-start'] = '本课程是隐藏的，学生无法访问，';
$string['alerticoninfo'] = '信息图标';
$string['alerticoninfodesc'] = '设置 \'<a href=“{$a}” target=“_blank”>Font Awesome Icons</a>\' 以在信息类提示中使用。 输入不带“fa-”前缀的图标名称。';
$string['alerticonsuccess'] = '公告图标';
$string['alerticonsuccessdesc'] = '设置 \'<a href=“{$a}” target=“_blank”>Font Awesome Icons</a>\' 以用于公告类型提示。 输入不带“fa-”前缀的图标名称。';
$string['alerticonwarning'] = '警告图标';
$string['alerticonwarningdesc'] = '设置 \'<a href=“{$a}” target=“_blank”>Font Awesome Icons</a>\' 以用于警告类型提示。 输入不带“fa-”前缀的图标名称。';
$string['alertinfo'] = '信息';
$string['alertinfodesc'] = '在提示中显示信息';
$string['alertkeyvalue'] = '提示标识';
$string['alertkeyvalue_details'] = '标识此提示的键。 仅当您想再次显示相同的警报时，您才需要更改此设置，即内容未更改或以前使用过。 注意：格式更改不计为对内容的更改。';
$string['alertprofilefield'] = '自定义配置文件字段名称 = 值（可选）';
$string['alertprofilefielddesc'] = '使用自定义配置文件字段添加访问规则，例如：usertype=student。';
$string['alertsettings'] = '提示 {$a}';
$string['alertsettingscourse'] = '课程提示设置';
$string['alertsettingsgeneral'] = '常规提示设置';
$string['alertsettingsheading'] = '提示';
$string['alerttext'] = '提示文字';
$string['alerttextdesc'] = '输入要在提示中显示的文本';
$string['alerttype'] = '提示类型';
$string['alerttypedesc'] = '选择提示类型：信息（蓝色），警告（黄色）或通告（绿色）';
$string['alertwarning'] = '警告';
$string['alertwarningdesc'] = '在提示中显示警告。';
$string['analyticscount'] = '分析计数';
$string['analyticscountdesc'] = '下面编辑区域中显示的分析字段条数。';
$string['analyticsprofilefield'] = '自定义配置字段名称=值（可选）';
$string['analyticsprofilefielddesc'] = '使用自定义配置文件字段添加访问规则，例如：usertype=student。';
$string['analyticssettings'] = '分析';
$string['analyticssettingsdesc'] = '您可以为Google Analytics设置多个代码，并将其定位到用户个人资料字段。或者您可以使用开源分析工具Matomo。';
$string['analyticssettingsheading'] = '设置Google Analytics和/或Matomo';
$string['analyticstext'] = '分析ID';
$string['analyticstextdesc'] = '输入Google Analytics ID';
$string['anonymizega'] = '匿名化用户IP';
$string['anonymizegadesc'] = '对发送到 Google Analytics（分析）的用户 IP 进行匿名化处理。';
$string['backcolor'] = '背景颜色';
$string['backcolordesc'] = '设置背景颜色。';
$string['bcustyle'] = 'BCU风格';
$string['blockbackgroundcolor'] = '版块背景颜色';
$string['blockbackgroundcolordesc'] = '设置所有版块的背景颜色。';
$string['blockbordercolor'] = '版块边框颜色';
$string['blockbordercolordesc'] = '设置版块边框颜色。';
$string['blockheaderbackgroundcolor'] = '版块标题背景颜色';
$string['blockheaderbackgroundcolordesc'] = '设置所有版块标题的背景颜色。';
$string['blockheaderborderbottom'] = '版块页眉底部边框粗细';
$string['blockheaderborderbottomdesc'] = '设置版块页眉标题底部边框的粗细';
$string['blockheaderborderleft'] = '版块页眉左边框粗细';
$string['blockheaderborderleftdesc'] = '设置版块页眉标题左边框的粗细';
$string['blockheaderborderright'] = '版块页眉右边框粗细';
$string['blockheaderborderrightdesc'] = '设置版块页眉标题右边框的粗细';
$string['blockheaderbordertop'] = '版块页眉上边框粗细';
$string['blockheaderbordertopdesc'] = '设置版块页眉标题上部边框的粗细';
$string['blockheaderbordertopstyle'] = '版块页眉边框样式';
$string['blockheaderbordertopstyledesc'] = '设置版块页眉标题边框的样式';
$string['blockheaderbottomradius'] = '版块标头底部半径';
$string['blockheaderbottomradiusdesc'] = '设置标题版块底部半径，实现弯曲/圆角效果';
$string['blockheadercolor'] = '版块标题字体颜色';
$string['blockheadercolordesc'] = '设置版块标题字体颜色。';
$string['blockheadertopradius'] = '版块标头上部半径';
$string['blockheadertopradiusdesc'] = '设置标题版块上部半径，实现弯曲/圆角效果';
$string['blockicons'] = '版块图标';
$string['blockiconsdesc'] = '设置在版块标题区域中显示版块图标。';
$string['blockiconsheadersize'] = '版块标题图标大小';
$string['blockiconsheadersizedesc'] = '设置在版块标题中使用的字体图标大小。请在列表中选择一个值。';
$string['blocklayoutbuilder'] = '首页版块区域';
$string['blocklayoutbuilderdesc'] = '您可在下方为首页构建自己的版块布局。
您需要<strong> 在首页打开编辑页面功能</strong> 以便向区域添加内容。
随后你可以开始向你创建的区域中拖拽版块。';
$string['blocklayoutlayoutcheck'] = '检查您的布局';
$string['blocklayoutlayoutcheckdesc'] = '使用下面的工具检查已使用版块数, 并查看新布局的展示形式。';
$string['blocklayoutlayoutcount1'] = '您可以设置最大为';
$string['blocklayoutlayoutcount2'] = '版块区域。您当前正在使用:';
$string['blocklayoutlayoutrow'] = '版块区域行';
$string['blocklayoutlayoutrowdesc'] = '为首页上的版块区域行添加/设置布局。';
$string['blockmainborderbottom'] = '版块主底边框粗细';
$string['blockmainborderbottomdesc'] = '设置主版块区域左边框的粗细';
$string['blockmainborderleft'] = '版块左主边框粗细';
$string['blockmainborderleftdesc'] = '设置主版块区域左边框的粗细';
$string['blockmainborderright'] = '版块右主边框粗细';
$string['blockmainborderrightdesc'] = '设置主版块区域右边框的粗细';
$string['blockmainbordertop'] = '版块上主边框粗细';
$string['blockmainbordertopdesc'] = '设置主版块区域顶部边框的粗细';
$string['blockmainbordertopstyle'] = '版块主边框样式';
$string['blockmainbordertopstyledesc'] = '设置版块内容区域的边框样式';
$string['blockmainbottomradius'] = '主版块底部半径';
$string['blockmainbottomradiusdesc'] = '设置主版块下部半径，实现弯曲/圆角效果';
$string['blockmaintopradius'] = '主版块顶部半径';
$string['blockmaintopradiusdesc'] = '设置主版块顶部半径，实现弯曲/圆角效果';
$string['blockregionbackground'] = '版块区域背景颜色';
$string['blockregionbackgrounddesc'] = '首页中的自定义布局容器的背景颜色';
$string['blockregioneditingtitleshown'] = '编辑时显示板块区域标题';
$string['blockregioneditingtitleshowndesc'] = '编辑时可以显示/隐藏版块区域标题。';
$string['blockshowhide'] = '显示/隐藏版块';
$string['blockside'] = '版块位置';
$string['blocksidedesc'] = '控制版块显示在页面的左侧还是右侧';
$string['breadcrumb'] = '线索';
$string['breadcrumbbackgroundcolor'] = '线索背景颜色';
$string['breadcrumbbackgroundcolordesc'] = '设置线索背景颜色';
$string['breadcrumbdisplay'] = '显示线索';
$string['breadcrumbdisplaydesc'] = '设置线索区域应该显示的内容。';
$string['breadcrumbhome'] = '线索主页';
$string['breadcrumbhomedesc'] = '将线索主页显示为图标或文本。';
$string['breadcrumbhomeicon'] = '图标';
$string['breadcrumbhometext'] = '文本';
$string['breadcrumbseparator'] = '线索分隔线';
$string['breadcrumbseparatordesc'] = '设置‘<a href="{$a}" target="_blank">Font Awesome Icons</a>’作为线索中的条目分隔符。输入不带“fa-”前缀的图标名称。';
$string['breadcrumbtextcolor'] = '线索文字颜色';
$string['breadcrumbtextcolordesc'] = '设置线索导航的文字颜色。';
$string['breadcrumbtitle'] = '线索课程名称';
$string['breadcrumbtitledesc'] = '设置课程标题在线索栏中的显示方式';
$string['buttoncolor'] = '按钮颜色';
$string['buttoncolorcancel'] = '取消按钮颜色';
$string['buttoncolordesc'] = '整个网站使用的主要按钮的颜色。';
$string['buttoncolordesccancel'] = '取消按钮的背景颜色。<br />在框中输入数值表示透明度。';
$string['buttoncolordescscnd'] = '整个网站中使用的次要按钮的颜色。';
$string['buttoncolorscnd'] = '次要按钮的颜色';
$string['buttondesc'] = '更改此主题中使用的按钮外观。';
$string['buttondropshadow'] = '按钮底部的阴影装饰';
$string['buttondropshadowdesc'] = '在按钮底部显示阴影(底纹)。';
$string['buttonfocuscolour'] = '按钮焦点背景颜色';
$string['buttonfocuscolourdesc'] = '按钮被选中时使用的颜色。';
$string['buttonhovercolor'] = '按钮颜色（悬停时）';
$string['buttonhovercolorcancel'] = '取消按钮悬停颜色';
$string['buttonhovercolordesc'] = '鼠标悬停在按钮上时按钮的颜色。';
$string['buttonhovercolordesccancel'] = '当将鼠标悬停在按钮上时，取消按钮变为的颜色。<br />在框中输入数值表示透明度。';
$string['buttonhovercolordescscnd'] = '当将鼠标悬停在次要按钮上时，该按钮改变为的颜色。';
$string['buttonhovercolorscnd'] = '次要按钮悬停颜色';
$string['buttonlogincolor'] = '登录按钮颜色';
$string['buttonlogincolordesc'] = '登录按钮的颜色。';
$string['buttonloginheight'] = '设置登录按钮的高度';
$string['buttonloginheightdesc'] = '仅在位于顶部页眉的登录窗口生效';
$string['buttonloginhovercolor'] = '登录按钮鼠标悬停颜色';
$string['buttonloginhovercolordesc'] = '鼠标悬停在按钮上时，登录按钮的颜色。';
$string['buttonloginmargintop'] = '设置登录按钮的顶部边距';
$string['buttonloginmargintopdesc'] = '允许更改登录按钮的间距/位置';
$string['buttonloginpadding'] = '设置 "登录" 按钮的内部边距';
$string['buttonloginpaddingdesc'] = '更大的数字 = 更大的按钮';
$string['buttonlogintextcolor'] = '登录按钮文字颜色';
$string['buttonlogintextcolordesc'] = '登录按钮上文字的颜色。';
$string['buttonradius'] = '设置按钮半径';
$string['buttonradiusdesc'] = '较大的半径 = 圆角按钮, 较小的半径 = 正方形按钮';
$string['buttonsettings'] = '按钮';
$string['buttonsettingsheading'] = '自定义此主题的按钮。';
$string['buttontextcolor'] = '按钮文字颜色';
$string['buttontextcolorcancel'] = '取消按钮文本颜色';
$string['buttontextcolordesc'] = '按钮上文字使用的颜色';
$string['buttontextcolordesccancel'] = '取消按钮上使用的文本颜色。';
$string['buttontextcolordescscnd'] = '用于次要按钮的文本颜色。';
$string['buttontextcolorscnd'] = '次要按钮文本颜色';
$string['buttontextfocuscolour'] = '按钮焦点文本颜色';
$string['buttontextfocuscolourdesc'] = '按钮被选中时在按钮上使用的文本颜色。';
$string['buttontexthovercolor'] = '按钮文本悬停颜色';
$string['buttontexthovercolordesc'] = '当鼠标悬停在按钮上时，按钮文本改变为的颜色。';
$string['categoryhavecustomheader'] = '自定义类别标题';
$string['categoryhavecustomheaderdesc'] = '选择具有自定义标题的顶级类别。要选择多个类别或取消选择一个类别，请使用` Ctrl `键。保存并刷新页面以更新。注意：所选的子类别将继承设置的值。';
$string['categoryheaderbgimage'] = '类别 \'{$a->name}\'id为 \'{$a->id}\' 的背景图像';
$string['categoryheaderbgimagedesc'] = '在标题中设置顶级类别 \'{$a->name}\' id为\'{$a->id}\'的背景图像。最小尺寸为1600x180px（推荐1900x180px）。该图像将覆盖整个标题。';
$string['categoryheaderbgimagedescchildren'] = '在标题中设置id为\'{$a->id}\'的顶级类别 \'{$a->name}\' 及其子类 \'{$a->children}\' 的背景图像。最小尺寸为1600x180px（推荐1900x180px）。该图像将覆盖整个标题。';
$string['categoryheaderbgimagetextcolour'] = '类别 \'{$a->name}\' id为 ‘{$a->id}’背景图像文本颜色';
$string['categoryheaderbgimagetextcolourdesc'] = '为标题中id为\'{$a->id}\'的顶级类别\'{$a->name}\'设置背景图像文本颜色。';
$string['categoryheaderbgimagetextcolourdescchildren'] = '为顶级类别‘{$a->name}’的id ‘{$a->id}’和它的子标题‘{$a->children}’设置背景图像文本颜色。';
$string['categoryheadercustomcss'] = '类别 \'{$a->name}\' id为\'{$a->id}\'自定义SCSS';
$string['categoryheadercustomcssdesc'] = '为顶级类别 \'{$a->name}\'  id为 \'{$a->id}\'设置自定义SCSS。这将为以\' .category-{$a->id} \'为前缀的主题选择器生成SCSS。如果SCSS没有被应用，那么使用浏览器开发工具来调查和检查PHP日志文件。';
$string['categoryheadercustomcssdescchildren'] = '为顶级类别 \'{$a->name}\' id为\'{$a->id}\'及其其子项 \'{$a->children}\'设置自定义SCSS。这将为以 \'.category-{$a->id}\'为前缀的主题选择器和所有子id生成SCSS。如果SCSS没有被应用，那么使用浏览器开发工具来调查和检查PHP日志文件。';
$string['categoryheadercustomtitle'] = '类别 \'{$a->name}\'，id为\'{$a->id}\'自定义标题';
$string['categoryheaderheader'] = '设置顶级类别 \'{$a->name}\'  id为 \'{$a->id}\'。';
$string['categoryheaderheaderdesc'] = '设置顶级类别 \'{$a->name}\'  id为 \'{$a->id}\'的参数。';
$string['categoryheaderheaderdescchildren'] = '设置顶级类别 \'{$a->name}\'  id为 \'{$a->id}\' 及其子类\'{$a->children}\'的参数。';
$string['categoryheaderlogo'] = '类别 \'{$a->name}\'  id为 \'{$a->id}\'的徽标';
$string['categoryheaderlogodesc'] = '为顶级类别 \'{$a->name}\'  id为 \'{$a->id}\'设置徽标。推荐的尺寸是200px * 80px。';
$string['categoryheaderlogodescchildren'] = '为顶级类别 \'{$a->name}\'  id为 \'{$a->id}\'及其子类\'{$a->children}\'设置徽标。推荐的尺寸是200px * 80px。';
$string['categoryheaderssettings'] = '分类标题';
$string['categoryheaderssettingsheading'] = '更改一个或多个顶级类别及以下类别的标题。';
$string['cdefaulticon'] = '我的课程默认图标';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Credits</h2>
<h3>About</h3>
<p>Adaptable 基于流行的BCU主题，是一款可高度自定义的双列响应式主题。</p>
<p>本主题为 GNU授权方式 (GNU General Public License)。您可在此找到完成的授权协议。 <a href="http://www.gnu.org/licenses/" target="_HERE">blank</a></p>
<br>
<h4>修改它！- 改进它！- 分享它！</h4>
<br>
<p>此主题开发者为:<br>
Jeremy Hopkins (Coventry 大学)<br>
Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>)</p>
<br>
<p>以及大批其它开发人员、测试人员、翻译人员以及志愿者们。 (见 <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<p>请访问 adaptable 网站获取更多信息，提示和技巧以及技术支持: <a href="https://adaptable.ws" target="_blank">adaptable.ws</a></p>
<br>
<h3>问题报告</h3>
<p>您可提报程序缺陷 (请务必, <b>仅提报</b> 程序缺陷) 至 <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">Bitbucket repository</a></p>
<br>
<h3>技术支持</h3>
<p>您可在 Adaptable 网站 (仅英语)请求技术支持 <a href="https://adaptable.ws/support/support-tickets" target="_blank">获取技术支持</a></p>
<br>
<p>您也可以在 moodle 论坛上提问:</p>
<ul>
<li>英语: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>西班牙语: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>加泰罗尼亚语: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>文档</h3>
<p>敬请期待</p>
<br>
<h3>演示</h3>
<p>你可<a href="https://adaptable.ws/demo" target="_blank">在此</a>浏览演示</p>
<br>
</div>
</div>';
$string['colordesc'] = '您可以选择整个主题中使用的颜色。使用十六进制或任何其他标准表示方法。作为备用选项，您可以使用透明及继承作为参数值';
$string['colorsettings'] = '颜色';
$string['colorsettingsheading'] = '修改整个主题使用的主要颜色。';
$string['configtabtitle'] = '设置';
$string['configtitle'] = 'Adaptable';
$string['course'] = '进入课程';
$string['courseactivitynavigationenabled'] = '活动导航';
$string['courseactivitynavigationenableddesc'] = '启用活动导航';
$string['courseindexenabled'] = '启用';
$string['courseindexenableddesc'] = '启用或禁用“课程索引”。';
$string['courseindexsettings'] = '课程索引';
$string['courseindexsettingsdesc'] = '自定义课程索引。';
$string['courseindexsettingsheading'] = '课程索引设置';
$string['coursepageactivitybottomblockregionheading'] = '自定义课程活动底部版块区域';
$string['coursepageactivitybottomblockregionheadingdesc'] = '活动结束后出现的自定义版块区域。';
$string['coursepageblockactivitybottomenabled'] = '在课程页面上启用课程活动底部版块区域';
$string['coursepageblockactivitybottomenableddesc'] = '在所有课程页面上启用此区域。';
$string['coursepageblocklayoutbuilder'] = '课程页面版块区域';
$string['coursepageblocklayoutbuilderdesc'] = '您可在下方为课程页面构建自己的版块布局。
您需要<strong> 在课程页面打开编辑页面功能</strong> 以便向区域添加内容。
随后你可以开始向你创建的区域中拖放版块。';
$string['coursepageblocklayoutlayoutbottomrow'] = '课程页面版块底部区域行';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = '为课程页面版块区域行添加/设置布局。';
$string['coursepageblocklayoutlayouttoprow'] = '课程页面版块顶部区域行';
$string['coursepageblocklayoutlayouttoprowdesc'] = '为课程页面版块区域行添加/设置布局。';
$string['coursepageblockregionsettings'] = '课程页面版块区域生成器';
$string['coursepageblocksenabled'] = '在 "课程" 页面上启用自定义版块区域';
$string['coursepageblocksenableddesc'] = '您可以在 "课程" 页面上启用/禁用自定义版块区域 (顶部和底部)。 然后, 您可以将版块拖放到您创建的区域中';
$string['coursepageblocksliderenabled'] = '在 "课程" 页面上启用自定义滚动区域';
$string['coursepageblocksliderenableddesc'] = '在所有课程页面上启用此区域。';
$string['coursepageheaderhidesitetitle'] = '在课程页面隐藏站点标题';
$string['coursepageheaderhidesitetitledesc'] = '在课程页面上隐藏网站标题、徽标和搜索栏。将其与页眉高度设置一起使用, 以便在与课程相关的页面上显示较小的页眉。';
$string['coursepageheaderhidetitle'] = '在课程页面上隐藏标题';
$string['coursepageheaderhidetitledesc'] = '在课程页面隐藏标题，徽标和搜索栏。将此与页面标题高度设置一起使用，以在课程相关的页面上显示较小的标题。';
$string['coursepagenewssliderblockregionheading'] = '自定义新闻滚动版块区域';
$string['coursepagenewssliderblockregionheadingdesc'] = '现在课程页面的课程活动上方。如要添加新闻滚动区块，首先请安装<strong><a href="https://moodle.org/plugins/block_news_slider">Adaptable UI news slider</a></strong> 并配置它在所有课程页面的 "课程页面滚动区域"显示。';
$string['coursepagesidebarinfooterenabled'] = '将边栏移动到 "课程" 页面的页脚';
$string['coursepagesidebarinfooterenableddesc'] = '通过将边栏移动到页脚, 将课程页面变得更宽。';
$string['coursepagesidebarinfooterenabledsection'] = '常见设置';
$string['coursepagesidebarinfooterenabledsectiondesc'] = '大多数课程格式的常用设置。';
$string['courses'] = '课程';
$string['coursesearch'] = '课程搜索';
$string['coursesectionactivityassignbgcolor'] = '课程委派背景颜色';
$string['coursesectionactivityassignbgcolordesc'] = '设置课程委派活动背景颜色。';
$string['coursesectionactivityassignleftbordercolor'] = '分配活动左边框显示颜色';
$string['coursesectionactivityassignleftbordercolordesc'] = '设置左边框的颜色。';
$string['coursesectionactivitybordercolor'] = '课程章节活动底部边框颜色';
$string['coursesectionactivitybordercolordesc'] = '设置课程章节活动底部边框的颜色。';
$string['coursesectionactivityborderstyle'] = '课程章节活动底部边框样式';
$string['coursesectionactivityborderstyledesc'] = '设置课程章节活动底部边框的风格。';
$string['coursesectionactivityborderwidth'] = '课程章节活动底部边框粗细';
$string['coursesectionactivityborderwidthdesc'] = '设置课程章节活动底部边框的宽度。';
$string['coursesectionactivitycolors'] = '课程章节活动选项';
$string['coursesectionactivityforumbgcolor'] = '论坛活动背景颜色';
$string['coursesectionactivityforumbgcolordesc'] = '设置论坛活动背景颜色。';
$string['coursesectionactivityforumleftbordercolor'] = '论坛活动左边框显示颜色';
$string['coursesectionactivityforumleftbordercolordesc'] = '设置左边框的颜色。';
$string['coursesectionactivityiconsize'] = '课程章节活动图标大小';
$string['coursesectionactivityiconsizedesc'] = '设置活动/递归的图标大小 (例如, 16px 的值将其设置为 16px x16px)。';
$string['coursesectionactivityleftborderwidth'] = '课程章节活动左边框粗细';
$string['coursesectionactivityleftborderwidthdesc'] = '设置课程章节活动研左侧边框宽度。';
$string['coursesectionactivitymarginbottom'] = '活动底边间距。';
$string['coursesectionactivitymarginbottomdesc'] = '活动之间的底边间距。';
$string['coursesectionactivitymargintop'] = '活动上边间距';
$string['coursesectionactivitymargintopdesc'] = '活动之间上间距。';
$string['coursesectionactivityquizbgcolor'] = '测验活动背景颜色';
$string['coursesectionactivityquizbgcolordesc'] = '设置测验活动背景颜色。';
$string['coursesectionactivityquizleftbordercolor'] = '测验活动左边框显示颜色';
$string['coursesectionactivityquizleftbordercolordesc'] = '设置左边框的颜色。';
$string['coursesectionbgcolor'] = '课程章节背景';
$string['coursesectionbgcolordesc'] = '设置课程章节的背景颜色。';
$string['coursesectionbordercolor'] = '课程章节边框颜色';
$string['coursesectionbordercolordesc'] = '设置课程章节的边框颜色';
$string['coursesectionborderradius'] = '课程章节边框半径';
$string['coursesectionborderradiusdesc'] = '设置课程章节边框的半径 (圆角)';
$string['coursesectionborderstyle'] = '课程章节边框样式';
$string['coursesectionborderstyledesc'] = '设置课程章节边框风格';
$string['coursesectionborderwidth'] = '课程章节边框粗细';
$string['coursesectionborderwidthdesc'] = '设置课程章节边框的宽度';
$string['coursesectionheaderbg'] = '课程章节标题背景';
$string['coursesectionheaderbgdesc'] = '设置课程章节页眉的背景颜色。';
$string['coursesectionheaderbordercolor'] = '课程章节页眉边框颜色';
$string['coursesectionheaderbordercolordesc'] = '设置课程章节标题边框的颜色（仅作用于底部边框，因为外部容器也有边框）';
$string['coursesectionheaderborderradiusbottom'] = '课程章节标题边框按钮半径';
$string['coursesectionheaderborderradiusbottomdesc'] = '设置课程章节标题边框的半径 (圆角)';
$string['coursesectionheaderborderradiustop'] = '课程章节标题上边框半径';
$string['coursesectionheaderborderradiustopdesc'] = '设置课程章节标题上边框的半径 (圆角)';
$string['coursesectionheaderborderstyle'] = '课程章节标题边框样式';
$string['coursesectionheaderborderstyledesc'] = '设置课程章节标题边框的样式（仅作用于底部边框，因为外部容器也有边框）';
$string['coursesectionheaderborderwidth'] = '课程章节标题边框粗细';
$string['coursesectionheaderborderwidthdesc'] = '设置课程章节标题边框的粗细（仅作用于底部边框，因为外部容器也有边框）';
$string['coursesections'] = '课程章节';
$string['coursesettings'] = '课程格式';
$string['coursesettingsdesc'] = '自定义一些最常用的 Moodle 课程格式, 以适应主设计。';
$string['coursesettingsheading'] = '课程格式设置';
$string['coursetitlefullname'] = '课程全称';
$string['coursetitlemaxwidth'] = '课程标题最大长度';
$string['coursetitlemaxwidthdesc'] = '设置课程标题区域的最大字符数';
$string['coursetitleshortname'] = '课程短名称/代码';
$string['covbkcolor'] = '磁贴式标题背景颜色';
$string['covbkcolordesc'] = '当选择磁贴式渲染器时，设置标题背景颜色。';
$string['coventrystyle'] = '考文垂风格';
$string['covfontcolor'] = '磁贴式标题背景文字颜色';
$string['covfontcolordesc'] = '当选择磁贴式渲染器时，设置标题文字颜色。';
$string['covhidebutton'] = '磁贴式课程按钮';
$string['covhidebuttondesc'] = '选择磁贴方式时, 此设置将隐藏课程按钮。';
$string['currentcolor'] = '当前课程章节突出显示颜色';
$string['currentcolordesc'] = '设置当前课程章节突出显示的颜色';
$string['customcoursesubtitle'] = '自定义课程副标题';
$string['customcoursetitle'] = '自定义课程名称';
$string['customcss'] = '自定义CSS';
$string['customcssdesc'] = '您在此文本区域提供的任何CSS规则将影响每个页面，此方式可简化本对本主题的自定义。';
$string['customcssjssettingsheading'] = '应用你自己的修改';
$string['customcsssettings'] = '自定义 CSS';
$string['customcsssettingsdescription'] = '在这里你可以找到各种设置来添加你自己的CSS到主题。';
$string['dashblocklayoutbuilder'] = '仪表板版块区域';
$string['dashblocklayoutbuilderdesc'] = '您可在下方版块区域构建自己的布局。
您需要<strong> 在仪表盘页面打开编辑页面功能</strong> 以便向区域添加内容。
随后你可以开始向你创建的区域中拖放版块。';
$string['dashblocklayoutlayoutrow'] = '仪表板版块区域行';
$string['dashblocklayoutlayoutrowdesc'] = '为仪表板页面的版块区域行添加/设置布局。';
$string['dashblocksenabled'] = '在仪表盘页面上启用自定义版块区域';
$string['dashblocksenableddesc'] = '您可以在仪表盘页面上启用/禁用自定义版块区域 (顶部和底部)。 然后, 您可以将版块拖放到您创建的区域中';
$string['dashblocksposition'] = '自定义版块区域位置';
$string['dashblockspositiondesc'] = '当自定义版块区域为仪表板页面启用时，选择位置。';
$string['dashboardblockregionsettings'] = '仪表盘版块区域生成器';
$string['defaultzoom'] = '默认缩放';
$string['defaultzoomdesc'] = '当启用缩放功能被禁用或用户没有设置首选项时，默认屏幕大小。在全屏和固定宽度之间选择。';
$string['disablecustommenu'] = '禁用 Moodle 自定义菜单';
$string['disablecustommenudesc'] = '在导航栏中禁用 Moodle 自定义菜单 (仍会在您可能已安装的其他主题中呈现)';
$string['disabled'] = '已禁用';
$string['disablemenuscoursepages'] = '禁用课程页面中的菜单';
$string['disablemenuscoursepagesdesc'] = '打开此选项将限制顶级菜单的显示在网站页面、主页和仪表盘 ("我的主页") 等, 且不会在任何课程页面中显示';
$string['discardbuttontext'] = '取消';
$string['displayeditingbuttontext'] = '编辑按钮文本';
$string['displayeditingbuttontextdesc'] = '显示或隐藏编辑按钮上的文本。注意：仅适用于课程编辑按钮。';
$string['displaygrades'] = '显示成绩';
$string['displaygradesdesc'] = '在菜单中显示成绩项';
$string['displaylogin'] = '显示登录';
$string['displayloginbox'] = '登录框';
$string['displayloginbutton'] = '按钮';
$string['displaylogindesc'] = '选择如何在屏幕上显示登录名 (启用上述内容时)。';
$string['displayloginno'] = '不登录';
$string['displayparticipants'] = '显示参与者';
$string['displayparticipantsdesc'] = '在菜单中显示参与者项';
$string['dividingline'] = '标题中的分隔线';
$string['dividingline2'] = '页脚中的分隔线';
$string['dividingline2desc'] = '页脚中分隔线颜色';
$string['dividinglinedesc'] = '页脚中分隔线的颜色';
$string['editfont'] = '辑和自定义此页面按钮字体颜色';
$string['editfontdesc'] = '设置 "编辑和自定义此页" 按钮字体颜色';
$string['edithorizontalpadding'] = '设置编辑按钮的水平内部边距';
$string['editoffbk'] = '编辑和自定义此页关闭按钮背景';
$string['editoffbkdesc'] = '';
$string['editonbk'] = '编辑和自定义此页按钮背景';
$string['editonbkdesc'] = '为自定义此页面按钮设置背景颜色';
$string['editsettingsbutton'] = '编辑设置和按钮显示';
$string['emoticonsize'] = '表情符号大小';
$string['emoticonsizedesc'] = '设置表情符号的高度和宽度。';
$string['enablealert'] = '启用提示框 {$a}';
$string['enablealertdesc'] = '启用提示框 {$a}';
$string['enablealerts'] = '启用/禁用提示';
$string['enablealertsdesc'] = '在全站启用/禁用提示';
$string['enablealertstriptags'] = '从提示信息中自动删除 html 标记';
$string['enablealertstriptagsdesc'] = '启用此选项将自动清理提示消息, 禁用将允许您在消息中使用 html / 链接, 但必须在 html 视图中手动清理';
$string['enableanalytics'] = '启用谷歌分析';
$string['enableanalyticsdesc'] = '在您的 Moodle 网站上启用谷歌分析设置';
$string['enableavailablecourses'] = '显示 "可用课程"';
$string['enableavailablecoursesdesc'] = '在首页中显示 "可用课程" 文本';
$string['enablebadges'] = '勋章';
$string['enablebadgesdesc'] = '显示用户勋章链接';
$string['enableblog'] = '启用我的博客';
$string['enableblogdesc'] = '显示链接到用户博客页';
$string['enablecalendar'] = '用户日历';
$string['enablecalendardesc'] = '显示链接用户日历';
$string['enablecoursetitle'] = '课程标题';
$string['enablecoursetitledesc'] = '设置显示课程标题的模式。';
$string['enableeditprofile'] = '编辑个人资料';
$string['enableeditprofiledesc'] = '显示至用户个人资料的链接';
$string['enableeventsdesc'] = '显示日历链接';
$string['enablefeed'] = '我的反馈';
$string['enablefeeddesc'] = '显示用户的"我的反馈" 页面 - 注意: 此功能需要 <a href="https://moodle.org/plugins/report_myfeedback" target="blank">我的反馈插件</a>';
$string['enablegrades'] = '成绩';
$string['enablegradesdesc'] = '显示用户成绩链接';
$string['enableheading'] = '页眉课程标题';
$string['enableheadingdesc'] = '默认 Moodle 网站标题启用时，设置页眉中课程标题的显示模式。';
$string['enablehelp'] = '帮助链接';
$string['enablehelpdesc'] = '在导航栏中添加帮助链接。';
$string['enablehomedesc'] = '显示链接首页';
$string['enablehomeredirect'] = '启用首页重定向 = 0';
$string['enablehomeredirectdesc'] = '在首页中启用重定向 = 0。适用于 "我的首页" 调为默认网站主页首页情况。它可以防止用户单击 "主页" 链接被重定向回 "我的主页/仪表板"';
$string['enablemenus'] = '启用菜单';
$string['enablemenusdesc'] = '如因性能原因菜单不能使用, 建议关闭本项';
$string['enablemy'] = '我的首页';
$string['enablemydesc'] = '显示"我的主页"页面';
$string['enablemysitesdesc'] = '显示包含用户课程的下拉列表';
$string['enablemysitesrestriction'] = '将用户的课程下拉列表限制为自定义配置文件字段';
$string['enablemysitesrestrictiondesc'] = '通过自定义配置文件字段限制用户课程的下拉列表。例如用户类型 = 工作人员';
$string['enablenavbarwhenloggedout'] = '注销后启用导航栏';
$string['enablenavbarwhenloggedoutdesc'] = '即使注销时, 也会显示导航栏。仅限于 "帮助" 和 "工具" 菜单。';
$string['enablenote'] = '我的通知';
$string['enablenotedesc'] = '显示指向用户通知页的链接';
$string['enableposts'] = '我的帖子';
$string['enablepostsdesc'] = '显示"我的跟贴"链接';
$string['enablepref'] = '我的首选项';
$string['enableprefdesc'] = '显示指向用户首选项页的链接';
$string['enableprivatefiles'] = '私人文件';
$string['enableprivatefilesdesc'] = '显示指向用户个人文件的链接';
$string['enableprofile'] = '用户资料';
$string['enableprofiledesc'] = '显示至用户个人资料的链接';
$string['enablesavecanceloverlay'] = '在设置页中启用保存/取消叠加层';
$string['enablesavecanceloverlaydesc'] = '在设置页顶部显示 "保存/取消" 按钮叠加层, 以便更轻松地保存设置。';
$string['enablesavecanceloverlayresetconfirm'] = '这将重置自加载该页以来所做的任何更改。你确定吗？';
$string['enableshowhideblocks'] = '启用显示/隐藏版块';
$string['enableshowhideblocksdesc'] = '允许用户显示/隐藏所有版块。';
$string['enableshowhideblockstext'] = '显示文本显示隐藏版块';
$string['enableshowhideblockstextdesc'] = '显示文本在按钮的旁边。';
$string['enablethiscoursedesc'] = '显示包含当前课程活动的下拉列表';
$string['enableticker'] = '在主页上启用滚动新闻?';
$string['enabletickerc'] = '在内部页面上启用新闻滚动？';
$string['enabletickercdesc'] = '勾选以启用内部页面上滚动信息。';
$string['enabletickerdesc'] = '勾选以启用主页上的滚动信息。';
$string['enabletickermy'] = '在 "我的主页/仪表板" 页面上启用新闻滚动？';
$string['enabletickermydesc'] = '勾选以启用 "我的主页/仪表板" 上的滚动信息。';
$string['enabletoolsmenus'] = '启用工具菜单';
$string['enabletoolsmenusdesc'] = '如不使用菜单，建议关闭本项以提高性能';
$string['enableusermysitessortoverride'] = '启用用户自定义课程排序';
$string['enableusermysitessortoverridedesc'] = '允许用户为“我的课程自定义排序”设置自己的值，包括默认为“mysitessortoverride”设置的主题设置值';
$string['enablezoom'] = '启用缩放';
$string['enablezoomdesc'] = '允许用户在全屏和固定宽度之间切换。';
$string['enablezoomshowtext'] = '显示文本启用缩放';
$string['enablezoomshowtextdesc'] = '显示文本在按钮的旁边。';
$string['events'] = '事件';
$string['expandable'] = '可扩展';
$string['favicon'] = '收藏夹图标';
$string['favicondesc'] = '上传一个网站使用的收藏夹图标，';
$string['fontblockheadercolor'] = '版块标题字体颜色';
$string['fontblockheadercolordesc'] = '设置moodle版块标题字体的颜色, 使用 html 十六进制代码。请注意, 这也会影响图标颜色。';
$string['fontblockheadersize'] = '版块标题字号';
$string['fontblockheadersizedesc'] = '设置在版块标题中使用的字号。请在列表中选择一个值。';
$string['fontblockheaderweight'] = '版块标题字体粗细';
$string['fontblockheaderweightdesc'] = '设置版块标题中使用的字体粗细。根据所选字体选择从100到900的值。';
$string['fontcolor'] = '字体主颜色';
$string['fontcolordesc'] = '设置主题字体颜色, 使用 html 十六进制代码。';
$string['fontdesc'] = '您可选择在本主题中使用的<a href="https://www.google.com/fonts" target="_blank">谷歌字体</a>。 选择需要的字体子集 (均包括拉丁字母) 同时输入正确的字体粗细或不需要显示的字体。';
$string['fontheadercolor'] = '标题字体颜色';
$string['fontheadercolordesc'] = '设置主题主标题字体颜色, 使用 html 十六进制代码。';
$string['fontheadername'] = '标题字体';
$string['fontheadernamedesc'] = '选择用于文字及版块标题的默认字体或 or <a href="https://www.google.com/fonts" target="_blank">谷歌字体</a> 。';
$string['fontheaderweight'] = '标题字体粗细';
$string['fontheaderweightdesc'] = '全站标题使用的字体粗细。根据所选字体选择从100到900的值。';
$string['fontname'] = '主字体';
$string['fontnamedesc'] = '选择全站默认字体或 <a href="https://www.google.com/fonts" target="_blank">谷歌字体</a> 。';
$string['fontsettings'] = '字体';
$string['fontsettingsheading'] = '修改整个主题使用的字体。';
$string['fontsize'] = '主字体字号';
$string['fontsizedesc'] = '选择全站使用的默认字号 (百分比)。';
$string['fontsubset'] = '谷歌字体子集';
$string['fontsubsetdesc'] = '选择要应用于所有字体的其他字符子集, 而不是拉丁语。默认情况下, 拉丁语子集已包含。';
$string['fonttitlecolor'] = '网站/课程标题字体颜色';
$string['fonttitlecolorcourse'] = '课程标题字体颜色';
$string['fonttitlecolorcoursedesc'] = '设置主题中课程标题字体颜色, 使用 html 十六进制代码。';
$string['fonttitlecolordesc'] = '设置主题中网站标题和课程标题字体颜色, 使用 html 十六进制代码。';
$string['fonttitlename'] = '网站/课程标题字体';
$string['fonttitlenamedesc'] = '选择网站标题及课程标题默认字体或 <a href="https://www.google.com/fonts" target="_blank">谷歌字体</a> 。';
$string['fonttitlesize'] = '网站/课程标题字号';
$string['fonttitlesizedesc'] = '本站网站标题和课程标题字号。在列表中选择一个值。';
$string['fonttitleweight'] = '网站/课程标题字体粗细';
$string['fonttitleweightdesc'] = '本站标题及课程标题使用的字体粗细。根据所选字体选择从100到900的值。';
$string['fontweight'] = '主字体粗细';
$string['fontweightdesc'] = '全站使用的字体粗细。根据所选字体选择从100到900的值。';
$string['footerbkcolor'] = '页脚背景颜色';
$string['footerbkcolordesc'] = '设置页脚背景颜色。';
$string['footerblocksplacement'] = '页脚版块位置';
$string['footerblocksplacement1'] = '全站范围';
$string['footerblocksplacement2'] = '仅限主页';
$string['footerblocksplacement3'] = '从不';
$string['footerblocksplacementdesc'] = '控制在何位置显示上部页脚版块。默认值为全站范围。';
$string['footerbuilderheading'] = '页脚块布局生成器';
$string['footercontent'] = '页脚内容部分';
$string['footercontentdesc'] = '向页脚部分添加内容';
$string['footerdesc'] = '为页脚部分添加标题';
$string['footerheader'] = '页脚标题区';
$string['footerlayoutrow'] = '页脚布局生成器';
$string['footerlayoutrowdesc'] = '为页脚版块区域设计布局。';
$string['footerlinkcolor'] = '页脚版块链接颜色';
$string['footerlinkcolordesc'] = '页脚版块链接颜色';
$string['footersettings'] = '页脚';
$string['footersettingsheading'] = '设置应显示在页脚中的内容。可<a href="./../theme/adaptable/pix/layout.png" target="_blank"> 在此处</a>查看布局';
$string['footertextcolor'] = '页脚文本颜色';
$string['footertextcolor2'] = '低层页脚文本颜色';
$string['footertextcolor2desc'] = '低层页脚文本颜色';
$string['footertextcolordesc'] = '在页脚中的文本的颜色, 使用 html 十六进制代码。';
$string['footnote'] = '脚注';
$string['footnotedesc'] = '向页脚添加文字。';
$string['forumbodybackgroundcolor'] = '论坛帖子正文背景';
$string['forumbodybackgroundcolordesc'] = '论坛帖子的背景色';
$string['forumheaderbackgroundcolor'] = '论坛帖子标题背景';
$string['forumheaderbackgroundcolordesc'] = '论坛帖子的背景色';
$string['frnt-footer'] = '此区域中的版块仅对管理员用户可见';
$string['frontpageblocksenabled'] = '在首页启用自定义版块区域';
$string['frontpageblocksenableddesc'] = '您可以在首页上启用/禁用自定义版块区域 。 然后, 您可以将版块拖放到您创建的区域中';
$string['frontpageblocksettings'] = '广告版块';
$string['frontpagecoursesettings'] = '首页课程列表';
$string['frontpagedesc'] = '配置在首页上呈现课程框的方式。';
$string['frontpagemarketenabled'] = '启用营销版块';
$string['frontpagemarketenableddesc'] = '在首页中设置市场营销版。';
$string['frontpagemarketoption'] = '选择市场营销版块样式';
$string['frontpagemarketoptiondesc'] = '您可以对市场营销版块应用不同样式。
注意: BCU 样式的设计用于处理块顶部的图像。';
$string['frontpagerenderer'] = '首页课程框';
$string['frontpagerendererdefaultimage'] = '默认课程图像';
$string['frontpagerendererdefaultimagedesc'] = '在找不到课程图像时要使用的默认图像 (仅适用于带叠加层的磁贴 )';
$string['frontpagerendererdesc'] = '控制在首页上呈现课程框的方式。';
$string['frontpagerendereroption1'] = '标题';
$string['frontpagerendereroption2'] = '带叠加层的磁贴';
$string['frontpagerendereroption3'] = 'Moodle 默认值';
$string['frontpagerendereroption4'] = '磁贴';
$string['frontpagesettingsheading'] = '首页渲染';
$string['frontpageslidersettings'] = '首页幻灯';
$string['fullscreen'] = '全屏';
$string['fullscreenwidth'] = '全屏宽度。';
$string['fullscreenwidthdesc'] = '设置主题在全屏模式/缩放时的最大宽度。';
$string['googleanalyticssettings'] = '谷歌分析';
$string['googleanalyticssettingsdesc'] = '您可以为 Google 分析设置多个代码, 并将其定位到用户配置文件字段。';
$string['googleanalyticssettingsheading'] = '为网站设置谷歌分析';
$string['headerbgimage'] = '背景图片';
$string['headerbgimagedesc'] = '设置标题区背景图片。最小尺寸1600x180像素 (推荐1900x180像素)。图片覆盖整个标题区。您可在 \'顶部标题背景颜色\'增加颜色或使用 <i>透明度</i> 显示背景颜色。在此情况下，可修改文本颜色以确保文字在图片上正确显示。';
$string['headerbkcolor'] = '顶部标题背景颜色';
$string['headerbkcolor2'] = '底部标题的背景颜色';
$string['headerbkcolor2desc'] = '设置底的标题的背景颜色。';
$string['headerbkcolordesc'] = '设置顶部标题背景颜色。';
$string['headerdesc'] = '上传收藏夹图标，徽标，设置标题版块中的登录窗口，调整标题栏中的标题。<br />您可在<a href="./../admin/settings.php?section=theme_adaptable_font">字体</a>设置页面设置标题字号及字体风格。';
$string['headernavbarhelpheading'] = '帮助链接和选项';
$string['headernavbarhelpheadingdesc'] = '帮助菜单链接的选项。';
$string['headernavbarmycoursesheading'] = '我的课程菜单';
$string['headernavbarmycoursesheadingdesc'] = '"我的课程 (我的网站)" 菜单选项的所有选项, 显示当前用户的课程列表';
$string['headernavbarthiscourseheading'] = '本课程菜单';
$string['headernavbarthiscourseheadingdesc'] = '在这个菜单中, 学生可以直接访问所有的课程活动和参与者名单以及他的成绩。';
$string['headersettings'] = '页眉';
$string['headersettingsheading'] = '自定义此主题的页眉。 可在 <a href="./../theme/adaptable/pix/layout.png" target="_blank"> 此处</a>查看布局';
$string['headertextcolor'] = '顶部标题版块文本和链接颜色';
$string['headertextcolor2'] = '底部标题版块文本和链接颜色';
$string['headertextcolor2desc'] = '设置底部标题版块文本和链接颜色。';
$string['headertextcolordesc'] = '设置顶部标题版块文本和链接颜色。';
$string['help'] = '帮助';
$string['helpprofilefield'] = '帮助自定义配置文件字段 (可选)';
$string['helpprofilefielddesc'] = '添加使用自定义配置字段的访问规则，例如：usertype = student';
$string['helptarget'] = '帮助目标';
$string['helptargetdesc'] = '是否要在新窗口中打开帮助链接？';
$string['helptitle'] = '帮助';
$string['hiddencourses'] = '隐藏的课程';
$string['hide'] = '隐藏';
$string['hidefootersocial'] = '显示社交应用图标';
$string['hidefootersocialdesc'] = '在版块下方的页脚中显示社交应用图标。';
$string['hideinforum'] = '在论坛中隐藏帮助和工具';
$string['hideinforumdesc'] = '当使用固定宽度和所有菜单选项时, 论坛搜索框会折行到下面的行。打开此选项将隐藏工具,及帮助论坛中的菜单项, 使其能够正确显示。';
$string['home'] = '首页';
$string['homebk'] = '首页背景图片';
$string['homebkdesc'] = '上传图像, 它将成为首页的背景图片。';
$string['infobox'] = '首页信息框';
$string['infobox2'] = '首页辅助信息框';
$string['infobox2desc'] = '首页辅助信息框 (更多信息及提示参见 <a href="./../theme/adaptable/README.txt" target="_blank">自述文件</a> )。<br><br><strong>注意: </strong><i>此元素仅用于兼容BCU并将从未来版本中移除。</i>';
$string['infoboxdesc'] = '首页信息版块HTML (更多信息及提示参见 <a href="./../theme/adaptable/README.txt" target="_blank">自述文件</a> )。<br><br><strong>注意: </strong><i>此元素仅用于兼容BCU并将从未来版本中移除。</i>';
$string['infoboxfullscreen'] = '全屏显示信息框';
$string['infoboxfullscreendesc'] = '打开此选项将全屏显示信息框。';
$string['jssection'] = 'javascript 区域';
$string['jssectiondesc'] = '将 javascript 代码添加到网站。';
$string['jssectionrestricted'] = 'Javascript条件区域';
$string['jssectionrestricteddashboardonly'] = '仅在仪表盘页上包括 Javascript';
$string['jssectionrestricteddashboardonlydesc'] = '仅在仪表盘页面上显示 javascript。否则, 将在全站范围内显示。';
$string['jssectionrestricteddesc'] = '根据自定义配置文件字段有条件地将 javascript 代码添加到网站。只有满足此条件时, 才会显示此 javascript。';
$string['jssectionrestrictedprofilefield'] = 'javascript 区块自定义配置文件字段';
$string['jssectionrestrictedprofilefielddesc'] = '仅当用户匹配此自定义配置文件字段值时, 才显示上面的 javascript, 例如: 教师 = fbl。';
$string['jumpto'] = '跳转到...';
$string['layoutaddcontent'] = '对布局满意了？ 现在为版块添加内容：';
$string['layoutaddcontentdesc1'] = '您已配置';
$string['layoutaddcontentdesc2'] = '营销版块。如果您对此布局感到满意, 请将内容添加到下面的版块中。
如果您不满意, 请使用上面的布局生成器进行更改<br />';
$string['layoutcheck'] = '检查布局';
$string['layoutcheckdesc'] = '使用下面的工具检查已使用版块数, 并查看新布局的展示形式。';
$string['layoutcount1'] = '您可以设置最大为';
$string['layoutcount2'] = '版块区域。您当前正在使用:';
$string['layoutdesc'] = '设置用户看到的默认布局。';
$string['layoutsettings'] = '布局';
$string['layoutsettingsheading'] = '控制网站布局的各个方面';
$string['leftblocks'] = '左侧';
$string['linkcolor'] = '链接颜色';
$string['linkcolordesc'] = '设置主题中链接的颜色, 使用 html 十六进制代码。';
$string['linkhover'] = '链接悬停颜色';
$string['linkhoverdesc'] = '设置主题中链接(鼠标悬停时)的颜色, 使用 html 十六进制代码。';
$string['linksmenu'] = '链接菜单';
$string['loadingcolor'] = '加载过程中颜色';
$string['loadingcolordesc'] = '页面顶部的加载条颜色';
$string['loginplaceholder'] = '用户名';
$string['logintextbutton'] = '登录';
$string['logo'] = '徽标';
$string['logodesc'] = '上传网站上使用的徽标。推荐尺寸为 200px x 80px';
$string['maincolor'] = '主体颜色';
$string['maincolordesc'] = '版块和页脚的主体颜色。';
$string['maincoursepage'] = '课程主页面';
$string['market'] = '营销版块';
$string['marketblockbordercolor'] = '营销版块边框线颜色';
$string['marketblockbordercolordesc'] = '设置营销版块边框线颜色';
$string['marketblocksbackgroundcolor'] = '营销版块区域背景颜色';
$string['marketblocksbackgroundcolordesc'] = '设置营销版块区域背景颜色。';
$string['marketdesc'] = '为营销版块添加html (查阅<a href="./../theme/adaptable/README.txt" target="_blank">自述文件</a> 可获取更多信息及提示)。';
$string['marketingbuilderdesc'] = '使用下面的工具设置营销版块。一旦定义, 版块设置将显示在页面的更下方。';
$string['marketingbuilderheading'] = '营销版块布局生成器';
$string['marketingdesc'] = '有两种不同风格的全宽度信息框可供使用。此外，还可使用布局生成器决定使用多少版块并定义你自己的布局。请查阅随本主题提供的<a href="./../theme/adaptable/README.txt" target="_blank">自述文件</a> 。';
$string['marketingsettings'] = '营销版块';
$string['marketingsettingsheading'] = '自定义出现在首页上的市场营销块。在此<a href="./../theme/adaptable/pix/layout.png" target="_blank>查看布局</a>';
$string['marketlayoutrow'] = '营销版块行';
$string['marketlayoutrowdesc'] = '为首页上的营销版块布局添加/设置行。';
$string['menubkcolor'] = '主菜单背景颜色';
$string['menubkcolordesc'] = '设置主菜单背景颜色';
$string['menubordercolor'] = '主菜单底部边框颜色';
$string['menubordercolordesc'] = '设置主菜单边框底部颜色';
$string['menufontcolor'] = '主菜单字体颜色';
$string['menufontcolordesc'] = '设置主菜单字体颜色';
$string['menufontpadding'] = '导航项目内部边距';
$string['menufontpaddingdesc'] = '在主导航栏中设置项目的内部边距。';
$string['menufontsize'] = '导航栏的字号';
$string['menufontsizedesc'] = '设置主导航栏中使用的字体号。';
$string['menuoverrideprofilefield'] = '自定义配置文件字段名称';
$string['menuoverrideprofilefielddefault'] = '顶部菜单设置';
$string['menuoverrideprofilefielddesc'] = '用于用户重写的自定义配置文件 "列表" 字段的名称';
$string['menusdesc'] = '';
$string['menusession'] = '在会话中存储访问的详细信息';
$string['menusessiondesc'] = '为提高性能, 建议启用此功能。您可能需要在测试时禁用';
$string['menusessionttl'] = '在会话中存储访问规则的分钟数';
$string['menusessionttldesc'] = '在用户会话中刷新菜单访问规则后的分钟数。';
$string['menusettings'] = '页眉菜单';
$string['menusettingsheading'] = '自定义此主题标题的上标题中的菜单。';
$string['menusheading'] = '为上页眉中的链接菜单配置导航';
$string['menusheadingvisibility'] = '顶级菜单可见性的常规设置';
$string['menusheadingvisibilitydesc'] = '以下设置允许您控制菜单的显示位置, 并允许用户自定义其设置 (可选)';
$string['menuslinkright'] = '在顶部右侧显示菜单链接';
$string['menuslinkrightdesc'] = '如果选中, 则在消息菜单旁边右上角显示链接';
$string['menustitledesc'] = '工具菜单(导航栏)及顶部菜单(上页眉)根据自定义配置(可选)进行限制。如要添加限制，可输入配置文件字段名称及期望的值。菜单结构遵循Moodle格式:
<pre>
Moodle 社区|https://moodle.org
-Moodle 免费支持|https://moodle.org/support
-Moodle 开发|https://moodle.org/development
--Moodle 文档|http://docs.moodle.org|Moodle Docs
--Moodle 德文文档|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = '允许用户优先覆盖';
$string['menuuseroverridedesc'] = '这此设置通过自定义配置字段控制菜单出现的何处。要使用此选项，您需要创建一个“列表”类型的定义配置字段，字段的值应符合以下顺序:
<pre>1. 全站范围 (列表中的第一项菜单在全站可见）
2. 仅在首页 (列表中的第二项仅在首页可见)
3. 隐藏(列表中第三项的菜单将完全隐藏)</pre>
不可将"禁用课程页面菜单"与配置文件字段设置共同使用。而是应该在设置配置文件字段选项时，将默认值设置为"仅在主页"。

注意: 用户必须登出Moodle再重新登录才能看到生效结果。您最好在自定义配置文件字段中加入说明，解释此事。';
$string['messagepopupbackground'] = '弹出信息背景颜色';
$string['messagepopupbackgrounddesc'] = '设置消息弹出标题的背景颜色。';
$string['messagepopupcolor'] = '弹出信息文字颜色';
$string['messagepopupcolordesc'] = '设置弹出消息标题的文字颜色。';
$string['messagingbackgroundcolor'] = '消息主窗口背景颜色';
$string['messagingbackgroundcolordesc'] = '设置主聊天消息窗口的背景颜色。';
$string['mobilemenubkcolor'] = '移动端菜单背景颜色';
$string['mobilemenubkcolordesc'] = '设置移动设备上主菜单背景颜色 (折起状态)';
$string['moodledocs'] = 'Moodle文档链接';
$string['moodledocsdesc'] = '在页脚中显示 Moodle 文档链接。';
$string['myblogs'] = '我的博客';
$string['mycoursesmenulimit'] = '我的课程菜单限制';
$string['mycoursesmenulimitdesc'] = '调整 "我的课程" 下拉列表中显示的课程的最大数量。0将显示所有课程。';
$string['mysites'] = '我的课程';
$string['mysitesdisabled'] = '禁用';
$string['mysitesexclude'] = '启用排除隐藏的课程';
$string['mysitesinclude'] = '启用包含隐藏的课程';
$string['mysitesmaxlength'] = '我的课程最大长度';
$string['mysitesmaxlengthdesc'] = '调整"我的课程" 下拉列表中课程名称最大长度, 以便针对您的字体进行优化。';
$string['mysitesmenudisplay'] = '我的课程菜单显示';
$string['mysitesmenudisplaydesc'] = '选择菜单项和悬停时显示的文本。';
$string['mysitesmenudisplayfullnamefullnameonhover'] = '在悬停时显示完整的课程标题和完整的标题。';
$string['mysitesmenudisplayfullnamenohover'] = '鼠标悬停时显示完整的课程标题, 并不显示文本。';
$string['mysitesmenudisplayshortcodefullnameonhover'] = '在悬停时显示简短的代码和完整的课程名称。';
$string['mysitesmenudisplayshortcodenohover'] = '悬停时显示简短的代码, 且不显示文本。';
$string['mysitessortoverride'] = '启用我的课程自定义排序';
$string['mysitessortoverridedesc'] = '使用自定义配置文件字段或通用字符串（年份等)收起子菜单中的过去课程';
$string['mysitessortoverridefield'] = '我的课程自定义配置文件字段或字符串';
$string['mysitessortoverridefielddesc'] = '要检查的课程中短代码配置文件字段或字符串的逗号分隔列表';
$string['mysitessortoverrideoff'] = '在单个扁平列表中显示所有选课的课程';
$string['mysitessortoverrideprofilefields'] = '在配置字段中找到的课程显示在第一个列表中, 其他课程显示在子菜单中';
$string['mysitessortoverrideprofilefieldscohort'] = '在第一个列表中显示在简介中发现的课程字段 + 群，其它的放在子菜单中';
$string['mysitessortoverridestrings'] = '将包含字符串的选课显示在第一个列表中, 其它显示在子菜单中';
$string['navbarcachetime'] = '导航栏缓存时间';
$string['navbarcachetimedesc'] = '导航栏缓存的分钟数。';
$string['navbardesc'] = '允许您控制导航栏上显示的所有元素。';
$string['navbardisplayicons'] = '显示图标';
$string['navbardisplayiconsdesc'] = '在主菜单标题旁边显示图标';
$string['navbardropdownborderradius'] = '下拉菜单边框半径';
$string['navbardropdownborderradiusdesc'] = '控制下拉菜单的边框半径 (例如圆角)。';
$string['navbardropdownhovercolor'] = '下拉菜单悬停颜色';
$string['navbardropdownhovercolordesc'] = '鼠标悬停在菜单项上时, 下拉菜单颜色。';
$string['navbardropdowntextcolor'] = '下拉菜单文本颜色';
$string['navbardropdowntextcolordesc'] = '下拉菜单项文本颜色。';
$string['navbardropdowntexthovercolordesc'] = '悬停在菜单项上时，下拉菜单文本的颜色。';
$string['navbardropdowntransitiontime'] = '导航栏动画过渡时间';
$string['navbardropdowntransitiontimedesc'] = '导航栏过渡效果时间 (以秒为单位)。将鼠标悬停在具有子菜单的菜单上时, 提供淡出的动画效果。';
$string['navbarsettings'] = '标题导航栏';
$string['navbarsettingsheading'] = '自定义导航栏';
$string['newmenu'] = '顶部菜单下拉菜单';
$string['newmenudesc'] = '配置要在顶部标题菜单下显示的链接。';
$string['newmenufield'] = '自定义配置字段名称=值（可选）';
$string['newmenufielddesc'] = '添加使用自定义配置字段的访问规则，例如：usertype = student';
$string['newmenuheading'] = '顶部菜单';
$string['newmenurequirelogin'] = '需要登录';
$string['newmenurequirelogindesc'] = '如果启用, 此菜单将仅对已登录用户可见';
$string['newmenutitle'] = '顶部菜单标题';
$string['newmenutitledefault'] = '菜单';
$string['nextactivity'] = '下一个活动';
$string['passwordplaceholder'] = '密码';
$string['previousactivity'] = '上一个活动';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['regionmaincolor'] = '主区域颜色';
$string['regionmaincolordesc'] = '设置主要内容区域的背景颜色。';
$string['rendereroverlaycolor'] = '覆盖颜色';
$string['rendereroverlaycolordesc'] = '当选择 "磁贴 w/覆盖" 渲染器时, 覆盖层的颜色。';
$string['rendereroverlayfontcolor'] = '覆盖字体颜色';
$string['rendereroverlayfontcolordesc'] = '当鼠标悬停在启用了 "磁贴及覆盖" 渲染器部件上时，字体的颜色。';
$string['sectionheadingcolor'] = '章节标题文本颜色';
$string['sectionheadingcolordesc'] = '设置章节标题文本的颜色';
$string['selectionbackground'] = '已选内容背景颜色';
$string['selectionbackgrounddesc'] = '设置屏幕中文本被选中时的背景色。';
$string['selectiontext'] = '选中项文字颜色';
$string['selectiontextdesc'] = '设置屏幕中文本被选中时的文字颜色。';
$string['settingsanalytics'] = '分析';
$string['settingsblocksconfiguration'] = '配置';
$string['settingsbreadcrumbcolors'] = '线索颜色';
$string['settingscolors'] = '颜色';
$string['settingsfonts'] = '字体';
$string['settingsfootercolors'] = '页脚颜色';
$string['settingsforumheading'] = '论坛';
$string['settingsheadercolors'] = '页眉颜色';
$string['settingsinfoboxcolors'] = '信息窗颜色';
$string['settingsmaincolors'] = '主体颜色';
$string['settingsmarketingcolors'] = '营销版块颜色';
$string['settingsmessagescolors'] = '弹出消息颜色';
$string['settingsnavbarcolors'] = '导航栏 (导航) 颜色';
$string['settingsoverlaycolors'] = '磁贴叠加颜色';
$string['settingssecondinfoboxcolors'] = '第二信息窗口颜色';
$string['show'] = '显示';
$string['sitetitle'] = '显示网站标题';
$string['sitetitletext'] = '网站标题';
$string['slider2h3bgcolor'] = '滚动条 2 H3 背景颜色';
$string['slider2h3bgcolordesc'] = '为滚动 2 H3 标签选择背景色';
$string['slider2h3color'] = '滚动条 2 H3 文字颜色';
$string['slider2h3colordesc'] = '为滚动条 2 H3 标签选择文字颜色';
$string['slider2h4bgcolor'] = '滚动条 2 H4 背景颜色';
$string['slider2h4bgcolordesc'] = '为滚动条 2 H4 标签选择背景色';
$string['slider2h4color'] = '滚动条 2 H4 文字颜色';
$string['slider2h4colordesc'] = '为滚动条 2 H4 标签选择背景色';
$string['sliderh3color'] = '滚动条1 H3 颜色';
$string['sliderh3colordesc'] = '为滚动条1 H3 标签选择颜色';
$string['sliderh4color'] = '滚动条 1 H4 颜色';
$string['sliderh4colordesc'] = '为滚动条1 H4 标签选择颜色';
$string['slideroption2a'] = '滚动条样式选项2箭头背景颜色';
$string['slideroption2adesc'] = '设置滚动条样式选项2箭头背景颜色';
$string['slideroption2colordesc'] = '在滑块样式选项中设置提交文本颜色';
$string['slideroption2desc'] = '选择滚动条类型 <strong>然后点击保存</strong> 可看到为滚动条进行的设置结果。';
$string['slideroption2submitcolordesc'] = '在滑块样式选项2中设置提交文本颜色';
$string['slidersubmitbgcolordesc'] = '选择 "滑块 1" 提交按钮的背景色';
$string['slidersubmitcolordesc'] = '选择 "滑块 1" 提交按钮的文字颜色';
$string['socialicondesc'] = '设置 Font Awesome 图标, 例如: fa-facebook';
$string['socialsize'] = '设置社交图标的字号';
$string['socialtitledesc'] = '您可禁用此处的全站范围的搜索控件并启用社交图标/链接。
设置社交图标方法，在下方“社交图标清单”中输入用 "|" 符号分隔的清单
清单格式应为:

url|标题|图标

示例:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
此处 <a href="https://fortawesome.github.io/Font-Awesome/icons/">可获取所有Font Awesome 图标</a>作为参考';
$string['standardview'] = '标准视图';
$string['thiscourse'] = '本课程';
$string['ticker'] = '公告';
$string['tickerdefault'] = '没有要显示的新闻项目';
$string['tickerwidth'] = '固定宽度';
$string['tilesbordercolor'] = '课程磁贴边框颜色';
$string['tilesbordercolordesc'] = '为课间磁巾设置边框颜色';
$string['toolsmenuheading'] = '工具菜单';
$string['toolsmenutitledefault'] = '工具';
$string['topmenufontsize'] = '顶级菜单字号';
$string['topmenufontsizedesc'] = '调整顶级菜单的字号';
