<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_mailtest', language 'sr_lt', version '4.4'.
 *
 * @package     local_mailtest
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additionalinfo'] = 'Dodatne informacije:';
$string['alwaysshowlog'] = 'Uvek prikaži zapis o komunikaciji sa serverom za e-poštu, čak i ako nema grešaka.';
$string['bimidmarcfailure'] = 'BIMI provera identiteta nije uspela zbog jedne ili više DMARC zavisnih grešaka.';
$string['bimiinvalidlogo'] = 'Nedostaje BIMI logo: {$a}.';
$string['biminorecordfound'] = 'BIMI zapis nedostaje.';
$string['bimipctinvalid'] = 'DMARC PCT vrednost mora biti podešena na 100 za BIMI.';
$string['bimirecordfound'] = 'Pronađen je BIMI zapis.';
$string['bimitagsfound'] = 'BIMI oznake su ispravne.';
$string['checkingdomain'] = 'DNS bezbednosna provera za {$a}:';
$string['commoncommissues'] = '<li>Vaš Moodle sajt može biti blokiran zaštitnim zidom, koji sprečava komunikaciju sa vašim serverom za e-poštu.</li>
<li>Možda ćete morati da dodate IP adresu svog veb sajta na spisak dozvoljenih IP adresa u konfiguraciji servera za e-poštu.</li>
<li>Proverite da li je vaš SMTP server pokrenut i da li radi.</li>';
$string['commondeliveryissues'] = '<p>Ako e-poruka nije isporučena u roku od 15-30 minuta, proverite sledeće:</p>
<ul>
<li>Proverite da li je e-adresa uneta u polje TO tačna.</li>
<li>Proverite sa primaocima da poslata poruka, možda, nije završila među neželjenom poštom (u tzv. spam/junk folderu).</li>
<li>Proverite sa primacioma da im, možda, poštansko sanduče nije prepunjeno.</li>
<li>Proverite poštansko sanduče vaše \'no-reply\' e-adrese, kako biste videli da nije slučajno poruka koju ste poslali odbijena (ostala neisporučena), iz bilo kog razloga.</a></li>
<li>Proverite da nijedan filter na vašem ili serveru za e-poštu primaoca, nije, slučajno, označio sadržaj vaše e-poruke kao nepoželjan (spam/junk).</a></li>
<li>Proverite da provajderi e-pošte nisu, slučajno, stavili IP adresu vašeg servera za e-poštu na tzv. crnu listu.</a></li>
{$a}
</ul>';
$string['connectionlog'] = 'Zapis komunikacije sa serverom za e-poštu';
$string['credit'] = 'Michael Milette - <a href="http://www.tngconsulting.ca/">TNG Consulting Inc.</a>';
$string['divertallemails'] = 'Preusmeri sve e-poruke';
$string['divertedto'] = 'Preusmereno na {$a}';
$string['dkiminvalidrecord'] = 'DKIM zapis mora da sadrži ispravne oznake v, k i p.';
$string['dkimmissingselector'] = 'Podešavanje DKIM selektora nije konfigurisano.';
$string['dkimnorecordfound'] = 'DKIM zapis nedostaje.';
$string['dkimrecordfound'] = 'Pronađen je DKIM zapis.';
$string['dkimselectorconfigured'] = 'Podešavanje DKIM selektora je konfigurisano.';
$string['dkimspffailed'] = 'DMARC zahteva da se konfigurišu SPF ili DKIM zapisi.';
$string['dkimvalidrecord'] = 'Format DKIM zapisa je ispravan.';
$string['dmarcnorecordfound'] = 'DMARC zapis nedostaje.';
$string['dmarcpctinvalid'] = 'DMARC pct vrednost nije u opsegu.';
$string['dmarcrecordfound'] = 'Pronađen je DMARC zapis.';
$string['dmarcruainvalid'] = 'DMARC rua vrednost vrednost nije pravilno formatirana.';
$string['dmarcrufinvalid'] = 'DMARC ruf vrednost vrednost nije pravilno formatirana.';
$string['dmarctagsfound'] = 'Pronađene su DMARC potrebne oznake.';
$string['emailfail'] = 'Slanje poruke e-pošte nije uspelo';
$string['errorcommunications'] = 'Moodle nije mogao da se poveže sa vašim serverom za e-poštu.</p><p><strong>Preporuka:</strong></p><p>Počnite tako što ćete proveriti <a href="{$a}" target="_blank">podešavanja SMTP servera za e-poštu</a>unutar vašeg Moodlea.</p><p>Ako ta podešavanja izgledaju ispravno, proverite podešavanja vašeg SMTP servera i/ili podešavanja zaštitnog zida (firewall servera) kako biste bili sigurni da su konfigurisani tako da prihvataju SMTP konekcije sa vašeg Moodle veb servera i vaše \'no-reply\' e-adrese. Za dodatnu pomoć, pogledajte u dokumentaciji odeljak \'Često postavljena pitanja\' (FAQ)';
$string['errorsend'] = 'Probna poruka e-pošte nije mogla biti isporučena serveru za e-poštu.</p><p><strong>Preporuka:</strong></p><p>Проверите <a href="{$a}" target="blank">Podešavanja e-pošte</a> unutar vašeg Moodlea. Za dodatnu pomoć, pogledajte u dokumentaciji odeljak \'Često postavljena pitanja\' (FAQ).';
$string['errorunknown'] = '<p>Došlo je do greške koja ne može da se dijagnostikuje.</p><p><strong>Препорука:</strong></p><p>Pogledajte u nastavku zapis o komunikaciji. Možda će vam biti korisno da pogledate spisak SMTP kôdova na stranicama <a href="https://www.rfc-editor.org/rfc/rfc5321.html#section-4.2.3" target="_blank">RFC 5321</a> i <a href="https://datatracker.ietf.org/doc/html/rfc4954#section-6" target="_blank">RFC 4954</a>.</p>';
$string['failaccessdenied'] = '<li>Povezivanje sa serverom za e-poštu nije uspelo, pa je konekcija zatvorena.</li>';
$string['failclosedport'] = 'Port servera {$a} je zatvoren. Da li ste naveli tačan :port number?';
$string['failcredentials'] = '<li>Akreditivi za proveru identiteta su možda neispravni ili nedostaju. Proverite da li ste uneli tačne podatke za prijavu</li>';
$string['faildnslookup'] = 'DNS pretraga nije uspela. Proverite da li  \'<strong>{$a}</strong>\' uspeva da odredi adresu servera za e-poštu.';
$string['failmissingport'] = 'Možda ćete morati da navedete :port number za veze tipa "{$a}".';
$string['failmissingprotocol'] = 'Možda ćete morati da navedete tip bezbednog protokola (SSL/TLS) sa portom \'{$a}\'.';
$string['failoutboundsmtpblocked'] = 'Nešto blokira povezivanje odlaznih SMTP konekcija. Da li postoji zaštitni zid (firewall) koji blokira vašu vezu sa serverom za e-poštu?';
$string['failphpmailer'] = 'Možda postoje problemi sa instalacijom Moodle LMS-a. Jedan od mogućih razloga su neispravna ovlašćenja vlasnika/grupe nad datotekama aplikacije.';
$string['failphpmailerconfig'] = 'Servis e-pošte na vašem Moodle veb serveru možda ne radi ili je pogrešno konfigurisan.';
$string['failprotocolmismatch'] = 'Možda postoji neusklađenost između protokola \'{$a->protocol}\' i porta \'{$a->port}\'\'.';
$string['failunknownmailbox'] = '<li>Poštansko sanduče FROM nije pronađeno, nije dostupno ili je odbijeno zbog definisanih pravila na sajtu. Proverite da li su obe e-adrese - TO i FROM ispravne i da li postoje, kao i da je \'no-reply\' adresa stvarno poštansko sanduče koje postoji na vašem serveru za e-poštu.</li>';
$string['from'] = '{$a->type}: <strong>{$a->email}</strong> (<a href="{$a->url}">{$a->label}</a>)';
$string['fromemail'] = 'Sa e-adresa';
$string['heading'] = 'Test konfiguracije e-pošte';
$string['iconlabel'] = 'Bezbednosna provera za {$a}';
$string['message'] = '<p>Ovo je probna poruka. Zanemarite je.</p>
<p>Ako ste primili ovu poruku e-pošte, to znači da ste uspešno konfigurisali podešavanja e-pošte na svom Moodle sajtu.</p>
<hr><p><strong>Dodatne informacije o korisniku</strong></p>
<ul>
<li><strong>Status registracije :</strong> {$a->regstatus}</li>
<li><strong>Preferirani jezik :</strong> {$a->lang}</li>
<li><strong>Veb čitač korisnika :</strong> {$a->browser}</li>
<li><strong>Poruka poslao/la :</strong> {$a->referer}</li>
<li><strong>Moodle verzija :</strong> {$a->release}</li>
<li><strong>IP adresa korisnika :</strong> {$a->ip}</li>
</ul>';
$string['noemailever'] = '<p>E -pošta na ovom sajtu je onemogućena zbog podešavanja u konfiguracionoj datoteci - <strong>$CFG-&gt;noemailever = true;</strong>.</p>';
$string['nologavailable'] = '<p>Zapisivanje nije dostupno kada se koristi PHP mail() funkcija. Međutim, moguće je pronaći zapise na vašem serveru. Najčešća mesta na Linux operativnom sistemu uključuju:</p>
<ul>
<li>/var/log/maillog</li>
<li>/var/log/mail.log</li>
<li>/var/adm/maillog</li>
<li>/var/adm/syslog/mail.log</li>
</ul>
<p>Alternativno, mesto gde će se zapisi čuvati može biti navedeno korišćenjem mail.log podešavanja u datoteci php.ini.</p>';
$string['notregistered'] = 'Niste registrovani ili niste prijavljeni.';
$string['phpmethod'] = 'PHP podrazumevani metod';
$string['pluginname'] = 'Test ePošte';
$string['pluginname_help'] = 'Test ePošte će proveriti podešavanja e-pošte za ovaj Moodle sajt slanjem probne poruke e-pošte na adresu koju navedete. Samo za administratore sajta.';
$string['primaryadminemail'] = 'Primarna adresa e-pošte administratora';
$string['privacy:metadata'] = 'Dodatak \'Test ePošte\' ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['recipientisrequired'] = 'Morate navesti adresu e-pošte primaoca.';
$string['registered'] = 'Registrovani korisnik ({$a}).';
$string['sendmethod'] = 'Način slanja e-pošte';
$string['sendtest'] = 'Pošaljite probnu poruku';
$string['sentmail'] = 'Moodle je uspešno isporučio probnu poruku SMTP serveru za e-poštu.';
$string['sentmailphp'] = 'PHP Mail je uspešno prihvatio Moodle probnu poruku.';
$string['server'] = 'Server: {$a}';
$string['smtpmethod'] = 'SMTP serveri: {$a}';
$string['spfinvalidrecord'] = 'SPF zapis mora da sadrži najmanje jedan mehanizam.';
$string['spfnorecordfound'] = 'SPF zapis nedostaje.';
$string['spfrecordfound'] = 'Pronađen je SPF zapis.';
$string['spfvalidrecord'] = 'Format SPF zapisa je ispravan.';
$string['testing'] = 'Testiranje konfiguracije e-pošte';
$string['toemail'] = 'Na adresu e-pošte';
$string['winsyslog'] = 'Dnevnik događaja na Windowsu';
$string['youremail'] = 'Vaša e-adresa';
